#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Jul  3 16:04:16 2023 by generateDS.py version 2.41.5.
# Python 3.8.16 (default, Dec 20 2022, 23:15:53) [MSC v.1900 64 bit (AMD64)]
#
# Command line options:
#   ('-f', '')
#   ('-o', 'E:\\Download\\RossRestr\\Forest\\TaxationDescriptionCuttingArea\\TaxationDescriptionCuttingArea_v1.9\\Python\\taxationdescriptioncuttingarea.py')
#   ('--super', 'forestDeclaration')
#
# Command line arguments:
#   E:\Download\RossRestr\Forest\TaxationDescriptionCuttingArea\TaxationDescriptionCuttingArea_v1.9\pilTaxationDescriptionCuttingArea.xsd
#
# Command line:
#   Scripts/generateDS.py -f -o "E:\Download\RossRestr\Forest\TaxationDescriptionCuttingArea\TaxationDescriptionCuttingArea_v1.9\Python\taxationdescriptioncuttingarea.py" --super="forestDeclaration" E:\Download\RossRestr\Forest\TaxationDescriptionCuttingArea\TaxationDescriptionCuttingArea_v1.9\pilTaxationDescriptionCuttingArea.xsd
#
# Current working directory (os.getcwd()):
#   python
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class BonitetKindEType(str, Enum):
    """BonitetKindEType -- К
    л
    а
    с
    с
    б
    о
    н
    и
    т
    е
    т
    а
    
    """
    FIVE_A='fiveA' # 5а
    FOUR='four' # 4
    ONE='one' # 1
    ONE_B='oneB' # 1б
    FIVE='five' # 5
    TWO='two' # 2
    THREE='three' # 3
    FIVE_B='fiveB' # 5б
    ONE_A='oneA' # 1а


class CompletenesSlayerKindEType(str, Enum):
    """CompletenesSlayerKindEType -- П
    о
    л
    н
    о
    т
    а
    л
    е
    с
    н
    о
    г
    о
    н
    а
    с
    а
    ж
    д
    е
    н
    и
    я
    (
    в
    д
    о
    л
    я
    х
    е
    д
    и
    н
    и
    ц
    ы
    )
    
    """
    _1_1='11' # 1.1
    _1_2='12' # 1.2
    _0_1='01' # 0.1
    _1_3='13' # 1.3
    _0_2='02' # 0.2
    _1_4='14' # 1.4
    _0_3='03' # 0.3
    _1_5='15' # 1.5
    _0_4='04' # 0.4
    _0_5='05' # 0.5
    _0_6='06' # 0.6
    _0_7='07' # 0.7
    _0_8='08' # 0.8
    _0_9='09' # 0.9
    _1_0='10' # 1.0


class ConstituentEntityKindEType(str, Enum):
    """ConstituentEntityKindEType -- С
    у
    б
    ъ
    е
    к
    т
    ы
    Р
    о
    с
    с
    и
    й
    с
    к
    о
    й
    Ф
    е
    д
    е
    р
    а
    ц
    и
    и
    
    """
    _0_1='01' # Республика Адыгея (Адыгея)
    _0_2='02' # Республика Башкортостан
    _0_3='03' # Республика Бурятия
    _0_4='04' # Республика Алтай
    _0_5='05' # Республика Дагестан
    _0_6='06' # Республика Ингушетия
    _0_7='07' # Кабардино-Балкарская Республика
    _0_8='08' # Республика Калмыкия
    _0_9='09' # Карачаево-Черкесская Республика
    _1_0='10' # Республика Карелия
    _1_1='11' # Республика Коми
    _1_2='12' # Республика Марий Эл
    _1_3='13' # Республика Мордовия
    _1_4='14' # Республика Саха (Якутия)
    _1_5='15' # Республика Северная Осетия - Алания
    _1_6='16' # Республика Татарстан (Татарстан)
    _1_7='17' # Республика Тыва
    _1_8='18' # Удмуртская Республика
    _1_9='19' # Республика Хакасия
    _2_0='20' # Чеченская Республика
    _2_1='21' # Чувашская Республика - Чувашия
    _2_2='22' # Алтайский край
    _2_3='23' # Краснодарский край
    _2_4='24' # Красноярский край
    _2_5='25' # Приморский край
    _2_6='26' # Ставропольский край
    _2_7='27' # Хабаровский край
    _2_8='28' # Амурская область
    _2_9='29' # Архангельская область
    _3_0='30' # Астраханская область
    _3_1='31' # Белгородская область
    _3_2='32' # Брянская область
    _3_3='33' # Владимирская область
    _3_4='34' # Волгоградская область
    _3_5='35' # Вологодская область
    _3_6='36' # Воронежская область
    _3_7='37' # Ивановская область
    _3_8='38' # Иркутская область
    _3_9='39' # Калининградская область
    _4_0='40' # Калужская область
    _4_1='41' # Камчатский край
    _4_2='42' # Кемеровская область
    _4_3='43' # Кировская область
    _4_4='44' # Костромская область
    _4_5='45' # Курганская область
    _4_6='46' # Курская область
    _4_7='47' # Ленинградская область
    _4_8='48' # Липецкая область
    _4_9='49' # Магаданская область
    _5_0='50' # Московская область
    _5_1='51' # Мурманская область
    _5_2='52' # Нижегородская область
    _5_3='53' # Новгородская область
    _5_4='54' # Новосибирская область
    _5_5='55' # Омская область
    _5_6='56' # Оренбургская область
    _5_7='57' # Орловская область
    _5_8='58' # Пензенская область
    _5_9='59' # Пермский край
    _6_0='60' # Псковская область
    _6_1='61' # Ростовская область
    _6_2='62' # Рязанская область
    _6_3='63' # Самарская область
    _6_4='64' # Саратовская область
    _6_5='65' # Сахалинская область
    _6_6='66' # Свердловская область
    _6_7='67' # Смоленская область
    _6_8='68' # Тамбовская область
    _6_9='69' # Тверская область
    _7_0='70' # Томская область
    _7_1='71' # Тульская область
    _7_2='72' # Тюменская область
    _7_3='73' # Ульяновская область
    _7_4='74' # Челябинская область
    _7_5='75' # Забайкальский край
    _7_6='76' # Ярославская область
    _7_7='77' # г. Москва
    _7_8='78' # г. Санкт-Петербург
    _7_9='79' # Еврейская автономная область
    _8_3='83' # Ненецкий автономный округ
    _8_6='86' # Ханты-Мансийский автономный округ - Югра
    _8_7='87' # Чукотский автономный округ
    _8_9='89' # Ямало-Ненецкий автономный округ
    _9_0='90' # Запорожская область
    _9_1='91' # Республика Крым
    _9_2='92' # г. Севастополь
    _9_3='93' # Донецкая Народная Республика
    _9_4='94' # Луганская Народная Республика
    _9_5='95' # Херсонская область
    _9_9='99' # г. Байконур


class CoordinateSystemKindEType(str, Enum):
    """CoordinateSystemKindEType -- С
    и
    с
    т
    е
    м
    ы
    к
    о
    о
    р
    д
    и
    н
    а
    т
    в
    е
    д
    е
    н
    и
    я
    п
    р
    о
    с
    т
    р
    а
    н
    с
    т
    в
    е
    н
    н
    ы
    х
    д
    а
    н
    н
    ы
    х
    Г
    Л
    Р
    
    """
    SK_FROLIKHA='skFrolikha' # СК Фролиха
    _7_208_ZAVODOUKOVSKY_DISTRICT='7208ZavodoukovskyDistrict' # 7208 - Заводоуковский район
    SK_VERKHNEBEREZOVO='skVerkhneberezovo' # СК Верхнеберезово
    SK_SO_NARTAN='skSoNartan' # СК с.п. со Нартан
    USC_RED_TANKS_0050002='uscRedTanks0050002' # УСК Красные баки (0050002)
    MSK_881427_CHIMNAI='msk881427Chimnai' # МСК 88 14:27 Чимнай
    SK_DOMOZHIROVO='skDomozhirovo' # СК Доможирово
    SK_LOCAL_ARTY='skLocalArty' # СК местная р.п.Арти
    MSK_OF_ARKHANGELSK='mskOfArkhangelsk' # МСК г.Архангельска
    MSK_67_ZONE_2='msk67Zone2' # МСК_67, зона 2
    _7_218_P_GORNOSLINKINO='7218PGornoslinkino' # 7218 с.Горнослинкино
    US_SOT_SATULI='usSotSatuli' # УС СОТ "Сатули"
    SK_LEBYAZHYE_LEBYAZHEVSKY_DISTRIC='skLebyazhyeLebyazhevskyDistric' # СК Лебяжье (Лебяжьевский район)
    SK_LECHINKAI='skLechinkai' # СК с.п. Лечинкай
    MSK_67_ZONE_1='msk67Zone1' # МСК_67, зона 1
    SK_OF_NUMGI_VILLAGE_NADYM_DISTRICT='skOfNumgiVillageNadymDistrict' # СК с.Нумги (Надымский район)
    LOCAL_SQ_M_KLETSKAYA_STREET='localSqMKletskayaStreet' # местная СК ст.Клетская
    SK_LOCAL_IVDEL='skLocalIvdel' # СК местная г.Ивдель
    USK_24_LOCAL_ZAKAZD_0309='usk24LocalZakazd0309' # УСК-24, местная (заказ0309)
    MSK_10_ZONE_2='msk10Zone2' # МСК-10, зона 2
    MSK_10_ZONE_1='msk10Zone1' # МСК-10, зона 1
    USK_24_LOCAL_ZAKAZD_0304='usk24LocalZakazd0304' # УСК-24, местная (заказ0304)
    SK_63_OF_THE_CADASTRAL_DISTRICT='sk63OfTheCadastralDistrict' # СК 63
    GRAVEL_STORAGE_FACILITY='gravelStorageFacility' # СК Гравийный
    OLD_VICHUGA='oldVichuga' # Старая Вичуга
    MSK_23_ZONE_12='msk23Zone12' # МСК 23, зона 1 2
    VICHUGA='vichuga' # Вичуга
    SK_BAKSAN='skBaksan' # СК г.п. Баксан
    MSK_KR_3314_KURLOVO='mskKr3314 Kurlovo' # МСК КР 33:14 п. Курлово
    SK_KORYAKI='skKoryaki' # СК Коряки
    SK_LOCAL_SEVEROURALSK='skLocalSeverouralsk' # СК местная г.Североуральск
    _1_8_MSK_ABEZ='18MskAbez' # 18 МСК Абезь
    SK_SWEET_CARP='skSweetCarp' # СК Сладкие Караси
    MSKR_604='mskr604' # МСКР-604
    MSKR_605='mskr605' # МСКР-605
    _0_1_MSK_PRILUZYE='01MskPriluzye' # 01 МСК Прилузье
    SVITLOGO_MSK='svitlogoMsk' # МСК Светлого
    SK_BELOZERSKY_DISTRICT='skBelozerskyDistrict' # СК Белозерского района
    MSK_PAVLOVO_TUMBOTINO='mskPavlovoTumbotino' # МСК Павлово (Тумботино)
    _7_212_TYUNEVO='7212Tyunevo' # 7212 с.Тюнево
    _1_963_TOSNENSKY='1963Tosnensky' # 1963 (Тосненский)
    MSK_881402_OROCHEN_2='msk881402Orochen2' # МСК 88 14:02 Орочен2
    _7_219_P_EMURTLA='7219PEmurtla' # 7219 с.Емуртла
    SK_KIROVO_MISHKINSKY='skKirovoMishkinsky' # СК Кирово (Мишкинский)
    SC_OF_TOTMA='scOfTotma' # СК г. Тотьма
    MSK_881402_OROCHEN_1='msk881402Orochen1' # МСК 88 14:02 Орочен1
    MSK_KR_3316_MELENKI='mskKr3316Melenki' # МСК КР 33:16 г. Меленки
    SK_NOVO_POLTAVSKOE='skNovoPoltavskoe' # СК с.п. Ново-Полтавское
    MSK_881433_DIARLA='msk881433Diarla' # МСК 88 14:33 Дярла
    _7_210_D_OKTOBREVKA='7210DOktobrevka' # 7210 д.Октябревка
    USC_RED_TANKS_0050008='uscRedTanks0050008' # УСК Красные баки (0050008)
    _7_205_S_VAGAY='7205SVagay' # 7205 с.Вагай
    USC_RED_TANKS_0050009='uscRedTanks0050009' # УСК Красные баки (0050009)
    SK_NEW_BALKARIA='skNewBalkaria' # СК с.п.Новая Балкария
    MSK_881427_WALBA='msk881427Walba' # МСК 88 14:27 Уолба
    MSK_881432_TECHTURE='msk881432Techture' # МСК 88 14:32 Техтюр
    MSK_OF_THE_VILLAGE_LOUHI='mskOfTheVillageLouhi' # МСК пгт.Лоухи
    US_0072801='us0072801' # УС 0072801
    US_0072802='us0072802' # УС 0072802
    MSK_881419_CHULMAN='msk881419Chulman' # МСК 88 14:19 Чульман
    SK_UTYATSKOE='skUtyatskoe' # СК Утятское
    MSK_881409_ALYSARDAKH='msk881409Alysardakh' # МСК 88 14:09 Алысардах
    MSK_881409_BATAGAY_3='msk881409Batagay3' # МСК 88 14:09 Батагай3
    MSK_881409_BATAGAY_2='msk881409Batagay2' # МСК 88 14:09 Батагай2
    US_KUDAMA='usKudama' # УС п.Кудама
    MSK_OF_THE_VILLAGE_OF_SMIRNYKH='mskOfTheVillageOfSmirnykh' # МСК пгт Смирных
    SK_MALY_ZAPOLOY='skMalyZapoloy' # СК Малый Заполой
    MSK_881419_YENGRA='msk881419Yengra' # МСК 88 14:19 Иенгра
    US_SOT_BUREVESTNIK='usSotBurevestnik' # УС СОТ "Буревестник"
    US_SOT_SADOVOD_SEVERA='usSotSadovodSevera' # УС СОТ "Садовод Севера"
    SK_LASHKUTA='skLashkuta' # СК с.п.Лашкута
    MSK_ARSENYEV='mskArsenyev' # МСК г.Арсеньев
    MSK_POGRANICHNY_DISTRICT='mskPogranichnyDistrict' # МСК Пограничный район
    MSK_ARDATOV_MUKHTOLOVO='mskArdatovMukhtolovo' # МСК Ардатов (Мухтолово)
    SK_KATAYSK='skKataysk' # СК Катайск
    SK_OKTYABRSKY_M_ATLYM='skOktyabrskyMAtlym' # СК Октябрьский М-Атлым
    MSK_881409_BATAGAY_1='msk881409Batagay1' # МСК 88 14:09 Батагай1
    MSK_POROSOZERO='mskPorosozero' # МСК п.Поросозеро
    US_SOT_KALEVALA='usSotKalevala' # УС СОТ "Калевала"
    BARNAUL_RURAL_LANDS='barnaulRuralLands' # г. Барнаул (сельские земли)
    SK_BUZAN='skBuzan' # СК Бузан
    MSK_S_ZAOZERYE='mskSZaozerye' # МСК с.Заозерье
    SK_YAGELNOYE_NADYMSKY_DISTRICT='skYagelnoyeNadymskyDistrict' # СК с.Ягельное (Надымский район)
    MSK_OF_THE_VILLAGE_MUEZERSKY='mskOfTheVillageMuezersky' # МСК пгт.Муезерский
    NIZHNYAYA_ALABUGA_SKI_RESORT='nizhnyayaAlabugaSkiResort' # СК Нижняя Алабуга
    SK_PIVKINO_ART='skPivkinoArt' # СК Пивкино (ст.)
    MSK_76_ZONE_1='msk76Zone1' # МСК-76, зона 1
    US_SOT_MELIORATOR='usSotMeliorator' # УС СОТ "Мелиоратор"
    MSK_76_ZONE_2='msk76Zone2' # МСК-76, зона 2
    LOCAL_CITY_OF_SHIMANOVSK='localCityOfShimanovsk' # Местная г.Шимановск
    SK_BEREZNYAKI='skBereznyaki' # СК Березняки
    SK_STEPPE='skSteppe' # СК Степное
    SKR_GARY='skrGary' # СК местная п.Гари
    SK_LIKHACHEVKA='skLikhachevka' # СК Лихачевка
    US_SOT_YUMANISHKI='usSotYumanishki' # УС СОТ "Юманишки"
    _7_218_P_PERSHINO='7218PPershino' # 7218 п.Першино
    SK_RETIRED='skRetired' # СК Отставное
    LOCAL_SK_ENGELS='localSkEngels' # Местная СК Энгельс
    _7_224_TOBOLSK='7224Tobolsk' # 7224 - г. Тобольск
    SK_63_COORD_SYSTEM_OF_1963_ZONE_D_4='sk63CoordSystemOf1963ZoneD4' # СК-63 - система координат 1963 года, зона D4
    SK_63_COORD_SYSTEM_OF_1963_ZONE_D_2='sk63CoordSystemOf1963ZoneD2' # СК-63 - система координат 1963 года, зона D2
    SK_NALCHIK='skNalchik' # СК г.п. Нальчик
    SK_NOVAYA_DEREVNYA='skNovayaDerevnya' # СК Новая Деревня
    SC_GRYAZOVETS='scGryazovets' # СК г.Грязовец
    MSK_881427_UST_TATTA='msk881427UstTatta' # МСК 88 14:27 Усть-Татта
    _7_210_PLESHKOVO='7210Pleshkovo' # 7210 с.Плешково
    SK_PRIRECHNOYE='skPrirechnoye' # СК с.п. Приречное
    SK_OF_CADASTRAL_DISTRICT_ZONE_361='skOfCadastralDistrictZone361' # СК кадастрового округа, зона 1
    SK_OF_CADASTRAL_DISTRICT_ZONE_362='skOfCadastralDistrictZone362' # СК кадастрового округа, зона 2
    US_SOT_MOZAYKA='usSotMozayka' # УС СОТ "Мозайка"
    SK_SHELEPOVO='skShelepovo' # СК Шелепово
    _7_206_VIKULOVSKY_DISTRICT='7206VikulovskyDistrict' # 7206 - Викуловский район
    CONDITIONAL_TOSHIKI='conditionalToshiki' # Условная (Тосики)
    _1_963_ZONE_2='1963Zone2' # 1963 (зона 2)
    MSK_881416_CHERNYSHEVSKY='msk881416Chernyshevsky' # МСК 88 14:16 Чернышевский
    _1_963_ZONE_3='1963Zone3' # 1963 (зона 3)
    _1_963_ZONE_4='1963Zone4' # 1963 (зона 4)
    MSK_881419_ST_NAGORNAYA='msk881419StNagornaya' # МСК 88 14:19 ст_Нагорная
    MSK_881409_BETENGKES='msk881409Betengkes' # МСК 88 14:09 Бетенгкес
    MSK_881409_ESE_HAYA='msk881409EseHaya' # МСК 88 14:09 Эсе-Хая
    CONDITIONAL_GORUSHKA_VILLAGE='conditionalGorushkaVillage' # Условная (д.Горушка)
    _7_215_SOROKINSKY_DISTRICT='7215SorokinskyDistrict' # 7215 - Сорокинский район
    IC_RADUZHNY='icRaduzhny' # СК Радужный
    LOCAL_TYNDA_DISTRICT='localTyndaDistrict' # Местная Тындинский район
    SK_NORI_NADYM_DISTRICT='skNoriNadymDistrict' # СК п.Нори (Надымский район)
    US_VAZHINSKAYA_PIER='usVazhinskayaPier' # УС д.Важинская Пристань
    MCК_30='mcк30' # MCК-30
    SK_HARP_LABYTNANGI='skHarpLabytnangi' # СК п.Харп (Лабытнанги)
    MSK_881409_ENGYA_SAYILYGA='msk881409EngyaSayilyga' # МСК 88 14:09 Энгя-Сайылыга
    USC_VOLODARSK='uscVolodarsk' # УСК Володарск
    MSK_881432_ISIT='msk881432Isit' # МСК 88 14:32 Исит
    WGS_84_EPSG_3857='wgs84Epsg3857' # WGS 84 (EPSG:3857)
    SK_LOCAL_KUZINO='skLocalKuzino' # СК местная п.Кузино
    MSK_DIVEYEVO_ONUCHINO='mskDiveyevoOnuchino' # МСК Дивеево (Онучино)
    US_SOT_YUBILEYNY='usSotYubileyny' # УС СОТ "Юбилейный"
    MSK_49_ZONE_3='msk49Zone3' # MСК-49 (зона 3)
    MSK_49_ZONE_2='msk49Zone2' # MСК-49 (зона 2)
    SK_BEREZOVSKY_DISTRICT_NYAKSIMVOL='skBerezovskyDistrictNyaksimvol' # СК Березовский район, Няксимволь
    SK_LOCAL_VERKHNYAYA_SINYACHIKHA='skLocalVerkhnyayaSinyachikha' # СК местная р.п.Верхняя Синячиха
    MSK_49_ZONE_4='msk49Zone4' # MСК-49 (зона 4)
    SK_KRASNOSELKUP_VILLAGE_KRASNOSEL='skKrasnoselkupVillageKrasnosel' # СК с.Красноселькуп (Красноселькупский район)
    SK_MST_KETOVSKY='skMstKetovsky' # СК МСТ (Кетовский)
    MSK_881432_ULAKHAN_AN='msk881432UlakhanAn' # МСК 88 14:32 Улахан-Ан
    SK_NAMED_AFTER_BABUSHKINO='skNamedAfterBabushkino' # СК п. им. Бабушкино
    MUGREEVSKY='mugreevsky' # Мугреевский
    POLESSK_CITY='polesskCity' # г.Полесск
    _7_209_P_KOMMUNAR='7209PKommunar' # 7209 п.Коммунар
    SK_LOCAL_PYSHMA='skLocalPyshma' # СК местная р.п.Пышма
    CONDITIONAL_PODDUBYE_VILLAGE_ORED='conditionalPoddubyeVillageOred' # Условная (д.Поддубье_Оредежское СП)
    MSK_881428_KESKIL='msk881428Keskil' # МСК 88 14:28 Кескил
    SK_63_COORD_SYSTEM_OF_1963_ZONE_Q_2='sk63CoordSystemOf1963ZoneQ2' # СК-63 - система координат 1963 года, зона Q2
    SKIMMER='skimmer' # СК Михайловка
    SK_MEZHBORNOYE='skMezhbornoye' # СК Межборное
    SK_OVGORT_SHURYSHKARSKY_DISTRICT='skOvgortShuryshkarskyDistrict' # СК с.Овгорт (Шурышкарский район)
    MSK_881419_NERYUNGRI='msk881419Neryungri' # МСК 88 14:19 Нерюнгри
    SK_RAZDOLYE_70='skRazdolye70' # СК Раздолье 70
    SK_LESNOYE='skLesnoye' # СК с.п. Лесное
    SK_BIRCHWOOD_GROVE='skBirchwoodGrove' # СК Березовая роща
    SK_VERKH_NEIVINSKY='skVerkhNeivinsky' # СК местная р.п. Верх-Нейвинский
    MSK_PETROZAVODSK='mskPetrozavodsk' # МСК г.Петрозаводск
    SK_PLOSKOE='skPloskoe' # СК Плоское
    US_SOT_RODNIK='usSotRodnik' # УС СОТ "Родник"
    SK_LOCAL_NOVAYA_LALA='skLocalNovayaLala' # СК местная г.Новая Ляля
    MSK_UKHTA_SOSNOGORSK='mskUkhtaSosnogorsk' # МСК Ухта Сосногорск
    MSK_881430_PETROPAVLOVSK='msk881430Petropavlovsk' # МСК 88 14:30 Петропавловск
    CONDITIONAL_13_LIPETSK_DISTRICT='conditional13LipetskDistrict' # Условная (13 Липецкий район)
    MSK_OF_RYLSKY_DISTRICT='mskOfRylskyDistrict' # МСК Рыльского р-на
    _7_215_D_VOZNESENKA_STREET='7215DVoznesenkaStreet' # 7215 д.Вознесенка
    SK_VYLPOSL_PRIURALSKY_DISTRICT='skVylposlPriuralskyDistrict' # СК Вылпосл (Приуральский район)
    VYNGAPUR_NOYABRSK='vyngapurNoyabrsk' # Вынгапур (Ноябрьск)
    _7_217_D_DRUGANOVA='7217DDruganova' # 7217 д.Друганова
    SK_BELOYARSK_DISTRICT_KAZYM='skBeloyarskDistrictKazym' # СК Белоярский район,Казым
    SK_NIZHNY_KURP='skNizhnyKurp' # СК с.п. Нижний Курп
    MSK_SOLNTSEVSKY_DISTRICT='mskSolntsevskyDistrict' # МСК Солнцевского р-на
    SK_OF_CADASTRAL_DISTRICT_ZONE_312='skOfCadastralDistrictZone312' # СК кадастрового округа, зона 2
    _7_209_KRASNOGORSKOE='7209Krasnogorskoe' # 7209 с.Красногорское
    SK_PROGRESS='skProgress' # СК с.п. Прогресс
    MSK_881432_TIT_EBE='msk881432TitEbe' # МСК 88 14:32 Тит-Эбэ
    SK_GORNOKNYAZEVSK_PRIURALSKY_DIST='skGornoknyazevskPriuralskyDist' # СК Горнокнязевск (Приуральский район)
    USK_24_KODINSK='usk24Kodinsk' # УСК-24, г. Кодинск
    US_SOT_TIP='usSotTip' # УС СОТ "Совет"
    US_SOT_ONEGO_2='usSotOnego2' # УС СОТ "Онего-2"
    SK_OF_CADASTRAL_DISTRICT_ZONE_311='skOfCadastralDistrictZone311' # СК кадастрового округа, зона 1
    SK_KAMYSHINO='skKamyshino' # СК Камышино
    SK_TEBENYAK='skTebenyak' # СК Тебеняк
    MSK_881430_KYUPTSY='msk881430Kyuptsy' # МСК 88 14:30 Кюпцы
    _7_210_D_ZAVYALOVO='7210DZavyalovo' # 7210 д.Завьялово
    USC_KRASNYE_BAKI_0090005='uscKrasnyeBaki0090005' # УСК Красные баки (0090005)
    USC_KRASNYE_BAKI_0090007='uscKrasnyeBaki0090007' # УСК Красные баки (0090007)
    LOCAL_VILLAGE_OF_YUKHTA='localVillageOfYukhta' # Местная с.Юхта
    LOCAL_KOSTROMA='localKostroma' # Местная_г.Кострома
    MSK_TERNEYSKY_DISTRICT='mskTerneyskyDistrict' # МСК Тернейский район
    SK_OKATOVA='skOkatova' # СК Окатова
    _7_210_D_LAIKOVA_STREET='7210DLaikovaStreet' # 7210 д.Лайкова
    MSK_881409_SUORDAKH='msk881409Suordakh' # МСК 88 14:09 Суордах
    US_SOT_ARZI_YARVI='usSotArziYarvi' # УС СОТ "Арзи-Ярви"
    _1_963_KINGISEPP='1963Kingisepp' # 1963 (Кингисеппский)
    US_SYSOILA='usSysoila' # УС д.Сыссойла
    SK_LESNOYE_PROKHL='skLesnoyeProkhl' # СК с.п. Лесное (прохл.)
    MSK_44_ZONE_2='msk44Zone2' # МСК-44, зона 2
    MSK_44_ZONE_1='msk44Zone1' # МСК-44, зона 1
    USC_KRASNYE_BAKI_0090020='uscKrasnyeBaki0090020' # УСК Красные баки (0090020)
    SK_PITLYAR_SHURYSHKARSKY_DISTRICT='skPitlyarShuryshkarskyDistrict' # СК с.Питляр (Шурышкарский район)
    MSK_44_ZONE_3='msk44Zone3' # МСК-44, зона 3
    _7_210_D_KOSHKARAGAI='7210DKoshkaragai' # 7210 д.Кошкарагай
    LOCAL_INSURANCE_COMPANY_BELGOROD='localInsuranceCompanyBelgorod' # Местная СК г. Белгород
    USC_KRASNYE_BAKI_0090016='uscKrasnyeBaki0090016' # УСК Красные баки (0090016)
    USC_KRASNYE_BAKI_0090015='uscKrasnyeBaki0090015' # УСК Красные баки (0090015)
    USC_KRASNYE_BAKI_0090018='uscKrasnyeBaki0090018' # УСК Красные баки (0090018)
    SK_MUZHI_SHURYSHKARSKY_DISTRICT='skMuzhiShuryshkarskyDistrict' # СК с.Мужи (Шурышкарский район)
    MSK_D_LUMBUSHI='mskDLumbushi' # МСК д.Лумбуши
    USC_KRASNYE_BAKI_0090017='uscKrasnyeBaki0090017' # УСК Красные баки (0090017)
    _1_963_LP='1963Lp' # 1963 ЛП
    USC_KRASNYE_BAKI_0090012='uscKrasnyeBaki0090012' # УСК Красные баки (0090012)
    USC_KRASNYE_BAKI_0090014='uscKrasnyeBaki0090014' # УСК Красные баки (0090014)
    USC_KRASNYE_BAKI_0090013='uscKrasnyeBaki0090013' # УСК Красные баки (0090013)
    SK_KOGALYM='skKogalym' # СК Когалым
    LOCAL_RED_TANKS='localRedTanks' # местная Красные баки
    LOCAL_SK_STAROPOLTAVSKY_DISTRICT='localSkStaropoltavskyDistrict' # Местная СК Старополтавский р-н
    _7_222_SHPALOZAVODSKY_SETTLEMENT='7222ShpalozavodskySettlement' # 7222 п.Шпалозаводский
    USC_KRASNYE_BAKI_0090019='uscKrasnyeBaki0090019' # УСК Красные баки (0090019)
    _7_202_ARMIZONSKOE='7202Armizonskoe' # 7202 с.Армизонское
    LOCAL_SK_OF_KIMOVSK='localSkOfKimovsk' # Местная СК г. Кимовска
    SOSNOVO_SPORTS_COMPLEX='sosnovoSportsComplex' # СК Сосново
    _0_3_MSK_SYSOLA='03MskSysola' # 03 МСК Сысола
    OCAL_LUZHSKY_DISTRICT_MSK_2='ocalLuzhskyDistrictMSK2' # Местная (Лужский район )
    NOVOPISTSOVO='novopistsovo' # Новописцово
    _7_210_D_NEVOLINA='7210DNevolina' # 7210 д.Неволина
    USC_KRASNYE_BAKI_0090030='uscKrasnyeBaki0090030' # УСК Красные баки (0090030)
    LOCAL_OF_TULA='localOfTula' # Местная г. Тулы
    USC_KRASNYE_BAKI_0090032='uscKrasnyeBaki0090032' # УСК Красные баки (0090032)
    _7_201_VODOLAZOVO='7201Vodolazovo' # 7201 с.Водолазово
    SK_VARGASHI_VILLAGE='skVargashiVillage' # СК Варгаши (село)
    US_SOT_OZERKI='usSotOzerki' # УС СОТ "Озерки"
    USC_KRASNYE_BAKI_0090027='uscKrasnyeBaki0090027' # УСК Красные баки (0090027)
    USC_KRASNYE_BAKI_0090026='uscKrasnyeBaki0090026' # УСК Красные баки (0090026)
    USC_KRASNYE_BAKI_0090029='uscKrasnyeBaki0090029' # УСК Красные баки (0090029)
    USC_KRASNYE_BAKI_0090023='uscKrasnyeBaki0090023' # УСК Красные баки (0090023)
    USC_KRASNYE_BAKI_0090024='uscKrasnyeBaki0090024' # УСК Красные баки (0090024)
    LOCAL_VOSKRESENSKOE='localVoskresenskoe' # Местная Воскресенское
    MSK_KHANKAYSKY_DISTRICT='mskKhankayskyDistrict' # МСК Ханкайский район
    SK_LOCAL_LAKESIDE='skLocalLakeside' # СК местная п.Приозёрный
    MSK_SHALSKIY_02='mskShalskiy02' # МСК п.Шальский02
    SK_KONDINSKY_DISTRICT_LUGOV='skKondinskyDistrictLugov' # СК Кондинский район,Лугов
    MSK_SHALSKIY_15='mskShalskiy15' # МСК п.Шальский15
    SK_HALASPUGOR_PRIURALSKY_DISTRICT='skHalaspugorPriuralskyDistrict' # СК Халасьпугор (Приуральский район)
    SK_BEREZOVSKY_DISTRICT_IGRIM='skBerezovskyDistrictIgrim' # СК Березовски район, Игрим
    _7_210_YERSHOVO='7210Yershovo' # 7210 с.Ершово
    SK_SHURYSHKARY_SHURYSHKARSKY_DIST='skShuryshkaryShuryshkarskyDist' # СК с.Шурышкары (Шурышкарский район)
    SK_DRP_APACHE='skDrpApache' # СК ДРП Апача
    MSK_OF_OBOYANSKY_DISTRICT='mskOfOboyanskyDistrict' # МСК Обоянского р-на
    MSK_881402_CHAGDA='msk881402Chagda' # МСК 88 14:02 Чагда
    US_SOT_SVETLANA='usSotSvetlana' # УС СОТ "Светлана"
    MSK_PORONAISKY_DISTRICT='mskPoronaiskyDistrict' # МСК Поронайского района
    SK_MEDVEZHYE='skMedvezhye' # СК Медвежье
    USC_KRASNYE_BAKI_0090037='uscKrasnyeBaki0090037' # УСК Красные баки (0090037)
    LOCAL_VILLAGE_OF_NOVOBUREYSKY='localVillageOfNovobureysky' # Местная рп.Новобурейский
    SK_ROMANOVO='skRomanovo' # СК Романово
    USC_KRASNYE_BAKI_0090034='uscKrasnyeBaki0090034' # УСК Красные баки (0090034)
    USC_KRASNYE_BAKI_0090036='uscKrasnyeBaki0090036' # УСК Красные баки (0090036)
    MSK_881433_DEERING='msk881433Deering' # МСК 88 14:33 Диринг
    _7_209_VERKHNEBESHKIL='7209Verkhnebeshkil' # 7209 с.Верхнебешкиль
    CONDITIONAL_NOVOIVANOVSKOE_VILLA='conditionalNovoivanovskoeVilla' # Условная (д.Новоивановское)
    OZERNOYE_SPORTS_COMPLEX='ozernoyeSportsComplex' # СК Озерное
    _7_210_D_GOLDOBINO='7210DGoldobino' # 7210 д.Голдобино
    SK_63_D_6_TRUNCATED='sk63D6Truncated' # СК 63 D6 усеченная
    SK_CHERNOBORYE='skChernoborye' # СК Черноборье
    US_SOT_CAMOMILE='usSotCamomile' # УС СОТ "Ромашка"
    _7_216_SDT_ORION='7216SdtOrion' # 7216 сдт.Орион
    USC_KRASNYE_BAKI_0090052='uscKrasnyeBaki0090052' # УСК Красные баки (0090052)
    USC_KRASNYE_BAKI_0090051='uscKrasnyeBaki0090051' # УСК Красные баки (0090051)
    SK_PRAVOKHETTINSKY_NADYMSKY_DISTR='skPravokhettinskyNadymskyDistr' # СК п.Правохеттинский (Надымский район)
    USC_KRASNYE_BAKI_0090053='uscKrasnyeBaki0090053' # УСК Красные баки (0090053)
    US_SOT_PROSVESHCHENETS='usSotProsveshchenets' # УС СОТ "Просвещенец"
    USC_KRASNYE_BAKI_0090050='uscKrasnyeBaki0090050' # УСК Красные баки (0090050)
    US_SOT_VANGOZERO='usSotVangozero' # УС СОТ "Вангозеро"
    USC_KRASNYE_BAKI_0090049='uscKrasnyeBaki0090049' # УСК Красные баки (0090049)
    USC_KRASNYE_BAKI_0090048='uscKrasnyeBaki0090048' # УСК Красные баки (0090048)
    _7_216_SDT_VICTORIA_2='7216SdtVictoria2' # 7216 сдт.Виктория-2
    MSK_881432_ULAKH_AN='msk881432UlakhAn' # МСК 88 14:32 Улах-Ан
    US_SOT_HERRINGBONE='usSotHerringbone' # УС СОТ "Елочка"
    US_MARTNAVOLOK='usMartnavolok' # УС д.Мартнаволок
    _7_215_P_ALEXANDROVKA='7215PAlexandrovka' # 7215 с.Александровка
    US_SOT_KONCHEZERSKY='usSotKonchezersky' # УС СОТ "Кончезерский"
    STATE_196377='state196377' # Государственная, 1963 г.
    SK_ZAVODSKOY='skZavodskoy' # СК с.п. Заводской
    MSK_881402_NAMELESS='msk881402Nameless' # МСК 88 14:02 Безымянный
    _7_217_P_BOROVSKY='7217PBorovsky' # 7217 п.Боровский
    MSK_881402_VERKHNYAYA_AMGA='msk881402VerkhnyayaAmga' # МСК 88 14:02 Верхняя Амга
    MSK_KIROV='mskKirov' # МСК г. Киров
    US_SOT_ENERGETIK='usSotEnergetik' # УС СОТ "Энергетик"
    _7_217_P_ANDREEVSKY_ISLAND='7217PAndreevskyIsland' # 7217 п.Андреевский
    SK_VAVILKOVA='skVavilkova' # СК Вавилкова
    SK_RESORT_LAKE='skResortLake' # СК Курорт Озеро
    SK_LOCAL_TURINSK='skLocalTurinsk' # СК местная г.Туринск
    LOCAL_NEREKHTA='localNerekhta' # Местная_г.Нерехта
    MSK_SYKTYVKAR='mskSyktyvkar' # МСК Сыктывкарская
    SK_LOCAL_DRUZHININO='skLocalDruzhinino' # СК местная р.п.Дружинино
    SK_MST_KURTAMYSHSKY_0='skMstKurtamyshsky0' # СК МСТ (Куртамышский) - 0
    _7_222_USALKA_VILLAGE='7222UsalkaVillage' # 7222 с.Усалка
    SK_SOVETSKY_DISTRICT_PIONERSKY='skSovetskyDistrictPionersky' # СК Советский район, Пионерский
    LOCAL_MAZANOVSKY_DISTRICT='localMazanovskyDistrict' # Местная Мазановский район
    LOCAL_169='local169' # Местная 169
    LOCAL_168='local168' # Местная 168
    USK_TONSHAYEVO_TANSY='uskTonshayevoTansy' # УСК Тоншаево (Пижма)
    _7_215_P_BOLSHOE_SOROKINO='7215PBolshoeSorokino' # 7215 с.Большое Сорокино
    MSK_MOTKO='mskMotko' # МСК п.Мотко
    SK_KICH_GORODOK='skKichGorodok' # СК с. Кич-городок
    LOCAL_167='local167' # Местная 167
    LOCAL_166='local166' # Местная 166
    _7_222_GUARDSMAN='7222Guardsman' # 7222 с.Караульнояр
    US_SALMON='usSalmon' # УС п.Лососий
    SK_KUBA_TABA='skKubaTaba' # СК с.п. Куба-Таба
    MSK_OF_THE_VILLAGE_OF_TYMOVSKOE='mskOfTheVillageOfTymovskoe' # МСК пгт Тымовское
    SK_VOSTOCHNOYE='skVostochnoye' # СК Восточное
    US_SOT_LESOVOD='usSotLesovod' # УС СОТ "Лесовод"
    _7_209_BARKHATOVO='7209Barkhatovo' # 7209 с.Бархатово
    MALOE_PESYANOVO_SPORTS_COMPLEX='maloePesyanovoSportsComplex' # СК Малое Песьяново
    SK_MAKUSHINSKY_DISTRICT='skMakushinskyDistrict' # СК Макушинского района
    _7_210_D_MAKAROVA_STREET='7210DMakarovaStreet' # 7210 д.Макарова
    SK_ZYUZINO='skZyuzino' # СК Зюзино
    US_SOT_VETEROK='usSotVeterok' # УС СОТ "Ветерок"
    USK_6868082929001='usk6868082929001' # УСК-68, 68:08:2929001
    LOCAL_VILLAGE_BOLSHOE_SELO='localVillageBolshoeSelo' # Местная с. Большое Село
    SK_GLADKOVSKOE='skGladkovskoe' # СК Гладковское
    CONDITIONAL_PUSTOSHKA_VILLAGE='conditionalPustoshkaVillage' # Условная (д.Пустошка)
    _7_218_TER_KALCHINSKY_OIL_FIELD='7218TerKalchinskyOilField' # 7218 тер.Кальчинского месторождения нефти
    CONDITIONAL_KONEZERYE_VILLAGE='conditionalKonezeryeVillage' # Условная (д.Конезерье)
    LOCAL_SQ_M_KUMYLGA='localSqMKumylga' # Местная СК ст.Кумылга
    SK_VOSTOCHNOYE_RURAL_SETT='skVostochnoyeRuralSett' # СК с.п. Восточное
    _7_210_D_MALINOVKA='7210DMalinovka' # 7210 д.Малиновка
    MSK_881409_BARYLAS='msk881409Barylas' # МСК 88 14:09 Барылас
    _0_7_MSK_UST_KULOM='07MskUstKulom' # 07 МСК Усть-Кулом
    US_SOT_DRUZHBA='usSotDruzhba' # УС СОТ "Дружба"
    SK_LEBYAZHEVSKY_DISTRICT='skLebyazhevskyDistrict' # СК Лебяжьевского района
    MSK_881430_EZHANTSEV='msk881430Ezhantsev' # МСК 88 14:30 Эжанцы
    SK_DAVYDOVKA='skDavydovka' # СК Давыдовка
    LOCAL_ARDATOV='localArdatov' # Местная Ардатов
    _0_8_SK_63_D_5='08Sk63D5' # 08 СК 63 D5
    LOCAL_NAVASHINO='localNavashino' # Местная Навашино
    SK_CRANBERRY='skCranberry' # СК Клюквенное
    LOCAL_TIKHVIN='localTikhvin' # Местная (г. Тихвин)
    SK_421431='sk421431' # СК 42 14:31
    SK_421430='sk421430' # СК 42 14:30
    _7_216_SDT_GARDENER='7216SdtGardener' # 7216 сдт.Садовод
    SKRYVNOE='skryvnoe' # СК Прорывное
    MSK_881432_KARAPATSKOE='msk881432Karapatskoe' # МСК 88 14:32 Карапатское
    SK_421433='sk421433' # СК 42 14:33
    SK_421432='sk421432' # СК 42 14:32
    SK_421434='sk421434' # СК 42 14:34
    MSK_FURRY='mskFurry' # МСК п.Пушной
    SK_POLOVINSKY_DISTRICT='skPolovinskyDistrict' # СК Половинского района
    SK_421429='sk421429' # СК 42 14:29
    MSK_74_ZONE_1='msk74Zone1' # МСК-74, зона 1
    _7_201_BYSTRUKHA='7201Bystrukha' # 7201 с.Быструха
    SK_YUDINO='skYudino' # СК Юдино
    CHERNYAKHOVSK_CITY='chernyakhovskCity' # г. Черняховск
    MSK_74_ZONE_3='msk74Zone3' # МСК-74, зона 3
    SK_DANKOVO='skDankovo' # СК Даньково
    MSK_74_ZONE_2='msk74Zone2' # МСК-74, зона 2
    SK_421420='sk421420' # СК 42 14:20
    _7_201_OSHCHEPKOVO='7201Oshchepkovo' # 7201 с.Ощепково
    MSK_881409_MACHAKH='msk881409Machakh' # МСК 88 14:09 Мачах
    _1_2_USK_BELY_YU='12UskBelyYu' # 12 УСК Белый-Ю
    SK_OF_THE_CADASTRAL_DISTRICT_13='skOfTheCadastralDistrict13' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_12='skOfTheCadastralDistrict12' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_11='skOfTheCadastralDistrict11' # СК кадастрового округа
    SK_GYDA_TAZOVSKY_DISTRICT='skGydaTazovskyDistrict' # ск п.Гыда (Тазовский район)
    SK_OF_THE_CADASTRAL_DISTRICT_10='skOfTheCadastralDistrict10' # СК кадастрового округа
    US_SOT_RADUGA='usSotRaduga' # УС СОТ "Радуга"
    SK_421426='sk421426' # СК 42 14:26
    SK_421425='sk421425' # СК 42 14:25
    SK_421428='sk421428' # СК 42 14:28
    SK_421427='sk421427' # СК 42 14:27
    SK_421422='sk421422' # СК 42 14:22
    MSK_TIMSKY_DISTRICT='mskTimskyDistrict' # МСК Тимского р-на
    SK_421424='sk421424' # СК 42 14:24
    _1_8_MSK_INTA='18MskInta' # 18 МСК Инта
    MSK_12_ZONE_1='msk12Zone1' # МСК 12, зона 1
    SK_421419='sk421419' # СК 42 14:19
    SK_PESCHANSKOE='skPeschanskoe' # СК Песчанское
    SK_OF_THE_CADASTRAL_DISTRICT_17='skOfTheCadastralDistrict17' # СК кадастрового округа
    MSK_881409_CHOLBON='msk881409Cholbon' # МСК 88 14:09 Чолбон
    _7_215_P_GOTOPUTOVO='7215PGotoputovo' # 7215 с.Готопутово
    SK_OF_THE_CADASTRAL_DISTRICT_16='skOfTheCadastralDistrict16' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_15='skOfTheCadastralDistrict15' # СК кадастрового округа
    USK_VOSKRESENSK_0060017='uskVoskresensk0060017' # УСК Воскресенск (0060017)
    SK_OF_THE_CADASTRAL_DISTRICT_14='skOfTheCadastralDistrict14' # СК кадастрового округа
    _7_216_SDT_GAZOVIK='7216SdtGazovik' # 7216 сдт.Газовик
    SK_SHUTINO='skShutino' # СК Шутино
    SK_NYAGAN_SQLBASE_0305='skNyaganSqlbase0305' # СК Нягань SQLBase_03_05
    CONDITIONAL_SOLSTICE='conditionalSolstice' # Условная (Солнцев берег)
    US_ART_LIZHMA='usArtLizhma' # УС ст.Лижма
    LOCAL_B_MURASHKINO='localBMurashkino' # Местная Б_Мурашкино
    SK_421417='sk421417' # СК 42 14:17
    SK_421416='sk421416' # СК 42 14:16
    SK_421411='sk421411' # СК 42 14:11
    SK_421410='sk421410' # СК 42 14:10
    SK_421413='sk421413' # СК 42 14:13
    BAGRATIONOVSKY_DISTRICT='bagrationovskyDistrict' # Багратионовский район
    SK_421412='sk421412' # СК 42 14:12
    USK_VOSKRESENSK_0060021='uskVoskresensk0060021' # УСК Воскресенск (0060021)
    _7_217_D_BIG_AKIYARS='7217DBigAkiyars' # 7217 д.Большие Акияры
    MSK_SPASSK='mskSpassk' # МСК г. Спасск
    SK_421408='sk421408' # СК 42 14:08
    SK_63_W_1='sk63W1' # СК 63 W1
    SK_421407='sk421407' # СК 42 14:07
    MSK_DIVEYEVO_STUKLOVO='mskDiveyevoStuklovo' # МСК Дивеево (Стуклово)
    SK_421409='sk421409' # СК 42 14:09
    US_0072001='us0072001' # УС 0072001
    MSK_USSURIYSKY_DISTRICT='mskUssuriyskyDistrict' # МСК Уссурийский район
    US_SOT_RYBAK='usSotRybak' # УС СОТ "Рыбак"
    ZELENIY_YAR_SPORTS_COMPLEX_PRIURAL='zeleniyYarSportsComplexPriural' # СК Зеленый Яр (Приуральский район)
    MSK_OF_DOLINSK='mskOfDolinsk' # МСК г. Долинска
    MSK_D_WESTERN_KONCHEZERO='mskDWesternKonchezero' # МСК д.Западное Кончезеро
    USC_RED_TANKS_0010005='uscRedTanks0010005' # УСК Красные баки (0010005)
    SK_BELOYARSK_PRIURALSKY_DISTRICT='skBeloyarskPriuralskyDistrict' # СК Белоярск (Приуральский район)
    USC_RED_TANKS_0010004='uscRedTanks0010004' # УСК Красные баки (0010004)
    _7_216_SDT_THE_LOTUS='7216SdtTheLotus' # 7216 сдт.Лотос
    USC_RED_TANKS_0010006='uscRedTanks0010006' # УСК Красные баки (0010006)
    MSK_KR_3324_SOBINKA_AND_LAKINSK='mskKr3324SobinkaAndLakinsk' # МСК КР 33:24 г. Собинка и г. Лакинск
    CONDITIONAL_19_YELETS='conditional19Yelets' # Условная (19 г.Елец)
    MSK_881428_TEPLY_KLYUCH='msk881428TeplyKlyuch' # МСК 88 14:28 Теплый Ключ
    SK_421404='sk421404' # СК 42 14:04
    SK_LISYE='skLisye' # СК Лисье
    MSK_881409_PILLARS='msk881409Pillars' # МСК 88 14:09 Столбы
    SK_421403='sk421403' # СК 42 14:03
    MSK_LADVA='mskLadva' # МСК п.Ладва
    SK_421406='sk421406' # СК 42 14:06
    SK_UROZHAYNOYE='skUrozhaynoye' # СК с.п.Урожайное
    SK_421405='sk421405' # СК 42 14:05
    USC_1711='usc1711' # УСК 1711
    SK_PRAVOURVANSKY='skPravourvansky' # СК с.п. Правоурванский
    USC_RED_TANKS_0010003='uscRedTanks0010003' # УСК Красные баки (0010003)
    SK_421402='sk421402' # СК 42 14:02
    CONDITIONAL_07_YELETSKY_DISTRICT='conditional07YeletskyDistrict' # Условная (07 Елецкий район)
    SK_421401='sk421401' # СК 42 14:01
    SK_UFINA='skUfina' # СК Уфина
    SK_NIDA_NADYM_DISTRICT='skNidaNadymDistrict' # СК с.Ныда (Надымский район)
    US_TIVDIA='usTivdia' # УС д.Тивдия
    LOCAL_SHIMANOVSKY_DISTRICT='localShimanovskyDistrict' # Местная Шимановский район
    SK_POPOVO='skPopovo' # СК Попово
    SK_CHESNOKOVO='skChesnokovo' # СК Чесноково
    MSK_881430_ELDIKAN='msk881430Eldikan' # МСК 88 14:30 Эльдикан
    CHERNAVSKY_SKI_SLOPE='chernavskySkiSlope' # СК кардон Чернавский
    _7_218_P_UVAT='7218PUvat' # 7218 с.Уват
    MSK_DALNERECHENSK='mskDalnerechensk' # МСК Дальнереченск
    SK_PLANOVSKOE='skPlanovskoe' # СК с.п. Плановское
    SK_OF_CADASTRAL_DISTRICT_ZONE_60_1='skOfCadastralDistrictZone60.1' # СК кадастрового округа, зона 1 (21)
    SK_PANGODY_NADYM_DISTRICT='skPangodyNadymDistrict' # СК п.Пангоды (Надымский район)
    MSK_ZHELEZNOGORSK='mskZheleznogorsk' # МСК г. Железногорск
    MSK_ZOLOTUKHINSKY_DISTRICT='mskZolotukhinskyDistrict' # МСК Золотухинского р-на
    MSK_881427_DAKAR='msk881427Dakar' # МСК 88 14:27 Даккы
    LOCAL_14='local14' # Местная 14
    MSK_12_ZONE_2='msk12Zone2' # МСК 12, зона 2
    ZAVOLZHSK='zavolzhsk' # Заволжск
    SK_OKTYABRSKY_DISTRICT_UN_YUGAN_PB='skOktyabrskyDistrictUnYuganPb' # СК Октябрьский район, Ун_Юган пб
    MSK_VIDLITSA_ESTUARY='mskVidlitsaEstuary' # МСК п.Устье Видлицы
    SK_KOPYRINO='skKopyrino' # СК Копырино
    MSK_881402_YLLYMAKH='msk881402Yllymakh' # МСК 88 14:02 Ыллымах
    LOCAL_GAKKOVO_VILLAGE='localGakkovoVillage' # Местная (д.Гакково)
    GVARDEYSK_CITY='gvardeyskCity' # г.Гвардейск
    SK_635_ZONE='sk635Zone' # СК 63 5 зона
    MSK_881402_KHATYSTYR='msk881402Khatystyr' # МСК 88 14:02 Хатыстыр
    MSK_35_ZONE_2='msk35Zone2' # МСК-35 2 зона
    SK_SALEKHARD='skSalekhard' # СК г.Салехард
    LOCAL_SEREBRYANSKY_SETTLEMENT='localSerebryanskySettlement' # Местная (п. Серебрянский)
    NIZHNEVARTOVSKY_SPORTS_COMPLEX='nizhnevartovskySportsComplex' # СК Нижневартовский
    SK_ZARECHNOYE='skZarechnoye' # СК с.п. Заречное
    MSK_BELOVSKY_DISTRICT='mskBelovskyDistrict' # МСК Беловского р-на
    US_0073301='us0073301' # УС 0073301
    SK_KUYAN='skKuyan' # СК с.п. Куян
    LOCAL_LIPETSK='localLipetsk' # Местная (г.Липецк)
    _1_4_USK_SHCHELYAYUR='14UskShchelyayur' # 14 УСК Щельяюр
    MSK_881427_BAYAGA='msk881427Bayaga' # МСК 88 14:27 Баяга
    USC_RED_TANKS_0030009='uscRedTanks0030009' # УСК Красные баки (0030009)
    MSK_881402_LEBEDINY='msk881402Lebediny' # МСК 88 14:02 Лебединый
    ILINSKOE_KHOVANSKOE='ilinskoeKhovanskoe' # Ильинское-Хованское
    _7_210_D_VORONINA='7210DVoronina' # 7210 д.Воронина
    _7_217_D_PYSHMINKA='7217DPyshminka' # 7217 д.Пышминка
    _7_201_BANNIKOVO='7201Bannikovo' # 7201 с.Банниково
    SK_CLEAN='skClean' # СК Чистое
    _7_222_GILEVO='7222Gilevo' # 7222 с.Гилево
    MSK_35_ZONE_3='msk35Zone3' # МСК-35 3 зона
    SK_OSTROVNOYE='skOstrovnoye' # СК Островное
    MSK_881416_BEREZOVY='msk881416Berezovy' # МСК 88 14:16 Березовый
    MSK_NARYAN_MAR='mskNaryanMar' # МСК г.Нарьян-Мар
    SK_BLAGOVESHCHENKA='skBlagoveshchenka' # СК с.п. Благовещенка
    _7_209_D_KIRSANOVA='7209DKirsanova' # 7209 д.Кирсанова
    US_SOT_CHERYOMUSHKI_NO_3='usSotCheryomushkiNo3' # УС СОТ "Черемушки №3"
    MSK_881409_BORONUK='msk881409Boronuk' # МСК 88 14:09 Боронук
    SK_BELOGLINSKOE='skBeloglinskoe' # СК с.п. Белоглинское
    SK_NAUMOVKA='skNaumovka' # СК Наумовка
    LOCAL_ARGALI='localArgali' # Местная Архара
    _7_210_ISHIM_DISTRICT='7210IshimDistrict' # 7210 - Ишимский район
    LOCAL_URN='localUrn' # Местная Урень
    LOCAL_LUZHSKY_DISTRICT_GGC_1='localLuzhskyDistrictGGC1' # Местная (Лужский район)
    KAMEN_NA_OB_CITY='kamenNaObCity' # г. Камень-на-Оби
    SK_ZOLSKOE='skZolskoe' # СК с.п. Зольское
    _7_210_D_ZAVOROKHINO='7210DZavorokhino' # 7210 д.Заворохино
    LOCAL_LUZHSKY_DISTRICT_GGC_3='localLuzhskyDistrictGGC3' # Местная (Лужский район.)
    LOCAL_LUZHSKY_DISTRICT_GGC_2='localLuzhskyDistrictGGC2' # Местная (Лужский район).
    ZARECHNY='zarechny' # Заречный
    MSK_881409_CHERYUMCHE='msk881409Cheryumche' # МСК 88 14:09 Черюмче
    MSK_OF_THE_VILLAGE_NADVOITSY='mskOfTheVillageNadvoitsy' # МСК пгт.Надвоицы
    GUSEVSKY_DISTRICT='gusevskyDistrict' # Гусевский район
    SC_KOCHARINO='scKocharino' # СК Кочарино
    SK_COLLECTIVE_GARDEN='skCollectiveGarden' # СК Коллективный сад
    MSK_D_UPPER_REACHES='mskDUpperReaches' # МСК д.Верховье
    US_SOT_ZAOZERYE='usSotZaozerye' # УС СОТ "Заозерье"
    MSK_881432_KYSYL_YURYUYA='msk881432KysylYuryuya' # МСК 88 14:32 Кысыл-Юрюйя
    TROITSKOE_SPORTS_COMPLEX='troitskoeSportsComplex' # СК Троицкое
    MSK_S_KONCHEZERO='mskSKonchezero' # МСК с.Кончезеро
    _7_210_D_NERPINO='7210DNerpino' # 7210 д.Нерпино
    _4_104_SHIFT='4104Shift' # 4104 сдвиг
    MSK_881409_TOMTOR_DULGALAKH='msk881409TomtorDulgalakh' # МСК 88 14:09 Томтор_Дулгалах
    MSK_OHI='mskOhi' # МСК г. Охи
    _0_6_MSK_PODTYBOK='06MskPodtybok' # 06 МСК Подтыбок
    SK_LOCAL_KAMYSHLOV='skLocalKamyshlov' # СК местная г.Камышлов
    MO_MURAVLENKO='moMuravlenko' # МО г.Муравленко
    US_SOT_PRIONEZHYE='usSotPrionezhye' # УС СОТ "Прионежье"
    MSK_87_CHUKOTKA_DISTRICT='msk87ChukotkaDistrict' # МСК-87 (Чукотский район)
    PRIVOLZHSK='privolzhsk' # Приволжск
    _7_218_UVATSKY_DISTRICT='7218UvatskyDistrict' # 7218 - Уватский район
    GURIEVSK_CITY='gurievskCity' # г.Гурьевск
    STARAYA_MSK_26_FROM_SK_95='starayaMsk26FromSk95' # Старая МСК-26 от СК-95
    _7_210_MIZONOVO='7210Mizonovo' # 7210 с.Мизоново
    MSK_87_BERINGOVSKY_DISTRICT='msk87BeringovskyDistrict' # МСК-87 (Беринговский район)
    US_SOT_RODNIK_1020='usSotRodnik1020' # УС СОТ "Родник" 10:20
    SK_FORTRESS='skFortress' # СК Крепость
    CONDITIONAL_SC_CO='conditionalScCo' # Условная СК (КО)
    MSK_881427_KYYY='msk881427Kyyy' # МСК 88 14:27 Кыйы
    MSK_KR_3301_ALEXANDROVSKY_DISTRICT='mskKr3301AlexandrovskyDistrict' # МСК КР 33:01 Александровский район
    CONDITIONAL_ZAMETMEZHYE_VILLAGE='conditionalZametmezhyeVillage' # Условная (д.Замежье)
    USK_VOSKRESENSK_0040005='uskVoskresensk0040005' # УСК Воскресенск (0040005)
    SK_VARGASHI='skVargashi' # СК Варгаши
    _7_210_P_BOKAREVKA='7210PBokarevka' # 7210 п.Бокаревка
    MSK_DIVEYEVO_MAYEVKA='mskDiveyevoMayevka' # МСК Дивеево (Маевка)
    SK_LOCAL_BUT_NOVOURALSK='skLocalButNovouralsk' # СК местная ЗАТО Новоуральск
    _0_8_MSK_VOGVAZDINO='08MskVogvazdino' # 08 МСК Вогваздино
    SK_LOCAL_KUSHVA='skLocalKushva' # СК местная г.Кушва
    SK_SKILYAGINA='skSkilyagina' # СК Скилягина
    US_USSUNA='usUssuna' # УС д.Уссуна
    SK_BELOYARSK_DISTRICT_V_KAZIM='skBeloyarskDistrictVKazim' # СК Белоярский район,V_Kazim
    US_KUBOVO='usKubovo' # УС п.Кубово
    US_SOT_RYABINKA='usSotRyabinka' # УС СОТ "Рябинка"
    ZARINSK_CITY='zarinskCity' # г. Заринск
    SK_LOPAREVO='skLoparevo' # СК Лопарево
    LOCAL_71='local71' # Местная 71
    MSK_KOSTOMUKSHA='mskKostomuksha' # МСК г.Костомукша
    SK_OF_THE_CADASTRAL_DISTRICT_COND_1='skOfTheCadastralDistrictCond1' # СК кадастрового округа (Условная СК)
    SK_OF_THE_CADASTRAL_DISTRICT_COND_2='skOfTheCadastralDistrictCond2' # СК кадастрового округа (Условная СК)
    MSK_PEDESTAL='mskPedestal' # МСК п.Тумба
    SK_OF_THE_CADASTRAL_DISTRICT_COND_3='skOfTheCadastralDistrictCond3' # СК кадастрового округа (Условная СК)
    MCK_30_ZONE_1='mck30Zone1' # MCK-30, зона 1
    US_SOT_KIIMASOZERO='usSotKiimasozero' # УС СОТ "Киимасозеро"
    US_0072401='us0072401' # УС 0072401
    SK_OKTYABRSKY_DISTRICT_OKTYABRSKO='skOktyabrskyDistrictOktyabrsko' # СК Октябрьский район, Октябрьское ПБ
    POKACHI_CITY='pokachiCity' # г. Покачи
    MSK_881428_KHANDYGA='msk881428Khandyga' # МСК 88 14:28 Хандыга
    MSK_45_KOSULINO_LOCALITY_COMINTERN='msk45KosulinoLocalityComintern' # МСК-45 н.п. Косулино, Коминтерн
    SK_SURGUT='skSurgut' # СК Сургут
    MSK_KIROVSKY_DISTRICT='mskKirovskyDistrict' # МСК Кировский район
    SK_ZHUKOVO='skZhukovo' # СК Жуково
    LOCAL_INSURANCE_COMPANY_OF_MOSCOWN='localInsuranceCompanyOfMoscown' # местная СК г.Новоаннинский
    _7_210_P_OKTYABRSKY_DISTRICT='7210POktyabrskyDistrict' # 7210 п.Октябрьский
    MSK_881419_NAGORNY='msk881419Nagorny' # МСК 88 14:19 Нагорный
    _7_210_D_NESTEROVA_STREET='7210DNesterovaStreet' # 7210 д.Нестерова
    US_SOT_NADEZHDA_1020='usSotNadezhda1020' # УС СОТ "Надежда" 10:20
    LOCAL_BOKSITOGORSK='localBoksitogorsk' # Местная (г. Бокситогорск)
    LOCAL_INSURANCE_COMPANY_OF_MOSCOWV='localInsuranceCompanyOfMoscowv' # Местная СК г.Вольск
    SK_UST_VOIKARY_SHURYSHKARSKY_DISTR='skUstVoikaryShuryshkarskyDistr' # СК д.Усть-Войкары (Шурышкарский район)
    LOCAL_VILLAGE_NOVOSTEPANOVKA='localVillageNovostepanovka' # Местная с.Новостепановка
    S_K_LOCAL='sKLocal' # С.К. Местная
    MSK_881416_LIGHT='msk881416Light' # МСК 88 14:16 Светлый
    SK_CHERYOMUSHKI='skCheryomushki' # СК Черемушки
    PRAVDINSK_CITY='pravdinskCity' # г.Правдинск
    LOCAL_VYBORG_DISTRICT='localVyborgDistrict' # местная (Выборгский район)
    SK_YANTARNOYE='skYantarnoye' # СК с.п. Янтарное
    SK_DUNDINO='skDundino' # СК Дундино
    SK_GORBUNOVO='skGorbunovo' # СК Горбуново
    USK_VOSKRESENSK_0040016='uskVoskresensk0040016' # УСК Воскресенск (0040016)
    SK_STAROPERSHINO='skStaropershino' # СК Старопершино
    LOCAL_SK_G_KALACH='localSkGKalach' # местная СК г Калач
    MSK_88_ZONE_5='msk88Zone5' # МСК-88, зона 5
    US_NELHOMOZERO='usNelhomozero' # УС п.Нелгомозеро
    USK_VOSKRESENSK_0040015='uskVoskresensk0040015' # УСК Воскресенск (0040015)
    MSK_88_ZONE_2='msk88Zone2' # МСК-88, зона 2
    _7_217_ART_LIFT='7217ArtLift' # 7217 ст.Подъем
    MSK_88_ZONE_1='msk88Zone1' # МСК-88, зона 1
    USK_VOSKRESENSK_0040013='uskVoskresensk0040013' # УСК Воскресенск (0040013)
    MSK_88_ZONE_4='msk88Zone4' # МСК-88, зона 4
    DULYAPINO='dulyapino' # Дуляпино
    MSK_88_ZONE_3='msk88Zone3' # МСК-88, зона 3
    MSK_DALNEGORSKY_DISTRICT='mskDalnegorskyDistrict' # МСК Дальнегорский район
    MSK_BOCHILOVO='mskBochilovo' # МСК п.Бочилово
    SK_NIZHNY_AKBASH='skNizhnyAkbash' # СК с.п. Нижний Акбаш
    SK_KOLTASHEVO='skKoltashevo' # СК Колташево
    LUH='luh' # Лух
    BOLSHAYA_GORBUNOVA_SPORTS_COMPLEX='bolshayaGorbunovaSportsComplex' # СК Большая Горбунова
    MSK_KR_3311_SUDOGODSKY_DISTRICT='mskKr3311SudogodskyDistrict' # МСК КР 33:11 Судогодский район
    SK_ALAKUL='skAlakul' # СК Алакуль
    MSK_KEM='mskKem' # МСК г.Кемь
    LAKHDENPOHYA_MSK='lakhdenpohyaMsk' # МСК г.Лахденпохья
    MSK_881427_CHYCHYMAKH='msk881427Chychymakh' # МСК 88 14:27 Чычымах
    SK_LOCAL_MALYSHEV='skLocalMalyshev' # СК местная п.Малышева
    MSK_22_ZONE_3='msk22Zone3' # МСК-22, зона 3
    MSK_22_ZONE_2='msk22Zone2' # МСК-22, зона 2
    MSK_22_ZONE_1='msk22Zone1' # МСК-22, зона 1
    US_SOT_OGONYOK='usSotOgonyok' # УС СОТ "Огонек"
    USK_24_SK_LESOSIBIRSK='usk24SkLesosibirsk' # УСК-24, СК Лесосибирск
    US_SOT_TEPLOENERGETIK='usSotTeploenergetik' # УС СОТ "Теплоэнергетик"
    SK_SOVETSKOE_RURAL_SETTLEMENT='skSovetskoeRuralSettlement' # СК с.п. Советское
    MSK_KR_3301_BALAKIREVO='mskKr3301Balakirevo' # МСК КР 33:01 п. Балакирево
    SK_DISPUTABLE='skDisputable' # СК Спорное
    SK_SOVETSKY_DISTRICT_KOMMUNIST='skSovetskyDistrictKommunist' # СК Советский Район, Коммунист
    US_METSYAKYULYA='usMetsyakyulya' # УС д.Метсякюля
    SK_ZHANHOTEKO='skZhanhoteko' # СК с.п. Жанхотеко
    US_PITKYARANTA='usPitkyaranta' # УС г.Питкяранта
    US_CC_10130080701='usCc10130080701' # УС КК 10:13:0080701
    SK_SOVETSKY_DISTRICT_AGIRISH='skSovetskyDistrictAgirish' # СК Советский Район, Агириш
    KAMINSKY='kaminsky' # Каминский
    SK_GLADYSHEVO='skGladyshevo' # СК Гладышево
    SKEPTICS='skeptics' # СК Желтики
    MSK_87_SHMIDTOVSKY_DISTRICT_ZONE_7='msk87ShmidtovskyDistrictZone7' # МСК-87 (Шмидтовский район, зона 7)
    SK_LOCAL_NOVOUTKINSK='skLocalNovoutkinsk' # СК местная п.Новоуткинск
    MSK_DIVEYEVO_CHELATMA='mskDiveyevoChelatma' # МСК Дивеево (Челатьма)
    SK_HERPEGEZH='skHerpegezh' # СК с.п. Герпегеж
    MSK_OF_GLUSHKOVSKY_DISTRICT='mskOfGlushkovskyDistrict' # МСК Глушковского р-на
    MSK_87_SHMIDTOVSKY_DISTRICT_ZONE_6='msk87ShmidtovskyDistrictZone6' # МСК-87 (Шмидтовский район, зона 6)
    SK_LOCAL_G_DIR='skLocalGDir' # СК местная г.Реж
    USC_KRASNYE_BAKI_0050022='uscKrasnyeBaki0050022' # УСК Красные баки (0050022)
    USC_KRASNYE_BAKI_0050025='uscKrasnyeBaki0050025' # УСК Красные баки (0050025)
    USC_KRASNYE_BAKI_0050024='uscKrasnyeBaki0050024' # УСК Красные баки (0050024)
    SK_URAY='skUray' # СК г. Урай
    MSK_55_ZONE_1='msk55Zone1' # МСК-55, зона 1
    MSK_55_ZONE_2='msk55Zone2' # МСК-55, зона 2
    USC_KRASNYE_BAKI_0050021='uscKrasnyeBaki0050021' # УСК Красные баки (0050021)
    SK_KONDINSKY_DISTRICT_MORTKA='skKondinskyDistrictMortka' # СК кондинский район,Мортка
    USC_KRASNYE_BAKI_0050020='uscKrasnyeBaki0050020' # УСК Красные баки (0050020)
    SK_OF_CADASTRAL_DISTRICT_ZONE_284='skOfCadastralDistrictZone284' # СК кадастрового округа, зона 4
    ZELENOGRADSK_CITY='zelenogradskCity' # г.Зеленоградск
    SK_OF_CADASTRAL_DISTRICT_ZONE_285='skOfCadastralDistrictZone285' # СК кадастрового округа, зона 5
    SK_URAL='skUral' # СК Урал
    SK_OF_CADASTRAL_DISTRICT_ZONE_282='skOfCadastralDistrictZone282' # СК кадастрового округа, зона 2
    SK_OF_CADASTRAL_DISTRICT_ZONE_283='skOfCadastralDistrictZone283' # СК кадастрового округа, зона 3
    MSK_ONEGA='mskOnega' # МСК г.Онега
    MSK_881409_YURDYUK_KUMAKH='msk881409YurdyukKumakh' # МСК 88 14:09 Юрдюк-Кумах
    LOCAL_SK_KAMYSHIN='localSkKamyshin' # местная СК г. Камышин
    SK_CHEREPOVETS='skCherepovets' # СК г. Череповец
    MSK_881433_BERE='msk881433Bere' # МСК 88 14:33 Бере
    LOCAL_UGLICH='localUglich' # Местная г. Углич
    USC_KRASNYE_BAKI_0050019='uscKrasnyeBaki0050019' # УСК Красные баки (0050019)
    USC_KRASNYE_BAKI_0050016='uscKrasnyeBaki0050016' # УСК Красные баки (0050016)
    S_K_OF_THE_SVERDLOVSK_REGION_63_G='sKOfTheSverdlovskRegion63G' # С.К. Свердловской области (63 г)
    USC_KRASNYE_BAKI_0050015='uscKrasnyeBaki0050015' # УСК Красные баки (0050015)
    MSK_DIVEYEVO_YAKOVLEVKA='mskDiveyevoYakovlevka' # МСК Дивеево (Яковлевка)
    USC_KRASNYE_BAKI_0050018='uscKrasnyeBaki0050018' # УСК Красные баки (0050018)
    USC_KRASNYE_BAKI_0050017='uscKrasnyeBaki0050017' # УСК Красные баки (0050017)
    USC_KRASNYE_BAKI_0050030='uscKrasnyeBaki0050030' # УСК Красные баки (0050030)
    _7_213_OMUTINSKOE='7213Omutinskoe' # 7213 с.Омутинское
    _7_209_D_YERSHINA='7209DYershina' # 7209 д.Ершина
    SK_OZERNOVSKY='skOzernovsky' # СК.р.п.Озерновский
    LOCAL_RED='localRed' # Местная_п.Красное
    MSK_OF_GORSHECHENSKIY_DISTRICT='mskOfGorshechenskiyDistrict' # МСК Горшеченского р-на
    US_SOT_RODNIK_05='usSotRodnik05' # УС СОТ "Родник" 05
    SK_OF_CADASTRAL_DISTRICT_ZONE_281='skOfCadastralDistrictZone281' # СК кадастрового округа, зона 1
    US_PYALMA='usPyalma' # УС п.Пяльма
    MSK_OF_SEVERODVINSK='mskOfSeverodvinsk' # МСК г. Северодвинска
    USC_KRASNYE_BAKI_0050027='uscKrasnyeBaki0050027' # УСК Красные баки (0050027)
    USC_KRASNYE_BAKI_0050026='uscKrasnyeBaki0050026' # УСК Красные баки (0050026)
    USC_KRASNYE_BAKI_0050029='uscKrasnyeBaki0050029' # УСК Красные баки (0050029)
    USC_KRASNYE_BAKI_0050028='uscKrasnyeBaki0050028' # УСК Красные баки (0050028)
    LOCAL_SK_6440='localSk6440' # Местная СК 64_40
    SK_MST_CHASTOOZERSKY='skMstChastoozersky' # СК МСТ (Частоозерский)
    LOCAL_SK_6441='localSk6441' # Местная СК 64_41
    SK_NOVOZABORKA='skNovozaborka' # СК Новозаборка
    SK_BELOYARSK_DISTRICT_LYKHMA='skBeloyarskDistrictLykhma' # СК Белоярский район,Лыхма
    SK_VERKHNEYE='skVerkhneye' # СК Верхнее
    MOSCOW='moscow' # Московская
    SK_ZAIKOVO='skZaikovo' # СК Зайково
    _0_4_MSK_MEZHSELENKA='04MskMezhselenka' # 04 МСК Межселенка
    _7_209_D_BITYUKI='7209DBityuki' # 7209 д.Битюки
    SK_ANZHIGORT_SHURYSHKARSKY_DISTRI='skAnzhigortShuryshkarskyDistri' # СК д.Анжигорт (Шурышкарский район)
    SK_SHADRINSK='skShadrinsk' # СК г. Шадринск
    _7_222_D_VARVARA='7222DVarvara' # 7222 д.Варвара
    LOCAL_MIKHAILOVSKY_DISTRICT='localMikhailovskyDistrict' # Местная Михайловский район
    LOCAL_KINGISEPP='localKingisepp' # Местная (г.Кингисепп)
    LOCAL_S_NOVOOSTROPOL='localSNovoostropol' # Местная с.Новоострополь
    LOCAL_SK_6436='localSk6436' # Местная СК 64_36
    LOCAL_SK_6439='localSk6439' # Местная СК 64_39
    SK_LOCAL_ZARECHNY='skLocalZarechny' # СК местная г.Заречный
    MSK_42_KEMEROVO_REGION_ZONE_1='msk42KemerovoRegionZone1' # МСК 42 (Кемеровская область зона 1)
    LOCAL_SK_6434='localSk6434' # Местная СК 64_34
    MSK_42_KEMEROVO_REGION_ZONE_2='msk42KemerovoRegionZone2' # МСК 42 (Кемеровская область зона 2)
    LOCAL_SK_6435='localSk6435' # Местная СК 64_35
    USC_KRASNYE_BAKI_0050012='uscKrasnyeBaki0050012' # УСК Красные баки (0050012)
    USC_KRASNYE_BAKI_0050011='uscKrasnyeBaki0050011' # УСК Красные баки (0050011)
    CONDITIONAL_PETRUSHINA_GORA_VILLA='conditionalPetrushinaGoraVilla' # Условная (д.Петрушина Гора)
    LOCAL_VILLAGE_OF_MARKUCHI='localVillageOfMarkuchi' # Местная с.Маркучи
    USC_KRASNYE_BAKI_0050014='uscKrasnyeBaki0050014' # УСК Красные баки (0050014)
    USC_KRASNYE_BAKI_0050013='uscKrasnyeBaki0050013' # УСК Красные баки (0050013)
    USC_KRASNYE_BAKI_0050010='uscKrasnyeBaki0050010' # УСК Красные баки (0050010)
    _7_210_D_EKATERINOVKA='7210DEkaterinovka' # 7210 д.Екатериновка
    SK_MITKINA='skMitkina' # СК Митькина
    US_SOT_GAIA='usSotGaia' # УС СОТ "Гея"
    SK_KYZBURUN_1='skKyzburun1' # СК с.п. Кызбурун-1
    MSK_881432_ED='msk881432Ed' # МСК 88 14:32 Едяй
    MSK_DIVEYEVO_VLADIMIROVKA='mskDiveyevoVladimirovka' # МСК Дивеево (Владимировка)
    _7_201_BOLDYREVO='7201Boldyrevo' # 7201 с.Болдырево
    US_SOT_YAGODKA='usSotYagodka' # УС СОТ "Ягодка"
    _0_4_MSK_SLUDKA='04MskSludka' # 04 МСК Слудка
    SK_BEREZOVSKY_DISTRICT='skBerezovskyDistrict' # СК Березовски район
    SK_DOROZHNIK='skDorozhnik' # СК с.п. Дорожник
    SCRAPERS='scrapers' # СК Жидки
    SK_KAMINSKOE='skKaminskoe' # СК Каминское
    MSK_PARTIZANSK='mskPartizansk' # МСК Партизанск
    LOCAL_SK_6447='localSk6447' # Местная СК 64_47
    SK_SHCHUCHYE_PRIURALSKY_DISTRICT='skShchuchyePriuralskyDistrict' # СК Щучье (Приуральский район)
    _7_209_ISETSKY_DISTRICT='7209IsetskyDistrict' # 7209 - Исетский район
    LOCAL_SK_6449='localSk6449' # Местная СК 64_49
    SK_CHERNIGOVSKOE='skChernigovskoe' # СК с.п. Черниговское
    LOCAL_SK_6443='localSk6443' # Местная СК 64_43
    LOCAL_SK_6444='localSk6444' # Местная СК 64_44
    USC_KRASNYE_BAKI_0050007='uscKrasnyeBaki0050007' # УСК Красные баки (0050007)
    US_SOT_COUNCIL_2='usSotCouncil2' # УС СОТ "Совет-2"
    LOCAL_SK_6446='localSk6446' # Местная СК 64_46
    CONDITIONAL_D_NEW_KRUPELS='conditionalDNewKrupels' # Условная (д.Новые Крупели)
    SK_CHEGEM_2='skChegem2' # СК с.п. Чегем 2
    SK_MARTINO='skMartino' # СК Мартино
    TEYKOVO='teykovo' # Тейково
    LOCAL_SK_6420='localSk6420' # Местная СК 64_20
    SK_CHUMLYAK='skChumlyak' # СК Чумляк
    USK_24_NO_2_KRASNOYARSK='usk24No2Krasnoyarsk' # УСК-24, №2 (г.Красноярск)
    LOCAL_DZERZHINSK_AND_VOLODARSK='localDzerzhinskAndVolodarsk' # Местная Дзержинск и Володарск
    MSK_881419_ZOLOTINKA='msk881419Zolotinka' # МСК 88 14:19 Золотинка
    SK_BELONOGOVO='skBelonogovo' # СК Белоногово
    _7_206_VIKULOVO='7206Vikulovo' # 7206 с.Викулово
    SK_SEVERNOYE='skSevernoye' # СК Северное
    SK_MITINO='skMitino' # СК Митино
    SK_BABUSHKINSKY_DISTRICT='skBabushkinskyDistrict' # СК Бабушкинский район
    GSK_52_CONDITIONAL_SC='gsk52ConditionalSc' # ГСК 52 (условная СК)
    ZNAMENSK='znamensk' # Знаменск
    LOCAL_SK_6419='localSk6419' # Местная СК 64_19
    SK_UST_KUBINSKY_DISTRICT='skUstKubinskyDistrict' # СК Усть-Кубинский район
    LOCAL_SK_6414='localSk6414' # Местная СК 64_14
    MSK_OF_PONYROVSKY_DISTRICT='mskOfPonyrovskyDistrict' # МСК Поныровского р-на
    MSK_CHALNA_SETTLEMENT='mskChalnaSettlement' # МСК п.Чална
    MSK_NADEZHDINSKY_DISTRICT='mskNadezhdinskyDistrict' # МСК Надеждинский район
    US_SOT_VERKHOVYE_1='usSotVerkhovye1' # УС СОТ "Верховье-1"
    LOCAL_SK_6411='localSk6411' # Местная СК 64_11
    _7_219_P_UPOROVO='7219PUporovo' # 7219 с.Упорово
    MSK_MEDVEZHEGORSK='mskMedvezhegorsk' # МСК г.Медвежьегорск
    SK_MARAI='skMarai' # СК Марай
    SK_SOVETSKY_DISTRICT='skSovetskyDistrict' # СК Советский район
    US_PODPOROZHIE='usPodporozhie' # УС п.Подпорожье
    SK_PSYCH='skPsych' # СК с.п. Псычох
    MSK_OF_KHELYULYA_VILLAGE='mskOfKhelyulyaVillage' # МСК пгт.Хелюля
    SK_VERKHNEGLUBOKOE='skVerkhneglubokoe' # СК Верхнеглубокое
    SK_633_ZONE='sk633Zone' # СК 63 3 зона
    MSK_1416_AIKHAL='msk1416Aikhal' # МСК 14:16 Айхал
    SK_LOCAL_VERKHNYAYA_PYSHMA='skLocalVerkhnyayaPyshma' # СК местная г.Верхняя Пышма
    MSK_47_ZONE_3='msk47Zone3' # МСК 47 зона 3
    LOCAL_SK_6425='localSk6425' # Местная СК 64_25
    SK_BEREZOVSKY_DISTRICT_SARANPAUL='skBerezovskyDistrictSaranpaul' # СК Березовский район Саранпауль
    MSK_47_ZONE_2='msk47Zone2' # МСК 47 зона 2
    LOCAL_SK_6426='localSk6426' # Местная СК 64_26
    MSK_47_ZONE_1='msk47Zone1' # МСК 47 зона 1
    LOCAL_SK_6428='localSk6428' # Местная СК 64_28
    LOCAL_SK_6421='localSk6421' # Местная СК 64_21
    LOCAL_NOVAYA_LADOGA='localNovayaLadoga' # Местная (г. Новая Ладога)
    USK_24169='usk24169' # УСК-24, 169
    USK_24168='usk24168' # УСК-24, 168
    USK_24165='usk24165' # УСК-24, 165
    USK_24164='usk24164' # УСК-24, 164
    USK_24167='usk24167' # УСК-24, 167
    USK_24166='usk24166' # УСК-24, 166
    US_SOT_BERENDEY='usSotBerendey' # УС СОТ "Берендей"
    US_UPPER_VIDLITSA='usUpperVidlitsa' # УС д.Верхняя Видлица
    MSK_04_ZONE_1='msk04Zone1' # МСК-04, зона 1
    MSK_04_ZONE_2='msk04Zone2' # МСК-04, зона 2
    SK_MAISKOE='skMaiskoe' # СК Майское
    KHARASAVEY_IC_YAMAL_REGION='kharasaveyIcYamalRegion' # СК п.Харасавэй (Ямальский район)
    MSK_DIVEYEVO_SILINO='mskDiveyevoSilino' # МСК Дивеево (Силино)
    US_SOT_KOLOS_1011='usSotKolos1011' # УС СОТ "Колос" 10:11
    SK_KAMLYUKO='skKamlyuko' # СК с.п. Камлюко
    USK_VOSKRESENSK_0150012='uskVoskresensk0150012' # УСК Воскресенск (0150012)
    SK_69_ZONE_1_MSK_69_ZONE_1='sk69Zone1Msk69Zone1' # СК-69, зона 1 (МСК-69, зона 1)
    MSK_DIVEYEVO_DERNOVKA='mskDiveyevoDernovka' # МСК Дивеево (Дерновка)
    MSK_881409_JUNKYUR='msk881409Junkyur' # МСК 88 14:09 Юнкюр
    SK_KOKOREVO='skKokorevo' # СК Кокорево
    SK_CHEGEMTSUKO='skChegemtsuko' # СК с.п. Чегемцуко
    SK_EKIMOVA='skEkimova' # СК Екимова
    SK_ZAPOLYARNY_NADYMSKY_DISTRICT='skZapolyarnyNadymskyDistrict' # СК п.Заполярный (Надымский район)
    US_SOT_SIGNAL_1='usSotSignal1' # УС СОТ "Сигнал-1"
    MSK_38_ZONE_338='msk38Zone338' # МСК-38, зона 3
    LOCAL_SK_G_NIKOLAEVSK='localSkGNikolaevsk' # местная СК г Николаевск
    SK_BOGORODITSKOGO_KR='skBogoroditskogoKr' # СК Богородицкого КР
    _7_220_YURGINSKY_DISTRICT='7220YurginskyDistrict' # 7220 - Юргинский район
    MSK_881433_KYSTYK_KULDA='msk881433KystykKulda' # МСК 88 14:33 Кыстык-Кугда
    LOCAL_SK_6407='localSk6407' # Местная СК 64_07
    LOCAL_SK_6409='localSk6409' # Местная СК 64_09
    MSK_DIVEYEVO_SATIS='mskDiveyevoSatis' # МСК Дивеево (Сатис+)
    SK_KAZARKINO='skKazarkino' # СК Казаркино
    LOCAL_SK_6403='localSk6403' # Местная СК 64_03
    LOCAL_SK_6404='localSk6404' # Местная СК 64_04
    _1_2_MSK_WITHDRAW='12MskWithdraw' # 12 МСК Изъяю
    LOCAL_SK_6405='localSk6405' # Местная СК 64_05
    LOCAL_SK_6401='localSk6401' # Местная СК 64_01
    LOCAL_SK_6402='localSk6402' # Местная СК 64_02
    _7_210_D_ROLY_POLY='7210DRolyPoly' # 7210 д.Ваньковка
    USK_88170='usk88170' # УСК-88, 170
    MSK_881427_DAYA_AMGA='msk881427DayaAmga' # МСК 88 14:27 Дайа-Амга
    SK_OKTYABRSKOE_MAYSK='skOktyabrskoeMaysk' # СК с.п. Октябрьское (майск)
    US_SOT_ZARYA_1003='usSotZarya1003' # УС СОТ "Заря" 10:03
    _6_529_KURIL_SEA='6529KurilSea' # 6529 Курильский морской
    SLAVGOROD_CITY='slavgorodCity' # г. Славгород
    MSK_64_ZONE_3='msk64Zone3' # МСК-64, зона 3
    MSK_64_ZONE_2='msk64Zone2' # МСК-64, зона 2
    MSK_64_ZONE_1='msk64Zone1' # МСК-64, зона 1
    _7_210_D_BIG_ISLAND='7210DBigIsland' # 7210 д.Большой Остров
    MSK_SHAKHUNYA_SYAVA='mskShakhunyaSyava' # МСК Шахунья (Сява)
    USK_88168='usk88168' # УСК-88, 168
    USK_88169='usk88169' # УСК-88, 169
    CONDITIONAL_SK_VLADIVOSTOK_FORMER='conditionalSkVladivostokFormer' # Условная СК Владивосток (бывшая МСК)
    ALEYSK_CITY='aleyskCity' # г. Алейск
    MSK_881416_UDACHNY='msk881416Udachny' # МСК 88 14:16 Удачный
    US_KRIVTSY='usKrivtsy' # УС п.Кривцы
    US_SOT_GORNYAK_1003='usSotGornyak1003' # УС СОТ "Горняк" 10:03
    MSK_86_ZON_1='msk86Zon1' # МСК86_Зона_1
    PIONERSKOE_SPORTS_COMPLEX='pionerskoeSportsComplex' # СК Пионерское
    MSK_86_ZON_2='msk86Zon2' # МСК86_Зона_2
    MSK_86_ZON_3='msk86Zon3' # МСК86_Зона_3
    MSK_86_ZON_4='msk86Zon4' # МСК86_Зона_4
    USK_24_NO_44_ACHINSK='usk24No44Achinsk' # УСК-24, №44 (г.Ачинск)
    MSK_ARTEM='mskArtem' # МСК г. Артем
    MSK_14_ZONE_1='msk14Zone1' # МСК 14, зона 1
    US_MIYNALA='usMiynala' # УС д.Мийнала
    _7_219_P_INGALINSKOE='7219PIngalinskoe' # 7219 с.Ингалинcкое
    LOCAL_CITYTYNDA='localCitytynda' # Местная г.Тында
    SK_NEW_HAMIDIYE='skNewHamidiye' # СК с.п.Новое Хамидие
    SK_STEPNOYE='skStepnoye' # СК с.п. Степное
    SK_NEZHDESTVENNAYA='skNezhdestvennaya' # СК с.п. Приближная
    MSK_881428_DZHEBARIKI_KHAYA='msk881428DzhebarikiKhaya' # МСК 88 14:28 Джебарики-Хая
    _7_209_D_OSINOVA_STREET='7209DOsinovaStreet' # 7209 д.Осинова
    SK_VERKHNESUERSKOE='skVerkhnesuerskoe' # СК Верхнесуерское
    US_DUBROVO='usDubrovo' # УС д.Дуброво
    SK_MST_BELOZERSKY='skMstBelozersky' # СК МСТ (Белозерский)
    _7_217_P_SOZONOVO='7217PSozonovo' # 7217 с.Созоново
    LOCAL_ZEYSKY_DISTRICT='localZeyskyDistrict' # Местная Зейский район
    SK_KISHPEK='skKishpek' # СК с.п. Кишпек
    ARKHIPOVKA='arkhipovka' # Архиповка
    MSK_84_ZONE_10='msk84Zone10' # МСК-84, зона 10
    MSK_84_ZONE_11='msk84Zone11' # МСК-84, зона 11
    US_SOT_VICTORIA='usSotVictoria' # УС СОТ "Виктория"
    SK_LOCAL_NIZHNY_TAGIL='skLocalNizhnyTagil' # СК местная г.Нижний Тагил
    LOCAL_CK_6415='localCk6415' # Местная CK 64_15
    SK_KAMENKA='skKamenka' # СК с.п. Каменка
    LOCAL_CK_6413='localCk6413' # Местная CK 64_13
    _7_210_D_ZYRYANKA='7210DZyryanka' # 7210 д.Зырянка
    _1_0_SK_63_D_5='10Sk63D5' # 10 СК 63 D5
    MSK_KR_3314_RED_ECHO='mskKr3314RedEcho' # МСК КР 33:14 п. Красное Эхо
    SK_BEREZOVSKY_DISTRICT_PRIPOLARNY='skBerezovskyDistrictPripolarny' # СК Березовский район, Приполярный
    CONDITIONAL_VILLAGE_OF_SYRETS='conditionalVillageOfSyrets' # Условная (д.Сырец)
    SK_BAKSANSKY='skBaksansky' # СК с.п. Баксанский
    SK_SETOVNOYE='skSetovnoye' # СК Сетовное
    MSK_355_ZONE='msk355Zone' # МСК-35 5 зона
    MSK_881433_MYNDAGAI='msk881433Myndagai' # МСК 88 14:33 Мындагай
    SK_TAMBOVSKOE='skTambovskoe' # СК с.п. Тамбовское
    LOCAL_BELOGORSKY_DISTRICT='localBelogorskyDistrict' # Местная Белогорский район
    SK_CORNER='skCorner' # СК Угловая
    LOCAL_VILLAGE_OF_VOLGA='localVillageOfVolga' # Местная п. Волга
    MSK_KR_3308_VYAZNIKOVSKY_DISTRICT='mskKr3308VyaznikovskyDistrict' # МСК КР 33:08 Вязниковский район
    MSK_OF_THE_DISTRICT='mskOfTheDistrict' # МСК Округа
    US_SOT_DOROZHNIK='usSotDorozhnik' # УС СОТ "Дорожник"
    SK_NADEZHDA='skNadezhda' # СК Надежда
    SK_PROKHLADNY='skProkhladny' # СК г.п.Прохладный
    SK_MEDVEDSKOE='skMedvedskoe' # СК Медведское
    MSK_KR_3305_SUZDAL_DISTRICT='mskKr3305SuzdalDistrict' # МСК КР 33:05 Суздальский район
    SK_LOCAL_KACHKANAR='skLocalKachkanar' # СК местная г.Качканар
    MSK_RUTTU='mskRuttu' # МСК п.Рюттю
    US_SOT_USTYE='usSotUstye' # УС СОТ "Устье"
    SK_GVARDEYSKOE='skGvardeyskoe' # СК с.п. Гвардейское
    SK_YANIKOY='skYanikoy' # СК с.п. Яникой
    _7_217_P_TORINSKY_DISTRICT='7217PTorinskyDistrict' # 7217 п.Туринский
    _7_209_D_KIDS='7209DKids' # 7209 д.Малыши
    KALININGRAD='kaliningrad' # г.Калининград
    SK_631_ZONE='sk631Zone' # СК 63 1 зона
    MSK_881432_HOTOCHCHU='msk881432Hotochchu' # МСК 88 14:32 Хоточчу
    MSK_KR_3318_KOLCHUGINO='mskKr3318Kolchugino' # МСК КР 33:18 г. Кольчугино
    SK_OKTYABRSKY_N_NARYKARY='skOktyabrskyNNarykary' # СК Октябрьский Н_Нарыкары
    SK_LOCAL_VOLCHANSK='skLocalVolchansk' # СК местная г.Волчанск
    LOCAL_SEMENOV='localSemenov' # Местная Семенов
    US_0042001='us0042001' # УС 0042001
    MSK_881432_KYTYL_DURA='msk881432KytylDura' # МСК 88 14:32 Кытыл-Дюра
    SK_OF_CADASTRAL_DISTRICT_ZONE_631='skOfCadastralDistrictZone631' # СК кадастрового округа, зона 1
    SK_OF_CADASTRAL_DISTRICT_ZONE_632='skOfCadastralDistrictZone632' # СК кадастрового округа, зона 2
    LOCAL_KSTOVO='localKstovo' # Местная Кстово
    US_VODLA='usVodla' # УС п.Водла
    MSK_881416_ARYLAKH='msk881416Arylakh' # МСК 88 14:16 Арылах
    SK_PRIMALKINSKOE='skPrimalkinskoe' # СК с.п. Прималкинское
    POLESSKY_DISTRICT='polesskyDistrict' # Полесский район
    USK_24_NO_9_BORODINO='usk24No9Borodino' # УСК-24, № 9 ( г. Бородино)
    LOCAL_SK_BELEV='localSkBelev' # Местная СК г. Белев
    MSK_MIKHAILOVSKY_DISTRICT='mskMikhailovskyDistrict' # МСК Михайловский район
    _7_217_MO_ANDREEVSKOE='7217MoAndreevskoe' # 7217 МО Андреевское
    MSK_82_ZONE_3='msk82Zone3' # МСК-82, зона 3
    US_SOT_VETERAN='usSotVeteran' # УС СОТ "Ветеран"
    _7_217_D_HOMELAND='7217DHomeland' # 7217 д.Насекина
    CONDITIONAL_NEW='conditionalNew' # Условная (Новинка)
    SK_MALOKANOVSKOE='skMalokanovskoe' # СК с.п. Малокановское
    MSK_YAKOVLEVSKY_DISTRICT='mskYakovlevskyDistrict' # МСК Яковлевский район
    SK_LOCAL_PERVOURALSK='skLocalPervouralsk' # СК местная г.Первоуральск
    SK_MST_POLOVINSKY='skMstPolovinsky' # СК МСТ (Половинский)
    MSK_881419_BERKAKIT='msk881419Berkakit' # МСК 88 14:19 Беркакит
    MSK_881428_SITES='msk881428Sites' # МСК 88 14:28 Сайды
    MSK_82_ZONE_1='msk82Zone1' # МСК-82, зона 1
    MSK_82_ZONE_2='msk82Zone2' # МСК-82, зона 2
    SK_MAKUSHINO='skMakushino' # СК Макушино
    WGS_84_EPSG_4326='wgs84epsg4326' # WGS 84 (EPSG:4326)
    SK_KETOVSKY_DISTRICT='skKetovskyDistrict' # СК Кетовского района
    USC_KRASNYE_BAKI_0090063='uscKrasnyeBaki0090063' # УСК Красные баки (0090063)
    USC_KRASNYE_BAKI_0090064='uscKrasnyeBaki0090064' # УСК Красные баки (0090064)
    USC_KRASNYE_BAKI_0090061='uscKrasnyeBaki0090061' # УСК Красные баки (0090061)
    USC_KRASNYE_BAKI_0090060='uscKrasnyeBaki0090060' # УСК Красные баки (0090060)
    _7_210_D_BYKOVA_STREET='7210DBykovaStreet' # 7210 д.Быкова
    SK_TSENTRALNOYE='skTsentralnoye' # СК Центральное
    USC_KRASNYE_BAKI_0090059='uscKrasnyeBaki0090059' # УСК Красные баки (0090059)
    SK_SOLDATSKAYA='skSoldatskaya' # СК с.п. Солдатская
    MSK_881419_HANI='msk881419Hani' # МСК 88 14:19 Хани
    USC_KRASNYE_BAKI_0090056='uscKrasnyeBaki0090056' # УСК Красные баки (0090056)
    USC_KRASNYE_BAKI_0090055='uscKrasnyeBaki0090055' # УСК Красные баки (0090055)
    USC_KRASNYE_BAKI_0090058='uscKrasnyeBaki0090058' # УСК Красные баки (0090058)
    MSK_KR_3313_PETUSHINSKY_DISTRICT='mskKr3313PetushinskyDistrict' # МСК КР 33:13 Петушинский район
    _7_210_BUTUSOVO='7210Butusovo' # 7210 с.Бутусово
    SK_CHUSOVAYA='skChusovaya' # СК Чусовая
    _7_226_YALUTOROVSK='7226Yalutorovsk' # 7226 - г. Ялуторовск
    GSK_63='gsk63' # ГСК 63
    SK_SARMAKOVO='skSarmakovo' # СК с.п. Сармаково
    MSK_KR_3306_KAMESHKOVO='mskKr3306Kameshkovo' # МСК КР 33:06 г. Камешково
    _0_6_MSK_KORTKEROS='06MskKortkeros' # 06 МСК Корткерос
    SK_MST_KURTAMYSHSKY_63='skMstKurtamyshsky63' # СК МСТ (Куртамышский) - 63
    SK_MATVEEVSKY='skMatveevsky' # СК с.п. Матвеевский
    USC_KRASNYE_BAKI_0090076='uscKrasnyeBaki0090076' # УСК Красные баки (0090076)
    SK_LOCAL_LOBVA='skLocalLobva' # СК местная р.п.Лобва
    USC_KRASNYE_BAKI_0090075='uscKrasnyeBaki0090075' # УСК Красные баки (0090075)
    USC_KRASNYE_BAKI_0090070='uscKrasnyeBaki0090070' # УСК Красные баки (0090070)
    USK_24_SK_OF_THE_CADASTRAL_DISTRICT='usk24SkOfTheCadastralDistrict' # УСК-24, СК кадастрового округа
    USC_KRASNYE_BAKI_0090072='uscKrasnyeBaki0090072' # УСК Красные баки (0090072)
    USC_KRASNYE_BAKI_0090071='uscKrasnyeBaki0090071' # УСК Красные баки (0090071)
    MSK_881433_TUORA_KUEL='msk881433TuoraKuel' # МСК 88 14:33 Туора-Кюель
    _7_210_D_SOROCHKINA='7210DSorochkina' # 7210 д.Сорочкина
    LOCAL_SK_STAROOSKOLSKY='localSkStarooskolsky' # Местная СК Старооскольский
    _7_210_D_KUKARTSEVA='7210DKukartseva' # 7210 д.Кукарцева
    MSK_45_ZVERINOGOLOVSKY_DISTRICT='msk45ZverinogolovskyDistrict' # МСК-45 Звериноголовского района
    CONDITIONAL_05_DOBROVSKIY_DISTRIC='conditional05DobrovskiyDistric' # Условная (05 Добровский район)
    MSK_24_ZONE_7='msk24Zone7' # МСК-24, зона 7
    MSK_24_ZONE_3='msk24Zone3' # МСК-24, зона 3
    MSK_24_ZONE_4='msk24Zone4' # МСК-24, зона 4
    SK_MST_LEBYAZHEVSKY_DISTRICT='skMstLebyazhevskyDistrict' # СК МСТ (Лебяжьевский район)
    MSK_24_ZONE_5='msk24Zone5' # МСК-24, зона 5
    MSK_24_ZONE_6='msk24Zone6' # МСК-24, зона 6
    _7_217_D_MOLCHANOVA='7217DMolchanova' # 7217 д.Молчанова
    MSK_24_ZONE_1='msk24Zone1' # МСК-24, зона 1
    SK_AKSARKA_PRIURALSKY_DISTRICT='skAksarkaPriuralskyDistrict' # СК Аксарка (Приуральский район)
    MSK_24_ZONE_2='msk24Zone2' # МСК-24, зона 2
    CHERNAVSKOYE_SPORTS_COMPLEX='chernavskoyeSportsComplex' # СК Чернавское
    SK_VERKHNYAYA_ZHEMTALA='skVerkhnyayaZhemtala' # СК с.п. Верхняя Жемтала
    CONDITIONAL_18_CHAPLYGINSKY_DISTR='conditional18ChaplyginskyDistr' # Условная (18 Чаплыгинский район)
    USC_KRASNYE_BAKI_0090080='uscKrasnyeBaki0090080' # УСК Красные баки (0090080)
    _7_210_P_NOVOKOKOVSKY='7210PNovokokovsky' # 7210 п.Новокировский
    US_SOT_GURVICH='usSotGurvich' # УС СОТ "Гурвич"
    MSK_KR_3302_KIRZHACHSKY_DISTRICT='mskKr3302KirzhachskyDistrict' # МСК КР 33:02 Киржачский район
    MSK_D_NILMOGUBA='mskDNilmoguba' # МСК д.Нильмогуба
    SK_OBUKHOVO='skObukhovo' # СК Обухово
    USC_KRASNYE_BAKI_0090077='uscKrasnyeBaki0090077' # УСК Красные баки (0090077)
    _7_210_STREKHNINO='7210Strekhnino' # 7210 с.Стрехнино
    MSK_KR_3301_STRUNINO='mskKr3301Strunino' # МСК КР 33:01 г. Струнино
    SK_LEBYAZHYE_1='skLebyazhye1' # СК Лебяжье - 1
    SK_PIVKINO_S='skPivkinoS' # СК Пивкино (с.)
    _7_217_D_KONYASHINA='7217DKonyashina' # 7217 д.Коняшина
    MSK_881432_OKTEMTSY='msk881432Oktemtsy' # МСК 88 14:32 Октемцы
    SK_LUMEN='skLumen' # СК Просвет
    MSK_14='msk14' # МСК_14
    NYANDOMA_MSK='nyandomaMsk' # МСК г. Няндома
    SK_BALINSKOE='skBalinskoe' # СК Балинское
    MSK_16='msk16' # МСК_16
    LOCAL_IC_FROLOVO='localIcFrolovo' # местная СК г. Фролово
    SK_APACHE='skApache' # СК с.Апача
    LEZHNEVO='lezhnevo' # Лежнево
    SK_TOLKA_KRASNOSELKUPSKY_DISTRICT='skTolkaKrasnoselkupskyDistrict' # СК с.Толька (Красноселькупский район)
    SK_ZVERINOGOLOVSKY_DISTRICT='skZverinogolovskyDistrict' # СК Звериноголовского района
    _7_209_D_RESHETNIKOVA_STREET='7209DReshetnikovaStreet' # 7209 д.Решетникова
    SK_LOCAL_EASTERN='skLocalEastern' # СК местная п.Восточный
    LOCAL_SK_OF_THE_VILLAGE_OF_OLKHOVKA='localSkOfTheVillageOfOlkhovka' # местная СК с. Ольховка
    MSK_D_SHUYA_CHUPA='mskDShuyaChupa' # МСК д.Шуйская Чупа
    USC_DRUZHBA='uscDruzhba' # УСК Дружба
    MSK_OF_SHCHIGROVSKY_DISTRICT='mskOfShchigrovskyDistrict' # МСК Щигровского р-на
    TOTEMSKY_DISTRICT_SPORTS_COMPLEX='totemskyDistrictSportsComplex' # СК Тотемский район
    MSK_881416_TAAS_YURYAKH='msk881416TaasYuryakh' # МСК 88 14:16 Таас-Юрях
    USK_24_NO_18_NAZAROVO='usk24No18Nazarovo' # УСК-24, № 18 (г. Назарово)
    SK_OKONECHNIKOVA='skOkonechnikova' # СК Оконечникова
    US_KAMENNY_BOR='usKamennyBor' # УС д.Каменный Бор
    MSK_08='msk08' # МСК_08
    MSK_07='msk07' # МСК острова 07
    US_SOT_BERYOZKA='usSotBeryozka' # УС СОТ "Березка"
    MSK_03='msk03' # МСК_03
    MSK_06='msk06' # МСК-06
    MSK_05='msk05' # МСК-05
    SK_CHUGA_ART='skChugaArt' # СК Чуга (ст.)
    SK_VODOLAZOVO='skVodolazovo' # СК Водолазово
    MSK_TOMARI='mskTomari' # МСК г. Томари
    _7_216_D_ACHIRS='7216DAchirs' # 7216 д.Ачиры
    MSK_27_ZONE_5='msk27Zone5' # МСК-27 зона 5
    MSK_27_ZONE_4='msk27Zone4' # МСК-27 зона 4
    MSK_27_ZONE_3='msk27Zone3' # МСК-27 зона 3
    MSK_27_ZONE_2='msk27Zone2' # МСК-27 зона 2
    MSK_881433_WOOSUNG_KYUL='msk881433WoosungKyul' # МСК 88 14:33 Усун-Кюель
    _7_215_D_ANCIENT_SETTLEMENT='7215DAncientSettlement' # 7215 д.Городище
    MSK_D_KOSALMA='mskDKosalma' # МСК д.Косалма
    MUSTACHIOED_LIP='mustachioedLip' # УС Сенная губа
    MSK_881409_VERKHOYANSK_2='msk881409Verkhoyansk2' # МСК 88 14:09 Верхоянск2
    MSK_881432_KYTANAKH_KYRDAL='msk881432KytanakhKyrdal' # МСК 88 14:32 Кытанах-Кырдал
    MSK_OLGINSKY_DISTRICT='mskOlginskyDistrict' # МСК Ольгинский район
    MSK_881409_VERKHOYANSK_1='msk881409Verkhoyansk1' # МСК 88 14:09 Верхоянск1
    _7_222_SHCHETKOVO_VILLAGE='7222ShchetkovoVillage' # 7222 с.Щетково
    MSK_39='msk39' # МСК39
    SK_BELOYARSK_DISTRICT_NUMTO='skBeloyarskDistrictNumto' # СК Белоярский район, Нумто
    MSK_881430_BELKACHI='msk881430Belkachi' # МСК 88 14:30 Белькачи
    USK_1710='usk1710' # УСК-1710
    SK_SARSKY='skSarsky' # СК с.п. Сарский
    US_SOT_METALLURG='usSotMetallurg' # УС СОТ "Металлург"
    _7_209_ISETSKOE_LAKE='7209IsetskoeLake' # 7209 с.Исетское
    SK_ZHEMTALA='skZhemtala' # СК с.п. Жемтала
    CITY_OF_SOVETSK='cityOfSovetsk' # г. Советск
    SK_VODNY='skVodny' # СК Водный
    SK_SOVETSKOE='skSovetskoe' # СК Советское
    SK_KAMAGAN='skKamagan' # СК Камаган
    MSK_IN_UGLEGORSK='mskInUglegorsk' # МСК г. Углегорска
    MSK_OF_SUDZHANSKY_DISTRICT='mskOfSudzhanskyDistrict' # МСК Суджанского р-на
    USC_FOR_THE_REPUBLIC_OF_KARELIA='uscForTheRepublicOfKarelia' # УСК по Республике Карелия
    MSK_20='msk20' # МСК20
    MSK_KHOMUTOVSKY_DISTRICT='mskKhomutovskyDistrict' # МСК Хомутовского р-на
    CONDITIONAL_COORDINATE_SYSTEM='conditionalCoordinateSystem' # Условная система координат
    MSK_26='msk26' # МСК_26
    MSK_25='msk25' # МСК_25
    SK_MST_MAKUSHINSKY='skMstMakushinsky' # СК МСТ (Макушинский)
    SK_LANGEPAS='skLangepas' # СК г. Лангепас
    SK_MOKROUSOVSKY_DISTRICT='skMokrousovskyDistrict' # СК Мокроусовского района
    MSK_27='msk27' # МСК_27
    SK_LOCAL_VERKHNY_TAGIL='skLocalVerkhnyTagil' # СК местная г.Верхний Тагил
    MSK_KIZHI_ISLAND='mskKizhiIsland' # МСК о.Кижи
    SK_KOTLYAREVSKAYA='skKotlyarevskaya' # СК с.п. Котляревкая
    USK_1708='usk1708' # УСК-1708
    SK_PSYNSHOKO='skPsynshoko' # СК с.п. Псыншоко
    CONDITIONAL_11_LEBEDYANSKY_DISTRI='conditional11LebedyanskyDistri' # Условная (11 Лебедянский район)
    MSK_881428_FORK='msk881428Fork' # МСК 88 14:28 Развилка
    _0_9_MSK_REGIONAL='09MskRegional' # 09 МСК Районная
    _7_222_POKROVSKOE_LAKE='7222PokrovskoeLake' # 7222 с.Покровское
    MSK_51='msk51' # МСК-51
    SK_TYUMENTSEVA='skTyumentseva' # СК Тюменцева
    RUBTSOVSK_CITY='rubtsovskCity' # г. Рубцовск
    MSK_KR_3325_GUS_KHRUSTALNY='mskKr3325GusKhrustalny' # МСК КР 33:25 г. Гусь-Хрустальный
    SK_OF_THE_KATAYSKY_DISTRICT='skOfTheKatayskyDistrict' # СК Катайского района
    MSK_S_VESHKELITSA='mskSVeshkelitsa' # МСК с.Вешкелица
    MSK_BOLSHOY_KAMEN='mskBolshoyKamen' # МСК Большой Камень
    US_RAIGUBA='usRaiguba' # УС п.Райгуба
    SK_PRIOZERNY_NADYMSKY_DISTRICT='skPriozernyNadymskyDistrict' # СК п.Приозерный (Надымский район)
    MSK_SHUYA='mskShuya' # МСК п.Шуя
    MSK_45_SHCHUCHANSKY_DISTRICT='msk45ShchuchanskyDistrict' # МСК-45 Щучанского района
    MSK_KR_3310_SELIVANOVSKY_DISTRICT='mskKr3310SelivanovskyDistrict' # МСК КР 33:10 Селивановский район
    PUCHEZH='puchezh' # Пучеж
    MSK_881432_KACHIKATTSY='msk881432Kachikattsy' # МСК 88 14:32 Качикатцы
    SK_SHALUSHKA='skShalushka' # СК с.п. Шалушка
    MSK_46='msk46' # МСК-46
    MSK_45='msk45' # МСК-45
    SK_SHOVELS='skShovels' # СК Лопатки
    MSK_42='msk42' # МСК-42
    MSK_LGOVSKY_DISTRICT='mskLgovskyDistrict' # МСК Льговского р-на
    LOCAL_NIZHNY_NOVGOROD_REGION='localNizhnyNovgorodRegion' # Местная Нижегородская
    US_SOT_MOTOR='usSotMotor' # УС СОТ "Мотор"
    _7_210_CHEREMSHANKA='7210Cheremshanka' # 7210 с.Черемшанка
    _7_209_P_KIROVSKY_DISTRICT='7209PKirovskyDistrict' # 7209 п.Кировский
    US_SOT_SALYUT_4='usSotSalyut4' # УС СОТ "Салют4"
    MSK_881430_TUMUL='msk881430Tumul' # МСК 88 14:30 Тумул
    US_KOCHKOMA='usKochkoma' # УС п.Кочкома
    LOCAL_IVANGOROD='localIvangorod' # Mестная (г. Ивангород)
    TALITSY='talitsy' # Талицы
    _7_217_P_MULLASHI='7217PMullashi' # 7217 с.Муллаши
    SK_TEREKSKOE='skTerekskoe' # СК с.п.Терекское
    _7_218_P_NAGORNY='7218PNagorny' # 7218 п.Нагорный
    _7_210_D_SINITSYNA='7210DSinitsyna' # 7210 д.Синицына
    MSK_75='msk75' # МСК 75
    _7_223_ITEMS_LITTLE_TARASCUL='7223ItemsLittleTarascul' # 7223 п.Малый Тараскуль
    SC_ZARECHYE='scZarechye' # СК Заречье
    _7_210_D_KAZANKA='7210DKazanka' # 7210 д.Казанка
    SK_OLD_NADYM_NADYM_DISTRICT='skOldNadymNadymDistrict' # СК п.Старый Надым (Надымский район)
    US_LAHKOLAMPI='usLahkolampi' # УС п.Лахколампи
    SK_OBUTKOVSKOE='skObutkovskoe' # СК Обутковское
    US_SOT_GEOLOGIST='usSotGeologist' # УС СОТ "Геолог"
    SK_BOLSHOY_ZAPOLOY='skBolshoyZapoloy' # СК Большой Заполой
    US_SOT_RYZHIK='usSotRyzhik' # УС СОТ "Рыжик"
    SK_KADUY='skKaduy' # СК п. Кадуй
    SK_UNSELGORT_SHURYSHKARSKY_DISTRI='skUnselgortShuryshkarskyDistri' # СК д.Унсельгорт (Шурышкарский район)
    MSK_PAVLOVO_VORSMA='mskPavlovoVorsma' # МСК Павлово (Ворсма)
    MSK_881428_AIRPORT='msk881428Airport' # МСК 88 14:28 Аэропорт
    _7_216_SDT_HEALTH='7216SdtHealth' # 7216 сдт.Здоровье
    MSK_66='msk66' # МСК - 66
    US_SUMY_POSAD='usSumyPosad' # УС с.Сумский Посад
    _7_216_SDT_BUILDER='7216SdtBuilder' # 7216 сдт.Строитель
    MSK_67='msk67' # МСК_67
    SK_VERKHNY_AKBASH='skVerkhnyAkbash' # СК с.п. Верхний Акбаш
    MSK_64='msk64' # мск 64
    MSK_881402_UGOYAN='msk881402Ugoyan' # МСК 88 14:02 Угоян
    _7_209_RAFAILOVO='7209Rafailovo' # 7209 с.Рафайлово
    SLAVSK_CITY='slavskCity' # г. Славск
    US_ALECKA='usAlecka' # УС д.Алекка
    CONDITIONAL_15_TERBUNSKY_DISTRICT='conditional15TerbunskyDistrict' # Условная (15 Тербунский район)
    MSK_OF_THE_PRIESTENSKY_DISTRICT='mskOfThePriestenskyDistrict' # МСК Пристенского р-на
    LOCAL_VILLAGE_OF_KLENNO='localVillageOfKlenno' # Местная (д.Клённо)
    LOCAL_REPAIRS='localRepairs' # Местная Починки
    SLAVSKY_DISTRICT='slavskyDistrict' # Славский район
    MSK_881432_CHARANG='msk881432Charang' # МСК 88 14:32 Чаранг
    US_PESCHANOE='usPeschanoe' # УС д.Песчаное
    SK_ALTUD='skAltud' # СК с.п. Алтуд
    SK_GORKI_SHURYSHKARSKY_DISTRICT='skGorkiShuryshkarskyDistrict' # СК с.Горки (Шурышкарский район)
    SK_OKTYABRSKY_DISTRICT_SERGINO_PB='skOktyabrskyDistrictSerginoPb' # СК Октябрьский район Сергино ПБ
    LOCAL_PIKALEVO='localPikalevo' # Местная (г. Пикалево)
    CONDITIONAL_ZAMOSTYE='conditionalZamostye' # Условная (Замостье)
    SK_MASLI_GREEN_GROVE='skMasliGreenGrove' # СК Масли, Зеленая Роща
    SK_LAPUSHKI='skLapushki' # СК Лапушки
    CONDITIONAL_08_ZADONSKY_DISTRICT='conditional08ZadonskyDistrict' # Условная (08 Задонский район)
    MSK_SOSNOVETS='mskSosnovets' # МСК п.Сосновец
    US_0073201='us0073201' # УС 0073201
    MSK_ANUCHINSKY_DISTRICT='mskAnuchinskyDistrict' # МСК Анучинский район
    _7_210_P_CHILDREN_S_HOME_NO_29='7210PChildrenSHomeNo29' # 7210 п.Детский Дом №29
    _7_216_SDT_MOSTOVIK='7216SdtMostovik' # 7216 сдт.Мостовик
    PRAVDINSKY_DISTRICT='pravdinskyDistrict' # Правдинский район
    MSK_83='msk83' # МСК-83
    SK_LOCAL_NIZHNYAYA_TURA='skLocalNizhnyayaTura' # СК местная г.Нижняя Тура
    SK_BOROVSKOE='skBorovskoe' # СК Боровское
    MSK_881433_TOLON='msk881433Tolon' # МСК 88 14:33 Толон
    MSK_351_ZONE='msk351Zone' # МСК-35 1 зона
    SK_KOROVYE='skKorovye' # СК Коровье
    US_SOT_OSTROV='usSotOstrov' # УС СОТ "Остров"
    SK_CHIMEYEVO='skChimeyevo' # СК Чимеево
    GSK_2011_EPSG_7681='gsk2011Epsg7681' # GSK-2011 (EPSG:7681)
    MSK_KHASANSKY_DISTRICT='mskKhasanskyDistrict' # МСК Хасанский район
    MSK_881402_LENINSKY='msk881402Leninsky' # МСК 88 14:02 Ленинский
    SK_PROLETARSKOE='skProletarskoe' # СК с.п. Пролетарское
    US_TULOKSA_ESTUARY='usTuloksaEstuary' # УС д.Устье Тулоксы
    SK_NYAGAN_SQLBASE='skNyaganSqlbase' # СК Нягань SQLBase
    BAGRATIONOVSK='bagrationovsk' # Багратионовск
    SC_RECHNOYE='scRechnoye' # СК Речное
    SK_NARTAN='skNartan' # СК с.п. Нартан
    MSK_FOR_YAKUTSK='mskForYakutsk' # МСК для г.Якутска
    SK_CHASHINSKY='skChashinsky' # СК Чашинский
    SK_NIZHNEYE='skNizhneye' # СК Нижнее
    _7_211_KAZANSKY_DISTRICT='7211KazanskyDistrict' # 7211 - Казанский район
    _7_209_MININO='7209Minino' # 7209 с.Минино
    SK_LOCAL_KRASNOTURINSK='skLocalKrasnoturinsk' # СК местная г.Краснотурьинск
    US_SOT_GREEN_CAPE='usSotGreenCape' # УС СОТ "Зеленый мыс"
    MSK_GOLDIE='mskGoldie' # МСК п.Золотец
    SK_CHEREMISSKOE='skCheremisskoe' # СК Черемисское
    LOCAL_S_TYGDA='localSTygda' # Местная с.Тыгда
    SK_NAKHODKA_TAZOVSKY_DISTRICT='skNakhodkaTazovskyDistrict' # ск п.Находка (Тазовский район)
    _7_209_UPPER_INGAL='7209UpperIngal' # 7209 с.Верхний Ингал
    _7_209_D_TURUSHEVO='7209DTurushevo' # 7209 д.Турушево
    SK_LOCAL_BILIMBAY='skLocalBilimbay' # СК местная п.Билимбай
    SK_KARPUNINO='skKarpunino' # СК Карпунино
    USK_SHAGONAR='uskShagonar' # УСК Шагонар
    CONDITIONAL_VILLAGE_OF_LYASHOZERO='conditionalVillageOfLyashozero' # Условная (д.Ляшозеро)
    MSK_KR_3304_YURIEV_POLSKY_DISTRICT='mskKr3304YurievPolskyDistrict' # МСК КР 33:04 Юрьев-Польский район
    USC_KRASNYE_BAKI_0030010='uscKrasnyeBaki0030010' # УСК Красные баки (0030010)
    SK_32_ZONE_1='sk32Zone1' # СК 32, зона 1
    USC_KRASNYE_BAKI_0030011='uscKrasnyeBaki0030011' # УСК Красные баки (0030011)
    SK_32_ZONE_2='sk32Zone2' # СК 32, зона 2
    SK_LOBANOVO='skLobanovo' # СК Лобаново
    USC_1414020017='usc1414020017' # УСК 14:14:020017
    LACKEY='lackey' # Холуй
    MSK_S_SNIFFER='mskSSniffer' # МСК с.Нюхча
    CHERNYAKHOVSKY_DISTRICT='chernyakhovskyDistrict' # Черняховский район
    MSK_KR_3317_ALEXANDROV='mskKr3317Alexandrov' # МСК КР 33:17 г. Александров
    SK_BABUGENT='skBabugent' # СК с.п. Бабугент
    USK_84169='usk84169' # УСК-84, 169
    SK_161='sk161' # СК 161
    USK_84166='usk84166' # УСК-84, 166
    USK_84167='usk84167' # УСК-84, 167
    _7_210_PROKUTKINO='7210Prokutkino' # 7210 с.Прокуткино
    SK_OKTYABRSKY_DISTRICT_SHERKALY_PB='skOktyabrskyDistrictSherkalyPb' # СК Октябрьский район, Шеркалы пб
    SK_ZALUKOKO='skZalukoko' # СК с.п. Залукокоаже
    USK_84164='usk84164' # УСК-84, 164
    USK_84165='usk84165' # УСК-84, 165
    USK_84163='usk84163' # УСК-84, 163
    MSK_OF_KORSAKOV='mskOfKorsakov' # МСК г. Корсакова
    SK_OBRYADOVKA='skObryadovka' # СК Обрядовка
    SK_BELOYARSK_DISTRICT_POLNOVAT='skBeloyarskDistrictPolnovat' # СК Белоярский район, Полноват
    _7_209_D_MIROLYUBOVA='7209DMirolyubova' # 7209 д.Миролюбова
    SK_KUBA='skKuba' # СК с.п. Куба
    MSK_881437_MIRNY='msk881437Mirny' # МСК 88 14:37 Мирный
    SK_PSYKHUREI='skPsykhurei' # СК с.п. Псыхурей
    SK_NIKITINSKOE='skNikitinskoe' # СК Никитинское
    SK_CHUGA='skChuga' # СК Чуга
    USK_84171='usk84171' # УСК-84, 171
    USK_57_OREL_CITY='usk57OrelCity' # УСК-57, город Орел
    SK_YUBILEYNY_SETTLEMENT='skYubileynySettlement' # СК п. Юбилейный
    USK_84170='usk84170' # УСК-84, 170
    US_0072301='us0072301' # УС 0072301
    SK_OF_THE_PRITOBOLNY_DISTRICT='skOfThePritobolnyDistrict' # СК Притобольного района
    MSK_CHUGUEVSKY_DISTRICT='mskChuguevskyDistrict' # МСК Чугуевский район
    MSK_SOLOVETSKY='mskSolovetsky' # МСК п. Соловецкий
    US_SOT_NAMOEVO='usSotNamoevo' # УС СОТ "Намоево"
    US_SOT_RADUZHNYY_1='usSotRaduzhnyy1' # УС СОТ "Радужный1"
    _7_214_P_SLADKOVO='7214PSladkovo' # 7214 с.Сладково
    CONDITIONAL_SABERO_VILLAGE='conditionalSaberoVillage' # Условная (д.Сяберо)
    US_SOT_RADUZHNYY_3='usSotRaduzhnyy3' # УС СОТ "Радужный3"
    SK_VERKHNEKLYUCHEVSKOE='skVerkhneklyuchevskoe' # СК Верхнеключевское
    CONDITIONAL_DOMKINO_VILLAGE='conditionalDomkinoVillage' # Условная (д.Домкино)
    US_SOT_RADUZHNYY_2='usSotRaduzhnyy2' # УС СОТ "Радужный2"
    USK_24_ERRONEOUS='usk24Erroneous' # УСК-24, (ошибочная)
    _7_216_SDT_RAILWAYMAN_1='7216SdtRailwayman1' # 7216 сдт.Железнодорожник-1
    US_SOT_LAGNOZERSKY='usSotLagnozersky' # УС СОТ "Лагнозерский"
    MSK_DIVEYEVO_LIPOVKA='mskDiveyevoLipovka' # МСК Дивеево (Липовка)
    US_SOT_KOMMUNALNIK_2='usSotKommunalnik2' # УС СОТ "Коммунальник2"
    _7_210_D_PAKHOMOVA_STREET='7210DPakhomovaStreet' # 7210 д.Пахомова
    US_SOT_KOMMUNALNIK_1='usSotKommunalnik1' # УС СОТ "Коммунальник1"
    SK_ZAKOULOVO='skZakoulovo' # СК Закоулово
    LOCAL_VOLOSOVO='localVolosovo' # Местная (г. Волосово)
    MSK_881432_BESTYAKH='msk881432Bestyakh' # МСК 88 14:32 Бестях
    SK_OPYTNOYE='skOpytnoye' # СК с.п.Опытное
    MSK_D_NAPE='mskDNape' # МСК д.Зашеек
    US_SOT_ANTENNA='usSotAntenna' # УС СОТ "Антенна"
    MSK_84_ZONE_3='msk84Zone3' # МСК-84, зона 3
    MSK_84_ZONE_4='msk84Zone4' # МСК-84, зона 4
    MSK_84_ZONE_1='msk84Zone1' # МСК-84, зона 1
    MSK_84_ZONE_2='msk84Zone2' # МСК-84, зона 2
    PESYANOE_SPORTS_COMPLEX_LEBYAZHEV='pesyanoeSportsComplexLebyazhev' # СК Песьяное (Лебяжьевский район)
    MSK_84_ZONE_7='msk84Zone7' # МСК-84, зона 7
    SK_SOVKHOZNOYE='skSovkhoznoye' # СК с.п. Совхозное
    MSK_84_ZONE_8='msk84Zone8' # МСК-84, зона 8
    MSK_84_ZONE_5='msk84Zone5' # МСК-84, зона 5
    MSK_84_ZONE_6='msk84Zone6' # МСК-84, зона 6
    CONDITIONAL_KOLODNO_VILLAGE='conditionalKolodnoVillage' # Условная (д.Колодно)
    MSK_84_ZONE_9='msk84Zone9' # МСК-84, зона 9
    SK_VVEDENSKOE_MISHKINSIKY='skVvedenskoeMishkinsiky' # СК Введенское (Мишкинсикй)
    SK_OF_CADASTRAL_DISTRICT_ZONE_182='skOfCadastralDistrictZone182' # СК кадастрового округа, зона 2
    MSK_87_ANADYRSKY_DISTRICT_ZONE_5='msk87AnadyrskyDistrictZone5' # МСК-87 (Анадырский район, зона 5)
    MSK_KHOROLSKY_DISTRICT='mskKhorolskyDistrict' # МСК Хорольский район
    SK_YAROVOYE='skYarovoye' # СК Яровое
    LOCAL_VILLAGE_WUSHUMUN='localVillageWushumun' # Местная пгт.Ушумун
    SK_TYRNYAUZ='skTyrnyauz' # СК г.п.Тырныауз
    _7_218_P_ASPEN_TREE='7218PAspenTree' # 7218 с.Осинник
    MSK_OF_THE_VILLAGE_THE_PINDUSHIS='mskOfTheVillageThePindushis' # МСК пгт.Пиндуши
    US_SOT_PRIGORODNY='usSotPrigorodny' # УС СОТ "Пригородный"
    SK_OF_CADASTRAL_DISTRICT_ZONE_163='skOfCadastralDistrictZone163' # СК кадастрового округа, зона 3
    MSK_TONSHAYEVO_TONSHAYEVO='mskTonshayevoTonshayevo' # МСК Тоншаево (Тоншаево)
    USK_34_SK_63_TRUNCATED_ZONE_2='usk34Sk63TruncatedZone2' # УСК-34, СК 63 усеч зона 2
    SK_OF_CADASTRAL_DISTRICT_ZONE_161='skOfCadastralDistrictZone161' # СК кадастрового округа, зона 1
    _7_211_KAZANSKOE='7211Kazanskoe' # 7211 с.Казанское
    USK_34_SK_63_TRUNCATED_ZONE_1='usk34Sk63TruncatedZone1' # УСК-34, СК 63 усеч зона 1
    SK_OF_CADASTRAL_DISTRICT_ZONE_162='skOfCadastralDistrictZone162' # СК кадастрового округа, зона 2
    OLD_LOCAL_2619='oldLocal2619' # Старая Местная_2619
    OLD_LOCAL_2617='oldLocal2617' # Старая Местная_2617
    OLD_LOCAL_2618='oldLocal2618' # Старая Местная_2618
    LOCAL_GAVRILOV_YAM='localGavrilovYam' # Местная г. Гаврилов-Ям
    OLD_LOCAL_2615='oldLocal2615' # Старая Местная_2615
    SK_CHERNAVCHIK='skChernavchik' # СК Чернавчик
    SK_SOVETSKY_DISTRICT_YUBILEYNY='skSovetskyDistrictYubileyny' # СК Советский район, Юбилейный
    CONDITIONAL_14_STANOVLYANSKY_DIST='conditional14StanovlyanskyDist' # Условная (14 Становлянский район)
    OLD_LOCAL_2616='oldLocal2616' # Старая Местная_2616
    MSK_KR_3304_YURIEV_POLSKY='mskKr3304YurievPolsky' # МСК КР 33:04 г. Юрьев-Польский
    OLD_LOCAL_2613='oldLocal2613' # Старая Местная_2613
    OLD_LOCAL_2614='oldLocal2614' # Старая Местная_2614
    OLD_LOCAL_2611='oldLocal2611' # Старая Местная_2611
    _4_107_SHIFT='4107Shift' # 4107 сдвиг
    OLD_LOCAL_2612='oldLocal2612' # Старая Местная_2612
    SK_ARLAGUL='skArlagul' # СК Арлагуль
    OLD_LOCAL_2610='oldLocal2610' # Старая Местная_2610
    CONDITIONAL_CHUKA='conditionalChuka' # Условная (д.Чука)
    MSK_HARLU='mskHarlu' # МСК п.Харлу
    MSK_OF_CHEREMISINOVSKY_DISTRICT='mskOfCheremisinovskyDistrict' # МСК Черемисиновского р-на
    SK_BELOYARSK_DISTRICT='skBeloyarskDistrict' # СК Белоярский район
    MSK_881402_KUTANA='msk881402Kutana' # МСК 88 14:02 Кутана
    MSK_87_BILIBINSKY_DISTRICT_ZONE_4='msk87BilibinskyDistrictZone4' # МСК-87 (Билибинский район, зона 4)
    OLD_LOCAL_2609='oldLocal2609' # Старая Местная_2609
    OLD_LOCAL_2606='oldLocal2606' # Старая Местная_2606
    OLD_LOCAL_2607='oldLocal2607' # Старая Местная_2607
    OLD_LOCAL_2604='oldLocal2604' # Старая Местная_2604
    OLD_LOCAL_2605='oldLocal2605' # Старая Местная_2605
    LOCAL_PERVOMAISKAYA_STREET='localPervomaiskayaStreet' # Местная Первомайская
    OLD_LOCAL_2601='oldLocal2601' # Старая Местная_2601
    OLD_MSK_26='oldMsk26' # старая МСК 26
    SK_CHISTOLEBYAZHYE='skChistolebyazhye' # СК Чистолебяжье
    SK_PRITCHINO='skPritchino' # СК Притчино
    MSK_KR_3320_KOVROV='mskKr3320Kovrov' # МСК КР 33:20 г. Ковров
    US_SOT_YUZHNY='usSotYuzhny' # УС СОТ "Южный"
    MSK_KR_3312_STAVROVO='mskKr3312 Stavrovo' # МСК КР 33:12 п. Ставрово
    LOCAL_SLANTSEVSKY_DISTRICT='localSlantsevskyDistrict' # Местная (Сланцевский район)
    IC_YASNOGORSKY_KR='icYasnogorskyKr' # СК Ясногорского КР
    US_SOT_ROMANTIC='usSotRomantic' # УС СОТ "Романтик"
    SK_GUNDELEN='skGundelen' # СК с.п. Гунделен
    MSK_881427_DEBDIRGE='msk881427Debdirge' # МСК 88 14:27 Дэбдиргэ
    MSK_75_ZONE_1='msk75Zone1' # МСК-75, зона 1
    MSK_75_ZONE_2='msk75Zone2' # МСК-75, зона 2
    MSK_881430_SUNNY='msk881430Sunny' # МСК 88 14:30 Солнечный
    MSK_75_ZONE_4='msk75Zone4' # МСК-75, зона 4
    _7_217_MO_NOVOTARMANSKOE='7217MoNovotarmanskoe' # 7217 МО Новотарманское
    SK_LOCAL_KIROVGRAD='skLocalKirovgrad' # СК местная г.Кировград
    LOCAL_DIVEYEVO='localDiveyevo' # Местная Дивеево
    LOCAL_TSIOLKOVSKY_CITY='localTsiolkovskyCity' # Местная г.Циолковский
    SK_BAKSANENOK='skBaksanenok' # СК с.п. Баксаненок
    MSK_SHAKHUNYA_VAKHTAN='mskShakhunyaVakhtan' # МСК Шахунья (Вахтан)
    SVETLY_DOL_SKI_AREA='svetlyDolSkiArea' # СК Светлый Дол
    OLD_LOCAL_2627_CITY='oldLocal2627City' # Старая Местная_2627_город
    SK_BOROVSKOE_KATAISKY='skBorovskoeKataisky' # СК Боровское (Катайский)
    SK_LOCAL_IRBIT='skLocalIrbit' # СК местная г.Ирбит
    _7_209_SHOROKHOVO='7209Shorokhovo' # 7209 с.Шорохово
    SK_LABOR_AND_KNOWLEDGE='skLaborAndKnowledge' # СК Труд и Знание
    _7_213_VAGAY='7213Vagay' # 7213 с.Вагай
    SK_69_ZONE_3_MSK_69_ZONE_3='sk69Zone3Msk69Zone3' # СК-69, зона 3 (МСК-69, зона 3)
    MO_LABYTNANGI='moLabytnangi' # МО Лабытнанги
    LOCAL_P_KONSTANTINOVSKY='localPKonstantinovsky' # Местная п. Константиновский
    MSK_DIVEYEVO_TRUDOVOE='mskDiveyevoTrudovoe' # МСК Дивеево (Трудовое)
    MSK_881427_TUORA_KUEL='msk881427TuoraKuel' # МСК 88 14:27 Туора-Кюель
    WGS_84_EPSG_4087='wgs84Epsg4087' # WGS 84 (EPSG:4087)
    FURMANOV='furmanov' # Фурманов
    LOCAL_VILLAGE_OF_TISKOLOVO='localVillageOfTiskolovo' # Местная (д. Тисколово)
    US_KOTCHURA='usKotchura' # УС д.Котчура
    SK_SEKISOVO='skSekisovo' # СК Секисово
    SK_JENAL='skJenal' # СК с.п. Дженал
    MSK_881433_ULAKHAN_KUEL='msk881433UlakhanKuel' # МСК 88 14:33 Улахан-Кюель
    MSK_KURCHATOV_DISTRICT='mskKurchatovDistrict' # МСК Курчатовского р-на
    LOCAL_SHIHANY='localShihany' # Местная Шиханы
    SK_SLAVYANSKY='skSlavyansky' # СК с.п. Славянский
    MSK_881416_DAWN='msk881416Dawn' # МСК 88 14:16 Заря
    MSK_881402_TOMMOT='msk881402Tommot' # МСК 88 14:02 Томмот
    _7_210_D_DESYATOVA='7210DDesyatova' # 7210 д.Десятова
    USK_VOSKRESENSK_0010007='uskVoskresensk0010007' # УСК Воскресенск (0010007)
    SK_VARGANOVSKOE='skVarganovskoe' # СК Варгановское
    SK_SHIKULEY='skShikuley' # СК с.п.Шикулей
    LOCAL_IVANOVO_DISTRICT='localIvanovoDistrict' # Местная Ивановский район
    MSK_KR_3301_KARABANOVO='mskKr3301Karabanovo' # МСК КР 33:01 г. Карабаново
    DOLMATOVSKY='dolmatovsky' # Долматовский
    SK_NIZHNY_KURKUZHIN='skNizhnyKurkuzhin' # СК с.п. Нижний Куркужин
    PESTLES='pestles' # Пестяки
    BELOKURIKHA_CITY='belokurikhaCity' # г. Белокуриха
    MSK_D_AVDEEVO_02='mskDAvdeevo02' # МСК д.Авдеево02
    MSK_D_AVDEEVO_01='mskDAvdeevo01' # МСК д.Авдеево01
    SK_KASHKHATAU='skKashkhatau' # СК с.п. Кашхатау
    SK_SVETLOVODSKOE='skSvetlovodskoe' # СК с.п. Светловодское
    SK_AUSHIGER='skAushiger' # СК с.п. Аушигер
    SK_MOSTOVSKOE='skMostovskoe' # СК Мостовское
    US_MIKKELITSA='usMikkelitsa' # УС д.Миккелица
    SK_SKOPINO='skSkopino' # СК Скопино
    LOCAL_RYBINSK='localRybinsk' # Местная г. Рыбинск
    GAVRILOV_POSAD='gavrilovPosad' # Гаврилов-Посад
    SK_ODINO='skOdino' # СК Одино
    LOCAL_SOKOLSKOE='localSokolskoe' # Местная Сокольское
    SK_LOCAL_BOGDANOVICH='skLocalBogdanovich' # СК местная г.Богданович
    SK_PROSEKOVO_BORODINO='skProsekovoBorodino' # СК Просеково (Бородино)
    MSK_881402_NIZHNY_KURANAKH='msk881402NizhnyKuranakh' # МСК 88 14:02 Нижний Куранах
    USC_RED_TANKS_0060004='uscRedTanks0060004' # УСК Красные баки (0060004)
    _7_215_P_KALINOVKA='7215PKalinovka' # 7215 с.Калиновка
    _7_222_DUBROVINSKOE_MUNICIPAL_DISTR='7222DubrovinskoeMunicipalDistr' # 7222 МО Дубровинское
    SK_LOCAL_BARANCHINSKY='skLocalBaranchinsky' # СК местная п.Баранчинский
    SPRINGS='springs' # Родники
    US_SOT_AVTOMOBILIST='usSotAvtomobilist' # УС СОТ "Автомобилист"
    SK_OF_CADASTRAL_DISTRICT_ZONE_581='skOfCadastralDistrictZone581' # СК кадастрового округа, зона 1
    SK_OF_CADASTRAL_DISTRICT_ZONE_582='skOfCadastralDistrictZone582' # СК кадастрового округа, зона 2
    PERSHINO_SPORTS_COMPLEX='pershinoSportsComplex' # СК Першино
    MSK_IN_BALTIYSK='mskInBaltiysk' # МСК Балтийска
    SK_DAUNTLESS='skDauntless' # СК Лихачи
    SK_TERPUGOVO='skTerpugovo' # СК Терпугово
    MSK_881433_YURYAKH_KYUERYA='msk881433YuryakhKyuerya' # МСК 88 14:33 Юрях-Кюеря
    GURYEVSKY_DISTRICT='guryevskyDistrict' # Гурьевский район
    SK_LOCAL_KAMENSK_URALSKY='skLocalKamenskUralsky' # СК местная г.Каменск-Уральский
    US_SOT_KOLOS='usSotKolos' # УС СОТ "Колос"
    CONDITIONAL_17_KHLEVENSKIY_DISTRI='conditional17KhlevenskiyDistri' # Условная (17 Хлевенский район)
    _7_210_NOVOTRAVNOYE='7210Novotravnoye' # 7210 с.Новотравное
    SK_MST_MOKROUSOVSKY='skMstMokrousovsky' # СК МСТ (Мокроусовский)
    MSK_881428_UDARNIK='msk881428Udarnik' # МСК 88 14:28 Ударник
    MSK_KR_3309_GOROKHOVETS_DISTRICT='mskKr3309GorokhovetsDistrict' # МСК КР 33:09 Гороховецкий район
    LOCAL_SECHENOVO='localSechenovo' # Местная Сеченово
    _1_0_MSK_CHERNORECHENSKIY='10MskChernorechenskiy' # 10 МСК Чернореченский
    SK_LOCAL_KRASNOUFIMSK='skLocalKrasnoufimsk' # СК местная г.Красноуфимск
    US_SOT_BESOVETS='usSotBesovets' # УС СОТ "Бесовец"
    MSK_OF_YUZHNO_SAKHALINSK='mskOfYuzhnoSakhalinsk' # МСК г. Южно-Сахалинска
    US_SOT_PULSE='usSotPulse' # УС СОТ "Пульс"
    _7_201_OLD_OIL_PAN='7201OldOilPan' # 7201 с.Старая Маслянка
    SK_OF_CADASTRAL_DISTRICT_ZONE_572='skOfCadastralDistrictZone572' # СК кадастрового округа, зона 2
    LOCAL_AD_SYSTEMESTUARY='localAdSystemestuary' # Местная система д.Устье
    SK_OF_CADASTRAL_DISTRICT_ZONE_573='skOfCadastralDistrictZone573' # СК кадастрового округа, зона 3
    MSK_D_VOKNAVOLOK='mskDVoknavolok' # МСК д.Вокнаволок
    _7_210_D_TALOVKA='7210DTalovka' # 7210 д.Таловка
    SK_OSTROVOK='skOstrovok' # СК Островок
    CONDITIONAL_10_KRASNINSKY_DISTRIC='conditional10KrasninskyDistric' # Условная (10 Краснинский район)
    LOCAL_VOLKHOV='localVolkhov' # Местная (г. Волхов)
    LOCAL_SHAUNYA='localShaunya' # Местная Шахунья
    MAKAROV_MSK='makarovMsk' # МСК г. Макарова
    US_SOT_CREATIVE_UNIONS='usSotCreativeUnions' # УС СОТ "Творческих союзов"
    US_0041001='us0041001' # УС 0041001
    SKOOZERSKY_DISTRICT='skoozerskyDistrict' # СК Частоозерского района
    SK_OF_THE_CADASTRAL_DISTRICT_ZONE_5='skOfTheCadastralDistrictZone5' # СК кадастрового округа, зона 5
    SK_OF_THE_CADASTRAL_DISTRICT_ZONE_6='skOfTheCadastralDistrictZone6' # СК кадастрового округа, зона 6
    _7_201_NAZAROVO='7201Nazarovo' # 7201 с.Назарово
    LOCAL='local' # Местная
    MSK_11_ZONE_7='msk11Zone7' # МСК-11 (7 зона)
    MSK_11_ZONE_6='msk11Zone6' # МСК-11 (6 зона)
    LOCAL_KNYAGININO='localKnyaginino' # Местная Княгинино
    MSK_11_ZONE_5='msk11Zone5' # МСК-11 (5 зона)
    MSK_11_ZONE_4='msk11Zone4' # МСК-11 (4 зона)
    MSK_11_ZONE_3='msk11Zone3' # МСК-11 (3 зона)
    _7_209_BOBYLEVO='7209Bobylevo' # 7209 с.Бобылево
    CONDITIONAL_02_GRYAZINSKY_DISTRIC='conditional02GryazinskyDistric' # Условная (02 Грязинский район)
    MSK_NOGLIKI_VILLAGE='mskNoglikiVillage' # МСК пгт Ноглики
    _7_207_GOLYSHMANOVSKY_DISTRICT='7207GolyshmanovskyDistrict' # 7207 - Голышмановский район
    _7_209_D_LOBANOVA='7209DLobanova' # 7209 д.Лобанова
    SK_MALETINO='skMaletino' # СК Малетино
    SK_NOVO_TROITSKIY='skNovoTroitskiy' # СК с.п. Ново-Троицкий
    SK_LOCAL_ASBESTOS='skLocalAsbestos' # СК местная г.Асбест
    SK_NOVAYA_BELOYARKA='skNovayaBeloyarka' # СК Новая Белоярка
    MSK_881427_VICTORY='msk881427Victory' # МСК 88 14:27 Победа
    MSK_LAZOVSKY_DISTRICT='mskLazovskyDistrict' # МСК Лазовский район
    LOCAL_SK_MSK_711='localSkMsk711' # Местная СК МСК-71.1
    LOCAL_DANILOV_CITY='localDanilovCity' # Местная г. Данилов
    SK_MST_VARGASHINSKY='skMstVargashinsky' # СК МСТ (Варгашинский)
    SK_VARGASHINSKY_DISTRICT='skVargashinskyDistrict' # СК Варгашинского района
    _7_201_ITEMS_LENINKA='7201ItemsLeninka' # 7201 п.Ленинка
    _7_217_D_RESHETNIKOVA_STREET='7217DReshetnikovaStreet' # 7217 д.Решетникова
    US_LIZHMA='usLizhma' # УС д.Лижма
    CONDITIONAL_D_PILLOWCASE='conditionalDPillowcase' # Условная (д.Наволок)
    LOCAL_VILLAGE_OF_KOPYEVO='localVillageOfKopyevo' # Местная п. Копьево
    MSK_4='msk4' # МСК № 4
    MSK_3='msk3' # МСК № 3
    MSK_2='msk2' # МСК № 2
    MSK_1='msk1' # МСК № 1
    US_SOT_KARELIA='usSotKarelia' # УС СОТ "Карелия"
    US_SOT_LYCHNY='usSotLychny' # УС СОТ "Лычный"
    _7_209_P_ISHIM='7209PIshim' # 7209 п.Ишимский
    MSK_881432_ELANKA='msk881432Elanka' # МСК 88 14:32 Еланка
    SK_VERKHNY_KURP_INARKOY='skVerkhnyKurpInarkoy' # СК с.п. Верхний Курп_Инаркой
    _7_209_D_SIZIKOVA='7209DSizikova' # 7209 д.Сизикова
    MSK_881432_CHKALOV='msk881432Chkalov' # МСК 88 14:32 Чкалов
    _7_213_OMUTINSKY_DISTRICT='7213OmutinskyDistrict' # 7213 - Омутинский район
    OLD_LOCAL_2635='oldLocal2635' # Старая Местная_2635
    OLD_LOCAL_2636='oldLocal2636' # Старая Местная_2636
    OLD_LOCAL_2633='oldLocal2633' # Старая Местная_2633
    OLD_LOCAL_2634='oldLocal2634' # Старая Местная_2634
    SK_NOVOBEREZOVO='skNovoberezovo' # СК Новоберезово
    OLD_LOCAL_2631='oldLocal2631' # Старая Местная_2631
    OLD_LOCAL_2632='oldLocal2632' # Старая Местная_2632
    OLD_LOCAL_2630='oldLocal2630' # Старая Местная_2630
    SK_MENDERSKAYA='skMenderskaya' # СК Мендерская
    _7_217_SDT_SOSNOVY_BOR='7217SdtSosnovyBor' # 7217 сдт.Сосновый бор
    US_DEKNAVOLOK='usDeknavolok' # УС д.Декнаволок
    MSK_881432_NOKHOROI='msk881432Nokhoroi' # МСК 88 14:32 Нохорой
    _7_210_D_BORISOVKA='7210DBorisovka' # 7210 д.Борисовка
    SK_NOVOKOLMAKOVO='skNovokolmakovo' # СК Новоколмаково
    MSK_59_ZONE_3='msk59Zone3' # МСК-59, зона 3
    MSK_59_ZONE_2='msk59Zone2' # МСК-59, зона 2
    US_BIRCH_BRIDGES='usBirchBridges' # УС д.Березевые Мосты
    MSK_59_ZONE_1='msk59Zone1' # МСК-59, зона 1
    _7_203_AROMASHEVSKY_DISTRICT='7203AromashevskyDistrict' # 7203 - Аромашевский район
    OLD_LOCAL_2628='oldLocal2628' # Старая Местная_2628
    OLD_LOCAL_2629='oldLocal2629' # Старая Местная_2629
    OLD_LOCAL_2626='oldLocal2626' # Старая Местная_2626
    OLD_LOCAL_2624='oldLocal2624' # Старая Местная_2624
    OLD_LOCAL_2625='oldLocal2625' # Старая Местная_2625
    OLD_LOCAL_2622='oldLocal2622' # Старая Местная_2622
    OLD_LOCAL_2623='oldLocal2623' # Старая Местная_2623
    OLD_LOCAL_2620='oldLocal2620' # Старая Местная_2620
    SKI_RESORT_MEDVEZHYE_LAKE='skiResortMedvezhyeLake' # СК курорт Озеро медвежье
    OLD_LOCAL_2621='oldLocal2621' # Старая Местная_2621
    US_SOT_PROGRESS='usSotProgress' # УС СОТ "Прогресс"
    MSK_ALEXANDROVSK_SAKHALINSKY='mskAlexandrovskSakhalinsky' # МСК г. Александровск-Сахалинский
    CONDITIONAL_ANT_SHAPED='conditionalAntShaped' # Условная (Муравейно)
    _7_212_NIZHNYAYA_TAVDA='7212NizhnyayaTavda' # 7212 с.Нижняя Тавда
    MSK_OKTYABRSKY_DISTRICT='mskOktyabrskyDistrict' # МСК Октябрьский район
    US_SOT_NIVA_4='usSotNiva4' # УС СОТ "Нива4"
    SK_KRASNOSELSKOE_VILLAGE='skKrasnoselskoeVillage' # СК с.п. Красносельское
    SK_STROJEVO='skStrojevo' # СК Строево
    _7_222_MARANKA='7222Maranka' # 7222 с.Маранка
    SK_PYT_YAKH='skPytYakh' # СК г. Пыть-ях
    SK_BELOYARSK='skBeloyarsk' # СК Белоярское
    MSK_881433_CHAKYR='msk881433Chakyr' # МСК 88 14:33 Чакыр
    SK_DUGULUBGEY='skDugulubgey' # СК с.п. Дугулубгей
    LOCAL_KONSTANTINOVSKY_DISTRICT='localKonstantinovskyDistrict' # Местная Константиновский район
    US_SOT_ILOXA='usSotIloxa' # УС СОТ "Илокса"
    MSK_D_UPPER_BESOVETS='mskDUpperBesovets' # МСК д.Верхний Бесовец
    _7_208_ZAVODOUKOVSK='7208Zavodoukovsk' # 7208 г.Заводоуковск
    MSK_S_SVYATOZERO='mskSSvyatozero' # МСК с.Святозеро
    MSK_881402_ULU='msk881402Ulu' # МСК 88 14:02 Улу
    NEMAN_DISTRICT='nemanDistrict' # Неманский район
    SK_DEISKOE='skDeiskoe' # СК с.п. Дейское
    KAMENKA='kamenka' # Каменка
    MSK_OF_KONYSHEVSKY_DISTRICT='mskOfKonyshevskyDistrict' # МСК Конышевского р-на
    MSK_38_ZONE_438='msk38Zone438' # МСК-38, зона 4
    SK_LOCAL_TAVDA='skLocalTavda' # СК местная г.Тавда
    _7_223_TYUMEN='7223Tyumen' # 7223 - г. Тюмень
    LOCAL_167_SK_167='local167SK167' # Местная 167
    MSK_881428_KREST_KHALDZHAY='msk881428KrestKhaldzhay' # МСк 88 14:28 Крест-Хальджай
    SK_LOCAL_AYAT='skLocalAyat' # СК местная р.п.Аять
    SK_BEREZOVSKY_DISTRICT_VANZETUR='skBerezovskyDistrictVanzetur' # СК Березовски район, Ванзетур
    PESYANOE_PARK_KURTAMYSHSKY='pesyanoeParkKurtamyshsky' # СК Песьяное (Куртамышский)
    MSK_881409_TOMTOR_BORULAKH='msk881409TomtorBorulakh' # МСК 88 14:09 Томтор_Борулах
    SK_OF_CADASTRAL_DISTRICT_ZONE_622='skOfCadastralDistrictZone622' # СК кадастрового округа, зона 2 (60)
    USK_24_SK_FICTITIOUS_2499='usk24SkFictitious2499' # УСК-24, СК фиктивн 24_99
    MSK_KR_3307_KOVROV_DISTRICT='mskKr3307KovrovDistrict' # МСК КР 33:07 Ковровский район
    LOCAL_IC_OF_VENEV='localIcOfVenev' # Местная СК г. Венева
    SK_OF_CADASTRAL_DISTRICT_ZONE_621='skOfCadastralDistrictZone621' # СК кадастрового округа, зона 1 (60)
    SK_OKTYABRSKY_DISTRICT_PRIOBYE_PB='skOktyabrskyDistrictPriobyePb' # СК Октябрьский район Приобье ПБ
    MSK_881409_SYSY_MEYITE='msk881409SysyMeyite' # МСК 88 14:09 Сысы-Мейите
    US_0020601='us0020601' # УС 0020601
    GSK_52_ZONE_1='gsk52Zone1' # ГСК 52, зона 1
    GSK_52_ZONE_3='gsk52Zone3' # ГСК 52, зона 3
    GSK_52_ZONE_2='gsk52Zone2' # ГСК 52, зона 2
    LOCAL_LUGA='localLuga' # Местная (г.Луга)
    SK_PRILOGINO='skPrilogino' # СК Прилогино
    _2_0_USK_SEDYU='20UskSedyu' # 20 УСК Седью
    LOCAL_CITY_OF_LYUBIM='localCityOfLyubim' # Местная г. Любим
    LOCAL_ARZAMAS='localArzamas' # Местная Арзамас
    _7_222_MO_DUBROVINSKOEEEE='7222MoDubrovinskoeeee' # 7222 МО Дубровинскoеееее
    SK_NAGORSKOE='skNagorskoe' # СК Нагорское
    SK_MOCHALOVO='skMochalovo' # СК Мочалово
    KOHMA='kohma' # Кохма
    SK_BEDYK='skBedyk' # СК с.п. Бедык
    US_NURMOILA='usNurmoila' # УС с.Нурмойла
    MSK_OF_THE_VILLAGE_POVENETS='mskOfTheVillagePovenets' # МСК пгт.Повенец
    US_KYARGOZERO='usKyargozero' # УС п.Кяргозеро
    MSK_LESOZAVODSK='mskLesozavodsk' # МСК Лесозаводск
    _7_202_ARMIZON_DISTRICT='7202ArmizonDistrict' # 7202 - Армизонский район
    MSK_48_ZONE_1='msk48Zone1' # МСК-48, зона 1
    SK_ANTIPAYUTA_TAZOVSKY_DISTRICT='skAntipayutaTazovskyDistrict' # ск п.Антипаюта (Тазовский район)
    MSK_KORENEVSKY_DISTRICT='mskKorenevskyDistrict' # МСК Кореневского р-на
    _7_210_TOBOLOVO='7210Tobolovo' # 7210 с.Тоболово
    USK_23='usk23' # УСК-23
    US_SOT_CHAIKA_1003='usSotChaika1003' # УС СОТ "Чайка" 10:03
    SK_VYTEGRA='skVytegra' # СК г. Вытегра
    _7_216_SDT_MACHINE_OPERATOR='7216SdtMachineOperator' # 7216 сдт.Механизатор
    MSK_LETNERECHENSKIY='mskLetnerechenskiy' # МСК п.Летнереченский
    MSK_OF_THE_MANTUROVSKY_DISTRICT='mskOfTheManturovskyDistrict' # МСК Мантуровского р-на
    US_SOT_SEVERNY='usSotSeverny' # УС СОТ "Северный"
    SK_KRUGLOE_ZVERINOGOLOVSKY='skKrugloeZverinogolovsky' # СК Круглое (Звериноголовский)
    _7_210_LARIKHA='7210Larikha' # 7210 с.Лариха
    SK_POKACHI='skPokachi' # СК г. Покачи
    BARNAUL='barnaul' # г. Барнаул
    US_NURMOLITSY='usNurmolitsy' # УС д.Нурмолицы
    USK_24166176='usk24166176' # УСК-24, 166
    MSK_ZATO_FOKINO='mskZatoFokino' # МСК ЗАТО г.Фокино
    SK_OF_CADASTRAL_DISTRICT_ZONE_602='skOfCadastralDistrictZone602' # СК кадастрового округа, зона 2
    KOLMAKOVO_MIASSKY_SPORTS_COMPLEX='kolmakovoMiasskySportsComplex' # СК Колмаково-Миасское
    MSK_881433_TELEY='msk881433Teley' # МСК 88 14:33 Телей
    _7_222_YARKOVSKY_DISTRICT='7222YarkovskyDistrict' # 7222 - Ярковский район
    OLD_LOCAL_2627_DISTRICT='oldLocal2627District' # Старая Местная_2627_район
    SK_YAMBURG_NADYM_DISTRICT='skYamburgNadymDistrict' # СК п.Ямбург (Надымский район)
    SK_ROMANOVKA='skRomanovka' # СК Романовка
    SK_SOVETSKY_DISTRICT_SOVETSKY='skSovetskyDistrictSovetsky' # СК Советский район, Советский
    SK_POSLOVY_SHURYSHKARSKY_DISTRICT='skPoslovyShuryshkarskyDistrict' # СК Пословы (Шурышкарский район)
    _7_210_D_OPENOVKA='7210DOpenovka' # 7210 д.Опеновка
    USK_24_KATEK_ZAP='usk24KatekZap' # УСК-24, КАТЭК-ЗАП
    SK_BEREZOVSKY_DISTRICT_BEREZOVO='skBerezovskyDistrictBerezovo' # СК Березовский район, Березово
    MSK_SHCHIGRY='mskShchigry' # МСК г. Щигры
    USK_24_KATEK_9_A_1='usk24Katek9A1' # УСК-24, КАТЭК-9А 1
    MSK_KR_3310_KRASNAYA_GORBATKA='mskKr3310KrasnayaGorbatka' # МСК КР 33:10 пгт Красная Горбатка
    LOCAL_PODPOROZHYE='localPodporozhye' # Mестная (г. Подпорожье)
    MSK_881428_OKHOTSK_TRANSPORTATION='msk881428OkhotskTransportation' # МСК 88 14:28 Охотский Перевоз
    MSK_SHALSKY='mskShalsky' # МСК п.Шальский
    _7_210_P_LOZOVOE='7210PLozovoe' # 7210 п.Лозовое
    USK_84_SK_OF_THE_CADASTRAL_DISTRICT='usk84SkOfTheCadastralDistrict' # УСК-84, СК кадастрового округа
    MSK_KR_3319_SUZDAL='mskKr3319 Suzdal' # МСК КР 33:19 г. Суздаль
    SKOBOZERYE='skobozerye' # СК Частоозерье
    SK_ZVERINOGOLOVSKOE='skZverinogolovskoe' # СК Звериноголовское
    SK_MISHKINO='skMishkino' # СК Мишкино
    SK_SOVETSKY_DISTRICT_ZELENOBORSK='skSovetskyDistrictZelenoborsk' # СК Советский район, зеленоборск
    _7_210_SHABLYKINO='7210Shablykino' # 7210 с.Шаблыкино
    MSK_881402_YAKOKIT='msk881402Yakokit' # МСК 88 14:02 Якокит
    SK_BUGAEVO='skBugaevo' # СК Бугаево
    SK_NIKITINO='skNikitino' # СК Никитино
    MSK_87_IULTINSKY_DISTRICT='msk87IultinskyDistrict' # МСК-87 (Иультинский район)
    MSK_87_PROVIDENSKY_DISTRICT='msk87ProvidenskyDistrict' # МСК-87 (Провиденский район)
    SK_KULIKOVO='skKulikovo' # СК Куликово
    SK_KONOVALOVA='skKonovalova' # СК Коновалова
    MSK_HIITOLA='mskHiitola' # МСК п.Хийтола
    _1_5_MSK_USINSK='15MskUsinsk' # 15 МСК Усинск
    _7_210_D_BOLSHEUDALOVO='7210DBolsheudalovo' # 7210 д.Большеудалово
    US_SOT_CHUPA_1='usSotChupa1' # УС СОТ "Чупа-1"
    SK_KRUGLOE='skKrugloe' # СК Круглое
    _7_209_P_GRAIN_MARKET='7209PGrainMarket' # 7209 п.Зерновой
    SK_KONOVALOVO='skKonovalovo' # СК Коновалово
    MSK_881433_KIELYANKA='msk881433Kielyanka' # МСК 88 14:33 Килянки
    MSK_61_ZONE_3='msk61Zone3' # МСК-61, зона 3
    MSK_61_ZONE_2='msk61Zone2' # МСК-61, зона 2
    MSK_61_ZONE_1='msk61Zone1' # МСК-61, зона 1
    SK_SHMAKOVO_KETOVSKY='skShmakovoKetovsky' # СК Шмаково (Кетовский)
    US_LOSOSINNOE='usLososinnoe' # УС д.Лососинное
    _1_963_LOMONOSOVSKY='1963Lomonosovsky' # 1963 (Ломоносовский)
    SK_KOSTYLEVO='skKostylevo' # СК Костылево
    MSK_881427_KHARA_ALDAN='msk881427KharaAldan' # МСК 88 14:27 Хара-Алдан
    MSK_881433_YURYUNG_KYUL='msk881433YuryungKyul' # МСК 88 14:33 Юрюнг-Кюель
    _7_207_GOLYSHMANOVO_SETTLEMENT='7207GolyshmanovoSettlement' # 7207 р.п.Голышманово
    SK_LOCAL_NIZHNY_SERGI='skLocalNizhnySergi' # СК местная г.Нижние Серги
    _7_217_P_BOGANDINSKOE='7217PBogandinskoe' # 7217 с.Богандинское
    LOCAL_INSURANCE_COMPANY_OF_KOTOVO='localInsuranceCompanyOfKotovo' # местная СК г. Котово
    SK_ARASLANOVO='skAraslanovo' # СК Арасланово
    US_SOT_BESOVETSKY='usSotBesovetsky' # УС СОТ "Бесовецкий"
    LOCAL_PYSHCHUG='localPyshchug' # Местная_с.Пыщуг
    NEW_SLIDES='newSlides' # Новые Горки
    MSK_OLONETS='mskOlonets' # МСК г.Олонец
    MSK_PORONAISK='mskPoronaisk' # МСК г. Поронайска
    PALEKH='palekh' # Палех
    LOCAL_SYSTEM_OF_KARGAT_CITY='localSystemOfKargatCity' # Местная система г. Каргат
    MSK_881419_SEREBRYANY_BOR='msk881419SerebryanyBor' # МСК 88 14:19 Серебряный_Бор
    MSK_SORTAVALA='mskSortavala' # МСК г.Сортавала
    MSK_881409_TOKUMA='msk881409Tokuma' # МСК 88 14:09 Токума
    LOCAL_POSHEKHONYE='localPoshekhonye' # Местная г. Пошехонье
    SK_KOROTCHAEVO='skKorotchaevo' # СК Коротчаево
    MSK_41_ZONE_1='msk41Zone1' # МСК-41, зона 1
    SAVINO='savino' # Савино
    MSK_41_ZONE_2='msk41Zone2' # МСК-41, зона 2
    MSK_41_ZONE_3='msk41Zone3' # МСК-41, зона 3
    SK_USHAKOVSKOE='skUshakovskoe' # СК Ушаковское
    LOCAL_S_BUSSE='localSBusse' # Местная с.Буссе
    MSK_881409_SENTACHAN='msk881409Sentachan' # МСК 88 14:09 Сентачан
    US_SOT_MAYAK='usSotMayak' # УС СОТ "Маяк"
    PISCOVO='piscovo' # Писцово
    MSK_45_OF_THE_KATAYSKY_DISTRICT='msk45OfTheKatayskyDistrict' # МСК-45 Катайского района
    MSK_KR_3318_BELAYA_RECHKA='mskKr3318BelayaRechka' # МСК КР 33:18 Белая речка
    LOCAL_BOGORODSK='localBogorodsk' # Местная Богородск
    SK_KOSHKINO='skKoshkino' # СК Кошкино
    _6_525_YUZHNO_KURILSKY_DISTRICT='6525YuzhnoKurilskyDistrict' # 6525 Южно-Курильский район
    SK_OF_LONGYUGAN_SETTLEMENT_NADYM_DI='skOfLongyuganSettlementNadymDi' # СК п.Лонгьюган (Надымский район)
    US_SOT_BYTOVIK_1020='usSotBytovik1020' # УС СОТ "Бытовик" 10:20
    SK_LOCAL_NEVYANSK='skLocalNevyansk' # СК местная г.Невьянск
    SK_KURTAMYSHSKY_DISTRICT='skKurtamyshskyDistrict' # СК Куртамышского района
    US_SOT_KRASNOGORYE='usSotKrasnogorye' # УС СОТ "Красногорье"
    SK_ZABORSKAYA='skZaborskaya' # СК Заборская
    SK_69_ZONE_2_MSK_69_ZONE_2='sk69Zone2Msk69Zone2' # СК-69, зона 2 (МСК-69, зона 2)
    MSK_881433_MYRYLA='msk881433Myryla' # МСК 88 14:33 Мырыла
    SK_NOVO_POKROVSKY='skNovoPokrovsky' # СК с.п. Ново-Покровский
    US_SOT_CHAIKA='usSotChaika' # УС СОТ "Чайка"
    SK_KRASNOARMEYSKOE='skKrasnoarmeyskoe' # СК с.п. Красноармейское
    US_OLONKA_ESTUARY='usOlonkaEstuary' # УС п.Устье Олонки
    USK_24_SK_FICTITIOUS_2426='usk24SkFictitious2426' # УСК-24, СК фиктивн 24_26
    CONDITIONAL_04_DOBRINSKY_DISTRICT='conditional04DobrinskyDistrict' # Условная (04 Добринский район)
    LOCAL_BLAGOVESHCHENSK_DISTRICT='localBlagoveshchenskDistrict' # Местная Благовещенский район
    MSK_SEGEZHA='mskSegezha' # МСК г.Сегежа
    SK_VOYKARY_PEAK_SHURYSHKARSKY_DIST='skVoykaryPeakShuryshkarskyDist' # СК д.Вершина Войкары (Шурышкарский район)
    _7_210_D_MIKHAILOVKA='7210DMikhailovka' # 7210 д.Михайловка
    US_SOT_AVTODOROZHNIK='usSotAvtodorozhnik' # УС СОТ "Автодорожник"
    LOCAL_BOR='localBor' # Местная Бор
    SK_SHMAKOVO='skShmakovo' # СК Шмаково
    US_SOT_MAYAK_06='usSotMayak06' # УС СОТ "Маяк" 06
    LOCAL_LUZHSKY_DISTRICT_MSK_1='localLuzhskyDistrictMSK1' # Местная ( Лужский район)
    SK_TAKTASHI='skTaktashi' # СК Такташи
    _7_210_D_PERVOTROITSK='7210DPervotroitsk' # 7210 д.Первотроицк
    _0_8_MSK_MIKUN='08MskMikun' # 08 МСК Микунь
    MSK_881432_TUMUL='msk881432Tumul' # МСК 88 14:32 Тумул
    MSK_WATCHAGE='mskWatchage' # МСК п.Вочаж
    US_SOT_CHERYOMUSHKI='usSotCheryomushki' # УС СОТ "Черемушки"
    SK_KAMENOMOSTSKOE='skKamenomostskoe' # СК с.п. Каменомостское
    US_KISHKOIL='usKishkoil' # УС д.Кишкойла
    _7_210_NOVOLOKTI='7210Novolokti' # 7210 с.Новолокти
    SK_LOCAL_SUKHOI_LOG='skLocalSukhoiLog' # СК местная г.Сухой Лог
    SK_UVAROVO='skUvarovo' # СК Уварово
    SK_NYAGAN_SQLBASE_00='skNyaganSqlbase00' # СК Нягань SQLBase_00
    US_LUMBOZERO='usLumbozero' # УС д.Лумбозеро
    MSK_881430_ZVEZDOCHKA='msk881430Zvezdochka' # МСК 88 14:30 Звездочка
    US_LAKHTA='usLakhta' # УС д.Лахта
    _7_213_SITNIKOVO='7213Sitnikovo' # 7213 с.Ситниково
    SK_DALNEYE='skDalneye' # СК с.п. Дальнее
    SK_NYAGAN_SQLBASE_07='skNyaganSqlbase07' # СК Нягань SQLBase_07
    MSK_02_ZONE_1='msk02Zone1' # МСК-02, зона 1
    MSK_02_ZONE_2='msk02Zone2' # МСК-02, зона 2
    US_0072201='us0072201' # УС 0072201
    _7_210_RAVNETS='7210Ravnets' # 7210 с.Равнец
    SK_TOLKA_PUROVSKY_DISTRICT='skTolkaPurovskyDistrict' # СК с.Толька (Пуровский район)
    SK_KRUTOBEREGOVO='skKrutoberegovo' # СК Крутоберегово
    MSK_881416_ALMAZNY='msk881416Almazny' # МСК 88 14:16 Алмазный
    US_SOT_BUILDER='usSotBuilder' # УС СОТ "Строитель"
    MSK_640709='msk640709' # МСК-64
    SK_SHCHUCHYE='skShchuchye' # СК Щучье
    SK_ELOSHNOYE='skEloshnoye' # СК Елошное
    _7_205_VAGAYSKY_DISTRICT='7205VagayskyDistrict' # 7205 - Вагайский район
    MSK_68_ZONE_1='msk68Zone1' # МСК-68, зона 1
    US_SOT_SOSENKA='usSotSosenka' # УС СОТ "Сосенка"
    SK_MALKA='skMalka' # СК с.п. Малка
    US_VEND_URA='usVendUra' # УС д.Вендюра
    MSK_ARDATOV_KUZHENDEYEVO='mskArdatovKuzhendeyevo' # МСК Ардатов (Кужендеево)
    _7_210_D_MALOUDALOVO='7210DMaloudalovo' # 7210 д.Малоудалово
    LOCAL_TAMBOV_REGION='localTambovRegion' # Местная Тамбовский район
    SK_POLAR_LABYTNANGI='skPolarLabytnangi' # СК п.Полярный (Лабытнанги)
    CITY_OF_YAROVOYE='cityOfYarovoye' # г. Яровое
    US_SOT_DOMOSTROITEL='usSotDomostroitel' # УС СОТ "Домостроитель"
    _7_210_D_FRUIT_NURSERY='7210DFruitNursery' # 7210 д.Плодопипитомник
    SK_MAISKY='skMaisky' # СК г.п. Майский
    G_GUSEV='gGusev' # г. Гусев
    _7_222_YARKOVO='7222Yarkovo' # 7222 с.Ярково
    MSK_23_ZONE_2_SK_CADASTRAL_DISTRICT='msk23Zone2SKCadastralDistrict' # МСК 23, зона 2
    SK_SOROKINO='skSorokino' # СК Сорокино
    CONDITIONAL_03_DANKOVSKY_DISTRICT='conditional03DankovskyDistrict' # Условная (03 Данковский район)
    MARKOVO='markovo' # Марково
    SK_MENSHCHIKOVO='skMenshchikovo' # СК Менщиково
    SK_VINOGRADOVSKY_DISTRICT_100201='skVinogradovskyDistrict100201' # СК Виноградовского района(100201)
    SK_IKOVSKOE='skIkovskoe' # СК Иковское
    SK_UKRAINETS='skUkrainets' # СК Украинец
    LOCAL_S_SOURCE_FIELD='localSSourceField' # Местная с.Источное
    SK_KUTOPYUGAN_NADYM_DISTRICT='skKutopyuganNadymDistrict' # СК п.Кутопьюган (Надымский район)
    SK_LOCAL_MIKHAYLOVSK='skLocalMikhaylovsk' # СК местная г.Михайловск
    SK_MENSHCHIKOVO_POLOVINSKY='skMenshchikovoPolovinsky' # СК Менщиково (Половинский)
    USC_RED_TANKS_0040008='uscRedTanks0040008' # УСК Красные баки (0040008)
    US_0073501='us0073501' # УС 0073501
    USC_RED_TANKS_0040003='uscRedTanks0040003' # УСК Красные баки (0040003)
    PLES='ples' # Плес
    USK_29_USK_83='usk29Usk83' # УСК-29, УСК 83
    USC_RED_TANKS_0040004='uscRedTanks0040004' # УСК Красные баки (0040004)
    SK_KHANTY_MANSIYSK='skKhantyMansiysk' # СК г. Ханты-Мансийск
    _7_217_D_ZYRYANKA='7217DZyryanka' # 7217 д.Зырянка
    NOVOALTAYSK_CITY='novoaltayskCity' # г. Новоалтайск
    US_SOT_KARELIAN_GARDENER='usSotKarelianGardener' # УС СОТ "Карельский садовод"
    SK_SUNGUROVO='skSungurovo' # СК Сунгурово
    MSK_881428_NEW='msk881428New' # МСК 88 14:28 Новый
    SK_LUKINA='skLukina' # СК Лукина
    SK_KHOSHGORT_SHURYSHKARSKY_DISTRI='skKhoshgortShuryshkarskyDistri' # СК Хошгорт (Шурышкарский район)
    US_SOT_BUILDER_1003='usSotBuilder1003' # УС СОТ "Строитель" 10:03
    _7_209_D_BATENI='7209DBateni' # 7209 д.Батени
    SK_LOCAL_YEKATERINBURG='skLocalYekaterinburg' # СК местная г.Екатеринбург
    MSK_881432_BULGUNNYAKHTAKH='msk881432Bulgunnyakhtakh' # МСК 88 14:32 Булгунняхтах
    NESTEROVSKY_DISTRICT='nesterovskyDistrict' # Нестеровский район
    SK_BORKI='skBorki' # СК Борки
    MSK_NAKHODKA='mskNakhodka' # МСК г.Находка
    SK_YAGODNAYA='skYagodnaya' # СК Ягодная
    _7_219_UPOROVSKY_DISTRICT='7219UporovskyDistrict' # 7219 - Упоровский район
    MSK_OF_RYAZAN='mskOfRyazan' # МСК г. Рязани
    SK_UCHEBNOE='skUchebnoe' # СК с.п. Учебное
    LOCAL_BALAKHNA='localBalakhna' # Местная Балахна
    OLD_LOCAL_26032='oldLocal26032' # Старая Местная_2603_2
    US_ONEGA='usOnega' # УС п.Онежский
    OLD_LOCAL_26031='oldLocal26031' # Старая Местная_2603_1
    LOCAL_SYASSTROY='localSyasstroy' # Местная (г. Сясьстрой)
    SK_PEREDERGINO='skPeredergino' # СК Передергино
    OLD_LOCAL_26033='oldLocal26033' # Старая Местная_2603_3
    MSK_26_FROM_SK_95_ZONE_2='msk26FromSk95Zone2' # МСК-26 от СК-95, зона 2
    US_SOT_SUNFLOWER='usSotSunflower' # УС СОТ "Подсолнух"
    MSK_26_FROM_SK_95_ZONE_1='msk26FromSk95Zone1' # МСК-26 от СК-95, зона 1
    MSK_0995='msk0995' # МСК 09-95
    SK_MEGION='skMegion' # СК Мегион
    _7_201_SYCHEVO='7201Sychevo' # 7201 с.Сычево
    US_SOT_KRISTALL='usSotKristall' # УС СОТ "Кристалл"
    SK_PETUKHOVO_1_ARRAY='skPetukhovo1Array' # СК Петухово (1 массив)
    MSK_KR_3310_NEW_LIFE='mskKr3310 NewLife' # МСК КР 33:10 п. Новый Быт
    USC_RED_TANKS_0040009='uscRedTanks0040009' # УСК Красные баки (0040009)
    SK_MEMORABLE='skMemorable' # СК Памятное
    PICHUGINO_SPORTS_COMPLEX='pichuginoSportsComplex' # СК Пичугино
    _1_2_MSK_KOZHVA='12MskKozhva' # 12 МСК Кожва
    _7_216_TOBOLSK_DISTRICT='7216TobolskDistrict' # 7216 - Тобольский район
    MSK_25_ZONE_1='msk25Zone1' # МСК 25, зона 1
    MSK_25_ZONE_3='msk25Zone3' # МСК 25, зона 3
    MSK_25_ZONE_2='msk25Zone2' # МСК 25, зона 2
    SK_KROPANI='skKropani' # СК Кропани
    MSK_881416_NEW='msk881416New' # МСК 88 14:16 Новый
    CONDITIONAL_D_VAGOSHKA='conditionalDVagoshka' # Условная (д.Вагошка)
    _7_210_D_SAVINA='7210DSavina' # 7210 д.Савина
    _7_209_D_GAYEVA='7209DGayeva' # 7209 д.Гаева
    SK_BOROVLYANKA='skBorovlyanka' # СК Боровлянка
    SK_DZHULAT='skDzhulat' # СК с.п. Джулат
    SK_BEREZOVSKY_DISTRICT_SVETLY='skBerezovskyDistrictSvetly' # СК Березовски район, Светлый
    MSK_881410='msk881410' # МСК 88 14:10
    MSK_881411='msk881411' # МСК 88 14:11
    MSK_881412='msk881412' # МСК 88 14:12
    MSK_881413='msk881413' # МСК 88 14:13
    SK_NIZHNY_CHEGEM='skNizhnyChegem' # СК с.п. Нижний Чегем
    SK_BELOZERSKOE='skBelozerskoe' # СК Белозерское
    MSK_881415='msk881415' # МСК 88 14:15
    SK_SOVETSKY_DISTRICT_TAEZHNY='skSovetskyDistrictTaezhny' # СК Советский район, Таежный
    LOCAL_SK_SARATOV_AND_SARATOVSKY_DIS='localSkSaratovAndSaratovskyDis' # Местная СК Саратов и Саратовский район
    MSK_881417='msk881417' # МСК 88 14:17
    MSK_NSO_ZONE_3='mskNsoZone3' # МСК НСО, зона 3
    MSK_881409_YUTTYAKH='msk881409Yuttyakh' # МСК 88 14:09 Юттях
    MSK_NSO_ZONE_4='mskNsoZone4' # МСК НСО, зона 4
    MSK_NSO_ZONE_1='mskNsoZone1' # МСК НСО, зона 1
    MSK_NSO_ZONE_2='mskNsoZone2' # МСК НСО, зона 2
    _7_210_D_RAGOZIN='7210DRagozin' # 7210 д.Рагозина
    SK_OF_CADASTRAL_DISTRICT_ZONE_071='skOfCadastralDistrictZone071' # СК кадастрового округа, зона 1
    KOMSOMOLSK='komsomolsk' # Комсомольск
    SK_LENSKY_DISTRICT_LOCAL='skLenskyDistrictLocal' # СК Ленского района местная
    SK_LOCAL_SREDNEURALSK='skLocalSredneuralsk' # СК местная г.Среднеуральск
    SK_RASKATIKHA='skRaskatikha' # СК Раскатиха
    _1_6_MSK_VORKUTA='16MskVorkuta' # 16 МСК Воркута
    SK_BEREZOVSKY_DISTRICT_ANNEVO='skBerezovskyDistrictAnnevo' # СК Березовский район, Аннево
    SK_EKATERINOGRADSKAYA='skEkaterinogradskaya' # СК с.п. Екатериноградская
    CONDITIONAL_NOVY_BROD_VILLAGE='conditionalNovyBrodVillage' # Условная (д.Новый Брод)
    _7_209_SOLOBOEVO='7209Soloboevo' # 7209 с.Солобоево
    SK_IPATOVA='skIpatova' # СК Ипатова
    MSK_881420='msk881420' # МСК 88 14:20
    _7_218_P_TURTAS='7218PTurtas' # 7218 п.Туртас
    US_SOT_RADIOTEKHNIK='usSotRadiotekhnik' # УС СОТ "Радиотехник"
    MSK_881422='msk881422' # МСК 88 14:22
    MSK_881424='msk881424' # МСК 88 14:24
    MSK_881425='msk881425' # МСК 88 14:25
    MSK_881426='msk881426' # МСК 88 14:26
    LOCAL_PAVLOVO='localPavlovo' # Местная Павлово
    MSK_881432_NUOCHAKHA='msk881432Nuochakha' # МСК 88 14:32 Нуочаха
    MSK_881429='msk881429' # МСК 88 14:29
    USK_24_NO_20_BOGOTOL='usk24No20Bogotol' # УСК-24, №20 (г. Боготол)
    SK_LOCAL_KRASNOURALSK='skLocalKrasnouralsk' # СК местная г.Красноуральск
    USC_KRASNYE_BAKI_0040010='uscKrasnyeBaki0040010' # УСК Красные баки (0040010)
    SK_ULYANOVSK='skUlyanovsk' # СК с.п. Ульяновское
    MSK_38_ZONE_6='msk38Zone6' # МСК-38, зона 6
    MSK_38_ZONE_7='msk38Zone7' # МСК-38, зона 7
    MSK_881402_BOLSHOY_NIMNYR='msk881402BolshoyNimnyr' # МСК 88 14:02 Большой Нимныр
    SK_CORNFLOWERS='skCornflowers' # СК Васильки
    GUBKINSKY_MUNICIPAL_DISTRICT='gubkinskyMunicipalDistrict' # МО г.Губкинский
    SK_KONDINSKY_DISTRICT_MEJDURECH='skKondinskyDistrictMejdurech' # СК Кондинский район Mejdurech
    SK_OF_THE_CITY_OF_KURSK_AND_THE_KURSK_D='skOfTheCityOfKurskAndTheKurskD' # СК г. Курск и Курского р-на
    LOCAL_OF_YAROSLAVL='localOfYaroslavl' # Местная г. Ярославля
    MSK_DALNERECHENSKY_DISTRICT='mskDalnerechenskyDistrict' # МСК Дальнереченский район
    SK_YAMBURA_PRIURALSKY_DISTRICT='skYamburaPriuralskyDistrict' # СК Ямбура (Приуральский район)
    SK_BATEKH='skBatekh' # СК с.п. Батех
    MSK_46_ZONE_1='msk46Zone1' # МСК-46, зона 1
    MSK_46_ZONE_2='msk46Zone2' # МСК-46, зона 2
    CONDITIONAL_12_LEV_TOLSTOVSKY_DIST='conditional12LevTolstovskyDist' # Условная (12 Лев-Толстовский район)
    SK_MALOE_SEREDKINO='skMaloeSeredkino' # СК Малое Середкино
    SK_LOCAL_TSEMENTNY='skLocalTsementny' # СК местная п.Цементный
    MSK_29_ZONE_4='msk29Zone4' # МСК-29 зона 4
    SK_SOVETSKY_DISTRICT_MALINOVSKY='skSovetskyDistrictMalinovsky' # СК Советский Район,Малиновкий
    MSK_29_ZONE_5='msk29Zone5' # МСК-29 зона 5
    MSK_29_ZONE_6='msk29Zone6' # МСК-29 зона 6
    SK_KHUTOR='skKhutor' # СК Хутора
    US_KARSHEVO='usKarshevo' # УС п.Каршево
    _7_216_SDT_HOPE='7216SdtHope' # 7216 сдт.Надежда
    SK_MORSHIKHA='skMorshikha' # СК Моршиха
    MSK_29_ZONE_2='msk29Zone2' # МСК-29 зона 2
    MSK_29_ZONE_3='msk29Zone3' # МСК-29 зона 3
    SK_PEREVALOVO='skPerevalovo' # СК Перевалово
    LOCAL_INVESTIGATIVE_COMMITTEE_OF_T='localInvestigativeCommitteeOfT' # местная СК р.п.Рудня
    MSK_881432_TIT_ARY='msk881432TitAry' # МСК 88 14:32 Тит-Ары
    MSK_DMITRIEVSKY_DISTRICT='mskDmitrievskyDistrict' # МСК Дмитриевского р-на
    SK_OF_CADASTRAL_DISTRICT_ZONE_031='skOfCadastralDistrictZone031' # СК кадастрового округа, зона 1
    _7_210_VTOROPESYANOVO='7210Vtoropesyanovo' # 7210 с.Второпесьяново
    SK_OF_CADASTRAL_DISTRICT_ZONE_032='skOfCadastralDistrictZone032' # СК кадастрового округа, зона 1 (62)
    MSK_881401='msk881401' # МСК 88 14:01
    SK_GAZ_SALE_TAZOVSKY_DISTRICT='skGazSaleTazovskyDistrict' # ск п.Газ-Сале (Тазовский район)
    MSK_881403='msk881403' # МСК 88 14:03
    SK_OF_CADASTRAL_DISTRICT_ZONE_035='skOfCadastralDistrictZone035' # СК кадастрового округа, зона 4
    MSK_881428_POPLAR='msk881428Poplar' # МСК 88 14:28 Тополиный
    MSK_881404='msk881404' # МСК 88 14:04
    MSK_881405='msk881405' # МСК 88 14:05
    SK_OF_CADASTRAL_DISTRICT_ZONE_033='skOfCadastralDistrictZone033' # СК кадастрового округа, зона 2 (62)
    MSK_881406='msk881406' # МСК 88 14:06
    SK_OF_CADASTRAL_DISTRICT_ZONE_034='skOfCadastralDistrictZone034' # СК кадастрового округа, зона 3
    MSK_881407='msk881407' # МСК 88 14:07
    MSK_881408='msk881408' # МСК 88 14:08
    PETROVSKY='petrovsky' # Петровский
    SK_634_ZONE='sk634Zone' # СК 63 4 зона
    SK_63_D_7='sk63D7' # СК 63 D7
    SK_KAZYM_MYS_SHURYSHKARSKY_DISTRIC='skKazymMysShuryshkarskyDistric' # СК Казым-Мыс (Шурышкарский район)
    SK_KARASU='skKarasu' # СК с.п. Карасу
    _7_214_SLADKOVSKY_DISTRICT='7214SladkovskyDistrict' # 7214 - Сладковский район
    SK_63_D_5='sk63D5' # СК 63 D5
    SK_YURUZANOVKA='skYuruzanovka' # СК Юрузановка
    MSK_OF_KHOLMOGORSKY_DISTRICT='mskOfKholmogorskyDistrict' # МСК Холмогорского района
    SK_NOSKOVO='skNoskovo' # СК Носково
    SK_KATRAVOZH_PRIURALSKY_DISTRICT='skKatravozhPriuralskyDistrict' # СК Катравож (Приуральский район)
    US_SOT_ROSINKA='usSotRosinka' # УС СОТ "Росинка"
    MSK_KR_3303_KOLCHUGINSKY_DISTRICT='mskKr3303KolchuginskyDistrict' # МСК КР 33:03 Кольчугинский район
    MSK_30_ZONE_2='msk30Zone2' # MCК-30, зона 2
    SK_SHCHUCHANSKY_DISTRICT='skShchuchanskyDistrict' # СК Щучанского района
    LOCAL_COMMUNARD='localCommunard' # Местная Коммунар
    US_SOT_BYTOVIK='usSotBytovik' # УС СОТ "Бытовик"
    ZELENOGRAD_DISTRICT='zelenogradDistrict' # Зеленоградский район
    MSK_OF_THE_NORTH_ONEGA_BAUXITE_MINE='mskOfTheNorthOnegaBauxiteMine' # МСК Северо-Онежского Бокситового рудника
    _7_210_D_KUIMOVA_STREET='7210DKuimovaStreet' # 7210 д.Куимова
    SK_63_OLD_CONDITIONAL_SC='sk63OldConditionalSC' # СК 63
    MSK_1423='msk1423' # МСК 14:23
    SK_NIZHNEVARTOVSK='skNizhnevartovsk' # СК г. Нижневартовск
    US_SOT_LYUTYA='usSotLyutya' # УС СОТ "Люття"
    _7_217_P_YAR='7217PYar' # 7217 с.Яр
    MSK_47_CONDITIONAL_SK='msk47ConditionalSk' # МСК 47 (условная СК)
    SK_MO_NOVY_URENGOY='skMoNovyUrengoy' # СК МО Новый Уренгой
    SK_YAMGORT_SHURYSHKARSKY_DISTRICT='skYamgortShuryshkarskyDistrict' # СК д.Ямгорт (Шурышкарский район)
    MSK_881433_KHARBALA_1='msk881433Kharbala1' # МСК 88 14:33 Харбала-1
    SK_PTICHYE='skPtichye' # СК Птичье
    MSK_881433_KHARBALA_2='msk881433Kharbala2' # МСК 88 14:33 Харбала-2
    USK_VOSKRESENSK_0160006='uskVoskresensk0160006' # УСК Воскресенск (0160006)
    SK_KOVALEVO='skKovalevo' # СК Ковалево
    _6_526_KURIL_DISTRICT='6526KurilDistrict' # 6526 Курильский район
    _7_210_KARASUL='7210Karasul' # 7210 с.Карасуль
    KINESHMA='kineshma' # Кинешма
    LOCAL_VOLKHOVSKY='localVolkhovsky' # Местная (Волховский)
    US_SOT_PRIOZERNY='usSotPriozerny' # УС СОТ "Приозерный"
    MSK_DIVEYEVO_ICHALOVO='mskDiveyevoIchalovo' # МСК Дивеево (Ичалово)
    LOCAL_SK_OF_MIKHAYLOVKA='localSkOfMikhaylovka' # местная СК г. Михайловка
    MSK_FOR_THE_YAKUTSK_REGION='mskForTheYakutskRegion' # МСК для Якутского района
    SK_LOGOVUSHKA='skLogovushka' # СК Логовушка
    SK_KAMYSHNOYE_LEBYAZHEVSKY_DISTRI='skKamyshnoyeLebyazhevskyDistri' # СК Камышное (Лебяжьевский район)
    SK_LOCAL_BASYANOVSKY='skLocalBasyanovsky' # СК местная п.Басьяновский
    SK_ISKRA='skIskra' # СК Искра
    MSK_881431='msk881431' # МСК 88 14:31
    MSK_881432='msk881432' # МСК 88 14:32 Ой
    MSK_881433_CHYAPPARA='msk881433Chyappara' # МСК 88 14:33 Чыаппара
    MSK_881434='msk881434' # МСК 88 14:34
    MSK_38_ZONE_5='msk38Zone5' # МСК-38, зона 5
    MSK_38_ZONE_2='msk38Zone2' # МСК-38, зона 2
    SK_POLOVINNOE_POLOVINSKY='skPolovinnoePolovinsky' # СК Половинное (Половинский)
    SK_DAWN='skDawn' # СК Рассвет
    MSK_38_ZONE_1='msk38Zone1' # МСК-38, зона 1
    SK_PETUKHOV_DISTRICT='skPetukhovDistrict' # СК Петуховского района
    US_SOT_SHARIYARVI='usSotShariyarvi' # УС СОТ "Шариярви"
    _0_8_MSK_LOCAL='08MskLocal' # 08 МСК Местная
    MSK_KR_3306_KAMESHKOVSKY_DISTRICT='mskKr3306KameshkovskyDistrict' # МСК КР 33:06 Камешковский район
    US_0040901='us0040901' # УС 0040901
    SK_TUNGUI='skTungui' # СК Тунгуй
    US_SOT_RINOYARVI='usSotRinoyarvi' # УС СОТ "Риноярви"
    SK_BEREZOVSKY_DISTRICT_LOMBOVOZH='skBerezovskyDistrictLombovozh' # СК Березовски район,Ломбовож
    SK_LOPKHARI_SHURYSHKARSKY_DISTRIC='skLopkhariShuryshkarskyDistric' # СК Лопхари (Шурышкарский район)
    US_0073801='us0073801' # УС 0073801
    MSK_881433_HAHYYAH='msk881433Hahyyah' # МСК 88 14:33 Хахыях
    MSK_881433_UORG='msk881433Uorg' # МСК 88 14:33 Уорга
    SK_MOKROUSOVO='skMokrousovo' # СК Мокроусово
    SK_BELOYARSK_CITY='skBeloyarskCity' # СК г. Белоярский
    MSK_LYASKELYA='mskLyaskelya' # МСК п.Ляскеля
    SK_GUSINOE='skGusinoe' # СК Гусиное
    SKALNOE='skalnoe' # СК Травное
    US_SOT_MAGISTRAL='usSotMagistral' # УС СОТ "Магистраль"
    US_SOT_SAMPO='usSotSampo' # УС СОТ "Сампо"
    SK_VOLOGDA='skVologda' # СК г. Вологда
    MSK_OF_ZHELEZNOGORSK_DISTRICT='mskOfZheleznogorskDistrict' # МСК Железногорского р-на
    MSK_881430_UST_MIL='msk881430UstMil' # МСК 88 14:30 Усть-Миль
    MSK_881409_BALA='msk881409Bala' # МСК 88 14:09 Бала
    _1_5_MSK_NOVIKBOZH='15MskNovikbozh' # 15 МСК Новикбож
    SK_ULUGUSHSKOE='skUlugushskoe' # СК Улугушское
    _7_210_KLEPIKOVO='7210Klepikovo' # 7210 с.Клепиково
    LOCAL_CITY_SK='localCitySk' # местная городская СК
    _7_210_D_MEZENKA='7210DMezenka' # 7210 д.Мезенка
    SK_OKTYABRSKOE_VILLAGE='skOktyabrskoeVillage' # СК с.п. Октябрьское
    SK_PETROVSKOE='skPetrovskoe' # СК Петровское
    SK_NOVO_IVANOVSKOE='skNovoIvanovskoe' # СК с.п. Ново-Ивановское
    MSK_DIVEYEVO_SHAKHAEVO='mskDiveyevoShakhaevo' # МСК Дивеево (Шахаево)
    MSK_USSURIYSK='mskUssuriysk' # МСК г.Уссурийск
    SK_LOCAL_KARPINSK='skLocalKarpinsk' # СК местная г.Карпинск
    GVARDEYSKY_DISTRICT='gvardeyskyDistrict' # Гвардейский район
    US_SOT_MARCIAL_1='usSotMarcial1' # УС СОТ "Марциальные1"
    SK_BEREZOVO='skBerezovo' # СК Березово
    LOCAL_PILNINSKY='localPilninsky' # Местная Пильнинский
    MSK_881427_CHERKEKH='msk881427Cherkekh' # МСК 88 14:27 Черкех
    MO_NOYABRSK='moNoyabrsk' # Мо г.Ноябрьск
    SKR='skr' # СК Долгие
    MAMONOVO='mamonovo' # Мамоново
    LOCAL_SK_PLAVSK='localSkPlavsk' # Местная СК г. Плавска
    US_SOT_ANTUSHEVSKOE='usSotAntushevskoe' # УС СОТ "Антушевское"
    SK_LOCAL_ARTYOMOVSKY='skLocalArtyomovsky' # СК местная г.Артемовский
    SK_YAKOVLEVKA='skYakovlevka' # СК Яковлевка
    SK_SHCHIGRY='skShchigry' # СК Щигры
    SK_OF_CADASTRAL_DISTRICT_ZONE_453='skOfCadastralDistrictZone453' # СК кадастрового округа, зона 3
    SK_OF_CADASTRAL_DISTRICT_ZONE_452='skOfCadastralDistrictZone452' # СК кадастрового округа, зона 2
    SK_TAZOVSKY_TAZOVSKY_DISTRICT='skTazovskyTazovskyDistrict' # ск п.Тазовский (Тазовский район)
    SK_AQUEDUCT='skAqueduct' # СК с.п. Акведук
    US_SOT_MELIORATOR_1='usSotMeliorator1' # УС СОТ "Мелиоратор1"
    _7_209_P_NOVIKOVA='7209PNovikova' # 7209 п.Новикова
    MSK_881409_TALA='msk881409Tala' # МСК 88 14:09 Тала
    MSKR_595='mskr595' # МСКР-595
    SC_TEREK='scTerek' # СК г.п. Терек
    MSK_KR_3313_PETUSHKI='mskKr3313 Petushki' # МСК КР 33:13 г. Петушки
    MSK_881433_MARALAYY='msk881433Maralayy' # МСК 88 14:33 Маралайы
    US_0070701='us0070701' # УС 0070701
    MSKR_593='mskr593' # МСКР-593
    MSKR_594='mskr594' # МСКР-594
    US_0072901='us0072901' # УС 0072901
    SK_PSYNODAKHA='skPsynodakha' # СК с.п. Псынодаха
    SK_LOCAL_IS='skLocalIs' # СК местная п.Ис
    SK_BKRKZOVSKY_DISTRICT_KHULIMSUNT='skBkrkzovskyDistrictKhulimsunt' # СК Бкркзовский район, Хулимсунт
    MSK_881416_SYULDYUKAR='msk881416Syuldyukar' # МСК 88 14:16 Сюльдюкар
    CONDITIONAL_KOMBAKOVO='conditionalKombakovo' # Условная (Комбаково)
    LOCAL_TUTAEVA='localTutaeva' # Местная г. Тутаева
    LOCAL_VETLUZHSKY='localVetluzhsky' # Местная Ветлужский
    SK_KAMENNOYE_OKTYABRSKY_DISTRICT='skKamennoyeOktyabrskyDistrict' # СК Каменное Октябрьский район
    MSK_KR_3312_SOBINSKY_DISTRICT_AND_AS='mskKr3312SobinskyDistrictAndAs' # МСК КР 33:12 Собинский район и Асерхово
    _7_210_D_NOVOIVANOVKA='7210DNovoivanovka' # 7210 д.Новоивановка
    STARLINGS_OF_SAGITTARIUS='starlingsOfSagittarius' # СК Стрельцы
    MSK_OF_KHOLMSK='mskOfKholmsk' # МСК г. Холмска
    SHUYA='shuya' # Шуя
    MSK_881433_DYABLA='msk881433Dyabla' # МСК 88 14:33 Дябыла
    UV_COORDINATE_SYSTEM='uvCoordinateSystem' # УФ система координат
    SK_KICHMALKA='skKichmalka' # СК с.п. Кичмалка
    SK_632_ZONE='sk632Zone' # СК 63 2 зона
    US_SOT_ZARECHYE='usSotZarechye' # УС СОТ "Заречье"
    YURIEVETS='yurievets' # Юрьевец
    SK_KHANTY_MUZHI_SHURYSHKARSKY_DIST='skKhantyMuzhiShuryshkarskyDist' # СК д.Ханты-Мужи (Шурышкарский район)
    SKU_YERSHOVKA='skuYershovka' # СК Ершовка
    MSK_KR_3302_KIRZHACH='mskKr3302Kirzhach' # МСК КР 33:02 г. Киржач
    _7_210_D_SIMONOVA='7210DSimonova' # 7210 д.Симонова
    _7_210_BOROVOYE='7210Borovoye' # 7210 с.Боровое
    SK_OF_CADASTRAL_DISTRICT_ZONE_433='skOfCadastralDistrictZone433' # СК кадастрового округа, зона 3
    _7_220_YURGINSKOE='7220Yurginskoe' # 7220 с.Юргинское
    SK_BASKOVSKOE='skBaskovskoe' # СК Басковское
    SK_MISHKINSKY_DISTRICT='skMishkinskyDistrict' # СК Мишкинского района
    SK_LOCAL_KOSYA='skLocalKosya' # СК местная п.Косья
    MSK_881409_OSOKHTOH='msk881409Osokhtoh' # МСК 88 14:09 Осохтох
    US_SOT_GORNYAK='usSotGornyak' # УС СОТ "Горняк"
    MSK_881409_ULAKHAN_KUEL='msk881409UlakhanKuel' # МСК 88 14:09 Улахан-Кюель
    SK_OF_CADASTRAL_DISTRICT_ZONE_431='skOfCadastralDistrictZone431' # СК кадастрового округа, зона 1
    SK_OF_CADASTRAL_DISTRICT_ZONE_432='skOfCadastralDistrictZone432' # СК кадастрового округа, зона 2
    LOCAL_SHARANGA='localSharanga' # Местная Шаранга
    _1_0_MSK_TRAKT='10MskTrakt' # 10 МСК Тракт
    MSK_881427_YTYK_KUEL='msk881427YtykKuel' # МСК 88 14:27 Ытык-Кюель
    _7_216_SDT_HIGHWAY='7216SdtHighway' # 7216 сдт.Магистраль
    MSK_OF_KASTORENSKY_DISTRICT='mskOfKastorenskyDistrict' # МСК Касторенского р-на
    MSK_FATEZHSKY_DISTRICT='mskFatezhskyDistrict' # МСК Фатежского р-на
    SK_DENISOVO='skDenisovo' # СК Денисово
    _7_209_DENISOVO='7209Denisovo' # 7209 с.Денисово
    LOCAL_SK_FORMER_SARATOVSKY_DISTRIC='localSkFormerSaratovskyDistric' # МЕстная СК Бывший Саратовский район
    MSK_87_BILIBINSKY_DISTRICT_ZONE_57='msk87BilibinskyDistrictZone57' # МСК-87 (Билибинский район, зона 5) 7
    MSK_881430_TROITSK='msk881430Troitsk' # МСК 88 14:30 Троицк
    _7_210_GAGARINO='7210Gagarino' # 7210 с.Гагарино
    CONDITIONAL_20_LIPETSK='conditional20Lipetsk' # Условная (20 г.Липецк)
    SK_KOLDRASINSKY='skKoldrasinsky' # СК с.п. Колдрасинский
    MSK_PAVLOVO_GORBATOV='mskPavlovoGorbatov' # МСК Павлово (Горбатов)
    USK_VOSKRESENSK_0080011='uskVoskresensk0080011' # УСК Воскресенск (0080011)
    USC_1414='usc1414' # УСК 14:14
    MSK_ZARECHNY='mskZarechny' # МСК п.Заречный
    USK_VOSKRESENSK_0140007='uskVoskresensk0140007' # УСК Воскресенск (0140007)
    LOCAL_AREA_OF_CHERKESSK='localAreaOfCherkessk' # Местная г Черкесска
    MSK_881432_HARYALYAKH='msk881432Haryalyakh' # МСК 88 14:32 Харыялах
    USC_1418='usc1418' # УСК 14:18
    PILLOWCASES='pillowcases' # Наволоки
    LOCAL_SKOVORODINSKY_DISTRICT='localSkovorodinskyDistrict' # Местная Сковородинский район
    USK_24_NO_14_MINUSINSK='usk24No14Minusinsk' # УСК-24, №14 (г. Минусинск)
    MSK_881430_UST_MAY='msk881430UstMay' # МСК 88 14:30 Усть-Мая
    MSK_OF_NEVELSK='mskOfNevelsk' # МСК г. Невельска
    CONDITIONAL_01_VOLOVSKY_DISTRICT='conditional01VolovskyDistrict' # Условная (01 Воловский район)
    SK_NOVO_KURSKY='skNovoKursky' # СК с.п. Ново-Курский
    US_KHELYULYA='usKhelyulya' # УС с.Хелюля
    CONDITIONAL_09_IZMALKOVSKY_DISTRI='conditional09IzmalkovskyDistri' # Условная (09 Измалковский район)
    _0_4_GMT_NYUVCHIM='04GmtNyuvchim' # 04 МСК Нювчим
    SK_PUKTYSH='skPuktysh' # СК Пуктыш
    USC_1421='usc1421' # УСК 14:21
    MSK_ANIVA='mskAniva' # МСК г. Анива
    _7_212_NIZHNETAVDINSKY_DISTRICT='7212NizhnetavdinskyDistrict' # 7212 - Нижнетавдинский район
    SK_OF_CADASTRAL_DISTRICT_ZONE_893='skOfCadastralDistrictZone893' # СК кадастрового округа, зона 3
    SK_OF_CADASTRAL_DISTRICT_ZONE_894='skOfCadastralDistrictZone894' # СК кадастрового округа, зона 4
    SK_OF_CADASTRAL_DISTRICT_ZONE_891='skOfCadastralDistrictZone891' # СК кадастрового округа, зона 1
    OLD_LOCAL_2603_DIVNOE='oldLocal2603Divnoe' # Старая Местная_2603_Дивное
    SK_OF_CADASTRAL_DISTRICT_ZONE_892='skOfCadastralDistrictZone892' # СК кадастрового округа, зона 2
    SK_NEFTEYUGANSKY_DISTRICT='skNefteyuganskyDistrict' # СК Нефтеюганский район
    _7_217_D_TURAEVA='7217DTuraeva' # 7217 д.Тураева
    OZYORSKY_DISTRICT='ozyorskyDistrict' # Озерский район
    SK_13_ZONE_1='sk13Zone1' # СК - 13, зона 1
    US_SOT_FAMILY='usSotFamily' # УС СОТ "Семья"
    SK_CHEGEM='skChegem' # СК г.п. Чегем
    MSK_881432_POKROVSK='msk881432Pokrovsk' # МСК 88 14:32 Покровск
    SK_SYCHEVO_KURTAMYSHSKY='skSychevoKurtamyshsky' # СК Сычево (Куртамышский)
    MSK_881430_UST_YUDOMA='msk881430UstYudoma' # МСК 88 14:30 Усть-Юдома
    SK_KOZINO='skKozino' # СК Козино
    MSK_881433_ARYLAKH='msk881433Arylakh' # МСК 88 14:33 Арылах
    SK_KULIKOVO_SHCHUCHANSKY='skKulikovoShchuchansky' # СК Куликово (Щучанский)
    OREL_CITY='orelCity' # город Орел
    SK_OF_CADASTRAL_DISTRICT_ZONE_401='skOfCadastralDistrictZone401' # СК кадастрового округа, зона 1
    _6_527_SEVERO_KURILSKY_DISTRICT='6527SeveroKurilskyDistrict' # 6527 Северо-Курильский район
    LOCAL_CHKALOVSKY='localChkalovsky' # Местная Чкаловский
    SK_POLEVOE='skPolevoe' # СК Полевое
    MSK_PARTIZANSKY_DISTRICT='mskPartizanskyDistrict' # МСК Партизанский район
    SK_ARIK='skArik' # СК с.п. Арик
    SK_SURGUTSKY_DISTRICT='skSurgutskyDistrict' # СК Сургутский район
    KINESHEMSKY_DISTRICT='kineshemskyDistrict' # Кинешемский
    SK_LABOROVAYA_PRIURALSKY_DISTRICT='skLaborovayaPriuralskyDistrict' # СК Лаборовая (Приуральский район)
    MSK_354_ZONE='msk354Zone' # МСК-35 4 зона
    MSK_S_VEDLOZERO='mskSVedlozero' # МСК с.Ведлозеро
    MSK_881402_YAKOKUT='msk881402Yakokut' # МСК 88 14:02 Якокут
    SK_LOCAL_VERKHNYAYA_TURA='skLocalVerkhnyayaTura' # СК местная г.Верхняя Тура
    CONDITIONAL_D_RAKOVICHI='conditionalDRakovichi' # Условная (д.Раковичи)
    SK_63_Q_4='sk63Q4' # СК 63 Q4
    KRASNOZNAMENSKIY_DISTRICT='krasnoznamenskiyDistrict' # Краснознаменский район
    USK_VOSKRESENSK_0080006='uskVoskresensk0080006' # УСК Воскресенск (0080006)
    SK_BASKAZYK='skBaskazyk' # СК Басказык
    US_GIRVAS='usGirvas' # УС п.Гирвас
    _7_217_SDT_FRIENDSHIP='7217SdtFriendship' # 7217 сдт.Дружба
    GURIEVSK_SETTLEMENTS='gurievskSettlements' # Гурьевск(поселки)
    LOCAL_BLAGOVESHCHENSK='localBlagoveshchensk' # Местная г.Благовещенск
    US_UTOZERO='usUtozero' # УС д.Утозеро
    US_SOT_SYAMOZERSKOE='usSotSyamozerskoe' # УС СОТ "Сямозерское"
    MSK_87_CHAUNSKY_DISTRICT='msk87ChaunskyDistrict' # МСК-87 (Чаунский район)
    MSK_KORYAZHMA='mskKoryazhma' # МСК г. Коряжма
    _7_204_BERDYUZHYE='7204Berdyuzhye' # 7204 с.Бердюжье
    LOCAL_SLANTSY='localSlantsy' # Mестная (г. Сланцы)
    _7_201_ABATSKY_DISTRICT='7201AbatskyDistrict' # 7201 - Абатский район
    CONDITIONAL_D_BANKOVO='conditionalDBankovo' # Условная (д.Баньково)
    MSK_881414_LENSK='msk881414Lensk' # МСК 88 14:14 Ленск
    MSK_SPASSKY_DISTRICT='mskSpasskyDistrict' # МСК Спасский район
    CONDITIONAL_KINGISEPP='conditionalKingisepp' # Условная(Кингисеппский)
    MSK_D_NIZHNY_BESOVETS='mskDNizhnyBesovets' # МСК д.Нижний Бесовец
    SK_KORYUKOVO='skKoryukovo' # СК Корюково
    MSK_881409_METYAKI='msk881409Metyaki' # МСК 88 14:09 Метяки
    LOCAL_VILLAGE_OF_PRECHISTOE='localVillageOfPrechistoe' # Местная п. Пречистое
    SK_NADYM='skNadym' # СК г.Надым
    SK_YALYM='skYalym' # СК Ялым
    MSK_53_ZONE_2='msk53Zone2' # МСК 53 (Зона-2)
    LADUSHKIN='ladushkin' # Ладушкин
    SK_BATYREVO='skBatyrevo' # СК Батырево
    _7_218_ALYMKA_VILLAGE='7218AlymkaVillage' # 7218 с.Алымка
    SK_NOVO_VOZNESENSKY='skNovoVoznesensky' # СК с.п. Ново-Вознесенский
    MSK_53_ZONE_3='msk53Zone3' # МСК 53 (Зона-3)
    _7_210_D_HAULERS='7210DHaulers' # 7210 д.Бурлаки
    NEFTEYUGANSK_CITY='nefteyuganskCity' # г.Нефтеюганск
    MSK_OF_THE_VILLAGE_YARN='mskOfTheVillageYarn' # МСК пгт.Пряжа
    MSK_70_ZONE_2='msk70Zone2' # МСК 70, зона 2
    MSK_KOTLAS='mskKotlas' # МСК г. Котлас
    MSK_70_ZONE_3='msk70Zone3' # МСК 70, зона 3
    _7_217_D_SMALL_AKIYARS='7217DSmallAkiyars' # 7217 д.Малые Акияры
    MSK_70_ZONE_4='msk70Zone4' # МСК 70, зона 4
    MSK_70_ZONE_5='msk70Zone5' # МСК 70, зона 5
    SK_LOCAL_ATIG='skLocalAtig' # СК местная р.п.Атиг
    SK_KEYS='skKeys' # СК Ключики
    USC_RED_TANKS_0090004='uscRedTanks0090004' # УСК Красные баки (0090004)
    _1_963_VOLKHOVSKY='1963Volkhovsky' # 1963 (Волховский)
    _7_218_P_IVANOVKA='7218PIvanovka' # 7218 с.Ивановка
    SK_LOCAL_SEROV='skLocalSerov' # СК местная г.Серов
    _1_7_MSK_VUKTYL='17MskVuktyl' # 17 МСК Вуктыл
    SK_ISLAMEY='skIslamey' # СК с.п. Исламей
    LOCAL_SERYSHEVSKY_DISTRICT='localSeryshevskyDistrict' # Местная Серышевский район
    _1_0_MSK_EMBA='10MskEmba' # 10 МСК Емва
    SK_CHEREPOVETS_LOCAL='skCherepovetsLocal' # СК Череповецкий местная
    LOCAL_MANTUROVO='localManturovo' # Местная_г.Мантурово
    SC_PODGORNAYA='scPodgornaya' # СК Подгорная
    _2_0_MSK_YAREGA='20MskYarega' # 20 МСК Ярега
    SK_BELOYARSK_DISTRICT_PASHTORI='skBeloyarskDistrictPashtori' # СК Белоярский район, Паштори
    _7_209_SUNRISE='7209Sunrise' # 7209 с.Рассвет
    SK_LOCAL_NIZHNYAYA_SALDA='skLocalNizhnyayaSalda' # СК местная г.Нижняя Салда
    US_KUKKOIL='usKukkoil' # УС д.Куккойла
    US_SOT_IMPULSE_1020='usSotImpulse1020' # УС СОТ "Импульс" 10:20
    SK_AKTABAN='skAktaban' # СК Актабан
    MSK_CHERNIHIV_DISTRICT='mskChernihivDistrict' # МСК Черниговский район
    LOCAL_KURGOLOVO_SETTLEMENT='localKurgolovoSettlement' # местная (п.Курголово)
    IVANOVO='ivanovo' # Иваново
    SK_CHESNOKI='skChesnoki' # СК Чесноки
    STATE_196344='state196344' # Государственная, 1963 г.
    SK_KONDINSKY_DISTRICT='skKondinskyDistrict' # СК Кондинский район
    MSK_OF_THE_VILLAGE_KALEVALA='mskOfTheVillageKalevala' # МСК пгт.Калевала
    SK_ZOTINO='skZotino' # СК Зотино
    SK_ALEXANDROVSKAYA='skAlexandrovskaya' # СК с.п. Александровская
    _7_221_YALUTOROVSKY_DISTRICT='7221YalutorovskyDistrict' # 7221 - Ялуторовский район
    SK_MOREVNOYE='skMorevnoye' # СК Моревное
    SK_SARATOVSKY='skSaratovsky' # СК с.п. Саратовский
    LOCAL_LUZHSKY_DISTRICT_DERGOVO='localLuzhskyDistrictDergovo' # Местная_(Лужский_ район)
    SK_BELOVO='skBelovo' # СК Белово
    MSK_881428_ARY_TOLON='msk881428AryTolon' # МСК 88 14:28 Ары-Толон
    LOCAL_VILLAGE_OF_NEKOUZ='localVillageOfNekouz' # Местная п. Некоуз
    SK_OKTYABRSKY_DISTRICT_GORNORENSK='skOktyabrskyDistrictGornorensk' # СК Октябрьский район Горноренск ПБ
    SK_PRIDOROZHNOYE='skPridorozhnoye' # СК с.п. Придорожное
    US_SOT_SUNNY_1020='usSotSunny1020' # УС СОТ "Солнечный" 10:20
    SK_OF_THE_CADASTRAL_DISTRICT_166='skOfTheCadastralDistrict166' # СК кадастрового округа 166
    MSK_KONDOPOGA='mskKondopoga' # МСК г.Кондопога
    SK_LOCAL_VERKHNYAYA_SALDA='skLocalVerkhnyayaSalda' # СК местная г.Верхняя Салда
    SK_KHANTY_MANSIYSK_DISTRICT='skKhantyMansiyskDistrict' # СК Ханты-Мансийский район
    SK_PETROVKA='skPetrovka' # СК Петровка
    CONDITION_DOMKINO='conditionDomkino' # Условная_(д.Домкино)
    US_PUDOZHGORSKY='usPudozhgorsky' # УС п.Пудожгорский
    SK_UTICHYE_SHCHUCHANSKY='skUtichyeShchuchansky' # СК Утичье (Щучанский)
    SK_PETRUSHINO='skPetrushino' # СК Петрушино
    LOCAL_RED_OCTOBER='localRedOctober' # Местная Красный Октябрь
    SK_VERKHNYAYA_BALKARIYA='skVerkhnyayaBalkariya' # СК с.п. Верхняя Балкария
    USK_TONSHAYEVO_BUREPOLOM='uskTonshayevoBurepolom' # УСК Тоншаево (Буреполом)
    SK_VINOGRADOVSKY_DISTRICT_UST_VASA='skVinogradovskyDistrictUstVasa' # СК Виноградовского района(Усть Васа)
    SK_BEZENGI='skBezengi' # СК с.п. Безенги
    SK_1963_ZONE_3='sk1963Zone3' # СК 1963 г., зона 3
    MSK_881402_VERKHNY_KURANAKH='msk881402VerkhnyKuranakh' # МСК 88 14:02 Верхний Куранах
    SK_1963_ZONE_1='sk1963Zone1' # СК 1963 г., зона 1
    SK_BABAEVO='skBabaevo' # СК г. Бабаево
    MSK_881419_BOLSHOY_KHATAMI='msk881419BolshoyKhatami' # МСК 88 14:19 Большой_Хатыми
    US_SOT_SILHOUETTE='usSotSilhouette' # УС СОТ "Силуэт"
    US_SOT_RUNES='usSotRunes' # УС СОТ "Руны"
    SK_OKTYABRSKY_DISTRICT_ANDRA_PB='skOktyabrskyDistrictAndraPb' # СК Октябрьский район, АНДРА ПБ
    US_SOT_ONEGA_DAWNS='usSotOnegaDawns' # УС СОТ "Онежские зори"
    _7_209_STANICHNOYE='7209Stanichnoye' # 7209 с.Станичное
    MSK_OF_MEDVENSKY_DISTRICT='mskOfMedvenskyDistrict' # МСК Медвенского р-на
    BOLSHOE_KASARGULSKOE_SPORTS_COMPL='bolshoeKasargulskoeSportsCompl' # СК Большое Касаргульское
    NEMAN_CITY='nemanCity' # г. Неман
    SK_VOSYAKHOVO_SHURYSHKARSKY_DISTR='skVosyakhovoShuryshkarskyDistr' # СК с.Восяхово (Шурышкарский район)
    MSK_OF_VINOGRADOVSKY_DISTRICT='mskOfVinogradovskyDistrict' # МСК Виноградовского района
    SK_MST_MISHKINSKY='skMstMishkinsky' # СК МСТ (Мишкинский)
    US_SOT_SUNNY_1007='usSotSunny1007' # УС СОТ "Солнечный" 10:07
    SK_HAMIDIYE='skHamidiye' # СК с.п.Хамидие
    US_SOT_CAMOMILE_1020='usSotCamomile1020' # УС СОТ "Ромашка" 10:20
    MALAYA_GORBUNOVA_SPORTS_COMPLEX='malayaGorbunovaSportsComplex' # СК Малая Горбунова
    SK_MALOE_KUREYNOE='skMaloeKureynoe' # СК Малое Курейное
    US_SOT_KVANT='usSotKvant' # УС СОТ "Квант"
    _0_4_USK_CHASOVO='04UskChasovo' # 04 УСК Часово
    SK_OF_THE_VILLAGE_OF_AZOV_SHURYSHKAR='skOfTheVillageOfAzovShuryshkar' # СК с.Азовы (Шурышкарский район)
    MSK_KR_3326_MUROM='mskKr3326Murom' # МСК КР 33:26 г. Муром
    LOCAL_SOSNOVY_BOR='localSosnovyBor' # Местная (г. Сосновый Бор)
    SK_SOVETSKAYA='skSovetskaya' # СК Советская
    MSK_OF_THE_VILLAGE_OF_CHUPA='mskOfTheVillageOfChupa' # МСК пгт.Чупа
    _7_225_ISHIM_CITY='7225IshimCity' # 7225 - г. Ишим
    SK_KURTAMYSH='skKurtamysh' # СК Куртамыш
    SK_VOSKRESENSKOE='skVoskresenskoe' # СК Воскресенское
    MSK_50_ZONE_1='msk50Zone1' # МСК-50, зона 1
    MSK_50_ZONE_2='msk50Zone2' # МСК-50, зона 2
    US_SOT_NYUK='usSotNyuk' # УС СОТ "Нюк"
    SKOBYANSKOE='skobyanskoe' # СК Глядянское
    _7_210_D_NALIMOVA_STREET='7210DNalimovaStreet' # 7210 д.Налимова
    _7_217_TYUMEN_REGION='7217TyumenRegion' # 7217 - Тюменский район
    US_0040106='us0040106' # УС 0040106
    USK_VOSKRESENSK_0120004='uskVoskresensk0120004' # УСК Воскресенск (0120004)
    US_SOT_MEKHANIZATOR='usSotMekhanizator' # УС СОТ "Механизатор"
    _7_217_D_NARIMANOVA='7217DNarimanova' # 7217 д.Нариманова
    SK_NIKOLAEVKA_SHCHUCHANSKY='skNikolaevkaShchuchansky' # СК Николаевка (Щучанский)
    US_SOT_SVYAZIST='usSotSvyazist' # УС СОТ "Связист"
    MSK_881427_HARBALA='msk881427Harbala' # МСК 88 14:27 Харбалах
    LOCAL_SVOBODNY='localSvobodny' # Местная г.Свободный
    _7_201_ABATSKOE_LAKE='7201AbatskoeLake' # 7201 с.Абатское
    SK_BOLSHOE_ZASLOSTOE='skBolshoeZaslostoe' # СК Большое Зарослое
    SK_OF_CADASTRAL_DISTRICT_ZONE_914='skOfCadastralDistrictZone914' # СК кадастрового округа, зона 1
    MSK_66_ZONE_2='msk66Zone2' # МСК-66, зона 2
    MEZHEUMNOYE_SHOPPING_CENTER='mezheumnoyeShoppingCenter' # СК Межеумное
    MSK_66_ZONE_1='msk66Zone1' # МСК - 66, зона 1
    SK_MST_PETUKHOVSKY='skMstPetukhovsky' # СК МСТ (Петуховский)
    MAMONOVSKY_DISTRICT='mamonovskyDistrict' # Мамоновский район
    KRASNOZNAMENSKOE_SPORTS_COMPLEX='krasnoznamenskoeSportsComplex' # СК Краснознаменское
    SK_NOVOTROITSKOE='skNovotroitskoe' # СК Новотроицкое
    SK_KURGAN='skKurgan' # СК г.Курган
    LOCAL_SK='localSk' # Местная СК
    _7_209_D_CUCKOOS='7209DCuckoos' # 7209 д.Кукушки
    LOCAL_OF_PERESLAVL_ZALESSKY='localOfPereslavlZalessky' # Местная г. Переславля-Залесского
    DUBROVNOYE_SPORTS_COMPLEX_VARGASH='dubrovnoyeSportsComplexVargash' # СК Дубровное (Варгашинский район)
    MSK_881433_CHURAPCHA='msk881433Churapcha' # МСК 88 14:33 Чурапча
    LOCAL_IC_URYUPINSK='localIcUryupinsk' # местная СК г. Урюпинск
    LOCAL_VACHSKY='localVachsky' # Местная Вачский
    SK_OF_CADASTRAL_DISTRICT_ZONE_905='skOfCadastralDistrictZone905' # СК кадастрового округа, зона 2
    SK_OF_CADASTRAL_DISTRICT_ZONE_904='skOfCadastralDistrictZone904' # СК кадастрового округа, зона 1
    _7_210_OZHOGINO='7210Ozhogino' # 7210 с.Ожогино
    US_SOT_UROZHAY='usSotUrozhay' # УС СОТ "Урожай"
    SK_63='sk63' # СК 63
    MALOE_MOSTOVSKOE_SPORTS_COMPLEX='maloeMostovskoeSportsComplex' # СК Малое Мостовское
    SK_LESNOY='skLesnoy' # СК Лесной
    SKOLKOVO='skolkovo' # СК Рычково
    MSK_881432_KERDEM='msk881432Kerdem' # МСК 88 14:32 Кердем
    US_SOT_DMITROVKA='usSotDmitrovka' # УС СОТ "Дмитровка"
    SK_KHABAZ='skKhabaz' # СК с.п. Хабаз
    SK_PLOTNIKOVO='skPlotnikovo' # СК Плотниково
    SK_OKTYABRSKY_DISTRICT_TALINKA_PB='skOktyabrskyDistrictTalinkaPb' # СК Октябрьский район Талинка ПБ
    MSK_881433_OGUSUR='msk881433Ogusur' # МСК 88 14:33 Огусур
    MSK_SHKOTOVSKY_DISTRICT='mskShkotovskyDistrict' # МСК Шкотовский район
    SK_OKTYABRSKY_DISTRICT='skOktyabrskyDistrict' # СК Октябрьский район
    _7_209_D_PASTUKHOVA_STREET='7209DPastukhovaStreet' # 7209 д.Пастухова
    MSK_DIVEYEVO_SYRESEVO='mskDiveyevoSyresevo' # МСК Дивеево (Сыресево)
    SK_BELOKAMENSKOE='skBelokamenskoe' # СК с.п. Белокаменское
    LOCAL_SOSNOVSKOE='localSosnovskoe' # Местная Сосновское
    _1_1_MSK_TROITSKO_PECHORSK='11MskTroitskoPechorsk' # 11 МСК Троицко-Печорск
    KRASNOGORKA_SPORTS_COMPLEX='krasnogorkaSportsComplex' # СК Красногорка
    SK_KREMENCHUG_KONSTANTINOVSKOE='skKremenchugKonstantinovskoe' # СК с.п. Кременчуг-Константиновское
    SK_LOCAL_NOVOURALSK='skLocalNovouralsk' # СК местная г.Новоуральск
    _7_201_TUSHNOLOBOVO='7201Tushnolobovo' # 7201 с.Тушнолобово
    USK_TONSHAYEVO_SHAIGINO='uskTonshayevoShaigino' # УСК Тоншаево (Шайгино)
    UPPER_LANDEH='upperLandeh' # Верхний Ландех
    SOUTH='south' # Южа
    _7_216_SDT_TRANSPORT_BUILDER='7216SdtTransportBuilder' # 7216 сдт.Транспортный строитель
    MSK_KR_3322_VLADIMIR='mskKr3322 Vladimir' # МСК КР 33:22 г. Владимир
    US_SOT_MICHURINETS='usSotMichurinets' # УС СОТ "Мичуринец"
    MSK_33_ZONE_1='msk33Zone1' # МСК-33, зона 1
    US_SOT_CHUPA='usSotChupa' # УС СОТ "Чупа"
    USC_KRASNYE_BAKI_0020007='uscKrasnyeBaki0020007' # УСК Красные баки (0020007)
    MSK_881433_KYUNGDAL='msk881433Kyungdal' # МСК 88 14:33 Кындал
    USC_KRASNYE_BAKI_0020008='uscKrasnyeBaki0020008' # УСК Красные баки (0020008)
    SK_KONDINSKY_DISTRICT_KONDINSK='skKondinskyDistrictKondinsk' # СК Кондинский район,Кондинск
    CONDITIONAL_BETKOVO_VILLAGE='conditionalBetkovoVillage' # Условная (д.Бетково)
    MSK_SUBJECT_56_ZONE_4='mskSubject56Zone4' # МСК - субъект 56, зона 4
    _7_209_LOGA_VILLAGE='7209LogaVillage' # 7209 д.Лога
    MSK_881432_CHAPAEVO='msk881432Chapaevo' # МСК 88 14:32 Чапаево
    MSK_SUBJECT_56_ZONE_2='mskSubject56Zone2' # МСК - субъект 56, зона 2
    SK_KARAGACH='skKaragach' # СК с.п. Карагач
    MSK_SUBJECT_56_ZONE_3='mskSubject56Zone3' # МСК - субъект 56, зона 3
    SK_OKTYABRSKY_DISTRICT_KARYMKARY_P='skOktyabrskyDistrictKarymkaryP' # СК Октябрьский район Карымкары ПБ
    SK_KAYASAN='skKayasan' # СК Каясан
    MSK_SUBJECT_56_ZONE_1='mskSubject56Zone1' # МСК - субъект 56, зона 1
    SK_GRABOVETS='skGrabovets' # СК с.п. Грабовец
    CITY_OF_KRASNOZNAMENSK='cityOfKrasnoznamensk' # г. Краснознаменск
    SK_KETOVO='skKetovo' # СК Кетово
    _7_201_D_KAREGLAZOVA='7201DKareglazova' # 7201 д.Кареглазова
    SK_MST_PRITOBOLNY='skMstPritobolny' # СК МСТ (Притобольный)
    USC_KRASNYE_BAKI_0020002='uscKrasnyeBaki0020002' # УСК Красные баки (0020002)
    SK_MIKHAYLOVKA_SHCHUCHANSKY='skMikhaylovkaShchuchansky' # СК Михайловка (Щучанский)
    SK_ZALUKODES='skZalukodes' # СК с.п. Залукодес
    _7_219_D_NIHODSKAYA='7219DNihodskaya' # 7219 д.Ниходская
    SK_VINOGRADNOYE='skVinogradnoye' # СК с.п. Виноградное
    US_SOT_PELDOZHSKY='usSotPeldozhsky' # УС СОТ "Пелдожский"
    SK_SUKHOBORSKOE='skSukhoborskoe' # СК Сухоборское
    _0_4_USK_GAVRILOVKA='04UskGavrilovka' # 04 УСК Гавриловка
    US_0072101='us0072101' # УС 0072101
    MSK_881432_MSK='msk881432Msk' # МСК 88 14:32 Синск
    SK_SHASTOVO='skShastovo' # СК Шастово
    US_SOT_LESNOYE='usSotLesnoye' # УС СОТ "Лесное"
    SK_ZAYUKOVO='skZayukovo' # СК с.п. Заюково
    SK_NOVY_KYIVAT='skNovyKyivat' # СК д.Новый киеват
    SK_SP_ZH_D_ST_SOLDATSKAYA='skSPZhDStSoldatskaya' # СК с.п. ж.д. Ст. Солдатская
    SK_OKTYABRSKY_DISTRICT_PEREGREBNO='skOktyabrskyDistrictPeregrebno' # СК Октябрьский район Перегребное ПБ
    SK_KONDINSKY_DISTRICT_UCHYA='skKondinskyDistrictUchya' # СК Кондинский район, Uchya
    THE_SQUIB='theSquib' # СК Утичье
    CONDITIONAL_16_USMANSKY_DISTRICT='conditional16UsmanskyDistrict' # Условная (16 Усманский район)
    LOCAL_SYSTEM_OF_D_GORBUNIKHA='localSystemOfDGorbunikha' # Местная система д. Горбуниха
    SK_OSHURKOVO='skOshurkovo' # СК Ошурково
    SK_REEDS='skReeds' # СК Камыши
    US_SOT_RUDNIK='usSotRudnik' # УС СОТ "Рудник"
    _2_0_MSK_KEDVAVOM='20MskKedvavom' # 20 МСК Кедвавом
    MSK_73_ZONE_2='msk73Zone2' # МСК-73
    USK_24_NO_184='usk24No184' # УСК-24, №184
    SK_BELOYARSK_DISTRICT_SOSNOVKA='skBeloyarskDistrictSosnovka' # СК Белоярский район,Сосновка
    MSK_73_ZONE_1='msk73Zone1' # МСК - 73
    SK_SYCHEVO='skSychevo' # СК Сычево
    MSK_KR_3314_GUS_KHRUSTALNY_DISTRICT='mskKr3314GusKhrustalnyDistrict' # МСК КР 33:14 Гусь-Хрустальный район
    _7_210_D_BUTYRKI='7210DButyrki' # 7210 д.Бутырки
    _7_204_BERDYUZHSKY_DISTRICT='7204BerdyuzhskyDistrict' # 7204 - Бердюжский район
    _7_209_ARKHANGELSK_REGION='7209ArkhangelskRegion' # 7209 с.Архангельское
    MSK_KAVALEROVSKY_DISTRICT='mskKavalerovskyDistrict' # МСК Кавалеровский район
    _7_217_D_GOLOVINA='7217DGolovina' # 7217 д.Головина
    US_SOT_ENERGETIK_1='usSotEnergetik1' # УС СОТ "Энергетик-1"
    US_SOT_ENERGETIK_3='usSotEnergetik3' # УС СОТ "Энергетик-3"
    LOCAL_LUZHSKY_DISTRICT_ZAMOSHYE='localLuzhskyDistrictZamoshye' # Местная_(Лужский район)
    MSK_OF_SOVETSKY_DISTRICT='mskOfSovetskyDistrict' # МСК Советского р-на
    _7_209_KRASNOVO='7209Krasnovo' # 7209 с.Красново
    MSK_881430_YUGORENOK='msk881430Yugorenok' # МСК 88 14:30 Югоренок
    SK_VERKHNY_KURKUZHIN='skVerkhnyKurkuzhin' # СК с.п. Верхний Куркужин
    SK_VINOGRADOVSKY_DISTRICT_120101='skVinogradovskyDistrict120101' # СК Виноградовского района(120101)
    SK_63_Q_5_TRUNCATED='sk63Q5Truncated' # СК 63 Q5 усеченная
    SK_PASHKOVO='skPashkovo' # СК Пашково
    _7_209_SLOBODA_BESHKIL='7209SlobodaBeshkil' # 7209 с.Слобода-Бешкиль
    MSK_881402_ALDAN='msk881402Aldan' # МСК 88 14:02 Алдан
    US_COAST='usCoast' # УС д.Побережье
    SK_YABLOCHNOYE='skYablochnoye' # СК Яблочное
    _7_210_D_NOVOKAZANKA='7210DNovokazanka' # 7210 д.Новоказанка
    MSK_63_ZONE_4='msk63Zone4' # МСК-63, зона 4
    MSK_881432_MOKHSOGOLLOH='msk881432Mokhsogolloh' # МСК 88 14:32 Мохсоголлох
    MSK_63_ZONE_5='msk63Zone5' # МСК-63, зона 5
    SK_KURTAN='skKurtan' # СК Куртан
    SK_OF_1963_CONDITIONAL_SK='skOf1963ConditionalSk' # СК 1963 г., условная СК
    BIYSK_CITY='biyskCity' # г. Бийск
    CONDITIONAL_06_DOLGORUKOVSKY_DIST='conditional06DolgorukovskyDist' # Условная (06 Долгоруковский район)
    _7_215_P_POKROVKA_STREET='7215PPokrovkaStreet' # 7215 с.Покровка
    LOCAL_SK_GUBKINSKY='localSkGubkinsky' # Местная СК Губкинский
    US_0073401='us0073401' # УС 0073401
    SK_SHORDAKOVO='skShordakovo' # СК с.п. Шордаково
    _1_2_USK_PECHORA='12UskPechora' # 12 УСК Печора
    SK_OF_THE_CADASTRAL_DISTRICT_1='skOfTheCadastralDistrict1' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_2='skOfTheCadastralDistrict2' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_3='skOfTheCadastralDistrict3' # СК кадастрового округа
    US_SOT_LOSOSINKA='usSotLososinka' # УС СОТ "Лососинка"
    SK_OF_THE_CADASTRAL_DISTRICT_4='skOfTheCadastralDistrict4' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_5='skOfTheCadastralDistrict5' # СК кадастрового округа
    SK_SHEKSNA='skSheksna' # СК п. Шексна
    SK_OF_THE_CADASTRAL_DISTRICT_6='skOfTheCadastralDistrict6' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_7='skOfTheCadastralDistrict7' # СК кадастрового округа
    MSK_881433_ULAKHAN_EBYA='msk881433UlakhanEbya' # МСК 88 14:33 Улахан-Эбя
    SK_OF_THE_CADASTRAL_DISTRICT_8='skOfTheCadastralDistrict8' # СК кадастрового округа
    SK_OF_THE_CADASTRAL_DISTRICT_9='skOfTheCadastralDistrict9' # СК кадастрового округа
    LOCAL_OF_ROSTOV='localOfRostov' # Местная г. Ростова
    MSK_881409_HAYSARDAH='msk881409Haysardah' # МСК 88 14:09 Хайысардах
    MSK_881409_SITES='msk881409Sites' # МСК 88 14:09 Сайды
    _1_963_LUZHSKY='1963Luzhsky' # 1963 (Лужский)
    SK_VOLOSNIKOVO='skVolosnikovo' # СК Волосниково
    MSK_881409_UST_CHARKY='msk881409UstCharky' # МСК 88 14:09 Усть-Чаркы
    _7_218_P_KRASNY_YAR='7218PKrasnyYar' # 7218 с.Красный Яр
    MSK_87_ANADYR_DISTRICT_ZONE_6='msk87AnadyrDistrictZone6' # МСК-87 (Анадырский район, зона 6)
    BOLSHOY_KAMAGAN_SPORTS_COMPLEX='bolshoyKamaganSportsComplex' # СК Большой Камаган
    US_LEDMOZERO='usLedmozero' # УС д.Ледмозеро
    MSK_881428_MEGINO_ALDAN='msk881428MeginoAldan' # МСк 88 14:28 Мегино-Алдан
    MSK_DIVEYEVO_CHEREVATOVO_METRO_STA='mskDiveyevoCherevatovoMetroSta' # МСК Дивеево (М. Череватово)


class CountryKindEType(str, Enum):
    """CountryKindEType -- С
    т
    р
    а
    н
    ы
    м
    и
    р
    а
    
    """
    _1_91='191' # Республика Хорватия
    _1_92='192' # Республика Куба
    _0_72='072' # Республика Ботсвана
    _5_91='591' # Республика Панама
    _4_70='470' # Республика Мальта
    _1_96='196' # Республика Кипр
    _0_76='076' # Федеративная Республика Бразилия
    _3_52='352' # Республика Исландия
    _2_31='231' # Федеративная Демократическая Республика Эфиопия
    _2_32='232' # Государство Эритрея
    _2_33='233' # Эстонская Республика
    _1_12='112' # Республика Беларусь
    _7_52='752' # Королевство Швеция
    _5_98='598' # Независимое Государство Папуа Новая Гвинея
    _3_56='356' # Республика Индия
    _4_78='478' # Исламская Республика Мавритания
    _5_12='512' # Султанат Оман
    _1_16='116' # Королевство Камбоджа
    _6_34='634' # Государство Катар
    _7_56='756' # Швейцарская Конфедерация
    _5_16='516' # Республика Намибия
    _4_80='480' # Республика Маврикий
    _3_60='360' # Республика Индонезия
    _1_20='120' # Республика Камерун
    _4_84='484' # Мексиканские Соединенные Штаты
    _2_42='242' # Республика Фиджи
    _3_64='364' # Исламская Республика Иран
    _8_82='882' # Независимое Государство Самоа
    _7_62='762' # Республика Таджикистан
    _5_20='520' # Республика Науру
    _4_00='400' # Иорданское Хашимитское Королевство
    _2_46='246' # Финляндская Республика
    _0_04='004' # Переходное Исламское Государство Афганистан
    _7_64='764' # Королевство Таиланд
    _6_43='643' # Российская Федерация
    _3_68='368' # Республика Ирак
    _8_87='887' # Йеменская Республика
    _8_00='800' # Республика Уганда
    _6_46='646' # Руандийская Республика
    _4_04='404' # Республика Кения
    _0_08='008' # Республика Албания
    _7_68='768' # Тоголезская Республика
    _5_28='528' # Королевство Нидерландов
    _4_08='408' # Корейская Народно-Демократическая Республика
    _8_07='807' # Республика Северная Македония
    _0_92='092' # Британские Виргинские острова
    _4_92='492' # Княжество Монако
    _2_50='250' # Французская Республика
    _1_32='132' # Республика Кабо-Верде
    _0_12='012' # Алжирская Народная Демократическая Республика
    _3_76='376' # Государство Израиль
    _4_98='498' # Республика Молдова
    _4_10='410' # Республика Корея
    _8_94='894' # Республика Замбия
    _8_95='895' # Республика Абхазия
    _8_96='896' # Республика Южная Осетия
    _7_76='776' # Королевство Тонга
    _8_97='897' # Донецкая Народная Республика
    _4_14='414' # Государство Кувейт
    _8_98='898' # Луганская Народная Республика
    _4_17='417' # Киргизская Республика
    _8_18='818' # Арабская Республика Египет
    _3_80='380' # Итальянская Республика
    _2_62='262' # Республика Джибути
    _0_20='020' # Княжество Андорра
    _7_80='780' # Республика Тринидад и Тобаго
    _3_84='384' # Республика Кот д'Ивуар
    _1_44='144' # Демократическая Социалистическая Республика Шри-Ланка
    _2_66='266' # Габонская Республика
    _0_24='024' # Республика Ангола
    _3_00='300' # Греческая Республика
    _4_22='422' # Ливанская Республика
    _1_48='148' # Республика Чад
    _7_88='788' # Тунисская Республика
    _4_26='426' # Королевство Лесото
    _7_02='702' # Республика Сингапур
    _5_48='548' # Республика Вануату
    _7_03='703' # Словацкая Республика
    _4_28='428' # Латвийская Республика
    _7_04='704' # Социалистическая Республика Вьетнам
    _8_26='826' # Соединенное Королевство Великобритании и Северной Ирландии
    _7_05='705' # Республика Словения
    _7_06='706' # Федеративная Республика Сомали
    _2_70='270' # Исламская Республика Гамбия
    _1_52='152' # Республика Чили
    _0_31='031' # Республика Азербайджан
    _0_32='032' # Аргентинская Республика
    _7_92='792' # Турецкая Республика
    _2_75='275' # Государство Палестина
    _4_30='430' # Республика Либерия
    _2_76='276' # Федеративная Республика Германия
    _3_98='398' # Республика Казахстан
    _1_56='156' # Китайская Народная Республика
    _7_95='795' # Туркменистан
    _6_74='674' # Республика Сан-Марино
    _4_34='434' # Государство Ливия
    _7_10='710' # Южно-Африканская Республика
    _6_78='678' # Демократическая Республика Сан-Томе и Принсипи
    _5_58='558' # Республика Никарагуа
    _4_38='438' # Княжество Лихтенштейн
    _8_34='834' # Объединенная Республика Танзания
    _7_16='716' # Республика Зимбабве
    _0_40='040' # Австрийская Республика
    _6_82='682' # Королевство Саудовская Аравия
    _4_40='440' # Литовская Республика
    _0_44='044' # Содружество Багамы
    _5_62='562' # Республика Нигер
    _3_20='320' # Республика Гватемала
    _4_42='442' # Великое Герцогство Люксембург
    _2_88='288' # Республика Гана
    _6_86='686' # Республика Сенегал
    _0_48='048' # Королевство Бахрейн
    _8_40='840' # Соединенные Штаты Америки
    _5_66='566' # Федеративная Республика Нигерия
    _3_24='324' # Гвинейская Республика
    _2_03='203' # Чешская Республика
    _6_88='688' # Республика Сербия
    _6_00='600' # Республика Парагвай
    _4_46='446' # Специальный административный район Макао Китайской Народной Республики
    _2_04='204' # Республика Бенин
    _7_24='724' # Королевство Испания
    _3_28='328' # Кооперативная Республика Гайана
    _6_04='604' # Республика Перу
    _2_08='208' # Королевство Дания
    _7_28='728' # Республика Южный Судан
    _7_29='729' # Республика Судан
    _6_08='608' # Республика Филиппины
    _1_70='170' # Республика Колумбия
    _0_50='050' # Народная Республика Бангладеш
    _0_51='051' # Республика Армения
    _6_90='690' # Республика Сейшелы
    _5_70='570' # Ниуэ
    _1_74='174' # Союз Коморы
    _4_50='450' # Республика Мадагаскар
    _2_96='296' # Республика Кирибати
    _6_94='694' # Республика Сьерра-Леоне
    _0_56='056' # Королевство Бельгия
    _3_32='332' # Республика Гаити
    _1_78='178' # Республика Конго
    _4_54='454' # Республика Малави
    _2_12='212' # Содружество Доминики
    _8_50='850' # Виргинские острова Соединенных Штатов
    _5_78='578' # Королевство Норвегия
    _2_18='218' # Республика Эквадор
    _6_16='616' # Республика Польша
    _8_58='858' # Восточная Республика Уругвай
    _1_80='180' # Демократическая Республика Конго
    _5_80='580' # Содружество Северных Марианских островов
    _0_64='064' # Королевство Бутан
    _3_40='340' # Республика Гондурас
    _5_83='583' # Федеративные штаты Микронезии
    _4_62='462' # Мальдивская Республика
    _5_84='584' # Республика Маршалловы Острова
    _1_88='188' # Республика Коста-Рика
    _1_00='100' # Республика Болгария
    _5_85='585' # Республика Палау
    _2_22='222' # Республика Эль-Сальвадор
    _0_68='068' # Многонациональное Государство Боливия
    _8_60='860' # Республика Узбекистан
    _7_40='740' # Республика Суринам
    _5_86='586' # Исламская Республика Пакистан
    _3_44='344' # Специальный административный район Гонконг Китайской Народной Республики
    _6_20='620' # Португальская Республика
    _4_66='466' # Республика Мали
    _8_62='862' # Боливарианская Республика Венесуэла
    _1_04='104' # Республика Союза Мьянма
    _2_26='226' # Республика Экваториальная Гвинея
    _3_48='348' # Венгрия
    _6_24='624' # Республика Гвинея-Бисау
    _5_04='504' # Королевство Марокко
    _1_08='108' # Республика Бурунди
    _6_26='626' # Демократическая Республика Тимор-Лесте
    _7_48='748' # Королевство Эсватини
    _5_08='508' # Республика Мозамбик


class CuttingGroupCategoryKindEType(str, Enum):
    """CuttingGroupCategoryKindEType -- В
    и
    д
    ы
    р
    у
    б
    к
    и
    
    """
    FELLING_OF_INDIVIDUAL_DEAD_WINDFA='fellingOfIndividualDeadWindfa' # Рубка отдельных сухостойных, ветровальных и буреломных деревьев для собственных нужд граждан в целях отопления (не в рамках проведения санитарно-оздоровительных мероприятий)
    CUTTING_OF_FOREST_PLANTATIONS_IN_ZO='cuttingOfForestPlantationsInZo' # Рубка лесных насаждений в зонах радиоактивного загрязнения лесов
    CLEAR_FELLING_WITH_NATURAL_REFORES='clearFellingWithNaturalRefores' # Сплошная рубка с естественным лесовосстановлением в следствие природных процессов" в справочнике
    GROUP_SELECTIVE_FELLING='groupSelectiveFelling' # Группово-выборочная рубка
    EVENLY_GRADUAL_FELLING='evenlyGradualFelling' # Равномерно-постепенная рубка
    FELLING_OF_FOREST_PLANTATIONS_IN_OR='fellingOfForestPlantationsInOr' # Рубка лесных насаждений в целях регулирования породного и возрастного составов лесных насаждений, зараженных вредными организмами
    CUTTING_OF_FOREST_PLANTATIONS_WITH='cuttingOfForestPlantationsWith' # Рубка лесных насаждений в границах созданных охранных зон, предназначенных для обеспечения безопасности граждан и создания необходимых условий для эксплуатации линейных объектов и объектов, связанных с осуществлением геологического изучения недр, разведкой и добычей полезных ископаемых
    RECONSTRUCTION_FELLING_IN_MIDDLE='reconstructionFellingInMiddle' # Рубка реконструкции в средневозрастных, приспевающих, спелых и перестойных малоценных лесных насаждениях
    GROUP_GRADUAL_HOLLOW_FELLING='groupGradualHollowFelling' # Группово-постепенная (котловинная) рубка
    VOLUNTARY_SELECTIVE_LOGGING='voluntarySelectiveLogging' # Добровольно-выборочная рубка
    CUTTING_DOWN_DEAD_AND_DAMAGED_FORES='cuttingDownDeadAndDamagedFores' # Вырубка погибших и поврежденных лесных насаждений
    FELLING_CARE='fellingCare' # Рубки ухода
    FELLING_OF_FOREST_PLANTATIONS_IN_FO='fellingOfForestPlantationsInFo' # Рубка лесных насаждений на лесных участках, предназначенных для строительства, реконструкции и эксплуатации объектов лесной, лесоперерабатывающей инфраструктуры и объектов, не связанных с созданием лесной инфраструктуры
    SANITARY_FELLING='sanitaryFelling' # Санитарная рубка
    CUTTING_OF_FOREST_PLANTATIONS_OF_AN='cuttingOfForestPlantationsOfAn' # Рубка лесных насаждений любого возраста на лесных участках, предназначенных для строительства, реконструкции и эксплуатации объектов
    FELLING_UPGRADE='fellingUpgrade' # Рубка обновления
    FELLING_CARRIED_OUT_IN_PLANTATIONS='fellingCarriedOutInPlantations' # Рубка проведенная в насаждениях, погибших в текущем году
    FELLING_OF_FOREST_PLANTATIONS_INTE='fellingOfForestPlantationsInte' # Рубка лесных насаждений для создания объектов лесной инфраструктуры
    FELLING_OF_MIDDLE_AGED_MATURING='fellingOfMiddleAgedMaturing' # Рубка средневозрастных, приспевающих, спелых, перестойных лесных насаждений при осуществлении мероприятий по сохранению лесов
    RECONSTRUCTION_FELLING='reconstructionFelling' # Рубка реконструкции молодняков
    THE_SECOND_TYPE_WHEN_USING_FORESTS_I='theSecondTypeWhenUsingForestsI' # Второй вид при использовании лесов в соответствии со статьями 43–46 Лесного Кодекса Российской Федерации
    LIGHTENING='lightening' # Осветление
    CLEANING='cleaning' # Прочистка
    FELLING_OF_FOREST_PLANTATIONS='fellingOfForestPlantations' # Рубка сохранения лесных насаждений
    CUTTING_EMERGENCY_TREES='cuttingEmergencyTrees' # Рубка аварийных деревьев
    CLEAR_FELLING_WITH_PRE_REFORESTAT='clearFellingWithPreReforestat' # Сплошная рубка с предварительным лесовосстановлением
    OTHER_CUTTINGS='otherCuttings' # Прочие рубки
    FELLING_DURING_THE_WORK='fellingDuringTheWork' # Рубка в ходе проведения работ по подготовке лесосеки
    STRIPED_GRADUAL_FELLING='stripedGradualFelling' # Чересполосная постепенная рубка
    LONG_TERM_GRADUAL_FELLING='longTermGradualFelling' # Длительно-постепенная рубка
    LANDSCAPE_SHAPING_FELLING='landscapeShapingFelling' # Рубка формирования ландшафта
    THINNING='thinning' # Прореживание
    FELLING_AS_PART_OF_SANITARY_AND_RECR='fellingAsPartOfSanitaryAndRecr' # Рубка в рамках проведения санитарно-оздоровительных мероприятий
    REFORMING_CABIN='reformingCabin' # Рубка переформирования
    FELLING_SINGLE_TREES='fellingSingleTrees' # Рубка единичных деревьев
    PASSING_CABIN='passingCabin' # Проходная рубка
    CLEAR_FELLING_FOLLOWED_BY_REFOREST='clearFellingFollowedByReforest' # Сплошная рубка с последующим лесовосстановлением
    CUTTING_OF_MATURE_AND_OVERMATURE_FO='cuttingOfMatureAndOvermatureFo' # Рубка спелых и перестойных лесных насаждений
    FELLING_OF_FOREST_PLANTATIONS_IN_O='fellingOfForestPlantationsInO' # Рубки лесных насаждений (с целью снижения природной пожарной опасности лесов путем регулирования породного состава лесных насаждений)
    CLEANING_OF_ILLIQUID_WOOD='cleaningOfIlliquidWood' # Уборка неликвидной древесины


class DistrictForestriesKindEType(str, Enum):
    """DistrictForestriesKindEType -- У
    ч
    а
    с
    т
    к
    о
    в
    ы
    е
    л
    е
    с
    н
    и
    ч
    е
    с
    т
    в
    а
    
    """
    _7_3_4_1='73:4:1' # Аргашское, Инзенское, Ульяновская область
    _7_3_4_2='73:4:2' # Валгусское, Инзенское, Ульяновская область
    _7_3_4_3='73:4:3' # Глотовское, Инзенское, Ульяновская область
    _7_3_4_4='73:4:4' # Инзенское, Инзенское, Ульяновская область
    _7_3_4_5='73:4:5' # Труслейское, Инзенское, Ульяновская область
    _7_3_4_6='73:4:6' # Чамзинское, Инзенское, Ульяновская область
    _2_5_5_4='25:5:4' # Лужковское, Кавалеровское, Приморский край
    _2_5_5_5='25:5:5' # Маргаритовское, Кавалеровское, Приморский край
    _2_5_5_6='25:5:6' # Михайловское, Кавалеровское, Приморский край
    _2_5_5_7='25:5:7' # Мономаховское, Кавалеровское, Приморский край
    _2_5_5_8='25:5:8' # Ольгинское, Кавалеровское, Приморский край
    _5_9_24_5='59:24:5' # Чайковское, Чайковское, Пермский край
    _2_5_5_9='25:5:9' # Пермское, Кавалеровское, Приморский край
    _5_9_24_4='59:24:4' # Степановское, Чайковское, Пермский край
    _5_9_24_3='59:24:3' # Сосновское, Чайковское, Пермский край
    _5_9_24_2='59:24:2' # Михайловское, Чайковское, Пермский край
    _2_5_5_1='25:5:1' # Дальнегорское, Кавалеровское, Приморский край
    _2_5_5_2='25:5:2' # Кавалеровское, Кавалеровское, Приморский край
    _2_5_5_3='25:5:3' # Кавалеровское сельское, Кавалеровское, Приморский край
    _5_9_24_1='59:24:1' # Еловское, Чайковское, Пермский край
    _5_9_11_2='59:11:2' # Косинское, Косинское, Пермский край
    _5_9_11_3='59:11:3' # Чазевское, Косинское, Пермский край
    _5_9_11_1='59:11:1' # Варышано-Чураковское, Косинское, Пермский край
    _1_9_3_3='19:3:3' # Шорское, Балыксинское, Республика Хакасия
    _1_9_3_2='19:3:2' # Верхне-Томское, Балыксинское, Республика Хакасия
    _1_9_3_1='19:3:1' # Балыксинское, Балыксинское, Республика Хакасия
    _2_9_29_4='29:29:4' # Литвиновское, Яренское, Архангельская область
    _2_9_29_5='29:29:5' # Очейское, Яренское, Архангельская область
    _2_9_29_6='29:29:6' # Пантыйское, Яренское, Архангельская область
    _2_9_29_7='29:29:7' # Урдомское, Яренское, Архангельская область
    _3_3_17_3='33:17:3' # Небыловское, Юрьев-Польское, Владимирская область
    _4_8_8_1='48:8:1' # Колодецкое, Усманское, Липецкая область
    _3_3_17_2='33:17:2' # Лучковское, Юрьев-Польское, Владимирская область
    _2_9_29_1='29:29:1' # Витюнинское, Яренское, Архангельская область
    _4_8_8_2='48:8:2' # Первомайское, Усманское, Липецкая область
    _3_3_17_5='33:17:5' # Юрьев-Польское, Юрьев-Польское, Владимирская область
    _2_9_29_2='29:29:2' # Козьминское, Яренское, Архангельская область
    _4_8_8_3='48:8:3' # Юшинское, Усманское, Липецкая область
    _3_3_17_4='33:17:4' # Шордогское, Юрьев-Польское, Владимирская область
    _2_9_29_3='29:29:3' # Ленское, Яренское, Архангельская область
    _3_3_17_1='33:17:1' # Елховское, Юрьев-Польское, Владимирская область
    _2_9_29_8='29:29:8' # Яренское, Яренское, Архангельская область
    _2_9_29_9='29:29:9' # Яренское сельское, Яренское, Архангельская область
    _7_3_10_3='73:10:3' # Сунгурское, Новоспасское, Ульяновская область
    _7_3_10_1='73:10:1' # Канадейское, Новоспасское, Ульяновская область
    _7_3_10_2='73:10:2' # Новоспасское, Новоспасское, Ульяновская область
    _5_0_1_8='50:1:8' # Хатунское, "Русский лес", Московская область
    _5_0_1_9='50:1:9' # Шараповское, "Русский лес", Московская область
    _1_6_19_4='16:19:4' # Тюлячинское, Кзыл-Юлдузское, Республика Татарстан (Татарстан)
    _1_6_19_3='16:19:3' # Кутлу-Букашское, Кзыл-Юлдузское, Республика Татарстан (Татарстан)
    _1_6_19_2='16:19:2' # Арышское, Кзыл-Юлдузское, Республика Татарстан (Татарстан)
    _2_9_16_1='29:16:1' # Верховское, Обозерское, Архангельская область
    _1_6_19_1='16:19:1' # Абдинское, Кзыл-Юлдузское, Республика Татарстан (Татарстан)
    _2_9_16_6='29:16:6' # Левашское, Обозерское, Архангельская область
    _2_9_16_7='29:16:7' # Озерское, Обозерское, Архангельская область
    _2_9_16_8='29:16:8' # Пермиловское, Обозерское, Архангельская область
    _2_9_16_9='29:16:9' # Северное, Обозерское, Архангельская область
    _2_9_16_2='29:16:2' # Войборское, Обозерское, Архангельская область
    _2_9_16_3='29:16:3' # Емцовское, Обозерское, Архангельская область
    _2_9_16_4='29:16:4' # Емцовское учебно-опытное, Обозерское, Архангельская область
    _2_9_16_5='29:16:5' # Кирилловское, Обозерское, Архангельская область
    _5_0_1_1='50:1:1' # Данковское, "Русский лес", Московская область
    _5_0_1_2='50:1:2' # Занарское, "Русский лес", Московская область
    _5_0_1_3='50:1:3' # Заокское, "Русский лес", Московская область
    _5_0_1_4='50:1:4' # Отрадненское им Н В Ветчинина, "Русский лес", Московская область
    _5_0_1_5='50:1:5' # Серпуховское сельское, "Русский лес", Московская область
    _5_0_1_6='50:1:6' # Ступинское, "Русский лес", Московская область
    _5_0_1_7='50:1:7' # Туровское, "Русский лес", Московская область
    _5_0_15_2='50:15:2' # Богдановское, Подольское, Московская область
    _5_0_15_1='50:15:1' # Барыбинское, Подольское, Московская область
    _5_0_15_6='50:15:6' # Домодедовское, Подольское, Московская область
    _5_0_15_5='50:15:5' # Видновское, Подольское, Московская область
    _5_0_15_4='50:15:4' # Бутовское, Подольское, Московская область
    _5_0_15_3='50:15:3' # Булычевское, Подольское, Московская область
    _4_3_28_1='43:28:1' # Корляковское, Санчурское, Кировская область
    _4_3_28_2='43:28:2' # Матвинурское, Санчурское, Кировская область
    _4_3_28_3='43:28:3' # Санчурское, Санчурское, Кировская область
    _4_3_28_4='43:28:4' # Санчурское сельское, Санчурское, Кировская область
    _4_3_5_5='43:5:5' # Красносельское, Даровское, Кировская область
    _2_4_25_13='24:25:13' # Чикогдинское, Кодинское, Красноярский край
    _4_3_5_4='43:5:4' # Кобрское, Даровское, Кировская область
    _2_4_25_12='24:25:12' # Цембинское, Кодинское, Красноярский край
    _4_3_5_7='43:5:7' # Лукинское, Даровское, Кировская область
    _4_3_5_6='43:5:6' # Красносельское сельское, Даровское, Кировская область
    _4_3_5_1='43:5:1' # Вонданское, Даровское, Кировская область
    _4_3_5_3='43:5:3' # Даровское сельское, Даровское, Кировская область
    _4_3_5_2='43:5:2' # Даровское, Даровское, Кировская область
    _4_3_5_8='43:5:8' # Пиксурское сельское, Даровское, Кировская область
    _5_0_15_9='50:15:9' # Коробовское, Подольское, Московская область
    _5_0_15_8='50:15:8' # Казанское, Подольское, Московская область
    _5_0_15_7='50:15:7' # Ильинское, Подольское, Московская область
    _5_6_12_1='56:12:1' # Городищенское, Краснохолмское, Оренбургская область
    _5_6_12_2='56:12:2' # Кардаиловское, Краснохолмское, Оренбургская область
    _5_6_12_3='56:12:3' # Краснохолмское, Краснохолмское, Оренбургская область
    _5_6_12_4='56:12:4' # Чесноковское, Краснохолмское, Оренбургская область
    _6_3_12_1='63:12:1' # Балашейское, Рачейское, Самарская область
    _6_3_12_2='63:12:2' # Рачейское, Рачейское, Самарская область
    _6_3_12_3='63:12:3' # Сызранское, Рачейское, Самарская область
    _6_3_12_4='63:12:4' # Троицкое, Рачейское, Самарская область
    _4_3_15_2='43:15:2' # Вымское, Лузское, Кировская область
    _4_3_15_1='43:15:1' # Аникинское, Лузское, Кировская область
    _4_3_15_6='43:15:6' # Лузское сельское, Лузское, Кировская область
    _4_3_15_5='43:15:5' # Лузское, Лузское, Кировская область
    _4_3_15_4='43:15:4' # Лальское сельское, Лузское, Кировская область
    _4_3_15_3='43:15:3' # Лальское, Лузское, Кировская область
    _4_3_15_9='43:15:9' # Христофоровское, Лузское, Кировская область
    _4_3_15_8='43:15:8' # Папуловское сельское, Лузское, Кировская область
    _4_3_15_7='43:15:7' # Папуловское, Лузское, Кировская область
    _1_8_20_2='18:20:2' # Областновское, Увинское, Удмуртская Республика
    _1_8_20_1='18:20:1' # Нылгинское, Увинское, Удмуртская Республика
    _1_8_20_4='18:20:4' # Ува-Туклинское, Увинское, Удмуртская Республика
    _1_8_20_3='18:20:3' # Северное, Увинское, Удмуртская Республика
    _2_4_61_3='24:61:3' # Тутончанское, Эвенкийское, Красноярский край
    _2_4_61_1='24:61:1' # Илимпийское, Эвенкийское, Красноярский край
    _2_4_61_2='24:61:2' # Кислоканское, Эвенкийское, Красноярский край
    _4_0_16_4='40:16:4' # Ульяновское, Ульяновское, Калужская область
    _4_0_16_3='40:16:3' # Ленинское, Ульяновское, Калужская область
    _4_0_16_5='40:16:5' # Хотьковское, Ульяновское, Калужская область
    _4_0_16_2='40:16:2' # Кцынское, Ульяновское, Калужская область
    _4_0_16_1='40:16:1' # Дудоровское, Ульяновское, Калужская область
    _5_3_13_5='53:13:5' # Поддорское, Поддорское, Новгородская область
    _5_3_13_4='53:13:4' # Коломенское, Поддорское, Новгородская область
    _5_3_13_6='53:13:6' # Серболовское, Поддорское, Новгородская область
    _5_3_13_1='53:13:1' # Белебелковское, Поддорское, Новгородская область
    _5_3_13_3='53:13:3' # Дороганское, Поддорское, Новгородская область
    _5_3_13_2='53:13:2' # Бушевское, Поддорское, Новгородская область
    _6_6_10_7='66:10:7' # Ницинское, Ирбитское, Свердловская область
    _6_6_10_5='66:10:5' # Ирбитское, Ирбитское, Свердловская область
    _6_6_10_6='66:10:6' # Лопатковское, Ирбитское, Свердловская область
    _6_6_10_3='66:10:3' # Зайковское, Ирбитское, Свердловская область
    _6_6_10_4='66:10:4' # Знаменское, Ирбитское, Свердловская область
    _2_4_25_11='24:25:11' # Тагаринское, Кодинское, Красноярский край
    _6_6_10_1='66:10:1' # Волковское, Ирбитское, Свердловская область
    _2_4_25_10='24:25:10' # Согринское, Кодинское, Красноярский край
    _6_6_10_2='66:10:2' # Горкинское, Ирбитское, Свердловская область
    _6_7_2_8='67:2:8' # Семлевское сельское, Вяземское, Смоленская область
    _6_7_2_7='67:2:7' # Семлевское, Вяземское, Смоленская область
    _6_7_2_6='67:2:6' # Исаковское сельское, Вяземское, Смоленская область
    _6_7_2_5='67:2:5' # Исаковское, Вяземское, Смоленская область
    _6_7_2_4='67:2:4' # Заречное, Вяземское, Смоленская область
    _6_7_2_3='67:2:3' # Вяземское сельское, Вяземское, Смоленская область
    _6_7_2_2='67:2:2' # Вяземское, Вяземское, Смоленская область
    _6_7_2_1='67:2:1' # Богородицкое, Вяземское, Смоленская область
    _6_7_2_9='67:2:9' # Тумановское, Вяземское, Смоленская область
    _5_3_14_4='53:14:4' # Залучское, Старорусское, Новгородская область
    _5_3_14_3='53:14:3' # Дубовицкое, Старорусское, Новгородская область
    _6_1_5_5='61:5:5' # Уляшкинское, Каменское, Ростовская область
    _5_3_14_6='53:14:6' # Ляховичское, Старорусское, Новгородская область
    _6_1_5_4='61:5:4' # Михайловское, Каменское, Ростовская область
    _5_3_14_5='53:14:5' # Ловатское, Старорусское, Новгородская область
    _5_3_14_8='53:14:8' # Старорусское, Старорусское, Новгородская область
    _5_3_14_7='53:14:7' # Порожское, Старорусское, Новгородская область
    _5_3_14_9='53:14:9' # Шубинское, Старорусское, Новгородская область
    _5_3_14_2='53:14:2' # Волотовское, Старорусское, Новгородская область
    _5_3_14_1='53:14:1' # Астриловское, Старорусское, Новгородская область
    _1_3_6_3='13:6:3' # Первомайское, Ковылкинское территориальное, Республика Мордовия
    _1_3_6_2='13:6:2' # Ковылкинское, Ковылкинское территориальное, Республика Мордовия
    _1_3_6_1='13:6:1' # Инсарское, Ковылкинское территориальное, Республика Мордовия
    _4_9_1='4:9:1' # Паспаульское, Чойское, Республика Алтай
    _4_9_2='4:9:2' # Саракокшинское, Чойское, Республика Алтай
    _4_9_3='4:9:3' # Чойское, Чойское, Республика Алтай
    _6_1_5_3='61:5:3' # Каменское, Каменское, Ростовская область
    _6_1_5_2='61:5:2' # Калитвенское, Каменское, Ростовская область
    _6_1_5_1='61:5:1' # Белокалитвинское, Каменское, Ростовская область
    _1_3_6_4='13:6:4' # Пушкинское, Ковылкинское территориальное, Республика Мордовия
    _6_6_23_6='66:23:6' # Сотринское, Сотринское, Свердловская область
    _6_6_23_5='66:23:5' # Сосьвинское, Сотринское, Свердловская область
    _6_6_23_4='66:23:4' # Предтурьинское, Сотринское, Свердловская область
    _6_6_23_3='66:23:3' # Первомайское, Сотринское, Свердловская область
    _6_6_23_2='66:23:2' # Нижне-Озерное, Сотринское, Свердловская область
    _6_6_23_1='66:23:1' # Кошайское, Сотринское, Свердловская область
    _3_2_1_2='32:1:2' # Погребское, Брасовское, Брянская область
    _3_2_1_1='32:1:1' # Луганское, Брасовское, Брянская область
    _6_6_8_4='66:8:4' # Лебедкинское, Егоршинское, Свердловская область
    _6_6_8_1='66:8:1' # Артемовское, Егоршинское, Свердловская область
    _6_6_8_3='66:8:3' # Красногвардейское, Егоршинское, Свердловская область
    _6_6_8_2='66:8:2' # Буланашское, Егоршинское, Свердловская область
    _3_7_3_6='37:3:6' # Лежневское сельское, Ивановское, Ивановская область
    _3_7_3_5='37:3:5' # Лежневское, Ивановское, Ивановская область
    _3_7_3_8='37:3:8' # Поречное, Ивановское, Ивановская область
    _3_7_3_7='37:3:7' # Михеевское, Ивановское, Ивановская область
    _3_7_3_9='37:3:9' # Талицкое, Ивановское, Ивановская область
    _3_7_3_2='37:3:2' # Ивановское, Ивановское, Ивановская область
    _3_7_3_1='37:3:1' # Ермолинское, Ивановское, Ивановская область
    _3_7_3_4='37:3:4' # Кохомское, Ивановское, Ивановская область
    _3_7_3_3='37:3:3' # Ивановское сельское, Ивановское, Ивановская область
    _4_3_29_4='43:29:4' # Свечинское сельское, Свечинское, Кировская область
    _4_3_29_5='43:29:5' # Спасское, Свечинское, Кировская область
    _4_3_29_6='43:29:6' # Шмелевское, Свечинское, Кировская область
    _4_3_29_7='43:29:7' # Юмское, Свечинское, Кировская область
    _4_3_29_1='43:29:1' # Круглыжское, Свечинское, Кировская область
    _4_3_29_2='43:29:2' # Круглыжское сельское, Свечинское, Кировская область
    _4_3_29_3='43:29:3' # Свечинское, Свечинское, Кировская область
    _9_1_5_2='91:5:2' # Сакское, Евпаторийское, Республика Крым
    _9_1_5_1='91:5:1' # Евпаторийское, Евпаторийское, Республика Крым
    _5_3_2='5:3:2' # Гунибское, Гунибское, Республика Дагестан
    _5_3_3='5:3:3' # Унцукульское, Гунибское, Республика Дагестан
    _5_3_1='5:3:1' # Гергебильское, Гунибское, Республика Дагестан
    _6_9_10_9='69:10:9' # Медведковское, Удомельское, Тверская область
    _6_9_10_8='69:10:8' # Малышевское, Удомельское, Тверская область
    _5_6_25_1='56:25:1' # Алмалинское, Тюльганское, Оренбургская область
    _6_9_10_5='69:10:5' # Дубровское, Удомельское, Тверская область
    _5_6_25_2='56:25:2' # Ташлинское, Тюльганское, Оренбургская область
    _6_9_10_4='69:10:4' # Дубно-Ремизовское, Удомельское, Тверская область
    _5_6_25_3='56:25:3' # Тугустемирское, Тюльганское, Оренбургская область
    _5_3_4='5:3:4' # Чародинское, Гунибское, Республика Дагестан
    _6_9_10_7='69:10:7' # Максатихинское, Удомельское, Тверская область
    _6_9_10_6='69:10:6' # Куровское, Удомельское, Тверская область
    _6_9_10_1='69:10:1' # Верхневолжское, Удомельское, Тверская область
    _6_9_10_3='69:10:3' # Гриблянское, Удомельское, Тверская область
    _6_9_10_2='69:10:2' # Городковское, Удомельское, Тверская область
    _3_8_30_4='38:30:4' # Тулунское, Тулунское, Иркутская область
    _3_8_30_2='38:30:2' # Икейское, Тулунское, Иркутская область
    _3_8_30_3='38:30:3' # Присаянское, Тулунское, Иркутская область
    _3_8_30_1='38:30:1' # Будаговское, Тулунское, Иркутская область
    _2_2_21_3='22:21:3' # Панкрушихинское, Панкрушихинское, Алтайский край
    _2_2_21_4='22:21:4' # Прыганское, Панкрушихинское, Алтайский край
    _2_2_21_1='22:21:1' # Велижанское, Панкрушихинское, Алтайский край
    _2_2_21_2='22:21:2' # Высоко-Гривское, Панкрушихинское, Алтайский край
    _2_2_21_5='22:21:5' # Пустынное, Панкрушихинское, Алтайский край
    _2_8_6_10='28:6:10' # Огоронское, Зейское, Амурская область
    _2_8_6_12='28:6:12' # Потехинское, Зейское, Амурская область
    _4_9_1_1='49:1:1' # Адыгалахское, Берелехское, Магаданская область
    _2_8_6_11='28:6:11' # Октябрьское, Зейское, Амурская область
    _2_8_6_14='28:6:14' # Туксинское, Зейское, Амурская область
    _2_8_6_13='28:6:13' # Снежногорское, Зейское, Амурская область
    _2_8_6_15='28:6:15' # Урканское, Зейское, Амурская область
    _4_9_1_2='49:1:2' # Берелехское, Берелехское, Магаданская область
    _4_9_1_3='49:1:3' # Кадыкчанское, Берелехское, Магаданская область
    _2_0_3_4='20:3:4' # Ца-Веденское, Веденское, Чеченская Республика
    _2_0_3_3='20:3:3' # Махкетинское, Веденское, Чеченская Республика
    _2_0_3_2='20:3:2' # Макажойское, Веденское, Чеченская Республика
    _2_0_3_1='20:3:1' # Веденское, Веденское, Чеченская Республика
    _7_9_1_1='79:1:1' # Биробиджанское, Биробиджанское, Еврейская автономная область
    _7_9_1_2='79:1:2' # Бобрихинское, Биробиджанское, Еврейская автономная область
    _7_9_1_3='79:1:3' # Городское, Биробиджанское, Еврейская автономная область
    _7_9_1_4='79:1:4' # Желтояровское, Биробиджанское, Еврейская автономная область
    _7_9_1_5='79:1:5' # Смидовичское, Биробиджанское, Еврейская автономная область
    _1_8_9_1='18:9:1' # Зуринское, Игринское, Удмуртская Республика
    _1_8_9_3='18:9:3' # Ново-Зятцинское, Игринское, Удмуртская Республика
    _1_8_9_2='18:9:2' # Менильское, Игринское, Удмуртская Республика
    _3_6_16_1='36:16:1' # Животиновское, Пригородное, Воронежская область
    _3_6_16_3='36:16:3' # Правобережное, Пригородное, Воронежская область
    _3_6_16_2='36:16:2' # Левобережное, Пригородное, Воронежская область
    _2_9_16_10='29:16:10' # Турчасовское, Обозерское, Архангельская область
    _1_8_9_5='18:9:5' # Чутырское, Игринское, Удмуртская Республика
    _1_8_9_4='18:9:4' # Пионерское, Игринское, Удмуртская Республика
    _5_5_4_4='55:4:4' # Новоягодинское, Знаменское, Омская область
    _5_5_4_5='55:4:5' # Новоягодинское сельское, Знаменское, Омская область
    _1_2_10_1='12:10:1' # Зеленогорское, Моркинское, Республика Марий Эл
    _5_9_25_4='59:25:4' # Чердынское, Чердынское, Пермский край
    _5_5_4_2='55:4:2' # Знаменское сельское, Знаменское, Омская область
    _5_9_25_3='59:25:3' # Пильвенское, Чердынское, Пермский край
    _5_5_4_3='55:4:3' # Качуковское, Знаменское, Омская область
    _5_9_25_2='59:25:2' # Камское, Чердынское, Пермский край
    _5_9_25_1='59:25:1' # Бондюжское, Чердынское, Пермский край
    _5_5_4_1='55:4:1' # Знаменское, Знаменское, Омская область
    _2_9_28_11='29:28:11' # Шенкурское, Шенкурское, Архангельская область
    _2_9_28_10='29:28:10' # Шелашское, Шенкурское, Архангельская область
    _2_9_28_12='29:28:12' # Шереньгское, Шенкурское, Архангельская область
    _1_2_10_5='12:10:5' # Уньжинское, Моркинское, Республика Марий Эл
    _1_2_10_4='12:10:4' # Тайганурское, Моркинское, Республика Марий Эл
    _1_2_10_3='12:10:3' # Семисолинское, Моркинское, Республика Марий Эл
    _1_2_10_2='12:10:2' # Комсомольское, Моркинское, Республика Марий Эл
    _7_0_11_5='70:11:5' # Томско-Обское, Корниловское, Томская область
    _7_0_11_4='70:11:4' # Северо-Алтайское, Корниловское, Томская область
    _7_0_11_3='70:11:3' # Прикульское, Корниловское, Томская область
    _7_0_11_2='70:11:2' # Корниловское, Корниловское, Томская область
    _7_0_11_1='70:11:1' # Егоровское, Корниловское, Томская область
    _5_9_12_1='59:12:1' # Кочевское, Кочевское, Пермский край
    _5_9_12_2='59:12:2' # Лологское, Кочевское, Пермский край
    _1_9_2_3='19:2:3' # Кирбинское, Абаканское, Республика Хакасия
    _1_9_2_2='19:2:2' # Биджинское, Абаканское, Республика Хакасия
    _7_3_5_1='73:5:1' # Беловодское, Карсунское, Ульяновская область
    _7_3_5_2='73:5:2' # Вальдиватское, Карсунское, Ульяновская область
    _1_9_2_1='19:2:1' # Березовское, Абаканское, Республика Хакасия
    _7_3_5_3='73:5:3' # Карсунское, Карсунское, Ульяновская область
    _7_3_5_4='73:5:4' # Сосновское, Карсунское, Ульяновская область
    _7_3_5_5='73:5:5' # Суховское, Карсунское, Ульяновская область
    _2_5_6_3='25:6:3' # Голубичное, Рощинское, Приморский край
    _2_5_6_4='25:6:4' # Дальнекутское, Рощинское, Приморский край
    _2_5_6_5='25:6:5' # Долинное, Рощинское, Приморский край
    _2_5_6_6='25:6:6' # Измайлихинское, Рощинское, Приморский край
    _2_5_6_7='25:6:7' # Мельничное, Рощинское, Приморский край
    _2_5_6_8='25:6:8' # Новопокровское, Рощинское, Приморский край
    _2_5_6_9='25:6:9' # Пихтовое, Рощинское, Приморский край
    _2_5_6_1='25:6:1' # Восточное, Рощинское, Приморский край
    _2_5_6_2='25:6:2' # Вострецовское, Рощинское, Приморский край
    _4_3_25_12='43:25:12' # Рубежницкое сельское, Парковое, Кировская область
    _4_3_25_11='43:25:11' # Раменское, Парковое, Кировская область
    _4_3_25_14='43:25:14' # Совьинское, Парковое, Кировская область
    _4_3_25_13='43:25:13' # Слободское, Парковое, Кировская область
    _4_3_25_10='43:25:10' # Просницкое, Парковое, Кировская область
    _1_6_18_7='16:18:7' # Шумбутское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_6='16:18:6' # Шеморбашское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_5='16:18:5' # Чистопольское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_4='16:18:4' # Усалинское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_3='16:18:3' # Прикамское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_2='16:18:2' # Камское, Камское, Республика Татарстан (Татарстан)
    _1_6_18_1='16:18:1' # Берсутское, Камское, Республика Татарстан (Татарстан)
    _2_9_17_5='29:17:5' # Нижмозерское, Онежское, Архангельская область
    _5_4_9_4='54:9:4' # Колыванский лесохозяйственный участок № 2, Колыванское, Новосибирская область
    _2_9_17_6='29:17:6' # Нименьгское, Онежское, Архангельская область
    _5_4_9_5='54:9:5' # Орско-Симанский лесохозяйственный участок, Колыванское, Новосибирская область
    _2_9_17_7='29:17:7' # Онежское, Онежское, Архангельская область
    _5_4_9_6='54:9:6' # Пихтовский лесохозяйственный участок № 1, Колыванское, Новосибирская область
    _2_9_17_8='29:17:8' # Онежское сельское, Онежское, Архангельская область
    _5_4_9_7='54:9:7' # Пихтовский лесохозяйственный участок № 2, Колыванское, Новосибирская область
    _2_9_17_1='29:17:1' # Караминское, Онежское, Архангельская область
    _5_4_9_8='54:9:8' # Тоя-Баксинский лесохозяйственный участок, Колыванское, Новосибирская область
    _2_9_17_2='29:17:2' # Кодинское, Онежское, Архангельская область
    _5_4_9_9='54:9:9' # Шегарский лесохозяйственный участок, Колыванское, Новосибирская область
    _2_9_17_3='29:17:3' # Кожское, Онежское, Архангельская область
    _2_9_17_4='29:17:4' # Малошуйское, Онежское, Архангельская область
    _2_9_17_9='29:17:9' # Прилукское, Онежское, Архангельская область
    _5_4_9_1='54:9:1' # Вьюнский лесохозяйственный участок, Колыванское, Новосибирская область
    _5_4_9_2='54:9:2' # Кандауровский лесохозяйственный участок, Колыванское, Новосибирская область
    _5_4_9_3='54:9:3' # Колыванский лесохозяйственный участок № 1, Колыванское, Новосибирская область
    _4_8_9_3='48:9:3' # Лев-Толстовское, Чаплыгинское, Липецкая область
    _4_8_9_4='48:9:4' # Раненбургское, Чаплыгинское, Липецкая область
    _3_3_16_3='33:16:3' # Торчинское, Суздальское, Владимирская область
    _4_8_9_1='48:9:1' # Дубовское, Чаплыгинское, Липецкая область
    _4_8_9_2='48:9:2' # Калининское, Чаплыгинское, Липецкая область
    _3_3_16_2='33:16:2' # Печугское, Суздальское, Владимирская область
    _3_3_16_1='33:16:1' # Нерлинское, Суздальское, Владимирская область
    _4_6_13_2='46:13:2' # Щигровское, Щигровское, Курская область
    _4_3_13_10='43:13:10' # Чистопольское, Котельничское, Кировская область
    _4_6_13_1='46:13:1' # Тимское, Щигровское, Курская область
    _4_3_13_11='43:13:11' # Щенниковское, Котельничское, Кировская область
    _2_5_5_10='25:5:10' # Сихотэ-Алинское, Кавалеровское, Приморский край
    _2_5_5_13='25:5:13' # Черемшанское, Кавалеровское, Приморский край
    _2_5_5_11='25:5:11' # Тайгинское, Кавалеровское, Приморский край
    _2_5_5_12='25:5:12' # Устиновское, Кавалеровское, Приморский край
    _5_6_13_1='56:13:1' # Кувандыкское, Кувандыкское, Оренбургская область
    _5_6_13_2='56:13:2' # Новосимбирское, Кувандыкское, Оренбургская область
    _5_6_13_3='56:13:3' # Новоуральское, Кувандыкское, Оренбургская область
    _5_6_13_4='56:13:4' # Саринское, Кувандыкское, Оренбургская область
    _5_6_13_5='56:13:5' # Чураевское, Кувандыкское, Оренбургская область
    _4_3_16_1='43:16:1' # Дмитриевское, Малмыжское, Кировская область
    _4_3_16_5='43:16:5' # Малмыжское сельское, Малмыжское, Кировская область
    _4_3_16_4='43:16:4' # Малмыжское, Малмыжское, Кировская область
    _4_3_16_3='43:16:3' # Константиновское, Малмыжское, Кировская область
    _4_3_16_2='43:16:2' # Заречное сельское, Малмыжское, Кировская область
    _4_3_16_7='43:16:7' # Плотбищенское, Малмыжское, Кировская область
    _4_3_16_6='43:16:6' # Мелетское, Малмыжское, Кировская область
    _5_0_16_1='50:16:1' # Алексеевское, Сергиево-Посадское, Московская область
    _5_0_16_5='50:16:5' # Сергиево-Посадское, Сергиево-Посадское, Московская область
    _5_0_16_4='50:16:4' # Краснозаводское, Сергиево-Посадское, Московская область
    _5_0_16_3='50:16:3' # Константиновское, Сергиево-Посадское, Московская область
    _5_0_16_2='50:16:2' # Васильевское, Сергиево-Посадское, Московская область
    _5_0_16_9='50:16:9' # Хотьковское, Сергиево-Посадское, Московская область
    _5_0_16_8='50:16:8' # Хомяковское, Сергиево-Посадское, Московская область
    _5_0_16_7='50:16:7' # Торгашинское, Сергиево-Посадское, Московская область
    _5_0_16_6='50:16:6' # Сергиево-Посадское сельское, Сергиево-Посадское, Московская область
    _5_3_12_6='53:12:6' # Никулкинское, Пестовское, Новгородская область
    _5_3_12_5='53:12:5' # Матрешинское, Пестовское, Новгородская область
    _5_3_12_7='53:12:7' # Пестовское, Пестовское, Новгородская область
    _5_3_12_2='53:12:2' # Дмитровское, Пестовское, Новгородская область
    _5_3_12_1='53:12:1' # Абросовское, Пестовское, Новгородская область
    _5_3_12_4='53:12:4' # Ленинское, Пестовское, Новгородская область
    _5_3_12_3='53:12:3' # Ереминское, Пестовское, Новгородская область
    _6_3_13_1='63:13:1' # Аделяковское, Сергиевское, Самарская область
    _6_3_13_2='63:13:2' # Исаклинское, Сергиевское, Самарская область
    _6_3_13_3='63:13:3' # Красно-Городецкое, Сергиевское, Самарская область
    _6_3_13_4='63:13:4' # Микушкинское, Сергиевское, Самарская область
    _6_3_13_5='63:13:5' # Сергиевское, Сергиевское, Самарская область
    _6_3_13_6='63:13:6' # Чекалинское, Сергиевское, Самарская область
    _6_7_1_1='67:1:1' # Беляевское, Велижское, Смоленская область
    _6_7_1_7='67:1:7' # Селезневское сельское, Велижское, Смоленская область
    _6_7_1_6='67:1:6' # Селезневское, Велижское, Смоленская область
    _6_7_1_5='67:1:5' # Городское, Велижское, Смоленская область
    _6_7_1_4='67:1:4' # Вязьменское, Велижское, Смоленская область
    _6_7_1_3='67:1:3' # Верховское, Велижское, Смоленская область
    _6_7_1_2='67:1:2' # Велижское, Велижское, Смоленская область
    _4_3_6_4='43:6:4' # Лабазнинское, Дубровское, Кировская область
    _3_7_10_10='37:10:10' # Южское сельское, Южское, Ивановская область
    _4_3_6_3='43:6:3' # Иванцевское сельское, Дубровское, Кировская область
    _4_3_6_6='43:6:6' # Троицкое, Дубровское, Кировская область
    _4_3_6_5='43:6:5' # Поломское, Дубровское, Кировская область
    _4_3_6_2='43:6:2' # Дубровское, Дубровское, Кировская область
    _4_3_6_1='43:6:1' # Верхне-Вятское, Дубровское, Кировская область
    _4_0_17_3='40:17:3' # Слободское, Ферзиковское, Калужская область
    _4_0_17_2='40:17:2' # Дугнинское, Ферзиковское, Калужская область
    _4_0_17_5='40:17:5' # Ферзиковское, Ферзиковское, Калужская область
    _4_0_17_4='40:17:4' # Тарусское, Ферзиковское, Калужская область
    _4_0_17_1='40:17:1' # Барятинское, Ферзиковское, Калужская область
    _6_6_22_5='66:22:5' # Синячихинское, Синячихинское, Свердловская область
    _6_6_22_4='66:22:4' # Санкинское, Синячихинское, Свердловская область
    _6_6_22_3='66:22:3' # Муратковское, Синячихинское, Свердловская область
    _6_6_22_2='66:22:2' # Кумарьинское, Синячихинское, Свердловская область
    _6_6_22_1='66:22:1' # Гаранинское, Синячихинское, Свердловская область
    _1_3_5_4='13:5:4' # Тепло-Станское, Зубовское территориальное, Республика Мордовия
    _1_3_5_3='13:5:3' # Комсомольское, Зубовское территориальное, Республика Мордовия
    _1_3_5_2='13:5:2' # Зубовское, Зубовское территориальное, Республика Мордовия
    _1_3_5_1='13:5:1' # Анаевское, Зубовское территориальное, Республика Мордовия
    _3_7_4_5='37:4:5' # Комсомольское сельское, Ильинское, Ивановская область
    _3_7_4_4='37:4:4' # Комсомольское, Ильинское, Ивановская область
    _3_7_4_7='37:4:7' # Писцовское, Ильинское, Ивановская область
    _3_7_4_6='37:4:6' # Октябрьское, Ильинское, Ивановская область
    _3_7_4_8='37:4:8' # Щениковское, Ильинское, Ивановская область
    _3_7_4_1='37:4:1' # Ивашевское, Ильинское, Ивановская область
    _3_7_4_3='37:4:3' # Ильинское сельское, Ильинское, Ивановская область
    _3_7_4_2='37:4:2' # Игрищинское, Ильинское, Ивановская область
    _5_4_1='5:4:1' # Белиджинское, Дербентское, Республика Дагестан
    _5_4_2='5:4:2' # Дербентское, Дербентское, Республика Дагестан
    _3_2_2_1='32:2:1' # Сельское, Брянское, Брянская область
    _5_6_26_1='56:26:1' # Переволоцкое, Чернореченское, Оренбургская область
    _3_2_2_2='32:2:2' # Снежетьское, Брянское, Брянская область
    _5_6_26_2='56:26:2' # Чернореченское, Чернореченское, Оренбургская область
    _5_4_3='5:4:3' # Мамедкалинское, Дербентское, Республика Дагестан
    _3_2_2_3='32:2:3' # Стяжновское, Брянское, Брянская область
    _3_2_2_4='32:2:4' # Фокинское, Брянское, Брянская область
    _6_6_7_6='66:7:6' # Пелымское, Гаринское, Свердловская область
    _6_6_7_5='66:7:5' # Ликинское, Гаринское, Свердловская область
    _6_6_7_7='66:7:7' # Шабуровское, Гаринское, Свердловская область
    _6_6_7_2='66:7:2' # Вагильское, Гаринское, Свердловская область
    _6_6_7_1='66:7:1' # Андрюшинское, Гаринское, Свердловская область
    _6_6_7_4='66:7:4' # Кузнецовское, Гаринское, Свердловская область
    _6_6_7_3='66:7:3' # Гаринское, Гаринское, Свердловская область
    _4_3_17_4='43:17:4' # Верхораменское, Мурашинское, Кировская область
    _4_3_17_3='43:17:3' # Боровицкое сельское, Мурашинское, Кировская область
    _4_3_17_2='43:17:2' # Бечевское, Мурашинское, Кировская область
    _4_3_17_1='43:17:1' # Алексеевское, Мурашинское, Кировская область
    _4_3_17_8='43:17:8' # Новожиловское, Мурашинское, Кировская область
    _4_3_17_7='43:17:7' # Мурашинское сельское, Мурашинское, Кировская область
    _4_3_17_6='43:17:6' # Мурашинское, Мурашинское, Кировская область
    _4_3_17_5='43:17:5' # Ивановское, Мурашинское, Кировская область
    _9_1_4_1='91:4:1' # Джанкойское, Джанкойское, Республика Крым
    _9_1_4_2='91:4:2' # Красногвардейское, Джанкойское, Республика Крым
    _2_0_4_3='20:4:3' # Грозненское, Грозненское, Чеченская Республика
    _2_0_4_2='20:4:2' # Горячеисточненское, Грозненское, Чеченская Республика
    _2_0_4_4='20:4:4' # Петропавловское, Грозненское, Чеченская Республика
    _5_0_2_12='50:2:12' # Тропаревское, Бородинское, Московская область
    _5_0_2_11='50:2:11' # Семеновское, Бородинское, Московская область
    _5_0_2_10='50:2:10' # Порецкое им К Ф Тюрмера, Бородинское, Московская область
    _2_0_4_1='20:4:1' # Городское, Грозненское, Чеченская Республика
    _7_9_2_1='79:2:1' # Бирское, Бирское, Еврейская автономная область
    _7_9_2_2='79:2:2' # Будуканское, Бирское, Еврейская автономная область
    _7_9_2_3='79:2:3' # Лондоковское, Бирское, Еврейская автономная область
    _7_9_2_4='79:2:4' # Успеновское, Бирское, Еврейская автономная область
    _1_8_8_2='18:8:2' # Люкшудьинское, Завьяловское, Удмуртская Республика
    _1_8_8_1='18:8:1' # Заречное, Завьяловское, Удмуртская Республика
    _1_8_8_4='18:8:4' # Пригородное, Завьяловское, Удмуртская Республика
    _1_8_8_3='18:8:3' # Подшиваловское, Завьяловское, Удмуртская Республика
    _2_2_20_4='22:20:4' # Колыванское, Павловское, Алтайский край
    _2_2_20_5='22:20:5' # Павловское, Павловское, Алтайский край
    _2_2_20_2='22:20:2' # Зиминское, Павловское, Алтайский край
    _2_2_20_3='22:20:3' # Клочковское, Павловское, Алтайский край
    _2_2_20_6='22:20:6' # Рогозихинское, Павловское, Алтайский край
    _1_6_17_4='16:17:4' # Шешминское первое, Калейкинское, Республика Татарстан (Татарстан)
    _1_6_17_3='16:17:3' # Старо-Еланское, Калейкинское, Республика Татарстан (Татарстан)
    _1_6_17_2='16:17:2' # Ракашевское, Калейкинское, Республика Татарстан (Татарстан)
    _4_3_25_15='43:25:15' # Чепецкое, Парковое, Кировская область
    _1_6_17_1='16:17:1' # Бутинское, Калейкинское, Республика Татарстан (Татарстан)
    _2_2_20_1='22:20:1' # Арбузовское, Павловское, Алтайский край
    _4_9_2_7='49:2:7' # Тауйское, Магаданское, Магаданская область
    _4_9_2_8='49:2:8' # Ямское, Магаданское, Магаданская область
    _4_9_2_5='49:2:5' # Сокольское, Магаданское, Магаданская область
    _4_9_2_6='49:2:6' # Талонское, Магаданское, Магаданская область
    _4_9_2_3='49:2:3' # Ольское, Магаданское, Магаданская область
    _4_9_2_4='49:2:4' # Снежнодолинское, Магаданское, Магаданская область
    _4_9_2_1='49:2:1' # Арманское, Магаданское, Магаданская область
    _4_9_2_2='49:2:2' # Магаданское, Магаданское, Магаданская область
    _2_5_7_2='25:7:2' # Волчанецкое, Сергеевское, Приморский край
    _2_5_7_3='25:7:3' # Киевское, Сергеевское, Приморский край
    _5_9_26_6='59:26:6' # Чусовское, Чусовское, Пермский край
    _2_5_7_4='25:7:4' # Лазовское, Сергеевское, Приморский край
    _5_9_26_5='59:26:5' # Средне-Усьвинское, Чусовское, Пермский край
    _5_5_3_5='55:3:5' # Пологрудовское, Васисское, Омская область
    _2_5_7_5='25:7:5' # Молчановское, Сергеевское, Приморский край
    _5_9_26_4='59:26:4' # Нижне-Усьвинское, Чусовское, Пермский край
    _2_5_7_6='25:7:6' # Находкинское, Сергеевское, Приморский край
    _5_9_26_3='59:26:3' # Комарихинское, Чусовское, Пермский край
    _5_5_3_3='55:3:3' # Васисское, Васисское, Омская область
    _2_5_7_7='25:7:7' # Партизанское, Сергеевское, Приморский край
    _5_9_26_2='59:26:2' # Вильвенское, Чусовское, Пермский край
    _5_5_3_4='55:3:4' # Пихтовское, Васисское, Омская область
    _2_5_7_8='25:7:8' # Партизанское сельское, Сергеевское, Приморский край
    _5_9_26_1='59:26:1' # Верхне-Городковское, Чусовское, Пермский край
    _5_5_3_1='55:3:1' # Атирское, Васисское, Омская область
    _2_5_7_9='25:7:9' # Сергеевское, Сергеевское, Приморский край
    _5_5_3_2='55:3:2' # Бобровское, Васисское, Омская область
    _2_5_7_1='25:7:1' # Владимиро-Александровское, Сергеевское, Приморский край
    _1_2_11_1='12:11:1' # Новоторъяльское, Новоторъяльское, Республика Марий Эл
    _7_0_12_2='70:12:2' # Кривошеинское, Кривошеинское, Томская область
    _7_0_12_1='70:12:1' # Красноярское, Кривошеинское, Томская область
    _5_9_13_6='59:13:6' # Северо-Колчимское, Красновишерское, Пермский край
    _5_9_13_7='59:13:7' # Щугорское, Красновишерское, Пермский край
    _5_9_13_4='59:13:4' # Нижне-Язьвинское, Красновишерское, Пермский край
    _5_9_13_5='59:13:5' # Пудьвинское, Красновишерское, Пермский край
    _5_9_13_2='59:13:2' # Говорливское, Красновишерское, Пермский край
    _5_9_13_3='59:13:3' # Красновишерское, Красновишерское, Пермский край
    _5_9_13_1='59:13:1' # Верхне-Язьвинское, Красновишерское, Пермский край
    _3_6_17_3='36:17:3' # Россошанское, Россошанское, Воронежская область
    _3_6_17_2='36:17:2' # Ольховатское, Россошанское, Воронежская область
    _6_1_4_2='61:4:2' # Орловское, Зимовниковское, Ростовская область
    _3_6_17_1='36:17:1' # Новокалитвянское, Россошанское, Воронежская область
    _6_1_4_1='61:4:1' # Зимовниковское, Зимовниковское, Ростовская область
    _2_9_27_1='29:27:1' # Белогорское, Холмогорское, Архангельская область
    _2_9_27_6='29:27:6' # Устьпинежское, Холмогорское, Архангельская область
    _2_9_27_7='29:27:7' # Холмогорское, Холмогорское, Архангельская область
    _2_9_27_8='29:27:8' # Холмогорское сельское, Холмогорское, Архангельская область
    _4_8_6_2='48:6:2' # Конь-Колодезское, Задонское, Липецкая область
    _2_9_27_2='29:27:2' # Келдозерское, Холмогорское, Архангельская область
    _4_8_6_3='48:6:3' # Октябрьское, Задонское, Липецкая область
    _2_9_27_3='29:27:3' # Кузоменское, Холмогорское, Архангельская область
    _4_8_6_4='48:6:4' # Хлевенское, Задонское, Липецкая область
    _2_9_27_4='29:27:4' # Ломоносовское, Холмогорское, Архангельская область
    _2_9_27_5='29:27:5' # Орлецкое, Холмогорское, Архангельская область
    _4_8_6_1='48:6:1' # Задонское, Задонское, Липецкая область
    _2_9_14_1='29:14:1' # Бычьевское, Мезенское, Архангельская область
    _2_9_14_2='29:14:2' # Кулойское, Мезенское, Архангельская область
    _2_9_14_3='29:14:3' # Мезенское, Мезенское, Архангельская область
    _2_9_14_4='29:14:4' # Мосеевское, Мезенское, Архангельская область
    _2_9_14_5='29:14:5' # Ручьевское, Мезенское, Архангельская область
    _2_9_14_6='29:14:6' # Совпольское, Мезенское, Архангельская область
    _2_9_14_7='29:14:7' # Соянское, Мезенское, Архангельская область
    _4_3_3_1='43:3:1' # Адышевское сельское, Верхошижемское, Кировская область
    _7_3_6_1='73:6:1' # Балтийское, Кузоватовское, Ульяновская область
    _7_3_6_6='73:6:6' # Налейкинское, Кузоватовское, Ульяновская область
    _4_3_3_6='43:3:6' # Шалеговское сельское, Верхошижемское, Кировская область
    _4_3_3_3='43:3:3' # Мякишинское сельское, Верхошижемское, Кировская область
    _7_3_6_2='73:6:2' # Безводовское, Кузоватовское, Ульяновская область
    _4_3_3_2='43:3:2' # Верхошижемское сельское, Верхошижемское, Кировская область
    _7_3_6_3='73:6:3' # Кузоватовское, Кузоватовское, Ульяновская область
    _4_3_3_5='43:3:5' # Среднеивкинское сельское, Верхошижемское, Кировская область
    _7_3_6_4='73:6:4' # Кузоватовское опытное, Кузоватовское, Ульяновская область
    _4_3_3_4='43:3:4' # Оричевское сельское, Верхошижемское, Кировская область
    _7_3_6_5='73:6:5' # Матюнинское, Кузоватовское, Ульяновская область
    _2_5_3_6='25:3:6' # Краскинское, Владивостокское, Приморский край
    _2_5_3_7='25:3:7' # Кучелиновское, Владивостокское, Приморский край
    _2_5_3_8='25:3:8' # Лазурное, Владивостокское, Приморский край
    _2_5_3_9='25:3:9' # Многоудобненское, Владивостокское, Приморский край
    _5_9_22_7='59:22:7' # Фабричное, Сивинское, Пермский край
    _7_4_19_3='74:19:3' # Усть-Катавское, Усть-Катавское, Челябинская область
    _5_9_22_6='59:22:6' # Сивинское, Сивинское, Пермский край
    _7_4_19_2='74:19:2' # Минское, Усть-Катавское, Челябинская область
    _5_9_22_5='59:22:5' # Сепычёвское, Сивинское, Пермский край
    _7_4_19_1='74:19:1' # Вязовское, Усть-Катавское, Челябинская область
    _5_9_22_4='59:22:4' # Ново-Михайловское, Сивинское, Пермский край
    _2_5_3_1='25:3:1' # Анисимовское, Владивостокское, Приморский край
    _2_5_3_2='25:3:2' # Артемовское, Владивостокское, Приморский край
    _2_5_3_3='25:3:3' # Барабашское, Владивостокское, Приморский край
    _2_5_3_4='25:3:4' # Заводское, Владивостокское, Приморский край
    _2_5_3_5='25:3:5' # Занадворовское, Владивостокское, Приморский край
    _5_9_22_3='59:22:3' # Нердвинское, Сивинское, Пермский край
    _5_9_22_2='59:22:2' # Карагайское, Сивинское, Пермский край
    _5_9_22_1='59:22:1' # Верещагинское, Сивинское, Пермский край
    _6_9_5_14='69:5:14' # Осташковское, Осташковское, Тверская область
    _6_9_5_13='69:5:13' # Ольховское, Осташковское, Тверская область
    _6_9_5_12='69:5:12' # Красногорское, Осташковское, Тверская область
    _6_9_5_11='69:5:11' # Комсомольское, Осташковское, Тверская область
    _6_9_5_10='69:5:10' # Каменское, Осташковское, Тверская область
    _5_0_17_14='50:17:14' # Ступинское сельское, Ступинское, Московская область
    _5_0_17_15='50:17:15' # Ульяновское, Ступинское, Московская область
    _5_0_17_12='50:17:12' # Песоченское, Ступинское, Московская область
    _5_0_17_13='50:17:13' # Сосновское, Ступинское, Московская область
    _5_0_17_10='50:17:10' # Озерское, Ступинское, Московская область
    _5_0_17_11='50:17:11' # Песковское, Ступинское, Московская область
    _6_9_5_24='69:5:24' # Шуваевское, Осташковское, Тверская область
    _6_9_5_23='69:5:23' # Слаутинское, Осташковское, Тверская область
    _6_9_5_22='69:5:22' # Сиговское, Осташковское, Тверская область
    _6_9_5_21='69:5:21' # Сибирское, Осташковское, Тверская область
    _6_9_5_20='69:5:20' # Селижаровское, Осташковское, Тверская область
    _6_9_5_19='69:5:19' # Селигерское, Осташковское, Тверская область
    _6_9_5_18='69:5:18' # Свапущенское, Осташковское, Тверская область
    _6_9_5_17='69:5:17' # Охватское, Осташковское, Тверская область
    _6_9_5_16='69:5:16' # Отоловское, Осташковское, Тверская область
    _6_9_5_15='69:5:15' # Островное, Осташковское, Тверская область
    _6_6_6_6='66:6:6' # Ступинское, Верхотурское, Свердловская область
    _6_6_6_1='66:6:1' # Верхотурское, Верхотурское, Свердловская область
    _6_6_6_3='66:6:3' # Косолманское, Верхотурское, Свердловская область
    _6_6_6_2='66:6:2' # Качканарское, Верхотурское, Свердловская область
    _6_6_6_5='66:6:5' # Прокоп-Салдинское, Верхотурское, Свердловская область
    _6_6_6_4='66:6:4' # Нижнетуринское, Верхотурское, Свердловская область
    _4_10_1='4:10:1' # Барагашское, Шебалинское, Республика Алтай
    _4_10_2='4:10:2' # Чергинское, Шебалинское, Республика Алтай
    _4_10_3='4:10:3' # Шебалинское, Шебалинское, Республика Алтай
    _4_6_12_1='46:12:1' # Калиновское, Хомутовское, Курская область
    _4_6_12_2='46:12:2' # Ольховское, Хомутовское, Курская область
    _4_3_39_5='43:39:5' # Тужинское, Яранское, Кировская область
    _4_3_39_6='43:39:6' # Тужинское сельское, Яранское, Кировская область
    _4_3_39_7='43:39:7' # Яранское, Яранское, Кировская область
    _4_3_39_8='43:39:8' # Яранское сельское, Яранское, Кировская область
    _4_3_39_1='43:39:1' # Каракшинское, Яранское, Кировская область
    _4_3_39_2='43:39:2' # Михайловское, Яранское, Кировская область
    _4_3_39_3='43:39:3' # Салобелякское, Яранское, Кировская область
    _4_3_39_4='43:39:4' # Салобелякское сельское, Яранское, Кировская область
    _7_3_12_1='73:12:1' # Октябрьское, Павловское, Ульяновская область
    _7_3_12_2='73:12:2' # Павловское, Павловское, Ульяновская область
    _7_3_12_3='73:12:3' # Шаховское, Павловское, Ульяновская область
    _5_3_11_1='53:11:1' # Кузьминское, Парфинское, Новгородская область
    _5_3_11_3='53:11:3' # Парфинское, Парфинское, Новгородская область
    _5_3_11_2='53:11:2' # Лажинское, Парфинское, Новгородская область
    _5_3_11_4='53:11:4' # Полавское, Парфинское, Новгородская область
    _1_3_9_5='13:9:5' # Харинское, Темниковское территориальное, Республика Мордовия
    _1_3_9_4='13:9:4' # Теньгушевское, Темниковское территориальное, Республика Мордовия
    _1_3_9_3='13:9:3' # Темниковское, Темниковское территориальное, Республика Мордовия
    _1_3_9_2='13:9:2' # Кочемировское, Темниковское территориальное, Республика Мордовия
    _1_3_9_1='13:9:1' # Барашевское, Темниковское территориальное, Республика Мордовия
    _4_3_26_1='43:26:1' # Каменское, Пинюгское, Кировская область
    _4_3_26_2='43:26:2' # Кичугское, Пинюгское, Кировская область
    _4_3_26_7='43:26:7' # Пушемкское, Пинюгское, Кировская область
    _4_3_26_8='43:26:8' # Щеткинское сельское, Пинюгское, Кировская область
    _4_3_26_9='43:26:9' # Яхреньгское сельское, Пинюгское, Кировская область
    _4_3_26_3='43:26:3' # Лунданское, Пинюгское, Кировская область
    _4_3_26_4='43:26:4' # Пинюгское, Пинюгское, Кировская область
    _4_3_26_5='43:26:5' # Подосиновское, Пинюгское, Кировская область
    _4_3_26_6='43:26:6' # Подосиновское сельское, Пинюгское, Кировская область
    _2_9_3_13='29:3:13' # Шадреньгское, Вельское, Архангельская область
    _2_9_3_10='29:3:10' # Тегринское, Вельское, Архангельская область
    _2_9_3_12='29:3:12' # Хозьминское, Вельское, Архангельская область
    _2_9_3_11='29:3:11' # Усть-Шоношское, Вельское, Архангельская область
    _4_2_9_4='42:9:4' # Чуазасское, Мысковское, Кемеровская область
    _4_2_9_3='42:9:3' # Тутуясское, Мысковское, Кемеровская область
    _4_2_9_2='42:9:2' # Ташелгинское, Мысковское, Кемеровская область
    _4_2_9_1='42:9:1' # Мысковское, Мысковское, Кемеровская область
    _2_4_50_4='24:50:4' # Тинское, Тинское, Красноярский край
    _2_4_50_3='24:50:3' # Северное, Тинское, Красноярский край
    _2_4_50_6='24:50:6' # Южное, Тинское, Красноярский край
    _2_4_50_5='24:50:5' # Тугушинское, Тинское, Красноярский край
    _2_4_50_2='24:50:2' # Ингашское, Тинское, Красноярский край
    _2_4_50_1='24:50:1' # Атагашское, Тинское, Красноярский край
    _3_6_8_3='36:8:3' # Ольховатское, Донское, Воронежская область
    _3_6_8_2='36:8:2' # Нижнемамонское, Донское, Воронежская область
    _3_6_8_1='36:8:1' # Верхнемамонское, Донское, Воронежская область
    _6_7_19_4='67:19:4' # Заднепровское, Смоленское, Смоленская область
    _6_7_19_3='67:19:3' # Жуковское сельское, Смоленское, Смоленская область
    _6_7_19_2='67:19:2' # Жуковское, Смоленское, Смоленская область
    _6_7_19_1='67:19:1' # Вонляровское, Смоленское, Смоленская область
    _6_7_19_7='67:19:7' # Соколинское, Смоленское, Смоленская область
    _6_7_19_6='67:19:6' # Пригородное, Смоленское, Смоленская область
    _6_7_19_5='67:19:5' # Касплянское, Смоленское, Смоленская область
    _6_3_14_1='63:14:1' # Мусорское, Ставропольское, Самарская область
    _6_3_14_2='63:14:2' # Федоровское, Ставропольское, Самарская область
    _6_3_14_3='63:14:3' # Ягодинское, Ставропольское, Самарская область
    _4_3_13_4='43:13:4' # Котельничское, Котельничское, Кировская область
    _4_3_13_3='43:13:3' # Иготинское, Котельничское, Кировская область
    _4_3_13_2='43:13:2' # Ежихинское, Котельничское, Кировская область
    _4_3_13_1='43:13:1' # Вишкильское, Котельничское, Кировская область
    _4_3_13_8='43:13:8' # Сюзюмское, Котельничское, Кировская область
    _4_3_13_7='43:13:7' # Макарьевское сельское, Котельничское, Кировская область
    _4_3_13_6='43:13:6' # Макарьевское, Котельничское, Кировская область
    _4_3_13_5='43:13:5' # Котельничское сельское, Котельничское, Кировская область
    _4_3_13_9='43:13:9' # Черновское, Котельничское, Кировская область
    _3_6_7_5='36:7:5' # Нововоронежское, Давыдовское, Воронежская область
    _3_6_7_4='36:7:4' # Лискинское, Давыдовское, Воронежская область
    _3_6_7_3='36:7:3' # Залуженское, Давыдовское, Воронежская область
    _3_6_7_2='36:7:2' # Донское, Давыдовское, Воронежская область
    _3_6_7_1='36:7:1' # Давыдовское, Давыдовское, Воронежская область
    _4_0_18_6='40:18:6' # Щелкановское, Юхновское, Калужская область
    _4_0_18_5='40:18:5' # Подсосонское, Юхновское, Калужская область
    _4_0_18_7='40:18:7' # Юхновское, Юхновское, Калужская область
    _3_6_14_3='36:14:3' # Павловское, Павловское, Воронежская область
    _3_6_14_2='36:14:2' # Лосевское, Павловское, Воронежская область
    _3_6_14_1='36:14:1' # Белогорьевское, Павловское, Воронежская область
    _3_6_14_5='36:14:5' # Русско-Буйловское, Павловское, Воронежская область
    _3_6_14_4='36:14:4' # Подгоренское, Павловское, Воронежская область
    _4_0_18_2='40:18:2' # Заресское, Юхновское, Калужская область
    _4_0_18_1='40:18:1' # Долговское, Юхновское, Калужская область
    _4_0_18_4='40:18:4' # Мосальское, Юхновское, Калужская область
    _4_0_18_3='40:18:3' # Крюковское, Юхновское, Калужская область
    _9_1_7_2='91:7:2' # Раздольненское, Раздольненское, Республика Крым
    _9_1_7_1='91:7:1' # Красноперекопское, Раздольненское, Республика Крым
    _5_5_1='5:5:1' # Казбековское, Казбековское, Республика Дагестан
    _6_6_12_9='66:12:9' # Черемуховское, Карпинское, Свердловская область
    _6_6_12_7='66:12:7' # Петропавловское, Карпинское, Свердловская область
    _5_5_2_2='55:2:2' # Большеуковское сельское, Большеуковское, Омская область
    _6_6_12_8='66:12:8' # Сосновское, Карпинское, Свердловская область
    _5_5_2_3='55:2:3' # Савиновское, Большеуковское, Омская область
    _6_6_12_5='66:12:5' # Краснотурьинское, Карпинское, Свердловская область
    _6_6_12_6='66:12:6' # Кытлымское, Карпинское, Свердловская область
    _6_6_12_3='66:12:3' # Всеволодское, Карпинское, Свердловская область
    _6_6_12_4='66:12:4' # Городское, Карпинское, Свердловская область
    _6_6_12_1='66:12:1' # Веселовское, Карпинское, Свердловская область
    _6_6_12_2='66:12:2' # Волчанское, Карпинское, Свердловская область
    _5_6_27_1='56:27:1' # Александровское, Шарлыкское, Оренбургская область
    _5_6_27_2='56:27:2' # Шарлыкское, Шарлыкское, Оренбургская область
    _5_5_2_1='55:2:1' # Большеуковское, Большеуковское, Омская область
    _7_0_13_3='70:13:3' # Сулзатское, Молчановское, Томская область
    _7_0_13_2='70:13:2' # Суйгинское, Молчановское, Томская область
    _7_0_13_1='70:13:1' # Молчановское, Молчановское, Томская область
    _5_0_13_4='50:13:4' # Кудиновское, Ногинское, Московская область
    _5_0_13_3='50:13:3' # Горенское, Ногинское, Московская область
    _5_0_13_2='50:13:2' # Больше-Дворское, Ногинское, Московская область
    _5_0_13_1='50:13:1' # Аверкиевское, Ногинское, Московская область
    _5_0_13_8='50:13:8' # Ногинское, Ногинское, Московская область
    _5_0_13_7='50:13:7' # Луковское, Ногинское, Московская область
    _5_0_13_6='50:13:6' # Логиновское, Ногинское, Московская область
    _5_0_13_5='50:13:5' # Кучинское, Ногинское, Московская область
    _1_3_8_1='13:8:1' # Кочкуровское, Саранское территориальное, Республика Мордовия
    _6_0_9_2='60:9:2' # Карамышевское, Псковское, Псковская область
    _6_0_9_1='60:9:1' # Ваулиногорское, Псковское, Псковская область
    _6_0_9_4='60:9:4' # Середкинское, Псковское, Псковская область
    _6_0_9_3='60:9:3' # Псковское, Псковское, Псковская область
    _1_3_8_4='13:8:4' # Шишкеевское, Саранское территориальное, Республика Мордовия
    _1_3_8_3='13:8:3' # Старо-Шайговское, Саранское территориальное, Республика Мордовия
    _1_3_8_2='13:8:2' # Саранское, Саранское территориальное, Республика Мордовия
    _5_0_13_9='50:13:9' # Ногинское сельское, Ногинское, Московская область
    _6_6_25_8='66:25:8' # Центральное, Сысертское, Свердловская область
    _6_6_25_7='66:25:7' # Сысертское, Сысертское, Свердловская область
    _6_6_25_6='66:25:6' # Северское, Сысертское, Свердловская область
    _6_6_25_5='66:25:5' # Полевское, Сысертское, Свердловская область
    _6_6_25_4='66:25:4' # Полдневское, Сысертское, Свердловская область
    _6_6_25_3='66:25:3' # Пионерское, Сысертское, Свердловская область
    _6_6_25_2='66:25:2' # Кашинское, Сысертское, Свердловская область
    _6_6_25_1='66:25:1' # Верх-Сысертское, Сысертское, Свердловская область
    _5_6_14_1='56:14:1' # Новосергиевское, Новосергиевское, Оренбургская область
    _5_6_14_2='56:14:2' # Покровское, Новосергиевское, Оренбургская область
    _1_9_5_2='19:5:2' # Базинское, Бирикчульское, Республика Хакасия
    _1_9_5_1='19:5:1' # Аскизское, Бирикчульское, Республика Хакасия
    _1_9_5_4='19:5:4' # Тейское, Бирикчульское, Республика Хакасия
    _1_9_5_3='19:5:3' # Кизласовское, Бирикчульское, Республика Хакасия
    _7_9_3_1='79:3:1' # Бираканское, Кульдурское, Еврейская автономная область
    _7_9_3_2='79:3:2' # Известковое, Кульдурское, Еврейская автономная область
    _7_9_3_3='79:3:3' # Кульдурское, Кульдурское, Еврейская автономная область
    _7_9_3_4='79:3:4' # Теплоозерское, Кульдурское, Еврейская автономная область
    _4_7_16_13='47:16:13' # Лужайское, Северо-Западное, Ленинградская область
    _4_7_16_14='47:16:14' # Пограничное, Северо-Западное, Ленинградская область
    _4_7_16_15='47:16:15' # Светогорское, Северо-Западное, Ленинградская область
    _4_7_16_16='47:16:16' # Селезневское, Северо-Западное, Ленинградская область
    _4_7_16_10='47:16:10' # Красносокольское, Северо-Западное, Ленинградская область
    _4_7_16_11='47:16:11' # Лесогорское, Северо-Западное, Ленинградская область
    _4_7_16_12='47:16:12' # Липовское, Северо-Западное, Ленинградская область
    _1_6_16_4='16:16:4' # Русаковское, Кайбицкое, Республика Татарстан (Татарстан)
    _1_6_16_3='16:16:3' # Кугеевское, Кайбицкое, Республика Татарстан (Татарстан)
    _1_6_16_2='16:16:2' # Берлибашское, Кайбицкое, Республика Татарстан (Татарстан)
    _1_6_16_1='16:16:1' # Балтаевское, Кайбицкое, Республика Татарстан (Татарстан)
    _3_7_1_8='37:1:8' # Порздневское, Вичугское, Ивановская область
    _3_7_1_7='37:1:7' # Лухское сельское, Вичугское, Ивановская область
    _3_7_1_9='37:1:9' # Родниковское, Вичугское, Ивановская область
    _3_7_1_2='37:1:2' # Вичугское сельское, Вичугское, Ивановская область
    _3_7_1_1='37:1:1' # Вичугское, Вичугское, Ивановская область
    _3_7_1_4='37:1:4' # Зарубинское, Вичугское, Ивановская область
    _3_7_1_3='37:1:3' # Вишневское, Вичугское, Ивановская область
    _3_7_1_6='37:1:6' # Лухское, Вичугское, Ивановская область
    _3_7_1_5='37:1:5' # Каменское, Вичугское, Ивановская область
    _4_3_14_12='43:14:12' # Сунское сельское, Куменское, Кировская область
    _4_3_14_11='43:14:11' # Сунское, Куменское, Кировская область
    _4_3_14_10='43:14:10' # Речное, Куменское, Кировская область
    _5_4_8_5='54:8:5' # Суминский лесохозяйственный участок, Каргатское, Новосибирская область
    _5_4_8_1='54:8:1' # Каргатский лесохозяйственный участок, Каргатское, Новосибирская область
    _5_4_8_2='54:8:2' # Кольцовский лесохозяйственный участок, Каргатское, Новосибирская область
    _5_4_8_3='54:8:3' # Михайловский лесохозяйственный участок, Каргатское, Новосибирская область
    _5_4_8_4='54:8:4' # Северный лесохозяйственный участок, Каргатское, Новосибирская область
    _1_4_2_2='14:2:2' # Покровское, Амгинское, Республика Саха (Якутия)
    _1_4_2_1='14:2:1' # Амгинское, Амгинское, Республика Саха (Якутия)
    _6_1_3_1='61:3:1' # Калитвенское, Донецкое, Ростовская область
    _6_1_3_3='61:3:3' # Фоминское, Донецкое, Ростовская область
    _6_1_3_2='61:3:2' # Миллеровское, Донецкое, Ростовская область
    _4_8_5_3='48:5:3' # Марьинское, Елецкое, Липецкая область
    _4_8_5_4='48:5:4' # Становлянское, Елецкое, Липецкая область
    _6_0_11_1='60:11:1' # Горское, Стругокрасненское, Псковская область
    _6_0_11_3='60:11:3' # Ровненское, Стругокрасненское, Псковская область
    _6_0_11_2='60:11:2' # Новосельское, Стругокрасненское, Псковская область
    _4_8_5_1='48:5:1' # Елецкое, Елецкое, Липецкая область
    _4_8_5_2='48:5:2' # Измалковское, Елецкое, Липецкая область
    _6_0_11_4='60:11:4' # Стругокрасненское, Стругокрасненское, Псковская область
    _2_0_1_1='20:1:1' # Бамутское, Ассиновское, Чеченская Республика
    _6_3_15_1='63:15:1' # Денискинское, Шенталинское, Самарская область
    _6_3_15_2='63:15:2' # Канашское, Шенталинское, Самарская область
    _6_3_15_3='63:15:3' # Ново-Кувакское, Шенталинское, Самарская область
    _6_3_15_4='63:15:4' # Тархановское, Шенталинское, Самарская область
    _6_3_15_5='63:15:5' # Шенталинское, Шенталинское, Самарская область
    _2_9_15_1='29:15:1' # Бурачихинское, Няндомское, Архангельская область
    _2_9_15_2='29:15:2' # Лимское, Няндомское, Архангельская область
    _2_9_15_7='29:15:7' # Шожемское, Няндомское, Архангельская область
    _2_9_15_3='29:15:3' # Мошинское, Няндомское, Архангельская область
    _2_9_15_4='29:15:4' # Няндомское, Няндомское, Архангельская область
    _2_9_15_5='29:15:5' # Няндомское сельское, Няндомское, Архангельская область
    _2_9_15_6='29:15:6' # Шалакушское, Няндомское, Архангельская область
    _4_8_7_1='48:7:1' # Больше-Полянское, Тербунское, Липецкая область
    _4_8_7_2='48:7:2' # Воловское, Тербунское, Липецкая область
    _4_8_7_3='48:7:3' # Долгоруковское, Тербунское, Липецкая область
    _5_9_23_6='59:23:6' # Урольское, Соликамское, Пермский край
    _5_9_23_5='59:23:5' # Ульвинское, Соликамское, Пермский край
    _5_9_23_4='59:23:4' # Соликамское, Соликамское, Пермский край
    _5_9_23_3='59:23:3' # Пармское, Соликамское, Пермский край
    _5_9_23_2='59:23:2' # Мошевское, Соликамское, Пермский край
    _5_9_23_1='59:23:1' # Вильвенское, Соликамское, Пермский край
    _1_6_29_6='16:29:6' # Шеморданское, Сабинское, Республика Татарстан (Татарстан)
    _1_6_29_5='16:29:5' # Сабабашское, Сабинское, Республика Татарстан (Татарстан)
    _1_6_29_4='16:29:4' # Мешебашское, Сабинское, Республика Татарстан (Татарстан)
    _1_6_29_3='16:29:3' # Ленинское, Сабинское, Республика Татарстан (Татарстан)
    _1_6_29_2='16:29:2' # Кукморское, Сабинское, Республика Татарстан (Татарстан)
    _1_6_29_1='16:29:1' # Корсинское, Сабинское, Республика Татарстан (Татарстан)
    _5_0_3_13='50:3:13' # Ульянинское, Виноградовское, Московская область
    _5_0_3_14='50:3:14' # Хорловское, Виноградовское, Московская область
    _5_9_10_3='59:10:3' # Вишерское, Колвинское, Пермский край
    _5_0_3_10='50:3:10' # Пласкининское, Виноградовское, Московская область
    _5_9_10_4='59:10:4' # Ныробское, Колвинское, Пермский край
    _5_0_3_11='50:3:11' # Подберезное, Виноградовское, Московская область
    _5_9_10_1='59:10:1' # Березовское, Колвинское, Пермский край
    _5_0_3_12='50:3:12' # Раменское, Виноградовское, Московская область
    _5_9_10_2='59:10:2' # Вижайское, Колвинское, Пермский край
    _1_9_4_3='19:4:3' # Табатское, Бейское, Республика Хакасия
    _1_9_4_2='19:4:2' # Очурское, Бейское, Республика Хакасия
    _1_9_4_1='19:4:1' # Бейское, Бейское, Республика Хакасия
    _7_9_4_1='79:4:1' # Биджанское, Ленинское, Еврейская автономная область
    _7_9_4_2='79:4:2' # Ленинское, Ленинское, Еврейская автономная область
    _2_9_28_5='29:28:5' # Паденьгское, Шенкурское, Архангельская область
    _7_3_7_5='73:7:5' # Первомайское, Майнское, Ульяновская область
    _2_9_28_6='29:28:6' # Поршинское, Шенкурское, Архангельская область
    _7_3_7_6='73:7:6' # Тагайское, Майнское, Ульяновская область
    _2_9_28_7='29:28:7' # Ровдинское, Шенкурское, Архангельская область
    _7_3_7_7='73:7:7' # Языковское, Майнское, Ульяновская область
    _2_9_28_8='29:28:8' # Сюмское, Шенкурское, Архангельская область
    _2_9_28_1='29:28:1' # Боровское, Шенкурское, Архангельская область
    _7_3_7_1='73:7:1' # Белоозерское, Майнское, Ульяновская область
    _2_9_28_2='29:28:2' # Верхоледское, Шенкурское, Архангельская область
    _7_3_7_2='73:7:2' # Выровское, Майнское, Ульяновская область
    _2_9_28_3='29:28:3' # Кодемское, Шенкурское, Архангельская область
    _7_3_7_3='73:7:3' # Майнское, Майнское, Ульяновская область
    _2_9_28_4='29:28:4' # Ледское, Шенкурское, Архангельская область
    _7_3_7_4='73:7:4' # Маклаушинское, Майнское, Ульяновская область
    _2_9_28_9='29:28:9' # Тарнянское, Шенкурское, Архангельская область
    _2_5_4_5='25:4:5' # Кировское сельское, Дальнереченское, Приморский край
    _2_5_4_6='25:4:6' # Ключевское, Дальнереченское, Приморский край
    _2_5_4_7='25:4:7' # Курортное, Дальнереченское, Приморский край
    _2_5_4_8='25:4:8' # Лесозаводское, Дальнереченское, Приморский край
    _2_5_4_9='25:4:9' # Лесозаводское сельское, Дальнереченское, Приморский край
    _2_5_4_1='25:4:1' # Боголюбовское, Дальнереченское, Приморский край
    _2_5_4_2='25:4:2' # Веденское, Дальнереченское, Приморский край
    _2_5_4_3='25:4:3' # Зимниковское, Дальнереченское, Приморский край
    _2_5_4_4='25:4:4' # Кировское, Дальнереченское, Приморский край
    _7_3_11_2='73:11:2' # Бесовское, Новочеремшанское, Ульяновская область
    _7_3_11_3='73:11:3' # Салаванское, Новочеремшанское, Ульяновская область
    _7_3_11_1='73:11:1' # Аппаковское, Новочеремшанское, Ульяновская область
    _7_3_11_4='73:11:4' # Сахчинское, Новочеремшанское, Ульяновская область
    _7_3_11_5='73:11:5' # Тиинское, Новочеремшанское, Ульяновская область
    _5_3_10_7='53:10:7' # Угловское, Окуловское, Новгородская область
    _5_3_10_2='53:10:2' # Каевское, Окуловское, Новгородская область
    _5_3_10_1='53:10:1' # Боровенковское, Окуловское, Новгородская область
    _5_3_10_4='53:10:4' # Окуловское, Окуловское, Новгородская область
    _5_3_10_3='53:10:3' # Кулотинское, Окуловское, Новгородская область
    _5_3_10_6='53:10:6' # Торбинское, Окуловское, Новгородская область
    _5_3_10_5='53:10:5' # Теребуновское, Окуловское, Новгородская область
    _4_3_27_1='43:27:1' # Верхне-Сысольское, Рудниковское, Кировская область
    _6_6_5_2='66:5:2' # Чусовское, Верх-Исетское, Свердловская область
    _6_6_5_1='66:5:1' # Решетское, Верх-Исетское, Свердловская область
    _4_3_27_2='43:27:2' # Гидаевское, Рудниковское, Кировская область
    _4_3_27_3='43:27:3' # Заводское, Рудниковское, Кировская область
    _4_3_27_4='43:27:4' # Лесновское, Рудниковское, Кировская область
    _4_3_27_5='43:27:5' # Рудниковское, Рудниковское, Кировская область
    _4_3_4_5='43:4:5' # Шабанское, Вятско-Полянское, Кировская область
    _4_3_4_2='43:4:2' # Вятско-Полянское, Вятско-Полянское, Кировская область
    _4_3_4_1='43:4:1' # Бурецкое, Вятско-Полянское, Кировская область
    _4_3_4_4='43:4:4' # Сосновское, Вятско-Полянское, Кировская область
    _4_3_4_3='43:4:3' # Вятско-Полянское сельское, Вятско-Полянское, Кировская область
    _8_6_10_1='86:10:1' # Кедровское, Самаровское, Ханты-Мансийский автономный округ - Югра
    _8_6_10_2='86:10:2' # Правдинское, Самаровское, Ханты-Мансийский автономный округ - Югра
    _8_6_10_3='86:10:3' # Троицкое, Самаровское, Ханты-Мансийский автономный округ - Югра
    _8_6_10_4='86:10:4' # Ханты-Мансийское, Самаровское, Ханты-Мансийский автономный округ - Югра
    _4_6_11_4='46:11:4' # Суджанское, Суджанское, Курская область
    _4_6_11_2='46:11:2' # Больше-Солдатское, Суджанское, Курская область
    _4_6_11_3='46:11:3' # Кореневское, Суджанское, Курская область
    _4_6_11_1='46:11:1' # Беловское, Суджанское, Курская область
    _3_6_9_3='36:9:3' # Воробьевское, Калачеевское, Воронежская область
    _3_6_9_2='36:9:2' # Бычковское, Калачеевское, Воронежская область
    _3_6_9_1='36:9:1' # Березняговское, Калачеевское, Воронежская область
    _3_6_9_5='36:9:5' # Меловатское, Калачеевское, Воронежская область
    _3_6_9_4='36:9:4' # Калачеевское, Калачеевское, Воронежская область
    _4_3_14_3='43:14:3' # Верхосунское, Куменское, Кировская область
    _4_3_14_2='43:14:2' # Верхобыстрицкое сельское, Куменское, Кировская область
    _4_3_14_1='43:14:1' # Верхобыстрицкое, Куменское, Кировская область
    _4_3_14_7='43:14:7' # Муринское, Куменское, Кировская область
    _4_3_14_6='43:14:6' # Куменское сельское, Куменское, Кировская область
    _4_3_14_5='43:14:5' # Куменское, Куменское, Кировская область
    _4_3_14_4='43:14:4' # Вожгальское, Куменское, Кировская область
    _4_3_14_9='43:14:9' # Плотниковское сельское, Куменское, Кировская область
    _4_3_14_8='43:14:8' # Нижнеивкинское, Куменское, Кировская область
    _7_4_1_1='74:1:1' # Аргазинское, Аргаяшское, Челябинская область
    _7_4_1_4='74:1:4' # Кулуевское, Аргаяшское, Челябинская область
    _7_4_1_2='74:1:2' # Аргаяшское, Аргаяшское, Челябинская область
    _7_4_1_3='74:1:3' # Кузнецкое, Аргаяшское, Челябинская область
    _2_4_51_3='24:51:3' # Чунское, Тунгусско-Чунское, Красноярский край
    _2_4_51_2='24:51:2' # Чемдальское, Тунгусско-Чунское, Красноярский край
    _2_4_51_1='24:51:1' # Ванаварское, Тунгусско-Чунское, Красноярский край
    _5_5_1_5='55:1:5' # Южное, Большереченское, Омская область
    _5_5_1_3='55:1:3' # Карасукское, Большереченское, Омская область
    _5_5_1_4='55:1:4' # Северное, Большереченское, Омская область
    _6_6_11_4='66:11:4' # Пышминское, Камышловское, Свердловская область
    _6_6_11_5='66:11:5' # Четкаринское, Камышловское, Свердловская область
    _6_6_11_2='66:11:2' # Камышловское, Камышловское, Свердловская область
    _6_6_11_3='66:11:3' # Пульниковское, Камышловское, Свердловская область
    _5_6_1='5:6:1' # Дахадаевское, Кайтагское, Республика Дагестан
    _5_6_2='5:6:2' # Кайтагское, Кайтагское, Республика Дагестан
    _6_6_11_1='66:11:1' # Городское, Камышловское, Свердловская область
    _5_5_1_1='55:1:1' # Большереченское, Большереченское, Омская область
    _5_5_1_2='55:1:2' # Евгащинское, Большереченское, Омская область
    _7_0_14_3='70:14:3' # Старицинское, Парабельское, Томская область
    _7_0_14_2='70:14:2' # Парабельское, Парабельское, Томская область
    _7_0_14_1='70:14:1' # Нарымское, Парабельское, Томская область
    _6_0_8_1='60:8:1' # Дедовичское, Порховское, Псковская область
    _6_0_8_3='60:8:3' # Павское, Порховское, Псковская область
    _6_0_8_2='60:8:2' # Дновское, Порховское, Псковская область
    _6_0_8_5='60:8:5' # Порховское, Порховское, Псковская область
    _6_0_8_4='60:8:4' # Полистовское, Порховское, Псковская область
    _3_6_15_2='36:15:2' # Песковское, Песковское, Воронежская область
    _3_6_15_1='36:15:1' # Буденовское, Песковское, Воронежская область
    _3_6_15_3='36:15:3' # Петровское, Песковское, Воронежская область
    _5_6_15_5='56:15:5' # Павловское, Оренбургское, Оренбургская область
    _2_2_31_3='22:31:3' # Шипуновское, Шипуновское, Алтайский край
    _2_2_31_2='22:31:2' # Хлопуновское, Шипуновское, Алтайский край
    _6_6_24_8='66:24:8' # Рефтинское, Сухоложское, Свердловская область
    _6_6_24_7='66:24:7' # Пригородное, Сухоложское, Свердловская область
    _6_6_24_6='66:24:6' # Курьинское, Сухоложское, Свердловская область
    _6_6_24_5='66:24:5' # Грязновское, Сухоложское, Свердловская область
    _1_3_10='1:3:10' # Ханское сельское, Майкопское, Республика Адыгея (Адыгея)
    _6_6_24_4='66:24:4' # Винокурское, Сухоложское, Свердловская область
    _6_6_24_3='66:24:3' # Богдановичское, Сухоложское, Свердловская область
    _6_6_24_2='66:24:2' # Асбестовское, Сухоложское, Свердловская область
    _6_6_24_1='66:24:1' # Алтынайское, Сухоложское, Свердловская область
    _5_6_15_1='56:15:1' # Благословенское, Оренбургское, Оренбургская область
    _5_6_15_2='56:15:2' # Комсомольское, Оренбургское, Оренбургская область
    _5_6_15_3='56:15:3' # Нежинское, Оренбургское, Оренбургская область
    _5_6_15_4='56:15:4' # Оренбургское, Оренбургское, Оренбургская область
    _1_3_11='1:3:11' # Цицинское, Майкопское, Республика Адыгея (Адыгея)
    _9_1_6_1='91:6:1' # Куйбышевское, Куйбышевское, Республика Крым
    _2_2_31_1='22:31:1' # Белоглазовское, Шипуновское, Алтайский край
    _9_1_6_3='91:6:3' # Сосновское, Куйбышевское, Республика Крым
    _9_1_6_2='91:6:2' # Соколинское, Куйбышевское, Республика Крым
    _2_3_15_3='23:15:3' # Солох-Аульское, Туапсинское, Краснодарский край
    _2_3_15_2='23:15:2' # Небугское, Туапсинское, Краснодарский край
    _2_3_15_1='23:15:1' # Георгиевское, Туапсинское, Краснодарский край
    _5_0_14_3='50:14:3' # Анциферовское, Орехово-Зуевское, Московская область
    _5_0_14_2='50:14:2' # Авсюнинское, Орехово-Зуевское, Московская область
    _5_0_14_1='50:14:1' # Абрамовское, Орехово-Зуевское, Московская область
    _5_0_14_7='50:14:7' # Запутновское, Орехово-Зуевское, Московская область
    _5_0_14_6='50:14:6' # Губинское, Орехово-Зуевское, Московская область
    _5_0_14_5='50:14:5' # Городищенское, Орехово-Зуевское, Московская область
    _5_0_14_4='50:14:4' # Белавинское, Орехово-Зуевское, Московская область
    _1_3_7_2='13:7:2' # Краснослободское, Краснослободское территориальное, Республика Мордовия
    _1_3_7_1='13:7:1' # Ельниковское, Краснослободское территориальное, Республика Мордовия
    _1_3_7_4='13:7:4' # Пурдошанское, Краснослободское территориальное, Республика Мордовия
    _1_3_7_3='13:7:3' # Октябрьское, Краснослободское территориальное, Республика Мордовия
    _3_7_2_7='37:2:7' # Красногорское, Заволжское, Ивановская область
    _3_7_2_6='37:2:6' # Кистегское, Заволжское, Ивановская область
    _3_7_2_8='37:2:8' # Октябрьское, Заволжское, Ивановская область
    _5_0_14_9='50:14:9' # Ильинское, Орехово-Зуевское, Московская область
    _3_7_2_1='37:2:1' # Есиплевское, Заволжское, Ивановская область
    _5_0_14_8='50:14:8' # Зуевское, Орехово-Зуевское, Московская область
    _3_7_2_3='37:2:3' # Заволжское, Заволжское, Ивановская область
    _3_7_2_2='37:2:2' # Жажлевское, Заволжское, Ивановская область
    _3_7_2_5='37:2:5' # Ильинское, Заволжское, Ивановская область
    _3_7_2_4='37:2:4' # Заволжское сельское, Заволжское, Ивановская область
    _7_3_8_4='73:8:4' # Мулловское, Мелекесское, Ульяновская область
    _7_3_8_5='73:8:5' # Никольское, Мелекесское, Ульяновская область
    _7_3_8_6='73:8:6' # Новомайнское, Мелекесское, Ульяновская область
    _7_3_8_7='73:8:7' # Русскомелекесское, Мелекесское, Ульяновская область
    _7_3_8_1='73:8:1' # Красноармейское, Мелекесское, Ульяновская область
    _7_3_8_2='73:8:2' # Лебяжинское, Мелекесское, Ульяновская область
    _7_3_8_3='73:8:3' # Мелекесское, Мелекесское, Ульяновская область
    _5_4_7_1='54:7:1' # Баганский лесохозяйственный участок, Карасукское, Новосибирская область
    _5_4_7_2='54:7:2' # Карасукский лесохозяйственный участок, Карасукское, Новосибирская область
    _5_4_7_3='54:7:3' # Морозовский лесохозяйственный участок, Карасукское, Новосибирская область
    _5_4_7_4='54:7:4' # Хорошинский лесохозяйственный участок, Карасукское, Новосибирская область
    _1_6_28_4='16:28:4' # Столбищенское, Пригородное, Республика Татарстан (Татарстан)
    _1_6_28_3='16:28:3' # Матюшинское, Пригородное, Республика Татарстан (Татарстан)
    _1_6_28_2='16:28:2' # Иске-Казанское, Пригородное, Республика Татарстан (Татарстан)
    _1_6_28_1='16:28:1' # Высокогорское, Пригородное, Республика Татарстан (Татарстан)
    _6_1_2_2='61:2:2' # Дубровское, Верхнедонское, Ростовская область
    _6_1_2_1='61:2:1' # Быковское, Верхнедонское, Ростовская область
    _6_1_2_6='61:2:6' # Мигулинское, Верхнедонское, Ростовская область
    _6_1_2_5='61:2:5' # Мещеряковское, Верхнедонское, Ростовская область
    _6_1_2_4='61:2:4' # Казанское, Верхнедонское, Ростовская область
    _6_1_2_3='61:2:3' # Ереминское, Верхнедонское, Ростовская область
    _6_0_10_2='60:10:2' # Идрицкое, Себежское, Псковская область
    _6_0_10_1='60:10:1' # Дубровское, Себежское, Псковская область
    _6_0_10_3='60:10:3' # Себежское, Себежское, Псковская область
    _6_6_4_10='66:4:10' # Северское, Билимбаевское, Свердловская область
    _2_25_10='2:25:10' # Тукаевское, Стерлитамакское, Республика Башкортостан
    _2_25_11='2:25:11' # Федоровское, Стерлитамакское, Республика Башкортостан
    _2_0_2_1='20:2:1' # Ачхой-Мартановское, Ачхой-Мартановское, Чеченская Республика
    _2_0_2_2='20:2:2' # Самашкинское, Ачхой-Мартановское, Чеченская Республика
    _1_4_1_5='14:1:5' # Томмотское, Алданское, Республика Саха (Якутия)
    _1_4_1_4='14:1:4' # Тобукское, Алданское, Республика Саха (Якутия)
    _1_4_1_7='14:1:7' # Учурское, Алданское, Республика Саха (Якутия)
    _1_4_1_6='14:1:6' # Тыркандинское, Алданское, Республика Саха (Якутия)
    _1_4_1_1='14:1:1' # Алданское, Алданское, Республика Саха (Якутия)
    _1_4_1_3='14:1:3' # Верхне-Амгинское, Алданское, Республика Саха (Якутия)
    _1_4_1_2='14:1:2' # Васильевское, Алданское, Республика Саха (Якутия)
    _1_6_15_2='16:15:2' # Илетьское, Ислейтарское, Республика Татарстан (Татарстан)
    _1_6_15_1='16:15:1' # Ашитское, Ислейтарское, Республика Татарстан (Татарстан)
    _4_3_24_1='43:24:1' # Бурденское, Орловское, Кировская область
    _3_5_22_9='35:22:9' # Устюженское, Устюженское, Вологодская область
    _6_9_3_11='69:3:11' # Славковское, Кашинское, Тверская область
    _4_3_24_2='43:24:2' # Русановское сельское, Орловское, Кировская область
    _3_5_22_8='35:22:8' # Северное, Устюженское, Вологодская область
    _6_9_3_12='69:3:12' # Суворовское, Кашинское, Тверская область
    _4_3_24_3='43:24:3' # Соловецкое, Орловское, Кировская область
    _3_5_22_7='35:22:7' # Моденское, Устюженское, Вологодская область
    _7_4_2_5='74:2:5' # Укское, Ашинское, Челябинская область
    _4_3_24_4='43:24:4' # Степановское сельское, Орловское, Кировская область
    _3_5_22_6='35:22:6' # Мережское, Устюженское, Вологодская область
    _6_9_3_10='69:3:10' # Пригородное, Кашинское, Тверская область
    _5_0_19_2='50:19:2' # Коробовское, Шатурское, Московская область
    _3_5_22_5='35:22:5' # Лентьевское, Устюженское, Вологодская область
    _5_0_19_1='50:19:1' # Белоозерское, Шатурское, Московская область
    _3_5_22_4='35:22:4' # Залесское, Устюженское, Вологодская область
    _3_5_22_3='35:22:3' # Жуковское, Устюженское, Вологодская область
    _3_5_22_2='35:22:2' # Долоцкое, Устюженское, Вологодская область
    _4_3_1_1='43:1:1' # Афанасьевское, Афанасьевское, Кировская область
    _4_3_1_3='43:1:3' # Бисеровское, Афанасьевское, Кировская область
    _4_3_1_2='43:1:2' # Афанасьевское сельское, Афанасьевское, Кировская область
    _4_3_24_5='43:24:5' # Тохтинское, Орловское, Кировская область
    _4_3_24_6='43:24:6' # Халтуринское, Орловское, Кировская область
    _5_2_33_2='52:33:2' # Килемарское, Шарангское районное, Нижегородская область
    _4_3_1_8='43:1:8' # Пашинское сельское, Афанасьевское, Кировская область
    _5_2_33_1='52:33:1' # Большерудкинское, Шарангское районное, Нижегородская область
    _5_2_33_3='52:33:3' # Шарангское, Шарангское районное, Нижегородская область
    _4_3_1_5='43:1:5' # Гординское, Афанасьевское, Кировская область
    _4_3_1_4='43:1:4' # Борское, Афанасьевское, Кировская область
    _4_3_1_7='43:1:7' # Лыткинское, Афанасьевское, Кировская область
    _4_3_1_6='43:1:6' # Колычёвское, Афанасьевское, Кировская область
    _3_5_22_1='35:22:1' # Ванское, Устюженское, Вологодская область
    _7_4_2_3='74:2:3' # Миньярское, Ашинское, Челябинская область
    _7_4_2_4='74:2:4' # Симское, Ашинское, Челябинская область
    _7_4_2_1='74:2:1' # Ашинское, Ашинское, Челябинская область
    _7_4_2_2='74:2:2' # Биянское, Ашинское, Челябинская область
    _2_2_25_3='22:25:3' # Сайдыпское, Солтонское, Алтайский край
    _2_2_25_4='22:25:4' # Сузопское, Солтонское, Алтайский край
    _2_2_25_1='22:25:1' # Макарьевское, Солтонское, Алтайский край
    _2_2_25_2='22:25:2' # Нижне-Ненинское, Солтонское, Алтайский край
    _2_2_25_5='22:25:5' # Целинное, Солтонское, Алтайский край
    _2_4_7_5='24:7:5' # Мостовское, Большемуртинское, Красноярский край
    _2_4_7_6='24:7:6' # Предивинское, Большемуртинское, Красноярский край
    _2_4_7_3='24:7:3' # Верхне-Казанское, Большемуртинское, Красноярский край
    _2_4_7_4='24:7:4' # Красноключинское, Большемуртинское, Красноярский край
    _2_4_7_7='24:7:7' # Таловское, Большемуртинское, Красноярский край
    _2_4_7_8='24:7:8' # Юксеевское, Большемуртинское, Красноярский край
    _5_0_19_6='50:19:6' # Мишеронское, Шатурское, Московская область
    _5_0_19_5='50:19:5' # Мещерское, Шатурское, Московская область
    _5_0_19_4='50:19:4' # Майское, Шатурское, Московская область
    _5_0_19_3='50:19:3' # Кривандинское, Шатурское, Московская область
    _2_4_7_1='24:7:1' # Большемуртинское, Большемуртинское, Красноярский край
    _5_0_19_9='50:19:9' # Рошальское, Шатурское, Московская область
    _2_4_7_2='24:7:2' # Большемуртинское сельское, Большемуртинское, Красноярский край
    _5_0_19_8='50:19:8' # Подлесное, Шатурское, Московская область
    _5_0_19_7='50:19:7' # Осановское, Шатурское, Московская область
    _6_3_16_1='63:16:1' # Кузькинское, Шигонское, Самарская область
    _6_3_16_2='63:16:2' # Львовское, Шигонское, Самарская область
    _6_3_16_3='63:16:3' # Новодевиченское, Шигонское, Самарская область
    _6_3_16_4='63:16:4' # Усольское, Шигонское, Самарская область
    _4_3_11_2='43:11:2' # Поломское, Кирово-Чепецкое, Кировская область
    _4_3_11_1='43:11:1' # Заречное, Кирово-Чепецкое, Кировская область
    _4_3_11_3='43:11:3' # Филипповское, Кирово-Чепецкое, Кировская область
    _1_8_24_2='18:24:2' # Мукшинское, Якшур-Бодьинское, Удмуртская Республика
    _1_8_24_1='18:24:1' # Кекоранское, Якшур-Бодьинское, Удмуртская Республика
    _1_8_24_4='18:24:4' # Чуровское, Якшур-Бодьинское, Удмуртская Республика
    _1_8_24_3='18:24:3' # Селычинское, Якшур-Бодьинское, Удмуртская Республика
    _7_9_5_1='79:5:1' # Дичунское, Облученское, Еврейская автономная область
    _7_9_5_2='79:5:2' # Облученское, Облученское, Еврейская автономная область
    _7_9_5_3='79:5:3' # Сутарское, Облученское, Еврейская автономная область
    _1_8_5_1='18:5:1' # Белорецкое, Глазовское, Удмуртская Республика
    _1_8_5_3='18:5:3' # Севинское, Глазовское, Удмуртская Республика
    _1_8_5_2='18:5:2' # Парзинское, Глазовское, Удмуртская Республика
    _4_0_12_2='40:12:2' # Детчинское, Малоярославецкое, Калужская область
    _4_0_12_1='40:12:1' # Бабаевское, Малоярославецкое, Калужская область
    _4_0_12_4='40:12:4' # Малоярославецкое, Малоярославецкое, Калужская область
    _4_0_12_3='40:12:3' # Ильинское, Малоярославецкое, Калужская область
    _4_0_12_5='40:12:5' # Неделинское, Малоярославецкое, Калужская область
    _5_2_20_4='52:20:4' # Личадеевское, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_3='52:20:3' # Лесостепное, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_6='52:20:6' # Мухтоловское, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_5='52:20:5' # Майданское, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_2='52:20:2' # Балахонихинское, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_1='52:20:1' # Ардатовское, Мухтоловское межрайонное, Нижегородская область
    _5_2_20_7='52:20:7' # Саконское, Мухтоловское межрайонное, Нижегородская область
    _3_8_21_3='38:21:3' # Игирминское, Нижнеилимское, Иркутская область
    _1_0_17_3='10:17:3' # Клюшиногорское, Суоярвское, Республика Карелия
    _3_8_21_2='38:21:2' # Железногорское, Нижнеилимское, Иркутская область
    _1_0_17_4='10:17:4' # Куолисмское, Суоярвское, Республика Карелия
    _3_8_21_5='38:21:5' # Ярское, Нижнеилимское, Иркутская область
    _1_0_17_1='10:17:1' # Вегарусское, Суоярвское, Республика Карелия
    _3_8_21_4='38:21:4' # Рудногорское, Нижнеилимское, Иркутская область
    _1_0_17_2='10:17:2' # Вешкельское, Суоярвское, Республика Карелия
    _1_0_17_7='10:17:7' # Найстеньярвское, Суоярвское, Республика Карелия
    _1_0_17_8='10:17:8' # Пийтсиекское, Суоярвское, Республика Карелия
    _3_8_21_1='38:21:1' # Верхнеилимское, Нижнеилимское, Иркутская область
    _1_0_17_5='10:17:5' # Кяснясельгское, Суоярвское, Республика Карелия
    _1_0_17_6='10:17:6' # Лахколамбинское, Суоярвское, Республика Карелия
    _4_2_7_6='42:7:6' # Тонгульское, Мариинское, Кемеровская область
    _2_5_1_8='25:1:8' # Скворцовское, Арсеньевское, Приморский край
    _4_2_7_5='42:7:5' # Таежно-Михайловское, Мариинское, Кемеровская область
    _2_5_1_9='25:1:9' # Смольнинское, Арсеньевское, Приморский край
    _4_2_7_4='42:7:4' # Сельское, Мариинское, Кемеровская область
    _1_0_17_9='10:17:9' # Поросозерское, Суоярвское, Республика Карелия
    _4_2_7_3='42:7:3' # Комиссаровское, Мариинское, Кемеровская область
    _4_2_7_2='42:7:2' # Закийское, Мариинское, Кемеровская область
    _4_2_7_1='42:7:1' # Даниловское, Мариинское, Кемеровская область
    _2_5_1_1='25:1:1' # Буянковское, Арсеньевское, Приморский край
    _2_5_1_2='25:1:2' # Варваровское, Арсеньевское, Приморский край
    _2_5_1_3='25:1:3' # Виноградовское, Арсеньевское, Приморский край
    _2_5_1_4='25:1:4' # Гордеевское, Арсеньевское, Приморский край
    _2_5_1_5='25:1:5' # Муравейское, Арсеньевское, Приморский край
    _2_5_1_6='25:1:6' # Новосысоевское, Арсеньевское, Приморский край
    _2_5_1_7='25:1:7' # Покровское, Арсеньевское, Приморский край
    _5_9_20_3='59:20:3' # Очерское, Очерское, Пермский край
    _5_9_20_2='59:20:2' # Оханское, Очерское, Пермский край
    _5_9_20_1='59:20:1' # Большесосновское, Очерское, Пермский край
    _6_6_4_9='66:4:9' # Ревдинское, Билимбаевское, Свердловская область
    _6_6_4_8='66:4:8' # Подволошинское, Билимбаевское, Свердловская область
    _6_6_4_1='66:4:1' # Билимбаевское, Билимбаевское, Свердловская область
    _6_6_4_3='66:4:3' # Кузинское, Билимбаевское, Свердловская область
    _6_6_4_2='66:4:2' # Дегтярское, Билимбаевское, Свердловская область
    _6_6_4_5='66:4:5' # Новоуткинское, Билимбаевское, Свердловская область
    _6_6_4_4='66:4:4' # Мариинское, Билимбаевское, Свердловская область
    _6_6_4_7='66:4:7' # Первоуральское, Билимбаевское, Свердловская область
    _6_6_4_6='66:4:6' # Октябрьское, Билимбаевское, Свердловская область
    _5_0_19_15='50:19:15' # Шатурское сельское, Шатурское, Московская область
    _5_0_19_14='50:19:14' # Шатурское, Шатурское, Московская область
    _5_0_19_13='50:19:13' # Шараповское, Шатурское, Московская область
    _5_0_19_12='50:19:12' # Туголесское, Шатурское, Московская область
    _5_0_19_11='50:19:11' # Середниковское, Шатурское, Московская область
    _5_0_19_10='50:19:10' # Семеновское, Шатурское, Московская область
    _4_6_10_3='46:10:3' # Солнцевское, Солнцевское, Курская область
    _4_3_37_1='43:37:1' # Высокораменское, Шабалинское, Кировская область
    _4_3_37_2='43:37:2' # Гостовское, Шабалинское, Кировская область
    _4_3_37_7='43:37:7' # Новотроицкое сельское, Шабалинское, Кировская область
    _4_3_37_8='43:37:8' # Черновское, Шабалинское, Кировская область
    _4_3_37_9='43:37:9' # Черновское сельское, Шабалинское, Кировская область
    _4_3_37_3='43:37:3' # Жирновское, Шабалинское, Кировская область
    _4_3_37_4='43:37:4' # Ленинское, Шабалинское, Кировская область
    _4_3_37_5='43:37:5' # Ленинское сельское, Шабалинское, Кировская область
    _4_3_37_6='43:37:6' # Новотроицкое, Шабалинское, Кировская область
    _4_6_10_1='46:10:1' # Мантуровское, Солнцевское, Курская область
    _4_6_10_2='46:10:2' # Пристенское, Солнцевское, Курская область
    _9_1_9_4='91:9:4' # Октябрьское, Старокрымское, Республика Крым
    _9_1_9_3='91:9:3' # Ленинское, Старокрымское, Республика Крым
    _9_1_9_6='91:9:6' # Феодосийское, Старокрымское, Республика Крым
    _9_1_9_5='91:9:5' # Старокрымское, Старокрымское, Республика Крым
    _9_1_9_2='91:9:2' # Керченское, Старокрымское, Республика Крым
    _9_1_9_1='91:9:1' # Грушевское, Старокрымское, Республика Крым
    _5_6_21_2='56:21:2' # Русско-Кандызское, Северное, Оренбургская область
    _5_6_21_3='56:21:3' # Рычковское, Северное, Оренбургская область
    _5_6_21_4='56:21:4' # Секретарское, Северное, Оренбургская область
    _5_6_21_1='56:21:1' # Верхне-Сокское, Северное, Оренбургская область
    _3_8_34_2='38:34:2' # Усть-Удинское, Усть-Удинское, Иркутская область
    _3_8_34_1='38:34:1' # Подволоченское, Усть-Удинское, Иркутская область
    _6_0_7_2='60:7:2' # Заянское, Плюсское, Псковская область
    _6_0_7_1='60:7:1' # Житковицкое, Плюсское, Псковская область
    _6_0_7_4='60:7:4' # Плюсское, Плюсское, Псковская область
    _6_0_7_3='60:7:3' # Лядское, Плюсское, Псковская область
    _5_19_2='5:19:2' # Кизилюртовское, Хасавюртовское, Республика Дагестан
    _5_19_1='5:19:1' # Андреаульское, Хасавюртовское, Республика Дагестан
    _5_19_3='5:19:3' # Хасавюртовское, Хасавюртовское, Республика Дагестан
    _3_6_5_5='36:5:5' # Тресвятское, Воронежское, Воронежская область
    _3_6_5_4='36:5:4' # Рождественно-Хавское, Воронежское, Воронежская область
    _3_6_5_3='36:5:3' # Рамонское, Воронежское, Воронежская область
    _3_6_5_2='36:5:2' # Краснолесенское, Воронежское, Воронежская область
    _3_6_5_1='36:5:1' # Борское, Воронежское, Воронежская область
    _1_2_8_4='12:8:4' # Учебно-опытное, Куярское, Республика Марий Эл
    _1_2_8_3='12:8:3' # Устье-Кундышское, Куярское, Республика Марий Эл
    _6_6_14_7='66:14:7' # Салдинское, Кушвинское, Свердловская область
    _6_6_14_5='66:14:5' # Кушвинское, Кушвинское, Свердловская область
    _6_6_14_6='66:14:6' # Нижне-Салдинское, Кушвинское, Свердловская область
    _6_6_14_3='66:14:3' # Верхне-Салдинское, Кушвинское, Свердловская область
    _6_6_14_4='66:14:4' # Красноуральское, Кушвинское, Свердловская область
    _6_6_14_1='66:14:1' # Азиатское, Кушвинское, Свердловская область
    _6_6_14_2='66:14:2' # Баранчинское, Кушвинское, Свердловская область
    _1_2_8_2='12:8:2' # Сурокское, Куярское, Республика Марий Эл
    _1_2_8_1='12:8:1' # Куярское, Куярское, Республика Марий Эл
    _6_1_1='6:1:1' # Али-Юртовское, Назрановское, Республика Ингушетия
    _5_9_9_6='59:9:6' # Суксунское, Кишертское, Пермский край
    _6_1_2='6:1:2' # Карабулакское, Назрановское, Республика Ингушетия
    _5_9_9_5='59:9:5' # Поедугинское, Кишертское, Пермский край
    _6_1_3='6:1:3' # Малгобекское, Назрановское, Республика Ингушетия
    _5_9_9_4='59:9:4' # Кордонское, Кишертское, Пермский край
    _6_1_4='6:1:4' # Ново-Редантское, Назрановское, Республика Ингушетия
    _5_9_9_3='59:9:3' # Кишертское, Кишертское, Пермский край
    _5_9_9_2='59:9:2' # Березовское, Кишертское, Пермский край
    _5_9_9_1='59:9:1' # Асовское, Кишертское, Пермский край
    _5_3_18_8='53:18:8' # Передольское, Шимское, Новгородская область
    _5_3_18_7='53:18:7' # Ольховское, Шимское, Новгородская область
    _5_3_18_9='53:18:9' # Солецкое, Шимское, Новгородская область
    _5_3_18_2='53:18:2' # Выбитское, Шимское, Новгородская область
    _5_3_18_1='53:18:1' # Батецкое, Шимское, Новгородская область
    _5_3_18_4='53:18:4' # Люболядское, Шимское, Новгородская область
    _5_3_18_3='53:18:3' # Городищенское, Шимское, Новгородская область
    _5_3_18_6='53:18:6' # Озеревское, Шимское, Новгородская область
    _5_3_18_5='53:18:5' # Мойкинское, Шимское, Новгородская область
    _1_6_27_5='16:27:5' # Шеланговское, Приволжское, Республика Татарстан (Татарстан)
    _1_6_27_4='16:27:4' # Чулпанихинское, Приволжское, Республика Татарстан (Татарстан)
    _1_6_27_3='16:27:3' # Теньковское, Приволжское, Республика Татарстан (Татарстан)
    _1_6_27_2='16:27:2' # Свияжское, Приволжское, Республика Татарстан (Татарстан)
    _1_6_27_1='16:27:1' # Ключищенское, Приволжское, Республика Татарстан (Татарстан)
    _1_3_2_4='13:2:4' # Чамзинское, Березниковское территориальное, Республика Мордовия
    _1_3_2_3='13:2:3' # Николаевское, Березниковское территориальное, Республика Мордовия
    _1_3_2_2='13:2:2' # Дубенское, Березниковское территориальное, Республика Мордовия
    _1_3_2_1='13:2:1' # Березниковское, Березниковское территориальное, Республика Мордовия
    _6_1_1_2='61:1:2' # Поповское, Боковское, Ростовская область
    _6_1_1_1='61:1:1' # Боковское, Боковское, Ростовская область
    _7_4_17_2='74:17:2' # Саткинское, Саткинское, Челябинская область
    _7_4_17_1='74:17:1' # Бердяушское, Саткинское, Челябинская область
    _4_7_1_26='47:1:26' # Шидрозерское, Бокситогорское, Ленинградская область
    _4_7_1_25='47:1:25' # Тургошское, Бокситогорское, Ленинградская область
    _4_7_1_24='47:1:24' # Соминское, Бокситогорское, Ленинградская область
    _4_7_1_23='47:1:23' # Самойловское, Бокситогорское, Ленинградская область
    _4_7_1_22='47:1:22' # Раменское, Бокситогорское, Ленинградская область
    _7_4_17_3='74:17:3' # Сулеинское, Саткинское, Челябинская область
    _2_14_12='2:14:12' # Яркеевское, Дюртюлинское, Республика Башкортостан
    _2_14_11='2:14:11' # Шариповское, Дюртюлинское, Республика Башкортостан
    _2_14_10='2:14:10' # Чумарское, Дюртюлинское, Республика Башкортостан
    _4_7_1_18='47:1:18' # Озеревское, Бокситогорское, Ленинградская область
    _4_7_1_17='47:1:17' # Новодеревенское, Бокситогорское, Ленинградская область
    _4_7_1_16='47:1:16' # Мозолевское, Бокситогорское, Ленинградская область
    _4_7_1_15='47:1:15' # Михайловское, Бокситогорское, Ленинградская область
    _4_7_1_14='47:1:14' # Лидское, Бокситогорское, Ленинградская область
    _4_7_1_13='47:1:13' # Кургальское, Бокситогорское, Ленинградская область
    _6_6_27_5='66:27:5' # Тавдинское, Тавдинское, Свердловская область
    _4_7_1_12='47:1:12' # Корвальское, Бокситогорское, Ленинградская область
    _6_6_27_4='66:27:4' # Матюшинское, Тавдинское, Свердловская область
    _4_7_1_11='47:1:11' # Колпинское, Бокситогорское, Ленинградская область
    _6_6_27_3='66:27:3' # Карабашевское, Тавдинское, Свердловская область
    _6_6_27_2='66:27:2' # Им. Павлика Морозова, Тавдинское, Свердловская область
    _6_6_27_1='66:27:1' # Городское, Тавдинское, Свердловская область
    _4_7_1_19='47:1:19' # Пикалевское, Бокситогорское, Ленинградская область
    _7_3_9_3='73:9:3' # Найманское, Николаевское, Ульяновская область
    _7_0_20_3='70:20:3' # Поскоево-Добринское, Чаинское, Томская область
    _7_3_9_4='73:9:4' # Николаевское, Николаевское, Ульяновская область
    _7_0_20_4='70:20:4' # Тигинское, Чаинское, Томская область
    _7_3_9_5='73:9:5' # Пичеурское, Николаевское, Ульяновская область
    _5_0_1_11='50:1:11' # Щелкановское, "Русский лес", Московская область
    _7_3_9_6='73:9:6' # Сайманское, Николаевское, Ульяновская область
    _5_5_11_10='55:11:10' # Усть-Заостровское, Омское, Омская область
    _7_3_9_1='73:9:1' # Андреевское, Николаевское, Ульяновская область
    _7_3_9_2='73:9:2' # Белоозерское, Николаевское, Ульяновская область
    _4_8_3_1='48:3:1' # Добровское, Добровское, Липецкая область
    _4_7_1_21='47:1:21' # Радогощинское, Бокситогорское, Ленинградская область
    _4_8_3_2='48:3:2' # Кривецкое, Добровское, Липецкая область
    _4_7_1_20='47:1:20' # Подборовское, Бокситогорское, Ленинградская область
    _4_8_3_3='48:3:3' # Трубетчинское, Добровское, Липецкая область
    _5_0_1_10='50:1:10' # Шатовское, "Русский лес", Московская область
    _7_3_9_7='73:9:7' # Славкинское, Николаевское, Ульяновская область
    _7_3_9_8='73:9:8' # Тепловское, Николаевское, Ульяновская область
    _7_3_9_9='73:9:9' # Эзекеевское, Николаевское, Ульяновская область
    _7_0_20_1='70:20:1' # Нюрсинское, Чаинское, Томская область
    _7_0_20_2='70:20:2' # Обское, Чаинское, Томская область
    _5_5_11_11='55:11:11' # Харинское, Омское, Омская область
    _4_7_1_10='47:1:10' # Заборское, Бокситогорское, Ленинградская область
    _2_2_12_1='22:12:1' # Дресвянское, Каменское, Алтайский край
    _2_2_12_2='22:12:2' # Столбовское, Каменское, Алтайский край
    _2_9_25_1='29:25:1' # Лавельское, Сурское, Архангельская область
    _2_9_25_2='29:25:2' # Нюхченское, Сурское, Архангельская область
    _2_9_25_3='29:25:3' # Пюлавское, Сурское, Архангельская область
    _2_9_25_4='29:25:4' # Сулецкое, Сурское, Архангельская область
    _2_9_25_5='29:25:5' # Сурское, Сурское, Архангельская область
    _2_9_25_6='29:25:6' # Шуйгинское, Сурское, Архангельская область
    _3_2_10_1='32:10:1' # Борковское, Клинцовское, Брянская область
    _3_2_10_2='32:10:2' # Красногорское, Клинцовское, Брянская область
    _3_2_10_3='32:10:3' # Суражское, Клинцовское, Брянская область
    _3_2_10_4='32:10:4' # Ущерпское, Клинцовское, Брянская область
    _1_6_14_3='16:14:3' # Краснооктябрьское, Зеленодольское, Республика Татарстан (Татарстан)
    _1_6_14_2='16:14:2' # Зеленодольское, Зеленодольское, Республика Татарстан (Татарстан)
    _1_6_14_1='16:14:1' # Айшинское, Зеленодольское, Республика Татарстан (Татарстан)
    _2_9_12_2='29:12:2' # Красноборское, Красноборское, Архангельская область
    _2_9_12_3='29:12:3' # Красноборское сельское, Красноборское, Архангельская область
    _2_9_12_4='29:12:4' # Новошинское, Красноборское, Архангельская область
    _2_9_12_5='29:12:5' # Праводвинское, Красноборское, Архангельская область
    _5_7_2='5:7:2' # Карабудахкентское, Карабудахкентское, Республика Дагестан
    _2_9_12_1='29:12:1' # Комаровское, Красноборское, Архангельская область
    _5_7_1='5:7:1' # Губденское, Карабудахкентское, Республика Дагестан
    _2_9_12_6='29:12:6' # Слободское, Красноборское, Архангельская область
    _2_9_12_7='29:12:7' # Уфтюгское, Красноборское, Архангельская область
    _2_9_12_8='29:12:8' # Уфтюгское сельское, Красноборское, Архангельская область
    _2_9_12_9='29:12:9' # Черевковское, Красноборское, Архангельская область
    _5_4_6_1='54:6:1' # Бердский лесохозяйственный участок, Искитимское, Новосибирская область
    _5_4_6_2='54:6:2' # Гуселетовский лесохозяйственный участок, Искитимское, Новосибирская область
    _5_4_6_3='54:6:3' # Елбашинский лесохозяйственный участок, Искитимское, Новосибирская область
    _5_4_6_4='54:6:4' # Искитимский лесохозяйственный участок № 1, Искитимское, Новосибирская область
    _5_4_6_5='54:6:5' # Легостаевский лесохозяйственный участок, Искитимское, Новосибирская область
    _4_3_12_1='43:12:1' # Барановское, Кирсинское, Кировская область
    _4_3_12_3='43:12:3' # Пещерское, Кирсинское, Кировская область
    _4_3_12_2='43:12:2' # Кирсинское, Кирсинское, Кировская область
    _7_9_6_4='79:6:4' # Самарское, Октябрьское, Еврейская автономная область
    _3_5_21_8='35:21:8' # Центральное, Усть-Кубинское, Вологодская область
    _3_5_21_7='35:21:7' # Устьянское, Усть-Кубинское, Вологодская область
    _3_5_21_6='35:21:6' # Сусельское, Усть-Кубинское, Вологодская область
    _3_5_21_5='35:21:5' # Северо-Кубинское, Усть-Кубинское, Вологодская область
    _3_5_21_4='35:21:4' # Куркинское, Усть-Кубинское, Вологодская область
    _3_5_21_3='35:21:3' # Верхнераменское, Усть-Кубинское, Вологодская область
    _2_9_26_1='29:26:1' # Бестужевское, Устьянское, Архангельская область
    _2_9_26_2='29:26:2' # Дмитриевское, Устьянское, Архангельская область
    _7_9_6_1='79:6:1' # Биджанское, Октябрьское, Еврейская автономная область
    _7_9_6_2='79:6:2' # Полевое, Октябрьское, Еврейская автономная область
    _7_9_6_3='79:6:3' # Помпеевское, Октябрьское, Еврейская автономная область
    _2_9_26_7='29:26:7' # Минское, Устьянское, Архангельская область
    _2_9_26_8='29:26:8' # Октябрьское, Устьянское, Архангельская область
    _2_9_26_9='29:26:9' # Плосское, Устьянское, Архангельская область
    _2_9_26_3='29:26:3' # Железнодорожное, Устьянское, Архангельская область
    _1_8_4_2='18:4:2' # Июльское, Воткинское, Удмуртская Республика
    _2_9_26_4='29:26:4' # Квазеньгское, Устьянское, Архангельская область
    _1_8_4_1='18:4:1' # Березовское, Воткинское, Удмуртская Республика
    _2_9_26_5='29:26:5' # Киземское, Устьянское, Архангельская область
    _2_9_26_6='29:26:6' # Лихачевское, Устьянское, Архангельская область
    _1_8_4_3='18:4:3' # Черновское, Воткинское, Удмуртская Республика
    _3_5_21_2='35:21:2' # Богородское, Усть-Кубинское, Вологодская область
    _3_5_21_1='35:21:1' # Бережновское, Усть-Кубинское, Вологодская область
    _7_4_3_2='74:3:2' # Кизильское, Брединское, Челябинская область
    _7_4_3_3='74:3:3' # Кортубайское, Брединское, Челябинская область
    _7_4_3_1='74:3:1' # Брединское, Брединское, Челябинская область
    _2_2_24_1='22:24:1' # Воронихинское, Ребрихинское, Алтайский край
    _1_8_12_1='18:12:1' # Ключевское, Кезское, Удмуртская Республика
    _2_2_24_4='22:24:4' # Ребрихинское, Ребрихинское, Алтайский край
    _1_8_12_3='18:12:3' # Кулигинское, Кезское, Удмуртская Республика
    _2_2_24_5='22:24:5' # Рожне-Логовское, Ребрихинское, Алтайский край
    _1_8_12_2='18:12:2' # Кузьминское, Кезское, Удмуртская Республика
    _2_2_24_2='22:24:2' # Кадниковское, Ребрихинское, Алтайский край
    _1_8_12_5='18:12:5' # Чепецкое, Кезское, Удмуртская Республика
    _2_2_24_3='22:24:3' # Подстепновское, Ребрихинское, Алтайский край
    _1_8_12_4='18:12:4' # Лесное, Кезское, Удмуртская Республика
    _2_4_8_1='24:8:1' # Большеулуйское, Большеулуйское, Красноярский край
    _4_3_2_2='43:2:2' # Белохолуницкое сельское, Белохолуницкое, Кировская область
    _4_3_2_1='43:2:1' # Белохолуницкое, Белохолуницкое, Кировская область
    _5_2_32_3='52:32:3' # Михайловское, Уренское районное, Нижегородская область
    _5_2_32_2='52:32:2' # Карповское, Уренское районное, Нижегородская область
    _5_2_32_5='52:32:5' # Тулажское, Уренское районное, Нижегородская область
    _5_2_32_4='52:32:4' # Семеновское, Уренское районное, Нижегородская область
    _4_3_2_4='43:2:4' # Климковское, Белохолуницкое, Кировская область
    _4_3_2_3='43:2:3' # Елевское, Белохолуницкое, Кировская область
    _5_2_32_1='52:32:1' # Арьевское, Уренское районное, Нижегородская область
    _4_3_2_5='43:2:5' # Прокопьевское, Белохолуницкое, Кировская область
    _5_2_32_6='52:32:6' # Уренское, Уренское районное, Нижегородская область
    _4_0_13_1='40:13:1' # Кременское, Медынское, Калужская область
    _5_9_21_5='59:21:5' # Рождественское, Пермское, Пермский край
    _2_6_12_2='26:12:2' # Ставропольское, Ставропольское, Ставропольский край
    _2_6_12_1='26:12:1' # Грачевское, Ставропольское, Ставропольский край
    _4_0_13_3='40:13:3' # Передельское, Медынское, Калужская область
    _4_0_13_2='40:13:2' # Медынское, Медынское, Калужская область
    _4_0_13_4='40:13:4' # Шанско-Заводское, Медынское, Калужская область
    _5_9_21_4='59:21:4' # Лядовское, Пермское, Пермский край
    _5_9_21_3='59:21:3' # Лобановское, Пермское, Пермский край
    _5_9_21_2='59:21:2' # Култаевское, Пермское, Пермский край
    _5_9_21_1='59:21:1' # Кукуштанское, Пермское, Пермский край
    _3_8_33_3='38:33:3' # Эхирит-Булагатское, Усть-Ордынское, Иркутская область
    _3_8_33_1='38:33:1' # Байтогское, Усть-Ордынское, Иркутская область
    _3_8_33_2='38:33:2' # Тугутуйское, Усть-Ордынское, Иркутская область
    _3_8_20_1='38:20:1' # Мамское, Мамское, Иркутская область
    _2_5_2_7='25:2:7' # Пожарское, Верхне-Перевальнинское, Приморский край
    _2_5_2_8='25:2:8' # Соболиное, Верхне-Перевальнинское, Приморский край
    _2_5_2_9='25:2:9' # Стрельниковское, Верхне-Перевальнинское, Приморский край
    _4_3_38_1='43:38:1' # Великорецкое, Юрьянское, Кировская область
    _4_3_38_6='43:38:6' # Юрьянское сельское, Юрьянское, Кировская область
    _2_5_2_1='25:2:1' # Бурлитское, Верхне-Перевальнинское, Приморский край
    _2_5_2_2='25:2:2' # Верхне-Перевальнинское, Верхне-Перевальнинское, Приморский край
    _4_3_38_2='43:38:2' # Гороховское сельское, Юрьянское, Кировская область
    _2_5_2_3='25:2:3' # Звеньевское, Верхне-Перевальнинское, Приморский край
    _4_3_38_3='43:38:3' # Новополомское, Юрьянское, Кировская область
    _2_5_2_4='25:2:4' # Краснояровское, Верхне-Перевальнинское, Приморский край
    _4_3_38_4='43:38:4' # Пышакское сельское, Юрьянское, Кировская область
    _2_5_2_5='25:2:5' # Лермонтовское, Верхне-Перевальнинское, Приморский край
    _4_3_38_5='43:38:5' # Юрьянское, Юрьянское, Кировская область
    _2_5_2_6='25:2:6' # Лучегорское, Верхне-Перевальнинское, Приморский край
    _5_6_22_1='56:22:1' # Буранное, Соль-Илецкое, Оренбургская область
    _5_6_22_2='56:22:2' # Соль-Илецкое, Соль-Илецкое, Оренбургская область
    _5_17_2='5:17:2' # Сыртычское, Табасаранское, Республика Дагестан
    _5_17_1='5:17:1' # Дюбекское, Табасаранское, Республика Дагестан
    _5_17_3='5:17:3' # Хурикское, Табасаранское, Республика Дагестан
    _4_3_25_1='43:25:1' # Бахтинское сельское, Парковое, Кировская область
    _4_3_25_2='43:25:2' # Бобинское, Парковое, Кировская область
    _4_3_25_3='43:25:3' # Ленинское, Парковое, Кировская область
    _4_3_25_8='43:25:8' # Пасеговское, Парковое, Кировская область
    _6_6_3_2='66:3:2' # Березовское, Березовское, Свердловская область
    _4_3_25_9='43:25:9' # Перекопское, Парковое, Кировская область
    _6_6_3_1='66:3:1' # Балтымское, Березовское, Свердловская область
    _6_6_3_4='66:3:4' # Монетное, Березовское, Свердловская область
    _6_6_3_3='66:3:3' # Лосиновское, Березовское, Свердловская область
    _4_3_25_4='43:25:4' # Лянгасовское, Парковое, Кировская область
    _6_6_3_6='66:3:6' # Пышминское, Березовское, Свердловская область
    _4_3_25_5='43:25:5' # Медянское, Парковое, Кировская область
    _6_6_3_5='66:3:5' # Мостовское, Березовское, Свердловская область
    _4_3_25_6='43:25:6' # Мурыгинское сельское, Парковое, Кировская область
    _4_3_25_7='43:25:7' # Новобыстрицкое, Парковое, Кировская область
    _6_6_3_7='66:3:7' # Среднеуральское, Березовское, Свердловская область
    _1_0_17_12='10:17:12' # Суйстамское, Суоярвское, Республика Карелия
    _1_0_17_13='10:17:13' # Суоярвское, Суоярвское, Республика Карелия
    _1_0_17_10='10:17:10' # Райконкосское, Суоярвское, Республика Карелия
    _1_0_17_11='10:17:11' # Салмиярвское, Суоярвское, Республика Карелия
    _1_0_17_16='10:17:16' # Южно-Селегское, Суоярвское, Республика Карелия
    _1_0_16_1='10:16:1' # Валаамское, Сортавальское, Республика Карелия
    _1_0_17_14='10:17:14' # Толвоярвское, Суоярвское, Республика Карелия
    _1_0_17_15='10:17:15' # Хаутаваарское, Суоярвское, Республика Карелия
    _1_0_16_4='10:16:4' # Рускеальское, Сортавальское, Республика Карелия
    _1_0_16_5='10:16:5' # Сортавальское, Сортавальское, Республика Карелия
    _1_0_16_2='10:16:2' # Ладожское, Сортавальское, Республика Карелия
    _1_0_16_3='10:16:3' # Пуйккольское, Сортавальское, Республика Карелия
    _1_0_16_6='10:16:6' # Хелюльское, Сортавальское, Республика Карелия
    _4_2_8_5='42:8:5' # Тебинское, Междуреченское, Кемеровская область
    _4_2_8_4='42:8:4' # Поднебесные зубья, Междуреченское, Кемеровская область
    _4_2_8_3='42:8:3' # Ольжерасское, Междуреченское, Кемеровская область
    _4_2_8_2='42:8:2' # Междуреченское, Междуреченское, Кемеровская область
    _4_2_8_1='42:8:1' # Майзасское, Междуреченское, Кемеровская область
    _4_2_8_6='42:8:6' # Хомутовское, Междуреченское, Кемеровская область
    _9_1_8_5='91:8:5' # Перевальненское, Симферопольское, Республика Крым
    _9_1_8_4='91:8:4' # Партизанское, Симферопольское, Республика Крым
    _9_1_8_6='91:8:6' # Пионерское, Симферопольское, Республика Крым
    _3_5_5_10='35:5:10' # Палемское, Великоустюгское, Вологодская область
    _3_5_5_11='35:5:11' # Усть-Алексеевское, Великоустюгское, Вологодская область
    _3_5_5_12='35:5:12' # Усть-Алексеевское сельское, Великоустюгское, Вологодская область
    _8_6_1_3='86:1:3' # Радужнинское, Аганское, Ханты-Мансийский автономный округ - Югра
    _8_6_1_2='86:1:2' # Новоаганское, Аганское, Ханты-Мансийский автономный округ - Югра
    _8_6_1_1='86:1:1' # Колек-Ёганское, Аганское, Ханты-Мансийский автономный округ - Югра
    _4_7_19_2='47:19:2' # Кастенское, Учебно-опытное, Ленинградская область
    _4_7_19_1='47:19:1' # Жерновское, Учебно-опытное, Ленинградская область
    _9_1_8_1='91:8:1' # Красногорское, Симферопольское, Республика Крым
    _4_7_19_5='47:19:5' # Перинское, Учебно-опытное, Ленинградская область
    _4_7_19_4='47:19:4' # Лисинское, Учебно-опытное, Ленинградская область
    _9_1_8_3='91:8:3' # Межгорское, Симферопольское, Республика Крым
    _4_7_19_3='47:19:3' # Кудровское, Учебно-опытное, Ленинградская область
    _9_1_8_2='91:8:2' # Лесопарковое, Симферопольское, Республика Крым
    _5_4_19_12='54:19:12' # Шайдуровский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_9_8_6='59:8:6' # Яйвинское, Кизеловское, Пермский край
    _5_9_8_5='59:8:5' # Чикманское, Кизеловское, Пермский край
    _5_9_8_4='59:8:4' # Коспашское, Кизеловское, Пермский край
    _5_9_8_3='59:8:3' # Кизеловское, Кизеловское, Пермский край
    _5_9_8_2='59:8:2' # Губахинское, Кизеловское, Пермский край
    _5_9_8_1='59:8:1' # Александровское, Кизеловское, Пермский край
    _5_4_19_10='54:19:10' # Усть-Хмелевский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_19_11='54:19:11' # Чингисский лесохозяйственный участок, Ордынское, Новосибирская область
    _3_6_6_3='36:6:3' # Новенькое, Воронцовское, Воронежская область
    _3_6_6_2='36:6:2' # Красное, Воронцовское, Воронежская область
    _3_6_6_1='36:6:1' # Александровское, Воронцовское, Воронежская область
    _1_6_13_5='16:13:5' # Ямашинское, Заинское, Республика Татарстан (Татарстан)
    _1_6_13_4='16:13:4' # Урганчинское, Заинское, Республика Татарстан (Татарстан)
    _1_6_13_3='16:13:3' # Кушниковское, Заинское, Республика Татарстан (Татарстан)
    _1_6_13_2='16:13:2' # Заинское, Заинское, Республика Татарстан (Татарстан)
    _1_6_13_1='16:13:1' # Болгарское, Заинское, Республика Татарстан (Татарстан)
    _6_1_18_4='61:18:4' # Еланское, Шолоховское, Ростовская область
    _6_1_18_5='61:18:5' # Колундаевское, Шолоховское, Ростовская область
    _5_18_1='5:18:1' # Анцухское, Тляратинское, Республика Дагестан
    _5_18_2='5:18:2' # Хадияльское, Тляратинское, Республика Дагестан
    _6_6_13_8='66:13:8' # Пригородное, Красноуфимское, Свердловская область
    _6_6_13_9='66:13:9' # Сажинское, Красноуфимское, Свердловская область
    _6_6_13_6='66:13:6' # Нижне-Саранинское, Красноуфимское, Свердловская область
    _6_6_13_7='66:13:7' # Поташкинское, Красноуфимское, Свердловская область
    _6_6_13_4='66:13:4' # Ключевское, Красноуфимское, Свердловская область
    _6_6_13_5='66:13:5' # Нижне-Иргинское, Красноуфимское, Свердловская область
    _6_6_13_2='66:13:2' # Афанасьевское, Красноуфимское, Свердловская область
    _6_6_13_3='66:13:3' # Ачитское, Красноуфимское, Свердловская область
    _1_2_7_1='12:7:1' # Красностекловарское, Кужерское, Республика Марий Эл
    _6_6_13_1='66:13:1' # Артинское, Красноуфимское, Свердловская область
    _1_2_7_3='12:7:3' # Чодрояльское, Кужерское, Республика Марий Эл
    _1_2_7_2='12:7:2' # Кужерское, Кужерское, Республика Марий Эл
    _6_2_1='6:2:1' # Алкунское, Сунженское, Республика Ингушетия
    _6_2_2='6:2:2' # Армхинское, Сунженское, Республика Ингушетия
    _6_2_3='6:2:3' # Галашкинское, Сунженское, Республика Ингушетия
    _6_2_4='6:2:4' # Мужичинское, Сунженское, Республика Ингушетия
    _6_2_5='6:2:5' # Нестеровское, Сунженское, Республика Ингушетия
    _6_2_6='6:2:6' # Таргимское, Сунженское, Республика Ингушетия
    _6_2_7='6:2:7' # Чемульгинское, Сунженское, Республика Ингушетия
    _5_3_17_1='53:17:1' # Грузинское, Чудовское, Новгородская область
    _5_3_17_3='53:17:3' # Оскуйское, Чудовское, Новгородская область
    _5_3_17_2='53:17:2' # Лезненское, Чудовское, Новгородская область
    _5_3_17_5='53:17:5' # Спасско-Полистское, Чудовское, Новгородская область
    _5_3_17_4='53:17:4' # Селищенское, Чудовское, Новгородская область
    _5_3_17_6='53:17:6' # Чудовское, Чудовское, Новгородская область
    _6_5_9_3='65:9:3' # Чайвинское, Ногликское, Сахалинская область
    _6_5_9_2='65:9:2' # Ногликское, Ногликское, Сахалинская область
    _6_5_9_1='65:9:1' # Катанглийское, Ногликское, Сахалинская область
    _6_6_26_5='66:26:5' # Чунь-Чешское, Таборинское, Свердловская область
    _6_6_26_4='66:26:4' # Чешское, Таборинское, Свердловская область
    _6_6_26_3='66:26:3' # Таборинское, Таборинское, Свердловская область
    _6_6_26_2='66:26:2' # Озерское, Таборинское, Свердловская область
    _6_6_26_1='66:26:1' # Александровское, Таборинское, Свердловская область
    _7_0_21_2='70:21:2' # Шегарское, Шегарское, Томская область
    _7_0_21_1='70:21:1' # Иловское, Шегарское, Томская область
    _1_3_1_4='13:1:4' # Заводское, Ардатовское территориальное, Республика Мордовия
    _1_3_1_3='13:1:3' # Большеигнатовское, Ардатовское территориальное, Республика Мордовия
    _1_3_1_2='13:1:2' # Атяшевское, Ардатовское территориальное, Республика Мордовия
    _1_3_1_1='13:1:1' # Ардатовское, Ардатовское территориальное, Республика Мордовия
    _7_4_18_1='74:18:1' # Кособродское, Увельское, Челябинская область
    _7_4_18_5='74:18:5' # Хомутининское, Увельское, Челябинская область
    _7_4_18_4='74:18:4' # Увельское, Увельское, Челябинская область
    _7_4_18_3='74:18:3' # Троицкое, Увельское, Челябинская область
    _7_4_18_2='74:18:2' # Рубежное, Увельское, Челябинская область
    _3_5_20_9='35:20:9' # Матвеевское, Тотемское, Вологодская область
    _3_5_20_8='35:20:8' # Маныловское сельское, Тотемское, Вологодская область
    _3_5_20_7='35:20:7' # Маныловское, Тотемское, Вологодская область
    _3_5_20_6='35:20:6' # Лучкинское, Тотемское, Вологодская область
    _3_5_20_5='35:20:5' # Камчугское, Тотемское, Вологодская область
    _3_5_20_4='35:20:4' # Калининское сельское, Тотемское, Вологодская область
    _6_1_18_2='61:18:2' # Базковское, Шолоховское, Ростовская область
    _6_1_18_3='61:18:3' # Вешенское, Шолоховское, Ростовская область
    _6_1_18_1='61:18:1' # Антиповское, Шолоховское, Ростовская область
    _4_8_4_4='48:4:4' # Скорняковское, Донское, Липецкая область
    _3_5_20_3='35:20:3' # Калининское, Тотемское, Вологодская область
    _4_8_4_1='48:4:1' # Боринское, Донское, Липецкая область
    _3_5_20_2='35:20:2' # Заозерское, Тотемское, Вологодская область
    _4_8_4_2='48:4:2' # Донское, Донское, Липецкая область
    _3_5_20_1='35:20:1' # Вожбальское, Тотемское, Вологодская область
    _4_8_4_3='48:4:3' # Сенцовское, Донское, Липецкая область
    _2_9_13_1='29:13:1' # Вожгорское, Лешуконское, Архангельская область
    _2_9_13_2='29:13:2' # Койнасское, Лешуконское, Архангельская область
    _2_9_13_3='29:13:3' # Лешуконское, Лешуконское, Архангельская область
    _2_9_13_4='29:13:4' # Олемское, Лешуконское, Архангельская область
    _5_8_1='5:8:1' # Касумкентское, Касумкентское, Республика Дагестан
    _5_8_2='5:8:2' # Курахское, Касумкентское, Республика Дагестан
    _2_4_9_3='24:9:3' # Подкаменно-Тунгусское, Борское, Красноярский край
    _2_4_9_1='24:9:1' # Борское, Борское, Красноярский край
    _2_4_9_2='24:9:2' # Вороговское, Борское, Красноярский край
    _2_9_13_5='29:13:5' # Усть-Вашское, Лешуконское, Архангельская область
    _5_4_5_1='54:5:1' # Верх-Каргатский лесохозяйственный участок, Здвинское, Новосибирская область
    _5_4_5_2='54:5:2' # Верх-Урюмский лесохозяйственный участок, Здвинское, Новосибирская область
    _5_4_5_3='54:5:3' # Здвинский лесохозяйственный участок, Здвинское, Новосибирская область
    _2_2_11_2='22:11:2' # Бурлинское, Знаменское, Алтайский край
    _2_2_11_3='22:11:3' # Знаменское, Знаменское, Алтайский край
    _2_2_11_1='22:11:1' # Благовещенское, Знаменское, Алтайский край
    _2_2_11_6='22:11:6' # Хабарское, Знаменское, Алтайский край
    _2_2_11_4='22:11:4' # Суетское, Знаменское, Алтайский край
    _2_2_11_5='22:11:5' # Табунское, Знаменское, Алтайский край
    _6_0_6_1='60:6:1' # Воронцовское, Печорское, Псковская область
    _1_6_26_6='16:26:6' # Чулпановское, Нурлатское, Республика Татарстан (Татарстан)
    _6_0_6_3='60:6:3' # Палкинское, Печорское, Псковская область
    _1_6_26_5='16:26:5' # Тумбинское, Нурлатское, Республика Татарстан (Татарстан)
    _6_0_6_2='60:6:2' # Островское, Печорское, Псковская область
    _1_6_26_4='16:26:4' # Тимерликовское, Нурлатское, Республика Татарстан (Татарстан)
    _1_6_26_3='16:26:3' # Мамыковское, Нурлатское, Республика Татарстан (Татарстан)
    _1_6_26_2='16:26:2' # Восходское, Нурлатское, Республика Татарстан (Татарстан)
    _1_6_26_1='16:26:1' # Вишнево-Полянское, Нурлатское, Республика Татарстан (Татарстан)
    _6_0_6_5='60:6:5' # Староизборское, Печорское, Псковская область
    _6_0_6_4='60:6:4' # Печорское, Печорское, Псковская область
    _3_2_11_1='32:11:1' # Водославское, Мглинское, Брянская область
    _3_2_11_2='32:11:2' # Южное, Мглинское, Брянская область
    _1_9_1_4='19:1:4' # Онинское, Абазинское, Республика Хакасия
    _1_9_1_3='19:1:3' # Арбатское, Абазинское, Республика Хакасия
    _6_6_2_3='66:2:3' # Куминовское, Байкаловское, Свердловская область
    _2_5_6_10='25:6:10' # Таежное, Рощинское, Приморский край
    _6_6_2_2='66:2:2' # Еланское, Байкаловское, Свердловская область
    _6_6_2_5='66:2:5' # Слободо-Туринское, Байкаловское, Свердловская область
    _6_6_2_4='66:2:4' # Ницинское, Байкаловское, Свердловская область
    _1_9_1_2='19:1:2' # Анзасское, Абазинское, Республика Хакасия
    _1_9_1_1='19:1:1' # Абазинское, Абазинское, Республика Хакасия
    _6_6_2_6='66:2:6' # Усть-Ницинское, Байкаловское, Свердловская область
    _6_6_2_1='66:2:1' # Байкаловское, Байкаловское, Свердловская область
    _4_3_35_1='43:35:1' # Буйское, Уржумское, Кировская область
    _4_7_8_7='47:8:7' # Мгинское (южная часть), Кировское, Ленинградская область
    _4_3_35_2='43:35:2' # Лебяжское, Уржумское, Кировская область
    _4_7_8_8='47:8:8' # Пелловское, Кировское, Ленинградская область
    _4_3_35_3='43:35:3' # Лебяжское сельское, Уржумское, Кировская область
    _4_7_8_5='47:8:5' # Вороновское, Кировское, Ленинградская область
    _4_3_35_4='43:35:4' # Октябрьское, Уржумское, Кировская область
    _4_7_8_6='47:8:6' # Мгинское (северная часть), Кировское, Ленинградская область
    _4_7_8_3='47:8:3' # Войбокальское (северная часть), Кировское, Ленинградская область
    _4_7_8_4='47:8:4' # Войбокальское (южная часть), Кировское, Ленинградская область
    _4_7_8_1='47:8:1' # Березовское (северная часть), Кировское, Ленинградская область
    _4_7_8_2='47:8:2' # Березовское (южная часть), Кировское, Ленинградская область
    _4_3_35_9='43:35:9' # Шурминское сельское, Уржумское, Кировская область
    _4_3_35_5='43:35:5' # Уржумское, Уржумское, Кировская область
    _4_3_35_6='43:35:6' # Уржумское сельское, Уржумское, Кировская область
    _4_3_35_7='43:35:7' # Цепочкинское, Уржумское, Кировская область
    _4_3_35_8='43:35:8' # Шурминское, Уржумское, Кировская область
    _4_3_22_3='43:22:3' # Латышское, Опаринское, Кировская область
    _7_4_4_5='74:4:5' # Магнитогорское, Верхнеуральское, Челябинская область
    _4_3_22_4='43:22:4' # Маромицкое, Опаринское, Кировская область
    _3_5_24_6='35:24:6' # Чагодощенское, Чагодощенское, Вологодская область
    _7_4_4_6='74:4:6' # Нагайбакское, Верхнеуральское, Челябинская область
    _4_3_22_5='43:22:5' # Мирное, Опаринское, Кировская область
    _3_5_24_5='35:24:5' # Смердомльское, Чагодощенское, Вологодская область
    _7_4_4_3='74:4:3' # Верхнеуральское, Верхнеуральское, Челябинская область
    _4_3_22_6='43:22:6' # Моломское, Опаринское, Кировская область
    _3_5_24_4='35:24:4' # Мегринское, Чагодощенское, Вологодская область
    _7_4_4_4='74:4:4' # Карагайское, Верхнеуральское, Челябинская область
    _3_5_24_3='35:24:3' # Кобожское, Чагодощенское, Вологодская область
    _3_5_24_2='35:24:2' # Белокрестское, Чагодощенское, Вологодская область
    _4_3_22_1='43:22:1' # Альмежское, Опаринское, Кировская область
    _3_5_24_1='35:24:1' # Белобычковское, Чагодощенское, Вологодская область
    _4_3_22_2='43:22:2' # Волмангское, Опаринское, Кировская область
    _4_3_22_7='43:22:7' # Моломское сельское, Опаринское, Кировская область
    _4_3_22_8='43:22:8' # Опаринское, Опаринское, Кировская область
    _4_3_22_9='43:22:9' # Паломицкое, Опаринское, Кировская область
    _5_2_31_2='52:31:2' # Тонкинское, Тонкинское районное, Нижегородская область
    _5_2_31_1='52:31:1' # Пакалевское, Тонкинское районное, Нижегородская область
    _7_4_4_1='74:4:1' # Арсинское, Верхнеуральское, Челябинская область
    _7_4_4_2='74:4:2' # Астафьевское, Верхнеуральское, Челябинская область
    _4_2_5_4='42:5:4' # Медвежское, Крапивинское, Кемеровская область
    _1_8_13_2='18:13:2' # Саркузское, Кизнерское, Удмуртская Республика
    _4_2_5_3='42:5:3' # Крапивинское, Крапивинское, Кемеровская область
    _1_8_13_1='18:13:1' # Казанское, Кизнерское, Удмуртская Республика
    _4_2_5_2='42:5:2' # Ивановское, Крапивинское, Кемеровская область
    _1_8_13_4='18:13:4' # Ягульское, Кизнерское, Удмуртская Республика
    _4_2_5_1='42:5:1' # Аило-Атынаковское, Крапивинское, Кемеровская область
    _1_8_13_3='18:13:3' # Южное, Кизнерское, Удмуртская Республика
    _2_4_5_3='24:5:3' # Гремяченское, Боготольское, Красноярский край
    _2_4_5_4='24:5:4' # Краснореченское, Боготольское, Красноярский край
    _2_4_5_1='24:5:1' # Боготольское, Боготольское, Красноярский край
    _2_4_5_2='24:5:2' # Боготольское сельское, Боготольское, Красноярский край
    _3_5_11_6='35:11:6' # Уйтинское, Кадуйское, Вологодская область
    _3_5_11_7='35:11:7' # Центральное, Кадуйское, Вологодская область
    _3_5_11_4='35:11:4' # Кадуйское, Кадуйское, Вологодская область
    _3_5_11_5='35:11:5' # Северное, Кадуйское, Вологодская область
    _3_5_11_2='35:11:2' # Барановское, Кадуйское, Вологодская область
    _3_5_11_3='35:11:3' # Заяцкое, Кадуйское, Вологодская область
    _3_5_11_1='35:11:1' # Андогское, Кадуйское, Вологодская область
    _6_5_8_2='65:8:2' # Шебунинское, Невельское, Сахалинская область
    _6_5_8_1='65:8:1' # Невельское, Невельское, Сахалинская область
    _4_0_14_5='40:14:5' # Сухиничское, Мещовское, Калужская область
    _4_0_14_2='40:14:2' # Дабужское, Мещовское, Калужская область
    _2_9_8_1='29:8:1' # Каргопольское, Каргопольское, Архангельская область
    _4_0_14_1='40:14:1' # Барятинское, Мещовское, Калужская область
    _2_9_8_2='29:8:2' # Кинемское, Каргопольское, Архангельская область
    _4_0_14_4='40:14:4' # Подкопаевское, Мещовское, Калужская область
    _2_9_8_3='29:8:3' # Кречетовское, Каргопольское, Архангельская область
    _4_0_14_3='40:14:3' # Мещовское, Мещовское, Калужская область
    _2_9_8_4='29:8:4' # Ошевенское, Каргопольское, Архангельская область
    _2_9_8_5='29:8:5' # Печниковское, Каргопольское, Архангельская область
    _2_9_8_6='29:8:6' # Печниковское сельское, Каргопольское, Архангельская область
    _2_9_8_7='29:8:7' # Ряговское, Каргопольское, Архангельская область
    _2_9_8_8='29:8:8' # Тихманьгское, Каргопольское, Архангельская область
    _2_9_8_9='29:8:9' # Ухотское, Каргопольское, Архангельская область
    _3_8_32_8='38:32:8' # Осетровское, Усть-Кутское, Иркутская область
    _3_8_32_9='38:32:9' # Таюрское, Усть-Кутское, Иркутская область
    _3_8_32_6='38:32:6' # Омолоевское, Усть-Кутское, Иркутская область
    _3_8_32_7='38:32:7' # Орлингское, Усть-Кутское, Иркутская область
    _5_6_23_1='56:23:1' # Богдановское, Сорочинское, Оренбургская область
    _5_6_23_2='56:23:2' # Красногвардейское, Сорочинское, Оренбургская область
    _5_6_23_3='56:23:3' # Пронькинское, Сорочинское, Оренбургская область
    _5_6_23_4='56:23:4' # Сорочинское, Сорочинское, Оренбургская область
    _5_6_23_5='56:23:5' # Тоцкое, Сорочинское, Оренбургская область
    _2_18_3='2:18:3' # Инзерское, Инзерское, Республика Башкортостан
    _2_18_4='2:18:4' # Мулдакаевское, Инзерское, Республика Башкортостан
    _3_8_32_4='38:32:4' # Каймоновское, Усть-Кутское, Иркутская область
    _3_8_32_5='38:32:5' # Марковское, Усть-Кутское, Иркутская область
    _3_8_32_2='38:32:2' # Борисовское, Усть-Кутское, Иркутская область
    _3_8_32_3='38:32:3' # Верхненепское, Усть-Кутское, Иркутская область
    _2_18_1='2:18:1' # Ассинское, Инзерское, Республика Башкортостан
    _3_8_32_1='38:32:1' # Бобровское, Усть-Кутское, Иркутская область
    _2_18_2='2:18:2' # Дубинское, Инзерское, Республика Башкортостан
    _5_0_17_4='50:17:4' # Жилевское, Ступинское, Московская область
    _5_0_17_3='50:17:3' # Достоевское, Ступинское, Московская область
    _5_0_17_2='50:17:2' # Городищенское, Ступинское, Московская область
    _5_0_17_1='50:17:1' # Бояркинское, Ступинское, Московская область
    _5_9_6_7='59:6:7' # Шеметевское, Добрянское, Пермский край
    _5_9_6_6='59:6:6' # Полазненское, Добрянское, Пермский край
    _5_9_6_5='59:6:5' # Перемское, Добрянское, Пермский край
    _5_9_6_4='59:6:4' # Милковское, Добрянское, Пермский край
    _5_9_6_3='59:6:3' # Добрянское, Добрянское, Пермский край
    _5_9_6_2='59:6:2' # Голубятское, Добрянское, Пермский край
    _5_0_17_8='50:17:8' # Малинское, Ступинское, Московская область
    _5_9_6_1='59:6:1' # Висимское, Добрянское, Пермский край
    _5_0_17_7='50:17:7' # Маливское, Ступинское, Московская область
    _5_0_17_6='50:17:6' # Коломенское, Ступинское, Московская область
    _5_0_17_5='50:17:5' # Карасевское, Ступинское, Московская область
    _5_0_17_9='50:17:9' # Мещеринское, Ступинское, Московская область
    _5_6_10_2='56:10:2' # Красноярское, Илекское, Оренбургская область
    _5_6_10_3='56:10:3' # Чапаевское, Илекское, Оренбургская область
    _4_7_18_3='47:18:3' # Городокское, Тихвинское, Ленинградская область
    _4_7_18_2='47:18:2' # Березовское, Тихвинское, Ленинградская область
    _4_7_18_1='47:18:1' # Андреевское, Тихвинское, Ленинградская область
    _5_6_10_1='56:10:1' # Илекское, Илекское, Оренбургская область
    _4_7_18_9='47:18:9' # Озерское, Тихвинское, Ленинградская область
    _4_7_18_8='47:18:8' # Новинское, Тихвинское, Ленинградская область
    _4_7_18_7='47:18:7' # Липногорское, Тихвинское, Ленинградская область
    _4_7_18_6='47:18:6' # Корбеническое, Тихвинское, Ленинградская область
    _4_7_18_5='47:18:5' # Капшинское, Тихвинское, Ленинградская область
    _4_7_18_4='47:18:4' # Горское, Тихвинское, Ленинградская область
    _5_16_1='5:16:1' # Хунзахское, Советское, Республика Дагестан
    _5_16_2='5:16:2' # Шамильское, Советское, Республика Дагестан
    _3_5_9_6='35:9:6' # Верховское, Вытегорское, Вологодская область
    _3_5_9_5='35:9:5' # Белоручейское, Вытегорское, Вологодская область
    _3_5_9_8='35:9:8' # Вытегорское, Вытегорское, Вологодская область
    _3_5_9_7='35:9:7' # Водлицкое, Вытегорское, Вологодская область
    _3_5_9_2='35:9:2' # Андоморецкое, Вытегорское, Вологодская область
    _3_5_9_1='35:9:1' # Алмозерское, Вытегорское, Вологодская область
    _3_5_9_4='35:9:4' # Андомское сельское, Вытегорское, Вологодская область
    _3_5_9_3='35:9:3' # Андомское, Вытегорское, Вологодская область
    _3_5_9_9='35:9:9' # Вытегорское сельское, Вытегорское, Вологодская область
    _1_6_12_3='16:12:3' # Татарстанское, Елабужское, Республика Татарстан (Татарстан)
    _1_6_12_2='16:12:2' # Мортовское, Елабужское, Республика Татарстан (Татарстан)
    _1_6_12_1='16:12:1' # Менделеевское, Елабужское, Республика Татарстан (Татарстан)
    _6_1_17_3='61:17:3' # Матвеево-Курганское, Шахтинское, Ростовская область
    _6_1_17_1='61:17:1' # Атаманское, Шахтинское, Ростовская область
    _6_1_17_2='61:17:2' # Красносулинское, Шахтинское, Ростовская область
    _5_9_7_7='59:7:7' # Чермозское, Закамское, Пермский край
    _5_9_7_6='59:7:6' # Нытвенское, Закамское, Пермский край
    _5_9_7_5='59:7:5' # Краснокамское, Закамское, Пермский край
    _5_9_7_4='59:7:4' # Каргинское, Закамское, Пермский край
    _5_9_7_3='59:7:3' # Ильинское, Закамское, Пермский край
    _5_9_7_2='59:7:2' # Григорьевское, Закамское, Пермский край
    _5_9_7_1='59:7:1' # Гайвинское, Закамское, Пермский край
    _5_4_4_1='54:4:1' # Доволенский лесохозяйственный участок № 1, Доволенское, Новосибирская область
    _5_4_4_2='54:4:2' # Доволенский лесохозяйственный участок № 2, Доволенское, Новосибирская область
    _5_4_4_3='54:4:3' # Кочковский лесохозяйственный участок, Доволенское, Новосибирская область
    _5_3_16_2='53:16:2' # Дунаевское, Холмское, Новгородская область
    _5_3_16_1='53:16:1' # Аполецкое, Холмское, Новгородская область
    _5_3_16_4='53:16:4' # Находское, Холмское, Новгородская область
    _5_3_16_3='53:16:3' # Морховское, Холмское, Новгородская область
    _5_3_16_6='53:16:6' # Тухомичское, Холмское, Новгородская область
    _5_3_16_5='53:16:5' # Новодворское, Холмское, Новгородская область
    _5_3_16_8='53:16:8' # Чекуновское, Холмское, Новгородская область
    _5_3_16_7='53:16:7' # Холмское, Холмское, Новгородская область
    _3_5_20_13='35:20:13' # Толшменское, Тотемское, Вологодская область
    _3_5_20_14='35:20:14' # Тотемское, Тотемское, Вологодская область
    _3_5_20_11='35:20:11' # Мосеевское, Тотемское, Вологодская область
    _3_5_20_12='35:20:12' # Погореловское, Тотемское, Вологодская область
    _3_5_20_10='35:20:10' # Михайловское, Тотемское, Вологодская область
    _3_5_20_15='35:20:15' # Тотемское сельское, Тотемское, Вологодская область
    _3_5_20_16='35:20:16' # Усть-Печенгское, Тотемское, Вологодская область
    _8_6_2_3='86:2:3' # Полноватское, Белоярское, Ханты-Мансийский автономный округ - Югра
    _8_6_2_2='86:2:2' # Лыхминское, Белоярское, Ханты-Мансийский автономный округ - Югра
    _8_6_2_1='86:2:1' # Казымское, Белоярское, Ханты-Мансийский автономный округ - Югра
    _4_4_19_1='44:19:1' # 1-е Судиславское, Судиславское, Костромская область
    _4_4_19_2='44:19:2' # 1-е Сусанинское, Судиславское, Костромская область
    _4_4_19_3='44:19:3' # 2-е Судиславское, Судиславское, Костромская область
    _4_4_19_4='44:19:4' # 2-е Сусанинское, Судиславское, Костромская область
    _4_4_19_5='44:19:5' # Воронское, Судиславское, Костромская область
    _3_5_19_10='35:19:10' # Шебеньгское, Тарногское, Вологодская область
    _4_4_19_6='44:19:6' # Калинкинское, Судиславское, Костромская область
    _4_4_19_7='44:19:7' # Сухоруковское, Судиславское, Костромская область
    _4_8_1_3='48:1:3' # Фащевское, Грязинское, Липецкая область
    _4_8_1_4='48:1:4' # Яманское, Грязинское, Липецкая область
    _4_8_1_1='48:1:1' # Балашовское, Грязинское, Липецкая область
    _4_8_1_2='48:1:2' # Плехановское, Грязинское, Липецкая область
    _2_2_10_3='22:10:3' # Черемушкинское, Залесовское, Алтайский край
    _2_2_10_4='22:10:4' # Шатуновское, Залесовское, Алтайский край
    _2_2_10_1='22:10:1' # Залесовское, Залесовское, Алтайский край
    _2_2_10_2='22:10:2' # Петеневское, Залесовское, Алтайский край
    _3_6_3_1='36:3:1' # Богучарское, Богучарское, Воронежская область
    _3_6_3_3='36:3:3' # Радченское, Богучарское, Воронежская область
    _3_6_3_2='36:3:2' # Подколодновское, Богучарское, Воронежская область
    _3_6_18_3='36:18:3' # Савальское, Савальское, Воронежская область
    _3_6_18_2='36:18:2' # Полянское, Савальское, Воронежская область
    _3_6_18_1='36:18:1' # Костино-Отдельное, Савальское, Воронежская область
    _3_2_12_1='32:12:1' # Гаваньское, Навлинское, Брянская область
    _3_2_12_2='32:12:2' # Клюковенское, Навлинское, Брянская область
    _3_2_12_3='32:12:3' # Синезерское, Навлинское, Брянская область
    _3_2_12_4='32:12:4' # Щегловское, Навлинское, Брянская область
    _6_6_16_7='66:16:7' # Первомайское, Нижне-Сергинское, Свердловская область
    _6_6_16_5='66:16:5' # Кленовское, Нижне-Сергинское, Свердловская область
    _6_6_16_6='66:16:6' # Михайловское, Нижне-Сергинское, Свердловская область
    _6_6_16_3='66:16:3' # Верхнесергинское, Нижне-Сергинское, Свердловская область
    _6_6_16_4='66:16:4' # Заречное, Нижне-Сергинское, Свердловская область
    _2_9_10_4='29:10:4' # Коношское, Коношское, Архангельская область
    _6_6_16_1='66:16:1' # Бардымское, Нижне-Сергинское, Свердловская область
    _2_9_10_5='29:10:5' # Подюжское, Коношское, Архангельская область
    _6_6_16_2='66:16:2' # Бисертское, Нижне-Сергинское, Свердловская область
    _2_9_10_6='29:10:6' # Ротковецкое, Коношское, Архангельская область
    _2_9_10_7='29:10:7' # Тавреньгское, Коношское, Архангельская область
    _2_9_10_1='29:10:1' # Вандышское, Коношское, Архангельская область
    _5_9_1='5:9:1' # Каякентское, Каякентское, Республика Дагестан
    _2_9_10_2='29:10:2' # Ерцевское, Коношское, Архангельская область
    _2_9_10_3='29:10:3' # Климовское, Коношское, Архангельская область
    _2_9_10_8='29:10:8' # Тавреньгское сельское, Коношское, Архангельская область
    _2_9_10_9='29:10:9' # Фоминское, Коношское, Архангельская область
    _6_0_5_2='60:5:2' # Красногородское, Опочецкое, Псковская область
    _6_0_5_1='60:5:1' # Гавровское, Опочецкое, Псковская область
    _6_0_5_4='60:5:4' # Пригородное, Опочецкое, Псковская область
    _6_0_5_3='60:5:3' # Опочецкое, Опочецкое, Псковская область
    _1_6_25_5='16:25:5' # Лякинское, Нижнекамское, Республика Татарстан (Татарстан)
    _1_6_25_4='16:25:4' # Кзыл-Юлское, Нижнекамское, Республика Татарстан (Татарстан)
    _1_6_25_3='16:25:3' # Ворошиловское, Нижнекамское, Республика Татарстан (Татарстан)
    _1_6_25_2='16:25:2' # Биклянское, Нижнекамское, Республика Татарстан (Татарстан)
    _1_6_25_1='16:25:1' # Багряжское, Нижнекамское, Республика Татарстан (Татарстан)
    _1_3_4_3='13:4:3' # Ширингушское, Вышинское территориальное, Республика Мордовия
    _1_3_4_2='13:4:2' # Известковское, Вышинское территориальное, Республика Мордовия
    _1_3_4_1='13:4:1' # Вышинское, Вышинское территориальное, Республика Мордовия
    _6_0_5_6='60:5:6' # Пыталовское, Опочецкое, Псковская область
    _6_0_5_5='60:5:5' # Пушкиногорское, Опочецкое, Псковская область
    _2_2_23_1='22:23:1' # Борисовское, Ракитовское, Алтайский край
    _2_2_23_2='22:23:2' # Озерно-Кузнецовское, Ракитовское, Алтайский край
    _7_4_15_3='74:15:3' # Октябрьское, Октябрьское, Челябинская область
    _7_4_15_2='74:15:2' # Кочердыкское, Октябрьское, Челябинская область
    _7_4_15_1='74:15:1' # Каратабызское, Октябрьское, Челябинская область
    _2_2_23_5='22:23:5' # Шелковниковское, Ракитовское, Алтайский край
    _2_2_23_6='22:23:6' # Шубинское, Ракитовское, Алтайский край
    _2_2_23_3='22:23:3' # Ракитовское, Ракитовское, Алтайский край
    _2_2_23_4='22:23:4' # Чекуновское, Ракитовское, Алтайский край
    _6_6_29_6='66:29:6' # Юшалинское, Тугулымское, Свердловская область
    _6_6_29_5='66:29:5' # Южное, Тугулымское, Свердловская область
    _6_6_29_4='66:29:4' # Тугулымское, Тугулымское, Свердловская область
    _6_6_29_3='66:29:3' # Северное, Тугулымское, Свердловская область
    _6_6_29_2='66:29:2' # Луговское, Тугулымское, Свердловская область
    _6_6_29_1='66:29:1' # Ертарское, Тугулымское, Свердловская область
    _4_7_7_8='47:7:8' # Лугское, Киришское, Ленинградская область
    _4_7_7_9='47:7:9' # Осничевское, Киришское, Ленинградская область
    _4_7_7_6='47:7:6' # Киришское, Киришское, Ленинградская область
    _4_7_7_7='47:7:7' # Кукуйское, Киришское, Ленинградская область
    _4_7_7_4='47:7:4' # Городищенское, Киришское, Ленинградская область
    _4_7_7_5='47:7:5' # Ирсовское, Киришское, Ленинградская область
    _4_7_7_2='47:7:2' # Будогощское, Киришское, Ленинградская область
    _4_7_7_3='47:7:3' # Восточное, Киришское, Ленинградская область
    _4_7_7_1='47:7:1' # Андреевское, Киришское, Ленинградская область
    _4_7_9_8='47:9:8' # Пирозерское, Лодейнопольское, Ленинградская область
    _4_7_9_9='47:9:9' # Ребовское, Лодейнопольское, Ленинградская область
    _3_5_10_9='35:10:9' # Слободское, Грязовецкое, Вологодская область
    _3_5_10_7='35:10:7' # Монзенское, Грязовецкое, Вологодская область
    _3_5_10_8='35:10:8' # Сеньговское, Грязовецкое, Вологодская область
    _3_5_10_5='35:10:5' # Лежское, Грязовецкое, Вологодская область
    _3_5_10_6='35:10:6' # Минькинское, Грязовецкое, Вологодская область
    _3_5_10_3='35:10:3' # Грязовецкое сельское, Грязовецкое, Вологодская область
    _3_5_10_4='35:10:4' # Жерноковское, Грязовецкое, Вологодская область
    _3_5_10_1='35:10:1' # Восьинское, Грязовецкое, Вологодская область
    _3_5_10_2='35:10:2' # Грязовецкое, Грязовецкое, Вологодская область
    _4_3_23_2='43:23:2' # Быстряговское, Оричевское, Кировская область
    _4_3_23_3='43:23:3' # Верхошижемское, Оричевское, Кировская область
    _4_7_18_21='47:18:21' # Явосемское, Тихвинское, Ленинградская область
    _4_3_23_4='43:23:4' # Зоновское, Оричевское, Кировская область
    _4_7_18_20='47:18:20' # Шугозерское, Тихвинское, Ленинградская область
    _4_3_23_5='43:23:5' # Илганское, Оричевское, Кировская область
    _4_3_23_1='43:23:1' # Быстрицкое, Оричевское, Кировская область
    _6_6_1_4='66:1:4' # Зенковское, Алапаевское, Свердловская область
    _6_6_1_3='66:1:3' # Западное, Алапаевское, Свердловская область
    _6_6_1_6='66:1:6' # Коптеловское, Алапаевское, Свердловская область
    _6_6_1_5='66:1:5' # Кировское, Алапаевское, Свердловская область
    _4_3_23_6='43:23:6' # Коршикское, Оричевское, Кировская область
    _6_6_1_8='66:1:8' # Нейво-Шайтанское, Алапаевское, Свердловская область
    _4_3_23_7='43:23:7' # Оричевское, Оричевское, Кировская область
    _6_6_1_7='66:1:7' # Махневское, Алапаевское, Свердловская область
    _4_3_23_8='43:23:8' # Пищальское, Оричевское, Кировская область
    _4_3_23_9='43:23:9' # Среднеивкинское, Оричевское, Кировская область
    _6_6_1_9='66:1:9' # Рагозинское, Алапаевское, Свердловская область
    _6_6_1_2='66:1:2' # Асбестовское, Алапаевское, Свердловская область
    _6_6_1_1='66:1:1' # Алапаевское, Алапаевское, Свердловская область
    _4_7_18_16='47:18:16' # Хундольское, Тихвинское, Ленинградская область
    _4_7_18_15='47:18:15' # Сясьское, Тихвинское, Ленинградская область
    _4_7_18_18='47:18:18' # Черенцовское, Тихвинское, Ленинградская область
    _4_7_18_17='47:18:17' # Цвылевское, Тихвинское, Ленинградская область
    _4_7_18_19='47:18:19' # Шомушское, Тихвинское, Ленинградская область
    _4_7_9_6='47:9:6' # Люговское, Лодейнопольское, Ленинградская область
    _6_9_4_12='69:4:12' # Чамеровское, Краснохолмское, Тверская область
    _4_7_9_7='47:9:7' # Мандрогское, Лодейнопольское, Ленинградская область
    _4_7_18_10='47:18:10' # Паше-Капецкое, Тихвинское, Ленинградская область
    _4_7_9_4='47:9:4' # Кондушское, Лодейнопольское, Ленинградская область
    _6_9_4_10='69:4:10' # Соболинское, Краснохолмское, Тверская область
    _4_7_9_5='47:9:5' # Лодейнопольское, Лодейнопольское, Ленинградская область
    _6_9_4_11='69:4:11' # Согласьевское, Краснохолмское, Тверская область
    _4_7_18_12='47:18:12' # Пашское, Тихвинское, Ленинградская область
    _4_7_9_2='47:9:2' # Алеховщинское сельское, Лодейнопольское, Ленинградская область
    _4_7_18_11='47:18:11' # Пашозерское, Тихвинское, Ленинградская область
    _4_7_9_3='47:9:3' # Доможировское, Лодейнопольское, Ленинградская область
    _4_7_18_14='47:18:14' # Пяльинское, Тихвинское, Ленинградская область
    _4_7_18_13='47:18:13' # Пригородное, Тихвинское, Ленинградская область
    _4_7_9_1='47:9:1' # Алеховщинское, Лодейнопольское, Ленинградская область
    _4_3_10_3='43:10:3' # Рыбно-Ватажское, Кильмезское, Кировская область
    _4_3_10_2='43:10:2' # Микваровское, Кильмезское, Кировская область
    _4_3_10_1='43:10:1' # Ломиковское, Кильмезское, Кировская область
    _4_3_10_7='43:10:7' # Южное сельское, Кильмезское, Кировская область
    _4_3_10_6='43:10:6' # Троицкое, Кильмезское, Кировская область
    _4_3_10_5='43:10:5' # Селинское, Кильмезское, Кировская область
    _4_3_10_4='43:10:4' # Северное сельское, Кильмезское, Кировская область
    _7_4_5_4='74:5:4' # Семибратское, Златоустовское, Челябинская область
    _3_5_23_7='35:23:7' # Шапшинское сельское, Харовское, Вологодская область
    _3_5_23_6='35:23:6' # Шапшинское, Харовское, Вологодская область
    _7_4_5_2='74:5:2' # Златоустовское, Златоустовское, Челябинская область
    _3_5_23_5='35:23:5' # Харовское сельское, Харовское, Вологодская область
    _7_4_5_3='74:5:3' # Кувашинское, Златоустовское, Челябинская область
    _3_5_23_4='35:23:4' # Харовское, Харовское, Вологодская область
    _3_5_23_3='35:23:3' # Семигородное, Харовское, Вологодская область
    _3_5_23_2='35:23:2' # Катромское, Харовское, Вологодская область
    _3_5_23_1='35:23:1' # Ильинское, Харовское, Вологодская область
    _7_4_5_1='74:5:1' # Веселовское, Златоустовское, Челябинская область
    _2_4_6_2='24:6:2' # Карабульское, Богучанское, Красноярский край
    _2_4_6_1='24:6:1' # Богучанское, Богучанское, Красноярский край
    _2_9_9_4='29:9:4' # Карпогорское сельское, Карпогорское, Архангельская область
    _2_9_9_5='29:9:5' # Кушкопальское, Карпогорское, Архангельская область
    _2_9_9_6='29:9:6' # Пачихинское, Карпогорское, Архангельская область
    _2_9_9_7='29:9:7' # Сийское, Карпогорское, Архангельская область
    _6_7_16_10='67:16:10' # Савеевское сельское, Рославльское, Смоленская область
    _5_6_24_1='56:24:1' # Кинделинское, Ташлинское, Оренбургская область
    _5_6_24_2='56:24:2' # Ташлинское, Ташлинское, Оренбургская область
    _2_19_4='2:19:4' # Мало-Икское, Кананикольское, Республика Башкортостан
    _2_19_2='2:19:2' # Канское, Кананикольское, Республика Башкортостан
    _2_19_3='2:19:3' # Куркатовское, Кананикольское, Республика Башкортостан
    _5_15_2='5:15:2' # Сергокалинское, Сергокалинское, Республика Дагестан
    _5_15_1='5:15:1' # Левашинское, Сергокалинское, Республика Дагестан
    _2_19_1='2:19:1' # Ивано-Кувалатское, Кананикольское, Республика Башкортостан
    _8_6_4_1='86:4:1' # Болчаровское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _8_6_4_5='86:4:5' # Леушинское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _5_2_30_5='52:30:5' # Сосновское, Сосновское районное, Нижегородская область
    _8_6_4_4='86:4:4' # Куминское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _5_2_30_4='52:30:4' # Селитьбенское, Сосновское районное, Нижегородская область
    _8_6_4_3='86:4:3' # Кондинское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _8_6_4_2='86:4:2' # Карымское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _2_4_60_2='24:60:2' # Шарыповское, Шарыповское, Красноярский край
    _5_2_30_1='52:30:1' # Барановское, Сосновское районное, Нижегородская область
    _5_2_30_3='52:30:3' # Рожковское, Сосновское районное, Нижегородская область
    _2_4_60_1='24:60:1' # Парнинское, Шарыповское, Красноярский край
    _8_6_4_6='86:4:6' # Морткинское, Кондинское, Ханты-Мансийский автономный округ - Югра
    _5_2_30_2='52:30:2' # Венецкое, Сосновское районное, Нижегородская область
    _6_5_7_1='65:7:1' # Макаровское, Макаровское, Сахалинская область
    _6_5_7_2='65:7:2' # Пореченское, Макаровское, Сахалинская область
    _4_2_6_2='42:6:2' # Кузедеевское, Кузедеевское, Кемеровская область
    _4_2_6_1='42:6:1' # Калтанское, Кузедеевское, Кемеровская область
    _4_0_15_5='40:15:5' # Пригородное, Спас-Деменское, Калужская область
    _4_0_15_4='40:15:4' # Павлиновское, Спас-Деменское, Калужская область
    _4_0_15_6='40:15:6' # Спас-Деменское, Спас-Деменское, Калужская область
    _4_0_15_1='40:15:1' # Барятинское, Спас-Деменское, Калужская область
    _6_6_17_10='66:17:10' # Усть-Уткинское, Нижне-Тагильское, Свердловская область
    _4_0_15_3='40:15:3' # Ново-Александровское, Спас-Деменское, Калужская область
    _4_0_15_2='40:15:2' # Милятинское, Спас-Деменское, Калужская область
    _5_6_11_1='56:11:1' # Болотовское, Кваркенское, Оренбургская область
    _5_6_11_2='56:11:2' # Зеленодольское, Кваркенское, Оренбургская область
    _4_7_17_4='47:17:4' # Лососкинское, Сланцевское, Ленинградская область
    _4_7_17_3='47:17:3' # Загривское, Сланцевское, Ленинградская область
    _4_7_17_2='47:17:2' # Доложское, Сланцевское, Ленинградская область
    _4_7_17_1='47:17:1' # Выскатское, Сланцевское, Ленинградская область
    _4_7_17_9='47:17:9' # Черновское, Сланцевское, Ленинградская область
    _4_7_17_8='47:17:8' # Старопольское, Сланцевское, Ленинградская область
    _4_7_17_7='47:17:7' # Сланцевское, Сланцевское, Ленинградская область
    _4_7_17_6='47:17:6' # Попковогорское, Сланцевское, Ленинградская область
    _4_7_17_5='47:17:5' # Нарвское, Сланцевское, Ленинградская область
    _5_0_18_3='50:18:3' # Талдомское, Талдомское, Московская область
    _5_0_18_2='50:18:2' # Салтыково-Щедринское, Талдомское, Московская область
    _5_0_18_1='50:18:1' # Комсомольское, Талдомское, Московская область
    _4_3_36_1='43:36:1' # Порезское, Фаленское, Кировская область
    _4_3_36_2='43:36:2' # Сардыкское, Фаленское, Кировская область
    _4_3_36_3='43:36:3' # Талицкое, Фаленское, Кировская область
    _4_3_36_4='43:36:4' # Унинское, Фаленское, Кировская область
    _4_3_36_5='43:36:5' # Фаленское, Фаленское, Кировская область
    _2_9_9_1='29:9:1' # Веркольское, Карпогорское, Архангельская область
    _2_9_9_2='29:9:2' # Кавринское, Карпогорское, Архангельская область
    _2_9_9_3='29:9:3' # Карпогорское, Карпогорское, Архангельская область
    _5_9_5_6='59:5:6' # Теплогорское, Горнозаводское, Пермский край
    _5_9_5_5='59:5:5' # Сарановское, Горнозаводское, Пермский край
    _5_9_5_4='59:5:4' # Кусье-Александровское, Горнозаводское, Пермский край
    _5_9_5_3='59:5:3' # Вижайское, Горнозаводское, Пермский край
    _5_9_5_2='59:5:2' # Верхне-Усьвинское, Горнозаводское, Пермский край
    _5_0_18_6='50:18:6' # Хотченское, Талдомское, Московская область
    _5_9_5_1='59:5:1' # Бисерское, Горнозаводское, Пермский край
    _5_0_18_5='50:18:5' # Танинское, Талдомское, Московская область
    _5_0_18_4='50:18:4' # Талдомское сельское, Талдомское, Московская область
    _2_9_17_11='29:17:11' # Чекуевское, Онежское, Архангельская область
    _2_9_17_10='29:17:10' # Унежемское, Онежское, Архангельская область
    _6_1_16_2='61:16:2' # Чертковское, Чертковское, Ростовская область
    _6_1_16_1='61:16:1' # Алексеево-Лозовское, Чертковское, Ростовская область
    _1_2_9_2='12:9:2' # Ямбаторское, Мари-Турекское, Республика Марий Эл
    _5_4_3_1='54:3:1' # Венгеровский лесохозяйственный участок № 1, Венгеровское, Новосибирская область
    _1_2_9_1='12:9:1' # Сендинское, Мари-Турекское, Республика Марий Эл
    _5_4_3_2='54:3:2' # Венгеровский лесохозяйственный участок № 2, Венгеровское, Новосибирская область
    _5_4_3_3='54:3:3' # Тартасский лесохозяйственный участок, Венгеровское, Новосибирская область
    _5_4_3_4='54:3:4' # Туруновский лесохозяйственный участок, Венгеровское, Новосибирская область
    _5_3_15_3='53:15:3' # Жилоборское, Хвойнинское, Новгородская область
    _5_3_15_2='53:15:2' # Вязовское, Хвойнинское, Новгородская область
    _5_3_15_5='53:15:5' # Песьское, Хвойнинское, Новгородская область
    _5_3_15_4='53:15:4' # Левочское, Хвойнинское, Новгородская область
    _5_3_15_7='53:15:7' # Раменское, Хвойнинское, Новгородская область
    _5_3_15_6='53:15:6' # Ракитинское, Хвойнинское, Новгородская область
    _5_3_15_9='53:15:9' # Хвойнинское, Хвойнинское, Новгородская область
    _5_3_15_8='53:15:8' # Спасское, Хвойнинское, Новгородская область
    _1_6_24_6='16:24:6' # Юртовское, Мензелинское, Республика Татарстан (Татарстан)
    _1_6_24_5='16:24:5' # Усинское, Мензелинское, Республика Татарстан (Татарстан)
    _1_6_24_4='16:24:4' # Муслюмовское, Мензелинское, Республика Татарстан (Татарстан)
    _5_3_15_1='53:15:1' # Анциферовское, Хвойнинское, Новгородская область
    _1_6_24_3='16:24:3' # Мензелинское, Мензелинское, Республика Татарстан (Татарстан)
    _1_6_24_2='16:24:2' # Калининское, Мензелинское, Республика Татарстан (Татарстан)
    _1_6_24_1='16:24:1' # Актанышское, Мензелинское, Республика Татарстан (Татарстан)
    _5_2_10_10='52:10:10' # Шурговашское, Воскресенское районное, Нижегородская область
    _8_6_3_2='86:3:2' # Саранпаульское, Берёзовское, Ханты-Мансийский автономный округ - Югра
    _8_6_3_1='86:3:1' # Берёзовское, Берёзовское, Ханты-Мансийский автономный округ - Югра
    _1_1_1='1:1:1' # Гузерипльское, Гузерипльское, Республика Адыгея (Адыгея)
    _8_6_3_3='86:3:3' # Сосьвинское, Берёзовское, Ханты-Мансийский автономный округ - Югра
    _1_1_7='1:1:7' # Хамышинское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_8='69:11:8' # Кемецкое, Фировское, Тверская область
    _1_1_6='1:1:6' # Усть-Сахрайское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_7='69:11:7' # Кафтинское, Фировское, Тверская область
    _6_9_11_9='69:11:9' # Красномайское, Фировское, Тверская область
    _1_1_3='1:1:3' # Даховское сельское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_4='69:11:4' # Есеновическое, Фировское, Тверская область
    _1_1_2='1:1:2' # Даховское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_3='69:11:3' # Дятловское, Фировское, Тверская область
    _1_1_5='1:1:5' # Ново-Прохладненское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_6='69:11:6' # Западное, Фировское, Тверская область
    _1_1_4='1:1:4' # Каменномостское, Гузерипльское, Республика Адыгея (Адыгея)
    _6_9_11_5='69:11:5' # Заборовское, Фировское, Тверская область
    _6_9_11_2='69:11:2' # Бологовское, Фировское, Тверская область
    _6_9_11_1='69:11:1' # Баталинское, Фировское, Тверская область
    _3_8_31_3='38:31:3' # Усольское, Усольское, Иркутская область
    _3_8_31_1='38:31:1' # Ангарское, Усольское, Иркутская область
    _3_8_31_2='38:31:2' # Тойсуковское, Усольское, Иркутская область
    _3_6_4_4='36:4:4' # Нижне-Битюгское, Бутурлиновское, Воронежская область
    _3_6_4_3='36:4:3' # Морозовское, Бутурлиновское, Воронежская область
    _3_6_4_2='36:4:2' # Корабельное, Бутурлиновское, Воронежская область
    _3_6_4_1='36:4:1' # Козловское, Бутурлиновское, Воронежская область
    _1_6_11_3='16:11:3' # Тюбяк-Чирковское, Буинское, Республика Татарстан (Татарстан)
    _1_6_11_2='16:11:2' # Дрожжановское, Буинское, Республика Татарстан (Татарстан)
    _1_6_11_1='16:11:1' # Буинское, Буинское, Республика Татарстан (Татарстан)
    _7_4_6_3='74:6:3' # Великопетровское, Карталинское, Челябинская область
    _5_3_9_7='53:9:7' # Новгородское, Новгородское, Новгородская область
    _7_4_6_4='74:6:4' # Джабыкское, Карталинское, Челябинская область
    _5_3_9_8='53:9:8' # Пригородное, Новгородское, Новгородская область
    _7_4_6_1='74:6:1' # Анненское, Карталинское, Челябинская область
    _5_3_9_5='53:9:5' # Мстинское, Новгородское, Новгородская область
    _7_4_6_2='74:6:2' # Варненское, Карталинское, Челябинская область
    _5_3_9_6='53:9:6' # Мясноборское, Новгородское, Новгородская область
    _7_4_6_5='74:6:5' # Неплюевское, Карталинское, Челябинская область
    _5_3_9_9='53:9:9' # Пролетарское, Новгородское, Новгородская область
    _7_4_6_6='74:6:6' # Парижское, Карталинское, Челябинская область
    _5_3_9_3='53:9:3' # Ермолинское, Новгородское, Новгородская область
    _5_3_9_4='53:9:4' # Медведское, Новгородское, Новгородская область
    _5_3_9_1='53:9:1' # Вишерское, Новгородское, Новгородская область
    _5_3_9_2='53:9:2' # Волховское, Новгородское, Новгородская область
    _4_8_2_2='48:2:2' # Воскресенское, Данковское, Липецкая область
    _4_7_2_11='47:2:11' # Хотнежское, Волосовское, Ленинградская область
    _4_8_2_3='48:2:3' # Лебедянское, Данковское, Липецкая область
    _4_7_2_10='47:2:10' # Редкинское, Волосовское, Ленинградская область
    _4_8_2_4='48:2:4' # Хрущевское, Данковское, Липецкая область
    _4_8_2_1='48:2:1' # Бигильдинское, Данковское, Липецкая область
    _6_6_15_8='66:15:8' # Осиновское, Невьянское, Свердловская область
    _6_6_15_9='66:15:9' # Таватуйское, Невьянское, Свердловская область
    _6_6_15_6='66:15:6' # Невьянское, Невьянское, Свердловская область
    _6_6_15_7='66:15:7' # Новоуральское, Невьянское, Свердловская область
    _6_6_15_4='66:15:4' # Кировградское, Невьянское, Свердловская область
    _6_6_15_5='66:15:5' # Левихинское, Невьянское, Свердловская область
    _2_9_11_3='29:11:3' # Котласское сельское, Котласское, Архангельская область
    _6_6_15_2='66:15:2' # Верх-Нейвинское, Невьянское, Свердловская область
    _2_9_11_4='29:11:4' # Северное, Котласское, Архангельская область
    _6_6_15_3='66:15:3' # Заозерное, Невьянское, Свердловская область
    _2_9_11_5='29:11:5' # Удимское, Котласское, Архангельская область
    _2_9_11_6='29:11:6' # Черемушское, Котласское, Архангельская область
    _6_6_15_1='66:15:1' # Аятское, Невьянское, Свердловская область
    _2_9_11_1='29:11:1' # Вычегодское, Котласское, Архангельская область
    _2_9_11_2='29:11:2' # Котласское, Котласское, Архангельская область
    _7_0_10_1='70:10:1' # Елтыревское, Колпашевское, Томская область
    _2_9_11_7='29:11:7' # Шипицинское, Котласское, Архангельская область
    _2_9_11_8='29:11:8' # Шипицинское сельское, Котласское, Архангельская область
    _7_0_10_3='70:10:3' # Шудельское, Колпашевское, Томская область
    _7_0_10_2='70:10:2' # Колпашевское, Колпашевское, Томская область
    _6_0_4_3='60:4:3' # Невельское, Невельское, Псковская область
    _6_0_4_2='60:4:2' # Калошинское, Невельское, Псковская область
    _6_0_4_5='60:4:5' # Туричинское, Невельское, Псковская область
    _6_0_4_4='60:4:4' # Пустошкинское, Невельское, Псковская область
    _6_0_4_1='60:4:1' # Забельское, Невельское, Псковская область
    _3_6_19_3='36:19:3' # Подгоренское, Семилукское, Воронежская область
    _6_0_4_7='60:4:7' # Усть-Долысское, Невельское, Псковская область
    _6_0_4_6='60:4:6' # Усвятское, Невельское, Псковская область
    _3_6_19_2='36:19:2' # Нижнедевицкое, Семилукское, Воронежская область
    _3_6_19_1='36:19:1' # Землянское, Семилукское, Воронежская область
    _3_2_13_1='32:13:1' # Милечское, Почепское, Брянская область
    _3_2_13_2='32:13:2' # Октябрьское, Почепское, Брянская область
    _3_2_13_3='32:13:3' # Семецкое, Почепское, Брянская область
    _6_6_28_6='66:28:6' # Троицкое, Талицкое, Свердловская область
    _6_6_28_5='66:28:5' # Луговское, Талицкое, Свердловская область
    _6_6_28_4='66:28:4' # Еланское, Талицкое, Свердловская область
    _6_6_28_3='66:28:3' # Вновь-Юрмытское, Талицкое, Свердловская область
    _6_6_28_2='66:28:2' # Буткинское, Талицкое, Свердловская область
    _6_6_28_1='66:28:1' # Боровское, Талицкое, Свердловская область
    _1_3_3_4='13:3:4' # Парцинское, Виндрейское территориальное, Республика Мордовия
    _1_3_3_3='13:3:3' # Виндрейское, Виндрейское территориальное, Республика Мордовия
    _1_3_3_2='13:3:2' # Быстрищенское, Виндрейское территориальное, Республика Мордовия
    _1_3_3_1='13:3:1' # Атюрьевское, Виндрейское территориальное, Республика Мордовия
    _4_7_8_9='47:8:9' # Шумское, Кировское, Ленинградская область
    _2_2_22_2='22:22:2' # Загайновское, Петровское, Алтайский край
    _7_4_16_3='74:16:3' # Западно-Санарское, Пластовское, Челябинская область
    _2_2_22_3='22:22:3' # Контошинское, Петровское, Алтайский край
    _7_4_16_2='74:16:2' # Восточно-Санарское, Пластовское, Челябинская область
    _7_4_16_1='74:16:1' # Березиновское, Пластовское, Челябинская область
    _2_2_22_1='22:22:1' # Заводское, Петровское, Алтайский край
    _2_2_22_6='22:22:6' # Озеро-Петровское, Петровское, Алтайский край
    _2_2_22_7='22:22:7' # Петровское, Петровское, Алтайский край
    _7_4_16_6='74:16:6' # Чесменское, Пластовское, Челябинская область
    _2_2_22_4='22:22:4' # Косихинское, Петровское, Алтайский край
    _7_4_16_5='74:16:5' # Пластовское, Пластовское, Челябинская область
    _2_2_22_5='22:22:5' # Налобихинское, Петровское, Алтайский край
    _7_4_16_4='74:16:4' # Кочкарское, Пластовское, Челябинская область
    _2_2_22_8='22:22:8' # Троицкое, Петровское, Алтайский край
    _2_7_1_2='27:1:2' # Верхне-Подхоренковское, Аванское, Хабаровский край
    _2_7_1_3='27:1:3' # Вяземское, Аванское, Хабаровский край
    _2_7_1_4='27:1:4' # Капитоновское, Аванское, Хабаровский край
    _2_7_1_5='27:1:5' # Подхоренковское, Аванское, Хабаровский край
    _2_7_1_1='27:1:1' # Аванское, Аванское, Хабаровский край
    _5_6_6_1='56:6:1' # Бугурусланское, Бугурусланское, Оренбургская область
    _5_6_6_2='56:6:2' # Коровинское, Бугурусланское, Оренбургская область
    _5_6_6_3='56:6:3' # Пилюгинское, Бугурусланское, Оренбургская область
    _5_6_6_4='56:6:4' # Советское, Бугурусланское, Оренбургская область
    _1_0_13_3='10:13:3' # Виданское, Пряжинское, Республика Карелия
    _1_0_13_4='10:13:4' # Кашканское, Пряжинское, Республика Карелия
    _1_0_13_1='10:13:1' # Важинское, Пряжинское, Республика Карелия
    _1_0_13_2='10:13:2' # Ведлозерское, Пряжинское, Республика Карелия
    _1_0_13_7='10:13:7' # Крошнозерское, Пряжинское, Республика Карелия
    _1_0_13_8='10:13:8' # Нялмозерское, Пряжинское, Республика Карелия
    _1_0_13_5='10:13:5' # Кинелахтинское, Пряжинское, Республика Карелия
    _1_0_13_6='10:13:6' # Койвусельгское, Пряжинское, Республика Карелия
    _1_0_13_9='10:13:9' # Паннильское, Пряжинское, Республика Карелия
    _6_6_19_4='66:19:4' # Режевское, Режевское, Свердловская область
    _6_6_19_2='66:19:2' # Липовское, Режевское, Свердловская область
    _6_6_19_3='66:19:3' # Озерское, Режевское, Свердловская область
    _6_6_19_1='66:19:1' # Глинское, Режевское, Свердловская область
    _5_2_11_1='52:11:1' # Вильское, Выксунское районное, Нижегородская область
    _5_2_11_2='52:11:2' # Димарское, Выксунское районное, Нижегородская область
    _5_2_11_3='52:11:3' # Пристанское, Выксунское районное, Нижегородская область
    _5_2_11_4='52:11:4' # Ризадеевское, Выксунское районное, Нижегородская область
    _5_2_11_5='52:11:5' # Рожновское, Выксунское районное, Нижегородская область
    _5_2_11_6='52:11:6' # Семиловское, Выксунское районное, Нижегородская область
    _7_1_8_1='71:8:1' # Крапивенское, Плавское, Тульская область
    _2_3_10_1='23:10:1' # Варениковское, Крымское, Краснодарский край
    _3_2_9_2='32:9:2' # Косновское, Клетнянское, Брянская область
    _3_2_9_3='32:9:3' # Октябрьское, Клетнянское, Брянская область
    _2_3_10_3='23:10:3' # Нижне-Баканское, Крымское, Краснодарский край
    _3_2_9_1='32:9:1' # Калининское, Клетнянское, Брянская область
    _2_3_10_2='23:10:2' # Варнавинское, Крымское, Краснодарский край
    _7_1_8_2='71:8:2' # Крюковское, Плавское, Тульская область
    _7_1_8_3='71:8:3' # Тепло-Огаревское, Плавское, Тульская область
    _3_2_9_4='32:9:4' # Пригородное, Клетнянское, Брянская область
    _7_1_8_4='71:8:4' # Центральное, Плавское, Тульская область
    _8_9_3_1='89:3:1' # Вынгапуровское, Ноябрьское, Ямало-Ненецкий автономный округ
    _8_9_3_3='89:3:3' # Ноябрьское, Ноябрьское, Ямало-Ненецкий автономный округ
    _8_9_3_2='89:3:2' # Муравленковское, Ноябрьское, Ямало-Ненецкий автономный округ
    _6_2_8_1='62:8:1' # Белореченское, Можарское, Рязанская область
    _6_2_8_3='62:8:3' # Можарское, Можарское, Рязанская область
    _6_2_8_2='62:8:2' # Борецкое, Можарское, Рязанская область
    _6_2_8_5='62:8:5' # Сысоевское, Можарское, Рязанская область
    _6_2_8_4='62:8:4' # Сараевское, Можарское, Рязанская область
    _6_2_8_6='62:8:6' # Ширинское, Можарское, Рязанская область
    _1_3_9='1:3:9' # Опытное, Майкопское, Республика Адыгея (Адыгея)
    _1_3_8='1:3:8' # Лесосеменное, Майкопское, Республика Адыгея (Адыгея)
    _1_3_5='1:3:5' # Кужорское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_4='1:3:4' # Дагестанское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_7='1:3:7' # Курджипское сельское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_6='1:3:6' # Курджипское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_1='1:3:1' # Гиагинское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_3='1:3:3' # Горбовское (Элота) Майкопское, Майкопское, Республика Адыгея (Адыгея)
    _1_3_2='1:3:2' # Горбовское (Элота) Кужорское, Майкопское, Республика Адыгея (Адыгея)
    _3_4_19_3='34:19:3' # Клетское сельское, Серафимовичское, Волгоградская область
    _3_4_19_4='34:19:4' # Перекопское, Серафимовичское, Волгоградская область
    _3_4_19_1='34:19:1' # Кировское, Серафимовичское, Волгоградская область
    _3_4_19_2='34:19:2' # Клетское, Серафимовичское, Волгоградская область
    _3_4_19_7='34:19:7' # Суворовское, Серафимовичское, Волгоградская область
    _3_4_19_8='34:19:8' # Усть-Хопёрское, Серафимовичское, Волгоградская область
    _3_4_19_5='34:19:5' # Распопинское, Серафимовичское, Волгоградская область
    _3_4_19_6='34:19:6' # Серафимовичское сельское, Серафимовичское, Волгоградская область
    _4_5_1_1='45:1:1' # Боровлянское, Белозерское, Курганская область
    _3_8_6_1='38:6:1' # Бодайбинское, Бодайбинское, Иркутская область
    _4_5_1_2='45:1:2' # Боровское, Белозерское, Курганская область
    _7_2_2_1='72:2:1' # Армизонское, Армизонское, Тюменская область
    _7_2_2_2='72:2:2' # Армизонское сельское, Армизонское, Тюменская область
    _3_36_1='3:36:1' # Брянское, Хандагатайское, Республика Бурятия
    _3_36_2='3:36:2' # Горхонское, Хандагатайское, Республика Бурятия
    _3_36_3='3:36:3' # Михайловское, Хандагатайское, Республика Бурятия
    _3_36_4='3:36:4' # Хандагатайское, Хандагатайское, Республика Бурятия
    _3_36_5='3:36:5' # Челутаевское, Хандагатайское, Республика Бурятия
    _1_4_9_1='14:9:1' # Верхнеколымское, Колымское, Республика Саха (Якутия)
    _1_4_9_3='14:9:3' # Черское, Колымское, Республика Саха (Якутия)
    _1_4_9_2='14:9:2' # Среднеколымское, Колымское, Республика Саха (Якутия)
    _5_1_3_1='51:3:1' # Апатитское, Кировское, Мурманская область
    _5_1_3_2='51:3:2' # Кировское, Кировское, Мурманская область
    _4_4_7_4='44:7:4' # 2-е Нерехтское, Костромское, Костромская область
    _4_4_7_3='44:7:3' # 2-е Красносельское, Костромское, Костромская область
    _4_4_7_2='44:7:2' # 1-е Нерехтское, Костромское, Костромская область
    _4_4_7_1='44:7:1' # 1-е Красносельское, Костромское, Костромская область
    _4_4_7_8='44:7:8' # Костромское, Костромское, Костромская область
    _4_5_12_4='45:12:4' # Юргамышское, Юргамышское, Курганская область
    _4_4_7_7='44:7:7' # Космынинское, Костромское, Костромская область
    _4_4_7_6='44:7:6' # Караваевское, Костромское, Костромская область
    _4_4_7_5='44:7:5' # ГПЗ "Сумароковский", Костромское, Костромская область
    _4_5_12_1='45:12:1' # Кировское, Юргамышское, Курганская область
    _4_5_12_3='45:12:3' # Мишкинское, Юргамышское, Курганская область
    _4_5_12_2='45:12:2' # Кислянское, Юргамышское, Курганская область
    _4_4_7_9='44:7:9' # Мисковское, Костромское, Костромская область
    _1_6_23_4='16:23:4' # Сокольское, Мамадышское, Республика Татарстан (Татарстан)
    _1_6_23_3='16:23:3' # Нурминское, Мамадышское, Республика Татарстан (Татарстан)
    _3_22_2='3:22:2' # Турокчанское, Куйтунское, Республика Бурятия
    _1_6_23_2='16:23:2' # Кумазанское, Мамадышское, Республика Татарстан (Татарстан)
    _3_22_1='3:22:1' # Баянгольское, Куйтунское, Республика Бурятия
    _1_6_23_1='16:23:1' # Кляушское, Мамадышское, Республика Татарстан (Татарстан)
    _7_4_13_4='74:13:4' # Тургоякское, Миасское, Челябинская область
    _7_4_13_3='74:13:3' # Сыростанское, Миасское, Челябинская область
    _7_4_13_2='74:13:2' # Новоандреевское, Миасское, Челябинская область
    _7_4_13_1='74:13:1' # Миасское, Миасское, Челябинская область
    _1_5_2_1='15:2:1' # Гизельдонское, Владикавказское, Республика Северная Осетия - Алания
    _1_5_2_3='15:2:3' # Майрамадагское, Владикавказское, Республика Северная Осетия - Алания
    _1_5_2_2='15:2:2' # Дзуарикауское, Владикавказское, Республика Северная Осетия - Алания
    _3_35_1='3:35:1' # Гусихинское, Усть-Баргузинское, Республика Бурятия
    _3_35_2='3:35:2' # Максимихинское, Усть-Баргузинское, Республика Бурятия
    _3_35_3='3:35:3' # Усть-Баргузинское, Усть-Баргузинское, Республика Бурятия
    _3_35_4='3:35:4' # Шанталыкское, Усть-Баргузинское, Республика Бурятия
    _2_1_5_3='21:5:3' # Кирское, Кирское, Чувашская Республика - Чувашия
    _2_1_5_2='21:5:2' # Гартовское, Кирское, Чувашская Республика - Чувашия
    _2_1_5_1='21:5:1' # Атратское, Кирское, Чувашская Республика - Чувашия
    _2_9_21_4='29:21:4' # Мехреньгское, Пуксоозерское, Архангельская область
    _2_9_21_1='29:21:1' # Выяжское, Пуксоозерское, Архангельская область
    _2_9_21_2='29:21:2' # Квандозерское, Пуксоозерское, Архангельская область
    _2_9_21_3='29:21:3' # Кочмасское, Пуксоозерское, Архангельская область
    _1_6_10_4='16:10:4' # Ютазинское, Бугульминское, Республика Татарстан (Татарстан)
    _1_6_10_3='16:10:3' # Петровское, Бугульминское, Республика Татарстан (Татарстан)
    _1_6_10_2='16:10:2' # Бугульминское, Бугульминское, Республика Татарстан (Татарстан)
    _6_2_10_5='62:10:5' # Шеметовское, Первомайское, Рязанская область
    _1_6_10_1='16:10:1' # Актюбинское, Бугульминское, Республика Татарстан (Татарстан)
    _3_3_10_10='33:10:10' # Эсинское, Ковровское, Владимирская область
    _6_2_10_4='62:10:4' # Путятинское, Первомайское, Рязанская область
    _6_2_10_3='62:10:3' # Назаровское, Первомайское, Рязанская область
    _6_2_10_2='62:10:2' # Инякинское, Первомайское, Рязанская область
    _6_2_10_1='62:10:1' # Боровское, Первомайское, Рязанская область
    _6_1_15_3='61:15:3' # Нижне-Кундрюченское, Усть-Донецкое, Ростовская область
    _6_1_15_1='61:15:1' # Константиновское, Усть-Донецкое, Ростовская область
    _6_1_15_2='61:15:2' # Крымское, Усть-Донецкое, Ростовская область
    _2_4_16_10='24:16:10' # Чалбышевское, Енисейское, Красноярский край
    _6_8_4_3='68:4:3' # Ирское, Кирсановское, Тамбовская область
    _6_8_4_2='68:4:2' # Инжавинское, Кирсановское, Тамбовская область
    _6_8_4_4='68:4:4' # Кирсановское, Кирсановское, Тамбовская область
    _6_8_4_1='68:4:1' # Дербенское, Кирсановское, Тамбовская область
    _1_2_5='1:2:5' # Шовгеновское, Красногвардейское, Республика Адыгея (Адыгея)
    _1_2_2='1:2:2' # Красногвардейское, Красногвардейское, Республика Адыгея (Адыгея)
    _1_2_1='1:2:1' # Кошехабльское, Красногвардейское, Республика Адыгея (Адыгея)
    _1_2_4='1:2:4' # Теучежское, Красногвардейское, Республика Адыгея (Адыгея)
    _1_2_3='1:2:3' # Тахтамукайское, Красногвардейское, Республика Адыгея (Адыгея)
    _5_0_15_17='50:15:17' # Подольское, Подольское, Московская область
    _5_0_15_16='50:15:16' # Первомайское, Подольское, Московская область
    _5_0_15_19='50:15:19' # Пушкинское, Подольское, Московская область
    _5_0_15_18='50:15:18' # Подольское сельское, Подольское, Московская область
    _5_0_15_13='50:15:13' # Мемориальное, Подольское, Московская область
    _5_0_15_12='50:15:12' # Малинское, Подольское, Московская область
    _5_0_15_15='50:15:15' # Молодинское, Подольское, Московская область
    _5_0_15_14='50:15:14' # Мещерское, Подольское, Московская область
    _5_0_15_11='50:15:11' # Львовское, Подольское, Московская область
    _5_0_15_10='50:15:10' # Кузьминки, Подольское, Московская область
    _1_8_15_2='18:15:2' # Валамазское, Красногорское, Удмуртская Республика
    _1_8_15_1='18:15:1' # Архангельское, Красногорское, Удмуртская Республика
    _5_2_25_1='52:25:1' # Большеболдинское, Починковское межрайонное, Нижегородская область
    _5_0_15_24='50:15:24' # Чеховское, Подольское, Московская область
    _5_0_15_23='50:15:23' # Томилинское, Подольское, Московская область
    _5_0_15_20='50:15:20' # Сельвачевское, Подольское, Московская область
    _1_8_15_4='18:15:4' # Курьинское, Красногорское, Удмуртская Республика
    _1_8_15_3='18:15:3' # Кокманское, Красногорское, Удмуртская Республика
    _5_0_15_22='50:15:22' # Съяновское, Подольское, Московская область
    _5_0_15_21='50:15:21' # Стремиловское, Подольское, Московская область
    _1_8_15_5='18:15:5' # Святогорское, Красногорское, Удмуртская Республика
    _2_0_11_1='20:11:1' # Гехинское, Урус-Мартановское, Чеченская Республика
    _5_2_25_3='52:25:3' # Ужовское, Починковское межрайонное, Нижегородская область
    _2_0_11_2='20:11:2' # Рошничуйское, Урус-Мартановское, Чеченская Республика
    _5_2_25_2='52:25:2' # Коммунарское, Починковское межрайонное, Нижегородская область
    _2_0_11_3='20:11:3' # Урус-Мартановское, Урус-Мартановское, Чеченская Республика
    _2_0_11_4='20:11:4' # Шалажинское, Урус-Мартановское, Чеченская Республика
    _5_5_10_4='55:10:4' # Федоровское, Называевское, Омская область
    _5_5_10_3='55:10:3' # Называевское сельское, Называевское, Омская область
    _5_5_10_2='55:10:2' # Называевское, Называевское, Омская область
    _5_5_10_1='55:10:1' # Князевское, Называевское, Омская область
    _2_6_8_2='26:8:2' # Степновское, Курское, Ставропольский край
    _2_6_8_1='26:8:1' # Курское, Курское, Ставропольский край
    _3_3_3_1='33:3:1' # Бараковское, Владимирское, Владимирская область
    _3_3_3_2='33:3:2' # Владимирское, Владимирское, Владимирская область
    _3_3_3_3='33:3:3' # Головинское, Владимирское, Владимирская область
    _3_3_3_4='33:3:4' # Лавровское, Владимирское, Владимирская область
    _3_3_3_5='33:3:5' # Пригородное, Владимирское, Владимирская область
    _3_3_3_6='33:3:6' # Радужное, Владимирское, Владимирская область
    _3_3_3_7='33:3:7' # Улыбышевское, Владимирское, Владимирская область
    _5_2_12_1='52:12:1' # Бриляковское, Городецкое межрайонное, Нижегородская область
    _5_2_12_2='52:12:2' # Городецкое, Городецкое межрайонное, Нижегородская область
    _5_2_12_3='52:12:3' # Пуреховское, Городецкое межрайонное, Нижегородская область
    _5_2_12_4='52:12:4' # Узольское, Городецкое межрайонное, Нижегородская область
    _5_2_12_5='52:12:5' # Чкаловское, Городецкое межрайонное, Нижегородская область
    _4_2_12_5='42:12:5' # Промышленновское, Промышленновское, Кемеровская область
    _4_2_12_3='42:12:3' # Ленинск-Кузнецкое, Промышленновское, Кемеровская область
    _4_2_12_4='42:12:4' # Падунское, Промышленновское, Кемеровская область
    _4_2_12_1='42:12:1' # Вагановское, Промышленновское, Кемеровская область
    _4_2_12_2='42:12:2' # Краснинское, Промышленновское, Кемеровская область
    _6_3_1_3='63:1:3' # Хворостянское, Безенчукское, Самарская область
    _6_3_1_2='63:1:2' # Приволжское, Безенчукское, Самарская область
    _6_6_18_3='66:18:3' # Павдинское, Ново-Лялинское, Свердловская область
    _6_3_1_1='63:1:1' # Безенчукское, Безенчукское, Самарская область
    _6_6_18_4='66:18:4' # Старолялинское, Ново-Лялинское, Свердловская область
    _6_6_18_1='66:18:1' # Коноплянское, Ново-Лялинское, Свердловская область
    _6_6_18_2='66:18:2' # Отвинское, Ново-Лялинское, Свердловская область
    _5_2_10_2='52:10:2' # Воскресенское, Воскресенское районное, Нижегородская область
    _5_2_10_3='52:10:3' # Елдежское, Воскресенское районное, Нижегородская область
    _5_2_10_4='52:10:4' # Заветлужское, Воскресенское районное, Нижегородская область
    _5_2_10_5='52:10:5' # Ижменское, Воскресенское районное, Нижегородская область
    _5_2_10_1='52:10:1' # Большепольское, Воскресенское районное, Нижегородская область
    _5_2_10_6='52:10:6' # Красноярское, Воскресенское районное, Нижегородская область
    _5_2_10_7='52:10:7' # Нестиарское, Воскресенское районное, Нижегородская область
    _5_2_10_8='52:10:8' # Староустинское, Воскресенское районное, Нижегородская область
    _5_2_10_9='52:10:9' # Успенское, Воскресенское районное, Нижегородская область
    _5_1_2_2='51:2:2' # Кандалакшское, Кандалакшское, Мурманская область
    _5_1_2_1='51:2:1' # Алакурттинское, Кандалакшское, Мурманская область
    _7_1_9_1='71:9:1' # Ханинское, Суворовское, Тульская область
    _7_1_9_2='71:9:2' # Чекалинское, Суворовское, Тульская область
    _2_7_2_1='27:2:1' # Амгуньское, Амгуньское, Хабаровский край
    _2_7_2_2='27:2:2' # Баджальское, Амгуньское, Хабаровский край
    _2_7_2_3='27:2:3' # Боленское, Амгуньское, Хабаровский край
    _2_7_2_4='27:2:4' # Дукинское, Амгуньское, Хабаровский край
    _2_7_2_5='27:2:5' # Ниланское, Амгуньское, Хабаровский край
    _2_7_2_6='27:2:6' # Средне-Амгуньское, Амгуньское, Хабаровский край
    _5_6_5_2='56:5:2' # Гипсовское, Беляевское, Оренбургская область
    _5_6_5_1='56:5:1' # Беляевское, Беляевское, Оренбургская область
    _3_5_9_12='35:9:12' # Краснодеревенское, Вытегорское, Вологодская область
    _2_27_20='2:27:20' # Ярмунчинское, Туймазинское, Республика Башкортостан
    _3_5_9_13='35:9:13' # Куржекское, Вытегорское, Вологодская область
    _3_5_9_10='35:9:10' # Кемозерское, Вытегорское, Вологодская область
    _3_5_9_11='35:9:11' # Ковжинское, Вытегорское, Вологодская область
    _3_5_9_16='35:9:16' # Мегорское, Вытегорское, Вологодская область
    _3_5_9_17='35:9:17' # Окштамское, Вытегорское, Вологодская область
    _3_5_9_14='35:9:14' # Ладвозерское, Вытегорское, Вологодская область
    _3_5_9_15='35:9:15' # Лемское, Вытегорское, Вологодская область
    _5_5_11_3='55:11:3' # Кормиловское, Омское, Омская область
    _5_5_11_2='55:11:2' # Городское, Омское, Омская область
    _5_5_11_1='55:11:1' # Большекулачинское, Омское, Омская область
    _5_5_11_7='55:11:7' # Омское, Омское, Омская область
    _5_5_11_6='55:11:6' # Лузинское, Омское, Омская область
    _5_5_11_5='55:11:5' # Красноярское, Омское, Омская область
    _5_5_11_4='55:11:4' # Кормиловское сельское, Омское, Омская область
    _5_5_11_9='55:11:9' # Подгородное, Омское, Омская область
    _5_5_11_8='55:11:8' # Петровское, Омское, Омская область
    _3_5_9_23='35:9:23' # Чернослободское, Вытегорское, Вологодская область
    _3_5_9_24='35:9:24' # Якшинское, Вытегорское, Вологодская область
    _3_5_9_21='35:9:21' # Приканальное, Вытегорское, Вологодская область
    _3_5_9_22='35:9:22' # Рубежское, Вытегорское, Вологодская область
    _3_5_9_20='35:9:20' # Педажезерское, Вытегорское, Вологодская область
    _8_9_4_3='89:4:3' # Уренгойское, Таркосалинское, Ямало-Ненецкий автономный округ
    _3_5_9_18='35:9:18' # Оштинское, Вытегорское, Вологодская область
    _3_5_9_19='35:9:19' # Оштинское сельское, Вытегорское, Вологодская область
    _8_9_4_2='89:4:2' # Таркосалинское, Таркосалинское, Ямало-Ненецкий автономный округ
    _8_9_4_1='89:4:1' # Пурпейское, Таркосалинское, Ямало-Ненецкий автономный округ
    _1_0_12_1='10:12:1' # Деревянское, Прионежское, Республика Карелия
    _1_0_12_4='10:12:4' # Лососинское, Прионежское, Республика Карелия
    _1_0_12_5='10:12:5' # Машезерское, Прионежское, Республика Карелия
    _1_0_12_2='10:12:2' # Ладва-Веткинское, Прионежское, Республика Карелия
    _1_0_12_3='10:12:3' # Ладвинское, Прионежское, Республика Карелия
    _1_0_12_8='10:12:8' # Петрозаводское, Прионежское, Республика Карелия
    _1_0_12_9='10:12:9' # Пригородное, Прионежское, Республика Карелия
    _1_0_12_6='10:12:6' # Пайское, Прионежское, Республика Карелия
    _1_0_12_7='10:12:7' # Педасельгское, Прионежское, Республика Карелия
    _2_27_13='2:27:13' # Октябрьское, Туймазинское, Республика Башкортостан
    _2_27_12='2:27:12' # Нижне-Троицкое, Туймазинское, Республика Башкортостан
    _2_27_11='2:27:11' # Мустафинское, Туймазинское, Республика Башкортостан
    _2_27_10='2:27:10' # Куручевское, Туймазинское, Республика Башкортостан
    _6_2_7_2='62:7:2' # Вандовское, Криушинское, Рязанская область
    _6_2_7_1='62:7:1' # Белоборское, Криушинское, Рязанская область
    _6_2_7_4='62:7:4' # Малиновское, Криушинское, Рязанская область
    _6_2_7_3='62:7:3' # Криушинское, Криушинское, Рязанская область
    _3_4_18_1='34:18:1' # Дубовоовражное, Светлоярское, Волгоградская область
    _6_2_7_5='62:7:5' # Хворостовское, Криушинское, Рязанская область
    _3_4_18_4='34:18:4' # Светлоярское, Светлоярское, Волгоградская область
    _2_27_17='2:27:17' # Чекмагушевское, Туймазинское, Республика Башкортостан
    _2_27_16='2:27:16' # Тюменякское, Туймазинское, Республика Башкортостан
    _3_4_18_2='34:18:2' # Котельниковское, Светлоярское, Волгоградская область
    _2_27_15='2:27:15' # Резяповское, Туймазинское, Республика Башкортостан
    _3_4_18_3='34:18:3' # Ново-Аксайское, Светлоярское, Волгоградская область
    _2_27_14='2:27:14' # Присюньское, Туймазинское, Республика Башкортостан
    _2_27_19='2:27:19' # Юрминское, Туймазинское, Республика Башкортостан
    _2_27_18='2:27:18' # Шаранское, Туймазинское, Республика Башкортостан
    _1_4_8_2='14:8:2' # Момское, Индигирское, Республика Саха (Якутия)
    _1_4_8_1='14:8:1' # Абыйское, Индигирское, Республика Саха (Якутия)
    _1_4_8_3='14:8:3' # Оймяконское, Индигирское, Республика Саха (Якутия)
    _5_0_8_1='50:8:1' # Глубоковское, Истринское, Московская область
    _5_0_8_2='50:8:2' # Деньковское, Истринское, Московская область
    _3_6_21_1='36:21:1' # Алабухское, Теллермановское, Воронежская область
    _5_0_8_3='50:8:3' # Истринское сельское, Истринское, Московская область
    _3_6_21_2='36:21:2' # Грибановское, Теллермановское, Воронежская область
    _5_0_8_4='50:8:4' # Котовское, Истринское, Московская область
    _3_6_21_3='36:21:3' # Карачанское, Теллермановское, Воронежская область
    _5_0_8_5='50:8:5' # Красногорское, Истринское, Московская область
    _5_0_8_6='50:8:6' # Никольское, Истринское, Московская область
    _5_0_8_7='50:8:7' # Новогорское, Истринское, Московская область
    _5_0_8_8='50:8:8' # Ново-Иерусалимское, Истринское, Московская область
    _5_0_8_9='50:8:9' # Опалиховское, Истринское, Московская область
    _3_8_7_6='38:7:6' # Тарминское, Братское, Иркутская область
    _3_8_7_5='38:7:5' # Тангуйское, Братское, Иркутская область
    _3_8_7_4='38:7:4' # Маральское, Братское, Иркутская область
    _3_8_7_3='38:7:3' # Илирское, Братское, Иркутская область
    _3_8_7_2='38:7:2' # Вихоревское, Братское, Иркутская область
    _3_8_7_1='38:7:1' # Братское, Братское, Иркутская область
    _7_2_3_2='72:3:2' # Кротовское, Аромашевское, Тюменская область
    _3_6_21_4='36:21:4' # Лобановское, Теллермановское, Воронежская область
    _3_6_21_5='36:21:5' # Пригородное, Теллермановское, Воронежская область
    _7_2_3_1='72:3:1' # Аромашевское, Аромашевское, Тюменская область
    _3_6_21_6='36:21:6' # Хоперское, Теллермановское, Воронежская область
    _1_4_8='1:4:8' # Тульское сельское, Первомайское, Республика Адыгея (Адыгея)
    _1_4_7='1:4:7' # Тульское, Первомайское, Республика Адыгея (Адыгея)
    _1_4_4='1:4:4' # Махошевское, Первомайское, Республика Адыгея (Адыгея)
    _1_4_3='1:4:3' # Горбовское, Первомайское, Республика Адыгея (Адыгея)
    _1_4_6='1:4:6' # Севастопольское сельское, Первомайское, Республика Адыгея (Адыгея)
    _1_4_5='1:4:5' # Первомайское, Первомайское, Республика Адыгея (Адыгея)
    _2_7_19_3='27:19:3' # Немптинское, Мухенское, Хабаровский край
    _2_7_19_4='27:19:4' # Сийское, Мухенское, Хабаровский край
    _2_7_19_1='27:19:1' # Верхне-Хорское, Мухенское, Хабаровский край
    _1_4_2='1:4:2' # Абадзехское сельское, Первомайское, Республика Адыгея (Адыгея)
    _2_7_19_2='27:19:2' # Мухенское, Мухенское, Хабаровский край
    _1_4_1='1:4:1' # Абадзехское, Первомайское, Республика Адыгея (Адыгея)
    _6_9_2_11='69:2:11' # Ленинское, Западнодвинское, Тверская область
    _6_9_2_10='69:2:10' # Западнодвинское, Западнодвинское, Тверская область
    _5_2_4_10='52:4:10' # Плотинковское, Борское районное, Нижегородская область
    _3_24_5='3:24:5' # Могойтинское, Курумканское, Республика Бурятия
    _3_24_4='3:24:4' # Курумканское сельское, Курумканское, Республика Бурятия
    _3_24_3='3:24:3' # Курумканское, Курумканское, Республика Бурятия
    _3_24_2='3:24:2' # Гаргинское, Курумканское, Республика Бурятия
    _3_24_1='3:24:1' # Аргадинское, Курумканское, Республика Бурятия
    _4_5_2_2='45:2:2' # Лебяжьевское, Варгашинское, Курганская область
    _4_5_2_1='45:2:1' # Варгашинское, Варгашинское, Курганская область
    _4_5_2_4='45:2:4' # Мокроусовское, Варгашинское, Курганская область
    _4_5_2_3='45:2:3' # Марайское, Варгашинское, Курганская область
    _6_9_2_20='69:2:20' # Шапковское, Западнодвинское, Тверская область
    _6_9_2_21='69:2:21' # Южное, Западнодвинское, Тверская область
    _3_37_1='3:37:1' # Аланское, Хоринское, Республика Бурятия
    _3_37_2='3:37:2' # Верхне-Онинское, Хоринское, Республика Бурятия
    _3_37_3='3:37:3' # Зун-Хурайское, Хоринское, Республика Бурятия
    _3_37_4='3:37:4' # Онинское, Хоринское, Республика Бурятия
    _3_37_5='3:37:5' # Хоринское, Хоринское, Республика Бурятия
    _3_37_6='3:37:6' # Хоринское сельское, Хоринское, Республика Бурятия
    _6_9_2_17='69:2:17' # Соловское, Западнодвинское, Тверская область
    _6_9_2_16='69:2:16' # Смородинское, Западнодвинское, Тверская область
    _6_9_2_19='69:2:19' # Туровское, Западнодвинское, Тверская область
    _6_9_2_18='69:2:18' # Староторопское, Западнодвинское, Тверская область
    _6_9_2_13='69:2:13' # Нелидовское, Западнодвинское, Тверская область
    _6_9_2_12='69:2:12' # Монинское, Западнодвинское, Тверская область
    _6_9_2_15='69:2:15' # Северное, Западнодвинское, Тверская область
    _6_9_2_14='69:2:14' # Паникольское, Западнодвинское, Тверская область
    _2_8_12_10='28:12:10' # Урушинское, Урушинское, Амурская область
    _4_7_13_20='47:13:20' # Юксовское, Подпорожское, Ленинградская область
    _2_1_6_2='21:6:2' # Сотниковское, Мариинско-Посадское, Чувашская Республика - Чувашия
    _2_1_6_1='21:6:1' # Мариинско-Посадское, Мариинско-Посадское, Чувашская Республика - Чувашия
    _4_7_13_17='47:13:17' # Свирское, Подпорожское, Ленинградская область
    _3_10_3='3:10:3' # Темниковскеое, Гусиноозёрское, Республика Бурятия
    _4_7_13_16='47:13:16' # Пригородное, Подпорожское, Ленинградская область
    _3_10_2='3:10:2' # Загустайское, Гусиноозёрское, Республика Бурятия
    _4_7_13_15='47:13:15' # Подпорожское, Подпорожское, Ленинградская область
    _3_10_1='3:10:1' # Гусиноозёрское, Гусиноозёрское, Республика Бурятия
    _4_7_13_14='47:13:14' # Пертозерское, Подпорожское, Ленинградская область
    _4_7_13_13='47:13:13' # Остречинское, Подпорожское, Ленинградская область
    _4_7_13_12='47:13:12' # Онежское, Подпорожское, Ленинградская область
    _4_4_7_12='44:7:12' # Сущёвское, Костромское, Костромская область
    _4_7_13_11='47:13:11' # Немжинское, Подпорожское, Ленинградская область
    _4_4_7_11='44:7:11' # Сандогорское, Костромское, Костромская область
    _4_7_13_10='47:13:10' # Лукинское, Подпорожское, Ленинградская область
    _4_4_7_10='44:7:10' # Пригородное, Костромское, Костромская область
    _4_7_13_19='47:13:19' # Тукшинское, Подпорожское, Ленинградская область
    _4_7_13_18='47:13:18' # Токарское, Подпорожское, Ленинградская область
    _3_23_1='3:23:1' # Верхне-Курбинское, Курбинское, Республика Бурятия
    _7_4_14_5='74:14:5' # Ункурдинское, Нязепетровское, Челябинская область
    _7_4_14_4='74:14:4' # Нязепетровское, Нязепетровское, Челябинская область
    _7_4_14_3='74:14:3' # Куказарское, Нязепетровское, Челябинская область
    _7_4_14_2='74:14:2' # Красностанское, Нязепетровское, Челябинская область
    _7_4_14_6='74:14:6' # Шемахинское, Нязепетровское, Челябинская область
    _7_4_14_1='74:14:1' # Гривенское, Нязепетровское, Челябинская область
    _3_23_4='3:23:4' # Хасуртайское, Курбинское, Республика Бурятия
    _3_23_3='3:23:3' # Тэгдинское, Курбинское, Республика Бурятия
    _3_23_2='3:23:2' # Ойбонтовское, Курбинское, Республика Бурятия
    _1_5_1_2='15:1:2' # Зилахарское, Алагирское, Республика Северная Осетия - Алания
    _1_5_1_1='15:1:1' # Алагирское, Алагирское, Республика Северная Осетия - Алания
    _6_2_11_4='62:11:4' # Скопинское, Ряжское, Рязанская область
    _1_5_1_5='15:1:5' # Тамискское, Алагирское, Республика Северная Осетия - Алания
    _1_5_1_4='15:1:4' # Суадагское, Алагирское, Республика Северная Осетия - Алания
    _1_5_1_3='15:1:3' # Садонское, Алагирское, Республика Северная Осетия - Алания
    _6_2_11_3='62:11:3' # Ряжское, Ряжское, Рязанская область
    _6_2_11_2='62:11:2' # Милославское, Ряжское, Рязанская область
    _6_2_11_1='62:11:1' # Горловское, Ряжское, Рязанская область
    _7_2_17_11='72:17:11' # Успенское, Тюменское, Тюменская область
    _7_2_17_10='72:17:10' # Тюменское сельское, Тюменское, Тюменская область
    _6_1_14_4='61:14:4' # Криворожское, Тарасовское, Ростовская область
    _6_1_14_5='61:14:5' # Митякинское, Тарасовское, Ростовская область
    _6_1_14_2='61:14:2' # Грачинское, Тарасовское, Ростовская область
    _6_1_14_3='61:14:3' # Ефремо-Степановское, Тарасовское, Ростовская область
    _6_1_14_1='61:14:1' # Большинское, Тарасовское, Ростовская область
    _2_6_9_3='26:9:3' # Нефтекумское, Левокумское, Ставропольский край
    _2_6_9_1='26:9:1' # Арзгирское, Левокумское, Ставропольский край
    _2_6_9_2='26:9:2' # Левокумское, Левокумское, Ставропольский край
    _6_8_3_4='68:3:4' # Хомутляйское, Горельское, Тамбовская область
    _6_8_3_3='68:3:3' # Хмелинское, Горельское, Тамбовская область
    _6_8_3_2='68:3:2' # Тулиновское, Горельское, Тамбовская область
    _6_8_3_1='68:3:1' # Галдымское, Горельское, Тамбовская область
    _4_4_8_3='44:8:3' # Ануфриевское, Макарьевское, Костромская область
    _4_4_8_2='44:8:2' # 2-е Макарьевское, Макарьевское, Костромская область
    _4_4_8_1='44:8:1' # 1-е Макарьевское, Макарьевское, Костромская область
    _4_4_8_7='44:8:7' # Нейское, Макарьевское, Костромская область
    _4_5_11_5='45:11:5' # Щучанское, Шумихинское, Курганская область
    _4_4_8_6='44:8:6' # Красногорское, Макарьевское, Костромская область
    _4_4_8_5='44:8:5' # Коршунское, Макарьевское, Костромская область
    _4_4_8_4='44:8:4' # Высоковское, Макарьевское, Костромская область
    _4_5_11_2='45:11:2' # Галкинское, Шумихинское, Курганская область
    _4_5_11_1='45:11:1' # Альменевское, Шумихинское, Курганская область
    _4_5_11_4='45:11:4' # Шумихинское, Шумихинское, Курганская область
    _4_4_8_9='44:8:9' # Торзатское, Макарьевское, Костромская область
    _3_10_5='3:10:5' # Урминское, Гусиноозёрское, Республика Бурятия
    _4_5_11_3='45:11:3' # Сафакулевское, Шумихинское, Курганская область
    _4_4_8_8='44:8:8' # Тимошинское, Макарьевское, Костромская область
    _3_10_4='3:10:4' # Убукунское, Гусиноозёрское, Республика Бурятия
    _5_0_9_1='50:9:1' # Борщевское, Клинское, Московская область
    _5_0_9_2='50:9:2' # Верхне-Клязьминское, Клинское, Московская область
    _5_0_9_3='50:9:3' # Владыкинское, Клинское, Московская область
    _5_0_9_4='50:9:4' # Воронинское, Клинское, Московская область
    _5_0_9_5='50:9:5' # Высоковское, Клинское, Московская область
    _5_0_9_6='50:9:6' # Домашевское, Клинское, Московская область
    _5_0_9_7='50:9:7' # Истринское, Клинское, Московская область
    _5_0_9_8='50:9:8' # Клинское сельское, Клинское, Московская область
    _5_0_9_9='50:9:9' # Краснополянское, Клинское, Московская область
    _2_0_12_1='20:12:1' # Автуринское, Шалинское, Чеченская Республика
    _2_0_12_2='20:12:2' # Ново-Атагинское, Шалинское, Чеченская Республика
    _2_0_12_3='20:12:3' # Шалинское, Шалинское, Чеченская Республика
    _6_2_6_1='62:6:1' # Запольское, Кораблинское, Рязанская область
    _6_2_6_3='62:6:3' # Ухоловское, Кораблинское, Рязанская область
    _6_2_6_2='62:6:2' # Кораблинское, Кораблинское, Рязанская область
    _2_9_22_3='29:22:3' # Лайское, Северодвинское, Архангельская область
    _2_9_22_4='29:22:4' # Северодвинское, Северодвинское, Архангельская область
    _2_9_22_5='29:22:5' # Унское, Северодвинское, Архангельская область
    _2_9_22_1='29:22:1' # Белозерское, Северодвинское, Архангельская область
    _2_9_22_2='29:22:2' # Верхнеозерское, Северодвинское, Архангельская область
    _1_8_16_1='18:16:1' # Горнякское, Можгинское, Удмуртская Республика
    _1_8_16_3='18:16:3' # Сюгинское, Можгинское, Удмуртская Республика
    _1_8_16_2='18:16:2' # Пычасское, Можгинское, Удмуртская Республика
    _2_7_3_1='27:3:1' # Аимское, Аянское, Хабаровский край
    _2_7_3_2='27:3:2' # Аянское, Аянское, Хабаровский край
    _2_7_3_3='27:3:3' # Нельканское, Аянское, Хабаровский край
    _4_2_11_4='42:11:4' # Терешское, Прокопьевское, Кемеровская область
    _4_2_11_2='42:11:2' # Керлегешское, Прокопьевское, Кемеровская область
    _4_2_11_3='42:11:3' # Михайловское, Прокопьевское, Кемеровская область
    _4_2_11_1='42:11:1' # Еловское, Прокопьевское, Кемеровская область
    _6_6_17_8='66:17:8' # Синегорское, Нижне-Тагильское, Свердловская область
    _3_3_4_1='33:4:1' # Заклязьменское, Вязниковское, Владимирская область
    _6_6_17_9='66:17:9' # Уральское, Нижне-Тагильское, Свердловская область
    _3_3_4_2='33:4:2' # Мстерское, Вязниковское, Владимирская область
    _6_6_17_6='66:17:6' # Петрокаменское, Нижне-Тагильское, Свердловская область
    _3_3_4_3='33:4:3' # Нагорное, Вязниковское, Владимирская область
    _6_6_17_7='66:17:7' # Серебрянское, Нижне-Тагильское, Свердловская область
    _3_3_4_4='33:4:4' # Никологорское, Вязниковское, Владимирская область
    _6_6_17_4='66:17:4' # Красноуральское, Нижне-Тагильское, Свердловская область
    _3_3_4_5='33:4:5' # Новое, Вязниковское, Владимирская область
    _6_6_17_5='66:17:5' # Николо-Павловское, Нижне-Тагильское, Свердловская область
    _3_3_4_6='33:4:6' # Паустовское, Вязниковское, Владимирская область
    _6_6_17_2='66:17:2' # Висимское, Нижне-Тагильское, Свердловская область
    _3_3_4_7='33:4:7' # Посад-Мстерское, Вязниковское, Владимирская область
    _6_6_17_3='66:17:3' # Городское, Нижне-Тагильское, Свердловская область
    _3_3_4_8='33:4:8' # Сарыевское, Вязниковское, Владимирская область
    _3_3_4_9='33:4:9' # Степанцевское, Вязниковское, Владимирская область
    _6_6_17_1='66:17:1' # Башкарское, Нижне-Тагильское, Свердловская область
    _6_7_9_1='67:9:1' # Воргинское, Ершичское, Смоленская область
    _6_7_9_4='67:9:4' # Сукромлянское, Ершичское, Смоленская область
    _6_7_9_3='67:9:3' # Ершичское сельское, Ершичское, Смоленская область
    _6_7_9_2='67:9:2' # Ершичское, Ершичское, Смоленская область
    _5_2_24_2='52:24:2' # Вайское, Пижемское районное, Нижегородская область
    _5_2_24_1='52:24:1' # Буреполомское, Пижемское районное, Нижегородская область
    _5_2_24_4='52:24:4' # Ошминское, Пижемское районное, Нижегородская область
    _5_2_24_3='52:24:3' # Верхне-Унженское, Пижемское районное, Нижегородская область
    _5_2_24_6='52:24:6' # Шайгинское, Пижемское районное, Нижегородская область
    _5_2_24_5='52:24:5' # Пижемское, Пижемское районное, Нижегородская область
    _2_28_10='2:28:10' # Осиповское, Уфимское, Республика Башкортостан
    _2_28_14='2:28:14' # Юматовское, Уфимское, Республика Башкортостан
    _2_28_13='2:28:13' # Чишминское, Уфимское, Республика Башкортостан
    _2_28_12='2:28:12' # Уфимское, Уфимское, Республика Башкортостан
    _2_28_11='2:28:11' # Покровское, Уфимское, Республика Башкортостан
    _5_2_22_2='52:22:2' # Степаньковское, Павловское районное, Нижегородская область
    _5_2_22_1='52:22:1' # Павловское, Павловское районное, Нижегородская область
    _5_1_1_3='51:1:3' # Ковдорское, Зашейковское, Мурманская область
    _5_2_22_3='52:22:3' # Тумботинское, Павловское районное, Нижегородская область
    _5_1_1_1='51:1:1' # Ёнское, Зашейковское, Мурманская область
    _5_1_1_2='51:1:2' # Зашейковское, Зашейковское, Мурманская область
    _4_2_15_4='42:15:4' # Черемшанское, Тяжинское, Кемеровская область
    _4_2_15_2='42:15:2' # Даниловское, Тяжинское, Кемеровская область
    _4_2_15_3='42:15:3' # Итатское, Тяжинское, Кемеровская область
    _4_2_15_1='42:15:1' # Бороковское, Тяжинское, Кемеровская область
    _2_6_11_1='26:11:1' # Зеленокумское, Нижне-Кумское, Ставропольский край
    _2_6_11_2='26:11:2' # Нижне-Кумское, Нижне-Кумское, Ставропольский край
    _5_5_12_2='55:12:2' # Саргатское, Саргатское, Омская область
    _5_5_12_1='55:12:1' # Баженовское, Саргатское, Омская область
    _5_5_12_4='55:12:4' # Хохловское, Саргатское, Омская область
    _5_5_12_3='55:12:3' # Саргатское сельское, Саргатское, Омская область
    _8_9_5_3='89:5:3' # Приуральское, Ямальское, Ямало-Ненецкий автономный округ
    _8_9_5_2='89:5:2' # Мужевское, Ямальское, Ямало-Ненецкий автономный округ
    _8_9_5_1='89:5:1' # Горковское, Ямальское, Ямало-Ненецкий автономный округ
    _1_0_2_7='10:2:7' # Тихтозерское, Калевальское, Республика Карелия
    _1_0_2_8='10:2:8' # Ухтинское, Калевальское, Республика Карелия
    _1_0_2_9='10:2:9' # Юшкозерское, Калевальское, Республика Карелия
    _1_0_2_3='10:2:3' # Кепское, Калевальское, Республика Карелия
    _1_0_2_4='10:2:4' # Лахнозерское, Калевальское, Республика Карелия
    _1_0_2_5='10:2:5' # Луусальмское, Калевальское, Республика Карелия
    _5_8_11_2='58:11:2' # Головинщинское, Мокшанское, Пензенская область
    _6_1_13_1='61:13:1' # Багаевское, Семикаракорское, Ростовская область
    _1_0_2_6='10:2:6' # Пизьмагубское, Калевальское, Республика Карелия
    _5_8_11_1='58:11:1' # Голицынское-Долгоруковское, Мокшанское, Пензенская область
    _6_1_13_2='61:13:2' # Семикаракорское, Семикаракорское, Ростовская область
    _5_8_11_3='58:11:3' # Мокшанское-Чернозерское, Мокшанское, Пензенская область
    _1_0_2_1='10:2:1' # Боровское, Калевальское, Республика Карелия
    _1_0_2_2='10:2:2' # Войницкое, Калевальское, Республика Карелия
    _5_0_7_2='50:7:2' # Звенигородское, Звенигородское, Московская область
    _5_0_7_3='50:7:3' # Звенигородское сельское, Звенигородское, Московская область
    _6_8_2_4='68:2:4' # Пичаевское, Вернадское, Тамбовская область
    _5_0_7_4='50:7:4' # Коралловское, Звенигородское, Московская область
    _5_0_7_5='50:7:5' # Кубинское, Звенигородское, Московская область
    _5_0_7_6='50:7:6' # Нестеровское, Звенигородское, Московская область
    _6_8_2_1='68:2:1' # Вьюнское, Вернадское, Тамбовская область
    _5_0_7_7='50:7:7' # Орешковское, Звенигородское, Московская область
    _5_0_7_8='50:7:8' # Пионерское, Звенигородское, Московская область
    _6_8_2_3='68:2:3' # Красное, Вернадское, Тамбовская область
    _5_0_7_9='50:7:9' # Подушкинское, Звенигородское, Московская область
    _6_8_2_2='68:2:2' # Гагаринское, Вернадское, Тамбовская область
    _7_4_10_1='74:10:1' # Кунакбаевское, Кунашакское, Челябинская область
    _7_4_10_4='74:10:4' # Синарское, Кунашакское, Челябинская область
    _7_4_10_3='74:10:3' # Куяшское, Кунашакское, Челябинская область
    _7_4_10_2='74:10:2' # Кунашакское, Кунашакское, Челябинская область
    _1_5_5_2='15:5:2' # Заманкульское, Кировское, Республика Северная Осетия - Алания
    _1_5_5_1='15:5:1' # Ардонское, Кировское, Республика Северная Осетия - Алания
    _1_5_5_3='15:5:3' # Эльхотовское, Кировское, Республика Северная Осетия - Алания
    _5_0_7_1='50:7:1' # Баковское, Звенигородское, Московская область
    _4_4_5_2='44:5:2' # Кадыйское, Кадыйское, Костромская область
    _4_4_5_1='44:5:1' # Вёдровское, Кадыйское, Костромская область
    _4_4_5_6='44:5:6' # Чернышевское, Кадыйское, Костромская область
    _4_4_5_5='44:5:5' # Северное, Кадыйское, Костромская область
    _4_4_5_4='44:5:4' # Октябрьское, Кадыйское, Костромская область
    _4_4_5_3='44:5:3' # Нёмденское, Кадыйское, Костромская область
    _4_4_5_8='44:5:8' # Южное, Кадыйское, Костромская область
    _4_4_5_7='44:5:7' # Шуйское, Кадыйское, Костромская область
    _1_0_15_1='10:15:1' # Выгозерское, Сегежское, Республика Карелия
    _1_0_15_2='10:15:2' # Кучозерское, Сегежское, Республика Карелия
    _1_0_15_5='10:15:5' # Сегежское, Сегежское, Республика Карелия
    _1_0_15_3='10:15:3' # Надвоицкое, Сегежское, Республика Карелия
    _1_0_15_4='10:15:4' # Попов-Порожское, Сегежское, Республика Карелия
    _3_8_4_2='38:4:2' # Хоготское, Баяндаевское, Иркутская область
    _3_8_4_1='38:4:1' # Баяндаевское, Баяндаевское, Иркутская область
    _2_0_9_2='20:9:2' # Гансолчуйское, Ножай-Юртовское, Чеченская Республика
    _2_0_9_1='20:9:1' # Бенойское, Ножай-Юртовское, Чеченская Республика
    _2_0_9_3='20:9:3' # Симсирское, Ножай-Юртовское, Чеченская Республика
    _7_2_4_1='72:4:1' # Бердюжское, Бердюжское, Тюменская область
    _7_2_4_2='72:4:2' # Бердюжское сельское, Бердюжское, Тюменская область
    _3_3_11_5='33:11:5' # Ульяновское, Кольчугинское, Владимирская область
    _3_3_11_4='33:11:4' # Литвиновское, Кольчугинское, Владимирская область
    _3_3_11_1='33:11:1' # Беречинское, Кольчугинское, Владимирская область
    _3_3_11_3='33:11:3' # Кольчугинское, Кольчугинское, Владимирская область
    _3_3_11_2='33:11:2' # Есиплевское, Кольчугинское, Владимирская область
    _3_8_3_1='38:3:1' # Балаганское, Балаганское, Иркутская область
    _3_33_1='3:33:1' # Березовское, Улан-Удэнское, Республика Бурятия
    _3_33_2='3:33:2' # Верхне-Березовское, Улан-Удэнское, Республика Бурятия
    _6_2_12_6='62:12:6' # Старожиловское, Рязанское, Рязанская область
    _6_2_12_5='62:12:5' # Рязанское, Рязанское, Рязанская область
    _6_2_12_4='62:12:4' # Рыбновское, Рязанское, Рязанская область
    _6_2_12_3='62:12:3' # Пронское, Рязанское, Рязанская область
    _6_2_12_2='62:12:2' # Михайловское, Рязанское, Рязанская область
    _6_2_12_1='62:12:1' # Больше-Коровинское, Рязанское, Рязанская область
    _7_1_2='7:1:2' # Заюковское, Баксанское, Кабардино-Балкарская Республика
    _7_1_1='7:1:1' # Баксанское, Баксанское, Кабардино-Балкарская Республика
    _6_7_8_2='67:8:2' # Высоковское, Ельнинское, Смоленская область
    _6_7_8_1='67:8:1' # Бибиревское, Ельнинское, Смоленская область
    _6_7_8_6='67:8:6' # Новоспасское, Ельнинское, Смоленская область
    _6_7_8_5='67:8:5' # Мутищенское, Ельнинское, Смоленская область
    _6_7_8_4='67:8:4' # Ельнинское сельское, Ельнинское, Смоленская область
    _6_7_8_3='67:8:3' # Ельнинское, Ельнинское, Смоленская область
    _5_9_18_3='59:18:3' # Уинское, Октябрьское, Пермский край
    _5_9_18_4='59:18:4' # Чадское, Октябрьское, Пермский край
    _5_9_18_1='59:18:1' # Ишимовское, Октябрьское, Пермский край
    _5_9_18_2='59:18:2' # Ольховское, Октябрьское, Пермский край
    _4_5_10_3='45:10:3' # Самохваловское, Шатровское, Курганская область
    _5_8_10_1='58:10:1' # Вазерское, Лунинское, Пензенская область
    _4_5_10_2='45:10:2' # Дальне-Кубасовское, Шатровское, Курганская область
    _5_8_10_3='58:10:3' # Иссинское, Лунинское, Пензенская область
    _5_9_18_5='59:18:5' # Чернушинское, Октябрьское, Пермский край
    _4_5_10_4='45:10:4' # Шатровское, Шатровское, Курганская область
    _5_8_10_2='58:10:2' # Иванырсинское-Верхнешкафтинское, Лунинское, Пензенская область
    _5_9_18_6='59:18:6' # Щучье-Озерское, Октябрьское, Пермский край
    _1_6_21_5='16:21:5' # Шугуровское, Лениногорское, Республика Татарстан (Татарстан)
    _1_6_21_4='16:21:4' # Старо-Кувакское, Лениногорское, Республика Татарстан (Татарстан)
    _3_20_3='3:20:3' # Сантыринское, Кондинское, Республика Бурятия
    _4_5_10_1='45:10:1' # Бариновское, Шатровское, Курганская область
    _1_6_21_3='16:21:3' # Нижнее-Чершелинское, Лениногорское, Республика Татарстан (Татарстан)
    _3_20_2='3:20:2' # Кондинское, Кондинское, Республика Бурятия
    _1_6_21_2='16:21:2' # Лениногорское, Лениногорское, Республика Татарстан (Татарстан)
    _3_20_1='3:20:1' # Исингинское, Кондинское, Республика Бурятия
    _1_6_21_1='16:21:1' # Зай-Каратайское, Лениногорское, Республика Татарстан (Татарстан)
    _7_4_11_4='74:11:4' # Петропавловское, Кусинское, Челябинская область
    _7_4_11_3='74:11:3' # Магнитское, Кусинское, Челябинская область
    _7_4_11_2='74:11:2' # Кусинское, Кусинское, Челябинская область
    _7_4_11_1='74:11:1' # Злоказовское, Кусинское, Челябинская область
    _1_5_4_2='15:4:2' # Чиколинское, Ирафское, Республика Северная Осетия - Алания
    _1_5_4_1='15:4:1' # Хазнидонское, Ирафское, Республика Северная Осетия - Алания
    _3_33_3='3:33:3' # Мостовское, Улан-Удэнское, Республика Бурятия
    _3_3_1_3='33:1:3' # Карабановское, Александровское, Владимирская область
    _3_3_1_4='33:1:4' # Краснопламенское, Александровское, Владимирская область
    _3_3_1_5='33:1:5' # Махринское, Александровское, Владимирская область
    _3_3_1_6='33:1:6' # Струнинское, Александровское, Владимирская область
    _2_1_3_5='21:3:5' # Нововыслинское, Ибресинское, Чувашская Республика - Чувашия
    _2_1_3_4='21:3:4' # Кошлоушское, Ибресинское, Чувашская Республика - Чувашия
    _2_1_3_3='21:3:3' # Кармалинское, Ибресинское, Чувашская Республика - Чувашия
    _2_1_3_2='21:3:2' # Буинское, Ибресинское, Чувашская Республика - Чувашия
    _2_1_3_1='21:3:1' # Березовское, Ибресинское, Чувашская Республика - Чувашия
    _3_3_1_1='33:1:1' # Балакиревское, Александровское, Владимирская область
    _3_3_1_2='33:1:2' # Годуновское, Александровское, Владимирская область
    _6_5_10_1='65:10:1' # Охинское, Охинское, Сахалинская область
    _6_5_10_3='65:10:3' # Тунгорское, Охинское, Сахалинская область
    _6_5_10_2='65:10:2' # Рыбновское, Охинское, Сахалинская область
    _4_2_14_5='42:14:5' # Тисульское, Тисульское, Кемеровская область
    _4_2_14_6='42:14:6' # Центральное, Тисульское, Кемеровская область
    _4_2_14_3='42:14:3' # Макаракское, Тисульское, Кемеровская область
    _4_2_14_4='42:14:4' # Первомайское, Тисульское, Кемеровская область
    _4_2_14_1='42:14:1' # Берикульское, Тисульское, Кемеровская область
    _4_2_14_2='42:14:2' # Комсомольское, Тисульское, Кемеровская область
    _6_2_5_2='62:5:2' # Клепиковское, Клепиковское, Рязанская область
    _6_2_5_1='62:5:1' # Бусаевское, Клепиковское, Рязанская область
    _6_2_5_4='62:5:4' # Оськинское, Клепиковское, Рязанская область
    _6_2_5_3='62:5:3' # Колесниковское, Клепиковское, Рязанская область
    _4_4_8_10='44:8:10' # Унженское, Макарьевское, Костромская область
    _4_4_8_12='44:8:12' # Юровское, Макарьевское, Костромская область
    _5_6_4_1='56:4:1' # Асекеевское, Асекеевское, Оренбургская область
    _4_4_8_11='44:8:11' # Чернолуховское, Макарьевское, Костромская область
    _5_2_23_1='52:23:1' # Кавказкое, Первомайское районное, Нижегородская область
    _5_2_23_3='52:23:3' # Первомайское, Первомайское районное, Нижегородская область
    _5_2_23_2='52:23:2' # Кременковское, Первомайское районное, Нижегородская область
    _1_8_17_2='18:17:2' # Октябрьское, Сарапульское, Удмуртская Республика
    _1_8_17_1='18:17:1' # Керкмасское, Сарапульское, Удмуртская Республика
    _5_2_23_5='52:23:5' # Шутиловское, Первомайское районное, Нижегородская область
    _5_2_23_4='52:23:4' # Сатисское, Первомайское районное, Нижегородская область
    _2_6_6_1='26:6:1' # Благодарненское, Калаусское, Ставропольский край
    _2_6_6_2='26:6:2' # Журавское, Калаусское, Ставропольский край
    _2_6_6_3='26:6:3' # Калаусское, Калаусское, Ставропольский край
    _3_2_7_1='32:7:1' # Злынковское, Злынковское, Брянская область
    _3_2_7_4='32:7:4' # Софиевское, Злынковское, Брянская область
    _3_2_7_5='32:7:5' # Чуровичское, Злынковское, Брянская область
    _3_2_7_2='32:7:2' # Климовское, Злынковское, Брянская область
    _3_2_7_3='32:7:3' # Новозыбковское, Злынковское, Брянская область
    _5_5_13_1='55:13:1' # Кейзесское, Седельниковское, Омская область
    _5_5_13_4='55:13:4' # Седельниковское сельское, Седельниковское, Омская область
    _5_5_13_3='55:13:3' # Седельниковское, Седельниковское, Омская область
    _5_5_13_2='55:13:2' # Кейзесское сельское, Седельниковское, Омская область
    _5_5_9_1='55:9:1' # Артынское, Муромцевское, Омская область
    _5_5_9_2='55:9:2' # Кондратьевское, Муромцевское, Омская область
    _5_5_9_5='55:9:5' # Рязанское, Муромцевское, Омская область
    _5_5_9_3='55:9:3' # Муромцевское, Муромцевское, Омская область
    _5_5_9_4='55:9:4' # Муромцевское сельское, Муромцевское, Омская область
    _5_2_21_3='52:21:3' # Сонинское, Навашинское районное, Нижегородская область
    _5_2_21_2='52:21:2' # Навашинское, Навашинское районное, Нижегородская область
    _5_2_21_5='52:21:5' # Тешинское, Навашинское районное, Нижегородская область
    _5_2_21_4='52:21:4' # Степуринское, Навашинское районное, Нижегородская область
    _3_2_8_3='32:8:3' # Карачевское, Карачевское, Брянская область
    _3_2_8_4='32:8:4' # Красноармейское, Карачевское, Брянская область
    _5_2_21_1='52:21:1' # Дедовское, Навашинское районное, Нижегородская область
    _3_2_8_1='32:8:1' # Батаговское, Карачевское, Брянская область
    _3_2_8_2='32:8:2' # Журиничское, Карачевское, Брянская область
    _3_2_8_5='32:8:5' # Степное, Карачевское, Брянская область
    _5_2_34_1='52:34:1' # Красноборское, Шатковское районное, Нижегородская область
    _5_2_34_3='52:34:3' # Шатковское, Шатковское районное, Нижегородская область
    _5_2_34_2='52:34:2' # Лесогорское, Шатковское районное, Нижегородская область
    _1_0_14_2='10:14:2' # Водлинское, Пудожское, Республика Карелия
    _1_0_14_3='10:14:3' # Гакугское, Пудожское, Республика Карелия
    _1_0_14_1='10:14:1' # Авдеевское, Пудожское, Республика Карелия
    _1_0_14_6='10:14:6' # Кубовское, Пудожское, Республика Карелия
    _1_0_14_7='10:14:7' # Пудожское, Пудожское, Республика Карелия
    _1_0_14_4='10:14:4' # Коловское, Пудожское, Республика Карелия
    _1_0_14_5='10:14:5' # Кривецкое, Пудожское, Республика Карелия
    _1_0_14_8='10:14:8' # Пяльмское, Пудожское, Республика Карелия
    _1_0_14_9='10:14:9' # Рагнукское, Пудожское, Республика Карелия
    _6_1_12_1='61:12:1' # Быстрянское, Селивановское, Ростовская область
    _1_0_1_8='10:1:8' # Тунгудское, Беломорское, Республика Карелия
    _1_0_1_9='10:1:9' # Хвойное, Беломорское, Республика Карелия
    _1_0_1_4='10:1:4' # Лехтинское, Беломорское, Республика Карелия
    _1_0_1_5='10:1:5' # Ноттоваракское, Беломорское, Республика Карелия
    _1_0_1_6='10:1:6' # Охтинское, Беломорское, Республика Карелия
    _6_1_12_2='61:12:2' # Маньковское, Селивановское, Ростовская область
    _1_0_1_7='10:1:7' # Сумское, Беломорское, Республика Карелия
    _6_1_12_3='61:12:3' # Селивановское, Селивановское, Ростовская область
    _1_0_1_1='10:1:1' # Беломорское, Беломорское, Республика Карелия
    _1_0_1_2='10:1:2' # Вирандозерское, Беломорское, Республика Карелия
    _1_0_1_3='10:1:3' # Летнинское, Беломорское, Республика Карелия
    _6_8_1_2='68:1:2' # Кривополянское, Бондарское, Тамбовская область
    _6_8_1_1='68:1:1' # Земетчинское, Бондарское, Тамбовская область
    _6_8_1_3='68:1:3' # Пахотно-Угловское, Бондарское, Тамбовская область
    _1_6_20_3='16:20:3' # Янтыковское, Лаишевское, Республика Татарстан (Татарстан)
    _1_6_20_2='16:20:2' # Пестречинское, Лаишевское, Республика Татарстан (Татарстан)
    _1_6_20_1='16:20:1' # Лаишевское, Лаишевское, Республика Татарстан (Татарстан)
    _2_6_10_2='26:10:2' # Невинномысское, Невинномысское, Ставропольский край
    _2_6_10_1='26:10:1' # Курсавское, Невинномысское, Ставропольский край
    _6_6_1_10='66:1:10' # Ясашинское, Алапаевское, Свердловская область
    _5_0_6_3='50:6:3' # Егорьевское, Егорьевское, Московская область
    _3_8_5_1='38:5:1' # Кондратьевское, Бирюсинское, Иркутская область
    _5_0_6_4='50:6:4' # Егорьевское сельское, Егорьевское, Московская область
    _5_0_6_5='50:6:5' # Куплиямское, Егорьевское, Московская область
    _7_2_5_8='72:5:8' # Ушаковское, Вагайское, Тюменская область
    _5_0_6_6='50:6:6' # Лелеческое, Егорьевское, Московская область
    _7_2_5_9='72:5:9' # Черноковское, Вагайское, Тюменская область
    _5_0_6_7='50:6:7' # Пешурское, Егорьевское, Московская область
    _7_2_5_6='72:5:6' # Первомайское, Вагайское, Тюменская область
    _5_0_6_8='50:6:8' # Поминовское, Егорьевское, Московская область
    _7_2_5_7='72:5:7' # Супринское, Вагайское, Тюменская область
    _5_0_6_9='50:6:9' # Пригородное, Егорьевское, Московская область
    _7_2_5_4='72:5:4' # Карагайское, Вагайское, Тюменская область
    _7_2_5_5='72:5:5' # Комсомольское, Вагайское, Тюменская область
    _2_5_7_12='25:7:12' # Углекаменское, Сергеевское, Приморский край
    _2_5_7_11='25:7:11' # Тигровское, Сергеевское, Приморский край
    _2_5_7_10='25:7:10' # Серебрянское, Сергеевское, Приморский край
    _2_5_7_15='25:7:15' # Чистоводное, Сергеевское, Приморский край
    _2_5_7_14='25:7:14' # Чернорученское, Сергеевское, Приморский край
    _3_8_5_2='38:5:2' # Шелаевское, Бирюсинское, Иркутская область
    _2_5_7_13='25:7:13' # Фроловское, Сергеевское, Приморский край
    _7_2_5_2='72:5:2' # Вагайское сельское, Вагайское, Тюменская область
    _7_2_5_3='72:5:3' # Дубровинское, Вагайское, Тюменская область
    _7_2_5_1='72:5:1' # Вагайское, Вагайское, Тюменская область
    _5_0_6_1='50:6:1' # Больше-Гридинское, Егорьевское, Московская область
    _5_0_6_2='50:6:2' # Восточное, Егорьевское, Московская область
    _7_2_1='7:2:1' # Зольское, Зольское, Кабардино-Балкарская Республика
    _7_2_2='7:2:2' # Малкинское, Зольское, Кабардино-Балкарская Республика
    _3_34_2='3:34:2' # Делакорское, Уоянское, Республика Бурятия
    _3_34_3='3:34:3' # Уоянское, Уоянское, Республика Бурятия
    _3_34_4='3:34:4' # Чильчигирское, Уоянское, Республика Бурятия
    _6_7_7_3='67:7:3' # Духовщинское, Духовщинское, Смоленская область
    _6_7_7_2='67:7:2' # Вишенское, Духовщинское, Смоленская область
    _6_7_7_1='67:7:1' # Бересневское, Духовщинское, Смоленская область
    _6_7_7_7='67:7:7' # Трунаевское, Духовщинское, Смоленская область
    _6_7_7_6='67:7:6' # Плотковское, Духовщинское, Смоленская область
    _6_7_7_5='67:7:5' # Озерненское, Духовщинское, Смоленская область
    _6_7_7_4='67:7:4' # Духовщинское сельское, Духовщинское, Смоленская область
    _4_4_6_1='44:6:1' # 1-е Ильинское, Кологривское, Костромская область
    _5_9_19_2='59:19:2' # Крыловское, Осинское, Пермский край
    _5_9_19_3='59:19:3' # Осинское, Осинское, Пермский край
    _5_9_19_1='59:19:1' # Беляевское, Осинское, Пермский край
    _4_4_6_5='44:6:5' # Кологривское, Кологривское, Костромская область
    _4_4_6_4='44:6:4' # Илешевское, Кологривское, Костромская область
    _4_4_6_3='44:6:3' # Варзенгское, Кологривское, Костромская область
    _4_4_6_2='44:6:2' # 2-е Ильинское, Кологривское, Костромская область
    _4_4_6_8='44:6:8' # Ужугское, Кологривское, Костромская область
    _4_4_6_7='44:6:7' # Понговское, Кологривское, Костромская область
    _4_4_6_6='44:6:6' # Октябрьское, Кологривское, Костромская область
    _5_9_19_4='59:19:4' # Частинское, Осинское, Пермский край
    _3_3_10_9='33:10:9' # Осиповское, Ковровское, Владимирская область
    _3_3_10_6='33:10:6' # Ковровское, Ковровское, Владимирская область
    _3_3_10_5='33:10:5' # Клязьмогородецкое, Ковровское, Владимирская область
    _3_3_10_8='33:10:8' # Мелеховское, Ковровское, Владимирская область
    _3_3_10_7='33:10:7' # Красномаяковское, Ковровское, Владимирская область
    _3_3_10_2='33:10:2' # Ивановское, Ковровское, Владимирская область
    _3_3_10_1='33:10:1' # Великовское, Ковровское, Владимирская область
    _3_3_10_4='33:10:4' # Клязьменское, Ковровское, Владимирская область
    _3_3_10_3='33:10:3' # Ивановское 1-е, Ковровское, Владимирская область
    _3_34_1='3:34:1' # Верхне-Ангарское, Уоянское, Республика Бурятия
    _2_1_4_5='21:4:5' # Янтиковское, Канашское, Чувашская Республика - Чувашия
    _2_1_4_4='21:4:4' # Шихранское, Канашское, Чувашская Республика - Чувашия
    _2_1_4_3='21:4:3' # Тобурдановское, Канашское, Чувашская Республика - Чувашия
    _2_1_4_2='21:4:2' # Комсомольское, Канашское, Чувашская Республика - Чувашия
    _2_1_4_1='21:4:1' # Канашское, Канашское, Чувашская Республика - Чувашия
    _2_9_20_5='29:20:5' # Ундозерское, Приозерное, Архангельская область
    _2_9_20_6='29:20:6' # Янгорское, Приозерное, Архангельская область
    _2_9_20_1='29:20:1' # Кенозерское, Приозерное, Архангельская область
    _2_9_20_2='29:20:2' # Коневское, Приозерное, Архангельская область
    _2_9_20_3='29:20:3' # Лелемское, Приозерное, Архангельская область
    _2_9_20_4='29:20:4' # Самковское, Приозерное, Архангельская область
    _3_21_3='3:21:3' # Хуртэйское, Кудунское, Республика Бурятия
    _3_21_2='3:21:2' # Нижне-Чесанское, Кудунское, Республика Бурятия
    _3_21_1='3:21:1' # Михайловское, Кудунское, Республика Бурятия
    _7_4_12_4='74:12:4' # Уфимское, Кыштымское, Челябинская область
    _7_4_12_3='74:12:3' # Кыштымское, Кыштымское, Челябинская область
    _7_4_12_2='74:12:2' # Карабашское, Кыштымское, Челябинская область
    _7_4_12_1='74:12:1' # Егозинское, Кыштымское, Челябинская область
    _3_21_4='3:21:4' # Чесанское, Кудунское, Республика Бурятия
    _1_5_3_3='15:3:3' # Урсдонское, Дигорское, Республика Северная Осетия - Алания
    _1_5_3_2='15:3:2' # Красногорское, Дигорское, Республика Северная Осетия - Алания
    _1_5_3_1='15:3:1' # Дур-Дурское, Дигорское, Республика Северная Осетия - Алания
    _4_2_13_6='42:13:6' # Шалымское, Таштагольское, Кемеровская область
    _4_2_13_4='42:13:4' # Темиртаусское, Таштагольское, Кемеровская область
    _4_2_13_5='42:13:5' # Чугунашское, Таштагольское, Кемеровская область
    _4_2_13_2='42:13:2' # Кабырзинское, Таштагольское, Кемеровская область
    _4_2_13_3='42:13:3' # Таштагольское, Таштагольское, Кемеровская область
    _4_2_13_1='42:13:1' # Алтамашское, Таштагольское, Кемеровская область
    _2_6_7_1='26:7:1' # Кисловодское, Кисловодское, Ставропольский край
    _3_3_2_2='33:2:2' # Воровское, Андреевское, Владимирская область
    _3_3_2_3='33:2:3' # Жуковское, Андреевское, Владимирская область
    _3_3_2_4='33:2:4' # Краснобогатырское, Андреевское, Владимирская область
    _3_3_2_5='33:2:5' # Мошокское, Андреевское, Владимирская область
    _3_3_2_6='33:2:6' # Муромцевское, Андреевское, Владимирская область
    _3_3_2_7='33:2:7' # Судогодское, Андреевское, Владимирская область
    _3_3_2_8='33:2:8' # Языковское, Андреевское, Владимирская область
    _3_3_2_1='33:2:1' # Андреевское, Андреевское, Владимирская область
    _2_0_10_1='20:10:1' # Аргунское, Предгорное, Чеченская Республика
    _2_0_10_2='20:10:2' # Предгорное, Предгорное, Чеченская Республика
    _5_2_35_2='52:35:2' # Железнодорожное, Шахунское районное, Нижегородская область
    _5_2_35_1='52:35:1' # Вахтанское, Шахунское районное, Нижегородская область
    _5_2_35_4='52:35:4' # Сявское, Шахунское районное, Нижегородская область
    _5_2_35_3='52:35:3' # Полетаевское, Шахунское районное, Нижегородская область
    _5_2_35_6='52:35:6' # Шахунское, Шахунское районное, Нижегородская область
    _5_2_35_5='52:35:5' # Хмелевицкое, Шахунское районное, Нижегородская область
    _6_2_4_1='62:4:1' # Белозерское, Касимовское, Рязанская область
    _6_2_4_3='62:4:3' # Елатомское, Касимовское, Рязанская область
    _6_2_4_2='62:4:2' # Долговское, Касимовское, Рязанская область
    _6_2_4_5='62:4:5' # Сосновское, Касимовское, Рязанская область
    _6_2_4_4='62:4:4' # Пригородное, Касимовское, Рязанская область
    _6_2_4_6='62:4:6' # Токаревское, Касимовское, Рязанская область
    _5_0_14_12='50:14:12' # Орехово-Зуевское сельское, Орехово-Зуевское, Московская область
    _5_0_14_11='50:14:11' # Ликинское, Орехово-Зуевское, Московская область
    _5_0_14_14='50:14:14' # Яковлевское, Орехово-Зуевское, Московская область
    _5_0_14_13='50:14:13' # Северное, Орехово-Зуевское, Московская область
    _5_0_14_10='50:14:10' # Куровское, Орехово-Зуевское, Московская область
    _5_6_3_1='56:3:1' # Акбулакское, Акбулакское, Оренбургская область
    _6_2_13_5='62:13:5' # Октябрьское, Сасовское, Рязанская область
    _6_2_13_4='62:13:4' # Никольское, Сасовское, Рязанская область
    _6_2_13_3='62:13:3' # Кустаревское, Сасовское, Рязанская область
    _6_2_13_2='62:13:2' # Кадомское, Сасовское, Рязанская область
    _6_2_13_8='62:13:8' # Щедринское, Сасовское, Рязанская область
    _6_2_13_7='62:13:7' # Салтыковское, Сасовское, Рязанская область
    _6_2_13_6='62:13:6' # Пителинское, Сасовское, Рязанская область
    _1_8_18_1='18:18:1' # Головизинское, Селтинское, Удмуртская Республика
    _1_8_18_3='18:18:3' # Нозинское, Селтинское, Удмуртская Республика
    _1_8_18_2='18:18:2' # Копкинское, Селтинское, Удмуртская Республика
    _6_2_13_1='62:13:1' # Батьковское, Сасовское, Рязанская область
    _1_8_18_4='18:18:4' # Сардыкское, Селтинское, Удмуртская Республика
    _2_6_3_3='26:3:3' # Петровское, Дивенское, Ставропольский край
    _2_6_3_4='26:3:4' # Туркменское, Дивенское, Ставропольский край
    _2_6_3_1='26:3:1' # Дивенское, Дивенское, Ставропольский край
    _2_6_3_2='26:3:2' # Ипатовское, Дивенское, Ставропольский край
    _7_2_6_3='72:6:3' # Таволжанское, Викуловское, Тюменская область
    _6_8_11_1='68:11:1' # Бригадирское, Хоботовское, Тамбовская область
    _4_7_9_13='47:9:13' # Тервеничское, Лодейнопольское, Ленинградская область
    _4_7_9_14='47:9:14' # Шапшинское, Лодейнопольское, Ленинградская область
    _4_7_9_11='47:9:11' # Свирское сельское, Лодейнопольское, Ленинградская область
    _4_7_9_12='47:9:12' # Тененское, Лодейнопольское, Ленинградская область
    _4_7_9_15='47:9:15' # Шоткусское, Лодейнопольское, Ленинградская область
    _4_7_9_16='47:9:16' # Яровщинское, Лодейнопольское, Ленинградская область
    _7_2_6_1='72:6:1' # Викуловское, Викуловское, Тюменская область
    _6_8_11_2='68:11:2' # Иловайское, Хоботовское, Тамбовская область
    _7_2_6_2='72:6:2' # Викуловское сельское, Викуловское, Тюменская область
    _6_8_11_3='68:11:3' # Ранинское, Хоботовское, Тамбовская область
    _4_7_9_10='47:9:10' # Свирское, Лодейнопольское, Ленинградская область
    _4_9_6_3='49:6:3' # Ясачинское, Сеймчанское, Магаданская область
    _4_9_6_1='49:6:1' # Коркодонское, Сеймчанское, Магаданская область
    _4_9_6_2='49:6:2' # Сеймчанское, Сеймчанское, Магаданская область
    _5_5_8_2='55:8:2' # Любинское, Любинское, Омская область
    _5_5_8_3='55:8:3' # Любинское сельское, Любинское, Омская область
    _5_5_8_1='55:8:1' # Алексеевское, Любинское, Омская область
    _5_5_8_8='55:8:8' # Шербакульское, Любинское, Омская область
    _5_5_8_9='55:8:9' # Шербакульское сельское, Любинское, Омская область
    _5_5_8_6='55:8:6' # Одесское, Любинское, Омская область
    _5_5_8_7='55:8:7' # Одесское сельское, Любинское, Омская область
    _5_5_8_4='55:8:4' # Марьяновское, Любинское, Омская область
    _5_5_8_5='55:8:5' # Марьяновское сельское, Любинское, Омская область
    _4_4_3_4='44:3:4' # Заветлужское, Вохомское, Костромская область
    _4_4_3_3='44:3:3' # Вохомское, Вохомское, Костромская область
    _4_4_3_2='44:3:2' # 2-е Семёновское, Вохомское, Костромская область
    _4_4_3_1='44:3:1' # 1-е Семёновское, Вохомское, Костромская область
    _4_4_3_8='44:3:8' # Пеномское, Вохомское, Костромская область
    _4_4_3_7='44:3:7' # Нюрюгское, Вохомское, Костромская область
    _4_4_3_6='44:3:6' # Крутогорское, Вохомское, Костромская область
    _4_4_3_5='44:3:5' # Красноборское, Вохомское, Костромская область
    _4_4_3_9='44:3:9' # Центральное, Вохомское, Костромская область
    _2_1_4='2:1:4' # Кирдасовское, Абзелиловское, Республика Башкортостан
    _2_1_3='2:1:3' # Казмашевское, Абзелиловское, Республика Башкортостан
    _2_1_2='2:1:2' # Бурангуловское, Абзелиловское, Республика Башкортостан
    _2_1_1='2:1:1' # Абзелиловское сельское, Абзелиловское, Республика Башкортостан
    _2_1_6='2:1:6' # Хамитовское, Абзелиловское, Республика Башкортостан
    _2_1_5='2:1:5' # Кусимовское, Абзелиловское, Республика Башкортостан
    _7_4_21_7='74:21:7' # Уйское, Чебаркульское, Челябинская область
    _7_4_21_6='74:21:6' # Травниковское, Чебаркульское, Челябинская область
    _3_6_11_2='36:11:2' # Новоусманское, Новоусманское, Воронежская область
    _3_6_11_1='36:11:1' # Гремяченское, Новоусманское, Воронежская область
    _7_4_21_1='74:21:1' # Бишкильское, Чебаркульское, Челябинская область
    _7_5_19_1='75:19:1' # Балягинское, Петровск-Забайкальское, Забайкальский край
    _7_5_19_2='75:19:2' # Катангарское, Петровск-Забайкальское, Забайкальский край
    _7_4_21_5='74:21:5' # Ларинское, Чебаркульское, Челябинская область
    _7_5_19_3='75:19:3' # Малетинское, Петровск-Забайкальское, Забайкальский край
    _7_4_21_4='74:21:4' # Кундравинское, Чебаркульское, Челябинская область
    _7_5_19_4='75:19:4' # Новопавловское, Петровск-Забайкальское, Забайкальский край
    _7_4_21_3='74:21:3' # Кумлякское, Чебаркульское, Челябинская область
    _7_5_19_5='75:19:5' # Петровск-Забайкальское, Петровск-Забайкальское, Забайкальский край
    _7_4_21_2='74:21:2' # Варламовское, Чебаркульское, Челябинская область
    _3_6_11_4='36:11:4' # Яблоченское, Новоусманское, Воронежская область
    _3_6_11_3='36:11:3' # Хохольское, Новоусманское, Воронежская область
    _3_7_8_1='37:8:1' # Дуляпинское, Фурмановское, Ивановская область
    _2_3_14_4='23:14:4' # Шаумянское, Пшишское, Краснодарский край
    _3_7_8_3='37:8:3' # Приволжское сельское, Фурмановское, Ивановская область
    _2_3_14_3='23:14:3' # Навагинское, Пшишское, Краснодарский край
    _3_7_8_2='37:8:2' # Плесское, Фурмановское, Ивановская область
    _2_3_14_2='23:14:2' # Гунайское, Пшишское, Краснодарский край
    _3_7_8_5='37:8:5' # Фурмановское, Фурмановское, Ивановская область
    _2_3_14_1='23:14:1' # Гойтхское, Пшишское, Краснодарский край
    _3_7_8_4='37:8:4' # Середское, Фурмановское, Ивановская область
    _3_7_8_7='37:8:7' # Яковлевское, Фурмановское, Ивановская область
    _3_7_8_6='37:8:6' # Фурмановское сельское, Фурмановское, Ивановская область
    _2_8_11_15='28:11:15' # Утугайское, Тындинское, Амурская область
    _2_8_11_16='28:11:16' # Хорогочинское, Тындинское, Амурская область
    _2_8_11_13='28:11:13' # Урканское, Тындинское, Амурская область
    _2_8_11_14='28:11:14' # Уркиминское, Тындинское, Амурская область
    _3_3_13_7='33:13:7' # Приклонское, Меленковское, Владимирская область
    _3_3_13_6='33:13:6' # Пичугинское, Меленковское, Владимирская область
    _3_3_13_8='33:13:8' # Тургеневское, Меленковское, Владимирская область
    _3_3_13_3='33:13:3' # Каменское, Меленковское, Владимирская область
    _3_3_13_2='33:13:2' # Илькинское, Меленковское, Владимирская область
    _3_3_13_5='33:13:5' # Меленковское, Меленковское, Владимирская область
    _3_3_13_4='33:13:4' # Ляховское, Меленковское, Владимирская область
    _2_8_11_11='28:11:11' # Тындинское, Тындинское, Амурская область
    _2_8_11_12='28:11:12' # Унахинское, Тындинское, Амурская область
    _3_3_13_1='33:13:1' # Бутылицкое, Меленковское, Владимирская область
    _2_8_11_10='28:11:10' # Соловьёвское, Тындинское, Амурская область
    _7_5_19_6='75:19:6' # Толбагинское, Петровск-Забайкальское, Забайкальский край
    _7_5_19_7='75:19:7' # Хохотуйское, Петровск-Забайкальское, Забайкальский край
    _6_1_11_1='61:11:1' # Манычское, Сальское, Ростовская область
    _6_1_11_2='61:11:2' # Пролетарское, Сальское, Ростовская область
    _2_7_29_1='27:29:1' # Верхне-Сукпайское, Сукпайское, Хабаровский край
    _2_7_29_3='27:29:3' # Сукпайское, Сукпайское, Хабаровский край
    _6_1_11_3='61:11:3' # Сальское, Сальское, Ростовская область
    _2_7_29_2='27:29:2' # Горное, Сукпайское, Хабаровский край
    _5_0_5_4='50:5:4' # Деденевское, Дмитровское, Московская область
    _5_0_5_5='50:5:5' # Дмитровское, Дмитровское, Московская область
    _5_0_5_6='50:5:6' # Дмитровское сельское, Дмитровское, Московская область
    _5_0_5_7='50:5:7' # Дутшевское, Дмитровское, Московская область
    _5_0_5_8='50:5:8' # Костинское, Дмитровское, Московская область
    _5_0_5_9='50:5:9' # Лобненское, Дмитровское, Московская область
    _5_0_5_1='50:5:1' # Вербилковское, Дмитровское, Московская область
    _5_0_5_2='50:5:2' # Гарское, Дмитровское, Московская область
    _5_0_5_3='50:5:3' # Гришинское, Дмитровское, Московская область
    _1_4_4_2='14:4:2' # Верхоянское, Верхоянское, Республика Саха (Якутия)
    _1_4_4_1='14:4:1' # Батагайское, Верхоянское, Республика Саха (Якутия)
    _1_4_4_4='14:4:4' # Эвено-Бытантайское, Верхоянское, Республика Саха (Якутия)
    _1_4_4_3='14:4:3' # Депутатское, Верхоянское, Республика Саха (Якутия)
    _2_7_28_2='27:28:2' # Харпинское, Солнечное, Хабаровский край
    _2_7_28_1='27:28:1' # Солнечное, Солнечное, Хабаровский край
    _2_7_28_3='27:28:3' # Хурмулинское, Солнечное, Хабаровский край
    _4_3_9_1='43:9:1' # Кикнурское, Кикнурское, Кировская область
    _4_3_9_3='43:9:3' # Кокшагское, Кикнурское, Кировская область
    _4_3_9_2='43:9:2' # Кикнурское сельское, Кикнурское, Кировская область
    _4_3_9_4='43:9:4' # Русско-Краинское, Кикнурское, Кировская область
    _2_0_15_2='20:15:2' # Бурунное, Шелковское, Чеченская Республика
    _2_0_15_3='20:15:3' # Каргалинское, Шелковское, Чеченская Республика
    _2_0_15_4='20:15:4' # Червленское, Шелковское, Чеченская Республика
    _2_0_15_5='20:15:5' # Шелковское, Шелковское, Чеченская Республика
    _5_2_29_3='52:29:3' # Пелеговское, Сокольское районное, Нижегородская область
    _5_2_29_2='52:29:2' # Каргинское, Сокольское районное, Нижегородская область
    _1_8_19_2='18:19:2' # Зонское, Сюмсинское, Удмуртская Республика
    _5_2_29_5='52:29:5' # Унженское, Сокольское районное, Нижегородская область
    _1_8_19_1='18:19:1' # Гуринское, Сюмсинское, Удмуртская Республика
    _5_2_29_4='52:29:4' # Сокольское, Сокольское районное, Нижегородская область
    _1_8_19_4='18:19:4' # Пумсинское, Сюмсинское, Удмуртская Республика
    _1_8_19_3='18:19:3' # Кильмезское, Сюмсинское, Удмуртская Республика
    _5_2_29_1='52:29:1' # Ильинское, Сокольское районное, Нижегородская область
    _2_0_15_1='20:15:1' # Бороздиновское, Шелковское, Чеченская Республика
    _5_6_16_4='56:16:4' # Орское, Орское, Оренбургская область
    _1_4_19_2='14:19:2' # Таттинское, Таттинское, Республика Саха (Якутия)
    _1_4_19_1='14:19:1' # Алексеевское, Таттинское, Республика Саха (Якутия)
    _5_6_16_1='56:16:1' # Ириклинское, Орское, Оренбургская область
    _5_6_16_2='56:16:2' # Красноуральское, Орское, Оренбургская область
    _5_6_16_3='56:16:3' # Новотроицкое, Орское, Оренбургская область
    _2_0_7_2='20:7:2' # Курчалойское, Курчалойское, Чеченская Республика
    _2_0_7_1='20:7:1' # Аллеройское, Курчалойское, Чеченская Республика
    _7_1_10_3='71:10:3' # Щегловское, Тульское, Тульская область
    _7_1_10_4='71:10:4' # Яснополянское, Тульское, Тульская область
    _2_7_15_3='27:15:3' # Городское, Комсомольское, Хабаровский край
    _2_7_15_4='27:15:4' # Хурбинское, Комсомольское, Хабаровский край
    _2_7_15_1='27:15:1' # Бокторское, Комсомольское, Хабаровский край
    _7_1_10_1='71:10:1' # Беломутовское, Тульское, Тульская область
    _2_7_15_2='27:15:2' # Галичное, Комсомольское, Хабаровский край
    _7_1_10_2='71:10:2' # Ленинское, Тульское, Тульская область
    _7_4_22_7='74:22:7' # Смолинское, Шершневское, Челябинская область
    _7_4_22_6='74:22:6' # Кременкульское, Шершневское, Челябинская область
    _7_4_22_5='74:22:5' # Каратабанское, Шершневское, Челябинская область
    _3_6_12_1='36:12:1' # Горело-Ольховское, Новохоперское, Воронежская область
    _1_1_19_4='11:19:4' # Нюмыдское, Пруптское, Республика Коми
    _1_1_19_3='11:19:3' # Крутоборское, Пруптское, Республика Коми
    _7_4_22_4='74:22:4' # Еткульское, Шершневское, Челябинская область
    _1_1_19_2='11:19:2' # Климовское, Пруптское, Республика Коми
    _7_4_22_3='74:22:3' # Еманжелинское, Шершневское, Челябинская область
    _1_1_19_1='11:19:1' # Вочевское, Пруптское, Республика Коми
    _7_4_22_2='74:22:2' # Долгодеревенское, Шершневское, Челябинская область
    _7_4_22_1='74:22:1' # Белоусовское, Шершневское, Челябинская область
    _3_6_12_3='36:12:3' # Степное, Новохоперское, Воронежская область
    _3_6_12_2='36:12:2' # Новохоперское, Новохоперское, Воронежская область
    _5_2_16_1='52:16:1' # Кстовское, Кстовское районное, Нижегородская область
    _5_2_16_2='52:16:2' # Пригородное, Кстовское районное, Нижегородская область
    _5_2_16_3='52:16:3' # Работкинское, Кстовское районное, Нижегородская область
    _3_8_1_4='38:1:4' # Приморское, Аларское, Иркутская область
    _3_8_1_3='38:1:3' # Заречное, Аларское, Иркутская область
    _3_8_1_2='38:1:2' # Алятское, Аларское, Иркутская область
    _3_8_1_1='38:1:1' # Аларское, Аларское, Иркутская область
    _3_31_1='3:31:1' # Байкальское, Северо-Байкальское, Республика Бурятия
    _3_31_2='3:31:2' # Верхне-Заимское, Северо-Байкальское, Республика Бурятия
    _3_31_3='3:31:3' # Прибайкальское, Северо-Байкальское, Республика Бурятия
    _3_31_4='3:31:4' # Северо-Байкальское, Северо-Байкальское, Республика Бурятия
    _6_5_12_1='65:12:1' # Буюкловское, Смирныховское, Сахалинская область
    _6_5_12_3='65:12:3' # Первомайское, Смирныховское, Сахалинская область
    _6_5_12_2='65:12:2' # Онорское, Смирныховское, Сахалинская область
    _6_5_12_5='65:12:5' # Смирныховское, Смирныховское, Сахалинская область
    _6_5_12_4='65:12:4' # Пограничное, Смирныховское, Сахалинская область
    _2_2_30_6='22:30:6' # Тополинское, Чарышское, Алтайский край
    _2_2_30_5='22:30:5' # Степное, Чарышское, Алтайский край
    _2_2_30_4='22:30:4' # Солонешенское, Чарышское, Алтайский край
    _2_2_30_3='22:30:3' # Мало-Бащелакское, Чарышское, Алтайский край
    _5_2_29_6='52:29:6' # Шомохтинское, Сокольское районное, Нижегородская область
    _2_2_30_7='22:30:7' # Чарышское, Чарышское, Алтайский край
    _2_2_30_2='22:30:2' # Кумирское, Чарышское, Алтайский край
    _2_2_30_1='22:30:1' # Больше-Бащелакское, Чарышское, Алтайский край
    _2_4_17_4='24:17:4' # Саянское, Ермаковское, Красноярский край
    _2_4_17_5='24:17:5' # Танзыбейское, Ермаковское, Красноярский край
    _2_4_17_1='24:17:1' # Большереченское, Ермаковское, Красноярский край
    _2_4_17_2='24:17:2' # Ермаковское, Ермаковское, Красноярский край
    _2_4_17_3='24:17:3' # Ермаковское сельское, Ермаковское, Красноярский край
    _6_7_6_4='67:6:4' # Быковское, Дорогобужское, Смоленская область
    _6_7_6_3='67:6:3' # Болдинское, Дорогобужское, Смоленская область
    _6_7_6_2='67:6:2' # Алексинское сельское, Дорогобужское, Смоленская область
    _6_7_6_1='67:6:1' # Алексинское, Дорогобужское, Смоленская область
    _6_7_6_7='67:6:7' # Старо-Смоленское, Дорогобужское, Смоленская область
    _6_7_6_6='67:6:6' # Осьмянское, Дорогобужское, Смоленская область
    _6_7_6_5='67:6:5' # Дорогобужское, Дорогобужское, Смоленская область
    _5_9_16_3='59:16:3' # Ординское, Кунгурское, Пермский край
    _5_9_16_4='59:16:4' # Пермско-Сергинское, Кунгурское, Пермский край
    _5_9_16_1='59:16:1' # Калининское, Кунгурское, Пермский край
    _5_9_16_2='59:16:2' # Кунгурское, Кунгурское, Пермский край
    _5_6_2_1='56:2:1' # Адамовское, Адамовское, Оренбургская область
    _3_31_5='3:31:5' # Язовкинское, Северо-Байкальское, Республика Бурятия
    _2_1_1_6='21:1:6' # Шумское, Алатырское, Чувашская Республика - Чувашия
    _2_1_1_5='21:1:5' # Соловьёвское, Алатырское, Чувашская Республика - Чувашия
    _2_1_1_4='21:1:4' # Пригородное, Алатырское, Чувашская Республика - Чувашия
    _3_2_5_2='32:5:2' # Дятьковское, Дятьковское, Брянская область
    _2_1_1_3='21:1:3' # Первомайское, Алатырское, Чувашская Республика - Чувашия
    _3_2_5_3='32:5:3' # Ивотское, Дятьковское, Брянская область
    _2_1_1_2='21:1:2' # Безднинское, Алатырское, Чувашская Республика - Чувашия
    _2_1_1_1='21:1:1' # Айбесинское, Алатырское, Чувашская Республика - Чувашия
    _3_2_5_1='32:5:1' # Бытошское, Дятьковское, Брянская область
    _3_2_5_4='32:5:4' # Старское, Дятьковское, Брянская область
    _3_2_5_5='32:5:5' # Стеклянно-Радицкое, Дятьковское, Брянская область
    _1_9_7_4='19:7:4' # Юферовское, Горячегорское, Республика Хакасия
    _1_9_7_3='19:7:3' # Полуторнинское, Горячегорское, Республика Хакасия
    _1_9_7_2='19:7:2' # Парнинское, Горячегорское, Республика Хакасия
    _1_9_7_1='19:7:1' # Горячегорское, Горячегорское, Республика Хакасия
    _6_2_14_4='62:14:4' # Переделецкое, Солотчинское, Рязанская область
    _6_2_14_3='62:14:3' # Мурминское, Солотчинское, Рязанская область
    _6_2_14_2='62:14:2' # Деулинское, Солотчинское, Рязанская область
    _6_2_14_1='62:14:1' # Борисковское, Солотчинское, Рязанская область
    _6_2_14_6='62:14:6' # Солотчинское, Солотчинское, Рязанская область
    _6_2_14_5='62:14:5' # Полковское, Солотчинское, Рязанская область
    _7_3_1='7:3:1' # Аргуданское, Лескенское, Кабардино-Балкарская Республика
    _7_3_4='7:3:4' # Черно-Реченское, Лескенское, Кабардино-Балкарская Республика
    _4_7_14_20='47:14:20' # Яблоневское, Приозерское, Ленинградская область
    _7_3_2='7:3:2' # Верхне-Лескенское, Лескенское, Кабардино-Балкарская Республика
    _7_3_3='7:3:3' # Старо-Лескенское, Лескенское, Кабардино-Балкарская Республика
    _4_7_14_18='47:14:18' # Приозерское южное, Приозерское, Ленинградская область
    _4_7_14_17='47:14:17' # Приозерское, Приозерское, Ленинградская область
    _4_7_14_16='47:14:16' # Некрасовское, Приозерское, Ленинградская область
    _4_7_14_15='47:14:15' # Мичуринское северное, Приозерское, Ленинградская область
    _4_7_14_14='47:14:14' # Мичуринское, Приозерское, Ленинградская область
    _4_7_14_13='47:14:13' # Ларионовское, Приозерское, Ленинградская область
    _4_7_14_12='47:14:12' # Ладожское южное, Приозерское, Ленинградская область
    _9_1_1_2='91:1:2' # Запрудненское, Алуштинское, Республика Крым
    _4_7_14_11='47:14:11' # Ладожское, Приозерское, Ленинградская область
    _9_1_1_1='91:1:1' # Алуштинское, Алуштинское, Республика Крым
    _9_1_1_3='91:1:3' # Солнечногорское, Алуштинское, Республика Крым
    _4_7_14_19='47:14:19' # Сосновское, Приозерское, Ленинградская область
    _4_7_14_10='47:14:10' # Кучеровское, Приозерское, Ленинградская область
    _6_2_3_2='62:3:2' # Луговое, Ермишинское, Рязанская область
    _6_2_3_1='62:3:1' # Ермишинское, Ермишинское, Рязанская область
    _6_2_3_4='62:3:4' # Некрасовское, Ермишинское, Рязанская область
    _6_2_3_3='62:3:3' # Мердушинское, Ермишинское, Рязанская область
    _6_2_3_5='62:3:5' # Октябрьское, Ермишинское, Рязанская область
    _5_0_4_5='50:4:5' # Красногорское, Волоколамское, Московская область
    _5_0_4_6='50:4:6' # Лотошинское, Волоколамское, Московская область
    _5_0_4_7='50:4:7' # Микулинское, Волоколамское, Московская область
    _5_0_4_8='50:4:8' # Ново-Александровское, Волоколамское, Московская область
    _5_0_4_9='50:4:9' # Осташевское, Волоколамское, Московская область
    _7_2_7_4='72:7:4' # Ражевское, Голышмановское, Тюменская область
    _7_2_7_2='72:7:2' # Голышмановское сельское, Голышмановское, Тюменская область
    _7_2_7_3='72:7:3' # Малышенское, Голышмановское, Тюменская область
    _7_2_7_1='72:7:1' # Голышмановское, Голышмановское, Тюменская область
    _5_0_4_1='50:4:1' # Аннинское, Волоколамское, Московская область
    _5_0_4_2='50:4:2' # Введенское, Волоколамское, Московская область
    _5_0_4_3='50:4:3' # Волоколамское, Волоколамское, Московская область
    _5_0_4_4='50:4:4' # Волоколамское сельское, Волоколамское, Московская область
    _2_6_4_1='26:4:1' # Ессентукское, Ессентукское, Ставропольский край
    _5_5_7_3='55:7:3' # Крутинское сельское, Крутинское, Омская область
    _5_5_7_4='55:7:4' # Шипуновское, Крутинское, Омская область
    _5_5_7_1='55:7:1' # Ировское, Крутинское, Омская область
    _5_5_7_2='55:7:2' # Крутинское, Крутинское, Омская область
    _4_9_7_2='49:7:2' # Кулинское, Тенькинское, Магаданская область
    _4_9_7_3='49:7:3' # Тенькинское, Тенькинское, Магаданская область
    _4_9_7_1='49:7:1' # Детринское, Тенькинское, Магаданская область
    _6_1_9_2='61:9:2' # Ремонтненское, Ремонтненское, Ростовская область
    _6_1_9_1='61:9:1' # Заветинское, Ремонтненское, Ростовская область
    _3_7_9_7='37:9:7' # Шуйское сельское, Шуйское, Ивановская область
    _2_4_18_3='24:18:3' # Идринское сельское, Идринское, Красноярский край
    _2_4_18_4='24:18:4' # Козинское, Идринское, Красноярский край
    _2_4_18_1='24:18:1' # Екатерининское, Идринское, Красноярский край
    _2_4_18_2='24:18:2' # Идринское, Идринское, Красноярский край
    _2_3_13_5='23:13:5' # Шесхарисское, Новороссийское, Краснодарский край
    _3_7_9_2='37:9:2' # Воскресенское, Шуйское, Ивановская область
    _2_3_13_4='23:13:4' # Гостагаевское, Новороссийское, Краснодарский край
    _3_7_9_1='37:9:1' # Васильевское, Шуйское, Ивановская область
    _2_3_13_3='23:13:3' # Верхне-Баканское, Новороссийское, Краснодарский край
    _3_7_9_4='37:9:4' # Савинское сельское, Шуйское, Ивановская область
    _2_3_13_2='23:13:2' # Анапское, Новороссийское, Краснодарский край
    _3_7_9_3='37:9:3' # Савинское, Шуйское, Ивановская область
    _2_3_13_1='23:13:1' # Абраусское, Новороссийское, Краснодарский край
    _3_7_9_6='37:9:6' # Шуйское, Шуйское, Ивановская область
    _3_7_9_5='37:9:5' # Тезинское, Шуйское, Ивановская область
    _7_3_1_3='73:1:3' # Должниковское, Базарносызганское, Ульяновская область
    _7_3_1_4='73:1:4' # Неклюдовское, Базарносызганское, Ульяновская область
    _7_3_1_5='73:1:5' # Папузинское, Базарносызганское, Ульяновская область
    _7_3_1_1='73:1:1' # Базарносызганское, Базарносызганское, Ульяновская область
    _7_3_1_2='73:1:2' # Годяйкинское, Базарносызганское, Ульяновская область
    _2_2_3='2:2:3' # Кагинское, Авзянское, Республика Башкортостан
    _2_2_2='2:2:2' # Зигазинское, Авзянское, Республика Башкортостан
    _2_2_1='2:2:1' # Авзянское, Авзянское, Республика Башкортостан
    _2_2_5='2:2:5' # Узянское, Авзянское, Республика Башкортостан
    _2_2_4='2:2:4' # Туканское, Авзянское, Республика Башкортостан
    _6_1_10_2='61:10:2' # Песчаное, Романовское, Ростовская область
    _6_1_10_3='61:10:3' # Приморское, Романовское, Ростовская область
    _6_1_10_1='61:10:1' # Волгодонское, Романовское, Ростовская область
    _6_1_10_4='61:10:4' # Рябичевское, Романовское, Ростовская область
    _6_1_10_5='61:10:5' # Цимлянское, Романовское, Ростовская область
    _6_8_12_1='68:12:1' # Отъясское, Цнинское, Тамбовская область
    _6_8_12_2='68:12:2' # Перкинское, Цнинское, Тамбовская область
    _6_8_12_3='68:12:3' # Семикинское, Цнинское, Тамбовская область
    _4_4_4_3='44:4:3' # Галичское, Галичское, Костромская область
    _4_4_4_2='44:4:2' # Вексинское, Галичское, Костромская область
    _4_4_4_1='44:4:1' # Березовское, Галичское, Костромская область
    _4_4_4_7='44:4:7' # Пригородное, Галичское, Костромская область
    _4_4_4_6='44:4:6' # Ореховское, Галичское, Костромская область
    _4_4_4_5='44:4:5' # Лопарёвское, Галичское, Костромская область
    _4_4_4_4='44:4:4' # Заозёрное, Галичское, Костромская область
    _4_4_4_9='44:4:9' # Рылеевское, Галичское, Костромская область
    _1_6_31_1='16:31:1' # Казанкинское, Черемшанское, Республика Татарстан (Татарстан)
    _4_4_4_8='44:4:8' # Пронинское, Галичское, Костромская область
    _1_6_31_2='16:31:2' # Светлогорское, Черемшанское, Республика Татарстан (Татарстан)
    _1_6_31_3='16:31:3' # Шешминское второе, Черемшанское, Республика Татарстан (Татарстан)
    _3_3_12_8='33:12:8' # Купреевское, Курловское, Владимирская область
    _3_3_12_7='33:12:7' # Крюковское, Курловское, Владимирская область
    _3_3_12_9='33:12:9' # Лесниковское, Курловское, Владимирская область
    _3_3_12_4='33:12:4' # Долбинское, Курловское, Владимирская область
    _3_3_12_3='33:12:3' # Володарское, Курловское, Владимирская область
    _3_3_12_6='33:12:6' # Краснооктябрьское, Курловское, Владимирская область
    _3_3_12_5='33:12:5' # Золотковское, Курловское, Владимирская область
    _3_3_12_2='33:12:2' # Великодворское, Курловское, Владимирская область
    _3_3_12_1='33:12:1' # Аксеновское, Курловское, Владимирская область
    _5_6_17_1='56:17:1' # Курманаевское, Первомайское, Оренбургская область
    _5_6_17_2='56:17:2' # Первомайское, Первомайское, Оренбургская область
    _2_0_8_1='20:8:1' # Надтеречное, Наурское, Чеченская Республика
    _2_0_8_3='20:8:3' # Савельевское, Наурское, Чеченская Республика
    _2_0_8_2='20:8:2' # Наурское, Наурское, Чеченская Республика
    _2_0_8_4='20:8:4' # Степное, Наурское, Чеченская Республика
    _6_2_2_1='62:2:1' # Веряевское, Ерахтурское, Рязанская область
    _6_2_2_3='62:2:3' # Комсомольское, Ерахтурское, Рязанская область
    _6_2_2_2='62:2:2' # Ерахтурское, Ерахтурское, Рязанская область
    _6_2_2_4='62:2:4' # Увязское, Ерахтурское, Рязанская область
    _5_0_9_20='50:9:20' # Сходненское, Клинское, Московская область
    _5_0_9_21='50:9:21' # Усагинское, Клинское, Московская область
    _2_7_27_3='27:27:3' # Коппинское, Советское, Хабаровский край
    _2_7_27_2='27:27:2' # Гроссевичское, Советское, Хабаровский край
    _1_1_18_7='11:18:7' # Спаспорубское, Прилузское, Республика Коми
    _2_7_27_1='27:27:1' # Городское, Советское, Хабаровский край
    _1_1_18_6='11:18:6' # Объячевское, Прилузское, Республика Коми
    _1_1_18_5='11:18:5' # Ношульское, Прилузское, Республика Коми
    _1_1_18_4='11:18:4' # Матяшское, Прилузское, Республика Коми
    _1_1_18_3='11:18:3' # Лопьинское, Прилузское, Республика Коми
    _2_7_27_5='27:27:5' # Совгаванское, Советское, Хабаровский край
    _1_1_18_2='11:18:2' # Лоемское, Прилузское, Республика Коми
    _2_7_27_4='27:27:4' # Нельминское, Советское, Хабаровский край
    _1_1_18_1='11:18:1' # Занульское, Прилузское, Республика Коми
    _5_0_9_19='50:9:19' # Сенежское, Клинское, Московская область
    _5_0_9_17='50:9:17' # Первомайское, Клинское, Московская область
    _5_0_9_18='50:9:18' # Поваровское, Клинское, Московская область
    _5_0_9_15='50:9:15' # Озерецкое, Клинское, Московская область
    _5_0_9_16='50:9:16' # Октябрьское, Клинское, Московская область
    _5_0_9_13='50:9:13' # Новинское, Клинское, Московская область
    _5_0_9_14='50:9:14' # Нудольское, Клинское, Московская область
    _5_0_9_11='50:9:11' # Круговское, Клинское, Московская область
    _5_0_9_12='50:9:12' # Крюковское, Клинское, Московская область
    _3_8_2_2='38:2:2' # Ушаковское, Ангарское, Иркутская область
    _3_8_2_1='38:2:1' # Тальцинское, Ангарское, Иркутская область
    _1_4_18_1='14:18:1' # Сунтарское, Сунтарское, Республика Саха (Якутия)
    _1_4_18_2='14:18:2' # Эльгяйское, Сунтарское, Республика Саха (Якутия)
    _7_2_19_2='72:19:2' # Емуртлинское, Упоровское, Тюменская область
    _7_2_19_1='72:19:1' # Буньковское, Упоровское, Тюменская область
    _3_32_4='3:32:4' # Чикойское, Селенгинское, Республика Бурятия
    _5_0_9_10='50:9:10' # Краснохолмское, Клинское, Московская область
    _2_7_14_4='27:14:4' # Чильбинское, Кизинское, Хабаровский край
    _2_7_14_2='27:14:2' # Кизинское, Кизинское, Хабаровский край
    _2_7_14_3='27:14:3' # Мариинское, Кизинское, Хабаровский край
    _7_2_19_4='72:19:4' # Упоровское сельское, Упоровское, Тюменская область
    _6_7_5_5='67:5:5' # Заборьевское, Демидовское, Смоленская область
    _7_2_19_3='72:19:3' # Суерское, Упоровское, Тюменская область
    _6_7_5_4='67:5:4' # Дубровское, Демидовское, Смоленская область
    _6_7_5_3='67:5:3' # Демидовское, Демидовское, Смоленская область
    _6_7_5_2='67:5:2' # Булыжское, Демидовское, Смоленская область
    _6_7_5_1='67:5:1' # Акатовское, Демидовское, Смоленская область
    _2_7_14_1='27:14:1' # Булавинское, Кизинское, Хабаровский край
    _6_7_5_6='67:5:6' # Леханов-Борское, Демидовское, Смоленская область
    _5_9_17_4='59:17:4' # Шаквинское, Лысьвенское, Пермский край
    _6_1_8_3='61:8:3' # Чернышевское, Обливское, Ростовская область
    _6_1_8_2='61:8:2' # Обливское, Обливское, Ростовская область
    _5_9_17_2='59:17:2' # Кыновское, Лысьвенское, Пермский край
    _6_1_8_1='61:8:1' # Морозовское, Обливское, Ростовская область
    _5_9_17_3='59:17:3' # Соинское, Лысьвенское, Пермский край
    _5_9_17_1='59:17:1' # Кормовищенское, Лысьвенское, Пермский край
    _3_6_13_4='36:13:4' # Репьевское, Острогожское, Воронежская область
    _3_6_13_3='36:13:3' # Острогожское, Острогожское, Воронежская область
    _3_6_13_2='36:13:2' # Коротоякское, Острогожское, Воронежская область
    _3_6_13_1='36:13:1' # Евдаковское, Острогожское, Воронежская область
    _3_32_1='3:32:1' # Новоселенгинское, Селенгинское, Республика Бурятия
    _3_32_2='3:32:2' # Селенгинское, Селенгинское, Республика Бурятия
    _3_32_3='3:32:3' # Селенгинское сельское, Селенгинское, Республика Бурятия
    _5_2_28_4='52:28:4' # Сеченовское, Сергачское межрайонное, Нижегородская область
    _5_2_28_3='52:28:3' # Сергачское, Сергачское межрайонное, Нижегородская область
    _5_2_28_5='52:28:5' # Спасское, Сергачское межрайонное, Нижегородская область
    _5_2_28_2='52:28:2' # Пильненское, Сергачское межрайонное, Нижегородская область
    _5_2_28_1='52:28:1' # Княжегорское, Сергачское межрайонное, Нижегородская область
    _2_1_2_3='21:2:3' # Калининское, Вурнарское, Чувашская Республика - Чувашия
    _2_1_2_2='21:2:2' # Вурнарское, Вурнарское, Чувашская Республика - Чувашия
    _2_1_2_1='21:2:1' # Авруйское, Вурнарское, Чувашская Республика - Чувашия
    _1_9_6_1='19:6:1' # Боградское, Боградское, Республика Хакасия
    _1_9_6_2='19:6:2' # Сонское, Боградское, Республика Хакасия
    _5_6_1_1='56:1:1' # Абдулинское, Абдулинское, Оренбургская область
    _5_6_1_2='56:1:2' # Матвеевское, Абдулинское, Оренбургская область
    _5_2_15_5='52:15:5' # Кирилловское, Краснобаковское районное, Нижегородская область
    _1_7_10_3='17:10:3' # Хайыраканское, Шагонарское, Республика Тыва
    _5_2_15_6='52:15:6' # Моисеевское, Краснобаковское районное, Нижегородская область
    _5_2_15_7='52:15:7' # Носовское, Краснобаковское районное, Нижегородская область
    _5_2_15_8='52:15:8' # Сабельное, Краснобаковское районное, Нижегородская область
    _5_2_15_1='52:15:1' # Баковское, Краснобаковское районное, Нижегородская область
    _5_2_15_2='52:15:2' # Боровское, Краснобаковское районное, Нижегородская область
    _5_2_15_3='52:15:3' # Быструхинское, Краснобаковское районное, Нижегородская область
    _1_7_10_1='17:10:1' # Ак-Дуругское, Шагонарское, Республика Тыва
    _5_2_15_4='52:15:4' # Ветлужское, Краснобаковское районное, Нижегородская область
    _1_7_10_2='17:10:2' # Арыг-Узунское, Шагонарское, Республика Тыва
    _5_2_15_9='52:15:9' # Шеманихинское, Краснобаковское районное, Нижегородская область
    _6_2_15_3='62:15:3' # Кудомское, Спасское, Рязанская область
    _6_2_15_2='62:15:2' # Комсомольское, Спасское, Рязанская область
    _6_2_15_1='62:15:1' # Ижевское, Спасское, Рязанская область
    _6_2_15_5='62:15:5' # Тонинское, Спасское, Рязанская область
    _6_2_15_4='62:15:4' # Павловское, Спасское, Рязанская область
    _6_5_11_2='65:11:2' # Леонидовское, Поронайское, Сахалинская область
    _6_5_11_1='65:11:1' # Гастелловское, Поронайское, Сахалинская область
    _6_5_11_4='65:11:4' # Трудовое, Поронайское, Сахалинская область
    _6_5_11_3='65:11:3' # Лермонтовское, Поронайское, Сахалинская область
    _7_4_3='7:4:3' # Солдатское, Майское, Кабардино-Балкарская Республика
    _7_4_1='7:4:1' # Майское, Майское, Кабардино-Балкарская Республика
    _7_4_2='7:4:2' # Прохладненское, Майское, Кабардино-Балкарская Республика
    _2_6_5_1='26:5:1' # Григорополисское, Изобильненское, Ставропольский край
    _2_6_5_2='26:5:2' # Изобильненское, Изобильненское, Ставропольский край
    _3_2_6_1='32:6:1' # Белоглавское, Жуковское, Брянская область
    _3_2_6_2='32:6:2' # Троснянское, Жуковское, Брянская область
    _3_2_6_3='32:6:3' # Фошнянское, Жуковское, Брянская область
    _4_9_4_3='49:4:3' # Тасканское, Оротуканское, Магаданская область
    _4_9_4_1='49:4:1' # Дебинское, Оротуканское, Магаданская область
    _4_9_4_2='49:4:2' # Оротуканское, Оротуканское, Магаданская область
    _5_0_3_6='50:3:6' # Дачное, Виноградовское, Московская область
    _5_0_3_7='50:3:7' # Загородное, Виноградовское, Московская область
    _5_0_3_8='50:3:8' # Ильинское, Виноградовское, Московская область
    _5_0_3_9='50:3:9' # Малаховское, Виноградовское, Московская область
    _5_0_3_1='50:3:1' # Бронницкое, Виноградовское, Московская область
    _5_0_3_2='50:3:2' # Виноградовское, Виноградовское, Московская область
    _5_0_3_3='50:3:3' # Виноградовское сельское, Виноградовское, Московская область
    _5_0_3_4='50:3:4' # Воскресенское, Виноградовское, Московская область
    _5_0_3_5='50:3:5' # Гжельское, Виноградовское, Московская область
    _4_4_1_6='44:1:6' # Понизовское, Антроповское, Костромская область
    _4_4_1_5='44:1:5' # Палкинское, Антроповское, Костромская область
    _4_4_1_4='44:1:4' # Николо-Поломское, Антроповское, Костромская область
    _4_4_1_3='44:1:3' # Борское, Антроповское, Костромская область
    _4_4_1_7='44:1:7' # Шуйское, Антроповское, Костромская область
    _1_0_11_1='10:11:1' # Импилахтинское, Питкярантское, Республика Карелия
    _1_0_11_2='10:11:2' # Кивиойское, Питкярантское, Республика Карелия
    _2_6_1_1='26:1:1' # Бештаугорское, Бештаугорское, Ставропольский край
    _1_0_11_5='10:11:5' # Салминское, Питкярантское, Республика Карелия
    _2_6_1_2='26:1:2' # Минераловодское, Бештаугорское, Ставропольский край
    _1_0_11_6='10:11:6' # Тулемское, Питкярантское, Республика Карелия
    _1_0_11_3='10:11:3' # Ляскельское, Питкярантское, Республика Карелия
    _1_0_11_4='10:11:4' # Питкярантское, Питкярантское, Республика Карелия
    _4_4_1_2='44:1:2' # 2-е Антроповское, Антроповское, Костромская область
    _4_4_1_1='44:1:1' # 1-е Антроповское, Антроповское, Костромская область
    _7_2_8_5='72:8:5' # Падунское, Заводоуковское, Тюменская область
    _7_2_8_3='72:8:3' # Комиссаровское, Заводоуковское, Тюменская область
    _7_2_8_4='72:8:4' # Лебедевское, Заводоуковское, Тюменская область
    _7_2_8_1='72:8:1' # Боровинское, Заводоуковское, Тюменская область
    _7_2_8_2='72:8:2' # Заводоуковское сельское, Заводоуковское, Тюменская область
    _1_6_30_1='16:30:1' # Кляринское, Тетюшское, Республика Татарстан (Татарстан)
    _1_6_30_2='16:30:2' # Тархановское, Тетюшское, Республика Татарстан (Татарстан)
    _1_6_30_3='16:30:3' # Тетюшское, Тетюшское, Республика Татарстан (Татарстан)
    _1_6_30_4='16:30:4' # Урюмское, Тетюшское, Республика Татарстан (Татарстан)
    _4_3_17_9='43:17:9' # Староверческое, Мурашинское, Кировская область
    _3_3_15_5='33:15:5' # Ставровское, Собинское, Владимирская область
    _3_3_15_4='33:15:4' # Собинское, Собинское, Владимирская область
    _3_3_15_6='33:15:6' # Ундольское, Собинское, Владимирская область
    _3_3_15_1='33:15:1' # Березниковское, Собинское, Владимирская область
    _3_3_15_3='33:15:3' # Лакинское, Собинское, Владимирская область
    _3_3_15_2='33:15:2' # Березниковское сельское, Собинское, Владимирская область
    _1_4_7_1='14:7:1' # Булунское, Жиганское, Республика Саха (Якутия)
    _1_4_7_3='14:7:3' # Оленекское, Жиганское, Республика Саха (Якутия)
    _1_4_7_2='14:7:2' # Жиганское, Жиганское, Республика Саха (Якутия)
    _3_6_22_1='36:22:1' # Брагинское, Хреновское, Воронежская область
    _3_6_22_2='36:22:2' # Вислинское, Хреновское, Воронежская область
    _2_4_19_2='24:19:2' # Росляковское, Иланское, Красноярский край
    _2_4_19_3='24:19:3' # Северное, Иланское, Красноярский край
    _2_4_19_4='24:19:4' # Южное, Иланское, Красноярский край
    _2_4_19_1='24:19:1' # Иланское, Иланское, Красноярский край
    _6_7_4_5='67:4:5' # Кучеровское, Глинковское, Смоленская область
    _6_7_4_4='67:4:4' # Доброминское сельское, Глинковское, Смоленская область
    _6_7_4_3='67:4:3' # Доброминское, Глинковское, Смоленская область
    _6_7_4_2='67:4:2' # Глинковское, Глинковское, Смоленская область
    _6_7_4_1='67:4:1' # Болтутинское, Глинковское, Смоленская область
    _3_6_22_3='36:22:3' # Хреновское, Хреновское, Воронежская область
    _7_3_2_2='73:2:2' # Барышское, Барышское, Ульяновская область
    _7_3_2_3='73:2:3' # Жадовское, Барышское, Ульяновская область
    _7_3_2_4='73:2:4' # Живайкинское, Барышское, Ульяновская область
    _7_3_2_5='73:2:5' # Измайловское, Барышское, Ульяновская область
    _4_3_22_12='43:22:12' # Шабурское сельское, Опаринское, Кировская область
    _4_3_22_13='43:22:13' # Шадринское, Опаринское, Кировская область
    _7_3_2_1='73:2:1' # Акшуатское, Барышское, Ульяновская область
    _4_3_7_3='43:7:3' # Зуевское, Зуевское, Кировская область
    _4_3_7_2='43:7:2' # Дубовицкое, Зуевское, Кировская область
    _4_3_7_5='43:7:5' # Майское, Зуевское, Кировская область
    _4_3_7_4='43:7:4' # Зуевское сельское, Зуевское, Кировская область
    _7_3_2_6='73:2:6' # Конновское, Барышское, Ульяновская область
    _7_3_2_7='73:2:7' # Малохомутерское, Барышское, Ульяновская область
    _4_3_7_1='43:7:1' # Богородское, Зуевское, Кировская область
    _7_3_2_8='73:2:8' # Старотимошкинское, Барышское, Ульяновская область
    _7_3_2_9='73:2:9' # Сурское, Барышское, Ульяновская область
    _4_3_7_7='43:7:7' # Мухинское сельское, Зуевское, Кировская область
    _4_3_7_6='43:7:6' # Мухинское, Зуевское, Кировская область
    _4_3_7_9='43:7:9' # Талицкое сельское, Зуевское, Кировская область
    _4_3_7_8='43:7:8' # Сезеневское, Зуевское, Кировская область
    _2_7_18_1='27:18:1' # Дабандинское, Литовское, Хабаровский край
    _2_7_18_4='27:18:4' # Самболинское, Литовское, Хабаровский край
    _2_7_18_2='27:18:2' # Даргинское, Литовское, Хабаровский край
    _2_7_18_3='27:18:3' # Литовское, Литовское, Хабаровский край
    _4_3_22_10='43:22:10' # Речное, Опаринское, Кировская область
    _2_3_8='2:3:8' # Шафрановское, Альшеевское, Республика Башкортостан
    _4_3_22_11='43:22:11' # Центральное сельское, Опаринское, Кировская область
    _2_3_7='2:3:7' # Придемское, Альшеевское, Республика Башкортостан
    _2_3_2='2:3:2' # Альшеевское, Альшеевское, Республика Башкортостан
    _2_3_1='2:3:1' # Аксеновское, Альшеевское, Республика Башкортостан
    _2_3_6='2:3:6' # Миякинское, Альшеевское, Республика Башкортостан
    _2_3_5='2:3:5' # Миякибашевское, Альшеевское, Республика Башкортостан
    _2_3_4='2:3:4' # Давлекановское, Альшеевское, Республика Башкортостан
    _2_3_3='2:3:3' # Бик-Кармалинское, Альшеевское, Республика Башкортостан
    _7_5_17_1='75:17:1' # Елизаветинское, Оленгуйское, Забайкальский край
    _7_5_17_2='75:17:2' # Ленинское, Оленгуйское, Забайкальский край
    _7_5_17_3='75:17:3' # Маккавеевское, Оленгуйское, Забайкальский край
    _7_5_17_4='75:17:4' # Нижне-Оленгуйское, Оленгуйское, Забайкальский край
    _7_5_17_5='75:17:5' # Оленгуйское, Оленгуйское, Забайкальский край
    _7_1_12_1='71:12:1' # Иваньковское, Ясногорское, Тульская область
    _7_1_12_2='71:12:2' # Народное, Ясногорское, Тульская область
    _3_7_6_3='37:6:3' # Демидовское, Пучежское, Ивановская область
    _3_7_6_2='37:6:2' # Верхне-Ландеховское сельское, Пучежское, Ивановская область
    _2_3_12_6='23:12:6' # Соленовское, Мостовское, Краснодарский край
    _3_7_6_5='37:6:5' # Мытское, Пучежское, Ивановская область
    _2_3_12_5='23:12:5' # Псебайское, Мостовское, Краснодарский край
    _3_7_6_4='37:6:4' # Зарайское, Пучежское, Ивановская область
    _2_3_12_4='23:12:4' # Бугунджанское, Мостовское, Краснодарский край
    _3_7_6_7='37:6:7' # Пестяковское, Пучежское, Ивановская область
    _2_3_12_3='23:12:3' # Беноковское, Мостовское, Краснодарский край
    _3_7_6_6='37:6:6' # Нижне-Ландеховское, Пучежское, Ивановская область
    _2_3_12_2='23:12:2' # Баракаевское, Мостовское, Краснодарский край
    _3_7_6_9='37:6:9' # Пучежское, Пучежское, Ивановская область
    _2_3_12_1='23:12:1' # Баговское, Мостовское, Краснодарский край
    _3_7_6_8='37:6:8' # Пестяковское сельское, Пучежское, Ивановская область
    _3_7_6_1='37:6:1' # Верхне-Ландеховское, Пучежское, Ивановская область
    _1_9_9_2='19:9:2' # Орджоникидзевское, Саралинское, Республика Хакасия
    _1_9_9_1='19:9:1' # Костинское, Саралинское, Республика Хакасия
    _2_2_18_10='22:18:10' # Тополинское, Озеро-Кузнецовское, Алтайский край
    _2_2_18_11='22:18:11' # Угловское, Озеро-Кузнецовское, Алтайский край
    _2_2_18_12='22:18:12' # Угловское 2, Озеро-Кузнецовское, Алтайский край
    _2_2_18_13='22:18:13' # Шадринское, Озеро-Кузнецовское, Алтайский край
    _3_7_5_4='37:5:4' # Кинешемское сельское, Кинешемское, Ивановская область
    _3_7_5_3='37:5:3' # Кинешемское, Кинешемское, Ивановская область
    _3_7_5_6='37:5:6' # Нагорное, Кинешемское, Ивановская область
    _3_7_5_5='37:5:5' # Наволокское, Кинешемское, Ивановская область
    _3_7_5_8='37:5:8' # Шилекшинское, Кинешемское, Ивановская область
    _3_7_5_7='37:5:7' # Решемское, Кинешемское, Ивановская область
    _3_7_5_9='37:5:9' # Юрьевецкое сельское, Кинешемское, Ивановская область
    _1_9_9_3='19:9:3' # Саралинское, Саралинское, Республика Хакасия
    _6_5_14_1='65:14:1' # Бошняковское, Углегорское, Сахалинская область
    _3_7_5_2='37:5:2' # Жуковское, Кинешемское, Ивановская область
    _3_7_5_1='37:5:1' # Елнатское, Кинешемское, Ивановская область
    _6_5_14_2='65:14:2' # Углегорское, Углегорское, Сахалинская область
    _4_2_10_5='42:10:5' # Терсинское, Новокузнецкое, Кемеровская область
    _4_2_10_6='42:10:6' # Чистогривенское, Новокузнецкое, Кемеровская область
    _4_2_10_3='42:10:3' # Костенковское, Новокузнецкое, Кемеровская область
    _4_2_10_4='42:10:4' # Пригородное, Новокузнецкое, Кемеровская область
    _4_2_10_1='42:10:1' # Ерунаковское, Новокузнецкое, Кемеровская область
    _4_2_10_2='42:10:2' # Есаульское, Новокузнецкое, Кемеровская область
    _3_7_1_10='37:1:10' # Родниковское сельское, Вичугское, Ивановская область
    _3_7_1_11='37:1:11' # Сосновское, Вичугское, Ивановская область
    _3_7_1_12='37:1:12' # Филисовское, Вичугское, Ивановская область
    _6_2_1_2='62:1:2' # Былинское, Бельковское, Рязанская область
    _6_2_1_1='62:1:1' # Алексеевское, Бельковское, Рязанская область
    _6_2_1_4='62:1:4' # Гусевское, Бельковское, Рязанская область
    _6_2_1_3='62:1:3' # Гиблицкое, Бельковское, Рязанская область
    _6_2_1_6='62:1:6' # Чарусское, Бельковское, Рязанская область
    _6_2_1_5='62:1:5' # Озерное, Бельковское, Рязанская область
    _6_2_1_7='62:1:7' # Чаурское, Бельковское, Рязанская область
    _1_4_6_2='14:6:2' # Магарасское, Горное, Республика Саха (Якутия)
    _1_4_6_1='14:6:1' # Бердигестяхское, Горное, Республика Саха (Якутия)
    _6_1_7_1='61:7:1' # Мартыновское, Мартыновское, Ростовская область
    _3_6_23_1='36:23:1' # Панинское, Эртильское, Воронежская область
    _4_3_18_3='43:18:3' # Мулинское, Нагорское, Кировская область
    _4_3_18_2='43:18:2' # Заевское, Нагорское, Кировская область
    _4_3_18_1='43:18:1' # Верхневятское, Нагорское, Кировская область
    _4_3_18_7='43:18:7' # Федоровское, Нагорское, Кировская область
    _4_3_18_6='43:18:6' # Симоновское, Нагорское, Кировская область
    _4_3_18_5='43:18:5' # Николаевское сельское, Нагорское, Кировская область
    _4_3_18_4='43:18:4' # Николаевское, Нагорское, Кировская область
    _5_2_27_5='52:27:5' # Лыковское, Семеновское районное, Нижегородская область
    _5_2_27_4='52:27:4' # Лобачевское, Семеновское районное, Нижегородская область
    _5_2_27_7='52:27:7' # Семеновское, Семеновское районное, Нижегородская область
    _5_2_27_6='52:27:6' # Рыжковское, Семеновское районное, Нижегородская область
    _5_2_27_1='52:27:1' # Бараниховское, Семеновское районное, Нижегородская область
    _3_6_23_2='36:23:2' # Эртильское, Эртильское, Воронежская область
    _2_0_13_1='20:13:1' # Шаро-Аргунское, Шаройское, Чеченская Республика
    _2_0_13_2='20:13:2' # Шаройское, Шаройское, Чеченская Республика
    _5_2_27_3='52:27:3' # Линдовское, Семеновское районное, Нижегородская область
    _5_2_27_2='52:27:2' # Красно-Усадское, Семеновское районное, Нижегородская область
    _1_4_17_2='14:17:2' # Сангарское, Сангарское, Республика Саха (Якутия)
    _1_4_17_1='14:17:1' # Кобяйское, Сангарское, Республика Саха (Якутия)
    _4_3_18_8='43:18:8' # Шевырталовское сельское, Нагорское, Кировская область
    _2_0_5_2='20:5:2' # Гудермесское, Гудермесское, Чеченская Республика
    _2_0_5_1='20:5:1' # Горное, Гудермесское, Чеченская Республика
    _2_0_5_3='20:5:3' # Джалкинское, Гудермесское, Чеченская Республика
    _3_2_3_1='32:3:1' # Выгоничское, Выгоничское, Брянская область
    _3_2_3_4='32:3:4' # Полужское, Выгоничское, Брянская область
    _3_2_3_2='32:3:2' # Жирятинское, Выгоничское, Брянская область
    _3_2_3_3='32:3:3' # Краснорогское, Выгоничское, Брянская область
    _5_2_14_1='52:14:1' # Ильино-Заборское, Ковернинское районное, Нижегородская область
    _5_2_14_2='52:14:2' # Ковернинское, Ковернинское районное, Нижегородская область
    _5_2_14_3='52:14:3' # Наумовское, Ковернинское районное, Нижегородская область
    _5_2_14_4='52:14:4' # Узольское, Ковернинское районное, Нижегородская область
    _5_2_14_5='52:14:5' # Хохломское, Ковернинское районное, Нижегородская область
    _6_2_16_2='62:16:2' # Головановское, Тумское, Рязанская область
    _6_2_16_1='62:16:1' # Воронцовское, Тумское, Рязанская область
    _6_2_16_5='62:16:5' # Южно-Тумское, Тумское, Рязанская область
    _6_2_16_4='62:16:4' # Северо-Тумское, Тумское, Рязанская область
    _6_2_16_3='62:16:3' # Киряевское, Тумское, Рязанская область
    _5_2_27_9='52:27:9' # Хахальское, Семеновское районное, Нижегородская область
    _5_2_27_8='52:27:8' # Федосеевское, Семеновское районное, Нижегородская область
    _7_5_2='7:5:2' # Вольно-Аульское, Нальчикское, Кабардино-Балкарская Республика
    _7_5_3='7:5:3' # Каменское, Нальчикское, Кабардино-Балкарская Республика
    _7_5_1='7:5:1' # Белореченское, Нальчикское, Кабардино-Балкарская Республика
    _7_5_4='7:5:4' # Кенженское, Нальчикское, Кабардино-Балкарская Республика
    _7_5_5='7:5:5' # Урванское, Нальчикское, Кабардино-Балкарская Республика
    _9_1_3_2='91:3:2' # Новокленовское, Белогорское, Республика Крым
    _9_1_3_1='91:3:1' # Белогорское, Белогорское, Республика Крым
    _9_1_3_4='91:3:4' # Пристепное, Белогорское, Республика Крым
    _9_1_3_3='91:3:3' # Подгорное, Белогорское, Республика Крым
    _9_1_3_6='91:3:6' # Ущельное, Белогорское, Республика Крым
    _9_1_3_5='91:3:5' # Прияйлинское, Белогорское, Республика Крым
    _9_1_3_7='91:3:7' # Холодная гора, Белогорское, Республика Крым
    _5_5_6_4='55:6:4' # Калачинское сельское, Калачинское, Омская область
    _5_5_6_5='55:6:5' # Нижнеомское, Калачинское, Омская область
    _5_9_27_4='59:27:4' # Юрлинское, Юрлинское, Пермский край
    _5_5_6_2='55:6:2' # Горьковское сельское, Калачинское, Омская область
    _5_9_27_3='59:27:3' # Чусовское, Юрлинское, Пермский край
    _5_5_6_3='55:6:3' # Калачинское, Калачинское, Омская область
    _5_9_27_2='59:27:2' # Лопанское, Юрлинское, Пермский край
    _5_9_27_1='59:27:1' # Березовское, Юрлинское, Пермский край
    _5_5_6_1='55:6:1' # Горьковское, Калачинское, Омская область
    _5_5_6_6='55:6:6' # Нижнеомское сельское, Калачинское, Омская область
    _5_5_6_7='55:6:7' # Прииртышское, Калачинское, Омская область
    _5_9_14_5='59:14:5' # Кудымкарское, Кудымкарское, Пермский край
    _5_9_14_6='59:14:6' # Ошибское, Кудымкарское, Пермский край
    _5_9_14_3='59:14:3' # Визяйское, Кудымкарское, Пермский край
    _5_9_14_4='59:14:4' # Кувинское, Кудымкарское, Пермский край
    _5_9_14_1='59:14:1' # Верх-Иньвенское, Кудымкарское, Пермский край
    _5_9_14_2='59:14:2' # Верх-Юсьвинское, Кудымкарское, Пермский край
    _4_9_3_4='49:3:4' # Северо-Эвенское, Омсукчанское, Магаданская область
    _4_9_3_2='49:3:2' # Вилигинское, Омсукчанское, Магаданская область
    _4_9_3_3='49:3:3' # Омсукчанское, Омсукчанское, Магаданская область
    _4_9_3_1='49:3:1' # Верхне-Балыгычанское, Омсукчанское, Магаданская область
    _5_6_18_1='56:18:1' # Пономаревское, Пономаревское, Оренбургская область
    _2_5_8_1='25:8:1' # Бельцовское, Спасское, Приморский край
    _2_5_8_2='25:8:2' # Нововладимировское, Спасское, Приморский край
    _2_5_8_3='25:8:3' # Реттиховское, Спасское, Приморский край
    _2_5_8_4='25:8:4' # Свиягинское, Спасское, Приморский край
    _2_5_8_5='25:8:5' # Сибирцевское, Спасское, Приморский край
    _2_5_8_6='25:8:6' # Спасское, Спасское, Приморский край
    _2_5_8_7='25:8:7' # Спасское сельское, Спасское, Приморский край
    _2_5_8_8='25:8:8' # Черниговское, Спасское, Приморский край
    _6_8_10_1='68:10:1' # Жердевское, Уваровское, Тамбовская область
    _6_8_10_2='68:10:2' # Мучкапское, Уваровское, Тамбовская область
    _6_8_10_3='68:10:3' # Ржаксинское, Уваровское, Тамбовская область
    _6_8_10_4='68:10:4' # Уваровское, Уваровское, Тамбовская область
    _4_9_5_4='49:5:4' # Тальское, Палаткинское, Магаданская область
    _4_9_5_2='49:5:2' # Буюндинское, Палаткинское, Магаданская область
    _4_9_5_3='49:5:3' # Палаткинское, Палаткинское, Магаданская область
    _4_9_5_1='49:5:1' # Аткинское, Палаткинское, Магаданская область
    _5_0_2_7='50:2:7' # Можайское, Бородинское, Московская область
    _5_0_2_8='50:2:8' # Мокровское, Бородинское, Московская область
    _5_0_2_9='50:2:9' # Ново-Покровское, Бородинское, Московская область
    _7_2_9_4='72:9:4' # Южное, Исетское, Тюменская область
    _7_2_9_2='72:9:2' # Исетское, Исетское, Тюменская область
    _7_2_9_3='72:9:3' # Северо-Исетское, Исетское, Тюменская область
    _7_2_9_1='72:9:1' # Денисовское, Исетское, Тюменская область
    _5_0_2_1='50:2:1' # Борисовское, Бородинское, Московская область
    _5_0_2_2='50:2:2' # Бородинское сельское, Бородинское, Московская область
    _5_0_2_3='50:2:3' # Глазовское, Бородинское, Московская область
    _5_0_2_4='50:2:4' # Дровнинское, Бородинское, Московская область
    _5_0_2_5='50:2:5' # Ивакинское, Бородинское, Московская область
    _5_0_2_6='50:2:6' # Колоцкое, Бородинское, Московская область
    _7_7_1='7:7:1' # Лечинкаевское, Чегемское, Кабардино-Балкарская Республика
    _6_2_17_6='62:17:6' # Ямбирнское, Шацкое, Рязанская область
    _7_7_2='7:7:2' # Нижне-Чегемское, Чегемское, Кабардино-Балкарская Республика
    _7_7_3='7:7:3' # Чегемское, Чегемское, Кабардино-Балкарская Республика
    _2_6_2_2='26:2:2' # Кумское, Георгиевское, Ставропольский край
    _2_6_2_1='26:2:1' # Георгиевское, Георгиевское, Ставропольский край
    _6_2_17_1='62:17:1' # Бабакинское, Шацкое, Рязанская область
    _6_2_17_5='62:17:5' # Шацкое, Шацкое, Рязанская область
    _6_2_17_4='62:17:4' # Пролетарское, Шацкое, Рязанская область
    _6_2_17_3='62:17:3' # Подгорновское, Шацкое, Рязанская область
    _6_2_17_2='62:17:2' # Кермисинское, Шацкое, Рязанская область
    _7_4_20_2='74:20:2' # Иткульское, Уфалейское, Челябинская область
    _7_4_20_1='74:20:1' # Верхне-Уфалейское, Уфалейское, Челябинская область
    _7_4_20_5='74:20:5' # Ушатовское, Уфалейское, Челябинская область
    _7_4_20_4='74:20:4' # Нижне-Уфалейское, Уфалейское, Челябинская область
    _7_4_20_3='74:20:3' # Маукское, Уфалейское, Челябинская область
    _4_4_20_10='44:20:10' # Нижне-Вигское, Чухломское, Костромская область
    _6_7_3_7='67:3:7' # Самковское, Гагаринское, Смоленская область
    _6_7_3_6='67:3:6' # Мишинское, Гагаринское, Смоленская область
    _4_4_20_12='44:20:12' # Слудное, Чухломское, Костромская область
    _6_7_3_5='67:3:5' # Кармановское, Гагаринское, Смоленская область
    _4_4_20_11='44:20:11' # Нольское, Чухломское, Костромская область
    _6_7_3_4='67:3:4' # Гжатское, Гагаринское, Смоленская область
    _6_7_3_3='67:3:3' # Гагаринское, Гагаринское, Смоленская область
    _6_7_3_2='67:3:2' # Акатовское сельское, Гагаринское, Смоленская область
    _6_7_3_1='67:3:1' # Акатовское, Гагаринское, Смоленская область
    _6_7_3_8='67:3:8' # Самуйловское, Гагаринское, Смоленская область
    _4_4_2_5='44:2:5' # Ликургское, Буйское, Костромская область
    _4_4_2_4='44:2:4' # Куребринское, Буйское, Костромская область
    _4_4_2_3='44:2:3' # Колыбаевское, Буйское, Костромская область
    _4_4_2_2='44:2:2' # Заречное, Буйское, Костромская область
    _4_4_2_9='44:2:9' # Северное, Буйское, Костромская область
    _4_4_2_8='44:2:8' # Романцевское, Буйское, Костромская область
    _4_4_2_7='44:2:7' # Пригородное, Буйское, Костромская область
    _4_4_2_6='44:2:6' # Полдневское, Буйское, Костромская область
    _3_3_14_9='33:14:9' # Южное, Селивановское, Владимирская область
    _3_3_14_6='33:14:6' # Муромское, Селивановское, Владимирская область
    _3_3_14_5='33:14:5' # Малышевское, Селивановское, Владимирская область
    _3_3_14_8='33:14:8' # Чаадаевское, Селивановское, Владимирская область
    _3_3_14_7='33:14:7' # Селивановское, Селивановское, Владимирская область
    _3_3_14_2='33:14:2' # Качаловское, Селивановское, Владимирская область
    _3_3_14_1='33:14:1' # Заречное, Селивановское, Владимирская область
    _3_3_14_4='33:14:4' # Красногорбатское, Селивановское, Владимирская область
    _3_3_14_3='33:14:3' # Копнинское, Селивановское, Владимирская область
    _4_4_2_1='44:2:1' # Буйское, Буйское, Костромская область
    _3_7_7_9='37:7:9' # Тейковское сельское, Тейковское, Ивановская область
    _7_5_18_1='75:18:1' # Кубухайское, Ононское, Забайкальский край
    _7_5_18_2='75:18:2' # Цасучейское, Ононское, Забайкальский край
    _7_1_11_2='71:11:2' # Троицкое, Чернское, Тульская область
    _7_1_11_1='71:11:1' # Липицкое, Чернское, Тульская область
    _3_7_7_2='37:7:2' # Гаврилово-Посадское сельское, Тейковское, Ивановская область
    _3_7_7_1='37:7:1' # Березовское, Тейковское, Ивановская область
    _3_7_7_4='37:7:4' # Ленинское, Тейковское, Ивановская область
    _3_7_7_3='37:7:3' # Крапивновское, Тейковское, Ивановская область
    _3_7_7_6='37:7:6' # Нерльское, Тейковское, Ивановская область
    _3_7_7_5='37:7:5' # Мирославское, Тейковское, Ивановская область
    _2_3_11_3='23:11:3' # Отрадненское, Лабинское, Краснодарский край
    _3_7_7_8='37:7:8' # Тейковское, Тейковское, Ивановская область
    _2_3_11_2='23:11:2' # Ахметовское, Лабинское, Краснодарский край
    _3_7_7_7='37:7:7' # Петровское, Тейковское, Ивановская область
    _2_3_11_1='23:11:1' # Армавирское, Лабинское, Краснодарский край
    _3_5_7_11='35:7:11' # Уфтюгское, Вожегодское, Вологодская область
    _3_5_7_10='35:7:10' # Огибаловское, Вожегодское, Вологодская область
    _3_5_7_13='35:7:13' # Явенгское сельское, Вожегодское, Вологодская область
    _3_5_7_12='35:7:12' # Явенгское, Вожегодское, Вологодская область
    _7_3_3_1='73:3:1' # Вешкаймское, Вешкаймское, Ульяновская область
    _7_3_3_2='73:3:2' # Крутецкое, Вешкаймское, Ульяновская область
    _7_3_3_3='73:3:3' # Шарловское, Вешкаймское, Ульяновская область
    _2_7_17_1='27:17:1' # Лазаревское, Лазаревское, Хабаровский край
    _2_7_17_2='27:17:2' # Нигирьское, Лазаревское, Хабаровский край
    _2_7_17_3='27:17:3' # Нижне-Амурское, Лазаревское, Хабаровский край
    _2_4_8='2:4:8' # Уршакское, Архангельское, Республика Башкортостан
    _2_4_7='2:4:7' # Симское, Архангельское, Республика Башкортостан
    _2_4_6='2:4:6' # Лемезинское, Архангельское, Республика Башкортостан
    _2_4_1='2:4:1' # Архангельское, Архангельское, Республика Башкортостан
    _2_4_5='2:4:5' # Куртовское, Архангельское, Республика Башкортостан
    _2_4_4='2:4:4' # Камышлинское, Архангельское, Республика Башкортостан
    _2_4_3='2:4:3' # Бузовьязовское, Архангельское, Республика Башкортостан
    _2_4_2='2:4:2' # Басинское, Архангельское, Республика Башкортостан
    _2_7_16_2='27:16:2' # Куканское, Кур-Урмийское, Хабаровский край
    _2_7_16_3='27:16:3' # Талаканское, Кур-Урмийское, Хабаровский край
    _2_7_16_1='27:16:1' # Инское, Кур-Урмийское, Хабаровский край
    _2_7_16_4='27:16:4' # Урмийское, Кур-Урмийское, Хабаровский край
    _6_6_9_4='66:9:4' # Ивдельское, Ивдельское, Свердловская область
    _6_6_9_3='66:9:3' # Вижайское, Ивдельское, Свердловская область
    _6_6_9_6='66:9:6' # Лангурское, Ивдельское, Свердловская область
    _6_6_9_5='66:9:5' # Лаксийское, Ивдельское, Свердловская область
    _6_6_9_8='66:9:8' # Оусское, Ивдельское, Свердловская область
    _6_6_9_7='66:9:7' # Митяевское, Ивдельское, Свердловская область
    _6_6_9_9='66:9:9' # Пелымское, Ивдельское, Свердловская область
    _6_6_9_2='66:9:2' # Бурмантовское, Ивдельское, Свердловская область
    _6_6_9_1='66:9:1' # Атымское, Ивдельское, Свердловская область
    _4_3_8_2='43:8:2' # Кайское, Кайское, Кировская область
    _4_3_8_1='43:8:1' # Верхнекамское сельское, Кайское, Кировская область
    _4_3_8_4='43:8:4' # Лойнское, Кайское, Кировская область
    _4_3_8_3='43:8:3' # Камское, Кайское, Кировская область
    _4_3_8_6='43:8:6' # Чусовское, Кайское, Кировская область
    _6_1_6_2='61:6:2' # Киевское, Кашарское, Ростовская область
    _4_3_8_5='43:8:5' # Ожмеговское, Кайское, Кировская область
    _6_1_6_1='61:6:1' # Кашарское, Кашарское, Ростовская область
    _4_3_19_2='43:19:2' # Лобанское, Немское, Кировская область
    _4_3_19_1='43:19:1' # Архангельское сельское, Немское, Кировская область
    _4_3_19_6='43:19:6' # Чистопольское, Немское, Кировская область
    _4_3_19_5='43:19:5' # Осиновское, Немское, Кировская область
    _4_3_19_4='43:19:4' # Немское сельское, Немское, Кировская область
    _4_3_19_3='43:19:3' # Немское, Немское, Кировская область
    _2_0_14_1='20:14:1' # Борзойское, Шатойское, Чеченская Республика
    _2_0_14_2='20:14:2' # Шатойское, Шатойское, Чеченская Республика
    _2_0_6_1='20:6:1' # Итум-Калинское, Итум-Калинское, Чеченская Республика
    _2_0_6_2='20:6:2' # Тазбичинское, Итум-Калинское, Чеченская Республика
    _6_5_13_6='65:13:6' # Тымовское, Тымовское, Сахалинская область
    _6_5_13_5='65:13:5' # Тауланское, Тымовское, Сахалинская область
    _6_5_13_2='65:13:2' # Арги-Пагинское, Тымовское, Сахалинская область
    _6_5_13_1='65:13:1' # Адо-Тымовское, Тымовское, Сахалинская область
    _6_5_13_4='65:13:4' # Мало-Тымовское, Тымовское, Сахалинская область
    _6_5_13_3='65:13:3' # Верхне-Тымовское, Тымовское, Сахалинская область
    _1_4_16_3='14:16:3' # Токкинское, Олекминское, Республика Саха (Якутия)
    _1_4_16_2='14:16:2' # Олекминское, Олекминское, Республика Саха (Якутия)
    _1_4_16_5='14:16:5' # Урицкое, Олекминское, Республика Саха (Якутия)
    _1_4_16_4='14:16:4' # Торгинское, Олекминское, Республика Саха (Якутия)
    _1_4_16_1='14:16:1' # Нохтуйское, Олекминское, Республика Саха (Якутия)
    _7_6_1='7:6:1' # Терское, Терское, Кабардино-Балкарская Республика
    _7_6_2='7:6:2' # Урожайненское, Терское, Кабардино-Балкарская Республика
    _1_4_16_7='14:16:7' # Чаринское, Олекминское, Республика Саха (Якутия)
    _1_4_16_6='14:16:6' # Чапаевское, Олекминское, Республика Саха (Якутия)
    _5_5_5_5='55:5:5' # Полтавское, Исилькульское, Омская область
    _2_5_9_1='25:9:1' # Агзинское, Тернейское, Приморский край
    _5_9_28_4='59:28:4' # Юсьвинское, Юсьвинское, Пермский край
    _5_5_5_6='55:5:6' # Полтавское сельское, Исилькульское, Омская область
    _2_5_9_2='25:9:2' # Амгинское, Тернейское, Приморский край
    _5_9_28_3='59:28:3' # Тиминское, Юсьвинское, Пермский край
    _5_5_5_3='55:5:3' # Москаленское, Исилькульское, Омская область
    _2_5_9_3='25:9:3' # Малокемское, Тернейское, Приморский край
    _5_9_28_2='59:28:2' # Пожвинское, Юсьвинское, Пермский край
    _5_5_5_4='55:5:4' # Москаленское сельское, Исилькульское, Омская область
    _2_5_9_4='25:9:4' # Пластунское, Тернейское, Приморский край
    _5_9_28_1='59:28:1' # Купросское, Юсьвинское, Пермский край
    _5_5_5_1='55:5:1' # Исилькульское, Исилькульское, Омская область
    _2_5_9_5='25:9:5' # Самаргинское, Тернейское, Приморский край
    _5_5_5_2='55:5:2' # Исилькульское сельское, Исилькульское, Омская область
    _2_5_9_6='25:9:6' # Светлинское, Тернейское, Приморский край
    _2_5_9_7='25:9:7' # Тернейское, Тернейское, Приморский край
    _5_5_5_7='55:5:7' # Украинское, Исилькульское, Омская область
    _3_2_4_3='32:4:3' # Рогнединское, Дубровское, Брянская область
    _3_2_4_1='32:4:1' # Дубровское, Дубровское, Брянская область
    _3_2_4_2='32:4:2' # Олсуфьевское, Дубровское, Брянская область
    _3_5_16_10='35:16:10' # Нюксенское сельское, Нюксенское, Вологодская область
    _5_9_15_4='59:15:4' # Сарашевское, Куединское, Пермский край
    _5_9_15_2='59:15:2' # Куединское, Куединское, Пермский край
    _5_9_15_3='59:15:3' # Ошьинское, Куединское, Пермский край
    _5_9_15_1='59:15:1' # Бардымское, Куединское, Пермский край
    _1_0_10_2='10:10:2' # Видлицкое, Олонецкое, Республика Карелия
    _1_0_10_3='10:10:3' # Коткозерское, Олонецкое, Республика Карелия
    _1_0_10_1='10:10:1' # Верхне-Олонецкое, Олонецкое, Республика Карелия
    _1_0_10_6='10:10:6' # Михайловское, Олонецкое, Республика Карелия
    _1_0_10_7='10:10:7' # Обжанское, Олонецкое, Республика Карелия
    _1_0_10_4='10:10:4' # Кукшегорское, Олонецкое, Республика Карелия
    _1_0_10_5='10:10:5' # Мегрозерское, Олонецкое, Республика Карелия
    _1_0_10_8='10:10:8' # Олонецкое, Олонецкое, Республика Карелия
    _1_0_10_9='10:10:9' # Тулокское, Олонецкое, Республика Карелия
    _3_30_1='3:30:1' # Витимское, Романовское, Республика Бурятия
    _3_30_2='3:30:2' # Джилиндинское, Романовское, Республика Бурятия
    _3_30_3='3:30:3' # Кыджимитское, Романовское, Республика Бурятия
    _3_30_4='3:30:4' # Романовское, Романовское, Республика Бурятия
    _4_7_15_12='47:15:12' # Рябовское сельское, Рощинское, Ленинградская область
    _5_2_26_5='52:26:5' # Разинское, Разинское районное, Нижегородская область
    _4_7_15_13='47:15:13' # Советское, Рощинское, Ленинградская область
    _4_7_15_14='47:15:14' # Тарасовское, Рощинское, Ленинградская область
    _4_7_15_15='47:15:15' # Цвелодубовское, Рощинское, Ленинградская область
    _5_2_26_2='52:26:2' # Лукояновское, Разинское районное, Нижегородская область
    _4_7_15_16='47:15:16' # Чапаевское, Рощинское, Ленинградская область
    _5_2_26_1='52:26:1' # Кутумское, Разинское районное, Нижегородская область
    _4_7_15_17='47:15:17' # Черкасовское, Рощинское, Ленинградская область
    _5_2_26_4='52:26:4' # Печинское, Разинское районное, Нижегородская область
    _5_2_26_3='52:26:3' # Панзельское, Разинское районное, Нижегородская область
    _5_6_19_1='56:19:1' # Никольское, Сакмарское, Оренбургская область
    _5_6_19_2='56:19:2' # Октябрьское, Сакмарское, Оренбургская область
    _5_6_19_3='56:19:3' # Сакмарское, Сакмарское, Оренбургская область
    _4_7_15_10='47:15:10' # Приморское, Рощинское, Ленинградская область
    _4_7_15_11='47:15:11' # Рябовское, Рощинское, Ленинградская область
    _9_1_2_1='91:2:1' # Верхореченское, Бахчисарайское, Республика Крым
    _9_1_2_3='91:2:3' # Привольное, Бахчисарайское, Республика Крым
    _9_1_2_2='91:2:2' # Михайловское, Бахчисарайское, Республика Крым
    _1_9_8_2='19:8:2' # Хуторское, Копьевское, Республика Хакасия
    _1_9_8_1='19:8:1' # Копьевское, Копьевское, Республика Хакасия
    _5_2_13_1='52:13:1' # Дальнеконстантиновское, Дальнеконстантиновское районное, Нижегородская область
    _5_2_13_2='52:13:2' # Румстихинское, Дальнеконстантиновское районное, Нижегородская область
    _2_5_9_8='25:9:8' # Усть-Соболевское, Тернейское, Приморский край
    _5_2_13_3='52:13:3' # Суроватихинское, Дальнеконстантиновское районное, Нижегородская область
    _3_9_8_3='39:8:3' # Моховое, Славское, Калининградская область
    _3_9_8_2='39:8:2' # Заповедненское, Славское, Калининградская область
    _3_9_8_5='39:8:5' # Ясновское, Славское, Калининградская область
    _3_9_8_4='39:8:4' # Славское, Славское, Калининградская область
    _3_9_8_1='39:8:1' # Большаковское, Славское, Калининградская область
    _2_5_8='2:5:8' # Кунгаковское, Аскинское, Республика Башкортостан
    _2_5_7='2:5:7' # Ключевское, Аскинское, Республика Башкортостан
    _2_5_6='2:5:6' # Кашкинское, Аскинское, Республика Башкортостан
    _5_8_2_2='58:2:2' # Белинское-Аргамаковское, Белинское, Пензенская область
    _2_5_5='2:5:5' # Казанчинское, Аскинское, Республика Башкортостан
    _5_8_2_1='58:2:1' # Башмаковское, Белинское, Пензенская область
    _5_8_2_4='58:2:4' # Морозовское-Поимское, Белинское, Пензенская область
    _5_8_2_3='58:2:3' # Каменское-Свищевское, Белинское, Пензенская область
    _2_5_9='2:5:9' # Тюйское, Аскинское, Республика Башкортостан
    _2_5_4='2:5:4' # Верхне-Суянское, Аскинское, Республика Башкортостан
    _2_5_3='2:5:3' # Балтачевское сельское, Аскинское, Республика Башкортостан
    _2_5_2='2:5:2' # Балтачевское, Аскинское, Республика Башкортостан
    _2_5_1='2:5:1' # Аскинское сельское, Аскинское, Республика Башкортостан
    _7_5_15_7='75:15:7' # Тунгиро-Олёкминское, Могочинское, Забайкальский край
    _7_5_15_6='75:15:6' # Семиозёрное, Могочинское, Забайкальский край
    _7_5_15_5='75:15:5' # Сбегинское, Могочинское, Забайкальский край
    _7_5_15_4='75:15:4' # Могочинское, Могочинское, Забайкальский край
    _7_5_15_3='75:15:3' # Ксеньевское, Могочинское, Забайкальский край
    _7_5_15_2='75:15:2' # Давендинское, Могочинское, Забайкальский край
    _7_5_15_1='75:15:1' # Амазарское, Могочинское, Забайкальский край
    _3_4_5_6='34:5:6' # Штабное, Даниловское, Волгоградская область
    _3_4_5_5='34:5:5' # Сергиевское, Даниловское, Волгоградская область
    _3_4_5_4='34:5:4' # Островское, Даниловское, Волгоградская область
    _3_4_5_3='34:5:3' # Заполянское, Даниловское, Волгоградская область
    _3_4_5_2='34:5:2' # Даниловское сельское, Даниловское, Волгоградская область
    _3_4_5_1='34:5:1' # Берёзовское, Даниловское, Волгоградская область
    _6_2_18_5='62:18:5' # Чернореченское, Шелуховское, Рязанская область
    _7_8_3='7:8:3' # Суканское, Черекское, Кабардино-Балкарская Республика
    _7_8_4='7:8:4' # Черекское, Черекское, Кабардино-Балкарская Республика
    _7_8_1='7:8:1' # Герпегежское, Черекское, Кабардино-Балкарская Республика
    _7_8_2='7:8:2' # Жемталинское, Черекское, Кабардино-Балкарская Республика
    _2_20_3='2:20:3' # Кирзинское, Караидельское, Республика Башкортостан
    _2_20_2='2:20:2' # Караидельское, Караидельское, Республика Башкортостан
    _2_20_1='2:20:1' # Байкибашевское, Караидельское, Республика Башкортостан
    _6_4_4_3='64:4:3' # Плехановское, Балаковское, Саратовская область
    _6_4_4_2='64:4:2' # Духовницкое, Балаковское, Саратовская область
    _6_4_4_1='64:4:1' # Балаковское, Балаковское, Саратовская область
    _6_2_18_4='62:18:4' # Сапожковское, Шелуховское, Рязанская область
    _6_2_18_3='62:18:3' # Песоченское, Шелуховское, Рязанская область
    _6_2_18_2='62:18:2' # Красенское, Шелуховское, Рязанская область
    _6_2_18_1='62:18:1' # Кирицкое, Шелуховское, Рязанская область
    _3_18_6='3:18:6' # Тендитское, Кижингинское, Республика Бурятия
    _3_18_5='3:18:5' # Сулхаринское, Кижингинское, Республика Бурятия
    _3_18_4='3:18:4' # Нижне-Кудунское, Кижингинское, Республика Бурятия
    _4_0_7_4='40:7:4' # Шанско-Заводское, Износковское, Калужская область
    _3_18_3='3:18:3' # Леоновское, Кижингинское, Республика Бурятия
    _4_0_7_3='40:7:3' # Тюрмеровское, Износковское, Калужская область
    _3_18_2='3:18:2' # Кижингинское сельское, Кижингинское, Республика Бурятия
    _4_0_7_2='40:7:2' # Мятлевское, Износковское, Калужская область
    _3_18_1='3:18:1' # Кижингинское, Кижингинское, Республика Бурятия
    _4_0_7_1='40:7:1' # Износковское, Износковское, Калужская область
    _2_20_5='2:20:5' # Резимское, Караидельское, Республика Башкортостан
    _2_20_4='2:20:4' # Крушинское, Караидельское, Республика Башкортостан
    _1_1_2_1='11:2:1' # Вуктыльское, Вуктыльское, Республика Коми
    _1_1_2_5='11:2:5' # Усть-Войское, Вуктыльское, Республика Коми
    _1_1_2_4='11:2:4' # Подчерское, Вуктыльское, Республика Коми
    _1_1_2_3='11:2:3' # Лемтское, Вуктыльское, Республика Коми
    _1_1_2_2='11:2:2' # Дутовское, Вуктыльское, Республика Коми
    _1_1_2_7='11:2:7' # Щугерское, Вуктыльское, Республика Коми
    _1_1_2_6='11:2:6' # Шердинское, Вуктыльское, Республика Коми
    _5_7_8_1='57:8:1' # Володарское, Орловское, Орловская область
    _5_7_8_5='57:8:5' # Урицкое, Орловское, Орловская область
    _5_7_8_4='57:8:4' # Троснянское, Орловское, Орловская область
    _5_7_8_3='57:8:3' # Орловское, Орловское, Орловская область
    _5_7_8_2='57:8:2' # Кромское, Орловское, Орловская область
    _2_2_7_9='22:7:9' # Ярковское, Боровлянское, Алтайский край
    _2_2_7_7='22:7:7' # Червянское, Боровлянское, Алтайский край
    _7_0_6_3='70:6:3' # Чердатское, Зырянское, Томская область
    _2_2_7_8='22:7:8' # Южаковское, Боровлянское, Алтайский край
    _2_2_7_5='22:7:5' # Обское, Боровлянское, Алтайский край
    _7_0_6_1='70:6:1' # Зырянское, Зырянское, Томская область
    _2_2_7_6='22:7:6' # Чеканихинское, Боровлянское, Алтайский край
    _7_0_6_2='70:6:2' # Окунеевское, Зырянское, Томская область
    _2_2_7_3='22:7:3' # Зональное, Боровлянское, Алтайский край
    _5_5_18_4='55:18:4' # Скородумское, Усть-Ишимское, Омская область
    _2_2_7_4='22:7:4' # Клепиковское, Боровлянское, Алтайский край
    _5_5_18_3='55:18:3' # Большетавинское, Усть-Ишимское, Омская область
    _2_2_7_1='22:7:1' # Акутихинское, Боровлянское, Алтайский край
    _5_5_18_2='55:18:2' # Бакшеевское, Усть-Ишимское, Омская область
    _2_2_7_2='22:7:2' # Боровлянское, Боровлянское, Алтайский край
    _5_5_18_1='55:18:1' # Аксеновское, Усть-Ишимское, Омская область
    _5_5_18_6='55:18:6' # Усть-Ишимское сельское, Усть-Ишимское, Омская область
    _5_5_18_5='55:18:5' # Усть-Ишимское, Усть-Ишимское, Омская область
    _2_31_10='2:31:10' # Янаульское сельское, Янаульское, Республика Башкортостан
    _4_7_5_15='47:5:15' # Чащинское, Гатчинское, Ленинградская область
    _1_6_5_1='16:5:1' # Акташское, Альметьевское, Республика Татарстан (Татарстан)
    _1_6_5_3='16:5:3' # Миннибаевское, Альметьевское, Республика Татарстан (Татарстан)
    _1_6_5_2='16:5:2' # Кама-Исмагиловское, Альметьевское, Республика Татарстан (Татарстан)
    _1_6_5_4='16:5:4' # Поташно-Полянское, Альметьевское, Республика Татарстан (Татарстан)
    _6_5_17_2='65:17:2' # Южно-Сахалинское, Южно-Сахалинское, Сахалинская область
    _6_5_17_1='65:17:1' # Синегорское, Южно-Сахалинское, Сахалинская область
    _4_7_5_10='47:5:10' # Орлинское, Гатчинское, Ленинградская область
    _4_7_5_11='47:5:11' # Рылеевское, Гатчинское, Ленинградская область
    _4_7_5_12='47:5:12' # Слудицкое, Гатчинское, Ленинградская область
    _4_7_5_13='47:5:13' # Сусанинское, Гатчинское, Ленинградская область
    _4_7_5_14='47:5:14' # Таицкое, Гатчинское, Ленинградская область
    _2_4_26_6='24:26:6' # Чернореченское, Козульское, Красноярский край
    _2_4_26_2='24:26:2' # Козульское, Козульское, Красноярский край
    _2_4_26_3='24:26:3' # Козульское сельское, Козульское, Красноярский край
    _2_4_26_4='24:26:4' # Курбатовское, Козульское, Красноярский край
    _2_4_26_5='24:26:5' # Трудновское, Козульское, Красноярский край
    _2_3_1_2='23:1:2' # Шапсугское, Абинское, Краснодарский край
    _2_3_1_3='23:1:3' # Эриванское, Абинское, Краснодарский край
    _2_4_26_1='24:26:1' # Жуковское, Козульское, Красноярский край
    _2_3_1_1='23:1:1' # Холмское, Абинское, Краснодарский край
    _5_4_20_7='54:20:7' # Северный лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_6='54:20:6' # Ново-Троицкий лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_5='54:20:5' # Верх-Тартасский лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_4='54:20:4' # Верх-Красноярский лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_3='54:20:3' # Вагановский лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_2='54:20:2' # Биазинский лесохозяйственный участок, Северное, Новосибирская область
    _5_4_20_1='54:20:1' # Артымский лесохозяйственный участок, Северное, Новосибирская область
    _4_6_3_1='46:3:1' # Железногорское, Железногорское, Курская область
    _4_6_3_2='46:3:2' # Кармановское, Железногорское, Курская область
    _7_5_9_1='75:9:1' # Газимуро-Заводское, Газимуро-Заводское, Забайкальский край
    _7_5_9_2='75:9:2' # Кактолгинское, Газимуро-Заводское, Забайкальский край
    _7_5_9_3='75:9:3' # Курлеинское, Газимуро-Заводское, Забайкальский край
    _5_5_19_3='55:19:3' # Оконешниковское, Черлакское, Омская область
    _5_5_19_2='55:19:2' # Иртышское, Черлакское, Омская область
    _5_5_19_1='55:19:1' # Большеатмасское, Черлакское, Омская область
    _5_5_19_6='55:19:6' # Черлакское сельское, Черлакское, Омская область
    _5_5_19_5='55:19:5' # Черлакское, Черлакское, Омская область
    _5_5_19_4='55:19:4' # Оконешниковское сельское, Черлакское, Омская область
    _2_4_39_4='24:39:4' # Подтаежное, Новоселовское, Красноярский край
    _2_4_39_5='24:39:5' # Степное, Новоселовское, Красноярский край
    _2_7_37_4='27:37:4' # Мало-Чиркинское, Хехцирское, Хабаровский край
    _2_7_37_3='27:37:3' # Мало-Хехцирское, Хехцирское, Хабаровский край
    _2_4_39_1='24:39:1' # Анашенское, Новоселовское, Красноярский край
    _2_7_37_2='27:37:2' # Лесопарковое, Хехцирское, Хабаровский край
    _2_4_39_2='24:39:2' # Кульчекское, Новоселовское, Красноярский край
    _2_7_37_1='27:37:1' # Корфовское, Хехцирское, Хабаровский край
    _2_4_39_3='24:39:3' # Новоселовское, Новоселовское, Красноярский край
    _5_2_6_5='52:6:5' # Лапшангское, Варнавинское районное, Нижегородская область
    _5_2_6_6='52:6:6' # Сивкоборское, Варнавинское районное, Нижегородская область
    _5_2_6_7='52:6:7' # Хмелевское, Варнавинское районное, Нижегородская область
    _5_2_6_8='52:6:8' # Шудское, Варнавинское районное, Нижегородская область
    _5_2_6_1='52:6:1' # Варнавинское, Варнавинское районное, Нижегородская область
    _5_2_6_2='52:6:2' # Кайское, Варнавинское районное, Нижегородская область
    _5_2_6_3='52:6:3' # Каливецкое, Варнавинское районное, Нижегородская область
    _5_2_6_4='52:6:4' # Камешниковское, Варнавинское районное, Нижегородская область
    _5_0_8_14='50:8:14' # Химкинское, Истринское, Московская область
    _5_0_8_12='50:8:12' # Серебряноборское, Истринское, Московская область
    _5_0_8_13='50:8:13' # Филатовское, Истринское, Московская область
    _5_0_8_10='50:8:10' # Рождественское, Истринское, Московская область
    _5_0_8_11='50:8:11' # Савельевское, Истринское, Московская область
    _2_7_24_3='27:24:3' # Ульинское, Охотское, Хабаровский край
    _2_7_24_1='27:24:1' # Инское, Охотское, Хабаровский край
    _2_7_24_2='27:24:2' # Охотское, Охотское, Хабаровский край
    _3_4_11_1='34:11:1' # Каршевитское, Лещёвское, Волгоградская область
    _3_4_11_2='34:11:2' # Лещёвское, Лещёвское, Волгоградская область
    _1_4_15_2='14:15:2' # Нюрбинское, Нюрбинское, Республика Саха (Якутия)
    _1_4_15_1='14:15:1' # Мархинское, Нюрбинское, Республика Саха (Якутия)
    _7_2_16_1='72:16:1' # Байкаловское, Тобольское, Тюменская область
    _7_2_16_3='72:16:3' # Карачинское, Тобольское, Тюменская область
    _7_2_16_2='72:16:2' # Иртышское, Тобольское, Тюменская область
    _7_2_16_5='72:16:5' # Носкинское, Тобольское, Тюменская область
    _7_2_16_4='72:16:4' # Нижне-Аремзянское, Тобольское, Тюменская область
    _7_6_3_1='76:3:1' # Брейтовское, ГКУ ЯО "Брейтовское лесничество", Ярославская область
    _2_21_2='2:21:2' # Инякское, Кугарчинское, Республика Башкортостан
    _2_21_1='2:21:1' # Икское, Кугарчинское, Республика Башкортостан
    _7_2_16_7='72:16:7' # Тобольское сельское, Тобольское, Тюменская область
    _7_2_16_6='72:16:6' # Тобольское, Тобольское, Тюменская область
    _7_2_16_8='72:16:8' # Янгутумское, Тобольское, Тюменская область
    _2_7_11_3='27:11:3' # Дуйское, Де-Кастринское, Хабаровский край
    _4_5_9_1='45:9:1' # Батуринское, Шадринское, Курганская область
    _2_7_11_4='27:11:4' # Софийское, Де-Кастринское, Хабаровский край
    _2_7_11_1='27:11:1' # Быстринское, Де-Кастринское, Хабаровский край
    _2_7_11_2='27:11:2' # Де-Кастринское, Де-Кастринское, Хабаровский край
    _4_5_9_2='45:9:2' # Ольховское, Шадринское, Курганская область
    _4_5_9_3='45:9:3' # Шадринское, Шадринское, Курганская область
    _7_6_3_2='76:3:2' # Ситское, ГКУ ЯО "Брейтовское лесничество", Ярославская область
    _1_1_15_3='11:15:3' # Пальюсское, Печоро-Илычское, Республика Коми
    _1_1_15_2='11:15:2' # Еремеевское, Печоро-Илычское, Республика Коми
    _1_1_15_1='11:15:1' # Большелягское, Печоро-Илычское, Республика Коми
    _1_1_15_5='11:15:5' # Усть-Илычское, Печоро-Илычское, Республика Коми
    _1_1_15_4='11:15:4' # Приуральское, Печоро-Илычское, Республика Коми
    _2_8_4_1='28:4:1' # Бахиревское, Бурейское, Амурская область
    _2_8_4_4='28:4:4' # Чеугдинское, Бурейское, Амурская область
    _2_8_4_2='28:4:2' # Бурейское, Бурейское, Амурская область
    _2_8_4_3='28:4:3' # Кулустайское, Бурейское, Амурская область
    _1_0_8_9='10:8:9' # Повенецкое, Медвежьегорское, Республика Карелия
    _1_0_8_6='10:8:6' # Маслозерское, Медвежьегорское, Республика Карелия
    _1_0_8_5='10:8:5' # Лобское, Медвежьегорское, Республика Карелия
    _1_0_8_8='10:8:8' # Пиндушское, Медвежьегорское, Республика Карелия
    _1_0_8_7='10:8:7' # Медвежьегорское, Медвежьегорское, Республика Карелия
    _1_0_8_2='10:8:2' # Великонивское, Медвежьегорское, Республика Карелия
    _1_0_8_1='10:8:1' # Великогубское, Медвежьегорское, Республика Карелия
    _1_0_8_4='10:8:4' # Кумсинское, Медвежьегорское, Республика Карелия
    _1_0_8_3='10:8:3' # Даниловское, Медвежьегорское, Республика Карелия
    _6_9_6_1='69:6:1' # Бахмутовское, Старицкое, Тверская область
    _6_9_6_2='69:6:2' # Вазузское, Старицкое, Тверская область
    _8_1_1='8:1:1' # Башантинское, Башантинское, Республика Калмыкия
    _8_1_2='8:1:2' # Комсомольское, Башантинское, Республика Калмыкия
    _8_1_3='8:1:3' # Яшалтинское, Башантинское, Республика Калмыкия
    _6_9_6_7='69:6:7' # Молодотудское, Старицкое, Тверская область
    _6_9_6_8='69:6:8' # Оленинское, Старицкое, Тверская область
    _6_9_6_9='69:6:9' # Пенское, Старицкое, Тверская область
    _6_9_6_3='69:6:3' # Верхневолжское, Старицкое, Тверская область
    _6_9_6_4='69:6:4' # Зубцовское, Старицкое, Тверская область
    _6_9_6_5='69:6:5' # Кошинское, Старицкое, Тверская область
    _6_9_6_6='69:6:6' # Луковниковское, Старицкое, Тверская область
    _1_1_28_1='11:28:1' # Деревянское, Усть-Куломское, Республика Коми
    _2_4_13_3='24:13:3' # Орловское, Дзержинское, Красноярский край
    _2_4_13_2='24:13:2' # Дзержинское сельское, Дзержинское, Красноярский край
    _2_4_13_1='24:13:1' # Дзержинское, Дзержинское, Красноярский край
    _1_1_28_5='11:28:5' # Усть-Куломское, Усть-Куломское, Республика Коми
    _1_1_28_4='11:28:4' # Озьягское, Усть-Куломское, Республика Коми
    _2_4_13_5='24:13:5' # Шеломковское, Дзержинское, Красноярский край
    _1_1_28_3='11:28:3' # Кужбинское, Усть-Куломское, Республика Коми
    _2_4_13_4='24:13:4' # Улюкольское, Дзержинское, Красноярский край
    _1_1_28_2='11:28:2' # Керчомское, Усть-Куломское, Республика Коми
    _3_19_5='3:19:5' # Черемушкинское, Кикинское, Республика Бурятия
    _3_19_4='3:19:4' # Кикинское, Кикинское, Республика Бурятия
    _3_19_3='3:19:3' # Гремячинское, Кикинское, Республика Бурятия
    _4_0_8_3='40:8:3' # Приокское, Калужское, Калужская область
    _3_19_2='3:19:2' # Верхне-Итанцинское, Кикинское, Республика Бурятия
    _4_0_8_2='40:8:2' # Пригородное, Калужское, Калужская область
    _3_19_1='3:19:1' # Ангырское, Кикинское, Республика Бурятия
    _4_0_8_1='40:8:1' # Желовское, Калужское, Калужская область
    _4_0_8_4='40:8:4' # Рожковское, Калужское, Калужская область
    _5_8_16_1='58:16:1' # Кирилловское-Подвышенское, Юрсовское, Пензенская область
    _7_5_16_4='75:16:4' # Пешковское, Нерчинское, Забайкальский край
    _5_8_16_4='58:16:4' # Юрсовское-Морсовское, Юрсовское, Пензенская область
    _7_5_16_3='75:16:3' # Калиновское, Нерчинское, Забайкальский край
    _7_5_16_2='75:16:2' # Зюльзинское, Нерчинское, Забайкальский край
    _5_8_16_2='58:16:2' # Раевское, Юрсовское, Пензенская область
    _7_5_16_1='75:16:1' # Знаменское, Нерчинское, Забайкальский край
    _5_8_16_3='58:16:3' # Салтыковское-Пашковское, Юрсовское, Пензенская область
    _6_2_19_4='62:19:4' # Южное, Шиловское, Рязанская область
    _7_9_2='7:9:2' # Лашкутинское, Эльбрусское, Кабардино-Балкарская Республика
    _7_9_1='7:9:1' # Герхажанское, Эльбрусское, Кабардино-Балкарская Республика
    _3_9_9_2='39:9:2' # Гремяченское, Черняховское, Калининградская область
    _3_9_9_1='39:9:1' # Бережковское, Черняховское, Калининградская область
    _3_9_9_4='39:9:4' # Каменское, Черняховское, Калининградская область
    _3_9_9_3='39:9:3' # Двуреченское, Черняховское, Калининградская область
    _3_9_9_6='39:9:6' # Майское, Черняховское, Калининградская область
    _3_9_9_5='39:9:5' # Краснополянское, Черняховское, Калининградская область
    _3_9_9_7='39:9:7' # Нагорное, Черняховское, Калининградская область
    _5_8_1_1='58:1:1' # Засурское-Леонидовское, Ахунское, Пензенская область
    _2_6_6='2:6:6' # Юлукское, Баймакское, Республика Башкортостан
    _2_6_5='2:6:5' # Темясовское, Баймакское, Республика Башкортостан
    _5_8_1_3='58:1:3' # Светлополянское-Лопуховское, Ахунское, Пензенская область
    _2_6_4='2:6:4' # Сибайское, Баймакское, Республика Башкортостан
    _5_8_1_2='58:1:2' # Пугачевское, Ахунское, Пензенская область
    _6_2_19_3='62:19:3' # Центральное, Шиловское, Рязанская область
    _6_2_19_2='62:19:2' # Северное, Шиловское, Рязанская область
    _6_2_19_1='62:19:1' # Новосельское, Шиловское, Рязанская область
    _2_6_3='2:6:3' # Крепостное, Баймакское, Республика Башкортостан
    _2_6_2='2:6:2' # Иткуловское, Баймакское, Республика Башкортостан
    _2_6_1='2:6:1' # Баймакское, Баймакское, Республика Башкортостан
    _4_4_10_1='44:10:1' # 1-е Георгиевское, Межевское, Костромская область
    _2_21_6='2:21:6' # Юмагузинское, Кугарчинское, Республика Башкортостан
    _4_4_10_2='44:10:2' # 1-е Никольское, Межевское, Костромская область
    _2_21_5='2:21:5' # Наказское, Кугарчинское, Республика Башкортостан
    _4_4_10_3='44:10:3' # 2-е Георгиевское, Межевское, Костромская область
    _2_21_4='2:21:4' # Мраковское, Кугарчинское, Республика Башкортостан
    _4_4_10_4='44:10:4' # 2-е Никольское, Межевское, Костромская область
    _2_21_3='2:21:3' # Кугарчинское, Кугарчинское, Республика Башкортостан
    _4_4_10_5='44:10:5' # Межевское, Межевское, Костромская область
    _4_4_10_6='44:10:6' # Петушихское, Межевское, Костромская область
    _4_4_10_7='44:10:7' # Родинское, Межевское, Костромская область
    _1_1_1_2='11:1:2' # Вежайское, Айкинское, Республика Коми
    _1_1_1_1='11:1:1' # Айкинское, Айкинское, Республика Коми
    _3_4_6_4='34:6:4' # Линёвское, Жирновское, Волгоградская область
    _3_4_6_3='34:6:3' # Красноярское, Жирновское, Волгоградская область
    _3_4_6_2='34:6:2' # Жирновское сельское, Жирновское, Волгоградская область
    _3_4_6_1='34:6:1' # Верхне-Добринское, Жирновское, Волгоградская область
    _1_1_1_6='11:1:6' # Семуковское, Айкинское, Республика Коми
    _1_1_1_5='11:1:5' # Микуньское, Айкинское, Республика Коми
    _1_1_1_4='11:1:4' # Мадмасское, Айкинское, Республика Коми
    _1_1_1_3='11:1:3' # Жешартское, Айкинское, Республика Коми
    _6_4_3_4='64:3:4' # Липовское, Базарно-Карабулакское, Саратовская область
    _6_4_3_3='64:3:3' # Вязовское, Базарно-Карабулакское, Саратовская область
    _6_4_3_5='64:3:5' # Нееловское, Базарно-Карабулакское, Саратовская область
    _6_4_3_2='64:3:2' # Биклейское, Базарно-Карабулакское, Саратовская область
    _6_4_3_1='64:3:1' # Алексеевское, Базарно-Карабулакское, Саратовская область
    _7_0_7_6='70:7:6' # Тымское, Каргасокское, Томская область
    _7_0_7_7='70:7:7' # Чижапское, Каргасокское, Томская область
    _7_0_7_4='70:7:4' # Нюрольское, Каргасокское, Томская область
    _7_0_7_5='70:7:5' # Тевризское, Каргасокское, Томская область
    _2_2_8_8='22:8:8' # Усть-Волчихинское, Волчихинское, Алтайский край
    _2_2_8_6='22:8:6' # Селиверстовское, Волчихинское, Алтайский край
    _7_0_7_2='70:7:2' # Верх-Тымское, Каргасокское, Томская область
    _2_2_8_7='22:8:7' # Солоновское, Волчихинское, Алтайский край
    _7_0_7_3='70:7:3' # Каргасокское, Каргасокское, Томская область
    _2_2_8_4='22:8:4' # Максинское, Волчихинское, Алтайский край
    _2_2_8_5='22:8:5' # Правдинское, Волчихинское, Алтайский край
    _7_0_7_1='70:7:1' # Большегривское, Каргасокское, Томская область
    _2_2_8_2='22:8:2' # Востровское, Волчихинское, Алтайский край
    _2_2_8_3='22:8:3' # Кормихинское, Волчихинское, Алтайский край
    _2_2_8_1='22:8:1' # Волчихинское, Волчихинское, Алтайский край
    _5_1_10_1='51:10:1' # Варзугское, Терское, Мурманская область
    _5_1_10_2='51:10:2' # Индельское, Терское, Мурманская область
    _5_1_10_3='51:10:3' # Умбское, Терское, Мурманская область
    _1_6_4_2='16:4:2' # Чернореченское, Алькеевское, Республика Татарстан (Татарстан)
    _1_6_4_1='16:4:1' # Базарно-Матаковское, Алькеевское, Республика Татарстан (Татарстан)
    _1_6_4_4='16:4:4' # Юхмачинское, Алькеевское, Республика Татарстан (Татарстан)
    _1_6_4_3='16:4:3' # Чув.Бродское, Алькеевское, Республика Татарстан (Татарстан)
    _5_2_4_1='52:4:1' # Большеорловское, Борское районное, Нижегородская область
    _5_2_4_2='52:4:2' # Борское, Борское районное, Нижегородская область
    _5_7_7_2='57:7:2' # Корсаковское, Новосильское, Орловская область
    _5_7_7_1='57:7:1' # Верховское, Новосильское, Орловская область
    _5_7_7_5='57:7:5' # Хомутовское, Новосильское, Орловская область
    _5_7_7_4='57:7:4' # Новосильское, Новосильское, Орловская область
    _5_7_7_3='57:7:3' # Моховское, Новосильское, Орловская область
    _5_2_4_7='52:4:7' # Ковровское, Борское районное, Нижегородская область
    _5_2_4_8='52:4:8' # Краснораменское, Борское районное, Нижегородская область
    _5_2_4_9='52:4:9' # Останкинское, Борское районное, Нижегородская область
    _5_2_4_3='52:4:3' # Ватомское, Борское районное, Нижегородская область
    _5_2_4_4='52:4:4' # Высокоборское, Борское районное, Нижегородская область
    _5_2_4_5='52:4:5' # Завражновское, Борское районное, Нижегородская область
    _5_2_4_6='52:4:6' # Затонское, Борское районное, Нижегородская область
    _6_6_9_10='66:9:10' # Тошемское, Ивдельское, Свердловская область
    _5_3_9_11='53:9:11' # Татинское, Новгородское, Новгородская область
    _5_3_9_10='53:9:10' # Советское, Новгородское, Новгородская область
    _6_5_16_1='65:16:1' # Южно-Курильское, Южно-Курильское, Сахалинская область
    _6_3_9_4='63:9:4' # Утевское, Нефтегорское, Самарская область
    _6_3_9_3='63:9:3' # Борское, Нефтегорское, Самарская область
    _6_3_9_2='63:9:2' # Богатовское, Нефтегорское, Самарская область
    _6_3_9_1='63:9:1' # Алексеевское, Нефтегорское, Самарская область
    _2_3_2_5='23:2:5' # Хадыженское, Апшеронское, Краснодарский край
    _2_3_2_6='23:2:6' # Черниговское, Апшеронское, Краснодарский край
    _2_3_2_7='23:2:7' # Ширванское, Апшеронское, Краснодарский край
    _2_3_2_1='23:2:1' # Гуамское, Апшеронское, Краснодарский край
    _2_3_2_2='23:2:2' # Маратукское, Апшеронское, Краснодарский край
    _2_3_2_3='23:2:3' # Тверское, Апшеронское, Краснодарский край
    _2_3_2_4='23:2:4' # Тубинское, Апшеронское, Краснодарский край
    _7_1_1_1='71:1:1' # Городское, Алексинское, Тульская область
    _7_1_1_2='71:1:2' # Петрушинское, Алексинское, Тульская область
    _7_1_1_3='71:1:3' # Сотинское, Алексинское, Тульская область
    _2_4_14_2='24:14:2' # Перспективное, Долгомостовское, Красноярский край
    _2_4_14_1='24:14:1' # Долгомостовское, Долгомостовское, Красноярский край
    _2_4_14_5='24:14:5' # Хандальское, Долгомостовское, Красноярский край
    _2_4_14_4='24:14:4' # Солнечное, Долгомостовское, Красноярский край
    _2_4_14_3='24:14:3' # Покатеевское, Долгомостовское, Красноярский край
    _5_2_19_2='52:19:2' # Каменское, Михайловское районное, Нижегородская область
    _5_2_19_1='52:19:1' # Валковское, Михайловское районное, Нижегородская область
    _5_2_19_4='52:19:4' # Красноборковское, Михайловское районное, Нижегородская область
    _5_2_19_3='52:19:3' # Керженское, Михайловское районное, Нижегородская область
    _5_2_19_6='52:19:6' # Михайловское, Михайловское районное, Нижегородская область
    _5_2_19_5='52:19:5' # Красноярское, Михайловское районное, Нижегородская область
    _5_2_19_8='52:19:8' # Сельскомазское, Михайловское районное, Нижегородская область
    _5_2_19_7='52:19:7' # Разнежское, Михайловское районное, Нижегородская область
    _2_8_5_3='28:5:3' # Октябрьское, Завитинское, Амурская область
    _2_8_5_4='28:5:4' # Райчихинское, Завитинское, Амурская область
    _2_8_5_1='28:5:1' # Завитинское, Завитинское, Амурская область
    _2_8_5_2='28:5:2' # Михайловское, Завитинское, Амурская область
    _6_5_15_2='65:15:2' # Холмское, Холмское, Сахалинская область
    _6_5_15_1='65:15:1' # Костромское, Холмское, Сахалинская область
    _5_2_5_1='52:5:1' # Больше-Мурашкинское, Бутурлинское межрайонное, Нижегородская область
    _2_4_27_1='24:27:1' # Краснотуранское, Краснотуранское, Красноярский край
    _2_4_27_2='24:27:2' # Краснотуранское сельское, Краснотуранское, Красноярский край
    _5_2_5_2='52:5:2' # Бутурлинское, Бутурлинское межрайонное, Нижегородская область
    _5_2_5_3='52:5:3' # Гагинское, Бутурлинское межрайонное, Нижегородская область
    _5_2_5_4='52:5:4' # Перевозское, Бутурлинское межрайонное, Нижегородская область
    _4_6_4_1='46:4:1' # Золотухинское, Золотухинское, Курская область
    _4_6_4_2='46:4:2' # Свободинское, Золотухинское, Курская область
    _4_6_4_3='46:4:3' # Фатежское, Золотухинское, Курская область
    _2_7_36_5='27:36:5' # Лесопарковое, Хабаровское, Хабаровский край
    _2_7_36_4='27:36:4' # Елабужское, Хабаровское, Хабаровский край
    _2_7_36_3='27:36:3' # Вишневское, Хабаровское, Хабаровский край
    _2_7_36_2='27:36:2' # Брацлавское, Хабаровское, Хабаровский край
    _3_4_10_1='34:10:1' # Котовское, Котовское, Волгоградская область
    _2_7_36_6='27:36:6' # Мало-Хехцирское, Хабаровское, Хабаровский край
    _5_0_12_13='50:12:13' # Симбуховское, Наро-Фоминское, Московская область
    _3_4_10_2='34:10:2' # Попковское, Котовское, Волгоградская область
    _2_7_36_1='27:36:1' # Анастасьевское, Хабаровское, Хабаровский край
    _5_0_12_10='50:12:10' # Наро-Фоминское сельское, Наро-Фоминское, Московская область
    _5_0_12_11='50:12:11' # Нарское, Наро-Фоминское, Московская область
    _5_0_12_12='50:12:12' # Рассудовское, Наро-Фоминское, Московская область
    _4_1_1_1='41:1:1' # Атласовское, Атласовское, Камчатский край
    _4_1_1_3='41:1:3' # Щапинское, Атласовское, Камчатский край
    _2_22_1='2:22:1' # Верхоторское, Макаровское, Республика Башкортостан
    _4_1_1_2='41:1:2' # Лазовское, Атласовское, Камчатский край
    _6_4_2_1='64:2:1' # Аткарское, Аткарское, Саратовская область
    _6_4_2_3='64:2:3' # Песчанское, Аткарское, Саратовская область
    _6_4_2_2='64:2:2' # Озерное, Аткарское, Саратовская область
    _1_1_14_4='11:14:4' # Турьинское, Мещурское, Республика Коми
    _1_1_14_3='11:14:3' # Мещурское, Мещурское, Республика Коми
    _1_1_14_2='11:14:2' # Ветьюнское, Мещурское, Республика Коми
    _1_1_14_1='11:14:1' # Верхневымское, Мещурское, Республика Коми
    _2_7_23_4='27:23:4' # Сидиминское, Оборское, Хабаровский край
    _2_7_23_5='27:23:5' # Ситинское, Оборское, Хабаровский край
    _2_7_23_2='27:23:2' # Дурминское, Оборское, Хабаровский край
    _2_7_23_3='27:23:3' # Оборское, Оборское, Хабаровский край
    _2_7_23_1='27:23:1' # Верхне-Немптинское, Оборское, Хабаровский край
    _2_22_5='2:22:5' # Макаровское, Макаровское, Республика Башкортостан
    _2_22_4='2:22:4' # Кулгунинское, Макаровское, Республика Башкортостан
    _2_22_3='2:22:3' # Кузяновское, Макаровское, Республика Башкортостан
    _2_22_2='2:22:2' # Ишимбайское, Макаровское, Республика Башкортостан
    _2_22_8='2:22:8' # Шихановское, Макаровское, Республика Башкортостан
    _2_22_7='2:22:7' # Урнякское, Макаровское, Республика Башкортостан
    _2_22_6='2:22:6' # Селеукское, Макаровское, Республика Башкортостан
    _1_4_14_5='14:14:5' # Чульманское, Нерюнгринское, Республика Саха (Якутия)
    _1_4_14_4='14:14:4' # Хатыминское, Нерюнгринское, Республика Саха (Якутия)
    _1_4_14_1='14:14:1' # Золотинское, Нерюнгринское, Республика Саха (Якутия)
    _1_0_7_7='10:7:7' # Энгозерское, Лоухское, Республика Карелия
    _1_0_7_6='10:7:6' # Чупинское, Лоухское, Республика Карелия
    _1_4_14_3='14:14:3' # Ханинское, Нерюнгринское, Республика Саха (Якутия)
    _1_4_14_2='14:14:2' # Нерюнгринское, Нерюнгринское, Республика Саха (Якутия)
    _1_0_7_3='10:7:3' # Пяозерское, Лоухское, Республика Карелия
    _1_0_7_2='10:7:2' # Лоухское, Лоухское, Республика Карелия
    _1_0_7_5='10:7:5' # Тикшеозерское, Лоухское, Республика Карелия
    _7_2_15_2='72:15:2' # Сорокинское сельское, Сорокинское, Тюменская область
    _1_0_7_4='10:7:4' # Рувозерское, Лоухское, Республика Карелия
    _7_2_15_1='72:15:1' # Сорокинское, Сорокинское, Тюменская область
    _1_0_7_1='10:7:1' # Амбарское, Лоухское, Республика Карелия
    _6_9_5_1='69:5:1' # Большекошинское, Осташковское, Тверская область
    _6_9_5_2='69:5:2' # Верхне-Селигерское, Осташковское, Тверская область
    _6_9_5_3='69:5:3' # Волговерховское, Осташковское, Тверская область
    _8_2_1='8:2:1' # Годжурское, Ергенинское, Республика Калмыкия
    _8_2_2='8:2:2' # Обиленское, Ергенинское, Республика Калмыкия
    _6_9_5_8='69:5:8' # Истоко-Волжское, Осташковское, Тверская область
    _8_2_3='8:2:3' # Садовское, Ергенинское, Республика Калмыкия
    _6_9_5_9='69:5:9' # Истоко-Двинское, Осташковское, Тверская область
    _8_2_4='8:2:4' # Сарпинское, Ергенинское, Республика Калмыкия
    _8_2_5='8:2:5' # Сухотинское, Ергенинское, Республика Калмыкия
    _6_9_5_4='69:5:4' # Волжское, Осташковское, Тверская область
    _6_9_5_5='69:5:5' # Вселукское, Осташковское, Тверская область
    _6_9_5_6='69:5:6' # Городское, Осташковское, Тверская область
    _6_9_5_7='69:5:7' # Дмитровское, Осташковское, Тверская область
    _1_1_27_2='11:27:2' # Усинское, Усинское, Республика Коми
    _1_1_27_1='11:27:1' # Мутноматерикское, Усинское, Республика Коми
    _2_7_10_6='27:10:6' # Снежное, Гурское, Хабаровский край
    _1_1_27_3='11:27:3' # Усть-Усинское, Усинское, Республика Коми
    _3_5_1_17='35:1:17' # Чистиковское, Бабаевское, Вологодская область
    _3_5_1_16='35:1:16' # Хилецкое, Бабаевское, Вологодская область
    _2_7_10_1='27:10:1' # Даппинское, Гурское, Хабаровский край
    _3_5_1_15='35:1:15' # Тимошинское, Бабаевское, Вологодская область
    _3_5_1_14='35:1:14' # Слудненское, Бабаевское, Вологодская область
    _3_5_1_13='35:1:13' # Ольховское, Бабаевское, Вологодская область
    _2_7_10_4='27:10:4' # Пиваньское, Гурское, Хабаровский край
    _3_5_1_12='35:1:12' # Ножемское, Бабаевское, Вологодская область
    _2_7_10_5='27:10:5' # Селихинское, Гурское, Хабаровский край
    _3_5_1_11='35:1:11' # Никольское, Бабаевское, Вологодская область
    _2_7_10_2='27:10:2' # Картельское, Гурское, Хабаровский край
    _3_5_1_10='35:1:10' # Люботинское, Бабаевское, Вологодская область
    _2_7_10_3='27:10:3' # Мачтовое, Гурское, Хабаровский край
    _3_5_1_19='35:1:19' # Шогдинское, Бабаевское, Вологодская область
    _7_6_4_1='76:4:1' # Курбское, ГКУ ЯО "Гаврилов -Ямское лесничество", Ярославская область
    _3_5_1_18='35:1:18' # Шиглинское, Бабаевское, Вологодская область
    _7_6_4_2='76:4:2' # Ставотинское, ГКУ ЯО "Гаврилов -Ямское лесничество", Ярославская область
    _3_7_10_1='37:10:1' # Гридинское, Южское, Ивановская область
    _3_7_10_2='37:10:2' # Козловское, Южское, Ивановская область
    _3_7_10_3='37:10:3' # Майдаковское, Южское, Ивановская область
    _3_7_10_4='37:10:4' # Мостовское, Южское, Ивановская область
    _3_7_10_5='37:10:5' # Палехское, Южское, Ивановская область
    _3_7_10_6='37:10:6' # Палехское сельское, Южское, Ивановская область
    _3_7_10_7='37:10:7' # Сакулинское, Южское, Ивановская область
    _3_7_10_8='37:10:8' # Холуйское, Южское, Ивановская область
    _3_7_10_9='37:10:9' # Южское, Южское, Ивановская область
    _1_4_12_3='14:12:3' # Сюльдюкарское, Мирнинское, Республика Саха (Якутия)
    _1_4_12_2='14:12:2' # Мирнинское, Мирнинское, Республика Саха (Якутия)
    _1_4_12_4='14:12:4' # Чернышевское, Мирнинское, Республика Саха (Якутия)
    _1_4_12_1='14:12:1' # Айхальское, Мирнинское, Республика Саха (Якутия)
    _6_3_8_4='63:8:4' # Шиланское, Красноярское, Самарская область
    _6_3_8_3='63:8:3' # Красноярское, Красноярское, Самарская область
    _6_3_8_2='63:8:2' # Большецаревщинское, Красноярское, Самарская область
    _6_3_8_1='63:8:1' # Большекаменское, Красноярское, Самарская область
    _6_4_21_4='64:21:4' # Синеньское, Саратовское, Саратовская область
    _6_4_21_3='64:21:3' # Саратовское, Саратовское, Саратовская область
    _6_4_21_5='64:21:5' # Усть-Курдюмское, Саратовское, Саратовская область
    _6_4_21_2='64:21:2' # Пригородное, Саратовское, Саратовская область
    _4_4_20_1='44:20:1' # 1-е Судайское, Чухломское, Костромская область
    _6_4_21_1='64:21:1' # Поповское, Саратовское, Саратовская область
    _1_6_7_1='16:7:1' # Бавлинское, Бавлинское, Республика Татарстан (Татарстан)
    _1_6_7_2='16:7:2' # Кандызское, Бавлинское, Республика Татарстан (Татарстан)
    _1_1_4_9='11:4:9' # Чубское, Железнодорожное, Республика Коми
    _1_1_4_8='11:4:8' # Чиньяворыкское, Железнодорожное, Республика Коми
    _4_4_20_2='44:20:2' # 1-е Чухломское, Чухломское, Костромская область
    _1_1_4_3='11:4:3' # Кылтовское, Железнодорожное, Республика Коми
    _4_4_20_3='44:20:3' # 2-е Судайское, Чухломское, Костромская область
    _1_1_4_2='11:4:2' # Княжпогостское, Железнодорожное, Республика Коми
    _4_4_20_4='44:20:4' # 2-е Чухломское, Чухломское, Костромская область
    _1_1_4_1='11:4:1' # Вожаельское, Железнодорожное, Республика Коми
    _4_4_20_5='44:20:5' # Бушневское, Чухломское, Костромская область
    _4_4_20_6='44:20:6' # Введенское, Чухломское, Костромская область
    _1_1_4_7='11:4:7' # Трактовское, Железнодорожное, Республика Коми
    _4_4_20_7='44:20:7' # Вигское, Чухломское, Костромская область
    _1_1_4_6='11:4:6' # Синдорское, Железнодорожное, Республика Коми
    _4_4_20_8='44:20:8' # Георгиевское, Чухломское, Костромская область
    _1_1_4_5='11:4:5' # Сереговское, Железнодорожное, Республика Коми
    _4_4_20_9='44:20:9' # Кистереченское, Чухломское, Костромская область
    _1_1_4_4='11:4:4' # Ропчинское, Железнодорожное, Республика Коми
    _5_7_6_3='57:6:3' # Тельченское, Мценское, Орловская область
    _5_7_6_2='57:6:2' # Мценское, Мценское, Орловская область
    _5_7_6_1='57:6:1' # Думчинское, Мценское, Орловская область
    _3_9_6_5='39:6:5' # Токаревское, Нестеровское, Калининградская область
    _3_9_6_4='39:6:4' # Пограничное, Нестеровское, Калининградская область
    _3_9_6_6='39:6:6' # Чистопрудненское, Нестеровское, Калининградская область
    _3_9_6_1='39:6:1' # Боровское, Нестеровское, Калининградская область
    _3_9_6_3='39:6:3' # Озерское, Нестеровское, Калининградская область
    _3_9_6_2='39:6:2' # Краснолесское, Нестеровское, Калининградская область
    _7_5_26_1='75:26:1' # Верхне-Хилинское, Шилкинское, Забайкальский край
    _7_5_26_2='75:26:2' # Зубаревское, Шилкинское, Забайкальский край
    _7_5_26_3='75:26:3' # Шилкинское, Шилкинское, Забайкальский край
    _2_7_6='2:7:6' # Краснореченское, Белебеевское, Республика Башкортостан
    _2_7_5='2:7:5' # Краснознаменское, Белебеевское, Республика Башкортостан
    _2_7_4='2:7:4' # Ермекеевское, Белебеевское, Республика Башкортостан
    _2_7_3='2:7:3' # Демское, Белебеевское, Республика Башкортостан
    _2_7_9='2:7:9' # Суккуловское, Белебеевское, Республика Башкортостан
    _2_7_8='2:7:8' # Михайловское, Белебеевское, Республика Башкортостан
    _2_7_7='2:7:7' # Метевбашевское, Белебеевское, Республика Башкортостан
    _2_7_2='2:7:2' # Бижбулякское, Белебеевское, Республика Башкортостан
    _2_7_1='2:7:1' # Белебеевское, Белебеевское, Республика Башкортостан
    _2_31_3='2:31:3' # Краснокамское сельское, Янаульское, Республика Башкортостан
    _2_31_2='2:31:2' # Кармановское, Янаульское, Республика Башкортостан
    _2_31_1='2:31:1' # Кайпановское, Янаульское, Республика Башкортостан
    _7_5_13_6='75:13:6' # Черемховское, Красночикойское, Забайкальский край
    _7_5_13_5='75:13:5' # Усть-Мензинское, Красночикойское, Забайкальский край
    _7_5_13_4='75:13:4' # Осиновское, Красночикойское, Забайкальский край
    _7_5_13_3='75:13:3' # Мензинское, Красночикойское, Забайкальский край
    _7_5_13_2='75:13:2' # Малоархангельское, Красночикойское, Забайкальский край
    _7_5_13_1='75:13:1' # Гутайское, Красночикойское, Забайкальский край
    _3_3_9_2='33:9:2' # Киржачское, Киржачское, Владимирская область
    _3_3_9_1='33:9:1' # Кипревское, Киржачское, Владимирская область
    _3_3_9_4='33:9:4' # Санинское, Киржачское, Владимирская область
    _3_3_9_3='33:9:3' # Новоселовское, Киржачское, Владимирская область
    _3_3_9_6='33:9:6' # Филипповское, Киржачское, Владимирская область
    _3_3_9_5='33:9:5' # Северное, Киржачское, Владимирская область
    _3_3_9_7='33:9:7' # Южное, Киржачское, Владимирская область
    _3_29_1='3:29:1' # Иркиликское, Прибайкальское, Республика Бурятия
    _3_29_2='3:29:2' # Итанцинское, Прибайкальское, Республика Бурятия
    _3_29_3='3:29:3' # Покровское, Прибайкальское, Республика Бурятия
    _3_29_4='3:29:4' # Прибайкальское сельское, Прибайкальское, Республика Бурятия
    _2_31_7='2:31:7' # Татышлинское, Янаульское, Республика Башкортостан
    _3_29_5='3:29:5' # Татауровское, Прибайкальское, Республика Бурятия
    _2_31_6='2:31:6' # Прибельское, Янаульское, Республика Башкортостан
    _2_31_5='2:31:5' # Ново-Артаульское, Янаульское, Республика Башкортостан
    _2_31_4='2:31:4' # Николо-Березовское, Янаульское, Республика Башкортостан
    _2_31_9='2:31:9' # Янаульское, Янаульское, Республика Башкортостан
    _2_31_8='2:31:8' # Татышлинское сельское, Янаульское, Республика Башкортостан
    _5_2_3_1='52:3:1' # Афанасьевское, Богородское районное, Нижегородская область
    _5_2_3_2='52:3:2' # Богородское, Богородское районное, Нижегородская область
    _5_2_3_3='52:3:3' # Ключищенское, Богородское районное, Нижегородская область
    _5_2_3_4='52:3:4' # Оранское, Богородское районное, Нижегородская область
    _3_16_6='3:16:6' # Оронгойское, Иволгинское, Республика Бурятия
    _3_16_5='3:16:5' # Каленовское, Иволгинское, Республика Бурятия
    _3_16_4='3:16:4' # Иволгинское сельское, Иволгинское, Республика Бурятия
    _3_16_3='3:16:3' # Иволгинское, Иволгинское, Республика Бурятия
    _3_16_2='3:16:2' # Гурульбинское, Иволгинское, Республика Бурятия
    _3_16_1='3:16:1' # Гильбиринское, Иволгинское, Республика Бурятия
    _1_7_1_3='17:1:3' # Степное, Балгазынское, Республика Тыва
    _1_7_1_2='17:1:2' # Кызыл-Арыгское, Балгазынское, Республика Тыва
    _1_7_1_1='17:1:1' # Балгазынское, Балгазынское, Республика Тыва
    _3_1_1='3:1:1' # Ангоянское, Ангоянское, Республика Бурятия
    _3_1_3='3:1:3' # Котерское, Ангоянское, Республика Бурятия
    _3_1_2='3:1:2' # Киронское, Ангоянское, Республика Бурятия
    _3_1_4='3:1:4' # Куморское, Ангоянское, Республика Бурятия
    _4_4_21_11='44:21:11' # Семинихинское, Шарьинское, Костромская область
    _4_4_21_10='44:21:10' # Рождественское, Шарьинское, Костромская область
    _4_4_21_13='44:21:13' # Шарьинское, Шарьинское, Костромская область
    _4_4_21_12='44:21:12' # Троицкое, Шарьинское, Костромская область
    _4_4_21_14='44:21:14' # Шекшемское, Шарьинское, Костромская область
    _7_0_8_1='70:8:1' # Осиповское, Кедровское, Томская область
    _7_0_8_2='70:8:2' # Пудинское, Кедровское, Томская область
    _2_2_5_5='22:5:5' # Соколовское, Бийское, Алтайский край
    _2_2_5_3='22:5:3' # Кокшинское, Бийское, Алтайский край
    _2_2_5_4='22:5:4' # Новиковское, Бийское, Алтайский край
    _2_2_5_1='22:5:1' # Бийско-Катунское, Бийское, Алтайский край
    _2_2_5_2='22:5:2' # Большеугреневское, Бийское, Алтайский край
    _4_6_1_1='46:1:1' # Горшеченское, Горшеченское, Курская область
    _4_6_1_2='46:1:2' # Касторенское, Горшеченское, Курская область
    _4_6_1_3='46:1:3' # Ясеновское, Горшеченское, Курская область
    _6_8_13_1='68:13:1' # Комсомольское, Челнавское, Тамбовская область
    _6_8_13_2='68:13:2' # Сосновское, Челнавское, Тамбовская область
    _6_8_13_3='68:13:3' # Стежинское, Челнавское, Тамбовская область
    _1_1_17_1='11:17:1' # Великопольское, Помоздинское, Республика Коми
    _1_1_17_6='11:17:6' # Пузлинское, Помоздинское, Республика Коми
    _1_1_17_5='11:17:5' # Помоздинское, Помоздинское, Республика Коми
    _1_1_17_4='11:17:4' # Пожегодское, Помоздинское, Республика Коми
    _1_1_17_3='11:17:3' # Вольское, Помоздинское, Республика Коми
    _1_1_17_2='11:17:2' # Вольдинское, Помоздинское, Республика Коми
    _5_2_18_3='52:18:3' # Лысковское, Лысковское межрайонное, Нижегородская область
    _5_2_18_2='52:18:2' # Княгининское, Лысковское межрайонное, Нижегородская область
    _5_2_18_1='52:18:1' # Воротынское, Лысковское межрайонное, Нижегородская область
    _2_7_39_1='27:39:1' # Чумиканское, Чумиканское, Хабаровский край
    _6_9_4_1='69:4:1' # Весьегонское, Краснохолмское, Тверская область
    _6_9_4_2='69:4:2' # Кесемское, Краснохолмское, Тверская область
    _6_9_4_3='69:4:3' # Краснохолмское, Краснохолмское, Тверская область
    _6_9_4_4='69:4:4' # Ламское, Краснохолмское, Тверская область
    _6_9_4_9='69:4:9' # Сандовское, Краснохолмское, Тверская область
    _6_9_4_5='69:4:5' # Лукинское, Краснохолмское, Тверская область
    _6_9_4_6='69:4:6' # Молоковское, Краснохолмское, Тверская область
    _6_9_4_7='69:4:7' # Приворотское, Краснохолмское, Тверская область
    _6_9_4_8='69:4:8' # Рычмановское, Краснохолмское, Тверская область
    _2_4_15_7='24:15:7' # Устюгское, Емельяновское, Красноярский край
    _2_4_15_6='24:15:6' # Никольское, Емельяновское, Красноярский край
    _2_4_15_1='24:15:1' # Емельяновское, Емельяновское, Красноярский край
    _2_1_11_4='21:11:4' # Пандиковское, Ядринское, Чувашская Республика - Чувашия
    _2_1_11_3='21:11:3' # Майское, Ядринское, Чувашская Республика - Чувашия
    _2_1_11_5='21:11:5' # Янымовское, Ядринское, Чувашская Республика - Чувашия
    _2_4_15_5='24:15:5' # Мостовское, Емельяновское, Красноярский край
    _2_4_15_4='24:15:4' # Михайловское, Емельяновское, Красноярский край
    _2_4_15_3='24:15:3' # Мало-Кемчугское, Емельяновское, Красноярский край
    _2_1_11_2='21:11:2' # Засурское, Ядринское, Чувашская Республика - Чувашия
    _2_4_15_2='24:15:2' # Кемчугское, Емельяновское, Красноярский край
    _2_1_11_1='21:11:1' # Атнарское, Ядринское, Чувашская Республика - Чувашия
    _2_7_26_3='27:26:3' # Хутинское, Северное, Хабаровский край
    _2_7_26_1='27:26:1' # Ванинское, Северное, Хабаровский край
    _2_7_26_2='27:26:2' # Тумнинское, Северное, Хабаровский край
    _2_4_28_8='24:28:8' # Усть-Манское, Красноярское, Красноярский край
    _2_4_28_9='24:28:9' # Хмельниковское, Красноярское, Красноярский край
    _2_4_28_4='24:28:4' # Дивногорское, Красноярское, Красноярский край
    _2_4_28_5='24:28:5' # Кедровое, Красноярское, Красноярский край
    _2_4_28_6='24:28:6' # Овсянское, Красноярское, Красноярский край
    _2_4_28_7='24:28:7' # Советское, Красноярское, Красноярский край
    _2_7_8_3='27:8:3' # Кенадское, Высокогорное, Хабаровский край
    _2_7_8_4='27:8:4' # Северное, Высокогорное, Хабаровский край
    _2_4_28_1='24:28:1' # Бархатовское, Красноярское, Красноярский край
    _2_7_8_5='27:8:5' # Тумнинское, Высокогорное, Хабаровский край
    _2_4_28_2='24:28:2' # Бахтинское, Красноярское, Красноярский край
    _2_4_28_3='24:28:3' # Вознесенское, Красноярское, Красноярский край
    _7_2_18_1='72:18:1' # Верхне-Демьянское, Уватское, Тюменская область
    _2_7_8_1='27:8:1' # Верхне-Тумнинское, Высокогорное, Хабаровский край
    _7_2_18_3='72:18:3' # Демьянское, Уватское, Тюменская область
    _2_7_8_2='27:8:2' # Высокогорное, Высокогорное, Хабаровский край
    _7_2_18_2='72:18:2' # Горно-Слинкинское, Уватское, Тюменская область
    _7_1_2_1='71:2:1' # Арсеньевское, Белевское, Тульская область
    _7_1_2_2='71:2:2' # Володьковское, Белевское, Тульская область
    _7_1_2_3='71:2:3' # Сороколетовское, Белевское, Тульская область
    _7_1_2_4='71:2:4' # Хрящевское, Белевское, Тульская область
    _2_7_13_5='27:13:5' # Херпучинское, Кербинское, Хабаровский край
    _2_7_13_3='27:13:3' # Нимеленское, Кербинское, Хабаровский край
    _2_7_13_4='27:13:4' # Омальское, Кербинское, Хабаровский край
    _7_2_18_5='72:18:5' # Мугенское, Уватское, Тюменская область
    _7_2_18_4='72:18:4' # Жердняковское, Уватское, Тюменская область
    _7_2_18_7='72:18:7' # Туртасское, Уватское, Тюменская область
    _7_2_18_6='72:18:6' # Першинское, Уватское, Тюменская область
    _4_5_7_2='45:7:2' # Куртамышское, Куртамышское, Курганская область
    _2_7_13_1='27:13:1' # Амгуньское, Кербинское, Хабаровский край
    _7_2_18_9='72:18:9' # Чебунтанское, Уватское, Тюменская область
    _4_5_7_3='45:7:3' # Нижнёвское, Куртамышское, Курганская область
    _2_7_13_2='27:13:2' # Кербинское, Кербинское, Хабаровский край
    _7_2_18_8='72:18:8' # Уватское, Уватское, Тюменская область
    _4_5_7_1='45:7:1' # Косулинское, Куртамышское, Курганская область
    _4_5_7_4='45:7:4' # Целинное, Куртамышское, Курганская область
    _4_0_4_5='40:4:5' # Хвастовичское, Еленское, Калужская область
    _4_0_4_4='40:4:4' # Тургеневское, Еленское, Калужская область
    _4_0_4_3='40:4:3' # Троснянское, Еленское, Калужская область
    _4_0_4_2='40:4:2' # Старосельское, Еленское, Калужская область
    _7_5_12_7='75:12:7' # Эдакуйское, Карымское, Забайкальский край
    _4_0_4_1='40:4:1' # Еленское, Еленское, Калужская область
    _7_5_12_6='75:12:6' # Урульгинское, Карымское, Забайкальский край
    _7_5_12_5='75:12:5' # Олентуйское, Карымское, Забайкальский край
    _7_5_12_4='75:12:4' # Курорт-Дарасунское, Карымское, Забайкальский край
    _7_5_12_3='75:12:3' # Карымское, Карымское, Забайкальский край
    _7_5_12_2='75:12:2' # Дарасунское, Карымское, Забайкальский край
    _7_5_12_1='75:12:1' # Адриановское, Карымское, Забайкальский край
    _2_8_2_2='28:2:2' # Ромненское, Белогорское, Амурская область
    _2_8_2_3='28:2:3' # Серышевское, Белогорское, Амурская область
    _2_8_2_1='28:2:1' # Белогорское, Белогорское, Амурская область
    _2_8_2_4='28:2:4' # Советское, Белогорское, Амурская область
    _3_5_15_10='35:15:10' # Унженское, Никольское, Вологодская область
    _8_3_1='8:3:1' # Джалыковское, Каспийское, Республика Калмыкия
    _8_3_2='8:3:2' # Каспийское, Каспийское, Республика Калмыкия
    _8_3_3='8:3:3' # Комсомольское, Каспийское, Республика Калмыкия
    _8_3_4='8:3:4' # Прикумское, Каспийское, Республика Калмыкия
    _8_3_5='8:3:5' # Цаган-Аманское, Каспийское, Республика Калмыкия
    _8_3_6='8:3:6' # Черноземельское, Каспийское, Республика Калмыкия
    _6_4_1_2='64:1:2' # Роговское, Аркадакское, Саратовская область
    _6_4_1_1='64:1:1' # Ильменское, Аркадакское, Саратовская область
    _6_4_1_3='64:1:3' # Турковское, Аркадакское, Саратовская область
    _3_4_13_1='34:13:1' # Нижнечирское, Нижнечирское, Волгоградская область
    _3_4_13_2='34:13:2' # Суровикинское, Нижнечирское, Волгоградская область
    _3_4_13_3='34:13:3' # Тормосиновское, Нижнечирское, Волгоградская область
    _1_4_13_2='14:13:2' # Хомустахское, Намское, Республика Саха (Якутия)
    _1_4_13_1='14:13:1' # Намское, Намское, Республика Саха (Якутия)
    _3_8_19_2='38:19:2' # Куйтунское, Куйтунское, Иркутская область
    _3_8_19_1='38:19:1' # Барлукское, Куйтунское, Иркутская область
    _3_4_3_3='34:3:3' # Приморское, Быковское, Волгоградская область
    _3_4_3_2='34:3:2' # Николаевское, Быковское, Волгоградская область
    _3_4_3_1='34:3:1' # Кисловское, Быковское, Волгоградская область
    _7_6_5_2='76:5:2' # Ивановское, ГКУ ЯО "Даниловское лесничество", Ярославская область
    _7_6_5_3='76:5:3' # Середское, ГКУ ЯО "Даниловское лесничество", Ярославская область
    _7_6_5_1='76:5:1' # Даниловское, ГКУ ЯО "Даниловское лесничество", Ярославская область
    _3_4_4_4='34:4:4' # Дубовское, Волгоградское, Волгоградская область
    _3_4_4_3='34:4:3' # Городищенское, Волгоградское, Волгоградская область
    _3_4_4_2='34:4:2' # Горно-Балыклейское, Волгоградское, Волгоградская область
    _3_4_4_1='34:4:1' # Вертячинское, Волгоградское, Волгоградская область
    _1_1_3_4='11:3:4' # Пучкомское, Ертомское, Республика Коми
    _1_1_3_3='11:3:3' # Ертомское, Ертомское, Республика Коми
    _1_1_3_2='11:3:2' # Важгортское, Ертомское, Республика Коми
    _1_1_3_1='11:3:1' # Благоевское, Ертомское, Республика Коми
    _1_1_3_8='11:3:8' # Чупровское, Ертомское, Республика Коми
    _1_1_3_7='11:3:7' # Чимское, Ертомское, Республика Коми
    _1_1_3_6='11:3:6' # Усть-Вачергское, Ертомское, Республика Коми
    _1_1_3_5='11:3:5' # Солнечное, Ертомское, Республика Коми
    _1_4_11_3='14:11:3' # Тюнгюлюнское, Мегино-Кангаласское, Республика Саха (Якутия)
    _1_4_11_2='14:11:2' # Майинское, Мегино-Кангаласское, Республика Саха (Якутия)
    _1_4_11_1='14:11:1' # Бестяхское, Мегино-Кангаласское, Республика Саха (Якутия)
    _6_3_7_2='63:7:2' # Кошкинское, Кошкинское, Самарская область
    _6_3_7_1='63:7:1' # Елховское, Кошкинское, Самарская область
    _3_17_7='3:17:7' # Сухинское, Кабанское, Республика Бурятия
    _3_17_6='3:17:6' # Степно-Дворецкое, Кабанское, Республика Бурятия
    _3_17_5='3:17:5' # Селенгинское, Кабанское, Республика Бурятия
    _3_17_4='3:17:4' # Каменское, Кабанское, Республика Бурятия
    _3_17_3='3:17:3' # Кабанское сельское, Кабанское, Республика Бурятия
    _4_0_6_3='40:6:3' # Угодско-Заводское, Жуковское, Калужская область
    _3_17_2='3:17:2' # Большереченское, Кабанское, Республика Бурятия
    _4_0_6_2='40:6:2' # Зареченское, Жуковское, Калужская область
    _3_17_1='3:17:1' # Байкало-Кударинское, Кабанское, Республика Бурятия
    _4_0_6_1='40:6:1' # Воробьевское, Жуковское, Калужская область
    _6_7_24_10='67:24:10' # Холмовское, Холм-Жирковское, Смоленская область
    _7_5_14_3='75:14:3' # Мангутское, Кыринское, Забайкальский край
    _7_5_14_2='75:14:2' # Кыринское, Кыринское, Забайкальский край
    _7_5_14_1='75:14:1' # Алтанское, Кыринское, Забайкальский край
    _4_4_21_9='44:21:9' # Панинское, Шарьинское, Костромская область
    _4_4_21_1='44:21:1' # 1-е Шангское, Шарьинское, Костромская область
    _4_4_21_2='44:21:2' # 2-е Шангское, Шарьинское, Костромская область
    _4_4_21_3='44:21:3' # Васенёвское, Шарьинское, Костромская область
    _4_4_21_4='44:21:4' # Дюковское, Шарьинское, Костромская область
    _4_4_21_5='44:21:5' # Ивановское, Шарьинское, Костромская область
    _4_4_21_6='44:21:6' # Майтихинское, Шарьинское, Костромская область
    _4_4_21_7='44:21:7' # Матвеевское, Шарьинское, Костромская область
    _4_4_21_8='44:21:8' # Одоевское, Шарьинское, Костромская область
    _3_9_7_4='39:7:4' # Полесское, Полесское, Калининградская область
    _3_9_7_3='39:7:3' # Калининское, Полесское, Калининградская область
    _3_9_7_6='39:7:6' # Славянское, Полесское, Калининградская область
    _8_5_1='8:5:1' # Красное, Элистинское, Республика Калмыкия
    _3_9_7_5='39:7:5' # Саранское, Полесское, Калининградская область
    _8_5_2='8:5:2' # Троицкое, Элистинское, Республика Калмыкия
    _8_5_3='8:5:3' # Элистинское, Элистинское, Республика Калмыкия
    _8_5_4='8:5:4' # Яшкулъское, Элистинское, Республика Калмыкия
    _3_9_7_2='39:7:2' # Ильичевское, Полесское, Калининградская область
    _3_9_7_1='39:7:1' # Залесовское, Полесское, Калининградская область
    _3_9_7_7='39:7:7' # Сосновское, Полесское, Калининградская область
    _2_8_5='2:8:5' # Новобелокатайское, Белокатайское, Республика Башкортостан
    _2_8_4='2:8:4' # Мечетлинское, Белокатайское, Республика Башкортостан
    _2_8_3='2:8:3' # Карлыхановское, Белокатайское, Республика Башкортостан
    _2_8_2='2:8:2' # Белянковское, Белокатайское, Республика Башкортостан
    _2_8_7='2:8:7' # Ургалинское, Белокатайское, Республика Башкортостан
    _2_8_6='2:8:6' # Старобелокатайское, Белокатайское, Республика Башкортостан
    _2_8_1='2:8:1' # Белокатайское сельское, Белокатайское, Республика Башкортостан
    _2_4_29_3='24:29:3' # Курагинское, Курагинское, Красноярский край
    _2_4_29_4='24:29:4' # Курагинское сельское, Курагинское, Красноярский край
    _2_4_29_5='24:29:5' # Табратское, Курагинское, Красноярский край
    _2_4_29_1='24:29:1' # Казырское, Курагинское, Красноярский край
    _2_4_29_2='24:29:2' # Кордовское, Курагинское, Красноярский край
    _3_3_7_10='33:7:10' # Покровское, Заречное, Владимирская область
    _2_9_10_10='29:10:10' # Хмельницкое, Коношское, Архангельская область
    _2_9_10_11='29:10:11' # Ширихановское, Коношское, Архангельская область
    _7_0_9_2='70:9:2' # Симанское, Кожевниковское, Томская область
    _7_0_9_3='70:9:3' # Ювалинское, Кожевниковское, Томская область
    _4_7_6_10='47:6:10' # Усть-Лужское, Кингисеппское, Ленинградская область
    _7_0_9_1='70:9:1' # Кожевниковское, Кожевниковское, Томская область
    _2_2_6_6='22:6:6' # Рассказихинское, Бобровское, Алтайский край
    _2_2_6_4='22:6:4' # Новоалтайское, Бобровское, Алтайский край
    _2_2_6_5='22:6:5' # Петровское, Бобровское, Алтайский край
    _2_2_6_2='22:6:2' # Большереченское, Бобровское, Алтайский край
    _2_2_6_3='22:6:3' # Калининское, Бобровское, Алтайский край
    _2_2_6_1='22:6:1' # Бобровское, Бобровское, Алтайский край
    _6_4_20_1='64:20:1' # Больше-Карайское, Романовское, Саратовская область
    _6_4_20_3='64:20:3' # Романовское, Романовское, Саратовская область
    _6_4_20_2='64:20:2' # Инясевское, Романовское, Саратовская область
    _1_6_6_2='16:6:2' # Сурнарское, Арское, Республика Татарстан (Татарстан)
    _1_6_6_1='16:6:1' # Балтасинское, Арское, Республика Татарстан (Татарстан)
    _1_6_6_3='16:6:3' # Тукайское, Арское, Республика Татарстан (Татарстан)
    _5_2_2_1='52:2:1' # Бурцевское, Балахнинское межрайонное, Нижегородская область
    _5_2_2_2='52:2:2' # Ильинское, Балахнинское межрайонное, Нижегородская область
    _5_2_2_3='52:2:3' # Козинское, Балахнинское межрайонное, Нижегородская область
    _5_2_2_4='52:2:4' # Лукинское, Балахнинское межрайонное, Нижегородская область
    _3_2_2='3:2:2' # Выдринское, Бабушкинское, Республика Бурятия
    _3_2_1='3:2:1' # Бабушкинское, Бабушкинское, Республика Бурятия
    _3_2_4='3:2:4' # Танхойское, Бабушкинское, Республика Бурятия
    _3_2_3='3:2:3' # Клюевское, Бабушкинское, Республика Бурятия
    _3_2_5='3:2:5' # Чеховское, Бабушкинское, Республика Бурятия
    _5_2_2_5='52:2:5' # Правдинское, Балахнинское межрайонное, Нижегородская область
    _2_7_9_2='27:9:2' # Октябрьское, Горинское, Хабаровский край
    _2_7_9_3='27:9:3' # Снежное, Горинское, Хабаровский край
    _2_7_9_4='27:9:4' # Хурмулинское, Горинское, Хабаровский край
    _2_7_9_1='27:9:1' # Горинское, Горинское, Хабаровский край
    _6_9_3_2='69:3:2' # Воронцовское, Кашинское, Тверская область
    _6_9_3_3='69:3:3' # Ильинское, Кашинское, Тверская область
    _6_9_3_4='69:3:4' # Калязинское, Кашинское, Тверская область
    _6_9_3_5='69:3:5' # Кашинское, Кашинское, Тверская область
    _6_9_3_1='69:3:1' # Бубновское, Кашинское, Тверская область
    _6_9_3_6='69:3:6' # Кесовогорское, Кашинское, Тверская область
    _6_9_3_7='69:3:7' # Кимрское, Кашинское, Тверская область
    _6_9_3_8='69:3:8' # Нерльское, Кашинское, Тверская область
    _6_9_3_9='69:3:9' # Никулинское, Кашинское, Тверская область
    _4_6_2_1='46:2:1' # Дмитриевское, Дмитриевское, Курская область
    _4_6_2_2='46:2:2' # Клинковское, Дмитриевское, Курская область
    _4_6_2_3='46:2:3' # Снижанское, Дмитриевское, Курская область
    _1_1_29_6='11:29:6' # Шэрьягское, Усть-Немское, Республика Коми
    _1_1_29_5='11:29:5' # Усть-Немское, Усть-Немское, Республика Коми
    _1_1_29_4='11:29:4' # Тимшерское, Усть-Немское, Республика Коми
    _1_1_29_3='11:29:3' # Смолянское, Усть-Немское, Республика Коми
    _1_1_29_2='11:29:2' # Немское, Усть-Немское, Республика Коми
    _1_1_29_1='11:29:1' # Мылвинское, Усть-Немское, Республика Коми
    _7_6_6_3='76:6:3' # Любимское, ГКУ ЯО "Любимское лесничество", Ярославская область
    _7_6_6_4='76:6:4' # Павловское, ГКУ ЯО "Любимское лесничество", Ярославская область
    _7_6_6_1='76:6:1' # Бедаревское, ГКУ ЯО "Любимское лесничество", Ярославская область
    _7_6_6_2='76:6:2' # Кулижское, ГКУ ЯО "Любимское лесничество", Ярославская область
    _2_7_38_3='27:38:3' # Кафэнское, Хорское, Хабаровский край
    _2_7_38_2='27:38:2' # Катэнское, Хорское, Хабаровский край
    _5_1_9_3='51:9:3' # Никельское, Печенгское, Мурманская область
    _2_7_38_1='27:38:1' # Бичевское, Хорское, Хабаровский край
    _5_1_9_1='51:9:1' # Аллареченское, Печенгское, Мурманская область
    _5_1_9_2='51:9:2' # Лоттское, Печенгское, Мурманская область
    _2_7_38_6='27:38:6' # Чиркинское, Хорское, Хабаровский край
    _2_7_38_5='27:38:5' # Лазовское, Хорское, Хабаровский край
    _2_7_38_4='27:38:4' # Киинское, Хорское, Хабаровский край
    _2_4_16_8='24:16:8' # Рудиковское, Енисейское, Красноярский край
    _2_4_16_7='24:16:7' # Озерновское, Енисейское, Красноярский край
    _2_4_16_6='24:16:6' # Назимовское, Енисейское, Красноярский край
    _7_1_3_1='71:3:1' # Кимовское, Богородицкое, Тульская область
    _2_4_16_5='24:16:5' # Маклаковское, Енисейское, Красноярский край
    _7_1_3_2='71:3:2' # Пригородное, Богородицкое, Тульская область
    _2_4_16_9='24:16:9' # Усть-Питское, Енисейское, Красноярский край
    _2_4_16_4='24:16:4' # Лосиноборское, Енисейское, Красноярский край
    _2_4_16_3='24:16:3' # Каргинское, Енисейское, Красноярский край
    _2_4_16_2='24:16:2' # Епишинское, Енисейское, Красноярский край
    _2_4_16_1='24:16:1' # Енисейское, Енисейское, Красноярский край
    _2_7_25_4='27:25:4' # Эльбанское, Падалинское, Хабаровский край
    _2_7_25_2='27:25:2' # Верхне-Курское, Падалинское, Хабаровский край
    _2_7_25_3='27:25:3' # Падалинское, Падалинское, Хабаровский край
    _2_7_25_1='27:25:1' # Амурское, Падалинское, Хабаровский край
    _5_2_17_4='52:17:4' # Саваслейское, Кулебакское районное, Нижегородская область
    _5_2_17_3='52:17:3' # Кулебакское, Кулебакское районное, Нижегородская область
    _5_2_17_5='52:17:5' # Тепловское, Кулебакское районное, Нижегородская область
    _5_2_17_2='52:17:2' # Красненское, Кулебакское районное, Нижегородская область
    _5_2_17_1='52:17:1' # Велетьменское, Кулебакское районное, Нижегородская область
    _4_7_11_14='47:11:14' # Толмачевское, Лужское, Ленинградская область
    _4_7_11_15='47:11:15' # Череменецкое, Лужское, Ленинградская область
    _4_7_11_12='47:11:12' # Печковское, Лужское, Ленинградская область
    _4_7_11_13='47:11:13' # Сяберское, Лужское, Ленинградская область
    _4_7_11_10='47:11:10' # Оредежское, Лужское, Ленинградская область
    _4_7_11_11='47:11:11' # Осьминское, Лужское, Ленинградская область
    _4_7_11_16='47:11:16' # Чоловское, Лужское, Ленинградская область
    _4_7_11_17='47:11:17' # Шильцевское, Лужское, Ленинградская область
    _1_0_9_9='10:9:9' # Суккозерское, Муезерское, Республика Карелия
    _1_0_9_8='10:9:8' # Ругозерское, Муезерское, Республика Карелия
    _1_0_9_5='10:9:5' # Лендерское, Муезерское, Республика Карелия
    _1_0_9_4='10:9:4' # Конец-Островское, Муезерское, Республика Карелия
    _1_0_9_7='10:9:7' # Ребольское, Муезерское, Республика Карелия
    _1_0_9_6='10:9:6' # Пенингское, Муезерское, Республика Карелия
    _1_0_9_1='10:9:1' # Воломское, Муезерское, Республика Карелия
    _1_0_9_3='10:9:3' # Кимоваарское, Муезерское, Республика Карелия
    _1_0_9_2='10:9:2' # Кимасозерское, Муезерское, Республика Карелия
    _7_2_17_2='72:17:2' # Боровское, Тюменское, Тюменская область
    _7_2_17_1='72:17:1' # Богандинское, Тюменское, Тюменская область
    _7_2_17_4='72:17:4' # Каменское, Тюменское, Тюменская область
    _7_2_17_3='72:17:3' # Винзилинское, Тюменское, Тюменская область
    _8_4_1='8:4:1' # Большецарынское, Октябрьское, Республика Калмыкия
    _8_4_2='8:4:2' # Малодербетовское, Октябрьское, Республика Калмыкия
    _8_4_3='8:4:3' # Плодовитенское, Октябрьское, Республика Калмыкия
    _3_8_18_3='38:18:3' # Кировское, Кировское, Иркутская область
    _3_8_18_2='38:18:2' # Казачинское, Кировское, Иркутская область
    _3_8_18_4='38:18:4' # Тихоновское, Кировское, Иркутская область
    _3_8_18_1='38:18:1' # Боханское, Кировское, Иркутская область
    _6_8_9_5='68:9:5' # Столовское, Тамбовское, Тамбовская область
    _6_8_9_3='68:9:3' # Пригородное, Тамбовское, Тамбовская область
    _6_8_9_4='68:9:4' # Рассказовское, Тамбовское, Тамбовская область
    _6_8_9_1='68:9:1' # Новолядинское, Тамбовское, Тамбовская область
    _6_8_9_2='68:9:2' # Платоновское, Тамбовское, Тамбовская область
    _7_2_17_6='72:17:6' # Мичуринское, Тюменское, Тюменская область
    _7_2_17_5='72:17:5' # Левашовское, Тюменское, Тюменская область
    _7_2_17_8='72:17:8' # Туринское, Тюменское, Тюменская область
    _7_2_17_7='72:17:7' # Тахталинское, Тюменское, Тюменская область
    _4_5_8_1='45:8:1' # Макушинское, Петуховское, Курганская область
    _2_7_12_2='27:12:2' # Маноминское, Иннокентьевское, Хабаровский край
    _4_5_8_2='45:8:2' # Петуховское, Петуховское, Курганская область
    _2_7_12_3='27:12:3' # Славянское, Иннокентьевское, Хабаровский край
    _7_2_17_9='72:17:9' # Тюменское, Тюменское, Тюменская область
    _2_7_12_1='27:12:1' # Иннокентьевское, Иннокентьевское, Хабаровский край
    _4_5_8_3='45:8:3' # Частоозёрское, Петуховское, Курганская область
    _4_0_5_5='40:5:5' # Судимирское, Жиздринское, Калужская область
    _4_0_5_4='40:5:4' # Огорское, Жиздринское, Калужская область
    _4_0_5_3='40:5:3' # Зикеевское, Жиздринское, Калужская область
    _4_0_5_2='40:5:2' # Жиздринское, Жиздринское, Калужская область
    _4_0_5_1='40:5:1' # Болвинское, Жиздринское, Калужская область
    _3_4_12_2='34:12:2' # Глинищанское, Михайловское, Волгоградская область
    _3_4_12_3='34:12:3' # Михайловское, Михайловское, Волгоградская область
    _3_4_12_1='34:12:1' # Безымянское, Михайловское, Волгоградская область
    _3_4_12_4='34:12:4' # Михайловское сельское, Михайловское, Волгоградская область
    _3_4_12_5='34:12:5' # Рахинское, Михайловское, Волгоградская область
    _1_4_25_4='14:25:4' # Шестаковское, Якутское, Республика Саха (Якутия)
    _1_4_25_2='14:25:2' # Маганское, Якутское, Республика Саха (Якутия)
    _1_4_25_3='14:25:3' # Мархинское, Якутское, Республика Саха (Якутия)
    _1_4_25_1='14:25:1' # Городское, Якутское, Республика Саха (Якутия)
    _1_1_16_2='11:16:2' # Канинское, Печорское, Республика Коми
    _1_1_16_1='11:16:1' # Интинское, Печорское, Республика Коми
    _1_1_16_5='11:16:5' # Сынинское, Печорское, Республика Коми
    _1_1_16_4='11:16:4' # Левобережное, Печорское, Республика Коми
    _1_1_16_3='11:16:3' # Конецборское, Печорское, Республика Коми
    _2_8_3_1='28:3:1' # Городское, Благовещенское, Амурская область
    _2_8_3_2='28:3:2' # Натальинское, Благовещенское, Амурская область
    _2_8_3_3='28:3:3' # Сергеевское, Благовещенское, Амурская область
    _5_7_4_1='57:4:1' # Должанское, Ливенское, Орловская область
    _4_2_17_4='42:17:4' # Топкинское, Юргинское, Кемеровская область
    _4_2_17_5='42:17:5' # Шишинское, Юргинское, Кемеровская область
    _4_2_17_2='42:17:2' # Новоромановское, Юргинское, Кемеровская область
    _5_7_4_5='57:4:5' # Русско-Бродское, Ливенское, Орловская область
    _4_2_17_3='42:17:3' # Проскоковское, Юргинское, Кемеровская область
    _5_7_4_4='57:4:4' # Никольское, Ливенское, Орловская область
    _5_7_4_3='57:4:3' # Краснозоренское, Ливенское, Орловская область
    _4_2_17_1='42:17:1' # Зарубинское, Юргинское, Кемеровская область
    _5_7_4_2='57:4:2' # Колпнянское, Ливенское, Орловская область
    _2_7_20_7='27:20:7' # Троицкое, Нанайское, Хабаровский край
    _3_3_1='3:3:1' # Байкальское, Байкальское, Республика Бурятия
    _3_3_3='3:3:3' # Горячинское, Байкальское, Республика Бурятия
    _3_3_2='3:3:2' # Голондинское, Байкальское, Республика Бурятия
    _3_3_5='3:3:5' # Туркинское, Байкальское, Республика Бурятия
    _3_3_4='3:3:4' # Котокельское, Байкальское, Республика Бурятия
    _2_7_20_1='27:20:1' # Анюйское, Нанайское, Хабаровский край
    _2_7_20_2='27:20:2' # Верхне-Анюйское, Нанайское, Хабаровский край
    _2_7_20_5='27:20:5' # Озерное, Нанайское, Хабаровский край
    _2_7_20_6='27:20:6' # Синдинское, Нанайское, Хабаровский край
    _2_7_20_3='27:20:3' # Гассинское, Нанайское, Хабаровский край
    _2_7_20_4='27:20:4' # Елабужское, Нанайское, Хабаровский край
    _1_4_23_2='14:23:2' # Покровское, Хангаласское, Республика Саха (Якутия)
    _1_4_23_3='14:23:3' # Синское, Хангаласское, Республика Саха (Якутия)
    _3_4_15_3='34:15:3' # Ольховское сельское, Ольховское, Волгоградская область
    _3_4_15_4='34:15:4' # Солодчинское, Ольховское, Волгоградская область
    _3_4_15_1='34:15:1' # Гусёвское, Ольховское, Волгоградская область
    _3_4_15_2='34:15:2' # Ольховское, Ольховское, Волгоградская область
    _1_4_23_1='14:23:1' # Ботомское, Хангаласское, Республика Саха (Якутия)
    _7_2_12_1='72:12:1' # Антипинское, Нижнетавдинское, Тюменская область
    _6_4_10_1='64:10:1' # Бакурское, Екатериновское, Саратовская область
    _6_4_10_2='64:10:2' # Екатериновское, Екатериновское, Саратовская область
    _7_2_12_3='72:12:3' # Карагандинское, Нижнетавдинское, Тюменская область
    _7_2_12_2='72:12:2' # Велижанское, Нижнетавдинское, Тюменская область
    _7_2_12_5='72:12:5' # Кунчурское, Нижнетавдинское, Тюменская область
    _7_2_12_4='72:12:4' # Ключевское, Нижнетавдинское, Тюменская область
    _7_2_12_7='72:12:7' # Нижнетавдинское, Нижнетавдинское, Тюменская область
    _7_2_12_6='72:12:6' # Миясское, Нижнетавдинское, Тюменская область
    _7_2_12_8='72:12:8' # Новотроицкое, Нижнетавдинское, Тюменская область
    _5_5_14_4='55:14:4' # Нововаршавское сельское, Степное, Омская область
    _5_5_14_3='55:14:3' # Нововаршавское, Степное, Омская область
    _5_5_14_2='55:14:2' # Азовское сельское, Степное, Омская область
    _5_5_14_1='55:14:1' # Азовское, Степное, Омская область
    _5_5_14_8='55:14:8' # Русско-Полянское сельское, Степное, Омская область
    _5_5_14_7='55:14:7' # Русско-Полянское, Степное, Омская область
    _5_5_14_6='55:14:6' # Павлоградское сельское, Степное, Омская область
    _5_5_14_5='55:14:5' # Павлоградское, Степное, Омская область
    _5_5_14_9='55:14:9' # Таврическое, Степное, Омская область
    _3_3_7_2='33:7:2' # Вольгинское, Заречное, Владимирская область
    _3_3_7_1='33:7:1' # Болдинское, Заречное, Владимирская область
    _3_3_7_4='33:7:4' # Заречное, Заречное, Владимирская область
    _3_3_7_3='33:7:3' # Воспушинское, Заречное, Владимирская область
    _3_3_7_6='33:7:6' # Костинское, Заречное, Владимирская область
    _3_3_7_5='33:7:5' # Клязьменское, Заречное, Владимирская область
    _3_3_7_8='33:7:8' # Пекшинское, Заречное, Владимирская область
    _3_3_7_7='33:7:7' # Панфиловское, Заречное, Владимирская область
    _3_3_7_9='33:7:9' # Петушинское, Заречное, Владимирская область
    _1_1_11_6='11:11:6' # Тылайское, Летское, Республика Коми
    _1_1_11_5='11:11:5' # Слудское, Летское, Республика Коми
    _1_1_11_4='11:11:4' # Мутницкое, Летское, Республика Коми
    _1_4_10_5='14:10:5' # Хамринское, Ленское, Республика Саха (Якутия)
    _1_1_11_3='11:11:3' # Ловлинское, Летское, Республика Коми
    _1_4_10_4='14:10:4' # Таежное, Ленское, Республика Саха (Якутия)
    _1_1_11_2='11:11:2' # Летское, Летское, Республика Коми
    _1_1_11_1='11:11:1' # Верхолузское, Летское, Республика Коми
    _1_4_10_1='14:10:1' # Витимское, Ленское, Республика Саха (Якутия)
    _1_4_10_3='14:10:3' # Нюйское, Ленское, Республика Саха (Якутия)
    _1_4_10_2='14:10:2' # Городское, Ленское, Республика Саха (Якутия)
    _6_3_6_3='63:6:3' # Клявлинское, Клявлинское, Самарская область
    _6_3_6_2='63:6:2' # Камышлинское, Клявлинское, Самарская область
    _6_3_6_1='63:6:1' # Бор-Игарское, Клявлинское, Самарская область
    _1_0_4_6='10:4:6' # Нелгомозерское, Кондопожское, Республика Карелия
    _1_0_4_5='10:4:5' # Марциальное, Кондопожское, Республика Карелия
    _1_0_4_8='10:4:8' # Юркостровское, Кондопожское, Республика Карелия
    _1_0_4_7='10:4:7' # Сандальское, Кондопожское, Республика Карелия
    _1_0_4_2='10:4:2' # Кондопожское, Кондопожское, Республика Карелия
    _1_0_4_1='10:4:1' # Гирвасское, Кондопожское, Республика Карелия
    _1_0_4_4='10:4:4' # Кяппесельгское, Кондопожское, Республика Карелия
    _1_0_4_3='10:4:3' # Кончезерское, Кондопожское, Республика Карелия
    _1_1_24_5='11:24:5' # Куратовское, Сысольское, Республика Коми
    _6_4_23_2='64:23:2' # Покурлейское, Черкасское, Саратовская область
    _1_1_24_4='11:24:4' # Копсинское, Сысольское, Республика Коми
    _6_4_23_1='64:23:1' # Колоярское, Черкасское, Саратовская область
    _1_1_24_3='11:24:3' # Исаневское, Сысольское, Республика Коми
    _1_1_24_2='11:24:2' # Заозерское, Сысольское, Республика Коми
    _6_4_23_3='64:23:3' # Черкасское, Черкасское, Саратовская область
    _1_1_24_1='11:24:1' # Визингское, Сысольское, Республика Коми
    _1_1_24_7='11:24:7' # Чухлэмское, Сысольское, Республика Коми
    _1_1_24_6='11:24:6' # Пыелдинское, Сысольское, Республика Коми
    _3_9_4_1='39:4:1' # Балтийское, Калининградское, Калининградская область
    _3_9_4_7='39:4:7' # Северное, Калининградское, Калининградская область
    _3_9_4_6='39:4:6' # Светлогорское, Калининградское, Калининградская область
    _3_9_4_8='39:4:8' # Семеновское, Калининградское, Калининградская область
    _3_9_4_3='39:4:3' # Матросовское, Калининградское, Калининградская область
    _3_7_3_11='37:3:11' # Шилыковское, Ивановское, Ивановская область
    _3_9_4_2='39:4:2' # Западное, Калининградское, Калининградская область
    _3_7_3_10='37:3:10' # Уводьское, Ивановское, Ивановская область
    _3_9_4_5='39:4:5' # Романовское, Калининградское, Калининградская область
    _3_9_4_4='39:4:4' # Переславское, Калининградское, Калининградская область
    _2_1_9_1='21:9:1' # Булинское, Шемуршинское, Чувашская Республика - Чувашия
    _2_1_9_2='21:9:2' # Трехбалтаевское, Шемуршинское, Чувашская Республика - Чувашия
    _2_1_9_3='21:9:3' # Турганкасинское, Шемуршинское, Чувашская Республика - Чувашия
    _2_1_9_4='21:9:4' # Чукальское, Шемуршинское, Чувашская Республика - Чувашия
    _2_1_9_5='21:9:5' # Шемуршинское, Шемуршинское, Чувашская Республика - Чувашия
    _7_1_4_1='71:4:1' # Карницкое, Веневское, Тульская область
    _7_1_4_2='71:4:2' # Мордвесское, Веневское, Тульская область
    _3_27_1='3:27:1' # Гашейское, Мухоршибирское, Республика Бурятия
    _3_27_2='3:27:2' # Калиновское, Мухоршибирское, Республика Бурятия
    _3_27_3='3:27:3' # Мухоршибирское, Мухоршибирское, Республика Бурятия
    _3_27_4='3:27:4' # Мухоршибирское сельское, Мухоршибирское, Республика Бурятия
    _3_27_5='3:27:5' # Тугнуйское, Мухоршибирское, Республика Бурятия
    _3_27_6='3:27:6' # Хонхолойское, Мухоршибирское, Республика Бурятия
    _5_2_1_2='52:1:2' # Арзамасское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_3='52:1:3' # Вадское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_4='52:1:4' # Кирилловское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_5='52:1:5' # Коваксинское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_1='52:1:1' # Абрамовское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_6='52:1:6' # Сережинское, Арзамасское межрайонное, Нижегородская область
    _5_2_1_7='52:1:7' # Чернухинское, Арзамасское межрайонное, Нижегородская область
    _3_14_8='3:14:8' # Шара-Азаргинское, Закаменское, Республика Бурятия
    _3_14_7='3:14:7' # Цакирское, Закаменское, Республика Бурятия
    _3_14_6='3:14:6' # Цаган-Моринское, Закаменское, Республика Бурятия
    _3_14_5='3:14:5' # Санагинское, Закаменское, Республика Бурятия
    _3_14_4='3:14:4' # Михайловское, Закаменское, Республика Бурятия
    _3_14_3='3:14:3' # Закаменское сельское, Закаменское, Республика Бурятия
    _3_14_2='3:14:2' # Закаменское, Закаменское, Республика Бурятия
    _3_14_1='3:14:1' # Баянгольское, Закаменское, Республика Бурятия
    _5_8_13_3='58:13:3' # Сердобское-Софьинское, Сердобское, Пензенская область
    _5_8_13_1='58:13:1' # Бековское-Тамалинское, Сердобское, Пензенская область
    _5_8_13_2='58:13:2' # Секретарское-Колышлейское, Сердобское, Пензенская область
    _1_5_7_4='15:7:4' # Тарское, Пригородное, Республика Северная Осетия - Алания
    _1_5_7_3='15:7:3' # Сунженское, Пригородное, Республика Северная Осетия - Алания
    _1_5_7_2='15:7:2' # Октябрьское, Пригородное, Республика Северная Осетия - Алания
    _1_5_7_1='15:7:1' # Комгаронское, Пригородное, Республика Северная Осетия - Алания
    _1_5_7_5='15:7:5' # Терское, Пригородное, Республика Северная Осетия - Алания
    _1_0_12_13='10:12:13' # Шуйское, Прионежское, Республика Карелия
    _2_4_48_2='24:48:2' # Хатангское, Таймырское, Красноярский край
    _2_4_48_1='24:48:1' # Дудинское, Таймырское, Красноярский край
    _2_2_3_3='22:3:3' # Зимаревское, Барнаульское, Алтайский край
    _2_2_3_4='22:3:4' # Черемновское, Барнаульское, Алтайский край
    _2_2_3_1='22:3:1' # Барнаульское, Барнаульское, Алтайский край
    _2_2_3_2='22:3:2' # Власихинское, Барнаульское, Алтайский край
    _4_5_5_1='45:5:1' # Вохменское, Каргапольское, Курганская область
    _4_5_5_4='45:5:4' # Осиновское, Каргапольское, Курганская область
    _4_5_5_5='45:5:5' # Твердышское, Каргапольское, Курганская область
    _4_5_5_2='45:5:2' # Каргапольское, Каргапольское, Курганская область
    _4_5_5_3='45:5:3' # Кособродское, Каргапольское, Курганская область
    _4_5_5_6='45:5:6' # Чашинское, Каргапольское, Курганская область
    _7_6_7_2='76:7:2' # Мышкинское, ГКУ ЯО "Некоузское лесничество", Ярославская область
    _7_6_7_3='76:7:3' # Некоузское, ГКУ ЯО "Некоузское лесничество", Ярославская область
    _7_6_7_1='76:7:1' # Воскресенское, ГКУ ЯО "Некоузское лесничество", Ярославская область
    _5_1_8_2='51:8:2' # Тайбольское, Мурманское, Мурманская область
    _5_1_8_3='51:8:3' # Туломское, Мурманское, Мурманская область
    _5_1_8_1='51:8:1' # Пригородное, Мурманское, Мурманская область
    _6_9_2_3='69:2:3' # Велесское, Западнодвинское, Тверская область
    _6_9_2_4='69:2:4' # Верховское, Западнодвинское, Тверская область
    _6_9_2_5='69:2:5' # Гороватское, Западнодвинское, Тверская область
    _6_9_2_6='69:2:6' # Двинское, Западнодвинское, Тверская область
    _6_9_2_1='69:2:1' # Алексапольское, Западнодвинское, Тверская область
    _6_9_2_2='69:2:2' # Бельское, Западнодвинское, Тверская область
    _6_9_2_7='69:2:7' # Демяховское, Западнодвинское, Тверская область
    _6_9_2_8='69:2:8' # Дубоцкое, Западнодвинское, Тверская область
    _6_9_2_9='69:2:9' # Жарковское, Западнодвинское, Тверская область
    _5_4_11_3='54:11:3' # Краснозерский лесохозяйственный участок № 2, Краснозерское, Новосибирская область
    _5_4_11_4='54:11:4' # Питомнический лесохозяйственный участок, Краснозерское, Новосибирская область
    _5_4_11_1='54:11:1' # Веселовский лесохозяйственный участок, Краснозерское, Новосибирская область
    _5_4_11_2='54:11:2' # Краснозерский лесохозяйственный участок № 1, Краснозерское, Новосибирская область
    _6_7_22_4='67:22:4' # Всходское, Угранское, Смоленская область
    _6_7_22_3='67:22:3' # Будянское, Угранское, Смоленская область
    _6_7_22_2='67:22:2' # Баскаковское, Угранское, Смоленская область
    _6_7_22_1='67:22:1' # Арнишинское, Угранское, Смоленская область
    _6_7_22_8='67:22:8' # Знаменское сельское, Угранское, Смоленская область
    _6_7_22_7='67:22:7' # Знаменское, Угранское, Смоленская область
    _6_7_22_6='67:22:6' # Дмитровское, Угранское, Смоленская область
    _6_7_22_5='67:22:5' # Всходское сельское, Угранское, Смоленская область
    _6_7_22_9='67:22:9' # Мытишинское, Угранское, Смоленская область
    _2_9_4='2:9:4' # Журавлинское, Белорецкое, Республика Башкортостан
    _2_9_3='2:9:3' # Белорецкое сельское, Белорецкое, Республика Башкортостан
    _2_9_2='2:9:2' # Белорецкое, Белорецкое, Республика Башкортостан
    _2_9_1='2:9:1' # Абзаковское, Белорецкое, Республика Башкортостан
    _2_9_7='2:9:7' # Сосновское, Белорецкое, Республика Башкортостан
    _2_9_6='2:9:6' # Серменевское, Белорецкое, Республика Башкортостан
    _2_9_5='2:9:5' # Ишлинское, Белорецкое, Республика Башкортостан
    _2_7_6_1='27:6:1' # Болоньское, Болоньское, Хабаровский край
    _2_4_22_2='24:22:2' # Канское сельское, Канское, Красноярский край
    _2_7_6_2='27:6:2' # Сельгонское, Болоньское, Хабаровский край
    _2_4_22_3='24:22:3' # Северное, Канское, Красноярский край
    _2_7_6_3='27:6:3' # Харпинское, Болоньское, Хабаровский край
    _2_4_22_4='24:22:4' # Таежное, Канское, Красноярский край
    _2_4_22_1='24:22:1' # Канское, Канское, Красноярский край
    _5_4_24_5='54:24:5' # Щегловский лесохозяйственный участок, Чановское, Новосибирская область
    _5_4_24_4='54:24:4' # Чановский лесохозяйственный участок, Чановское, Новосибирская область
    _5_4_24_3='54:24:3' # Тебисский лесохозяйственный участок, Чановское, Новосибирская область
    _5_4_24_2='54:24:2' # Старокарачинский лесохозяйственный участок, Чановское, Новосибирская область
    _5_4_24_1='54:24:1' # Отреченский лесохозяйственный участок, Чановское, Новосибирская область
    _7_5_23_1='75:23:1' # Намингинское, Чарское, Забайкальский край
    _7_5_23_2='75:23:2' # Нелятинское, Чарское, Забайкальский край
    _7_5_23_3='75:23:3' # Удоканское, Чарское, Забайкальский край
    _7_5_23_4='75:23:4' # Чарское, Чарское, Забайкальский край
    _3_4_1_7='34:1:7' # Усть-Бузулукское, Алексеевское, Волгоградская область
    _3_4_1_6='34:1:6' # Тишанское, Алексеевское, Волгоградская область
    _3_4_1_5='34:1:5' # Нехаевское сельское, Алексеевское, Волгоградская область
    _3_4_1_4='34:1:4' # Нехаевское, Алексеевское, Волгоградская область
    _3_4_1_3='34:1:3' # Захоперское, Алексеевское, Волгоградская область
    _3_4_1_2='34:1:2' # Алексеевское сельское, Алексеевское, Волгоградская область
    _3_4_1_1='34:1:1' # Алексеевское, Алексеевское, Волгоградская область
    _4_0_2_1='40:2:1' # Кондровское, Дзержинское, Калужская область
    _4_0_2_4='40:2:4' # Остроженское, Дзержинское, Калужская область
    _4_0_2_3='40:2:3' # Озеренское, Дзержинское, Калужская область
    _4_0_2_2='40:2:2' # Льва Толстовское, Дзержинское, Калужская область
    _7_5_10_3='75:10:3' # Таптанайское, Дульдургинское, Забайкальский край
    _7_5_10_2='75:10:2' # Дульдургинское, Дульдургинское, Забайкальский край
    _7_5_10_1='75:10:1' # Верх-Оленгуйское, Дульдургинское, Забайкальский край
    _2_4_35_4='24:35:4' # Орджоникидзевское, Мотыгинское, Красноярский край
    _2_4_35_5='24:35:5' # Первомайское, Мотыгинское, Красноярский край
    _2_4_35_6='24:35:6' # Раздолинское, Мотыгинское, Красноярский край
    _2_4_35_7='24:35:7' # Южно-Енисейское, Мотыгинское, Красноярский край
    _2_4_35_1='24:35:1' # Кировское, Мотыгинское, Красноярский край
    _2_4_35_2='24:35:2' # Кулаковское, Мотыгинское, Красноярский край
    _2_4_35_3='24:35:3' # Мотыгинское, Мотыгинское, Красноярский край
    _2_7_33_4='27:33:4' # Ярапское, Уликанское, Хабаровский край
    _2_7_33_3='27:33:3' # Уликанское, Уликанское, Хабаровский край
    _2_7_33_2='27:33:2' # Ниранское, Уликанское, Хабаровский край
    _2_7_33_1='27:33:1' # Бираканское, Уликанское, Хабаровский край
    _6_8_8_1='68:8:1' # Знаменское, Степное, Тамбовская область
    _1_4_24_1='14:24:1' # Диринское, Чурапчинское, Республика Саха (Якутия)
    _1_4_24_2='14:24:2' # Чурапчинское, Чурапчинское, Республика Саха (Якутия)
    _6_8_8_2='68:8:2' # Кандауровское, Степное, Тамбовская область
    _6_8_8_3='68:8:3' # Котовское, Степное, Тамбовская область
    _1_0_12_12='10:12:12' # Шокшинское, Прионежское, Республика Карелия
    _1_0_12_11='10:12:11' # Шелтозерское, Прионежское, Республика Карелия
    _1_0_12_10='10:12:10' # Рыборецкое, Прионежское, Республика Карелия
    _2_30_3='2:30:3' # Южно-Уральское, Хайбуллинское, Республика Башкортостан
    _2_30_2='2:30:2' # Усерганское, Хайбуллинское, Республика Башкортостан
    _2_30_1='2:30:1' # Степное, Хайбуллинское, Республика Башкортостан
    _6_4_22_2='64:22:2' # Усовское, Усовское, Саратовская область
    _6_4_22_1='64:22:1' # Белогродненское, Усовское, Саратовская область
    _3_4_6='3:4:6' # Читканское, Баргузинское, Республика Бурятия
    _5_7_3_2='57:3:2' # Дубравское, Дмитровское, Орловская область
    _3_4_5='3:4:5' # Уринское, Баргузинское, Республика Бурятия
    _5_7_3_1='57:3:1' # Долбенкинское, Дмитровское, Орловская область
    _1_1_10_6='11:10:6' # Усть-Локчимское, Корткеросское, Республика Коми
    _1_1_10_5='11:10:5' # Позтыкересское, Корткеросское, Республика Коми
    _1_1_10_4='11:10:4' # Пезмегское, Корткеросское, Республика Коми
    _1_1_10_3='11:10:3' # Маджское, Корткеросское, Республика Коми
    _1_1_10_2='11:10:2' # Корткеросское, Корткеросское, Республика Коми
    _5_7_3_4='57:3:4' # Черневское, Дмитровское, Орловская область
    _1_1_10_1='11:10:1' # Веселовское, Корткеросское, Республика Коми
    _5_7_3_3='57:3:3' # Неруссовское, Дмитровское, Орловская область
    _3_4_2='3:4:2' # Баргузинское сельское, Баргузинское, Республика Бурятия
    _3_4_1='3:4:1' # Баргузинское, Баргузинское, Республика Бурятия
    _3_4_4='3:4:4' # Улюнское, Баргузинское, Республика Бурятия
    _3_4_3='3:4:3' # Ининское, Баргузинское, Республика Бурятия
    _1_4_22_3='14:22:3' # Ыныкчанское, Усть-Майское, Республика Саха (Якутия)
    _1_4_22_4='14:22:4' # Эльдиканское, Усть-Майское, Республика Саха (Якутия)
    _1_4_22_1='14:22:1' # Усть-Майское, Усть-Майское, Республика Саха (Якутия)
    _1_4_22_2='14:22:2' # Усть-Мильское, Усть-Майское, Республика Саха (Якутия)
    _7_2_11_2='72:11:2' # Казанское, Казанское, Тюменская область
    _7_2_11_1='72:11:1' # Боровское, Казанское, Тюменская область
    _7_2_11_3='72:11:3' # Казанское сельское, Казанское, Тюменская область
    _1_0_3_3='10:3:3' # Куземское, Кемское, Республика Карелия
    _1_0_3_2='10:3:2' # Кемское, Кемское, Республика Карелия
    _1_0_3_5='10:3:5' # Поньгомское, Кемское, Республика Карелия
    _1_0_3_4='10:3:4' # Панозерское, Кемское, Республика Карелия
    _1_0_3_1='10:3:1' # Авнепорожское, Кемское, Республика Карелия
    _1_1_23_6='11:23:6' # Эжвинское, Сыктывкарское, Республика Коми
    _1_1_23_5='11:23:5' # Треозерное, Сыктывкарское, Республика Коми
    _1_1_23_4='11:23:4' # Сыктывкарское, Сыктывкарское, Республика Коми
    _1_1_23_3='11:23:3' # Нювчимское, Сыктывкарское, Республика Коми
    _3_3_8_1='33:8:1' # Вахромеевское, Камешковское, Владимирская область
    _1_1_23_2='11:23:2' # Краснозатонское, Сыктывкарское, Республика Коми
    _1_1_23_1='11:23:1' # Выльгортское, Сыктывкарское, Республика Коми
    _3_3_8_3='33:8:3' # Новкинское, Камешковское, Владимирская область
    _3_3_8_2='33:8:2' # Второвское, Камешковское, Владимирская область
    _3_3_8_4='33:8:4' # Пенкинское, Камешковское, Владимирская область
    _3_28_1='3:28:1' # Орликское, Окинское, Республика Бурятия
    _3_28_2='3:28:2' # Сорокское, Окинское, Республика Бурятия
    _4_2_16_3='42:16:3' # Чумайское, Чебулинское, Кемеровская область
    _4_2_16_1='42:16:1' # Николаевское, Чебулинское, Кемеровская область
    _4_2_16_2='42:16:2' # Чебулинское, Чебулинское, Кемеровская область
    _6_3_5_1='63:5:1' # Кинель-Черкасское, Кинель-Черкасское, Самарская область
    _7_5_25_1='75:25:1' # Городское, Читинское, Забайкальский край
    _7_5_25_2='75:25:2' # Кручининское, Читинское, Забайкальский край
    _7_5_25_3='75:25:3' # Сивяковское, Читинское, Забайкальский край
    _7_5_25_4='75:25:4' # Черновское, Читинское, Забайкальский край
    _6_3_5_3='63:5:3' # Тимашевское, Кинель-Черкасское, Самарская область
    _6_3_5_2='63:5:2' # Сарбайское, Кинель-Черкасское, Самарская область
    _3_15_7='3:15:7' # Харитоновское, Заудинское, Республика Бурятия
    _3_15_6='3:15:6' # Тарбагатайское сельское, Заудинское, Республика Бурятия
    _3_15_5='3:15:5' # Тарбагатайское, Заудинское, Республика Бурятия
    _3_15_4='3:15:4' # Талецкое, Заудинское, Республика Бурятия
    _3_15_3='3:15:3' # Саянтуйское, Заудинское, Республика Бурятия
    _3_15_2='3:15:2' # Заудинское, Заудинское, Республика Бурятия
    _3_15_1='3:15:1' # Заводское, Заудинское, Республика Бурятия
    _5_8_12_1='58:12:1' # Базарнокеньшенское, Никольское, Пензенская область
    _5_8_12_4='58:12:4' # Пестровское, Никольское, Пензенская область
    _5_8_12_5='58:12:5' # Сабановское, Никольское, Пензенская область
    _5_8_12_2='58:12:2' # Междуреченское, Никольское, Пензенская область
    _5_8_12_3='58:12:3' # Нижнешкафтинское-Казарское, Никольское, Пензенская область
    _7_1_5_1='71:5:1' # Каменское, Ефремовское, Тульская область
    _7_1_5_2='71:5:2' # Октябрьское, Ефремовское, Тульская область
    _5_1_6_2='51:6:2' # Ловозерское, Ловозерское, Мурманская область
    _5_1_6_1='51:6:1' # Верхне-Понойское, Ловозерское, Мурманская область
    _1_5_6_1='15:6:1' # Моздокское, Моздокское, Республика Северная Осетия - Алания
    _1_5_6_3='15:6:3' # Хуарикауское, Моздокское, Республика Северная Осетия - Алания
    _1_5_6_2='15:6:2' # Павлодольское, Моздокское, Республика Северная Осетия - Алания
    _5_6_9_1='56:9:1' # Домбаровское, Домбаровское, Оренбургская область
    _3_9_5_5='39:5:5' # Подгородненское, Краснознаменское, Калининградская область
    _3_9_5_2='39:5:2' # Краснознаменское, Краснознаменское, Калининградская область
    _3_9_5_1='39:5:1' # Верхне-Неманское, Краснознаменское, Калининградская область
    _3_9_5_4='39:5:4' # Неманское, Краснознаменское, Калининградская область
    _3_9_5_3='39:5:3' # Мичуринское, Краснознаменское, Калининградская область
    _5_5_15_3='55:15:3' # Колосовское сельское, Тарское, Омская область
    _5_5_15_2='55:15:2' # Колосовское, Тарское, Омская область
    _5_5_15_1='55:15:1' # Екатерининское, Тарское, Омская область
    _5_5_15_6='55:15:6' # Тарское, Тарское, Омская область
    _5_5_15_5='55:15:5' # Северо-Тарское, Тарское, Омская область
    _5_5_15_4='55:15:4' # Пригородно-Тарское, Тарское, Омская область
    _2_2_4_2='22:4:2' # Смоленское, Белокурихинское, Алтайский край
    _2_2_4_1='22:4:1' # Белокурихинское, Белокурихинское, Алтайский край
    _5_4_10_2='54:10:2' # Коченевский лесохозяйственный участок № 2, Коченевское, Новосибирская область
    _5_4_10_3='54:10:3' # Новомихайловский лесохозяйственный участок № 2, Коченевское, Новосибирская область
    _5_4_10_1='54:10:1' # Коченевский лесохозяйственный участок № 1, Коченевское, Новосибирская область
    _2_4_49_6='24:49:6' # Нижнетерянское, Терянское, Красноярский край
    _2_4_49_5='24:49:5' # Каталангское, Терянское, Красноярский край
    _2_4_49_2='24:49:2' # Иркинеевское, Терянское, Красноярский край
    _2_4_49_1='24:49:1' # Верхнетерянское, Терянское, Красноярский край
    _2_4_49_4='24:49:4' # Каменское, Терянское, Красноярский край
    _2_4_49_3='24:49:3' # Кажимское, Терянское, Красноярский край
    _2_5_1_11='25:1:11' # Чернышевское, Арсеньевское, Приморский край
    _2_5_1_12='25:1:12' # Яблоновское, Арсеньевское, Приморский край
    _2_5_1_13='25:1:13' # Яковлевское, Арсеньевское, Приморский край
    _2_5_1_14='25:1:14' # Яковлевское сельское, Арсеньевское, Приморский край
    _4_3_17_10='43:17:10' # Стахановское, Мурашинское, Кировская область
    _2_5_1_10='25:1:10' # Солнечное, Арсеньевское, Приморский край
    _2_7_7_1='27:7:1' # Киселёвское, Быстринское, Хабаровский край
    _2_7_7_2='27:7:2' # Ключевское, Быстринское, Хабаровский край
    _2_7_7_3='27:7:3' # Сухановское, Быстринское, Хабаровский край
    _6_9_1_4='69:1:4' # Кушалинское, Бежецкое, Тверская область
    _6_9_1_5='69:1:5' # Моркиногорское, Бежецкое, Тверская область
    _6_9_1_6='69:1:6' # Рамешковское, Бежецкое, Тверская область
    _6_9_1_7='69:1:7' # Северное Кушалинское, Бежецкое, Тверская область
    _6_9_1_1='69:1:1' # Бежецкое, Бежецкое, Тверская область
    _6_9_1_2='69:1:2' # Бережайское, Бежецкое, Тверская область
    _6_9_1_3='69:1:3' # Дрезненское, Бежецкое, Тверская область
    _5_4_23_5='54:23:5' # Черномысинский лесохозяйственный участок, Убинское, Новосибирская область
    _5_4_23_4='54:23:4' # Убинский лесохозяйственный участок № 2, Убинское, Новосибирская область
    _5_4_23_3='54:23:3' # Убинский лесохозяйственный участок № 1, Убинское, Новосибирская область
    _5_4_23_2='54:23:2' # Лячинский лесохозяйственный участок, Убинское, Новосибирская область
    _6_9_1_8='69:1:8' # Сонковское, Бежецкое, Тверская область
    _5_4_23_1='54:23:1' # Аникинский лесохозяйственный участок, Убинское, Новосибирская область
    _6_9_1_9='69:1:9' # Центральное Рамешковское, Бежецкое, Тверская область
    _4_5_6_3='45:6:3' # Старопросветское, Курганское, Курганская область
    _4_5_6_1='45:6:1' # Кетовское, Курганское, Курганская область
    _7_6_8_5='76:8:5' # Сольбинское, ГКУ ЯО "Переславское лесничество", Ярославская область
    _4_5_6_2='45:6:2' # Курганское, Курганское, Курганская область
    _7_6_8_3='76:8:3' # Рогозининское, ГКУ ЯО "Переславское лесничество", Ярославская область
    _7_6_8_4='76:8:4' # Рязанцевское, ГКУ ЯО "Переславское лесничество", Ярославская область
    _7_6_8_1='76:8:1' # Заладьевское, ГКУ ЯО "Переславское лесничество", Ярославская область
    _7_6_8_2='76:8:2' # Переславское, ГКУ ЯО "Переславское лесничество", Ярославская область
    _5_1_7_3='51:7:3' # Оленегорское, Мончегорское, Мурманская область
    _5_1_7_1='51:7:1' # Мончегорское, Мончегорское, Мурманская область
    _5_1_7_2='51:7:2' # Мончеозерское, Мончегорское, Мурманская область
    _6_7_10_2='67:10:2' # Шокинское, Кардымовское, Смоленская область
    _6_7_10_1='67:10:1' # Кардымовское, Кардымовское, Смоленская область
    _6_3_4_2='63:4:2' # Кинельское, Кинельское, Самарская область
    _6_3_4_1='63:4:1' # Богдановское, Кинельское, Самарская область
    _7_5_24_1='75:24:1' # Букачачинское, Чернышевское, Забайкальский край
    _7_5_24_2='75:24:2' # Бушулейское, Чернышевское, Забайкальский край
    _7_5_24_3='75:24:3' # Зиловское, Чернышевское, Забайкальский край
    _2_4_10_6='24:10:6' # Минское, Верхнеманское, Красноярский край
    _7_5_24_4='75:24:4' # Чернышевское, Чернышевское, Забайкальский край
    _2_4_10_5='24:10:5' # Койское, Верхнеманское, Красноярский край
    _2_4_10_4='24:10:4' # Карлыковское, Верхнеманское, Красноярский край
    _2_4_10_3='24:10:3' # Вершино-Рыбинское, Верхнеманское, Красноярский край
    _2_4_10_8='24:10:8' # Партизанское сельское, Верхнеманское, Красноярский край
    _2_4_10_7='24:10:7' # Партизанское, Верхнеманское, Красноярский край
    _2_4_10_2='24:10:2' # Верхнеманское, Верхнеманское, Красноярский край
    _2_4_10_1='24:10:1' # Аргазинское, Верхнеманское, Красноярский край
    _6_3_4_4='63:4:4' # Советское, Кинельское, Самарская область
    _6_3_4_3='63:4:3' # Красносамарское, Кинельское, Самарская область
    _7_5_11_7='75:11:7' # Черемховское, Ингодинское, Забайкальский край
    _7_5_11_6='75:11:6' # Татауровское, Ингодинское, Забайкальский край
    _7_5_11_5='75:11:5' # Тангинское, Ингодинское, Забайкальский край
    _7_5_11_4='75:11:4' # Николаевское, Ингодинское, Забайкальский край
    _7_5_11_3='75:11:3' # Доронинское, Ингодинское, Забайкальский край
    _7_5_11_2='75:11:2' # Верх-Ингодинское, Ингодинское, Забайкальский край
    _7_5_11_1='75:11:1' # Арейское, Ингодинское, Забайкальский край
    _2_8_1_3='28:1:3' # Татаканское, Архаринское, Амурская область
    _2_8_1_4='28:1:4' # Урильское, Архаринское, Амурская область
    _2_8_1_1='28:1:1' # Архаринское, Архаринское, Амурская область
    _2_8_1_2='28:1:2' # Кундурское, Архаринское, Амурская область
    _2_4_23_5='24:23:5' # Степное, Каратузское, Красноярский край
    _2_4_23_6='24:23:6' # Червизюльское, Каратузское, Красноярский край
    _2_4_23_1='24:23:1' # Верхне-Кужебарское, Каратузское, Красноярский край
    _2_4_23_2='24:23:2' # Каратузское, Каратузское, Красноярский край
    _2_4_23_3='24:23:3' # Нижне-Курятское, Каратузское, Красноярский край
    _2_4_23_4='24:23:4' # Подтаежное, Каратузское, Красноярский край
    _6_8_7_1='68:7:1' # Борковское, Серповское, Тамбовская область
    _6_8_7_2='68:7:2' # Пролетарское, Серповское, Тамбовская область
    _6_8_7_5='68:7:5' # Старотомниковское, Серповское, Тамбовская область
    _3_4_2_3='34:2:3' # Фроловское сельское, Арчединское, Волгоградская область
    _3_4_2_2='34:2:2' # Сосновское, Арчединское, Волгоградская область
    _6_8_7_3='68:7:3' # Раевское, Серповское, Тамбовская область
    _3_4_2_1='34:2:1' # Арчединское, Арчединское, Волгоградская область
    _6_8_7_4='68:7:4' # Ракшинское, Серповское, Тамбовская область
    _4_0_3_5='40:3:5' # Паликское, Думиничское, Калужская область
    _4_0_3_4='40:3:4' # Маклаковское, Думиничское, Калужская область
    _4_0_3_3='40:3:3' # Думиничское, Думиничское, Калужская область
    _4_0_3_2='40:3:2' # Высокское, Думиничское, Калужская область
    _4_0_3_1='40:3:1' # Брынское, Думиничское, Калужская область
    _6_7_23_2='67:23:2' # Хиславичское сельское, Хиславичское, Смоленская область
    _6_7_23_1='67:23:1' # Хиславичское, Хиславичское, Смоленская область
    _2_4_36_3='24:36:3' # Назаровское, Назаровское, Красноярский край
    _2_4_36_4='24:36:4' # Сахаптинское, Назаровское, Красноярский край
    _2_4_36_1='24:36:1' # Березовское, Назаровское, Красноярский край
    _2_4_36_2='24:36:2' # Медведское, Назаровское, Красноярский край
    _2_7_32_1='27:32:1' # Гурское, Уктурское, Хабаровский край
    _3_4_14_1='34:14:1' # Киквидзенское, Новоаннинское, Волгоградская область
    _3_4_14_2='34:14:2' # Новоаннинское, Новоаннинское, Волгоградская область
    _2_7_32_3='27:32:3' # Уктурское, Уктурское, Хабаровский край
    _3_4_14_3='34:14:3' # Новоаннинское сельское, Новоаннинское, Волгоградская область
    _2_7_32_2='27:32:2' # Джаурское, Уктурское, Хабаровский край
    _1_0_6_4='10:6:4' # Хийтольское, Лахденпохское, Республика Карелия
    _1_0_6_3='10:6:3' # Лахденпохское, Лахденпохское, Республика Карелия
    _1_0_6_6='10:6:6' # Яккимское, Лахденпохское, Республика Карелия
    _1_0_6_5='10:6:5' # Элисенваарское, Лахденпохское, Республика Карелия
    _1_0_6_2='10:6:2' # Куркиекское, Лахденпохское, Республика Карелия
    _1_0_6_1='10:6:1' # Ихальское, Лахденпохское, Республика Карелия
    _5_8_15_1='58:15:1' # Мачимское, Шемышейское, Пензенская область
    _5_8_15_2='58:15:2' # Узинское-Чиндясское, Шемышейское, Пензенская область
    _5_8_15_3='58:15:3' # Шемышейское-Чапаевское, Шемышейское, Пензенская область
    _3_5_5='3:5:5' # Окино-Ключевское, Бичурское, Республика Бурятия
    _3_5_4='3:5:4' # Куналейское, Бичурское, Республика Бурятия
    _3_5_1='3:5:1' # Бичурское, Бичурское, Республика Бурятия
    _3_5_3='3:5:3' # Киретское, Бичурское, Республика Бурятия
    _3_5_2='3:5:2' # Бичурское сельское, Бичурское, Республика Бурятия
    _5_6_8_1='56:8:1' # Грачевское, Грачевское, Оренбургская область
    _3_4_17_1='34:17:1' # Еланское, Руднянское, Волгоградская область
    _3_4_17_2='34:17:2' # Матышевское, Руднянское, Волгоградская область
    _1_4_21_2='14:21:2' # Сырдахское, Усть-Алданское, Республика Саха (Якутия)
    _3_4_17_3='34:17:3' # Руднянское, Руднянское, Волгоградская область
    _1_4_21_1='14:21:1' # Дюпсинское, Усть-Алданское, Республика Саха (Якутия)
    _6_4_12_1='64:12:1' # Ахтубинское, Калининское, Саратовская область
    _6_4_12_2='64:12:2' # Калининское, Калининское, Саратовская область
    _3_8_8_2='38:8:2' # Малоголоустненское, Голоустненское, Иркутская область
    _3_8_8_1='38:8:1' # Большеголоустненское, Голоустненское, Иркутская область
    _4_7_7_10='47:7:10' # Пчевжинское, Киришское, Ленинградская область
    _1_6_3_1='16:3:1' # Аксубаевское, Аксубаевское, Республика Татарстан (Татарстан)
    _1_6_3_3='16:3:3' # Чебоксарское, Аксубаевское, Республика Татарстан (Татарстан)
    _1_6_3_2='16:3:2' # Ибрайкинское, Аксубаевское, Республика Татарстан (Татарстан)
    _5_1_5_3='51:5:3' # Нотозерское, Кольское, Мурманская область
    _5_1_5_1='51:5:1' # Гирвасское, Кольское, Мурманская область
    _5_1_5_2='51:5:2' # Мурмашинское, Кольское, Мурманская область
    _4_2_19_4='42:19:4' # Тайгинское, Яшкинское, Кемеровская область
    _4_2_19_5='42:19:5' # Яшкинское, Яшкинское, Кемеровская область
    _4_2_19_2='42:19:2' # Пашковское, Яшкинское, Кемеровская область
    _4_2_19_3='42:19:3' # Сурановское, Яшкинское, Кемеровская область
    _4_2_19_1='42:19:1' # Пачинское, Яшкинское, Кемеровская область
    _3_9_2_1='39:2:1' # Гвардейское, Гвардейское, Калининградская область
    _3_9_2_3='39:2:3' # Первомайское, Гвардейское, Калининградская область
    _3_9_2_2='39:2:2' # Новодеревенское, Гвардейское, Калининградская область
    _3_9_2_4='39:2:4' # Придорожное, Гвардейское, Калининградская область
    _3_12_1='3:12:1' # Гундинское, Еравнинское, Республика Бурятия
    _2_1_7_1='21:7:1' # Ильинское, Опытное, Чувашская Республика - Чувашия
    _2_1_7_2='21:7:2' # Карачуринское, Опытное, Чувашская Республика - Чувашия
    _5_5_16_2='55:16:2' # Бородинское, Тевризское, Омская область
    _2_1_7_3='21:7:3' # Сорминское, Опытное, Чувашская Республика - Чувашия
    _5_5_16_1='55:16:1' # Белоярское, Тевризское, Омская область
    _2_1_7_4='21:7:4' # Цивильское, Опытное, Чувашская Республика - Чувашия
    _5_5_16_4='55:16:4' # Тевризское сельское, Тевризское, Омская область
    _5_5_16_3='55:16:3' # Тевризское, Тевризское, Омская область
    _8_9_1_1='89:1:1' # Красноселькупское, Красноселькупское, Ямало-Ненецкий автономный округ
    _7_1_6_1='71:6:1' # Нечаевское, Заокское, Тульская область
    _7_1_6_2='71:6:2' # Пахомовское, Заокское, Тульская область
    _4_5_3_2='45:3:2' # Звериноголовское, Глядянское, Курганская область
    _4_5_3_3='45:3:3' # Половинское, Глядянское, Курганская область
    _3_25_1='3:25:1' # Большелугское, Кяхтинское, Республика Бурятия
    _3_25_2='3:25:2' # Кударинское, Кяхтинское, Республика Бурятия
    _4_5_3_1='45:3:1' # Глядянское, Глядянское, Курганская область
    _3_25_3='3:25:3' # Кяхтинское, Кяхтинское, Республика Бурятия
    _3_25_4='3:25:4' # Кяхтинское сельское, Кяхтинское, Республика Бурятия
    _3_25_5='3:25:5' # Наушкинское, Кяхтинское, Республика Бурятия
    _3_25_6='3:25:6' # Степное, Кяхтинское, Республика Бурятия
    _3_25_7='3:25:7' # Чикойское, Кяхтинское, Республика Бурятия
    _8_9_1_3='89:1:3' # Толькинское, Красноселькупское, Ямало-Ненецкий автономный округ
    _8_9_1_2='89:1:2' # Раттинское, Красноселькупское, Ямало-Ненецкий автономный округ
    _3_11_6='3:11:6' # Торейское, Джидинское, Республика Бурятия
    _3_11_5='3:11:5' # Пограничное, Джидинское, Республика Бурятия
    _3_11_4='3:11:4' # Нарынское, Джидинское, Республика Бурятия
    _3_11_3='3:11:3' # Ичетуйское, Джидинское, Республика Бурятия
    _2_7_10='2:7:10' # Усень-Ивановское, Белебеевское, Республика Башкортостан
    _2_4_37_2='24:37:2' # Ирбинское, Невонское, Красноярский край
    _2_4_37_3='24:37:3' # Невонское, Невонское, Красноярский край
    _2_4_37_1='24:37:1' # Говорковское, Невонское, Красноярский край
    _5_0_13_15='50:13:15' # Электрогорское, Ногинское, Московская область
    _3_9_1_2='39:1:2' # Ладушкинское, Багратионовское, Калининградская область
    _5_0_13_14='50:13:14' # Фрязевское, Ногинское, Московская область
    _3_9_1_1='39:1:1' # Багратионовское, Багратионовское, Калининградская область
    _3_9_1_4='39:1:4' # Октябрьское, Багратионовское, Калининградская область
    _5_0_13_16='50:13:16' # Ямкинское, Ногинское, Московская область
    _3_9_1_3='39:1:3' # Новоселовское, Багратионовское, Калининградская область
    _5_0_13_11='50:13:11' # Пригородное, Ногинское, Московская область
    _5_0_13_10='50:13:10' # Озерное, Ногинское, Московская область
    _5_0_13_13='50:13:13' # Салтыковское, Ногинское, Московская область
    _5_0_13_12='50:13:12' # Рахмановское, Ногинское, Московская область
    _6_8_6_2='68:6:2' # Моршанское, Моршанское, Тамбовская область
    _6_8_6_3='68:6:3' # Парлинское, Моршанское, Тамбовская область
    _6_8_6_1='68:6:1' # Вяжлинское, Моршанское, Тамбовская область
    _6_8_6_4='68:6:4' # Сокольниковское, Моршанское, Тамбовская область
    _3_11_2='3:11:2' # Джидинское сельское, Джидинское, Республика Бурятия
    _3_11_1='3:11:1' # Джидинское, Джидинское, Республика Бурятия
    _6_9_9_10='69:9:10' # Поженское, Торопецкое, Тверская область
    _6_9_9_11='69:9:11' # Речанское, Торопецкое, Тверская область
    _6_9_9_12='69:9:12' # Скворцовское, Торопецкое, Тверская область
    _6_9_9_13='69:9:13' # Торопецкое, Торопецкое, Тверская область
    _4_4_9_1='44:9:1' # 1-е Мантуровское, Мантуровское, Костромская область
    _4_4_9_2='44:9:2' # 2-е Мантуровское, Мантуровское, Костромская область
    _4_4_9_7='44:9:7' # Ухтубужское, Мантуровское, Костромская область
    _4_4_9_3='44:9:3' # Вочеровское, Мантуровское, Костромская область
    _4_4_9_4='44:9:4' # Карьковское, Мантуровское, Костромская область
    _4_4_9_5='44:9:5' # Октябрьское, Мантуровское, Костромская область
    _4_4_9_6='44:9:6' # Угорское, Мантуровское, Костромская область
    _4_7_12_15='47:12:15' # Шапкинское, Любанское, Ленинградская область
    _4_7_12_14='47:12:14' # Ушакинское, Любанское, Ленинградская область
    _4_7_12_13='47:12:13' # Ульяновское, Любанское, Ленинградская область
    _4_7_12_12='47:12:12' # Трубниковское, Любанское, Ленинградская область
    _4_7_12_11='47:12:11' # Тосненское, Любанское, Ленинградская область
    _4_7_12_10='47:12:10' # Саблинское, Любанское, Ленинградская область
    _6_7_20_6='67:20:6' # Субботнинское, Сычевское, Смоленская область
    _6_7_20_5='67:20:5' # Нащекинское сельское, Сычевское, Смоленская область
    _6_7_20_4='67:20:4' # Нащекинское, Сычевское, Смоленская область
    _6_7_20_3='67:20:3' # Днепровское, Сычевское, Смоленская область
    _1_6_2_2='16:2:2' # Джалильское, Азнакаевское, Республика Татарстан (Татарстан)
    _1_6_2_1='16:2:1' # Азнакаевское, Азнакаевское, Республика Татарстан (Татарстан)
    _1_6_2_4='16:2:4' # Сармановское, Азнакаевское, Республика Татарстан (Татарстан)
    _1_6_2_3='16:2:3' # Мальбагушское, Азнакаевское, Республика Татарстан (Татарстан)
    _1_6_2_5='16:2:5' # Чатыртауское, Азнакаевское, Республика Татарстан (Татарстан)
    _6_7_20_2='67:20:2' # Валутинское, Сычевское, Смоленская область
    _6_7_20_1='67:20:1' # Бочаровское, Сычевское, Смоленская область
    _2_2_1_1='22:1:1' # Айское, Алтайское, Алтайский край
    _2_2_1_2='22:1:2' # Алтайское, Алтайское, Алтайский край
    _5_4_22_5='54:22:5' # Усть-Таркский лесохозяйственный участок № 2, Татарское, Новосибирская область
    _5_4_22_4='54:22:4' # Усть-Таркский лесохозяйственный участок № 1, Татарское, Новосибирская область
    _5_4_22_3='54:22:3' # Ускюльский лесохозяйственный участок, Татарское, Новосибирская область
    _5_4_22_2='54:22:2' # Татарский лесохозяйственный участок № 2, Татарское, Новосибирская область
    _5_4_22_1='54:22:1' # Татарский лесохозяйственный участок № 1, Татарское, Новосибирская область
    _2_2_1_3='22:1:3' # Куяганское, Алтайское, Алтайский край
    _7_6_9_6='76:9:6' # Ухринское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _7_6_9_4='76:9:4' # Люксембургское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _7_6_9_5='76:9:5' # Согожское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _7_6_9_2='76:9:2' # Вязовское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _7_6_9_3='76:9:3' # Ермаковское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _7_6_9_1='76:9:1' # Белосельское, ГКУ ЯО "Пошехонское лесничество", Ярославская область
    _1_1_13_5='11:13:5' # Селэгвожское, Междуреченское, Республика Коми
    _1_1_13_4='11:13:4' # Мозындорское, Междуреченское, Республика Коми
    _1_1_13_3='11:13:3' # Едвинское, Междуреченское, Республика Коми
    _1_1_13_2='11:13:2' # Вожское, Междуреченское, Республика Коми
    _1_1_13_1='11:13:1' # Верхневашкинское, Междуреченское, Республика Коми
    _2_7_35_6='27:35:6' # Чекундинское, Ургальское, Хабаровский край
    _2_7_35_5='27:35:5' # Ургальское, Ургальское, Хабаровский край
    _2_7_35_4='27:35:4' # Умальтинское, Ургальское, Хабаровский край
    _2_7_35_3='27:35:3' # Туюнское, Ургальское, Хабаровский край
    _2_7_35_2='27:35:2' # Нимаканское, Ургальское, Хабаровский край
    _2_7_35_1='27:35:1' # Дубликанское, Ургальское, Хабаровский край
    _9_1_4='9:1:4' # Точеновское, Бескесское, Карачаево-Черкесская Республика
    _9_1_2='9:1:2' # Больше-Лабинское, Бескесское, Карачаево-Черкесская Республика
    _9_1_3='9:1:3' # Пхиинское, Бескесское, Карачаево-Черкесская Республика
    _9_1_1='9:1:1' # Бескесское, Бескесское, Карачаево-Черкесская Республика
    _1_1_26_3='11:26:3' # Глотовское, Удорское, Республика Коми
    _6_3_3_3='63:3:3' # Новокуйбышевское, Волжское, Самарская область
    _1_1_26_2='11:26:2' # Верхнемезенское, Удорское, Республика Коми
    _6_3_3_2='63:3:2' # Красноармейское, Волжское, Самарская область
    _1_1_26_1='11:26:1' # Бутканское, Удорское, Республика Коми
    _6_3_3_1='63:3:1' # Дубово-Уметское, Волжское, Самарская область
    _6_7_22_14='67:22:14' # Угранское сельское, Угранское, Смоленская область
    _6_7_22_13='67:22:13' # Угранское, Угранское, Смоленская область
    _6_7_22_12='67:22:12' # Подсосонское, Угранское, Смоленская область
    _6_7_22_11='67:22:11' # Ново-Милятинское, Угранское, Смоленская область
    _6_7_22_10='67:22:10' # Новинское, Угранское, Смоленская область
    _2_4_11_5='24:11:5' # Шиверское, Гремучинское, Красноярский край
    _2_4_11_4='24:11:4' # Мадашенское, Гремучинское, Красноярский край
    _2_4_11_3='24:11:3' # Красногорьевское, Гремучинское, Красноярский край
    _2_4_11_2='24:11:2' # Бедобинское, Гремучинское, Красноярский край
    _1_1_26_6='11:26:6' # Сельыбское, Удорское, Республика Коми
    _1_1_26_5='11:26:5' # Пысское, Удорское, Республика Коми
    _1_1_26_4='11:26:4' # Косланское, Удорское, Республика Коми
    _2_4_11_1='24:11:1' # Ангарское, Гремучинское, Красноярский край
    _6_3_3_5='63:3:5' # Чапаевское, Волжское, Самарская область
    _6_3_3_4='63:3:4' # Самарское, Волжское, Самарская область
    _5_7_2_3='57:2:3' # Покровское, Глазуновское, Орловская область
    _5_7_2_2='57:2:2' # Малоархангельское, Глазуновское, Орловская область
    _5_7_2_1='57:2:1' # Глазуновское, Глазуновское, Орловская область
    _5_7_2_4='57:2:4' # Свердловское, Глазуновское, Орловская область
    _2_7_22_5='27:22:5' # Озерпахское, Николаевское, Хабаровский край
    _2_7_22_3='27:22:3' # Магинское, Николаевское, Хабаровский край
    _2_7_22_4='27:22:4' # Многовершинное, Николаевское, Хабаровский край
    _2_7_22_1='27:22:1' # Городское, Николаевское, Хабаровский край
    _2_7_22_2='27:22:2' # Колчанское, Николаевское, Хабаровский край
    _2_7_4_1='27:4:1' # Верхне-Амгуньское, Баджальское, Хабаровский край
    _2_7_4_2='27:4:2' # Гербинское, Баджальское, Хабаровский край
    _2_4_24_4='24:24:4' # Пионерское, Кизирское, Красноярский край
    _7_2_14_1='72:14:1' # Сладковское, Сладковское, Тюменская область
    _7_2_14_2='72:14:2' # Сладковское сельское, Сладковское, Тюменская область
    _2_7_4_3='27:4:3' # Сулукское, Баджальское, Хабаровский край
    _2_4_24_1='24:24:1' # Артемовское, Кизирское, Красноярский край
    _2_4_24_2='24:24:2' # Верхне-Сисимское, Кизирское, Красноярский край
    _2_4_24_3='24:24:3' # Кошурниковское, Кизирское, Красноярский край
    _3_3_5_2='33:5:2' # Вишенское, Гороховецкое, Владимирская область
    _7_5_21_1='75:21:1' # Вершино-Дарасунское, Тунгокоченское, Забайкальский край
    _3_3_5_1='33:5:1' # Быкасовское, Гороховецкое, Владимирская область
    _7_5_21_2='75:21:2' # Калаканское, Тунгокоченское, Забайкальский край
    _3_3_5_4='33:5:4' # Гороховецкое, Гороховецкое, Владимирская область
    _7_5_21_3='75:21:3' # Левобережное, Тунгокоченское, Забайкальский край
    _3_3_5_3='33:5:3' # Городищенское, Гороховецкое, Владимирская область
    _7_5_21_4='75:21:4' # Тунгокоченское, Тунгокоченское, Забайкальский край
    _3_3_5_6='33:5:6' # Чулковское, Гороховецкое, Владимирская область
    _7_5_21_5='75:21:5' # Усуглинское, Тунгокоченское, Забайкальский край
    _3_3_5_5='33:5:5' # Фоминское, Гороховецкое, Владимирская область
    _6_4_11_2='64:11:2' # Ершовское, Ершовское, Саратовская область
    _6_4_11_3='64:11:3' # Краснопартизанское, Ершовское, Саратовская область
    _6_4_11_4='64:11:4' # Озинское, Ершовское, Саратовская область
    _6_4_11_5='64:11:5' # Федоровское, Ершовское, Саратовская область
    _6_4_11_1='64:11:1' # Дергачевское, Ершовское, Саратовская область
    _7_2_13_2='72:13:2' # Зимовское, Омутинское, Тюменская область
    _7_2_13_1='72:13:1' # Вагайское, Омутинское, Тюменская область
    _7_2_13_4='72:13:4' # Ситниковское, Омутинское, Тюменская область
    _7_2_13_3='72:13:3' # Омутинское, Омутинское, Тюменская область
    _1_0_5_1='10:5:1' # Вокнаволокское, Костомукшское, Республика Карелия
    _1_0_5_3='10:5:3' # Ладвозерское, Костомукшское, Республика Карелия
    _1_0_5_2='10:5:2' # Костомукшское, Костомукшское, Республика Карелия
    _3_5_13_10='35:13:10' # Слободское, Кичменгско-Городецкое, Вологодская область
    _3_3_6_1='33:6:1' # Анопинское, Гусевское, Владимирская область
    _3_3_6_3='33:6:3' # Григорьевское, Гусевское, Владимирская область
    _3_3_6_2='33:6:2' # Вашутинское, Гусевское, Владимирская область
    _3_3_6_5='33:6:5' # Давыдовское, Гусевское, Владимирская область
    _3_3_6_4='33:6:4' # Гусевское, Гусевское, Владимирская область
    _3_5_13_12='35:13:12' # Шарженское, Кичменгско-Городецкое, Вологодская область
    _3_3_6_7='33:6:7' # Красноэховское, Гусевское, Владимирская область
    _3_5_13_11='35:13:11' # Стрелкинское, Кичменгско-Городецкое, Вологодская область
    _3_3_6_6='33:6:6' # Заколпьевское, Гусевское, Владимирская область
    _3_3_6_9='33:6:9' # Семеновское, Гусевское, Владимирская область
    _3_5_13_13='35:13:13' # Югское, Кичменгско-Городецкое, Вологодская область
    _3_3_6_8='33:6:8' # Неклюдовское, Гусевское, Владимирская область
    _8_9_2_2='89:2:2' # Надымское, Надымское, Ямало-Ненецкий автономный округ
    _8_9_2_1='89:2:1' # Лонг-Юганское, Надымское, Ямало-Ненецкий автономный округ
    _8_9_2_3='89:2:3' # Пангодинское, Надымское, Ямало-Ненецкий автономный округ
    _4_2_18_3='42:18:3' # Яйское, Яйское, Кемеровская область
    _4_2_18_1='42:18:1' # Анжерское, Яйское, Кемеровская область
    _4_2_18_2='42:18:2' # Лебедянское, Яйское, Кемеровская область
    _6_2_9_2='62:9:2' # Зареченское, Нижне-Окское, Рязанская область
    _6_2_9_1='62:9:1' # Дмитриевское, Нижне-Окское, Рязанская область
    _3_4_16_2='34:16:2' # Глазуновское, Подтёлковское, Волгоградская область
    _3_4_16_3='34:16:3' # Кумылженское, Подтёлковское, Волгоградская область
    _6_2_9_3='62:9:3' # Ибердусское, Нижне-Окское, Рязанская область
    _3_4_16_1='34:16:1' # Букановское, Подтёлковское, Волгоградская область
    _3_4_16_6='34:16:6' # Шакинское, Подтёлковское, Волгоградская область
    _3_4_16_4='34:16:4' # Кумылженское сельское, Подтёлковское, Волгоградская область
    _3_4_16_5='34:16:5' # Слащёвское, Подтёлковское, Волгоградская область
    _6_4_24_1='64:24:1' # Гремячинское, Ширококарамышское, Саратовская область
    _6_4_24_3='64:24:3' # Ширококарамышское, Ширококарамышское, Саратовская область
    _6_4_24_2='64:24:2' # Невежкинское, Ширококарамышское, Саратовская область
    _3_8_9_2='38:9:2' # Тутурское, Жигаловское, Иркутская область
    _3_8_9_1='38:9:1' # Жигаловское, Жигаловское, Иркутская область
    _3_6_4='3:6:4' # Шибертуйское, Буйское, Республика Бурятия
    _3_6_3='3:6:3' # Потанинское, Буйское, Республика Бурятия
    _1_1_12_4='11:12:4' # Четдинское, Локчимское, Республика Коми
    _1_1_12_3='11:12:3' # Намское, Локчимское, Республика Коми
    _1_1_12_2='11:12:2' # Мординское, Локчимское, Республика Коми
    _1_1_12_1='11:12:1' # Лопыдинское, Локчимское, Республика Коми
    _3_6_2='3:6:2' # Мангиртуйское, Буйское, Республика Бурятия
    _3_6_1='3:6:1' # Буйское, Буйское, Республика Бурятия
    _5_6_7_1='56:7:1' # Боровское, Бузулукское, Оренбургская область
    _9_3_4='9:3:4' # Учкуланское, Карачаевское, Карачаево-Черкесская Республика
    _5_6_7_3='56:7:3' # Бузулукское сельское, Бузулукское, Оренбургская область
    _9_3_5='9:3:5' # Худесское, Карачаевское, Карачаево-Черкесская Республика
    _5_6_7_2='56:7:2' # Бузулукское, Бузулукское, Оренбургская область
    _9_3_2='9:3:2' # Кубанское, Карачаевское, Карачаево-Черкесская Республика
    _9_3_3='9:3:3' # Тебердинское, Карачаевское, Карачаево-Черкесская Республика
    _9_3_1='9:3:1' # Карачаевское, Карачаевское, Карачаево-Черкесская Республика
    _5_6_7_5='56:7:5' # Никифоровское, Бузулукское, Оренбургская область
    _5_6_7_4='56:7:4' # Державинское, Бузулукское, Оренбургская область
    _1_4_20_1='14:20:1' # Томпонское, Томпонское, Республика Саха (Якутия)
    _5_5_17_1='55:17:1' # Бекишевское, Тюкалинское, Омская область
    _5_0_7_15='50:7:15' # Шараповское, Звенигородское, Московская область
    _5_5_17_5='55:17:5' # Тюкалинское сельское, Тюкалинское, Омская область
    _5_5_17_4='55:17:4' # Тюкалинское, Тюкалинское, Омская область
    _5_0_7_13='50:7:13' # Хлюпинское, Звенигородское, Московская область
    _5_5_17_3='55:17:3' # Солдатское сельское, Тюкалинское, Омская область
    _5_0_7_14='50:7:14' # Чепелевское, Звенигородское, Московская область
    _5_5_17_2='55:17:2' # Солдатское, Тюкалинское, Омская область
    _5_0_7_11='50:7:11' # Таракановское, Звенигородское, Московская область
    _5_0_7_12='50:7:12' # Тучковское, Звенигородское, Московская область
    _5_0_7_10='50:7:10' # Рузское, Звенигородское, Московская область
    _3_26_1='3:26:1' # Бамбуйское, Муйское, Республика Бурятия
    _3_26_2='3:26:2' # Витимское, Муйское, Республика Бурятия
    _3_26_3='3:26:3' # Муйское, Муйское, Республика Бурятия
    _3_26_4='3:26:4' # Муяканское, Муйское, Республика Бурятия
    _3_26_5='3:26:5' # Парамское, Муйское, Республика Бурятия
    _3_26_6='3:26:6' # Северомуйское, Муйское, Республика Бурятия
    _3_26_7='3:26:7' # Таксимовское, Муйское, Республика Бурятия
    _3_26_8='3:26:8' # Улан-Макитское, Муйское, Республика Бурятия
    _3_13_7='3:13:7' # Усть-Брянское, Заиграевское, Республика Бурятия
    _3_13_6='3:13:6' # Унэгэтэйское, Заиграевское, Республика Бурятия
    _3_13_5='3:13:5' # Онохойское, Заиграевское, Республика Бурятия
    _3_13_4='3:13:4' # Илькинское, Заиграевское, Республика Бурятия
    _3_13_3='3:13:3' # Заиграевское сельское, Заиграевское, Республика Бурятия
    _3_13_2='3:13:2' # Заиграевское, Заиграевское, Республика Бурятия
    _3_13_1='3:13:1' # Додогольское, Заиграевское, Республика Бурятия
    _5_8_14_2='58:14:2' # Кардавское, Чаадаевское, Пензенская область
    _5_8_14_3='58:14:3' # Краснооктябрьское-Канаевское, Чаадаевское, Пензенская область
    _5_8_14_1='58:14:1' # Городищенское-Юловское, Чаадаевское, Пензенская область
    _2_1_8_1='21:8:1' # Пихтулинское, Чебоксарское, Чувашская Республика - Чувашия
    _2_1_8_2='21:8:2' # Северное, Чебоксарское, Чувашская Республика - Чувашия
    _2_1_8_3='21:8:3' # Сосновское, Чебоксарское, Чувашская Республика - Чувашия
    _5_8_14_4='58:14:4' # Чаадаевское-Куракинское, Чаадаевское, Пензенская область
    _7_1_7_1='71:7:1' # Гурьевское, Одоевское, Тульская область
    _7_1_7_2='71:7:2' # Дубенское, Одоевское, Тульская область
    _5_1_4_2='51:4:2' # Ковдозерское, Ковдозерское, Мурманская область
    _5_1_4_1='51:4:1' # Зеленоборское, Ковдозерское, Мурманская область
    _7_1_7_3='71:7:3' # Северо-Одоевское, Одоевское, Тульская область
    _7_1_7_4='71:7:4' # Южно-Одоевское, Одоевское, Тульская область
    _3_9_3_2='39:3:2' # Железнодорожное, Железнодорожное, Калининградская область
    _3_9_3_1='39:3:1' # Домновское, Железнодорожное, Калининградская область
    _3_9_3_4='39:3:4' # Правдинское, Железнодорожное, Калининградская область
    _3_9_3_3='39:3:3' # Ново-Бобруйское, Железнодорожное, Калининградская область
    _3_9_3_5='39:3:5' # Фрунзенское, Железнодорожное, Калининградская область
    _2_4_25_7='24:25:7' # Недокурское, Кодинское, Красноярский край
    _2_4_25_8='24:25:8' # Пановское, Кодинское, Красноярский край
    _2_4_25_9='24:25:9' # Проспихинское, Кодинское, Красноярский край
    _2_4_25_3='24:25:3' # Ковинское, Кодинское, Красноярский край
    _2_4_25_4='24:25:4' # Кодинское, Кодинское, Красноярский край
    _2_4_25_5='24:25:5' # Лаушкардинское, Кодинское, Красноярский край
    _2_4_25_6='24:25:6' # Неводинское, Кодинское, Красноярский край
    _2_4_25_1='24:25:1' # Аксеновское, Кодинское, Красноярский край
    _2_4_25_2='24:25:2' # Кежемское, Кодинское, Красноярский край
    _5_4_21_9='54:21:9' # Шипуновский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_8='54:21:8' # Сузунский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_7='54:21:7' # Нечунаевский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_6='54:21:6' # Мышланский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_5='54:21:5' # Меретский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_4='54:21:4' # Кубанский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_3='54:21:3' # Заковряжинский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_2='54:21:2' # Бобровский лесохозяйственный участок, Сузунское, Новосибирская область
    _5_4_21_1='54:21:1' # Битковский лесохозяйственный участок, Сузунское, Новосибирская область
    _6_8_5_3='68:5:3' # Ярковское, Мичуринское, Тамбовская область
    _6_8_5_1='68:5:1' # Заворонежское, Мичуринское, Тамбовская область
    _6_8_5_2='68:5:2' # Шехманское, Мичуринское, Тамбовская область
    _4_5_4_1='45:4:1' # Верх-Теченское, Далматовское, Курганская область
    _4_5_4_2='45:4:2' # Далматовское, Далматовское, Курганская область
    _4_5_4_3='45:4:3' # Катайское, Далматовское, Курганская область
    _4_5_4_4='45:4:4' # Уксянское, Далматовское, Курганская область
    _3_12_7='3:12:7' # Тужинское, Еравнинское, Республика Бурятия
    _3_12_6='3:12:6' # Сосново-Озерское, Еравнинское, Республика Бурятия
    _3_12_5='3:12:5' # Можайское, Еравнинское, Республика Бурятия
    _3_12_4='3:12:4' # Зазинское, Еравнинское, Республика Бурятия
    _3_12_3='3:12:3' # Еравнинское сельское, Еравнинское, Республика Бурятия
    _3_12_2='3:12:2' # Еравнинское, Еравнинское, Республика Бурятия
    _4_0_1_2='40:1:2' # Боровское, Боровское, Калужская область
    _4_0_1_1='40:1:1' # Балабановское, Боровское, Калужская область
    _4_0_1_3='40:1:3' # Тишневское, Боровское, Калужская область
    _2_4_38_5='24:38:5' # Сымское, Нижне-Енисейское, Красноярский край
    _2_4_38_6='24:38:6' # Ярцевское, Нижне-Енисейское, Красноярский край
    _2_4_38_7='24:38:7' # Ярцевское сельское, Нижне-Енисейское, Красноярский край
    _2_4_38_1='24:38:1' # Зотинское, Нижне-Енисейское, Красноярский край
    _2_4_38_2='24:38:2' # Касовское, Нижне-Енисейское, Красноярский край
    _2_4_38_3='24:38:3' # Майское, Нижне-Енисейское, Красноярский край
    _2_4_38_4='24:38:4' # Сурнихинское, Нижне-Енисейское, Красноярский край
    _4_4_11_10='44:11:10' # Семёновское, Нейское, Костромская область
    _2_2_2_1='22:2:1' # Андроновское, Баевское, Алтайский край
    _2_2_2_4='22:2:4' # Рыбинское, Баевское, Алтайский край
    _2_2_2_5='22:2:5' # Харитоновское, Баевское, Алтайский край
    _2_2_2_2='22:2:2' # Баевское, Баевское, Алтайский край
    _2_2_2_3='22:2:3' # Корниловское, Баевское, Алтайский край
    _7_2_1_4='72:1:4' # Ощепковское, Абатское, Тюменская область
    _7_2_1_2='72:1:2' # Абатское сельское, Абатское, Тюменская область
    _7_2_1_3='72:1:3' # Балаирское, Абатское, Тюменская область
    _7_2_1_1='72:1:1' # Абатское, Абатское, Тюменская область
    _1_6_1_1='16:1:1' # Агрызское, Агрызское, Республика Татарстан (Татарстан)
    _1_6_1_3='16:1:3' # Красноборское, Агрызское, Республика Татарстан (Татарстан)
    _1_6_1_2='16:1:2' # Девятернинское, Агрызское, Республика Татарстан (Татарстан)
    _1_6_1_4='16:1:4' # Шаршадинское, Агрызское, Республика Татарстан (Татарстан)
    _2_7_5_1='27:5:1' # Бикинское, Бикинское, Хабаровский край
    _2_7_5_2='27:5:2' # Звеньевское, Бикинское, Хабаровский край
    _2_7_5_3='27:5:3' # Лермонтовское, Бикинское, Хабаровский край
    _9_2_5='9:2:5' # Кардоникское, Зеленчукское, Карачаево-Черкесская Республика
    _9_2_6='9:2:6' # Марухское, Зеленчукское, Карачаево-Черкесская Республика
    _9_2_3='9:2:3' # Ермоловское, Зеленчукское, Карачаево-Черкесская Республика
    _9_2_4='9:2:4' # Зеленчукское, Зеленчукское, Карачаево-Черкесская Республика
    _9_2_1='9:2:1' # Аксаутское, Зеленчукское, Карачаево-Черкесская Республика
    _9_2_2='9:2:2' # Архызское, Зеленчукское, Карачаево-Черкесская Республика
    _1_1_25_4='11:25:4' # Русановское, Троицко-Печорское, Республика Коми
    _1_1_25_3='11:25:3' # Нижнеомринское, Троицко-Печорское, Республика Коми
    _1_1_25_2='11:25:2' # Митрофановское, Троицко-Печорское, Республика Коми
    _1_1_25_1='11:25:1' # Белоборское, Троицко-Печорское, Республика Коми
    _1_1_25_5='11:25:5' # Троицко-Печорское, Троицко-Печорское, Республика Коми
    _6_7_21_5='67:21:5' # Темкинское сельское, Темкинское, Смоленская область
    _6_7_21_4='67:21:4' # Темкинское, Темкинское, Смоленская область
    _6_7_21_3='67:21:3' # Горковское сельское, Темкинское, Смоленская область
    _6_4_25_2='64:25:2' # Приволжское, Энгельсское, Саратовская область
    _6_7_21_2='67:21:2' # Горковское, Темкинское, Смоленская область
    _6_4_25_1='64:25:1' # Красноярское, Энгельсское, Саратовская область
    _2_7_34_5='27:34:5' # Удыльское, Ульчское, Хабаровский край
    _2_7_34_4='27:34:4' # Тахтинское, Ульчское, Хабаровский край
    _6_4_25_4='64:25:4' # Энгельсское, Энгельсское, Саратовская область
    _6_4_25_3='64:25:3' # Ровенское, Энгельсское, Саратовская область
    _2_7_34_3='27:34:3' # Воскресенское, Ульчское, Хабаровский край
    _2_7_34_2='27:34:2' # Больше-Михайловское, Ульчское, Хабаровский край
    _2_7_34_1='27:34:1' # Богородское, Ульчское, Хабаровский край
    _6_7_21_1='67:21:1' # Власовское, Темкинское, Смоленская область
    _6_3_2_3='63:2:3' # Пестравское, Большеглушицкое, Самарская область
    _6_3_2_2='63:2:2' # Большечерниговское, Большеглушицкое, Самарская область
    _7_5_22_1='75:22:1' # Леневоозерское, Хилокское, Забайкальский край
    _6_3_2_1='63:2:1' # Большеглушицкое, Большеглушицкое, Самарская область
    _7_5_22_2='75:22:2' # Могзонское, Хилокское, Забайкальский край
    _7_5_22_3='75:22:3' # Харагунское, Хилокское, Забайкальский край
    _7_5_22_4='75:22:4' # Хилокское, Хилокское, Забайкальский край
    _7_5_22_5='75:22:5' # Хушенгинское, Хилокское, Забайкальский край
    _2_4_12_4='24:12:4' # Черемушкинское, Даурское, Красноярский край
    _7_5_22_6='75:22:6' # Энгорокское, Хилокское, Забайкальский край
    _2_4_12_3='24:12:3' # Тубильское, Даурское, Красноярский край
    _2_4_12_2='24:12:2' # Сисимское, Даурское, Красноярский край
    _2_4_12_1='24:12:1' # Куртюльское, Даурское, Красноярский край
    _2_7_21_1='27:21:1' # Ильинское, Нижнетамбовское, Хабаровский край
    _2_7_21_4='27:21:4' # Ягодное, Нижнетамбовское, Хабаровский край
    _2_7_21_2='27:21:2' # Нижнетамбовское, Нижнетамбовское, Хабаровский край
    _2_7_21_3='27:21:3' # Халбинское, Нижнетамбовское, Хабаровский край
    _3_8_25_4='38:25:4' # Приморское, Осинское, Иркутская область
    _3_8_25_2='38:25:2' # Обусинское, Осинское, Иркутская область
    _3_8_25_3='38:25:3' # Осинское, Осинское, Иркутская область
    _4_1_2='4:1:2' # Курайское, Кош-Агачское, Республика Алтай
    _4_1_1='4:1:1' # Джазаторское, Кош-Агачское, Республика Алтай
    _3_8_25_1='38:25:1' # Бурят-Янгутское, Осинское, Иркутская область
    _6_7_26_4='67:26:4' # Озерищенское, Ярцевское, Смоленская область
    _6_7_26_3='67:26:3' # Львовское, Ярцевское, Смоленская область
    _6_7_26_2='67:26:2' # Кротовское, Ярцевское, Смоленская область
    _4_2_3_3='42:3:3' # Святославское, Ижморское, Кемеровская область
    _6_7_26_1='67:26:1' # Капыревщинское, Ярцевское, Смоленская область
    _6_7_26_7='67:26:7' # Ярцевское сельское, Ярцевское, Смоленская область
    _6_7_26_6='67:26:6' # Ярцевское, Ярцевское, Смоленская область
    _6_7_26_5='67:26:5' # Репинское, Ярцевское, Смоленская область
    _4_2_3_2='42:3:2' # Красноярское, Ижморское, Кемеровская область
    _4_2_3_1='42:3:1' # Ижморское, Ижморское, Кемеровская область
    _6_7_13_2='67:13:2' # Монастырщинское сельское, Монастырщинское, Смоленская область
    _6_7_13_1='67:13:1' # Монастырщинское, Монастырщинское, Смоленская область
    _2_3_9_2='23:9:2' # Каневское, Краснодарское, Краснодарский край
    _2_3_9_3='23:9:3' # Усть-Лабинское, Краснодарское, Краснодарский край
    _2_3_9_1='23:9:1' # Елизаветинское, Краснодарское, Краснодарский край
    _2_4_30_5='24:30:5' # Урманское, Маганское, Красноярский край
    _2_4_30_1='24:30:1' # Березовское, Маганское, Красноярский край
    _2_4_30_2='24:30:2' # Беретское, Маганское, Красноярский край
    _2_4_30_3='24:30:3' # Верх-Базайское, Маганское, Красноярский край
    _2_4_30_4='24:30:4' # Маганское, Маганское, Красноярский край
    _2_2_16_1='22:16:1' # Курортное, Лебяжинское, Алтайский край
    _2_2_16_2='22:16:2' # Ново-Советское, Лебяжинское, Алтайский край
    _2_2_16_3='22:16:3' # Сростинское, Лебяжинское, Алтайский край
    _2_2_16_4='22:16:4' # Титовское, Лебяжинское, Алтайский край
    _9_4_5='9:4:5' # Хабезское, Кубанское, Карачаево-Черкесская Республика
    _9_4_6='9:4:6' # Холодно-Родниковское, Кубанское, Карачаево-Черкесская Республика
    _9_4_3='9:4:3' # Пригородное, Кубанское, Карачаево-Черкесская Республика
    _9_4_4='9:4:4' # Учкекенское, Кубанское, Карачаево-Черкесская Республика
    _9_4_1='9:4:1' # Джегутинское, Кубанское, Карачаево-Черкесская Республика
    _9_4_2='9:4:2' # Красногорское, Кубанское, Карачаево-Черкесская Республика
    _4_3_33_3='43:33:3' # Мокинское, Суводское, Кировская область
    _4_3_33_4='43:33:4' # Первомайское, Суводское, Кировская область
    _4_3_33_5='43:33:5' # Пижанское, Суводское, Кировская область
    _4_3_33_6='43:33:6' # Пижанское сельское, Суводское, Кировская область
    _4_3_33_1='43:33:1' # Заречное сельское, Суводское, Кировская область
    _4_3_33_2='43:33:2' # Зашижемское, Суводское, Кировская область
    _4_3_33_7='43:33:7' # Советское, Суводское, Кировская область
    _4_3_33_8='43:33:8' # Советское сельское, Суводское, Кировская область
    _4_3_33_9='43:33:9' # Суводское, Суводское, Кировская область
    _2_4_43_4='24:43:4' # Субботинское, Саяно-Шушенское, Красноярский край
    _2_4_43_3='24:43:3' # Саяногорское, Саяно-Шушенское, Красноярский край
    _2_4_43_6='24:43:6' # Шушенское сельское, Саяно-Шушенское, Красноярский край
    _2_4_43_5='24:43:5' # Шушенское, Саяно-Шушенское, Красноярский край
    _2_4_43_2='24:43:2' # Ивановское, Саяно-Шушенское, Красноярский край
    _2_4_43_1='24:43:1' # Верхне-Енисейское, Саяно-Шушенское, Красноярский край
    _1_7_7_4='17:7:4' # Чазыларское, Тоджинское, Республика Тыва
    _1_7_7_3='17:7:3' # Хамсаринское, Тоджинское, Республика Тыва
    _1_7_7_2='17:7:2' # Тоора-Хемское, Тоджинское, Республика Тыва
    _7_2_21_1='72:21:1' # Заводопетровское, Ялуторовское, Тюменская область
    _1_7_7_1='17:7:1' # Сыстыг-Хемское, Тоджинское, Республика Тыва
    _7_2_21_3='72:21:3' # Районное сельское, Ялуторовское, Тюменская область
    _7_2_21_2='72:21:2' # Новотьяловское, Ялуторовское, Тюменская область
    _7_2_21_4='72:21:4' # Ялуторовское, Ялуторовское, Тюменская область
    _3_5_26_4='35:26:4' # Шекснинское, Шекснинское, Вологодская область
    _3_5_26_3='35:26:3' # Чебсарское, Шекснинское, Вологодская область
    _3_5_26_2='35:26:2' # Северное, Шекснинское, Вологодская область
    _3_5_26_1='35:26:1' # Пришекснинское, Шекснинское, Вологодская область
    _5_14_1='5:14:1' # Самурское, Самурское, Республика Дагестан
    _8_6_5_4='86:5:4' # Покачёвское, Мегионское, Ханты-Мансийский автономный округ - Югра
    _8_6_5_3='86:5:3' # Октябрьское, Мегионское, Ханты-Мансийский автономный округ - Югра
    _8_6_5_2='86:5:2' # Лангепасское, Мегионское, Ханты-Мансийский автономный округ - Югра
    _8_6_5_1='86:5:1' # Куль-Еганское, Мегионское, Ханты-Мансийский автономный округ - Югра
    _8_6_5_5='86:5:5' # Сарт-Ёганское, Мегионское, Ханты-Мансийский автономный округ - Югра
    _2_2_29_3='22:29:3' # Сосновское, Фрунзенское, Алтайский край
    _2_2_29_1='22:29:1' # Красногорское, Фрунзенское, Алтайский край
    _2_2_29_2='22:29:2' # Макарьевское, Фрунзенское, Алтайский край
    _5_9_4_5='59:4:5' # Пятигорское, Гайнское, Пермский край
    _5_9_4_4='59:4:4' # Леманское, Гайнское, Пермский край
    _2_4_3_1='24:3:1' # Байкитское, Байкитское, Красноярский край
    _5_9_4_3='59:4:3' # Гайнское, Гайнское, Пермский край
    _2_4_3_2='24:3:2' # Ошаровское, Байкитское, Красноярский край
    _5_9_4_2='59:4:2' # Вурламское, Гайнское, Пермский край
    _5_9_4_1='59:4:1' # Верхне-Камское, Гайнское, Пермский край
    _2_4_3_3='24:3:3' # Суломайское, Байкитское, Красноярский край
    _4_7_16_4='47:16:4' # Вещевское, Северо-Западное, Ленинградская область
    _4_7_16_5='47:16:5' # Выборгское, Северо-Западное, Ленинградская область
    _4_7_16_2='47:16:2' # Большепольское, Северо-Западное, Ленинградская область
    _4_7_16_3='47:16:3' # Бородинское, Северо-Западное, Ленинградская область
    _4_7_16_1='47:16:1' # Балтийское, Северо-Западное, Ленинградская область
    _4_7_16_8='47:16:8' # Каменогорское, Северо-Западное, Ленинградская область
    _4_7_16_9='47:16:9' # Комсомольское, Северо-Западное, Ленинградская область
    _4_7_16_6='47:16:6' # Дымовское, Северо-Западное, Ленинградская область
    _4_7_16_7='47:16:7' # Калининское, Северо-Западное, Ленинградская область
    _3_5_13_7='35:13:7' # Нижне-Ентальское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_6='35:13:6' # Кичменгское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_5='35:13:5' # Кичменгско-Городецкое, Кичменгско-Городецкое, Вологодская область
    _3_5_13_4='35:13:4' # Карюгское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_3='35:13:3' # Енангское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_2='35:13:2' # Верхне-Югское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_1='35:13:1' # Верхне-Ентальское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_9='35:13:9' # Савинское, Кичменгско-Городецкое, Вологодская область
    _3_5_13_8='35:13:8' # Пыжугское, Кичменгско-Городецкое, Вологодская область
    _6_5_6_1='65:6:1' # Курильское, Курильское, Сахалинская область
    _3_8_12_4='38:12:4' # Усть-Илимское, Илимское, Иркутская область
    _3_8_12_1='38:12:1' # Воробьевское, Илимское, Иркутская область
    _3_8_12_3='38:12:3' # Седановское, Илимское, Иркутская область
    _3_8_12_2='38:12:2' # Невонское, Илимское, Иркутская область
    _1_1_20_9='11:20:9' # Усть-Ухтинское, Сосногорское, Республика Коми
    _1_1_20_8='11:20:8' # Пожнинское, Сосногорское, Республика Коми
    _1_1_20_7='11:20:7' # Нижнеодесское, Сосногорское, Республика Коми
    _1_1_20_6='11:20:6' # Малоперское, Сосногорское, Республика Коми
    _1_1_20_5='11:20:5' # Конашьельское, Сосногорское, Республика Коми
    _1_1_20_4='11:20:4' # Ираельское, Сосногорское, Республика Коми
    _1_1_20_3='11:20:3' # Войвожское, Сосногорское, Республика Коми
    _1_1_20_2='11:20:2' # Висское, Сосногорское, Республика Коми
    _1_2_18_2='12:18:2' # Дорогучинское, Юринское, Республика Марий Эл
    _1_2_18_3='12:18:3' # Кузьминское, Юринское, Республика Марий Эл
    _1_2_18_4='12:18:4' # Юркинское, Юринское, Республика Марий Эл
    _1_1_20_1='11:20:1' # Айювинское, Сосногорское, Республика Коми
    _1_2_18_1='12:18:1' # Абросимовское, Юринское, Республика Марий Эл
    _2_8_13_3='28:13:3' # Мухинское, Шимановское, Амурская область
    _2_8_13_2='28:13:2' # Кухтеринское, Шимановское, Амурская область
    _2_8_13_1='28:13:1' # Кумарское, Шимановское, Амурская область
    _7_3_18_5='73:18:5' # Ясашно-Ташлинское, Тереньгульское, Ульяновская область
    _4_4_17_2='44:17:2' # 1-е Пыщугское, Пыщугское, Костромская область
    _4_4_17_3='44:17:3' # 2-е Носковское, Пыщугское, Костромская область
    _4_4_17_4='44:17:4' # 2-е Пыщугское, Пыщугское, Костромская область
    _4_4_17_5='44:17:5' # Ключевское, Пыщугское, Костромская область
    _4_4_17_6='44:17:6' # Красное, Пыщугское, Костромская область
    _4_4_17_7='44:17:7' # Михайловицкое, Пыщугское, Костромская область
    _2_8_13_8='28:13:8' # Шимановское, Шимановское, Амурская область
    _2_8_13_7='28:13:7' # Чагоянское, Шимановское, Амурская область
    _2_8_13_6='28:13:6' # Селетканское, Шимановское, Амурская область
    _2_8_13_5='28:13:5' # Новогеоргиевское, Шимановское, Амурская область
    _4_4_17_1='44:17:1' # 1-е Носковское, Пыщугское, Костромская область
    _2_8_13_4='28:13:4' # Нововоскресеновское, Шимановское, Амурская область
    _3_5_7_8='35:7:8' # Нижне-Слободское, Вожегодское, Вологодская область
    _2_29_6='2:29:6' # Уральское, Учалинское, Республика Башкортостан
    _9_1_10_1='91:10:1' # Комсомольское, Судакское, Республика Крым
    _3_5_7_7='35:7:7' # Кадниковское, Вожегодское, Вологодская область
    _2_29_5='2:29:5' # Северо-Уральское, Учалинское, Республика Башкортостан
    _9_1_10_2='91:10:2' # Морское, Судакское, Республика Крым
    _2_29_4='2:29:4' # Кирябинское, Учалинское, Республика Башкортостан
    _9_1_10_3='91:10:3' # Приветненское, Судакское, Республика Крым
    _3_5_7_9='35:7:9' # Нижне-Слободское сельское, Вожегодское, Вологодская область
    _2_29_3='2:29:3' # Ильчигуловское, Учалинское, Республика Башкортостан
    _9_1_10_4='91:10:4' # Приморское, Судакское, Республика Крым
    _3_5_7_4='35:7:4' # Вожегодское сельское, Вожегодское, Вологодская область
    _9_1_10_5='91:10:5' # Судакское, Судакское, Республика Крым
    _3_5_7_3='35:7:3' # Вожегодское, Вожегодское, Вологодская область
    _3_5_7_6='35:7:6' # Ембское, Вожегодское, Вологодская область
    _2_29_8='2:29:8' # Учалинское сельское, Учалинское, Республика Башкортостан
    _3_5_7_5='35:7:5' # Вотчинское, Вожегодское, Вологодская область
    _2_29_7='2:29:7' # Ургунское, Учалинское, Республика Башкортостан
    _3_5_7_2='35:7:2' # Бекетовское, Вожегодское, Вологодская область
    _3_5_7_1='35:7:1' # Азлецкое, Вожегодское, Вологодская область
    _2_29_2='2:29:2' # Ильтибановское, Учалинское, Республика Башкортостан
    _2_29_1='2:29:1' # Зауральское, Учалинское, Республика Башкортостан
    _2_5_11_14='25:11:14' # Шумнинское, Чугуевское, Приморский край
    _2_5_11_13='25:11:13' # Чугуевское сельское, Чугуевское, Приморский край
    _2_5_11_12='25:11:12' # Чугуевское, Чугуевское, Приморский край
    _2_5_11_11='25:11:11' # Уборковское, Чугуевское, Приморский край
    _2_5_11_10='25:11:10' # Самарское, Чугуевское, Приморский край
    _2_9_6_1='29:6:1' # Верхнепинежское, Выйское, Архангельская область
    _2_10_11='2:10:11' # Челкаковское, Бирское, Республика Башкортостан
    _2_9_6_2='29:6:2' # Гавриловское, Выйское, Архангельская область
    _2_10_10='2:10:10' # Рефандинское, Бирское, Республика Башкортостан
    _2_9_6_3='29:6:3' # Горковское, Выйское, Архангельская область
    _2_10_13='2:10:13' # Янтузовское, Бирское, Республика Башкортостан
    _3_2_14_1='32:14:1' # Подывотское, Севское, Брянская область
    _2_9_6_4='29:6:4' # Илешское, Выйское, Архангельская область
    _2_10_12='2:10:12' # Чураевское, Бирское, Республика Башкортостан
    _3_2_14_2='32:14:2' # Хинельское, Севское, Брянская область
    _7_3_18_3='73:18:3' # Молвинское, Тереньгульское, Ульяновская область
    _7_3_18_4='73:18:4' # Тереньгульское, Тереньгульское, Ульяновская область
    _7_3_18_1='73:18:1' # Елшанское, Тереньгульское, Ульяновская область
    _7_3_18_2='73:18:2' # Зеленецкое, Тереньгульское, Ульяновская область
    _5_4_2_1='54:2:1' # Бибеевский лесохозяйственный участок, Болотнинское, Новосибирская область
    _5_4_2_2='54:2:2' # Болотнинский лесохозяйственный участок № 1, Болотнинское, Новосибирская область
    _2_16_7='2:16:7' # Юлдыбаевское, Зилаирское, Республика Башкортостан
    _2_16_5='2:16:5' # Сабыровское, Зилаирское, Республика Башкортостан
    _2_16_6='2:16:6' # Суреньское, Зилаирское, Республика Башкортостан
    _5_4_2_3='54:2:3' # Болотнинский лесохозяйственный участок № 2, Болотнинское, Новосибирская область
    _5_4_2_4='54:2:4' # Кругликовский лесохозяйственный участок, Болотнинское, Новосибирская область
    _5_4_2_5='54:2:5' # Кунчурукский лесохозяйственный участок, Болотнинское, Новосибирская область
    _2_16_3='2:16:3' # Ново-Александровское, Зилаирское, Республика Башкортостан
    _2_16_4='2:16:4' # Петровское, Зилаирское, Республика Башкортостан
    _2_16_1='2:16:1' # Емашлинское, Зилаирское, Республика Башкортостан
    _2_16_2='2:16:2' # Зилаир-Шарское, Зилаирское, Республика Башкортостан
    _4_3_20_4='43:20:4' # Нолинское, Нолинское, Кировская область
    _3_7_3='3:7:3' # Дыренское, Верхне-Баргузинское, Республика Бурятия
    _4_3_20_3='43:20:3' # Медведское, Нолинское, Кировская область
    _3_7_2='3:7:2' # Джиргинское, Верхне-Баргузинское, Республика Бурятия
    _4_3_20_2='43:20:2' # Лудянское сельское, Нолинское, Кировская область
    _4_3_20_1='43:20:1' # Кырчанское, Нолинское, Кировская область
    _3_7_4='3:7:4' # Куллукское, Верхне-Баргузинское, Республика Бурятия
    _6_4_15_1='64:15:1' # Владыкинское, Макаровское, Саратовская область
    _4_3_20_7='43:20:7' # Шварихинское, Нолинское, Кировская область
    _4_3_20_6='43:20:6' # Татауровское, Нолинское, Кировская область
    _4_3_20_5='43:20:5' # Нолинское сельское, Нолинское, Кировская область
    _6_0_3_4='60:3:4' # Полновское, Гдовское, Псковская область
    _2_4_44_6='24:44:6' # Тугачинское, Саянское, Красноярский край
    _6_0_3_3='60:3:3' # Партизанское, Гдовское, Псковская область
    _6_0_3_5='60:3:5' # Черневское, Гдовское, Псковская область
    _2_4_44_3='24:44:3' # Вознесенское, Саянское, Красноярский край
    _6_4_15_2='64:15:2' # Красноярское, Макаровское, Саратовская область
    _2_4_44_2='24:44:2' # Агинское сельское, Саянское, Красноярский край
    _6_4_15_3='64:15:3' # Макаровское, Макаровское, Саратовская область
    _2_4_44_5='24:44:5' # Кирельское, Саянское, Красноярский край
    _3_7_1='3:7:1' # Аллинское, Верхне-Баргузинское, Республика Бурятия
    _6_0_3_2='60:3:2' # Дубровское, Гдовское, Псковская область
    _2_4_44_4='24:44:4' # Кан-Оклерское, Саянское, Красноярский край
    _6_0_3_1='60:3:1' # Гдовское, Гдовское, Псковская область
    _2_4_44_1='24:44:1' # Агинское, Саянское, Красноярский край
    _1_9_10_2='19:10:2' # Майнское, Саяногорское, Республика Хакасия
    _1_9_10_1='19:10:1' # Карловское, Саяногорское, Республика Хакасия
    _1_9_10_3='19:10:3' # Саяногорское, Саяногорское, Республика Хакасия
    _7_4_7_2='74:7:2' # Багарякское, Каслинское, Челябинская область
    _7_4_7_3='74:7:3' # Вишневогорское, Каслинское, Челябинская область
    _7_4_7_1='74:7:1' # Аракульское, Каслинское, Челябинская область
    _7_4_7_4='74:7:4' # Каслинское, Каслинское, Челябинская область
    _7_4_7_5='74:7:5' # Тюбукское, Каслинское, Челябинская область
    _4_7_5_8='47:5:8' # Новинское, Гатчинское, Ленинградская область
    _4_7_5_9='47:5:9' # Онцевское, Гатчинское, Ленинградская область
    _4_7_5_6='47:5:6' # Карташевское, Гатчинское, Ленинградская область
    _4_7_5_7='47:5:7' # Минское, Гатчинское, Ленинградская область
    _4_7_5_4='47:5:4' # Елизаветинское, Гатчинское, Ленинградская область
    _4_7_5_5='47:5:5' # Заречское, Гатчинское, Ленинградская область
    _4_7_5_2='47:5:2' # Дивенское, Гатчинское, Ленинградская область
    _2_4_57_5='24:57:5' # Уярское сельское, Уярское, Красноярский край
    _4_7_5_3='47:5:3' # Дружносельское, Гатчинское, Ленинградская область
    _2_4_57_4='24:57:4' # Уярское, Уярское, Красноярский край
    _4_7_5_1='47:5:1' # Вырицкое, Гатчинское, Ленинградская область
    _2_4_57_1='24:57:1' # Богунаевское, Уярское, Красноярский край
    _2_4_57_3='24:57:3' # Сокаревское, Уярское, Красноярский край
    _2_4_57_2='24:57:2' # Никольское, Уярское, Красноярский край
    _6_9_7_16='69:7:16' # Пушкинское, Тверское, Тверская область
    _6_9_7_15='69:7:15' # Путиловское, Тверское, Тверская область
    _6_9_7_14='69:7:14' # Петровское, Тверское, Тверская область
    _6_9_7_13='69:7:13' # Первомайское, Тверское, Тверская область
    _6_9_7_12='69:7:12' # Оршинское, Тверское, Тверская область
    _6_9_7_11='69:7:11' # Октябрьское, Тверское, Тверская область
    _6_9_7_10='69:7:10' # Медновское, Тверское, Тверская область
    _3_6_1_3='36:1:3' # Октябрьское, Аннинское, Воронежская область
    _3_6_1_2='36:1:2' # Ново-Чигольское, Аннинское, Воронежская область
    _3_6_1_1='36:1:1' # Архангельское, Аннинское, Воронежская область
    _3_6_1_4='36:1:4' # Первомайское, Аннинское, Воронежская область
    _6_9_7_20='69:7:20' # Чуприяновское, Тверское, Тверская область
    _6_9_7_19='69:7:19' # Сельцовское, Тверское, Тверская область
    _6_9_7_18='69:7:18' # Савватьевское, Тверское, Тверская область
    _6_9_7_17='69:7:17' # Рождественское, Тверское, Тверская область
    _5_3_8_6='53:8:6' # Устрекское, Мошенское, Новгородская область
    _5_3_8_1='53:8:1' # Кабожское, Мошенское, Новгородская область
    _5_3_8_4='53:8:4' # Мошенское, Мошенское, Новгородская область
    _5_3_8_5='53:8:5' # Ореховское, Мошенское, Новгородская область
    _5_3_8_2='53:8:2' # Крутецкое, Мошенское, Новгородская область
    _5_3_8_3='53:8:3' # Меглецкое, Мошенское, Новгородская область
    _1_2_4_2='12:4:2' # Кумьинское, Килемарское, Республика Марий Эл
    _1_2_4_1='12:4:1' # Килемарское, Килемарское, Республика Марий Эл
    _1_2_4_4='12:4:4' # Нежнурское, Килемарское, Республика Марий Эл
    _1_2_4_3='12:4:3' # Кундышское, Килемарское, Республика Марий Эл
    _1_2_4_5='12:4:5' # Удюрминское, Килемарское, Республика Марий Эл
    _5_4_15_7='54:15:7' # Маслянинский лесохозяйственный участок № 2, Маслянинское, Новосибирская область
    _5_4_15_5='54:15:5' # Елбанский лесохозяйственный участок, Маслянинское, Новосибирская область
    _5_4_15_6='54:15:6' # Маслянинский лесохозяйственный участок № 1, Маслянинское, Новосибирская область
    _5_4_15_3='54:15:3' # Дубровский лесохозяйственный участок, Маслянинское, Новосибирская область
    _5_4_15_4='54:15:4' # Егорьевский лесохозяйственный участок, Маслянинское, Новосибирская область
    _5_4_15_1='54:15:1' # Больше-Изыракский лесохозяйственный участок, Маслянинское, Новосибирская область
    _5_4_15_2='54:15:2' # Борковский лесохозяйственный участок, Маслянинское, Новосибирская область
    _6_7_14_1='67:14:1' # Болшевское, Новодугинское, Смоленская область
    _6_7_14_5='67:14:5' # Новодугинское сельское, Новодугинское, Смоленская область
    _6_7_14_4='67:14:4' # Новодугинское, Новодугинское, Смоленская область
    _6_7_14_3='67:14:3' # Загон, Новодугинское, Смоленская область
    _6_7_14_2='67:14:2' # Днепровское, Новодугинское, Смоленская область
    _1_1_32_1='11:32:1' # Зареченское, Чернамское, Республика Коми
    _1_1_32_2='11:32:2' # Усть-Вымское, Чернамское, Республика Коми
    _6_7_14_8='67:14:8' # Хвощеватовское, Новодугинское, Смоленская область
    _1_1_32_3='11:32:3' # Часовское, Чернамское, Республика Коми
    _6_7_14_7='67:14:7' # Торбеевское, Новодугинское, Смоленская область
    _6_7_14_6='67:14:6' # Приднепровское, Новодугинское, Смоленская область
    _1_7_6_3='17:6:3' # Эрзинское, Тес-Хемское, Республика Тыва
    _1_7_6_2='17:6:2' # Шуурмакское, Тес-Хемское, Республика Тыва
    _3_8_37_1='38:37:1' # Шелеховское, Шелеховское, Иркутская область
    _1_7_6_1='17:6:1' # Самагалтайское, Тес-Хемское, Республика Тыва
    _1_0_9_11='10:9:11' # Тулосское, Муезерское, Республика Карелия
    _1_0_9_12='10:9:12' # Тумбское, Муезерское, Республика Карелия
    _1_0_9_10='10:9:10' # Тикшинское, Муезерское, Республика Карелия
    _9_5_6='9:5:6' # Сторожевское, Урупское, Карачаево-Черкесская Республика
    _9_5_7='9:5:7' # Урупское, Урупское, Карачаево-Черкесская Республика
    _9_5_4='9:5:4' # Пантелеймоновское, Урупское, Карачаево-Черкесская Республика
    _9_5_5='9:5:5' # Преградненское, Урупское, Карачаево-Черкесская Республика
    _9_5_2='9:5:2' # Исправненское, Урупское, Карачаево-Черкесская Республика
    _4_2_2='4:2:2' # Манжерокское, Майминское, Республика Алтай
    _9_5_3='9:5:3' # Куньшанское, Урупское, Карачаево-Черкесская Республика
    _4_2_1='4:2:1' # Горно-Алтайское, Майминское, Республика Алтай
    _9_5_1='9:5:1' # Агурское, Урупское, Карачаево-Черкесская Республика
    _3_8_24_1='38:24:1' # Бугульдейское, Ольхонское, Иркутская область
    _3_8_24_2='38:24:2' # Ольхонское, Ольхонское, Иркутская область
    _4_3_34_2='43:34:2' # Порезское сельское, Унинское, Кировская область
    _4_3_34_3='43:34:3' # Унинское сельское, Унинское, Кировская область
    _4_3_34_4='43:34:4' # Ухтымское сельское, Унинское, Кировская область
    _4_3_34_5='43:34:5' # Хорошевское сельское, Унинское, Кировская область
    _4_3_34_1='43:34:1' # Канахинское сельское, Унинское, Кировская область
    _7_5_1_1='75:1:1' # Агинское, Агинское, Забайкальский край
    _7_5_1_2='75:1:2' # Аргалейское, Агинское, Забайкальский край
    _7_5_1_3='75:1:3' # Могойтуйское, Агинское, Забайкальский край
    _6_4_13_1='64:13:1' # Золотовское, Красноармейское, Саратовская область
    _6_4_13_2='64:13:2' # Красноармейское, Красноармейское, Саратовская область
    _6_4_13_3='64:13:3' # Мордовинское, Красноармейское, Саратовская область
    _6_4_13_4='64:13:4' # Нижнебанновское, Красноармейское, Саратовская область
    _3_5_12_8='35:12:8' # Чарозерское сельское, Кирилловское, Вологодская область
    _3_5_12_7='35:12:7' # Чарозерское, Кирилловское, Вологодская область
    _3_5_12_6='35:12:6' # Сусельское, Кирилловское, Вологодская область
    _3_5_12_5='35:12:5' # Пидемское, Кирилловское, Вологодская область
    _3_5_12_4='35:12:4' # Коротецкое, Кирилловское, Вологодская область
    _3_5_12_3='35:12:3' # Кирилловское, Кирилловское, Вологодская область
    _3_5_12_2='35:12:2' # Волокославинское, Кирилловское, Вологодская область
    _3_5_12_1='35:12:1' # Береговское, Кирилловское, Вологодская область
    _2_4_31_1='24:31:1' # Манзенское, Манзенское, Красноярский край
    _2_4_31_2='24:31:2' # Пинчугское, Манзенское, Красноярский край
    _2_4_31_3='24:31:3' # Таежинское, Манзенское, Красноярский край
    _4_3_21_3='43:21:3' # Залазнинское сельское, Омутнинское, Кировская область
    _4_3_21_2='43:21:2' # Залазнинское, Омутнинское, Кировская область
    _4_3_21_1='43:21:1' # Белореченское, Омутнинское, Кировская область
    _4_3_21_7='43:21:7' # Песковское, Омутнинское, Кировская область
    _2_2_15_2='22:15:2' # Курочкинское, Ларичихинское, Алтайский край
    _4_3_21_6='43:21:6' # Омутнинское сельское, Омутнинское, Кировская область
    _2_2_15_3='22:15:3' # Ново-Заринское, Ларичихинское, Алтайский край
    _4_3_21_5='43:21:5' # Омутнинское, Омутнинское, Кировская область
    _4_3_21_4='43:21:4' # Лупейское, Омутнинское, Кировская область
    _2_2_15_1='22:15:1' # Инское, Ларичихинское, Алтайский край
    _2_2_15_6='22:15:6' # Средне-Инское, Ларичихинское, Алтайский край
    _6_0_2_5='60:2:5' # Низовское, Великолукское, Псковская область
    _2_2_15_7='22:15:7' # Тальменское, Ларичихинское, Алтайский край
    _6_0_2_4='60:2:4' # Куньинское, Великолукское, Псковская область
    _4_3_21_9='43:21:9' # Чернохолуницкое, Омутнинское, Кировская область
    _2_2_15_4='22:15:4' # Озерское, Ларичихинское, Алтайский край
    _6_0_2_7='60:2:7' # Слепневское, Великолукское, Псковская область
    _4_3_21_8='43:21:8' # Струговское, Омутнинское, Кировская область
    _2_2_15_5='22:15:5' # Причумышское, Ларичихинское, Алтайский край
    _6_0_2_6='60:2:6' # Новосокольническое, Великолукское, Псковская область
    _6_0_2_1='60:2:1' # Букровское, Великолукское, Псковская область
    _2_2_15_8='22:15:8' # Шипицинское, Ларичихинское, Алтайский край
    _6_0_2_3='60:2:3' # Жижицкое, Великолукское, Псковская область
    _6_0_2_2='60:2:2' # Великолукское, Великолукское, Псковская область
    _6_0_2_8='60:2:8' # Стайковское, Великолукское, Псковская область
    _4_2_4_6='42:4:6' # Промышленновское, Кемеровское, Кемеровская область
    _4_2_4_5='42:4:5' # Невское, Кемеровское, Кемеровская область
    _4_2_4_4='42:4:4' # Мазуровское, Кемеровское, Кемеровская область
    _4_2_4_3='42:4:3' # Елыкаевское, Кемеровское, Кемеровская область
    _4_2_4_2='42:4:2' # Барзасское, Кемеровское, Кемеровская область
    _4_2_4_1='42:4:1' # Барановское, Кемеровское, Кемеровская область
    _4_7_15_5='47:15:5' # Линдуловское, Рощинское, Ленинградская область
    _4_7_15_6='47:15:6' # Октябрьское, Рощинское, Ленинградская область
    _4_7_15_3='47:15:3' # Красносельское, Рощинское, Ленинградская область
    _4_7_15_4='47:15:4' # Ленинское, Рощинское, Ленинградская область
    _4_7_15_1='47:15:1' # Глебычевское, Рощинское, Ленинградская область
    _4_7_15_2='47:15:2' # Житковское, Рощинское, Ленинградская область
    _4_7_15_9='47:15:9' # Полянское, Рощинское, Ленинградская область
    _4_7_15_7='47:15:7' # Пионерское, Рощинское, Ленинградская область
    _4_7_15_8='47:15:8' # Победовское, Рощинское, Ленинградская область
    _7_2_20_2='72:20:2' # Лесновское, Юргинское, Тюменская область
    _7_2_20_1='72:20:1' # Агаракское, Юргинское, Тюменская область
    _7_2_20_4='72:20:4' # Юргинское сельское, Юргинское, Тюменская область
    _7_2_20_3='72:20:3' # Сосновское, Юргинское, Тюменская область
    _3_5_25_6='35:25:6' # Уломское, Череповецкое, Вологодская область
    _3_5_25_5='35:25:5' # Судское, Череповецкое, Вологодская область
    _3_5_25_4='35:25:4' # Мяксинское, Череповецкое, Вологодская область
    _3_5_25_3='35:25:3' # Мотомское, Череповецкое, Вологодская область
    _3_5_25_2='35:25:2' # Кубинское, Череповецкое, Вологодская область
    _3_5_25_1='35:25:1' # Ваучское, Череповецкое, Вологодская область
    _5_13_2='5:13:2' # Червлено-Бурунское, Ногайское, Республика Дагестан
    _5_13_1='5:13:1' # Ногайское, Ногайское, Республика Дагестан
    _3_5_25_9='35:25:9' # Южское, Череповецкое, Вологодская область
    _3_5_25_8='35:25:8' # Шухтовское, Череповецкое, Вологодская область
    _3_5_25_7='35:25:7' # Череповецкое, Череповецкое, Вологодская область
    _2_2_28_1='22:28:1' # Аламбайское, Тягунское, Алтайский край
    _2_2_28_4='22:28:4' # Тягунское, Тягунское, Алтайский край
    _2_2_28_5='22:28:5' # Хмелевское, Тягунское, Алтайский край
    _2_2_28_2='22:28:2' # Новомоношкинское, Тягунское, Алтайский край
    _2_9_7_1='29:7:1' # Брин-Наволоцкое, Емецкое, Архангельская область
    _2_2_28_3='22:28:3' # Сорокинское, Тягунское, Алтайский край
    _2_9_7_2='29:7:2' # Емецкое, Емецкое, Архангельская область
    _2_9_7_3='29:7:3' # Емецкое сельское, Емецкое, Архангельская область
    _2_9_7_4='29:7:4' # Ковозерское, Емецкое, Архангельская область
    _2_9_7_5='29:7:5' # Пингишенское, Емецкое, Архангельская область
    _2_4_4_1='24:4:1' # Балахтинское, Балахтинское, Красноярский край
    _5_9_3_3='59:3:3' # Усть-Черновское, Веслянское, Пермский край
    _5_9_3_2='59:3:2' # Веслянское, Веслянское, Пермский край
    _5_9_3_1='59:3:1' # Березовское, Веслянское, Пермский край
    _2_4_4_2='24:4:2' # Балахтинское сельское, Балахтинское, Красноярский край
    _2_4_4_3='24:4:3' # Даурское, Балахтинское, Красноярский край
    _8_6_6_3='86:6:3' # Нефтеюганское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _5_0_5_19='50:5:19' # Тишковское, Дмитровское, Московская область
    _8_6_6_2='86:6:2' # Лемпинское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _8_6_6_1='86:6:1' # Куть-Яхское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _5_0_5_16='50:5:16' # Раменское, Дмитровское, Московская область
    _5_0_5_15='50:5:15' # Протасовское, Дмитровское, Московская область
    _8_6_6_6='86:6:6' # Юнг-Яхское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _5_0_5_18='50:5:18' # Тимоновское, Дмитровское, Московская область
    _8_6_6_5='86:6:5' # Салымское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _5_0_5_17='50:5:17' # Рогачевское, Дмитровское, Московская область
    _8_6_6_4='86:6:4' # Пывь-Яхское, Нефтеюганское, Ханты-Мансийский автономный округ - Югра
    _5_0_5_12='50:5:12' # Орудьевское, Дмитровское, Московская область
    _5_0_5_11='50:5:11' # Ольговское, Дмитровское, Московская область
    _6_5_5_2='65:5:2' # Красногорское, Красногорское, Сахалинская область
    _5_0_5_14='50:5:14' # Пироговское, Дмитровское, Московская область
    _6_5_5_1='65:5:1' # Ильинское, Красногорское, Сахалинская область
    _5_0_5_13='50:5:13' # Пантюхинское, Дмитровское, Московская область
    _5_0_5_10='50:5:10' # Марфинское, Дмитровское, Московская область
    _3_8_11_2='38:11:2' # Зулумайское, Зиминское, Иркутская область
    _3_8_11_1='38:11:1' # Буринское, Зиминское, Иркутская область
    _5_0_5_21='50:5:21' # Хлебниковское, Дмитровское, Московская область
    _5_0_5_20='50:5:20' # Учинское, Дмитровское, Московская область
    _2_8_12_4='28:12:4' # Джалиндинское, Урушинское, Амурская область
    _2_8_12_3='28:12:3' # Верхнеурушинское, Урушинское, Амурская область
    _2_8_12_2='28:12:2' # Верхненюкжинское, Урушинское, Амурская область
    _2_8_12_1='28:12:1' # Бейтоновское, Урушинское, Амурская область
    _2_8_12_9='28:12:9' # Тахтамыгдинское, Урушинское, Амурская область
    _2_8_12_8='28:12:8' # Талданское, Урушинское, Амурская область
    _2_8_12_7='28:12:7' # Сковородинское, Урушинское, Амурская область
    _2_8_12_6='28:12:6' # Игнашинское, Урушинское, Амурская область
    _2_8_12_5='28:12:5' # Ерофеевское, Урушинское, Амурская область
    _7_5_20_1='75:20:1' # Ботовское, Сретенское, Забайкальский край
    _7_5_20_2='75:20:2' # Копуньское, Сретенское, Забайкальский край
    _7_5_20_3='75:20:3' # Куэнгинское, Сретенское, Забайкальский край
    _7_5_20_4='75:20:4' # Сретенское, Сретенское, Забайкальский край
    _7_5_20_5='75:20:5' # Усть-Карское, Сретенское, Забайкальский край
    _7_5_20_6='75:20:6' # Фирсовское, Сретенское, Забайкальский край
    _7_5_20_7='75:20:7' # Чикичейское, Сретенское, Забайкальский край
    _7_5_20_8='75:20:8' # Шелопугинское, Сретенское, Забайкальский край
    _3_5_8_7='35:8:7' # Кубенское, Вологодское, Вологодская область
    _3_5_8_6='35:8:6' # Кубено-Озерское, Вологодское, Вологодская область
    _3_5_8_9='35:8:9' # Пригородное, Вологодское, Вологодская область
    _3_5_8_8='35:8:8' # Новленское, Вологодское, Вологодская область
    _3_5_8_3='35:8:3' # Емское, Вологодское, Вологодская область
    _1_0_13_10='10:13:10' # Пряжинское, Пряжинское, Республика Карелия
    _3_5_8_2='35:8:2' # Диковское, Вологодское, Вологодская область
    _1_0_13_11='10:13:11' # Святозерское, Пряжинское, Республика Карелия
    _3_5_8_5='35:8:5' # Кипеловское сельское, Вологодское, Вологодская область
    _1_0_13_12='10:13:12' # Соддерское, Пряжинское, Республика Карелия
    _3_5_8_4='35:8:4' # Кипеловское, Вологодское, Вологодская область
    _1_0_13_13='10:13:13' # Сяпсинское, Пряжинское, Республика Карелия
    _3_5_8_1='35:8:1' # Вологодское, Вологодское, Вологодская область
    _1_0_13_14='10:13:14' # Южно-Святозерское, Пряжинское, Республика Карелия
    _7_3_17_4='73:17:4' # Сурское, Сурское, Ульяновская область
    _7_3_17_2='73:17:2' # Кувайское, Сурское, Ульяновская область
    _7_3_17_3='73:17:3' # Лавинское, Сурское, Ульяновская область
    _7_3_17_1='73:17:1' # Астрадамовское, Сурское, Ульяновская область
    _4_4_18_1='44:18:1' # 1-е Зашугомское, Солигаличское, Костромская область
    _2_9_7_6='29:7:6' # Селецкое, Емецкое, Архангельская область
    _4_4_18_2='44:18:2' # 1-е Корцовское, Солигаличское, Костромская область
    _2_9_7_7='29:7:7' # Челмохотское, Емецкое, Архангельская область
    _4_4_18_3='44:18:3' # 1-е Солигаличское, Солигаличское, Костромская область
    _4_4_18_4='44:18:4' # 2-е Зашугомское, Солигаличское, Костромская область
    _4_4_18_5='44:18:5' # 2-е Корцовское, Солигаличское, Костромская область
    _4_4_18_6='44:18:6' # 2-е Солигаличское, Солигаличское, Костромская область
    _4_4_18_7='44:18:7' # Берёзовское, Солигаличское, Костромская область
    _4_4_18_8='44:18:8' # Колногорское, Солигаличское, Костромская область
    _5_4_1_1='54:1:1' # Барабинский лесохозяйственный участок, Барабинское, Новосибирская область
    _5_4_1_2='54:1:2' # Беловский лесохозяйственный участок, Барабинское, Новосибирская область
    _5_4_1_3='54:1:3' # Козловский лесохозяйственный участок, Барабинское, Новосибирская область
    _4_4_18_9='44:18:9' # Коровновское, Солигаличское, Костромская область
    _1_1_9_5='11:9:5' # Якшинское, Комсомольское, Республика Коми
    _1_1_9_4='11:9:4' # Курьинское, Комсомольское, Республика Коми
    _2_17_4='2:17:4' # Улу-Телякское, Иглинское, Республика Башкортостан
    _1_1_9_3='11:9:3' # Комсомольское, Комсомольское, Республика Коми
    _2_17_5='2:17:5' # Урманское, Иглинское, Республика Башкортостан
    _1_1_9_2='11:9:2' # Знаменское, Комсомольское, Республика Коми
    _2_17_2='2:17:2' # Пушкинское, Иглинское, Республика Башкортостан
    _1_1_9_1='11:9:1' # Верхнепечорское, Комсомольское, Республика Коми
    _2_17_3='2:17:3' # Тавтимановское, Иглинское, Республика Башкортостан
    _2_17_1='2:17:1' # Иглинское, Иглинское, Республика Башкортостан
    _3_2_15_3='32:15:3' # Погощенское, Суземское, Брянская область
    _3_2_15_4='32:15:4' # Холмечское, Суземское, Брянская область
    _3_2_15_1='32:15:1' # Кокоревское, Суземское, Брянская область
    _3_2_15_2='32:15:2' # Негинское, Суземское, Брянская область
    _5_4_14_8='54:14:8' # Черновский лесохозяйственный участок, Кыштовское, Новосибирская область
    _5_4_14_6='54:14:6' # Кыштовский лесохозяйственный участок № 2, Кыштовское, Новосибирская область
    _5_4_14_7='54:14:7' # Ново-Майзасский лесохозяйственный участок, Кыштовское, Новосибирская область
    _5_4_14_4='54:14:4' # Крутихинский лесохозяйственный участок, Кыштовское, Новосибирская область
    _5_4_14_5='54:14:5' # Кыштовский лесохозяйственный участок № 1, Кыштовское, Новосибирская область
    _5_4_14_2='54:14:2' # Верх-Тарский лесохозяйственный участок, Кыштовское, Новосибирская область
    _5_4_14_3='54:14:3' # Колбасинский лесохозяйственный участок, Кыштовское, Новосибирская область
    _5_4_14_1='54:14:1' # Верх-Майзасский лесохозяйственный участок, Кыштовское, Новосибирская область
    _3_8_2='3:8:2' # Санномысское, Верхне-Талецкое, Республика Бурятия
    _3_8_1='3:8:1' # Карбаиновское, Верхне-Талецкое, Республика Бурятия
    _3_8_4='3:8:4' # Хандагайское, Верхне-Талецкое, Республика Бурятия
    _6_4_14_1='64:14:1' # Лысогорское, Лысогорское, Саратовская область
    _3_8_3='3:8:3' # Удинское, Верхне-Талецкое, Республика Бурятия
    _6_4_14_2='64:14:2' # Урицкое, Лысогорское, Саратовская область
    _3_6_2_2='36:2:2' # Икорецкое, Бобровское, Воронежская область
    _2_4_45_6='24:45:6' # Северо-Енисейское, Северо-Енисейское, Красноярский край
    _3_6_2_1='36:2:1' # Бобровское, Бобровское, Воронежская область
    _2_4_45_5='24:45:5' # Пит-Городокское, Северо-Енисейское, Красноярский край
    _2_4_45_8='24:45:8' # Тейское, Северо-Енисейское, Красноярский край
    _2_4_45_7='24:45:7' # Сухо-Питское, Северо-Енисейское, Красноярский край
    _2_4_45_2='24:45:2' # Вельминское, Северо-Енисейское, Красноярский край
    _2_4_45_1='24:45:1' # Брянковское, Северо-Енисейское, Красноярский край
    _3_6_2_4='36:2:4' # Хреновское, Бобровское, Воронежская область
    _2_4_45_4='24:45:4' # Новокаламинское, Северо-Енисейское, Красноярский край
    _3_6_2_3='36:2:3' # Семёно-Александровское, Бобровское, Воронежская область
    _2_4_45_3='24:45:3' # Ерудо-Питское, Северо-Енисейское, Красноярский край
    _7_4_8_1='74:8:1' # Верх-Катавское, Катав-Ивановское, Челябинская область
    _7_4_8_2='74:8:2' # Катавское, Катав-Ивановское, Челябинская область
    _7_4_8_5='74:8:5' # Орловское, Катав-Ивановское, Челябинская область
    _7_4_8_6='74:8:6' # Сульское, Катав-Ивановское, Челябинская область
    _7_4_8_3='74:8:3' # Лемезинское, Катав-Ивановское, Челябинская область
    _7_4_8_4='74:8:4' # Месединское, Катав-Ивановское, Челябинская область
    _5_3_7_1='53:7:1' # Велильское, Маревское, Новгородская область
    _5_3_7_2='53:7:2' # Маревское, Маревское, Новгородская область
    _7_4_8_7='74:8:7' # Юрюзанское, Катав-Ивановское, Челябинская область
    _5_3_7_5='53:7:5' # Первомайское, Маревское, Новгородская область
    _5_3_7_3='53:7:3' # Молвотицкое, Маревское, Новгородская область
    _5_3_7_4='53:7:4' # Одоевское, Маревское, Новгородская область
    _4_7_6_9='47:6:9' # Тикописское, Кингисеппское, Ленинградская область
    _4_7_6_7='47:6:7' # Приморское, Кингисеппское, Ленинградская область
    _4_7_6_8='47:6:8' # Сойкинское, Кингисеппское, Ленинградская область
    _4_7_6_5='47:6:5' # Кингисеппское, Кингисеппское, Ленинградская область
    _4_7_6_6='47:6:6' # Котельское, Кингисеппское, Ленинградская область
    _4_7_6_3='47:6:3' # Ивангородское, Кингисеппское, Ленинградская область
    _4_7_6_4='47:6:4' # Ивановское, Кингисеппское, Ленинградская область
    _4_7_6_1='47:6:1' # Александровское, Кингисеппское, Ленинградская область
    _1_2_3_1='12:3:1' # Волжское, Звениговское, Республика Марий Эл
    _4_7_6_2='47:6:2' # Георгиевское, Кингисеппское, Ленинградская область
    _2_4_58_3='24:58:3' # Яркинское, Хребтовское, Красноярский край
    _1_2_3_3='12:3:3' # Суслонгерское, Звениговское, Республика Марий Эл
    _1_2_3_2='12:3:2' # Нуктужское, Звениговское, Республика Марий Эл
    _2_4_58_2='24:58:2' # Пашутинское, Хребтовское, Красноярский край
    _2_4_58_1='24:58:1' # Заледеевское, Хребтовское, Красноярский край
    _2_2_14_3='22:14:3' # Гоноховское, Кулундинское, Алтайский край
    _2_2_14_4='22:14:4' # Тюменцевское, Кулундинское, Алтайский край
    _2_2_14_1='22:14:1' # Вылковское, Кулундинское, Алтайский край
    _2_2_14_2='22:14:2' # Гилевское, Кулундинское, Алтайский край
    _2_2_14_7='22:14:7' # Шелаболихинское, Кулундинское, Алтайский край
    _2_2_14_5='22:14:5' # Усть-Мосихинское, Кулундинское, Алтайский край
    _2_2_14_6='22:14:6' # Шарчинское, Кулундинское, Алтайский край
    _1_8_3_3='18:3:3' # Какможское, Вавожское, Удмуртская Республика
    _1_8_3_2='18:3:2' # Волипельгинское, Вавожское, Удмуртская Республика
    _1_8_3_4='18:3:4' # Центральное, Вавожское, Удмуртская Республика
    _6_5_4_3='65:4:3' # Охотское, Корсаковское, Сахалинская область
    _1_8_3_1='18:3:1' # Брызгаловское, Вавожское, Удмуртская Республика
    _6_5_4_2='65:4:2' # Озерское, Корсаковское, Сахалинская область
    _6_5_4_1='65:4:1' # Корсаковское, Корсаковское, Сахалинская область
    _4_0_10_1='40:10:1' # Красноборское, Куйбышевское, Калужская область
    _4_0_10_2='40:10:2' # Кузьминичское, Куйбышевское, Калужская область
    _4_0_10_3='40:10:3' # Раменное, Куйбышевское, Калужская область
    _4_0_10_4='40:10:4' # Тимирязевское, Куйбышевское, Калужская область
    _2_7_31_8='27:31:8' # Ушманское, Тырминское, Хабаровский край
    _2_7_31_7='27:31:7' # Тырминское, Тырминское, Хабаровский край
    _4_0_10_5='40:10:5' # Троицкое, Куйбышевское, Калужская область
    _4_0_10_6='40:10:6' # Феликсовское, Куйбышевское, Калужская область
    _2_7_31_2='27:31:2' # Гуджиканское, Тырминское, Хабаровский край
    _2_7_31_1='27:31:1' # Аланапское, Тырминское, Хабаровский край
    _2_7_31_6='27:31:6' # Таланджинское, Тырминское, Хабаровский край
    _2_7_31_5='27:31:5' # Сутарское, Тырминское, Хабаровский край
    _2_7_31_4='27:31:4' # Согдинское, Тырминское, Хабаровский край
    _2_7_31_3='27:31:3' # Мельгинское, Тырминское, Хабаровский край
    _1_0_8_11='10:8:11' # Селегское, Медвежьегорское, Республика Карелия
    _1_0_8_10='10:8:10' # Северное, Медвежьегорское, Республика Карелия
    _1_0_8_13='10:8:13' # Чебинское, Медвежьегорское, Республика Карелия
    _1_0_8_12='10:8:12' # Сергиевское, Медвежьегорское, Республика Карелия
    _1_1_22_6='11:22:6' # Яснэгское, Сыктывдинское, Республика Коми
    _1_1_22_5='11:22:5' # Ыбское, Сыктывдинское, Республика Коми
    _1_1_22_4='11:22:4' # Шыладорское, Сыктывдинское, Республика Коми
    _3_8_36_4='38:36:4' # Неванское, Чунское, Иркутская область
    _1_1_22_3='11:22:3' # Часовское, Сыктывдинское, Республика Коми
    _1_0_8_15='10:8:15' # Шалговаарское, Медвежьегорское, Республика Карелия
    _3_8_36_5='38:36:5' # Червянское, Чунское, Иркутская область
    _1_1_22_2='11:22:2' # Слудское, Сыктывдинское, Республика Коми
    _1_0_8_14='10:8:14' # Челмужское, Медвежьегорское, Республика Карелия
    _3_8_36_2='38:36:2' # Выдринское, Чунское, Иркутская область
    _1_1_22_1='11:22:1' # Пажгинское, Сыктывдинское, Республика Коми
    _3_8_36_3='38:36:3' # Мироновское, Чунское, Иркутская область
    _1_0_8_16='10:8:16' # Юккогубское, Медвежьегорское, Республика Карелия
    _3_8_36_1='38:36:1' # Баяндаевское, Чунское, Иркутская область
    _5_12_1='5:12:1' # Кумторкалинское, Махачкалинское, Республика Дагестан
    _5_12_3='5:12:3' # Махачкалинское, Махачкалинское, Республика Дагестан
    _5_12_2='5:12:2' # Лесопарковое, Махачкалинское, Республика Дагестан
    _6_0_1_6='60:1:6' # Стехновское, Бежаницкое, Псковская область
    _6_0_1_5='60:1:5' # Самолуковское, Бежаницкое, Псковская область
    _6_0_1_2='60:1:2' # Бежаницкое, Бежаницкое, Псковская область
    _6_0_1_1='60:1:1' # Ашевское, Бежаницкое, Псковская область
    _6_0_1_4='60:1:4' # Новоржевское, Бежаницкое, Псковская область
    _6_0_1_3='60:1:3' # Локнянское, Бежаницкое, Псковская область
    _4_3_4='4:3:4' # Теньгинское, Онгудайское, Республика Алтай
    _4_3_3='4:3:3' # Онгудайское, Онгудайское, Республика Алтай
    _4_3_2='4:3:2' # Каракольское, Онгудайское, Республика Алтай
    _4_3_1='4:3:1' # Ининское, Онгудайское, Республика Алтай
    _2_2_27_1='22:27:1' # Ельцовское, Тогульское, Алтайский край
    _2_2_27_2='22:27:2' # Кытмановское, Тогульское, Алтайский край
    _2_2_27_3='22:27:3' # Новоиушинское, Тогульское, Алтайский край
    _2_2_27_4='22:27:4' # Тогульское, Тогульское, Алтайский край
    _7_5_2_1='75:2:1' # Акшинское, Акшинское, Забайкальский край
    _7_5_2_2='75:2:2' # Нарасунское, Акшинское, Забайкальский край
    _7_5_2_3='75:2:3' # Урейское, Акшинское, Забайкальский край
    _7_5_2_4='75:2:4' # Усть-Илинское, Акшинское, Забайкальский край
    _4_1_7_1='41:7:1' # Апачинское, Усть-Большерецкое, Камчатский край
    _5_9_2_4='59:2:4' # Кутимское, Вайское, Пермский край
    _4_1_7_3='41:7:3' # Усть-Большерецкое, Усть-Большерецкое, Камчатский край
    _5_9_2_3='59:2:3' # Велсовское, Вайское, Пермский край
    _4_1_7_2='41:7:2' # Соболевское, Усть-Большерецкое, Камчатский край
    _5_9_2_2='59:2:2' # Вайское, Вайское, Пермский край
    _5_9_2_1='59:2:1' # Акчимское, Вайское, Пермский край
    _2_3_7_4='23:7:4' # Ольгинское, Джубгское, Краснодарский край
    _7_2_10_1='72:10:1' # Ишимское, Ишимское, Тюменская область
    _7_2_10_3='72:10:3' # Синицинское, Ишимское, Тюменская область
    _7_2_10_2='72:10:2' # Ишимское сельское, Ишимское, Тюменская область
    _2_3_7_1='23:7:1' # Дефановское, Джубгское, Краснодарский край
    _2_3_7_2='23:7:2' # Лермонтовское, Джубгское, Краснодарский край
    _2_3_7_3='23:7:3' # Новомихайловское, Джубгское, Краснодарский край
    _4_7_14_6='47:14:6' # Джатиевское, Приозерское, Ленинградская область
    _4_7_14_7='47:14:7' # Коммунарское, Приозерское, Ленинградская область
    _4_7_14_4='47:14:4' # Громовское, Приозерское, Ленинградская область
    _4_7_14_5='47:14:5' # Денисовское, Приозерское, Ленинградская область
    _4_7_14_2='47:14:2' # Борисовское, Приозерское, Ленинградская область
    _4_7_14_3='47:14:3' # Вуоксинское, Приозерское, Ленинградская область
    _4_7_14_1='47:14:1' # Антикайненское, Приозерское, Ленинградская область
    _4_7_14_8='47:14:8' # Кривковское, Приозерское, Ленинградская область
    _4_7_14_9='47:14:9' # Куйбышевское, Приозерское, Ленинградская область
    _2_4_32_7='24:32:7' # Шалинское сельское, Манское, Красноярский край
    _2_4_32_3='24:32:3' # Крольское, Манское, Красноярский край
    _2_4_32_4='24:32:4' # Манское, Манское, Красноярский край
    _2_4_32_5='24:32:5' # Унгутское, Манское, Красноярский край
    _2_4_32_6='24:32:6' # Шалинское, Манское, Красноярский край
    _2_4_32_1='24:32:1' # Баджейское, Манское, Красноярский край
    _7_6_15_1='76:15:1' # Некрасовское, ГКУ ЯО "Ярославское лесничество", Ярославская область
    _2_4_32_2='24:32:2' # Колбинское, Манское, Красноярский край
    _7_6_15_2='76:15:2' # Пригородное, ГКУ ЯО "Ярославское лесничество", Ярославская область
    _5_12_4='5:12:4' # Сулакское, Махачкалинское, Республика Дагестан
    _7_6_15_3='76:15:3' # Яковлевское, ГКУ ЯО "Ярославское лесничество", Ярославская область
    _6_6_30_5='66:30:5' # Шарыгинское, Туринское, Свердловская область
    _6_6_30_4='66:30:4' # Туринское, Туринское, Свердловская область
    _6_6_30_3='66:30:3' # Сарагульское, Туринское, Свердловская область
    _6_6_30_2='66:30:2' # Ленское, Туринское, Свердловская область
    _6_6_30_1='66:30:1' # Благовещенское, Туринское, Свердловская область
    _3_8_10_2='38:10:2' # Черемшанское, Заларинское, Иркутская область
    _3_8_10_1='38:10:1' # Тыретское, Заларинское, Иркутская область
    _1_2_16_1='12:16:1' # Бушковское, Сернурское, Республика Марий Эл
    _3_0_2_3='30:2:3' # Лиманское, Западнодельтовое, Астраханская область
    _3_0_2_4='30:2:4' # Мумринское, Западнодельтовое, Астраханская область
    _3_0_2_1='30:2:1' # Икрянинское, Западнодельтовое, Астраханская область
    _3_0_2_2='30:2:2' # Камызякское, Западнодельтовое, Астраханская область
    _8_6_7_2='86:7:2' # Корликовское, Нижневартовское, Ханты-Мансийский автономный округ - Югра
    _8_6_7_1='86:7:1' # Излучинское, Нижневартовское, Ханты-Мансийский автономный округ - Югра
    _3_0_2_7='30:2:7' # Травинское, Западнодельтовое, Астраханская область
    _8_6_7_5='86:7:5' # Охтеурское, Нижневартовское, Ханты-Мансийский автономный округ - Югра
    _3_0_2_5='30:2:5' # Правобережное, Западнодельтовое, Астраханская область
    _8_6_7_4='86:7:4' # Нижневартовское, Нижневартовское, Ханты-Мансийский автономный округ - Югра
    _3_0_2_6='30:2:6' # Приволжское, Западнодельтовое, Астраханская область
    _8_6_7_3='86:7:3' # Ларьякское, Нижневартовское, Ханты-Мансийский автономный округ - Югра
    _3_8_23_2='38:23:2' # Харётское, Нукутское, Иркутская область
    _3_8_23_1='38:23:1' # Новонукутское, Нукутское, Иркутская область
    _5_0_6_13='50:6:13' # Юбилейное, Егорьевское, Московская область
    _2_4_1_3='24:1:3' # Долгомостовское, Абанское, Красноярский край
    _5_8_8_2='58:8:2' # Вадинское-Беднодемьяновское-Кудеяровское, Ломовское, Пензенская область
    _5_0_6_12='50:6:12' # Чернолесское, Егорьевское, Московская область
    _2_4_1_4='24:1:4' # Каменское, Абанское, Красноярский край
    _5_8_8_1='58:8:1' # Барабановское-Наровчатское, Ломовское, Пензенская область
    _2_4_1_1='24:1:1' # Абанское, Абанское, Красноярский край
    _5_8_8_4='58:8:4' # Пачелмское-Черкасское, Ломовское, Пензенская область
    _2_4_1_2='24:1:2' # Абанское сельское, Абанское, Красноярский край
    _5_8_8_3='58:8:3' # Нижнеломовское-Верхнеломовское, Ломовское, Пензенская область
    _5_0_6_11='50:6:11' # Цнинское, Егорьевское, Московская область
    _2_4_1_5='24:1:5' # Почетское, Абанское, Красноярский край
    _5_0_6_10='50:6:10' # Радовицкое, Егорьевское, Московская область
    _3_5_15_5='35:15:5' # Кудангское, Никольское, Вологодская область
    _3_5_15_4='35:15:4' # Краснополянское, Никольское, Вологодская область
    _3_5_15_3='35:15:3' # Завражское, Никольское, Вологодская область
    _3_5_15_2='35:15:2' # Деминское, Никольское, Вологодская область
    _3_5_15_1='35:15:1' # Андангское, Никольское, Вологодская область
    _3_5_15_9='35:15:9' # Теребаевское, Никольское, Вологодская область
    _3_5_15_8='35:15:8' # Северное, Никольское, Вологодская область
    _3_5_15_7='35:15:7' # Полежаевское, Никольское, Вологодская область
    _3_5_15_6='35:15:6' # Никольское, Никольское, Вологодская область
    _2_27_8='2:27:8' # Килеевское, Туймазинское, Республика Башкортостан
    _2_27_7='2:27:7' # Кармалы-Губеевское, Туймазинское, Республика Башкортостан
    _2_27_6='2:27:6' # Кандринское, Туймазинское, Республика Башкортостан
    _2_27_5='2:27:5' # Гусевское, Туймазинское, Республика Башкортостан
    _2_27_9='2:27:9' # Кузеевское, Туймазинское, Республика Башкортостан
    _2_27_4='2:27:4' # Верхне-Троицкое, Туймазинское, Республика Башкортостан
    _2_27_3='2:27:3' # Буздякское, Туймазинское, Республика Башкортостан
    _2_27_2='2:27:2' # Бишиндинское, Туймазинское, Республика Башкортостан
    _2_27_1='2:27:1' # Бакалинское, Туймазинское, Республика Башкортостан
    _3_2_16_2='32:16:2' # Остролукское, Трубчевское, Брянская область
    _3_2_16_3='32:16:3' # Холмовское, Трубчевское, Брянская область
    _2_9_4_1='29:4:1' # Афанасьевское, Верхнетоемское, Архангельская область
    _2_9_4_2='29:4:2' # Верхнетоемское, Верхнетоемское, Архангельская область
    _2_9_4_3='29:4:3' # Вершинское, Верхнетоемское, Архангельская область
    _2_9_4_4='29:4:4' # Кодимское, Верхнетоемское, Архангельская область
    _2_9_4_5='29:4:5' # Лахомское, Верхнетоемское, Архангельская область
    _2_9_4_6='29:4:6' # Нижнетоемское, Верхнетоемское, Архангельская область
    _2_9_4_7='29:4:7' # Сефтренское, Верхнетоемское, Архангельская область
    _3_2_16_1='32:16:1' # Комягинское, Трубчевское, Брянская область
    _2_9_4_8='29:4:8' # Федьковское, Верхнетоемское, Архангельская область
    _5_3_6_8='53:6:8' # Парневское, Маловишерское, Новгородская область
    _5_3_6_9='53:6:9' # Пустовишерское, Маловишерское, Новгородская область
    _5_3_6_2='53:6:2' # Бургинское, Маловишерское, Новгородская область
    _5_3_6_3='53:6:3' # Веребьинское, Маловишерское, Новгородская область
    _5_3_6_1='53:6:1' # Большевишерское, Маловишерское, Новгородская область
    _5_3_6_6='53:6:6' # Каширское, Маловишерское, Новгородская область
    _5_3_6_7='53:6:7' # Маловишерское, Маловишерское, Новгородская область
    _5_3_6_4='53:6:4' # Грядское, Маловишерское, Новгородская область
    _5_3_6_5='53:6:5' # Дворищенское, Маловишерское, Новгородская область
    _2_14_9='2:14:9' # Турачинское, Дюртюлинское, Республика Башкортостан
    _2_14_7='2:14:7' # Куяновское, Дюртюлинское, Республика Башкортостан
    _2_14_8='2:14:8' # Надеждинское, Дюртюлинское, Республика Башкортостан
    _2_14_1='2:14:1' # Ангасякское, Дюртюлинское, Республика Башкортостан
    _5_8_9_1='58:9:1' # Даниловское, Лопатинское, Пензенская область
    _2_14_2='2:14:2' # Дюртюлинское, Дюртюлинское, Республика Башкортостан
    _5_8_9_3='58:9:3' # Малосердобинское, Лопатинское, Пензенская область
    _5_8_9_2='58:9:2' # Лопатинское-Козловское, Лопатинское, Пензенская область
    _2_14_5='2:14:5' # Кангышское, Дюртюлинское, Республика Башкортостан
    _2_14_6='2:14:6' # Карабашевское, Дюртюлинское, Республика Башкортостан
    _2_14_3='2:14:3' # Калтасинское, Дюртюлинское, Республика Башкортостан
    _2_14_4='2:14:4' # Калтасинское сельское, Дюртюлинское, Республика Башкортостан
    _4_7_3_17='47:3:17' # Часовенское, Волховское , Ленинградская область
    _4_7_3_16='47:3:16' # Хваловское, Волховское , Ленинградская область
    _4_7_3_15='47:3:15' # Сясьстроевское, Волховское , Ленинградская область
    _4_7_3_14='47:3:14' # Рыбежское сельское, Волховское , Ленинградская область
    _4_7_3_13='47:3:13' # Рыбежское, Волховское , Ленинградская область
    _4_7_3_12='47:3:12' # Порожское, Волховское , Ленинградская область
    _4_7_3_11='47:3:11' # Пашское, Волховское , Ленинградская область
    _4_7_3_10='47:3:10' # Новоладожское, Волховское , Ленинградская область
    _4_7_3_8='47:3:8' # Мыслинское, Волховское , Ленинградская область
    _4_7_3_9='47:3:9' # Николаевщинское, Волховское , Ленинградская область
    _4_7_3_6='47:3:6' # Кондежское, Волховское , Ленинградская область
    _4_7_3_7='47:3:7' # Масельгорское, Волховское , Ленинградская область
    _4_7_3_4='47:3:4' # Зареченское, Волховское , Ленинградская область
    _4_7_3_5='47:3:5' # Колчановское, Волховское , Ленинградская область
    _4_7_3_2='47:3:2' # Волховстроевское, Волховское , Ленинградская область
    _4_7_3_3='47:3:3' # Загубское, Волховское , Ленинградская область
    _4_7_3_1='47:3:1' # Волховское, Волховское , Ленинградская область
    _3_5_5_9='35:5:9' # Опокское, Великоустюгское, Вологодская область
    _3_5_5_6='35:5:6' # Лодейское, Великоустюгское, Вологодская область
    _3_5_5_5='35:5:5' # Кузинское, Великоустюгское, Вологодская область
    _3_5_5_8='35:5:8' # Нижне-Шарденгское, Великоустюгское, Вологодская область
    _3_5_5_7='35:5:7' # Ломоватское, Великоустюгское, Вологодская область
    _3_5_5_2='35:5:2' # Великоустюгское сельское, Великоустюгское, Вологодская область
    _3_5_5_1='35:5:1' # Великоустюгское, Великоустюгское, Вологодская область
    _3_5_5_4='35:5:4' # Красавинское, Великоустюгское, Вологодская область
    _3_5_5_3='35:5:3' # Железнодорожное, Великоустюгское, Вологодская область
    _4_3_31_5='43:31:5' # Октябрьское, Слободское, Кировская область
    _4_3_31_6='43:31:6' # Роговское, Слободское, Кировская область
    _4_3_31_7='43:31:7' # Слободское, Слободское, Кировская область
    _4_3_31_8='43:31:8' # Совьинское, Слободское, Кировская область
    _4_3_31_1='43:31:1' # Ильинское, Слободское, Кировская область
    _4_3_31_2='43:31:2' # Казанское, Слободское, Кировская область
    _4_3_31_3='43:31:3' # Каринское, Слободское, Кировская область
    _4_3_31_4='43:31:4' # Озерницкое, Слободское, Кировская область
    _2_4_33_6='24:33:6' # Крутокачинское, Мининское, Красноярский край
    _2_4_33_7='24:33:7' # Мининское, Мининское, Красноярский край
    _2_4_33_8='24:33:8' # Шумихинское, Мининское, Красноярский край
    _4_3_31_9='43:31:9' # Шестаковское, Слободское, Кировская область
    _2_4_33_2='24:33:2' # Дивногорское, Мининское, Красноярский край
    _2_4_33_3='24:33:3' # Еловское, Мининское, Красноярский край
    _2_4_33_4='24:33:4' # Зеледеевское, Мининское, Красноярский край
    _2_4_33_5='24:33:5' # Караульное, Мининское, Красноярский край
    _2_4_33_1='24:33:1' # Бирюсинское, Мининское, Красноярский край
    _1_7_9_4='17:9:4' # Чыраа-Бажынское, Чаданское, Республика Тыва
    _1_7_9_3='17:9:3' # Чаданское, Чаданское, Республика Тыва
    _1_7_9_2='17:9:2' # Сут-Хольское, Чаданское, Республика Тыва
    _1_7_9_1='17:9:1' # Овюрское, Чаданское, Республика Тыва
    _1_2_6_1='12:6:1' # Шойское, Куженерское, Республика Марий Эл
    _5_4_13_3='54:13:3' # Чистоозерный лесохозяйственный участок, Купинское, Новосибирская область
    _5_4_13_1='54:13:1' # Кулундинский лесохозяйственный участок, Купинское, Новосибирская область
    _5_4_13_2='54:13:2' # Купинский лесохозяйственный участок, Купинское, Новосибирская область
    _3_9_1='3:9:1' # Багдаринское, Витимское, Республика Бурятия
    _3_9_3='3:9:3' # Варваринское, Витимское, Республика Бурятия
    _3_9_2='3:9:2' # Баунтовское, Витимское, Республика Бурятия
    _3_9_5='3:9:5' # Нижнеципское, Витимское, Республика Бурятия
    _3_9_4='3:9:4' # Монгойское, Витимское, Республика Бурятия
    _3_9_6='3:9:6' # Уакитское, Витимское, Республика Бурятия
    _2_4_46_4='24:46:4' # Сухобузимское сельское, Сухобузимское, Красноярский край
    _2_4_46_1='24:46:1' # Кононовское, Сухобузимское, Красноярский край
    _6_4_17_1='64:17:1' # Лоховское, Новобурасское, Саратовская область
    _2_4_46_3='24:46:3' # Сухобузимское, Сухобузимское, Красноярский край
    _6_4_17_2='64:17:2' # Новобурасское, Новобурасское, Саратовская область
    _2_4_46_2='24:46:2' # Павловское, Сухобузимское, Красноярский край
    _6_4_17_3='64:17:3' # Тепловское, Новобурасское, Саратовская область
    _6_7_24_2='67:24:2' # Боголюбовское, Холм-Жирковское, Смоленская область
    _6_7_24_1='67:24:1' # Батуринское, Холм-Жирковское, Смоленская область
    _6_7_24_6='67:24:6' # Канютинское, Холм-Жирковское, Смоленская область
    _6_7_24_5='67:24:5' # Игоревское, Холм-Жирковское, Смоленская область
    _6_7_24_4='67:24:4' # Дяглевское, Холм-Жирковское, Смоленская область
    _6_7_24_3='67:24:3' # Владимирское, Холм-Жирковское, Смоленская область
    _6_7_24_9='67:24:9' # Тупиковское, Холм-Жирковское, Смоленская область
    _6_7_24_8='67:24:8' # Нахимовское, Холм-Жирковское, Смоленская область
    _6_7_24_7='67:24:7' # Комягинское, Холм-Жирковское, Смоленская область
    _1_9_12_4='19:12:4' # Туимское, Туимское, Республика Хакасия
    _1_9_12_3='19:12:3' # Озерное, Туимское, Республика Хакасия
    _1_9_12_5='19:12:5' # Ширинское, Туимское, Республика Хакасия
    _1_9_12_2='19:12:2' # Коммунаровское, Туимское, Республика Хакасия
    _1_9_12_1='19:12:1' # Беренжакское, Туимское, Республика Хакасия
    _7_4_9_1='74:9:1' # Бродокалмакское, Красноармейское, Челябинская область
    _6_7_11_3='67:11:3' # Самуйловское, Кармановское, Смоленская область
    _6_7_11_2='67:11:2' # Кармановское сельское, Кармановское, Смоленская область
    _6_7_11_1='67:11:1' # Кармановское, Кармановское, Смоленская область
    _7_4_9_4='74:9:4' # Сугоякское, Красноармейское, Челябинская область
    _7_4_9_2='74:9:2' # Красноармейское, Красноармейское, Челябинская область
    _7_4_9_3='74:9:3' # Севостьяновское, Красноармейское, Челябинская область
    _4_4_15_4='44:15:4' # Матвеевское, Парфеньевское, Костромская область
    _4_4_15_5='44:15:5' # Потрусовское, Парфеньевское, Костромская область
    _4_4_15_6='44:15:6' # Татауровское, Парфеньевское, Костромская область
    _5_4_26_3='54:26:3' # Чулымский лесохозяйственный участок, Чулымское, Новосибирская область
    _5_4_26_2='54:26:2' # Ужанихинский лесохозяйственный участок, Чулымское, Новосибирская область
    _5_4_26_1='54:26:1' # Верх-Каргатский лесохозяйственный участок, Чулымское, Новосибирская область
    _4_4_15_1='44:15:1' # 1-е Парфеньевское, Парфеньевское, Костромская область
    _4_4_15_2='44:15:2' # 2-е Парфеньевское, Парфеньевское, Костромская область
    _4_4_15_3='44:15:3' # Вохтомское, Парфеньевское, Костромская область
    _4_6_9_1='46:9:1' # Кшенское, Советское, Курская область
    _2_4_59_3='24:59:3' # Хожинское, Чунское, Красноярский край
    _4_6_9_2='46:9:2' # Советское, Советское, Курская область
    _2_4_59_2='24:59:2' # Такучетское, Чунское, Красноярский край
    _4_6_9_3='46:9:3' # Черемисиновское, Советское, Курская область
    _2_4_59_4='24:59:4' # Чуноярское, Чунское, Красноярский край
    _2_4_59_1='24:59:1' # Новохайское, Чунское, Красноярский край
    _1_1_21_6='11:21:6' # Сывъюдорское, Сторожевское, Республика Коми
    _1_1_21_5='11:21:5' # Сторожевское, Сторожевское, Республика Коми
    _1_1_21_4='11:21:4' # Подъельское, Сторожевское, Республика Коми
    _1_1_21_3='11:21:3' # Нившерское, Сторожевское, Республика Коми
    _1_1_21_2='11:21:2' # Кересское, Сторожевское, Республика Коми
    _1_1_21_1='11:21:1' # Богородское, Сторожевское, Республика Коми
    _5_6_20_1='56:20:1' # Саракташское, Саракташское, Оренбургская область
    _5_6_20_2='56:20:2' # Спасское, Саракташское, Оренбургская область
    _2_2_13_1='22:13:1' # Бастанское, Ключевское, Алтайский край
    _2_2_13_4='22:13:4' # Николаевское, Ключевское, Алтайский край
    _6_5_3_1='65:3:1' # Долинское, Долинское, Сахалинская область
    _2_2_13_5='22:13:5' # Покровское, Ключевское, Алтайский край
    _2_2_13_2='22:13:2' # Зерновое, Ключевское, Алтайский край
    _2_2_13_3='22:13:3' # Ключевское, Ключевское, Алтайский край
    _2_2_13_6='22:13:6' # Северное, Ключевское, Алтайский край
    _8_6_8_1='86:8:1' # Няксимвольское, Няксимвольское, Ханты-Мансийский автономный округ - Югра
    _8_6_8_2='86:8:2' # Хуранское, Няксимвольское, Ханты-Мансийский автономный округ - Югра
    _6_5_3_2='65:3:2' # Фирсовское, Долинское, Сахалинская область
    _6_7_25_1='67:25:1' # Понятовское, Шумячское, Смоленская область
    _4_0_11_1='40:11:1' # Бережковское, Людиновское, Калужская область
    _4_0_11_2='40:11:2' # Космачевское, Людиновское, Калужская область
    _4_0_11_3='40:11:3' # Людиновское, Людиновское, Калужская область
    _6_7_25_5='67:25:5' # Шумячское, Шумячское, Смоленская область
    _6_7_25_4='67:25:4' # Студенецкое, Шумячское, Смоленская область
    _6_7_25_3='67:25:3' # Снегиревское, Шумячское, Смоленская область
    _4_2_2_4='42:2:4' # Салаирское, Гурьевское, Кемеровская область
    _6_7_25_2='67:25:2' # Руссковское, Шумячское, Смоленская область
    _4_0_11_4='40:11:4' # Радомичское, Людиновское, Калужская область
    _4_0_11_5='40:11:5' # Савинское, Людиновское, Калужская область
    _2_7_30_3='27:30:3' # Сизиманское, Тумнинское, Хабаровский край
    _2_7_30_2='27:30:2' # Мулинское, Тумнинское, Хабаровский край
    _2_7_30_1='27:30:1' # Восточное, Тумнинское, Хабаровский край
    _2_7_30_4='27:30:4' # Тулучинское, Тумнинское, Хабаровский край
    _4_2_2_3='42:2:3' # Касьминское, Гурьевское, Кемеровская область
    _4_2_2_2='42:2:2' # Гавриловское, Гурьевское, Кемеровская область
    _4_2_2_1='42:2:1' # Бирюлинское, Гурьевское, Кемеровская область
    _2_3_8_1='23:8:1' # Новопокровское, Кавказское, Краснодарский край
    _2_3_8_2='23:8:2' # Первомайское, Кавказское, Краснодарский край
    _4_7_13_7='47:13:7' # Ивинское, Подпорожское, Ленинградская область
    _4_7_13_8='47:13:8' # Красноборское, Подпорожское, Ленинградская область
    _4_7_13_5='47:13:5' # Вознесенское, Подпорожское, Ленинградская область
    _4_7_13_6='47:13:6' # Гонгинское, Подпорожское, Ленинградская область
    _4_7_13_3='47:13:3' # Винницкое, Подпорожское, Ленинградская область
    _4_7_13_4='47:13:4' # Винницкое сельское, Подпорожское, Ленинградская область
    _4_7_13_1='47:13:1' # Важинское, Подпорожское, Ленинградская область
    _4_7_13_2='47:13:2' # Важинское сельское, Подпорожское, Ленинградская область
    _4_7_13_9='47:13:9' # Курбинское, Подпорожское, Ленинградская область
    _1_7_8_3='17:8:3' # Уюкское, Туранское, Республика Тыва
    _1_7_8_2='17:8:2' # Туранское, Туранское, Республика Тыва
    _1_7_8_1='17:8:1' # Белозерское, Туранское, Республика Тыва
    _7_2_22_2='72:22:2' # Караульноярское, Ярковское, Тюменская область
    _7_2_22_1='72:22:1' # Варваринское, Ярковское, Тюменская область
    _7_2_22_4='72:22:4' # Петропавловское, Ярковское, Тюменская область
    _7_2_22_3='72:22:3' # Маранское, Ярковское, Тюменская область
    _7_2_22_6='72:22:6' # Ярковское сельское, Ярковское, Тюменская область
    _7_2_22_5='72:22:5' # Юртоборовское, Ярковское, Тюменская область
    _7_6_14_1='76:14:1' # Заволжское, ГКУ ЯО "Угличское лесничество", Ярославская область
    _7_6_14_2='76:14:2' # Ильинское, ГКУ ЯО "Угличское лесничество", Ярославская область
    _7_6_14_3='76:14:3' # Покровское, ГКУ ЯО "Угличское лесничество", Ярославская область
    _7_6_14_4='76:14:4' # Угличское, ГКУ ЯО "Угличское лесничество", Ярославская область
    _5_11_2='5:11:2' # Рутульское, Магарамкентское, Республика Дагестан
    _5_11_1='5:11:1' # Магарамкентское, Магарамкентское, Республика Дагестан
    _2_4_20_4='24:20:4' # Кесовское, Ирбейское, Красноярский край
    _2_4_20_5='24:20:5' # Кунгусское, Ирбейское, Красноярский край
    _4_4_3='4:4:3' # Иогачское, Турочакское, Республика Алтай
    _2_4_20_1='24:20:1' # Агульское, Ирбейское, Красноярский край
    _4_4_2='4:4:2' # Верх-Бийское, Турочакское, Республика Алтай
    _2_4_20_2='24:20:2' # Ирбейское, Ирбейское, Красноярский край
    _4_4_1='4:4:1' # Бийкинское, Турочакское, Республика Алтай
    _2_4_20_3='24:20:3' # Ирбейское сельское, Ирбейское, Красноярский край
    _4_4_6='4:4:6' # Ушпинское, Турочакское, Республика Алтай
    _4_4_5='4:4:5' # Пыжинское, Турочакское, Республика Алтай
    _4_4_4='4:4:4' # Майское, Турочакское, Республика Алтай
    _4_3_32_4='43:32:4' # Сорвижское, Сорвижское, Кировская область
    _4_3_32_5='43:32:5' # Шембетское, Сорвижское, Кировская область
    _2_2_26_2='22:26:2' # Джентайское, Степно-Михайловское, Алтайский край
    _4_3_32_1='43:32:1' # Арбажское, Сорвижское, Кировская область
    _2_2_26_3='22:26:3' # Михайловское, Степно-Михайловское, Алтайский край
    _4_3_32_2='43:32:2' # Арбажское сельское, Сорвижское, Кировская область
    _4_3_32_3='43:32:3' # Косинское, Сорвижское, Кировская область
    _2_2_26_1='22:26:1' # Бор-Форпостовское, Степно-Михайловское, Алтайский край
    _2_2_26_6='22:26:6' # Соляно-Озерное, Степно-Михайловское, Алтайский край
    _2_2_26_7='22:26:7' # Сосновское, Степно-Михайловское, Алтайский край
    _2_2_26_4='22:26:4' # Ракитовское, Степно-Михайловское, Алтайский край
    _2_2_26_5='22:26:5' # Рублевское, Степно-Михайловское, Алтайский край
    _7_5_3_1='75:3:1' # Акатуйское, Александровско-Заводское, Забайкальский край
    _7_5_3_2='75:3:2' # Акурайское, Александровско-Заводское, Забайкальский край
    _7_5_3_3='75:3:3' # Александровско-Заводское, Александровско-Заводское, Забайкальский край
    _7_5_3_4='75:3:4' # Борзинское, Александровско-Заводское, Забайкальский край
    _7_5_3_5='75:3:5' # Кличкинское, Александровско-Заводское, Забайкальский край
    _7_5_3_6='75:3:6' # Курунзулайское, Александровско-Заводское, Забайкальский край
    _5_9_1_5='59:1:5' # Усольское, Березниковское, Пермский край
    _5_9_1_4='59:1:4' # Романовское, Березниковское, Пермский край
    _5_9_1_3='59:1:3' # Пригородное, Березниковское, Пермский край
    _5_9_1_2='59:1:2' # Верх-Кондасское, Березниковское, Пермский край
    _5_9_1_1='59:1:1' # Березниковское, Березниковское, Пермский край
    _3_5_14_6='35:14:6' # Пустошуйское, Междуреченское, Вологодская область
    _3_5_14_5='35:14:5' # Озерское, Междуреченское, Вологодская область
    _3_5_14_4='35:14:4' # Междуреченское, Междуреченское, Вологодская область
    _3_5_14_3='35:14:3' # Лаврентьевское, Междуреченское, Вологодская область
    _3_5_14_2='35:14:2' # Враговское, Междуреченское, Вологодская область
    _3_5_14_1='35:14:1' # Большедворское, Междуреченское, Вологодская область
    _3_5_14_9='35:14:9' # Шуйское, Междуреченское, Вологодская область
    _3_5_14_8='35:14:8' # Центральное, Междуреченское, Вологодская область
    _3_5_14_7='35:14:7' # Святогорское, Междуреченское, Вологодская область
    _1_2_17_1='12:17:1' # Ронгинское, Советское, Республика Марий Эл
    _6_4_9_2='64:9:2' # Новоузенское, Дьяковское, Саратовская область
    _6_4_9_1='64:9:1' # Комсомольское, Дьяковское, Саратовская область
    _6_4_9_3='64:9:3' # Питерское, Дьяковское, Саратовская область
    _3_2_18_1='32:18:1' # Учебно-опытное, Учебно-опытное, Брянская область
    _3_8_35_1='38:35:1' # Голуметское, Черемховское, Иркутская область
    _3_8_35_2='38:35:2' # Малобельское, Черемховское, Иркутская область
    _3_8_22_5='38:22:5' # Нижнеудинское, Нижнеудинское, Иркутская область
    _3_8_22_6='38:22:6' # Тофаларское, Нижнеудинское, Иркутская область
    _3_0_3_2='30:3:2' # Капустиноярское, Левобережное, Астраханская область
    _3_0_3_3='30:3:3' # Петропавловское, Левобережное, Астраханская область
    _3_0_3_1='30:3:1' # Болхунское, Левобережное, Астраханская область
    _3_0_3_6='30:3:6' # Харабалинское, Левобережное, Астраханская область
    _1_8_2_4='18:2:4' # Сергинское, Балезинское, Удмуртская Республика
    _1_8_2_3='18:2:3' # Набережное, Балезинское, Удмуртская Республика
    _3_0_3_4='30:3:4' # Сасыкольское, Левобережное, Астраханская область
    _3_0_3_5='30:3:5' # Селитренское, Левобережное, Астраханская область
    _1_8_2_5='18:2:5' # Ушурское, Балезинское, Удмуртская Республика
    _3_8_22_3='38:22:3' # Замзорское, Нижнеудинское, Иркутская область
    _3_8_22_4='38:22:4' # Каменское, Нижнеудинское, Иркутская область
    _3_8_22_1='38:22:1' # Алзамайское, Нижнеудинское, Иркутская область
    _1_8_2_2='18:2:2' # Карсовайское, Балезинское, Удмуртская Республика
    _3_8_22_2='38:22:2' # Боровинское, Нижнеудинское, Иркутская область
    _1_8_2_1='18:2:1' # Андрейшурское, Балезинское, Удмуртская Республика
    _4_4_2_10='44:2:10' # Шушкодомское, Буйское, Костромская область
    _5_8_7_1='58:7:1' # Веселовское, Ленинское, Пензенская область
    _2_4_2_2='24:2:2' # Бычковское, Ачинское, Красноярский край
    _5_8_7_3='58:7:3' # Ольшанское, Ленинское, Пензенская область
    _2_4_2_3='24:2:3' # Мазульское, Ачинское, Красноярский край
    _5_8_7_2='58:7:2' # Ермоловское-Степное, Ленинское, Пензенская область
    _2_4_2_1='24:2:1' # Большеулуйское, Ачинское, Красноярский край
    _5_8_7_4='58:7:4' # Степное им.Докучаева, Ленинское, Пензенская область
    _2_4_2_6='24:2:6' # Южно-Кытатское, Ачинское, Красноярский край
    _2_4_2_7='24:2:7' # Ястребовское, Ачинское, Красноярский край
    _2_4_2_4='24:2:4' # Тарутинское, Ачинское, Красноярский край
    _2_4_2_5='24:2:5' # Тарутинское сельское, Ачинское, Красноярский край
    _2_5_10_14='25:10:14' # Ханкайское сельское, Уссурийское, Приморский край
    _2_5_10_13='25:10:13' # Уссурийское сельское, Уссурийское, Приморский край
    _2_5_10_12='25:10:12' # Уссурийское, Уссурийское, Приморский край
    _5_3_5_9='53:5:9' # Петровское, Любытинское, Новгородская область
    _2_5_10_11='25:10:11' # Решетниковское, Уссурийское, Приморский край
    _2_5_10_10='25:10:10' # Раковское, Уссурийское, Приморский край
    _3_0_4_1='30:4:1' # Енотаевское, Правобережное, Астраханская область
    _5_3_5_3='53:5:3' # Каменское, Любытинское, Новгородская область
    _3_0_4_2='30:4:2' # Замьяновское, Правобережное, Астраханская область
    _5_3_5_4='53:5:4' # Клишинское, Любытинское, Новгородская область
    _5_3_5_1='53:5:1' # Зарубинское, Любытинское, Новгородская область
    _5_3_5_2='53:5:2' # Звонецкое, Любытинское, Новгородская область
    _5_3_5_7='53:5:7' # Любытинское, Любытинское, Новгородская область
    _2_5_10_17='25:10:17' # Экспериментальное, Уссурийское, Приморский край
    _5_3_5_8='53:5:8' # Неболчское, Любытинское, Новгородская область
    _2_5_10_16='25:10:16' # Ширяевское, Уссурийское, Приморский край
    _5_3_5_5='53:5:5' # Комаровское, Любытинское, Новгородская область
    _2_5_10_15='25:10:15' # Хорольское, Уссурийское, Приморский край
    _5_3_5_6='53:5:6' # Кременичское, Любытинское, Новгородская область
    _4_4_16_3='44:16:3' # Луптюгское, Поназыревское, Костромская область
    _4_4_16_4='44:16:4' # Марковское, Поназыревское, Костромская область
    _4_4_16_5='44:16:5' # Полдневицкое, Поназыревское, Костромская область
    _4_4_16_6='44:16:6' # Шортюгское, Поназыревское, Костромская область
    _4_4_16_7='44:16:7' # Якшангское, Поназыревское, Костромская область
    _3_0_4_5='30:4:5' # Солодниковское, Правобережное, Астраханская область
    _3_0_4_6='30:4:6' # Черноярское, Правобережное, Астраханская область
    _3_0_4_3='30:4:3' # Каменноярское, Правобережное, Астраханская область
    _3_0_4_4='30:4:4' # Никольское, Правобережное, Астраханская область
    _4_4_16_1='44:16:1' # 1-е Поназыревское, Поназыревское, Костромская область
    _4_4_16_2='44:16:2' # 2-е Поназыревское, Поназыревское, Костромская область
    _2_15_1='2:15:1' # Баишевское, Зианчуринское, Республика Башкортостан
    _2_15_4='2:15:4' # Юлдыбаевское, Зианчуринское, Республика Башкортостан
    _2_15_2='2:15:2' # Кара-Тугайское, Зианчуринское, Республика Башкортостан
    _2_15_3='2:15:3' # Касмарское, Зианчуринское, Республика Башкортостан
    _3_2_17_1='32:17:1' # Погарское, Унечское, Брянская область
    _3_2_17_2='32:17:2' # Рассухское, Унечское, Брянская область
    _3_2_17_3='32:17:3' # Стародубское, Унечское, Брянская область
    _3_2_17_4='32:17:4' # Унечское, Унечское, Брянская область
    _8_7_1_4='87:1:4' # Омолонское, Чукотское, Чукотский автономный округ
    _7_3_19_6='73:19:6' # Чердаклинское, Ульяновское, Ульяновская область
    _7_3_19_4='73:19:4' # Ульяновское, Ульяновское, Ульяновская область
    _7_3_19_5='73:19:5' # Ундоровское, Ульяновское, Ульяновская область
    _8_7_1_1='87:1:1' # Анюйское, Чукотское, Чукотский автономный округ
    _8_7_1_3='87:1:3' # Марковское, Чукотское, Чукотский автономный округ
    _8_7_1_2='87:1:2' # Билибинское, Чукотское, Чукотский автономный округ
    _5_4_12_4='54:12:4' # Михайловский лесохозяйственный участок, Куйбышевское, Новосибирская область
    _5_4_12_5='54:12:5' # Чумаковский лесохозяйственный участок, Куйбышевское, Новосибирская область
    _5_4_12_2='54:12:2' # Каминский лесохозяйственный участок, Куйбышевское, Новосибирская область
    _5_4_12_3='54:12:3' # Куйбышевский лесохозяйственный участок, Куйбышевское, Новосибирская область
    _5_4_12_1='54:12:1' # Булатовский лесохозяйственный участок, Куйбышевское, Новосибирская область
    _2_28_7='2:28:7' # Ново-Троицкое, Уфимское, Республика Башкортостан
    _3_5_6_8='35:6:8' # Центральное, Верховажское, Вологодская область
    _2_28_6='2:28:6' # Кушнаренковское, Уфимское, Республика Башкортостан
    _2_28_5='2:28:5' # Красноярское, Уфимское, Республика Башкортостан
    _2_28_4='2:28:4' # Дмитриевское, Уфимское, Республика Башкортостан
    _3_5_6_5='35:6:5' # Морозовское, Верховажское, Вологодская область
    _3_5_6_4='35:6:4' # Липецкое, Верховажское, Вологодская область
    _3_5_6_7='35:6:7' # Урусовское, Верховажское, Вологодская область
    _2_28_9='2:28:9' # Орловское, Уфимское, Республика Башкортостан
    _3_5_6_6='35:6:6' # Оринодорское, Верховажское, Вологодская область
    _2_28_8='2:28:8' # Нурлинское, Уфимское, Республика Башкортостан
    _3_5_6_1='35:6:1' # Верховажское, Верховажское, Вологодская область
    _3_5_6_3='35:6:3' # Кулойское, Верховажское, Вологодская область
    _3_5_6_2='35:6:2' # Верховское, Верховажское, Вологодская область
    _2_28_3='2:28:3' # Демское, Уфимское, Республика Башкортостан
    _2_28_2='2:28:2' # Благовещенское, Уфимское, Республика Башкортостан
    _2_28_1='2:28:1' # Благоварское, Уфимское, Республика Башкортостан
    _2_9_5_1='29:5:1' # Вилегодское, Вилегодское, Архангельская область
    _2_9_5_2='29:5:2' # Ильинское, Вилегодское, Архангельская область
    _2_9_5_3='29:5:3' # Нижне-Лупьинское, Вилегодское, Архангельская область
    _2_9_5_4='29:5:4' # Павловское, Вилегодское, Архангельская область
    _2_9_5_5='29:5:5' # Селянское, Вилегодское, Архангельская область
    _6_6_13_11='66:13:11' # Усть-Машское, Красноуфимское, Свердловская область
    _6_6_13_10='66:13:10' # Саргаинское, Красноуфимское, Свердловская область
    _7_3_19_2='73:19:2' # Красноярское, Ульяновское, Ульяновская область
    _7_3_19_3='73:19:3' # Охотническое, Ульяновское, Ульяновская область
    _7_3_19_1='73:19:1' # Ключищенское, Ульяновское, Ульяновская область
    _2_4_21_3='24:21:3' # Казачинское, Казачинское, Красноярский край
    _2_4_21_4='24:21:4' # Кемское, Казачинское, Красноярский край
    _2_4_21_5='24:21:5' # Кемское сельское, Казачинское, Красноярский край
    _2_4_21_6='24:21:6' # Язаевское, Казачинское, Красноярский край
    _2_4_21_1='24:21:1' # Галанинское, Казачинское, Красноярский край
    _2_4_21_2='24:21:2' # Дементьевское, Казачинское, Красноярский край
    _5_4_25_3='54:25:3' # Черепановский лесохозяйственный участок № 2, Черепановское, Новосибирская область
    _5_4_25_2='54:25:2' # Черепановский лесохозяйственный участок № 1, Черепановское, Новосибирская область
    _5_4_25_1='54:25:1' # Бурановский лесохозяйственный участок, Черепановское, Новосибирская область
    _4_7_4_9='47:4:9' # Меднозаводское, Всеволожское, Ленинградская область
    _4_7_4_7='47:4:7' # Кавголовское, Всеволожское, Ленинградская область
    _4_7_4_8='47:4:8' # Лемболовское, Всеволожское, Ленинградская область
    _4_7_4_5='47:4:5' # Всеволожское сельское, Всеволожское, Ленинградская область
    _4_7_4_6='47:4:6' # Гарболовское, Всеволожское, Ленинградская область
    _4_7_4_3='47:4:3' # Верхолинское, Всеволожское, Ленинградская область
    _4_7_4_4='47:4:4' # Всеволожское, Всеволожское, Ленинградская область
    _4_7_4_1='47:4:1' # Агалатовское, Всеволожское, Ленинградская область
    _1_2_5_1='12:5:1' # Таирское, Кокшайское, Республика Марий Эл
    _4_7_4_2='47:4:2' # Вагановское, Всеволожское, Ленинградская область
    _1_2_5_3='12:5:3' # Черноозерское, Кокшайское, Республика Марий Эл
    _1_2_5_2='12:5:2' # Уржумское, Кокшайское, Республика Марий Эл
    _1_2_5_4='12:5:4' # Шуйское, Кокшайское, Республика Марий Эл
    _7_5_4_1='75:4:1' # Калганское, Аргунское, Забайкальский край
    _7_5_4_2='75:4:2' # Нерчинско-Заводское, Аргунское, Забайкальский край
    _7_5_4_3='75:4:3' # Уровское, Аргунское, Забайкальский край
    _3_5_3_10='35:3:10' # Палкинское, Белозерское, Вологодская область
    _3_5_3_11='35:3:11' # Шольское, Белозерское, Вологодская область
    _2_4_34_5='24:34:5' # Минусинское сельское, Минусинское, Красноярский край
    _2_4_34_1='24:34:1' # Знаменское, Минусинское, Красноярский край
    _2_4_34_2='24:34:2' # Инское, Минусинское, Красноярский край
    _2_4_34_3='24:34:3' # Луговское, Минусинское, Красноярский край
    _2_4_34_4='24:34:4' # Минусинское, Минусинское, Красноярский край
    _6_7_12_3='67:12:3' # Любавичское, Краснинское, Смоленская область
    _6_7_12_2='67:12:2' # Краснинское, Краснинское, Смоленская область
    _6_7_12_1='67:12:1' # Гусинское, Краснинское, Смоленская область
    _6_7_12_5='67:12:5' # Перховское, Краснинское, Смоленская область
    _6_7_12_4='67:12:4' # Малеевское, Краснинское, Смоленская область
    _7_0_1_2='70:1:2' # Стрежевское, Александровское, Томская область
    _7_0_1_1='70:1:1' # Александровское, Александровское, Томская область
    _4_2_1_6='42:1:6' # Чигирское, Беловское, Кемеровская область
    _4_2_1_5='42:1:5' # Чекмаревское, Беловское, Кемеровская область
    _4_2_1_4='42:1:4' # Менчерепское, Беловское, Кемеровская область
    _4_2_1_3='42:1:3' # Каралдинское, Беловское, Кемеровская область
    _4_2_1_2='42:1:2' # Евтинское, Беловское, Кемеровская область
    _4_2_1_1='42:1:1' # Бачатское, Беловское, Кемеровская область
    _2_4_47_4='24:47:4' # Мало-Кетское, Таежинское, Красноярский край
    _2_4_47_3='24:47:3' # Кытатское, Таежинское, Красноярский край
    _2_4_47_6='24:47:6' # Новобирилюсское, Таежинское, Красноярский край
    _2_4_47_5='24:47:5' # Мелецкое, Таежинское, Красноярский край
    _6_4_16_1='64:16:1' # Марксовское, Марксовское, Саратовская область
    _6_4_16_2='64:16:2' # Подлесновское, Марксовское, Саратовская область
    _2_4_47_2='24:47:2' # Бирилюсское сельское, Таежинское, Красноярский край
    _2_4_47_1='24:47:1' # Бирилюсское, Таежинское, Красноярский край
    _6_9_8_10='69:8:10' # Южное, Торжокское, Тверская область
    _6_9_8_11='69:8:11' # Яконовское, Торжокское, Тверская область
    _1_9_11_4='19:11:4' # Таштыпское, Таштыпское, Республика Хакасия
    _1_9_11_1='19:11:1' # Верхне-Сейское, Таштыпское, Республика Хакасия
    _1_9_11_3='19:11:3' # Матурское, Таштыпское, Республика Хакасия
    _1_9_11_2='19:11:2' # Верхне-Таштыпское, Таштыпское, Республика Хакасия
    _5_10_1='5:10:1' # Атай-Батхановское, Кизлярское, Республика Дагестан
    _5_10_3='5:10:3' # Кизлярское, Кизлярское, Республика Дагестан
    _5_10_2='5:10:2' # Бабаюртовское, Кизлярское, Республика Дагестан
    _5_10_4='5:10:4' # Новромановское, Кизлярское, Республика Дагестан
    _8_6_9_4='86:9:4' # Октябрьское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _8_6_9_3='86:9:3' # Обское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _8_6_9_2='86:9:2' # Няганское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _8_6_9_1='86:9:1' # Ендырское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _8_6_9_6='86:9:6' # Ун-Юганское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _8_6_9_5='86:9:5' # Перегребинское, Октябрьское, Ханты-Мансийский автономный округ - Югра
    _4_1_5_1='41:5:1' # Карагинское, Корякское, Камчатский край
    _2_4_52_2='24:52:2' # Туруханское, Туруханское, Красноярский край
    _2_4_52_1='24:52:1' # Верхне-Имбатское, Туруханское, Красноярский край
    _4_1_5_3='41:5:3' # Паланское, Корякское, Камчатский край
    _4_1_5_2='41:5:2' # Олюторское, Корякское, Камчатский край
    _4_1_5_5='41:5:5' # Тигильское, Корякское, Камчатский край
    _4_1_5_4='41:5:4' # Пенжинское, Корякское, Камчатский край
    _4_1_5_6='41:5:6' # Усть-Хайрюзовское, Корякское, Камчатский край
    _4_7_12_1='47:12:1' # Андриановское, Любанское, Ленинградская область
    _4_7_12_8='47:12:8' # Любанское, Любанское, Ленинградская область
    _4_7_12_9='47:12:9' # Осничевское, Любанское, Ленинградская область
    _4_7_12_6='47:12:6' # Каменское, Любанское, Ленинградская область
    _4_7_12_7='47:12:7' # Красноборское, Любанское, Ленинградская область
    _4_7_12_4='47:12:4' # Добросельское, Любанское, Ленинградская область
    _4_7_12_5='47:12:5' # Дубовицкое, Любанское, Ленинградская область
    _4_7_12_2='47:12:2' # Апраксинское, Любанское, Ленинградская область
    _4_7_12_3='47:12:3' # Броницкое, Любанское, Ленинградская область
    _7_6_13_1='76:13:1' # Тутаевское, ГКУ ЯО "Тутаевское лесничество", Ярославская область
    _7_6_13_2='76:13:2' # Чебоковское, ГКУ ЯО "Тутаевское лесничество", Ярославская область
    _5_0_4_14='50:4:14' # Теряевское, Волоколамское, Московская область
    _5_0_4_15='50:4:15' # Шаховское, Волоколамское, Московская область
    _5_0_4_16='50:4:16' # Ядровское, Волоколамское, Московская область
    _5_0_4_10='50:4:10' # Пригородное, Волоколамское, Московская область
    _5_0_4_11='50:4:11' # Серединское, Волоколамское, Московская область
    _5_0_4_12='50:4:12' # Спасское, Волоколамское, Московская область
    _5_0_4_13='50:4:13' # Судниковское, Волоколамское, Московская область
    _6_5_2_2='65:2:2' # Таранайское, Анивское, Сахалинская область
    _6_5_2_1='65:2:1' # Анивское, Анивское, Сахалинская область
    _3_8_16_1='38:16:1' # Ангинское, Качугское, Иркутская область
    _3_8_16_2='38:16:2' # Верхоленское, Качугское, Иркутская область
    _2_5_4_14='25:4:14' # Пожигинское, Дальнереченское, Приморский край
    _1_6_9_1='16:9:1' # Никольское, Болгарское, Республика Татарстан (Татарстан)
    _1_6_9_2='16:9:2' # Спасское, Болгарское, Республика Татарстан (Татарстан)
    _5_3_18_10='53:18:10' # Уторгошское, Шимское, Новгородская область
    _5_3_18_11='53:18:11' # Шелонское, Шимское, Новгородская область
    _5_8_6_2='58:6:2' # Кузнецкое-Комаровское, Кузнецкое, Пензенская область
    _5_8_6_1='58:6:1' # Двориковское, Кузнецкое, Пензенская область
    _5_8_6_4='58:6:4' # Радищевское, Кузнецкое, Пензенская область
    _5_8_6_3='58:6:3' # Неверкинское, Кузнецкое, Пензенская область
    _5_3_18_12='53:18:12' # Шимское, Шимское, Новгородская область
    _5_8_6_5='58:6:5' # Чибирлейское, Кузнецкое, Пензенская область
    _6_7_17_2='67:17:2' # Красновское, Руднянское, Смоленская область
    _6_7_17_1='67:17:1' # Голынковское, Руднянское, Смоленская область
    _2_3_5_2='23:5:2' # Кабардинское, Геленджикское, Краснодарский край
    _4_4_3_10='44:3:10' # Чабрское, Вохомское, Костромская область
    _2_3_5_3='23:5:3' # Ново-Садовское, Геленджикское, Краснодарский край
    _6_7_17_5='67:17:5' # Руднянское сельское, Руднянское, Смоленская область
    _2_3_5_4='23:5:4' # Пшадское, Геленджикское, Краснодарский край
    _6_7_17_4='67:17:4' # Руднянское, Руднянское, Смоленская область
    _6_7_17_3='67:17:3' # Понизовское, Руднянское, Смоленская область
    _2_3_5_1='23:5:1' # Архипо-Осиповское, Геленджикское, Краснодарский край
    _3_4_9_4='34:9:4' # Таловское, Камышинское, Волгоградская область
    _3_4_9_3='34:9:3' # Камышинское сельское, Камышинское, Волгоградская область
    _3_4_9_2='34:9:2' # Добринское, Камышинское, Волгоградская область
    _3_4_9_1='34:9:1' # Верхне-Липовское, Камышинское, Волгоградская область
    _8_6_11_9='86:11:9' # Эсское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_8='86:11:8' # Торское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_7='86:11:7' # Таёжное, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_6='86:11:6' # Самзасское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_1='86:11:1' # Арантурское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_5='86:11:5' # Пионерское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_4='86:11:4' # Мулымское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_3='86:11:3' # Картопское, Советское, Ханты-Мансийский автономный округ - Югра
    _8_6_11_2='86:11:2' # Зеленоборское, Советское, Ханты-Мансийский автономный округ - Югра
    _6_4_8_3='64:8:3' # Мизино-Лапшиновское, Вязовское, Саратовская область
    _6_4_8_2='64:8:2' # Кологривовское, Вязовское, Саратовская область
    _6_4_8_4='64:8:4' # Ягодно-Полянское, Вязовское, Саратовская область
    _6_4_8_1='64:8:1' # Вязовское, Вязовское, Саратовская область
    _7_3_14_5='73:14:5' # Тушнинское, Сенгилеевское, Ульяновская область
    _7_3_14_3='73:14:3' # Сенгилеевское, Сенгилеевское, Ульяновская область
    _7_3_14_4='73:14:4' # Смородинское, Сенгилеевское, Ульяновская область
    _7_3_14_1='73:14:1' # Белоярское, Сенгилеевское, Ульяновская область
    _7_3_14_2='73:14:2' # Елаурское, Сенгилеевское, Ульяновская область
    _3_5_22_11='35:22:11' # Яковлевское, Устюженское, Вологодская область
    _3_5_22_10='35:22:10' # Южное, Устюженское, Вологодская область
    _1_7_3_5='17:3:5' # Сизимское, Каа-Хемское, Республика Тыва
    _1_7_3_4='17:3:4' # Сарыг-Сепское, Каа-Хемское, Республика Тыва
    _1_7_3_3='17:3:3' # Кунгуртукское, Каа-Хемское, Республика Тыва
    _1_7_3_2='17:3:2' # Бурен-Хемское, Каа-Хемское, Республика Тыва
    _1_7_3_1='17:3:1' # Бурен-Бай-Хаакское, Каа-Хемское, Республика Тыва
    _5_0_11_6='50:11:6' # Свердловское, Московское учебно-опытное, Московская область
    _5_0_11_5='50:11:5' # Огудневское, Московское учебно-опытное, Московская область
    _5_0_11_4='50:11:4' # Красноармейское, Московское учебно-опытное, Московская область
    _5_0_11_3='50:11:3' # Гребневское, Московское учебно-опытное, Московская область
    _5_0_11_9='50:11:9' # Фряновское, Московское учебно-опытное, Московская область
    _5_0_11_8='50:11:8' # Учебно-опытное, Московское учебно-опытное, Московская область
    _5_0_11_7='50:11:7' # Тютчевское, Московское учебно-опытное, Московская область
    _6_4_19_2='64:19:2' # Перелюбское, Пугачевское, Саратовская область
    _6_4_19_3='64:19:3' # Пугачевское, Пугачевское, Саратовская область
    _6_4_19_4='64:19:4' # Старо-Порубежское, Пугачевское, Саратовская область
    _6_4_19_5='64:19:5' # Чапаевское, Пугачевское, Саратовская область
    _5_0_11_2='50:11:2' # Воря-Богородское, Московское учебно-опытное, Московская область
    _5_0_11_1='50:11:1' # Алешинское, Московское учебно-опытное, Московская область
    _6_4_19_1='64:19:1' # Бартеневское, Пугачевское, Саратовская область
    _6_4_19_6='64:19:6' # Яблонево-Гайское, Пугачевское, Саратовская область
    _7_0_2_3='70:2:3' # Мало-Юксинское, Асиновское, Томская область
    _7_0_2_4='70:2:4' # Митрофановское, Асиновское, Томская область
    _7_0_2_1='70:2:1' # Асиновское, Асиновское, Томская область
    _7_0_2_2='70:2:2' # Батуринское, Асиновское, Томская область
    _3_5_17_3='35:17:3' # Двиницкое, Сокольское, Вологодская область
    _3_5_17_2='35:17:2' # Воробьёвское, Сокольское, Вологодская область
    _3_5_17_1='35:17:1' # Алексинское, Сокольское, Вологодская область
    _4_7_1_8='47:1:8' # Деревское, Бокситогорское, Ленинградская область
    _4_7_1_9='47:1:9' # Ефимовское, Бокситогорское, Ленинградская область
    _4_7_1_6='47:1:6' # Вожанское, Бокситогорское, Ленинградская область
    _4_7_1_7='47:1:7' # Горское, Бокситогорское, Ленинградская область
    _4_7_1_4='47:1:4' # Боровское, Бокситогорское, Ленинградская область
    _4_7_1_5='47:1:5' # Борское, Бокситогорское, Ленинградская область
    _3_5_17_8='35:17:8' # Чучковское, Сокольское, Вологодская область
    _4_7_1_2='47:1:2' # Бокситогорское, Бокситогорское, Ленинградская область
    _3_5_17_7='35:17:7' # Сокольское, Сокольское, Вологодская область
    _4_7_1_3='47:1:3' # Большедворское, Бокситогорское, Ленинградская область
    _3_5_17_6='35:17:6' # Пельшемское, Сокольское, Вологодская область
    _3_5_17_5='35:17:5' # Кадниковское, Сокольское, Вологодская область
    _4_7_1_1='47:1:1' # Анисимовское, Бокситогорское, Ленинградская область
    _3_5_17_4='35:17:4' # Заболотское, Сокольское, Вологодская область
    _3_4_20_1='34:20:1' # Ленинское, Среднеахтубинское, Волгоградская область
    _3_4_20_2='34:20:2' # Сахарное, Среднеахтубинское, Волгоградская область
    _3_4_20_3='34:20:3' # Среднеахтубинское, Среднеахтубинское, Волгоградская область
    _5_0_11_10='50:11:10' # Щелковское сельское, Московское учебно-опытное, Московская область
    _2_8_8_1='28:8:1' # Лебединское, Мазановское, Амурская область
    _2_8_8_4='28:8:4' # Маргаритовское, Мазановское, Амурская область
    _2_8_8_5='28:8:5' # Новороссийское, Мазановское, Амурская область
    _2_8_8_2='28:8:2' # Мазановское, Мазановское, Амурская область
    _2_8_8_3='28:8:3' # Майское, Мазановское, Амурская область
    _2_5_10_4='25:10:4' # Комиссаровское, Уссурийское, Приморский край
    _2_5_10_5='25:10:5' # Корсаковское, Уссурийское, Приморский край
    _2_5_10_6='25:10:6' # Михайловское сельское, Уссурийское, Приморский край
    _2_5_10_7='25:10:7' # Николаевское, Уссурийское, Приморский край
    _2_5_10_8='25:10:8' # Николо-Львовское, Уссурийское, Приморский край
    _2_5_10_9='25:10:9' # Пограничное, Уссурийское, Приморский край
    _5_3_4_4='53:4:4' # Крестецкое, Крестецкое, Новгородская область
    _5_3_4_5='53:4:5' # Локотское, Крестецкое, Новгородская область
    _5_3_4_2='53:4:2' # Жаровское, Крестецкое, Новгородская область
    _5_3_4_3='53:4:3' # Зайцевское, Крестецкое, Новгородская область
    _5_3_4_8='53:4:8' # Ручьевское, Крестецкое, Новгородская область
    _5_3_4_9='53:4:9' # Усть-Волмское, Крестецкое, Новгородская область
    _5_3_4_6='53:4:6' # Ново-Рахинское, Крестецкое, Новгородская область
    _5_3_4_7='53:4:7' # Островское, Крестецкое, Новгородская область
    _5_3_4_1='53:4:1' # Винское, Крестецкое, Новгородская область
    _2_5_10_1='25:10:1' # Баневуровское, Уссурийское, Приморский край
    _2_5_10_2='25:10:2' # Ильинское, Уссурийское, Приморский край
    _2_5_10_3='25:10:3' # Кленовское, Уссурийское, Приморский край
    _1_2_14_2='12:14:2' # Краснооктябрьское, Пригородное, Республика Марий Эл
    _7_0_15_4='70:15:4' # Первомайское, Первомайское, Томская область
    _1_2_14_3='12:14:3' # Люльпанское, Пригородное, Республика Марий Эл
    _7_0_15_3='70:15:3' # Ореховское, Первомайское, Томская область
    _1_2_14_4='12:14:4' # Старожильское, Пригородное, Республика Марий Эл
    _7_0_15_2='70:15:2' # Куяновское, Первомайское, Томская область
    _7_0_15_1='70:15:1' # Комсомольское, Первомайское, Томская область
    _1_2_14_1='12:14:1' # Азяковское, Пригородное, Республика Марий Эл
    _4_5_2='4:5:2' # Улаганское, Улаганское, Республика Алтай
    _4_5_1='4:5:1' # Акташское, Улаганское, Республика Алтай
    _3_5_2_12='35:2:12' # Юзское, Бабушкинское, Вологодская область
    _3_5_2_11='35:2:11' # Шоноровское, Бабушкинское, Вологодская область
    _2_5_4_12='25:4:12' # Междуреченское, Дальнереченское, Приморский край
    _2_5_4_13='25:4:13' # Пантелеймоновское, Дальнереченское, Приморский край
    _2_5_4_10='25:4:10' # Мартыново-Полянское, Дальнереченское, Приморский край
    _2_5_4_11='25:4:11' # Марьяновское, Дальнереченское, Приморский край
    _4_4_13_6='44:13:6' # 2-е Островское, Островское, Костромская область
    _4_4_13_7='44:13:7' # Дымницкое, Островское, Костромская область
    _4_4_13_8='44:13:8' # Заборское, Островское, Костромская область
    _4_4_13_9='44:13:9' # Ломковское, Островское, Костромская область
    _4_4_13_1='44:13:1' # 1-е Адищевское, Островское, Костромская область
    _4_4_13_2='44:13:2' # 1-е Игодовское, Островское, Костромская область
    _4_4_13_3='44:13:3' # 1-е Островское, Островское, Костромская область
    _4_4_13_4='44:13:4' # 2-е Адищевское, Островское, Костромская область
    _4_4_13_5='44:13:5' # 2-е Игодовское, Островское, Костромская область
    _3_8_17_4='38:17:4' # Чайское, Киренское, Иркутская область
    _3_8_17_3='38:17:3' # Киренское, Киренское, Иркутская область
    _4_6_7_1='46:7:1' # Медвенское, Обоянское, Курская область
    _3_8_17_2='38:17:2' # Карелинское, Киренское, Иркутская область
    _4_6_7_2='46:7:2' # Обоянское, Обоянское, Курская область
    _3_8_17_1='38:17:1' # Ичерское, Киренское, Иркутская область
    _4_6_7_3='46:7:3' # Рыбино-Будское, Обоянское, Курская область
    _7_5_5_1='75:5:1' # Бадинское, Бадинское, Забайкальский край
    _7_5_5_2='75:5:2' # Жипхегенское, Бадинское, Забайкальский край
    _2_25_9='2:25:9' # Толбазинское, Стерлитамакское, Республика Башкортостан
    _2_25_8='2:25:8' # Стерлитамакское, Стерлитамакское, Республика Башкортостан
    _2_25_7='2:25:7' # Стерлибашевское, Стерлитамакское, Республика Башкортостан
    _3_5_3_8='35:3:8' # Мартыновское, Белозерское, Вологодская область
    _3_5_3_7='35:3:7' # Конец-Слободское, Белозерское, Вологодская область
    _3_5_3_9='35:3:9' # Мегринское, Белозерское, Вологодская область
    _3_5_3_4='35:3:4' # Визьменское, Белозерское, Вологодская область
    _2_25_2='2:25:2' # Воскресенское, Стерлитамакское, Республика Башкортостан
    _3_5_3_3='35:3:3' # Белозерское сельское, Белозерское, Вологодская область
    _2_25_1='2:25:1' # Белогорское, Стерлитамакское, Республика Башкортостан
    _3_5_3_6='35:3:6' # Зубовское, Белозерское, Вологодская область
    _3_5_3_5='35:3:5' # Георгиевское, Белозерское, Вологодская область
    _2_25_6='2:25:6' # Салаватское, Стерлитамакское, Республика Башкортостан
    _2_25_5='2:25:5' # Мелеузовское, Стерлитамакское, Республика Башкортостан
    _3_5_3_2='35:3:2' # Белозерское, Белозерское, Вологодская область
    _2_25_4='2:25:4' # Куюргазинское, Стерлитамакское, Республика Башкортостан
    _3_5_3_1='35:3:1' # Артюшинское, Белозерское, Вологодская область
    _2_25_3='2:25:3' # Куганакское, Стерлитамакское, Республика Башкортостан
    _2_9_2_1='29:2:1' # Березниковское, Березниковское, Архангельская область
    _2_9_2_2='29:2:2' # Ваеньгское, Березниковское, Архангельская область
    _2_9_2_3='29:2:3' # Верхневаеньгское, Березниковское, Архангельская область
    _2_9_2_4='29:2:4' # Виноградовское, Березниковское, Архангельская область
    _2_9_2_5='29:2:5' # Нижнедвинское, Березниковское, Архангельская область
    _2_9_2_6='29:2:6' # Рочегодское, Березниковское, Архангельская область
    _2_9_2_7='29:2:7' # Тулгасское, Березниковское, Архангельская область
    _3_5_2_10='35:2:10' # Харинское, Бабушкинское, Вологодская область
    _1_1_6_1='11:6:1' # Березовское, Каджеромское, Республика Коми
    _2_12_3='2:12:3' # Ташлинское, Гафурийское, Республика Башкортостан
    _2_12_4='2:12:4' # Усольское, Гафурийское, Республика Башкортостан
    _2_12_1='2:12:1' # Зилимское, Гафурийское, Республика Башкортостан
    _2_12_2='2:12:2' # Табынское, Гафурийское, Республика Башкортостан
    _1_1_6_5='11:6:5' # Чикшинское, Каджеромское, Республика Коми
    _1_1_6_4='11:6:4' # Таловское, Каджеромское, Республика Коми
    _1_1_6_3='11:6:3' # Каджеромское, Каджеромское, Республика Коми
    _1_1_6_2='11:6:2' # Зеленоборское, Каджеромское, Республика Коми
    _4_7_11_1='47:11:1' # Бережковское, Лужское, Ленинградская область
    _4_7_11_2='47:11:2' # Долговское, Лужское, Ленинградская область
    _4_7_11_9='47:11:9' # Николаевское, Лужское, Ленинградская область
    _2_4_40_3='24:40:3' # Пировское, Пировское, Красноярский край
    _2_4_40_2='24:40:2' # Большекетское, Пировское, Красноярский край
    _4_7_11_7='47:11:7' # Мшинское, Лужское, Ленинградская область
    _4_7_11_8='47:11:8' # Низовское, Лужское, Ленинградская область
    _2_4_40_4='24:40:4' # Пировское сельское, Пировское, Красноярский край
    _4_7_11_5='47:11:5' # Луговское, Лужское, Ленинградская область
    _4_7_11_6='47:11:6' # Лужское, Лужское, Ленинградская область
    _4_7_11_3='47:11:3' # Жельцевское, Лужское, Ленинградская область
    _2_4_40_1='24:40:1' # Алгайское, Пировское, Красноярский край
    _4_7_11_4='47:11:4' # Красногорское, Лужское, Ленинградская область
    _5_22_2='5:22:2' # Междуреченское, Цунтинское, Республика Дагестан
    _5_22_1='5:22:1' # Бежтинское, Цунтинское, Республика Дагестан
    _5_22_4='5:22:4' # Шауринское, Цунтинское, Республика Дагестан
    _5_22_3='5:22:3' # Тлядальское, Цунтинское, Республика Дагестан
    _1_6_8_2='16:8:2' # Баганинское, Билярское, Республика Татарстан (Татарстан)
    _1_6_8_1='16:8:1' # Алексеевское, Билярское, Республика Татарстан (Татарстан)
    _1_6_8_4='16:8:4' # Большеполянское, Билярское, Республика Татарстан (Татарстан)
    _1_6_8_3='16:8:3' # Билярское, Билярское, Республика Татарстан (Татарстан)
    _1_6_8_5='16:8:5' # Кзыл-Юлское, Билярское, Республика Татарстан (Татарстан)
    _7_6_12_2='76:12:2' # Борзовское, ГКУ ЯО "Рыбинское лесничество", Ярославская область
    _7_6_12_3='76:12:3' # Ломовское, ГКУ ЯО "Рыбинское лесничество", Ярославская область
    _7_6_12_4='76:12:4' # Приволжское, ГКУ ЯО "Рыбинское лесничество", Ярославская область
    _7_6_12_5='76:12:5' # Пригородное, ГКУ ЯО "Рыбинское лесничество", Ярославская область
    _7_6_12_1='76:12:1' # Арефинское, ГКУ ЯО "Рыбинское лесничество", Ярославская область
    _2_4_53_5='24:53:5' # Чульское, Тюхтетское, Красноярский край
    _2_4_53_4='24:53:4' # Чиндатское, Тюхтетское, Красноярский край
    _2_4_53_1='24:53:1' # Кандатское, Тюхтетское, Красноярский край
    _2_4_53_3='24:53:3' # Тюхтетское сельское, Тюхтетское, Красноярский край
    _2_4_53_2='24:53:2' # Тюхтетское, Тюхтетское, Красноярский край
    _6_9_11_13='69:11:13' # Медведевское, Фировское, Тверская область
    _6_9_11_12='69:11:12' # Лыкошинское, Фировское, Тверская область
    _6_9_11_15='69:11:15' # Пеньское, Фировское, Тверская область
    _6_9_11_14='69:11:14' # Осеченское, Фировское, Тверская область
    _6_5_1_3='65:1:3' # Хоэнское, Александровское, Сахалинская область
    _6_5_1_2='65:1:2' # Александровское, Александровское, Сахалинская область
    _6_9_11_11='69:11:11' # Лужниковское, Фировское, Тверская область
    _6_5_1_1='65:1:1' # Агневское, Александровское, Сахалинская область
    _6_9_11_10='69:11:10' # Кувшиновское, Фировское, Тверская область
    _6_9_11_17='69:11:17' # Рученское, Фировское, Тверская область
    _5_4_19_9='54:19:9' # Спиринский лесохозяйственный участок, Ордынское, Новосибирская область
    _6_9_11_16='69:11:16' # Ранцевское, Фировское, Тверская область
    _6_9_11_19='69:11:19' # Фировское, Фировское, Тверская область
    _5_4_19_7='54:19:7' # Ордынский лесохозяйственный участок № 2, Ордынское, Новосибирская область
    _6_9_11_18='69:11:18' # Тысяцкое, Фировское, Тверская область
    _5_4_19_8='54:19:8' # Петровский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_16_11='54:16:11' # Тогучинский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_10='54:16:10' # Рожневский лесохозяйственный участок, Мирновское, Новосибирская область
    _6_9_11_20='69:11:20' # Хотиловское, Фировское, Тверская область
    _3_8_15_1='38:15:1' # Катангское, Катангское, Иркутская область
    _6_9_11_22='69:11:22' # Шлинское, Фировское, Тверская область
    _6_9_11_21='69:11:21' # Цнинское, Фировское, Тверская область
    _5_4_19_5='54:19:5' # Нижне-Каменский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_19_6='54:19:6' # Ордынский лесохозяйственный участок № 1, Ордынское, Новосибирская область
    _5_4_19_3='54:19:3' # Караканский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_19_4='54:19:4' # Кирзинский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_19_1='54:19:1' # Алеусский лесохозяйственный участок, Ордынское, Новосибирская область
    _5_4_19_2='54:19:2' # Антоновский лесохозяйственный участок, Ордынское, Новосибирская область
    _4_1_6_2='41:6:2' # Мильковское, Мильковское, Камчатский край
    _4_1_6_1='41:6:1' # Долиновское, Мильковское, Камчатский край
    _4_1_6_3='41:6:3' # Шаромское, Мильковское, Камчатский край
    _6_7_18_1='67:18:1' # Алферовское, Сафоновское, Смоленская область
    _2_3_6_1='23:6:1' # Ключевское, Горячеключевское, Краснодарский край
    _6_7_18_5='67:18:5' # Издешковское, Сафоновское, Смоленская область
    _2_3_6_2='23:6:2' # Кутаисское, Горячеключевское, Краснодарский край
    _6_7_18_4='67:18:4' # Вадинское сельское, Сафоновское, Смоленская область
    _2_3_6_3='23:6:3' # Псекупское, Горячеключевское, Краснодарский край
    _6_7_18_3='67:18:3' # Вадинское, Сафоновское, Смоленская область
    _2_3_6_4='23:6:4' # Саратовское, Горячеключевское, Краснодарский край
    _6_7_18_2='67:18:2' # Батищевское, Сафоновское, Смоленская область
    _6_7_18_7='67:18:7' # Яковское, Сафоновское, Смоленская область
    _6_7_18_6='67:18:6' # Издешковское сельское, Сафоновское, Смоленская область
    _1_7_2_4='17:2:4' # Монгун-Тайгинское, Барун-Хемчикское, Республика Тыва
    _1_7_2_3='17:2:3' # Барун-Хемчикское, Барун-Хемчикское, Республика Тыва
    _1_7_2_2='17:2:2' # Бай-Тайгинское, Барун-Хемчикское, Республика Тыва
    _1_7_2_1='17:2:1' # Аянгатинское, Барун-Хемчикское, Республика Тыва
    _7_0_17_4='70:17:4' # Темерчинское, Тимирязевское, Томская область
    _7_0_17_3='70:17:3' # Моряковское, Тимирязевское, Томская область
    _3_0_1_2='30:1:2' # Красноярское, Восточнодельтовое, Астраханская область
    _5_3_2_4='53:2:4' # Небылицкое, Валдайское, Новгородская область
    _3_0_1_3='30:1:3' # Марфинское, Восточнодельтовое, Астраханская область
    _5_3_2_5='53:2:5' # Яжелбицкое, Валдайское, Новгородская область
    _3_0_1_1='30:1:1' # Зеленгинское, Восточнодельтовое, Астраханская область
    _5_3_2_2='53:2:2' # Едровское, Валдайское, Новгородская область
    _5_3_2_3='53:2:3' # Замошское, Валдайское, Новгородская область
    _5_3_2_1='53:2:1' # Валдайское, Валдайское, Новгородская область
    _6_6_31_8='66:31:8' # Шамарское, Шалинское, Свердловская область
    _6_6_31_7='66:31:7' # Шалинское, Шалинское, Свердловская область
    _6_6_31_6='66:31:6' # Урминское, Шалинское, Свердловская область
    _6_6_31_5='66:31:5' # Уньское, Шалинское, Свердловская область
    _6_6_31_4='66:31:4' # Староуткинское, Шалинское, Свердловская область
    _6_6_31_3='66:31:3' # Илимское, Шалинское, Свердловская область
    _6_6_31_2='66:31:2' # Восточное, Шалинское, Свердловская область
    _6_6_31_1='66:31:1' # Вогульское, Шалинское, Свердловская область
    _7_3_13_1='73:13:1' # Ореховское, Радищевское, Ульяновская область
    _5_8_5_1='58:5:1' # Камешкирское-Порзовское, Камешкирское, Пензенская область
    _5_8_5_2='58:5:2' # Шаткинское-Лесосадовое, Камешкирское, Пензенская область
    _7_0_17_2='70:17:2' # Калтайское, Тимирязевское, Томская область
    _7_0_17_1='70:17:1' # Богородское, Тимирязевское, Томская область
    _2_8_9_3='28:9:3' # Норское, Норское, Амурская область
    _2_8_9_4='28:9:4' # Огоджинское, Норское, Амурская область
    _2_8_9_1='28:9:1' # Златоустовское, Норское, Амурская область
    _7_3_13_2='73:13:2' # Радищевское, Радищевское, Ульяновская область
    _2_8_9_2='28:9:2' # Меунское, Норское, Амурская область
    _7_3_13_3='73:13:3' # Соловчихинское, Радищевское, Ульяновская область
    _3_5_16_4='35:16:4' # Востровское, Нюксенское, Вологодская область
    _3_5_16_3='35:16:3' # Восточное, Нюксенское, Вологодская область
    _3_5_16_2='35:16:2' # Брусенецкое, Нюксенское, Вологодская область
    _3_5_16_1='35:16:1' # Бобровское, Нюксенское, Вологодская область
    _3_5_16_9='35:16:9' # Нюксенское, Нюксенское, Вологодская область
    _3_5_16_8='35:16:8' # Илезское, Нюксенское, Вологодская область
    _3_5_16_7='35:16:7' # Дмитриевское, Нюксенское, Вологодская область
    _3_5_16_6='35:16:6' # Городищенское сельское, Нюксенское, Вологодская область
    _3_5_16_5='35:16:5' # Городищенское, Нюксенское, Вологодская область
    _2_2_19_2='22:19:2' # Озерское, Озерское, Алтайский край
    _2_2_19_3='22:19:3' # Первомайское, Озерское, Алтайский край
    _2_2_19_1='22:19:1' # Кислянское, Озерское, Алтайский край
    _2_2_19_6='22:19:6' # Язовское, Озерское, Алтайский край
    _2_2_19_4='22:19:4' # Повалихинское, Озерское, Алтайский край
    _2_2_19_5='22:19:5' # Речкуновское, Озерское, Алтайский край
    _8_6_12_7='86:12:7' # Ульт-Ягунское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_6='86:12:6' # Сытоминское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_5='86:12:5' # Сургутское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_4='86:12:4' # Русскинское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_3='86:12:3' # Пимское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_2='86:12:2' # Нижне-Сартымское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _8_6_12_1='86:12:1' # Когалымское, Сургутское, Ханты-Мансийский автономный округ - Югра
    _6_4_7_4='64:7:4' # Первомайское, Вольское, Саратовская область
    _6_4_7_3='64:7:3' # Октябрьское, Вольское, Саратовская область
    _6_4_7_2='64:7:2' # Куликовское, Вольское, Саратовская область
    _6_4_7_1='64:7:1' # Городское, Вольское, Саратовская область
    _7_0_3_2='70:3:2' # Парбигское, Бакчарское, Томская область
    _7_0_3_3='70:3:3' # Плотниковское, Бакчарское, Томская область
    _7_0_3_1='70:3:1' # Бакчарское, Бакчарское, Томская область
    _8_6_13_3='86:13:3' # Учинское, Урайское, Ханты-Мансийский автономный округ - Югра
    _8_6_13_2='86:13:2' # Урайское, Урайское, Ханты-Мансийский автономный округ - Югра
    _8_6_13_1='86:13:1' # Верхне-Кондинское, Урайское, Ханты-Мансийский автономный округ - Югра
    _4_7_4_14='47:4:14' # Ройкинское, Всеволожское, Ленинградская область
    _2_1_10_5='21:10:5' # Торханское, Шумерлинское, Чувашская Республика - Чувашия
    _4_7_4_15='47:4:15' # Чернореченское, Всеволожское, Ленинградская область
    _2_1_10_4='21:10:4' # Саланчикское, Шумерлинское, Чувашская Республика - Чувашия
    _2_1_10_6='21:10:6' # Шумерлинское, Шумерлинское, Чувашская Республика - Чувашия
    _2_1_10_1='21:10:1' # Алгашинское, Шумерлинское, Чувашская Республика - Чувашия
    _2_1_10_3='21:10:3' # Порецкое, Шумерлинское, Чувашская Республика - Чувашия
    _2_1_10_2='21:10:2' # Дубовское, Шумерлинское, Чувашская Республика - Чувашия
    _5_0_12_5='50:12:5' # Вышегородское, Наро-Фоминское, Московская область
    _5_0_12_4='50:12:4' # Веселевское, Наро-Фоминское, Московская область
    _5_0_12_3='50:12:3' # Верейское, Наро-Фоминское, Московская область
    _5_0_12_2='50:12:2' # Башкинское, Наро-Фоминское, Московская область
    _5_0_12_9='50:12:9' # Назарьевское, Наро-Фоминское, Московская область
    _5_0_12_8='50:12:8' # Литвиновское, Наро-Фоминское, Московская область
    _5_0_12_7='50:12:7' # Каменское, Наро-Фоминское, Московская область
    _5_0_12_6='50:12:6' # Дороховское, Наро-Фоминское, Московская область
    _5_0_12_1='50:12:1' # Алабинское, Наро-Фоминское, Московская область
    _6_4_18_1='64:18:1' # Ножкинское, Петровское, Саратовская область
    _6_4_18_2='64:18:2' # Сосновоборское, Петровское, Саратовская область
    _4_7_4_10='47:4:10' # Морозовское, Всеволожское, Ленинградская область
    _4_7_4_11='47:4:11' # Невское, Всеволожское, Ленинградская область
    _4_7_4_12='47:4:12' # Ореховское, Всеволожское, Ленинградская область
    _4_7_4_13='47:4:13' # Осинорощинское, Всеволожское, Ленинградская область
    _2_26_1='2:26:1' # Аршинское, Тирлянское, Республика Башкортостан
    _2_26_3='2:26:3' # Тирлянское, Тирлянское, Республика Башкортостан
    _2_26_2='2:26:2' # Верхне-Бельское, Тирлянское, Республика Башкортостан
    _2_9_3_1='29:3:1' # Благовещенское, Вельское, Архангельская область
    _2_9_3_2='29:3:2' # Важское, Вельское, Архангельская область
    _2_9_3_3='29:3:3' # Вельское, Вельское, Архангельская область
    _2_9_3_4='29:3:4' # Вельское сельское, Вельское, Архангельская область
    _2_9_3_5='29:3:5' # Кулойское, Вельское, Архангельская область
    _2_9_3_6='29:3:6' # Низовское, Вельское, Архангельская область
    _2_9_3_7='29:3:7' # Пуйское, Вельское, Архангельская область
    _2_9_3_8='29:3:8' # Солгинское, Вельское, Архангельская область
    _2_9_3_9='29:3:9' # Судромское, Вельское, Архангельская область
    _1_9_13_3='19:13:3' # Майское, Усть-Бюрское, Республика Хакасия
    _1_9_13_2='19:13:2' # Кискачинское, Усть-Бюрское, Республика Хакасия
    _1_9_13_5='19:13:5' # Усть-Бюрское, Усть-Бюрское, Республика Хакасия
    _1_9_13_4='19:13:4' # Усть-Абаканское, Усть-Бюрское, Республика Хакасия
    _1_9_13_1='19:13:1' # Инейское, Усть-Бюрское, Республика Хакасия
    _2_8_9_7='28:9:7' # Экимчанское, Норское, Амурская область
    _2_5_11_3='25:11:3' # Бреевское, Чугуевское, Приморский край
    _2_8_9_8='28:9:8' # Янсайское, Норское, Амурская область
    _2_5_11_4='25:11:4' # Журавлевское, Чугуевское, Приморский край
    _2_8_9_5='28:9:5' # Стойбинское, Норское, Амурская область
    _2_5_11_5='25:11:5' # Заветнинское, Чугуевское, Приморский край
    _2_8_9_6='28:9:6' # Февральское, Норское, Амурская область
    _2_5_11_6='25:11:6' # Зареченское, Чугуевское, Приморский край
    _2_5_11_7='25:11:7' # Каменское, Чугуевское, Приморский край
    _2_5_11_8='25:11:8' # Кокшаровское, Чугуевское, Приморский край
    _2_5_11_9='25:11:9' # Ленинское, Чугуевское, Приморский край
    _7_0_16_5='70:16:5' # Четское, Тегульдетское, Томская область
    _7_0_16_4='70:16:4' # Черноярское, Тегульдетское, Томская область
    _5_3_3_5='53:3:5' # Лычковское, Демянское, Новгородская область
    _5_3_3_6='53:3:6' # Полновское, Демянское, Новгородская область
    _5_3_3_3='53:3:3' # Ильиногорское, Демянское, Новгородская область
    _5_3_3_4='53:3:4' # Кневицкое, Демянское, Новгородская область
    _5_3_3_9='53:3:9' # Черноручейское, Демянское, Новгородская область
    _5_3_3_7='53:3:7' # Сельское, Демянское, Новгородская область
    _5_3_3_8='53:3:8' # Филиппогорское, Демянское, Новгородская область
    _5_3_3_1='53:3:1' # Великозаходское, Демянское, Новгородская область
    _5_3_3_2='53:3:2' # Демянское, Демянское, Новгородская область
    _2_5_11_1='25:11:1' # Архиповское, Чугуевское, Приморский край
    _2_5_11_2='25:11:2' # Березовское, Чугуевское, Приморский край
    _4_7_2_9='47:2:9' # Молосковицкое, Волосовское, Ленинградская область
    _4_7_2_7='47:2:7' # Каськовское, Волосовское, Ленинградская область
    _4_7_2_8='47:2:8' # Клопицкое, Волосовское, Ленинградская область
    _4_7_2_5='47:2:5' # Врудское, Волосовское, Ленинградская область
    _4_7_2_6='47:2:6' # Изварское, Волосовское, Ленинградская область
    _4_7_2_3='47:2:3' # Волновское, Волосовское, Ленинградская область
    _4_7_2_4='47:2:4' # Волосовское, Волосовское, Ленинградская область
    _4_7_2_1='47:2:1' # Бегуницкое, Волосовское, Ленинградская область
    _4_7_2_2='47:2:2' # Верестское, Волосовское, Ленинградская область
    _1_2_15_1='12:15:1' # Ардинское, Руткинское, Республика Марий Эл
    _7_0_16_3='70:16:3' # Тегульдетское, Тегульдетское, Томская область
    _1_2_15_2='12:15:2' # Козьмодемьянское, Руткинское, Республика Марий Эл
    _7_0_16_2='70:16:2' # Средне-Чулымское, Тегульдетское, Томская область
    _1_2_15_3='12:15:3' # Шарское, Руткинское, Республика Марий Эл
    _7_0_16_1='70:16:1' # Берегаевское, Тегульдетское, Томская область
    _3_8_29_4='38:29:4' # Шиткинское, Тайшетское, Иркутская область
    _3_8_29_5='38:29:5' # Юртинское, Тайшетское, Иркутская область
    _3_8_29_2='38:29:2' # Тагульское, Тайшетское, Иркутская область
    _3_8_29_3='38:29:3' # Тайшетское, Тайшетское, Иркутская область
    _3_8_29_1='38:29:1' # Верхнебирюсинское, Тайшетское, Иркутская область
    _6_9_6_15='69:6:15' # Сытьковское, Старицкое, Тверская область
    _6_9_6_14='69:6:14' # Степуринское, Старицкое, Тверская область
    _6_9_6_13='69:6:13' # Старицкое, Старицкое, Тверская область
    _6_9_6_12='69:6:12' # Сибирское, Старицкое, Тверская область
    _6_9_6_11='69:6:11' # Ржевское, Старицкое, Тверская область
    _6_9_6_10='69:6:10' # Погорельское, Старицкое, Тверская область
    _4_6_1='4:6:1' # Ануйское, Усть-Канское, Республика Алтай
    _3_5_4_6='35:4:6' # Унженское, Вашкинское, Вологодская область
    _3_5_4_3='35:4:3' # Вашкинское сельское, Вашкинское, Вологодская область
    _3_5_4_2='35:4:2' # Вашкинское, Вашкинское, Вологодская область
    _3_5_4_5='35:4:5' # Павшозерское, Вашкинское, Вологодская область
    _3_5_4_4='35:4:4' # Кемское, Вашкинское, Вологодская область
    _6_9_6_18='69:6:18' # Чертолинское, Старицкое, Тверская область
    _3_5_4_1='35:4:1' # Андреевское, Вашкинское, Вологодская область
    _4_6_3='4:6:3' # Ябоганское, Усть-Канское, Республика Алтай
    _6_9_6_17='69:6:17' # Центральное, Старицкое, Тверская область
    _4_6_2='4:6:2' # Усть-Канское, Усть-Канское, Республика Алтай
    _6_9_6_16='69:6:16' # Татаринское, Старицкое, Тверская область
    _4_3_30_6='43:30:6' # Синегорское, Синегорское, Кировская область
    _4_3_30_2='43:30:2' # Краснореченское, Синегорское, Кировская область
    _6_9_9_8='69:9:8' # Окское, Торопецкое, Тверская область
    _4_3_30_3='43:30:3' # Крутоложское, Синегорское, Кировская область
    _6_9_9_9='69:9:9' # Плоскошское, Торопецкое, Тверская область
    _4_3_30_4='43:30:4' # Орлецовское, Синегорское, Кировская область
    _4_3_30_5='43:30:5' # Первомайское, Синегорское, Кировская область
    _4_3_30_1='43:30:1' # Кобринское, Синегорское, Кировская область
    _4_4_14_5='44:14:5' # Малопызмасское, Павинское, Костромская область
    _4_4_14_6='44:14:6' # Шуботское, Павинское, Костромская область
    _5_2_9_2='52:9:2' # Дивеевское, Вознесенское межрайонное, Нижегородская область
    _5_2_9_3='52:9:3' # Илевское, Вознесенское межрайонное, Нижегородская область
    _5_2_9_4='52:9:4' # Сарминское, Вознесенское межрайонное, Нижегородская область
    _4_4_14_1='44:14:1' # 1-е Павинское, Павинское, Костромская область
    _4_4_14_2='44:14:2' # 2-е Павинское, Павинское, Костромская область
    _4_4_14_3='44:14:3' # Ивановское, Павинское, Костромская область
    _5_2_9_1='52:9:1' # Вознесенское, Вознесенское межрайонное, Нижегородская область
    _4_4_14_4='44:14:4' # Леденгское, Павинское, Костромская область
    _4_6_8_1='46:8:1' # Глушковское, Рыльское, Курская область
    _4_6_8_2='46:8:2' # Ивановское, Рыльское, Курская область
    _4_6_8_3='46:8:3' # Крупецкое, Рыльское, Курская область
    _4_6_8_4='46:8:4' # Рыльское, Рыльское, Курская область
    _7_5_6_1='75:6:1' # Балейское, Балейское, Забайкальский край
    _2_13_8='2:13:8' # Ярославское, Дуванское, Республика Башкортостан
    _7_5_6_2='75:6:2' # Калангуйское, Балейское, Забайкальский край
    _7_5_6_3='75:6:3' # Оловяннинское, Балейское, Забайкальский край
    _7_5_6_4='75:6:4' # Талангуйское, Балейское, Забайкальский край
    _7_5_6_5='75:6:5' # Улятуйское, Балейское, Забайкальский край
    _7_5_6_6='75:6:6' # Ундинское, Балейское, Забайкальский край
    _1_1_5_2='11:5:2' # Мощьюгское, Ижемское, Республика Коми
    _2_13_2='2:13:2' # Дуванское сельское, Дуванское, Республика Башкортостан
    _1_1_5_1='11:5:1' # Ижемское, Ижемское, Республика Коми
    _2_13_3='2:13:3' # Калмашское, Дуванское, Республика Башкортостан
    _2_13_1='2:13:1' # Дуванское, Дуванское, Республика Башкортостан
    _2_13_6='2:13:6' # Михайловское, Дуванское, Республика Башкортостан
    _2_13_7='2:13:7' # Урмантавское, Дуванское, Республика Башкортостан
    _2_13_4='2:13:4' # Месягутовское, Дуванское, Республика Башкортостан
    _1_1_5_3='11:5:3' # Щельяюрское, Ижемское, Республика Коми
    _2_13_5='2:13:5' # Метелинское, Дуванское, Республика Башкортостан
    _4_7_10_2='47:10:2' # Гостилицкое, Ломоносовское, Ленинградская область
    _4_7_10_3='47:10:3' # Кипенское, Ломоносовское, Ленинградская область
    _4_7_10_1='47:10:1' # Володарское, Ломоносовское, Ленинградская область
    _4_7_10_8='47:10:8' # Сосновоборское, Ломоносовское, Ленинградская область
    _4_7_10_6='47:10:6' # Лопухинское, Ломоносовское, Ленинградская область
    _4_7_10_7='47:10:7' # Приморское, Ломоносовское, Ленинградская область
    _4_7_10_4='47:10:4' # Копорское, Ломоносовское, Ленинградская область
    _4_7_10_5='47:10:5' # Ломоносовское, Ломоносовское, Ленинградская область
    _3_5_1_9='35:1:9' # Курбозерское, Бабаевское, Вологодская область
    _3_5_1_6='35:1:6' # Колошемское, Бабаевское, Вологодская область
    _3_5_1_5='35:1:5' # Дубровское, Бабаевское, Вологодская область
    _3_5_1_8='35:1:8' # Куйское, Бабаевское, Вологодская область
    _3_5_1_7='35:1:7' # Колпинское, Бабаевское, Вологодская область
    _3_5_1_2='35:1:2' # Борисовское, Бабаевское, Вологодская область
    _3_5_1_1='35:1:1' # Бабаевское, Бабаевское, Вологодская область
    _3_5_1_4='35:1:4' # Вешарорецкое, Бабаевское, Вологодская область
    _3_5_1_3='35:1:3' # Борисовское сельское, Бабаевское, Вологодская область
    _3_8_14_3='38:14:3' # Магистральное, Казачинско-Ленское, Иркутская область
    _3_8_14_2='38:14:2' # Карамское, Казачинско-Ленское, Иркутская область
    _3_8_14_4='38:14:4' # Ульканское, Казачинско-Ленское, Иркутская область
    _6_4_6_1='64:6:1' # Балтайское, Балтайское, Саратовская область
    _6_4_6_3='64:6:3' # Калининское, Балтайское, Саратовская область
    _6_4_6_2='64:6:2' # Барнуковское, Балтайское, Саратовская область
    _5_4_18_2='54:18:2' # Кудряшовский лесохозяйственный участок, Новосибирское, Новосибирская область
    _5_4_18_3='54:18:3' # Новосибирский лесохозяйственный участок, Новосибирское, Новосибирская область
    _5_4_18_1='54:18:1' # Инской лесохозяйственный участок, Новосибирское, Новосибирская область
    _3_8_14_1='38:14:1' # Казачинское, Казачинско-Ленское, Иркутская область
    _4_0_9_2='40:9:2' # Каменское, Козельское, Калужская область
    _4_0_9_1='40:9:1' # Волконское, Козельское, Калужская область
    _2_4_41_5='24:41:5' # Тунгусское, Пойменское, Красноярский край
    _4_0_9_4='40:9:4' # Сосенское, Козельское, Калужская область
    _4_0_9_3='40:9:3' # Лихвинское, Козельское, Калужская область
    _2_4_41_2='24:41:2' # Пойменское, Пойменское, Красноярский край
    _2_4_41_1='24:41:1' # Заводовское, Пойменское, Красноярский край
    _2_4_41_4='24:41:4' # Тиличетское, Пойменское, Красноярский край
    _2_4_41_3='24:41:3' # Решотинское, Пойменское, Красноярский край
    _5_21_1='5:21:1' # Инхокваринское, Цумадинское, Республика Дагестан
    _5_21_3='5:21:3' # Цумадинское, Цумадинское, Республика Дагестан
    _1_7_5_3='17:5:3' # Элегестинское, Тандынское, Республика Тыва
    _5_21_2='5:21:2' # Метрадинское, Цумадинское, Республика Дагестан
    _1_7_5_2='17:5:2' # Хову-Аксынское, Тандынское, Республика Тыва
    _1_7_5_1='17:5:1' # Бай-Хакское, Тандынское, Республика Тыва
    _1_2_2_2='12:2:2' # Дубовское, Волжское, Республика Марий Эл
    _1_2_2_1='12:2:1' # Визимьярское, Волжское, Республика Марий Эл
    _1_2_2_4='12:2:4' # Куплонгское, Волжское, Республика Марий Эл
    _1_2_2_3='12:2:3' # Красномостовское, Волжское, Республика Марий Эл
    _3_8_27_2='38:27:2' # Сосновское, Северное, Иркутская область
    _3_8_27_3='38:27:3' # Тубинское, Северное, Иркутская область
    _3_8_27_1='38:27:1' # Зелендинско-Катинское, Северное, Иркутская область
    _6_9_9_4='69:9:4' # Западнодвинское, Торопецкое, Тверская область
    _6_9_9_5='69:9:5' # Козловское, Торопецкое, Тверская область
    _6_9_9_6='69:9:6' # Красноволокское, Торопецкое, Тверская область
    _6_9_9_7='69:9:7' # Луговское, Торопецкое, Тверская область
    _6_9_9_1='69:9:1' # Андреапольское, Торопецкое, Тверская область
    _6_9_9_2='69:9:2' # Бобровское, Торопецкое, Тверская область
    _6_9_9_3='69:9:3' # Бологовское, Торопецкое, Тверская область
    _2_4_54_4='24:54:4' # Ужурское, Ужурское, Красноярский край
    _2_4_54_3='24:54:3' # Солгонское, Ужурское, Красноярский край
    _2_4_54_5='24:54:5' # Ужурское сельское, Ужурское, Красноярский край
    _2_4_54_2='24:54:2' # Петропавловское, Ужурское, Красноярский край
    _2_4_54_1='24:54:1' # Парнинское, Ужурское, Красноярский край
    _5_8_4_2='58:4:2' # Монастырское, Кададинское, Пензенская область
    _5_8_4_1='58:4:1' # Качимское-Шугуровское, Кададинское, Пензенская область
    _5_8_4_4='58:4:4' # Пензенский лесной колледж, Кададинское, Пензенская область
    _5_8_4_3='58:4:3' # Нижнелиповское-Индерское, Кададинское, Пензенская область
    _5_8_4_6='58:4:6' # Траханиотовское, Кададинское, Пензенская область
    _5_8_4_5='58:4:5' # Сосновоборское-Николо-Барнуковское-Маркинское, Кададинское, Пензенская область
    _6_7_15_4='67:15:4' # Рославльское, Починковское, Смоленская область
    _6_7_15_3='67:15:3' # Починковское, Починковское, Смоленская область
    _6_7_15_2='67:15:2' # Ельнинское, Починковское, Смоленская область
    _6_7_15_1='67:15:1' # Беликское, Починковское, Смоленская область
    _6_7_15_5='67:15:5' # Стодолищенское, Починковское, Смоленская область
    _4_4_11_8='44:11:8' # Первомайское, Нейское, Костромская область
    _2_7_40_4='27:40:4' # Эвурское, Эворонское, Хабаровский край
    _4_4_11_9='44:11:9' # Потрусовское, Нейское, Костромская область
    _2_7_40_3='27:40:3' # Эворонское, Эворонское, Хабаровский край
    _2_7_40_2='27:40:2' # Чукчагирское, Эворонское, Хабаровский край
    _2_7_40_1='27:40:1' # Харпичанское, Эворонское, Хабаровский край
    _2_2_9_1='22:9:1' # Змеиногорское, Горно-Колыванское, Алтайский край
    _4_4_11_1='44:11:1' # 1-е Солтановское, Нейское, Костромская область
    _2_2_9_2='22:9:2' # Колыванское, Горно-Колыванское, Алтайский край
    _4_4_11_2='44:11:2' # 2-е Солтановское, Нейское, Костромская область
    _4_4_11_3='44:11:3' # Абросимовское, Нейское, Костромская область
    _4_4_11_4='44:11:4' # Ёлкинское, Нейское, Костромская область
    _4_4_11_5='44:11:5' # Кужбальское, Нейское, Костромская область
    _4_4_11_6='44:11:6' # Нейское, Нейское, Костромская область
    _4_4_11_7='44:11:7' # Никитское, Нейское, Костромская область
    _3_4_7_4='34:7:4' # Сиротинское, Иловлинское, Волгоградская область
    _3_4_7_3='34:7:3' # Иловлинское сельское, Иловлинское, Волгоградская область
    _3_4_7_2='34:7:2' # Иловлинское, Иловлинское, Волгоградская область
    _3_4_7_1='34:7:1' # Вилтовское, Иловлинское, Волгоградская область
    _7_0_18_3='70:18:3' # Межениновское, Томское, Томская область
    _7_0_18_2='70:18:2' # Коларовское, Томское, Томская область
    _2_2_18_3='22:18:3' # Валовое, Озеро-Кузнецовское, Алтайский край
    _5_3_1_7='53:1:7' # Пригородное, Боровичское, Новгородская область
    _2_2_18_4='22:18:4' # Круглянское, Озеро-Кузнецовское, Алтайский край
    _5_3_1_8='53:1:8' # Суворовское, Боровичское, Новгородская область
    _2_2_18_1='22:18:1' # Алексеевское, Озеро-Кузнецовское, Алтайский край
    _5_3_1_5='53:1:5' # Перелучское, Боровичское, Новгородская область
    _2_2_18_2='22:18:2' # Борисовское, Озеро-Кузнецовское, Алтайский край
    _5_3_1_6='53:1:6' # Плужинское, Боровичское, Новгородская область
    _2_2_18_7='22:18:7' # Павловское, Озеро-Кузнецовское, Алтайский край
    _2_2_18_8='22:18:8' # Партизанское, Озеро-Кузнецовское, Алтайский край
    _2_2_18_5='22:18:5' # Кузнецовское, Озеро-Кузнецовское, Алтайский край
    _2_2_18_6='22:18:6' # Лаптевское, Озеро-Кузнецовское, Алтайский край
    _5_3_1_3='53:1:3' # Кончанское, Боровичское, Новгородская область
    _5_3_1_4='53:1:4' # Опеченское, Боровичское, Новгородская область
    _5_3_1_1='53:1:1' # Боровичское, Боровичское, Новгородская область
    _5_3_1_2='53:1:2' # Волокское, Боровичское, Новгородская область
    _2_2_18_9='22:18:9' # Симоновское, Озеро-Кузнецовское, Алтайский край
    _7_0_18_1='70:18:1' # Богашевское, Томское, Томская область
    _5_1_3='5:1:3' # Гумбетовское, Ботлихское, Республика Дагестан
    _5_1_2='5:1:2' # Ботлихское, Ботлихское, Республика Дагестан
    _5_1_1='5:1:1' # Ахвахское, Ботлихское, Республика Дагестан
    _2_9_18_4='29:18:4' # Пинежское, Пинежское, Архангельская область
    _2_9_18_5='29:18:5' # Пинежское сельское, Пинежское, Архангельская область
    _2_9_18_1='29:18:1' # Ёжугское, Пинежское, Архангельская область
    _2_9_18_2='29:18:2' # Келдинское, Пинежское, Архангельская область
    _2_9_18_3='29:18:3' # Кулойское, Пинежское, Архангельская область
    _2_8_11_5='28:11:5' # Моготское, Тындинское, Амурская область
    _2_8_11_4='28:11:4' # Ларбинское, Тындинское, Амурская область
    _2_8_11_3='28:11:3' # Дипкунское, Тындинское, Амурская область
    _2_8_11_2='28:11:2' # Джелтулакское, Тындинское, Амурская область
    _2_8_11_1='28:11:1' # Беленькое, Тындинское, Амурская область
    _2_3_3_4='23:3:4' # Смоленское, Афипское, Краснодарский край
    _1_1_31_2='11:31:2' # Городское, Ухтинское, Республика Коми
    _2_3_3_5='23:3:5' # Убинское, Афипское, Краснодарский край
    _1_1_31_3='11:31:3' # Изваильское, Ухтинское, Республика Коми
    _1_1_31_4='11:31:4' # Кедвинское, Ухтинское, Республика Коми
    _6_6_21_5='66:21:5' # Филькинское, Серовское, Свердловская область
    _1_1_31_5='11:31:5' # Сюзьюнское, Ухтинское, Республика Коми
    _1_1_31_6='11:31:6' # Тобысьское, Ухтинское, Республика Коми
    _6_6_21_3='66:21:3' # Серовское, Серовское, Свердловская область
    _2_3_3_1='23:3:1' # Калужское, Афипское, Краснодарский край
    _1_1_31_7='11:31:7' # Ухтинское, Ухтинское, Республика Коми
    _6_6_21_4='66:21:4' # Танковское, Серовское, Свердловская область
    _2_3_3_2='23:3:2' # Крепостное, Афипское, Краснодарский край
    _1_1_31_8='11:31:8' # Учебно-опытное, Ухтинское, Республика Коми
    _6_6_21_1='66:21:1' # Андриановское, Серовское, Свердловская область
    _2_3_3_3='23:3:3' # Мирное, Афипское, Краснодарский край
    _6_6_21_2='66:21:2' # Красноярское, Серовское, Свердловская область
    _1_1_31_1='11:31:1' # Боровское, Ухтинское, Республика Коми
    _2_8_11_9='28:11:9' # Сигиктинское, Тындинское, Амурская область
    _2_8_11_8='28:11:8' # Северо-Ларбинское, Тындинское, Амурская область
    _2_8_11_7='28:11:7' # Пригородное, Тындинское, Амурская область
    _2_8_11_6='28:11:6' # Нюкжинское, Тындинское, Амурская область
    _7_6_11_1='76:11:1' # Петровское, ГКУ ЯО "Ростовское лесничество", Ярославская область
    _7_6_11_2='76:11:2' # Ростовское, ГКУ ЯО "Ростовское лесничество", Ярославская область
    _2_8_6_2='28:6:2' # Верхненорское, Зейское, Амурская область
    _7_3_16_5='73:16:5' # Старомайнское, Старомайнское, Ульяновская область
    _2_8_6_3='28:6:3' # Горненское, Зейское, Амурская область
    _7_3_16_6='73:16:6' # Юрткульское, Старомайнское, Ульяновская область
    _7_3_16_3='73:16:3' # Краснореченское, Старомайнское, Ульяновская область
    _2_8_6_1='28:6:1' # Бомнакское, Зейское, Амурская область
    _7_3_16_4='73:16:4' # Никольское, Старомайнское, Ульяновская область
    _2_8_6_6='28:6:6' # Золотогорское, Зейское, Амурская область
    _7_3_16_1='73:16:1' # Жедяевское, Старомайнское, Ульяновская область
    _2_8_6_7='28:6:7' # Кировское, Зейское, Амурская область
    _7_3_16_2='73:16:2' # Кандалинское, Старомайнское, Ульяновская область
    _2_8_6_4='28:6:4' # Дугдинское, Зейское, Амурская область
    _2_8_6_5='28:6:5' # Зейское, Зейское, Амурская область
    _2_8_6_8='28:6:8' # Ново-Ямпольское, Зейское, Амурская область
    _2_8_6_9='28:6:9' # Овсянковское, Зейское, Амурская область
    _8_6_14_3='86:14:3' # Угутское, Юганское, Ханты-Мансийский автономный округ - Югра
    _5_2_8_7='52:8:7' # Стрелицкое, Ветлужское районное, Нижегородская область
    _5_2_8_3='52:8:3' # Калининское, Ветлужское районное, Нижегородская область
    _5_2_8_4='52:8:4' # Каменское, Ветлужское районное, Нижегородская область
    _5_2_8_5='52:8:5' # Макарьевское, Ветлужское районное, Нижегородская область
    _5_2_8_6='52:8:6' # Нагорное, Ветлужское районное, Нижегородская область
    _8_6_14_2='86:14:2' # Тайлаковское, Юганское, Ханты-Мансийский автономный округ - Югра
    _8_6_14_1='86:14:1' # Локосовское, Юганское, Ханты-Мансийский автономный округ - Югра
    _5_2_8_1='52:8:1' # Ветлужское, Ветлужское районное, Нижегородская область
    _5_2_8_2='52:8:2' # Заречное, Ветлужское районное, Нижегородская область
    _1_2_12_1='12:12:1' # Шулкинское, Оршанское, Республика Марий Эл
    _1_0_14_10='10:14:10' # Римское, Пудожское, Республика Карелия
    _1_0_14_11='10:14:11' # Шальское, Пудожское, Республика Карелия
    _1_0_14_12='10:14:12' # Янгозерское, Пудожское, Республика Карелия
    _7_0_4_1='70:4:1' # Васюганское, Васюганское, Томская область
    _3_5_19_1='35:19:1' # Верхне-Кокшеньгское, Тарногское, Вологодская область
    _4_6_5_1='46:5:1' # Бесединское, Курское, Курская область
    _4_6_5_2='46:5:2' # Городское, Курское, Курская область
    _4_6_5_3='46:5:3' # Ленинское, Курское, Курская область
    _4_6_5_4='46:5:4' # Стрелецкое, Курское, Курская область
    _3_5_19_9='35:19:9' # Центральное, Тарногское, Вологодская область
    _3_5_19_8='35:19:8' # Тарногское, Тарногское, Вологодская область
    _3_5_19_7='35:19:7' # Спасское, Тарногское, Вологодская область
    _3_5_19_6='35:19:6' # Северное, Тарногское, Вологодская область
    _3_5_19_5='35:19:5' # Илезское, Тарногское, Вологодская область
    _3_5_19_4='35:19:4' # Заборское, Тарногское, Вологодская область
    _3_5_19_3='35:19:3' # Железнодорожное, Тарногское, Вологодская область
    _3_5_19_2='35:19:2' # Верховское, Тарногское, Вологодская область
    _3_4_22_3='34:22:3' # Новониколаевское, Урюпинское, Волгоградская область
    _3_4_22_4='34:22:4' # Россошинское, Урюпинское, Волгоградская область
    _3_4_22_1='34:22:1' # Добринское, Урюпинское, Волгоградская область
    _3_4_22_2='34:22:2' # Михайловское, Урюпинское, Волгоградская область
    _3_4_22_5='34:22:5' # Урюпинское, Урюпинское, Волгоградская область
    _3_4_22_6='34:22:6' # Урюпинское сельское, Урюпинское, Волгоградская область
    _2_23_4='2:23:4' # Павловское, Нуримановское, Республика Башкортостан
    _5_3_5_13='53:5:13' # Теребутинецкое, Любытинское, Новгородская область
    _2_23_3='2:23:3' # Красноключевское, Нуримановское, Республика Башкортостан
    _5_3_5_12='53:5:12' # Талецкое, Любытинское, Новгородская область
    _2_23_2='2:23:2' # Исаевское, Нуримановское, Республика Башкортостан
    _5_3_5_11='53:5:11' # Радостинское, Любытинское, Новгородская область
    _2_23_1='2:23:1' # Атняшское, Нуримановское, Республика Башкортостан
    _5_3_5_10='53:5:10' # Порогское, Любытинское, Новгородская область
    _2_23_7='2:23:7' # Сарвинское, Нуримановское, Республика Башкортостан
    _2_23_6='2:23:6' # Салдыбашевское, Нуримановское, Республика Башкортостан
    _5_3_5_15='53:5:15' # Хировское, Любытинское, Новгородская область
    _2_23_5='2:23:5' # Первомайское, Нуримановское, Республика Башкортостан
    _5_3_5_14='53:5:14' # Тиховское, Любытинское, Новгородская область
    _6_9_8_9='69:8:9' # Торжокское, Торжокское, Тверская область
    _2_9_26_11='29:26:11' # Устьянское, Устьянское, Архангельская область
    _2_9_26_10='29:26:10' # Студенецкое, Устьянское, Архангельская область
    _2_9_26_13='29:26:13' # Шангальское, Устьянское, Архангельская область
    _2_9_26_12='29:26:12' # Чадромское, Устьянское, Архангельская область
    _3_8_28_1='38:28:1' # Байкальское, Слюдянское, Иркутская область
    _2_10_1='2:10:1' # Бирское, Бирское, Республика Башкортостан
    _3_8_28_2='38:28:2' # Слюдянское, Слюдянское, Иркутская область
    _2_10_2='2:10:2' # Бирское сельское, Бирское, Республика Башкортостан
    _6_9_8_5='69:8:5' # Савиногорское, Торжокское, Тверская область
    _6_9_8_6='69:8:6' # Спировское, Торжокское, Тверская область
    _6_9_8_7='69:8:7' # Тверецкое, Торжокское, Тверская область
    _6_9_8_8='69:8:8' # Толмачевское, Торжокское, Тверская область
    _6_9_8_1='69:8:1' # Калашниковское, Торжокское, Тверская область
    _6_9_8_2='69:8:2' # Козловское, Торжокское, Тверская область
    _6_9_8_3='69:8:3' # Лихославльское, Торжокское, Тверская область
    _6_9_8_4='69:8:4' # Раменское, Торжокское, Тверская область
    _6_9_10_11='69:10:11' # Раевское, Удомельское, Тверская область
    _6_9_10_12='69:10:12' # Ривицкое, Удомельское, Тверская область
    _6_9_10_13='69:10:13' # Свищевское, Удомельское, Тверская область
    _6_9_10_14='69:10:14' # Селецкое, Удомельское, Тверская область
    _6_9_10_10='69:10:10' # Озерное, Удомельское, Тверская область
    _6_9_10_15='69:10:15' # Совхозное, Удомельское, Тверская область
    _6_9_10_16='69:10:16' # Удомельское, Удомельское, Тверская область
    _1_1_8_5='11:8:5' # Ужгинское, Койгородское, Республика Коми
    _1_1_8_4='11:8:4' # Палаузское, Койгородское, Республика Коми
    _2_10_5='2:10:5' # Забельское, Бирское, Республика Башкортостан
    _2_10_6='2:10:6' # Казанцевское, Бирское, Республика Башкортостан
    _2_10_3='2:10:3' # Бураевское, Бирское, Республика Башкортостан
    _2_10_4='2:10:4' # Бураевское сельское, Бирское, Республика Башкортостан
    _1_1_8_3='11:8:3' # Койгородское, Койгородское, Республика Коми
    _2_10_9='2:10:9' # Мишкинское сельское, Бирское, Республика Башкортостан
    _1_1_8_2='11:8:2' # Кобринское, Койгородское, Республика Коми
    _1_1_8_1='11:8:1' # Гривенское, Койгородское, Республика Коми
    _2_10_7='2:10:7' # Калинниковское, Бирское, Республика Башкортостан
    _2_10_8='2:10:8' # Мишкинское, Бирское, Республика Башкортостан
    _4_7_3='4:7:3' # Мультинское, Усть-Коксинское, Республика Алтай
    _4_7_2='4:7:2' # Кайтанакское, Усть-Коксинское, Республика Алтай
    _4_7_1='4:7:1' # Абайское, Усть-Коксинское, Республика Алтай
    _4_1_2_2='41:2:2' # Эссовское, Быстринское, Камчатский край
    _4_1_2_1='41:2:1' # Анавгайское, Быстринское, Камчатский край
    _7_5_7_1='75:7:1' # Беклемишевское, Беклемишевское, Забайкальский край
    _7_5_7_2='75:7:2' # Озёрное, Беклемишевское, Забайкальский край
    _7_5_7_3='75:7:3' # Сохондинское, Беклемишевское, Забайкальский край
    _7_5_7_4='75:7:4' # Яблоновское, Беклемишевское, Забайкальский край
    _1_2_1_1='12:1:1' # Сотнурское, Алексеевское, Республика Марий Эл
    _3_7_6_11='37:6:11' # Сезуховское, Пучежское, Ивановская область
    _3_7_6_10='37:6:10' # Пучежское сельское, Пучежское, Ивановская область
    _3_8_13_3='38:13:3' # Хомутовское, Иркутское, Иркутская область
    _4_1_4_2='41:4:2' # Козыревское, Ключевское, Камчатский край
    _4_1_4_1='41:4:1' # Ключевское, Ключевское, Камчатский край
    _6_4_5_2='64:5:2' # Балашовское, Балашовское, Саратовская область
    _6_4_5_1='64:5:1' # Алмазовское, Балашовское, Саратовская область
    _6_4_5_4='64:5:4' # Самойловское, Балашовское, Саратовская область
    _6_4_5_3='64:5:3' # Падовское, Балашовское, Саратовская область
    _5_4_17_5='54:17:5' # Ояшинский лесохозяйственный участок, Мошковское, Новосибирская область
    _5_4_17_3='54:17:3' # Мошковский лесохозяйственный участок № 1, Мошковское, Новосибирская область
    _5_4_17_4='54:17:4' # Мошковский лесохозяйственный участок № 2, Мошковское, Новосибирская область
    _5_4_17_1='54:17:1' # Белоярский лесохозяйственный участок, Мошковское, Новосибирская область
    _5_4_17_2='54:17:2' # Кубовинский лесохозяйственный участок, Мошковское, Новосибирская область
    _4_1_4_4='41:4:4' # Майское, Ключевское, Камчатский край
    _4_1_4_3='41:4:3' # Крапивненское, Ключевское, Камчатский край
    _3_8_13_2='38:13:2' # Приморское, Иркутское, Иркутская область
    _3_8_13_1='38:13:1' # Гороховское, Иркутское, Иркутская область
    _6_7_16_3='67:16:3' # Екимовичское, Рославльское, Смоленская область
    _6_7_16_2='67:16:2' # Дружба, Рославльское, Смоленская область
    _6_7_16_1='67:16:1' # Громашовское, Рославльское, Смоленская область
    _6_7_16_7='67:16:7' # Кургановское, Рославльское, Смоленская область
    _6_7_16_6='67:16:6' # Красниковское, Рославльское, Смоленская область
    _6_7_16_5='67:16:5' # Колпинское, Рославльское, Смоленская область
    _6_7_16_4='67:16:4' # Заря, Рославльское, Смоленская область
    _6_7_16_9='67:16:9' # Савеевское, Рославльское, Смоленская область
    _6_7_16_8='67:16:8' # Рославльское, Рославльское, Смоленская область
    _2_4_42_1='24:42:1' # Заозерновское, Рыбинское, Красноярский край
    _2_4_42_2='24:42:2' # Рыбинское, Рыбинское, Красноярский край
    _3_8_26_5='38:26:5' # Усть-Вихоревское, Падунское, Иркутская область
    _3_8_26_3='38:26:3' # Озерное, Падунское, Иркутская область
    _3_8_26_4='38:26:4' # Падунское, Падунское, Иркутская область
    _3_8_26_1='38:26:1' # Боровское, Падунское, Иркутская область
    _3_8_26_2='38:26:2' # Карахунское, Падунское, Иркутская область
    _7_6_1_2='76:1:2' # Новосельское, ГКУ ЯО "Большесельское лесничество", Ярославская область
    _7_6_1_1='76:1:1' # Большесельское, ГКУ ЯО "Большесельское лесничество", Ярославская область
    _2_4_55_3='24:55:3' # Нижне-Усинское, Усинское, Красноярский край
    _2_4_55_2='24:55:2' # Верхне-Усинское, Усинское, Красноярский край
    _2_4_55_1='24:55:1' # Араданское, Усинское, Красноярский край
    _5_8_3_1='58:3:1' # Большевьясское-Ломовское, Большевьясское, Пензенская область
    _5_8_3_3='58:3:3' # Кенчурское, Большевьясское, Пензенская область
    _5_8_3_2='58:3:2' # Ильминское, Большевьясское, Пензенская область
    _5_2_2='5:2:2' # Ишкартинское, Буйнакское, Республика Дагестан
    _5_2_1='5:2:1' # Буйнакское, Буйнакское, Республика Дагестан
    _5_2_3='5:2:3' # Казанищенское, Буйнакское, Республика Дагестан
    _3_4_8_3='34:8:3' # Левобережное, Калачёвское, Волгоградская область
    _3_4_8_2='34:8:2' # Калачёвское сельское, Калачёвское, Волгоградская область
    _6_3_11_4='63:11:4' # Ятманское, Похвистневское, Самарская область
    _3_4_8_1='34:8:1' # Калачёвское, Калачёвское, Волгоградская область
    _6_3_11_3='63:11:3' # Сосновское, Похвистневское, Самарская область
    _6_3_11_2='63:11:2' # Подбельское, Похвистневское, Самарская область
    _6_3_11_1='63:11:1' # Кротковское, Похвистневское, Самарская область
    _2_9_19_3='29:19:3' # Плесецкое, Плесецкое, Архангельская область
    _2_9_19_4='29:19:4' # Плесецкое сельское, Плесецкое, Архангельская область
    _2_9_19_5='29:19:5' # Пуксинское, Плесецкое, Архангельская область
    _2_9_19_6='29:19:6' # Федовское, Плесецкое, Архангельская область
    _2_9_19_1='29:19:1' # Липаковское, Плесецкое, Архангельская область
    _2_9_19_2='29:19:2' # Оксовское, Плесецкое, Архангельская область
    _2_2_17_1='22:17:1' # Гуселетовское, Новичихинское, Алтайский край
    _2_2_17_4='22:17:4' # Мамонтовское, Новичихинское, Алтайский край
    _2_2_17_5='22:17:5' # Мельниковское, Новичихинское, Алтайский край
    _2_2_17_2='22:17:2' # Костино-Логовское, Новичихинское, Алтайский край
    _4_3_7_10='43:7:10' # Фаленское сельское, Зуевское, Кировская область
    _2_2_17_3='22:17:3' # Крестьянское, Новичихинское, Алтайский край
    _2_2_17_8='22:17:8' # Токаревское, Новичихинское, Алтайский край
    _2_2_17_9='22:17:9' # Травновское, Новичихинское, Алтайский край
    _2_2_17_6='22:17:6' # Новичихинское, Новичихинское, Алтайский край
    _2_2_17_7='22:17:7' # Поломошенское, Новичихинское, Алтайский край
    _2_8_10_4='28:10:4' # Семёновское, Свободненское, Амурская область
    _2_8_10_3='28:10:3' # Свободненское, Свободненское, Амурская область
    _2_8_10_2='28:10:2' # Ледянское, Свободненское, Амурская область
    _2_8_10_1='28:10:1' # Загорненское, Свободненское, Амурская область
    _2_3_4_3='23:4:3' # Пшехское, Белореченское, Краснодарский край
    _1_1_30_3='11:30:3' # Усть-Цилемское, Усть-Цилемское, Республика Коми
    _2_3_4_4='23:4:4' # Родниковское, Белореченское, Краснодарский край
    _6_6_20_6='66:20:6' # Черноусовское, Свердловское, Свердловская область
    _6_6_20_4='66:20:4' # Покровское, Свердловское, Свердловская область
    _6_6_20_5='66:20:5' # Режиковское, Свердловское, Свердловская область
    _2_3_4_1='23:4:1' # Бжедуховское, Белореченское, Краснодарский край
    _6_6_20_2='66:20:2' # Косулинское, Свердловское, Свердловская область
    _2_3_4_2='23:4:2' # Комсомольское, Белореченское, Краснодарский край
    _6_6_20_3='66:20:3' # Маминское, Свердловское, Свердловская область
    _6_6_20_1='66:20:1' # Каменское, Свердловское, Свердловская область
    _1_1_30_1='11:30:1' # Бугаевское, Усть-Цилемское, Республика Коми
    _1_1_30_2='11:30:2' # Пижемское, Усть-Цилемское, Республика Коми
    _1_7_4_3='17:4:3' # Эрбекское, Кызылское, Республика Тыва
    _1_7_4_2='17:4:2' # Чербинское, Кызылское, Республика Тыва
    _1_7_4_1='17:4:1' # Кызылское, Кызылское, Республика Тыва
    _7_6_10_4='76:10:4' # Первомайское, ГКУ ЯО "Пречистенское лесничество", Ярославская область
    _7_6_10_5='76:10:5' # Скалинское, ГКУ ЯО "Пречистенское лесничество", Ярославская область
    _7_6_10_1='76:10:1' # Козское, ГКУ ЯО "Пречистенское лесничество", Ярославская область
    _7_6_10_2='76:10:2' # Макаровское, ГКУ ЯО "Пречистенское лесничество", Ярославская область
    _7_6_10_3='76:10:3' # Марфинское, ГКУ ЯО "Пречистенское лесничество", Ярославская область
    _7_0_19_1='70:19:1' # Улу-Юльское, Улу-Юльское, Томская область
    _5_7_9_3='57:9:3' # Шаблыкинское, Шаблыкинское, Орловская область
    _5_7_9_2='57:9:2' # Сомовское, Шаблыкинское, Орловская область
    _5_7_9_1='57:9:1' # Молодовское, Шаблыкинское, Орловская область
    _7_3_15_4='73:15:4' # Терешанское, Старокулаткинское, Ульяновская область
    _7_3_15_2='73:15:2' # Бахтеевское, Старокулаткинское, Ульяновская область
    _7_3_15_3='73:15:3' # Кулаткинское, Старокулаткинское, Ульяновская область
    _7_3_15_1='73:15:1' # Атлашинское, Старокулаткинское, Ульяновская область
    _2_8_7_7='28:7:7' # Черняевское, Магдагачинское, Амурская область
    _5_2_7_1='52:7:1' # Вачское, Вачское районное, Нижегородская область
    _5_2_7_2='52:7:2' # Давыдовское, Вачское районное, Нижегородская область
    _5_2_7_3='52:7:3' # Степановское, Вачское районное, Нижегородская область
    _3_5_18_2='35:18:2' # Голузинское, Сямженское, Вологодская область
    _3_5_18_1='35:18:1' # Верденгское, Сямженское, Вологодская область
    _3_5_18_7='35:18:7' # Шиченгское, Сямженское, Вологодская область
    _3_5_18_6='35:18:6' # Чивицкое, Сямженское, Вологодская область
    _3_5_18_5='35:18:5' # Сямженское, Сямженское, Вологодская область
    _3_5_18_4='35:18:4' # Коробицинское, Сямженское, Вологодская область
    _3_5_18_3='35:18:3' # Двиницкое, Сямженское, Вологодская область
    _6_7_2_11='67:2:11' # Хмелитское, Вяземское, Смоленская область
    _7_5_8_1='75:8:1' # Бургенское, Верхне-Читинское, Забайкальский край
    _6_7_2_10='67:2:10' # Тумановское сельское, Вяземское, Смоленская область
    _7_5_8_2='75:8:2' # Верхне-Читинское, Верхне-Читинское, Забайкальский край
    _7_5_8_3='75:8:3' # Новотроицкое, Верхне-Читинское, Забайкальский край
    _7_5_8_4='75:8:4' # Учебно-Опытное, Верхне-Читинское, Забайкальский край
    _1_2_13_1='12:13:1' # Илетское, Параньгинское, Республика Марий Эл
    _5_5_14_10='55:14:10' # Таврическое сельское, Степное, Омская область
    _7_0_5_6='70:5:6' # Максимоярское, Верхнекетское, Томская область
    _7_0_5_7='70:5:7' # Ягоднинское, Верхнекетское, Томская область
    _7_0_5_1='70:5:1' # Белоярское, Верхнекетское, Томская область
    _7_0_5_4='70:5:4' # Клюквинское, Верхнекетское, Томская область
    _7_0_5_5='70:5:5' # Лисицинское, Верхнекетское, Томская область
    _7_0_5_2='70:5:2' # Дружнинское, Верхнекетское, Томская область
    _7_0_5_3='70:5:3' # Катайгинское, Верхнекетское, Томская область
    _3_4_21_1='34:21:1' # Красноярское, Старополтавское, Волгоградская область
    _3_4_21_2='34:21:2' # Старополтавское, Старополтавское, Волгоградская область
    _6_3_10_4='63:10:4' # Узюковское, Ново-Буянское, Самарская область
    _6_3_10_3='63:10:3' # Старобинарадское, Ново-Буянское, Самарская область
    _6_3_10_2='63:10:2' # Ново-Буянское, Ново-Буянское, Самарская область
    _6_3_10_1='63:10:1' # Задельненское, Ново-Буянское, Самарская область
    _2_8_7_1='28:7:1' # Гонжинское, Магдагачинское, Амурская область
    _2_8_7_2='28:7:2' # Магдагачинское, Магдагачинское, Амурская область
    _2_8_7_5='28:7:5' # Тыгдинское, Магдагачинское, Амурская область
    _2_8_7_6='28:7:6' # Ушумунское, Магдагачинское, Амурская область
    _2_8_7_3='28:7:3' # Сивакское, Магдагачинское, Амурская область
    _2_8_7_4='28:7:4' # Толбузинское, Магдагачинское, Амурская область
    _2_11_1='2:11:1' # Асибарское, Бурзянское, Республика Башкортостан
    _2_5_3_14='25:3:14' # Раздольнинское, Владивостокское, Приморский край
    _2_5_3_13='25:3:13' # Петровское, Владивостокское, Приморский край
    _2_5_3_16='25:3:16' # Седанское, Владивостокское, Приморский край
    _2_5_3_15='25:3:15' # Садгородское, Владивостокское, Приморский край
    _6_9_7_1='69:7:1' # Верхневолжское, Тверское, Тверская область
    _2_5_3_18='25:3:18' # Центральное, Владивостокское, Приморский край
    _2_5_3_17='25:3:17' # Славянское, Владивостокское, Приморский край
    _2_5_3_19='25:3:19' # Шкотовское, Владивостокское, Приморский край
    _6_9_7_6='69:7:6' # Заволжское, Тверское, Тверская область
    _6_9_7_7='69:7:7' # Калининское, Тверское, Тверская область
    _4_4_12_1='44:12:1' # Боговаровское, Октябрьское, Костромская область
    _6_9_7_8='69:7:8' # Красногорское, Тверское, Тверская область
    _4_4_12_2='44:12:2' # Веденьевское, Октябрьское, Костромская область
    _6_9_7_9='69:7:9' # Кулицкое, Тверское, Тверская область
    _4_4_12_3='44:12:3' # Луптюгское, Октябрьское, Костромская область
    _6_9_7_2='69:7:2' # Волжское, Тверское, Тверская область
    _4_4_12_4='44:12:4' # Соловецкое, Октябрьское, Костромская область
    _6_9_7_3='69:7:3' # Вяземское, Тверское, Тверская область
    _4_4_12_5='44:12:5' # Стариковское, Октябрьское, Костромская область
    _6_9_7_4='69:7:4' # Дмитрогорское, Тверское, Тверская область
    _6_9_7_5='69:7:5' # Завидовское, Тверское, Тверская область
    _7_6_2_1='76:2:1' # Борисоглебское, ГКУ ЯО "Борисоглебское лесничество", Ярославская область
    _7_6_2_2='76:2:2' # Высоковское, ГКУ ЯО "Борисоглебское лесничество", Ярославская область
    _4_6_6_1='46:6:1' # Банищанское, Льговское, Курская область
    _4_6_6_2='46:6:2' # Иванинское, Льговское, Курская область
    _4_6_6_3='46:6:3' # Конышевское, Льговское, Курская область
    _4_6_6_4='46:6:4' # Льговское, Льговское, Курская область
    _2_4_56_6='24:56:6' # Троицкое, Усольское, Красноярский край
    _2_4_56_5='24:56:5' # Тасеевское сельское, Усольское, Красноярский край
    _2_4_56_8='24:56:8' # Шумихинское, Усольское, Красноярский край
    _2_4_56_7='24:56:7' # Унжинское, Усольское, Красноярский край
    _2_5_3_10='25:3:10' # Надеждинское, Владивостокское, Приморский край
    _2_4_56_2='24:56:2' # Кайтымское, Усольское, Красноярский край
    _2_4_56_1='24:56:1' # Бирюсинское, Усольское, Красноярский край
    _2_5_3_12='25:3:12' # Островное, Владивостокское, Приморский край
    _2_4_56_4='24:56:4' # Тасеевское, Усольское, Красноярский край
    _2_5_3_11='25:3:11' # Нежинское, Владивостокское, Приморский край
    _2_4_56_3='24:56:3' # Суховское, Усольское, Красноярский край
    _2_11_4='2:11:4' # Гадельгареевское, Бурзянское, Республика Башкортостан
    _2_11_5='2:11:5' # Нижне-Бельское, Бурзянское, Республика Башкортостан
    _2_11_2='2:11:2' # Бельское, Бурзянское, Республика Башкортостан
    _2_11_3='2:11:3' # Бетеринское, Бурзянское, Республика Башкортостан
    _1_1_7_4='11:7:4' # Туруньинское, Кажимское, Республика Коми
    _1_1_7_3='11:7:3' # Нючпасское, Кажимское, Республика Коми
    _1_1_7_2='11:7:2' # Комское, Кажимское, Республика Коми
    _7_6_2_3='76:2:3' # Неверковское, ГКУ ЯО "Борисоглебское лесничество", Ярославская область
    _2_11_6='2:11:6' # Нугушское, Бурзянское, Республика Башкортостан
    _1_1_7_1='11:7:1' # Кажымское, Кажимское, Республика Коми
    _2_11_7='2:11:7' # Южно-Узянское, Бурзянское, Республика Башкортостан
    _5_20_1='5:20:1' # Хивское, Хивское, Республика Дагестан
    _4_1_3_1='41:3:1' # Елизовское, Елизовское, Камчатский край
    _4_1_3_3='41:3:3' # Начикинское, Елизовское, Камчатский край
    _4_1_3_2='41:3:2' # Корякское, Елизовское, Камчатский край
    _5_4_16_8='54:16:8' # Мирновский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_9='54:16:9' # Мокрушинский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_6='54:16:6' # Коуракский лесохозяйственный участок № 2, Мирновское, Новосибирская область
    _5_4_16_7='54:16:7' # Курундусский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_4='54:16:4' # Которовский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_5='54:16:5' # Коуракский лесохозяйственный участок № 1, Мирновское, Новосибирская область
    _5_4_16_2='54:16:2' # Дергоусовский лесохозяйственный участок, Мирновское, Новосибирская область
    _5_4_16_3='54:16:3' # Долговский лесохозяйственный участок, Мирновское, Новосибирская область
    _4_1_3_5='41:3:5' # Петропавловское, Елизовское, Камчатский край
    _4_1_3_4='41:3:4' # Паратунское, Елизовское, Камчатский край
    _5_4_16_1='54:16:1' # Буготакский лесохозяйственный участок, Мирновское, Новосибирская область
    _4_1_3_6='41:3:6' # Южное, Елизовское, Камчатский край
    _5_0_10_7='50:10:7' # Серебряно-Прудское, Луховицкое, Московская область
    _5_0_10_6='50:10:6' # Ольшанское, Луховицкое, Московская область
    _5_0_10_5='50:10:5' # Луховицкое сельское, Луховицкое, Московская область
    _5_0_10_4='50:10:4' # Луховицкое, Луховицкое, Московская область
    _5_0_10_8='50:10:8' # Чернореченское, Луховицкое, Московская область
    _5_0_10_3='50:10:3' # Зарайское, Луховицкое, Московская область
    _5_0_10_2='50:10:2' # Дединовское, Луховицкое, Московская область
    _5_0_10_1='50:10:1' # Белоомутское, Луховицкое, Московская область
    _3_5_2_9='35:2:9' # Унженское, Бабушкинское, Вологодская область
    _3_5_2_8='35:2:8' # Талицкое, Бабушкинское, Вологодская область
    _3_5_2_5='35:2:5' # Леденгское, Бабушкинское, Вологодская область
    _2_24_3='2:24:3' # Кигинское, Салаватское, Республика Башкортостан
    _3_5_2_4='35:2:4' # Илезское, Бабушкинское, Вологодская область
    _2_24_2='2:24:2' # Калмакуловское, Салаватское, Республика Башкортостан
    _3_5_2_7='35:2:7' # Рослятинское, Бабушкинское, Вологодская область
    _2_24_1='2:24:1' # Аркаульское, Салаватское, Республика Башкортостан
    _3_5_2_6='35:2:6' # Миньковское, Бабушкинское, Вологодская область
    _3_5_2_1='35:2:1' # Бабушкинское, Бабушкинское, Вологодская область
    _4_8_3='4:8:3' # Эликманарское, Чемальское, Республика Алтай
    _2_24_7='2:24:7' # Салаватское сельское, Салаватское, Республика Башкортостан
    _4_8_2='4:8:2' # Чемальское, Чемальское, Республика Алтай
    _2_24_6='2:24:6' # Малоязовское, Салаватское, Республика Башкортостан
    _3_5_2_3='35:2:3' # Идское, Бабушкинское, Вологодская область
    _4_8_1='4:8:1' # Семинское, Чемальское, Республика Алтай
    _2_24_5='2:24:5' # Леузинское, Салаватское, Республика Башкортостан
    _3_5_2_2='35:2:2' # Брусенецкое, Бабушкинское, Вологодская область
    _2_24_4='2:24:4' # Кигинское сельское, Салаватское, Республика Башкортостан
    _2_9_1_1='29:1:1' # Архангельское, Архангельское, Архангельская область
    _2_9_1_2='29:1:2' # Беломорское, Архангельское, Архангельская область
    _2_9_1_3='29:1:3' # Ижемское, Архангельское, Архангельская область
    _2_9_1_4='29:1:4' # Исакогорское, Архангельское, Архангельская область
    _2_9_1_5='29:1:5' # Кепинское, Архангельское, Архангельская область
    _2_9_1_6='29:1:6' # Лодемское, Архангельское, Архангельская область
    _2_9_1_7='29:1:7' # Новодвинское, Архангельское, Архангельская область
    _2_9_1_8='29:1:8' # Поморское, Архангельское, Архангельская область
    _2_9_1_9='29:1:9' # Усть-Двинское, Архангельское, Архангельская область


class DocumentTypeKindEType2(str, Enum):
    """DocumentTypeKindEType2 -- Т
    и
    п
    ы
    д
    о
    к
    у
    м
    е
    н
    т
    о
    в
    
    """
    STATE_FOREST_REGISTER_FOR_TAX='stateForestRegisterForTax' # Выписка из государственного лесного реестра о лесотаксационном выделе
    FOREST_REPRODUCTION='forestReproduction' # Отчёт о воспроизводстве лесов
    EXERCISE_AUTHORITY_REPORT='exerciseAuthorityReport' # Отчетность об осуществлении переданных в соответствии с частью 1 статьи 83 ЛК РФ полномочий
    CIVIL_LAW_CONTRACT='civilLawContract' # Гражданско-правовой договор
    ABOLITION_FORESTRY_OB_ORDER='abolitionForestryOBOrder' # Приказ об упразднении лесничества на землях обороны и безопасности
    CORRECT_ERROR_IN_GLR_REQUEST='correctErrorInGlrRequest' # Обращение заинтересованных лиц об исправлении технической ошибки в сведениях ГЛР
    DOCT_BASIS_CREATED_FOREST_ROADS='doctBasisCreatedForestRoads' # Документ, на основании которого сведения о планируемых к созданию лесных дорогах внесены в ГЛР
    ORDER_CREATE_FORESTRY_OB='orderCreateForestryOB' # Приказ о создании лесничества на землях обороны и безопасности
    ORDER_CREATE_FORESTRY_FOREST_FUND='orderCreateForestryForestFund' # Приказ о создании лесничества на землях лесного фонда
    STATE_TASK='stateTask' # Государственное задание
    NOTIFICATION_PUT_INFO='notificationPutInfo' # Уведомление о внесении сведений
    NOTIFICATION_REJECT_DOCUMENT_FORE='notificationRejectDocumentFore' # Уведомление об отказе в приеме документов, необходимых для предоставления услуги по приему лесных деклараций и отчетов об использовании лесов от граждан, юридических лиц, осуществляющих использование лесов
    ESTABLISHMENT_DISTRICT_FORESTRY_L='establishmentDistrictForestryL' # Приказ о создании участкового лесничества на землях лесного фонда
    STATE_FOREST_REGISTER_EXTRACT_FORE='stateForestRegisterExtractFore' # Выписка из государственного лесного реестра о лесничестве
    CHANGING_BOUNDARIES_DDISTRICT_FOR='changingBoundariesDdistrictFor' # Приказ об изменении границ участкового лесничества на землях населенных пунктов
    DECISION_STAB_SUB_FORESTRY='decisionStabSubForestry' # Решение ОГВ или ОМС об установлении или изменении границы участкового лесничества
    BASIC_DOCUMENT_RADIONUCLIDE='basicDocumentRadionuclide' # Документ-основание для внесения в ГЛР сведений о загрязнении радионуклидами земель, на которых расположены леса
    NOTICE_ACCEPT_FOREST_DECLARATION='noticeAcceptForestDeclaration' # Извещение о приеме лесной декларации/отчета об использовании лесов
    ABOLITION_FORESTRY_OOPT_ORDER='abolitionForestryOOPTOrder' # Приказ об упразднении лесничества на землях особо охраняемых природных территорий
    DECISION_ABOLISH_GREEN_ZONE='decisionAbolishGreenZone' # Решение об упразднении зеленой зоны, лесопарковой зоны
    FOREST_PLAN='forestPlan' # Лесной план субъекта
    STATE_FOREST_REGISTER_EXTRACT_GREE='stateForestRegisterExtractGree' # Выписка из государственного лесного реестра о зеленой зоне
    CORRECT_REGISTRY_ERROR_IN_OZVL_REPO='correctRegistryErrorInOzvlRepo' # Исправление реестровой ошибки в сведениях о проведенных мероприятиях по сохранению лесов
    EGRN_NOTIFICATION_OF_ENTERING_INFO='egrnNotificationOfEnteringInfo' # Уведомление о внесении сведений об установлении или изменении границы лесничества в ЕГРН
    FOREST_DOCUMENTATION='forestDocumentation' # Лесоустроительная документация
    CORRECT_REGISTRY_ERROR_IN_PUL='correctRegistryErrorInPUL' # Обращение заинтересованных лиц об исправлении реестровой ошибки в сведениях ГЛР об учете лесов
    ORDER_BOUNDARY_FORESTRY_OB='orderBoundaryForestryOB' # Приказ об установлении границ лесничества на землях обороны и безопасности
    NOTICE_EXTRACTION='noticeExtraction' # Извещение о выдаче выписки из ГЛР
    ALLOCATION_SPECIALLY_PROTECTED_AR='allocationSpeciallyProtectedAr' # Приказ о выделении особо защитных участков лесов
    PERMIT_USE_FORESTS_FOR_AGRICULTURE='permitUseForestsForAgriculture' # Разрешение на использование лесов для ведения сельского хозяйства
    NOTIFICATION_REJECT_REFUND='notificationRejectRefund' # Уведомление об отказе в возврате платежа за предоставление сведений, содержащихся в государственном лесном реестре
    NOTIFICATION_PLACEMENT_INFO='notificationPlacementInfo' # Уведомление о размещении документа
    NOTIFICATION_ACCEPT_FOREST_DECLAR='notificationAcceptForestDeclar' # Уведомление о приеме лесной декларации/отчета об использовании лесов
    DOC_THE_BASIS_EMERGE_OWNERSHIP_NON_T='docTheBasisEmergeOwnershipNonT' # Документ-основание возникновения у владельцев объектов, не связанных с созданием лесной инфраструктуры, права собственности или иного законного основания владения объектами, не связанными с созданием лесной инфраструктуры
    NOTIFICATION_REJECT_FOREST_DIRT_SE='notificationRejectForestDirtSe' # Извещение об отказе в приеме отчета об охране лесов от загрязнения и иного негативного воздействия
    NOTIFICATION_REJECT_FIXED_TECHNIC='notificationRejectFixedTechnic' # Уведомление об отказе в исправлении технической ошибки
    LUDPROJECTСONSERVATION_FOREST='ludprojectСonservationForest' # Проект мероприятий по сохранению лесов
    DECISION_AS_PROTECT_FORESTS='decisionAsProtectForests' # Решение об отнесении лесов к категории защитных лесов
    CORRECT_ERROR_IN_GLR_PIL_REESTR_REQU='correctErrorInGlrPilReestrRequ' # Исправление реестровой ошибки в сведениях ГЛР использования лесов
    LUDPROJECT_KIND_FOREST='ludprojectKindForest' # Проект эксплуатационных лесов, защитных лесов, резервных лесов, особо защитных участков лесов
    BUILDING_PERMIT='buildingPermit' # Разрешение на строительство, реконструкцию объектов капитального строительства в границах лесничеств
    PERMIT_USE_FORESTS_FOR_GEO_SURVEY='permitUseForestsForGeoSurvey' # Разрешение на использование лесов в целях осуществления геологического изучения недр, разведки и добычи полезных ископаемых
    AMENDMENT_AGREEMENT='amendmentAgreement' # Дополнительное соглашение о внесении изменений в договор
    STATE_FOREST_REGISTER_EXTRACT_CUTT='stateForestRegisterExtractCutt' # Выписка из государственного лесного реестра о лесосеке
    AGREEMENT_PERMANENT_USE='agreementPermanentUse' # Решение уполномоченного органа гос. власти или органа местного самоуправления в случае предоставления лесного участка в постоянное (бессрочное) пользование (в соответствии со статьями 81-84 ЛК РФ)
    NOTIFICATION_FIXED_REGISTRY_ERROR='notificationFixedRegistryError' # Уведомление об исправлении реестровой ошибки
    ORDER_BOUNDARY_FORESTRY_SETTLEMEN='orderBoundaryForestrySettlemen' # Приказ об установлении границ лесничества на землях населенных пунктов
    NOTIFICATION_ERROR_REFUND='notificationErrorRefund' # Уведомление об ошибке при возврате платежа за предоставление сведений, содержащихся в государственном лесном реестре
    DECREE_ON_THE_TRANSFER_OF_LAND='decreeOnTheTransferOfLand' # Решение о переводе земель в иную категорию
    PERMIT_USE_FORESTS_FOR_LINEAR_OBJEC='permitUseForestsForLinearObjec' # Разрешение на использование лесов для строительства, реконструкции, эксплуатации линейных объектов
    CHANGING_BOUNDARIES_DISTRICT_FORE='changingBoundariesDistrictFore' # Приказ об изменении границ участкового лесничества на землях лесного фонда
    INSPECTION_FORESTS_REPORT='inspectionForestsReport' # Акт осмотра лесосеки
    NOTIFICATION_ACCEPT_FOREST_DIRT_SE='notificationAcceptForestDirtSe' # Извещение о приеме отчета об охране лесов от загрязнения и иного негативного воздействия
    JUDICAL_ACT='judicalAct' # Вступивший в законную силу судебный акт
    DECISION_AS_SPECIAL_PROTECT_FOREST='decisionAsSpecialProtectForest' # Решение о выделении особо защитных участков лесов
    EASEMENT_AGREEMENT='easementAgreement' # Соглашение об установлении сервитута
    NOTIFICATION_OF_ABSENCE_VIOLATION='notificationOfAbsenceViolation' # Мотивированное уведомление об отсутствии выявленных нарушений при внесении информации в ГЛР
    GLR_RECORD_CHANGE_XML='glrRecordChangeXml' # Документ с изменениями для ТО
    ASSIGNMEN_FORESTS_GREEN_ZONE_ORDER='assignmenForestsGreenZoneOrder' # Распоряжение/приказ об отнесении лесов к зелёной, лесопарковой зоне
    ZTMO_INFORMATION='ztmoInformation' # Внесение сведений о составе и границах земель лесного фонда, составе земель иных категорий, на которых расположены леса на территории муниципального образования
    OTHER_DOCUMENT_PUL='otherDocumentPUL' # Иной документ раздела I «Характеристики лесов и лесных ресурсов»
    APPEAL_OF_INTERESTED_PERSONS='appealOfInterestedPersons' # Исправление реестровой ошибки в сведениях ГЛР использования лесов
    TIMBER_DEAL_DECLARATION='timberDealDeclaration' # Декларация о сделках с древесиной в случае ее заключения в целях вывоза древесины и продукции ее переработки из РФ
    CHANGING_BOUNDAR_FORESTRY_LANDS_OB='changingBoundarForestryLandsOB' # Приказ об изменении границ лесничества на землях обороны и безопасности
    STATE_CONTRACT='stateContract' # Государственный контракт
    DOC_THE_BASIS_USE_FOREST_AREA_WITHOU='docTheBasisUseForestAreaWithou' # Документ, являющийся основанием использования лесов без предоставления лесного участка
    FOREST_FIRE_SECURITY='forestFireSecurity' # Отчёт об охране лесов от пожаров
    LEASE_CONTRACT='leaseContract' # Договор аренды лесного участка
    OPERATIONAL_PROTECTIVE_FOREST='operationalProtectiveForest' # Приказ об отнесении лесов к эксплуатационным лесам и защитным лесам и установлении их границ
    NOTIFICATION_RESOLVED_PUT_INFO_ERR='notificationResolvedPutInfoErr' # Уведомление о необоснованности выявленных нарушений при внесении сведений в ГЛР
    DECISION_CREATION_FORESTRY='decisionCreationForestry' # Решение ОГВ или ОМС о создании лесничеств
    LUDPROJECT_FORESTRY='ludprojectForestry' # Проект лесничества
    NOTIFICATION_REJECT_PLACEMENT_INF='notificationRejectPlacementInf' # Уведомление об отказе в размещении документов
    NOTIFICATION_REJECT_FOREST_FIRE_SE='notificationRejectForestFireSe' # Извещение об отказе в приеме отчета об охране лесов от пожаров
    OTHER_DOCUMENT='otherDocument' # Иной документ
    DOCUMENT_BASIS_MACHINES='documentBasisMachines' # Документ, на основании которого сведения о машинах и оборудовании, предназначенных для рубки лесных насаждений, вывоза из леса древесины и продукции ее переработки, лесосечных работ, транспортировки древесины и продукции ее переработки внесены в ГЛР
    ESTABLISHMENT_BOUNDARIES_FORESTR='establishmentBoundariesForestr' # Приказ об установлении границ участкового лесничества на землях лесного фонда
    PUBLIC_EASEMENT_AGREEMENT='publicEasementAgreement' # Соглашение об установлении публичного сервитута
    LUD_TAXATION_DESCRIPTION='ludTaxationDescription' # Таксационное описание лесотаксационного выдела
    ABOLITION_DISTRICT_FORESTRY_LANDS='abolitionDistrictForestryLands' # Приказ об упразднении участкового лесничества на землях лесного фонда
    NOTIFICATION_REJECT_FOREST_REGIST='notificationRejectForestRegist' # Уведомление об отказе в предоставлении выписки из государственного лесного реестра
    ATTRIB_LAND_FOR_REFORESTATION_LAND='attribLandForReforestationLand' # Акт отнесения земель, предназначенных для лесовосстановления, к землям, на которых расположены леса
    EXTRACT_EGRN='extractEGRN' # Выписка из ЕГРН о лесном участке
    EXAMINATION_RADIATION='examinationRadiation' # Радиационное обследование
    CHANGING_BOUNDARIE_LANDS_SETLE='changingBoundarieLandsSetle' # Приказ об изменении границ лесничества на землях населенных пунктов
    NOTIFICATION_RESOLVED_DOC_PLACEME='notificationResolvedDocPlaceme' # Уведомление о необоснованности выявленных нарушений при размещении документа в ГЛР
    DECISION_CHANGE_BOUND_FORESTRY_ON_L='decisionChangeBoundForestryOnL' # Приказ об изменении границ лесничества на землях лесного фонда
    DECISION_ABOLITION_PROTECT_FOREST='decisionAbolitionProtectForest' # Решение об исключении лесов из состава категории защитных лесов
    NOTIFICATION_REJECT_FIXED_REGISTR='notificationRejectFixedRegistr' # Уведомление об отказе в исправлении реестровой ошибки
    INFO_REQUEST_GLR_PAPER_REQUEST='infoRequestGLRPaperRequest' # Запрос о предоставлении сведений, содержащихся в государственном лесном реестре (поданный в бумажном виде)
    CORRECTREGISTRYERROR='correctregistryerror' # Исправление реестровой ошибки в сведениях ГЛР об учете лесов
    DECISION_STAB_OR_CHANGE_BOUND_PROTE='decisionStabOrChangeBoundProte' # Решение об установлении или изменении границ земель, на которых располагаются леса соответствующей категории защитных лесов
    DOC_THE_BASIS_ENTER_DATA_IN_GLR='docTheBasisEnterDataInGlr' # Документ, являющийся основанием для внесения сведений в ГЛР, направленный в порядке информационного взаимодействия ФГИС ЛК с иными ИС в рамках соглашений об информационном взаимодействии
    STATE_FOREST_REGISTER_PARK_ZONE='stateForestRegisterParkZone' # Выписка из государственного лесного реестра о лесопарковой зоне
    NOTIFICATION_ACCEPT_FOREST_FIRE_SE='notificationAcceptForestFireSe' # Извещение о приеме отчета об охране лесов от пожаров
    STATE_FOREST_REGISTER_EXTRACT_PLAC='stateForestRegisterExtractPlac' # Выписка из государственного лесного реестра о месте (пункте) складирования древесины (складе древесины)
    NOTIFICATION_FOREST_REGISTER_EXTR='notificationForestRegisterExtr' # Уведомление о размере платы за предоставление выписки из государственного лесного реестра
    OTHER_DOCUMENT_FOREST_USE='otherDocumentForestUse' # Иной документ использования лесов
    FOREST_DECLARATION='forestDeclaration' # Лесная декларация
    NOTICE_REJECT_FOREST_DECLARATION_O='noticeRejectForestDeclarationO' # Извещение об отказе в приеме лесной декларации/отчета об использовании лесов
    EXCLUSION_INFO_GLR='exclusionInfoGlr' # Документ основание на исключение сведений о проведенных мероприятиях по сохранению лесов
    NOTICE_REJECT_FOREST_DECLARATION='noticeRejectForestDeclaration' # Извещение об отказе в предоставлении государственной услуги в приеме лесной декларации/отчета об использовании лесов
    STATE_FOREST_REGISTER_EXTRACT_OBJ='stateForestRegisterExtractObj' # Выписка из государственного лесного реестра об объекте, не связанном с созданием лесной инфраструктуры
    DECISION_ABOLITION_AS_SPECIAL_PROT='decisionAbolitionAsSpecialProt' # Решение об упразднении особо защитных участков лесов
    EXCLUSION_PIL_INFO_GLR_TE='exclusionPilInfoGlrTE' # Обращение заинтересованного лица об исправлении реестровой/технической ошибки использования лесов
    EXCLUSION_PIL_INFO_GLR='exclusionPilInfoGlr' # Документ основание на исключение сведений об использовании лесов
    CORRECT_ERROR_IN_GLR_PUL='correctErrorInGlrPUL' # Обращение заинтересованного лица об исправлении технической ошибки в сведениях ГЛР об учете лесов
    EGRN_STATEMENT_BORDER_BETWEEN_SUBJ='egrnStatementBorderBetweenSubj' # Выписка из ЕГРН о границе между субъектами Российской Федерации, границе муниципального образования и границе населенного пункта
    NOTIFICATION_PUT_INFO_DEFECTION='notificationPutInfoDefection' # Уведомление о выявленных нарушениях при внесении сведений
    DOC_THE_BASIS_EMERGE_OWNERSHIP='docTheBasisEmergeOwnership' # Документ-основание возникновения права собственности или иного законного основания владения складом древесины
    NOTIFICATION_COMPLETE_WORK_DATE='notificationCompleteWorkDate' # Извещение об окончании лесосечных работ
    DECISION_ON_CERTIFICATION_FOREST_S='decisionOnCertificationForestS' # Решение комиссии по аттестации (списанию) объектов лесного семеноводства
    DOKUMENT_BASIS_CREATED_FOREST_ROAD='dokumentBasisCreatedForestRoad' # Документ, на основании которого сведения о созданных лесных дорогах внесены в ГЛР
    ZTSRF_INFORMATION='ztsrfInformation' # Внесение сведений о составе и границах земель лесного фонда, составе земель иных категорий, на которых расположены леса на территории субъекта Российской Федерации
    ORDER_CREATE_FORESTRY_SETTLEMENT='orderCreateForestrySettlement' # Приказ о создании лесничества на землях населенных пунктов
    DOC_THE_BASIS_FOR_CREATION_FORESTS='docTheBasisForCreationForests' # Документ, являющийся основанием для создания лесосек
    REPORT_ON_WOOD_IMPORTED_INTO_WAREHO='reportOnWoodImportedIntoWareho' # Отчет о ввезенной на склад или вывезенной со склада древесине и продукции ее переработки
    RIGHT_OF_USE='rightOfUse' # Право пользования
    CORRECT_REESTR_ERROR_POZVL='correctReestrErrorPOZVL' # Обращение заинтересованных лиц об исправлении реестровой ошибки в сведениях ГЛР об охране, защите, воспроизводстве лесов
    TIMBER_DEAL='timberDeal' # Сделка с древесиной
    DECISION_STAB_REVERSE_FORESTRY='decisionStabReverseForestry' # Решение об установлении или изменении границ земель, на которых располагаются защитные, эксплуатационные, резервные леса
    DECISION_CREATION_SUB_FORESTRY='decisionCreationSubForestry' # Решение ОГВ или ОМС о создании участковых лесничеств
    DOCUMENT_BASIC_FOREST_QUATRER='documentBasicForestQuatrer' # Документ, на основании которого сведения о лесном квартале внесены в ГЛР
    ABOLITION_FORESTRY_LANDS_FOREST_FU='abolitionForestryLandsForestFu' # Приказ об упразднении лесничества на землях лесного фонда
    HUNTING_AGREEMENT='huntingAgreement' # Охотохозяйственное соглашение
    ORDER_BOUNDARY_FORESTRY_FOREST_FUN='orderBoundaryForestryForestFun' # Приказ об установлении границ лесничества на землях лесного фонда
    FOREST_TAXATION_DESC='forestTaxationDesc' # Таксационное описание лесосеки
    CONTRACT_OF_PURCHASE='contractOfPurchase' # Договор купли-продажи лесных насаждений
    STATE_FOREST_REGISTER_EXTRACT_USE_W='stateForestRegisterExtractUseW' # Выписка из государственного лесного реестра об использовании лесов без предоставления лесного участка
    EL_SUPPORT_DOC='elSupportDoc' # Электронный сопроводительный документ, в том числе сведения об его прекращении
    CERTIFICATE_OF_STATE_REGISTR_IN_GLR='certificateOfStateRegistrInGlr' # Свидетельство о Государственной регистрации права собственности в ГЛР
    ANALYSIS_REPORT='analysisReport' # Отчет об анализе качества проведения и результативности мероприятий по сохранению лесов
    CORRECT_ERROR_IN_GLR_OZVL_REQUEST='correctErrorInGlrOzvlRequest' # Исправление технической ошибки в сведениях о проведенных мероприятиях по сохранению лесов
    DOC_THE_BASIS_ENTER_DATA_IN_GLR_ON_SME='docTheBasisEnterDataInGlrOnSme' # Документ, являющийся основанием для внесения сведений в ГЛР, направленный способами и в порядке, предусмотренном порядком межведомственного информационного взаимодействия при ведении ГЛР, в том числе запрошенных оператором ФГИС ЛК по межведомственным
    NOTIFICATION_REJECT_PUT_INFO='notificationRejectPutInfo' # Уведомление об отказе во внесении сведений
    DECRYPT_CARD='decryptCard' # Карточка дешифрирования
    STATE_FOREST_REGISTER_EXTRACT_OTHE='stateForestRegisterExtractOthe' # Выписка, предоставляемая в ином виде
    EASEMENT_APPLICATION='easementApplication' # Заявление о заключении соглашения по установлению сервитута в отношении лесного участка
    ESTABLISHMENT_DISTRICT_FOR_LAND='establishmentDistrictForLand' # Приказ о создании участкового лесничества на землях населенных пунктов
    ESTABLISHMENT_BOUNDARIES_DISTRIC='establishmentBoundariesDistric' # Приказ об установлении границ участкового лесничества на землях населенных пунктов
    INFO_REQUEST_GLR='infoRequestGLR' # Запрос о предоставлении сведений, содержащихся в государственном лесном реестре
    DOCUMENT_BASIS_BATCH_OF_TRANSPORTE='documentBasisBatchOfTransporte' # Документ, на основании которого сведения о партии транспортируемой древесины и продукции ее переработки внесены в ГЛР
    FOREST_PROTECTION='forestProtection' # Отчёт о защите лесов
    NOTIFICATION_REJECT_FOREST_PROTEC='notificationRejectForestProtec' # Извещение об отказе в приеме отчета о защите лесов
    NOTIFICATION_ACCEPT_FOREST_PROTEC='notificationAcceptForestProtec' # Извещение о приеме отчета о защите лесов
    LPO='lpo' # Акт лесопатологического обследования
    NOTIFICATION_EXTRACT_NOTICE_DOC_EM='notificationExtractNoticeDocEm' # Уведомление об отсутствии сведений в ГЛР
    ORDER_CREATE_FORESTRY_OOPT='orderCreateForestryOOPT' # Приказ о создании лесничества на землях особо охраняемых природных территорий
    DECISION_ABOLITION_SUB_FORESTRY='decisionAbolitionSubForestry' # Решение ОГВ или ОМС об упразднении участковых лесничеств
    NOTIFICATION_REJECT_DOCUMENT_PRE_P='notificationRejectDocumentPreP' # Извещение об отказе в приеме документов, необходимых для размещения
    DOCUMENT_BASIS_ACTIVITIES_DESIGNE='documentBasisActivitiesDesigne' # Документ-основание для внесения в ГЛР сведений о мероприятиях, проектируемых при осуществлении мероприятий по лесоустройству
    DOCUMENT_BASIS_BALANS_OF_WOOD='documentBasisBalansOfWood' # Документ, на основании которого сведения о балансе древесины и продукции ее переработки, хранящейся на лесосеке внесены в ГЛР
    FOREST_DEV_PROJECT='forestDevProject' # Проект освоения лесов
    NOTIFICATION_ACT_ZOL_REFUSED='notificationActZolRefused' # Извещение об отказе в принятии извещения об окончании лесосечных работ
    DECISION_STAB_OR_CHANGE_BOUND_AS_SPE='decisionStabOrChangeBoundAsSpe' # Решение об установлении или изменении границ земель, на которых располагаются особо защитные участки лесов
    OPERATIOMAL_LANDS_ORDER_SELECTION='operatiomalLandsOrderSelection' # Приказ об отнесении лесов к эксплуатационным лесам и об установлении их границ
    STATE_FOREST_REGISTER_EXTRACT_DEAL='stateForestRegisterExtractDeal' # Выписка из государственного лесного реестра о сделке с древесиной и продукцией ее переработки
    PERMIT_USE_FORESTS_FOR_FISHING='permitUseForestsForFishing' # Разрешение на использование лесов для осуществления рыболовства
    NOTICE_REJECT_DOCUMENT_FOREST_DECL='noticeRejectDocumentForestDecl' # Извещение об отказе в приеме документов, необходимых для предоставления услуги по приему лесных деклараций и отчетов об использовании лесов от граждан, юридических лиц, осуществляющих использование лесов
    CHANGING_BOUNDARIE_FORESTRY_LANDS='changingBoundarieForestryLands' # Приказ об изменении границ лесничества на землях особо охраняемых природных территорий
    CORRECT_TECHERROR_PUL='correctTecherrorPUL' # Исправление технической ошибки в сведениях ГЛР об учете лесов
    EXCLUSION_INFO_GLR_XML='exclusionInfoGlrXml' # Документ с изменениями для исключения
    FOREST_USAGE_REPORT='forestUsageReport' # Отчёт об использовании лесов
    NOTIFICATION_REJECT_DOCUMENT_REFU='notificationRejectDocumentRefu' # Уведомление об отказе в приеме документов, необходимых для выполнения возврата платежа от граждан, юридических лиц, внесших плату за предоставление сведений, содержащихся в государственном лесном реестре
    ORDER_PROTECTIVE_FOREST='orderProtectiveForest' # Приказ об отнесении лесов к защитным лесам и об установлении их границ
    NOTIFICATION_INSPECTION_CLEARCUT='notificationInspectionClearcut' # Извещение о проведении осмотра лесосек
    STATE_FOREST_REGISTER_EXTRACT_OBJE='stateForestRegisterExtractObje' # Выписка из государственного лесного реестра об объекте лесоперерабатывающей инфраструктуры
    STATEMENT_REFUND_PAYMENT='statementRefundPayment' # Заявление о возврате платежа за предоставление сведений, содержащихся в государственном лесном реестре
    ABOLITION_FORESTRY_LANDS_SETTLEME='abolitionForestryLandsSettleme' # Приказ об упразднении лесничества на землях населенных пунктов
    TIMBER_IMOPRT_EXPORT_REPORT='timberImoprtExportReport' # Отчет о ввезенной на склад или вывезенной со склада древесине
    NOTIFICATION_REJECT_FOREST_DECLAR='notificationRejectForestDeclar' # Уведомление об отказе в приеме лесной декларации/отчета об использовании лесов
    COPIES_CONTRACT_TIMBER_DEAL='copiesContractTimberDeal' # Копия договора о сделках с древесиной при их заключении в письменной форме
    WORKING_PROJECT_CREATION_FOREST_SE='workingProjectCreationForestSe' # Рабочий проект создания объектов лесного семеноводства
    ANALYTICAL_REVIEW='analyticalReview' # Аналитический обзор о состоянии лесов, их количественных и качественных характеристиках по субъекту РФ
    NOTIFICATION_REJECT_PRE_PLACEMENT='notificationRejectPrePlacement' # Уведомление об отказе в приеме документа к размещению
    STATE_FOREST_REGISTУК_FOR_QUATER='stateForestRegistукForQuater' # Выписка из государственного лесного реестра о лесном квартале
    FOREST_DIRT_SECURITY='forestDirtSecurity' # Отчёт об охране лесов от загрязнения и иного негативного воздействия
    DOC_THE_BASIS_USE_FOREST_AREA='docTheBasisUseForestArea' # Документ, являющийся основанием для использования лесных участков
    NOTIFICATION_PLACEMENT_INFO_DEFEC='notificationPlacementInfoDefec' # Уведомление о выявленных нарушениях при размещении документов
    DECISION_STAB_OR_CHANGE_BOUND_FORES='decisionStabOrChangeBoundFores' # Решение ОГВ или ОМС об установлении или изменении границ лесничеств
    NOTIFICATION_ACT_ZOL_PROCESSED='notificationActZolProcessed' # Извещение о принятии извещения об окончании лесосечных работ
    DECISION_ABOLITION_AS_RESERVE_FORE='decisionAbolitionAsReserveFore' # Решение об исключении лесов из состава защитных, эксплуатационных, резервных лесов
    TIMBER_INFRASTRUCTURE_REPORT='timberInfrastructureReport' # Отчет о древесине, которая поступает на объект лесоперерабатывающей инфраструктуры
    DECISION_AS_RESERVE_FORESTS='decisionAsReserveForests' # Решение об отнесении лесов к защитным, эксплуатационным, резервным лесам
    FOREST_LAND_GRATIS_AGREEMENT='forestLandGratisAgreement' # Договор безвозмездного пользования лесным участком
    NOTIFICATION_REJECT_FOREST_REPROD='notificationRejectForestReprod' # Извещение об отказе в приеме отчета о воспроизводстве лесов и лесоразведении
    FORESTRY_REGULATIONS='forestryRegulations' # Лесохозяйственный регламент лесничества
    PROJ_DOC_FOREST_SITE='projDocForestSite' # Проектная документация лесного участка
    INSPECTION_FINAL_FORESTS_REPORT='inspectionFinalForestsReport' # Акт заключительного осмотра лесосеки
    NOTIFICATION_ACT_ZOL_REJECT='notificationActZolReject' # Уведомление об отказе в приеме извещения об окончании лесосечных работ
    DOC_THE_BASIS_EMERGE_OWNERSHIP_OF_TI='docTheBasisEmergeOwnershipOfTi' # Документ-основание возникновения у владельцев объектов лесоперерабатывающей инфраструктуры права собственности или иного законного основания владения объектами лесоперерабатывающей инфраструктуры
    NOTIFICATION_FIXED_TECHNICAL_ERRO='notificationFixedTechnicalErro' # Уведомление об исправлении технической ошибки
    DOCUMENT_BASIS_USE_OF_FOREST_AREA='documentBasisUseOfForestArea' # Документ, являющийся основанием для использования лесного участка, в том числе в рамках приоритетных инвестиционных проектов в области освоения лесов
    REPORT_ON_WOOD_AND_PRODUCTS='reportOnWoodAndProducts' # Отчет о древесине и продукции ее переработки
    NOTIFICATION_ACCEPT_FOREST_REPROD='notificationAcceptForestReprod' # Извещение о приеме отчета о воспроизводстве лесов и лесоразведении
    STATE_FOREST_REGISTER_EXTRACT_PART='stateForestRegisterExtractPart' # Выписка из государственного лесного реестра об участковом лесничестве
    EXTRACT_EGRNZOUIT='extractEGRNZOUIT' # Выписка из ЕГРН о зоне с особыми условиями использования территорий
    ABOLITION_PRECINCT_FORESTRY_LANDS='abolitionPrecinctForestryLands' # Приказ об упразднении участкового лесничества на землях населенных пунктов
    STATE_FOREST_REGISTER_FOREST_PART='stateForestRegisterForestPart' # Выписка из государственного лесного реестра о лесном участке
    ORDER_BOUNDARY_FORESTRY_OOPT='orderBoundaryForestryOOPT' # Приказ об установлении границ лесничества на землях особо охраняемых природных территорий
    CORRECT_ERROR_IN_GLR_PIL_TECH_REQUES='correctErrorInGlrPilTechReques' # Исправление технической ошибки в сведениях ГЛР использования лесов
    CONTRACT_OF_WOOD='contractOfWood' # Договор, по которому приобретается или отчуждается древесина и продукция ее переработки
    POZVL_REGYSTRY_ERROR_XML='pozvlRegystryErrorXml' # Документ с изменениями для РО


class FarmsKindEType(str, Enum):
    """FarmsKindEType -- Х
    о
    з
    я
    й
    с
    т
    в
    а
    
    """
    CONIFEROUS='coniferous' # Хвойное
    SOFT_LEAVED='softLeaved' # Мягколиственное
    HARD_WOOD='hardWood' # Твердолиственное


class FellingForestKindEType(str, Enum):
    """FellingForestKindEType -- Ф
    о
    р
    м
    а
    р
    у
    б
    к
    и
    
    """
    CLEAR_FELLING='clearFelling' # Сплошная рубка
    SELECTIVE_FELLING='selectiveFelling' # Выборочная рубка


class ForestryActivitiesKindEType(str, Enum):
    """ForestryActivitiesKindEType -- Л
    е
    с
    о
    х
    о
    з
    я
    й
    с
    т
    в
    е
    н
    н
    ы
    е
    м
    е
    р
    о
    п
    р
    и
    я
    т
    и
    я
    
    """
    _2_3040='23040' # Рубка лесных насаждений в целях регулирования породного и возрастного составов лесных насаждений, зараженных вредными организмами
    _4_1097_1='41097.1' # Резерв
    _5_3145='53145' # Химическая обработка почвы гербицидами
    _5_3146='53146' # Обработка почвы огневым способом
    _4_1101_104='41101.104' # Резерв
    _4_10101='410101' # Рубки для создания объектов, не связанных с лесной инфраструктурой
    _5_1138_142='51138.142' # Резерв
    _3_1085_88='31085.88' # Резерв
    _0_0989='00989' # Узколесосечные рубки
    _0_0988='00988' # Огараживание муравейников
    _0_0987='00987' # Запрет пастьбы скота
    _1_2011='12011' # Равномерно-постепенная рубка
    _1_2010='12010' # Длительно-постепенная рубка
    _0_0986='00986' # Выпас сельскохозяйственных животных
    _2_3041_49='23041.49' # Резерв
    _1_2013='12013' # Завершающий прием постепенных рубок
    _1_2012='12012' # Чересполосная постепенная рубка
    _1_2019='12019' # Добровольно-выборочная рубка
    _1_2018='12018' # Группово-выборочная рубка
    _2_3034='23034' # Проведение обследований очагов вредных организмов
    _2_3035_38='23035.38' # Резерв
    _3_2092='32092' # Рыхление верхних слоев почвы
    _2_3039='23039' # Уничтожение или подавление численности вредных организмов
    _3_2090='32090' # Посев сидератов
    _9_1250_252='91250.252' # Резерв
    _3_2091='32091' # Частичное снятие мохового покрова
    _2_2033='22033' # Лесопатологическое обследование
    _3_3054='33054' # Улучшение условий обитания и размножения насекомоядных птиц и других насекомоядных животных
    _5_1152_156='51152.156' # Резерв
    _3_3050='33050' # Применение пестицидов и биологических средств защиты леса для предотвращения появления очагов вредных организмов
    _7_1203_212='71203.212' # Резерв
    _3_3057='33057' # Использование феромонов
    _3_3055='33055' # Охрана местообитаний, выпуск, расселение и интродукция насекомых-энтомофагов
    _3_3056='33056' # Посев травянистых нектароносных растений
    _3_2093_95='32093.95' # Резерв
    _1_2009='12009' # Группово-постепенная рубка
    _3_3049='33049' # Лечение деревьев
    _9_1257_26='91257.26' # Резерв
    _1_2008='12008' # Постепенные рубки
    _5_3127_131='53127.131' # Резерв
    _6_1166_17='61166.17' # Резерв
    _2_2029_32='22029.32' # Резерв
    _7_1189='71189' # Ремонт мостов
    _1_2014_17='12014.17' # Резерв
    _7_1187='71187' # Ремонт лесных дорог
    _7_1188='71188' # Строительство мостов
    _7_1185='71185' # Устройство пожарных водоемов и подъездов к источникам противопожарного водоснабжения
    _7_1186='71186' # Строительство лесных дорог
    _7_1183='71183' # Создание противопожарных разрывов
    _7_1184='71184' # Создание и содержание противопожарных заслонов
    _7_1181='71181' # Создание минерализованных полос
    _7_1182='71182' # Уход за минерализованными полосами
    _7_1180='71180' # Установка аншлагов
    _1_1001='11001' # Сплошная рубка с последующим лесовосстановлением
    _5_1106='51106' # Сохранение подроста и молодняка
    _5_1105='51105' # Естественное восстановление лесов вследствие природных процессов
    _1_1002='11002' # Сплошная рубка с предварительным лесовосстановлением
    _5_1108='51108' # Уход за подростом (молодняком)
    _5_1107='51107' # Минерализация почвы
    _5_1109='51109' # Огораживание участка
    _7_1198='71198' # Строительство и реконструкция пунктов сосредоточения противопожарного инвентаря
    _3_1083='31083' # Комбинированный уход
    _7_1199='71199' # Установка шлагбаумов, устройство преград, обеспечивающих ограничение пребывания граждан в лесах в целях обеспечения пожарной безопасности
    _3_1082='31082' # Рубка в подросте
    _7_1196='71196' # Снижение природной пожарной опасности лесов путем регулирование породного состава лесных насаждений
    _7_1197='71197' # Проведение профилактического контролируемого противопожарного выжигания хвороста
    _3_1084='31084' # Комплексный уход
    _2_2027='22027' # Рубка аварийных деревьев
    _7_1195='71195' # Проведение работ по гидромелиорации
    _7_1192='71192' # Строительство и реконструкция пожарных наблюдательных пунктов
    _3_1081='31081' # Рубка в подлеске
    _2_2028='22028' # Уборка неликвидной древесины (сухостоя)
    _7_1193='71193' # Прокладка просек, противопожарных разрывов
    _3_1080='31080' # Обрезка сучьев и ветвей
    _7_1190='71190' # Очистка мест рубок
    _7_1191='71191' # Строительство и реконструкция посадочных площадок для самолетов и вертолетов
    _1_2020_24='12020.24' # Резерв
    _5_1111='51111' # Подавление порослевой (корнеотпрысковой) способности деревьев (инъекции арборицидов или окольцовывание)
    _6_1159='61159' # Закладка лесосеменных плантаций
    _5_1110='51110' # Оставление семенных деревьев, куртин и групп
    _6_1158='61158' # Выделение плюсовых деревьев
    _3_1089='31089' # Внесение удобрений
    _6_1157='61157' # Выделение плюсовых насаждений
    _5_1112='51112' # Прочие меры содействия естественному возобновлению
    _5_1117='51117' # Создание лесных культур посадкой
    _5_1116='51116' # Создание лесных культур посевом
    _5_1118='51118' # Создание культур под пологом леса
    _9_1255='91255' # Заготовка ягод
    _9_1256='91256' # Заготовка пищевого сырья
    _2_1026='21026' # Выборочные санитарные рубки
    _9_1253='91253' # Заготовка лекарственного сырья
    _2_1025='21025' # Сплошные санитарные рубки
    _9_1254='91254' # Заготовка орехов
    _3_3057_59='33057.59' # Резерв
    _3_1072='31072' # Мероприятия по обновлению целевых ландшафтных насаждений
    _3_1071='31071' # Ландшафтная рубка для улучшения декоративных качеств
    _3_1073='31073' # Опытные рубки
    _3_1070='31070' # Ландшафтная рубка формирования оптимального пространственного размещения
    _8_1214='81214' # Устройство кострищ
    _8_1215='81215' # Строительство сети троп
    _3_1079='31079' # Уход за опушками леса
    _8_1216='81216' # Ремонт сети троп
    _8_1217='81217' # Установка кабин переодевания
    _5_1124='51124' # Комбинированное лесовосстановление
    _8_1213='81213' # Обустройство мест источников питьевой воды
    _5_1123='51123' # Дополнение лесных культур
    _6_1165='61165' # Закладка популяционно-экологических культур
    _6_1164='61164' # Закладка географических культур
    _6_1163='61163' # Закладка постоянных лесосеменных участков
    _6_1162='61162' # Закладка испытательных культур
    _6_1161='61161' # Закладка маточных плантаций
    _6_1160='61160' # Закладка архивов клонов плюсовых деревьев
    _9_1248='91248' # Краткосрочная подсочка
    _9_1249='91249' # Заготовка пневого осмола
    _9_1247='91247' # Назначить в подсочку
    _3_1061='31061' # Рубки прочистки
    _3_1060='31060' # Рубки осветления
    _3_1063='31063' # Проходные рубки
    _3_1062='31062' # Рубки прореживания
    _3_1069='31069' # Ландшафтная рубка формирования породного состава
    _3_1068='31068' # Ландшафтная рубка
    _3_1065='31065' # Рубка переформирования лесных насаждений
    _5_1133='51133' # Сплошная или полосная (частичная) расчистка площади
    _5_1132='51132' # Маркировка (обозначение) линий или направления будущих рядов лесных культур или полос обработки почвы и обозначение мест, опасных для работы техники
    _3_1064='31064' # Рубки реконструкции
    _5_1135='51135' # Планировка поверхности
    _3_1067='31067' # Рубка сохранения лесных насаждений
    _5_1134='51134' # Корчёвка пней
    _3_1066='31066' # Рубка обновления лесных насаждений
    _5_1137='51137' # Проведение осушительных мероприятий
    _5_1136='51136' # Предварительная борьба с вредными почвенными организмами
    _9_1277='91277' # Осушение сенокоса
    _9_1278='91278' # Ремонт мелиоративных каналов (канав)
    _9_1275='91275' # Расчистка родников
    _4_1096='41096' # Рубка для создания лесной инфраструктуры
    _9_1276='91276' # Поверхностное улучшение сенокоса
    _9_1279='91279' # Биотехнические мероприятия
    _9_1270='91270' # Срезка кочек
    _5_1113_115='51113.115' # Резерв
    _8_1229='81229' # Устройство переходов
    _9_1273='91273' # Ремонт лесной мебели
    _9_1274='91274' # Устройство мусоросборников
    _9_1271='91271' # Срезка кустарников
    _7_2194='72194' # Прочистка квартальных просек и границ
    _9_1272='91272' # Коренное улучшение сенокоса
    _8_1232='81232' # Устройство площадки
    _5_1144='51144' # Частичная механическая обработка почвы
    _8_1233='81233' # Оформление входа
    _5_1143='51143' # Сплошная механическая обработка почвы
    _8_1234='81234' # Благоустройство
    _8_1235='81235' # Создание экологического маршрута
    _5_1148='51148' # Устройство гряд
    _5_1147='51147' # Вспашка полосами
    _8_1230='81230' # Расчистка водоема
    _8_1231='81231' # Расчистка троп
    _5_1149='51149' # Полосное рыхление, нарездка борозд
    _9_1266='91266' # Мелиорация участков лесного фонда
    _9_1267='91267' # Расчистка площадей
    _9_1264='91264' # Рекультивация для целей рекреационного использования
    _9_1265='91265' # Уход за плантациями
    _9_1268='91268' # Отвод поверхностных застойных вод
    _9_1269='91269' # Подсев трав
    _8_1218='81218' # Расчистка полян
    _9_1262='91262' # Создание кормовых полей
    _8_1219='81219' # Прокашивание полян
    _9_1263='91263' # Устройство подкормочных площадок
    _9_1261='91261' # Уход за плодоносящими деревьями
    _8_1225='81225' # Оборудование стоянок автотранспорта
    _5_1151='51151' # Обработка площадками или прерывистыми полосами
    _8_1226='81226' # Регулирование рекреационных нагрузки
    _5_1150='51150' # Нарезка выемочно-насыпных террас
    _8_1227='81227' # Обустройство пляжей
    _8_1228='81228' # Уборка мусора
    _8_1221='81221' # Устройство укрытий от непогоды
    _8_1222='81222' # Строительство беседок
    _1_1003_7='11003.7' # Резерв
    _8_1223='81223' # Установка лесной мебели
    _8_1224='81224' # Оборудование стоянок туристов
    _8_1220='81220' # Оформление видовой точки
    _6_2172='62172' # Уход за плюсовыми насаждениями
    _6_2173='62173' # Уход за лесосеменными плантациями, маточными плантациями, архивами клонов плюсовых деревьев, постоянными лесосеменными участками
    _6_2174='62174' # Уход за испытательными, географическими, популяционно-экологическими культурами как объектами лесного семеноводства
    _7_1202='71202' # Установка и размещение стендов, и других знаков и указателей, содержащих информацию о мерах пожарной безопасности в лесах
    _7_1200='71200' # Устройство мест отдыха
    _7_1201='71201' # Устройство лиственных опушек
    _8_1280_29='81280.29' # Резерв
    _6_2171='62171' # Уход за плюсовыми деревьями
    _0_0999='00999' # Сплошная рубка
    _0_0998='00998' # Рубка редин и единичных деревьев
    _0_0993='00993' # Строительство детских площадок
    _0_0992='00992' # Заготовка технического сырья
    _0_0991='00991' # Рубка с сохранением подроста и молодняка
    _0_0990='00990' # Рубка по состоянию
    _0_0997='00997' # Разрубка просек
    _0_0996='00996' # Закладка лесного питомника
    _0_0995='00995' # Закладка постоянного лесосеменного участка
    _6_2175_179='62175.179' # Резерв
    _0_0994='00994' # Посадка без подготовки почвы
    _3_1074_78='31074.78' # Резерв
    _5_3119='53119' # Создание ландшафтных культур
    _3_3051_53='33051.53' # Резерв
    _5_3121='53121' # Создание лесных полос путем посадки крупномерного посадочного материала
    _5_3122='53122' # Создание лесных культур при реконструкции насаждений
    _5_3120='53120' # Создание культур декоративных
    _5_3125='53125' # Агротехнический уход
    _5_3126='53126' # Лесоводственный уход
    _8_1236_246='81236.246' # Резерв


class ForestryKindEType(str, Enum):
    """ForestryKindEType -- Л
    е
    с
    н
    и
    ч
    е
    с
    т
    в
    а
    
    """
    _1_4_15='14:15' # Нюрбинское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_14='14:14' # Нерюнгринское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_13='14:13' # Намское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_12='14:12' # Мирнинское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_19='14:19' # Таттинское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_18='14:18' # Сунтарское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_17='14:17' # Сангарское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_16='14:16' # Олекминское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_11='14:11' # Мегино-Кангаласское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_10='14:10' # Ленское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_26='14:26' # ГПЗ Олекминский, Республика Саха (Якутия), (Земли особо охраняемых природных территорий)
    _1_4_25='14:25' # Якутское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_24='14:24' # Чурапчинское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_23='14:23' # Хангаласское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_29='14:29' # Алданское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_28='14:28' # Абыйское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_27='14:27' # ГПЗ Усть-Ленский, Республика Саха (Якутия), (Земли особо охраняемых природных территорий)
    _1_4_22='14:22' # Усть-Майское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_21='14:21' # Усть-Алданское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_20='14:20' # Томпонское, Республика Саха (Якутия), (Земли лесного фонда)
    _4_9_1='49:1' # Берелехское, Магаданская область, (Земли лесного фонда)
    _4_9_2='49:2' # Магаданское, Магаданская область, (Земли лесного фонда)
    _4_9_3='49:3' # Омсукчанское, Магаданская область, (Земли лесного фонда)
    _4_9_4='49:4' # Оротуканское, Магаданская область, (Земли лесного фонда)
    _4_9_5='49:5' # Палаткинское, Магаданская область, (Земли лесного фонда)
    _4_9_6='49:6' # Сеймчанское, Магаданская область, (Земли лесного фонда)
    _4_9_7='49:7' # Тенькинское, Магаданская область, (Земли лесного фонда)
    _4_9_8='49:8' # ГПЗ Магаданский, Магаданская область, (Земли особо охраняемых природных территорий)
    _4_9_9='49:9' # МО городской округ "Г.Магадан", Магаданская область, (Земли населенных пунктов)
    _5_1_11='51:11' # ГПБЗ Лапландский, Мурманская область, (Земли особо охраняемых природных территорий)
    _5_1_12='51:12' # ГПЗ Пасвик, Мурманская область, (Земли особо охраняемых природных территорий)
    _5_1_10='51:10' # Терское, Мурманская область, (Земли лесного фонда)
    _5_1_15='51:15' # г.Кандалакша, Мурманская область, (Земли населенных пунктов)
    _5_1_16='51:16' # г.Кировск, Мурманская область, (Земли населенных пунктов)
    _5_1_13='51:13' # г.Апатиты, Мурманская область, (Земли населенных пунктов)
    _3_6_1='36:1' # Аннинское, Воронежская область, (Земли лесного фонда)
    _5_1_14='51:14' # г.Заозерск, Мурманская область, (Земли населенных пунктов)
    _3_6_2='36:2' # Бобровское, Воронежская область, (Земли лесного фонда)
    _5_1_19='51:19' # г.Островной, Мурманская область, (Земли населенных пунктов)
    _3_6_3='36:3' # Богучарское, Воронежская область, (Земли лесного фонда)
    _3_6_4='36:4' # Бутурлиновское, Воронежская область, (Земли лесного фонда)
    _5_1_17='51:17' # г.Мончегорск, Мурманская область, (Земли населенных пунктов)
    _3_6_5='36:5' # Воронежское, Воронежская область, (Земли лесного фонда)
    _5_1_18='51:18' # г.Оленегорск, Мурманская область, (Земли населенных пунктов)
    _3_6_6='36:6' # Воронцовское, Воронежская область, (Земли лесного фонда)
    _5_1_22='51:22' # г.Североморск, Мурманская область, (Земли населенных пунктов)
    _5_1_23='51:23' # г.Скалистый, Мурманская область, (Земли населенных пунктов)
    _5_1_20='51:20' # г.Полярные Зори, Мурманская область, (Земли населенных пунктов)
    _5_1_21='51:21' # г.Полярный, Мурманская область, (Земли населенных пунктов)
    _5_1_26='51:26' # Кольский, Мурманская область, (Земли населенных пунктов)
    _5_1_27='51:27' # Ловозерский, Мурманская область, (Земли населенных пунктов)
    _5_1_24='51:24' # г.Снежногорск, Мурманская область, (Земли населенных пунктов)
    _5_1_25='51:25' # Ковдорский, Мурманская область, (Земли населенных пунктов)
    _5_1_28='51:28' # Мурманское городское лесничество г. Мурманск, Мурманская область, (Земли населенных пунктов)
    _5_1_29='51:29' # п. Видяево, Мурманская область, (Земли населенных пунктов)
    _6_3_11='63:11' # Похвистневское, Самарская область, (Земли лесного фонда)
    _6_3_10='63:10' # Ново-Буянское, Самарская область, (Земли лесного фонда)
    _6_3_13='63:13' # Сергиевское, Самарская область, (Земли лесного фонда)
    _6_3_12='63:12' # Рачейское, Самарская область, (Земли лесного фонда)
    _3_6_7='36:7' # Давыдовское, Воронежская область, (Земли лесного фонда)
    _5_1_30='51:30' # Печенгский, Мурманская область, (Земли населенных пунктов)
    _3_6_8='36:8' # Донское, Воронежская область, (Земли лесного фонда)
    _3_6_9='36:9' # Калачеевское, Воронежская область, (Земли лесного фонда)
    _5_1_31='51:31' # Терский, Мурманская область, (Земли населенных пунктов)
    _3_8_60='38:60' # МО города Братска, Иркутская область, (Земли населенных пунктов)
    _3_8_69='38:69' # МО Мамско-Чуйского района, Иркутская область, (Земли населенных пунктов)
    _3_8_62='38:62' # МО Жигаловский район, Иркутская область, (Земли населенных пунктов)
    _3_8_61='38:61' # МО города Усолье-Сибирское, Иркутская область, (Земли населенных пунктов)
    _3_8_64='38:64' # МО Казачинско-Ленский район, Иркутская область, (Земли населенных пунктов)
    _3_8_63='38:63' # МО Заларинский район, Иркутская область, (Земли населенных пунктов)
    _3_8_66='38:66' # МО Качугский район, Иркутская область, (Земли населенных пунктов)
    _3_8_65='38:65' # МО Катангский район, Иркутская область, (Земли населенных пунктов)
    _3_8_68='38:68' # МО Куйтунский район, Иркутская область, (Земли населенных пунктов)
    _3_8_67='38:67' # МО Киренский район, Иркутская область, (Земли населенных пунктов)
    _2_3_8='23:8' # Кавказское, Краснодарский край, (Земли лесного фонда)
    _2_3_7='23:7' # Джубгское, Краснодарский край, (Земли лесного фонда)
    _2_3_6='23:6' # Горячеключевское, Краснодарский край, (Земли лесного фонда)
    _2_3_5='23:5' # Геленджикское, Краснодарский край, (Земли лесного фонда)
    _2_3_4='23:4' # Белореченское, Краснодарский край, (Земли лесного фонда)
    _2_3_3='23:3' # Афипское, Краснодарский край, (Земли лесного фонда)
    _2_3_2='23:2' # Апшеронское, Краснодарский край, (Земли лесного фонда)
    _2_3_1='23:1' # Абинское, Краснодарский край, (Земли лесного фонда)
    _3_8_59='38:59' # МО города Бодайбо и района, Иркутская область, (Земли населенных пунктов)
    _3_8_58='38:58' # МО город Тулун, Иркутская область, (Земли населенных пунктов)
    _3_8_51='38:51' # МО "Осинский район", Иркутская область, (Земли населенных пунктов)
    _3_8_50='38:50' # МО "Нукутский район", Иркутская область, (Земли населенных пунктов)
    _3_8_53='38:53' # МО Балаганский район, Иркутская область, (Земли населенных пунктов)
    _3_8_52='38:52' # МО "Эхирит-Булагатский р-он", Иркутская область, (Земли населенных пунктов)
    _3_8_55='38:55' # МО город Усть-Илимск, Иркутская область, (Земли населенных пунктов)
    _3_8_54='38:54' # МО Братский район, Иркутская область, (Земли населенных пунктов)
    _3_8_57='38:57' # МО город Саянск, Иркутская область, (Земли населенных пунктов)
    _3_8_56='38:56' # МО город Иркутск, Иркутская область, (Земли населенных пунктов)
    _3_8_48='38:48' # МО "Баяндаевский район", Иркутская область, (Земли населенных пунктов)
    _3_8_47='38:47' # МО "Аларский район", Иркутская область, (Земли населенных пунктов)
    _3_8_49='38:49' # МО "Боханский район", Иркутская область, (Земли населенных пунктов)
    _2_3_9='23:9' # Краснодарское, Краснодарский край, (Земли лесного фонда)
    _3_8_40='38:40' # НП Прибайкальский, Иркутская область, (Земли особо охраняемых природных территорий)
    _3_8_42='38:42' # Шелеховское, Иркутская область, (Земли обороны и безопасности)
    _3_8_41='38:41' # Нижнеудинское, Иркутская область, (Земли обороны и безопасности)
    _3_8_44='38:44' # Зиминское городское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_43='38:43' # Ангарское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_46='38:46' # Иркутское городское лесничество, Иркутская область, (Земли населенных пунктов)
    _3_8_45='38:45' # Зиминское районное МО, Иркутская область, (Земли населенных пунктов)
    _3_8_37='38:37' # Шелеховское, Иркутская область, (Земли лесного фонда)
    _3_8_36='38:36' # Чунское, Иркутская область, (Земли лесного фонда)
    _3_8_39='38:39' # ГПЗ Витимский, Иркутская область, (Земли особо охраняемых природных территорий)
    _3_8_38='38:38' # ГПЗ Байкало-Ленский, Иркутская область, (Земли особо охраняемых природных территорий)
    _3_8_31='38:31' # Усольское, Иркутская область, (Земли лесного фонда)
    _3_8_30='38:30' # Тулунское, Иркутская область, (Земли лесного фонда)
    _3_8_33='38:33' # Усть-Ордынское, Иркутская область, (Земли лесного фонда)
    _3_8_32='38:32' # Усть-Кутское, Иркутская область, (Земли лесного фонда)
    _3_8_35='38:35' # Черемховское, Иркутская область, (Земли лесного фонда)
    _3_8_34='38:34' # Усть-Удинское, Иркутская область, (Земли лесного фонда)
    _1_0_2='10:2' # Калевальское, Республика Карелия, (Земли лесного фонда)
    _2_6_37='26:37' # Нефтекумское, Ставропольский край, (Земли населенных пунктов)
    _1_0_1='10:1' # Беломорское, Республика Карелия, (Земли лесного фонда)
    _2_6_38='26:38' # Новоалександровское, Ставропольский край, (Земли населенных пунктов)
    _2_6_35='26:35' # Минераловодское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_36='26:36' # Невинномысское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_39='26:39' # Новоселицкое, Ставропольский край, (Земли населенных пунктов)
    _1_0_9='10:9' # Муезерское, Республика Карелия, (Земли лесного фонда)
    _2_6_30='26:30' # Красногвардейское, Ставропольский край, (Земли населенных пунктов)
    _1_0_8='10:8' # Медвежьегорское, Республика Карелия, (Земли лесного фонда)
    _1_0_7='10:7' # Лоухское, Республика Карелия, (Земли лесного фонда)
    _1_0_6='10:6' # Лахденпохское, Республика Карелия, (Земли лесного фонда)
    _2_6_33='26:33' # Лермонтовское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _1_0_5='10:5' # Костомукшское, Республика Карелия, (Земли лесного фонда)
    _2_6_34='26:34' # Минераловодское, Ставропольский край, (Земли населенных пунктов)
    _1_0_4='10:4' # Кондопожское, Республика Карелия, (Земли лесного фонда)
    _2_6_31='26:31' # Курское, Ставропольский край, (Земли населенных пунктов)
    _1_0_3='10:3' # Кемское, Республика Карелия, (Земли лесного фонда)
    _2_6_32='26:32' # Левокумское, Ставропольский край, (Земли населенных пунктов)
    _1_4_59='14:59' # Хангаласское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_26='38:26' # Падунское, Иркутская область, (Земли лесного фонда)
    _1_4_58='14:58' # Усть-Янское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_25='38:25' # Осинское, Иркутская область, (Земли лесного фонда)
    _1_4_57='14:57' # Усть-Майское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_28='38:28' # Слюдянское, Иркутская область, (Земли лесного фонда)
    _1_4_56='14:56' # Усть-Алданское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_27='38:27' # Северное, Иркутская область, (Земли лесного фонда)
    _3_8_29='38:29' # Тайшетское, Иркутская область, (Земли лесного фонда)
    _1_4_51='14:51' # Оленекское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_50='14:50' # Олекминское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_20='38:20' # Мамское, Иркутская область, (Земли лесного фонда)
    _1_4_55='14:55' # Томпонское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_22='38:22' # Нижнеудинское, Иркутская область, (Земли лесного фонда)
    _1_4_54='14:54' # Таттинское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_21='38:21' # Нижнеилимское, Иркутская область, (Земли лесного фонда)
    _1_4_53='14:53' # Сунтарское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_24='38:24' # Ольхонское, Иркутская область, (Земли лесного фонда)
    _1_4_52='14:52' # Средне-Колымское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_23='38:23' # Нукутское, Иркутская область, (Земли лесного фонда)
    _2_6_48='26:48' # Шпаковское, Ставропольский край, (Земли населенных пунктов)
    _2_6_46='26:46' # Труновское, Ставропольский край, (Земли населенных пунктов)
    _2_6_47='26:47' # Туркменское, Ставропольский край, (Земли населенных пунктов)
    _2_6_40='26:40' # Петровское, Ставропольский край, (Земли населенных пунктов)
    _2_6_41='26:41' # Предгорный, Ставропольский край, (Земли населенных пунктов)
    _2_6_44='26:44' # Ставропольское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_45='26:45' # Степновское, Ставропольский край, (Земли населенных пунктов)
    _2_6_42='26:42' # Пятигорское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_43='26:43' # Советское, Ставропольский край, (Земли населенных пунктов)
    _3_8_15='38:15' # Катангское, Иркутская область, (Земли лесного фонда)
    _3_8_14='38:14' # Казачинско-Ленское, Иркутская область, (Земли лесного фонда)
    _3_8_17='38:17' # Киренское, Иркутская область, (Земли лесного фонда)
    _3_8_16='38:16' # Качугское, Иркутская область, (Земли лесного фонда)
    _3_8_19='38:19' # Куйтунское, Иркутская область, (Земли лесного фонда)
    _3_8_18='38:18' # Кировское, Иркутская область, (Земли лесного фонда)
    _1_4_62='14:62' # Якутское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_61='14:61' # Эвено-Бытантайское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_60='14:60' # Чурапчинское, Республика Саха (Якутия), (Земли населенных пунктов)
    _3_8_11='38:11' # Зиминское, Иркутская область, (Земли лесного фонда)
    _3_8_10='38:10' # Заларинское, Иркутская область, (Земли лесного фонда)
    _3_8_13='38:13' # Иркутское, Иркутская область, (Земли лесного фонда)
    _3_8_12='38:12' # Илимское, Иркутская область, (Земли лесного фонда)
    _2_6_15='26:15' # Апанасенковское, Ставропольский край, (Земли населенных пунктов)
    _2_6_16='26:16' # Арзгирское, Ставропольский край, (Земли населенных пунктов)
    _2_6_13='26:13' # Александровское, Ставропольский край, (Земли населенных пунктов)
    _2_6_14='26:14' # Андроповское, Ставропольский край, (Земли населенных пунктов)
    _2_6_19='26:19' # г. Буденновск, Ставропольский край, (Земли населенных пунктов)
    _2_6_17='26:17' # Благодарненское, Ставропольский край, (Земли населенных пунктов)
    _2_6_18='26:18' # Будённовское, Ставропольский край, (Земли населенных пунктов)
    _2_6_11='26:11' # Нижне-Кумское, Ставропольский край, (Земли лесного фонда)
    _2_6_12='26:12' # Ставропольское, Ставропольский край, (Земли лесного фонда)
    _2_6_10='26:10' # Невинномысское, Ставропольский край, (Земли лесного фонда)
    _1_4_37='14:37' # Вилюйское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_36='14:36' # Верхоянское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_35='14:35' # Верхне-Колымское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_34='14:34' # Верхне-Вилюйское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_39='14:39' # Жиганское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_38='14:38' # Горный, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_33='14:33' # Булунское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_32='14:32' # Анабарское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_31='14:31' # Амгинское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_30='14:30' # Аллайховское, Республика Саха (Якутия), (Земли населенных пунктов)
    _2_6_26='26:26' # Ипатовское, Ставропольский край, (Земли населенных пунктов)
    _2_6_27='26:27' # Кировское, Ставропольский край, (Земли населенных пунктов)
    _2_6_24='26:24' # Железноводское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_25='26:25' # Изобильненское, Ставропольский край, (Земли населенных пунктов)
    _2_6_28='26:28' # Кисловодское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_29='26:29' # Кочубеевское, Ставропольский край, (Земли населенных пунктов)
    _2_6_22='26:22' # Грачёвское, Ставропольский край, (Земли населенных пунктов)
    _2_6_23='26:23' # Ессентукскское городское лесничество, Ставропольский край, (Земли населенных пунктов)
    _2_6_20='26:20' # г. Георгиевск, Ставропольский край, (Земли населенных пунктов)
    _2_6_21='26:21' # Георгиевское, Ставропольский край, (Земли населенных пунктов)
    _1_4_48='14:48' # Нюрбинский, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_47='14:47' # Нижне-Колымское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_46='14:46' # Нерюнгринское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_45='14:45' # Намское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_49='14:49' # Оймяконское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_40='14:40' # Кобяйское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_44='14:44' # Момское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_43='14:43' # Мирнинское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_42='14:42' # Мегино-Кангаласское, Республика Саха (Якутия), (Земли населенных пунктов)
    _1_4_41='14:41' # Ленское, Республика Саха (Якутия), (Земли населенных пунктов)
    _2_1='2:1' # Абзелиловское, Республика Башкортостан, (Земли лесного фонда)
    _2_2='2:2' # Авзянское, Республика Башкортостан, (Земли лесного фонда)
    _2_3='2:3' # Альшеевское, Республика Башкортостан, (Земли лесного фонда)
    _2_4='2:4' # Архангельское, Республика Башкортостан, (Земли лесного фонда)
    _2_5='2:5' # Аскинское, Республика Башкортостан, (Земли лесного фонда)
    _2_6='2:6' # Баймакское, Республика Башкортостан, (Земли лесного фонда)
    _2_7='2:7' # Белебеевское, Республика Башкортостан, (Земли лесного фонда)
    _2_8='2:8' # Белокатайское, Республика Башкортостан, (Земли лесного фонда)
    _2_9='2:9' # Белорецкое, Республика Башкортостан, (Земли лесного фонда)
    _4_13='4:13' # НП Сайлюгемский, Республика Алтай, (Земли особо охраняемых природных территорий)
    _4_14='4:14' # г.Горно-Алтайск, Республика Алтай, (Земли населенных пунктов)
    _4_15='4:15' # Кош-Агачское, Республика Алтай, (Земли населенных пунктов)
    _4_16='4:16' # Майминское, Республика Алтай, (Земли населенных пунктов)
    _4_17='4:17' # Онгудайское, Республика Алтай, (Земли населенных пунктов)
    _4_18='4:18' # Турочакское, Республика Алтай, (Земли населенных пунктов)
    _4_19='4:19' # Улаганское, Республика Алтай, (Земли населенных пунктов)
    _4_10='4:10' # Шебалинское, Республика Алтай, (Земли лесного фонда)
    _4_11='4:11' # ГПБЗ Катунский, Республика Алтай, (Земли особо охраняемых природных территорий)
    _4_12='4:12' # ГПЗ Алтайский, Республика Алтай, (Земли особо охраняемых природных территорий)
    _7_2_8='72:8' # Заводоуковское, Тюменская область, (Земли лесного фонда)
    _7_2_7='72:7' # Голышмановское, Тюменская область, (Земли лесного фонда)
    _7_2_9='72:9' # Исетское, Тюменская область, (Земли лесного фонда)
    _7_2_2='72:2' # Армизонское, Тюменская область, (Земли лесного фонда)
    _7_2_1='72:1' # Абатское, Тюменская область, (Земли лесного фонда)
    _7_2_4='72:4' # Бердюжское, Тюменская область, (Земли лесного фонда)
    _7_2_3='72:3' # Аромашевское, Тюменская область, (Земли лесного фонда)
    _7_2_6='72:6' # Викуловское, Тюменская область, (Земли лесного фонда)
    _7_2_5='72:5' # Вагайское, Тюменская область, (Земли лесного фонда)
    _4_24='4:24' # Шебалинское, Республика Алтай, (Земли населенных пунктов)
    _4_20='4:20' # Усть-Канское, Республика Алтай, (Земли населенных пунктов)
    _4_21='4:21' # Усть-Коксинское, Республика Алтай, (Земли населенных пунктов)
    _4_22='4:22' # Чемальское, Республика Алтай, (Земли населенных пунктов)
    _4_23='4:23' # Чойское, Республика Алтай, (Земли населенных пунктов)
    _3_7_1='37:1' # Вичугское, Ивановская область, (Земли лесного фонда)
    _3_7_2='37:2' # Заволжское, Ивановская область, (Земли лесного фонда)
    _3_7_3='37:3' # Ивановское, Ивановская область, (Земли лесного фонда)
    _3_7_4='37:4' # Ильинское, Ивановская область, (Земли лесного фонда)
    _3_7_5='37:5' # Кинешемское, Ивановская область, (Земли лесного фонда)
    _3_7_6='37:6' # Пучежское, Ивановская область, (Земли лесного фонда)
    _3_7_7='37:7' # Тейковское, Ивановская область, (Земли лесного фонда)
    _3_7_8='37:8' # Фурмановское, Ивановская область, (Земли лесного фонда)
    _3_7_9='37:9' # Шуйское, Ивановская область, (Земли лесного фонда)
    _2_4_7='24:7' # Большемуртинское, Красноярский край, (Земли лесного фонда)
    _2_4_6='24:6' # Богучанское, Красноярский край, (Земли лесного фонда)
    _2_4_5='24:5' # Боготольское, Красноярский край, (Земли лесного фонда)
    _2_4_4='24:4' # Балахтинское, Красноярский край, (Земли лесного фонда)
    _2_4_3='24:3' # Байкитское, Красноярский край, (Земли лесного фонда)
    _2_4_2='24:2' # Ачинское, Красноярский край, (Земли лесного фонда)
    _2_4_1='24:1' # Абанское, Красноярский край, (Земли лесного фонда)
    _2_4_9='24:9' # Борское, Красноярский край, (Земли лесного фонда)
    _2_4_8='24:8' # Большеулуйское, Красноярский край, (Земли лесного фонда)
    _1_1_1='11:1' # Айкинское, Республика Коми, (Земли лесного фонда)
    _1_1_9='11:9' # Комсомольское, Республика Коми, (Земли лесного фонда)
    _1_1_8='11:8' # Койгородское, Республика Коми, (Земли лесного фонда)
    _1_1_7='11:7' # Кажимское, Республика Коми, (Земли лесного фонда)
    _1_1_6='11:6' # Каджеромское, Республика Коми, (Земли лесного фонда)
    _1_1_5='11:5' # Ижемское, Республика Коми, (Земли лесного фонда)
    _1_1_4='11:4' # Железнодорожное, Республика Коми, (Земли лесного фонда)
    _1_1_3='11:3' # Ертомское, Республика Коми, (Земли лесного фонда)
    _1_1_2='11:2' # Вуктыльское, Республика Коми, (Земли лесного фонда)
    _8_6_6='86:6' # Нефтеюганское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_7='86:7' # Нижневартовское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_4='86:4' # Кондинское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_5='86:5' # Мегионское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_8='86:8' # Няксимвольское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_9='86:9' # Октябрьское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _3_1='3:1' # Ангоянское, Республика Бурятия, (Земли лесного фонда)
    _3_2='3:2' # Бабушкинское, Республика Бурятия, (Земли лесного фонда)
    _3_3='3:3' # Байкальское, Республика Бурятия, (Земли лесного фонда)
    _8_6_2='86:2' # Белоярское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _3_4='3:4' # Баргузинское, Республика Бурятия, (Земли лесного фонда)
    _8_6_3='86:3' # Берёзовское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _3_5='3:5' # Бичурское, Республика Бурятия, (Земли лесного фонда)
    _3_6='3:6' # Буйское, Республика Бурятия, (Земли лесного фонда)
    _8_6_1='86:1' # Аганское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _3_7='3:7' # Верхне-Баргузинское, Республика Бурятия, (Земли лесного фонда)
    _3_8='3:8' # Верхне-Талецкое, Республика Бурятия, (Земли лесного фонда)
    _3_9='3:9' # Витимское, Республика Бурятия, (Земли лесного фонда)
    _3_8_80='38:80' # Усть-Кутское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_82='38:82' # Черемховское районное МО, Иркутская область, (Земли населенных пунктов)
    _3_8_81='38:81' # Черемховское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_84='38:84' # Шелеховское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_83='38:83' # Чунское районное МО, Иркутская область, (Земли населенных пунктов)
    _3_8_71='38:71' # МО Нижнеудинский район, Иркутская область, (Земли населенных пунктов)
    _3_8_70='38:70' # МО Нижнеилимский район, Иркутская область, (Земли населенных пунктов)
    _3_8_73='38:73' # МО Тайшетский район, Иркутская область, (Земли населенных пунктов)
    _3_8_72='38:72' # МО Слюдянский район, Иркутская область, (Земли населенных пунктов)
    _3_8_75='38:75' # МО Усть-Удинскиий район, Иркутская область, (Земли населенных пунктов)
    _3_8_74='38:74' # МО Тулунский район, Иркутская область, (Земли населенных пунктов)
    _3_8_77='38:77' # Свирское МО, Иркутская область, (Земли населенных пунктов)
    _3_8_76='38:76' # Ольхонское районное МО, Иркутская область, (Земли населенных пунктов)
    _3_8_79='38:79' # Усть-Илимское городское лесничество, Иркутская область, (Земли населенных пунктов)
    _3_8_78='38:78' # Усольское районное МО, Иркутская область, (Земли населенных пунктов)
    _7_3_7='73:7' # Майнское, Ульяновская область, (Земли лесного фонда)
    _7_3_6='73:6' # Кузоватовское, Ульяновская область, (Земли лесного фонда)
    _7_3_9='73:9' # Николаевское, Ульяновская область, (Земли лесного фонда)
    _7_3_8='73:8' # Мелекесское, Ульяновская область, (Земли лесного фонда)
    _7_3_1='73:1' # Базарносызганское, Ульяновская область, (Земли лесного фонда)
    _6_3_20='63:20' # Безенчукский, Самарская область, (Земли населенных пунктов)
    _7_3_3='73:3' # Вешкаймское, Ульяновская область, (Земли лесного фонда)
    _6_3_22='63:22' # Большеглушицкий, Самарская область, (Земли населенных пунктов)
    _7_3_2='73:2' # Барышское, Ульяновская область, (Земли лесного фонда)
    _6_3_21='63:21' # Богатовский, Самарская область, (Земли населенных пунктов)
    _7_3_5='73:5' # Карсунское, Ульяновская область, (Земли лесного фонда)
    _6_3_24='63:24' # Борский, Самарская область, (Земли населенных пунктов)
    _7_3_4='73:4' # Инзенское, Ульяновская область, (Земли лесного фонда)
    _6_3_23='63:23' # Большечерниговский, Самарская область, (Земли населенных пунктов)
    _6_3_15='63:15' # Шенталинское, Самарская область, (Земли лесного фонда)
    _6_3_14='63:14' # Ставропольское, Самарская область, (Земли лесного фонда)
    _6_3_17='63:17' # ГПЗ Жигулевский, Самарская область, (Земли особо охраняемых природных территорий)
    _6_3_16='63:16' # Шигонское, Самарская область, (Земли лесного фонда)
    _6_3_19='63:19' # Алексеевский, Самарская область, (Земли населенных пунктов)
    _6_3_18='63:18' # НП Самарская Лука, Самарская область, (Земли особо охраняемых природных территорий)
    _7_5_10='75:10' # Дульдургинское, Забайкальский край, (Земли лесного фонда)
    _7_5_11='75:11' # Ингодинское, Забайкальский край, (Земли лесного фонда)
    _7_5_12='75:12' # Карымское, Забайкальский край, (Земли лесного фонда)
    _7_5_13='75:13' # Красночикойское, Забайкальский край, (Земли лесного фонда)
    _7_5_14='75:14' # Кыринское, Забайкальский край, (Земли лесного фонда)
    _6_3_31='63:31' # Елховский, Самарская область, (Земли населенных пунктов)
    _6_3_30='63:30' # г.Чапаевск, Самарская область, (Земли населенных пунктов)
    _6_3_33='63:33' # Камышленский, Самарская область, (Земли населенных пунктов)
    _6_3_32='63:32' # Исаклинский, Самарская область, (Земли населенных пунктов)
    _6_3_35='63:35' # Кинель-Черкасский, Самарская область, (Земли населенных пунктов)
    _6_3_34='63:34' # Кинельский, Самарская область, (Земли населенных пунктов)
    _6_3_26='63:26' # г.Жигулевск, Самарская область, (Земли населенных пунктов)
    _6_3_25='63:25' # Волжский, Самарская область, (Земли населенных пунктов)
    _6_3_28='63:28' # г.Самара, Самарская область, (Земли населенных пунктов)
    _6_3_27='63:27' # г.Новокуйбышевск, Самарская область, (Земли населенных пунктов)
    _6_3_29='63:29' # г.Тольятти, Самарская область, (Земли населенных пунктов)
    _7_5_26='75:26' # Шилкинское, Забайкальский край, (Земли лесного фонда)
    _7_5_27='75:27' # ГПБЗ Даурский, Забайкальский край, (Земли особо охраняемых природных территорий)
    _7_5_28='75:28' # ГПБЗ Сохондинский, Забайкальский край, (Земли особо охраняемых природных территорий)
    _7_5_29='75:29' # НП Алханай, Забайкальский край, (Земли особо охраняемых природных территорий)
    _6_3_40='63:40' # Нефтегорский, Самарская область, (Земли населенных пунктов)
    _6_3_42='63:42' # Похвистневский, Самарская область, (Земли населенных пунктов)
    _6_3_41='63:41' # Пестравский, Самарская область, (Земли населенных пунктов)
    _6_3_44='63:44' # Сергиевский, Самарская область, (Земли населенных пунктов)
    _6_3_43='63:43' # Приволжский, Самарская область, (Земли населенных пунктов)
    _6_3_46='63:46' # Сызранский, Самарская область, (Земли населенных пунктов)
    _6_3_45='63:45' # Ставропольский, Самарская область, (Земли населенных пунктов)
    _6_3_37='63:37' # Кошкинский, Самарская область, (Земли населенных пунктов)
    _6_3_36='63:36' # Клявлинский, Самарская область, (Земли населенных пунктов)
    _6_3_39='63:39' # Красноярский, Самарская область, (Земли населенных пунктов)
    _6_3_38='63:38' # Красноармейский, Самарская область, (Земли населенных пунктов)
    _8_7_10='87:10' # Чукотский, Чукотский автономный округ, (Земли населенных пунктов)
    _7_5_30='75:30' # НП Чикой, Забайкальский край, (Земли особо охраняемых природных территорий)
    _7_5_31='75:31' # Ингодинское, Забайкальский край, (Земли обороны и безопасности)
    _7_5_32='75:32' # Агинский муниципальный р-он, Забайкальский край, (Земли населенных пунктов)
    _7_5_33='75:33' # Акшинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_34='75:34' # Александровско-Заводский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_35='75:35' # Балейский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_36='75:36' # Борзинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_15='75:15' # Могочинское, Забайкальский край, (Земли лесного фонда)
    _6_0_9='60:9' # Псковское, Псковская область, (Земли лесного фонда)
    _7_5_16='75:16' # Нерчинское, Забайкальский край, (Земли лесного фонда)
    _6_0_8='60:8' # Порховское, Псковская область, (Земли лесного фонда)
    _7_5_17='75:17' # Оленгуйское, Забайкальский край, (Земли лесного фонда)
    _7_5_18='75:18' # Ононское, Забайкальский край, (Земли лесного фонда)
    _7_5_19='75:19' # Петровск-Забайкальское, Забайкальский край, (Земли лесного фонда)
    _6_0_1='60:1' # Бежаницкое, Псковская область, (Земли лесного фонда)
    _6_3_50='63:50' # Шигонский, Самарская область, (Земли населенных пунктов)
    _6_0_3='60:3' # Гдовское, Псковская область, (Земли лесного фонда)
    _6_0_2='60:2' # Великолукское, Псковская область, (Земли лесного фонда)
    _6_0_5='60:5' # Опочецкое, Псковская область, (Земли лесного фонда)
    _6_0_4='60:4' # Невельское, Псковская область, (Земли лесного фонда)
    _6_0_7='60:7' # Плюсское, Псковская область, (Земли лесного фонда)
    _6_0_6='60:6' # Печорское, Псковская область, (Земли лесного фонда)
    _6_3_48='63:48' # Челно-Вершинский, Самарская область, (Земли населенных пунктов)
    _6_3_47='63:47' # Хворостянский, Самарская область, (Земли населенных пунктов)
    _6_3_49='63:49' # Шенталинский, Самарская область, (Земли населенных пунктов)
    _7_5_20='75:20' # Сретенское, Забайкальский край, (Земли лесного фонда)
    _7_5_21='75:21' # Тунгокоченское, Забайкальский край, (Земли лесного фонда)
    _7_5_22='75:22' # Хилокское, Забайкальский край, (Земли лесного фонда)
    _7_5_23='75:23' # Чарское, Забайкальский край, (Земли лесного фонда)
    _7_5_24='75:24' # Чернышевское, Забайкальский край, (Земли лесного фонда)
    _7_5_25='75:25' # Читинское, Забайкальский край, (Земли лесного фонда)
    _7_5_48='75:48' # Могочинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_49='75:49' # Нерчинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_50='75:50' # Нерчинско-Заводский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_51='75:51' # Оловяннинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_52='75:52' # Ононский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_53='75:53' # Петровск-Забайкальский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_54='75:54' # Приаргунский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_55='75:55' # Сретенский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_56='75:56' # Тунгиро-Олекминский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_57='75:57' # Тунгокоченский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_58='75:58' # Улетовский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_37='75:37' # г.Чита, Забайкальский край, (Земли населенных пунктов)
    _7_5_38='75:38' # Газимуро-Заводский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_39='75:39' # Дульдургинский муниципальный р-он, Забайкальский край, (Земли населенных пунктов)
    _7_5_40='75:40' # Забайкальский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_41='75:41' # Каларский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_42='75:42' # Калганский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_43='75:43' # Карымский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_44='75:44' # Краснокаменский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_45='75:45' # Красночикойский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_46='75:46' # Кыринский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_47='75:47' # Могойтуйский муниципальный р-он, Забайкальский край, (Земли населенных пунктов)
    _7_5_59='75:59' # Хилокский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_60='75:60' # Чернышевский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_61='75:61' # Читинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_62='75:62' # Шелопугинский район, Забайкальский край, (Земли населенных пунктов)
    _7_5_63='75:63' # Шилкинский район, Забайкальский край, (Земли населенных пунктов)
    _3_8_1='38:1' # Аларское, Иркутская область, (Земли лесного фонда)
    _3_8_2='38:2' # Ангарское, Иркутская область, (Земли лесного фонда)
    _3_8_3='38:3' # Балаганское, Иркутская область, (Земли лесного фонда)
    _3_8_4='38:4' # Баяндаевское, Иркутская область, (Земли лесного фонда)
    _3_8_5='38:5' # Бирюсинское, Иркутская область, (Земли лесного фонда)
    _3_8_6='38:6' # Бодайбинское, Иркутская область, (Земли лесного фонда)
    _3_8_7='38:7' # Братское, Иркутская область, (Земли лесного фонда)
    _3_8_8='38:8' # Голоустненское, Иркутская область, (Земли лесного фонда)
    _3_8_9='38:9' # Жигаловское, Иркутская область, (Земли лесного фонда)
    _2_5_6='25:6' # Рощинское, Приморский край, (Земли лесного фонда)
    _2_5_5='25:5' # Кавалеровское, Приморский край, (Земли лесного фонда)
    _2_5_4='25:4' # Дальнереченское, Приморский край, (Земли лесного фонда)
    _2_5_3='25:3' # Владивостокское, Приморский край, (Земли лесного фонда)
    _2_5_2='25:2' # Верхне-Перевальнинское, Приморский край, (Земли лесного фонда)
    _2_5_1='25:1' # Арсеньевское, Приморский край, (Земли лесного фонда)
    _2_5_9='25:9' # Тернейское, Приморский край, (Земли лесного фонда)
    _2_5_8='25:8' # Спасское, Приморский край, (Земли лесного фонда)
    _2_5_7='25:7' # Сергеевское, Приморский край, (Земли лесного фонда)
    _6_8_32='68:32' # Мучкапское, Тамбовская область, (Земли населенных пунктов)
    _6_8_31='68:31' # Моршанское, Тамбовская область, (Земли населенных пунктов)
    _6_8_30='68:30' # Мордовское, Тамбовская область, (Земли населенных пунктов)
    _1_2_8='12:8' # Куярское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_36='68:36' # Пичаевское, Тамбовская область, (Земли населенных пунктов)
    _1_2_7='12:7' # Кужерское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_35='68:35' # Петровское, Тамбовская область, (Земли населенных пунктов)
    _1_2_6='12:6' # Куженерское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_34='68:34' # Первомайское, Тамбовская область, (Земли населенных пунктов)
    _1_2_5='12:5' # Кокшайское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_33='68:33' # Никифоровское, Тамбовская область, (Земли населенных пунктов)
    _1_2_4='12:4' # Килемарское, Республика Марий Эл, (Земли лесного фонда)
    _1_2_3='12:3' # Звениговское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_39='68:39' # Сампурское, Тамбовская область, (Земли населенных пунктов)
    _1_2_2='12:2' # Волжское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_38='68:38' # Ржаксинское, Тамбовская область, (Земли населенных пунктов)
    _1_2_1='12:1' # Алексеевское, Республика Марий Эл, (Земли лесного фонда)
    _6_8_37='68:37' # Рассказовское, Тамбовская область, (Земли населенных пунктов)
    _5_6_50='56:50' # Гайский, Оренбургская область, (Земли населенных пунктов)
    _5_6_51='56:51' # Грачевский, Оренбургская область, (Земли населенных пунктов)
    _5_6_52='56:52' # Домбаровский, Оренбургская область, (Земли населенных пунктов)
    _5_6_53='56:53' # Илекский, Оренбургская область, (Земли населенных пунктов)
    _9_12='9:12' # Прикубанский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _5_6_58='56:58' # Матвеевский, Оренбургская область, (Земли населенных пунктов)
    _9_13='9:13' # Урупский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _5_6_59='56:59' # Новоорский, Оренбургская область, (Земли населенных пунктов)
    _9_10='9:10' # Карачаевский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _9_11='9:11' # Малокарачаевский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _5_6_54='56:54' # Кваркенский, Оренбургская область, (Земли населенных пунктов)
    _5_6_55='56:55' # Красногвардейский, Оренбургская область, (Земли населенных пунктов)
    _9_14='9:14' # Усть-Джегутинский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _5_6_56='56:56' # Кувандыкский, Оренбургская область, (Земли населенных пунктов)
    _9_15='9:15' # Хабезский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _5_6_57='56:57' # Курманаевский, Оренбургская область, (Земли населенных пунктов)
    _6_8_43='68:43' # Токаревское, Тамбовская область, (Земли населенных пунктов)
    _6_8_42='68:42' # Тамбовское, Тамбовская область, (Земли населенных пунктов)
    _6_8_41='68:41' # Староюрьевское, Тамбовская область, (Земли населенных пунктов)
    _6_8_40='68:40' # Сосновское, Тамбовская область, (Земли населенных пунктов)
    _6_8_45='68:45' # Уметское, Тамбовская область, (Земли населенных пунктов)
    _6_8_44='68:44' # Уваровское, Тамбовская область, (Земли населенных пунктов)
    _5_6_61='56:61' # Октябрьский, Оренбургская область, (Земли населенных пунктов)
    _5_6_62='56:62' # Оренбургский, Оренбургская область, (Земли населенных пунктов)
    _5_6_63='56:63' # Первомайский, Оренбургская область, (Земли населенных пунктов)
    _5_6_64='56:64' # Переволоцкий, Оренбургская область, (Земли населенных пунктов)
    _1_2_9='12:9' # Мари-Турекское, Республика Марий Эл, (Земли лесного фонда)
    _5_6_60='56:60' # Новосергиевский, Оренбургская область, (Земли населенных пунктов)
    _5_6_69='56:69' # Северный, Оренбургская область, (Земли населенных пунктов)
    _5_6_65='56:65' # Пономаревский, Оренбургская область, (Земли населенных пунктов)
    _5_6_66='56:66' # Сакмарский, Оренбургская область, (Земли населенных пунктов)
    _5_6_67='56:67' # Саракташский, Оренбургская область, (Земли населенных пунктов)
    _5_6_68='56:68' # Светлинский, Оренбургская область, (Земли населенных пунктов)
    _5_6_72='56:72' # Ташлинский, Оренбургская область, (Земли населенных пунктов)
    _5_6_73='56:73' # Тоцкий, Оренбургская область, (Земли населенных пунктов)
    _5_6_74='56:74' # Тюльганский, Оренбургская область, (Земли населенных пунктов)
    _5_6_75='56:75' # Шарлыкский, Оренбургская область, (Земли населенных пунктов)
    _5_6_70='56:70' # Соль-Илецкий, Оренбургская область, (Земли населенных пунктов)
    _5_6_71='56:71' # Сорочинский, Оренбургская область, (Земли населенных пунктов)
    _5_6_76='56:76' # Ясневский, Оренбургская область, (Земли населенных пунктов)
    _2_0_14='20:14' # Шатойское, Чеченская Республика, (Земли лесного фонда)
    _2_0_13='20:13' # Шаройское, Чеченская Республика, (Земли лесного фонда)
    _2_0_12='20:12' # Шалинское, Чеченская Республика, (Земли лесного фонда)
    _2_0_11='20:11' # Урус-Мартановское, Чеченская Республика, (Земли лесного фонда)
    _2_0_10='20:10' # Предгорное, Чеченская Республика, (Земли лесного фонда)
    _1_9_25='19:25' # Ширинский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_24='19:24' # Усть-Абаканский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_21='19:21' # г.Черногорск, Республика Хакасия, (Земли населенных пунктов)
    _1_9_20='19:20' # г.Саяногорск, Республика Хакасия, (Земли населенных пунктов)
    _1_9_23='19:23' # Таштыпский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_22='19:22' # Орджоникидзевский район, Республика Хакасия, (Земли населенных пунктов)
    _2_0_25='20:25' # Надтеречный район, Чеченская республика, (Земли населенных пунктов)
    _2_0_24='20:24' # Курчалойский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_23='20:23' # Итум-Калинский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_22='20:22' # Гудермесский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_21='20:21' # Грозненский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_20='20:20' # Город Гудермес, Чеченская республика, (Земли населенных пунктов)
    _2_0_19='20:19' # Город Грозный, Чеченская республика, (Земли населенных пунктов)
    _2_0_18='20:18' # Город Аргун, Чеченская республика, (Земли населенных пунктов)
    _2_0_17='20:17' # Веденский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_16='20:16' # Ачхой-Мартановский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_15='20:15' # Шелковское, Чеченская Республика, (Земли лесного фонда)
    _8_7_5='87:5' # Билибинский, Чукотский автономный округ, (Земли населенных пунктов)
    _8_7_6='87:6' # го Анадырь, Чукотский автономный округ, (Земли населенных пунктов)
    _8_7_3='87:3' # НП Берингия, Чукотский автономный округ, (Земли особо охраняемых природных территорий)
    _8_7_4='87:4' # Анадырский, Чукотский автономный округ, (Земли населенных пунктов)
    _8_7_9='87:9' # Чаунский, Чукотский автономный округ, (Земли населенных пунктов)
    _8_7_7='87:7' # Иультинский, Чукотский автономный округ, (Земли населенных пунктов)
    _8_7_8='87:8' # Провидинский, Чукотский автономный округ, (Земли населенных пунктов)
    _4_1='4:1' # Кош-Агачское, Республика Алтай, (Земли лесного фонда)
    _4_2='4:2' # Майминское, Республика Алтай, (Земли лесного фонда)
    _8_7_1='87:1' # Чукотское, Чукотский автономный округ, (Земли лесного фонда)
    _4_3='4:3' # Онгудайское, Республика Алтай, (Земли лесного фонда)
    _8_7_2='87:2' # ГПЗ Остров Врангеля, Чукотский автономный округ, (Земли особо охраняемых природных территорий)
    _4_4='4:4' # Турочакское, Республика Алтай, (Земли лесного фонда)
    _4_5='4:5' # Улаганское, Республика Алтай, (Земли лесного фонда)
    _4_6='4:6' # Усть-Канское, Республика Алтай, (Земли лесного фонда)
    _4_7='4:7' # Усть-Коксинское, Республика Алтай, (Земли лесного фонда)
    _4_8='4:8' # Чемальское, Республика Алтай, (Земли лесного фонда)
    _4_9='4:9' # Чойское, Республика Алтай, (Земли лесного фонда)
    _1_9_18='19:18' # Боградский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_17='19:17' # Бейский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_19='19:19' # г. Абакан, Республика Хакасия, (Земли населенных пунктов)
    _1_9_14='19:14' # ГПЗ Хакасский, Республика Хакасия, (Земли особо охраняемых природных территорий)
    _1_9_13='19:13' # Усть-Бюрское, Республика Хакасия, (Земли лесного фонда)
    _1_9_16='19:16' # Аскизский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_15='19:15' # Алтайский район, Республика Хакасия, (Земли населенных пунктов)
    _1_9_10='19:10' # Саяногорское, Республика Хакасия, (Земли лесного фонда)
    _1_9_12='19:12' # Туимское, Республика Хакасия, (Земли лесного фонда)
    _1_9_11='19:11' # Таштыпское, Республика Хакасия, (Земли лесного фонда)
    _5_6_14='56:14' # Новосергиевское, Оренбургская область, (Земли лесного фонда)
    _5_6_15='56:15' # Оренбургское, Оренбургская область, (Земли лесного фонда)
    _5_6_16='56:16' # Орское, Оренбургская область, (Земли лесного фонда)
    _5_6_17='56:17' # Первомайское, Оренбургская область, (Земли лесного фонда)
    _5_6_10='56:10' # Илекское, Оренбургская область, (Земли лесного фонда)
    _5_6_11='56:11' # Кваркенское, Оренбургская область, (Земли лесного фонда)
    _5_6_12='56:12' # Краснохолмское, Оренбургская область, (Земли лесного фонда)
    _5_6_13='56:13' # Кувандыкское, Оренбургская область, (Земли лесного фонда)
    _5_6_18='56:18' # Пономаревское, Оренбургская область, (Земли лесного фонда)
    _5_6_19='56:19' # Сакмарское, Оренбургская область, (Земли лесного фонда)
    _5_6_20='56:20' # Саракташское, Оренбургская область, (Земли лесного фонда)
    _5_6_25='56:25' # Тюльганское, Оренбургская область, (Земли лесного фонда)
    _5_6_26='56:26' # Чернореченское, Оренбургская область, (Земли лесного фонда)
    _5_6_27='56:27' # Шарлыкское, Оренбургская область, (Земли лесного фонда)
    _5_6_28='56:28' # ГПЗ Оренбургский, Оренбургская область, (Земли особо охраняемых природных территорий)
    _5_6_21='56:21' # Северное, Оренбургская область, (Земли лесного фонда)
    _5_6_22='56:22' # Соль-Илецкое, Оренбургская область, (Земли лесного фонда)
    _5_6_23='56:23' # Сорочинское, Оренбургская область, (Земли лесного фонда)
    _5_6_24='56:24' # Ташлинское, Оренбургская область, (Земли лесного фонда)
    _7_4_6='74:6' # Карталинское, Челябинская область, (Земли лесного фонда)
    _7_4_5='74:5' # Златоустовское, Челябинская область, (Земли лесного фонда)
    _7_4_8='74:8' # Катав-Ивановское, Челябинская область, (Земли лесного фонда)
    _7_4_7='74:7' # Каслинское, Челябинская область, (Земли лесного фонда)
    _6_8_10='68:10' # Уваровское, Тамбовская область, (Земли лесного фонда)
    _5_6_29='56:29' # Оренбургское, Оренбургская область, (Земли обороны и безопасности)
    _7_4_9='74:9' # Красноармейское, Челябинская область, (Земли лесного фонда)
    _6_8_14='68:14' # ГПЗ Воронинский, Тамбовская область, (Земли особо охраняемых природных территорий)
    _6_8_13='68:13' # Челнавское, Тамбовская область, (Земли лесного фонда)
    _6_8_12='68:12' # Цнинское, Тамбовская область, (Земли лесного фонда)
    _6_8_11='68:11' # Хоботовское, Тамбовская область, (Земли лесного фонда)
    _7_4_2='74:2' # Ашинское, Челябинская область, (Земли лесного фонда)
    _6_8_18='68:18' # г. Котовск, Тамбовская область, (Земли населенных пунктов)
    _7_4_1='74:1' # Аргаяшское, Челябинская область, (Земли лесного фонда)
    _6_8_17='68:17' # г. Кирсанов, Тамбовская область, (Земли населенных пунктов)
    _7_4_4='74:4' # Верхнеуральское, Челябинская область, (Земли лесного фонда)
    _6_8_16='68:16' # г. Жердевка, Тамбовская область, (Земли населенных пунктов)
    _7_4_3='74:3' # Брединское, Челябинская область, (Земли лесного фонда)
    _6_8_15='68:15' # Бондарское, Тамбовская область, (Земли населенных пунктов)
    _5_6_30='56:30' # Абдулинский, Оренбургская область, (Земли населенных пунктов)
    _5_6_31='56:31' # Адамовский, Оренбургская область, (Земли населенных пунктов)
    _5_6_36='56:36' # Бугурусланский, Оренбургская область, (Земли населенных пунктов)
    _5_6_37='56:37' # Бузулукский, Оренбургская область, (Земли населенных пунктов)
    _5_6_38='56:38' # г.Абдулино, Оренбургская область, (Земли населенных пунктов)
    _5_6_39='56:39' # г.Бугуруслан, Оренбургская область, (Земли населенных пунктов)
    _5_6_32='56:32' # Акбулакский, Оренбургская область, (Земли населенных пунктов)
    _5_6_33='56:33' # Александровский, Оренбургская область, (Земли населенных пунктов)
    _5_6_34='56:34' # Асекеевский, Оренбургская область, (Земли населенных пунктов)
    _5_6_35='56:35' # Беляевский, Оренбургская область, (Земли населенных пунктов)
    _6_8_21='68:21' # г. Рассказово, Тамбовская область, (Земли населенных пунктов)
    _6_8_20='68:20' # г. Моршанск, Тамбовская область, (Земли населенных пунктов)
    _6_8_25='68:25' # Жердевское, Тамбовская область, (Земли населенных пунктов)
    _6_8_24='68:24' # Гавриловское, Тамбовская область, (Земли населенных пунктов)
    _6_8_23='68:23' # г. Уварово, Тамбовская область, (Земли населенных пунктов)
    _6_8_22='68:22' # г. Тамбов, Тамбовская область, (Земли населенных пунктов)
    _6_8_29='68:29' # Мичуринское, Тамбовская область, (Земли населенных пунктов)
    _6_8_28='68:28' # Кирсановское, Тамбовская область, (Земли населенных пунктов)
    _6_8_27='68:27' # Инжавинское, Тамбовская область, (Земли населенных пунктов)
    _6_8_26='68:26' # Знаменское, Тамбовская область, (Земли населенных пунктов)
    _5_6_40='56:40' # г.Бузулук, Оренбургская область, (Земли населенных пунктов)
    _5_6_41='56:41' # г.Гай, Оренбургская область, (Земли населенных пунктов)
    _6_8_19='68:19' # г. Мичуринск, Тамбовская область, (Земли населенных пунктов)
    _5_6_42='56:42' # г.Кувандык, Оренбургская область, (Земли населенных пунктов)
    _5_6_47='56:47' # г.Соль-Илецк, Оренбургская область, (Земли населенных пунктов)
    _5_6_48='56:48' # г.Сорочинск, Оренбургская область, (Земли населенных пунктов)
    _5_6_49='56:49' # г.Ясный, Оренбургская область, (Земли населенных пунктов)
    _5_6_43='56:43' # г.Медногорск, Оренбургская область, (Земли населенных пунктов)
    _5_6_44='56:44' # г.Новотроицк, Оренбургская область, (Земли населенных пунктов)
    _5_6_45='56:45' # г.Оренбург, Оренбургская область, (Земли населенных пунктов)
    _5_6_46='56:46' # г.Орск, Оренбургская область, (Земли населенных пунктов)
    _6_1_8='61:8' # Обливское, Ростовская область, (Земли лесного фонда)
    _4_4_50='44:50' # Сусанинское АТО, Костромская область, (Земли населенных пунктов)
    _6_1_7='61:7' # Мартыновское, Ростовская область, (Земли лесного фонда)
    _4_4_52='44:52' # Шарьинское АТО, Костромская область, (Земли населенных пунктов)
    _6_1_9='61:9' # Ремонтненское, Ростовская область, (Земли лесного фонда)
    _4_4_51='44:51' # Чухломское АТО, Костромская область, (Земли населенных пунктов)
    _6_1_2='61:2' # Верхнедонское, Ростовская область, (Земли лесного фонда)
    _6_1_1='61:1' # Боковское, Ростовская область, (Земли лесного фонда)
    _6_1_4='61:4' # Зимовниковское, Ростовская область, (Земли лесного фонда)
    _6_1_3='61:3' # Донецкое, Ростовская область, (Земли лесного фонда)
    _6_1_6='61:6' # Кашарское, Ростовская область, (Земли лесного фонда)
    _6_1_5='61:5' # Каменское, Ростовская область, (Земли лесного фонда)
    _4_4_41='44:41' # Нерехтское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_40='44:40' # Нейское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_47='44:47' # Пыщугское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_46='44:46' # Поназыревское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_49='44:49' # Судиславское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_48='44:48' # Солигаличское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_43='44:43' # Островское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_42='44:42' # Октябрьское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_45='44:45' # Парфеньевское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_44='44:44' # Павинское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_39='44:39' # Межевское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_30='44:30' # г.Мантурово, Костромская область, (Земли населенных пунктов)
    _3_2_49='32:49' # Суражский, Брянская область, (Земли населенных пунктов)
    _4_4_36='44:36' # Красносельское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_35='44:35' # Костромское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_38='44:38' # Мантуровское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_37='44:37' # Макарьевское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_32='44:32' # Галичское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_31='44:31' # г.Шарья, Костромская область, (Земли населенных пунктов)
    _4_4_34='44:34' # Кологривское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_33='44:33' # Кадыйское АТО, Костромская область, (Земли населенных пунктов)
    _3_2_50='32:50' # Трубчевский, Брянская область, (Земли населенных пунктов)
    _3_2_51='32:51' # Унечский, Брянская область, (Земли населенных пунктов)
    _4_4_29='44:29' # г.Кострома, Костромская область, (Земли населенных пунктов)
    _4_4_28='44:28' # г.Галич, Костромская область, (Земли населенных пунктов)
    _3_2_38='32:38' # Комаричский, Брянская область, (Земли населенных пунктов)
    _3_2_39='32:39' # Красногорский, Брянская область, (Земли населенных пунктов)
    _4_4_25='44:25' # Вохомское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_24='44:24' # Буйское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_27='44:27' # г.Волглреченск, Костромская область, (Земли населенных пунктов)
    _4_4_26='44:26' # г.Буй, Костромская область, (Земли населенных пунктов)
    _4_4_21='44:21' # Шарьинское, Костромская область, (Земли лесного фонда)
    _4_4_20='44:20' # Чухломское, Костромская область, (Земли лесного фонда)
    _4_4_23='44:23' # Антроповское АТО, Костромская область, (Земли населенных пунктов)
    _4_4_22='44:22' # ГПЗ Кологривский лес, Костромская область, (Земли особо охраняемых природных территорий)
    _3_2_40='32:40' # Мглинский, Брянская область, (Земли населенных пунктов)
    _4_4_18='44:18' # Солигаличское, Костромская область, (Земли лесного фонда)
    _4_4_17='44:17' # Пыщугское, Костромская область, (Земли лесного фонда)
    _4_4_19='44:19' # Судиславское, Костромская область, (Земли лесного фонда)
    _3_2_47='32:47' # Стародубский, Брянская область, (Земли населенных пунктов)
    _3_2_48='32:48' # Суземский, Брянская область, (Земли населенных пунктов)
    _3_2_45='32:45' # Рогнединский, Брянская область, (Земли населенных пунктов)
    _3_2_46='32:46' # Севский, Брянская область, (Земли населенных пунктов)
    _3_2_43='32:43' # Погарский, Брянская область, (Земли населенных пунктов)
    _3_2_44='32:44' # Почепский, Брянская область, (Земли населенных пунктов)
    _3_2_41='32:41' # Навлинский, Брянская область, (Земли населенных пунктов)
    _3_2_42='32:42' # Новозыбковский, Брянская область, (Земли населенных пунктов)
    _3_2_29='32:29' # Дубровский, Брянская область, (Земли населенных пунктов)
    _3_2_27='32:27' # г.Сельцо, Брянская область, (Земли населенных пунктов)
    _3_2_28='32:28' # Гордеевский, Брянская область, (Земли населенных пунктов)
    _4_4_14='44:14' # Павинское, Костромская область, (Земли лесного фонда)
    _4_4_13='44:13' # Островское, Костромская область, (Земли лесного фонда)
    _4_4_16='44:16' # Поназыревское, Костромская область, (Земли лесного фонда)
    _4_4_15='44:15' # Парфеньевское, Костромская область, (Земли лесного фонда)
    _4_4_10='44:10' # Межевское, Костромская область, (Земли лесного фонда)
    _4_4_12='44:12' # Октябрьское, Костромская область, (Земли лесного фонда)
    _4_4_11='44:11' # Нейское, Костромская область, (Земли лесного фонда)
    _3_2_36='32:36' # Климовский, Брянская область, (Земли населенных пунктов)
    _3_2_37='32:37' # Клинцовский, Брянская область, (Земли населенных пунктов)
    _3_2_34='32:34' # Карачевский, Брянская область, (Земли населенных пунктов)
    _3_2_35='32:35' # Клетнянский, Брянская область, (Земли населенных пунктов)
    _3_2_32='32:32' # Жуковский, Брянская область, (Земли населенных пунктов)
    _3_2_33='32:33' # Злынковский, Брянская область, (Земли населенных пунктов)
    _3_2_30='32:30' # Дятьковский, Брянская область, (Земли населенных пунктов)
    _3_2_31='32:31' # Жирятинский, Брянская область, (Земли населенных пунктов)
    _3_2_18='32:18' # Учебно-опытное, Брянская область, (Земли лесного фонда)
    _3_2_19='32:19' # ГПБЗ Брянский лес, Брянская область, (Земли особо охраняемых природных территорий)
    _3_2_16='32:16' # Трубчевское, Брянская область, (Земли лесного фонда)
    _3_2_17='32:17' # Унечское, Брянская область, (Земли лесного фонда)
    _2_0_33='20:33' # Шелковской район, Чеченская республика, (Земли населенных пунктов)
    _2_0_32='20:32' # Шатойский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_31='20:31' # Шаройский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_30='20:30' # Шалинский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_29='20:29' # Урус-Мартановский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_28='20:28' # Сунженский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_27='20:27' # Ножай-Юртовский район, Чеченская республика, (Земли населенных пунктов)
    _2_0_26='20:26' # Наурский район, Чеченская республика, (Земли населенных пунктов)
    _3_2_25='32:25' # г.Клинцы, Брянская область, (Земли населенных пунктов)
    _3_2_26='32:26' # г.Новозыбков, Брянская область, (Земли населенных пунктов)
    _3_2_23='32:23' # г.Брянск, Брянская область, (Земли населенных пунктов)
    _3_2_24='32:24' # г.Дятьково, Брянская область, (Земли населенных пунктов)
    _3_2_21='32:21' # Брянский, Брянская область, (Земли населенных пунктов)
    _3_2_22='32:22' # Выгоничский, Брянская область, (Земли населенных пунктов)
    _3_2_20='32:20' # Брасовский, Брянская область, (Земли населенных пунктов)
    _3_2_14='32:14' # Севское, Брянская область, (Земли лесного фонда)
    _3_2_15='32:15' # Суземское, Брянская область, (Земли лесного фонда)
    _3_2_12='32:12' # Навлинское, Брянская область, (Земли лесного фонда)
    _3_2_13='32:13' # Почепское, Брянская область, (Земли лесного фонда)
    _3_2_10='32:10' # Клинцовское, Брянская область, (Земли лесного фонда)
    _3_2_11='32:11' # Мглинское, Брянская область, (Земли лесного фонда)
    _2_5_24='25:24' # Анучинский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_23='25:23' # Уссурийское, Приморский край, (Земли обороны и безопасности)
    _2_5_26='25:26' # Артемовский городской округ, Приморский край, (Земли населенных пунктов)
    _2_5_25='25:25' # Аресеньевский городской округ, Приморский край, (Земли населенных пунктов)
    _2_5_28='25:28' # Городской округ ЗАТО Большой Камень, Приморский край, (Земли населенных пунктов)
    _3_9_1='39:1' # Багратионовское, Калининградская область, (Земли лесного фонда)
    _2_5_27='25:27' # Владивостокский городской округ, Приморский край, (Земли населенных пунктов)
    _3_9_2='39:2' # Гвардейское, Калининградская область, (Земли лесного фонда)
    _3_9_3='39:3' # Железнодорожное, Калининградская область, (Земли лесного фонда)
    _2_5_29='25:29' # Городской округ ЗАТО Фокино, Приморский край, (Земли населенных пунктов)
    _2_5_20='25:20' # НП Удегейская легенда, Приморский край, (Земли особо охраняемых природных территорий)
    _2_5_22='25:22' # Партизанское, Приморский край, (Земли обороны и безопасности)
    _2_5_21='25:21' # Владивостокское, Приморский край, (Земли обороны и безопасности)
    _3_7_13='37:13' # Гав-Посадский, Ивановская область, (Земли населенных пунктов)
    _3_7_14='37:14' # Заволжский, Ивановская область, (Земли населенных пунктов)
    _3_7_15='37:15' # Ивановский, Ивановская область, (Земли населенных пунктов)
    _3_7_16='37:16' # Ильинский, Ивановская область, (Земли населенных пунктов)
    _3_7_17='37:17' # Кинешемский, Ивановская область, (Земли населенных пунктов)
    _3_7_18='37:18' # Комсомольский, Ивановская область, (Земли населенных пунктов)
    _3_7_19='37:19' # Лежневский, Ивановская область, (Земли населенных пунктов)
    _3_7_10='37:10' # Южское, Ивановская область, (Земли лесного фонда)
    _3_7_11='37:11' # Верхнеландеховский, Ивановская область, (Земли населенных пунктов)
    _3_7_12='37:12' # Вичугский, Ивановская область, (Земли населенных пунктов)
    _2_5_35='25:35' # Кировский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_34='25:34' # Кавалеровский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_37='25:37' # Лазовский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_36='25:36' # Красноармейский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_39='25:39' # Михайловский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_38='25:38' # Лесозаводский городской округ, Приморский край, (Земли населенных пунктов)
    _2_5_31='25:31' # Дальнегорский городской окург, Приморский край, (Земли населенных пунктов)
    _2_5_30='25:30' # Городской округ Спасск - Дальний, Приморский край, (Земли населенных пунктов)
    _2_5_33='25:33' # Дальнереченский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_32='25:32' # Дальнереченский городской округ, Приморский край, (Земли населенных пунктов)
    _3_9_4='39:4' # Калининградское, Калининградская область, (Земли лесного фонда)
    _3_9_5='39:5' # Краснознаменское, Калининградская область, (Земли лесного фонда)
    _3_9_6='39:6' # Нестеровское, Калининградская область, (Земли лесного фонда)
    _3_9_7='39:7' # Полесское, Калининградская область, (Земли лесного фонда)
    _3_9_8='39:8' # Славское, Калининградская область, (Земли лесного фонда)
    _3_9_9='39:9' # Черняховское, Калининградская область, (Земли лесного фонда)
    _1_3_19='13:19' # Ельниковское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_24='13:24' # Кочкуровское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_25='13:25' # Краснослободское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_22='13:22' # Ичалковское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_23='13:23' # Кадошкинское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_28='13:28' # МО г. Рузаевка, Республика Мордовия, (Земли населенных пунктов)
    _1_3_29='13:29' # Ромодановское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_26='13:26' # Лямбирское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_27='13:27' # МО г. Ковылкино, Республика Мордовия, (Земли населенных пунктов)
    _1_3_20='13:20' # Зубово-Полянское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_21='13:21' # Инсарское, Республика Мордовия, (Земли населенных пунктов)
    _5_0_11='50:11' # Московское учебно-опытное, Московская область, (Земли лесного фонда)
    _5_0_10='50:10' # Луховицкое, Московская область, (Земли лесного фонда)
    _5_0_13='50:13' # Ногинское, Московская область, (Земли лесного фонда)
    _2_5_13='25:13' # ГПБЗ Сихотэ-Алинский, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_12='50:12' # Наро-Фоминское, Московская область, (Земли лесного фонда)
    _2_5_12='25:12' # ГПБЗ Кедровая падь, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_15='50:15' # Подольское, Московская область, (Земли лесного фонда)
    _2_5_15='25:15' # ГПЗ Лазовский, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_14='50:14' # Орехово-Зуевское, Московская область, (Земли лесного фонда)
    _2_5_14='25:14' # ГПБЗ Ханкайский, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_17='50:17' # Ступинское, Московская область, (Земли лесного фонда)
    _2_5_17='25:17' # Дальневосточный морской биосферный заповедник «ДВГМЗ», Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_16='50:16' # Сергиево-Посадское, Московская область, (Земли лесного фонда)
    _2_5_16='25:16' # ГПЗ Уссурийский, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_19='50:19' # Шатурское, Московская область, (Земли лесного фонда)
    _2_5_19='25:19' # НП Зов тигра, Приморский край, (Земли особо охраняемых природных территорий)
    _5_0_18='50:18' # Талдомское, Московская область, (Земли лесного фонда)
    _2_5_18='25:18' # НП Земля леопарда, Приморский край, (Земли особо охраняемых природных территорий)
    _2_6_5='26:5' # Изобильненское, Ставропольский край, (Земли лесного фонда)
    _2_6_4='26:4' # Ессентукское, Ставропольский край, (Земли лесного фонда)
    _2_6_3='26:3' # Дивенское, Ставропольский край, (Земли лесного фонда)
    _2_6_2='26:2' # Георгиевское, Ставропольский край, (Земли лесного фонда)
    _2_6_1='26:1' # Бештаугорское, Ставропольский край, (Земли лесного фонда)
    _2_5_11='25:11' # Чугуевское, Приморский край, (Земли лесного фонда)
    _2_5_10='25:10' # Уссурийское, Приморский край, (Земли лесного фонда)
    _1_3_33='13:33' # Торбеевское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_34='13:34' # Чамзинское, Республика Мордовия, (Земли населенных пунктов)
    _1_3_31='13:31' # Темниковское, Республика Мордовия, (Земли населенных пунктов)
    _5_0_20='50:20' # ГПБЗ Приокско-Террасный, Московская область, (Земли особо охраняемых природных территорий)
    _1_3_32='13:32' # Теньгушевское, Республика Мордовия, (Земли населенных пунктов)
    _5_0_22='50:22' # "Завидово" ФСО России, Московская область, (Земли обороны и безопасности)
    _1_3_30='13:30' # Старошайговское, Республика Мордовия, (Земли населенных пунктов)
    _5_0_21='50:21' # НП Лосиный остров, Московская область, (Земли особо охраняемых природных территорий)
    _5_0_24='50:24' # Волоколамский, Московская область, (Земли населенных пунктов)
    _5_0_23='50:23' # Балашихинский, Московская область, (Земли населенных пунктов)
    _5_0_26='50:26' # г.Дубна, Московская область, (Земли населенных пунктов)
    _5_0_25='50:25' # Воскресенский, Московская область, (Земли населенных пунктов)
    _5_0_28='50:28' # г.Фрязино(тер.условно), Московская область, (Земли населенных пунктов)
    _5_0_27='50:27' # г.Королев(тер.условно), Московская область, (Земли населенных пунктов)
    _5_0_29='50:29' # Города областного подчинения, Московская область, (Земли населенных пунктов)
    _6_2_10='62:10' # Первомайское, Рязанская область, (Земли лесного фонда)
    _6_2_11='62:11' # Ряжское, Рязанская область, (Земли лесного фонда)
    _6_2_12='62:12' # Рязанское, Рязанская область, (Земли лесного фонда)
    _2_6_9='26:9' # Левокумское, Ставропольский край, (Земли лесного фонда)
    _2_6_8='26:8' # Курское, Ставропольский край, (Земли лесного фонда)
    _2_6_7='26:7' # Кисловодское, Ставропольский край, (Земли лесного фонда)
    _2_6_6='26:6' # Калаусское, Ставропольский край, (Земли лесного фонда)
    _5_0_31='50:31' # Домодедовский, Московская область, (Земли населенных пунктов)
    _5_0_30='50:30' # Дмитровский, Московская область, (Земли населенных пунктов)
    _5_0_33='50:33' # Загорский, Московская область, (Земли населенных пунктов)
    _5_0_32='50:32' # Егорьевский, Московская область, (Земли населенных пунктов)
    _5_0_35='50:35' # Истринский, Московская область, (Земли населенных пунктов)
    _5_0_34='50:34' # Зарайский, Московская область, (Земли населенных пунктов)
    _5_0_37='50:37' # Клинский, Московская область, (Земли населенных пунктов)
    _5_0_36='50:36' # Каширский, Московская область, (Земли населенных пунктов)
    _5_0_39='50:39' # Красногорский, Московская область, (Земли населенных пунктов)
    _5_0_38='50:38' # Коломенский, Московская область, (Земли населенных пунктов)
    _6_2_20='62:20' # ГПБЗ Окский, Рязанская область, (Земли особо охраняемых природных территорий)
    _6_2_21='62:21' # НП Мещерский, Рязанская область, (Земли особо охраняемых природных территорий)
    _6_2_22='62:22' # Ермишинское, Рязанская область, (Земли населенных пунктов)
    _6_2_23='62:23' # Захаровское, Рязанская область, (Земли населенных пунктов)
    _1_3_13='13:13' # Атюрьевское, Республика Мордовия, (Земли населенных пунктов)
    _6_2_13='62:13' # Сасовское, Рязанская область, (Земли лесного фонда)
    _1_3_14='13:14' # Атяшевское, Республика Мордовия, (Земли населенных пунктов)
    _6_2_14='62:14' # Солотчинское, Рязанская область, (Земли лесного фонда)
    _1_3_11='13:11' # НП Смольный, Республика Мордовия, (Земли особо охраняемых природных территорий)
    _6_2_15='62:15' # Спасское, Рязанская область, (Земли лесного фонда)
    _1_3_12='13:12' # Ардатовское, Республика Мордовия, (Земли населенных пунктов)
    _6_2_16='62:16' # Тумское, Рязанская область, (Земли лесного фонда)
    _1_3_17='13:17' # ГО г.Саранск, Республика Мордовия, (Земли населенных пунктов)
    _6_2_17='62:17' # Шацкое, Рязанская область, (Земли лесного фонда)
    _1_3_18='13:18' # Дубенское, Республика Мордовия, (Земли населенных пунктов)
    _6_2_18='62:18' # Шелуховское, Рязанская область, (Земли лесного фонда)
    _1_3_15='13:15' # Б.-Березниковское, Республика Мордовия, (Земли населенных пунктов)
    _6_2_19='62:19' # Шиловское, Рязанская область, (Земли лесного фонда)
    _1_3_16='13:16' # Большеигнатовское, Республика Мордовия, (Земли населенных пунктов)
    _5_0_40='50:40' # Ленинский, Московская область, (Земли населенных пунктов)
    _5_0_42='50:42' # Луховицкий, Московская область, (Земли населенных пунктов)
    _1_3_10='13:10' # ГПЗ Мордовский, Республика Мордовия, (Земли особо охраняемых природных территорий)
    _5_0_41='50:41' # Лотошинский, Московская область, (Земли населенных пунктов)
    _5_0_44='50:44' # Можайский, Московская область, (Земли населенных пунктов)
    _5_0_43='50:43' # Люберецкий, Московская область, (Земли населенных пунктов)
    _7_4_13='74:13' # Миасское, Челябинская область, (Земли лесного фонда)
    _5_0_46='50:46' # Наро-Фоминский, Московская область, (Земли населенных пунктов)
    _7_4_12='74:12' # Кыштымское, Челябинская область, (Земли лесного фонда)
    _5_0_45='50:45' # Мытищинский, Московская область, (Земли населенных пунктов)
    _7_4_11='74:11' # Кусинское, Челябинская область, (Земли лесного фонда)
    _5_0_48='50:48' # Одинцовский, Московская область, (Земли населенных пунктов)
    _7_4_10='74:10' # Кунашакское, Челябинская область, (Земли лесного фонда)
    _5_0_47='50:47' # Ногинский, Московская область, (Земли населенных пунктов)
    _5_0_49='50:49' # Озерский, Московская область, (Земли населенных пунктов)
    _1_3_7='13:7' # Краснослободское территориальное, Республика Мордовия, (Земли лесного фонда)
    _1_3_6='13:6' # Ковылкинское территориальное, Республика Мордовия, (Земли лесного фонда)
    _1_3_5='13:5' # Зубовское территориальное, Республика Мордовия, (Земли лесного фонда)
    _1_3_4='13:4' # Вышинское территориальное, Республика Мордовия, (Земли лесного фонда)
    _6_2_30='62:30' # Новодеревенское, Рязанская область, (Земли населенных пунктов)
    _1_3_3='13:3' # Виндрейское территориальное, Республика Мордовия, (Земли лесного фонда)
    _6_2_31='62:31' # Пителенское, Рязанская область, (Земли населенных пунктов)
    _1_3_2='13:2' # Березниковское территориальное, Республика Мордовия, (Земли лесного фонда)
    _6_2_32='62:32' # Пронское, Рязанская область, (Земли населенных пунктов)
    _1_3_1='13:1' # Ардатовское территориальное, Республика Мордовия, (Земли лесного фонда)
    _6_2_33='62:33' # Путятинское, Рязанская область, (Земли населенных пунктов)
    _6_2_34='62:34' # Рыбновское, Рязанская область, (Земли населенных пунктов)
    _6_2_24='62:24' # Кадомское, Рязанская область, (Земли населенных пунктов)
    _6_2_25='62:25' # Касимовское, Рязанская область, (Земли населенных пунктов)
    _6_2_26='62:26' # Клепиковское, Рязанская область, (Земли населенных пунктов)
    _6_2_27='62:27' # Кораблинское, Рязанская область, (Земли населенных пунктов)
    _6_2_28='62:28' # Милославское, Рязанская область, (Земли населенных пунктов)
    _6_2_29='62:29' # Михайловское, Рязанская область, (Земли населенных пунктов)
    _5_0_51='50:51' # Павло-Посадский, Московская область, (Земли населенных пунктов)
    _5_0_50='50:50' # Орехово-Зуевский, Московская область, (Земли населенных пунктов)
    _5_0_53='50:53' # Пушкинский, Московская область, (Земли населенных пунктов)
    _5_0_52='50:52' # Подольский, Московская область, (Земли населенных пунктов)
    _5_0_55='50:55' # Рузский, Московская область, (Земли населенных пунктов)
    _5_0_54='50:54' # Раменский, Московская область, (Земли населенных пунктов)
    _7_4_24='74:24' # НП Зюраткуль, Челябинская область, (Земли особо охраняемых природных территорий)
    _5_0_57='50:57' # Серпуховский, Московская область, (Земли населенных пунктов)
    _7_4_23='74:23' # ГПЗ Ильменский, Челябинская область, (Земли особо охраняемых природных территорий)
    _5_0_56='50:56' # Серебряно-Прудский, Московская область, (Земли населенных пунктов)
    _7_4_22='74:22' # Шершневское, Челябинская область, (Земли лесного фонда)
    _5_0_59='50:59' # Ступинский, Московская область, (Земли населенных пунктов)
    _7_4_21='74:21' # Чебаркульское, Челябинская область, (Земли лесного фонда)
    _5_0_58='50:58' # Солнечногорский, Московская область, (Земли населенных пунктов)
    _7_4_20='74:20' # Уфалейское, Челябинская область, (Земли лесного фонда)
    _6_2_40='62:40' # Сасовское, Рязанская область, (Земли населенных пунктов)
    _6_2_41='62:41' # Скопинское, Рязанская область, (Земли населенных пунктов)
    _6_2_42='62:42' # Спасское, Рязанская область, (Земли населенных пунктов)
    _6_2_43='62:43' # Старожиловское, Рязанская область, (Земли населенных пунктов)
    _6_2_44='62:44' # Ухоловское, Рязанская область, (Земли населенных пунктов)
    _6_2_45='62:45' # Чучковское, Рязанская область, (Земли населенных пунктов)
    _6_2_35='62:35' # Ряжское, Рязанская область, (Земли населенных пунктов)
    _6_2_36='62:36' # Рязанское, Рязанская область, (Земли населенных пунктов)
    _6_2_37='62:37' # Рязань, Рязанская область, (Земли населенных пунктов)
    _6_2_38='62:38' # Сапожковское, Рязанская область, (Земли населенных пунктов)
    _6_2_39='62:39' # Сараевское, Рязанская область, (Земли населенных пунктов)
    _1_3_9='13:9' # Темниковское территориальное, Республика Мордовия, (Земли лесного фонда)
    _1_3_8='13:8' # Саранское территориальное, Республика Мордовия, (Земли лесного фонда)
    _5_0_60='50:60' # Талдомский, Московская область, (Земли населенных пунктов)
    _7_4_19='74:19' # Усть-Катавское, Челябинская область, (Земли лесного фонда)
    _5_0_62='50:62' # Чеховский, Московская область, (Земли населенных пунктов)
    _7_4_18='74:18' # Увельское, Челябинская область, (Земли лесного фонда)
    _5_0_61='50:61' # Химкинский р-он (г.Химки), Московская область, (Земли населенных пунктов)
    _7_4_17='74:17' # Саткинское, Челябинская область, (Земли лесного фонда)
    _5_0_64='50:64' # Шаховский, Московская область, (Земли населенных пунктов)
    _7_4_16='74:16' # Пластовское, Челябинская область, (Земли лесного фонда)
    _5_0_63='50:63' # Шатурский, Московская область, (Земли населенных пунктов)
    _7_4_15='74:15' # Октябрьское, Челябинская область, (Земли лесного фонда)
    _7_4_14='74:14' # Нязепетровское, Челябинская область, (Земли лесного фонда)
    _5_0_65='50:65' # Щелковский, Московская область, (Земли населенных пунктов)
    _0_0_1='00:1' # ГПБЗ Воронежский, Воронежская область, Липецкая область, (Земли особо охраняемых природных территорий)
    _0_0_8='00:8' # НП Завидово, Московская область, Тверская область, (Земли особо охраняемых природных территорий)
    _0_0_9='00:9' # Алтайское, Алтайский край, Новосибирская область, (Земли обороны и безопасности)
    _0_0_6='00:6' # НП Бузулукский бор, Оренбургская область, Самарская область, (Земли особо охраняемых природных территорий)
    _0_0_7='00:7' # НП Водлозерский, Архангельская область, Республика Карелия, (Земли особо охраняемых природных территорий)
    _0_0_4='00:4' # ГПЗ Кандалакшский, Мурманская область, Республика Карелия, (Земли особо охраняемых природных территорий)
    _0_0_5='00:5' # ГПЗ Южно-Уральский, Республика Башкортостан, Челябинская область, (Земли особо охраняемых природных территорий)
    _0_0_2='00:2' # ГПБЗ Дарвинский, Вологодская область, Ярославская область, (Земли особо охраняемых природных территорий)
    _0_0_3='00:3' # ГПБЗ Кавказский, Карачаево-Черкесская Республика, Краснодарский край, Республика Адыгея (Адыгея), (Земли особо охраняемых природных территорий)
    _4_9_13='49:13' # Среднеканский район, Магаданская область, (Земли населенных пунктов)
    _2_5_46='25:46' # Пограничный муниципальный район, Приморский край, (Земли населенных пунктов)
    _4_9_12='49:12' # Северо-Эвенский район, Магаданская область, (Земли населенных пунктов)
    _2_5_45='25:45' # Партизанский муниципальный район, Приморский край, (Земли населенных пунктов)
    _4_9_11='49:11' # Омсукчанский район, Магаданская область, (Земли населенных пунктов)
    _2_5_48='25:48' # Спасский муниципальный район, Приморский край, (Земли населенных пунктов)
    _4_9_10='49:10' # Ольский район, Магаданская область, (Земли населенных пунктов)
    _2_5_47='25:47' # Пожарский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_49='25:49' # Тернейский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_40='25:40' # Надеждинский муниципальный район, Приморский край, (Земли населенных пунктов)
    _4_9_17='49:17' # Ягоднинский район, Магаданская область, (Земли населенных пунктов)
    _2_5_42='25:42' # Октябрьский муниципальный район, Приморский край, (Земли населенных пунктов)
    _4_9_16='49:16' # Хасынский район, Магаданская область, (Земли населенных пунктов)
    _2_5_41='25:41' # Находкинский городской округ, Приморский край, (Земли населенных пунктов)
    _4_9_15='49:15' # Тенькинский район, Магаданская область, (Земли населенных пунктов)
    _2_5_44='25:44' # Партизанский городской округ, Приморский край, (Земли населенных пунктов)
    _4_9_14='49:14' # Сусуманский район, Магаданская область, (Земли населенных пунктов)
    _2_5_43='25:43' # Ольгинский муниципальный район, Приморский край, (Земли населенных пунктов)
    _3_7_30='37:30' # Южский, Ивановская область, (Земли населенных пунктов)
    _3_7_31='37:31' # Юрьевецкий, Ивановская область, (Земли населенных пунктов)
    _2_5_57='25:57' # Яковлевский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_56='25:56' # Шкотовский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_51='25:51' # Ханкайский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_50='25:50' # Уссурийский городской округ, Приморский край, (Земли населенных пунктов)
    _2_5_53='25:53' # Хорольский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_52='25:52' # Хасанский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_55='25:55' # Чугуевский муниципальный район, Приморский край, (Земли населенных пунктов)
    _2_5_54='25:54' # Черниговский муниципальный район, Приморский край, (Земли населенных пунктов)
    _3_7_24='37:24' # Пучежский, Ивановская область, (Земли населенных пунктов)
    _3_7_25='37:25' # Родниковский., Ивановская область, (Земли населенных пунктов)
    _3_7_26='37:26' # Савинский, Ивановская область, (Земли населенных пунктов)
    _3_7_27='37:27' # Тейковский, Ивановская область, (Земли населенных пунктов)
    _3_7_28='37:28' # Фурмановский, Ивановская область, (Земли населенных пунктов)
    _3_7_29='37:29' # Шуйский, Ивановская область, (Земли населенных пунктов)
    _3_7_20='37:20' # Лухский, Ивановская область, (Земли населенных пунктов)
    _3_7_21='37:21' # Палехский, Ивановская область, (Земли населенных пунктов)
    _3_7_22='37:22' # Пестяковский, Ивановская область, (Земли населенных пунктов)
    _3_7_23='37:23' # Приволжский, Ивановская область, (Земли населенных пунктов)
    _5_1='5:1' # Ботлихское, Республика Дагестан, (Земли лесного фонда)
    _5_2='5:2' # Буйнакское, Республика Дагестан, (Земли лесного фонда)
    _5_3='5:3' # Гунибское, Республика Дагестан, (Земли лесного фонда)
    _5_4='5:4' # Дербентское, Республика Дагестан, (Земли лесного фонда)
    _5_5='5:5' # Казбековское, Республика Дагестан, (Земли лесного фонда)
    _5_6='5:6' # Кайтагское, Республика Дагестан, (Земли лесного фонда)
    _5_7='5:7' # Карабудахкентское, Республика Дагестан, (Земли лесного фонда)
    _5_8='5:8' # Касумкентское, Республика Дагестан, (Земли лесного фонда)
    _5_9='5:9' # Каякентское, Республика Дагестан, (Земли лесного фонда)
    _7_5_5='75:5' # Бадинское, Забайкальский край, (Земли лесного фонда)
    _7_5_4='75:4' # Аргунское, Забайкальский край, (Земли лесного фонда)
    _7_5_7='75:7' # Беклемишевское, Забайкальский край, (Земли лесного фонда)
    _7_5_6='75:6' # Балейское, Забайкальский край, (Земли лесного фонда)
    _7_5_9='75:9' # Газимуро-Заводское, Забайкальский край, (Земли лесного фонда)
    _7_5_8='75:8' # Верхне-Читинское, Забайкальский край, (Земли лесного фонда)
    _7_5_1='75:1' # Агинское, Забайкальский край, (Земли лесного фонда)
    _7_5_3='75:3' # Александровско-Заводское, Забайкальский край, (Земли лесного фонда)
    _7_5_2='75:2' # Акшинское, Забайкальский край, (Земли лесного фонда)
    _3_12='3:12' # Еравнинское, Республика Бурятия, (Земли лесного фонда)
    _3_13='3:13' # Заиграевское, Республика Бурятия, (Земли лесного фонда)
    _3_14='3:14' # Закаменское, Республика Бурятия, (Земли лесного фонда)
    _3_15='3:15' # Заудинское, Республика Бурятия, (Земли лесного фонда)
    _3_16='3:16' # Иволгинское, Республика Бурятия, (Земли лесного фонда)
    _3_17='3:17' # Кабанское, Республика Бурятия, (Земли лесного фонда)
    _3_18='3:18' # Кижингинское, Республика Бурятия, (Земли лесного фонда)
    _3_19='3:19' # Кикинское, Республика Бурятия, (Земли лесного фонда)
    _3_10='3:10' # Гусиноозёрское, Республика Бурятия, (Земли лесного фонда)
    _3_11='3:11' # Джидинское, Республика Бурятия, (Земли лесного фонда)
    _6_2_7='62:7' # Криушинское, Рязанская область, (Земли лесного фонда)
    _6_2_6='62:6' # Кораблинское, Рязанская область, (Земли лесного фонда)
    _6_2_9='62:9' # Нижне-Окское, Рязанская область, (Земли лесного фонда)
    _6_2_8='62:8' # Можарское, Рязанская область, (Земли лесного фонда)
    _6_2_1='62:1' # Бельковское, Рязанская область, (Земли лесного фонда)
    _6_2_3='62:3' # Ермишинское, Рязанская область, (Земли лесного фонда)
    _6_2_2='62:2' # Ерахтурское, Рязанская область, (Земли лесного фонда)
    _6_2_5='62:5' # Клепиковское, Рязанская область, (Земли лесного фонда)
    _6_2_4='62:4' # Касимовское, Рязанская область, (Земли лесного фонда)
    _3_23='3:23' # Курбинское, Республика Бурятия, (Земли лесного фонда)
    _3_24='3:24' # Курумканское, Республика Бурятия, (Земли лесного фонда)
    _3_25='3:25' # Кяхтинское, Республика Бурятия, (Земли лесного фонда)
    _3_26='3:26' # Муйское, Республика Бурятия, (Земли лесного фонда)
    _3_27='3:27' # Мухоршибирское, Республика Бурятия, (Земли лесного фонда)
    _3_28='3:28' # Окинское, Республика Бурятия, (Земли лесного фонда)
    _3_29='3:29' # Прибайкальское, Республика Бурятия, (Земли лесного фонда)
    _3_20='3:20' # Кондинское, Республика Бурятия, (Земли лесного фонда)
    _3_21='3:21' # Кудунское, Республика Бурятия, (Земли лесного фонда)
    _3_22='3:22' # Куйтунское, Республика Бурятия, (Земли лесного фонда)
    _3_34='3:34' # Уоянское, Республика Бурятия, (Земли лесного фонда)
    _3_35='3:35' # Усть-Баргузинское, Республика Бурятия, (Земли лесного фонда)
    _3_36='3:36' # Хандагатайское, Республика Бурятия, (Земли лесного фонда)
    _3_37='3:37' # Хоринское, Республика Бурятия, (Земли лесного фонда)
    _3_38='3:38' # ГПБЗ Байкальский, Республика Бурятия, (Земли особо охраняемых природных территорий)
    _3_39='3:39' # ГПБЗ Баргузинский, Республика Бурятия, (Земли особо охраняемых природных территорий)
    _3_30='3:30' # Романовское, Республика Бурятия, (Земли лесного фонда)
    _3_31='3:31' # Северо-Байкальское, Республика Бурятия, (Земли лесного фонда)
    _3_32='3:32' # Селенгинское, Республика Бурятия, (Земли лесного фонда)
    _3_33='3:33' # Улан-Удэнское, Республика Бурятия, (Земли лесного фонда)
    _3_45='3:45' # Бичурский, Республика Бурятия, (Земли населенных пунктов)
    _3_46='3:46' # Джидинский, Республика Бурятия, (Земли населенных пунктов)
    _3_47='3:47' # Еравнинский, Республика Бурятия, (Земли населенных пунктов)
    _3_48='3:48' # Заиграевский, Республика Бурятия, (Земли населенных пунктов)
    _3_49='3:49' # Закаменский, Республика Бурятия, (Земли населенных пунктов)
    _3_40='3:40' # ГПЗ Джергинский, Республика Бурятия, (Земли особо охраняемых природных территорий)
    _3_41='3:41' # НП Забайкальский, Республика Бурятия, (Земли особо охраняемых природных территорий)
    _3_42='3:42' # НП Тункинский, Республика Бурятия, (Земли особо охраняемых природных территорий)
    _3_43='3:43' # Баргузинский, Республика Бурятия, (Земли населенных пунктов)
    _3_44='3:44' # Баунтовский, Республика Бурятия, (Земли населенных пунктов)
    _3_56='3:56' # Муйский, Республика Бурятия, (Земли населенных пунктов)
    _3_57='3:57' # Мухоршибирский, Республика Бурятия, (Земли населенных пунктов)
    _3_58='3:58' # Окинский, Республика Бурятия, (Земли населенных пунктов)
    _3_59='3:59' # Прибайкальский, Республика Бурятия, (Земли населенных пунктов)
    _3_50='3:50' # Иволгинский, Республика Бурятия, (Земли населенных пунктов)
    _3_51='3:51' # Кабанский, Республика Бурятия, (Земли населенных пунктов)
    _3_52='3:52' # Кижингинский, Республика Бурятия, (Земли населенных пунктов)
    _3_53='3:53' # Курумканский, Республика Бурятия, (Земли населенных пунктов)
    _3_54='3:54' # Кяхтинский, Республика Бурятия, (Земли населенных пунктов)
    _3_55='3:55' # МАУ городское л-во г.Улан-Удэ, Республика Бурятия, (Земли населенных пунктов)
    _3_60='3:60' # Северо-Байкальский, Республика Бурятия, (Земли населенных пунктов)
    _3_61='3:61' # Селенгинский, Республика Бурятия, (Земли населенных пунктов)
    _3_62='3:62' # Тарбагатайский, Республика Бурятия, (Земли населенных пунктов)
    _3_63='3:63' # Тунгинский, Республика Бурятия, (Земли населенных пунктов)
    _3_64='3:64' # Хоринский, Республика Бурятия, (Земли населенных пунктов)
    _2_7_4='27:4' # Баджальское, Хабаровский край, (Земли лесного фонда)
    _2_7_3='27:3' # Аянское, Хабаровский край, (Земли лесного фонда)
    _2_7_2='27:2' # Амгуньское, Хабаровский край, (Земли лесного фонда)
    _2_7_1='27:1' # Аванское, Хабаровский край, (Земли лесного фонда)
    _2_7_9='27:9' # Горинское, Хабаровский край, (Земли лесного фонда)
    _2_7_8='27:8' # Высокогорное, Хабаровский край, (Земли лесного фонда)
    _2_7_7='27:7' # Быстринское, Хабаровский край, (Земли лесного фонда)
    _2_7_6='27:6' # Болоньское, Хабаровский край, (Земли лесного фонда)
    _2_7_5='27:5' # Бикинское, Хабаровский край, (Земли лесного фонда)
    _1_4_6='14:6' # Горное, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_5='14:5' # Вилюйское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_4='14:4' # Верхоянское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_3='14:3' # Верхневилюйское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_2='14:2' # Амгинское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_1='14:1' # Алданское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_9='14:9' # Колымское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_8='14:8' # Индигирское, Республика Саха (Якутия), (Земли лесного фонда)
    _1_4_7='14:7' # Жиганское, Республика Саха (Якутия), (Земли лесного фонда)
    _8_9_3='89:3' # Ноябрьское, Ямало-Ненецкий автономный округ, (Земли лесного фонда)
    _8_9_4='89:4' # Таркосалинское, Ямало-Ненецкий автономный округ, (Земли лесного фонда)
    _8_9_1='89:1' # Красноселькупское, Ямало-Ненецкий автономный округ, (Земли лесного фонда)
    _8_9_2='89:2' # Надымское, Ямало-Ненецкий автономный округ, (Земли лесного фонда)
    _8_9_7='89:7' # ГПЗ Гыданский, Ямало-Ненецкий автономный округ, (Земли особо охраняемых природных территорий)
    _8_9_8='89:8' # Красноселькупский район, Ямало-Ненецкий автономный округ, (Земли населенных пунктов)
    _8_9_5='89:5' # Ямальское, Ямало-Ненецкий автономный округ, (Земли лесного фонда)
    _8_9_6='89:6' # ГПЗ Верхне-Тазовский, Ямало-Ненецкий автономный округ, (Земли особо охраняемых природных территорий)
    _6_1='6:1' # Назрановское, Республика Ингушетия, (Земли лесного фонда)
    _6_2='6:2' # Сунженское, Республика Ингушетия, (Земли лесного фонда)
    _6_3='6:3' # ГПЗ Эрзи, Республика Ингушетия, (Земли особо охраняемых природных территорий)
    _6_4='6:4' # г. Карабулак, Республика Ингушетия, (Земли населенных пунктов)
    _6_5='6:5' # г. Магас, Республика Ингушетия, (Земли населенных пунктов)
    _6_6='6:6' # г.Назрань, Республика Ингушетия, (Земли населенных пунктов)
    _6_7='6:7' # Джейрахский район, Республика Ингушетия, (Земли населенных пунктов)
    _6_8='6:8' # Малгобекский район, Республика Ингушетия, (Земли населенных пунктов)
    _6_9='6:9' # Назрановский район, Республика Ингушетия, (Земли населенных пунктов)
    _8_9_9='89:9' # Надымский район, Ямало-Ненецкий автономный округ, (Земли населенных пунктов)
    _7_6_4='76:4' # ГКУ ЯО "Гаврилов -Ямское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_3='76:3' # ГКУ ЯО "Брейтовское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_6='76:6' # ГКУ ЯО "Любимское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_5='76:5' # ГКУ ЯО "Даниловское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_8='76:8' # ГКУ ЯО "Переславское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_7='76:7' # ГКУ ЯО "Некоузское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_9='76:9' # ГКУ ЯО "Пошехонское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_2='76:2' # ГКУ ЯО "Борисоглебское лесничество", Ярославская область, (Земли лесного фонда)
    _7_6_1='76:1' # ГКУ ЯО "Большесельское лесничество", Ярославская область, (Земли лесного фонда)
    _6_3_6='63:6' # Клявлинское, Самарская область, (Земли лесного фонда)
    _6_3_5='63:5' # Кинель-Черкасское, Самарская область, (Земли лесного фонда)
    _6_3_8='63:8' # Красноярское, Самарская область, (Земли лесного фонда)
    _6_3_7='63:7' # Кошкинское, Самарская область, (Земли лесного фонда)
    _6_3_9='63:9' # Нефтегорское, Самарская область, (Земли лесного фонда)
    _6_3_2='63:2' # Большеглушицкое, Самарская область, (Земли лесного фонда)
    _6_3_1='63:1' # Безенчукское, Самарская область, (Земли лесного фонда)
    _6_3_4='63:4' # Кинельское, Самарская область, (Земли лесного фонда)
    _6_3_3='63:3' # Волжское, Самарская область, (Земли лесного фонда)
    _7_4_35='74:35' # Еткульский МР, Челябинская область, (Земли населенных пунктов)
    _5_0_7='50:7' # Звенигородское, Московская область, (Земли лесного фонда)
    _7_4_34='74:34' # Еманжелинский МР, Челябинская область, (Земли населенных пунктов)
    _5_0_8='50:8' # Истринское, Московская область, (Земли лесного фонда)
    _7_4_33='74:33' # Верхнеуфалейский ГО, Челябинская область, (Земли населенных пунктов)
    _5_0_9='50:9' # Клинское, Московская область, (Земли лесного фонда)
    _7_4_32='74:32' # Верхнеуральский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_31='74:31' # Варненский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_30='74:30' # Брединский МР, Челябинская область, (Земли населенных пунктов)
    _8_6_19='86:19' # Городские леса г. Белоярский, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _5_0_1='50:1' # "Русский лес", Московская область, (Земли лесного фонда)
    _5_0_2='50:2' # Бородинское, Московская область, (Земли лесного фонда)
    _8_6_17='86:17' # Белоярский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _5_0_3='50:3' # Виноградовское, Московская область, (Земли лесного фонда)
    _8_6_18='86:18' # Березовский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _5_0_4='50:4' # Волоколамское, Московская область, (Земли лесного фонда)
    _8_6_15='86:15' # ГПЗ Малая Сосьва, Ханты-Мансийский автономный округ - Югра, (Земли особо охраняемых природных территорий)
    _5_0_5='50:5' # Дмитровское, Московская область, (Земли лесного фонда)
    _8_6_16='86:16' # ГПЗ Юганский, Ханты-Мансийский автономный округ - Югра, (Земли особо охраняемых природных территорий)
    _5_0_6='50:6' # Егорьевское, Московская область, (Земли лесного фонда)
    _8_6_24='86:24' # Городские леса г. Нягань, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _6_2_46='62:46' # Шацкое, Рязанская область, (Земли населенных пунктов)
    _8_6_25='86:25' # Городские леса г. Покачи, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _6_2_47='62:47' # Шиловское, Рязанская область, (Земли населенных пунктов)
    _8_6_22='86:22' # Городские леса г. Лянтора, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_23='86:23' # Городские леса г. Мегион, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_20='86:20' # Городские леса г. Когалым, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_21='86:21' # Городские леса г. Лангепас, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _7_4_29='74:29' # Ашинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_28='74:28' # Аргаяшский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_27='74:27' # Агаповский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_26='74:26' # Челябинское, Челябинская область, (Земли обороны и безопасности)
    _7_4_25='74:25' # НП Таганай, Челябинская область, (Земли особо охраняемых природных территорий)
    _7_4_46='74:46' # Кусинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_45='74:45' # Кунашакский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_44='74:44' # Красноармейский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_43='74:43' # Коркинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_42='74:42' # Копейский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_41='74:41' # Кизильский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_40='74:40' # Катав-Ивановский МР, Челябинская область, (Земли населенных пунктов)
    _8_6_13='86:13' # Урайское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_14='86:14' # Юганское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_11='86:11' # Советское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_12='86:12' # Сургутское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _8_6_10='86:10' # Самаровское, Ханты-Мансийский автономный округ - Югра, (Земли лесного фонда)
    _7_4_39='74:39' # Каслинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_38='74:38' # Карталинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_37='74:37' # Карабашский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_36='74:36' # Златоустовский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_57='74:57' # Снежинский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_56='74:56' # Саткинский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_55='74:55' # Пластовский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_54='74:54' # Октябрьский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_53='74:53' # Озёрский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_52='74:52' # Нязепетровский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_51='74:51' # Нагайбакский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_50='74:50' # Миасский ГО, Челябинская область, (Земли населенных пунктов)
    _8_6_39='86:39' # Сургутский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_37='86:37' # Нижневартовский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_38='86:38' # Октябрьский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_40='86:40' # Ханты-Мансийск муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _7_4_49='74:49' # Магнитогорский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_48='74:48' # Локомотивный ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_47='74:47' # Кыштымский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_68='74:68' # Чесменский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_67='74:67' # Челябинский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_66='74:66' # Чебаркульский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_65='74:65' # Чебаркульский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_64='74:64' # Усть-Катавский ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_63='74:63' # Уйский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_62='74:62' # Увельский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_61='74:61' # Троицкий МР, Челябинская область, (Земли населенных пунктов)
    _7_4_60='74:60' # Троицкий ГО, Челябинская область, (Земли населенных пунктов)
    _8_6_28='86:28' # Городские леса г. Советский, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_29='86:29' # Городские леса г. Сургут, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_26='86:26' # Городские леса г. Пыть-Ях, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_27='86:27' # Городские леса г. Радужный, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_35='86:35' # Кондинский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_36='86:36' # Нефтеюганский муницип. р-он, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_33='86:33' # Городские леса г.Нефтеюганск, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_34='86:34' # Городские леса г.Нижневартовск, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_31='86:31' # Городские леса г. Ханты-Мансийск, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_32='86:32' # Городские леса г. Югорск, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _8_6_30='86:30' # Городские леса г. Урай, Ханты-Мансийский автономный округ - Югра, (Земли населенных пунктов)
    _7_4_59='74:59' # Трёхгорный ГО, Челябинская область, (Земли населенных пунктов)
    _7_4_58='74:58' # Сосновский МР, Челябинская область, (Земли населенных пунктов)
    _7_4_69='74:69' # Южноуральский ГО, Челябинская область, (Земли населенных пунктов)
    _2_8_3='28:3' # Благовещенское, Амурская область, (Земли лесного фонда)
    _2_8_2='28:2' # Белогорское, Амурская область, (Земли лесного фонда)
    _2_8_1='28:1' # Архаринское, Амурская область, (Земли лесного фонда)
    _2_8_9='28:9' # Норское, Амурская область, (Земли лесного фонда)
    _2_8_8='28:8' # Мазановское, Амурская область, (Земли лесного фонда)
    _2_8_7='28:7' # Магдагачинское, Амурская область, (Земли лесного фонда)
    _2_8_6='28:6' # Зейское, Амурская область, (Земли лесного фонда)
    _2_8_5='28:5' # Завитинское, Амурская область, (Земли лесного фонда)
    _2_8_4='28:4' # Бурейское, Амурская область, (Земли лесного фонда)
    _1_5_5='15:5' # Кировское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_4='15:4' # Ирафское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_3='15:3' # Дигорское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_2='15:2' # Владикавказское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_1='15:1' # Алагирское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_9='15:9' # НП Алания, Республика Северная Осетия - Алания, (Земли особо охраняемых природных территорий)
    _1_5_8='15:8' # ГПЗ Северо-Осетинский, Республика Северная Осетия - Алания, (Земли особо охраняемых природных территорий)
    _1_5_7='15:7' # Пригородное, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _1_5_6='15:6' # Моздокское, Республика Северная Осетия - Алания, (Земли лесного фонда)
    _8_19='8:19' # Яшалтинское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_17='8:17' # Черноземельское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_18='8:18' # Юстинское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_11='8:11' # Лаганское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_12='8:12' # Малодербетовское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_10='8:10' # Кетченеровское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_15='8:15' # Сарпинское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_16='8:16' # Целинное АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_13='8:13' # Октябрьское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_14='8:14' # Приютненское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_20='8:20' # Яшкульское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _7_1='7:1' # Баксанское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_2='7:2' # Зольское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_3='7:3' # Лескенское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_4='7:4' # Майское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_5='7:5' # Нальчикское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_6='7:6' # Терское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_7='7:7' # Чегемское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_8='7:8' # Черекское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _7_9='7:9' # Эльбрусское, Кабардино-Балкарская Республика, (Земли лесного фонда)
    _1_8_50='18:50' # Селтинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _1_8_51='18:51' # Сюмсинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _3_1_27='31:27' # Вейделевский, Белгородская область, (Земли населенных пунктов)
    _3_1_26='31:26' # Валуйский, Белгородская область, (Земли населенных пунктов)
    _3_1_29='31:29' # Грайворонский, Белгородская область, (Земли населенных пунктов)
    _3_1_28='31:28' # Волоконовский, Белгородская область, (Земли населенных пунктов)
    _4_3_12='43:12' # Кирсинское, Кировская область, (Земли лесного фонда)
    _4_3_13='43:13' # Котельничское, Кировская область, (Земли лесного фонда)
    _4_3_14='43:14' # Куменское, Кировская область, (Земли лесного фонда)
    _4_3_15='43:15' # Лузское, Кировская область, (Земли лесного фонда)
    _4_3_10='43:10' # Кильмезское, Кировская область, (Земли лесного фонда)
    _4_3_11='43:11' # Кирово-Чепецкое, Кировская область, (Земли лесного фонда)
    _1_8_56='18:56' # Ярский р-он, Удмуртская республика, (Земли населенных пунктов)
    _3_1_34='31:34' # Красногвардейский, Белгородская область, (Земли населенных пунктов)
    _3_1_33='31:33' # Красненский, Белгородская область, (Земли населенных пунктов)
    _3_1_36='31:36' # Новооскольский, Белгородская область, (Земли населенных пунктов)
    _3_1_35='31:35' # Краснояружский, Белгородская область, (Земли населенных пунктов)
    _1_8_52='18:52' # Увинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _3_1_30='31:30' # Губкинский, Белгородская область, (Земли населенных пунктов)
    _1_8_53='18:53' # Шарканский р-он, Удмуртская республика, (Земли населенных пунктов)
    _1_8_54='18:54' # Юкаменский р-он, Удмуртская республика, (Земли населенных пунктов)
    _3_1_32='31:32' # Корочанский, Белгородская область, (Земли населенных пунктов)
    _1_8_55='18:55' # Якшур-Бодьинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _3_1_31='31:31' # Ивнянский, Белгородская область, (Земли населенных пунктов)
    _3_1_19='31:19' # Чернянское, Белгородская область, (Земли лесного фонда)
    _3_1_16='31:16' # Ракитянское, Белгородская область, (Земли лесного фонда)
    _3_1_15='31:15' # Прохоровское, Белгородская область, (Земли лесного фонда)
    _3_1_18='31:18' # Старооскольское, Белгородская область, (Земли лесного фонда)
    _3_1_17='31:17' # Ровеньское, Белгородская область, (Земли лесного фонда)
    _5_5_12='55:12' # Саргатское, Омская область, (Земли лесного фонда)
    _3_1_23='31:23' # Алексеевский, Белгородская область, (Земли населенных пунктов)
    _5_5_11='55:11' # Омское, Омская область, (Земли лесного фонда)
    _3_1_22='31:22' # ГПЗ Белогорье, Белгородская область, (Земли особо охраняемых природных территорий)
    _5_5_10='55:10' # Называевское, Омская область, (Земли лесного фонда)
    _3_1_25='31:25' # Борисовский, Белгородская область, (Земли населенных пунктов)
    _3_1_24='31:24' # Белгородский, Белгородская область, (Земли населенных пунктов)
    _5_5_16='55:16' # Тевризское, Омская область, (Земли лесного фонда)
    _5_5_15='55:15' # Тарское, Омская область, (Земли лесного фонда)
    _5_5_14='55:14' # Степное, Омская область, (Земли лесного фонда)
    _3_1_21='31:21' # Яковлевское, Белгородская область, (Земли лесного фонда)
    _5_5_13='55:13' # Седельниковское, Омская область, (Земли лесного фонда)
    _3_1_20='31:20' # Шебекинское, Белгородская область, (Земли лесного фонда)
    _5_5_19='55:19' # Черлакское, Омская область, (Земли лесного фонда)
    _5_5_18='55:18' # Усть-Ишимское, Омская область, (Земли лесного фонда)
    _5_5_17='55:17' # Тюкалинское, Омская область, (Земли лесного фонда)
    _1_8_38='18:38' # Дебесский р-он, Удмуртская республика, (Земли населенных пунктов)
    _1_8_39='18:39' # Завьяловский р-он, Удмуртская республика, (Земли населенных пунктов)
    _1_8_34='18:34' # г. Можга, Удмуртская республика, (Земли населенных пунктов)
    _5_5_23='55:23' # Горьковский, Омская область, (Земли населенных пунктов)
    _3_1_12='31:12' # Красногвардейское, Белгородская область, (Земли лесного фонда)
    _1_8_35='18:35' # г. Сарапул, Удмуртская республика, (Земли населенных пунктов)
    _5_5_22='55:22' # Большеуковский, Омская область, (Земли населенных пунктов)
    _3_1_11='31:11' # Красненское, Белгородская область, (Земли лесного фонда)
    _1_8_36='18:36' # Глазовский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_21='55:21' # Большереченский, Омская область, (Земли населенных пунктов)
    _3_1_14='31:14' # Новооскольское, Белгородская область, (Земли лесного фонда)
    _1_8_37='18:37' # Граховский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_20='55:20' # Азовский, Омская область, (Земли населенных пунктов)
    _3_1_13='31:13' # Краснояружское, Белгородская область, (Земли лесного фонда)
    _1_8_30='18:30' # Воткинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_27='55:27' # Колосовский, Омская область, (Земли населенных пунктов)
    _1_8_31='18:31' # г. Воткинск, Удмуртская республика, (Земли населенных пунктов)
    _5_5_26='55:26' # Калачинский, Омская область, (Земли населенных пунктов)
    _1_8_32='18:32' # г. Глазов, Удмуртская республика, (Земли населенных пунктов)
    _5_5_25='55:25' # Исилькульский, Омская область, (Земли населенных пунктов)
    _3_1_10='31:10' # Корочанское, Белгородская область, (Земли лесного фонда)
    _1_8_33='18:33' # г. Ижевск (расп. внутри Завьял.р-на), Удмуртская республика, (Земли населенных пунктов)
    _5_5_24='55:24' # Знаменский, Омская область, (Земли населенных пунктов)
    _6_4_5='64:5' # Балашовское, Саратовская область, (Земли лесного фонда)
    _6_4_4='64:4' # Балаковское, Саратовская область, (Земли лесного фонда)
    _6_4_7='64:7' # Вольское, Саратовская область, (Земли лесного фонда)
    _5_5_29='55:29' # Крутинский, Омская область, (Земли населенных пунктов)
    _1_8_40='18:40' # Игринский р-он, Удмуртская республика, (Земли населенных пунктов)
    _6_4_6='64:6' # Балтайское, Саратовская область, (Земли лесного фонда)
    _5_5_28='55:28' # Кормиловский, Омская область, (Земли населенных пунктов)
    _6_4_9='64:9' # Дьяковское, Саратовская область, (Земли лесного фонда)
    _6_4_8='64:8' # Вязовское, Саратовская область, (Земли лесного фонда)
    _6_7_12='67:12' # Краснинское, Смоленская область, (Земли лесного фонда)
    _6_7_13='67:13' # Монастырщинское, Смоленская область, (Земли лесного фонда)
    _6_7_10='67:10' # Кардымовское, Смоленская область, (Земли лесного фонда)
    _6_7_11='67:11' # Кармановское, Смоленская область, (Земли лесного фонда)
    _6_7_16='67:16' # Рославльское, Смоленская область, (Земли лесного фонда)
    _6_4_1='64:1' # Аркадакское, Саратовская область, (Земли лесного фонда)
    _6_7_17='67:17' # Руднянское, Смоленская область, (Земли лесного фонда)
    _6_7_14='67:14' # Новодугинское, Смоленская область, (Земли лесного фонда)
    _6_4_3='64:3' # Базарно-Карабулакское, Саратовская область, (Земли лесного фонда)
    _6_7_15='67:15' # Починковское, Смоленская область, (Земли лесного фонда)
    _6_4_2='64:2' # Аткарское, Саратовская область, (Земли лесного фонда)
    _1_8_49='18:49' # Сарапульский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_30='55:30' # Любинский, Омская область, (Земли населенных пунктов)
    _1_8_45='18:45' # Киясовский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_34='55:34' # Называевский, Омская область, (Земли населенных пунктов)
    _1_8_46='18:46' # Красногорский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_33='55:33' # Муромцевский, Омская область, (Земли населенных пунктов)
    _1_8_47='18:47' # Малопургинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_32='55:32' # Москаленский, Омская область, (Земли населенных пунктов)
    _1_8_48='18:48' # Можгинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_31='55:31' # Марьяновский, Омская область, (Земли населенных пунктов)
    _1_8_41='18:41' # Камбарский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_38='55:38' # Оконешниковский, Омская область, (Земли населенных пунктов)
    _1_8_42='18:42' # Каракулинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_37='55:37' # Одесский, Омская область, (Земли населенных пунктов)
    _1_8_43='18:43' # Кезский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_36='55:36' # Нововаршавский, Омская область, (Земли населенных пунктов)
    _1_8_44='18:44' # Кизнерский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_35='55:35' # Нижнеомский, Омская область, (Земли населенных пунктов)
    _5_5_39='55:39' # Омский, Омская область, (Земли населенных пунктов)
    _6_7_20='67:20' # Сычевское, Смоленская область, (Земли лесного фонда)
    _6_7_23='67:23' # Хиславичское, Смоленская область, (Земли лесного фонда)
    _6_7_24='67:24' # Холм-Жирковское, Смоленская область, (Земли лесного фонда)
    _6_7_21='67:21' # Темкинское, Смоленская область, (Земли лесного фонда)
    _6_7_22='67:22' # Угранское, Смоленская область, (Земли лесного фонда)
    _6_7_27='67:27' # НП Смоленское Поозерье, Смоленская область, (Земли особо охраняемых природных территорий)
    _6_7_28='67:28' # Велижское, Смоленская область, (Земли населенных пунктов)
    _6_7_25='67:25' # Шумячское, Смоленская область, (Земли лесного фонда)
    _6_7_26='67:26' # Ярцевское, Смоленская область, (Земли лесного фонда)
    _6_7_18='67:18' # Сафоновское, Смоленская область, (Земли лесного фонда)
    _6_7_19='67:19' # Смоленское, Смоленская область, (Земли лесного фонда)
    _1_8_16='18:16' # Можгинское, Удмуртская Республика, (Земли лесного фонда)
    _5_5_41='55:41' # Полтавский, Омская область, (Земли населенных пунктов)
    _1_8_17='18:17' # Сарапульское, Удмуртская Республика, (Земли лесного фонда)
    _5_5_40='55:40' # Павлоградский, Омская область, (Земли населенных пунктов)
    _1_8_18='18:18' # Селтинское, Удмуртская Республика, (Земли лесного фонда)
    _7_9_10='79:10' # Муниц.образ."Ленинскийр-он", Еврейская автономная область, (Земли населенных пунктов)
    _1_8_19='18:19' # Сюмсинское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_12='18:12' # Кезское, Удмуртская Республика, (Земли лесного фонда)
    _7_9_12='79:12' # Муниц.образ."Октябрьский р-он", Еврейская автономная область, (Земли населенных пунктов)
    _5_5_45='55:45' # Таврический, Омская область, (Земли населенных пунктов)
    _1_8_13='18:13' # Кизнерское, Удмуртская Республика, (Земли лесного фонда)
    _7_9_11='79:11' # Муниц.образ."Облученский р-он", Еврейская автономная область, (Земли населенных пунктов)
    _5_5_44='55:44' # Седельниковский, Омская область, (Земли населенных пунктов)
    _1_8_14='18:14' # Киясовское, Удмуртская Республика, (Земли лесного фонда)
    _5_5_43='55:43' # Саргатский, Омская область, (Земли населенных пунктов)
    _1_8_15='18:15' # Красногорское, Удмуртская Республика, (Земли лесного фонда)
    _7_9_13='79:13' # Муниц.образ."Смидовичский р-он", Еврейская автономная область, (Земли населенных пунктов)
    _5_5_42='55:42' # Русско-Полянский, Омская область, (Земли населенных пунктов)
    _5_5_49='55:49' # Усть-Ишимский, Омская область, (Земли населенных пунктов)
    _5_5_48='55:48' # Тюкалинский, Омская область, (Земли населенных пунктов)
    _1_8_10='18:10' # Камбарское, Удмуртская Республика, (Земли лесного фонда)
    _5_5_47='55:47' # Тевризский, Омская область, (Земли населенных пунктов)
    _1_8_11='18:11' # Каракулинское, Удмуртская Республика, (Земли лесного фонда)
    _5_5_46='55:46' # Тарский, Омская область, (Земли населенных пунктов)
    _6_7_30='67:30' # г. Десногорск, Смоленская область, (Земли населенных пунктов)
    _6_7_31='67:31' # г. Смоленск, Смоленская область, (Земли населенных пунктов)
    _6_7_34='67:34' # Демидовское, Смоленская область, (Земли населенных пунктов)
    _6_7_35='67:35' # Дорогобужское, Смоленская область, (Земли населенных пунктов)
    _6_7_32='67:32' # Гагаринское, Смоленская область, (Земли населенных пунктов)
    _6_7_33='67:33' # Глинковское, Смоленская область, (Земли населенных пунктов)
    _6_7_38='67:38' # Ершичское, Смоленская область, (Земли населенных пунктов)
    _6_7_39='67:39' # Кардымовское, Смоленская область, (Земли населенных пунктов)
    _6_7_36='67:36' # Духовщинское, Смоленская область, (Земли населенных пунктов)
    _6_7_37='67:37' # Ельнинское, Смоленская область, (Земли населенных пунктов)
    _6_7_29='67:29' # Вяземское, Смоленская область, (Земли населенных пунктов)
    _1_8_27='18:27' # Алнашский р-он, Удмуртская республика, (Земли населенных пунктов)
    _1_8_28='18:28' # Балезинский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_51='55:51' # Щербакульский, Омская область, (Земли населенных пунктов)
    _1_8_29='18:29' # Вавожский р-он, Удмуртская республика, (Земли населенных пунктов)
    _5_5_50='55:50' # Черлакский, Омская область, (Земли населенных пунктов)
    _1_8_23='18:23' # Яганское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_24='18:24' # Якшур-Бодьинское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_25='18:25' # Ярское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_26='18:26' # НП Нечкинский, Удмуртская Республика, (Земли особо охраняемых природных территорий)
    _1_8_20='18:20' # Увинское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_21='18:21' # Шарканское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_22='18:22' # Юкаменское, Удмуртская Республика, (Земли лесного фонда)
    _5_1_6='51:6' # Ловозерское, Мурманская область, (Земли лесного фонда)
    _5_1_7='51:7' # Мончегорское, Мурманская область, (Земли лесного фонда)
    _5_1_8='51:8' # Мурманское, Мурманская область, (Земли лесного фонда)
    _5_1_9='51:9' # Печенгское, Мурманская область, (Земли лесного фонда)
    _6_7_41='67:41' # Монастырщинское, Смоленская область, (Земли населенных пунктов)
    _6_7_42='67:42' # Новодугинское, Смоленская область, (Земли населенных пунктов)
    _6_7_40='67:40' # Краснинское, Смоленская область, (Земли населенных пунктов)
    _6_7_45='67:45' # Руднянское, Смоленская область, (Земли населенных пунктов)
    _6_7_46='67:46' # Сафоновское, Смоленская область, (Земли населенных пунктов)
    _6_7_43='67:43' # Починковское, Смоленская область, (Земли населенных пунктов)
    _6_7_44='67:44' # Рославльское, Смоленская область, (Земли населенных пунктов)
    _5_1_1='51:1' # Зашейковское, Мурманская область, (Земли лесного фонда)
    _6_7_49='67:49' # Темкинское, Смоленская область, (Земли населенных пунктов)
    _5_1_2='51:2' # Кандалакшское, Мурманская область, (Земли лесного фонда)
    _5_1_3='51:3' # Кировское, Мурманская область, (Земли лесного фонда)
    _6_7_47='67:47' # Смоленское, Смоленская область, (Земли населенных пунктов)
    _5_1_4='51:4' # Ковдозерское, Мурманская область, (Земли лесного фонда)
    _6_7_48='67:48' # Сычевское, Смоленская область, (Земли населенных пунктов)
    _5_1_5='51:5' # Кольское, Мурманская область, (Земли лесного фонда)
    _6_7_52='67:52' # Холм-Жирковское, Смоленская область, (Земли населенных пунктов)
    _6_7_53='67:53' # Шумячское, Смоленская область, (Земли населенных пунктов)
    _6_7_50='67:50' # Угранское, Смоленская область, (Земли населенных пунктов)
    _6_7_51='67:51' # Хиславичское, Смоленская область, (Земли населенных пунктов)
    _6_7_54='67:54' # Ярцевское, Смоленская область, (Земли населенных пунктов)
    _4_3_80='43:80' # Яранский район, Кировская область, (Земли населенных пунктов)
    _4_3_70='43:70' # Свечинский район, Кировская область, (Земли населенных пунктов)
    _4_3_71='43:71' # Слободской район, Кировская область, (Земли населенных пунктов)
    _4_3_72='43:72' # Советский район, Кировская область, (Земли населенных пунктов)
    _4_3_73='43:73' # Сунский район, Кировская область, (Земли населенных пунктов)
    _4_3_78='43:78' # Шабалинский район, Кировская область, (Земли населенных пунктов)
    _4_3_79='43:79' # Юрьянский район, Кировская область, (Земли населенных пунктов)
    _4_3_74='43:74' # Тужинский район, Кировская область, (Земли населенных пунктов)
    _4_3_75='43:75' # Унинский район, Кировская область, (Земли населенных пунктов)
    _4_3_76='43:76' # Уржумский район, Кировская область, (Земли населенных пунктов)
    _4_3_77='43:77' # Фаленский район, Кировская область, (Земли населенных пунктов)
    _4_3_60='43:60' # Нагорский район, Кировская область, (Земли населенных пунктов)
    _4_3_61='43:61' # Немский район, Кировская область, (Земли населенных пунктов)
    _4_3_62='43:62' # Нолинский район, Кировская область, (Земли населенных пунктов)
    _4_3_67='43:67' # Пижанский район, Кировская область, (Земли населенных пунктов)
    _4_3_68='43:68' # Подосиновский район, Кировская область, (Земли населенных пунктов)
    _4_3_69='43:69' # Санчурский район, Кировская область, (Земли населенных пунктов)
    _4_3_63='43:63' # Омутнинский район, Кировская область, (Земли населенных пунктов)
    _4_3_64='43:64' # Опаринский район, Кировская область, (Земли населенных пунктов)
    _4_3_65='43:65' # Оричевский район, Кировская область, (Земли населенных пунктов)
    _4_3_66='43:66' # Орловский район, Кировская область, (Земли населенных пунктов)
    _4_3_50='43:50' # Зуевский район, Кировская область, (Земли населенных пунктов)
    _4_3_51='43:51' # Кикнурский район, Кировская область, (Земли населенных пунктов)
    _4_3_56='43:56' # Лебяжский район, Кировская область, (Земли населенных пунктов)
    _4_3_57='43:57' # Лузский район, Кировская область, (Земли населенных пунктов)
    _4_3_58='43:58' # Малмыжский район, Кировская область, (Земли населенных пунктов)
    _4_3_59='43:59' # Мурашинский район, Кировская область, (Земли населенных пунктов)
    _4_3_52='43:52' # Кильмезский район, Кировская область, (Земли населенных пунктов)
    _4_3_53='43:53' # Кирово-Чепецкий район, Кировская область, (Земли населенных пунктов)
    _4_3_54='43:54' # Котельничский район, Кировская область, (Земли населенных пунктов)
    _4_3_55='43:55' # Куменский район, Кировская область, (Земли населенных пунктов)
    _4_3_49='43:49' # Даровской район, Кировская область, (Земли населенных пунктов)
    _4_3_40='43:40' # ГПЗ Нургуш, Кировская область, (Земли особо охраняемых природных территорий)
    _4_3_45='43:45' # Верхнекамский район, Кировская область, (Земли населенных пунктов)
    _2_9_2='29:2' # Березниковское, Архангельская область, (Земли лесного фонда)
    _4_3_46='43:46' # Верхошижемский район, Кировская область, (Земли населенных пунктов)
    _2_9_1='29:1' # Архангельское, Архангельская область, (Земли лесного фонда)
    _4_3_47='43:47' # Вятскополянский район, Кировская область, (Земли населенных пунктов)
    _4_3_48='43:48' # г.Киров, Кировская область, (Земли населенных пунктов)
    _4_3_41='43:41' # Арбажский район, Кировская область, (Земли населенных пунктов)
    _4_3_42='43:42' # Афанасьевский район, Кировская область, (Земли населенных пунктов)
    _4_3_43='43:43' # Белохолуницкий район, Кировская область, (Земли населенных пунктов)
    _4_3_44='43:44' # Богородский район, Кировская область, (Земли населенных пунктов)
    _4_3_38='43:38' # Юрьянское, Кировская область, (Земли лесного фонда)
    _4_3_39='43:39' # Яранское, Кировская область, (Земли лесного фонда)
    _4_3_34='43:34' # Унинское, Кировская область, (Земли лесного фонда)
    _4_3_35='43:35' # Уржумское, Кировская область, (Земли лесного фонда)
    _4_3_36='43:36' # Фаленское, Кировская область, (Земли лесного фонда)
    _4_3_37='43:37' # Шабалинское, Кировская область, (Земли лесного фонда)
    _4_3_30='43:30' # Синегорское, Кировская область, (Земли лесного фонда)
    _4_3_31='43:31' # Слободское, Кировская область, (Земли лесного фонда)
    _4_3_32='43:32' # Сорвижское, Кировская область, (Земли лесного фонда)
    _4_3_33='43:33' # Суводское, Кировская область, (Земли лесного фонда)
    _2_9_9='29:9' # Карпогорское, Архангельская область, (Земли лесного фонда)
    _2_9_8='29:8' # Каргопольское, Архангельская область, (Земли лесного фонда)
    _2_9_7='29:7' # Емецкое, Архангельская область, (Земли лесного фонда)
    _4_3_27='43:27' # Рудниковское, Кировская область, (Земли лесного фонда)
    _2_9_6='29:6' # Выйское, Архангельская область, (Земли лесного фонда)
    _4_3_28='43:28' # Санчурское, Кировская область, (Земли лесного фонда)
    _2_9_5='29:5' # Вилегодское, Архангельская область, (Земли лесного фонда)
    _4_3_29='43:29' # Свечинское, Кировская область, (Земли лесного фонда)
    _2_9_4='29:4' # Верхнетоемское, Архангельская область, (Земли лесного фонда)
    _2_9_3='29:3' # Вельское, Архангельская область, (Земли лесного фонда)
    _3_1_38='31:38' # Ракитянский, Белгородская область, (Земли населенных пунктов)
    _3_1_37='31:37' # Прохоровский, Белгородская область, (Земли населенных пунктов)
    _3_1_39='31:39' # Ровеньский, Белгородская область, (Земли населенных пунктов)
    _4_3_23='43:23' # Оричевское, Кировская область, (Земли лесного фонда)
    _4_3_24='43:24' # Орловское, Кировская область, (Земли лесного фонда)
    _4_3_25='43:25' # Парковое, Кировская область, (Земли лесного фонда)
    _4_3_26='43:26' # Пинюгское, Кировская область, (Земли лесного фонда)
    _4_3_20='43:20' # Нолинское, Кировская область, (Земли лесного фонда)
    _4_3_21='43:21' # Омутнинское, Кировская область, (Земли лесного фонда)
    _4_3_22='43:22' # Опаринское, Кировская область, (Земли лесного фонда)
    _4_3_16='43:16' # Малмыжское, Кировская область, (Земли лесного фонда)
    _4_3_17='43:17' # Мурашинское, Кировская область, (Земли лесного фонда)
    _4_3_18='43:18' # Нагорское, Кировская область, (Земли лесного фонда)
    _4_3_19='43:19' # Немское, Кировская область, (Земли лесного фонда)
    _3_1_41='31:41' # Чернянский, Белгородская область, (Земли населенных пунктов)
    _3_1_40='31:40' # Старооскольский, Белгородская область, (Земли населенных пунктов)
    _3_1_43='31:43' # Яковлевский, Белгородская область, (Земли населенных пунктов)
    _3_1_42='31:42' # Шебекинский, Белгородская область, (Земли населенных пунктов)
    _4_8_23='48:23' # Лебедянский район, Липецкая область, (Земли населенных пунктов)
    _2_4_56='24:56' # Усольское, Красноярский край, (Земли лесного фонда)
    _4_8_22='48:22' # Краснинский район, Липецкая область, (Земли населенных пунктов)
    _2_4_55='24:55' # Усинское, Красноярский край, (Земли лесного фонда)
    _4_8_21='48:21' # Измалковский район, Липецкая область, (Земли населенных пунктов)
    _2_4_58='24:58' # Хребтовское, Красноярский край, (Земли лесного фонда)
    _4_8_20='48:20' # Задонский район, Липецкая область, (Земли населенных пунктов)
    _2_4_57='24:57' # Уярское, Красноярский край, (Земли лесного фонда)
    _2_4_59='24:59' # Чунское, Красноярский край, (Земли лесного фонда)
    _1_6_4='16:4' # Алькеевское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _1_6_3='16:3' # Аксубаевское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _1_6_2='16:2' # Азнакаевское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _4_8_29='48:29' # Усманский район, Липецкая область, (Земли населенных пунктов)
    _2_4_50='24:50' # Тинское, Красноярский край, (Земли лесного фонда)
    _1_6_1='16:1' # Агрызское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _4_8_28='48:28' # Тербунский район, Липецкая область, (Земли населенных пунктов)
    _4_8_27='48:27' # Становлянский район, Липецкая область, (Земли населенных пунктов)
    _2_4_52='24:52' # Туруханское, Красноярский край, (Земли лесного фонда)
    _4_8_26='48:26' # Липецкое, Липецкая область, (Земли населенных пунктов)
    _2_4_51='24:51' # Тунгусско-Чунское, Красноярский край, (Земли лесного фонда)
    _4_8_25='48:25' # Липецкий район, Липецкая область, (Земли населенных пунктов)
    _2_4_54='24:54' # Ужурское, Красноярский край, (Земли лесного фонда)
    _4_8_24='48:24' # Лев-Толстовский район, Липецкая область, (Земли населенных пунктов)
    _2_4_53='24:53' # Тюхтетское, Красноярский край, (Земли лесного фонда)
    _3_6_45='36:45' # Острогожский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_46='36:46' # Павловский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_47='36:47' # Панинский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_48='36:48' # Петропавловский муниц. р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_49='36:49' # Поворинский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_40='36:40' # Лискинский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_41='36:41' # Нижнедевицкий муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_42='36:42' # Новоусманский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_43='36:43' # Новохоперский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_44='36:44' # Ольховатский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _4_8_12='48:12' # г. Елец, Липецкая область, (Земли населенных пунктов)
    _2_4_67='24:67' # ГПЗ Столбы, Красноярский край, (Земли особо охраняемых природных территорий)
    _4_8_11='48:11' # Воловский район, Липецкая область, (Земли населенных пунктов)
    _2_4_66='24:66' # ГПЗ Путоранский, Красноярский край, (Земли особо охраняемых природных территорий)
    _4_8_10='48:10' # ГПЗ Галичья гора, Липецкая область, (Земли особо охраняемых природных территорий)
    _2_4_69='24:69' # НП Шушенский бор, Красноярский край, (Земли особо охраняемых природных территорий)
    _2_4_68='24:68' # ГПЗ Тунгусский, Красноярский край, (Земли особо охраняемых природных территорий)
    _4_8_19='48:19' # Елецкий район, Липецкая область, (Земли населенных пунктов)
    _4_8_18='48:18' # Долгоруковский район, Липецкая область, (Земли населенных пунктов)
    _2_4_61='24:61' # Эвенкийское, Красноярский край, (Земли лесного фонда)
    _4_8_17='48:17' # Добровский район, Липецкая область, (Земли населенных пунктов)
    _2_4_60='24:60' # Шарыповское, Красноярский край, (Земли лесного фонда)
    _4_8_16='48:16' # Добринский район, Липецкая область, (Земли населенных пунктов)
    _2_4_63='24:63' # ГПБЗ Таймырский, Красноярский край, (Земли особо охраняемых природных территорий)
    _4_8_15='48:15' # Данковский район, Липецкая область, (Земли населенных пунктов)
    _2_4_62='24:62' # ГПБЗ Саяно-Шушенский, Красноярский край, (Земли особо охраняемых природных территорий)
    _6_1_10='61:10' # Романовское, Ростовская область, (Земли лесного фонда)
    _4_8_14='48:14' # Грязинский район, Липецкая область, (Земли населенных пунктов)
    _2_4_65='24:65' # ГПЗ Большой Арктический, Красноярский край, (Земли особо охраняемых природных территорий)
    _6_1_11='61:11' # Сальское, Ростовская область, (Земли лесного фонда)
    _4_8_13='48:13' # г. Липецк, Липецкая область, (Земли населенных пунктов)
    _2_4_64='24:64' # ГПБЗ Центральносибирский, Красноярский край, (Земли особо охраняемых природных территорий)
    _3_6_34='36:34' # Городской округ - город Воронеж, Воронежская область, (Земли населенных пунктов)
    _3_6_35='36:35' # Грибановский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_36='36:36' # Калачеевский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _1_6_9='16:9' # Болгарское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _3_6_37='36:37' # Каменский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _1_6_8='16:8' # Билярское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _3_6_38='36:38' # Кантемировский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _1_6_7='16:7' # Бавлинское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _3_6_39='36:39' # Каширский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _1_6_6='16:6' # Арское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _1_6_5='16:5' # Альметьевское, Республика Татарстан (Татарстан), (Земли лесного фонда)
    _3_6_30='36:30' # Верхнемамонский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_31='36:31' # Верхнехавский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_32='36:32' # Воробьевский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_33='36:33' # Гор.округ - город Нововоронеж, Воронежская область, (Земли населенных пунктов)
    _2_4_34='24:34' # Минусинское, Красноярский край, (Земли лесного фонда)
    _2_4_33='24:33' # Мининское, Красноярский край, (Земли лесного фонда)
    _2_4_36='24:36' # Назаровское, Красноярский край, (Земли лесного фонда)
    _2_4_35='24:35' # Мотыгинское, Красноярский край, (Земли лесного фонда)
    _2_4_38='24:38' # Нижне-Енисейское, Красноярский край, (Земли лесного фонда)
    _2_4_37='24:37' # Невонское, Красноярский край, (Земли лесного фонда)
    _2_4_39='24:39' # Новоселовское, Красноярский край, (Земли лесного фонда)
    _2_4_30='24:30' # Маганское, Красноярский край, (Земли лесного фонда)
    _6_1_20='61:20' # Азовское, Ростовская область, (Земли населенных пунктов)
    _6_1_21='61:21' # Аксайское, Ростовская область, (Земли населенных пунктов)
    _2_4_32='24:32' # Манское, Красноярский край, (Земли лесного фонда)
    _6_1_22='61:22' # Багаевское, Ростовская область, (Земли населенных пунктов)
    _2_4_31='24:31' # Манзенское, Красноярский край, (Земли лесного фонда)
    _6_1_12='61:12' # Селивановское, Ростовская область, (Земли лесного фонда)
    _3_6_23='36:23' # Эртильское, Воронежская область, (Земли лесного фонда)
    _6_1_13='61:13' # Семикаракорское, Ростовская область, (Земли лесного фонда)
    _3_6_24='36:24' # ГПЗ Хоперский, Воронежская область, (Земли особо охраняемых природных территорий)
    _6_1_14='61:14' # Тарасовское, Ростовская область, (Земли лесного фонда)
    _3_6_25='36:25' # Аннинский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _6_1_15='61:15' # Усть-Донецкое, Ростовская область, (Земли лесного фонда)
    _3_6_26='36:26' # Бобровский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _6_1_16='61:16' # Чертковское, Ростовская область, (Земли лесного фонда)
    _3_6_27='36:27' # Богучарский муниципальный райоy, Воронежская область, (Земли населенных пунктов)
    _6_1_17='61:17' # Шахтинское, Ростовская область, (Земли лесного фонда)
    _3_6_28='36:28' # Борисоглебский городской округ, Воронежская область, (Земли населенных пунктов)
    _6_1_18='61:18' # Шолоховское, Ростовская область, (Земли лесного фонда)
    _3_6_29='36:29' # Бутурлиновский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _6_1_19='61:19' # ГПБЗ Ростовский, Ростовская область, (Земли особо охраняемых природных территорий)
    _3_6_20='36:20' # Сомовское, Воронежская область, (Земли лесного фонда)
    _3_6_21='36:21' # Теллермановское, Воронежская область, (Земли лесного фонда)
    _3_6_22='36:22' # Хреновское, Воронежская область, (Земли лесного фонда)
    _7_3_12='73:12' # Павловское, Ульяновская область, (Земли лесного фонда)
    _2_4_45='24:45' # Северо-Енисейское, Красноярский край, (Земли лесного фонда)
    _7_3_11='73:11' # Новочеремшанское, Ульяновская область, (Земли лесного фонда)
    _2_4_44='24:44' # Саянское, Красноярский край, (Земли лесного фонда)
    _7_3_10='73:10' # Новоспасское, Ульяновская область, (Земли лесного фонда)
    _2_4_47='24:47' # Таежинское, Красноярский край, (Земли лесного фонда)
    _2_4_46='24:46' # Сухобузимское, Красноярский край, (Земли лесного фонда)
    _2_4_49='24:49' # Терянское, Красноярский край, (Земли лесного фонда)
    _2_4_48='24:48' # Таймырское, Красноярский край, (Земли лесного фонда)
    _6_1_30='61:30' # г. Гуково, Ростовская область, (Земли населенных пунктов)
    _2_4_41='24:41' # Пойменское, Красноярский край, (Земли лесного фонда)
    _6_1_31='61:31' # г. Донецк, Ростовская область, (Земли населенных пунктов)
    _2_4_40='24:40' # Пировское, Красноярский край, (Земли лесного фонда)
    _6_1_32='61:32' # г. Зверево, Ростовская область, (Земли населенных пунктов)
    _2_4_43='24:43' # Саяно-Шушенское, Красноярский край, (Земли лесного фонда)
    _6_1_33='61:33' # г. Каменск - Шахтинский, Ростовская область, (Земли населенных пунктов)
    _2_4_42='24:42' # Рыбинское, Красноярский край, (Земли лесного фонда)
    _6_1_23='61:23' # Белокалитвенское, Ростовская область, (Земли населенных пунктов)
    _3_6_12='36:12' # Новохоперское, Воронежская область, (Земли лесного фонда)
    _6_1_24='61:24' # Боковское, Ростовская область, (Земли населенных пунктов)
    _3_6_13='36:13' # Острогожское, Воронежская область, (Земли лесного фонда)
    _6_1_25='61:25' # Верхнедонское, Ростовская область, (Земли населенных пунктов)
    _3_6_14='36:14' # Павловское, Воронежская область, (Земли лесного фонда)
    _6_1_26='61:26' # Веселовское, Ростовская область, (Земли населенных пунктов)
    _3_6_15='36:15' # Песковское, Воронежская область, (Земли лесного фонда)
    _6_1_27='61:27' # Волгодонское, Ростовская область, (Земли населенных пунктов)
    _3_6_16='36:16' # Пригородное, Воронежская область, (Земли лесного фонда)
    _6_1_28='61:28' # г. Батайск, Ростовская область, (Земли населенных пунктов)
    _3_6_17='36:17' # Россошанское, Воронежская область, (Земли лесного фонда)
    _6_1_29='61:29' # г. Волгодонск, Ростовская область, (Земли населенных пунктов)
    _3_6_18='36:18' # Савальское, Воронежская область, (Земли лесного фонда)
    _3_6_19='36:19' # Семилукское, Воронежская область, (Земли лесного фонда)
    _3_6_10='36:10' # Кантемировское, Воронежская область, (Земли лесного фонда)
    _3_6_11='36:11' # Новоусманское, Воронежская область, (Земли лесного фонда)
    _7_3_23='73:23' # г.Барыш, Ульяновская область, (Земли населенных пунктов)
    _2_4_12='24:12' # Даурское, Красноярский край, (Земли лесного фонда)
    _7_3_22='73:22' # Вешкаймский, Ульяновская область, (Земли населенных пунктов)
    _2_4_11='24:11' # Гремучинское, Красноярский край, (Земли лесного фонда)
    _7_3_21='73:21' # Барышский, Ульяновская область, (Земли населенных пунктов)
    _2_4_14='24:14' # Долгомостовское, Красноярский край, (Земли лесного фонда)
    _7_3_20='73:20' # Базарно-Сызганский, Ульяновская область, (Земли населенных пунктов)
    _2_4_13='24:13' # Дзержинское, Красноярский край, (Земли лесного фонда)
    _2_4_16='24:16' # Енисейское, Красноярский край, (Земли лесного фонда)
    _2_4_15='24:15' # Емельяновское, Красноярский край, (Земли лесного фонда)
    _2_4_18='24:18' # Идринское, Красноярский край, (Земли лесного фонда)
    _2_4_17='24:17' # Ермаковское, Красноярский край, (Земли лесного фонда)
    _1_2_29='12:29' # Мари-Турекский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_40='61:40' # г.Миллерово, Ростовская область, (Земли населенных пунктов)
    _6_1_41='61:41' # г.Пролетарск, Ростовская область, (Земли населенных пунктов)
    _6_1_42='61:42' # г.Сальск, Ростовская область, (Земли населенных пунктов)
    _6_1_43='61:43' # Дубовское, Ростовская область, (Земли населенных пунктов)
    _2_4_10='24:10' # Верхнеманское, Красноярский край, (Земли лесного фонда)
    _6_1_44='61:44' # Егорлыкское, Ростовская область, (Земли населенных пунктов)
    _1_2_34='12:34' # Параньгинский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_34='61:34' # г. Новочеркасск, Ростовская область, (Земли населенных пунктов)
    _1_2_35='12:35' # Сернурский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_35='61:35' # г. Новошахтинск, Ростовская область, (Земли населенных пунктов)
    _1_2_32='12:32' # Новоторъяльский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_36='61:36' # г. Ростов-на-Дону, Ростовская область, (Земли населенных пунктов)
    _1_2_33='12:33' # Оршанский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_37='61:37' # г. Таганрог, Ростовская область, (Земли населенных пунктов)
    _6_1_38='61:38' # г. Шахты, Ростовская область, (Земли населенных пунктов)
    _6_1_39='61:39' # г.Красный Сулин, Ростовская область, (Земли населенных пунктов)
    _1_2_36='12:36' # Советский район, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_37='12:37' # Юринский район, Республика Марий Эл, (Земли населенных пунктов)
    _7_3_19='73:19' # Ульяновское, Ульяновская область, (Земли лесного фонда)
    _7_3_18='73:18' # Тереньгульское, Ульяновская область, (Земли лесного фонда)
    _7_3_17='73:17' # Сурское, Ульяновская область, (Земли лесного фонда)
    _1_2_30='12:30' # Медведевский район, Республика Марий Эл, (Земли населенных пунктов)
    _7_3_16='73:16' # Старомайнское, Ульяновская область, (Земли лесного фонда)
    _1_2_31='12:31' # Моркийнский район, Республика Марий Эл, (Земли населенных пунктов)
    _7_3_15='73:15' # Старокулаткинское, Ульяновская область, (Земли лесного фонда)
    _7_3_14='73:14' # Сенгилеевское, Ульяновская область, (Земли лесного фонда)
    _7_3_13='73:13' # Радищевское, Ульяновская область, (Земли лесного фонда)
    _7_3_34='73:34' # Павловский, Ульяновская область, (Земли населенных пунктов)
    _2_4_23='24:23' # Каратузское, Красноярский край, (Земли лесного фонда)
    _7_3_33='73:33' # Новоспасский, Ульяновская область, (Земли населенных пунктов)
    _2_4_22='24:22' # Канское, Красноярский край, (Земли лесного фонда)
    _7_3_32='73:32' # Новомалыклинский, Ульяновская область, (Земли населенных пунктов)
    _2_4_25='24:25' # Кодинское, Красноярский край, (Земли лесного фонда)
    _7_3_31='73:31' # Николаевский, Ульяновская область, (Земли населенных пунктов)
    _2_4_24='24:24' # Кизирское, Красноярский край, (Земли лесного фонда)
    _7_3_30='73:30' # Мелекесский, Ульяновская область, (Земли населенных пунктов)
    _2_4_27='24:27' # Краснотуранское, Красноярский край, (Земли лесного фонда)
    _2_4_26='24:26' # Козульское, Красноярский край, (Земли лесного фонда)
    _2_4_29='24:29' # Курагинское, Красноярский край, (Земли лесного фонда)
    _2_4_28='24:28' # Красноярское, Красноярский край, (Земли лесного фонда)
    _6_1_50='61:50' # Кашарское, Ростовская область, (Земли населенных пунктов)
    _6_1_51='61:51' # Константиновское, Ростовская область, (Земли населенных пунктов)
    _6_1_52='61:52' # Красносулинское, Ростовская область, (Земли населенных пунктов)
    _6_1_53='61:53' # Куйбышевское, Ростовская область, (Земли населенных пунктов)
    _6_1_54='61:54' # Мартыновское, Ростовская область, (Земли населенных пунктов)
    _2_4_21='24:21' # Казачинское, Красноярский край, (Земли лесного фонда)
    _6_1_55='61:55' # Матвеево-Курганское, Ростовская область, (Земли населенных пунктов)
    _2_4_20='24:20' # Ирбейское, Красноярский край, (Земли лесного фонда)
    _6_1_45='61:45' # Заветинское, Ростовская область, (Земли населенных пунктов)
    _6_1_46='61:46' # Зерноградское, Ростовская область, (Земли населенных пунктов)
    _6_1_47='61:47' # Зимовниковское, Ростовская область, (Земли населенных пунктов)
    _6_1_48='61:48' # Кагальницкое, Ростовская область, (Земли населенных пунктов)
    _6_1_49='61:49' # Каменское, Ростовская область, (Земли населенных пунктов)
    _2_4_19='24:19' # Иланское, Красноярский край, (Земли лесного фонда)
    _7_3_29='73:29' # Майнский, Ульяновская область, (Земли населенных пунктов)
    _0_0_28='00:28' # Ярославское, Волгоградская область, Кабардино-Балкарская Республика, Краснодарский край, Республика Адыгея (Адыгея), Республика Северная Осетия - Алания, (Земли обороны и безопасности)
    _7_3_28='73:28' # Кузоватовский, Ульяновская область, (Земли населенных пунктов)
    _7_3_27='73:27' # Карсунский, Ульяновская область, (Земли населенных пунктов)
    _7_3_26='73:26' # Инзенский, Ульяновская область, (Земли населенных пунктов)
    _7_3_25='73:25' # г.Ульяновск, Ульяновская область, (Земли населенных пунктов)
    _7_3_24='73:24' # г.Дмитровград, Ульяновская область, (Земли населенных пунктов)
    _7_3_43='73:43' # Чердаклинский, Ульяновская область, (Земли населенных пунктов)
    _7_3_42='73:42' # Цильнинский, Ульяновская область, (Земли населенных пунктов)
    _7_3_41='73:41' # Ульяновский, Ульяновская область, (Земли населенных пунктов)
    _7_3_40='73:40' # Тереньгульский, Ульяновская область, (Земли населенных пунктов)
    _6_1_60='61:60' # Неклиновское, Ростовская область, (Земли населенных пунктов)
    _6_1_61='61:61' # Обливское, Ростовская область, (Земли населенных пунктов)
    _6_1_62='61:62' # Октябрьское, Ростовская область, (Земли населенных пунктов)
    _6_1_63='61:63' # Орловское, Ростовская область, (Земли населенных пунктов)
    _6_1_64='61:64' # Песчанокопское, Ростовская область, (Земли населенных пунктов)
    _6_1_65='61:65' # Пролетарское, Ростовская область, (Земли населенных пунктов)
    _6_1_66='61:66' # Радионово-Несветаевское, Ростовская область, (Земли населенных пунктов)
    _1_2_12='12:12' # Оршанское, Республика Марий Эл, (Земли лесного фонда)
    _6_1_56='61:56' # Миллеровское, Ростовская область, (Земли населенных пунктов)
    _1_2_13='12:13' # Параньгинское, Республика Марий Эл, (Земли лесного фонда)
    _6_1_57='61:57' # Милютинское, Ростовская область, (Земли населенных пунктов)
    _1_2_10='12:10' # Моркинское, Республика Марий Эл, (Земли лесного фонда)
    _6_1_58='61:58' # Морозовское, Ростовская область, (Земли населенных пунктов)
    _1_2_11='12:11' # Новоторъяльское, Республика Марий Эл, (Земли лесного фонда)
    _6_1_59='61:59' # Мясниковское, Ростовская область, (Земли населенных пунктов)
    _1_2_16='12:16' # Сернурское, Республика Марий Эл, (Земли лесного фонда)
    _1_2_17='12:17' # Советское, Республика Марий Эл, (Земли лесного фонда)
    _1_2_14='12:14' # Пригородное, Республика Марий Эл, (Земли лесного фонда)
    _1_2_15='12:15' # Руткинское, Республика Марий Эл, (Земли лесного фонда)
    _7_3_39='73:39' # Сурский, Ульяновская область, (Земли населенных пунктов)
    _7_3_38='73:38' # Старомайнский, Ульяновская область, (Земли населенных пунктов)
    _7_3_37='73:37' # Старокулаткинский, Ульяновская область, (Земли населенных пунктов)
    _7_3_36='73:36' # Сенгилеевский, Ульяновская область, (Земли населенных пунктов)
    _7_3_35='73:35' # Радищевский, Ульяновская область, (Земли населенных пунктов)
    _6_1_70='61:70' # Советское, Ростовская область, (Земли населенных пунктов)
    _6_1_71='61:71' # Тарасовское, Ростовская область, (Земли населенных пунктов)
    _1_2_18='12:18' # Юринское, Республика Марий Эл, (Земли лесного фонда)
    _6_1_72='61:72' # Тацинское, Ростовская область, (Земли населенных пунктов)
    _1_2_19='12:19' # ГПЗ Большая Кокшага, Республика Марий Эл, (Земли особо охраняемых природных территорий)
    _6_1_73='61:73' # Усть-Донецкое, Ростовская область, (Земли населенных пунктов)
    _6_1_74='61:74' # Целинское, Ростовская область, (Земли населенных пунктов)
    _6_1_75='61:75' # Цимлянское, Ростовская область, (Земли населенных пунктов)
    _6_1_76='61:76' # Чертковское, Ростовская область, (Земли населенных пунктов)
    _6_1_77='61:77' # Шолоховское, Ростовская область, (Земли населенных пунктов)
    _1_2_23='12:23' # г.Йошкар-Ола, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_67='61:67' # Ремонтненское, Ростовская область, (Земли населенных пунктов)
    _1_2_24='12:24' # г.Козьмодемьянск, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_68='61:68' # Сальское, Ростовская область, (Земли населенных пунктов)
    _1_2_21='12:21' # Волжский район, Республика Марий Эл, (Земли населенных пунктов)
    _6_1_69='61:69' # Семикаракорское, Ростовская область, (Земли населенных пунктов)
    _1_2_22='12:22' # г.Волжск, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_27='12:27' # Килемарский район, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_28='12:28' # Куженерский район, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_25='12:25' # Горномарийский район, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_26='12:26' # Звениговский район, Республика Марий Эл, (Земли населенных пунктов)
    _1_2_20='12:20' # НП Марий Чодра, Республика Марий Эл, (Земли особо охраняемых природных территорий)
    _8_1='8:1' # Башантинское, Республика Калмыкия, (Земли лесного фонда)
    _8_2='8:2' # Ергенинское, Республика Калмыкия, (Земли лесного фонда)
    _8_3='8:3' # Каспийское, Республика Калмыкия, (Земли лесного фонда)
    _8_4='8:4' # Октябрьское, Республика Калмыкия, (Земли лесного фонда)
    _8_5='8:5' # Элистинское, Республика Калмыкия, (Земли лесного фонда)
    _8_6='8:6' # ГПБЗ Черные Земли, Республика Калмыкия, (Земли особо охраняемых природных территорий)
    _8_7='8:7' # г.Элиста, Республика Калмыкия, (Земли населенных пунктов)
    _8_8='8:8' # Городовиковское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _8_9='8:9' # Ики-Бурульское АТО, Республика Калмыкия, (Земли населенных пунктов)
    _2_4_99='24:99' # Енисейский, Красноярский край, (Земли населенных пунктов)
    _2_4_92='24:92' # г.Минусинск, Красноярский край, (Земли населенных пунктов)
    _2_4_91='24:91' # г.Лесосибирск, Красноярский край, (Земли населенных пунктов)
    _2_4_94='24:94' # г.Норильск, Красноярский край, (Земли населенных пунктов)
    _2_4_93='24:93' # г.Назарово, Красноярский край, (Земли населенных пунктов)
    _2_4_96='24:96' # г.Шарыпово, Красноярский край, (Земли населенных пунктов)
    _2_4_95='24:95' # г.Сосновоборск, Красноярский край, (Земли населенных пунктов)
    _2_4_98='24:98' # Емельяновский, Красноярский край, (Земли населенных пунктов)
    _2_4_97='24:97' # Дзержинский, Красноярский край, (Земли населенных пунктов)
    _2_2_103='22:103' # Шипуновский район, Алтайский край, (Земли населенных пунктов)
    _2_2_101='22:101' # Чарышский район, Алтайский край, (Земли населенных пунктов)
    _2_4_90='24:90' # г.Красноярск, Красноярский край, (Земли населенных пунктов)
    _2_2_102='22:102' # Шелаболихинский район, Алтайский край, (Земли населенных пунктов)
    _2_2_100='22:100' # Целинний район, Алтайский край, (Земли населенных пунктов)
    _2_4_78='24:78' # Большемуртинский, Красноярский край, (Земли населенных пунктов)
    _2_4_77='24:77' # Богучанский, Красноярский край, (Земли населенных пунктов)
    _2_4_79='24:79' # Большеулуйский, Красноярский край, (Земли населенных пунктов)
    _2_4_70='24:70' # Красноярское, Красноярский край, (Земли обороны и безопасности)
    _2_4_72='24:72' # Ачинский, Красноярский край, (Земли населенных пунктов)
    _2_4_71='24:71' # Абанский, Красноярский край, (Земли населенных пунктов)
    _2_4_74='24:74' # Березовский, Красноярский край, (Земли населенных пунктов)
    _2_4_73='24:73' # Балахтинский, Красноярский край, (Земли населенных пунктов)
    _2_4_76='24:76' # Боготольский, Красноярский край, (Земли населенных пунктов)
    _2_4_75='24:75' # Бирилюсский, Красноярский край, (Земли населенных пунктов)
    _2_4_89='24:89' # г.Канск, Красноярский край, (Земли населенных пунктов)
    _2_4_88='24:88' # г.Игарка, Красноярский край, (Земли населенных пунктов)
    _4_8_31='48:31' # Чаплыгинский район, Липецкая область, (Земли населенных пунктов)
    _4_8_30='48:30' # Хлевенский район, Липецкая область, (Земли населенных пунктов)
    _2_4_81='24:81' # г.Боготол, Красноярский край, (Земли населенных пунктов)
    _2_4_80='24:80' # г.Ачинск, Красноярский край, (Земли населенных пунктов)
    _2_4_83='24:83' # г.Дивногорск, Красноярский край, (Земли населенных пунктов)
    _2_4_82='24:82' # г.Бородино, Красноярский край, (Земли населенных пунктов)
    _2_4_85='24:85' # г.Железногорск, Красноярский край, (Земли населенных пунктов)
    _2_4_84='24:84' # г.Енисейск, Красноярский край, (Земли населенных пунктов)
    _2_4_87='24:87' # г.Зеленогорск, Красноярский край, (Земли населенных пунктов)
    _2_4_86='24:86' # г.Заозерный, Красноярский край, (Земли населенных пунктов)
    _3_6_56='36:56' # Терновский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_57='36:57' # Хохольский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_58='36:58' # Эртильский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_50='36:50' # Подгоренский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_51='36:51' # Рамонский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_52='36:52' # Репьевский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_53='36:53' # Россошанский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_54='36:54' # Семилукский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _3_6_55='36:55' # Таловский муниципальный р-он, Воронежская область, (Земли населенных пунктов)
    _6_5_4='65:4' # Корсаковское, Сахалинская область, (Земли лесного фонда)
    _6_5_3='65:3' # Долинское, Сахалинская область, (Земли лесного фонда)
    _6_5_6='65:6' # Курильское, Сахалинская область, (Земли лесного фонда)
    _6_5_5='65:5' # Красногорское, Сахалинская область, (Земли лесного фонда)
    _6_5_8='65:8' # Невельское, Сахалинская область, (Земли лесного фонда)
    _6_5_7='65:7' # Макаровское, Сахалинская область, (Земли лесного фонда)
    _6_5_9='65:9' # Ногликское, Сахалинская область, (Земли лесного фонда)
    _6_5_2='65:2' # Анивское, Сахалинская область, (Земли лесного фонда)
    _6_5_1='65:1' # Александровское, Сахалинская область, (Земли лесного фонда)
    _2_19='2:19' # Кананикольское, Республика Башкортостан, (Земли лесного фонда)
    _2_10='2:10' # Бирское, Республика Башкортостан, (Земли лесного фонда)
    _2_18='2:18' # Инзерское, Республика Башкортостан, (Земли лесного фонда)
    _2_17='2:17' # Иглинское, Республика Башкортостан, (Земли лесного фонда)
    _2_16='2:16' # Зилаирское, Республика Башкортостан, (Земли лесного фонда)
    _2_15='2:15' # Зианчуринское, Республика Башкортостан, (Земли лесного фонда)
    _2_14='2:14' # Дюртюлинское, Республика Башкортостан, (Земли лесного фонда)
    _2_13='2:13' # Дуванское, Республика Башкортостан, (Земли лесного фонда)
    _2_12='2:12' # Гафурийское, Республика Башкортостан, (Земли лесного фонда)
    _2_11='2:11' # Бурзянское, Республика Башкортостан, (Земли лесного фонда)
    _5_2_5='52:5' # Бутурлинское межрайонное, Нижегородская область, (Земли лесного фонда)
    _5_2_6='52:6' # Варнавинское районное, Нижегородская область, (Земли лесного фонда)
    _5_2_7='52:7' # Вачское районное, Нижегородская область, (Земли лесного фонда)
    _5_2_8='52:8' # Ветлужское районное, Нижегородская область, (Земли лесного фонда)
    _5_2_9='52:9' # Вознесенское межрайонное, Нижегородская область, (Земли лесного фонда)
    _5_2_1='52:1' # Арзамасское межрайонное, Нижегородская область, (Земли лесного фонда)
    _5_2_2='52:2' # Балахнинское межрайонное, Нижегородская область, (Земли лесного фонда)
    _5_2_3='52:3' # Богородское районное, Нижегородская область, (Земли лесного фонда)
    _5_2_4='52:4' # Борское районное, Нижегородская область, (Земли лесного фонда)
    _2_21='2:21' # Кугарчинское, Республика Башкортостан, (Земли лесного фонда)
    _2_20='2:20' # Караидельское, Республика Башкортостан, (Земли лесного фонда)
    _2_29='2:29' # Учалинское, Республика Башкортостан, (Земли лесного фонда)
    _2_28='2:28' # Уфимское, Республика Башкортостан, (Земли лесного фонда)
    _2_27='2:27' # Туймазинское, Республика Башкортостан, (Земли лесного фонда)
    _2_26='2:26' # Тирлянское, Республика Башкортостан, (Земли лесного фонда)
    _2_25='2:25' # Стерлитамакское, Республика Башкортостан, (Земли лесного фонда)
    _2_24='2:24' # Салаватское, Республика Башкортостан, (Земли лесного фонда)
    _2_23='2:23' # Нуримановское, Республика Башкортостан, (Земли лесного фонда)
    _2_22='2:22' # Макаровское, Республика Башкортостан, (Земли лесного фонда)
    _2_32='2:32' # ГПЗ Башкирский, Республика Башкортостан, (Земли особо охраняемых природных территорий)
    _2_31='2:31' # Янаульское, Республика Башкортостан, (Земли лесного фонда)
    _2_30='2:30' # Хайбуллинское, Республика Башкортостан, (Земли лесного фонда)
    _2_39='2:39' # Аскинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_38='2:38' # Архангельский, Республика Башкортостан, (Земли населенных пунктов)
    _2_37='2:37' # Альшеевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_36='2:36' # Абзелиловский, Республика Башкортостан, (Земли населенных пунктов)
    _2_35='2:35' # Башкирское, Республика Башкортостан, (Земли обороны и безопасности)
    _2_34='2:34' # НП Башкирия, Республика Башкортостан, (Земли особо охраняемых природных территорий)
    _2_33='2:33' # ГПЗ Шульган-Таш, Республика Башкортостан, (Земли особо охраняемых природных территорий)
    _2_43='2:43' # Балтачевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_42='2:42' # Бакалинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_41='2:41' # Баймакский, Республика Башкортостан, (Земли населенных пунктов)
    _2_40='2:40' # Аургазинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_49='2:49' # Благоварский, Республика Башкортостан, (Земли населенных пунктов)
    _2_48='2:48' # Бирский, Республика Башкортостан, (Земли населенных пунктов)
    _2_47='2:47' # Бижбулякский, Республика Башкортостан, (Земли населенных пунктов)
    _2_46='2:46' # Белорецкий, Республика Башкортостан, (Земли населенных пунктов)
    _2_45='2:45' # Белокатайский, Республика Башкортостан, (Земли населенных пунктов)
    _2_44='2:44' # Белебеевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_54='2:54' # г. Белебей, Республика Башкортостан, (Земли населенных пунктов)
    _2_53='2:53' # Бурзянский, Республика Башкортостан, (Земли населенных пунктов)
    _2_52='2:52' # Бураевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_51='2:51' # Буздякский, Республика Башкортостан, (Земли населенных пунктов)
    _2_50='2:50' # Благовещенский, Республика Башкортостан, (Земли населенных пунктов)
    _2_59='2:59' # г. Салават, Республика Башкортостан, (Земли населенных пунктов)
    _2_58='2:58' # г. Октябрьский, Республика Башкортостан, (Земли населенных пунктов)
    _2_57='2:57' # г. Межгорье, Республика Башкортостан, (Земли населенных пунктов)
    _2_56='2:56' # г. Кумертау, Республика Башкортостан, (Земли населенных пунктов)
    _2_55='2:55' # г. Ишимбай, Республика Башкортостан, (Земли населенных пунктов)
    _2_65='2:65' # Дюртюлинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_64='2:64' # Дуванский, Республика Башкортостан, (Земли населенных пунктов)
    _2_63='2:63' # Давлекановский, Республика Башкортостан, (Земли населенных пунктов)
    _2_62='2:62' # Гафурийский, Республика Башкортостан, (Земли населенных пунктов)
    _2_61='2:61' # г. Уфа, Республика Башкортостан, (Земли населенных пунктов)
    _2_60='2:60' # г. Стерлитамак, Республика Башкортостан, (Земли населенных пунктов)
    _2_69='2:69' # Иглинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_68='2:68' # Зилаирский, Республика Башкортостан, (Земли населенных пунктов)
    _2_67='2:67' # Зианчуринский, Республика Башкортостан, (Земли населенных пунктов)
    _2_66='2:66' # Ермекеевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_76='2:76' # Краснокамский, Республика Башкортостан, (Земли населенных пунктов)
    _2_75='2:75' # Кигинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_74='2:74' # Кармаскалинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_73='2:73' # Караидельский, Республика Башкортостан, (Земли населенных пунктов)
    _2_72='2:72' # Калтасинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_71='2:71' # Ишимбайский, Республика Башкортостан, (Земли населенных пунктов)
    _2_70='2:70' # Илишевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_79='2:79' # Куюргазинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_78='2:78' # Кушнаренковский, Республика Башкортостан, (Земли населенных пунктов)
    _2_77='2:77' # Кугарчинский, Республика Башкортостан, (Земли населенных пунктов)
    _0_0_23='00:23' # Свердловское, Курганская область, Свердловская область, (Земли обороны и безопасности)
    _0_0_22='00:22' # Пермское, Пермский край, Удмуртская Республика, (Земли обороны и безопасности)
    _0_0_21='00:21' # Пензенское, Пензенская область, Саратовская область, Ульяновская область, (Земли обороны и безопасности)
    _0_0_20='00:20' # Новосибирское, Кемеровская область, Новосибирская область, Омская область, Томская область, (Земли обороны и безопасности)
    _0_0_27='00:27' # Читинское, Забайкальский край, Республика Бурятия, (Земли обороны и безопасности)
    _0_0_26='00:26' # Хвойное, Вологодская область, Ленинградская область, Мурманская область, Республика Карелия, (Земли обороны и безопасности)
    _0_0_25='00:25' # Улан-Удэнское, Забайкальский край, Республика Бурятия, (Земли обороны и безопасности)
    _0_0_24='00:24' # Тверское, Новгородская область, Тверская область, (Земли обороны и безопасности)
    _2_90='2:90' # Уфимский, Республика Башкортостан, (Земли населенных пунктов)
    _2_87='2:87' # Стерлитамакский, Республика Башкортостан, (Земли населенных пунктов)
    _2_86='2:86' # Стерлибашевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_85='2:85' # Салаватский, Республика Башкортостан, (Земли населенных пунктов)
    _2_84='2:84' # Нуримановский, Республика Башкортостан, (Земли населенных пунктов)
    _2_83='2:83' # Миякинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_82='2:82' # Мишкинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_81='2:81' # Мечетлинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_80='2:80' # Мелеузовский, Республика Башкортостан, (Земли населенных пунктов)
    _0_0_19='00:19' # Московское, Владимирская область, Калужская область, Московская область, Рязанская область, Тульская область, Ярославская область, (Земли обороны и безопасности)
    _0_0_18='00:18' # Морозовское, Калининградская область, Ленинградская область, (Земли обороны и безопасности)
    _0_0_17='00:17' # Марийское, Республика Марий Эл, Республика Татарстан (Татарстан), (Земли обороны и безопасности)
    _2_89='2:89' # Туймазинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_88='2:88' # Татышлинский, Республика Башкортостан, (Земли населенных пунктов)
    _0_0_12='00:12' # Гороховецкое, Владимирская область, Ивановская область, Костромская область, Нижегородская область, Ярославская область, (Земли обороны и безопасности)
    _0_0_11='00:11' # Брянское, Белгородская область, Брянская область, Воронежская область, Калужская область, Курская область, Липецкая область, Орловская область, Смоленская область, Тамбовская область, (Земли обороны и безопасности)
    _0_0_10='00:10' # Архангельское, Архангельская область, Мурманская область, (Земли обороны и безопасности)
    _0_0_16='00:16' # Лужское, Ленинградская область, Псковская область, (Земли обороны и безопасности)
    _0_0_15='00:15' # Костеревское, Владимирская область, Московская область, (Земли обороны и безопасности)
    _0_0_14='00:14' # Кировское, Кировская область, Республика Коми, (Земли обороны и безопасности)
    _0_0_13='00:13' # Камышловское, Курганская область, Свердловская область, (Земли обороны и безопасности)
    _2_97='2:97' # Янаульский, Республика Башкортостан, (Земли населенных пунктов)
    _2_96='2:96' # Шаранский, Республика Башкортостан, (Земли населенных пунктов)
    _2_95='2:95' # Чишминский, Республика Башкортостан, (Земли населенных пунктов)
    _2_94='2:94' # Чекмагушевский, Республика Башкортостан, (Земли населенных пунктов)
    _2_93='2:93' # Хайбуллинский, Республика Башкортостан, (Земли населенных пунктов)
    _2_92='2:92' # Федоровский, Республика Башкортостан, (Земли населенных пунктов)
    _2_91='2:91' # Учалинский, Республика Башкортостан, (Земли населенных пунктов)
    _1_7_3='17:3' # Каа-Хемское, Республика Тыва, (Земли лесного фонда)
    _1_7_2='17:2' # Барун-Хемчикское, Республика Тыва, (Земли лесного фонда)
    _1_7_1='17:1' # Балгазынское, Республика Тыва, (Земли лесного фонда)
    _1_7_9='17:9' # Чаданское, Республика Тыва, (Земли лесного фонда)
    _1_7_8='17:8' # Туранское, Республика Тыва, (Земли лесного фонда)
    _1_7_7='17:7' # Тоджинское, Республика Тыва, (Земли лесного фонда)
    _1_7_6='17:6' # Тес-Хемское, Республика Тыва, (Земли лесного фонда)
    _1_7_5='17:5' # Тандынское, Республика Тыва, (Земли лесного фонда)
    _1_7_4='17:4' # Кызылское, Республика Тыва, (Земли лесного фонда)
    _1_7_19='17:19' # Кызылский, Республика Тыва, (Земли населенных пунктов)
    _9_1='9:1' # Бескесское, Карачаево-Черкесская Республика, (Земли лесного фонда)
    _9_2='9:2' # Зеленчукское, Карачаево-Черкесская Республика, (Земли лесного фонда)
    _9_3='9:3' # Карачаевское, Карачаево-Черкесская Республика, (Земли лесного фонда)
    _9_4='9:4' # Кубанское, Карачаево-Черкесская Республика, (Земли лесного фонда)
    _1_7_15='17:15' # г.Ак-Довурак, Республика Тыва, (Земли населенных пунктов)
    _9_5='9:5' # Урупское, Карачаево-Черкесская Республика, (Земли лесного фонда)
    _1_7_16='17:16' # г.Кызыл, Республика Тыва, (Земли населенных пунктов)
    _9_6='9:6' # ГПБЗ Тебердинский, Карачаево-Черкесская Республика, (Земли особо охраняемых природных территорий)
    _1_7_17='17:17' # Дзун-Хемчикский, Республика Тыва, (Земли населенных пунктов)
    _9_7='9:7' # Адыге-Хабльский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _1_7_18='17:18' # Каа-Хемский, Республика Тыва, (Земли населенных пунктов)
    _9_8='9:8' # г.Черкесск, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _1_7_11='17:11' # ГПБЗ Убсунурская котловина, Республика Тыва, (Земли особо охраняемых природных территорий)
    _9_9='9:9' # Зеленчукский, Карачаево-Черкесская республика, (Земли населенных пунктов)
    _1_7_12='17:12' # ГПЗ Азас, Республика Тыва, (Земли особо охраняемых природных территорий)
    _1_7_13='17:13' # Бай-Тайгинский, Республика Тыва, (Земли населенных пунктов)
    _1_7_14='17:14' # Барун-Хемчикский, Республика Тыва, (Земли населенных пунктов)
    _1_7_10='17:10' # Шагонарское, Республика Тыва, (Земли лесного фонда)
    _7_9_1='79:1' # Биробиджанское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_3='79:3' # Кульдурское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_2='79:2' # Бирское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_5='79:5' # Облученское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_4='79:4' # Ленинское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_7='79:7' # ГПЗ Бастак, Еврейская автономная область, (Земли особо охраняемых природных территорий)
    _7_9_6='79:6' # Октябрьское, Еврейская автономная область, (Земли лесного фонда)
    _7_9_9='79:9' # Муниц.образ."г.Биробиджан", Еврейская автономная область, (Земли населенных пунктов)
    _7_9_8='79:8' # Муниц.образ."Биробиджанский р-он", Еврейская автономная область, (Земли населенных пунктов)
    _6_6_3='66:3' # Березовское, Свердловская область, (Земли лесного фонда)
    _6_6_2='66:2' # Байкаловское, Свердловская область, (Земли лесного фонда)
    _6_6_5='66:5' # Верх-Исетское, Свердловская область, (Земли лесного фонда)
    _6_6_4='66:4' # Билимбаевское, Свердловская область, (Земли лесного фонда)
    _6_6_7='66:7' # Гаринское, Свердловская область, (Земли лесного фонда)
    _6_6_6='66:6' # Верхотурское, Свердловская область, (Земли лесного фонда)
    _6_6_9='66:9' # Ивдельское, Свердловская область, (Земли лесного фонда)
    _6_6_8='66:8' # Егоршинское, Свердловская область, (Земли лесного фонда)
    _6_6_1='66:1' # Алапаевское, Свердловская область, (Земли лесного фонда)
    _5_3_4='53:4' # Крестецкое, Новгородская область, (Земли лесного фонда)
    _5_3_5='53:5' # Любытинское, Новгородская область, (Земли лесного фонда)
    _5_3_6='53:6' # Маловишерское, Новгородская область, (Земли лесного фонда)
    _5_3_7='53:7' # Маревское, Новгородская область, (Земли лесного фонда)
    _5_3_8='53:8' # Мошенское, Новгородская область, (Земли лесного фонда)
    _5_3_9='53:9' # Новгородское, Новгородская область, (Земли лесного фонда)
    _5_3_1='53:1' # Боровичское, Новгородская область, (Земли лесного фонда)
    _5_3_2='53:2' # Валдайское, Новгородская область, (Земли лесного фонда)
    _5_3_3='53:3' # Демянское, Новгородская область, (Земли лесного фонда)
    _4_0_6='40:6' # Жуковское, Калужская область, (Земли лесного фонда)
    _4_0_7='40:7' # Износковское, Калужская область, (Земли лесного фонда)
    _4_0_8='40:8' # Калужское, Калужская область, (Земли лесного фонда)
    _4_0_9='40:9' # Козельское, Калужская область, (Земли лесного фонда)
    _4_0_1='40:1' # Боровское, Калужская область, (Земли лесного фонда)
    _4_0_2='40:2' # Дзержинское, Калужская область, (Земли лесного фонда)
    _4_0_3='40:3' # Думиничское, Калужская область, (Земли лесного фонда)
    _4_0_4='40:4' # Еленское, Калужская область, (Земли лесного фонда)
    _4_0_5='40:5' # Жиздринское, Калужская область, (Земли лесного фонда)
    _1_8_2='18:2' # Балезинское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_1='18:1' # Алнашское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_9='18:9' # Игринское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_8='18:8' # Завьяловское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_7='18:7' # Дебесское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_6='18:6' # Граховское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_5='18:5' # Глазовское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_4='18:4' # Воткинское, Удмуртская Республика, (Земли лесного фонда)
    _1_8_3='18:3' # Вавожское, Удмуртская Республика, (Земли лесного фонда)
    _7_17='7:17' # Прохладненский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_16='7:16' # Майский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_19='7:19' # Урванский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_18='7:18' # Терский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_11='7:11' # НП Приэльбрусье, Кабардино-Балкарская Республика, (Земли особо охраняемых природных территорий)
    _7_10='7:10' # ГПВЗ Кабардино-Балкарский, Кабардино-Балкарская Республика, (Земли особо охраняемых природных территорий)
    _7_13='7:13' # Земли г.Нальчика, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_12='7:12' # Баксанский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_15='7:15' # Зольский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_14='7:14' # Земли г.Прохладного, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_20='7:20' # Чегемский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_22='7:22' # Эльбрусский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _7_21='7:21' # Черекский, Кабардино-Балкарская республика, (Земли населенных пунктов)
    _6_6_91='66:91' # Талицкий го, Свердловская область, (Земли населенных пунктов)
    _6_6_92='66:92' # Тугулымский го, Свердловская область, (Земли населенных пунктов)
    _6_6_90='66:90' # Тавдинский го, Свердловская область, (Земли населенных пунктов)
    _6_6_93='66:93' # Туринский го, Свердловская область, (Земли населенных пунктов)
    _6_6_94='66:94' # Шалинский го, Свердловская область, (Земли населенных пунктов)
    _6_7_2='67:2' # Вяземское, Смоленская область, (Земли лесного фонда)
    _6_7_1='67:1' # Велижское, Смоленская область, (Земли лесного фонда)
    _6_7_4='67:4' # Глинковское, Смоленская область, (Земли лесного фонда)
    _6_7_3='67:3' # Гагаринское, Смоленская область, (Земли лесного фонда)
    _6_7_6='67:6' # Дорогобужское, Смоленская область, (Земли лесного фонда)
    _6_7_5='67:5' # Демидовское, Смоленская область, (Земли лесного фонда)
    _6_7_8='67:8' # Ельнинское, Смоленская область, (Земли лесного фонда)
    _6_7_7='67:7' # Духовщинское, Смоленская область, (Земли лесного фонда)
    _6_7_9='67:9' # Ершичское, Смоленская область, (Земли лесного фонда)
    _5_4_3='54:3' # Венгеровское, Новосибирская область, (Земли лесного фонда)
    _5_4_29='54:29' # Болотнинский, Новосибирская область, (Земли населенных пунктов)
    _5_4_4='54:4' # Доволенское, Новосибирская область, (Земли лесного фонда)
    _5_4_28='54:28' # Барабинский, Новосибирская область, (Земли населенных пунктов)
    _5_4_5='54:5' # Здвинское, Новосибирская область, (Земли лесного фонда)
    _5_4_27='54:27' # Баганский, Новосибирская область, (Земли населенных пунктов)
    _5_4_6='54:6' # Искитимское, Новосибирская область, (Земли лесного фонда)
    _5_4_7='54:7' # Карасукское, Новосибирская область, (Земли лесного фонда)
    _5_4_8='54:8' # Каргатское, Новосибирская область, (Земли лесного фонда)
    _5_4_9='54:9' # Колыванское, Новосибирская область, (Земли лесного фонда)
    _6_6_11='66:11' # Камышловское, Свердловская область, (Земли лесного фонда)
    _4_2_44='42:44' # Мариинский, Кемеровская область, (Земли населенных пунктов)
    _6_6_12='66:12' # Карпинское, Свердловская область, (Земли лесного фонда)
    _4_2_45='42:45' # Новокузнецкий, Кемеровская область, (Земли населенных пунктов)
    _4_2_46='42:46' # пгт. Яйский, Кемеровская область, (Земли населенных пунктов)
    _6_6_10='66:10' # Ирбитское, Свердловская область, (Земли лесного фонда)
    _4_2_47='42:47' # пгт. Яшкино, Кемеровская область, (Земли населенных пунктов)
    _6_6_15='66:15' # Невьянское, Свердловская область, (Земли лесного фонда)
    _4_2_40='42:40' # Ижморский, Кемеровская область, (Земли населенных пунктов)
    _6_6_16='66:16' # Нижне-Сергинское, Свердловская область, (Земли лесного фонда)
    _4_2_41='42:41' # Кемеровский, Кемеровская область, (Земли населенных пунктов)
    _6_6_13='66:13' # Красноуфимское, Свердловская область, (Земли лесного фонда)
    _5_4_1='54:1' # Барабинское, Новосибирская область, (Земли лесного фонда)
    _4_2_42='42:42' # Крапивинский, Кемеровская область, (Земли населенных пунктов)
    _6_6_14='66:14' # Кушвинское, Свердловская область, (Земли лесного фонда)
    _5_4_2='54:2' # Болотнинское, Новосибирская область, (Земли лесного фонда)
    _4_2_43='42:43' # Ленинск-Кузнецкий, Кемеровская область, (Земли населенных пунктов)
    _4_2_37='42:37' # г.Топки, Кемеровская область, (Земли населенных пунктов)
    _4_2_38='42:38' # г.Юрга, Кемеровская область, (Земли населенных пунктов)
    _4_2_39='42:39' # Гурьевский, Кемеровская область, (Земли населенных пунктов)
    _5_4_33='54:33' # Искитимский, Новосибирская область, (Земли населенных пунктов)
    _5_4_32='54:32' # Доволенский, Новосибирская область, (Земли населенных пунктов)
    _5_4_31='54:31' # г.Новосибирск, Новосибирская область, (Земли населенных пунктов)
    _5_4_30='54:30' # Венгеровский, Новосибирская область, (Земли населенных пунктов)
    _5_4_37='54:37' # Коченевский, Новосибирская область, (Земли населенных пунктов)
    _5_4_36='54:36' # Колыванский, Новосибирская область, (Земли населенных пунктов)
    _5_4_35='54:35' # Каргатский, Новосибирская область, (Земли населенных пунктов)
    _5_4_34='54:34' # Карасукский, Новосибирская область, (Земли населенных пунктов)
    _5_4_39='54:39' # Краснозерский, Новосибирская область, (Земли населенных пунктов)
    _5_4_38='54:38' # Кочковский, Новосибирская область, (Земли населенных пунктов)
    _6_6_22='66:22' # Синячихинское, Свердловская область, (Земли лесного фонда)
    _4_2_33='42:33' # г.Ленинск-Кузнецкий, Кемеровская область, (Земли населенных пунктов)
    _6_6_23='66:23' # Сотринское, Свердловская область, (Земли лесного фонда)
    _4_2_34='42:34' # г.Новокузнецк, Кемеровская область, (Земли населенных пунктов)
    _6_6_20='66:20' # Свердловское, Свердловская область, (Земли лесного фонда)
    _4_2_35='42:35' # г.Осинники, Кемеровская область, (Земли населенных пунктов)
    _6_6_21='66:21' # Серовское, Свердловская область, (Земли лесного фонда)
    _4_2_36='42:36' # г.Прокопьевск, Кемеровская область, (Земли населенных пунктов)
    _6_6_26='66:26' # Таборинское, Свердловская область, (Земли лесного фонда)
    _6_6_27='66:27' # Тавдинское, Свердловская область, (Земли лесного фонда)
    _4_2_30='42:30' # г.Гурьевск, Кемеровская область, (Земли населенных пунктов)
    _6_6_24='66:24' # Сухоложское, Свердловская область, (Земли лесного фонда)
    _4_2_31='42:31' # г.Кемерово, Кемеровская область, (Земли населенных пунктов)
    _6_6_25='66:25' # Сысертское, Свердловская область, (Земли лесного фонда)
    _4_2_32='42:32' # г.Киселевск, Кемеровская область, (Земли населенных пунктов)
    _6_6_19='66:19' # Режевское, Свердловская область, (Земли лесного фонда)
    _6_6_17='66:17' # Нижне-Тагильское, Свердловская область, (Земли лесного фонда)
    _6_6_18='66:18' # Ново-Лялинское, Свердловская область, (Земли лесного фонда)
    _5_4_40='54:40' # Куйбышевский, Новосибирская область, (Земли населенных пунктов)
    _4_2_26='42:26' # г. Тайга, Кемеровская область, (Земли населенных пунктов)
    _4_2_27='42:27' # г.Анжеро-Суджинск, Кемеровская область, (Земли населенных пунктов)
    _4_2_28='42:28' # г.Белово, Кемеровская область, (Земли населенных пунктов)
    _4_2_29='42:29' # г.Березовский, Кемеровская область, (Земли населенных пунктов)
    _5_4_44='54:44' # Мошковский, Новосибирская область, (Земли населенных пунктов)
    _5_4_43='54:43' # Маслянинский, Новосибирская область, (Земли населенных пунктов)
    _5_4_42='54:42' # Кыштовский, Новосибирская область, (Земли населенных пунктов)
    _5_4_41='54:41' # Купинский, Новосибирская область, (Земли населенных пунктов)
    _5_4_48='54:48' # Сузунское, Новосибирская область, (Земли населенных пунктов)
    _5_4_47='54:47' # Северный, Новосибирская область, (Земли населенных пунктов)
    _5_4_46='54:46' # Ордынский, Новосибирская область, (Земли населенных пунктов)
    _5_4_45='54:45' # Новосибирский, Новосибирская область, (Земли населенных пунктов)
    _5_4_49='54:49' # Татарский, Новосибирская область, (Земли населенных пунктов)
    _2_9_49='29:49' # Онежский, Архангельская область, (Земли населенных пунктов)
    _6_6_30='66:30' # Туринское, Свердловская область, (Земли лесного фонда)
    _6_6_33='66:33' # ГПЗ Денежкин Камень, Свердловская область, (Земли особо охраняемых природных территорий)
    _4_2_22='42:22' # "Городские леса г. Междуреченска", Кемеровская область, (Земли населенных пунктов)
    _2_9_44='29:44' # Красноберский, Архангельская область, (Земли населенных пунктов)
    _6_6_34='66:34' # НП Припышминские боры, Свердловская область, (Земли особо охраняемых природных территорий)
    _4_2_23='42:23' # Беловский, Кемеровская область, (Земли населенных пунктов)
    _2_9_43='29:43' # Котласский, Архангельская область, (Земли населенных пунктов)
    _6_6_31='66:31' # Шалинское, Свердловская область, (Земли лесного фонда)
    _4_2_24='42:24' # г. Мариинск, Кемеровская область, (Земли населенных пунктов)
    _2_9_42='29:42' # Коношский, Архангельская область, (Земли населенных пунктов)
    _6_6_32='66:32' # ГПБЗ Висимский, Свердловская область, (Земли особо охраняемых природных территорий)
    _4_2_25='42:25' # г. Салаир, Кемеровская область, (Земли населенных пунктов)
    _2_9_41='29:41' # Каргопольский, Архангельская область, (Земли населенных пунктов)
    _6_6_37='66:37' # Алапаевское мун.обр., Свердловская область, (Земли населенных пунктов)
    _2_9_48='29:48' # Няндомский, Архангельская область, (Земли населенных пунктов)
    _6_6_38='66:38' # Артемовский го, Свердловская область, (Земли населенных пунктов)
    _2_9_47='29:47' # Мезенский, Архангельская область, (Земли населенных пунктов)
    _6_6_35='66:35' # Карелинское, Свердловская область, (Земли обороны и безопасности)
    _4_2_20='42:20' # ГПЗ Кузнецкий Алатау, Кемеровская область, (Земли особо охраняемых природных территорий)
    _2_9_46='29:46' # Лешуконский, Архангельская область, (Земли населенных пунктов)
    _6_6_36='66:36' # Нижнетагильское, Свердловская область, (Земли обороны и безопасности)
    _4_2_21='42:21' # НП Шорский, Кемеровская область, (Земли особо охраняемых природных территорий)
    _2_9_45='29:45' # Ленский, Архангельская область, (Земли населенных пунктов)
    _4_2_19='42:19' # Яшкинское, Кемеровская область, (Земли лесного фонда)
    _6_6_28='66:28' # Талицкое, Свердловская область, (Земли лесного фонда)
    _6_6_29='66:29' # Тугулымское, Свердловская область, (Земли лесного фонда)
    _5_4_51='54:51' # Убинский, Новосибирская область, (Земли населенных пунктов)
    _4_2_15='42:15' # Тяжинское, Кемеровская область, (Земли лесного фонда)
    _2_9_40='29:40' # г.Северодвинск, Архангельская область, (Земли населенных пунктов)
    _5_4_50='54:50' # Тогучинский, Новосибирская область, (Земли населенных пунктов)
    _4_2_16='42:16' # Чебулинское, Кемеровская область, (Земли лесного фонда)
    _4_2_17='42:17' # Юргинское, Кемеровская область, (Земли лесного фонда)
    _4_2_18='42:18' # Яйское, Кемеровская область, (Земли лесного фонда)
    _5_4_55='54:55' # Чистоозерный, Новосибирская область, (Земли населенных пунктов)
    _5_4_54='54:54' # Черепановский, Новосибирская область, (Земли населенных пунктов)
    _5_4_53='54:53' # Чановский, Новосибирская область, (Земли населенных пунктов)
    _5_4_52='54:52' # Усть-Тарковский, Новосибирская область, (Земли населенных пунктов)
    _5_4_57='54:57' # Эдвинский, Новосибирская область, (Земли населенных пунктов)
    _5_4_56='54:56' # Чулымский, Новосибирская область, (Земли населенных пунктов)
    _4_1_5='41:5' # Корякское, Камчатский край, (Земли лесного фонда)
    _4_1_6='41:6' # Мильковское, Камчатский край, (Земли лесного фонда)
    _4_1_7='41:7' # Усть-Большерецкое, Камчатский край, (Земли лесного фонда)
    _4_1_8='41:8' # ГПБЗ Командорский, Камчатский край, (Земли особо охраняемых природных территорий)
    _6_6_40='66:40' # Асбестовский го, Свердловская область, (Земли населенных пунктов)
    _4_1_9='41:9' # ГПБЗ Кроноцкий, Камчатский край, (Земли особо охраняемых природных территорий)
    _6_6_41='66:41' # Ачитский го, Свердловская область, (Земли населенных пунктов)
    _6_6_44='66:44' # Березовский го, Свердловская область, (Земли населенных пунктов)
    _4_2_11='42:11' # Прокопьевское, Кемеровская область, (Земли лесного фонда)
    _2_9_55='29:55' # Холмогорский, Архангельская область, (Земли населенных пунктов)
    _6_6_45='66:45' # Верхнесалдинский го, Свердловская область, (Земли населенных пунктов)
    _4_2_12='42:12' # Промышленновское, Кемеровская область, (Земли лесного фонда)
    _2_9_54='29:54' # Устьянский, Архангельская область, (Земли населенных пунктов)
    _6_6_42='66:42' # Байкаловский мун.р-н, Свердловская область, (Земли населенных пунктов)
    _4_2_13='42:13' # Таштагольское, Кемеровская область, (Земли лесного фонда)
    _2_9_53='29:53' # Соловецкий, Архангельская область, (Земли населенных пунктов)
    _6_6_43='66:43' # Белоярский го, Свердловская область, (Земли населенных пунктов)
    _4_2_14='42:14' # Тисульское, Кемеровская область, (Земли лесного фонда)
    _2_9_52='29:52' # Приморский, Архангельская область, (Земли населенных пунктов)
    _6_6_48='66:48' # го Богданович, Свердловская область, (Земли населенных пунктов)
    _4_1_1='41:1' # Атласовское, Камчатский край, (Земли лесного фонда)
    _6_6_49='66:49' # го Верхняя Пышма, Свердловская область, (Земли населенных пунктов)
    _4_1_2='41:2' # Быстринское, Камчатский край, (Земли лесного фонда)
    _6_6_46='66:46' # Гаринский го, Свердловская область, (Земли населенных пунктов)
    _4_1_3='41:3' # Елизовское, Камчатский край, (Земли лесного фонда)
    _6_6_47='66:47' # Го "Город Лесной", Свердловская область, (Земли населенных пунктов)
    _4_1_4='41:4' # Ключевское, Камчатский край, (Земли лесного фонда)
    _4_2_10='42:10' # Новокузнецкое, Кемеровская область, (Земли лесного фонда)
    _2_9_56='29:56' # Шенкурский, Архангельская область, (Земли населенных пунктов)
    _6_6_39='66:39' # Артинский го, Свердловская область, (Земли населенных пунктов)
    _2_9_51='29:51' # Плесецкий, Архангельская область, (Земли населенных пунктов)
    _2_9_50='29:50' # Пинежский, Архангельская область, (Земли населенных пунктов)
    _3_0_18='30:18' # Черноярское АТО, Астраханская область, (Земли населенных пунктов)
    _2_9_29='29:29' # Яренское, Архангельская область, (Земли лесного фонда)
    _2_9_28='29:28' # Шенкурское, Архангельская область, (Земли лесного фонда)
    _2_9_27='29:27' # Холмогорское, Архангельская область, (Земли лесного фонда)
    _6_6_51='66:51' # го Заречный, Свердловская область, (Земли населенных пунктов)
    _3_0_15='30:15' # Наримановское АТО, Астраханская область, (Земли населенных пунктов)
    _6_6_52='66:52' # го ЗАТО Свободный, Свердловская область, (Земли населенных пунктов)
    _3_0_14='30:14' # Лиманское АТО, Астраханская область, (Земли населенных пунктов)
    _3_0_17='30:17' # Харабалинское АТО, Астраханская область, (Земли населенных пунктов)
    _6_6_50='66:50' # го Верхотурский, Свердловская область, (Земли населенных пунктов)
    _3_0_16='30:16' # Приволжское АТО, Астраханская область, (Земли населенных пунктов)
    _6_6_55='66:55' # го Краснотурьинск, Свердловская область, (Земли населенных пунктов)
    _2_9_22='29:22' # Северодвинское, Архангельская область, (Земли лесного фонда)
    _6_6_56='66:56' # го Красноуральск, Свердловская область, (Земли населенных пунктов)
    _2_9_21='29:21' # Пуксоозерское, Архангельская область, (Земли лесного фонда)
    _6_6_53='66:53' # го Каменск-Уральский, Свердловская область, (Земли населенных пунктов)
    _2_9_20='29:20' # Приозерное, Архангельская область, (Земли лесного фонда)
    _6_6_54='66:54' # го Карпинск, Свердловская область, (Земли населенных пунктов)
    _6_6_59='66:59' # го Первоуральск, Свердловская область, (Земли населенных пунктов)
    _2_9_26='29:26' # Устьянское, Архангельская область, (Земли лесного фонда)
    _2_9_25='29:25' # Сурское, Архангельская область, (Земли лесного фонда)
    _6_6_57='66:57' # го Красноуфимск, Свердловская область, (Земли населенных пунктов)
    _2_9_24='29:24' # Соловецкое, Архангельская область, (Земли лесного фонда)
    _6_6_58='66:58' # го Нижняя Салда, Свердловская область, (Земли населенных пунктов)
    _2_9_23='29:23' # Сийское, Архангельская область, (Земли лесного фонда)
    _2_9_39='29:39' # г.Новодвинск, Архангельская область, (Земли населенных пунктов)
    _2_9_38='29:38' # г.Архангельск, Архангельская область, (Земли населенных пунктов)
    _6_6_62='66:62' # гоНижний Тагил, Свердловская область, (Земли населенных пунктов)
    _6_6_63='66:63' # Горноуральский го, Свердловская область, (Земли населенных пунктов)
    _6_6_60='66:60' # го Ревда, Свердловская область, (Земли населенных пунктов)
    _6_6_61='66:61' # го Сухой Лог, Свердловская область, (Земли населенных пунктов)
    _6_6_66='66:66' # Каменский го, Свердловская область, (Земли населенных пунктов)
    _2_9_33='29:33' # НП Русская Арктика, Архангельская область, (Земли особо охраняемых природных территорий)
    _6_6_67='66:67' # Камышловский го, Свердловская область, (Земли населенных пунктов)
    _2_9_32='29:32' # НП Онежское Поморье, Архангельская область, (Земли особо охраняемых природных территорий)
    _6_6_64='66:64' # Ивдельский го, Свердловская область, (Земли населенных пунктов)
    _2_9_31='29:31' # НП Кенозерский, Архангельская область, (Земли особо охраняемых природных территорий)
    _6_6_65='66:65' # Ирбитское мун.обр., Свердловская область, (Земли населенных пунктов)
    _2_9_30='29:30' # ГПЗ Пинежский, Архангельская область, (Земли особо охраняемых природных территорий)
    _2_9_37='29:37' # Виноградовский, Архангельская область, (Земли населенных пунктов)
    _2_9_36='29:36' # Вилегодский, Архангельская область, (Земли населенных пунктов)
    _6_6_68='66:68' # Камышловский мун.р-н, Свердловская область, (Земли населенных пунктов)
    _2_9_35='29:35' # Верхнетоемский, Архангельская область, (Земли населенных пунктов)
    _6_6_69='66:69' # Качканарский го, Свердловская область, (Земли населенных пунктов)
    _2_9_34='29:34' # Вельский, Архангельская область, (Земли населенных пунктов)
    _3_0_11='30:11' # Икрянинское АТО, Астраханская область, (Земли населенных пунктов)
    _3_0_10='30:10' # Енотаевское АТО, Астраханская область, (Земли населенных пунктов)
    _3_0_13='30:13' # Красноярское АТО, Астраханская область, (Земли населенных пунктов)
    _3_0_12='30:12' # Камызякское АТО, Астраханская область, (Земли населенных пунктов)
    _6_6_70='66:70' # Кировградский го, Свердловская область, (Земли населенных пунктов)
    _6_6_73='66:73' # му.обр. город Алапаевск, Свердловская область, (Земли населенных пунктов)
    _6_6_74='66:74' # мун.обр."город Екатеринбург", Свердловская область, (Земли населенных пунктов)
    _6_6_71='66:71' # Красноуфимский округ, Свердловская область, (Земли населенных пунктов)
    _6_6_72='66:72' # Кушвинский го, Свердловская область, (Земли населенных пунктов)
    _6_6_77='66:77' # Нижнесергинский мун.р-н, Свердловская область, (Земли населенных пунктов)
    _6_6_78='66:78' # Нижнетуринский го, Свердловская область, (Земли населенных пунктов)
    _6_6_75='66:75' # мун.обр.город Ирбит, Свердловская область, (Земли населенных пунктов)
    _6_6_76='66:76' # Невьянский го, Свердловская область, (Земли населенных пунктов)
    _6_6_79='66:79' # Новолялинский го, Свердловская область, (Земли населенных пунктов)
    _1_7_26='17:26' # Тес-Хемский, Республика Тыва, (Земли населенных пунктов)
    _1_7_27='17:27' # Тоджинский, Республика Тыва, (Земли населенных пунктов)
    _1_7_28='17:28' # Улуг-Хемский, Республика Тыва, (Земли населенных пунктов)
    _1_7_29='17:29' # Чаа-Хольский, Республика Тыва, (Земли населенных пунктов)
    _1_7_22='17:22' # Пий-Хемский, Республика Тыва, (Земли населенных пунктов)
    _1_7_23='17:23' # Сут-Хольский, Республика Тыва, (Земли населенных пунктов)
    _1_7_24='17:24' # Тандинский, Республика Тыва, (Земли населенных пунктов)
    _1_7_25='17:25' # Тере-Хольский, Республика Тыва, (Земли населенных пунктов)
    _1_7_20='17:20' # Монгун-Тайгинский, Республика Тыва, (Земли населенных пунктов)
    _1_7_21='17:21' # Овюрский, Республика Тыва, (Земли населенных пунктов)
    _6_6_80='66:80' # Новоуральский го, Свердловская область, (Земли населенных пунктов)
    _2_9_19='29:19' # Плесецкое, Архангельская область, (Земли лесного фонда)
    _6_6_81='66:81' # Полевской го, Свердловская область, (Земли населенных пунктов)
    _2_9_18='29:18' # Пинежское, Архангельская область, (Земли лесного фонда)
    _2_9_17='29:17' # Онежское, Архангельская область, (Земли лесного фонда)
    _2_9_16='29:16' # Обозерское, Архангельская область, (Земли лесного фонда)
    _6_6_84='66:84' # Североуральский го, Свердловская область, (Земли населенных пунктов)
    _6_6_85='66:85' # Серовский го, Свердловская область, (Земли населенных пунктов)
    _6_6_82='66:82' # Пышминский го, Свердловская область, (Земли населенных пунктов)
    _6_6_83='66:83' # Режевской го, Свердловская область, (Земли населенных пунктов)
    _6_6_88='66:88' # Сысертский го, Свердловская область, (Земли населенных пунктов)
    _2_9_11='29:11' # Котласское, Архангельская область, (Земли лесного фонда)
    _6_6_89='66:89' # Таборинский мун.р-н, Свердловская область, (Земли населенных пунктов)
    _2_9_10='29:10' # Коношское, Архангельская область, (Земли лесного фонда)
    _6_6_86='66:86' # Слободо-Туринский мун.р-н, Свердловская область, (Земли населенных пунктов)
    _6_6_87='66:87' # Сосьвинский го, Свердловская область, (Земли населенных пунктов)
    _2_9_15='29:15' # Няндомское, Архангельская область, (Земли лесного фонда)
    _2_9_14='29:14' # Мезенское, Архангельская область, (Земли лесного фонда)
    _2_9_13='29:13' # Лешуконское, Архангельская область, (Земли лесного фонда)
    _2_9_12='29:12' # Красноборское, Архангельская область, (Земли лесного фонда)
    _9_1_11='91:11' # ГПЗ "Карадагский", Республика Крым, (Земли особо охраняемых природных территорий)
    _9_1_12='91:12' # ГПЗ "Ялтинский горно-лесной", Республика Крым, (Земли особо охраняемых природных территорий)
    _9_1_10='91:10' # Судакское, Республика Крым, (Земли лесного фонда)
    _1_7_30='17:30' # Чеди-Хольский, Республика Тыва, (Земли населенных пунктов)
    _1_7_31='17:31' # Эрзинский, Республика Тыва, (Земли населенных пунктов)
    _9_1_13='91:13' # НП "Крымский" ФГБУ "комплекс "Крым", Республика Крым, (Земли особо охраняемых природных территорий)
    _9_1_14='91:14' # Крымское, Республика Крым, (Земли обороны и безопасности)
    _1_9_1='19:1' # Абазинское, Республика Хакасия, (Земли лесного фонда)
    _1_9_9='19:9' # Саралинское, Республика Хакасия, (Земли лесного фонда)
    _1_9_8='19:8' # Копьевское, Республика Хакасия, (Земли лесного фонда)
    _1_9_7='19:7' # Горячегорское, Республика Хакасия, (Земли лесного фонда)
    _1_9_6='19:6' # Боградское, Республика Хакасия, (Земли лесного фонда)
    _1_9_5='19:5' # Бирикчульское, Республика Хакасия, (Земли лесного фонда)
    _1_9_4='19:4' # Бейское, Республика Хакасия, (Земли лесного фонда)
    _1_9_3='19:3' # Балыксинское, Республика Хакасия, (Земли лесного фонда)
    _1_9_2='19:2' # Абаканское, Республика Хакасия, (Земли лесного фонда)
    _5_4_11='54:11' # Краснозерское, Новосибирская область, (Земли лесного фонда)
    _5_4_10='54:10' # Коченевское, Новосибирская область, (Земли лесного фонда)
    _5_4_15='54:15' # Маслянинское, Новосибирская область, (Земли лесного фонда)
    _5_4_14='54:14' # Кыштовское, Новосибирская область, (Земли лесного фонда)
    _5_4_13='54:13' # Купинское, Новосибирская область, (Земли лесного фонда)
    _5_4_12='54:12' # Куйбышевское, Новосибирская область, (Земли лесного фонда)
    _5_4_19='54:19' # Ордынское, Новосибирская область, (Земли лесного фонда)
    _5_4_18='54:18' # Новосибирское, Новосибирская область, (Земли лесного фонда)
    _5_4_17='54:17' # Мошковское, Новосибирская область, (Земли лесного фонда)
    _5_4_16='54:16' # Мирновское, Новосибирская область, (Земли лесного фонда)
    _4_2_50='42:50' # Таштагольский, Кемеровская область, (Земли населенных пунктов)
    _4_2_55='42:55' # Юргинский, Кемеровская область, (Земли населенных пунктов)
    _4_2_56='42:56' # Яйский, Кемеровская область, (Земли населенных пунктов)
    _4_2_57='42:57' # Яшкинский, Кемеровская область, (Земли населенных пунктов)
    _4_2_51='42:51' # Тисульский, Кемеровская область, (Земли населенных пунктов)
    _4_2_52='42:52' # Топкинский, Кемеровская область, (Земли населенных пунктов)
    _4_2_53='42:53' # Тяжинский, Кемеровская область, (Земли населенных пунктов)
    _4_2_54='42:54' # Чебулинский, Кемеровская область, (Земли населенных пунктов)
    _4_2_48='42:48' # Прокопьевский, Кемеровская область, (Земли населенных пунктов)
    _4_2_49='42:49' # Промышленновский, Кемеровская область, (Земли населенных пунктов)
    _5_4_22='54:22' # Татарское, Новосибирская область, (Земли лесного фонда)
    _5_4_21='54:21' # Сузунское, Новосибирская область, (Земли лесного фонда)
    _5_4_20='54:20' # Северное, Новосибирская область, (Земли лесного фонда)
    _5_4_26='54:26' # Чулымское, Новосибирская область, (Земли лесного фонда)
    _5_4_25='54:25' # Черепановское, Новосибирская область, (Земли лесного фонда)
    _5_4_24='54:24' # Чановское, Новосибирская область, (Земли лесного фонда)
    _5_4_23='54:23' # Убинское, Новосибирская область, (Земли лесного фонда)
    _7_2_10='72:10' # Ишимское, Тюменская область, (Земли лесного фонда)
    _7_2_11='72:11' # Казанское, Тюменская область, (Земли лесного фонда)
    _6_0_29='60:29' # Палкинский, Псковская область, (Земли населенных пунктов)
    _6_0_28='60:28' # Островский, Псковская область, (Земли населенных пунктов)
    _6_0_27='60:27' # Опочецкий, Псковская область, (Земли населенных пунктов)
    _6_0_26='60:26' # Новосокольнический, Псковская область, (Земли населенных пунктов)
    _6_0_25='60:25' # Новоржевский, Псковская область, (Земли населенных пунктов)
    _6_0_24='60:24' # Невельский, Псковская область, (Земли населенных пунктов)
    _6_0_23='60:23' # Локнянский, Псковская область, (Земли населенных пунктов)
    _6_0_22='60:22' # Куньинский, Псковская область, (Земли населенных пунктов)
    _5_9_43='59:43' # ГО Соликамск, Пермский край, (Земли населенных пунктов)
    _6_0_32='60:32' # Порховский, Псковская область, (Земли населенных пунктов)
    _5_9_42='59:42' # ГО Пермь, Пермский край, (Земли населенных пунктов)
    _6_0_31='60:31' # Плюсский, Псковская область, (Земли населенных пунктов)
    _5_9_45='59:45' # Гремячинский район, Пермский край, (Земли населенных пунктов)
    _6_0_30='60:30' # Печорский, Псковская область, (Земли населенных пунктов)
    _5_9_44='59:44' # Горнозаводский район, Пермский край, (Земли населенных пунктов)
    _5_9_41='59:41' # ГО Кунгур, Пермский край, (Земли населенных пунктов)
    _5_9_40='59:40' # ГО Кудымкар, Пермский край, (Земли населенных пунктов)
    _5_9_47='59:47' # Добрянский район, Пермский край, (Земли населенных пунктов)
    _5_9_46='59:46' # Губахинский район, Пермский край, (Земли населенных пунктов)
    _5_9_49='59:49' # Ильинский район, Пермский край, (Земли населенных пунктов)
    _5_9_48='59:48' # Еловский район, Пермский край, (Земли населенных пунктов)
    _7_2_21='72:21' # Ялуторовское, Тюменская область, (Земли лесного фонда)
    _7_2_22='72:22' # Ярковское, Тюменская область, (Земли лесного фонда)
    _4_7_41='47:41' # Тосненский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _7_2_20='72:20' # Юргинское, Тюменская область, (Земли лесного фонда)
    _4_7_40='47:40' # Тихвинский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _6_0_39='60:39' # Усвятский, Псковская область, (Земли населенных пунктов)
    _6_0_38='60:38' # Стругокрасненский, Псковская область, (Земли населенных пунктов)
    _6_0_37='60:37' # Себежский, Псковская область, (Земли населенных пунктов)
    _6_0_36='60:36' # Пыталовский, Псковская область, (Земли населенных пунктов)
    _6_0_35='60:35' # Пушкиногорский, Псковская область, (Земли населенных пунктов)
    _6_0_34='60:34' # Пустошкинский, Псковская область, (Земли населенных пунктов)
    _6_0_33='60:33' # Псковский, Псковская область, (Земли населенных пунктов)
    _5_9_54='59:54' # Кочевский район, Пермский край, (Земли населенных пунктов)
    _5_9_53='59:53' # Косинский район, Пермский край, (Земли населенных пунктов)
    _5_9_56='59:56' # Краснокамский район, Пермский край, (Земли населенных пунктов)
    _5_9_55='59:55' # Красновишерский район, Пермский край, (Земли населенных пунктов)
    _5_9_50='59:50' # Карагайский район, Пермский край, (Земли населенных пунктов)
    _5_9_52='59:52' # Кишертский район, Пермский край, (Земли населенных пунктов)
    _5_9_51='59:51' # Кизеловский район, Пермский край, (Земли населенных пунктов)
    _7_2_18='72:18' # Уватское, Тюменская область, (Земли лесного фонда)
    _7_2_19='72:19' # Упоровское, Тюменская область, (Земли лесного фонда)
    _7_2_16='72:16' # Тобольское, Тюменская область, (Земли лесного фонда)
    _7_2_17='72:17' # Тюменское, Тюменская область, (Земли лесного фонда)
    _7_2_14='72:14' # Сладковское, Тюменская область, (Земли лесного фонда)
    _5_9_58='59:58' # Куединский район, Пермский край, (Земли населенных пунктов)
    _7_2_15='72:15' # Сорокинское, Тюменская область, (Земли лесного фонда)
    _5_9_57='59:57' # Кудымкарский район, Пермский край, (Земли населенных пунктов)
    _7_2_12='72:12' # Нижнетавдинское, Тюменская область, (Земли лесного фонда)
    _7_2_13='72:13' # Омутинское, Тюменская область, (Земли лесного фонда)
    _5_9_59='59:59' # Кунгурский район, Пермский край, (Земли населенных пунктов)
    _7_2_32='72:32' # г.Тюмень, Тюменская область, (Земли населенных пунктов)
    _4_7_32='47:32' # Ладожское и Онежское озера, Ленинградская область, (Земли населенных пунктов)
    _7_2_33='72:33' # г.Ялуторовск, Тюменская область, (Земли населенных пунктов)
    _4_7_33='47:33' # Лодейнопольский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _7_2_30='72:30' # г.Ишим, Тюменская область, (Земли населенных пунктов)
    _4_7_30='47:30' # Киришский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _7_2_31='72:31' # г.Тобольск, Тюменская область, (Земли населенных пунктов)
    _4_7_31='47:31' # Кировский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_38='47:38' # Сланцевский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_39='47:39' # Сосновогорский гор.округ, Ленинградская область, (Земли населенных пунктов)
    _2_3_60='23:60' # Туапсинский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_36='47:36' # Подпорожский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _2_3_61='23:61' # Успенский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_37='47:37' # Приозерский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _2_3_62='23:62' # Усть-Лабинский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_34='47:34' # Ломоносовский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _2_3_63='23:63' # Щербиновский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_35='47:35' # Лужский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _5_9_65='59:65' # Оханский район, Пермский край, (Земли населенных пунктов)
    _3_5_54='35:54' # Череповецкий район, Вологодская область, (Земли населенных пунктов)
    _5_9_64='59:64' # Осинский район, Пермский край, (Земли населенных пунктов)
    _3_5_53='35:53' # Чагодощенский район, Вологодская область, (Земли населенных пунктов)
    _5_9_67='59:67' # Пермский район, Пермский край, (Земли населенных пунктов)
    _3_5_52='35:52' # Харовский район, Вологодская область, (Земли населенных пунктов)
    _5_9_66='59:66' # Очерский район, Пермский край, (Земли населенных пунктов)
    _3_5_51='35:51' # Устюженский район, Вологодская область, (Земли населенных пунктов)
    _5_9_61='59:61' # Нытвенский район, Пермский край, (Земли населенных пунктов)
    _3_5_50='35:50' # Усть-Кубинский район, Вологодская область, (Земли населенных пунктов)
    _5_9_60='59:60' # Лысьвенский район, Пермский край, (Земли населенных пунктов)
    _5_9_63='59:63' # Ординский район, Пермский край, (Земли населенных пунктов)
    _5_9_62='59:62' # Октябрьский район, Пермский край, (Земли населенных пунктов)
    _7_2_29='72:29' # Викуловский, Тюменская область, (Земли населенных пунктов)
    _7_2_27='72:27' # Бердюжский, Тюменская область, (Земли населенных пунктов)
    _7_2_28='72:28' # Вагайский, Тюменская область, (Земли населенных пунктов)
    _7_2_25='72:25' # Армизонский, Тюменская область, (Земли населенных пунктов)
    _5_9_69='59:69' # Соликамский район, Пермский край, (Земли населенных пунктов)
    _7_2_26='72:26' # Аромашевский, Тюменская область, (Земли населенных пунктов)
    _5_9_68='59:68' # Сивинский район, Пермский край, (Земли населенных пунктов)
    _7_2_23='72:23' # Тюменское, Тюменская область, (Земли обороны и безопасности)
    _7_2_24='72:24' # Абатский, Тюменская область, (Земли населенных пунктов)
    _3_5_55='35:55' # Шекснинский район, Вологодская область, (Земли населенных пунктов)
    _7_2_43='72:43' # Тобольский, Тюменская область, (Земли населенных пунктов)
    _4_7_21='47:21' # Мичуринское, Ленинградская область, (Земли обороны и безопасности)
    _7_2_44='72:44' # Тюменский, Тюменская область, (Земли населенных пунктов)
    _4_7_22='47:22' # Бокситогорский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _7_2_41='72:41' # Сладковский, Тюменская область, (Земли населенных пунктов)
    _7_2_42='72:42' # Сорокинский, Тюменская область, (Земли населенных пунктов)
    _4_7_20='47:20' # ГПЗ Нижне-Свирский, Ленинградская область, (Земли особо охраняемых природных территорий)
    _7_2_40='72:40' # Омутинский, Тюменская область, (Земли населенных пунктов)
    _4_7_29='47:29' # Кингисеппский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _5_9_70='59:70' # Суксунский район, Пермский край, (Земли населенных пунктов)
    _4_7_27='47:27' # г. Санкт-петербург, Ленинградская область, (Земли населенных пунктов)
    _4_7_28='47:28' # Гатчинский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_25='47:25' # Всеволожский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_26='47:26' # Выборгский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_23='47:23' # Волосовский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _4_7_24='47:24' # Волховский муницип. р-он, Ленинградская область, (Земли населенных пунктов)
    _5_9_76='59:76' # Чернушенский район, Пермский край, (Земли населенных пунктов)
    _3_5_43='35:43' # Междуреченский район, Вологодская область, (Земли населенных пунктов)
    _5_9_75='59:75' # Чердынский район, Пермский край, (Земли населенных пунктов)
    _3_5_42='35:42' # Кичменгско-Городецкий район, Вологодская область, (Земли населенных пунктов)
    _5_9_78='59:78' # Юрлинский район, Пермский край, (Земли населенных пунктов)
    _3_5_41='35:41' # Кирилловский район, Вологодская область, (Земли населенных пунктов)
    _5_9_77='59:77' # Чусовской район, Пермский край, (Земли населенных пунктов)
    _3_5_40='35:40' # Кадуйский район, Вологодская область, (Земли населенных пунктов)
    _5_9_72='59:72' # Усольский район, Пермский край, (Земли населенных пунктов)
    _5_9_71='59:71' # Уинский район, Пермский край, (Земли населенных пунктов)
    _5_9_74='59:74' # Частинский район, Пермский край, (Земли населенных пунктов)
    _5_9_73='59:73' # Чайковский район, Пермский край, (Земли населенных пунктов)
    _7_2_38='72:38' # Казанский, Тюменская область, (Земли населенных пунктов)
    _3_5_49='35:49' # Тотемский район, Вологодская область, (Земли населенных пунктов)
    _7_2_39='72:39' # Нижнетавдинский, Тюменская область, (Земли населенных пунктов)
    _3_5_48='35:48' # Тарногский район, Вологодская область, (Земли населенных пунктов)
    _7_2_36='72:36' # Исетский, Тюменская область, (Земли населенных пунктов)
    _3_5_47='35:47' # Сямженский район, Вологодская область, (Земли населенных пунктов)
    _7_2_37='72:37' # Ишимский, Тюменская область, (Земли населенных пунктов)
    _5_9_79='59:79' # Юсьвинский район, Пермский край, (Земли населенных пунктов)
    _3_5_46='35:46' # Сокольский район, Вологодская область, (Земли населенных пунктов)
    _7_2_34='72:34' # Голышмановский, Тюменская область, (Земли населенных пунктов)
    _3_5_45='35:45' # Нюксенский район, Вологодская область, (Земли населенных пунктов)
    _7_2_35='72:35' # Заводоуковский, Тюменская область, (Земли населенных пунктов)
    _3_5_44='35:44' # Никольский район, Вологодская область, (Земли населенных пунктов)
    _4_7_10='47:10' # Ломоносовское, Ленинградская область, (Земли лесного фонда)
    _2_3_43='23:43' # Курганинский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_11='47:11' # Лужское, Ленинградская область, (Земли лесного фонда)
    _2_3_44='23:44' # Кущевский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_45='23:45' # Лабинский район, Краснодарский край, (Земли населенных пунктов)
    _2_3_46='23:46' # Ленинградский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_47='23:47' # Мостовский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_48='23:48' # Новокубанский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_49='23:49' # Новопокровский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_18='47:18' # Тихвинское, Ленинградская область, (Земли лесного фонда)
    _4_7_19='47:19' # Учебно-опытное, Ленинградская область, (Земли лесного фонда)
    _4_7_16='47:16' # Северо-Западное, Ленинградская область, (Земли лесного фонда)
    _4_7_17='47:17' # Сланцевское, Ленинградская область, (Земли лесного фонда)
    _4_7_14='47:14' # Приозерское, Ленинградская область, (Земли лесного фонда)
    _4_7_15='47:15' # Рощинское, Ленинградская область, (Земли лесного фонда)
    _2_3_40='23:40' # Красноармейский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_12='47:12' # Любанское, Ленинградская область, (Земли лесного фонда)
    _2_3_41='23:41' # Крыловский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _4_7_13='47:13' # Подпорожское, Ленинградская область, (Земли лесного фонда)
    _2_3_42='23:42' # Крымский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _3_5_32='35:32' # Великоустюгский район, Вологодская область, (Земли населенных пунктов)
    _3_5_31='35:31' # Вашкинский район, Вологодская область, (Земли населенных пунктов)
    _3_5_30='35:30' # Белозерский район, Вологодская область, (Земли населенных пунктов)
    _3_5_39='35:39' # Грязовецкий район, Вологодская область, (Земли населенных пунктов)
    _7_2_49='72:49' # Ярковский, Тюменская область, (Земли населенных пунктов)
    _3_5_38='35:38' # г.Череповец, Вологодская область, (Земли населенных пунктов)
    _3_5_37='35:37' # г.Вологда, Вологодская область, (Земли населенных пунктов)
    _7_2_47='72:47' # Юргинский, Тюменская область, (Земли населенных пунктов)
    _3_5_36='35:36' # Вытегорский район, Вологодская область, (Земли населенных пунктов)
    _7_2_48='72:48' # Ялуторовский, Тюменская область, (Земли населенных пунктов)
    _3_5_35='35:35' # Вологодский район, Вологодская область, (Земли населенных пунктов)
    _7_2_45='72:45' # Уватский, Тюменская область, (Земли населенных пунктов)
    _3_5_34='35:34' # Вожегодский район, Вологодская область, (Земли населенных пунктов)
    _7_2_46='72:46' # Упоровский, Тюменская область, (Земли населенных пунктов)
    _3_5_33='35:33' # Верховажский район, Вологодская область, (Земли населенных пунктов)
    _2_3_54='23:54' # Славянский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_55='23:55' # Староминский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_56='23:56' # Тбилисский муницип. р-он, Краснодарский край, (Земли населенных пунктов)
    _2_3_57='23:57' # Темрюкский мун