import sqlite3


class MapCatalog:
    __name_table='mapinfo_mapcatalog'
    def __init__(self,path_db):
        self.__connect=sqlite3.connect(path_db)
        if self.__connect is not None:
            self.createMapCatalog()
            self.__updateMapCatalog=[]
    @property
    def connect(self):
        return self.__connect
    def createMapCatalog(self):
        sql_create='CREATE TABLE mapinfo_mapcatalog(  spatialtype FLOAT,   tablename TEXT,   ownername CHAR(32),   spatialcolumn CHAR(32),   db_x_ll DOUBLE,   db_y_ll DOUBLE,   db_x_ur DOUBLE,   db_y_ur DOUBLE,   view_x_ll DOUBLE,   view_y_ll DOUBLE,   view_x_ur DOUBLE,   view_y_ur DOUBLE,   coordinatesystem TEXT,   symbol TEXT,   xcolumnname CHAR(32),   ycolumnname CHAR(32),   renditiontype INTEGER,   renditioncolumn TEXT,   renditiontable TEXT,   number_rows INTEGER)'
        existTable=self.exisTable(self.__name_table)
        if not existTable:
            self.runSql(sql_create)
    def Close(self):
        if self.__connect is not None:
            if len(self.__updateMapCatalog)>0:
                for sql_insert in self.__updateMapCatalog:
                    self.runSqlParams(sql_insert['sql'], sql_insert['params'])
            self.__connect.commit()
            self.__connect.close()
    def runSql(self,sql):
        cursor = self.__connect.cursor()
        try:
            cursor.execute(sql)
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
    def exisTable(self,name_table):
        sql="SELECT name FROM sqlite_master WHERE type='table' AND name='"+name_table+"'"
        cursor = self.__connect.cursor()
        existTable=False
        try:
            listOfTables = cursor.execute(sql)
            if listOfTables.rowcount>0:
                existTable=True
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
        return existTable
    def insertLayerDescription(self,name_layer,name_geo_col,type_mi_spaial_type,mi_prj,bound):
        sql ='Insert into '+self.__name_table+" (spatialtype,tablename,spatialcolumn,db_x_ll,db_y_ll,db_x_ur,db_y_ur,view_x_ll,view_y_ll,view_x_ur,view_y_ur,coordinatesystem,renditiontype,renditioncolumn) "
        sql=sql + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
        params=(22.3,name_layer,name_geo_col,bound[0],bound[2],bound[1],bound[3],bound[0],bound[2],bound[1],bound[3],mi_prj,1,"MI_STYLE")
        #self.runSqlParams(sql, params)
        self.__updateMapCatalog.append({'sql':sql,'params':params})
        return
    def runSqlParams(self,sql,params):
        cursor = self.__connect.cursor()
        try:
            cursor.execute(sql,params)
        except Exception as ex:
            print(ex)
        finally:
            cursor.close()
    def addLayerInfoInMapCataalog(self,layer,mi_prj):
        name_geometry_col = layer.GetGeometryColumn()
        name_layer = layer.GetName()
        ext_layer = layer.GetExtent()
        self.insertLayerDescription(name_layer, name_geometry_col, None, mi_prj, ext_layer)





