from osgeo import ogr, osr


class ObjOMSPoint:
    def __init__(self,tagOMSPoint,cadNumber,mi_style=''):
        self.__xmlObjOMSPoint=tagOMSPoint
        self.__str_styleMi=mi_style
        self.__CadastralNumber=cadNumber


    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'Номер_пункта_на_сети', 'type': ogr.OFTString, 'width': 255})
        struct.append({'name': 'Название_тип_пункта', 'type': ogr.OFTString, 'width': 1000})
        struct.append({'name': 'Класс_геодезической_сети', 'type': ogr.OFTString, 'width': 255})
        struct.append({'name': 'x', 'type': ogr.OFTReal})
        struct.append({'name': 'y', 'type': ogr.OFTReal})
        return struct
    def setMiStyle(self,mi_style):
        self.__str_styleMi=mi_style
    def Write(self, layer):
        strPNmb = self.__xmlObjOMSPoint.PNmb
        valPName = self.__xmlObjOMSPoint.PName
        valuePKlass=self.__xmlObjOMSPoint.PKlass
        valueOrdX=self.__xmlObjOMSPoint.OrdX
        valueOrdY = self.__xmlObjOMSPoint.OrdY

        geo_point=ogr.Geometry(ogr.wkbPoint)
        geo_point.AddPoint(float(valueOrdX),float(valueOrdY))

        att = []
        att.append({'name': 'Номер_пункта_на_сети', 'value': strPNmb })
        att.append({'name': 'Название_тип_пункта', 'value': valPName})
        att.append({'name': 'x', 'value': float(valueOrdX)})
        att.append({'name': 'y', 'value': float(valueOrdY)})
        feature = ogr.Feature(layer.GetLayerDefn())
        if self.__str_styleMi is not None:
            att.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        for atr_item in att:
            # print(atr_item['name'])
            # print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        if geo_point is not None:
            feature.SetGeometry(geo_point)

        layer.CreateFeature(feature)
        geoObj = None
        feature = None

        return
class ObjOMSPoints:
    __xmlObjOMSPoints = None
    __listRealty = None
    __cs_prj4 = None
    __str_styleMi = None
    __reverseXY = True
    __CadastralNumber=None
    __countBuilding=0
    __countConstruction=0
    __layers=None
    __nameProcess = "пунктах ОМС"
    __name = "пункты_ОМС"
    def __init__(self, OMSPoints, cadastralNumber=None):
        self.__listOMSPoints = None
        if OMSPoints is None:
            return
        self.__xmlObjOMSPoints = OMSPoints
        self.__listOMSPoints = []
        for itemtagOMSPoint in self.__xmlObjOMSPoints.OMSPoint:
            self.__listOMSPoints.append(ObjOMSPoint(itemtagOMSPoint, self.__CadastralNumber, self.__str_styleMi))
    def setOutParams(self,cs_proj4,mi_style,reverseXY=True):
        self.__str_styleMi = mi_style
        self.__cs_prj4 = cs_proj4
        self.__reverseXY = reverseXY

    def setProperty(self, property):
        self.__property = property
        self.__cs_prj4 = property['cs']
        self.__reverseXY=property['reverseXY']
    def CreateLayer(self,ds,createNewLayer=True):
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__cs_prj4)
        layer=None
        if not createNewLayer:
            layer=ds.GetLayer(self.__name)
            if layer is not None:
                return layer

        layer = ds.CreateLayer(self.__name, srs, geom_type=ogr.wkbPoint)
        for fld in ObjOMSPoint.getStruct():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'], fld['type'])
            type_field = fld['type']
            if fld['type'] == ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        #if self.__str_styleMi is not None:
        field_cur = ogr.FieldDefn("MI_STYLE", ogr.OFTString)
        field_cur.SetWidth(128)
        layer.CreateField(field_cur)
        return layer
    def Save(self,ds):
        layer=self.CreateLayer(ds,self.__cs_prj4)
        self.Write(layer)

    @property
    def NameLayer(self):
        return self.__name

    @property
    def NameProcess(self):
        return self.__nameProcess

    @property
    def Count(self):
        if self.__listOMSPoints is None:
            return 0
        return len(self.__listOMSPoints)
    def Write(self,layer,dbDictionary,mapCatalog):
        if self.__listOMSPoints is None:
            return
        ''' Получаем стиль из базы'''
        mi_style = dbDictionary.GetStyle('kpt_10_style', 'OMSPoints')
        if mi_style[0] is None:
            print(mi_style[1])
            str_mi_style = 'Pen (2, 6, 16711680) Brush (1, 16777215, 16777215)'
        else:
            str_mi_style = mi_style[0]
        #layer.StartTransaction()
        for points in self.__listOMSPoints:
            points.setMiStyle(str_mi_style)

            points.Write(layer)
        mapCatalog.addLayerInfoInMapCataalog(layer, self.__property['cs_mi'])