import logging
import os

#from PkkXml.plugins.XmlPkk.KptObjXml import FactoryKpt, ClearKpt
#from PkkXml.plugins.XmlPkk.ObjectToSave import DbGeoOgr
#from PkkXml.plugins.XmlPkk.ObjKPT import parse
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr
from rosreestrXml.ui.tools.kptTools.KptObjXml import FactoryKpt, ClearKpt
from rosreestrXml.ui.tools.kptTools.kpt_10 import parse


class SimpleProcessPkk:
    '''
    Класс импорта xml pkk
    '''
    __outDataSourceFile=None
    __cs_wkt=None
    __listFileXml=None
    __ObjKpt=None
    __objXmlKpt=None
    def __init__(self,outFile:str,namesImport:dict,styles:dict,cs_out:str):
        '''

        :param outFile: путь на результирующий файл ( gpkg)
        :param namesImport: импортируемые объекты ( зоны , кварталы и т.д)
        :param styles: стили для разных типов объектов
        :param cs_out: результирующая кооржинатная система
        '''
        self.__outDataSourceFile=outFile
        self.__cs_wkt=cs_out
        self.__objectNameImport=namesImport
        self.__importStyles=styles
    def setXmls(self,listFiles):
        self.__listFileXml=listFiles
    def initOutDs(self,pathOut=None):
        pathDb=pathOut
        if pathDb is None:
            pathDb=self.__outDataSourceFile
        logging.info("init out dataSource:"+pathDb)
        addToExist = False
        self.__db = DbGeoOgr(None, pathDb, addToExist)
        self.__db.initDs(pathDb)
        self.__db.initCatalog()
        if self.__db.DataSource is None:
            self.__db=None
            logging.error("Error create (open):"+pathDb)
            return False
        return True
    @property
    def Db(self):
        return self.__db
    def ImportPkk(self,path_xml_pkk:str,pathOut_file=None):
        '''
        Импорт xml pkk
        :param path_xml_pkk: путь на xml
        :param pathOut_file: путь на результирующий файл , если none то запись в один определенный в классе
        :return:
        '''
        ObjKpt = parse(path_xml_pkk, True)
        objXmlKpt = FactoryKpt(ObjKpt)
        if self.__objectNameImport['SpatialData']:
            mi_style=self.__importStyles['SpatialData']
            objXmlKpt[0].SaveSpatialData(self.__db,self.__cs_wkt,mi_style)
        if self.__objectNameImport['Parcels']:
            mi_style = self.__importStyles['Parcels']
            objXmlKpt[0].SaveParcels(self.__db,self.__cs_wkt,mi_style)
        if self.__objectNameImport['Zones']:
            mi_style = self.__importStyles['Zones']
            objXmlKpt[0].SaveZones(self.__db, self.__cs_wkt, mi_style)
        if self.__objectNameImport['Realty_Building']:
            mi_style = self.__importStyles['Realty_Building']
            objXmlKpt[0].SaveRealtyBuilding(self.__db, self.__cs_wkt, mi_style)
        ClearKpt(ObjKpt)
        jkl=0

    @property
    def CountProcess(self):
        count_out=0
        lst_name = list(self.__objectNameImport.keys())
        for name_proc in lst_name:
            if self.__objectNameImport[name_proc]:
                count_out = count_out + 1
        return count_out
    @property
    def getCountItem(self):
        if self.__listFileXml is None:
            return 0
        return len(self.__listFileXml)
    def getNameXml(self,idXml):
        path_xml = self.__listFileXml[idXml]
        head, name = os.path.split(path_xml)
        return name
    def readItemXml(self,idXml):
        path_xml=self.__listFileXml[idXml]
        print("Read "+path_xml)
        if self.__ObjKpt is not None:
            ClearKpt(self.__ObjKpt)
        self.__ObjKpt = parse(path_xml, True)
        self.__objXmlKpt = FactoryKpt(self.__ObjKpt)
        print("End Create Obj")
    def getObj(self,id):
        if id==0 :
            ''' читаем'''
        count_out = 0
        lst_name = list(self.__objectNameImport.keys())
        for name_proc in lst_name:
            if self.__objectNameImport[name_proc]:
                if count_out==id:
                    if name_proc=='SpatialData':
                        mi_style = self.__importStyles['SpatialData']
                        return self.__objXmlKpt[0].getObjSpatialDataToSave(self.__cs_wkt,mi_style)
                    if name_proc=='Parcels':
                        mi_style = self.__importStyles['Parcels']
                        return self.__objXmlKpt[0].getObjParcelsToSave(self.__cs_wkt,mi_style)
                    if name_proc=='Zones':
                        mi_style = self.__importStyles['Zones']
                        return self.__objXmlKpt[0].getObjZonesToSave(self.__cs_wkt,mi_style)

                    if name_proc=='Realty':
                        mi_style = self.__importStyles['Realty']
                        return self.__objXmlKpt[0].getObjRealtyToSave(self.__cs_wkt,mi_style)
                count_out = count_out + 1
        return None
    def CloseDs(self):
        self.__db.Close()

