from osgeo import ogr, osr

from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.KPT.kptTools.KPTXml import GeoPolygonFromEntitySpatial


class ObjParcel:
    __cs_prj4 = None
    __str_styleMi = None
    __reverseXY = True
    __xmlObjParcel=None
    def __init__(self,tagParcel,mi_style=None):
        self.__xmlObjParcel=tagParcel
        self.__str_styleMi=mi_style
    def setMiStyle(self,mi_style):
        self.__str_styleMi=mi_style
    @staticmethod
    def getStruct():
        struct=[]
        field_caD = {}
        field_caD['name'] = 'КадНомер'
        field_caD['type'] = ogr.OFTString
        field_caD['width'] = 50
        struct.append(field_caD)
        struct.append({'name':'КодСтатус','type':ogr.OFTInteger})
        struct.append({'name': 'Статус', 'type': ogr.OFTString,'width':20})
        struct.append({'name': 'ДатаСоздания', 'type': ogr.OFTString,'width':22})
        struct.append({'name': 'КодВидУчастка', 'type': ogr.OFTInteger})
        struct.append({'name': 'ВидУчастка', 'type': ogr.OFTString, 'width': 30})
        struct.append({'name': 'КодКатегория_земель', 'type':ogr.OFTString, 'width': 20})
        struct.append({'name': 'Категория_земель', 'type': ogr.OFTString, 'width': 240})
        struct.append({'name': 'Местоположение', 'type': ogr.OFTString, 'width': 4000})
        struct.append({'name': 'OKATO', 'type': ogr.OFTString, 'width': 12})
        struct.append({'name': 'KLADR', 'type': ogr.OFTString, 'width': 20})
        struct.append({'name': 'КодРегиона', 'type': ogr.OFTString, 'width': 3})
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})
        return struct
    @staticmethod
    def getStructContours():
        struct = []
        struct.append({'name':'КадНомер','type':ogr.OFTString,'width':50})
        struct.append({'name': 'УчетныйНомер', 'type': ogr.OFTInteger})
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})
        return struct
    @property
    def Contours(self):
        return self.__xmlObjParcel.Contours
    def WriteContours(self,layer):
        if self.__xmlObjParcel.Contours is  None :
            return

        for contour in self.__xmlObjParcel.Contours.Contour:
            self.WriteContoursItem(layer,contour)
    def WriteContoursItem(self,layer,objContours):
        att = []
        att.append({'name': 'КадНомер', 'value': self.__xmlObjParcel.CadastralNumber})
        att.append({'name': 'УчетныйНомер', 'value': objContours.NumberRecord})
        feature = ogr.Feature(layer.GetLayerDefn())
        if self.__str_styleMi is not None:
            att.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        for atr_item in att:
            # print(atr_item['name'])
            # print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        geoObj = GeoPolygonFromEntitySpatial(objContours.EntitySpatial)
        if geoObj is not None:
            feature.SetGeometry(geoObj)
        layer.CreateFeature(feature)
        geoObj=None
        feature=None
        return
    def Write(self,layer,dbDictionary:KptСatalog,reverseXY=False):
        strCadastralNumber=self.__xmlObjParcel.CadastralNumber
        valCodeState=self.__xmlObjParcel.State
        valState,codError=dbDictionary.getStateObjectZU(valCodeState)
        valDate=str(self.__xmlObjParcel.DateCreated)
        valCodeType=self.__xmlObjParcel.Name
        valType,codError=dbDictionary.getNameLandType(valCodeType)
        valCodeCategory=self.__xmlObjParcel.Category
        valCategory,codError=dbDictionary.getCategoryEarth(valCodeCategory)
        objLocation=self.__xmlObjParcel.Location
        valOkato=objLocation.Address.OKATO
        valKladr=objLocation.Address.KLADR
        valNote=objLocation.Address.Note
        valRegionCode=objLocation.Address.Region
        geoObj = GeoPolygonFromEntitySpatial(self.__xmlObjParcel.EntitySpatial,reverseXY)
        att=[]
        att.append({'name':'КадНомер','value':strCadastralNumber})
        att.append({'name': 'КодСтатус', 'value': valCodeState})
        att.append({'name': 'Статус', 'value': valState})
        att.append({'name': 'ДатаСоздания', 'value': valDate})
        att.append({'name': 'КодВидУчастка', 'value': valCodeType})
        att.append({'name': 'ВидУчастка', 'value': valType})
        att.append({'name': 'КодКатегория_земель', 'value': valCodeCategory})
        att.append({'name': 'Категория_земель', 'value': valCategory})
        att.append({'name': 'OKATO', 'value': valOkato})
        att.append({'name': 'KLADR', 'value': valKladr})
        att.append({'name': 'KLADR', 'value': valKladr})
        att.append({'name': 'Местоположение', 'value': valNote})
        att.append({'name': 'КодРегиона', 'value': valRegionCode})
        feature = ogr.Feature(layer.GetLayerDefn())
        if self.__str_styleMi is not None:
            att.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        for atr_item in att:
            #print(atr_item['name'])
            #print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        if geoObj is not None:
            feature.SetGeometry(geoObj)
        layer.CreateFeature(feature)
        geoObj=None
        feature=None
        return
class ObjParcels:
    __xmlParcels=None
    __name="земельные_участки"
    __listParcel=None
    __cs_prj4 = None
    __str_styleMi = None
    __reverseXY = True
    __nameProcess="Импорт земельных участков"
    __countContours=0
    __layerContours=None
    def __init__(self,tagParcels):
        self.__xmlParcels=tagParcels
        if tagParcels is None:
            return

        self.__listParcel=[]
        self.__countContours=0
        for itemtagParcel in self.__xmlParcels.Parcel:
            if itemtagParcel.Contours is not None :
                self.__countContours=self.__countContours+1
            self.__listParcel.append(ObjParcel(itemtagParcel,self.__str_styleMi))


    def setOutParams(self,cs_proj4,mi_style,reverseXY=True):
        self.__str_styleMi = mi_style
        self.__cs_prj4 = cs_proj4
        self.__reverseXY = reverseXY
    def setProperty(self,property):
        self.__property=property
        self.__cs_prj4=property['cs']
    def Save(self,ds,dbDictionary:KptСatalog):
        layer=self.CreateLayer(ds,self.__cs_prj4)
        self.Write(layer,dbDictionary)

    @property
    def NameProcess(self):
        return self.__nameProcess

    @property
    def NameLayer(self):
        return self.__name
    @property
    def Count(self):
        if self.__listParcel is None:
            return 0
        return len(self.__listParcel)
    def CreateLayer(self,ds,createNewLayer=True):
        if self.__countContours>0:
            self.__layerContours=self.CreateLayerContours(ds,createNewLayer)
        layer = None
        if not createNewLayer:
            layer = ds.GetLayer(self.__name)
            if layer is not None:
                return layer
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__cs_prj4)
        layer = ds.CreateLayer(self.__name, srs, geom_type=ogr.wkbUnknown)
        for fld in ObjParcel.getStruct():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'], fld['type'])
            type_field = fld['type']
            if fld['type'] == ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer
    def CreateLayerContours(self,ds,createNewLayer=True):
        layer = None
        if not createNewLayer:
            layer = ds.GetLayer(self.__name+"_Контуры")
            if layer is not None:
                return layer
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__cs_prj4)
        layer = ds.CreateLayer(self.__name+"_Контуры", srs, geom_type=ogr.wkbUnknown)
        for fld in ObjParcel.getStructContours():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'], fld['type'])
            type_field = fld['type']
            if fld['type'] == ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer
    def Write(self,layer,dbDictionary:KptСatalog,mapCatalog):
        if self.__listParcel is None:
            return
        ''' Получаем стиль из базы'''
        mi_style = dbDictionary.GetStyle('kpt_10_style', 'Parcels')
        if mi_style[0] is None:
            print(mi_style[1])
            str_mi_style = 'Pen (2, 6, 16711680) Brush (1, 16777215, 16777215)'
        else:
            str_mi_style = mi_style[0]
        for parcel in self.__listParcel:
            if self.__countContours >0 :
                parcel.WriteContours(self.__layerContours)
            parcel.setMiStyle(str_mi_style )
            parcel.Write(layer,dbDictionary)
    def WriteItem(self,i,layer,kptCatalog,dbDocument):
        ''' запись Parcels в базу '''
        parcel=self.__listParcel[i]
        parcel.setMiStyle(self.__str_styleMi)
        parcel.Write(layer, kptCatalog)