from rosreestrXml.ui.tools.KPT.kptTools.kpt_10 import parseString
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr
from rosreestrXml.ui.tools.KPT.kptTools.GeometryClass import SpatialObjPolyLine
from rosreestrXml.ui.tools.KPT.kptTools.KPTXml import FactorySpatialData
from rosreestrXml.ui.tools.KPT.kptTools.KptBound import ObjBounds, addAtributDocuments
from rosreestrXml.ui.tools.KPT.kptTools.KptParcels import ObjParcels
from rosreestrXml.ui.tools.KPT.kptTools.KptZones import ObjZones
from rosreestrXml.ui.tools.KPT.kptTools.XmlOMSPoints import ObjOMSPoints
from rosreestrXml.ui.tools.KPT.kptTools.XmlRealtys import ObjRealtys


class XmlCadastralBlock:
    __cadastralNumber=None
    __Area = None
    __Parcels = None
    __ObjectsRealty = None
    __SpatialData = None
    __objZones=None
    __CoordSystems=None
    __objParcels=None
    __objBounds=None
    __objOMSPoints=None
    def __init__(self,cadastrNumber):
        self.__cadastralNumber=cadastrNumber
        pass
    def setSpatialData(self,objSpatialData):
        self.__SpatialData=objSpatialData
    def SetCoordSys(self,tagCoordSys):
        self.__CoordSystems=tagCoordSys
    def setParcels(self,objParcels):
        self.__objParcels=objParcels
    def setZones(self,objZones):
        self.__objZones=objZones
    def setBounds(self,objBounds):
        self.__objBounds=objBounds
    def setObjectsRealty(self,objRealty):
        self.__ObjectsRealty=objRealty
    def setObjectOMSPoints(self,objOMSPoints):
        self.__objOMSPoints=objOMSPoints
    def SaveSpatialData(self,objectOut:DbGeoOgr,str_proj4,mi_style_str:str,reverseXY=True):
        if self.__SpatialData is None:
            return
        dbCatalog=objectOut.PropertyDB['Catalog']
        att_spatial=self.__SpatialData.Attribute
        docs=self.__SpatialData.document
        if docs is not None:
            att_spatial.extend(addAtributDocuments(docs.Document,dbCatalog))
        geoObjPolyOut=SpatialObjPolyLine(str_proj4,self.__SpatialData.Points,att_spatial,mi_style_str,reverseXY)
        objectOut.Save(geoObjPolyOut)
    def getObjSpatialDataToSave(self,str_proj4,mi_style_str:str,reverseXY=True):

        geoObjPolyOut = SpatialObjPolyLine(str_proj4, self.__SpatialData.Points, self.__SpatialData.Attribute,
                                           mi_style_str, reverseXY)
        return geoObjPolyOut
    def getObjSpatialData(self,property):
        if self.__SpatialData is not None:
            geoObjPolyOut = SpatialObjPolyLine(None, self.__SpatialData.Points, self.__SpatialData.Attribute,
                                             None, None)
            geoObjPolyOut.setProperty(property)
            return geoObjPolyOut
        return None
    def SaveParcels(self,objectOut:DbGeoOgr,str_proj4,mi_style_str:str,reverseXY=True):
        self.__objParcels.setOutParams(str_proj4,mi_style_str,reverseXY)
        objectOut.Save(self.__objParcels)
    def SaveOMSPoints(self,objectOut:DbGeoOgr,str_proj4,mi_style_str,reverseXY):
        self.__objOMSPoints.setOutParams(str_proj4,mi_style_str,reverseXY)
        objectOut.Save(self.__objOMSPoints)

    def getObjOMSPoints(self,property):
        if self.__objOMSPoints is None:
            return None
        self.__objOMSPoints.setProperty(property)
        return self.__objOMSPoints
    def getObjParcelsToSave(self,str_proj4,mi_style_str:str,reverseXY=True):
        self.__objParcels.setOutParams(str_proj4, mi_style_str, reverseXY)
        return self.__objParcels

    def getObjParcels(self, property):
        if self.__objParcels is not None:
            self.__objParcels.setProperty(property)
        return self.__objParcels
    def SaveZones(self,objectOut:DbGeoOgr,str_proj4,mi_style_str:str,reverseXY=True):
        self.__objZones.setOutParams(str_proj4,mi_style_str,reverseXY)
        objectOut.Save(self.__objZones)
    def SaveRealty(self,objectOut:DbGeoOgr,str_proj4,mi_style_str:str,reverseXY=True):
        self.__ObjectsRealty.setOutParams(str_proj4,mi_style_str,reverseXY)
        objectOut.Save(self.__ObjectsRealty)
    def getObjRealtyToSave(self,str_proj4,mi_style_str:str,reverseXY=True):
        self.__ObjectsRealty.setOutParams(str_proj4, mi_style_str, reverseXY)
        return self.__ObjectsRealty
    def getObjRealty(self,property):
        self.__ObjectsRealty.setProperties(property)
        return self.__ObjectsRealty
    def getObjRealtyBuildingToSave(self,str_proj4,mi_style_str:str,reverseXY=True):
        self.__ObjectsRealty.setOutParams(str_proj4, mi_style_str, reverseXY)
        return self.__ObjectsRealty
    def getObjZonesToSave(self,str_proj4,mi_style_str:str,reverseXY=True):
        self.__objZones.setOutParams(str_proj4, mi_style_str, reverseXY)
        return self.__objZones
    def getObjZones(self,property):
        self.__objZones.setProperties(property)
        return self.__objZones
    def getObjBoundsToSave(self,str_proj4,mi_style_str:str,reverseXY=True):
        self.__objBounds.setOutParams(str_proj4, mi_style_str, reverseXY)
        return self.__objBounds
    def getObjBounds(self,property):
        self.__objBounds.setProperties(property)
        return self.__objBounds
def FactoryCadastralBlock(tagCadastralBlock,property)  :
    tagCoordSystems=tagCadastralBlock.CoordSystems
    #objCadastreBlock=XmlCadastralBlock()
    cadNumber = tagCadastralBlock.CadastralNumber
    cadstrBlock = XmlCadastralBlock(cadNumber)
    cadstrBlock.SetCoordSys(tagCoordSystems)
    try:
        if property['spatial_data']['enable']:
            tagSpatialData = tagCadastralBlock.SpatialData
            objSpatial = FactorySpatialData(tagSpatialData, cadNumber)
            cadstrBlock.setSpatialData(objSpatial)
    except:
        pass
    try:
        if property['parcels']['enable']:
            objParcels = tagCadastralBlock.Parcels
            cadstrBlock.setParcels(ObjParcels(objParcels))
    except:
        pass
    #tagSpatialData=tagCadastralBlock.SpatialData
    #objSpatial=FactorySpatialData(tagSpatialData,cadNumber)
    try:
        if property['zones']['enable']:
            objZones=tagCadastralBlock.Zones
            cadstrBlock.setZones(ObjZones(objZones, cadNumber))
    except:
        pass
    try:
        if property['realtys']['enable']:

            cadstrBlock.setObjectsRealty(ObjRealtys(tagCadastralBlock.ObjectsRealty,cadNumber))
    except:
        pass
    #cadstrBlock.setSpatialData(objSpatial)
    try:
        if property['bounds']['enable']:

            cadstrBlock.setBounds(ObjBounds(tagCadastralBlock.Bounds,cadNumber))
    except:
        pass

    try:
        if property['oms_points']['enable']:
            cadstrBlock.setObjectOMSPoints(ObjOMSPoints(tagCadastralBlock.OMSPoints))
    except:
        pass
    #cadstrBlock.setBounds(ObjBounds(tagCadastralBlock.Bounds,cadNumber))
    #cadstrBlock.setObjectOMSPoints(ObjOMSPoints(tagCadastralBlock.OMSPoints))
    return cadstrBlock
def getObjectToSave(cadBlock,property):
    out_obj=[]
    try:
        if property['spatial_data']['enable']:
            out_obj.append(cadBlock.getObjSpatialData(property))
    except:
        pass
    try:
        if property['parcels']['enable']:
            out_obj.append(cadBlock.getObjParcels(property))
    except:
        pass
    try:
        if property['zones']['enable']:
            out_obj.append(cadBlock.getObjZones(property))
    except:
        pass
    try:
        if property['bounds']['enable']:
            out_obj.append(cadBlock.getObjBounds(property))
    except:
        pass
    try:
        if property['realtys']['enable']:
            out_obj.append(cadBlock.getObjRealty(property))
    except:
        pass
    try:
        if property['oms_points']['enable']:
            out_obj.append(cadBlock.getObjOMSPoints(property))
    except:
        pass
    if len(out_obj)>0:
        return out_obj
    return None
class KptGeo:
    __CadastralBlocks=None
    def __init__(self):
        pass

def FactoryKpt(objKpt,property):
    cadBloks=[]
    for cadBlock_item in objKpt.CadastralBlocks.CadastralBlock:
        cadBlock=FactoryCadastralBlock(cadBlock_item,property)
        if cadBlock is None:
            continue
        cadBloks.append(cadBlock)
    return cadBloks
def FactoryKpt10FromString(source_xml,property):
    objKpt=parseString(source_xml,True)
    if objKpt is None:
        return None
    return FactoryKpt(objKpt,property)
def FactoryObjectKpt10FromString(source_xml,property):
    property_kpt10=property['kpt10']
    property_kpt10['cs']=property['cs']
    property_kpt10['cs_mi']=property['cs_mi']
    property_kpt10['reverseXY'] =property ['reverseXY']
    objKpt=parseString(source_xml,True)
    if objKpt is None:
        return None
    cadBloks= FactoryKpt(objKpt,property_kpt10)
    if cadBloks is None or len(cadBloks)==0:
        return None
    list_objToSave=[]
    for cad_block in cadBloks:
        obj_to_save=getObjectToSave(cad_block,property_kpt10)
        if obj_to_save is not None:
            list_objToSave.extend(obj_to_save)
    if len(list_objToSave)>0:
        return list_objToSave
    return None
def ClearKpt(objKpt):
    pass


