import axipy
from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr, TypeGeometryProviderOgr
from rosreestrXml.ui.tools.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.kptTools.KptObjXml import FactoryKpt
from rosreestrXml.ui.tools.kptTools.kpt_10 import parse

path_kpt=r"E:\Download\RossRestr\47_17_0102002_2020-04-06_kpt10.xml\47_17_0102002_2020-04-06_kpt10.xml"
path_out=r"E:\Download\RossRestr\47_17_0102002_2020-04-06_kpt10.xml\47_17_0102002_2020-04-06_kpt10.gpkg"
cs_wkt = 'LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
properties={}
properties['cs']=cs_wkt
properties['cs_mi']='NonEarth Units "m" '
properties['reverseXY']=False
properties['zones']={}
properties['zones']['enable']=False
properties['spatial_data']={}
properties['spatial_data']['enable']=False
properties['parcels']={}
properties['parcels']['enable']=True

dbCatalog=KptСatalog()
dbDoc = None
dbDoc = DocumentsDb(path_out)
db = DbGeoOgr(dbCatalog)
db.Create(path_out, TypeGeometryProviderOgr.GPKG)
ObjKpt=parse(path_kpt,True)
objKpt10= FactoryKpt(ObjKpt,properties)
objZones=objKpt10[0].getObjZones()
if objZones is not None:
    objZones.setProperties(properties)
    db.Save(objZones)
objSpatial=objKpt10[0].getObjSpatialData(properties)
if objSpatial is not None:
    db.Save(objSpatial)
objParcels=objKpt10[0].getObjParcels(properties)
if objParcels is not None:
    db.Save(objParcels)
db.Close()
print("End End")
