import axipy
import glob, os

from PkkXml.plugins.XmlPkk.ObjectToSave import TypeGeometryProviderOgr
from rosreestrXml.ui.tools.KPT.factory_kpt import factoryKptObj
from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.KPT.kptTools.KptObjXml import FactoryObjectKpt10FromString
from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr
from rosreestrXml.ui.tools.utils.fileAdapter import DataSourceXml

path_source=r"E:\Download\RossRestr\47_17_0102002_2020-04-06_kpt10.xml\47_17_0102002_2020-04-06_kpt10.xml"
path_source=r"E:\Download\RossRestr\TestZip\71_01_010401_2015-11-10_kpt09.xml.sig\71_01_010401_2015-11-10_kpt09.xml"
path_source=r"E:\Download\RossRestr\report-2dcb0ac2-6dad-49e7-8d0b-44a12f4c1b41-OfSite-2020-09-02-265959-69-010.xml"
path_source=r"E:\Download\RossRestr\newEGRN\report-4393f417-5b0d-49f5-938f-1954effeaf84-BC-2024-10-30-590300-86-01[0].xml"
path_out=r"E:\Download\RossRestr\47_17_0102002_2020-04-06_kpt10.xml\47_17_0102002_2020-04-06_kpt10.gpkg"
path_out=r"E:\Download\RossRestr\TestZip\71_01_010401_2015-11-10_kpt09.xml.sig\71_01_010401_2015-11-10_kpt09.gpkg"
path_out=r"E:\Download\RossRestr\report-2dcb0ac2-6dad-49e7-8d0b-44a12f4c1b41-OfSite-2020-09-02-265959-69-010.gpkg"
path_out=r"E:\Download\RossRestr\newEGRN\report-4393f417-5b0d-49f5-938f-1954effeaf84-BC-2024-10-30-590300-86-01[0].gpkg"
dbCatalog=KptСatalog()
dbDoc = None

dbDoc = DocumentsDb(path_out)
db = DbGeoOgr(dbCatalog)
db.Create(path_out, TypeGeometryProviderOgr.GPKG)
properties={}
cs_wkt = 'LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
properties['cs']=cs_wkt
properties['cs_mi']='NonEarth Units "m" '
properties['reverseXY']=False
prop_kpt10={}

prop_kpt10['zones']={}
prop_kpt10['zones']['enable']=True
prop_kpt10['spatial_data']={}
prop_kpt10['spatial_data']['enable']=True
prop_kpt10['parcels']={}
prop_kpt10['parcels']['enable']=True
prop_kpt10['bounds']={}
prop_kpt10['bounds']['enable']=True
prop_kpt10['realtys']={}
prop_kpt10['realtys']['enable']=True
prop_kpt10['oms_points']={}
prop_kpt10['oms_points']['enable']=True
prop_kp11={}
prop_kp11['zones']={}
#properties['zones']['style']=mi_style
prop_kp11['zones']['enable']=True

prop_kp11['municipal']={}
#properties['municipal']['style']=mi_style
prop_kp11['municipal']['enable']=True
prop_kp11['spatial']={}
#properties['spatial']['style']=mi_style
prop_kp11['spatial']['enable']=True

prop_kp11['land_building']={}
#properties['land_building']['style']=mi_style
prop_kp11['land_building']['enable']=True

properties['kpt11']=prop_kp11
properties['kpt10']=prop_kpt10
source_xml=[]
source_xml.append(path_source)
jkl=0
cls_sourceXml=DataSourceXml()
count=cls_sourceXml.build(source_xml)
count=cls_sourceXml.count
for i in range(count):
    file_source,value_file=cls_sourceXml.getSource(i)
    value_string_no_utf8=value_file.replace('<?xml version="1.0" encoding="utf-8"?>','')
    value_string_no_utf8=value_file.replace('<?xml version="1.0" encoding="UTF-8"?>','')
    objs_to_save=factoryKptObj(value_string_no_utf8,properties)
    if objs_to_save is None or len(objs_to_save)==0:
        continue
    for save_obj in objs_to_save:
        print(save_obj.NameProcess)

        db.Save( save_obj)
        print(save_obj.NameLayer)
cls_sourceXml.clear()
db.Close()
print("End End")