import axipy
from axipy import Map, data_manager, Style, Feature, view_manager, Notifications

from createFromSelection.ui.tools.factoryObject import FactoryGeometry


def getEditableTable(map:Map):
    editable_layer=map.editable_layer
    if editable_layer is None:
        return None
    return editable_layer.data_object
def createObject(type_out_object):
    cls_create = FactoryGeometry()
    count_points = cls_create.prepare_points(data_manager.selection)
    lim_count_points=2
    header_message="Создание полилинии"
    if type_out_object==axipy.GeometryType.Polygon:
        lim_count_points=3
        header_message = "Создание полигона"
    if count_points < lim_count_points:
        Notifications.push( header_message, 'Число точек меньше '+str(lim_count_points), Notifications.Warning)
        return
    geo_obj = cls_create.createGeometry(type_out_object, data_manager.selection.coordsystem)
    if geo_obj is None:
        Notifications.push( header_message, 'Объект не создан', Notifications.Information)
        return
    curent_style = Style.for_geometry(geo_obj)
    editable_tab = getEditableTable(view_manager.active.map)

    ft_new_geo = Feature({}, geo_obj, style=curent_style)
    editable_tab.insert([ft_new_geo])