import os

import axipy
from axipy import local_file, menubar, tr, data_manager, Notifications, Style, view_manager, Feature

from createFromSelection.ui.tools.factoryObject import FactoryGeometry
from createFromSelection.ui.tools.helper_observers.observersFactory import factoryObserverCreatePolyline
from createFromSelection.ui.tools.map_tools import getEditableTable, createObject


class CreatePolyline:
    __name = 'Создание полилинии'
    __name_observer = 'DataForCreatePolyline'
    def __init__(self,parent_class_plugin):
        self.__parent_cls_plugin=parent_class_plugin
        self.__observer=factoryObserverCreatePolyline(self.__name_observer)
        local_file_icon = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'icons', 'create_polyline_32_32.png')
        self.__action = self.__parent_cls_plugin.create_action('Создание полилинии',
                                           icon=local_file_icon,
                                           on_click=self.run_tools, enable_on=self.__name_observer)
        self.__parent_cls_plugin.position = menubar.get_position(tr(self.__parent_cls_plugin.NameTab),tr(self.__parent_cls_plugin.NameGroup))
        self.__parent_cls_plugin.position.add(self.__action, size=2)
    def unload(self):
        axipy.ObserverManager.remove(self.__name_observer)
        self.__action.remove()
    def run_tools(self):
        #print("run")
        createObject(axipy.GeometryType.LineString)
        '''
        cls_create=FactoryGeometry()
        count_points=cls_create.prepare_points(data_manager.selection)
        if count_points<2:
            Notifications.push('Создание полилинии', 'Число точек меньше 2', Notifications.Warning)
            return
        geo_obj = cls_create.createGeometry(axipy.GeometryType.LineString, data_manager.selection.coordsystem)
        curent_style=Style.for_geometry(geo_obj)
        editable_tab = getEditableTable(view_manager.active.map)

        ft_new_geo = Feature({}, geo_obj, style=curent_style)
        editable_tab.insert([ ft_new_geo])
        '''