import re

from PySide2.QtCore import QRect
from PySide2.QtGui import QGuiApplication
from axipy import Unit, Pnt, Rect, LinearUnit, Map

from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsParser import baseParser
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.utils import parserWindowInfo


class correctLineSpace:
    def __init__(self):
        self.__pline=compile("Create Pline {}")
    def getCountPointPline(self,str_pl):
        result=self.__pline.parse(str_pl)
        return

def removeLNFromLine(source:str)->str:
    index_ln=source.find('\n')
    if index_ln==len(source)-1:
        return source[:-1]
    return source
def removeLn(data_source):
    if isinstance(data_source,str):
        return removeLNFromLine(data_source)
    out_lines=[]
    for i,line in enumerate(data_source):

        cur_line=removeLNFromLine(line)
        if len(cur_line.strip())==0:
            continue

        if cur_line.lstrip()[0]==',' :
            last_id_line=len(out_lines)-1
            out_lines[last_id_line]=out_lines[last_id_line]+cur_line.lstrip()
        else:
            '''
            if len(out_lines)>0 and out_lines[-1].rstrip()[-1]==',':
            '''
            if len(out_lines)>0 and out_lines[-1].rstrip()[-1]==',' and out_lines[-1].lower().find("map from")==0:
                '''
                if cur_line.lower().find("pen (")>=0 or cur_line.lower().find("brush (")>=0 or cur_line.lower().find("symbol (")>=0:
                    out_lines.append(removeLNFromLine(line))
                else:
                '''
                out_lines[-1]=out_lines[-1]+cur_line.strip()
            else:
                out_lines.append(removeLNFromLine(line))
    return out_lines
def countSpaceinStart(line:str)->int:
    temp_string=line.lstrip()
    index=line.index(temp_string)
    return index
def listStringToString(list_str)->str:
    result=''
    for line in list_str:
        result=result+' '+line
    return result.lstrip()
def prepareLineWor(index,line:str,reg_first):
    count_space=countSpaceinStart(line)

    first_word=reg_first.findall(line)
    key_word=None
    if first_word is not None and len(first_word)>0:
        key_word=first_word[0]
        '''
        if key_word.lower()=='map' and index==887:
            jkl=0
        '''
    return {'index':index,'cnt_sp':count_space,"key":key_word,'words':first_word}
def prepareWor(lines):
    '''
    Пробелов и определяем строки которые начинаются с ключевого слоя команнад
    :param lines исходный массив строк wor:

    :return:
    '''
    reg_first=re.compile(r'\w+')
    out_prepare=[]
    for i,line in enumerate(lines):

        '''
        count_space=countSpaceinStart(line)

        first_word=reg_first.findall(line)
        key_word=None
        if first_word is not None and len(first_word)>0:
            key_word=first_word[0]
            
        out_prepare.append({'index':i,'cnt_sp':count_space,"key":key_word,'words':first_word})
        '''
        out_prepare.append(prepareLineWor(i,line,reg_first))
    return out_prepare
def findNextItem(prepare_wor,index_start,curent_offset):
    for i in range(index_start,len(prepare_wor)):
        if prepare_wor[i]['cnt_sp']>curent_offset:
            return prepare_wor[i]['index']
    return -1
def normWorLine(base_line,prepare_wor):
    '''
    исправляем wor для элементов Create Pline , Create Point
    Alpha
    :param base_line:
    :param prepare_wor:
    :return:
    '''
    reg_first=re.compile(r'\w+')
    for line_prepare in prepare_wor:

        words=line_prepare['words']
        '''
        if len(words) > 1 and words[0].lower() == 'map' and words[1].lower() == 'from' and line_prepare['cnt_sp']>0:
            line_prepare['cnt_sp']=0
        '''
        if len(words) > 1 and words[0].lower() == 'object':
            line_prepare['cnt_sp']=line_prepare['cnt_sp']+1
            continue
        if len(words)>1 and words[0].lower()=='create':
            if words[1].lower()=='pline':
                next_index=findNextItem(prepare_wor,line_prepare['index'],line_prepare['cnt_sp'])
                new_offset=line_prepare['cnt_sp']+2
                for i in range(line_prepare['index']+1,next_index):
                    update_item=prepare_wor[i]
                    string_source=base_line[i]
                    new_string= " " *new_offset+string_source.lstrip()
                    base_line[i]=new_string
                    prepare_wor[i]=prepareLineWor(i,new_string,reg_first)
                continue
            if words[1].lower()=='region':
                next_index=findNextItem(prepare_wor,line_prepare['index'],line_prepare['cnt_sp'])
                new_offset=line_prepare['cnt_sp']+2
                for i in range(line_prepare['index']+1,next_index):
                    update_item=prepare_wor[i]
                    string_source=base_line[i]
                    new_string= " " *new_offset+string_source.lstrip()
                    base_line[i]=new_string
                    prepare_wor[i]=prepareLineWor(i,new_string,reg_first)
                continue
            if words[1].lower()=='rect':
                next_index=findNextItem(prepare_wor,line_prepare['index'],line_prepare['cnt_sp'])
                new_offset=line_prepare['cnt_sp']+2
                for i in range(line_prepare['index']+1,next_index):
                    update_item=prepare_wor[i]
                    string_source=base_line[i]
                    new_string= " " *new_offset+string_source.lstrip()
                    base_line[i]=new_string
                    #prepare_wor[i]=prepareLineWor(i,new_string,reg_first)
                continue
        try:
            if words[0].lower()=='alpha' or words[0].lower()=='contrast' or words[0].lower()=='brightness'  or words[0].lower()=='transparency' or words[0].lower()=='color' or words[0].lower()=='transparency' or words[0].lower()=='grayscale' :
                line_prepare['cnt_sp']=line_prepare['cnt_sp']+1
        except Exception as ex:
            jkl=0


def buildTreeChildren(base_lines,curent_item,next_id,level):

    if next_id>=0:
        list_children=list(filter(lambda item: item['cnt_sp'] == level and item['index']>curent_item['index'] and  item['index']<=next_id , base_lines))
    else:
        list_children=[]
        for i in range(curent_item['index']+1,len(base_lines)):
            if base_lines[i]['cnt_sp']<level:
                break
            list_children.append(base_lines[i])
        #list_children=list(filter(lambda item: item['cnt_sp'] == level and item['index']>curent_item['index'] , base_lines))
    children_item=None
    if len(list_children)>0:
        curent_item['children']=list_children
        findChildren(base_lines,list_children,level+2)
        for id,item in enumerate(list_children):
            if item['key']=="Label":
                try:
                    if item['children'] is not None:
                        break
                except:
                    jkl=0
                item['children']=[]

                for id_ch in range(id+1,len(list_children)):
                    if list_children[id_ch]['cnt_sp']>list_children[id]['cnt_sp']:
                        item['children'].append(list_children[id_ch])
                    else:
                        break
                del list_children[id+1:id+len(item['children'])+1]
                return
    return
def findChildren(base_lines,list_parent,level):
    cnt=len(list_parent)
    if cnt==0:
        return
    for i in range(0,cnt-1):
        curent_item=list_parent[i]
        curent_next=list_parent[i+1]
        '''
        if level==2:
            #print(curent_next['index'])
            if curent_next['index']==1086:
                jkl=0
        '''
        if curent_next['index']-curent_item['index']==1 and (curent_next['cnt_sp']<=curent_item['cnt_sp']):
            curent_item['children']=None
            continue
        if curent_item['index']==24:
            jkl=0
        buildTreeChildren(base_lines,curent_item,curent_next['index'],level)
    jkl=0
    buildTreeChildren(base_lines,list_parent[cnt-1],-1,level)
def buildTree(prepare_line,level=0):
    list_level=list(filter(lambda item: item['cnt_sp'] == level, prepare_line))
    '''
    cnt=len(list_level)
    for i in range(0,cnt-1):
        curent_item=list_level[i]
        curent_next=list_level[i+1]
        if curent_next['index']-curent_item['index']==1:
            curent_item['children']=None
        buildTreeChildren(prepare_line,curent_item,curent_next['index'],2)
    '''
    findChildren(prepare_line,list_level,2)
    return list_level
def tokenPointToPnt(string_pnt):
    s_xy=string_pnt.split(",")
    return Pnt(float(s_xy[0]),float(s_xy[1]))

def UnitsFromString(str_unit):
    if len(str_unit.split(" "))==2:
        ''' Area unit'''
        unit_str=str_unit.split(" ")[1]
        if unit_str.lower()=='km':
            return  Unit.sq_km
        if unit_str.lower()=='m':
            return  Unit.sq_m
        if unit_str.lower() == 'mm':
            return Unit.sq_mm
        return None
    if str_unit.lower()=='km':
        return  Unit.km
    if str_unit.lower()=='m':
        return  Unit.m
    if str_unit.lower()=='cm':
        return  Unit.cm
    if str_unit.lower()=='mm':
        return  Unit.mm
    if str_unit.lower()=='in':
        return  Unit.inch
    if str_unit.lower()=='hectare':
        return  Unit.hectare
    return None
def getDpi():
    return QGuiApplication.instance().primaryScreen().logicalDotsPerInch()

def toScreen(value,str_unit):
    value_lines=value
    if isinstance(str_unit,LinearUnit):
        unit_val=str_unit
    else:
        unit_val=UnitsFromString(str_unit)
    if unit_val!=Unit.inch:
        value_lines=unit_val.to_unit(Unit.inch)
    dpi=getDpi()
    pix_value=dpi*value_lines
    return pix_value

def calcSizeScreenRect(point,str_unit_pnt,width_obj,height_obj):
    x_start=toScreen(point.x,str_unit_pnt)
    y_start=toScreen(point.y,str_unit_pnt)
    width=toScreen(width_obj['value'],width_obj['unit'])
    height=toScreen(height_obj['value'],height_obj['unit'])
    return Rect(x_start,y_start,x_start+width,y_start+height)
def findLayerByName(map:Map,name):
    count=map.layers.count
    for i in range(count):
        layer=map.layers.at(i)
        if layer.title==name:
            return layer
    return None








