import os.path
import pathlib
from pathlib import Path

from PySide2.QtWidgets import QMessageBox
from axipy import provider_manager, data_manager
from loguru import logger

from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.modParsers.parsersLib import initLoadLibParser
from LoadMiWor.ui.processTool.parserWor.parse import parse


def get_full_path(base_folder,path_tab):
    p_tab=Path(path_tab)
    if p_tab.exists():
        return path_tab
    parent=str(p_tab.parent)
    if parent=='.':
        return os.path.join(base_folder,path_tab)
    name_file=str(p_tab.name)

    curent_path_item=pathlib.PurePath(parent).parts
    out_full_path=base_folder
    for item in curent_path_item:
        out_full_path=os.path.join(out_full_path,item)
    out_full_path=os.path.join(out_full_path,name_file)
    return out_full_path
class MiTable:
    __dictionary_pattern=initLoadLibParser()
    __token_open=__dictionary_pattern['Open Table']
    def __init__(self,folder_path_wor,isOpenImmediately=True):
        self.__open_start=isOpenImmediately
        self.__folder_path_wor=folder_path_wor
        self.__open_tables=[]
    def add(self,item,source,new_path=None,alias_tab=None):

        words=item['words']
        cnt=len(words)
        isInteractive=False
        if words[cnt-1].lower()=='interactive':
            ''' Если Interactive то данное слово пропускаем'''
            isInteractive=True
            cnt=cnt-1
        '''    
        string_open_tab=''
        for i in range(cnt):
            string_open_tab=string_open_tab+words[i]+' '
        string_open_tab=string_open_tab.rstrip()
        '''
        string_open_tab=source[item['index']]
        if isInteractive:
            str_lst = list(string_open_tab.split())
            str_lst.pop()
            string_open_tab=' '.join(str_lst)
        result_token=self.__token_open.parserToken(string_open_tab)
        if result_token is None:
            print("Erorr parser string :"+string_open_tab)
            return False,None
        if new_path is not None:
            file_name=new_path
        else:
            file_name=result_token.named['filename']
        if file_name[0]=='"' and file_name[len(file_name)-1]=='"':
            file_name=file_name[1:-1]
        name_alias=result_token.named['name']
        ''' ПРОВЕРЯЕМ alias таблицы содержит пробелы'''
        temp_words=name_alias.lstrip().split(' ')
        if len(temp_words)>1:
            name_alias=temp_words[0]
        name_alias=name_alias.rstrip()
        ext_file=Path(file_name).suffix
        if ext_file=='':
            file_name=file_name+".tab"
        else:
            if not (ext_file.lower()=='.tab'):
                file_name=file_name+".tab"
        full_path_tab=get_full_path(self.__folder_path_wor,file_name)
        '''
        parent_folder=Path(file_name).parent
        if (str(parent_folder)=='.'):
            full_path_tab=os.path.join(self.__folder_path_wor,file_name)
            full_path_tab= pathlib.PurePath(self.__folder_path_wor).joinpath(file_name)
        else:
            full_path_tab=file_name
        '''
        if not Path(full_path_tab).is_file():
            ''' пробуем еще с расширением TAB'''
            temp_path=full_path_tab.replace(".tab",".TAB")
            if not Path(temp_path).is_file():
                #print("not find table:"+full_path_tab)
                if name_alias is None:
                    name_alias=str(Path(full_path_tab).stem)
                #self.__open_tables.append({'name': name_alias, 'table': None,"path":full_path_tab})
                return False,full_path_tab,name_alias
            full_path_tab=temp_path
            #return True,None

        definition = { 'src':full_path_tab,
                       'dataobject': name_alias}
        #print(definition)
        logger.debug(definition)
        table=provider_manager.open(definition)
        if name_alias is not None:
            table.name=name_alias
        self.__open_tables.append({'name':name_alias,'table':table})
        return True,None,None
    def addSelect(self,item,source):
        str_select_table=source[item['index']]
        token_parser = parse('Select {select} into {name_query} noselect', str_select_table.strip())
        if token_parser is None:
            token_parser = parse('Select {select} into {name_query} ', str_select_table.lstrip())
        try:
            query_table=data_manager.query("select "+token_parser['select'])
        except:
            QMessageBox.critical(None, "Ошибка выполнения Sql запроса", "select "+token_parser['select'])
            return False,None
        query_table.name=token_parser['name_query']
        self.__open_tables.append({'name': query_table.name, 'table':query_table})
        return True, None
    def getTable(self,index):
        return self.__open_tables[index]['table']
    def getByName(self,name_table):
        tab_axi=list(filter(lambda table: table['name'] == name_table, self.__open_tables))
        if tab_axi is not None and len(tab_axi)>0:
            return tab_axi[0]['table']
        return None