#from PySide2.QtGui import QPageLayout
import axipy
from PySide2.QtCore import QRect
from PySide2.QtGui import QPageLayout, QPagedPaintDevice
from PySide2.QtPrintSupport import QPrinter
from axipy import CoordSystem, GeometryReportItem, Report, Unit, view_manager, MapReportItem, TableReportItem, Style
from loguru import logger

from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsCoordSystem import parserCoordSystem
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsFrame import parserFrame, parserFrameAlter
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsGeometry import factoryGeometryReport, AxiPrepareText
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsParserMiCreate import ParserMiCreate
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsRect import parserRect
from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.clsText import parserText, parserTextAlter
from LoadMiWor.ui.processTool.parserWor.clsMiMap import prepareLineWidthMap, MiMap
from LoadMiWor.ui.processTool.parserWor.clsTableView import BrowseTable
from LoadMiWor.ui.processTool.parserWor.parse import parse
from LoadMiWor.ui.processTool.utils import tokenPointToPnt, UnitsFromString, calcSizeScreenRect

mi_page_size_dict={8:QPagedPaintDevice.A3,9:QPagedPaintDevice.A4,24:QPagedPaintDevice.AnsiC,25:QPagedPaintDevice.ArchD,26:QPagedPaintDevice.ArchE}
from LoadMiWor.ui.processTool.parserWor.parse import search
def findLinerUnitByName(name_unit):
    for liner_unit_name in axipy.LinearUnits.keys():
        liner_unit=axipy.LinearUnits.get(liner_unit_name)
        if liner_unit.name==name_unit:
            return liner_unit
    return None
def parserCoordSystemLayout(str_coordsys):
    mi_str=str_coordsys.strip()+" "
    token_find_object = search('Units "{unit}"', mi_str + " ")
    if token_find_object is None:
        return None,None
    name_unit = token_find_object.named['unit']
    cs_unit = findLinerUnitByName(name_unit)
    if cs_unit is None:
        return None,None
    return CoordSystem.from_units(cs_unit),cs_unit
def getPrinterPageSizeFromMi(mi_page_size):
    return mi_page_size_dict.get(mi_page_size, QPagedPaintDevice.A4)
def getItemFormDict(dict_item,name):
    try:
        return dict_item[name]
    except:
        print("No find :"+name)
        return None
def linesMiForItem(item,source):
    children=getItemFormDict(item,"children")
    list_mi_lines=[]
    list_mi_lines.append(source[item['index']])
    if children is None:
        return list_mi_lines
    for item_children in children:
        list_mi_lines.append(source[item_children['index']])
    return list_mi_lines
class miWorLayout:
    __list_command=None
    def __init__(self,tree,source_lines):
        self.__cs=None
        self.__unit = None
        self.__list_item_layout=[]
        self.build(tree,source_lines)
    def build(self,tree,source_lines):
        children=tree['children']
        self.__source=source_lines
        self.__prebuild_command(children,source_lines)
        self.__findCsLayout()
        self.__listParsers=ParserMiCreate()
    def __findCsLayout(self):
        for item in self.__list_command:
            if len(item['tree_item']['words'])>2:
                if item['tree_item']['words'][0].lower()=="set" and item['tree_item']['words'][1].lower()=='coordsys':
                    ''' Устанавливаем cs отчета'''
                    self.__cs,self.__unit=parserCoordSystemLayout(self.source[item['tree_item']['index']])
    def __prebuild_command(self,tree,source_line):
        self.__list_command=[]
        for item_tree in tree:
            childern_item=getItemFormDict(item_tree,'children')
            if childern_item is None:
                item_command={}
                item_command['tree_item']=item_tree
                item_command['source']=source_line[item_tree['index']]
                self.__list_command.append(item_command)
            else:
                new_source=source_line[item_tree['index']].lstrip()
                for item in item_tree['children']:
                    new_source=new_source+' '+source_line[item['index']].lstrip()
                item_command={}
                item_command['tree_item']=item_tree
                item_command['source']=new_source
                self.__list_command.append(item_command)

    @property
    def Unit(self):
        return self.__unit
    @property
    def listParsers(self):
        return self.__listParsers
    def setMapWinProperty(self,item):
        ''' Установка свойств '''
        ''' Для отчета принтер'''
        if item['words'][3].lower()=='printer':
            ''' Установка принтера '''

            self.__item_printer=item
    def add(self,obj_layout):
        self.__list_item_layout.append(obj_layout)
    @property
    def itemsLayout(self):
        return self.__list_item_layout
    @property
    def listCommands(self):
        return self.__list_command
    @property
    def source(self):
        return self.__source
    def getPrinter(self):
        try:
            mi_cmd_printer=self.__source[self.__item_printer['index']+1].lstrip()
        except Exception:
            print("Error parser Printer page")
            return None
        token_printer=parse('Name "{name_printer}" Orientation {orientation} Copies {count_copy}',mi_cmd_printer)
        if token_printer is None:
            print("Error parser Printer")
            return None
        ''' Size Page'''
        mi_cmd_printer=self.__source[self.__item_printer['index']+2].lstrip()
        token_printer_page=parse('Papersize {page_size}',mi_cmd_printer)
        if token_printer_page is None:
            print("Error parser Printer page")
            return None
        mi_page_size=int(token_printer_page.named['page_size'])
        printer_page_size=getPrinterPageSizeFromMi(mi_page_size)
        printer = QPrinter()
        printer.setPaperSize(printer_page_size)
        mi_page_orientation=token_printer.named['orientation']
        page_orientation= QPrinter.Portrait
        if mi_page_orientation=='Landscape':
            page_orientation= QPrinter.Landscape
        printer.setOrientation(page_orientation)
        printer.setPrinterName(token_printer.named['name_printer'])
        return printer
    def __createViewReport(self):
        pass
    def fillLayout(self,outViewReport=None):
        report_view=None
        if outViewReport is None:
            printer=self.getPrinter()
            #report = Report(printer)
            report_view = view_manager.create_reportview()
            report=report_view.report
        else:
            report=outViewReport.report
        units=report.unit
        #report.unit= Unit.inch
        units=report.unit
        name_unit=units.name
        mi_prj='CoordSys NonEarth Units "'+name_unit+'"'
        cs_report=CoordSystem.from_prj(mi_prj)
        cs_curent=None
        for item_object in self.__list_command:

            ''' пока тестовый вариант'''
            tree_item=item_object['tree_item']
            if tree_item['key']=='Set':
                if tree_item['words'][1]=='CoordSys':
                    ''' Устанавливаем координатную систему'''
                    miwor_line=self.__source[tree_item['index']]
                    cs_curent=parserCoordSystem(miwor_line,self.__listParsers.dictionary)
                    if cs_curent is not None:
                        report.unit=cs_curent.unit
                        mi_prj='CoordSys NonEarth Units "'+cs_curent.unit.name+'"'
                        cs_report=CoordSystem.from_prj(mi_prj)
            if tree_item['key']=='Create':
                list_mi_lines=linesMiForItem(tree_item,self.__source)
                if tree_item['words'][1]=="Rect":
                    #list_mi_lines=linesMiForItem(tree_item,self.__source)
                    geo,axi_style=parserRect(self.__listParsers.dictionary,list_mi_lines,cs_curent,cs_report)
                    if axi_style is None:
                        line_pen=self.source[tree_item['index']+1]
                        line_brush=self.source[tree_item['index']+2]
                        str_style=line_pen+" "+line_brush
                        axi_style=Style.from_mapinfo(str_style)
                    geomItem = GeometryReportItem()
                    geomItem.geometry = geo

                    geomItem.style =axi_style
                    report.items.add(geomItem)
                if tree_item['words'][1]=="Text":
                    #list_mi_lines=linesMiForItem(tree_item,self.__source)
                    geo= axi_style=None
                    try:
                        geo,axi_style=parserText(self.__listParsers.dictionary,list_mi_lines,report_view,cs_curent,cs_report)
                    except:
                        geo, axi_style = parserTextAlter(self.source, tree_item['index'], report_view, cs_curent,
                                                         cs_report)

                    geomItem = GeometryReportItem()
                    geomItem.geometry = geo

                    geomItem.style =axi_style
                    report.items.add(geomItem)
                if tree_item['words'][1]=="Frame":
                    pass
                    ''' Вставка карты'''
                    map_item=None

                    map_item=parserFrame(list_mi_lines)
                    if map_item is None:
                        map_item=parserFrameAlter(self.source,tree_item['index'])
                    if map_item is not None:
                        report.items.add(map_item)
        ''' Report View'''
        if report_view is not None:
            reportview=report_view
        else:
            reportview = view_manager.create_reportview(report)

class miWorLayoutDesigner(miWorLayout):
    __list_command=None

    def __init__(self,tree,source_lines):
        self.__spatial_object = []
        super(miWorLayoutDesigner,self).__init__(tree,source_lines)

    def addGeometry(self,item_tree):
        geometr_obj,style,priorety=factoryGeometryReport(item_tree,self.source)
        if geometr_obj is not None:
            self.__spatial_object.append({'geometry':geometr_obj,'style':style,'priorety':priorety})
        else:
            logger("Not find parser geometry report:"+ item_tree['words'][1])
    def fillLayout(self,outViewReport=None):
        report_view=None
        if outViewReport is None:
            printer=self.getPrinter()
            #report = Report(printer)
            report_view = view_manager.create_reportview()
            report=report_view.report
        else:
            report=outViewReport.report
        units=report.unit
        #report.unit= Unit.inch
        units=report.unit
        name_unit=units.name
        mi_prj='CoordSys NonEarth Units "'+name_unit+'"'
        cs_report=CoordSystem.from_prj(mi_prj)
        cs_curent=None
        list_command=self.listCommands
        width_report_obj = None
        height_report_obj = None
        for item_object in list_command:

            ''' пока тестовый вариант'''
            tree_item=item_object['tree_item']
            if tree_item['key'].lower() == 'position':
                mi_str=self.source[tree_item['index']].lower().strip()
                token_position = parse('position ({point}) units "{unit}"', mi_str)
                if token_position is not None:
                    position_win_map = tokenPointToPnt(token_position.named['point'])
                    unit_pos = UnitsFromString(token_position.named['unit'])
                    continue
            if tree_item['key'].lower() == 'width':
                mi_str = self.source[tree_item['index']].lower().strip()
                self.__width = prepareLineWidthMap(mi_str).strip()
                token_position = parse('Width {width} Units "{w_unit}" Height {height} Units "{h_unit}"', self.__width)
                if token_position is None:
                    token_position = parse('Width {width} Units "{w_unit}" Height {height} Units "{h_unit}" {type_view}',
                                           self.__width+"")
                width_report_obj = {"value": float(token_position.named['width']), "unit": token_position.named['w_unit']}
                height_report_obj = {"value": float(token_position.named['height']), "unit": token_position.named['h_unit']}
                continue
            if tree_item['key']=='Set':
                if tree_item['words'][1]=='CoordSys':
                    ''' Устанавливаем координатную систему'''
                    miwor_line=self.source[tree_item['index']]
                    cs_curent=parserCoordSystem(miwor_line,self.listParsers.dictionary)
                    report.unit=cs_curent.unit
                    mi_prj='CoordSys NonEarth Units "'+cs_curent.unit.name+'"'
                    cs_report=CoordSystem.from_prj(mi_prj)
            if tree_item['key']=='Create':
                list_mi_lines=linesMiForItem(tree_item,self.source)
                if tree_item['words'][1]=="Rect":
                    #list_mi_lines=linesMiForItem(tree_item,self.__source)
                    geo,axi_style=parserRect(self.listParsers.dictionary,list_mi_lines,cs_curent,cs_report)
                    geomItem = GeometryReportItem()
                    geomItem.geometry = geo

                    geomItem.style =axi_style
                    report.items.add(geomItem)
                if tree_item['words'][1]=="Text":
                    #list_mi_lines=linesMiForItem(tree_item,self.__source)
                    geo=None
                    axi_style=None
                    try:
                        geo,axi_style=parserText(self.listParsers.dictionary,list_mi_lines,report_view,cs_curent,cs_report)
                    except:
                        geo,axi_style=parserTextAlter(self.source,tree_item['index'],report_view,cs_curent,cs_report)
                    geomItem = GeometryReportItem()
                    geomItem.geometry = geo

                    geomItem.style =axi_style
                    report.items.add(geomItem)
                if tree_item['words'][1]=="Frame":
                    pass
                    ''' Вставка карты'''
                    map_item=parserFrame(list_mi_lines)
                    if map_item is not None:
                        report.items.add(map_item)

        rect_map_view = calcSizeScreenRect(position_win_map, unit_pos, width_report_obj, height_report_obj)
        ''' Report View'''
        if report_view is not None:
            reportview=report_view
        else:
            reportview = view_manager.create_reportview(report)
        q_rect=QRect(rect_map_view.xmin,rect_map_view.ymin,rect_map_view.width,rect_map_view.height)
        reportview.position=q_rect
        for item_report in self.itemsLayout:
            position_obj=item_report.position_object
            if isinstance(item_report,MiMap):
                mapview=item_report.AxiMapView
                map_item=MapReportItem(position_obj,item_report.map,coordsystem=mapview.coordsystem)
                scale=mapview.scale
                center=mapview.center
                map_item.center=(center.x,center.y)
                map_item.scale=scale
                style=item_report.style
                if style is not None:
                    style_border=style['pen']
                    style_fill=style['brush']
                    if style_border is not None:
                        map_item.border_style=Style.from_mapinfo(style_border)
                    if style_fill is not None:
                        map_item.fill_style=Style.from_mapinfo(style_fill)
                report.items.add(map_item)
            if isinstance(item_report,BrowseTable):
                tableReportItem = TableReportItem(position_obj, item_report.table_view.data_object)
                style=item_report.style
                if style is not None:
                    style_border = style['pen']
                    if style_border is not None:
                        tableReportItem.border_style = Style.from_mapinfo(style_border)
                report.items.add(tableReportItem)
        if len(self.__spatial_object)>0:
            ''' Добавляем геометрию на отчет'''
            for obj_geometry in self.__spatial_object:
                if obj_geometry['geometry'] is None:
                    continue

                geomItem = GeometryReportItem()
                style_report_geometry= obj_geometry['style']
                if style_report_geometry is None:
                    style_report_geometry=Style.from_mapinfo("Pen (1, 2, 0)")
                geomItem.style = style_report_geometry
                if isinstance(obj_geometry['geometry'],AxiPrepareText):
                    geomItem.geometry=obj_geometry['geometry'].createAxiTextGeoObject(reportview)
                else:
                    geomItem.geometry=obj_geometry['geometry']
                report.items.add(geomItem)








