from axipy import CoordSystem, Rectangle, Rect, Point
from axipy.da import Style


class MiCreateRect:
    def __init__(self,dict_parsers):
        '''
        self.__obj_comp_one=dict_parsers["Create Rect'] ({ld}) ({ru}) Pen ({pen}) Brush ({brush})")
        self.__obj_comp=baseParser("Create Rect ({ld}) ({ru})")
        self.__obj_pen=baseParser("Pen ({pen})")
        self.__obj_brush=baseParser("Brush ({brush})")
        '''
        self.__obj_comp=dict_parsers['Create Rect']
        self.__obj_pen=dict_parsers['Pen']
        self.__obj_brush=dict_parsers["Brush"]
    def parser(self,micomand:str,cs:CoordSystem,out_cs=None):
        '''

        :param micomand command MapBasic:
        :param cs source CoordSystem:
        :param out_cs Out CoordSystem:
        :return:
        '''
        parser_result=self.__obj_comp.parserToken(micomand)
        if parser_result is None:
            return None
        points_str=parser_result.named['ld']+','+parser_result.named['ru']
        lst_str_points=points_str.split(',')
        x0=float(lst_str_points[0])
        y0=float(lst_str_points[1])
        x1=float(lst_str_points[2])
        y1=float(lst_str_points[3])
        pt1=Point(x0,y0,cs=cs)
        pt2=Point(x1,y1,cs=cs)
        if out_cs is not None:
            pt1=pt1.reproject(out_cs)
            pt2=pt2.reproject(out_cs)
        geo=Rectangle(pt1.x,pt1.y,pt2.x,pt2.y,cs=cs)
        mi_style=None
        mi_cmd_pen=parser_result.named['pen']
        if mi_cmd_pen is not None:
            mi_cmd_pen='Pen ('+mi_cmd_pen+")"
            mi_style=mi_cmd_pen
        mi_cmd_brush=   parser_result.named['brush']
        if mi_cmd_brush is not None:
            mi_cmd_brush="Brush ("+mi_cmd_brush+")"
            if mi_style is not None:
                mi_style=mi_style+' '+mi_cmd_brush
        axi_style=Style.from_mapinfo(mi_style)


        return geo,axi_style
    def parserGeo(self,micomand:str,cs:CoordSystem,out_cs=None):
        parser_result=self.__obj_comp.parserToken(micomand)
        if parser_result is None:
            return None
        points_str=parser_result.named['ld']+','+parser_result.named['ru']
        lst_str_points=points_str.split(',')
        x0=float(lst_str_points[0])
        y0=float(lst_str_points[1])
        x1=float(lst_str_points[2])
        y1=float(lst_str_points[3])
        if out_cs is not None:
            x0=cs.unit.to_unit(out_cs.unit,x0)
            y0=cs.unit.to_unit(out_cs.unit,y0)
            x1=cs.unit.to_unit(out_cs.unit,x1)
            y1=cs.unit.to_unit(out_cs.unit,y1)
        pt1=Point(x0,y0,cs=out_cs)
        pt2=Point(x1,y1,cs=out_cs)
        '''
        if out_cs is not None:
            pt1=pt1.reproject(out_cs)
            pt2=pt2.reproject(out_cs)
        '''
        geo=Rectangle(pt1.x,pt1.y,pt2.x,pt2.y,cs=out_cs)
        return geo
    def parserItems(self,items:list,cs:CoordSystem,out_cs=None):
        '''
        Парсер items wor
        :param items:
        :param cs:
        :param out_cs:
        :return:
        '''
        mi_commad_geo=items[0].lstrip().rstrip()
        geo_rect=self.parserGeo(mi_commad_geo,cs,out_cs)
        mi_pen=None
        mi_brush=None
        mi_style=None
        axi_style=None
        for i in range(1,len(items)):
            cur_line=items[i].lstrip().rstrip()
            if cur_line.find("Pen")==0:
                parser_pen=self.__obj_pen.parserToken(cur_line)
                if parser_pen is not None:
                    mi_pen="Pen ("+parser_pen.named['pen']+")"
                    if mi_style is None:
                        mi_style=mi_pen
                    else:
                        mi_style=mi_style+" "+mi_pen

            if cur_line.find("Brush")==0:
                parser_brush=self.__obj_brush.parserToken(cur_line)
                if parser_brush is not None:
                    mi_brush="Brush ("+parser_brush.named['brush']+")"

                    if mi_style is None:
                        mi_style=mi_brush
                    else:
                        mi_style=mi_style+" "+mi_brush

        if mi_style is not None:
            axi_style=Style.from_mapinfo(mi_style)
        return geo_rect,axi_style
def parserRect(dictanary,items,cs_source,cs_out):
    cls_rect=MiCreateRect(dictanary)
    return cls_rect.parserItems(items,cs_source,cs_out)





