import axipy
from axipy import CustomLabelProperties, Point, CustomLabelEndType, Style
from LoadMiWor.ui.processTool.parserWor.parse import search


def strXYToPoint(str_xy):
    try:
        sxy = str_xy.split(",")
        x = float(sxy[0])
        y = float(sxy[1])
        return Point(x,y)
    except:
        return None
class miCustomLabel:
    def __init__(self,id,clsCustomLabelProperties):
        self.id=id
        self.customLabelProperties=clsCustomLabelProperties
def factoryCustomLabel(mi_str):
    token_find_object = search("Object {id} ", mi_str)
    token_find_point = search("Anchor ({point}) ", mi_str)
    token_find_angle = search("Angle {angl} ", mi_str)
    token_find_line = search("Line {type_line} ", mi_str)
    token_find_text = search("Text {text} ", mi_str)
    token_find_pen=search("Pen {type_style} ", mi_str)
    #id_obj=int(token_find_object['id'])-1
    id_obj = int(token_find_object['id'])-1
    axi_custom_label=CustomLabelProperties()
    if token_find_point is not None:
        pnt=strXYToPoint(token_find_point.named['point'])
        if pnt is not None:
            axi_custom_label.position=pnt
    if token_find_angle is not None:
        angle=float(token_find_angle.named['angl'])
        axi_custom_label.angle=angle
    if token_find_line is not None:
        type_line=token_find_line.named['type_line'].lower()
        if type_line=='none':
            axi_custom_label.endType=CustomLabelEndType.EndNone
        if type_line == 'simple':
            axi_custom_label.endType = CustomLabelEndType.Line
        if type_line == 'arrow':
            axi_custom_label.endType = CustomLabelEndType.Arrow
    if token_find_pen is not None:
        str_pen="Pen "+token_find_pen.named['type_style']
        axi_custom_label.arrow_style=Style.from_mapinfo(str_pen)
    if token_find_text is not None:
        text_expression=token_find_text.named['text']
        axi_custom_label.expression=text_expression
    return miCustomLabel(id_obj,axi_custom_label)
def cloneCustomLabelPropertySetCs(custum_curent,cs):
    new_custum_property=axipy.CustomLabelProperties()
    new_custum_property.angle=custum_curent.angle
    new_custum_property.endType = custum_curent.endType
    new_custum_property.expression = custum_curent.expression
    if custum_curent.arrow_style is not None:
        new_custum_property.arrow_style=custum_curent.arrow_style
    #if custum_curent.text_style is not None:
    #    new_custum_property.text_style=custum_curent.text_style
    #new_custum_property.
    try:
        if custum_curent.position is not None:
            point_cs_map = Point(custum_curent.position.x, custum_curent.position.y, cs)
            new_custum_property.position=point_cs_map
    except:
        pass
    return new_custum_property




