import os

import axipy
from PySide2 import QtCore
from PySide2.QtCore import QFile
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog


class DlgSelectView(QDialog):
    def __init__(self,parent=None):
        super(DlgSelectView, self).__init__(parent)
        self.__parentWin=parent
        self.load_ui('DlgSelectView1.ui')
        self.window.setWindowFlags(self.window.windowFlags() & ~QtCore.Qt.WindowCloseButtonHint& ~QtCore.Qt.WindowContextHelpButtonHint)
        self.window.pb_cancel.clicked.connect(self.__cancel)

        self.window.pb_run.clicked.connect(self.__run)
        self.__select_view=None
    def load_ui(self,name_resource):
        loader = QUiLoader()
        path = os.path.join(os.path.dirname(__file__),name_resource)
        ui_file = QFile(path)
        ui_file.open(QFile.ReadOnly)
        self.window  = loader.load(ui_file,self.__parentWin)
        ui_file.close()
    def __initViews(self):
        for view in axipy.gui.view_manager.views:
            self.window.cmb_name_view.addItem(view.title)
        self.window.cmb_name_view.setCurrentIndex(0)
    def __run(self):
        select_name_view=self.window.cmb_name_view.currentText()
        self.__select_view=None
        for view in axipy.gui.view_manager.views:
            if view.title==select_name_view:
                self.__select_view= view
                break

        self.window.close()
    def __cancel(self):
        self.__select_view=None
        self.window.close()
    @property
    def selectView(self):
        return self.__select_view
    def exec_(self,name_view):
        self.window.cmb_name_view.clear()
        self.__initViews()
        self.window.lb_head_message.setText(name_view)
        self.window.show()
        self.window.exec_()
    def show(self,name_view):
        self.window.cmb_name_view.clear()
        self.__initViews()
        self.window.lb_head_message.setText(name_view)
        self.window.show()


