import os

import axipy
from PySide2.QtGui import QIcon

from CopyMws.ui.FormCopyMws import dlgFormCopyMws
from CopyMws.ui.processtool.addTools.docWidget import AxiDocWidget, addDoc


class CopyMws:
    __name='Копирование mws'
    __name_observer=None
    __type_observer="catalog"
    __form_tool=None
    __docWidget=None

    def __init__(self,parentPlugin):
        #self._initTool(parentPlugin)
        self.__docWidget=None

    def initTool(self, parentPlugin):

        local_file_icon = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'icons', 'copyMws.png')
        try:
            self.__action = parentPlugin.create_action(self.__name, icon=local_file_icon, on_click=self.open_form)
            #self.__action.action.setToolTip('Копирование рабочего набора (Mws)')
        except Exception as ex:
            jkl = 0
        return
    def getPathIcon(self):
        local_file_icon = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'icons', 'copyMws.png')
        return local_file_icon
    def open_form(self):
        if self.__form_tool is None:
            self.__form_tool =dlgFormCopyMws(axipy.app.mainwindow.qt_object())

        if self.__docWidget is None:
            mainwindowAxi = axipy.app.mainwindow.qt_object()
            self.__docWidget = AxiDocWidget(self.__form_tool.widget, "CreateGrid", self.__name, QIcon(), mainwindowAxi)
            addDoc(mainwindowAxi, self.__docWidget)
    @property
    def name(self):
        return self.__name

    @property
    def name_group(self):
        return self.__def_name_group

    @property
    def action(self):
        return self.__action

    @property
    def nameObserver(self):
        return self.__name_observer

    @property
    def docWidget(self):
        return self.__docWidget