﻿<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />
<xsl:template match="/">

<p><b>Перечень используемых проекций:</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>ID</td>
<td>Наименование проекции</td>
<td>Метод измерения</td>
</tr>
<xsl:for-each select="tr/projections/projection">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@name"/></td>
<td><xsl:value-of select="@calc_mode"/></td>
</tr>
</xsl:for-each>
</table>

<p><b>Параметры эллипсоидов:</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>Номер</td>
<td>Наименование</td>
<td>Наименование в mitab</td>
<td>Большая полуось</td>
<td>Коэффициент сжатия</td>
</tr>
<xsl:for-each select="tr/ellipsoids/ellipsoid">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@name"/></td>
<td><xsl:value-of select="@name_mitab"/></td>
<td><xsl:value-of select="@semi_major"/></td>
<td><xsl:value-of select="@inv_flatenning"/></td>
</tr>
</xsl:for-each>
</table>

<p><b>Параметры датумов:</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>Номер</td>
<td>Наименование</td>
<td>Наименование в mitab</td>
<td>Значение EPSG из GDAL</td>
<td>Эллипсоид</td>
<td>dx</td>
<td>dy</td>
<td>dz</td>
<td>rx</td>
<td>ry</td>
<td>rz</td>
<td>sa</td>
<td>pm</td>
</tr>
<xsl:for-each select="tr/datums/datum">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@name"/></td>
<td><xsl:value-of select="@name_mitab"/></td>
<td><xsl:value-of select="@epsg_mitab"/></td>
<td><xsl:value-of select="@ellipsoid"/></td>
<td><xsl:value-of select="@dx"/></td>
<td><xsl:value-of select="@dy"/></td>
<td><xsl:value-of select="@dz"/></td>
<td><xsl:value-of select="@rx"/></td>
<td><xsl:value-of select="@ry"/></td>
<td><xsl:value-of select="@rz"/></td>
<td><xsl:value-of select="@sa"/></td>
<td><xsl:value-of select="@pm"/></td>
</tr>
</xsl:for-each>
</table>

<p><b>Единицы измерения (линейные):</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>Номер</td>
<td>Преобразование в метры</td>
<td>Наименование на англ.</td>
<td>Наименование в PROJ4</td>
<td>Описание</td>
<td>Наименование</td>
</tr>
<xsl:for-each select="tr/units/unit">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@conv"/></td>
<td><xsl:value-of select="@name_mi"/></td>
<td><xsl:value-of select="@name_proj4"/></td>
<td><xsl:value-of select="@descr"/></td>
<td><xsl:value-of select="@name_l10n"/></td>
</tr>
</xsl:for-each>
</table>

<p><b>Единицы измерения (площадные):</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>Номер</td>
<td>Преобразование в метры</td>
<td>Наименование на англ.</td>
<td>Описание</td>
<td>Наименование</td>
</tr>
<xsl:for-each select="tr/areas/area">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@conv"/></td>
<td><xsl:value-of select="@name_mi"/></td>
<td><xsl:value-of select="@descr"/></td>
<td><xsl:value-of select="@name_l10n"/></td>
</tr>
</xsl:for-each>
</table>

<p><b>Методы измерения:</b></p>
<table border="1">
<tr bgcolor="#ccffFF">
<td>Номер</td>
<td>Наименование</td>
<td>Описание</td>
</tr>
<xsl:for-each select="tr/calc_modes/mode">
<tr>
<td><xsl:value-of select="@id"/></td>
<td><xsl:value-of select="@name"/></td>
<td><xsl:value-of select="@descr"/></td>
</tr>
</xsl:for-each>
</table>

</xsl:template>
</xsl:stylesheet>
