from enum import Enum
from typing import List

__all__: List[str] = [
    "TypeSqlDialect",
]


class TypeSqlDialect(str, Enum):
    """
    Используемый диалект при выполнении SQL запросов. Есть отличия как в скорости, так и
    в функционале. выбор зависит от конкретной задачи. Значение, установленное по
    умолчанию можно получить посредством свойства :attr:`data_manager.sql_dialect`

    .. csv-table:: Значения
        :header: Значение, Наименование

        axioma, "Использовать собственную реализацию инструмента выполнения запросов"
        sqlite, "Использовать при выполнении реализацию, являющийся надстройкой над sqlite"
    """

    axioma = "axioma"
    sqlite = "sqlite"
