from typing import List, Type

from .dbms_data_provider import DatabaseDataProvider
from .source import Destination, Source

__all__: List[str] = [
    "PostgreSource",
    "PostgreDestination",
    "PostgreDataProvider",
]


class PostgreSource(Source):
    pass


class PostgreDestination(Destination):
    pass


class PostgreDataProvider(DatabaseDataProvider):
    """Провайдер для Базы Данных `PostgreSQL <https://www.postgresql.org>`_.

    Пример с указанием имени таблицы::

        definition = provider_manager.postgre.get_source('localhost', 'test', 'postgres', 'postgres', dataobject='world')
        table = provider_manager.open(definition)

    Пример с указанием текста запроса::

        definition = provider_manager.postgre.get_source('localhost', 'test', 'postgres', 'postgres', sql="select * from world where Страна like 'Р%'")
        table = provider_manager.open(definition)

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.provider_manager.postgre`.
    """

    @staticmethod
    def _identifier() -> str:
        return "PgDataProvider"

    DEFAULT_PORT = 5432
    """Порт по умолчанию."""

    @property
    def _get_source_class(self) -> Type[PostgreSource]:
        return PostgreSource

    @property
    def _get_destination_class(self) -> Type[PostgreDestination]:
        return PostgreDestination
