"""
Warning:
    .. deprecated:: 3.0.0
"""

from typing import TYPE_CHECKING, List, Optional

from axipy._internal._decorator import _deprecated_by

from .schema import Attribute, Schema

if TYPE_CHECKING:
    from axipy import CoordSystem

__all__: List[str] = []


def _apply_deprecated() -> None:
    # Using getattr to hide deprecated objects from axipy namespace on IDE inspections
    getattr(__all__, "extend")(
        (
            "AttributeFactory",
            "attr",
        )
    )

    class AttributeFactory:
        """
        Warning:
            .. deprecated:: 3.0.0
                Используйте :class:`axipy.Schema` и статические методы класса :class:`axipy.Attribute`.
        """

        DEFAULT_STRING_LENGTH = 80
        DEFAULT_DECIMAL_LENGTH = 15
        DEFAULT_DECIMAL_PRECISION = 5

        def __init__(self) -> None:
            raise NotImplementedError

        @staticmethod
        @_deprecated_by("axipy.Attribute.string")
        def string(name: str, length: int = DEFAULT_STRING_LENGTH) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, f"string:{length}")

        @staticmethod
        @_deprecated_by("axipy.Attribute.decimal")
        def decimal(
            name: str,
            length: int = DEFAULT_DECIMAL_LENGTH,
            precision: int = DEFAULT_DECIMAL_PRECISION,
        ) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, f"decimal:{length}.{precision}")

        @staticmethod
        @_deprecated_by("axipy.Attribute.integer")
        def integer(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "int")

        @staticmethod
        @_deprecated_by("axipy.Attribute.float")
        def float(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute.double(name)

        @staticmethod
        @_deprecated_by("axipy.Attribute.double")
        def double(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "double")

        @staticmethod
        @_deprecated_by("axipy.Attribute.bool")
        def bool(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "bool")

        @staticmethod
        @_deprecated_by("axipy.Attribute.date")
        def date(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "date")

        @staticmethod
        @_deprecated_by("axipy.Attribute.time")
        def time(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "time")

        @staticmethod
        @_deprecated_by("axipy.Attribute.datetime")
        def datetime(name: str) -> "Attribute":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Attribute(name, "datetime")

        @staticmethod
        @_deprecated_by("axipy.Schema")
        def schema(*attributes: Attribute, coordsystem: Optional["CoordSystem"] = None) -> "Schema":
            """
            Warning:
                .. deprecated:: 3.0.0
            """
            return Schema(*attributes, coordsystem=coordsystem)

    globals().update(
        AttributeFactory=AttributeFactory,
        attr=AttributeFactory,
    )


_apply_deprecated()
