"""
Модуль источников данных.
В данном модуле содержатся классы и методы для работы с источниками данных.
"""

from .attribute_factory import *
from .data_manager_ import *
from .data_object import *
from .feature import *
from .file_format_type import *
from .foreign_manager_ import *
from .geometry import *
from .mapinfo_mapcatalog import *
from .observer_manager import *
from .providers import *
from .raster import *
from .schema import *
from .sqldialect import *
from .state_manager_ import *
from .style import *
from .tab_file import *

attribute_schema = schema
DataManagerWrapper = data_manager_
DataObjectWrapper = data_object
FeatureWrapper = feature


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "attribute_schema": schema,
        "DataManagerWrapper": data_manager_,
        "DataObjectWrapper": data_object,
        "FeatureWrapper": feature,
        "Geometry": geometry,
        "Style": style,
        "TabFile": tab_file,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
