"""Модуль для работы с длительными пользовательскими задачами, выполняемыми в фоновом потоке."""

from .axipy_progress_handler import *
from .task import *
from .task_manager_ import *
from .task_utils import *

TaskUtils = task_utils


def __getattr__(name: str):
    """Backwards compatibility."""
    old_names = {
        "AxipyProgressHandler": axipy_progress_handler,
        "Task": task,
        "TaskManager": task_manager_,
        "TaskUtils": task_utils,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
