from typing import overload
import PySide2.QtCore
import shiboken2
import typing
T = typing.TypeVar('T')

class QGeoAddress(shiboken2.Object):
    @overload
    def __init__(self, other: QGeoAddress) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def city(self) -> str: ...
    def clear(self) -> None: ...
    def country(self) -> str: ...
    def countryCode(self) -> str: ...
    def county(self) -> str: ...
    def district(self) -> str: ...
    def isEmpty(self) -> bool: ...
    def isTextGenerated(self) -> bool: ...
    def postalCode(self) -> str: ...
    def setCity(self, city: str) -> None: ...
    def setCountry(self, country: str) -> None: ...
    def setCountryCode(self, countryCode: str) -> None: ...
    def setCounty(self, county: str) -> None: ...
    def setDistrict(self, district: str) -> None: ...
    def setPostalCode(self, postalCode: str) -> None: ...
    def setState(self, state: str) -> None: ...
    def setStreet(self, street: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def state(self) -> str: ...
    def street(self) -> str: ...
    def text(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoAreaMonitorInfo(shiboken2.Object):
    @overload
    def __init__(self, name: str = ...) -> None: ...
    @overload
    def __init__(self, other: QGeoAreaMonitorInfo) -> None: ...
    def area(self) -> QGeoShape: ...
    def expiration(self) -> PySide2.QtCore.QDateTime: ...
    def identifier(self) -> str: ...
    def isPersistent(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def notificationParameters(self) -> typing.Dict[str,typing.Any]: ...
    def setArea(self, newShape: QGeoShape) -> None: ...
    def setExpiration(self, expiry: PySide2.QtCore.QDateTime) -> None: ...
    def setName(self, name: str) -> None: ...
    def setNotificationParameters(self, parameters: typing.Dict[str,typing.Any]) -> None: ...
    def setPersistent(self, isPersistent: bool) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QGeoAreaMonitorSource(PySide2.QtCore.QObject):
    class AreaMonitorFeature:
        AnyAreaMonitorFeature: typing.ClassVar[QGeoAreaMonitorSource.AreaMonitorFeature] = ...
        PersistentAreaMonitorFeature: typing.ClassVar[QGeoAreaMonitorSource.AreaMonitorFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...

    class AreaMonitorFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.AreaMonitorFeatures: ...

    class Error:
        AccessError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
        InsufficientPositionInfo: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
        NoError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
        UnknownSourceError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoAreaMonitorSource.Error: ...
    AccessError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
    AnyAreaMonitorFeature: typing.ClassVar[QGeoAreaMonitorSource.AreaMonitorFeature] = ...
    InsufficientPositionInfo: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
    NoError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
    PersistentAreaMonitorFeature: typing.ClassVar[QGeoAreaMonitorSource.AreaMonitorFeature] = ...
    UnknownSourceError: typing.ClassVar[QGeoAreaMonitorSource.Error] = ...
    areaEntered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    areaExited: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    monitorExpired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def activeMonitors(self, lookupArea: QGeoShape) -> typing.List[QGeoAreaMonitorInfo]: ...
    @overload
    def activeMonitors(self) -> typing.List[QGeoAreaMonitorInfo]: ...
    @classmethod
    def availableSources(cls) -> typing.List[str]: ...
    @classmethod
    def createDefaultSource(cls, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoAreaMonitorSource: ...
    @classmethod
    def createSource(cls, sourceName: str, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoAreaMonitorSource: ...
    def positionInfoSource(self) -> QGeoPositionInfoSource: ...
    def requestUpdate(self, monitor: QGeoAreaMonitorInfo, signal: bytes) -> bool: ...
    def setPositionInfoSource(self, source: QGeoPositionInfoSource) -> None: ...
    def sourceName(self) -> str: ...
    def startMonitoring(self, monitor: QGeoAreaMonitorInfo) -> bool: ...
    def stopMonitoring(self, monitor: QGeoAreaMonitorInfo) -> bool: ...
    def supportedAreaMonitorFeatures(self) -> typing.Union[QGeoAreaMonitorSource.AreaMonitorFeatures,QGeoAreaMonitorSource.AreaMonitorFeature]: ...

class QGeoCircle(QGeoShape):
    @overload
    def __init__(self, center: QGeoCoordinate, radius: float = ...) -> None: ...
    @overload
    def __init__(self, other: QGeoCircle) -> None: ...
    @overload
    def __init__(self, other: QGeoShape) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def center(self) -> QGeoCoordinate: ...
    def extendCircle(self, coordinate: QGeoCoordinate) -> None: ...
    def radius(self) -> float: ...
    def setCenter(self, center: QGeoCoordinate) -> None: ...
    def setRadius(self, radius: float) -> None: ...
    def toString(self) -> str: ...
    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None: ...
    def translated(self, degreesLatitude: float, degreesLongitude: float) -> QGeoCircle: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoCoordinate(shiboken2.Object):
    class CoordinateFormat:
        Degrees: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        DegreesMinutes: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        DegreesMinutesSeconds: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        DegreesMinutesSecondsWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        DegreesMinutesWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        DegreesWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateFormat: ...

    class CoordinateType:
        Coordinate2D: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
        Coordinate3D: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
        InvalidCoordinate: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoCoordinate.CoordinateType: ...
    Coordinate2D: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
    Coordinate3D: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
    Degrees: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    DegreesMinutes: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    DegreesMinutesSeconds: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    DegreesMinutesSecondsWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    DegreesMinutesWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    DegreesWithHemisphere: typing.ClassVar[QGeoCoordinate.CoordinateFormat] = ...
    InvalidCoordinate: typing.ClassVar[QGeoCoordinate.CoordinateType] = ...
    @overload
    def __init__(self, latitude: float, longitude: float, altitude: float) -> None: ...
    @overload
    def __init__(self, latitude: float, longitude: float) -> None: ...
    @overload
    def __init__(self, other: QGeoCoordinate) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def altitude(self) -> float: ...
    def atDistanceAndAzimuth(self, distance: float, azimuth: float, distanceUp: float = ...) -> QGeoCoordinate: ...
    def azimuthTo(self, other: QGeoCoordinate) -> float: ...
    def distanceTo(self, other: QGeoCoordinate) -> float: ...
    def isValid(self) -> bool: ...
    def latitude(self) -> float: ...
    def longitude(self) -> float: ...
    def setAltitude(self, altitude: float) -> None: ...
    def setLatitude(self, latitude: float) -> None: ...
    def setLongitude(self, longitude: float) -> None: ...
    def toString(self, format: QGeoCoordinate.CoordinateFormat = ...) -> str: ...
    def type(self) -> QGeoCoordinate.CoordinateType: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QGeoLocation(shiboken2.Object):
    @overload
    def __init__(self, other: QGeoLocation) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def address(self) -> QGeoAddress: ...
    def boundingBox(self) -> QGeoRectangle: ...
    def coordinate(self) -> QGeoCoordinate: ...
    def extendedAttributes(self) -> typing.Dict[str,typing.Any]: ...
    def isEmpty(self) -> bool: ...
    def setAddress(self, address: QGeoAddress) -> None: ...
    def setBoundingBox(self, box: QGeoRectangle) -> None: ...
    def setCoordinate(self, position: QGeoCoordinate) -> None: ...
    def setExtendedAttributes(self, data: typing.Dict[str,typing.Any]) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoPath(QGeoShape):
    @overload
    def __init__(self, path: typing.Iterable[QGeoCoordinate], width: float = ...) -> None: ...
    @overload
    def __init__(self, other: QGeoPath) -> None: ...
    @overload
    def __init__(self, other: QGeoShape) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def addCoordinate(self, coordinate: QGeoCoordinate) -> None: ...
    def clearPath(self) -> None: ...
    def containsCoordinate(self, coordinate: QGeoCoordinate) -> bool: ...
    def coordinateAt(self, index: int) -> QGeoCoordinate: ...
    def insertCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None: ...
    def length(self, indexFrom: int = ..., indexTo: int = ...) -> float: ...
    def path(self) -> typing.List[QGeoCoordinate]: ...
    @overload
    def removeCoordinate(self, coordinate: QGeoCoordinate) -> None: ...
    @overload
    def removeCoordinate(self, index: int) -> None: ...
    def replaceCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None: ...
    def setPath(self, path: typing.Iterable[QGeoCoordinate]) -> None: ...
    def setVariantPath(self, path: typing.Iterable[typing.Any]) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None: ...
    def translated(self, degreesLatitude: float, degreesLongitude: float) -> QGeoPath: ...
    def variantPath(self) -> typing.List[typing.Any]: ...
    def width(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoPolygon(QGeoShape):
    @overload
    def __init__(self, other: QGeoPolygon) -> None: ...
    @overload
    def __init__(self, other: QGeoShape) -> None: ...
    @overload
    def __init__(self, path: typing.Iterable[QGeoCoordinate]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def addCoordinate(self, coordinate: QGeoCoordinate) -> None: ...
    @overload
    def addHole(self, holePath: typing.Iterable[QGeoCoordinate]) -> None: ...
    @overload
    def addHole(self, holePath: typing.Any) -> None: ...
    def containsCoordinate(self, coordinate: QGeoCoordinate) -> bool: ...
    def coordinateAt(self, index: int) -> QGeoCoordinate: ...
    def hole(self, index: int) -> typing.List[typing.Any]: ...
    def holePath(self, index: int) -> typing.List[QGeoCoordinate]: ...
    def holesCount(self) -> int: ...
    def insertCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None: ...
    def length(self, indexFrom: int = ..., indexTo: int = ...) -> float: ...
    def path(self) -> typing.List[QGeoCoordinate]: ...
    def perimeter(self) -> typing.List[typing.Any]: ...
    @overload
    def removeCoordinate(self, coordinate: QGeoCoordinate) -> None: ...
    @overload
    def removeCoordinate(self, index: int) -> None: ...
    def removeHole(self, index: int) -> None: ...
    def replaceCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None: ...
    def setPath(self, path: typing.Iterable[QGeoCoordinate]) -> None: ...
    def setPerimeter(self, path: typing.Iterable[typing.Any]) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None: ...
    def translated(self, degreesLatitude: float, degreesLongitude: float) -> QGeoPolygon: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoPositionInfo(shiboken2.Object):
    class Attribute:
        Direction: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        GroundSpeed: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        HorizontalAccuracy: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        MagneticVariation: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        VerticalAccuracy: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        VerticalSpeed: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoPositionInfo.Attribute: ...
    Direction: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    GroundSpeed: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    HorizontalAccuracy: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    MagneticVariation: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    VerticalAccuracy: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    VerticalSpeed: typing.ClassVar[QGeoPositionInfo.Attribute] = ...
    @overload
    def __init__(self, coordinate: QGeoCoordinate, updateTime: PySide2.QtCore.QDateTime) -> None: ...
    @overload
    def __init__(self, other: QGeoPositionInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attribute(self, attribute: QGeoPositionInfo.Attribute) -> float: ...
    def coordinate(self) -> QGeoCoordinate: ...
    def hasAttribute(self, attribute: QGeoPositionInfo.Attribute) -> bool: ...
    def isValid(self) -> bool: ...
    def removeAttribute(self, attribute: QGeoPositionInfo.Attribute) -> None: ...
    def setAttribute(self, attribute: QGeoPositionInfo.Attribute, value: float) -> None: ...
    def setCoordinate(self, coordinate: QGeoCoordinate) -> None: ...
    def setTimestamp(self, timestamp: PySide2.QtCore.QDateTime) -> None: ...
    def timestamp(self) -> PySide2.QtCore.QDateTime: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QGeoPositionInfoSource(PySide2.QtCore.QObject):
    class Error:
        AccessError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
        ClosedError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
        NoError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
        UnknownSourceError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.Error: ...

    class PositioningMethod:
        AllPositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
        NoPositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
        NonSatellitePositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
        SatellitePositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...

    class PositioningMethods:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoPositionInfoSource.PositioningMethods: ...
    AccessError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
    AllPositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
    ClosedError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
    NoError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
    NoPositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
    NonSatellitePositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
    SatellitePositioningMethods: typing.ClassVar[QGeoPositionInfoSource.PositioningMethod] = ...
    UnknownSourceError: typing.ClassVar[QGeoPositionInfoSource.Error] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    positionUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    supportedPositioningMethodsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    updateTimeout: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def availableSources(cls) -> typing.List[str]: ...
    def backendProperty(self, name: str) -> typing.Any: ...
    @overload
    @classmethod
    def createDefaultSource(cls, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoPositionInfoSource: ...
    @overload
    @classmethod
    def createDefaultSource(cls, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoPositionInfoSource: ...
    @overload
    @classmethod
    def createSource(cls, sourceName: str, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoPositionInfoSource: ...
    @overload
    @classmethod
    def createSource(cls, sourceName: str, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoPositionInfoSource: ...
    def lastKnownPosition(self, fromSatellitePositioningMethodsOnly: bool = ...) -> QGeoPositionInfo: ...
    def minimumUpdateInterval(self) -> int: ...
    def preferredPositioningMethods(self) -> typing.Union[QGeoPositionInfoSource.PositioningMethods,QGeoPositionInfoSource.PositioningMethod]: ...
    def requestUpdate(self, timeout: int = ...) -> None: ...
    def setBackendProperty(self, name: str, value: typing.Any) -> bool: ...
    def setPreferredPositioningMethods(self, methods: typing.Union[QGeoPositionInfoSource.PositioningMethods,QGeoPositionInfoSource.PositioningMethod]) -> None: ...
    def setUpdateInterval(self, msec: int) -> None: ...
    def sourceName(self) -> str: ...
    def startUpdates(self) -> None: ...
    def stopUpdates(self) -> None: ...
    def supportedPositioningMethods(self) -> typing.Union[QGeoPositionInfoSource.PositioningMethods,QGeoPositionInfoSource.PositioningMethod]: ...
    def updateInterval(self) -> int: ...

class QGeoPositionInfoSourceFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    def areaMonitor(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoAreaMonitorSource: ...
    def positionInfoSource(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoPositionInfoSource: ...
    def satelliteInfoSource(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoSatelliteInfoSource: ...

class QGeoRectangle(QGeoShape):
    @overload
    def __init__(self, center: QGeoCoordinate, degreesWidth: float, degreesHeight: float) -> None: ...
    @overload
    def __init__(self, topLeft: QGeoCoordinate, bottomRight: QGeoCoordinate) -> None: ...
    @overload
    def __init__(self, coordinates: typing.Iterable[QGeoCoordinate]) -> None: ...
    @overload
    def __init__(self, other: QGeoRectangle) -> None: ...
    @overload
    def __init__(self, other: QGeoShape) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bottomLeft(self) -> QGeoCoordinate: ...
    def bottomRight(self) -> QGeoCoordinate: ...
    def center(self) -> QGeoCoordinate: ...
    @overload
    def contains(self, coordinate: QGeoCoordinate) -> bool: ...
    @overload
    def contains(self, rectangle: QGeoRectangle) -> bool: ...
    def extendRectangle(self, coordinate: QGeoCoordinate) -> None: ...
    def height(self) -> float: ...
    def intersects(self, rectangle: QGeoRectangle) -> bool: ...
    def setBottomLeft(self, bottomLeft: QGeoCoordinate) -> None: ...
    def setBottomRight(self, bottomRight: QGeoCoordinate) -> None: ...
    def setCenter(self, center: QGeoCoordinate) -> None: ...
    def setHeight(self, degreesHeight: float) -> None: ...
    def setTopLeft(self, topLeft: QGeoCoordinate) -> None: ...
    def setTopRight(self, topRight: QGeoCoordinate) -> None: ...
    def setWidth(self, degreesWidth: float) -> None: ...
    def toString(self) -> str: ...
    def topLeft(self) -> QGeoCoordinate: ...
    def topRight(self) -> QGeoCoordinate: ...
    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None: ...
    def translated(self, degreesLatitude: float, degreesLongitude: float) -> QGeoRectangle: ...
    def united(self, rectangle: QGeoRectangle) -> QGeoRectangle: ...
    def width(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __ior__(self, rectangle: QGeoRectangle) -> QGeoRectangle: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, rectangle: QGeoRectangle) -> QGeoRectangle: ...
    def __ror__(self, other) -> typing.Any: ...

class QGeoSatelliteInfo(shiboken2.Object):
    class Attribute:
        Azimuth: typing.ClassVar[QGeoSatelliteInfo.Attribute] = ...
        Elevation: typing.ClassVar[QGeoSatelliteInfo.Attribute] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.Attribute: ...

    class SatelliteSystem:
        GLONASS: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
        GPS: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
        Undefined: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfo.SatelliteSystem: ...
    Azimuth: typing.ClassVar[QGeoSatelliteInfo.Attribute] = ...
    Elevation: typing.ClassVar[QGeoSatelliteInfo.Attribute] = ...
    GLONASS: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
    GPS: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
    Undefined: typing.ClassVar[QGeoSatelliteInfo.SatelliteSystem] = ...
    @overload
    def __init__(self, other: QGeoSatelliteInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attribute(self, attribute: QGeoSatelliteInfo.Attribute) -> float: ...
    def hasAttribute(self, attribute: QGeoSatelliteInfo.Attribute) -> bool: ...
    def removeAttribute(self, attribute: QGeoSatelliteInfo.Attribute) -> None: ...
    def satelliteIdentifier(self) -> int: ...
    def satelliteSystem(self) -> QGeoSatelliteInfo.SatelliteSystem: ...
    def setAttribute(self, attribute: QGeoSatelliteInfo.Attribute, value: float) -> None: ...
    def setSatelliteIdentifier(self, satId: int) -> None: ...
    def setSatelliteSystem(self, system: QGeoSatelliteInfo.SatelliteSystem) -> None: ...
    def setSignalStrength(self, signalStrength: int) -> None: ...
    def signalStrength(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QGeoSatelliteInfoSource(PySide2.QtCore.QObject):
    class Error:
        AccessError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
        ClosedError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
        NoError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
        UnknownSourceError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoSatelliteInfoSource.Error: ...
    AccessError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
    ClosedError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
    NoError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
    UnknownSourceError: typing.ClassVar[QGeoSatelliteInfoSource.Error] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    requestTimeout: typing.ClassVar[PySide2.QtCore.Signal] = ...
    satellitesInUseUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    satellitesInViewUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def availableSources(cls) -> typing.List[str]: ...
    @overload
    @classmethod
    def createDefaultSource(cls, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoSatelliteInfoSource: ...
    @overload
    @classmethod
    def createDefaultSource(cls, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoSatelliteInfoSource: ...
    @overload
    @classmethod
    def createSource(cls, sourceName: str, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoSatelliteInfoSource: ...
    @overload
    @classmethod
    def createSource(cls, sourceName: str, parent: typing.Union[PySide2.QtCore.QObject,None]) -> QGeoSatelliteInfoSource: ...
    def minimumUpdateInterval(self) -> int: ...
    def requestUpdate(self, timeout: int = ...) -> None: ...
    def setUpdateInterval(self, msec: int) -> None: ...
    def sourceName(self) -> str: ...
    def startUpdates(self) -> None: ...
    def stopUpdates(self) -> None: ...
    def updateInterval(self) -> int: ...

class QGeoShape(shiboken2.Object):
    class ShapeType:
        CircleType: typing.ClassVar[QGeoShape.ShapeType] = ...
        PathType: typing.ClassVar[QGeoShape.ShapeType] = ...
        PolygonType: typing.ClassVar[QGeoShape.ShapeType] = ...
        RectangleType: typing.ClassVar[QGeoShape.ShapeType] = ...
        UnknownType: typing.ClassVar[QGeoShape.ShapeType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoShape.ShapeType: ...
    CircleType: typing.ClassVar[QGeoShape.ShapeType] = ...
    PathType: typing.ClassVar[QGeoShape.ShapeType] = ...
    PolygonType: typing.ClassVar[QGeoShape.ShapeType] = ...
    RectangleType: typing.ClassVar[QGeoShape.ShapeType] = ...
    UnknownType: typing.ClassVar[QGeoShape.ShapeType] = ...
    @overload
    def __init__(self, other: QGeoShape) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def boundingGeoRectangle(self) -> QGeoRectangle: ...
    def center(self) -> QGeoCoordinate: ...
    def contains(self, coordinate: QGeoCoordinate) -> bool: ...
    def extendShape(self, coordinate: QGeoCoordinate) -> None: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def toString(self) -> str: ...
    def type(self) -> QGeoShape.ShapeType: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QNmeaPositionInfoSource(QGeoPositionInfoSource):
    class UpdateMode:
        RealTimeMode: typing.ClassVar[QNmeaPositionInfoSource.UpdateMode] = ...
        SimulationMode: typing.ClassVar[QNmeaPositionInfoSource.UpdateMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __and__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QNmeaPositionInfoSource.UpdateMode: ...
    RealTimeMode: typing.ClassVar[QNmeaPositionInfoSource.UpdateMode] = ...
    SimulationMode: typing.ClassVar[QNmeaPositionInfoSource.UpdateMode] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, updateMode: QNmeaPositionInfoSource.UpdateMode, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> QGeoPositionInfoSource.Error: ...
    def lastKnownPosition(self, fromSatellitePositioningMethodsOnly: bool = ...) -> QGeoPositionInfo: ...
    def minimumUpdateInterval(self) -> int: ...
    def parsePosInfoFromNmeaData(self, data: bytes, size: int, posInfo: QGeoPositionInfo) -> typing.Tuple[bool,bool]: ...
    def requestUpdate(self, timeout: int = ...) -> None: ...
    def setDevice(self, source: PySide2.QtCore.QIODevice) -> None: ...
    def setUpdateInterval(self, msec: int) -> None: ...
    def setUserEquivalentRangeError(self, uere: float) -> None: ...
    def startUpdates(self) -> None: ...
    def stopUpdates(self) -> None: ...
    def supportedPositioningMethods(self) -> typing.Union[QGeoPositionInfoSource.PositioningMethods,QGeoPositionInfoSource.PositioningMethod]: ...
    def updateMode(self) -> QNmeaPositionInfoSource.UpdateMode: ...
    def userEquivalentRangeError(self) -> float: ...
