from typing import Optional

import axipy
from axipy import ActiveToolPanel, MapTool, selection_manager, view_manager
from axipy.concurrent import ProgressGuiFlags, ProgressSpecification
from axipy.gui.map_tool import SelectToolBehavior
from PySide2.QtCore import Qt
from PySide2.QtGui import QKeyEvent, QMouseEvent, QPainter, QPaintEvent

from . import helper
from .helper import print_


class SelectorMapTool(axipy.MapTool):

    def __init__(self) -> None:
        super().__init__()
        self._selector = SelectToolBehavior(self)

    def unload(self) -> None:
        # Важно явно удалить selector при unload
        self._selector = None
        super().unload()

    # Input events

    def keyPressEvent(self, event: QKeyEvent) -> bool:
        if self._selector.keyPressEvent(event):
            return self.BlockEvent
        return super().keyPressEvent(event)

    def mouseMoveEvent(self, event: QMouseEvent) -> bool:
        self._selector.mouseMoveEvent(event)
        return self.PassEvent

    def mousePressEvent(self, event: QMouseEvent) -> bool:
        return self._selector.mousePressEvent(event)

    def mouseReleaseEvent(self, event: QMouseEvent) -> bool:
        return self._selector.mouseReleaseEvent(event)

    def paintEvent(self, event: QPaintEvent, painter: QPainter) -> bool:
        self._selector.paintEvent(event, painter)
        return self.PassEvent
