from typing import List

import axipy
from axipy.da import Feature, Table

from .collection_strategy import CollectionStrategy
from .line_strategy import LineStrategy
from .mapinfo_point_strategy import MapinfoPointStrategy
from .polygon_strategy import PolygonStrategy
from .raster_point_strategy import RasterPointStrategy
from .strategy_base import SelectStrategy
from .text_strategy import TextStrategy
from .vector_point_strategy import VectorPointStrategy


class SelectStrategyFactory:
    """
    Фабрика создающая стратегии поиска по стилю в зависимости от стиля
    выбранной записи
    """

    @staticmethod
    def make(f: Feature, table: Table) -> SelectStrategy:
        """
        Возвращают объект стратегии выделения по стилю
        """
        strategies = [
            MapinfoPointStrategy(f, table),
            VectorPointStrategy(f, table),
            RasterPointStrategy(f, table),
            LineStrategy(f, table),
            PolygonStrategy(f, table),
            CollectionStrategy(f, table),
            TextStrategy(f, table),
        ]  # type: List[SelectStrategy]
        for strategy in strategies:
            if strategy.identify(f.style):
                return strategy
        raise RuntimeError(axipy.tr("Не удалось определить стиль для выделенного объекта"))
