from enum import Enum

from osgeo import ogr, osr

from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.KPT.kptTools.KPTXml import GeoBuilderFromEntitySpatial, GeoPolygonFromEntitySpatial
from rosreestrXml.ui.tools.KPT.kptTools.KptAddress import ObjAddress


#from PkkXml.plugins.XmlPkk.DbKptDirectory import KptСatalog
#from PkkXml.plugins.XmlPkk.KPTXml import GeoPolygonFromEntitySpatial, GeoBuilderFromEntitySpatial,    GeoPolylineFromEntitySpatial
#from PkkXml.plugins.XmlPkk.KptAddress import ObjAddress

class TypeRealtysObject(Enum):
    Building=1
    Construction=2
    Uncompleted=3


class ObjBuilding:
    __xmlBuilding=None
    def __init__(self,Building,mi_style=None):
        self.__xmlBuilding=Building
        self.__str_styleMi=mi_style
        self.__reverseXY=False

    def setMiStyle(self,mi_style):
        self.__str_styleMi=mi_style
    def setReverseXY(self,reverse=False):
        self.__reverseXY=reverse
    @staticmethod
    def getNameLayer():
        return "ОбъектыЗдания"
    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'КадНомер', 'type': ogr.OFTString, 'width': 40})
        struct.append({'name': 'Вид', 'type': ogr.OFTString, 'width': 20})
        struct.append({'name': 'Назначение', 'type': ogr.OFTString, 'width': 20})
        struct.append({'name': 'Площадь', 'type': ogr.OFTReal})

        struct.append({'name': 'стоимость', 'type': ogr.OFTReal})
        struct.append({'name': 'СтоимостьЕдиницыИзмерения', 'type':ogr.OFTString, 'width': 20})

        struct.extend(ObjAddress.getStruct())
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})
        return struct

    def Write(self, layer, dbDictionary: KptСatalog):
        values=[]
        values.append({'name': 'КадНомер', 'value': self.__xmlBuilding.CadastralNumber})
        valObjectType=self.__xmlBuilding.ObjectType
        valStrObjectType,errMessage=dbDictionary.getTypeObject(valObjectType)
        values.append({'name': 'Вид', 'value': valStrObjectType})
        values.append({'name': 'Назначение', 'value': self.__xmlBuilding.AssignationBuilding})
        objCadastralCost=self.__xmlBuilding.CadastralCost
        try:
            values.append({'name': 'стоимость', 'value': float(objCadastralCost.Value)})
        except:
            pass
        try:
            valUnite,errMessage=dbDictionary.getUnit(objCadastralCost.Unit)
            values.append({'name': 'СтоимостьЕдиницыИзмерения', 'value': valUnite})
        except:
            pass
        try:
            values.append({'name': 'Площадь', 'value': float(self.__xmlBuilding.Area)})
        except:
            pass
        try:
            address=ObjAddress(self.__xmlBuilding.Address)
            values.extend(address.getValue())
        except:
            pass
        values.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})

        geoObj = GeoPolygonFromEntitySpatial(self.__xmlBuilding.EntitySpatial,self.__reverseXY)
        feature = ogr.Feature(layer.GetLayerDefn())
        for atr_item in values:
            #print(atr_item['name'])
            #print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        if geoObj is not None:
            feature.SetGeometry(geoObj)

        layer.CreateFeature(feature)
        geoObj = None
        feature = None
class ObjConstruction:
    __xmlConstruction=None
    def __init__(self,xmlConstruction,mi_style=None):
        self.__xmlConstruction=xmlConstruction
        self.__str_styleMi=mi_style

        self.__reverseXY = False

    def setMiStyle(self, mi_style):
        self.__str_styleMi = mi_style

    def setReverseXY(self, reverse=False):
        self.__reverseXY = reverse
    @staticmethod
    def getNameLayer():
        return "ОбъектыСооружения"

    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'КадНомер', 'type': ogr.OFTString, 'width': 40})
        struct.append({'name': 'Вид', 'type': ogr.OFTString, 'width': 20})
        struct.append({'name': 'Назначение', 'type': ogr.OFTString, 'width': 80})


        struct.append({'name': 'стоимость', 'type': ogr.OFTReal})
        struct.append({'name': 'СтоимостьЕдиницыИзмерения', 'type': ogr.OFTString, 'width': 20})

        struct.extend(ObjAddress.getStruct())
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})
        return struct
    def Write(self, layer, dbDictionary: KptСatalog):
        values=[]
        values.append({'name': 'КадНомер', 'value': self.__xmlConstruction.CadastralNumber})
        valObjectType=self.__xmlConstruction.ObjectType
        valStrObjectType,errMessage=dbDictionary.getTypeObject(valObjectType)
        values.append({'name': 'Вид', 'value': valStrObjectType})
        values.append({'name': 'Назначение', 'value': self.__xmlConstruction.AssignationName})
        objCadastralCost=self.__xmlConstruction.CadastralCost
        if objCadastralCost is not None:
            values.append({'name': 'стоимость', 'value': float(objCadastralCost.Value)})
            valUnite,errMessage=dbDictionary.getUnit(objCadastralCost.Unit)
            values.append({'name': 'СтоимостьЕдиницыИзмерения', 'value': valUnite})
        #values.append({'name': 'Площадь', 'value': float(self.__xmlBuilding.Area)})
        address=ObjAddress(self.__xmlConstruction.Address)
        try:
            values.extend(address.getValue())
            values.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        except:
            pass
        geoObj=None
        if self.__xmlConstruction.EntitySpatial is not None:
            geoObj = GeoBuilderFromEntitySpatial(self.__xmlConstruction.EntitySpatial,self.__reverseXY)
            #geoObj = GeoPolylineFromEntitySpatial(self.__xmlConstruction.EntitySpatial)
        feature = ogr.Feature(layer.GetLayerDefn())
        for atr_item in values:
            #print(atr_item['name'])
            #print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        if geoObj is not None:
            #print(self.__xmlConstruction.CadastralNumber)
            #print(geoObj.ExportToWkt())
            feature.SetGeometry(geoObj)

        layer.CreateFeature(feature)
        geoObj = None
        feature = None
class ObjUncompleted:
    __xmlConstruction = None

    def __init__(self, xmlConstruction, mi_style=None):
        self.__xmlConstruction = xmlConstruction
        self.__str_styleMi = mi_style

        self.__reverseXY = False

    def setMiStyle(self, mi_style):
        self.__str_styleMi = mi_style

    def setReverseXY(self, reverse=False):
        self.__reverseXY = reverse

    @staticmethod
    def getNameLayer():
        return "ОбъектыНезавершенногоСтроительства"

    @property
    def NameLayer(self):
        return self.__name
    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'КадНомер', 'type': ogr.OFTString, 'width': 40})
        struct.append({'name': 'Вид', 'type': ogr.OFTString, 'width': 20})
        struct.append({'name': 'Назначение', 'type': ogr.OFTString, 'width': 80})

        struct.append({'name': 'стоимость', 'type': ogr.OFTReal})
        struct.append({'name': 'СтоимостьЕдиницыИзмерения', 'type': ogr.OFTString, 'width': 20})

        struct.extend(ObjAddress.getStruct())
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})

        return struct
    def Write(self, layer, dbDictionary: KptСatalog):
        values=[]
        values.append({'name': 'КадНомер', 'value': self.__xmlConstruction.CadastralNumber})
        valObjectType=self.__xmlConstruction.ObjectType
        valStrObjectType,errMessage=dbDictionary.getTypeObject(valObjectType)
        values.append({'name': 'Вид', 'value': valStrObjectType})
        values.append({'name': 'Назначение', 'value': self.__xmlConstruction.AssignationName})
        objCadastralCost=self.__xmlConstruction.CadastralCost
        if objCadastralCost is not None:
            values.append({'name': 'стоимость', 'value': float(objCadastralCost.Value)})
            valUnite,errMessage=dbDictionary.getUnit(objCadastralCost.Unit)
            values.append({'name': 'СтоимостьЕдиницыИзмерения', 'value': valUnite})
        #values.append({'name': 'Площадь', 'value': float(self.__xmlBuilding.Area)})
        address=ObjAddress(self.__xmlConstruction.Address)
        try:
            values.extend(address.getValue())
            values.append({'name': 'MI_STYLE', 'value': self.__str_styleMi})
        except:
            pass
        geoObj=None
        if self.__xmlConstruction.EntitySpatial is not None:
            geoObj = GeoBuilderFromEntitySpatial(self.__xmlConstruction.EntitySpatial,self.__reverseXY)
            #geoObj = GeoPolylineFromEntitySpatial(self.__xmlConstruction.EntitySpatial)
        feature = ogr.Feature(layer.GetLayerDefn())
        for atr_item in values:
            #print(atr_item['name'])
            #print(atr_item['value'])
            feature.SetField(atr_item['name'], atr_item['value'])
        if geoObj is not None:
            #print(self.__xmlConstruction.CadastralNumber)
            #print(geoObj.ExportToWkt())
            feature.SetGeometry(geoObj)

        layer.CreateFeature(feature)
        geoObj = None
        feature = None
class ObjRealtys:
    __xmlRealtys = None
    __listRealty = None
    __cs_prj4 = None
    __str_styleMi = None
    __reverseXY = True
    __CadastralNumber=None
    __countBuilding=0
    __countConstruction=0
    __layers=None
    __nameProcess = "Импорт зданий и сооружений "
    def __init__(self, Realtys, cadastralNumber):
        self.__list_name=None
        if Realtys is None:
            return
        self.__xmlRealtys = Realtys
        self.__countBuilding = 0
        self.__countConstruction = 0
        self.__countUncompleted = 0
        self.__listRealty = []
        self.__list_name=[]
        for itemtagRealty in self.__xmlRealtys.ObjectRealty:
            if itemtagRealty.Building is not None:
                self.__listRealty.append(ObjBuilding(itemtagRealty.Building, self.__str_styleMi))
                self.__countBuilding=self.__countBuilding+1
            if itemtagRealty.Construction is not None:
                self.__listRealty.append(ObjConstruction(itemtagRealty.Construction, self.__str_styleMi))
                self.__countConstruction=self.__countConstruction+1
            if itemtagRealty.Uncompleted is not None:
                self.__countUncompleted=self.__countUncompleted +1
    def setCurentObjType(self,curentTypeObj:TypeRealtysObject):
        self.__curentSaveObjectType=curentTypeObj
    def setProperties(self,property):
        self.__property=property
        self.__cs_prj4=property['cs']
        self.__reverseXY=property['reverseXY']
    @property
    def NameProcess(self):
        return self.__nameProcess

    @property
    def NameLayer(self):
        if self.__list_name is None or len(self.__list_name)==0:
            return None
        return self.__list_name
    @property
    def Count(self):
        if self.__listRealty is None:
            return 0
        return len(self.__listRealty)
    def setOutParams(self, cs_proj4, mi_style, reverseXY=True):
        self.__str_styleMi = mi_style
        self.__cs_prj4 = cs_proj4
        self.__reverseXY = reverseXY
    def Save(self,ds,dbDictionary:KptСatalog):
        self.CreateLayer(ds,self.__cs_prj4)
        self.Write(dbDictionary)
    def CreateLayer(self,ds,createNewLayer=True):


        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__cs_prj4)
        self.__layers={}
        obj_layer=None
        if self.__countBuilding>0:
            if not createNewLayer:
                obj_layer=ds.GetLayer(ObjBuilding.getNameLayer())
            if obj_layer is None:
                obj_layer=self.CreateLayerItem(ds,ObjBuilding.getNameLayer(),srs,ObjBuilding.getStruct())
                self.__list_name.append(ObjBuilding.getNameLayer())
            self.__layers["Building"]=obj_layer
        if self.__countConstruction>0:
            if not createNewLayer:
                obj_layer=ds.GetLayer(ObjConstruction.getNameLayer())
            if obj_layer is None:
                obj_layer = self.CreateLayerItem(ds, ObjConstruction.getNameLayer(), srs, ObjConstruction.getStruct())
                self.__list_name.append( ObjConstruction.getNameLayer())
            self.__layers["Construction"] = obj_layer
        srs=None
    def CreateLayerItem(self,ds,name,srs,struct):

        layer = ds.CreateLayer(name, srs, geom_type=ogr.wkbGeometryCollection)
        for fld in struct:
            # create fields
            field_cur = ogr.FieldDefn(fld['name'], fld['type'])
            type_field = fld['type']
            if fld['type'] == ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer
    def Write(self,layerBase,dbDictionary:KptСatalog,mapCatalog):
        if self.__listRealty is None:
            return
        mi_style_building=''
        mi_style = dbDictionary.GetStyle('kpt_10_style', 'Building')
        if mi_style[0] is None:

            mi_style_building = 'Pen (2, 6, 16711680) Brush (1, 16777215, 16777215)'
        else:
            mi_style_building = mi_style[0]
        mi_style = dbDictionary.GetStyle('kpt_10_style', 'Construction')
        if mi_style[0] is None:

            mi_style_constacrtion = 'Pen (2, 6, 16711680) Brush (1, 16777215, 16777215)'
        else:
            mi_style_constacrtion = mi_style[0]
        for realty in self.__listRealty:

            layer=None
            realty.setReverseXY(self.__reverseXY)
            if isinstance(realty,ObjBuilding):
                realty.setMiStyle( mi_style_building)
                layer=self.__layers["Building"]
            if isinstance(realty,ObjConstruction):
                realty.setMiStyle(mi_style_constacrtion)
                layer=self.__layers["Construction"]
            if layer is not None:
                realty.Write(layer,dbDictionary)
        try:
            layer_building=self.__layers["Building"]
            mapCatalog.addLayerInfoInMapCataalog(layer_building,self.__property['cs_mi'])
        except:
            pass
        try:
            layer_constraction=self.__layers["Construction"]
            mapCatalog.addLayerInfoInMapCataalog(layer_constraction, self.__property['cs_mi'])
        except:
            pass
    def WriteItem(self,id_item,layer,dbDictionary:KptСatalog,dbDoc):
        realty= self.__listRealty[id_item]
        realty.setMiStyle(self.__str_styleMi)

        layer = None
        if isinstance(realty, ObjBuilding):
            layer = self.__layers["Building"]
        if isinstance(realty, ObjConstruction):
            layer = self.__layers["Construction"]
        if layer is not None:
            realty.Write(layer, dbDictionary)
