from osgeo import ogr

from rosreestrXml.ui.tools.db_helper.dbRsc import DbRsc

def addAllColums(db:DbRsc,name_view,name_result,name_key,name_geometry):
    sql = "select name AS column_name,type AS column_type FROM  pragma_table_info('" + name_view + "')"
    rows = db.select(sql)
    def_names = []
    for row in rows:
        def_names.append({"name": row[0], 'type': row[1]})
    for name_def in def_names:
        if name_def['name'] == name_key or name_def['name'] == name_geometry:
            continue
        sql_alter = "ALTER TABLE " + name_result + " ADD COLUMN " + name_def['name'] + " " + name_def['type']
        db.runSqlNoResult(sql_alter)

def createBaseSpatial(ds,name_view,name_result,name_key):
    layer = ds.GetLayerByName(name_view)
    srs = layer.GetSpatialRef()
    layer_def = layer.GetLayerDefn()
    layer_temp = ds.GetLayerByName(name_result)
    if layer_temp is not None:
        ds.DeleteLayer(name_result)
    layer_temp=None
    layer_new = ds.CreateLayer(name_result, srs=srs, geom_type=ogr.wkbUnknown)
    layer_new.CreateField(ogr.FieldDefn(name_key, ogr.OFTInteger))

    for ft in layer:
        id_rec = ft.GetFID()
        # id_rec=ft.GetField("parent_row_id")
        new_ft = ogr.Feature(layer_new.GetLayerDefn())
        new_ft.SetField('parent_row_id', id_rec)
        new_ft.SetGeometry(ft.GetGeometryRef())
        layer_new.CreateFeature(new_ft)
        new_ft = None
    layer_new=None
def CreateMaterialized_Views(db:DbRsc,name_source_view,name_Materialized_Views,name_key_field,name_geometry="geom"):
    path_source_db=str(db.PathDb)
    ds=ogr.Open(path_source_db,1)
    createBaseSpatial(ds,name_source_view,name_Materialized_Views,name_key_field)
    addAllColums(db,name_source_view,name_Materialized_Views,name_key_field,name_geometry)
    sql = "select name AS column_name,type AS column_type FROM  pragma_table_info('" + name_source_view + "')"
    rows = db.select(sql)
    def_names = []
    for row in rows:
        def_names.append({"name": row[0], 'type': row[1]})
    sql_base = "select parent_row_id from " + name_source_view
    layer_select = ds.ExecuteSQL(sql_base)
    for ft in layer_select:
        id_row = ft.GetFID()
        for name_def in def_names:
            if name_def['name'] == 'parent_row_id' or name_def['name'] == 'geom':
                continue
            sqlupdate = "update " + name_Materialized_Views + " Set " + name_def['name'] + "= ( select " + name_def[
                'name'] + " from " + name_source_view + " where parent_row_id=" + str(
                id_row) + ") where " + name_Materialized_Views + ".parent_row_id=" + str(id_row)
            temp_layer = ds.ExecuteSQL(sqlupdate)
            temp_layer=None
        ft=None

    layer_select=None
    ds.FlushCache()
    ds.Destroy()
    ds = None


