import os

from PySide2.QtCore import QFile
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog, QToolButton, QListWidgetItem, QWidget, QCheckBox, QLabel, QHBoxLayout
from axipy import  StyleButton
from axipy.da import Style

from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog


class StylesKpt(QWidget):
    def __init__(self,properies,parent=None):
        super(StylesKpt, self).__init__(parent)
        self.__properies=properies
        self.__parentWin=parent
        self.load_ui('widgetStyles.ui')
        self.ui.cmb_type.currentIndexChanged.connect(self.__change_kpt)
        self.__initView()
        self.ui.pb_save.clicked.connect(self.__save)
        #self.__update0()

    def __initView(self):
        type_obj_xml=self.__properies['type_kpt']
        for item in type_obj_xml:
            self.ui.cmb_type.addItem(item['name'])
        self.ui.cmb_type.setCurrentIndex(0)
    def __update0(self):
        items=[]
        items.append({'name':'Местоположение квартала','style':'Pen (2, 2, 16711680)  Brush (52, 0)','enable':True})
        items.append({'name': 'земельных участки', 'style': 'Pen (2, 2, 8388608) Brush (63, 0)','enable':True})
        for item_style in items:
            item, item_widget = self.__createItem(item_style)
            self.ui.list_styles.addItem(item)
            self.ui.list_styles.setItemWidget(item, item_widget)
    def __change_kpt(self,index):
        items_properies=self.__properies['type_kpt'][index]
        tab_db=KptСatalog()
        kpt_properties=tab_db.GetPropertiesKpt(items_properies['table'])
        tab_db.close()
        self.ui.list_styles.clear()
        for item_style in kpt_properties:
            item, item_widget = self.__createItem(item_style)
            self.ui.list_styles.addItem(item)
            self.ui.list_styles.setItemWidget(item, item_widget)
    def __createItem(self,item_style):
        item = QListWidgetItem()
        item_widget = QWidget()
        line_chekBox = QCheckBox()
        if item_style['enable']:
            line_chekBox.setChecked(True)
        line_chekBox.setObjectName(item_style['name'])
        line_chekBox.setText(item_style['name'])
        # line_chekBox.setCheckState(True)
        #line_text = QLabel(item_style['name'])
        style_bt=StyleButton(Style.from_mapinfo(item_style['style']), self.ui)
        style_bt.style_changed.connect(self.clicked)
        #style_bt.setGeometry(0,0, 50, 50)
        #style_bt.resize(50, 50)
        style_bt.setFixedSize(50,50)
        style_bt.setObjectName(item_style['name'])
        item_layout = QHBoxLayout()
        item_layout.addWidget(line_chekBox)
        #item_layout.addWidget(line_text)
        item_layout.addWidget(style_bt)
        item_widget.setLayout(item_layout)
        item.setSizeHint(item_widget.sizeHint())
        item.setWhatsThis(item_style['name'])
        return item, item_widget
    def __save(self):
        count_row = self.ui.list_styles.count()
        style_kpt_properties=[]
        for i in range(count_row):
            item_widget = self.ui.list_styles.item(i)
            name = item_widget.whatsThis()
            style_button=self.ui.findChild(StyleButton, name)
            mi_style=style_button.style.to_mapinfo()
            check_box=self.ui.findChild(QCheckBox, name)
            is_enable=check_box.isChecked()
            style_kpt_properties.append({'key':name,'style':mi_style,'enable':is_enable})
        curent_index=self.ui.cmb_type.currentIndex()
        items_properies = self.__properies['type_kpt'][curent_index]
        name_table_db=items_properies['table']
        tab_db=KptСatalog()
        tab_db.updateTabStyle(name_table_db,style_kpt_properties)
        tab_db.close()
        return
    def clicked(self):
        sender = self.sender()
        push_button = self.ui.findChild(StyleButton, sender.objectName())
        jkl=0
    def load_ui(self, name_resource):
        loader = QUiLoader()
        path = os.path.join(os.path.dirname(__file__), name_resource)
        ui_file = QFile(path)
        ui_file.open(QFile.ReadOnly)
        self.ui = loader.load(ui_file, self.__parentWin)
        ui_file.close()

    @property
    def widget(self):
        return self.ui

    def show(self):
        # self.ui.showMaximized()
        # print("Show Form")
        self.ui.show()
