import sys

from PySide2.QtWidgets import QApplication

from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr, TypeGeometryProviderOgr
from rosreestrXml.ui.tools.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.kptTools.KPTXml import SpatialData
from rosreestrXml.ui.tools.kptTools.KptBound import ObjBounds
from rosreestrXml.ui.tools.kptTools.KptObjXml import FactoryKpt
from rosreestrXml.ui.tools.kptTools.kpt_10 import parse

if __name__ == "__main__":
    app = QApplication(sys.argv)

    path_kpt="E:\\Download\\RossRestr\\77_01_0000000_2016-12-16_kpt10.xml.sig\\77_01_0000000_2016-12-16_kpt10.xml"
    path_kpt="E:\\Download\\RossRestr\\47_17_0102002_2020-04-06_kpt10.xml\\47_17_0102002_2020-04-06_kpt10.xml"
    path_kpt="E:\\Download\\RossRestr\\77_06_0002015_2016-07-15_kpt10.xml\\77_06_0002015_2016-07-15_kpt10.xml"
    #path_kpt="E:\\Download\\RossRestr\\Test77_06_0002015_2016-07-15_kpt10.xml\\77_06_0002015_2016-07-15_kpt10.xml"
    path_kpt=r"E:\Download\RossRestr\47_17_0102002_2020-04-06_kpt10.xml\47_17_0102002_2020-04-06_kpt10.xml"
    dbCatalog=KptСatalog()
    ObjKpt=parse(path_kpt,True)
    #ObjEntitySpatial(ObjKpt.CadastralBlocks.CadastralBlock[0].Parcels.Parcel[0].EntitySpatial)
    #geoObj=GeoPolygonFromEntitySpatial(ObjKpt.CadastralBlocks.CadastralBlock[0].Parcels.Parcel[0].EntitySpatial)
    #ObjKpt.CadastralBlocks.CadastralBlock[0]
    objXmlKpt=FactoryKpt(ObjKpt)
    path_out="E:\\Support\\AxiomaTesting\\XMLKpt\\test.sqlite"
    path_out="E:\\Support\\AxiomaTesting\\XMLKpt\\testGpkgBounds.gpkg"
    #path_out="E:\\Support\\AxiomaTesting\\XMLKpt\\testGpkg.gpkg"
    dbDoc=None
    dbDoc=DocumentsDb(path_out)
    db=DbGeoOgr(dbCatalog)
    db.Create(path_out,TypeGeometryProviderOgr.GPKG)
    db.setDbDocuments(dbDoc)
    cs_proj4="+proj=eqc +R=6370997 +units=m +no_defs"
    cs_wkt='LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
    mi_style='Pen (3, 9, 255) Brush (18, 65280)'
    mi_style='Pen (3, 9, 255) ,Pen (3, 9, 255) Brush (18, 65280)'
    objXmlKpt[0].setSpatialData(SpatialData())
    objSpatial=objXmlKpt[0].SaveSpatialData(db,cs_wkt,mi_style)
    #objXmlKpt[0].SaveParcels(db,cs_wkt,mi_style)
    #objXmlKpt[0].SaveZones(db,cs_wkt,mi_style)
    #objXmlKpt[0].SaveRealty(db,cs_wkt,mi_style)
    #objXmlKpt[0].setBounds(ObjBounds(objXmlKpt[0].Bounds,None))
    #objBounds=objXmlKpt[0].getObjBoundsToSave(cs_wkt,mi_style)

    db.Save(objBounds)
    #db.runProcess([objZones])
    db.Close()