import axipy
from PySide2.QtCore import QSize
from PySide2.QtGui import QFont, QColor
from axipy import LabelLayoutPosition, Label, Pnt, Style

from LoadMiWor.ui.processTool.parserWor.parse import search
#from LoadMiWor.ui.processTool.utils import getDpi

def getStyleLineLabel(mi_str):
    token_find_pen = search("pen {type_style} ", mi_str+" ")
    arrow_style=None
    if token_find_pen is not None:
        str_pen = "Pen " + token_find_pen.named['type_style']
        arrow_style = Style.from_mapinfo(str_pen)
    return arrow_style
def StringToBoolean(value):
    if value.lower().strip()=='off':
        return False
    if value.lower().strip()=='on':
        return True
    return False
def setLabelFont(label,mi_style:str):
    params=mi_style.split(",")
    name_font=params[0].replace('"','')
    style_font=int(params[1])
    size=int(params[2])
    int_foreground_color=int(params[3])
    int_background_color=None
    if len(params)==5:
        int_background_color=int(params[4])
    qfont= QFont(name_font, size)
    if style_font==1:
        qfont.setBold(True)
    if style_font==2:
        qfont.setItalic(True)
    if style_font==4:
        qfont.setUnderline(True)
    label.font=qfont
    label.color=QColor(int_foreground_color)
    if int_background_color is not None:
        label. backgroundColor=QColor(int_background_color)
    return
def setPosition(layout,name_pos):
    ''' Установка положения подписи относительно центроида'''
    if name_pos=='center':
        layout.position=LabelLayoutPosition.Center
        return layout
    if name_pos=='above':
        layout.position=LabelLayoutPosition.Top
        return layout
    if name_pos=='below':
        layout.position=LabelLayoutPosition.Bottom
        return layout
    if name_pos=='left':
        layout.position=LabelLayoutPosition.Left
        return layout
    if name_pos=='right':
        layout.position=LabelLayoutPosition.Right
        return layout
    if name_pos=='right':
        layout.position=LabelLayoutPosition.Right
        return layout
    if  name_pos=='below_left':
        layout.position=LabelLayoutPosition.BottomLeft
        return layout
    if  name_pos=='below_right':
        layout.position=LabelLayoutPosition.BottomRight
        return layout
    if  name_pos=='above_left':
        layout.position=LabelLayoutPosition.TopLeft
        return layout
    if  name_pos=='above_right':
        layout.position=LabelLayoutPosition.TopRight
        return layout
    return None
def setOffsetLayout(layout,offset:int):
    '''
    if layout.position==LabelLayoutPosition.Center:
        layout.offset=QSize(0,0)
        return layout
    if layout.position==LabelLayoutPosition.Top:
        layout.offset=QSize(0,offset)
        return layout
    if layout.position==LabelLayoutPosition.Bottom:
        layout.offset=QSize(0,-offset)
        return layout
    if layout.position==LabelLayoutPosition.BottomLeft:
        layout.offset=QSize(-offset,-offset)
        return layout
    if layout.position==LabelLayoutPosition.BottomRight:
        layout.offset=QSize(-offset,-offset)
        return layout
    if layout.position==LabelLayoutPosition.TopLeft:
        layout.offset=QSize(offset,offset)
        return layout
    if layout.position==LabelLayoutPosition.TopRight:
        layout.offset=QSize(offset,offset)
        return layout
    if layout.position==LabelLayoutPosition.Left:
        layout.offset=QSize(-offset,0)
        return layout
    if layout.position==LabelLayoutPosition.Right:
        layout.offset=QSize(offset,0)
        return layout
    '''
    layout.offset=QSize(offset,offset)
    return layout
def SetOffsetLabel(layer,offset:int):
    list_layout=[layer.label.pointLayout,layer.label.lineLayout,layer.label.areaLayout]
    for i,layout in enumerate(list_layout):
        layout=setOffsetLayout(layout,offset)
        if i==0:
            layer.label.pointLayout=layout
            continue
        if i==1:
            layer.label.lineLayout=layout
            continue
        if i==1:
            layer.label.areaLayout=layout
            continue
    return
def parserWindowInfo(str_miWininfo):
    #if str_miWininfo.isnumeric():
    #    return float(str_miWininfo)
    val_float=None
    try:
        val_float=float(str_miWininfo)
    except:
        pass
    if val_float is not None:
        return val_float
    token_win = search('WindowInfo ({params}) ', str_miWininfo)
    if token_win is None:
        return None
    value_params=token_win.named['params']
    lst_params=value_params.split(',')
    number_win=int(lst_params[0])
    param_win=int(lst_params[1])
    from LoadMiWor.ui.processTool.utils import getDpi
    dpi=getDpi()
    rect_mainWindow=axipy.mainwindow.qt_object().geometry()
    obj_val=None
    if number_win==1011 and param_win==5:
        ''' Высота главного окна'''
        obj_val=rect_mainWindow.height()/dpi

    if number_win == 1011 and param_win == 4:
        ''' Ширина '''
        obj_val = rect_mainWindow.width() / dpi
    if obj_val is not None:
        str_eval=str(obj_val)
        str_temp=str_miWininfo[token_win.spans['params'][1]+1:len(str_miWininfo)-1]
        str_temp=str_temp.strip()
        if len(str_temp)==0:
            return obj_val
        str_eval=str_eval+str_temp
        obj_eval=eval(str_eval)
        return obj_eval
    return None
def tokenPointPositionToPnt(string_pnt):
    s_xy=string_pnt.split(",")
    if len(s_xy)>2:
        s_xy[1]=s_xy[1]+','+s_xy[2]
    x=parserWindowInfo(s_xy[0])
    y=parserWindowInfo(s_xy[1])
    return Pnt(x,y)


