#from axipy import CoordSystem

#from clsParser import baseParser
from axipy import Text, Style, Rect

from LoadMiWor.ui.processTool.parserWor.parse import search


class MiCreateText:
    def __init__(self,dict_parsers):
        self.__parsers_dict=dict_parsers
        #self.__obj_comp_coord=baseParser("({ld}) ({ru})")
    def parser(self,micomand:list,view,cs,out_cs=None):
        '''

        :param micomand command MapBasic:
        :param cs source CoordSystem:
        :param out_cs Out CoordSystem:
        :return:
        '''
        micomand_text=''
        for i in range(1,len(micomand)):
            line_txt=micomand[i].lstrip().rstrip()
            if line_txt[-1]!='+':
                micomand_text=micomand_text+line_txt.lstrip('"').rstrip('"')
                break
            micomand_text=micomand_text+line_txt.rstrip('+').lstrip('"').rstrip('"')
        str_coord=micomand[i+1].lstrip().rstrip()
        result_pares=self.__parsers_dict['Create Text'].parserToken(str_coord)
        str_ld_coord=result_pares.named['ld']
        xy=str_ld_coord.split(",")
        x0=float(xy[0])
        y0=float(xy[1])
        str_ru_coord=result_pares.named['ru']
        xy=str_ru_coord.split(",")
        x1=float(xy[0])
        y1=float(xy[1])

        micomand_text=micomand_text.replace('\\n','\n')

        if out_cs is not None:
            x0=cs.unit.to_unit(out_cs.unit,x0)
            y0=cs.unit.to_unit(out_cs.unit,y0)
            x1=cs.unit.to_unit(out_cs.unit,x1)
            y1=cs.unit.to_unit(out_cs.unit,y1)
            rect=Rect(x0,y0,x1,y1)
            #geo=Text(micomand_text,rect=rect,angle=0,view=view,cs=out_cs)

            geo=Text(micomand_text,rect=rect,angle=0,view=view)
        else:
            rect=Rect(x0,y0,x1,y1)
            geo=Text(micomand_text,rect,view=view,cs=cs)
        micomand_font=None
        micomand_angle=None
        for j in range(i,len(micomand)):
            line_=micomand[j].lstrip().rstrip()
            if line_.find("Font")==0:
                micomand_font=line_
            if line_.find("Angle")==0:
                micomand_angle=line_
        axi_style=None
        if micomand_font is not None:
            result_parser_font=self.__parsers_dict['Font'].parserToken(micomand_font)
            mi_style="Font ("+result_parser_font.named['font']+")"
            axi_style=Style.from_mapinfo(mi_style)
        return geo,axi_style
def parserText(dictanary,items,view,cs_source,cs_out):
    cls_text=MiCreateText(dictanary)
    return cls_text.parser(items,view,cs_source,cs_out)
def parserTextAlter(source,start_index,view,cs_source,cs_out):
    index=start_index+1
    line_text=source[index].strip()
    index=index+1
    line_coord=source[index].strip()
    token_coord=search("({point1}) ({point2}) ",line_coord+" ")
    str_point_1=token_coord.named['point1']
    str_point_2 = token_coord.named['point2']
    from LoadMiWor.ui.processTool.utils import tokenPointToPnt
    pt1=tokenPointToPnt(str_point_1)
    pt2=tokenPointToPnt(str_point_2)
    x0=pt1.x
    y0=pt1.y
    x1=pt2.x
    y1=pt2.y
    if cs_out is not None:
        x0 = cs_source.unit.to_unit(cs_out.unit, x0)
        y0 = cs_source.unit.to_unit(cs_out.unit, y0)
        x1 = cs_source.unit.to_unit(cs_out.unit, x1)
        y1 = cs_source.unit.to_unit(cs_out.unit, y1)
    geo = Text(line_text, Rect(x0,y0,x1,y1), view=view, cs=cs_out)
    index = index + 1
    line_style = source[index].strip()
    axy_style=Style.from_mapinfo(line_style)
    return geo,axy_style





