import os

import axipy
from PySide2.QtWidgets import QMessageBox
from axipy import AxiomaPlugin, Position

from LoadMiWor.ui.dlgLoadWor import DlgFormWorOpen


class Plugin(AxiomaPlugin):
    def load(self):
        local_file_icon=os.path.join(os.path.dirname(os.path.realpath(__file__)),'icons', 'OpenWor.png')
        self.__action = self.create_action('Открытие wor',
                                           icon=local_file_icon, on_click=self.openWor)
        position = Position('Основные', 'Команды')
        position.add(self.__action)
        self.__action.action.setToolTip('Открытие wor(рабочего набора MapInfo) ')
        self.__dlgWor=None
    def unload(self):
        self.__dlgWor=None
        self.__action.remove()
    def openWor(self):
        if self.__dlgWor is None:
            self.__dlgWor=DlgFormWorOpen(axipy.app.mainwindow.qt_object())
        self.__dlgWor.exec_()



