import axipy
from axipy import Legend, view_manager, PolygonStyle

from LoadMiWor.ui.processTool.parserWor.parse import search


def getStyleBrush(mi_str):
    token = search('brush ({value_brush}) pen ({value_pen})', mi_str)
    if token is None:
        return None
    return "Brush " + " (" + token['value_brush'] + ") Pen("+token['value_pen']+")"
def clearLegendView(legende_view):
    count=len(legende_view.legends)
    for j in range(count):
        legende_view.legends.remove(0)
def legInfoDebug(leg:Legend):
    leg_items=leg.items
    count= len(leg_items)
    print(leg.caption)
    print("Count items:"+str(count))
    if leg.caption=='дополнительно - ID':
        for i in range(count):
            item=leg.items[i]
            style_mi=item.style.to_mapinfo()
            mi_brush=getStyleBrush(style_mi.lower())
            item.style=PolygonStyle().from_mapinfo(mi_brush)
            item.title=str(i+1)
            leg.items[i]=item
map=axipy.view_manager.active.map
layers=map.layers
legendView = view_manager.create_legendview(axipy.view_manager.active)
for leg in legendView.legends:
    legInfoDebug(leg)
legendView.arrange()
