from axipy import Position, Plugin, Notifications, tr, ActionButton


class ExamplePluginMinimal(Plugin):
    def __init__(self) -> None:
        self._title: str = self.tr("Минимальный плагин")

        self._action: ActionButton = ActionButton(
            title=self.tr("Пример действия"),
            icon="://icons/share/32px/run3.png",
            on_click=self.show_message,
            tooltip=self.tr("Всплывающая подсказка")
        )
        position = Position(tr("Примеры модулей"), tr("Минимальный"))
        position.add(self._action)

    def unload(self) -> None:
        self._action.remove()

    def show_message(self) -> None:
        Notifications.push(self._title, self.tr("Пример выполнения действия по нажатию кнопки"))
