from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtNetwork
import PySide2.QtPrintSupport
import PySide2.QtWebChannel
import PySide2.QtWebEngineCore
import PySide2.QtWidgets
import shiboken2
import typing
T = typing.TypeVar('T')

class QWebEngineCertificateError(shiboken2.Object):
    class Error:
        CertificateAuthorityInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateCommonNameInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateContainsErrors: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateDateInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateKnownInterceptionBlocked: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateNameConstraintViolation: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateNoRevocationMechanism: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateNonUniqueName: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateRevoked: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateTransparencyRequired: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateUnableToCheckRevocation: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateValidityTooLong: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateWeakKey: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        CertificateWeakSignatureAlgorithm: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        SslPinnedKeyNotInCertificateChain: typing.ClassVar[QWebEngineCertificateError.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineCertificateError.Error: ...
    CertificateAuthorityInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateCommonNameInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateContainsErrors: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateDateInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateInvalid: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateKnownInterceptionBlocked: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateNameConstraintViolation: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateNoRevocationMechanism: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateNonUniqueName: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateRevoked: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateTransparencyRequired: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateUnableToCheckRevocation: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateValidityTooLong: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateWeakKey: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    CertificateWeakSignatureAlgorithm: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    SslPinnedKeyNotInCertificateChain: typing.ClassVar[QWebEngineCertificateError.Error] = ...
    @overload
    def __init__(self, error: int, url: PySide2.QtCore.QUrl, overridable: bool, errorDescription: str) -> None: ...
    @overload
    def __init__(self, other: QWebEngineCertificateError) -> None: ...
    def answered(self) -> bool: ...
    def certificateChain(self) -> typing.List[PySide2.QtNetwork.QSslCertificate]: ...
    def defer(self) -> None: ...
    def deferred(self) -> bool: ...
    def error(self) -> QWebEngineCertificateError.Error: ...
    def errorDescription(self) -> str: ...
    def ignoreCertificateError(self) -> None: ...
    def isOverridable(self) -> bool: ...
    def rejectCertificate(self) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QWebEngineContextMenuData(shiboken2.Object):
    class EditFlag:
        CanCopy: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanCut: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanDelete: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanEditRichly: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanPaste: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanRedo: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanSelectAll: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanTranslate: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        CanUndo: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineContextMenuData.EditFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...

    class EditFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineContextMenuData.EditFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.EditFlags: ...

    class MediaFlag:
        MediaCanPrint: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaCanRotate: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaCanSave: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaCanToggleControls: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaControls: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaHasAudio: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaInError: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaLoop: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaMuted: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        MediaPaused: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineContextMenuData.MediaFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...

    class MediaFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineContextMenuData.MediaFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaFlags: ...

    class MediaType:
        MediaTypeAudio: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypeCanvas: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypeFile: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypeImage: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypeNone: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypePlugin: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        MediaTypeVideo: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineContextMenuData.MediaType: ...
    CanCopy: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanCut: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanDelete: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanEditRichly: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanPaste: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanRedo: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanSelectAll: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanTranslate: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    CanUndo: typing.ClassVar[QWebEngineContextMenuData.EditFlag] = ...
    MediaCanPrint: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaCanRotate: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaCanSave: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaCanToggleControls: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaControls: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaHasAudio: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaInError: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaLoop: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaMuted: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaPaused: typing.ClassVar[QWebEngineContextMenuData.MediaFlag] = ...
    MediaTypeAudio: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypeCanvas: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypeFile: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypeImage: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypeNone: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypePlugin: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    MediaTypeVideo: typing.ClassVar[QWebEngineContextMenuData.MediaType] = ...
    @overload
    def __init__(self, other: QWebEngineContextMenuData) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def editFlags(self) -> typing.Union[QWebEngineContextMenuData.EditFlags,QWebEngineContextMenuData.EditFlag]: ...
    def isContentEditable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def linkText(self) -> str: ...
    def linkUrl(self) -> PySide2.QtCore.QUrl: ...
    def mediaFlags(self) -> typing.Union[QWebEngineContextMenuData.MediaFlags,QWebEngineContextMenuData.MediaFlag]: ...
    def mediaType(self) -> QWebEngineContextMenuData.MediaType: ...
    def mediaUrl(self) -> PySide2.QtCore.QUrl: ...
    def misspelledWord(self) -> str: ...
    def position(self) -> PySide2.QtCore.QPoint: ...
    def selectedText(self) -> str: ...
    def spellCheckerSuggestions(self) -> typing.List[str]: ...
    def __copy__(self) -> None: ...

class QWebEngineDownloadItem(PySide2.QtCore.QObject):
    class DownloadInterruptReason:
        FileAccessDenied: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileBlocked: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileHashMismatch: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileNameTooLong: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileNoSpace: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileSecurityCheckFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileTooLarge: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileTooShort: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileTransientError: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        FileVirusInfected: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NetworkDisconnected: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NetworkFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NetworkInvalidRequest: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NetworkServerDown: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NetworkTimeout: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        NoReason: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerBadContent: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerCertProblem: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerForbidden: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerUnauthorized: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        ServerUnreachable: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        UserCanceled: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadInterruptReason: ...

    class DownloadState:
        DownloadCancelled: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
        DownloadCompleted: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
        DownloadInProgress: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
        DownloadInterrupted: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
        DownloadRequested: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadState: ...

    class DownloadType:
        Attachment: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
        DownloadAttribute: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
        SavePage: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
        UserRequested: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.DownloadType: ...

    class SavePageFormat:
        CompleteHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
        MimeHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
        SingleHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
        UnknownSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineDownloadItem.SavePageFormat: ...
    Attachment: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
    CompleteHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
    DownloadAttribute: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
    DownloadCancelled: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
    DownloadCompleted: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
    DownloadInProgress: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
    DownloadInterrupted: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
    DownloadRequested: typing.ClassVar[QWebEngineDownloadItem.DownloadState] = ...
    FileAccessDenied: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileBlocked: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileHashMismatch: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileNameTooLong: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileNoSpace: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileSecurityCheckFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileTooLarge: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileTooShort: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileTransientError: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    FileVirusInfected: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    MimeHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
    NetworkDisconnected: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    NetworkFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    NetworkInvalidRequest: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    NetworkServerDown: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    NetworkTimeout: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    NoReason: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    SavePage: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
    ServerBadContent: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    ServerCertProblem: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    ServerFailed: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    ServerForbidden: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    ServerUnauthorized: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    ServerUnreachable: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    SingleHtmlSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
    UnknownSaveFormat: typing.ClassVar[QWebEngineDownloadItem.SavePageFormat] = ...
    UserCanceled: typing.ClassVar[QWebEngineDownloadItem.DownloadInterruptReason] = ...
    UserRequested: typing.ClassVar[QWebEngineDownloadItem.DownloadType] = ...
    downloadProgress: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    isPausedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def accept(self) -> None: ...
    def cancel(self) -> None: ...
    def downloadDirectory(self) -> str: ...
    def downloadFileName(self) -> str: ...
    def id(self) -> int: ...
    def interruptReason(self) -> QWebEngineDownloadItem.DownloadInterruptReason: ...
    def interruptReasonString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isSavePageDownload(self) -> bool: ...
    def mimeType(self) -> str: ...
    def page(self) -> QWebEnginePage: ...
    def path(self) -> str: ...
    def pause(self) -> None: ...
    def receivedBytes(self) -> int: ...
    def resume(self) -> None: ...
    def savePageFormat(self) -> QWebEngineDownloadItem.SavePageFormat: ...
    def setDownloadDirectory(self, directory: str) -> None: ...
    def setDownloadFileName(self, fileName: str) -> None: ...
    def setPath(self, path: str) -> None: ...
    def setSavePageFormat(self, format: QWebEngineDownloadItem.SavePageFormat) -> None: ...
    def state(self) -> QWebEngineDownloadItem.DownloadState: ...
    def suggestedFileName(self) -> str: ...
    def totalBytes(self) -> int: ...
    def type(self) -> QWebEngineDownloadItem.DownloadType: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QWebEngineFullScreenRequest(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def accept(self) -> None: ...
    def origin(self) -> PySide2.QtCore.QUrl: ...
    def reject(self) -> None: ...
    def toggleOn(self) -> bool: ...

class QWebEngineHistory(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def back(self) -> None: ...
    def backItem(self) -> QWebEngineHistoryItem: ...
    def backItems(self, maxItems: int) -> typing.List[QWebEngineHistoryItem]: ...
    def canGoBack(self) -> bool: ...
    def canGoForward(self) -> bool: ...
    def clear(self) -> None: ...
    def count(self) -> int: ...
    def currentItem(self) -> QWebEngineHistoryItem: ...
    def currentItemIndex(self) -> int: ...
    def forward(self) -> None: ...
    def forwardItem(self) -> QWebEngineHistoryItem: ...
    def forwardItems(self, maxItems: int) -> typing.List[QWebEngineHistoryItem]: ...
    def goToItem(self, item: QWebEngineHistoryItem) -> None: ...
    def itemAt(self, i: int) -> QWebEngineHistoryItem: ...
    def items(self) -> typing.List[QWebEngineHistoryItem]: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QWebEngineHistoryItem(shiboken2.Object):
    def __init__(self, other: QWebEngineHistoryItem) -> None: ...
    def iconUrl(self) -> PySide2.QtCore.QUrl: ...
    def isValid(self) -> bool: ...
    def lastVisited(self) -> PySide2.QtCore.QDateTime: ...
    def originalUrl(self) -> PySide2.QtCore.QUrl: ...
    def swap(self, other: QWebEngineHistoryItem) -> None: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...

class QWebEnginePage(PySide2.QtCore.QObject):
    class Feature:
        DesktopAudioVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
        DesktopVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
        Geolocation: typing.ClassVar[QWebEnginePage.Feature] = ...
        MediaAudioCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
        MediaAudioVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
        MediaVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
        MouseLock: typing.ClassVar[QWebEnginePage.Feature] = ...
        Notifications: typing.ClassVar[QWebEnginePage.Feature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.Feature: ...

    class FileSelectionMode:
        FileSelectOpen: typing.ClassVar[QWebEnginePage.FileSelectionMode] = ...
        FileSelectOpenMultiple: typing.ClassVar[QWebEnginePage.FileSelectionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.FileSelectionMode: ...

    class FindFlag:
        FindBackward: typing.ClassVar[QWebEnginePage.FindFlag] = ...
        FindCaseSensitively: typing.ClassVar[QWebEnginePage.FindFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEnginePage.FindFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...

    class FindFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEnginePage.FindFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.FindFlags: ...

    class JavaScriptConsoleMessageLevel:
        ErrorMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
        InfoMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
        WarningMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.JavaScriptConsoleMessageLevel: ...

    class LifecycleState:
        Active: typing.ClassVar[QWebEnginePage.LifecycleState] = ...
        Discarded: typing.ClassVar[QWebEnginePage.LifecycleState] = ...
        Frozen: typing.ClassVar[QWebEnginePage.LifecycleState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.LifecycleState: ...

    class NavigationType:
        NavigationTypeBackForward: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeFormSubmitted: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeLinkClicked: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeOther: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeRedirect: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeReload: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        NavigationTypeTyped: typing.ClassVar[QWebEnginePage.NavigationType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.NavigationType: ...

    class PermissionPolicy:
        PermissionDeniedByUser: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
        PermissionGrantedByUser: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
        PermissionUnknown: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.PermissionPolicy: ...

    class RenderProcessTerminationStatus:
        AbnormalTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
        CrashedTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
        KilledTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
        NormalTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.RenderProcessTerminationStatus: ...

    class WebAction:
        AlignCenter: typing.ClassVar[QWebEnginePage.WebAction] = ...
        AlignJustified: typing.ClassVar[QWebEnginePage.WebAction] = ...
        AlignLeft: typing.ClassVar[QWebEnginePage.WebAction] = ...
        AlignRight: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Back: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Copy: typing.ClassVar[QWebEnginePage.WebAction] = ...
        CopyImageToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
        CopyImageUrlToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
        CopyLinkToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
        CopyMediaUrlToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Cut: typing.ClassVar[QWebEnginePage.WebAction] = ...
        DownloadImageToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
        DownloadLinkToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
        DownloadMediaToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ExitFullScreen: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Forward: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Indent: typing.ClassVar[QWebEnginePage.WebAction] = ...
        InsertOrderedList: typing.ClassVar[QWebEnginePage.WebAction] = ...
        InsertUnorderedList: typing.ClassVar[QWebEnginePage.WebAction] = ...
        InspectElement: typing.ClassVar[QWebEnginePage.WebAction] = ...
        NoWebAction: typing.ClassVar[QWebEnginePage.WebAction] = ...
        OpenLinkInNewBackgroundTab: typing.ClassVar[QWebEnginePage.WebAction] = ...
        OpenLinkInNewTab: typing.ClassVar[QWebEnginePage.WebAction] = ...
        OpenLinkInNewWindow: typing.ClassVar[QWebEnginePage.WebAction] = ...
        OpenLinkInThisWindow: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Outdent: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Paste: typing.ClassVar[QWebEnginePage.WebAction] = ...
        PasteAndMatchStyle: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Redo: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Reload: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ReloadAndBypassCache: typing.ClassVar[QWebEnginePage.WebAction] = ...
        RequestClose: typing.ClassVar[QWebEnginePage.WebAction] = ...
        SavePage: typing.ClassVar[QWebEnginePage.WebAction] = ...
        SelectAll: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Stop: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleBold: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleItalic: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleMediaControls: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleMediaLoop: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleMediaMute: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleMediaPlayPause: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleStrikethrough: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ToggleUnderline: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Undo: typing.ClassVar[QWebEnginePage.WebAction] = ...
        Unselect: typing.ClassVar[QWebEnginePage.WebAction] = ...
        ViewSource: typing.ClassVar[QWebEnginePage.WebAction] = ...
        WebActionCount: typing.ClassVar[QWebEnginePage.WebAction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.WebAction: ...

    class WebWindowType:
        WebBrowserBackgroundTab: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
        WebBrowserTab: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
        WebBrowserWindow: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
        WebDialog: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEnginePage.WebWindowType: ...
    AbnormalTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
    AlignCenter: typing.ClassVar[QWebEnginePage.WebAction] = ...
    AlignJustified: typing.ClassVar[QWebEnginePage.WebAction] = ...
    AlignLeft: typing.ClassVar[QWebEnginePage.WebAction] = ...
    AlignRight: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Back: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Copy: typing.ClassVar[QWebEnginePage.WebAction] = ...
    CopyImageToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
    CopyImageUrlToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
    CopyLinkToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
    CopyMediaUrlToClipboard: typing.ClassVar[QWebEnginePage.WebAction] = ...
    CrashedTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
    Cut: typing.ClassVar[QWebEnginePage.WebAction] = ...
    DesktopAudioVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
    DesktopVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
    DownloadImageToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
    DownloadLinkToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
    DownloadMediaToDisk: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ErrorMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
    ExitFullScreen: typing.ClassVar[QWebEnginePage.WebAction] = ...
    FileSelectOpen: typing.ClassVar[QWebEnginePage.FileSelectionMode] = ...
    FileSelectOpenMultiple: typing.ClassVar[QWebEnginePage.FileSelectionMode] = ...
    FindBackward: typing.ClassVar[QWebEnginePage.FindFlag] = ...
    FindCaseSensitively: typing.ClassVar[QWebEnginePage.FindFlag] = ...
    Forward: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Geolocation: typing.ClassVar[QWebEnginePage.Feature] = ...
    Indent: typing.ClassVar[QWebEnginePage.WebAction] = ...
    InfoMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
    InsertOrderedList: typing.ClassVar[QWebEnginePage.WebAction] = ...
    InsertUnorderedList: typing.ClassVar[QWebEnginePage.WebAction] = ...
    InspectElement: typing.ClassVar[QWebEnginePage.WebAction] = ...
    KilledTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
    MediaAudioCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
    MediaAudioVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
    MediaVideoCapture: typing.ClassVar[QWebEnginePage.Feature] = ...
    MouseLock: typing.ClassVar[QWebEnginePage.Feature] = ...
    NavigationTypeBackForward: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeFormSubmitted: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeLinkClicked: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeOther: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeRedirect: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeReload: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NavigationTypeTyped: typing.ClassVar[QWebEnginePage.NavigationType] = ...
    NoWebAction: typing.ClassVar[QWebEnginePage.WebAction] = ...
    NormalTerminationStatus: typing.ClassVar[QWebEnginePage.RenderProcessTerminationStatus] = ...
    Notifications: typing.ClassVar[QWebEnginePage.Feature] = ...
    OpenLinkInNewBackgroundTab: typing.ClassVar[QWebEnginePage.WebAction] = ...
    OpenLinkInNewTab: typing.ClassVar[QWebEnginePage.WebAction] = ...
    OpenLinkInNewWindow: typing.ClassVar[QWebEnginePage.WebAction] = ...
    OpenLinkInThisWindow: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Outdent: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Paste: typing.ClassVar[QWebEnginePage.WebAction] = ...
    PasteAndMatchStyle: typing.ClassVar[QWebEnginePage.WebAction] = ...
    PermissionDeniedByUser: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
    PermissionGrantedByUser: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
    PermissionUnknown: typing.ClassVar[QWebEnginePage.PermissionPolicy] = ...
    Redo: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Reload: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ReloadAndBypassCache: typing.ClassVar[QWebEnginePage.WebAction] = ...
    RequestClose: typing.ClassVar[QWebEnginePage.WebAction] = ...
    SavePage: typing.ClassVar[QWebEnginePage.WebAction] = ...
    SelectAll: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Stop: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleBold: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleItalic: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleMediaControls: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleMediaLoop: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleMediaMute: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleMediaPlayPause: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleStrikethrough: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ToggleUnderline: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Undo: typing.ClassVar[QWebEnginePage.WebAction] = ...
    Unselect: typing.ClassVar[QWebEnginePage.WebAction] = ...
    ViewSource: typing.ClassVar[QWebEnginePage.WebAction] = ...
    WarningMessageLevel: typing.ClassVar[QWebEnginePage.JavaScriptConsoleMessageLevel] = ...
    WebActionCount: typing.ClassVar[QWebEnginePage.WebAction] = ...
    WebBrowserBackgroundTab: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
    WebBrowserTab: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
    WebBrowserWindow: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
    WebDialog: typing.ClassVar[QWebEnginePage.WebWindowType] = ...
    audioMutedChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    authenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    featurePermissionRequestCanceled: typing.ClassVar[PySide2.QtCore.Signal] = ...
    featurePermissionRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    findTextFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fullScreenRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    geometryChangeRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    iconChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    iconUrlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    lifecycleStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linkHovered: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadProgress: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    pdfPrintingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    printRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    proxyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    quotaRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    recentlyAudibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    recommendedStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    registerProtocolHandlerRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    renderProcessPidChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    renderProcessTerminated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    scrollPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectClientCertificate: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    titleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    urlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    windowCloseRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, profile: QWebEngineProfile, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., audioMuted: bool = ..., audioMutedChanged: typing.Callable = ..., authenticationRequired: typing.Callable = ..., backgroundColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., contentsSize: PySide2.QtCore.QSizeF = ..., contentsSizeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., featurePermissionRequestCanceled: typing.Callable = ..., featurePermissionRequested: typing.Callable = ..., findTextFinished: typing.Callable = ..., fullScreenRequested: typing.Callable = ..., geometryChangeRequested: typing.Callable = ..., hasSelection: bool = ..., icon: PySide2.QtGui.QIcon = ..., iconChanged: typing.Callable = ..., iconUrl: PySide2.QtCore.QUrl = ..., iconUrlChanged: typing.Callable = ..., lifecycleState: QWebEnginePage.LifecycleState = ..., lifecycleStateChanged: typing.Callable = ..., linkHovered: typing.Callable = ..., loadFinished: typing.Callable = ..., loadProgress: typing.Callable = ..., loadStarted: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pdfPrintingFinished: typing.Callable = ..., printRequested: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., quotaRequested: typing.Callable = ..., recentlyAudible: bool = ..., recentlyAudibleChanged: typing.Callable = ..., recommendedState: QWebEnginePage.LifecycleState = ..., recommendedStateChanged: typing.Callable = ..., registerProtocolHandlerRequested: typing.Callable = ..., renderProcessPid: int = ..., renderProcessPidChanged: typing.Callable = ..., renderProcessTerminated: typing.Callable = ..., requestedUrl: PySide2.QtCore.QUrl = ..., scrollPosition: PySide2.QtCore.QPointF = ..., scrollPositionChanged: typing.Callable = ..., selectClientCertificate: typing.Callable = ..., selectedText: str = ..., selectionChanged: typing.Callable = ..., title: str = ..., titleChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ..., urlChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., windowCloseRequested: typing.Callable = ..., zoomFactor: float = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., audioMuted: bool = ..., audioMutedChanged: typing.Callable = ..., authenticationRequired: typing.Callable = ..., backgroundColor: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int] = ..., contentsSize: PySide2.QtCore.QSizeF = ..., contentsSizeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., featurePermissionRequestCanceled: typing.Callable = ..., featurePermissionRequested: typing.Callable = ..., findTextFinished: typing.Callable = ..., fullScreenRequested: typing.Callable = ..., geometryChangeRequested: typing.Callable = ..., hasSelection: bool = ..., icon: PySide2.QtGui.QIcon = ..., iconChanged: typing.Callable = ..., iconUrl: PySide2.QtCore.QUrl = ..., iconUrlChanged: typing.Callable = ..., lifecycleState: QWebEnginePage.LifecycleState = ..., lifecycleStateChanged: typing.Callable = ..., linkHovered: typing.Callable = ..., loadFinished: typing.Callable = ..., loadProgress: typing.Callable = ..., loadStarted: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pdfPrintingFinished: typing.Callable = ..., printRequested: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., quotaRequested: typing.Callable = ..., recentlyAudible: bool = ..., recentlyAudibleChanged: typing.Callable = ..., recommendedState: QWebEnginePage.LifecycleState = ..., recommendedStateChanged: typing.Callable = ..., registerProtocolHandlerRequested: typing.Callable = ..., renderProcessPid: int = ..., renderProcessPidChanged: typing.Callable = ..., renderProcessTerminated: typing.Callable = ..., requestedUrl: PySide2.QtCore.QUrl = ..., scrollPosition: PySide2.QtCore.QPointF = ..., scrollPositionChanged: typing.Callable = ..., selectClientCertificate: typing.Callable = ..., selectedText: str = ..., selectionChanged: typing.Callable = ..., title: str = ..., titleChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ..., urlChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., windowCloseRequested: typing.Callable = ..., zoomFactor: float = ...) -> None: ...
    def acceptNavigationRequest(self, url: PySide2.QtCore.QUrl, type: QWebEnginePage.NavigationType, isMainFrame: bool) -> bool: ...
    def action(self, action: QWebEnginePage.WebAction) -> PySide2.QtWidgets.QAction: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def certificateError(self, certificateError: QWebEngineCertificateError) -> bool: ...
    def chooseFiles(self, mode: QWebEnginePage.FileSelectionMode, oldFiles: typing.Iterable[str], acceptedMimeTypes: typing.Iterable[str]) -> typing.List[str]: ...
    def contentsSize(self) -> PySide2.QtCore.QSizeF: ...
    def contextMenuData(self) -> QWebEngineContextMenuData: ...
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def createWindow(self, type: QWebEnginePage.WebWindowType) -> QWebEnginePage: ...
    def devToolsPage(self) -> QWebEnginePage: ...
    def download(self, url: PySide2.QtCore.QUrl, filename: str = ...) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    def findText(self, arg__1: str, arg__2: typing.Union[QWebEnginePage.FindFlags,QWebEnginePage.FindFlag], arg__3: object) -> None: ...
    @overload
    def findText(self, subString: str, options: typing.Union[QWebEnginePage.FindFlags,QWebEnginePage.FindFlag] = ...) -> None: ...
    def hasSelection(self) -> bool: ...
    def history(self) -> QWebEngineHistory: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconUrl(self) -> PySide2.QtCore.QUrl: ...
    def inspectedPage(self) -> QWebEnginePage: ...
    def isAudioMuted(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def javaScriptAlert(self, securityOrigin: PySide2.QtCore.QUrl, msg: str) -> None: ...
    def javaScriptConfirm(self, securityOrigin: PySide2.QtCore.QUrl, msg: str) -> bool: ...
    def javaScriptConsoleMessage(self, level: QWebEnginePage.JavaScriptConsoleMessageLevel, message: str, lineNumber: int, sourceID: str) -> None: ...
    def javaScriptPrompt(self, securityOrigin: PySide2.QtCore.QUrl, msg: str, defaultValue: str) -> typing.Tuple[bool,str]: ...
    def lifecycleState(self) -> QWebEnginePage.LifecycleState: ...
    @overload
    def load(self, request: PySide2.QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    @overload
    def load(self, url: PySide2.QtCore.QUrl) -> None: ...
    def print(self, arg__1: PySide2.QtPrintSupport.QPrinter, arg__2: object) -> None: ...
    @overload
    def printToPdf(self, arg__1: object, arg__2: PySide2.QtGui.QPageLayout) -> None: ...
    @overload
    def printToPdf(self, filePath: str, layout: PySide2.QtGui.QPageLayout = ...) -> None: ...
    def profile(self) -> QWebEngineProfile: ...
    def recentlyAudible(self) -> bool: ...
    def recommendedState(self) -> QWebEnginePage.LifecycleState: ...
    def renderProcessPid(self) -> int: ...
    def replaceMisspelledWord(self, replacement: str) -> None: ...
    def requestedUrl(self) -> PySide2.QtCore.QUrl: ...
    @overload
    def runJavaScript(self, arg__1: str, arg__2: int, arg__3: object) -> None: ...
    @overload
    def runJavaScript(self, scriptSource: str, worldId: int) -> None: ...
    @overload
    def runJavaScript(self, scriptSource: str) -> None: ...
    def save(self, filePath: str, format: QWebEngineDownloadItem.SavePageFormat = ...) -> None: ...
    def scripts(self) -> QWebEngineScriptCollection: ...
    def scrollPosition(self) -> PySide2.QtCore.QPointF: ...
    def selectedText(self) -> str: ...
    def setAudioMuted(self, muted: bool) -> None: ...
    def setBackgroundColor(self, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setContent(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes], mimeType: str = ..., baseUrl: PySide2.QtCore.QUrl = ...) -> None: ...
    def setDevToolsPage(self, page: QWebEnginePage) -> None: ...
    def setFeaturePermission(self, securityOrigin: PySide2.QtCore.QUrl, feature: QWebEnginePage.Feature, policy: QWebEnginePage.PermissionPolicy) -> None: ...
    def setHtml(self, html: str, baseUrl: PySide2.QtCore.QUrl = ...) -> None: ...
    def setInspectedPage(self, page: QWebEnginePage) -> None: ...
    def setLifecycleState(self, state: QWebEnginePage.LifecycleState) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def setUrlRequestInterceptor(self, interceptor: PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor) -> None: ...
    def setView(self, view: PySide2.QtWidgets.QWidget) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @overload
    def setWebChannel(self, arg__1: PySide2.QtWebChannel.QWebChannel, worldId: int) -> None: ...
    @overload
    def setWebChannel(self, arg__1: PySide2.QtWebChannel.QWebChannel) -> None: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def settings(self) -> QWebEngineSettings: ...
    def title(self) -> str: ...
    def toHtml(self, arg__1: object) -> None: ...
    def toPlainText(self, arg__1: object) -> None: ...
    def triggerAction(self, action: QWebEnginePage.WebAction, checked: bool = ...) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def view(self) -> PySide2.QtWidgets.QWidget: ...
    def webChannel(self) -> PySide2.QtWebChannel.QWebChannel: ...
    def zoomFactor(self) -> float: ...

class QWebEngineProfile(PySide2.QtCore.QObject):
    class HttpCacheType:
        DiskHttpCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
        MemoryHttpCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
        NoCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineProfile.HttpCacheType: ...

    class PersistentCookiesPolicy:
        AllowPersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
        ForcePersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
        NoPersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineProfile.PersistentCookiesPolicy: ...
    AllowPersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
    DiskHttpCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
    ForcePersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
    MemoryHttpCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
    NoCache: typing.ClassVar[QWebEngineProfile.HttpCacheType] = ...
    NoPersistentCookies: typing.ClassVar[QWebEngineProfile.PersistentCookiesPolicy] = ...
    downloadRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, name: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., downloadRequested: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., downloadRequested: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cachePath(self) -> str: ...
    def clearAllVisitedLinks(self) -> None: ...
    def clearHttpCache(self) -> None: ...
    def clearVisitedLinks(self, urls: typing.Iterable[PySide2.QtCore.QUrl]) -> None: ...
    def cookieStore(self) -> PySide2.QtWebEngineCore.QWebEngineCookieStore: ...
    @classmethod
    def defaultProfile(cls) -> QWebEngineProfile: ...
    def downloadPath(self) -> str: ...
    def httpAcceptLanguage(self) -> str: ...
    def httpCacheMaximumSize(self) -> int: ...
    def httpCacheType(self) -> QWebEngineProfile.HttpCacheType: ...
    def httpUserAgent(self) -> str: ...
    def installUrlSchemeHandler(self, scheme: typing.Union[PySide2.QtCore.QByteArray,bytes], arg__2: PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler) -> None: ...
    def isOffTheRecord(self) -> bool: ...
    def isSpellCheckEnabled(self) -> bool: ...
    def isUsedForGlobalCertificateVerification(self) -> bool: ...
    def persistentCookiesPolicy(self) -> QWebEngineProfile.PersistentCookiesPolicy: ...
    def persistentStoragePath(self) -> str: ...
    def removeAllUrlSchemeHandlers(self) -> None: ...
    def removeUrlScheme(self, scheme: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def removeUrlSchemeHandler(self, arg__1: PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler) -> None: ...
    def scripts(self) -> QWebEngineScriptCollection: ...
    def setCachePath(self, path: str) -> None: ...
    def setDownloadPath(self, path: str) -> None: ...
    def setHttpAcceptLanguage(self, httpAcceptLanguage: str) -> None: ...
    def setHttpCacheMaximumSize(self, maxSize: int) -> None: ...
    def setHttpCacheType(self, arg__1: QWebEngineProfile.HttpCacheType) -> None: ...
    def setHttpUserAgent(self, userAgent: str) -> None: ...
    def setPersistentCookiesPolicy(self, arg__1: QWebEngineProfile.PersistentCookiesPolicy) -> None: ...
    def setPersistentStoragePath(self, path: str) -> None: ...
    def setRequestInterceptor(self, interceptor: PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor) -> None: ...
    def setSpellCheckEnabled(self, enabled: bool) -> None: ...
    def setSpellCheckLanguages(self, languages: typing.Iterable[str]) -> None: ...
    def setUrlRequestInterceptor(self, interceptor: PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor) -> None: ...
    def setUseForGlobalCertificateVerification(self, enabled: bool = ...) -> None: ...
    def settings(self) -> QWebEngineSettings: ...
    def spellCheckLanguages(self) -> typing.List[str]: ...
    def storageName(self) -> str: ...
    def urlSchemeHandler(self, arg__1: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> PySide2.QtWebEngineCore.QWebEngineUrlSchemeHandler: ...
    def visitedLinksContainsUrl(self, url: PySide2.QtCore.QUrl) -> bool: ...

class QWebEngineScript(shiboken2.Object):
    class InjectionPoint:
        Deferred: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
        DocumentCreation: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
        DocumentReady: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineScript.InjectionPoint: ...

    class ScriptWorldId:
        ApplicationWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
        MainWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
        UserWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineScript.ScriptWorldId: ...
    ApplicationWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
    Deferred: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
    DocumentCreation: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
    DocumentReady: typing.ClassVar[QWebEngineScript.InjectionPoint] = ...
    MainWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
    UserWorld: typing.ClassVar[QWebEngineScript.ScriptWorldId] = ...
    @overload
    def __init__(self, other: QWebEngineScript) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def injectionPoint(self) -> QWebEngineScript.InjectionPoint: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    def runsOnSubFrames(self) -> bool: ...
    def setInjectionPoint(self, arg__1: QWebEngineScript.InjectionPoint) -> None: ...
    def setName(self, arg__1: str) -> None: ...
    def setRunsOnSubFrames(self, on: bool) -> None: ...
    def setSourceCode(self, arg__1: str) -> None: ...
    def setWorldId(self, arg__1: int) -> None: ...
    def sourceCode(self) -> str: ...
    def swap(self, other: QWebEngineScript) -> None: ...
    def worldId(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QWebEngineScriptCollection(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def clear(self) -> None: ...
    def contains(self, value: QWebEngineScript) -> bool: ...
    def count(self) -> int: ...
    def findScript(self, name: str) -> QWebEngineScript: ...
    def findScripts(self, name: str) -> typing.List[QWebEngineScript]: ...
    @overload
    def insert(self, arg__1: QWebEngineScript) -> None: ...
    @overload
    def insert(self, list: typing.Iterable[QWebEngineScript]) -> None: ...
    def isEmpty(self) -> bool: ...
    def remove(self, arg__1: QWebEngineScript) -> bool: ...
    def size(self) -> int: ...
    def toList(self) -> typing.List[QWebEngineScript]: ...

class QWebEngineSettings(shiboken2.Object):
    class FontFamily:
        CursiveFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        FantasyFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        FixedFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        PictographFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        SansSerifFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        SerifFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        StandardFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontFamily: ...

    class FontSize:
        DefaultFixedFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
        DefaultFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
        MinimumFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
        MinimumLogicalFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineSettings.FontSize: ...

    class UnknownUrlSchemePolicy:
        AllowAllUnknownUrlSchemes: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
        AllowUnknownUrlSchemesFromUserInteraction: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
        DisallowUnknownUrlSchemes: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...

    class WebAttribute:
        Accelerated2dCanvasEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        AllowGeolocationOnInsecureOrigins: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        AllowRunningInsecureContent: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        AllowWindowActivationFromJavaScript: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        AutoLoadIconsForPage: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        AutoLoadImages: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        DnsPrefetchEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        ErrorPageEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        FocusOnNavigationEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        FullScreenSupportEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        HyperlinkAuditingEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        JavascriptCanAccessClipboard: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        JavascriptCanOpenWindows: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        JavascriptCanPaste: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        JavascriptEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        LinksIncludedInFocusChain: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        LocalContentCanAccessFileUrls: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        LocalContentCanAccessRemoteUrls: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        LocalStorageEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        PdfViewerEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        PlaybackRequiresUserGesture: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        PluginsEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        PrintElementBackgrounds: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        ScreenCaptureEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        ScrollAnimatorEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        ShowScrollBars: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        SpatialNavigationEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        TouchIconsEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        WebGLEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        WebRTCPublicInterfacesOnly: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        XSSAuditingEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineSettings.WebAttribute: ...
    Accelerated2dCanvasEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    AllowAllUnknownUrlSchemes: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
    AllowGeolocationOnInsecureOrigins: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    AllowRunningInsecureContent: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    AllowUnknownUrlSchemesFromUserInteraction: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
    AllowWindowActivationFromJavaScript: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    AutoLoadIconsForPage: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    AutoLoadImages: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    CursiveFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    DefaultFixedFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
    DefaultFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
    DisallowUnknownUrlSchemes: typing.ClassVar[QWebEngineSettings.UnknownUrlSchemePolicy] = ...
    DnsPrefetchEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    ErrorPageEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    FantasyFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    FixedFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    FocusOnNavigationEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    FullScreenSupportEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    HyperlinkAuditingEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    JavascriptCanAccessClipboard: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    JavascriptCanOpenWindows: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    JavascriptCanPaste: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    JavascriptEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    LinksIncludedInFocusChain: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    LocalContentCanAccessFileUrls: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    LocalContentCanAccessRemoteUrls: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    LocalStorageEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    MinimumFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
    MinimumLogicalFontSize: typing.ClassVar[QWebEngineSettings.FontSize] = ...
    PdfViewerEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    PictographFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    PlaybackRequiresUserGesture: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    PluginsEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    PrintElementBackgrounds: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    SansSerifFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    ScreenCaptureEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    ScrollAnimatorEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    SerifFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    ShowScrollBars: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    SpatialNavigationEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    StandardFont: typing.ClassVar[QWebEngineSettings.FontFamily] = ...
    TouchIconsEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    WebGLEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    WebRTCPublicInterfacesOnly: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    XSSAuditingEnabled: typing.ClassVar[QWebEngineSettings.WebAttribute] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def defaultSettings(cls) -> QWebEngineSettings: ...
    def defaultTextEncoding(self) -> str: ...
    def fontFamily(self, which: QWebEngineSettings.FontFamily) -> str: ...
    def fontSize(self, type: QWebEngineSettings.FontSize) -> int: ...
    @classmethod
    def globalSettings(cls) -> QWebEngineSettings: ...
    def resetAttribute(self, attr: QWebEngineSettings.WebAttribute) -> None: ...
    def resetFontFamily(self, which: QWebEngineSettings.FontFamily) -> None: ...
    def resetFontSize(self, type: QWebEngineSettings.FontSize) -> None: ...
    def resetUnknownUrlSchemePolicy(self) -> None: ...
    def setAttribute(self, attr: QWebEngineSettings.WebAttribute, on: bool) -> None: ...
    def setDefaultTextEncoding(self, encoding: str) -> None: ...
    def setFontFamily(self, which: QWebEngineSettings.FontFamily, family: str) -> None: ...
    def setFontSize(self, type: QWebEngineSettings.FontSize, size: int) -> None: ...
    def setUnknownUrlSchemePolicy(self, policy: QWebEngineSettings.UnknownUrlSchemePolicy) -> None: ...
    def testAttribute(self, attr: QWebEngineSettings.WebAttribute) -> bool: ...
    def unknownUrlSchemePolicy(self) -> QWebEngineSettings.UnknownUrlSchemePolicy: ...

class QWebEngineView(PySide2.QtWidgets.QWidget):
    iconChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    iconUrlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadProgress: typing.ClassVar[PySide2.QtCore.Signal] = ...
    loadStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    renderProcessTerminated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    titleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    urlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., hasSelection: bool = ..., height: int = ..., icon: PySide2.QtGui.QIcon = ..., iconChanged: typing.Callable = ..., iconUrl: PySide2.QtCore.QUrl = ..., iconUrlChanged: typing.Callable = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., loadFinished: typing.Callable = ..., loadProgress: typing.Callable = ..., loadStarted: typing.Callable = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., renderProcessTerminated: typing.Callable = ..., selectedText: str = ..., selectionChanged: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., title: str = ..., titleChanged: typing.Callable = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., url: PySide2.QtCore.QUrl = ..., urlChanged: typing.Callable = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ..., zoomFactor: float = ...) -> None: ...
    def back(self) -> None: ...
    def closeEvent(self, arg__1: PySide2.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None: ...
    def createWindow(self, type: QWebEnginePage.WebWindowType) -> QWebEngineView: ...
    def dragEnterEvent(self, e: PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @overload
    def findText(self, arg__1: str, arg__2: typing.Union[QWebEnginePage.FindFlags,QWebEnginePage.FindFlag], arg__3: object) -> None: ...
    @overload
    def findText(self, subString: str, options: typing.Union[QWebEnginePage.FindFlags,QWebEnginePage.FindFlag] = ...) -> None: ...
    def forward(self) -> None: ...
    def hasSelection(self) -> bool: ...
    def hideEvent(self, arg__1: PySide2.QtGui.QHideEvent) -> None: ...
    def history(self) -> QWebEngineHistory: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconUrl(self) -> PySide2.QtCore.QUrl: ...
    @overload
    def load(self, request: PySide2.QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    @overload
    def load(self, url: PySide2.QtCore.QUrl) -> None: ...
    def page(self) -> QWebEnginePage: ...
    def pageAction(self, action: QWebEnginePage.WebAction) -> PySide2.QtWidgets.QAction: ...
    def reload(self) -> None: ...
    def selectedText(self) -> str: ...
    def setContent(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes], mimeType: str = ..., baseUrl: PySide2.QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str, baseUrl: PySide2.QtCore.QUrl = ...) -> None: ...
    def setPage(self, page: QWebEnginePage) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def settings(self) -> QWebEngineSettings: ...
    def showEvent(self, arg__1: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stop(self) -> None: ...
    def title(self) -> str: ...
    def triggerPageAction(self, action: QWebEnginePage.WebAction, checked: bool = ...) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def zoomFactor(self) -> float: ...
