from PySide2.QtGui import QIcon

from typing import Optional

from PySide2.QtWidgets import QDialog
from axipy import ActionButton, Position, Plugin, view_manager

from .export_to_file_dialog import ExportToFileDialog


class ExportToFile(Plugin):

    def __init__(self) -> None:
        self._dialog: Optional[QDialog] = None
        self._button = ActionButton(
            title=self.tr("Экспорт\nтаблиц"),
            on_click=self.on_click,
            icon=QIcon.fromTheme("table_save_copy_as"),
        )
        position = Position(self.tr("Основные"), self.tr("Команды"))
        position.add(self._button)

    def unload(self) -> None:
        self._button.remove()
        if self._dialog is not None:
            self._dialog.deleteLater()

    def on_click(self) -> None:
        if self._dialog is None:
            self._dialog = ExportToFileDialog(self, parent=view_manager.global_parent)
        self._dialog.open()
