"""Модуль низкоуровневого доступа к SQL.

Предоставляет доступ к таблицам через классы и методы стандартного модуля Qt
:mod:`PySide2.QtSql`.
"""

from PySide2.QtSql import QSqlDatabase


__all__ = [
    "get_database",
    "geometry_uid",
    "style_uid"
]


def get_database() -> QSqlDatabase:
    """Возвращает объект базы данных.

    Все таблицы каталога :attr:`axipy.data_manager`
    представляются в виде базы данных.

.. code-block:: python

    q = QSqlQuery(get_database())
    q.exec_(f'SELECT AsBinary(FromAxiGeo({geometry_uid})) FROM {table.name}')
    while q.next():
        binary = q.value(0)
        ...
    """
    from axipy.gui import gui_instance
    return gui_instance.database()


geometry_uid = 'cd750f8a9a2b4fac9b9b05eb53795d97'
"""Уникальный идентификатор поля Геометрия.

.. code-block:: python

    query.exec_('SELECT AsBinary(FromAxiGeo({})) as "+geometry", {} as "+style" FROM {}'
            .format(geometry_uid, style_uid, table_name))
"""

style_uid = 'd39f65c319974aa198a899a89b1240c7'
"""Уникальный идентификатор поля Стиль."""
