"""
Модуль систем координат.

В данном модуле содержатся классы и методы, предназначенные для удобной работы с координатными системами.
"""

from .unit import *
from .coord_system import *  # depends on unit
from .coord_transformer import *  # depends on coord_system


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "CoordSystem": coord_system,
        "CoordTransformer": coord_transformer,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
