import logging
from pathlib import Path

from typing import Optional

__all__ = [
    'Dependencies',
]


class Dependencies:
    def __init__(self, requirements_file: Path):
        self._requirements_file = requirements_file

    @property
    def requirements(self) -> Path:
        """File with requirements."""
        return self._requirements_file

    def packages(self):
        # split process by packages
        deps_file = open(str(self.requirements), 'r')
        data = deps_file.read()
        deps_file.close()
        return Dependencies._to_list(data)

    @staticmethod
    def _to_list(data):
        list_filter = filter(None, data.split("\n"))
        return list(list_filter)

    @staticmethod
    def find(plugin_dir: Path) -> Optional['Dependencies']:
        """Finds dependencies in a plugin."""
        requirements_file = plugin_dir / 'requirements.txt'
        logging.debug(f'Check file with deps: {requirements_file}')
        if not requirements_file.is_file():
            return None
        return Dependencies(requirements_file)
