from collections.abc import Mapping, MutableMapping
from typing import List, Tuple, Any


class _MappingExtended(Mapping):
    """
    Класс является статическим словарем, доступным только для чтения (:class:`collections.abc.Mapping`).
    Поддерживает обращение по индексу.
    """

    def __repr__(self) -> str:
        return repr(self.items())

    def get(self, key: str, default=None) -> Any:
        """Возвращает значение по ключу."""
        return super().get(key, default)

    def keys(self) -> List[str]:
        """Возвращает список ключей."""
        return list(super().keys())

    def values(self) -> List[Any]:
        """Возвращает список значений."""
        return list(super().values())

    def items(self) -> List[Tuple[str, Any]]:
        """Возвращает список кортежей ключ-значение."""
        return list(super().items())


class _MutableMappingExtended(MutableMapping, _MappingExtended):
    ...
