import axipy
from axipy._internal._decorator import _deprecated_by
from axipy._internal._shadow_instance_factory import _shadow_manager
from typing import Type


def _MainWindow_apply_deprecated(class_type: Type) -> Type:
    # hide deprecated methods from IntelliSense

    @_deprecated_by("axipy.Workspace.load_file")
    def load_workspace(self, fileName: str) -> None:
        """
        Читает рабочее пространство из файла.

        Args:
            self:
            fileName: Наименование входного файла.

        :meta private:
        """
        self.service().open_workspace(fileName)

    setattr(class_type, "load_workspace", load_workspace)

    @_deprecated_by("axipy.Workspace.save_file")
    def save_workspace(self, fileName: str) -> None:
        """Сохраняет рабочее пространство в файл.

        Args:
            self:
            fileName: Наименование выходного файла.

        :meta private:
        """

        self.service().save_workspace(fileName)

    setattr(class_type, "save_workspace", save_workspace)

    return class_type


def _apply_deprecated_methods() -> None:

    @property
    @_deprecated_by("axipy.CurrentSettings.Language")
    def language(self) -> str:
        """
        Значение языка, с которым запущено приложение. Например, ``'ru'``.

        :meta private:
        """
        return _shadow_manager.core.translationLanguage()

    setattr(axipy.Plugin, "language", language)

    def as_string(self, delimiter: str = None, precision: int = None, suppress_trailing_zeros: bool = False) -> str:
        """
        Получение строкового значения угловой координаты.

        Args:
            delimiter:  Разделитель. Например, ``'-'`` или ``'/'``.
            precision: Количество знаков после запятой. Если None, округление не производится.
            suppress_trailing_zeros: Признак удаления завершающих нулей.
        """
        if precision is None:
            precision = -1

        if delimiter and isinstance(delimiter, str):
            return self._reader.as_string_with_delimeter(self._value, delimiter, precision, suppress_trailing_zeros)
        else:
            return self._reader.as_string(self._value, precision, suppress_trailing_zeros)

    def as_rumb(self, precision: int = None, suppress_trailing_zeros: bool = False) -> str:
        """
        Получение строкового значения угловой координаты в формате румбов.

        Args:
            precision: Количество знаков после запятой. Если None, округление не производится.
            suppress_trailing_zeros: Признак удаления завершающих нулей.
        """
        if precision is None:
            precision = -1
        return self._reader.double_to_rumb(self._value, precision, suppress_trailing_zeros)

    setattr(axipy.AngleCoord, "as_string", as_string)
    setattr(axipy.AngleCoord, "as_rumb", as_rumb)

    @_deprecated_by("rollback")
    def restore(self) -> None:
        self.rollback()

    setattr(axipy.Table, "restore", restore)
