from typing import overload
import PySide2.QtCore
import PySide2.QtNetwork
import shiboken2
import typing
T = typing.TypeVar('T')

class ListProperty(PySide2.QtCore.Property):
    def __init__(self, type: type, append: typing.Callable, at: typing.Union[typing.Callable,None] = ..., clear: typing.Union[typing.Callable,None] = ..., count: typing.Union[typing.Callable,None] = ...) -> None: ...

class QJSEngine(PySide2.QtCore.QObject):
    class Extension:
        AllExtensions: typing.ClassVar[QJSEngine.Extension] = ...
        ConsoleExtension: typing.ClassVar[QJSEngine.Extension] = ...
        GarbageCollectionExtension: typing.ClassVar[QJSEngine.Extension] = ...
        TranslationExtension: typing.ClassVar[QJSEngine.Extension] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QJSEngine.Extensions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __rand__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __ror__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __xor__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...

    class Extensions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QJSEngine.Extensions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __rand__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __ror__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
        def __xor__(self, other: typing.SupportsInt) -> QJSEngine.Extensions: ...
    AllExtensions: typing.ClassVar[QJSEngine.Extension] = ...
    ConsoleExtension: typing.ClassVar[QJSEngine.Extension] = ...
    GarbageCollectionExtension: typing.ClassVar[QJSEngine.Extension] = ...
    TranslationExtension: typing.ClassVar[QJSEngine.Extension] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    uiLanguageChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ...) -> None: ...
    def collectGarbage(self) -> None: ...
    def evaluate(self, program: str, fileName: str = ..., lineNumber: int = ...) -> QJSValue: ...
    def globalObject(self) -> QJSValue: ...
    def importModule(self, fileName: str) -> QJSValue: ...
    def installExtensions(self, extensions: typing.Union[QJSEngine.Extensions,QJSEngine.Extension], object: QJSValue = ...) -> None: ...
    def installTranslatorFunctions(self, object: QJSValue = ...) -> None: ...
    def isInterrupted(self) -> bool: ...
    def newArray(self, length: int = ...) -> QJSValue: ...
    def newErrorObject(self, errorType: QJSValue.ErrorType, message: str = ...) -> QJSValue: ...
    def newObject(self) -> QJSValue: ...
    def newQMetaObject(self, metaObject: PySide2.QtCore.QMetaObject) -> QJSValue: ...
    def newQObject(self, object: PySide2.QtCore.QObject) -> QJSValue: ...
    def setInterrupted(self, interrupted: bool) -> None: ...
    def setUiLanguage(self, language: str) -> None: ...
    @overload
    def throwError(self, errorType: QJSValue.ErrorType, message: str = ...) -> None: ...
    @overload
    def throwError(self, message: str) -> None: ...
    def toScriptValue(self, arg__1: typing.Any) -> QJSValue: ...
    def uiLanguage(self) -> str: ...

class QJSValue(shiboken2.Object):
    class ErrorType:
        EvalError: typing.ClassVar[QJSValue.ErrorType] = ...
        GenericError: typing.ClassVar[QJSValue.ErrorType] = ...
        NoError: typing.ClassVar[QJSValue.ErrorType] = ...
        RangeError: typing.ClassVar[QJSValue.ErrorType] = ...
        ReferenceError: typing.ClassVar[QJSValue.ErrorType] = ...
        SyntaxError: typing.ClassVar[QJSValue.ErrorType] = ...
        TypeError: typing.ClassVar[QJSValue.ErrorType] = ...
        URIError: typing.ClassVar[QJSValue.ErrorType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __and__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __rand__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __ror__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __sub__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...
        def __xor__(self, other: typing.SupportsInt) -> QJSValue.ErrorType: ...

    class SpecialValue:
        NullValue: typing.ClassVar[QJSValue.SpecialValue] = ...
        UndefinedValue: typing.ClassVar[QJSValue.SpecialValue] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __and__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __rand__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __ror__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __sub__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
        def __xor__(self, other: typing.SupportsInt) -> QJSValue.SpecialValue: ...
    EvalError: typing.ClassVar[QJSValue.ErrorType] = ...
    GenericError: typing.ClassVar[QJSValue.ErrorType] = ...
    NoError: typing.ClassVar[QJSValue.ErrorType] = ...
    NullValue: typing.ClassVar[QJSValue.SpecialValue] = ...
    RangeError: typing.ClassVar[QJSValue.ErrorType] = ...
    ReferenceError: typing.ClassVar[QJSValue.ErrorType] = ...
    SyntaxError: typing.ClassVar[QJSValue.ErrorType] = ...
    TypeError: typing.ClassVar[QJSValue.ErrorType] = ...
    URIError: typing.ClassVar[QJSValue.ErrorType] = ...
    UndefinedValue: typing.ClassVar[QJSValue.SpecialValue] = ...
    @overload
    def __init__(self, other: QJSValue) -> None: ...
    @overload
    def __init__(self, str: bytes) -> None: ...
    @overload
    def __init__(self, value: QJSValue.SpecialValue = ...) -> None: ...
    @overload
    def __init__(self, value: str) -> None: ...
    @overload
    def __init__(self, value: bool) -> None: ...
    @overload
    def __init__(self, value: float) -> None: ...
    @overload
    def __init__(self, value: int) -> None: ...
    def call(self, args: typing.Iterable[QJSValue] = ...) -> QJSValue: ...
    def callAsConstructor(self, args: typing.Iterable[QJSValue] = ...) -> QJSValue: ...
    def callWithInstance(self, instance: QJSValue, args: typing.Iterable[QJSValue] = ...) -> QJSValue: ...
    def deleteProperty(self, name: str) -> bool: ...
    def engine(self) -> QJSEngine: ...
    def equals(self, other: QJSValue) -> bool: ...
    def errorType(self) -> QJSValue.ErrorType: ...
    def hasOwnProperty(self, name: str) -> bool: ...
    def hasProperty(self, name: str) -> bool: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isCallable(self) -> bool: ...
    def isDate(self) -> bool: ...
    def isError(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isNumber(self) -> bool: ...
    def isObject(self) -> bool: ...
    def isQMetaObject(self) -> bool: ...
    def isQObject(self) -> bool: ...
    def isRegExp(self) -> bool: ...
    def isString(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isVariant(self) -> bool: ...
    @overload
    def property(self, arrayIndex: int) -> QJSValue: ...
    @overload
    def property(self, name: str) -> QJSValue: ...
    def prototype(self) -> QJSValue: ...
    @overload
    def setProperty(self, arrayIndex: int, value: QJSValue) -> None: ...
    @overload
    def setProperty(self, name: str, value: QJSValue) -> None: ...
    def setPrototype(self, prototype: QJSValue) -> None: ...
    def strictlyEquals(self, other: QJSValue) -> bool: ...
    def toBool(self) -> bool: ...
    def toDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def toInt(self) -> int: ...
    def toNumber(self) -> float: ...
    def toQMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
    def toQObject(self) -> PySide2.QtCore.QObject: ...
    def toString(self) -> str: ...
    def toUInt(self) -> int: ...
    def toVariant(self) -> typing.Any: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...

class QJSValueIterator(shiboken2.Object):
    def __init__(self, value: QJSValue) -> None: ...
    def hasNext(self) -> bool: ...
    def name(self) -> str: ...
    def next(self) -> bool: ...
    def value(self) -> QJSValue: ...

class QQmlAbstractUrlInterceptor(shiboken2.Object):
    class DataType:
        JavaScriptFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
        QmlFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
        QmldirFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
        UrlString: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlAbstractUrlInterceptor.DataType: ...
    JavaScriptFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
    QmlFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
    QmldirFile: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
    UrlString: typing.ClassVar[QQmlAbstractUrlInterceptor.DataType] = ...
    def __init__(self) -> None: ...
    def intercept(self, path: PySide2.QtCore.QUrl, type: QQmlAbstractUrlInterceptor.DataType) -> PySide2.QtCore.QUrl: ...

class QQmlApplicationEngine(QQmlEngine):
    objectCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, filePath: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., exit: typing.Callable = ..., objectCreated: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offlineStoragePath: str = ..., quit: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ..., warnings: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, url: PySide2.QtCore.QUrl, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., exit: typing.Callable = ..., objectCreated: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offlineStoragePath: str = ..., quit: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ..., warnings: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., exit: typing.Callable = ..., objectCreated: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offlineStoragePath: str = ..., quit: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ..., warnings: typing.Callable = ...) -> None: ...
    @overload
    def load(self, filePath: str) -> None: ...
    @overload
    def load(self, url: PySide2.QtCore.QUrl) -> None: ...
    def loadData(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes], url: PySide2.QtCore.QUrl = ...) -> None: ...
    def rootObjects(self) -> typing.List[PySide2.QtCore.QObject]: ...
    def setInitialProperties(self, initialProperties: typing.Dict[str,typing.Any]) -> None: ...

class QQmlComponent(PySide2.QtCore.QObject):
    class CompilationMode:
        Asynchronous: typing.ClassVar[QQmlComponent.CompilationMode] = ...
        PreferSynchronous: typing.ClassVar[QQmlComponent.CompilationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlComponent.CompilationMode: ...

    class Status:
        Error: typing.ClassVar[QQmlComponent.Status] = ...
        Loading: typing.ClassVar[QQmlComponent.Status] = ...
        Null: typing.ClassVar[QQmlComponent.Status] = ...
        Ready: typing.ClassVar[QQmlComponent.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlComponent.Status: ...
    Asynchronous: typing.ClassVar[QQmlComponent.CompilationMode] = ...
    Error: typing.ClassVar[QQmlComponent.Status] = ...
    Loading: typing.ClassVar[QQmlComponent.Status] = ...
    Null: typing.ClassVar[QQmlComponent.Status] = ...
    PreferSynchronous: typing.ClassVar[QQmlComponent.CompilationMode] = ...
    Ready: typing.ClassVar[QQmlComponent.Status] = ...
    progressChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, arg__1: QQmlEngine, fileName: str, mode: QQmlComponent.CompilationMode, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlEngine, url: PySide2.QtCore.QUrl, mode: QQmlComponent.CompilationMode, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlEngine, fileName: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlEngine, url: PySide2.QtCore.QUrl, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlEngine, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., progress: float = ..., progressChanged: typing.Callable = ..., status: QQmlComponent.Status = ..., statusChanged: typing.Callable = ..., url: PySide2.QtCore.QUrl = ...) -> None: ...
    def beginCreate(self, arg__1: QQmlContext) -> PySide2.QtCore.QObject: ...
    def completeCreate(self) -> None: ...
    @overload
    def create(self, arg__1: QQmlIncubator, context: typing.Union[QQmlContext,None] = ..., forContext: typing.Union[QQmlContext,None] = ...) -> None: ...
    @overload
    def create(self, context: typing.Union[QQmlContext,None] = ...) -> PySide2.QtCore.QObject: ...
    def createWithInitialProperties(self, initialProperties: typing.Dict[str,typing.Any], context: typing.Union[QQmlContext,None] = ...) -> PySide2.QtCore.QObject: ...
    def creationContext(self) -> QQmlContext: ...
    def engine(self) -> QQmlEngine: ...
    def errorString(self) -> str: ...
    def errors(self) -> typing.List[QQmlError]: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    @overload
    def loadUrl(self, url: PySide2.QtCore.QUrl, mode: QQmlComponent.CompilationMode) -> None: ...
    @overload
    def loadUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def progress(self) -> float: ...
    def setData(self, arg__1: typing.Union[PySide2.QtCore.QByteArray,bytes], baseUrl: PySide2.QtCore.QUrl) -> None: ...
    def setInitialProperties(self, component: PySide2.QtCore.QObject, properties: typing.Dict[str,typing.Any]) -> None: ...
    def status(self) -> QQmlComponent.Status: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __bool__(self) -> bool: ...

class QQmlContext(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: QQmlContext, objParent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: QQmlEngine, objParent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def contextObject(self) -> PySide2.QtCore.QObject: ...
    def contextProperty(self, arg__1: str) -> typing.Any: ...
    def engine(self) -> QQmlEngine: ...
    def isValid(self) -> bool: ...
    def nameForObject(self, arg__1: PySide2.QtCore.QObject) -> str: ...
    def parentContext(self) -> QQmlContext: ...
    def resolvedUrl(self, arg__1: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def setBaseUrl(self, arg__1: PySide2.QtCore.QUrl) -> None: ...
    def setContextObject(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    @overload
    def setContextProperty(self, arg__1: str, arg__2: PySide2.QtCore.QObject) -> None: ...
    @overload
    def setContextProperty(self, arg__1: str, arg__2: typing.Any) -> None: ...

class QQmlDebuggingEnabler(shiboken2.Object):
    class StartMode:
        DoNotWaitForClient: typing.ClassVar[QQmlDebuggingEnabler.StartMode] = ...
        WaitForClient: typing.ClassVar[QQmlDebuggingEnabler.StartMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlDebuggingEnabler.StartMode: ...
    DoNotWaitForClient: typing.ClassVar[QQmlDebuggingEnabler.StartMode] = ...
    WaitForClient: typing.ClassVar[QQmlDebuggingEnabler.StartMode] = ...
    def __init__(self, printWarning: bool = ...) -> None: ...
    @classmethod
    def connectToLocalDebugger(cls, socketFileName: str, mode: QQmlDebuggingEnabler.StartMode = ...) -> bool: ...
    @classmethod
    def debuggerServices(cls) -> typing.List[str]: ...
    @classmethod
    def inspectorServices(cls) -> typing.List[str]: ...
    @classmethod
    def nativeDebuggerServices(cls) -> typing.List[str]: ...
    @classmethod
    def profilerServices(cls) -> typing.List[str]: ...
    @classmethod
    def setServices(cls, services: typing.Iterable[str]) -> None: ...
    @classmethod
    def startDebugConnector(cls, pluginName: str, configuration: typing.Dict[str,typing.Any] = ...) -> bool: ...
    @classmethod
    def startTcpDebugServer(cls, port: int, mode: QQmlDebuggingEnabler.StartMode = ..., hostName: str = ...) -> bool: ...

class QQmlEngine(QJSEngine):
    class ObjectOwnership:
        CppOwnership: typing.ClassVar[QQmlEngine.ObjectOwnership] = ...
        JavaScriptOwnership: typing.ClassVar[QQmlEngine.ObjectOwnership] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlEngine.ObjectOwnership: ...
    CppOwnership: typing.ClassVar[QQmlEngine.ObjectOwnership] = ...
    JavaScriptOwnership: typing.ClassVar[QQmlEngine.ObjectOwnership] = ...
    exit: typing.ClassVar[PySide2.QtCore.Signal] = ...
    quit: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    warnings: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, p: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., exit: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., offlineStoragePath: str = ..., quit: typing.Callable = ..., uiLanguage: str = ..., uiLanguageChanged: typing.Callable = ..., warnings: typing.Callable = ...) -> None: ...
    def addImageProvider(self, id: str, arg__2: QQmlImageProviderBase) -> None: ...
    def addImportPath(self, dir: str) -> None: ...
    def addNamedBundle(self, name: str, fileName: str) -> bool: ...
    def addPluginPath(self, dir: str) -> None: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def clearComponentCache(self) -> None: ...
    @classmethod
    def contextForObject(cls, arg__1: PySide2.QtCore.QObject) -> QQmlContext: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def imageProvider(self, id: str) -> QQmlImageProviderBase: ...
    def importPathList(self) -> typing.List[str]: ...
    def importPlugin(self, filePath: str, uri: str, errors: typing.Iterable[QQmlError]) -> bool: ...
    def incubationController(self) -> QQmlIncubationController: ...
    def networkAccessManager(self) -> PySide2.QtNetwork.QNetworkAccessManager: ...
    def networkAccessManagerFactory(self) -> QQmlNetworkAccessManagerFactory: ...
    @classmethod
    def objectOwnership(cls, arg__1: PySide2.QtCore.QObject) -> QQmlEngine.ObjectOwnership: ...
    def offlineStorageDatabaseFilePath(self, databaseName: str) -> str: ...
    def offlineStoragePath(self) -> str: ...
    def outputWarningsToStandardError(self) -> bool: ...
    def pluginPathList(self) -> typing.List[str]: ...
    def removeImageProvider(self, id: str) -> None: ...
    def retranslate(self) -> None: ...
    def rootContext(self) -> QQmlContext: ...
    def setBaseUrl(self, arg__1: PySide2.QtCore.QUrl) -> None: ...
    @classmethod
    def setContextForObject(cls, arg__1: PySide2.QtCore.QObject, arg__2: QQmlContext) -> None: ...
    def setImportPathList(self, paths: typing.Iterable[str]) -> None: ...
    def setIncubationController(self, arg__1: QQmlIncubationController) -> None: ...
    def setNetworkAccessManagerFactory(self, arg__1: QQmlNetworkAccessManagerFactory) -> None: ...
    @classmethod
    def setObjectOwnership(cls, arg__1: PySide2.QtCore.QObject, arg__2: QQmlEngine.ObjectOwnership) -> None: ...
    def setOfflineStoragePath(self, dir: str) -> None: ...
    def setOutputWarningsToStandardError(self, arg__1: bool) -> None: ...
    def setPluginPathList(self, paths: typing.Iterable[str]) -> None: ...
    def setUrlInterceptor(self, urlInterceptor: QQmlAbstractUrlInterceptor) -> None: ...
    def trimComponentCache(self) -> None: ...
    def urlInterceptor(self) -> QQmlAbstractUrlInterceptor: ...

class QQmlError(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QQmlError) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def column(self) -> int: ...
    def description(self) -> str: ...
    def isValid(self) -> bool: ...
    def line(self) -> int: ...
    def messageType(self) -> PySide2.QtCore.QtMsgType: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def setColumn(self, arg__1: int) -> None: ...
    def setDescription(self, arg__1: str) -> None: ...
    def setLine(self, arg__1: int) -> None: ...
    def setMessageType(self, messageType: PySide2.QtCore.QtMsgType) -> None: ...
    def setObject(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    def setUrl(self, arg__1: PySide2.QtCore.QUrl) -> None: ...
    def toString(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...

class QQmlExpression(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, arg__1: QQmlContext, arg__2: PySide2.QtCore.QObject, arg__3: str, arg__4: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlScriptString, arg__2: typing.Union[QQmlContext,None] = ..., arg__3: typing.Union[PySide2.QtCore.QObject,None] = ..., arg__4: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
    def clearError(self) -> None: ...
    def columnNumber(self) -> int: ...
    def context(self) -> QQmlContext: ...
    def engine(self) -> QQmlEngine: ...
    def error(self) -> QQmlError: ...
    def evaluate(self) -> typing.Tuple[typing.Any,bool]: ...
    def expression(self) -> str: ...
    def hasError(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def notifyOnValueChanged(self) -> bool: ...
    def scopeObject(self) -> PySide2.QtCore.QObject: ...
    def setExpression(self, arg__1: str) -> None: ...
    def setNotifyOnValueChanged(self, arg__1: bool) -> None: ...
    def setSourceLocation(self, fileName: str, line: int, column: int = ...) -> None: ...
    def sourceFile(self) -> str: ...

class QQmlExtensionInterface(QQmlTypesExtensionInterface):
    def __init__(self) -> None: ...
    def initializeEngine(self, engine: QQmlEngine, uri: bytes) -> None: ...

class QQmlExtensionPlugin(PySide2.QtCore.QObject, QQmlExtensionInterface):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def initializeEngine(self, engine: QQmlEngine, uri: bytes) -> None: ...
    def registerTypes(self, uri: bytes) -> None: ...

class QQmlFile(shiboken2.Object):
    class Status:
        Error: typing.ClassVar[QQmlFile.Status] = ...
        Loading: typing.ClassVar[QQmlFile.Status] = ...
        Null: typing.ClassVar[QQmlFile.Status] = ...
        Ready: typing.ClassVar[QQmlFile.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlFile.Status: ...
    Error: typing.ClassVar[QQmlFile.Status] = ...
    Loading: typing.ClassVar[QQmlFile.Status] = ...
    Null: typing.ClassVar[QQmlFile.Status] = ...
    Ready: typing.ClassVar[QQmlFile.Status] = ...
    @overload
    def __init__(self, arg__1: QQmlEngine, arg__2: PySide2.QtCore.QUrl) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlEngine, arg__2: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def clear(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def connectDownloadProgress(self, arg__1: PySide2.QtCore.QObject, arg__2: bytes) -> bool: ...
    @overload
    def connectDownloadProgress(self, arg__1: PySide2.QtCore.QObject, arg__2: int) -> bool: ...
    @overload
    def connectFinished(self, arg__1: PySide2.QtCore.QObject, arg__2: bytes) -> bool: ...
    @overload
    def connectFinished(self, arg__1: PySide2.QtCore.QObject, arg__2: int) -> bool: ...
    def data(self) -> bytes: ...
    def dataByteArray(self) -> PySide2.QtCore.QByteArray: ...
    def error(self) -> str: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    @overload
    @classmethod
    def isLocalFile(cls, url: PySide2.QtCore.QUrl) -> bool: ...
    @overload
    @classmethod
    def isLocalFile(cls, url: str) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    @overload
    @classmethod
    def isSynchronous(cls, url: PySide2.QtCore.QUrl) -> bool: ...
    @overload
    @classmethod
    def isSynchronous(cls, url: str) -> bool: ...
    @overload
    def load(self, arg__1: QQmlEngine, arg__2: PySide2.QtCore.QUrl) -> None: ...
    @overload
    def load(self, arg__1: QQmlEngine, arg__2: str) -> None: ...
    def size(self) -> int: ...
    def status(self) -> QQmlFile.Status: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    @overload
    @classmethod
    def urlToLocalFileOrQrc(cls, arg__1: PySide2.QtCore.QUrl) -> str: ...
    @overload
    @classmethod
    def urlToLocalFileOrQrc(cls, arg__1: str) -> str: ...
    def __bool__(self) -> bool: ...

class QQmlFileSelector(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, engine: QQmlEngine, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def get(cls, arg__1: QQmlEngine) -> QQmlFileSelector: ...
    def selector(self) -> PySide2.QtCore.QFileSelector: ...
    def setExtraSelectors(self, strings: typing.Iterable[str]) -> None: ...
    def setSelector(self, selector: PySide2.QtCore.QFileSelector) -> None: ...

class QQmlImageProviderBase(shiboken2.Object):
    class Flag:
        ForceAsynchronousImageLoading: typing.ClassVar[QQmlImageProviderBase.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQmlImageProviderBase.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QQmlImageProviderBase.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.Flags: ...

    class ImageType:
        Image: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
        ImageResponse: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
        Invalid: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
        Pixmap: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
        Texture: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlImageProviderBase.ImageType: ...
    ForceAsynchronousImageLoading: typing.ClassVar[QQmlImageProviderBase.Flag] = ...
    Image: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
    ImageResponse: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
    Invalid: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
    Pixmap: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
    Texture: typing.ClassVar[QQmlImageProviderBase.ImageType] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def flags(self) -> typing.Union[QQmlImageProviderBase.Flags,QQmlImageProviderBase.Flag]: ...
    def imageType(self) -> QQmlImageProviderBase.ImageType: ...

class QQmlIncubationController(shiboken2.Object):
    def __init__(self) -> None: ...
    def engine(self) -> QQmlEngine: ...
    def incubateFor(self, msecs: int) -> None: ...
    def incubateWhile(self, msecs: int = ...) -> bool: ...
    def incubatingObjectCount(self) -> int: ...
    def incubatingObjectCountChanged(self, arg__1: int) -> None: ...

class QQmlIncubator(shiboken2.Object):
    class IncubationMode:
        Asynchronous: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
        AsynchronousIfNested: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
        Synchronous: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlIncubator.IncubationMode: ...

    class Status:
        Error: typing.ClassVar[QQmlIncubator.Status] = ...
        Loading: typing.ClassVar[QQmlIncubator.Status] = ...
        Null: typing.ClassVar[QQmlIncubator.Status] = ...
        Ready: typing.ClassVar[QQmlIncubator.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlIncubator.Status: ...
    Asynchronous: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
    AsynchronousIfNested: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
    Error: typing.ClassVar[QQmlIncubator.Status] = ...
    Loading: typing.ClassVar[QQmlIncubator.Status] = ...
    Null: typing.ClassVar[QQmlIncubator.Status] = ...
    Ready: typing.ClassVar[QQmlIncubator.Status] = ...
    Synchronous: typing.ClassVar[QQmlIncubator.IncubationMode] = ...
    def __init__(self, arg__1: QQmlIncubator.IncubationMode = ...) -> None: ...
    def clear(self) -> None: ...
    def errors(self) -> typing.List[QQmlError]: ...
    def forceCompletion(self) -> None: ...
    def incubationMode(self) -> QQmlIncubator.IncubationMode: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def setInitialProperties(self, initialProperties: typing.Dict[str,typing.Any]) -> None: ...
    def setInitialState(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    def status(self) -> QQmlIncubator.Status: ...
    def statusChanged(self, arg__1: QQmlIncubator.Status) -> None: ...
    def __bool__(self) -> bool: ...

class QQmlListReference(shiboken2.Object):
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, property: bytes, arg__3: typing.Union[QQmlEngine,None] = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlListReference) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def append(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def at(self, arg__1: int) -> PySide2.QtCore.QObject: ...
    def canAppend(self) -> bool: ...
    def canAt(self) -> bool: ...
    def canClear(self) -> bool: ...
    def canCount(self) -> bool: ...
    def canRemoveLast(self) -> bool: ...
    def canReplace(self) -> bool: ...
    def clear(self) -> bool: ...
    def count(self) -> int: ...
    def isManipulable(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def listElementType(self) -> PySide2.QtCore.QMetaObject: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def removeLast(self) -> bool: ...
    def replace(self, arg__1: int, arg__2: PySide2.QtCore.QObject) -> bool: ...
    def __copy__(self) -> None: ...

class QQmlNetworkAccessManagerFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    def create(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> PySide2.QtNetwork.QNetworkAccessManager: ...

class QQmlParserStatus(shiboken2.Object):
    def __init__(self) -> None: ...
    def classBegin(self) -> None: ...
    def componentComplete(self) -> None: ...

class QQmlProperty(shiboken2.Object):
    class PropertyTypeCategory:
        InvalidCategory: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
        List: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
        Normal: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
        Object: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlProperty.PropertyTypeCategory: ...

    class Type:
        Invalid: typing.ClassVar[QQmlProperty.Type] = ...
        Property: typing.ClassVar[QQmlProperty.Type] = ...
        SignalProperty: typing.ClassVar[QQmlProperty.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QQmlProperty.Type: ...
    Invalid: typing.ClassVar[QQmlProperty.Type] = ...
    InvalidCategory: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
    List: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
    Normal: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
    Object: typing.ClassVar[QQmlProperty.PropertyTypeCategory] = ...
    Property: typing.ClassVar[QQmlProperty.Type] = ...
    SignalProperty: typing.ClassVar[QQmlProperty.Type] = ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, arg__2: str, arg__3: QQmlContext) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, arg__2: str, arg__3: QQmlEngine) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, arg__2: QQmlContext) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, arg__2: QQmlEngine) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject, arg__2: str) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    @overload
    def __init__(self, arg__1: QQmlProperty) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def connectNotifySignal(self, dest: PySide2.QtCore.QObject, method: int) -> bool: ...
    @overload
    def connectNotifySignal(self, dest: PySide2.QtCore.QObject, slot: bytes) -> bool: ...
    def hasNotifySignal(self) -> bool: ...
    def index(self) -> int: ...
    def isDesignable(self) -> bool: ...
    def isProperty(self) -> bool: ...
    def isResettable(self) -> bool: ...
    def isSignalProperty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def method(self) -> PySide2.QtCore.QMetaMethod: ...
    def name(self) -> str: ...
    def needsNotifySignal(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def property(self) -> PySide2.QtCore.QMetaProperty: ...
    def propertyType(self) -> int: ...
    def propertyTypeCategory(self) -> QQmlProperty.PropertyTypeCategory: ...
    def propertyTypeName(self) -> bytes: ...
    def read(self) -> typing.Any: ...
    def reset(self) -> bool: ...
    def type(self) -> QQmlProperty.Type: ...
    def write(self, arg__1: typing.Any) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QQmlPropertyMap(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
    def clear(self, key: str) -> None: ...
    def contains(self, key: str) -> bool: ...
    def count(self) -> int: ...
    def insert(self, key: str, value: typing.Any) -> None: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List[str]: ...
    def size(self) -> int: ...
    def updateValue(self, key: str, input: typing.Any) -> typing.Any: ...
    def value(self, key: str) -> typing.Any: ...

class QQmlPropertyValueSource(shiboken2.Object):
    def __init__(self) -> None: ...
    def setTarget(self, arg__1: QQmlProperty) -> None: ...

class QQmlScriptString(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QQmlScriptString) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def booleanLiteral(self) -> typing.Tuple[bool,bool]: ...
    def isEmpty(self) -> bool: ...
    def isNullLiteral(self) -> bool: ...
    def isUndefinedLiteral(self) -> bool: ...
    def numberLiteral(self) -> typing.Tuple[float,bool]: ...
    def stringLiteral(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QQmlTypesExtensionInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def registerTypes(self, uri: bytes) -> None: ...

class QtQml(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def qmlAttachedPropertiesObject(cls, arg__2: PySide2.QtCore.QObject, arg__3: PySide2.QtCore.QMetaObject, create: bool) -> typing.Tuple[PySide2.QtCore.QObject,int]: ...
    @classmethod
    def qmlAttachedPropertiesObjectById(cls, arg__1: int, arg__2: PySide2.QtCore.QObject, create: bool = ...) -> PySide2.QtCore.QObject: ...
    @classmethod
    def qmlContext(cls, arg__1: PySide2.QtCore.QObject) -> QQmlContext: ...
    @classmethod
    def qmlEngine(cls, arg__1: PySide2.QtCore.QObject) -> QQmlEngine: ...
    @classmethod
    def qmlExecuteDeferred(cls, arg__1: PySide2.QtCore.QObject) -> None: ...

class VolatileBool:
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get(self) -> bool: ...
    def set(self, a: object) -> None: ...

def qmlRegisterType(arg__1: type, arg__2: bytes, arg__3: int, arg__4: int, arg__5: bytes) -> int: ...
