from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import shiboken2
import typing
T = typing.TypeVar('T')

class QCompressedHelpInfo(shiboken2.Object):
    @overload
    def __init__(self, other: QCompressedHelpInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def component(self) -> str: ...
    @classmethod
    def fromCompressedHelpFile(cls, documentationFileName: str) -> QCompressedHelpInfo: ...
    def isNull(self) -> bool: ...
    def namespaceName(self) -> str: ...
    def swap(self, other: QCompressedHelpInfo) -> None: ...
    def version(self) -> PySide2.QtCore.QVersionNumber: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...

class QHelpContentItem(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def child(self, row: int) -> QHelpContentItem: ...
    def childCount(self) -> int: ...
    def childPosition(self, child: QHelpContentItem) -> int: ...
    def parent(self) -> QHelpContentItem: ...
    def row(self) -> int: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...

class QHelpContentModel(PySide2.QtCore.QAbstractItemModel):
    contentsCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsCreationStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def contentItemAt(self, index: PySide2.QtCore.QModelIndex) -> QHelpContentItem: ...
    def createContents(self, customFilterName: str) -> None: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isCreatingContents(self) -> bool: ...
    @overload
    def parent(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...

class QHelpContentWidget(PySide2.QtWidgets.QTreeView):
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def indexOf(self, link: PySide2.QtCore.QUrl) -> PySide2.QtCore.QModelIndex: ...

class QHelpEngine(QHelpEngineCore):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, collectionFile: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def contentModel(self) -> QHelpContentModel: ...
    def contentWidget(self) -> QHelpContentWidget: ...
    def indexModel(self) -> QHelpIndexModel: ...
    def indexWidget(self) -> QHelpIndexWidget: ...
    def searchEngine(self) -> QHelpSearchEngine: ...

class QHelpEngineCore(PySide2.QtCore.QObject):
    currentFilterChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readersAboutToBeInvalidated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    setupFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    setupStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    warning: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, collectionFile: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addCustomFilter(self, filterName: str, attributes: typing.Iterable[str]) -> bool: ...
    def autoSaveFilter(self) -> bool: ...
    def collectionFile(self) -> str: ...
    def copyCollectionFile(self, fileName: str) -> bool: ...
    def currentFilter(self) -> str: ...
    def customFilters(self) -> typing.List[str]: ...
    def customValue(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def documentationFileName(self, namespaceName: str) -> str: ...
    @overload
    def documentsForIdentifier(self, id: str, filterName: str) -> typing.List[QHelpLink]: ...
    @overload
    def documentsForIdentifier(self, id: str) -> typing.List[QHelpLink]: ...
    @overload
    def documentsForKeyword(self, keyword: str, filterName: str) -> typing.List[QHelpLink]: ...
    @overload
    def documentsForKeyword(self, keyword: str) -> typing.List[QHelpLink]: ...
    def error(self) -> str: ...
    def fileData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
    @overload
    def files(self, namespaceName: str, filterAttributes: typing.Iterable[str], extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    @overload
    def files(self, namespaceName: str, filterName: str, extensionFilter: str = ...) -> typing.List[PySide2.QtCore.QUrl]: ...
    def filterAttributeSets(self, namespaceName: str) -> typing.List[typing.List[str]]: ...
    @overload
    def filterAttributes(self, filterName: str) -> typing.List[str]: ...
    @overload
    def filterAttributes(self) -> typing.List[str]: ...
    def filterEngine(self) -> QHelpFilterEngine: ...
    def findFile(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def linksForIdentifier(self, id: str) -> typing.Dict[str,PySide2.QtCore.QUrl]: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str,PySide2.QtCore.QUrl]: ...
    @classmethod
    def metaData(cls, documentationFileName: str, name: str) -> typing.Any: ...
    @classmethod
    def namespaceName(cls, documentationFileName: str) -> str: ...
    def registerDocumentation(self, documentationFileName: str) -> bool: ...
    def registeredDocumentations(self) -> typing.List[str]: ...
    def removeCustomFilter(self, filterName: str) -> bool: ...
    def removeCustomValue(self, key: str) -> bool: ...
    def setAutoSaveFilter(self, save: bool) -> None: ...
    def setCollectionFile(self, fileName: str) -> None: ...
    def setCurrentFilter(self, filterName: str) -> None: ...
    def setCustomValue(self, key: str, value: typing.Any) -> bool: ...
    def setUsesFilterEngine(self, uses: bool) -> None: ...
    def setupData(self) -> bool: ...
    def unregisterDocumentation(self, namespaceName: str) -> bool: ...
    def usesFilterEngine(self) -> bool: ...

class QHelpFilterData(shiboken2.Object):
    @overload
    def __init__(self, other: QHelpFilterData) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def components(self) -> typing.List[str]: ...
    def setComponents(self, components: typing.Iterable[str]) -> None: ...
    def setVersions(self, versions: typing.Iterable[PySide2.QtCore.QVersionNumber]) -> None: ...
    def swap(self, other: QHelpFilterData) -> None: ...
    def versions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QHelpFilterEngine(PySide2.QtCore.QObject):
    filterActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, helpEngine: QHelpEngineCore, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def activeFilter(self) -> str: ...
    def availableComponents(self) -> typing.List[str]: ...
    def availableVersions(self) -> typing.List[PySide2.QtCore.QVersionNumber]: ...
    def filterData(self, filterName: str) -> QHelpFilterData: ...
    def filters(self) -> typing.List[str]: ...
    @overload
    def indices(self, filterName: str) -> typing.List[str]: ...
    @overload
    def indices(self) -> typing.List[str]: ...
    def namespaceToComponent(self) -> typing.Dict[str,str]: ...
    def namespaceToVersion(self) -> typing.Dict[str,PySide2.QtCore.QVersionNumber]: ...
    def namespacesForFilter(self, filterName: str) -> typing.List[str]: ...
    def removeFilter(self, filterName: str) -> bool: ...
    def setActiveFilter(self, filterName: str) -> bool: ...
    def setFilterData(self, filterName: str, filterData: QHelpFilterData) -> bool: ...

class QHelpFilterSettingsWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def applySettings(self, filterEngine: QHelpFilterEngine) -> bool: ...
    def readSettings(self, filterEngine: QHelpFilterEngine) -> None: ...
    def setAvailableComponents(self, components: typing.Iterable[str]) -> None: ...
    def setAvailableVersions(self, versions: typing.Iterable[PySide2.QtCore.QVersionNumber]) -> None: ...

class QHelpIndexModel(PySide2.QtCore.QStringListModel):
    indexCreated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    indexCreationStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @overload
    def createIndex(self, row: int, column: int, id: int = ...) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def createIndex(self, row: int, column: int, ptr: object) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def createIndex(self, customFilterName: str) -> None: ...
    def filter(self, filter: str, wildcard: str = ...) -> PySide2.QtCore.QModelIndex: ...
    def helpEngine(self) -> QHelpEngineCore: ...
    def isCreatingIndex(self) -> bool: ...
    def linksForKeyword(self, keyword: str) -> typing.Dict[str,PySide2.QtCore.QUrl]: ...

class QHelpIndexWidget(PySide2.QtWidgets.QListView):
    documentActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    documentsActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linkActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    linksActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter: str, wildcard: str = ...) -> None: ...

class QHelpLink(shiboken2.Object):
    title: typing.Any
    url: typing.Any
    @overload
    def __init__(self, QHelpLink: QHelpLink) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QHelpSearchEngine(PySide2.QtCore.QObject):
    indexingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    indexingStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    searchingStarted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, helpEngine: QHelpEngineCore, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def cancelIndexing(self) -> None: ...
    def cancelSearching(self) -> None: ...
    def hitCount(self) -> int: ...
    def hits(self, start: int, end: int) -> typing.List[typing.Tuple[str,str]]: ...
    def hitsCount(self) -> int: ...
    def query(self) -> typing.List[QHelpSearchQuery]: ...
    def queryWidget(self) -> QHelpSearchQueryWidget: ...
    def reindexDocumentation(self) -> None: ...
    def resultWidget(self) -> QHelpSearchResultWidget: ...
    def scheduleIndexDocumentation(self) -> None: ...
    @overload
    def search(self, queryList: typing.Iterable[QHelpSearchQuery]) -> None: ...
    @overload
    def search(self, searchInput: str) -> None: ...
    def searchInput(self) -> str: ...
    def searchResultCount(self) -> int: ...
    def searchResults(self, start: int, end: int) -> typing.List[QHelpSearchResult]: ...

class QHelpSearchQuery(shiboken2.Object):
    class FieldName:
        ALL: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        ATLEAST: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        DEFAULT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        FUZZY: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        PHRASE: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        WITHOUT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __and__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rand__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __ror__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __sub__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
        def __xor__(self, other: typing.SupportsInt) -> QHelpSearchQuery.FieldName: ...
    ALL: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    ATLEAST: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    DEFAULT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    FUZZY: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    PHRASE: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    WITHOUT: typing.ClassVar[QHelpSearchQuery.FieldName] = ...
    fieldName: typing.Any
    wordList: typing.Any
    @overload
    def __init__(self, field: QHelpSearchQuery.FieldName, wordList_: typing.Iterable[str]) -> None: ...
    @overload
    def __init__(self, QHelpSearchQuery: QHelpSearchQuery) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QHelpSearchQueryWidget(PySide2.QtWidgets.QWidget):
    search: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., search: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...
    def focusInEvent(self, focusEvent: PySide2.QtGui.QFocusEvent) -> None: ...
    def isCompactMode(self) -> bool: ...
    def query(self) -> typing.List[QHelpSearchQuery]: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool) -> None: ...
    def setQuery(self, queryList: typing.Iterable[QHelpSearchQuery]) -> None: ...
    def setSearchInput(self, searchInput: str) -> None: ...

class QHelpSearchResult(shiboken2.Object):
    @overload
    def __init__(self, url: PySide2.QtCore.QUrl, title: str, snippet: str) -> None: ...
    @overload
    def __init__(self, other: QHelpSearchResult) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def snippet(self) -> str: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QHelpSearchResultWidget(PySide2.QtWidgets.QWidget):
    requestShowLink: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def changeEvent(self, event: PySide2.QtCore.QEvent) -> None: ...
    def linkAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QUrl: ...
