from typing import overload
import PySide2.QtCore
import shiboken2
import typing
T = typing.TypeVar('T')

class QAbstractOpenGLFunctions(shiboken2.Object):
    def __init__(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def owningContext(self) -> QOpenGLContext: ...
    def setOwningContext(self, context: QOpenGLContext) -> None: ...

class QAbstractTextDocumentLayout(PySide2.QtCore.QObject):
    class PaintContext(shiboken2.Object):
        clip: typing.Any
        cursorPosition: typing.Any
        palette: typing.Any
        @overload
        def __init__(self, PaintContext: QAbstractTextDocumentLayout.PaintContext) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...

    class Selection(shiboken2.Object):
        cursor: typing.Any
        format: typing.Any
        @overload
        def __init__(self, Selection: QAbstractTextDocumentLayout.Selection) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...
    documentSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    pageCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    update: typing.ClassVar[PySide2.QtCore.Signal] = ...
    updateBlock: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def anchorAt(self, pos: PySide2.QtCore.QPointF) -> str: ...
    def blockBoundingRect(self, block: QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockWithMarkerAt(self, pos: PySide2.QtCore.QPointF) -> QTextBlock: ...
    def document(self) -> QTextDocument: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, painter: QPainter, context: QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def drawInlineObject(self, painter: QPainter, rect: PySide2.QtCore.QRectF, object: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def format(self, pos: int) -> QTextCharFormat: ...
    def formatAt(self, pos: PySide2.QtCore.QPointF) -> QTextFormat: ...
    def formatIndex(self, pos: int) -> int: ...
    def frameBoundingRect(self, frame: QTextFrame) -> PySide2.QtCore.QRectF: ...
    def handlerForObject(self, objectType: int) -> QTextObjectInterface: ...
    def hitTest(self, point: PySide2.QtCore.QPointF, accuracy: PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def imageAt(self, pos: PySide2.QtCore.QPointF) -> str: ...
    def pageCount(self) -> int: ...
    def paintDevice(self) -> QPaintDevice: ...
    def positionInlineObject(self, item: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def registerHandler(self, objectType: int, component: PySide2.QtCore.QObject) -> None: ...
    def resizeInlineObject(self, item: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def setPaintDevice(self, device: QPaintDevice) -> None: ...
    def unregisterHandler(self, objectType: int, component: typing.Union[PySide2.QtCore.QObject,None] = ...) -> None: ...

class QAccessible(shiboken2.Object):
    class Event:
        AcceleratorChanged: typing.ClassVar[QAccessible.Event] = ...
        ActionChanged: typing.ClassVar[QAccessible.Event] = ...
        ActiveDescendantChanged: typing.ClassVar[QAccessible.Event] = ...
        Alert: typing.ClassVar[QAccessible.Event] = ...
        AttributeChanged: typing.ClassVar[QAccessible.Event] = ...
        ContextHelpEnd: typing.ClassVar[QAccessible.Event] = ...
        ContextHelpStart: typing.ClassVar[QAccessible.Event] = ...
        DefaultActionChanged: typing.ClassVar[QAccessible.Event] = ...
        DescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
        DialogEnd: typing.ClassVar[QAccessible.Event] = ...
        DialogStart: typing.ClassVar[QAccessible.Event] = ...
        DocumentContentChanged: typing.ClassVar[QAccessible.Event] = ...
        DocumentLoadComplete: typing.ClassVar[QAccessible.Event] = ...
        DocumentLoadStopped: typing.ClassVar[QAccessible.Event] = ...
        DocumentReload: typing.ClassVar[QAccessible.Event] = ...
        DragDropEnd: typing.ClassVar[QAccessible.Event] = ...
        DragDropStart: typing.ClassVar[QAccessible.Event] = ...
        Focus: typing.ClassVar[QAccessible.Event] = ...
        ForegroundChanged: typing.ClassVar[QAccessible.Event] = ...
        HelpChanged: typing.ClassVar[QAccessible.Event] = ...
        HyperlinkEndIndexChanged: typing.ClassVar[QAccessible.Event] = ...
        HyperlinkNumberOfAnchorsChanged: typing.ClassVar[QAccessible.Event] = ...
        HyperlinkSelectedLinkChanged: typing.ClassVar[QAccessible.Event] = ...
        HyperlinkStartIndexChanged: typing.ClassVar[QAccessible.Event] = ...
        HypertextChanged: typing.ClassVar[QAccessible.Event] = ...
        HypertextLinkActivated: typing.ClassVar[QAccessible.Event] = ...
        HypertextLinkSelected: typing.ClassVar[QAccessible.Event] = ...
        HypertextNLinksChanged: typing.ClassVar[QAccessible.Event] = ...
        InvalidEvent: typing.ClassVar[QAccessible.Event] = ...
        LocationChanged: typing.ClassVar[QAccessible.Event] = ...
        MenuCommand: typing.ClassVar[QAccessible.Event] = ...
        MenuEnd: typing.ClassVar[QAccessible.Event] = ...
        MenuStart: typing.ClassVar[QAccessible.Event] = ...
        NameChanged: typing.ClassVar[QAccessible.Event] = ...
        ObjectAttributeChanged: typing.ClassVar[QAccessible.Event] = ...
        ObjectCreated: typing.ClassVar[QAccessible.Event] = ...
        ObjectDestroyed: typing.ClassVar[QAccessible.Event] = ...
        ObjectHide: typing.ClassVar[QAccessible.Event] = ...
        ObjectReorder: typing.ClassVar[QAccessible.Event] = ...
        ObjectShow: typing.ClassVar[QAccessible.Event] = ...
        PageChanged: typing.ClassVar[QAccessible.Event] = ...
        ParentChanged: typing.ClassVar[QAccessible.Event] = ...
        PopupMenuEnd: typing.ClassVar[QAccessible.Event] = ...
        PopupMenuStart: typing.ClassVar[QAccessible.Event] = ...
        ScrollingEnd: typing.ClassVar[QAccessible.Event] = ...
        ScrollingStart: typing.ClassVar[QAccessible.Event] = ...
        SectionChanged: typing.ClassVar[QAccessible.Event] = ...
        Selection: typing.ClassVar[QAccessible.Event] = ...
        SelectionAdd: typing.ClassVar[QAccessible.Event] = ...
        SelectionRemove: typing.ClassVar[QAccessible.Event] = ...
        SelectionWithin: typing.ClassVar[QAccessible.Event] = ...
        SoundPlayed: typing.ClassVar[QAccessible.Event] = ...
        StateChanged: typing.ClassVar[QAccessible.Event] = ...
        TableCaptionChanged: typing.ClassVar[QAccessible.Event] = ...
        TableColumnDescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
        TableColumnHeaderChanged: typing.ClassVar[QAccessible.Event] = ...
        TableModelChanged: typing.ClassVar[QAccessible.Event] = ...
        TableRowDescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
        TableRowHeaderChanged: typing.ClassVar[QAccessible.Event] = ...
        TableSummaryChanged: typing.ClassVar[QAccessible.Event] = ...
        TextAttributeChanged: typing.ClassVar[QAccessible.Event] = ...
        TextCaretMoved: typing.ClassVar[QAccessible.Event] = ...
        TextColumnChanged: typing.ClassVar[QAccessible.Event] = ...
        TextInserted: typing.ClassVar[QAccessible.Event] = ...
        TextRemoved: typing.ClassVar[QAccessible.Event] = ...
        TextSelectionChanged: typing.ClassVar[QAccessible.Event] = ...
        TextUpdated: typing.ClassVar[QAccessible.Event] = ...
        ValueChanged: typing.ClassVar[QAccessible.Event] = ...
        VisibleDataChanged: typing.ClassVar[QAccessible.Event] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessible.Event: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.Event: ...

    class InterfaceType:
        ActionInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        EditableTextInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        ImageInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        TableCellInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        TableInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        TextInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        ValueInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.InterfaceType: ...

    class Relation:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAccessible.Relation: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...

    class RelationFlag:
        AllRelations: typing.ClassVar[QAccessible.RelationFlag] = ...
        Controlled: typing.ClassVar[QAccessible.RelationFlag] = ...
        Controller: typing.ClassVar[QAccessible.RelationFlag] = ...
        Label: typing.ClassVar[QAccessible.RelationFlag] = ...
        Labelled: typing.ClassVar[QAccessible.RelationFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAccessible.Relation: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.Relation: ...

    class Role:
        AlertMessage: typing.ClassVar[QAccessible.Role] = ...
        Animation: typing.ClassVar[QAccessible.Role] = ...
        Application: typing.ClassVar[QAccessible.Role] = ...
        Assistant: typing.ClassVar[QAccessible.Role] = ...
        Border: typing.ClassVar[QAccessible.Role] = ...
        Button: typing.ClassVar[QAccessible.Role] = ...
        ButtonDropDown: typing.ClassVar[QAccessible.Role] = ...
        ButtonDropGrid: typing.ClassVar[QAccessible.Role] = ...
        ButtonMenu: typing.ClassVar[QAccessible.Role] = ...
        Canvas: typing.ClassVar[QAccessible.Role] = ...
        Caret: typing.ClassVar[QAccessible.Role] = ...
        Cell: typing.ClassVar[QAccessible.Role] = ...
        Chart: typing.ClassVar[QAccessible.Role] = ...
        CheckBox: typing.ClassVar[QAccessible.Role] = ...
        Client: typing.ClassVar[QAccessible.Role] = ...
        Clock: typing.ClassVar[QAccessible.Role] = ...
        ColorChooser: typing.ClassVar[QAccessible.Role] = ...
        Column: typing.ClassVar[QAccessible.Role] = ...
        ColumnHeader: typing.ClassVar[QAccessible.Role] = ...
        ComboBox: typing.ClassVar[QAccessible.Role] = ...
        ComplementaryContent: typing.ClassVar[QAccessible.Role] = ...
        Cursor: typing.ClassVar[QAccessible.Role] = ...
        Desktop: typing.ClassVar[QAccessible.Role] = ...
        Dial: typing.ClassVar[QAccessible.Role] = ...
        Dialog: typing.ClassVar[QAccessible.Role] = ...
        Document: typing.ClassVar[QAccessible.Role] = ...
        EditableText: typing.ClassVar[QAccessible.Role] = ...
        Equation: typing.ClassVar[QAccessible.Role] = ...
        Footer: typing.ClassVar[QAccessible.Role] = ...
        Form: typing.ClassVar[QAccessible.Role] = ...
        Graphic: typing.ClassVar[QAccessible.Role] = ...
        Grip: typing.ClassVar[QAccessible.Role] = ...
        Grouping: typing.ClassVar[QAccessible.Role] = ...
        Heading: typing.ClassVar[QAccessible.Role] = ...
        HelpBalloon: typing.ClassVar[QAccessible.Role] = ...
        HotkeyField: typing.ClassVar[QAccessible.Role] = ...
        Indicator: typing.ClassVar[QAccessible.Role] = ...
        LayeredPane: typing.ClassVar[QAccessible.Role] = ...
        Link: typing.ClassVar[QAccessible.Role] = ...
        List: typing.ClassVar[QAccessible.Role] = ...
        ListItem: typing.ClassVar[QAccessible.Role] = ...
        MenuBar: typing.ClassVar[QAccessible.Role] = ...
        MenuItem: typing.ClassVar[QAccessible.Role] = ...
        NoRole: typing.ClassVar[QAccessible.Role] = ...
        Note: typing.ClassVar[QAccessible.Role] = ...
        Notification: typing.ClassVar[QAccessible.Role] = ...
        PageTab: typing.ClassVar[QAccessible.Role] = ...
        PageTabList: typing.ClassVar[QAccessible.Role] = ...
        Pane: typing.ClassVar[QAccessible.Role] = ...
        Paragraph: typing.ClassVar[QAccessible.Role] = ...
        PopupMenu: typing.ClassVar[QAccessible.Role] = ...
        ProgressBar: typing.ClassVar[QAccessible.Role] = ...
        PropertyPage: typing.ClassVar[QAccessible.Role] = ...
        PushButton: typing.ClassVar[QAccessible.Role] = ...
        RadioButton: typing.ClassVar[QAccessible.Role] = ...
        Row: typing.ClassVar[QAccessible.Role] = ...
        RowHeader: typing.ClassVar[QAccessible.Role] = ...
        ScrollBar: typing.ClassVar[QAccessible.Role] = ...
        Section: typing.ClassVar[QAccessible.Role] = ...
        Separator: typing.ClassVar[QAccessible.Role] = ...
        Slider: typing.ClassVar[QAccessible.Role] = ...
        Sound: typing.ClassVar[QAccessible.Role] = ...
        SpinBox: typing.ClassVar[QAccessible.Role] = ...
        Splitter: typing.ClassVar[QAccessible.Role] = ...
        StaticText: typing.ClassVar[QAccessible.Role] = ...
        StatusBar: typing.ClassVar[QAccessible.Role] = ...
        Table: typing.ClassVar[QAccessible.Role] = ...
        Terminal: typing.ClassVar[QAccessible.Role] = ...
        TitleBar: typing.ClassVar[QAccessible.Role] = ...
        ToolBar: typing.ClassVar[QAccessible.Role] = ...
        ToolTip: typing.ClassVar[QAccessible.Role] = ...
        Tree: typing.ClassVar[QAccessible.Role] = ...
        TreeItem: typing.ClassVar[QAccessible.Role] = ...
        UserRole: typing.ClassVar[QAccessible.Role] = ...
        WebDocument: typing.ClassVar[QAccessible.Role] = ...
        Whitespace: typing.ClassVar[QAccessible.Role] = ...
        Window: typing.ClassVar[QAccessible.Role] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessible.Role: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.Role: ...

    class State(shiboken2.Object):
        active: typing.Any
        animated: typing.Any
        busy: typing.Any
        checkStateMixed: typing.Any
        checkable: typing.Any
        checked: typing.Any
        collapsed: typing.Any
        defaultButton: typing.Any
        disabled: typing.Any
        editable: typing.Any
        expandable: typing.Any
        expanded: typing.Any
        extSelectable: typing.Any
        focusable: typing.Any
        focused: typing.Any
        hasPopup: typing.Any
        hotTracked: typing.Any
        invalid: typing.Any
        invisible: typing.Any
        linked: typing.Any
        marqueed: typing.Any
        modal: typing.Any
        movable: typing.Any
        multiLine: typing.Any
        multiSelectable: typing.Any
        offscreen: typing.Any
        passwordEdit: typing.Any
        pressed: typing.Any
        readOnly: typing.Any
        searchEdit: typing.Any
        selectable: typing.Any
        selectableText: typing.Any
        selected: typing.Any
        selfVoicing: typing.Any
        sizeable: typing.Any
        supportsAutoCompletion: typing.Any
        traversed: typing.Any
        @overload
        def __init__(self, State: QAccessible.State) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class Text:
        Accelerator: typing.ClassVar[QAccessible.Text] = ...
        DebugDescription: typing.ClassVar[QAccessible.Text] = ...
        Description: typing.ClassVar[QAccessible.Text] = ...
        Help: typing.ClassVar[QAccessible.Text] = ...
        Name: typing.ClassVar[QAccessible.Text] = ...
        UserText: typing.ClassVar[QAccessible.Text] = ...
        Value: typing.ClassVar[QAccessible.Text] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessible.Text: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.Text: ...

    class TextBoundaryType:
        CharBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        LineBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        NoBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        ParagraphBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        SentenceBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        WordBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessible.TextBoundaryType: ...
    Accelerator: typing.ClassVar[QAccessible.Text] = ...
    AcceleratorChanged: typing.ClassVar[QAccessible.Event] = ...
    ActionChanged: typing.ClassVar[QAccessible.Event] = ...
    ActionInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    ActiveDescendantChanged: typing.ClassVar[QAccessible.Event] = ...
    Alert: typing.ClassVar[QAccessible.Event] = ...
    AlertMessage: typing.ClassVar[QAccessible.Role] = ...
    AllRelations: typing.ClassVar[QAccessible.RelationFlag] = ...
    Animation: typing.ClassVar[QAccessible.Role] = ...
    Application: typing.ClassVar[QAccessible.Role] = ...
    Assistant: typing.ClassVar[QAccessible.Role] = ...
    AttributeChanged: typing.ClassVar[QAccessible.Event] = ...
    Border: typing.ClassVar[QAccessible.Role] = ...
    Button: typing.ClassVar[QAccessible.Role] = ...
    ButtonDropDown: typing.ClassVar[QAccessible.Role] = ...
    ButtonDropGrid: typing.ClassVar[QAccessible.Role] = ...
    ButtonMenu: typing.ClassVar[QAccessible.Role] = ...
    Canvas: typing.ClassVar[QAccessible.Role] = ...
    Caret: typing.ClassVar[QAccessible.Role] = ...
    Cell: typing.ClassVar[QAccessible.Role] = ...
    CharBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    Chart: typing.ClassVar[QAccessible.Role] = ...
    CheckBox: typing.ClassVar[QAccessible.Role] = ...
    Client: typing.ClassVar[QAccessible.Role] = ...
    Clock: typing.ClassVar[QAccessible.Role] = ...
    ColorChooser: typing.ClassVar[QAccessible.Role] = ...
    Column: typing.ClassVar[QAccessible.Role] = ...
    ColumnHeader: typing.ClassVar[QAccessible.Role] = ...
    ComboBox: typing.ClassVar[QAccessible.Role] = ...
    ComplementaryContent: typing.ClassVar[QAccessible.Role] = ...
    ContextHelpEnd: typing.ClassVar[QAccessible.Event] = ...
    ContextHelpStart: typing.ClassVar[QAccessible.Event] = ...
    Controlled: typing.ClassVar[QAccessible.RelationFlag] = ...
    Controller: typing.ClassVar[QAccessible.RelationFlag] = ...
    Cursor: typing.ClassVar[QAccessible.Role] = ...
    DebugDescription: typing.ClassVar[QAccessible.Text] = ...
    DefaultActionChanged: typing.ClassVar[QAccessible.Event] = ...
    Description: typing.ClassVar[QAccessible.Text] = ...
    DescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
    Desktop: typing.ClassVar[QAccessible.Role] = ...
    Dial: typing.ClassVar[QAccessible.Role] = ...
    Dialog: typing.ClassVar[QAccessible.Role] = ...
    DialogEnd: typing.ClassVar[QAccessible.Event] = ...
    DialogStart: typing.ClassVar[QAccessible.Event] = ...
    Document: typing.ClassVar[QAccessible.Role] = ...
    DocumentContentChanged: typing.ClassVar[QAccessible.Event] = ...
    DocumentLoadComplete: typing.ClassVar[QAccessible.Event] = ...
    DocumentLoadStopped: typing.ClassVar[QAccessible.Event] = ...
    DocumentReload: typing.ClassVar[QAccessible.Event] = ...
    DragDropEnd: typing.ClassVar[QAccessible.Event] = ...
    DragDropStart: typing.ClassVar[QAccessible.Event] = ...
    EditableText: typing.ClassVar[QAccessible.Role] = ...
    EditableTextInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    Equation: typing.ClassVar[QAccessible.Role] = ...
    Focus: typing.ClassVar[QAccessible.Event] = ...
    Footer: typing.ClassVar[QAccessible.Role] = ...
    ForegroundChanged: typing.ClassVar[QAccessible.Event] = ...
    Form: typing.ClassVar[QAccessible.Role] = ...
    Graphic: typing.ClassVar[QAccessible.Role] = ...
    Grip: typing.ClassVar[QAccessible.Role] = ...
    Grouping: typing.ClassVar[QAccessible.Role] = ...
    Heading: typing.ClassVar[QAccessible.Role] = ...
    Help: typing.ClassVar[QAccessible.Text] = ...
    HelpBalloon: typing.ClassVar[QAccessible.Role] = ...
    HelpChanged: typing.ClassVar[QAccessible.Event] = ...
    HotkeyField: typing.ClassVar[QAccessible.Role] = ...
    HyperlinkEndIndexChanged: typing.ClassVar[QAccessible.Event] = ...
    HyperlinkNumberOfAnchorsChanged: typing.ClassVar[QAccessible.Event] = ...
    HyperlinkSelectedLinkChanged: typing.ClassVar[QAccessible.Event] = ...
    HyperlinkStartIndexChanged: typing.ClassVar[QAccessible.Event] = ...
    HypertextChanged: typing.ClassVar[QAccessible.Event] = ...
    HypertextLinkActivated: typing.ClassVar[QAccessible.Event] = ...
    HypertextLinkSelected: typing.ClassVar[QAccessible.Event] = ...
    HypertextNLinksChanged: typing.ClassVar[QAccessible.Event] = ...
    ImageInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    Indicator: typing.ClassVar[QAccessible.Role] = ...
    InvalidEvent: typing.ClassVar[QAccessible.Event] = ...
    Label: typing.ClassVar[QAccessible.RelationFlag] = ...
    Labelled: typing.ClassVar[QAccessible.RelationFlag] = ...
    LayeredPane: typing.ClassVar[QAccessible.Role] = ...
    LineBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    Link: typing.ClassVar[QAccessible.Role] = ...
    List: typing.ClassVar[QAccessible.Role] = ...
    ListItem: typing.ClassVar[QAccessible.Role] = ...
    LocationChanged: typing.ClassVar[QAccessible.Event] = ...
    MenuBar: typing.ClassVar[QAccessible.Role] = ...
    MenuCommand: typing.ClassVar[QAccessible.Event] = ...
    MenuEnd: typing.ClassVar[QAccessible.Event] = ...
    MenuItem: typing.ClassVar[QAccessible.Role] = ...
    MenuStart: typing.ClassVar[QAccessible.Event] = ...
    Name: typing.ClassVar[QAccessible.Text] = ...
    NameChanged: typing.ClassVar[QAccessible.Event] = ...
    NoBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    NoRole: typing.ClassVar[QAccessible.Role] = ...
    Note: typing.ClassVar[QAccessible.Role] = ...
    Notification: typing.ClassVar[QAccessible.Role] = ...
    ObjectAttributeChanged: typing.ClassVar[QAccessible.Event] = ...
    ObjectCreated: typing.ClassVar[QAccessible.Event] = ...
    ObjectDestroyed: typing.ClassVar[QAccessible.Event] = ...
    ObjectHide: typing.ClassVar[QAccessible.Event] = ...
    ObjectReorder: typing.ClassVar[QAccessible.Event] = ...
    ObjectShow: typing.ClassVar[QAccessible.Event] = ...
    PageChanged: typing.ClassVar[QAccessible.Event] = ...
    PageTab: typing.ClassVar[QAccessible.Role] = ...
    PageTabList: typing.ClassVar[QAccessible.Role] = ...
    Pane: typing.ClassVar[QAccessible.Role] = ...
    Paragraph: typing.ClassVar[QAccessible.Role] = ...
    ParagraphBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    ParentChanged: typing.ClassVar[QAccessible.Event] = ...
    PopupMenu: typing.ClassVar[QAccessible.Role] = ...
    PopupMenuEnd: typing.ClassVar[QAccessible.Event] = ...
    PopupMenuStart: typing.ClassVar[QAccessible.Event] = ...
    ProgressBar: typing.ClassVar[QAccessible.Role] = ...
    PropertyPage: typing.ClassVar[QAccessible.Role] = ...
    PushButton: typing.ClassVar[QAccessible.Role] = ...
    RadioButton: typing.ClassVar[QAccessible.Role] = ...
    Row: typing.ClassVar[QAccessible.Role] = ...
    RowHeader: typing.ClassVar[QAccessible.Role] = ...
    ScrollBar: typing.ClassVar[QAccessible.Role] = ...
    ScrollingEnd: typing.ClassVar[QAccessible.Event] = ...
    ScrollingStart: typing.ClassVar[QAccessible.Event] = ...
    Section: typing.ClassVar[QAccessible.Role] = ...
    SectionChanged: typing.ClassVar[QAccessible.Event] = ...
    Selection: typing.ClassVar[QAccessible.Event] = ...
    SelectionAdd: typing.ClassVar[QAccessible.Event] = ...
    SelectionRemove: typing.ClassVar[QAccessible.Event] = ...
    SelectionWithin: typing.ClassVar[QAccessible.Event] = ...
    SentenceBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    Separator: typing.ClassVar[QAccessible.Role] = ...
    Slider: typing.ClassVar[QAccessible.Role] = ...
    Sound: typing.ClassVar[QAccessible.Role] = ...
    SoundPlayed: typing.ClassVar[QAccessible.Event] = ...
    SpinBox: typing.ClassVar[QAccessible.Role] = ...
    Splitter: typing.ClassVar[QAccessible.Role] = ...
    StateChanged: typing.ClassVar[QAccessible.Event] = ...
    StaticText: typing.ClassVar[QAccessible.Role] = ...
    StatusBar: typing.ClassVar[QAccessible.Role] = ...
    Table: typing.ClassVar[QAccessible.Role] = ...
    TableCaptionChanged: typing.ClassVar[QAccessible.Event] = ...
    TableCellInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    TableColumnDescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
    TableColumnHeaderChanged: typing.ClassVar[QAccessible.Event] = ...
    TableInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    TableModelChanged: typing.ClassVar[QAccessible.Event] = ...
    TableRowDescriptionChanged: typing.ClassVar[QAccessible.Event] = ...
    TableRowHeaderChanged: typing.ClassVar[QAccessible.Event] = ...
    TableSummaryChanged: typing.ClassVar[QAccessible.Event] = ...
    Terminal: typing.ClassVar[QAccessible.Role] = ...
    TextAttributeChanged: typing.ClassVar[QAccessible.Event] = ...
    TextCaretMoved: typing.ClassVar[QAccessible.Event] = ...
    TextColumnChanged: typing.ClassVar[QAccessible.Event] = ...
    TextInserted: typing.ClassVar[QAccessible.Event] = ...
    TextInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    TextRemoved: typing.ClassVar[QAccessible.Event] = ...
    TextSelectionChanged: typing.ClassVar[QAccessible.Event] = ...
    TextUpdated: typing.ClassVar[QAccessible.Event] = ...
    TitleBar: typing.ClassVar[QAccessible.Role] = ...
    ToolBar: typing.ClassVar[QAccessible.Role] = ...
    ToolTip: typing.ClassVar[QAccessible.Role] = ...
    Tree: typing.ClassVar[QAccessible.Role] = ...
    TreeItem: typing.ClassVar[QAccessible.Role] = ...
    UserRole: typing.ClassVar[QAccessible.Role] = ...
    UserText: typing.ClassVar[QAccessible.Text] = ...
    Value: typing.ClassVar[QAccessible.Text] = ...
    ValueChanged: typing.ClassVar[QAccessible.Event] = ...
    ValueInterface: typing.ClassVar[QAccessible.InterfaceType] = ...
    VisibleDataChanged: typing.ClassVar[QAccessible.Event] = ...
    WebDocument: typing.ClassVar[QAccessible.Role] = ...
    Whitespace: typing.ClassVar[QAccessible.Role] = ...
    Window: typing.ClassVar[QAccessible.Role] = ...
    WordBoundary: typing.ClassVar[QAccessible.TextBoundaryType] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def accessibleInterface(cls, uniqueId: int) -> QAccessibleInterface: ...
    @classmethod
    def cleanup(cls) -> None: ...
    @classmethod
    def deleteAccessibleInterface(cls, uniqueId: int) -> None: ...
    @classmethod
    def isActive(cls) -> bool: ...
    @classmethod
    def qAccessibleTextBoundaryHelper(cls, cursor: QTextCursor, boundaryType: QAccessible.TextBoundaryType) -> typing.Tuple[int,int]: ...
    @classmethod
    def queryAccessibleInterface(cls, arg__1: PySide2.QtCore.QObject) -> QAccessibleInterface: ...
    @classmethod
    def registerAccessibleInterface(cls, iface: QAccessibleInterface) -> int: ...
    @classmethod
    def setActive(cls, active: bool) -> None: ...
    @classmethod
    def setRootObject(cls, object: PySide2.QtCore.QObject) -> None: ...
    @classmethod
    def uniqueId(cls, iface: QAccessibleInterface) -> int: ...
    @classmethod
    def updateAccessibility(cls, event: QAccessibleEvent) -> None: ...
    def __copy__(self) -> None: ...

class QAccessibleEditableTextInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def deleteText(self, startOffset: int, endOffset: int) -> None: ...
    def insertText(self, offset: int, text: str) -> None: ...
    def replaceText(self, startOffset: int, endOffset: int, text: str) -> None: ...

class QAccessibleEvent(shiboken2.Object):
    @overload
    def __init__(self, iface: QAccessibleInterface, typ: QAccessible.Event) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, typ: QAccessible.Event) -> None: ...
    def accessibleInterface(self) -> QAccessibleInterface: ...
    def child(self) -> int: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def setChild(self, chld: int) -> None: ...
    def type(self) -> QAccessible.Event: ...
    def uniqueId(self) -> int: ...

class QAccessibleInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def backgroundColor(self) -> QColor: ...
    def child(self, index: int) -> QAccessibleInterface: ...
    def childAt(self, x: int, y: int) -> QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def editableTextInterface(self) -> QAccessibleEditableTextInterface: ...
    def focusChild(self) -> QAccessibleInterface: ...
    def foregroundColor(self) -> QColor: ...
    def indexOfChild(self, arg__1: QAccessibleInterface) -> int: ...
    def interface_cast(self, arg__1: QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def parent(self) -> QAccessibleInterface: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match: typing.Union[QAccessible.Relation,QAccessible.RelationFlag] = ...) -> typing.List[typing.Tuple[QAccessibleInterface,QAccessible.Relation]]: ...
    def role(self) -> QAccessible.Role: ...
    def setText(self, t: QAccessible.Text, text: str) -> None: ...
    def state(self) -> QAccessible.State: ...
    def tableCellInterface(self) -> QAccessibleTableCellInterface: ...
    def text(self, t: QAccessible.Text) -> str: ...
    def textInterface(self) -> QAccessibleTextInterface: ...
    def valueInterface(self) -> QAccessibleValueInterface: ...
    def virtual_hook(self, id: int, data: int) -> None: ...
    def window(self) -> QWindow: ...

class QAccessibleObject(QAccessibleInterface):
    def __init__(self, object: PySide2.QtCore.QObject) -> None: ...
    def childAt(self, x: int, y: int) -> QAccessibleInterface: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def setText(self, t: QAccessible.Text, text: str) -> None: ...

class QAccessibleStateChangeEvent(QAccessibleEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, state: QAccessible.State) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, state: QAccessible.State) -> None: ...
    def changedStates(self) -> QAccessible.State: ...

class QAccessibleTableCellInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def columnExtent(self) -> int: ...
    def columnHeaderCells(self) -> typing.List[QAccessibleInterface]: ...
    def columnIndex(self) -> int: ...
    def isSelected(self) -> bool: ...
    def rowExtent(self) -> int: ...
    def rowHeaderCells(self) -> typing.List[QAccessibleInterface]: ...
    def rowIndex(self) -> int: ...
    def table(self) -> QAccessibleInterface: ...

class QAccessibleTableModelChangeEvent(QAccessibleEvent):
    class ModelChangeType:
        ColumnsInserted: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        ColumnsRemoved: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        DataChanged: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        ModelReset: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        RowsInserted: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        RowsRemoved: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __and__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
    ColumnsInserted: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    ColumnsRemoved: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    DataChanged: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    ModelReset: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    RowsInserted: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    RowsRemoved: typing.ClassVar[QAccessibleTableModelChangeEvent.ModelChangeType] = ...
    @overload
    def __init__(self, iface: QAccessibleInterface, changeType: QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, changeType: QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    def firstColumn(self) -> int: ...
    def firstRow(self) -> int: ...
    def lastColumn(self) -> int: ...
    def lastRow(self) -> int: ...
    def modelChangeType(self) -> QAccessibleTableModelChangeEvent.ModelChangeType: ...
    def setFirstColumn(self, col: int) -> None: ...
    def setFirstRow(self, row: int) -> None: ...
    def setLastColumn(self, col: int) -> None: ...
    def setLastRow(self, row: int) -> None: ...
    def setModelChangeType(self, changeType: QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...

class QAccessibleTextCursorEvent(QAccessibleEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, cursorPos: int) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, cursorPos: int) -> None: ...
    def cursorPosition(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...

class QAccessibleTextInsertEvent(QAccessibleTextCursorEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, position: int, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str) -> None: ...
    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...

class QAccessibleTextInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def addSelection(self, startOffset: int, endOffset: int) -> None: ...
    def attributes(self, offset: int) -> typing.Tuple[str,int,int]: ...
    def characterCount(self) -> int: ...
    def characterRect(self, offset: int) -> PySide2.QtCore.QRect: ...
    def cursorPosition(self) -> int: ...
    def offsetAtPoint(self, point: PySide2.QtCore.QPoint) -> int: ...
    def removeSelection(self, selectionIndex: int) -> None: ...
    def scrollToSubstring(self, startIndex: int, endIndex: int) -> None: ...
    def selection(self, selectionIndex: int) -> typing.Tuple[int,int]: ...
    def selectionCount(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...
    def setSelection(self, selectionIndex: int, startOffset: int, endOffset: int) -> None: ...
    def text(self, startOffset: int, endOffset: int) -> str: ...
    def textAfterOffset(self, offset: int, boundaryType: QAccessible.TextBoundaryType) -> typing.Tuple[str,int,int]: ...
    def textAtOffset(self, offset: int, boundaryType: QAccessible.TextBoundaryType) -> typing.Tuple[str,int,int]: ...
    def textBeforeOffset(self, offset: int, boundaryType: QAccessible.TextBoundaryType) -> typing.Tuple[str,int,int]: ...

class QAccessibleTextRemoveEvent(QAccessibleTextCursorEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, position: int, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, text: str) -> None: ...
    def changePosition(self) -> int: ...
    def textRemoved(self) -> str: ...

class QAccessibleTextSelectionEvent(QAccessibleTextCursorEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, start: int, end: int) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, start: int, end: int) -> None: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setSelection(self, start: int, end: int) -> None: ...

class QAccessibleTextUpdateEvent(QAccessibleTextCursorEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, position: int, oldText: str, text: str) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, position: int, oldText: str, text: str) -> None: ...
    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...
    def textRemoved(self) -> str: ...

class QAccessibleValueChangeEvent(QAccessibleEvent):
    @overload
    def __init__(self, iface: QAccessibleInterface, val: typing.Any) -> None: ...
    @overload
    def __init__(self, obj: PySide2.QtCore.QObject, val: typing.Any) -> None: ...
    def setValue(self, val: typing.Any) -> None: ...
    def value(self) -> typing.Any: ...

class QAccessibleValueInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def currentValue(self) -> typing.Any: ...
    def maximumValue(self) -> typing.Any: ...
    def minimumStepSize(self) -> typing.Any: ...
    def minimumValue(self) -> typing.Any: ...
    def setCurrentValue(self, value: typing.Any) -> None: ...

class QActionEvent(PySide2.QtCore.QEvent):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QBackingStore(shiboken2.Object):
    def __init__(self, window: QWindow) -> None: ...
    def beginPaint(self, arg__1: QRegion) -> None: ...
    def endPaint(self) -> None: ...
    def flush(self, region: QRegion, window: typing.Union[QWindow,None] = ..., offset: PySide2.QtCore.QPoint = ...) -> None: ...
    def hasStaticContents(self) -> bool: ...
    def paintDevice(self) -> QPaintDevice: ...
    def resize(self, size: PySide2.QtCore.QSize) -> None: ...
    def scroll(self, area: QRegion, dx: int, dy: int) -> bool: ...
    def setStaticContents(self, region: QRegion) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def staticContents(self) -> QRegion: ...
    def window(self) -> QWindow: ...

class QBitmap(QPixmap):
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @overload
    def __init__(self, arg__1: QPixmap) -> None: ...
    @overload
    def __init__(self, other: QBitmap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    @classmethod
    def fromData(cls, size: PySide2.QtCore.QSize, bits: bytes, monoFormat: QImage.Format = ...) -> QBitmap: ...
    @overload
    @classmethod
    def fromImage(cls, image: QImage, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QBitmap: ...
    @overload
    @classmethod
    def fromImage(cls, image: QImage, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QPixmap: ...
    @overload
    def swap(self, other: QBitmap) -> None: ...
    @overload
    def swap(self, other: QPixmap) -> None: ...
    @overload
    def transformed(self, arg__1: QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    @overload
    def transformed(self, arg__1: QMatrix) -> QBitmap: ...
    @overload
    def transformed(self, matrix: QTransform) -> QBitmap: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...

class QBrush(shiboken2.Object):
    @overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, bs: PySide2.QtCore.Qt.BrushStyle = ...) -> None: ...
    @overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor, pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], bs: PySide2.QtCore.Qt.BrushStyle = ...) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def __init__(self, bs: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def __init__(self, gradient: QGradient) -> None: ...
    @overload
    def __init__(self, image: QImage) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def color(self) -> QColor: ...
    def gradient(self) -> QGradient: ...
    def isOpaque(self) -> bool: ...
    def matrix(self) -> QMatrix: ...
    @overload
    def setColor(self, color: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def setColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setMatrix(self, mat: QMatrix) -> None: ...
    def setStyle(self, arg__1: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    def setTexture(self, pixmap: QPixmap) -> None: ...
    def setTextureImage(self, image: QImage) -> None: ...
    def setTransform(self, arg__1: QTransform) -> None: ...
    def style(self) -> PySide2.QtCore.Qt.BrushStyle: ...
    def swap(self, other: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def texture(self) -> QPixmap: ...
    def textureImage(self) -> QImage: ...
    def transform(self) -> QTransform: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QClipboard(PySide2.QtCore.QObject):
    class Mode:
        Clipboard: typing.ClassVar[QClipboard.Mode] = ...
        FindBuffer: typing.ClassVar[QClipboard.Mode] = ...
        LastMode: typing.ClassVar[QClipboard.Mode] = ...
        Selection: typing.ClassVar[QClipboard.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QClipboard.Mode: ...
    Clipboard: typing.ClassVar[QClipboard.Mode] = ...
    FindBuffer: typing.ClassVar[QClipboard.Mode] = ...
    LastMode: typing.ClassVar[QClipboard.Mode] = ...
    Selection: typing.ClassVar[QClipboard.Mode] = ...
    changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    findBufferChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def clear(self, mode: QClipboard.Mode = ...) -> None: ...
    def image(self, mode: QClipboard.Mode = ...) -> QImage: ...
    def mimeData(self, mode: QClipboard.Mode = ...) -> PySide2.QtCore.QMimeData: ...
    def ownsClipboard(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsSelection(self) -> bool: ...
    def pixmap(self, mode: QClipboard.Mode = ...) -> QPixmap: ...
    def setImage(self, arg__1: QImage, mode: QClipboard.Mode = ...) -> None: ...
    def setMimeData(self, data: PySide2.QtCore.QMimeData, mode: QClipboard.Mode = ...) -> None: ...
    def setPixmap(self, arg__1: QPixmap, mode: QClipboard.Mode = ...) -> None: ...
    def setText(self, arg__1: str, mode: QClipboard.Mode = ...) -> None: ...
    def supportsFindBuffer(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    @overload
    def text(self, subtype: str, mode: QClipboard.Mode = ...) -> str: ...
    @overload
    def text(self, mode: QClipboard.Mode = ...) -> str: ...

class QCloseEvent(PySide2.QtCore.QEvent):
    def __init__(self) -> None: ...

class QColor(shiboken2.Object):
    class NameFormat:
        HexArgb: typing.ClassVar[QColor.NameFormat] = ...
        HexRgb: typing.ClassVar[QColor.NameFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QColor.NameFormat: ...

    class Spec:
        Cmyk: typing.ClassVar[QColor.Spec] = ...
        ExtendedRgb: typing.ClassVar[QColor.Spec] = ...
        Hsl: typing.ClassVar[QColor.Spec] = ...
        Hsv: typing.ClassVar[QColor.Spec] = ...
        Invalid: typing.ClassVar[QColor.Spec] = ...
        Rgb: typing.ClassVar[QColor.Spec] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __and__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __rand__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __ror__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __sub__(self, other: typing.SupportsInt) -> QColor.Spec: ...
        def __xor__(self, other: typing.SupportsInt) -> QColor.Spec: ...
    Cmyk: typing.ClassVar[QColor.Spec] = ...
    ExtendedRgb: typing.ClassVar[QColor.Spec] = ...
    HexArgb: typing.ClassVar[QColor.NameFormat] = ...
    HexRgb: typing.ClassVar[QColor.NameFormat] = ...
    Hsl: typing.ClassVar[QColor.Spec] = ...
    Hsv: typing.ClassVar[QColor.Spec] = ...
    Invalid: typing.ClassVar[QColor.Spec] = ...
    Rgb: typing.ClassVar[QColor.Spec] = ...
    @overload
    def __init__(self, spec: QColor.Spec, a1: int, a2: int, a3: int, a4: int, a5: int = ...) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Any) -> None: ...
    @overload
    def __init__(self, color: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, rgb: int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alpha(self) -> int: ...
    def alphaF(self) -> float: ...
    def black(self) -> int: ...
    def blackF(self) -> float: ...
    def blue(self) -> int: ...
    def blueF(self) -> float: ...
    @classmethod
    def colorNames(cls) -> typing.List[str]: ...
    def convertTo(self, colorSpec: QColor.Spec) -> QColor: ...
    def cyan(self) -> int: ...
    def cyanF(self) -> float: ...
    def dark(self, f: int = ...) -> QColor: ...
    def darker(self, f: int = ...) -> QColor: ...
    @classmethod
    def fromCmyk(cls, c: int, m: int, y: int, k: int, a: int = ...) -> QColor: ...
    @classmethod
    def fromCmykF(cls, c: float, m: float, y: float, k: float, a: float = ...) -> QColor: ...
    @classmethod
    def fromHsl(cls, h: int, s: int, l: int, a: int = ...) -> QColor: ...
    @classmethod
    def fromHslF(cls, h: float, s: float, l: float, a: float = ...) -> QColor: ...
    @classmethod
    def fromHsv(cls, h: int, s: int, v: int, a: int = ...) -> QColor: ...
    @classmethod
    def fromHsvF(cls, h: float, s: float, v: float, a: float = ...) -> QColor: ...
    @overload
    @classmethod
    def fromRgb(cls, r: int, g: int, b: int, a: int = ...) -> QColor: ...
    @overload
    @classmethod
    def fromRgb(cls, rgb: int) -> QColor: ...
    @classmethod
    def fromRgbF(cls, r: float, g: float, b: float, a: float = ...) -> QColor: ...
    @classmethod
    def fromRgba(cls, rgba: int) -> QColor: ...
    @classmethod
    def fromRgba64(cls, r: int, g: int, b: int, a: int = ...) -> QColor: ...
    def getCmyk(self) -> typing.Tuple[int,int,int,int,int]: ...
    def getCmykF(self) -> typing.Tuple[float,float,float,float,float]: ...
    def getHsl(self) -> typing.Tuple[int,int,int,int]: ...
    def getHslF(self) -> typing.Tuple[float,float,float,float]: ...
    def getHsv(self) -> typing.Tuple[int,int,int,int]: ...
    def getHsvF(self) -> typing.Tuple[float,float,float,float]: ...
    def getRgb(self) -> typing.Tuple[int,int,int,int]: ...
    def getRgbF(self) -> typing.Tuple[float,float,float,float]: ...
    def green(self) -> int: ...
    def greenF(self) -> float: ...
    def hslHue(self) -> int: ...
    def hslHueF(self) -> float: ...
    def hslSaturation(self) -> int: ...
    def hslSaturationF(self) -> float: ...
    def hsvHue(self) -> int: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hue(self) -> int: ...
    def hueF(self) -> float: ...
    def isValid(self) -> bool: ...
    @classmethod
    def isValidColor(cls, name: str) -> bool: ...
    def light(self, f: int = ...) -> QColor: ...
    def lighter(self, f: int = ...) -> QColor: ...
    def lightness(self) -> int: ...
    def lightnessF(self) -> float: ...
    def magenta(self) -> int: ...
    def magentaF(self) -> float: ...
    @overload
    def name(self, format: QColor.NameFormat) -> str: ...
    @overload
    def name(self) -> str: ...
    def red(self) -> int: ...
    def redF(self) -> float: ...
    def rgb(self) -> int: ...
    def rgba(self) -> int: ...
    def saturation(self) -> int: ...
    def saturationF(self) -> float: ...
    def setAlpha(self, alpha: int) -> None: ...
    def setAlphaF(self, alpha: float) -> None: ...
    def setBlue(self, blue: int) -> None: ...
    def setBlueF(self, blue: float) -> None: ...
    def setCmyk(self, c: int, m: int, y: int, k: int, a: int = ...) -> None: ...
    def setCmykF(self, c: float, m: float, y: float, k: float, a: float = ...) -> None: ...
    def setGreen(self, green: int) -> None: ...
    def setGreenF(self, green: float) -> None: ...
    def setHsl(self, h: int, s: int, l: int, a: int = ...) -> None: ...
    def setHslF(self, h: float, s: float, l: float, a: float = ...) -> None: ...
    def setHsv(self, h: int, s: int, v: int, a: int = ...) -> None: ...
    def setHsvF(self, h: float, s: float, v: float, a: float = ...) -> None: ...
    def setNamedColor(self, name: str) -> None: ...
    def setRed(self, red: int) -> None: ...
    def setRedF(self, red: float) -> None: ...
    @overload
    def setRgb(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @overload
    def setRgb(self, rgb: int) -> None: ...
    def setRgbF(self, r: float, g: float, b: float, a: float = ...) -> None: ...
    def setRgba(self, rgba: int) -> None: ...
    def spec(self) -> QColor.Spec: ...
    def toCmyk(self) -> QColor: ...
    def toExtendedRgb(self) -> QColor: ...
    def toHsl(self) -> QColor: ...
    def toHsv(self) -> QColor: ...
    def toRgb(self) -> QColor: ...
    def toTuple(self) -> object: ...
    def value(self) -> int: ...
    def valueF(self) -> float: ...
    def yellow(self) -> int: ...
    def yellowF(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __setstate__(self, arg__1: object) -> object: ...

class QColorConstants(shiboken2.Object):
    class Svg(shiboken2.Object):
        aliceblue: typing.ClassVar[QColor] = ...
        antiquewhite: typing.ClassVar[QColor] = ...
        aqua: typing.ClassVar[QColor] = ...
        aquamarine: typing.ClassVar[QColor] = ...
        azure: typing.ClassVar[QColor] = ...
        beige: typing.ClassVar[QColor] = ...
        bisque: typing.ClassVar[QColor] = ...
        black: typing.ClassVar[QColor] = ...
        blanchedalmond: typing.ClassVar[QColor] = ...
        blue: typing.ClassVar[QColor] = ...
        blueviolet: typing.ClassVar[QColor] = ...
        brown: typing.ClassVar[QColor] = ...
        burlywood: typing.ClassVar[QColor] = ...
        cadetblue: typing.ClassVar[QColor] = ...
        chartreuse: typing.ClassVar[QColor] = ...
        chocolate: typing.ClassVar[QColor] = ...
        coral: typing.ClassVar[QColor] = ...
        cornflowerblue: typing.ClassVar[QColor] = ...
        cornsilk: typing.ClassVar[QColor] = ...
        crimson: typing.ClassVar[QColor] = ...
        cyan: typing.ClassVar[QColor] = ...
        darkblue: typing.ClassVar[QColor] = ...
        darkcyan: typing.ClassVar[QColor] = ...
        darkgoldenrod: typing.ClassVar[QColor] = ...
        darkgray: typing.ClassVar[QColor] = ...
        darkgreen: typing.ClassVar[QColor] = ...
        darkgrey: typing.ClassVar[QColor] = ...
        darkkhaki: typing.ClassVar[QColor] = ...
        darkmagenta: typing.ClassVar[QColor] = ...
        darkolivegreen: typing.ClassVar[QColor] = ...
        darkorange: typing.ClassVar[QColor] = ...
        darkorchid: typing.ClassVar[QColor] = ...
        darkred: typing.ClassVar[QColor] = ...
        darksalmon: typing.ClassVar[QColor] = ...
        darkseagreen: typing.ClassVar[QColor] = ...
        darkslateblue: typing.ClassVar[QColor] = ...
        darkslategray: typing.ClassVar[QColor] = ...
        darkslategrey: typing.ClassVar[QColor] = ...
        darkturquoise: typing.ClassVar[QColor] = ...
        darkviolet: typing.ClassVar[QColor] = ...
        deeppink: typing.ClassVar[QColor] = ...
        deepskyblue: typing.ClassVar[QColor] = ...
        dimgray: typing.ClassVar[QColor] = ...
        dimgrey: typing.ClassVar[QColor] = ...
        dodgerblue: typing.ClassVar[QColor] = ...
        firebrick: typing.ClassVar[QColor] = ...
        floralwhite: typing.ClassVar[QColor] = ...
        forestgreen: typing.ClassVar[QColor] = ...
        fuchsia: typing.ClassVar[QColor] = ...
        gainsboro: typing.ClassVar[QColor] = ...
        ghostwhite: typing.ClassVar[QColor] = ...
        gold: typing.ClassVar[QColor] = ...
        goldenrod: typing.ClassVar[QColor] = ...
        gray: typing.ClassVar[QColor] = ...
        green: typing.ClassVar[QColor] = ...
        greenyellow: typing.ClassVar[QColor] = ...
        grey: typing.ClassVar[QColor] = ...
        honeydew: typing.ClassVar[QColor] = ...
        hotpink: typing.ClassVar[QColor] = ...
        indianred: typing.ClassVar[QColor] = ...
        indigo: typing.ClassVar[QColor] = ...
        ivory: typing.ClassVar[QColor] = ...
        khaki: typing.ClassVar[QColor] = ...
        lavender: typing.ClassVar[QColor] = ...
        lavenderblush: typing.ClassVar[QColor] = ...
        lawngreen: typing.ClassVar[QColor] = ...
        lemonchiffon: typing.ClassVar[QColor] = ...
        lightblue: typing.ClassVar[QColor] = ...
        lightcoral: typing.ClassVar[QColor] = ...
        lightcyan: typing.ClassVar[QColor] = ...
        lightgoldenrodyellow: typing.ClassVar[QColor] = ...
        lightgray: typing.ClassVar[QColor] = ...
        lightgreen: typing.ClassVar[QColor] = ...
        lightgrey: typing.ClassVar[QColor] = ...
        lightpink: typing.ClassVar[QColor] = ...
        lightsalmon: typing.ClassVar[QColor] = ...
        lightseagreen: typing.ClassVar[QColor] = ...
        lightskyblue: typing.ClassVar[QColor] = ...
        lightslategray: typing.ClassVar[QColor] = ...
        lightslategrey: typing.ClassVar[QColor] = ...
        lightsteelblue: typing.ClassVar[QColor] = ...
        lightyellow: typing.ClassVar[QColor] = ...
        lime: typing.ClassVar[QColor] = ...
        limegreen: typing.ClassVar[QColor] = ...
        linen: typing.ClassVar[QColor] = ...
        magenta: typing.ClassVar[QColor] = ...
        maroon: typing.ClassVar[QColor] = ...
        mediumaquamarine: typing.ClassVar[QColor] = ...
        mediumblue: typing.ClassVar[QColor] = ...
        mediumorchid: typing.ClassVar[QColor] = ...
        mediumpurple: typing.ClassVar[QColor] = ...
        mediumseagreen: typing.ClassVar[QColor] = ...
        mediumslateblue: typing.ClassVar[QColor] = ...
        mediumspringgreen: typing.ClassVar[QColor] = ...
        mediumturquoise: typing.ClassVar[QColor] = ...
        mediumvioletred: typing.ClassVar[QColor] = ...
        midnightblue: typing.ClassVar[QColor] = ...
        mintcream: typing.ClassVar[QColor] = ...
        mistyrose: typing.ClassVar[QColor] = ...
        moccasin: typing.ClassVar[QColor] = ...
        navajowhite: typing.ClassVar[QColor] = ...
        navy: typing.ClassVar[QColor] = ...
        oldlace: typing.ClassVar[QColor] = ...
        olive: typing.ClassVar[QColor] = ...
        olivedrab: typing.ClassVar[QColor] = ...
        orange: typing.ClassVar[QColor] = ...
        orangered: typing.ClassVar[QColor] = ...
        orchid: typing.ClassVar[QColor] = ...
        palegoldenrod: typing.ClassVar[QColor] = ...
        palegreen: typing.ClassVar[QColor] = ...
        paleturquoise: typing.ClassVar[QColor] = ...
        palevioletred: typing.ClassVar[QColor] = ...
        papayawhip: typing.ClassVar[QColor] = ...
        peachpuff: typing.ClassVar[QColor] = ...
        peru: typing.ClassVar[QColor] = ...
        pink: typing.ClassVar[QColor] = ...
        plum: typing.ClassVar[QColor] = ...
        powderblue: typing.ClassVar[QColor] = ...
        purple: typing.ClassVar[QColor] = ...
        red: typing.ClassVar[QColor] = ...
        rosybrown: typing.ClassVar[QColor] = ...
        royalblue: typing.ClassVar[QColor] = ...
        saddlebrown: typing.ClassVar[QColor] = ...
        salmon: typing.ClassVar[QColor] = ...
        sandybrown: typing.ClassVar[QColor] = ...
        seagreen: typing.ClassVar[QColor] = ...
        seashell: typing.ClassVar[QColor] = ...
        sienna: typing.ClassVar[QColor] = ...
        silver: typing.ClassVar[QColor] = ...
        skyblue: typing.ClassVar[QColor] = ...
        slateblue: typing.ClassVar[QColor] = ...
        slategray: typing.ClassVar[QColor] = ...
        slategrey: typing.ClassVar[QColor] = ...
        snow: typing.ClassVar[QColor] = ...
        springgreen: typing.ClassVar[QColor] = ...
        steelblue: typing.ClassVar[QColor] = ...
        tan: typing.ClassVar[QColor] = ...
        teal: typing.ClassVar[QColor] = ...
        thistle: typing.ClassVar[QColor] = ...
        tomato: typing.ClassVar[QColor] = ...
        turquoise: typing.ClassVar[QColor] = ...
        violet: typing.ClassVar[QColor] = ...
        wheat: typing.ClassVar[QColor] = ...
        white: typing.ClassVar[QColor] = ...
        whitesmoke: typing.ClassVar[QColor] = ...
        yellow: typing.ClassVar[QColor] = ...
        yellowgreen: typing.ClassVar[QColor] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
    Black: typing.ClassVar[QColor] = ...
    Blue: typing.ClassVar[QColor] = ...
    Color0: typing.ClassVar[QColor] = ...
    Color1: typing.ClassVar[QColor] = ...
    Cyan: typing.ClassVar[QColor] = ...
    DarkBlue: typing.ClassVar[QColor] = ...
    DarkCyan: typing.ClassVar[QColor] = ...
    DarkGray: typing.ClassVar[QColor] = ...
    DarkGreen: typing.ClassVar[QColor] = ...
    DarkMagenta: typing.ClassVar[QColor] = ...
    DarkRed: typing.ClassVar[QColor] = ...
    DarkYellow: typing.ClassVar[QColor] = ...
    Gray: typing.ClassVar[QColor] = ...
    Green: typing.ClassVar[QColor] = ...
    LightGray: typing.ClassVar[QColor] = ...
    Magenta: typing.ClassVar[QColor] = ...
    Red: typing.ClassVar[QColor] = ...
    Transparent: typing.ClassVar[QColor] = ...
    White: typing.ClassVar[QColor] = ...
    Yellow: typing.ClassVar[QColor] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QColorSpace(shiboken2.Object):
    class NamedColorSpace:
        AdobeRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
        DisplayP3: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
        ProPhotoRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
        SRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
        SRgbLinear: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __and__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __rand__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __ror__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __sub__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...
        def __xor__(self, other: typing.SupportsInt) -> QColorSpace.NamedColorSpace: ...

    class Primaries:
        AdobeRgb: typing.ClassVar[QColorSpace.Primaries] = ...
        Custom: typing.ClassVar[QColorSpace.Primaries] = ...
        DciP3D65: typing.ClassVar[QColorSpace.Primaries] = ...
        ProPhotoRgb: typing.ClassVar[QColorSpace.Primaries] = ...
        SRgb: typing.ClassVar[QColorSpace.Primaries] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __and__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __rand__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __ror__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __sub__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...
        def __xor__(self, other: typing.SupportsInt) -> QColorSpace.Primaries: ...

    class TransferFunction:
        Custom: typing.ClassVar[QColorSpace.TransferFunction] = ...
        Gamma: typing.ClassVar[QColorSpace.TransferFunction] = ...
        Linear: typing.ClassVar[QColorSpace.TransferFunction] = ...
        ProPhotoRgb: typing.ClassVar[QColorSpace.TransferFunction] = ...
        SRgb: typing.ClassVar[QColorSpace.TransferFunction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __and__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __rand__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __ror__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __sub__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
        def __xor__(self, other: typing.SupportsInt) -> QColorSpace.TransferFunction: ...
    AdobeRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
    DisplayP3: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
    ProPhotoRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
    SRgb: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
    SRgbLinear: typing.ClassVar[QColorSpace.NamedColorSpace] = ...
    @overload
    def __init__(self, whitePoint: PySide2.QtCore.QPointF, redPoint: PySide2.QtCore.QPointF, greenPoint: PySide2.QtCore.QPointF, bluePoint: PySide2.QtCore.QPointF, fun: QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @overload
    def __init__(self, primaries: QColorSpace.Primaries, fun: QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @overload
    def __init__(self, primaries: QColorSpace.Primaries, gamma: float) -> None: ...
    @overload
    def __init__(self, colorSpace: QColorSpace) -> None: ...
    @overload
    def __init__(self, namedColorSpace: QColorSpace.NamedColorSpace) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def fromIccProfile(cls, iccProfile: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> QColorSpace: ...
    def gamma(self) -> float: ...
    def iccProfile(self) -> PySide2.QtCore.QByteArray: ...
    def isValid(self) -> bool: ...
    def primaries(self) -> QColorSpace.Primaries: ...
    @overload
    def setPrimaries(self, whitePoint: PySide2.QtCore.QPointF, redPoint: PySide2.QtCore.QPointF, greenPoint: PySide2.QtCore.QPointF, bluePoint: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setPrimaries(self, primariesId: QColorSpace.Primaries) -> None: ...
    def setTransferFunction(self, transferFunction: QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    def swap(self, colorSpace: QColorSpace) -> None: ...
    def transferFunction(self) -> QColorSpace.TransferFunction: ...
    def withTransferFunction(self, transferFunction: QColorSpace.TransferFunction, gamma: float = ...) -> QColorSpace: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QConicalGradient(QGradient):
    @overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...
    @overload
    def __init__(self, center: PySide2.QtCore.QPointF, startAngle: float) -> None: ...
    @overload
    def __init__(self, QConicalGradient: QConicalGradient) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def angle(self) -> float: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def setAngle(self, angle: float) -> None: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...
    @overload
    def setCenter(self, center: PySide2.QtCore.QPointF) -> None: ...
    def __copy__(self) -> None: ...

class QContextMenuEvent(QInputEvent):
    class Reason:
        Keyboard: typing.ClassVar[QContextMenuEvent.Reason] = ...
        Mouse: typing.ClassVar[QContextMenuEvent.Reason] = ...
        Other: typing.ClassVar[QContextMenuEvent.Reason] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __and__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __rand__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __rmul__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __ror__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __rsub__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __rxor__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __sub__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
        def __xor__(self, other: typing.SupportsInt) -> QContextMenuEvent.Reason: ...
    Keyboard: typing.ClassVar[QContextMenuEvent.Reason] = ...
    Mouse: typing.ClassVar[QContextMenuEvent.Reason] = ...
    Other: typing.ClassVar[QContextMenuEvent.Reason] = ...
    @overload
    def __init__(self, reason: QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    @overload
    def __init__(self, reason: QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, reason: QContextMenuEvent.Reason, pos: PySide2.QtCore.QPoint) -> None: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def reason(self) -> QContextMenuEvent.Reason: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QCursor(shiboken2.Object):
    @overload
    def __init__(self, bitmap: QBitmap, mask: QBitmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, cursor: typing.Union[QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    @overload
    def __init__(self, shape: PySide2.QtCore.Qt.CursorShape) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bitmap(self) -> QBitmap: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> QBitmap: ...
    def pixmap(self) -> QPixmap: ...
    @overload
    @classmethod
    def pos(cls, screen: QScreen) -> PySide2.QtCore.QPoint: ...
    @overload
    @classmethod
    def pos(cls) -> PySide2.QtCore.QPoint: ...
    @overload
    @classmethod
    def setPos(cls, screen: QScreen, x: int, y: int) -> None: ...
    @overload
    @classmethod
    def setPos(cls, screen: QScreen, p: PySide2.QtCore.QPoint) -> None: ...
    @overload
    @classmethod
    def setPos(cls, x: int, y: int) -> None: ...
    @overload
    @classmethod
    def setPos(cls, p: PySide2.QtCore.QPoint) -> None: ...
    def setShape(self, newShape: PySide2.QtCore.Qt.CursorShape) -> None: ...
    def shape(self) -> PySide2.QtCore.Qt.CursorShape: ...
    def swap(self, other: typing.Union[QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, outS: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, inS: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QDesktopServices(shiboken2.Object):
    def __init__(self) -> None: ...
    @classmethod
    def openUrl(cls, url: PySide2.QtCore.QUrl) -> bool: ...
    @classmethod
    def setUrlHandler(cls, scheme: str, receiver: PySide2.QtCore.QObject, method: bytes) -> None: ...
    @classmethod
    def unsetUrlHandler(cls, scheme: str) -> None: ...

class QDoubleValidator(QValidator):
    class Notation:
        ScientificNotation: typing.ClassVar[QDoubleValidator.Notation] = ...
        StandardNotation: typing.ClassVar[QDoubleValidator.Notation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __and__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __rand__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __ror__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __sub__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
        def __xor__(self, other: typing.SupportsInt) -> QDoubleValidator.Notation: ...
    ScientificNotation: typing.ClassVar[QDoubleValidator.Notation] = ...
    StandardNotation: typing.ClassVar[QDoubleValidator.Notation] = ...
    bottomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    decimalsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    topChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., bottomChanged: typing.Callable = ..., changed: typing.Callable = ..., decimalsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., notation: QDoubleValidator.Notation = ..., notationChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., topChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., bottom: float = ..., bottomChanged: typing.Callable = ..., changed: typing.Callable = ..., decimals: int = ..., decimalsChanged: typing.Callable = ..., destroyed: typing.Callable = ..., notation: QDoubleValidator.Notation = ..., notationChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., top: float = ..., topChanged: typing.Callable = ...) -> None: ...
    def bottom(self) -> float: ...
    def decimals(self) -> int: ...
    def notation(self) -> QDoubleValidator.Notation: ...
    def setBottom(self, arg__1: float) -> None: ...
    def setDecimals(self, arg__1: int) -> None: ...
    def setNotation(self, arg__1: QDoubleValidator.Notation) -> None: ...
    def setRange(self, bottom: float, top: float, decimals: int = ...) -> None: ...
    def setTop(self, arg__1: float) -> None: ...
    def top(self) -> float: ...
    def validate(self, arg__1: str, arg__2: int) -> QValidator.State: ...

class QDrag(PySide2.QtCore.QObject):
    actionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, dragSource: PySide2.QtCore.QObject, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def cancel(cls) -> None: ...
    def defaultAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dragCursor(self, action: PySide2.QtCore.Qt.DropAction) -> QPixmap: ...
    @overload
    def exec_(self, supportedActions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction], defaultAction: PySide2.QtCore.Qt.DropAction) -> PySide2.QtCore.Qt.DropAction: ...
    @overload
    def exec_(self, supportedActions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction] = ...) -> PySide2.QtCore.Qt.DropAction: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def pixmap(self) -> QPixmap: ...
    def setDragCursor(self, cursor: QPixmap, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def setHotSpot(self, hotspot: PySide2.QtCore.QPoint) -> None: ...
    def setMimeData(self, data: PySide2.QtCore.QMimeData) -> None: ...
    def setPixmap(self, arg__1: QPixmap) -> None: ...
    def source(self) -> PySide2.QtCore.QObject: ...
    def start(self, supportedActions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction] = ...) -> PySide2.QtCore.Qt.DropAction: ...
    def supportedActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def target(self) -> PySide2.QtCore.QObject: ...

class QDragEnterEvent(QDragMoveEvent):
    def __init__(self, pos: PySide2.QtCore.QPoint, actions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction], data: PySide2.QtCore.QMimeData, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...

class QDragLeaveEvent(PySide2.QtCore.QEvent):
    def __init__(self) -> None: ...

class QDragMoveEvent(QDropEvent):
    def __init__(self, pos: PySide2.QtCore.QPoint, actions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction], data: PySide2.QtCore.QMimeData, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], type: PySide2.QtCore.QEvent.Type = ...) -> None: ...
    @overload
    def accept(self, r: PySide2.QtCore.QRect) -> None: ...
    @overload
    def accept(self) -> None: ...
    def answerRect(self) -> PySide2.QtCore.QRect: ...
    @overload
    def ignore(self, r: PySide2.QtCore.QRect) -> None: ...
    @overload
    def ignore(self) -> None: ...

class QDropEvent(PySide2.QtCore.QEvent):
    def __init__(self, pos: PySide2.QtCore.QPointF, actions: typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction], data: PySide2.QtCore.QMimeData, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], type: PySide2.QtCore.QEvent.Type = ...) -> None: ...
    def acceptProposedAction(self) -> None: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def keyboardModifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def mouseButtons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def setDropAction(self, action: PySide2.QtCore.Qt.DropAction) -> None: ...
    def source(self) -> PySide2.QtCore.QObject: ...

class QEnterEvent(PySide2.QtCore.QEvent):
    def __init__(self, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF) -> None: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QExposeEvent(PySide2.QtCore.QEvent):
    rgn: typing.Any
    def __init__(self, rgn: QRegion) -> None: ...
    def region(self) -> QRegion: ...

class QFileOpenEvent(PySide2.QtCore.QEvent):
    @overload
    def __init__(self, file: str) -> None: ...
    @overload
    def __init__(self, url: PySide2.QtCore.QUrl) -> None: ...
    def file(self) -> str: ...
    def openFile(self, file: PySide2.QtCore.QFile, flags: typing.Union[PySide2.QtCore.QIODevice.OpenMode,PySide2.QtCore.QIODevice.OpenModeFlag]) -> bool: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QFocusEvent(PySide2.QtCore.QEvent):
    def __init__(self, type: PySide2.QtCore.QEvent.Type, reason: PySide2.QtCore.Qt.FocusReason = ...) -> None: ...
    def gotFocus(self) -> bool: ...
    def lostFocus(self) -> bool: ...
    def reason(self) -> PySide2.QtCore.Qt.FocusReason: ...

class QFont(shiboken2.Object):
    class Capitalization:
        AllLowercase: typing.ClassVar[QFont.Capitalization] = ...
        AllUppercase: typing.ClassVar[QFont.Capitalization] = ...
        Capitalize: typing.ClassVar[QFont.Capitalization] = ...
        MixedCase: typing.ClassVar[QFont.Capitalization] = ...
        SmallCaps: typing.ClassVar[QFont.Capitalization] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.Capitalization: ...

    class HintingPreference:
        PreferDefaultHinting: typing.ClassVar[QFont.HintingPreference] = ...
        PreferFullHinting: typing.ClassVar[QFont.HintingPreference] = ...
        PreferNoHinting: typing.ClassVar[QFont.HintingPreference] = ...
        PreferVerticalHinting: typing.ClassVar[QFont.HintingPreference] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.HintingPreference: ...

    class SpacingType:
        AbsoluteSpacing: typing.ClassVar[QFont.SpacingType] = ...
        PercentageSpacing: typing.ClassVar[QFont.SpacingType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.SpacingType: ...

    class Stretch:
        AnyStretch: typing.ClassVar[QFont.Stretch] = ...
        Condensed: typing.ClassVar[QFont.Stretch] = ...
        Expanded: typing.ClassVar[QFont.Stretch] = ...
        ExtraCondensed: typing.ClassVar[QFont.Stretch] = ...
        ExtraExpanded: typing.ClassVar[QFont.Stretch] = ...
        SemiCondensed: typing.ClassVar[QFont.Stretch] = ...
        SemiExpanded: typing.ClassVar[QFont.Stretch] = ...
        UltraCondensed: typing.ClassVar[QFont.Stretch] = ...
        UltraExpanded: typing.ClassVar[QFont.Stretch] = ...
        Unstretched: typing.ClassVar[QFont.Stretch] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.Stretch: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.Stretch: ...

    class Style:
        StyleItalic: typing.ClassVar[QFont.Style] = ...
        StyleNormal: typing.ClassVar[QFont.Style] = ...
        StyleOblique: typing.ClassVar[QFont.Style] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.Style: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.Style: ...

    class StyleHint:
        AnyStyle: typing.ClassVar[QFont.StyleHint] = ...
        Courier: typing.ClassVar[QFont.StyleHint] = ...
        Cursive: typing.ClassVar[QFont.StyleHint] = ...
        Decorative: typing.ClassVar[QFont.StyleHint] = ...
        Fantasy: typing.ClassVar[QFont.StyleHint] = ...
        Helvetica: typing.ClassVar[QFont.StyleHint] = ...
        Monospace: typing.ClassVar[QFont.StyleHint] = ...
        OldEnglish: typing.ClassVar[QFont.StyleHint] = ...
        SansSerif: typing.ClassVar[QFont.StyleHint] = ...
        Serif: typing.ClassVar[QFont.StyleHint] = ...
        System: typing.ClassVar[QFont.StyleHint] = ...
        Times: typing.ClassVar[QFont.StyleHint] = ...
        TypeWriter: typing.ClassVar[QFont.StyleHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.StyleHint: ...

    class StyleStrategy:
        ForceIntegerMetrics: typing.ClassVar[QFont.StyleStrategy] = ...
        ForceOutline: typing.ClassVar[QFont.StyleStrategy] = ...
        NoAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
        NoFontMerging: typing.ClassVar[QFont.StyleStrategy] = ...
        NoSubpixelAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
        OpenGLCompatible: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferBitmap: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferDefault: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferDevice: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferMatch: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferNoShaping: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferOutline: typing.ClassVar[QFont.StyleStrategy] = ...
        PreferQuality: typing.ClassVar[QFont.StyleStrategy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.StyleStrategy: ...

    class Weight:
        Black: typing.ClassVar[QFont.Weight] = ...
        Bold: typing.ClassVar[QFont.Weight] = ...
        DemiBold: typing.ClassVar[QFont.Weight] = ...
        ExtraBold: typing.ClassVar[QFont.Weight] = ...
        ExtraLight: typing.ClassVar[QFont.Weight] = ...
        Light: typing.ClassVar[QFont.Weight] = ...
        Medium: typing.ClassVar[QFont.Weight] = ...
        Normal: typing.ClassVar[QFont.Weight] = ...
        Thin: typing.ClassVar[QFont.Weight] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __and__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __rand__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __ror__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __sub__(self, other: typing.SupportsInt) -> QFont.Weight: ...
        def __xor__(self, other: typing.SupportsInt) -> QFont.Weight: ...
    AbsoluteSpacing: typing.ClassVar[QFont.SpacingType] = ...
    AllLowercase: typing.ClassVar[QFont.Capitalization] = ...
    AllUppercase: typing.ClassVar[QFont.Capitalization] = ...
    AnyStretch: typing.ClassVar[QFont.Stretch] = ...
    AnyStyle: typing.ClassVar[QFont.StyleHint] = ...
    Black: typing.ClassVar[QFont.Weight] = ...
    Bold: typing.ClassVar[QFont.Weight] = ...
    Capitalize: typing.ClassVar[QFont.Capitalization] = ...
    Condensed: typing.ClassVar[QFont.Stretch] = ...
    Courier: typing.ClassVar[QFont.StyleHint] = ...
    Cursive: typing.ClassVar[QFont.StyleHint] = ...
    Decorative: typing.ClassVar[QFont.StyleHint] = ...
    DemiBold: typing.ClassVar[QFont.Weight] = ...
    Expanded: typing.ClassVar[QFont.Stretch] = ...
    ExtraBold: typing.ClassVar[QFont.Weight] = ...
    ExtraCondensed: typing.ClassVar[QFont.Stretch] = ...
    ExtraExpanded: typing.ClassVar[QFont.Stretch] = ...
    ExtraLight: typing.ClassVar[QFont.Weight] = ...
    Fantasy: typing.ClassVar[QFont.StyleHint] = ...
    ForceIntegerMetrics: typing.ClassVar[QFont.StyleStrategy] = ...
    ForceOutline: typing.ClassVar[QFont.StyleStrategy] = ...
    Helvetica: typing.ClassVar[QFont.StyleHint] = ...
    Light: typing.ClassVar[QFont.Weight] = ...
    Medium: typing.ClassVar[QFont.Weight] = ...
    MixedCase: typing.ClassVar[QFont.Capitalization] = ...
    Monospace: typing.ClassVar[QFont.StyleHint] = ...
    NoAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
    NoFontMerging: typing.ClassVar[QFont.StyleStrategy] = ...
    NoSubpixelAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
    Normal: typing.ClassVar[QFont.Weight] = ...
    OldEnglish: typing.ClassVar[QFont.StyleHint] = ...
    OpenGLCompatible: typing.ClassVar[QFont.StyleStrategy] = ...
    PercentageSpacing: typing.ClassVar[QFont.SpacingType] = ...
    PreferAntialias: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferBitmap: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferDefault: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferDefaultHinting: typing.ClassVar[QFont.HintingPreference] = ...
    PreferDevice: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferFullHinting: typing.ClassVar[QFont.HintingPreference] = ...
    PreferMatch: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferNoHinting: typing.ClassVar[QFont.HintingPreference] = ...
    PreferNoShaping: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferOutline: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferQuality: typing.ClassVar[QFont.StyleStrategy] = ...
    PreferVerticalHinting: typing.ClassVar[QFont.HintingPreference] = ...
    SansSerif: typing.ClassVar[QFont.StyleHint] = ...
    SemiCondensed: typing.ClassVar[QFont.Stretch] = ...
    SemiExpanded: typing.ClassVar[QFont.Stretch] = ...
    Serif: typing.ClassVar[QFont.StyleHint] = ...
    SmallCaps: typing.ClassVar[QFont.Capitalization] = ...
    StyleItalic: typing.ClassVar[QFont.Style] = ...
    StyleNormal: typing.ClassVar[QFont.Style] = ...
    StyleOblique: typing.ClassVar[QFont.Style] = ...
    System: typing.ClassVar[QFont.StyleHint] = ...
    Thin: typing.ClassVar[QFont.Weight] = ...
    Times: typing.ClassVar[QFont.StyleHint] = ...
    TypeWriter: typing.ClassVar[QFont.StyleHint] = ...
    UltraCondensed: typing.ClassVar[QFont.Stretch] = ...
    UltraExpanded: typing.ClassVar[QFont.Stretch] = ...
    Unstretched: typing.ClassVar[QFont.Stretch] = ...
    @overload
    def __init__(self, family: str, pointSize: int = ..., weight: typing.SupportsInt = ..., italic: bool = ...) -> None: ...
    @overload
    def __init__(self, font: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, font: QFont) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bold(self) -> bool: ...
    @classmethod
    def cacheStatistics(cls) -> None: ...
    def capitalization(self) -> QFont.Capitalization: ...
    @classmethod
    def cleanup(cls) -> None: ...
    def defaultFamily(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def families(self) -> typing.List[str]: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def fromString(self, arg__1: str) -> bool: ...
    def hintingPreference(self) -> QFont.HintingPreference: ...
    @classmethod
    def initialize(cls) -> None: ...
    @classmethod
    def insertSubstitution(cls, arg__1: str, arg__2: str) -> None: ...
    @classmethod
    def insertSubstitutions(cls, arg__1: str, arg__2: typing.Iterable[str]) -> None: ...
    def isCopyOf(self, arg__1: QFont) -> bool: ...
    def italic(self) -> bool: ...
    def kerning(self) -> bool: ...
    def key(self) -> str: ...
    def lastResortFamily(self) -> str: ...
    def lastResortFont(self) -> str: ...
    def letterSpacing(self) -> float: ...
    def letterSpacingType(self) -> QFont.SpacingType: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def rawName(self) -> str: ...
    @classmethod
    def removeSubstitutions(cls, arg__1: str) -> None: ...
    @overload
    def resolve(self, arg__1: QFont) -> QFont: ...
    @overload
    def resolve(self, mask: int) -> None: ...
    @overload
    def resolve(self) -> int: ...
    def setBold(self, arg__1: bool) -> None: ...
    def setCapitalization(self, arg__1: QFont.Capitalization) -> None: ...
    def setFamilies(self, arg__1: typing.Iterable[str]) -> None: ...
    def setFamily(self, arg__1: str) -> None: ...
    def setFixedPitch(self, arg__1: bool) -> None: ...
    def setHintingPreference(self, hintingPreference: QFont.HintingPreference) -> None: ...
    def setItalic(self, b: bool) -> None: ...
    def setKerning(self, arg__1: bool) -> None: ...
    def setLetterSpacing(self, type: QFont.SpacingType, spacing: float) -> None: ...
    def setOverline(self, arg__1: bool) -> None: ...
    def setPixelSize(self, arg__1: int) -> None: ...
    def setPointSize(self, arg__1: int) -> None: ...
    def setPointSizeF(self, arg__1: float) -> None: ...
    def setRawMode(self, arg__1: bool) -> None: ...
    def setRawName(self, arg__1: str) -> None: ...
    def setStretch(self, arg__1: int) -> None: ...
    def setStrikeOut(self, arg__1: bool) -> None: ...
    def setStyle(self, style: QFont.Style) -> None: ...
    def setStyleHint(self, arg__1: QFont.StyleHint, strategy: QFont.StyleStrategy = ...) -> None: ...
    def setStyleName(self, arg__1: str) -> None: ...
    def setStyleStrategy(self, s: QFont.StyleStrategy) -> None: ...
    def setUnderline(self, arg__1: bool) -> None: ...
    def setWeight(self, arg__1: typing.Union[int,QFont.Weight]) -> None: ...
    def setWordSpacing(self, spacing: float) -> None: ...
    def stretch(self) -> int: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> QFont.Style: ...
    def styleHint(self) -> QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def styleStrategy(self) -> QFont.StyleStrategy: ...
    @classmethod
    def substitute(cls, arg__1: str) -> str: ...
    @classmethod
    def substitutes(cls, arg__1: str) -> typing.List[str]: ...
    @classmethod
    def substitutions(cls) -> typing.List[str]: ...
    def swap(self, other: QFont) -> None: ...
    def toString(self) -> str: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...
    def wordSpacing(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QFontDatabase(shiboken2.Object):
    class SystemFont:
        FixedFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
        GeneralFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
        SmallestReadableFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
        TitleFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __and__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __sub__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontDatabase.SystemFont: ...

    class WritingSystem:
        Any: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Arabic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Armenian: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Bengali: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Cyrillic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Devanagari: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Georgian: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Greek: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Gujarati: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Gurmukhi: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Hebrew: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Japanese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Kannada: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Khmer: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Korean: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Lao: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Latin: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Malayalam: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Myanmar: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Nko: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Ogham: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Oriya: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Other: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Runic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        SimplifiedChinese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Sinhala: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Symbol: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Syriac: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Tamil: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Telugu: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Thaana: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Thai: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Tibetan: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        TraditionalChinese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        Vietnamese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        WritingSystemsCount: typing.ClassVar[QFontDatabase.WritingSystem] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __and__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __rand__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __ror__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __sub__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
        def __xor__(self, other: typing.SupportsInt) -> QFontDatabase.WritingSystem: ...
    Any: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Arabic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Armenian: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Bengali: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Cyrillic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Devanagari: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    FixedFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
    GeneralFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
    Georgian: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Greek: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Gujarati: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Gurmukhi: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Hebrew: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Japanese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Kannada: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Khmer: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Korean: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Lao: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Latin: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Malayalam: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Myanmar: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Nko: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Ogham: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Oriya: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Other: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Runic: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    SimplifiedChinese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Sinhala: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    SmallestReadableFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
    Symbol: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Syriac: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Tamil: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Telugu: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Thaana: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Thai: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Tibetan: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    TitleFont: typing.ClassVar[QFontDatabase.SystemFont] = ...
    TraditionalChinese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    Vietnamese: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    WritingSystemsCount: typing.ClassVar[QFontDatabase.WritingSystem] = ...
    @overload
    def __init__(self, QFontDatabase: QFontDatabase) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def addApplicationFont(cls, fileName: str) -> int: ...
    @classmethod
    def addApplicationFontFromData(cls, fontData: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    @classmethod
    def applicationFontFamilies(cls, id: int) -> typing.List[str]: ...
    def bold(self, family: str, style: str) -> bool: ...
    def families(self, writingSystem: QFontDatabase.WritingSystem = ...) -> typing.List[str]: ...
    def font(self, family: str, style: str, pointSize: int) -> QFont: ...
    def hasFamily(self, family: str) -> bool: ...
    def isBitmapScalable(self, family: str, style: str = ...) -> bool: ...
    def isFixedPitch(self, family: str, style: str = ...) -> bool: ...
    def isPrivateFamily(self, family: str) -> bool: ...
    def isScalable(self, family: str, style: str = ...) -> bool: ...
    def isSmoothlyScalable(self, family: str, style: str = ...) -> bool: ...
    def italic(self, family: str, style: str) -> bool: ...
    def pointSizes(self, family: str, style: str = ...) -> typing.List[int]: ...
    @classmethod
    def removeAllApplicationFonts(cls) -> bool: ...
    @classmethod
    def removeApplicationFont(cls, id: int) -> bool: ...
    def smoothSizes(self, family: str, style: str) -> typing.List[int]: ...
    @classmethod
    def standardSizes(cls) -> typing.List[int]: ...
    @overload
    def styleString(self, font: QFont) -> str: ...
    @overload
    def styleString(self, fontInfo: QFontInfo) -> str: ...
    def styles(self, family: str) -> typing.List[str]: ...
    @classmethod
    def supportsThreadedFontRendering(cls) -> bool: ...
    @classmethod
    def systemFont(cls, type: QFontDatabase.SystemFont) -> QFont: ...
    def weight(self, family: str, style: str) -> int: ...
    @classmethod
    def writingSystemName(cls, writingSystem: QFontDatabase.WritingSystem) -> str: ...
    @classmethod
    def writingSystemSample(cls, writingSystem: QFontDatabase.WritingSystem) -> str: ...
    @overload
    def writingSystems(self, family: str) -> typing.List[QFontDatabase.WritingSystem]: ...
    @overload
    def writingSystems(self) -> typing.List[QFontDatabase.WritingSystem]: ...
    def __copy__(self) -> None: ...

class QFontInfo(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QFont) -> None: ...
    @overload
    def __init__(self, arg__1: QFontInfo) -> None: ...
    def bold(self) -> bool: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def italic(self) -> bool: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> QFont.Style: ...
    def styleHint(self) -> QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def swap(self, other: QFontInfo) -> None: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...
    def __copy__(self) -> None: ...

class QFontMetrics(shiboken2.Object):
    @overload
    def __init__(self, font: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, arg__1: QFont) -> None: ...
    @overload
    def __init__(self, arg__1: QFontMetrics) -> None: ...
    def ascent(self) -> int: ...
    def averageCharWidth(self) -> int: ...
    @overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: typing.SupportsInt, text: str, tabstops: int = ..., tabarray: typing.Union[typing.Iterable[int],None] = ...) -> PySide2.QtCore.QRect: ...
    @overload
    def boundingRect(self, r: PySide2.QtCore.QRect, flags: typing.SupportsInt, text: str, tabstops: int = ..., tabarray: typing.Union[typing.Iterable[int],None] = ...) -> PySide2.QtCore.QRect: ...
    @overload
    def boundingRect(self, text: str) -> PySide2.QtCore.QRect: ...
    def boundingRectChar(self, arg__1: str) -> PySide2.QtCore.QRect: ...
    def capHeight(self) -> int: ...
    def charWidth(self, str: str, pos: int) -> int: ...
    def descent(self) -> int: ...
    def elidedText(self, text: str, mode: PySide2.QtCore.Qt.TextElideMode, width: int, flags: typing.SupportsInt = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> int: ...
    def horizontalAdvance(self, arg__1: str, len: int = ...) -> int: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> int: ...
    def leftBearing(self, arg__1: str) -> int: ...
    def lineSpacing(self) -> int: ...
    def lineWidth(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def overlinePos(self) -> int: ...
    def rightBearing(self, arg__1: str) -> int: ...
    def size(self, flags: typing.SupportsInt, str: str, tabstops: int = ..., tabarray: typing.Union[typing.Iterable[int],None] = ...) -> PySide2.QtCore.QSize: ...
    def strikeOutPos(self) -> int: ...
    def swap(self, other: QFontMetrics) -> None: ...
    def tightBoundingRect(self, text: str) -> PySide2.QtCore.QRect: ...
    def underlinePos(self) -> int: ...
    @overload
    def width(self, arg__1: str, len: int, flags: typing.SupportsInt) -> int: ...
    @overload
    def width(self, arg__1: str, len: int = ...) -> int: ...
    def widthChar(self, arg__1: str) -> int: ...
    def xHeight(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QFontMetricsF(shiboken2.Object):
    @overload
    def __init__(self, font: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, arg__1: QFontMetrics) -> None: ...
    @overload
    def __init__(self, arg__1: QFontMetricsF) -> None: ...
    @overload
    def __init__(self, font: QFont) -> None: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    @overload
    def boundingRect(self, r: PySide2.QtCore.QRectF, flags: typing.SupportsInt, string: str, tabstops: int = ..., tabarray: typing.Union[typing.Iterable[int],None] = ...) -> PySide2.QtCore.QRectF: ...
    @overload
    def boundingRect(self, string: str) -> PySide2.QtCore.QRectF: ...
    def boundingRectChar(self, arg__1: str) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def elidedText(self, text: str, mode: PySide2.QtCore.Qt.TextElideMode, width: float, flags: typing.SupportsInt = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> float: ...
    @overload
    def horizontalAdvance(self, string: str, length: int = ...) -> float: ...
    @overload
    def horizontalAdvance(self, arg__1: str) -> float: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> float: ...
    def leftBearing(self, arg__1: str) -> float: ...
    def lineSpacing(self) -> float: ...
    def lineWidth(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def overlinePos(self) -> float: ...
    def rightBearing(self, arg__1: str) -> float: ...
    def size(self, flags: typing.SupportsInt, str: str, tabstops: int = ..., tabarray: typing.Union[typing.Iterable[int],None] = ...) -> PySide2.QtCore.QSizeF: ...
    def strikeOutPos(self) -> float: ...
    def swap(self, other: QFontMetricsF) -> None: ...
    def tightBoundingRect(self, text: str) -> PySide2.QtCore.QRectF: ...
    def underlinePos(self) -> float: ...
    def width(self, string: str) -> float: ...
    def widthChar(self, arg__1: str) -> float: ...
    def xHeight(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGradient(shiboken2.Object):
    class CoordinateMode:
        LogicalMode: typing.ClassVar[QGradient.CoordinateMode] = ...
        ObjectBoundingMode: typing.ClassVar[QGradient.CoordinateMode] = ...
        ObjectMode: typing.ClassVar[QGradient.CoordinateMode] = ...
        StretchToDeviceMode: typing.ClassVar[QGradient.CoordinateMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGradient.CoordinateMode: ...

    class InterpolationMode:
        ColorInterpolation: typing.ClassVar[QGradient.InterpolationMode] = ...
        ComponentInterpolation: typing.ClassVar[QGradient.InterpolationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __and__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QGradient.InterpolationMode: ...

    class Preset:
        AboveTheSky: typing.ClassVar[QGradient.Preset] = ...
        AfricanField: typing.ClassVar[QGradient.Preset] = ...
        AlchemistLab: typing.ClassVar[QGradient.Preset] = ...
        AmourAmour: typing.ClassVar[QGradient.Preset] = ...
        AmyCrisp: typing.ClassVar[QGradient.Preset] = ...
        AngelCare: typing.ClassVar[QGradient.Preset] = ...
        AquaGuidance: typing.ClassVar[QGradient.Preset] = ...
        AquaSplash: typing.ClassVar[QGradient.Preset] = ...
        AwesomePine: typing.ClassVar[QGradient.Preset] = ...
        BigMango: typing.ClassVar[QGradient.Preset] = ...
        BlackSea: typing.ClassVar[QGradient.Preset] = ...
        Blessing: typing.ClassVar[QGradient.Preset] = ...
        BurningSpring: typing.ClassVar[QGradient.Preset] = ...
        CheerfulCaramel: typing.ClassVar[QGradient.Preset] = ...
        ChildCare: typing.ClassVar[QGradient.Preset] = ...
        CleanMirror: typing.ClassVar[QGradient.Preset] = ...
        CloudyApple: typing.ClassVar[QGradient.Preset] = ...
        CloudyKnoxville: typing.ClassVar[QGradient.Preset] = ...
        CochitiLake: typing.ClassVar[QGradient.Preset] = ...
        ColdEvening: typing.ClassVar[QGradient.Preset] = ...
        ColorfulPeach: typing.ClassVar[QGradient.Preset] = ...
        ConfidentCloud: typing.ClassVar[QGradient.Preset] = ...
        CrystalRiver: typing.ClassVar[QGradient.Preset] = ...
        Crystalline: typing.ClassVar[QGradient.Preset] = ...
        DeepBlue: typing.ClassVar[QGradient.Preset] = ...
        DeepRelief: typing.ClassVar[QGradient.Preset] = ...
        DenseWater: typing.ClassVar[QGradient.Preset] = ...
        DesertHump: typing.ClassVar[QGradient.Preset] = ...
        DirtyBeauty: typing.ClassVar[QGradient.Preset] = ...
        DustyGrass: typing.ClassVar[QGradient.Preset] = ...
        EternalConstance: typing.ClassVar[QGradient.Preset] = ...
        EverlastingSky: typing.ClassVar[QGradient.Preset] = ...
        FabledSunset: typing.ClassVar[QGradient.Preset] = ...
        FarawayRiver: typing.ClassVar[QGradient.Preset] = ...
        FebruaryInk: typing.ClassVar[QGradient.Preset] = ...
        FlyHigh: typing.ClassVar[QGradient.Preset] = ...
        FlyingLemon: typing.ClassVar[QGradient.Preset] = ...
        ForestInei: typing.ClassVar[QGradient.Preset] = ...
        FreshMilk: typing.ClassVar[QGradient.Preset] = ...
        FreshOasis: typing.ClassVar[QGradient.Preset] = ...
        FrozenBerry: typing.ClassVar[QGradient.Preset] = ...
        FrozenDreams: typing.ClassVar[QGradient.Preset] = ...
        FrozenHeat: typing.ClassVar[QGradient.Preset] = ...
        FruitBlend: typing.ClassVar[QGradient.Preset] = ...
        GagarinView: typing.ClassVar[QGradient.Preset] = ...
        GentleCare: typing.ClassVar[QGradient.Preset] = ...
        GlassWater: typing.ClassVar[QGradient.Preset] = ...
        GrassShampoo: typing.ClassVar[QGradient.Preset] = ...
        GreatWhale: typing.ClassVar[QGradient.Preset] = ...
        GrownEarly: typing.ClassVar[QGradient.Preset] = ...
        HappyAcid: typing.ClassVar[QGradient.Preset] = ...
        HappyFisher: typing.ClassVar[QGradient.Preset] = ...
        HappyMemories: typing.ClassVar[QGradient.Preset] = ...
        HappyUnicorn: typing.ClassVar[QGradient.Preset] = ...
        HealthyWater: typing.ClassVar[QGradient.Preset] = ...
        HeavenPeach: typing.ClassVar[QGradient.Preset] = ...
        HeavyRain: typing.ClassVar[QGradient.Preset] = ...
        HiddenJaguar: typing.ClassVar[QGradient.Preset] = ...
        HighFlight: typing.ClassVar[QGradient.Preset] = ...
        ItmeoBranding: typing.ClassVar[QGradient.Preset] = ...
        JapanBlush: typing.ClassVar[QGradient.Preset] = ...
        JuicyCake: typing.ClassVar[QGradient.Preset] = ...
        JuicyPeach: typing.ClassVar[QGradient.Preset] = ...
        JungleDay: typing.ClassVar[QGradient.Preset] = ...
        KindSteel: typing.ClassVar[QGradient.Preset] = ...
        LadogaBottom: typing.ClassVar[QGradient.Preset] = ...
        LadyLips: typing.ClassVar[QGradient.Preset] = ...
        LandingAircraft: typing.ClassVar[QGradient.Preset] = ...
        LeCocktail: typing.ClassVar[QGradient.Preset] = ...
        LemonGate: typing.ClassVar[QGradient.Preset] = ...
        LightBlue: typing.ClassVar[QGradient.Preset] = ...
        LilyMeadow: typing.ClassVar[QGradient.Preset] = ...
        LoveKiss: typing.ClassVar[QGradient.Preset] = ...
        MagicLake: typing.ClassVar[QGradient.Preset] = ...
        MagicRay: typing.ClassVar[QGradient.Preset] = ...
        MalibuBeach: typing.ClassVar[QGradient.Preset] = ...
        MarbleWall: typing.ClassVar[QGradient.Preset] = ...
        MarsParty: typing.ClassVar[QGradient.Preset] = ...
        MeanFruit: typing.ClassVar[QGradient.Preset] = ...
        MidnightBloom: typing.ClassVar[QGradient.Preset] = ...
        MillenniumPine: typing.ClassVar[QGradient.Preset] = ...
        MindCrawl: typing.ClassVar[QGradient.Preset] = ...
        MixedHopes: typing.ClassVar[QGradient.Preset] = ...
        MoleHall: typing.ClassVar[QGradient.Preset] = ...
        MorningSalad: typing.ClassVar[QGradient.Preset] = ...
        MorpheusDen: typing.ClassVar[QGradient.Preset] = ...
        MountainRock: typing.ClassVar[QGradient.Preset] = ...
        NearMoon: typing.ClassVar[QGradient.Preset] = ...
        Nega: typing.ClassVar[QGradient.Preset] = ...
        NewLife: typing.ClassVar[QGradient.Preset] = ...
        NewRetrowave: typing.ClassVar[QGradient.Preset] = ...
        NewYork: typing.ClassVar[QGradient.Preset] = ...
        NightCall: typing.ClassVar[QGradient.Preset] = ...
        NightFade: typing.ClassVar[QGradient.Preset] = ...
        NightParty: typing.ClassVar[QGradient.Preset] = ...
        NightSky: typing.ClassVar[QGradient.Preset] = ...
        NorseBeauty: typing.ClassVar[QGradient.Preset] = ...
        NorthMiracle: typing.ClassVar[QGradient.Preset] = ...
        NumPresets: typing.ClassVar[QGradient.Preset] = ...
        OctoberSilence: typing.ClassVar[QGradient.Preset] = ...
        OldHat: typing.ClassVar[QGradient.Preset] = ...
        OrangeJuice: typing.ClassVar[QGradient.Preset] = ...
        OverSun: typing.ClassVar[QGradient.Preset] = ...
        PaloAlto: typing.ClassVar[QGradient.Preset] = ...
        PartyBliss: typing.ClassVar[QGradient.Preset] = ...
        PassionateBed: typing.ClassVar[QGradient.Preset] = ...
        PerfectBlue: typing.ClassVar[QGradient.Preset] = ...
        PerfectWhite: typing.ClassVar[QGradient.Preset] = ...
        PhoenixStart: typing.ClassVar[QGradient.Preset] = ...
        PlumBath: typing.ClassVar[QGradient.Preset] = ...
        PlumPlate: typing.ClassVar[QGradient.Preset] = ...
        PoliteRumors: typing.ClassVar[QGradient.Preset] = ...
        PremiumDark: typing.ClassVar[QGradient.Preset] = ...
        PremiumWhite: typing.ClassVar[QGradient.Preset] = ...
        PurpleDivision: typing.ClassVar[QGradient.Preset] = ...
        RainyAshville: typing.ClassVar[QGradient.Preset] = ...
        RareWind: typing.ClassVar[QGradient.Preset] = ...
        RedSalvation: typing.ClassVar[QGradient.Preset] = ...
        RichMetal: typing.ClassVar[QGradient.Preset] = ...
        RipeMalinka: typing.ClassVar[QGradient.Preset] = ...
        RiskyConcrete: typing.ClassVar[QGradient.Preset] = ...
        RiverCity: typing.ClassVar[QGradient.Preset] = ...
        RoyalGarden: typing.ClassVar[QGradient.Preset] = ...
        SaintPetersburg: typing.ClassVar[QGradient.Preset] = ...
        SaltMountain: typing.ClassVar[QGradient.Preset] = ...
        SandStrike: typing.ClassVar[QGradient.Preset] = ...
        SeaLord: typing.ClassVar[QGradient.Preset] = ...
        SeaStrike: typing.ClassVar[QGradient.Preset] = ...
        Seashore: typing.ClassVar[QGradient.Preset] = ...
        ShadyWater: typing.ClassVar[QGradient.Preset] = ...
        SharpBlues: typing.ClassVar[QGradient.Preset] = ...
        SharpeyeEagle: typing.ClassVar[QGradient.Preset] = ...
        ShyRainbow: typing.ClassVar[QGradient.Preset] = ...
        SkyGlider: typing.ClassVar[QGradient.Preset] = ...
        SleeplessNight: typing.ClassVar[QGradient.Preset] = ...
        SmartIndigo: typing.ClassVar[QGradient.Preset] = ...
        SmilingRain: typing.ClassVar[QGradient.Preset] = ...
        SnowAgain: typing.ClassVar[QGradient.Preset] = ...
        SoftCherish: typing.ClassVar[QGradient.Preset] = ...
        SoftGrass: typing.ClassVar[QGradient.Preset] = ...
        SoftLipstick: typing.ClassVar[QGradient.Preset] = ...
        SolidStone: typing.ClassVar[QGradient.Preset] = ...
        SpaceShift: typing.ClassVar[QGradient.Preset] = ...
        SpikyNaga: typing.ClassVar[QGradient.Preset] = ...
        SpringWarmth: typing.ClassVar[QGradient.Preset] = ...
        StarWine: typing.ClassVar[QGradient.Preset] = ...
        StrictNovember: typing.ClassVar[QGradient.Preset] = ...
        StrongBliss: typing.ClassVar[QGradient.Preset] = ...
        StrongStick: typing.ClassVar[QGradient.Preset] = ...
        SugarLollipop: typing.ClassVar[QGradient.Preset] = ...
        SummerGames: typing.ClassVar[QGradient.Preset] = ...
        SunVeggie: typing.ClassVar[QGradient.Preset] = ...
        SunnyMorning: typing.ClassVar[QGradient.Preset] = ...
        SupremeSky: typing.ClassVar[QGradient.Preset] = ...
        SweetDessert: typing.ClassVar[QGradient.Preset] = ...
        SweetPeriod: typing.ClassVar[QGradient.Preset] = ...
        TeenNotebook: typing.ClassVar[QGradient.Preset] = ...
        TeenParty: typing.ClassVar[QGradient.Preset] = ...
        TemptingAzure: typing.ClassVar[QGradient.Preset] = ...
        TrueSunset: typing.ClassVar[QGradient.Preset] = ...
        ViciousStance: typing.ClassVar[QGradient.Preset] = ...
        WarmFlame: typing.ClassVar[QGradient.Preset] = ...
        WideMatrix: typing.ClassVar[QGradient.Preset] = ...
        WildApple: typing.ClassVar[QGradient.Preset] = ...
        WinterNeva: typing.ClassVar[QGradient.Preset] = ...
        WitchDance: typing.ClassVar[QGradient.Preset] = ...
        YoungGrass: typing.ClassVar[QGradient.Preset] = ...
        YoungPassion: typing.ClassVar[QGradient.Preset] = ...
        ZeusMiracle: typing.ClassVar[QGradient.Preset] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __and__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __rand__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __ror__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __sub__(self, other: typing.SupportsInt) -> QGradient.Preset: ...
        def __xor__(self, other: typing.SupportsInt) -> QGradient.Preset: ...

    class Spread:
        PadSpread: typing.ClassVar[QGradient.Spread] = ...
        ReflectSpread: typing.ClassVar[QGradient.Spread] = ...
        RepeatSpread: typing.ClassVar[QGradient.Spread] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __and__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __rand__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __ror__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __sub__(self, other: typing.SupportsInt) -> QGradient.Spread: ...
        def __xor__(self, other: typing.SupportsInt) -> QGradient.Spread: ...

    class Type:
        ConicalGradient: typing.ClassVar[QGradient.Type] = ...
        LinearGradient: typing.ClassVar[QGradient.Type] = ...
        NoGradient: typing.ClassVar[QGradient.Type] = ...
        RadialGradient: typing.ClassVar[QGradient.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QGradient.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QGradient.Type: ...
    AboveTheSky: typing.ClassVar[QGradient.Preset] = ...
    AfricanField: typing.ClassVar[QGradient.Preset] = ...
    AlchemistLab: typing.ClassVar[QGradient.Preset] = ...
    AmourAmour: typing.ClassVar[QGradient.Preset] = ...
    AmyCrisp: typing.ClassVar[QGradient.Preset] = ...
    AngelCare: typing.ClassVar[QGradient.Preset] = ...
    AquaGuidance: typing.ClassVar[QGradient.Preset] = ...
    AquaSplash: typing.ClassVar[QGradient.Preset] = ...
    AwesomePine: typing.ClassVar[QGradient.Preset] = ...
    BigMango: typing.ClassVar[QGradient.Preset] = ...
    BlackSea: typing.ClassVar[QGradient.Preset] = ...
    Blessing: typing.ClassVar[QGradient.Preset] = ...
    BurningSpring: typing.ClassVar[QGradient.Preset] = ...
    CheerfulCaramel: typing.ClassVar[QGradient.Preset] = ...
    ChildCare: typing.ClassVar[QGradient.Preset] = ...
    CleanMirror: typing.ClassVar[QGradient.Preset] = ...
    CloudyApple: typing.ClassVar[QGradient.Preset] = ...
    CloudyKnoxville: typing.ClassVar[QGradient.Preset] = ...
    CochitiLake: typing.ClassVar[QGradient.Preset] = ...
    ColdEvening: typing.ClassVar[QGradient.Preset] = ...
    ColorInterpolation: typing.ClassVar[QGradient.InterpolationMode] = ...
    ColorfulPeach: typing.ClassVar[QGradient.Preset] = ...
    ComponentInterpolation: typing.ClassVar[QGradient.InterpolationMode] = ...
    ConfidentCloud: typing.ClassVar[QGradient.Preset] = ...
    ConicalGradient: typing.ClassVar[QGradient.Type] = ...
    CrystalRiver: typing.ClassVar[QGradient.Preset] = ...
    Crystalline: typing.ClassVar[QGradient.Preset] = ...
    DeepBlue: typing.ClassVar[QGradient.Preset] = ...
    DeepRelief: typing.ClassVar[QGradient.Preset] = ...
    DenseWater: typing.ClassVar[QGradient.Preset] = ...
    DesertHump: typing.ClassVar[QGradient.Preset] = ...
    DirtyBeauty: typing.ClassVar[QGradient.Preset] = ...
    DustyGrass: typing.ClassVar[QGradient.Preset] = ...
    EternalConstance: typing.ClassVar[QGradient.Preset] = ...
    EverlastingSky: typing.ClassVar[QGradient.Preset] = ...
    FabledSunset: typing.ClassVar[QGradient.Preset] = ...
    FarawayRiver: typing.ClassVar[QGradient.Preset] = ...
    FebruaryInk: typing.ClassVar[QGradient.Preset] = ...
    FlyHigh: typing.ClassVar[QGradient.Preset] = ...
    FlyingLemon: typing.ClassVar[QGradient.Preset] = ...
    ForestInei: typing.ClassVar[QGradient.Preset] = ...
    FreshMilk: typing.ClassVar[QGradient.Preset] = ...
    FreshOasis: typing.ClassVar[QGradient.Preset] = ...
    FrozenBerry: typing.ClassVar[QGradient.Preset] = ...
    FrozenDreams: typing.ClassVar[QGradient.Preset] = ...
    FrozenHeat: typing.ClassVar[QGradient.Preset] = ...
    FruitBlend: typing.ClassVar[QGradient.Preset] = ...
    GagarinView: typing.ClassVar[QGradient.Preset] = ...
    GentleCare: typing.ClassVar[QGradient.Preset] = ...
    GlassWater: typing.ClassVar[QGradient.Preset] = ...
    GrassShampoo: typing.ClassVar[QGradient.Preset] = ...
    GreatWhale: typing.ClassVar[QGradient.Preset] = ...
    GrownEarly: typing.ClassVar[QGradient.Preset] = ...
    HappyAcid: typing.ClassVar[QGradient.Preset] = ...
    HappyFisher: typing.ClassVar[QGradient.Preset] = ...
    HappyMemories: typing.ClassVar[QGradient.Preset] = ...
    HappyUnicorn: typing.ClassVar[QGradient.Preset] = ...
    HealthyWater: typing.ClassVar[QGradient.Preset] = ...
    HeavenPeach: typing.ClassVar[QGradient.Preset] = ...
    HeavyRain: typing.ClassVar[QGradient.Preset] = ...
    HiddenJaguar: typing.ClassVar[QGradient.Preset] = ...
    HighFlight: typing.ClassVar[QGradient.Preset] = ...
    ItmeoBranding: typing.ClassVar[QGradient.Preset] = ...
    JapanBlush: typing.ClassVar[QGradient.Preset] = ...
    JuicyCake: typing.ClassVar[QGradient.Preset] = ...
    JuicyPeach: typing.ClassVar[QGradient.Preset] = ...
    JungleDay: typing.ClassVar[QGradient.Preset] = ...
    KindSteel: typing.ClassVar[QGradient.Preset] = ...
    LadogaBottom: typing.ClassVar[QGradient.Preset] = ...
    LadyLips: typing.ClassVar[QGradient.Preset] = ...
    LandingAircraft: typing.ClassVar[QGradient.Preset] = ...
    LeCocktail: typing.ClassVar[QGradient.Preset] = ...
    LemonGate: typing.ClassVar[QGradient.Preset] = ...
    LightBlue: typing.ClassVar[QGradient.Preset] = ...
    LilyMeadow: typing.ClassVar[QGradient.Preset] = ...
    LinearGradient: typing.ClassVar[QGradient.Type] = ...
    LogicalMode: typing.ClassVar[QGradient.CoordinateMode] = ...
    LoveKiss: typing.ClassVar[QGradient.Preset] = ...
    MagicLake: typing.ClassVar[QGradient.Preset] = ...
    MagicRay: typing.ClassVar[QGradient.Preset] = ...
    MalibuBeach: typing.ClassVar[QGradient.Preset] = ...
    MarbleWall: typing.ClassVar[QGradient.Preset] = ...
    MarsParty: typing.ClassVar[QGradient.Preset] = ...
    MeanFruit: typing.ClassVar[QGradient.Preset] = ...
    MidnightBloom: typing.ClassVar[QGradient.Preset] = ...
    MillenniumPine: typing.ClassVar[QGradient.Preset] = ...
    MindCrawl: typing.ClassVar[QGradient.Preset] = ...
    MixedHopes: typing.ClassVar[QGradient.Preset] = ...
    MoleHall: typing.ClassVar[QGradient.Preset] = ...
    MorningSalad: typing.ClassVar[QGradient.Preset] = ...
    MorpheusDen: typing.ClassVar[QGradient.Preset] = ...
    MountainRock: typing.ClassVar[QGradient.Preset] = ...
    NearMoon: typing.ClassVar[QGradient.Preset] = ...
    Nega: typing.ClassVar[QGradient.Preset] = ...
    NewLife: typing.ClassVar[QGradient.Preset] = ...
    NewRetrowave: typing.ClassVar[QGradient.Preset] = ...
    NewYork: typing.ClassVar[QGradient.Preset] = ...
    NightCall: typing.ClassVar[QGradient.Preset] = ...
    NightFade: typing.ClassVar[QGradient.Preset] = ...
    NightParty: typing.ClassVar[QGradient.Preset] = ...
    NightSky: typing.ClassVar[QGradient.Preset] = ...
    NoGradient: typing.ClassVar[QGradient.Type] = ...
    NorseBeauty: typing.ClassVar[QGradient.Preset] = ...
    NorthMiracle: typing.ClassVar[QGradient.Preset] = ...
    NumPresets: typing.ClassVar[QGradient.Preset] = ...
    ObjectBoundingMode: typing.ClassVar[QGradient.CoordinateMode] = ...
    ObjectMode: typing.ClassVar[QGradient.CoordinateMode] = ...
    OctoberSilence: typing.ClassVar[QGradient.Preset] = ...
    OldHat: typing.ClassVar[QGradient.Preset] = ...
    OrangeJuice: typing.ClassVar[QGradient.Preset] = ...
    OverSun: typing.ClassVar[QGradient.Preset] = ...
    PadSpread: typing.ClassVar[QGradient.Spread] = ...
    PaloAlto: typing.ClassVar[QGradient.Preset] = ...
    PartyBliss: typing.ClassVar[QGradient.Preset] = ...
    PassionateBed: typing.ClassVar[QGradient.Preset] = ...
    PerfectBlue: typing.ClassVar[QGradient.Preset] = ...
    PerfectWhite: typing.ClassVar[QGradient.Preset] = ...
    PhoenixStart: typing.ClassVar[QGradient.Preset] = ...
    PlumBath: typing.ClassVar[QGradient.Preset] = ...
    PlumPlate: typing.ClassVar[QGradient.Preset] = ...
    PoliteRumors: typing.ClassVar[QGradient.Preset] = ...
    PremiumDark: typing.ClassVar[QGradient.Preset] = ...
    PremiumWhite: typing.ClassVar[QGradient.Preset] = ...
    PurpleDivision: typing.ClassVar[QGradient.Preset] = ...
    RadialGradient: typing.ClassVar[QGradient.Type] = ...
    RainyAshville: typing.ClassVar[QGradient.Preset] = ...
    RareWind: typing.ClassVar[QGradient.Preset] = ...
    RedSalvation: typing.ClassVar[QGradient.Preset] = ...
    ReflectSpread: typing.ClassVar[QGradient.Spread] = ...
    RepeatSpread: typing.ClassVar[QGradient.Spread] = ...
    RichMetal: typing.ClassVar[QGradient.Preset] = ...
    RipeMalinka: typing.ClassVar[QGradient.Preset] = ...
    RiskyConcrete: typing.ClassVar[QGradient.Preset] = ...
    RiverCity: typing.ClassVar[QGradient.Preset] = ...
    RoyalGarden: typing.ClassVar[QGradient.Preset] = ...
    SaintPetersburg: typing.ClassVar[QGradient.Preset] = ...
    SaltMountain: typing.ClassVar[QGradient.Preset] = ...
    SandStrike: typing.ClassVar[QGradient.Preset] = ...
    SeaLord: typing.ClassVar[QGradient.Preset] = ...
    SeaStrike: typing.ClassVar[QGradient.Preset] = ...
    Seashore: typing.ClassVar[QGradient.Preset] = ...
    ShadyWater: typing.ClassVar[QGradient.Preset] = ...
    SharpBlues: typing.ClassVar[QGradient.Preset] = ...
    SharpeyeEagle: typing.ClassVar[QGradient.Preset] = ...
    ShyRainbow: typing.ClassVar[QGradient.Preset] = ...
    SkyGlider: typing.ClassVar[QGradient.Preset] = ...
    SleeplessNight: typing.ClassVar[QGradient.Preset] = ...
    SmartIndigo: typing.ClassVar[QGradient.Preset] = ...
    SmilingRain: typing.ClassVar[QGradient.Preset] = ...
    SnowAgain: typing.ClassVar[QGradient.Preset] = ...
    SoftCherish: typing.ClassVar[QGradient.Preset] = ...
    SoftGrass: typing.ClassVar[QGradient.Preset] = ...
    SoftLipstick: typing.ClassVar[QGradient.Preset] = ...
    SolidStone: typing.ClassVar[QGradient.Preset] = ...
    SpaceShift: typing.ClassVar[QGradient.Preset] = ...
    SpikyNaga: typing.ClassVar[QGradient.Preset] = ...
    SpringWarmth: typing.ClassVar[QGradient.Preset] = ...
    StarWine: typing.ClassVar[QGradient.Preset] = ...
    StretchToDeviceMode: typing.ClassVar[QGradient.CoordinateMode] = ...
    StrictNovember: typing.ClassVar[QGradient.Preset] = ...
    StrongBliss: typing.ClassVar[QGradient.Preset] = ...
    StrongStick: typing.ClassVar[QGradient.Preset] = ...
    SugarLollipop: typing.ClassVar[QGradient.Preset] = ...
    SummerGames: typing.ClassVar[QGradient.Preset] = ...
    SunVeggie: typing.ClassVar[QGradient.Preset] = ...
    SunnyMorning: typing.ClassVar[QGradient.Preset] = ...
    SupremeSky: typing.ClassVar[QGradient.Preset] = ...
    SweetDessert: typing.ClassVar[QGradient.Preset] = ...
    SweetPeriod: typing.ClassVar[QGradient.Preset] = ...
    TeenNotebook: typing.ClassVar[QGradient.Preset] = ...
    TeenParty: typing.ClassVar[QGradient.Preset] = ...
    TemptingAzure: typing.ClassVar[QGradient.Preset] = ...
    TrueSunset: typing.ClassVar[QGradient.Preset] = ...
    ViciousStance: typing.ClassVar[QGradient.Preset] = ...
    WarmFlame: typing.ClassVar[QGradient.Preset] = ...
    WideMatrix: typing.ClassVar[QGradient.Preset] = ...
    WildApple: typing.ClassVar[QGradient.Preset] = ...
    WinterNeva: typing.ClassVar[QGradient.Preset] = ...
    WitchDance: typing.ClassVar[QGradient.Preset] = ...
    YoungGrass: typing.ClassVar[QGradient.Preset] = ...
    YoungPassion: typing.ClassVar[QGradient.Preset] = ...
    ZeusMiracle: typing.ClassVar[QGradient.Preset] = ...
    @overload
    def __init__(self, QGradient: QGradient) -> None: ...
    @overload
    def __init__(self, arg__1: QGradient.Preset) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def coordinateMode(self) -> QGradient.CoordinateMode: ...
    def interpolationMode(self) -> QGradient.InterpolationMode: ...
    def setColorAt(self, pos: float, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setCoordinateMode(self, mode: QGradient.CoordinateMode) -> None: ...
    def setInterpolationMode(self, mode: QGradient.InterpolationMode) -> None: ...
    def setSpread(self, spread: QGradient.Spread) -> None: ...
    def setStops(self, stops: typing.List[typing.Tuple[float,QColor]]) -> None: ...
    def spread(self) -> QGradient.Spread: ...
    def stops(self) -> typing.List[typing.Tuple[float,QColor]]: ...
    def type(self) -> QGradient.Type: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGuiApplication(PySide2.QtCore.QCoreApplication):
    applicationDisplayNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    applicationStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    commitDataRequest: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusObjectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusWindowChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fontChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    fontDatabaseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    lastWindowClosed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    layoutDirectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    paletteChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    primaryScreenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    saveStateRequest: typing.ClassVar[PySide2.QtCore.Signal] = ...
    screenAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    screenRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, arg__1: typing.Iterable[str], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def allWindows(cls) -> typing.List[QWindow]: ...
    @classmethod
    def applicationDisplayName(cls) -> str: ...
    @classmethod
    def applicationState(cls) -> PySide2.QtCore.Qt.ApplicationState: ...
    @classmethod
    def changeOverrideCursor(cls, arg__1: typing.Union[QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    @classmethod
    def clipboard(cls) -> QClipboard: ...
    @classmethod
    def desktopFileName(cls) -> str: ...
    @classmethod
    def desktopSettingsAware(cls) -> bool: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    @classmethod
    def exec_(cls) -> int: ...
    @classmethod
    def focusObject(cls) -> PySide2.QtCore.QObject: ...
    @classmethod
    def focusWindow(cls) -> QWindow: ...
    @classmethod
    def font(cls) -> QFont: ...
    @classmethod
    def highDpiScaleFactorRoundingPolicy(cls) -> PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy: ...
    @classmethod
    def inputMethod(cls) -> QInputMethod: ...
    @classmethod
    def isFallbackSessionManagementEnabled(cls) -> bool: ...
    @classmethod
    def isLeftToRight(cls) -> bool: ...
    @classmethod
    def isRightToLeft(cls) -> bool: ...
    def isSavingSession(self) -> bool: ...
    def isSessionRestored(self) -> bool: ...
    @classmethod
    def keyboardModifiers(cls) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    @classmethod
    def layoutDirection(cls) -> PySide2.QtCore.Qt.LayoutDirection: ...
    @classmethod
    def modalWindow(cls) -> QWindow: ...
    @classmethod
    def mouseButtons(cls) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def notify(self, arg__1: PySide2.QtCore.QObject, arg__2: PySide2.QtCore.QEvent) -> bool: ...
    @classmethod
    def overrideCursor(cls) -> QCursor: ...
    @classmethod
    def palette(cls) -> QPalette: ...
    @classmethod
    def platformName(cls) -> str: ...
    @classmethod
    def primaryScreen(cls) -> QScreen: ...
    @classmethod
    def queryKeyboardModifiers(cls) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    @classmethod
    def quitOnLastWindowClosed(cls) -> bool: ...
    @classmethod
    def restoreOverrideCursor(cls) -> None: ...
    @classmethod
    def screenAt(cls, point: PySide2.QtCore.QPoint) -> QScreen: ...
    @classmethod
    def screens(cls) -> typing.List[QScreen]: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    @classmethod
    def setApplicationDisplayName(cls, name: str) -> None: ...
    @classmethod
    def setDesktopFileName(cls, name: str) -> None: ...
    @classmethod
    def setDesktopSettingsAware(cls, on: bool) -> None: ...
    @classmethod
    def setFallbackSessionManagementEnabled(cls, arg__1: bool) -> None: ...
    @classmethod
    def setFont(cls, arg__1: QFont) -> None: ...
    @classmethod
    def setHighDpiScaleFactorRoundingPolicy(cls, policy: PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy) -> None: ...
    @classmethod
    def setLayoutDirection(cls, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    @classmethod
    def setOverrideCursor(cls, arg__1: typing.Union[QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    @classmethod
    def setPalette(cls, pal: QPalette) -> None: ...
    @classmethod
    def setQuitOnLastWindowClosed(cls, quit: bool) -> None: ...
    @classmethod
    def setWindowIcon(cls, icon: QIcon) -> None: ...
    @classmethod
    def styleHints(cls) -> QStyleHints: ...
    @classmethod
    def sync(cls) -> None: ...
    @classmethod
    def topLevelAt(cls, pos: PySide2.QtCore.QPoint) -> QWindow: ...
    @classmethod
    def topLevelWindows(cls) -> typing.List[QWindow]: ...
    @classmethod
    def windowIcon(cls) -> QIcon: ...

class QHelpEvent(PySide2.QtCore.QEvent):
    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPoint, globalPos: PySide2.QtCore.QPoint) -> None: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QHideEvent(PySide2.QtCore.QEvent):
    def __init__(self) -> None: ...

class QHoverEvent(QInputEvent):
    def __init__(self, type: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, oldPos: PySide2.QtCore.QPointF, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def oldPosF(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...

class QIcon(shiboken2.Object):
    class Mode:
        Active: typing.ClassVar[QIcon.Mode] = ...
        Disabled: typing.ClassVar[QIcon.Mode] = ...
        Normal: typing.ClassVar[QIcon.Mode] = ...
        Selected: typing.ClassVar[QIcon.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QIcon.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QIcon.Mode: ...

    class State:
        Off: typing.ClassVar[QIcon.State] = ...
        On: typing.ClassVar[QIcon.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __and__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QIcon.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QIcon.State: ...
    Active: typing.ClassVar[QIcon.Mode] = ...
    Disabled: typing.ClassVar[QIcon.Mode] = ...
    Normal: typing.ClassVar[QIcon.Mode] = ...
    Off: typing.ClassVar[QIcon.State] = ...
    On: typing.ClassVar[QIcon.State] = ...
    Selected: typing.ClassVar[QIcon.Mode] = ...
    @overload
    def __init__(self, engine: QIconEngine) -> None: ...
    @overload
    def __init__(self, fileName: str) -> None: ...
    @overload
    def __init__(self, other: QIcon) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def actualSize(self, window: QWindow, size: PySide2.QtCore.QSize, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> PySide2.QtCore.QSize: ...
    @overload
    def actualSize(self, size: PySide2.QtCore.QSize, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide2.QtCore.QSize = ..., mode: QIcon.Mode = ..., state: QIcon.State = ...) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> None: ...
    def availableSizes(self, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def cacheKey(self) -> int: ...
    @classmethod
    def fallbackSearchPaths(cls) -> typing.List[str]: ...
    @classmethod
    def fallbackThemeName(cls) -> str: ...
    @overload
    @classmethod
    def fromTheme(cls, name: str, fallback: QIcon) -> QIcon: ...
    @overload
    @classmethod
    def fromTheme(cls, name: str) -> QIcon: ...
    @classmethod
    def hasThemeIcon(cls, name: str) -> bool: ...
    def isMask(self) -> bool: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    @overload
    def paint(self, painter: QPainter, x: int, y: int, w: int, h: int, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., mode: QIcon.Mode = ..., state: QIcon.State = ...) -> None: ...
    @overload
    def paint(self, painter: QPainter, rect: PySide2.QtCore.QRect, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag] = ..., mode: QIcon.Mode = ..., state: QIcon.State = ...) -> None: ...
    @overload
    def pixmap(self, w: int, h: int, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> QPixmap: ...
    @overload
    def pixmap(self, window: QWindow, size: PySide2.QtCore.QSize, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> QPixmap: ...
    @overload
    def pixmap(self, extent: int, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> QPixmap: ...
    @overload
    def pixmap(self, size: PySide2.QtCore.QSize, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> QPixmap: ...
    @classmethod
    def setFallbackSearchPaths(cls, paths: typing.Iterable[str]) -> None: ...
    @classmethod
    def setFallbackThemeName(cls, name: str) -> None: ...
    def setIsMask(self, isMask: bool) -> None: ...
    @classmethod
    def setThemeName(cls, path: str) -> None: ...
    @classmethod
    def setThemeSearchPaths(cls, searchpath: typing.Iterable[str]) -> None: ...
    def swap(self, other: QIcon) -> None: ...
    @classmethod
    def themeName(cls) -> str: ...
    @classmethod
    def themeSearchPaths(cls) -> typing.List[str]: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QIconDragEvent(PySide2.QtCore.QEvent):
    def __init__(self) -> None: ...

class QIconEngine(shiboken2.Object):
    class AvailableSizesArgument(shiboken2.Object):
        mode: typing.Any
        sizes: typing.Any
        state: typing.Any
        def __init__(self) -> None: ...

    class IconEngineHook:
        AvailableSizesHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
        IconNameHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
        IsNullHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
        ScaledPixmapHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __and__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __rand__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __rmul__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __ror__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __rsub__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __rxor__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __sub__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
        def __xor__(self, other: typing.SupportsInt) -> QIconEngine.IconEngineHook: ...
    AvailableSizesHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
    IconNameHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
    IsNullHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
    ScaledPixmapHook: typing.ClassVar[QIconEngine.IconEngineHook] = ...
    @overload
    def __init__(self, other: QIconEngine) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def actualSize(self, size: PySide2.QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide2.QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: QIcon.Mode, state: QIcon.State) -> None: ...
    def availableSizes(self, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def clone(self) -> QIconEngine: ...
    def iconName(self) -> str: ...
    def isNull(self) -> bool: ...
    def key(self) -> str: ...
    def paint(self, painter: QPainter, rect: PySide2.QtCore.QRect, mode: QIcon.Mode, state: QIcon.State) -> None: ...
    def pixmap(self, size: PySide2.QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> QPixmap: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> bool: ...
    def scaledPixmap(self, size: PySide2.QtCore.QSize, mode: QIcon.Mode, state: QIcon.State, scale: float) -> QPixmap: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> bool: ...
    def __bool__(self) -> bool: ...

class QImage(QPaintDevice):
    class Format:
        Format_A2BGR30_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_A2RGB30_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_ARGB32: typing.ClassVar[QImage.Format] = ...
        Format_ARGB32_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_ARGB4444_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_ARGB6666_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_ARGB8555_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_ARGB8565_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_Alpha8: typing.ClassVar[QImage.Format] = ...
        Format_BGR30: typing.ClassVar[QImage.Format] = ...
        Format_BGR888: typing.ClassVar[QImage.Format] = ...
        Format_Grayscale16: typing.ClassVar[QImage.Format] = ...
        Format_Grayscale8: typing.ClassVar[QImage.Format] = ...
        Format_Indexed8: typing.ClassVar[QImage.Format] = ...
        Format_Invalid: typing.ClassVar[QImage.Format] = ...
        Format_Mono: typing.ClassVar[QImage.Format] = ...
        Format_MonoLSB: typing.ClassVar[QImage.Format] = ...
        Format_RGB16: typing.ClassVar[QImage.Format] = ...
        Format_RGB30: typing.ClassVar[QImage.Format] = ...
        Format_RGB32: typing.ClassVar[QImage.Format] = ...
        Format_RGB444: typing.ClassVar[QImage.Format] = ...
        Format_RGB555: typing.ClassVar[QImage.Format] = ...
        Format_RGB666: typing.ClassVar[QImage.Format] = ...
        Format_RGB888: typing.ClassVar[QImage.Format] = ...
        Format_RGBA64: typing.ClassVar[QImage.Format] = ...
        Format_RGBA64_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_RGBA8888: typing.ClassVar[QImage.Format] = ...
        Format_RGBA8888_Premultiplied: typing.ClassVar[QImage.Format] = ...
        Format_RGBX64: typing.ClassVar[QImage.Format] = ...
        Format_RGBX8888: typing.ClassVar[QImage.Format] = ...
        NImageFormats: typing.ClassVar[QImage.Format] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __and__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __rand__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __rmul__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __ror__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __rsub__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __sub__(self, other: typing.SupportsInt) -> QImage.Format: ...
        def __xor__(self, other: typing.SupportsInt) -> QImage.Format: ...

    class InvertMode:
        InvertRgb: typing.ClassVar[QImage.InvertMode] = ...
        InvertRgba: typing.ClassVar[QImage.InvertMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __and__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QImage.InvertMode: ...
    Format_A2BGR30_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_A2RGB30_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_ARGB32: typing.ClassVar[QImage.Format] = ...
    Format_ARGB32_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_ARGB4444_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_ARGB6666_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_ARGB8555_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_ARGB8565_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_Alpha8: typing.ClassVar[QImage.Format] = ...
    Format_BGR30: typing.ClassVar[QImage.Format] = ...
    Format_BGR888: typing.ClassVar[QImage.Format] = ...
    Format_Grayscale16: typing.ClassVar[QImage.Format] = ...
    Format_Grayscale8: typing.ClassVar[QImage.Format] = ...
    Format_Indexed8: typing.ClassVar[QImage.Format] = ...
    Format_Invalid: typing.ClassVar[QImage.Format] = ...
    Format_Mono: typing.ClassVar[QImage.Format] = ...
    Format_MonoLSB: typing.ClassVar[QImage.Format] = ...
    Format_RGB16: typing.ClassVar[QImage.Format] = ...
    Format_RGB30: typing.ClassVar[QImage.Format] = ...
    Format_RGB32: typing.ClassVar[QImage.Format] = ...
    Format_RGB444: typing.ClassVar[QImage.Format] = ...
    Format_RGB555: typing.ClassVar[QImage.Format] = ...
    Format_RGB666: typing.ClassVar[QImage.Format] = ...
    Format_RGB888: typing.ClassVar[QImage.Format] = ...
    Format_RGBA64: typing.ClassVar[QImage.Format] = ...
    Format_RGBA64_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_RGBA8888: typing.ClassVar[QImage.Format] = ...
    Format_RGBA8888_Premultiplied: typing.ClassVar[QImage.Format] = ...
    Format_RGBX64: typing.ClassVar[QImage.Format] = ...
    Format_RGBX8888: typing.ClassVar[QImage.Format] = ...
    InvertRgb: typing.ClassVar[QImage.InvertMode] = ...
    InvertRgba: typing.ClassVar[QImage.InvertMode] = ...
    NImageFormats: typing.ClassVar[QImage.Format] = ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, bytesPerLine: int, format: QImage.Format, cleanupFunction: typing.Union[typing.Callable,None] = ..., cleanupInfo: typing.Union[int,None] = ...) -> None: ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, format: QImage.Format, cleanupFunction: typing.Union[typing.Callable,None] = ..., cleanupInfo: typing.Union[int,None] = ...) -> None: ...
    @overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: int, arg__5: QImage.Format) -> None: ...
    @overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: QImage.Format) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: QImage.Format) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, format: QImage.Format) -> None: ...
    @overload
    def __init__(self, arg__1: QImage) -> None: ...
    @overload
    def __init__(self, xpm: typing.Iterable[str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def allGray(self) -> bool: ...
    def alphaChannel(self) -> QImage: ...
    def bitPlaneCount(self) -> int: ...
    def bits(self) -> bytes: ...
    def byteCount(self) -> int: ...
    def bytesPerLine(self) -> int: ...
    def cacheKey(self) -> int: ...
    def color(self, i: int) -> int: ...
    def colorCount(self) -> int: ...
    def colorSpace(self) -> QColorSpace: ...
    def colorTable(self) -> typing.List[int]: ...
    def constBits(self) -> bytes: ...
    def constScanLine(self, arg__1: int) -> bytes: ...
    def convertTo(self, f: QImage.Format, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    def convertToColorSpace(self, arg__1: QColorSpace) -> None: ...
    @overload
    def convertToFormat(self, f: QImage.Format, colorTable: typing.List[int], flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QImage: ...
    @overload
    def convertToFormat(self, f: QImage.Format, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QImage: ...
    def convertToFormat_helper(self, format: QImage.Format, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag]) -> QImage: ...
    def convertToFormat_inplace(self, format: QImage.Format, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag]) -> bool: ...
    def convertedToColorSpace(self, arg__1: QColorSpace) -> QImage: ...
    @overload
    def copy(self, x: int, y: int, w: int, h: int) -> QImage: ...
    @overload
    def copy(self, rect: PySide2.QtCore.QRect = ...) -> QImage: ...
    def createAlphaMask(self, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QImage: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> QImage: ...
    def createMaskFromColor(self, color: int, mode: PySide2.QtCore.Qt.MaskMode = ...) -> QImage: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def dotsPerMeterX(self) -> int: ...
    def dotsPerMeterY(self) -> int: ...
    @overload
    def fill(self, color: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fill(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def fill(self, pixel: int) -> None: ...
    def format(self) -> QImage.Format: ...
    @classmethod
    def fromData(cls, data: typing.Union[PySide2.QtCore.QByteArray,bytes], format: typing.Optional[str] = ...) -> QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def invertPixels(self, mode: QImage.InvertMode = ...) -> None: ...
    def isGrayscale(self) -> bool: ...
    def isNull(self) -> bool: ...
    @overload
    def load(self, device: PySide2.QtCore.QIODevice, format: bytes) -> bool: ...
    @overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def loadFromData(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes], aformat: typing.Union[bytes,None] = ...) -> bool: ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def mirrored(self, horizontally: bool = ..., vertically: bool = ...) -> QImage: ...
    def mirrored_helper(self, horizontal: bool, vertical: bool) -> QImage: ...
    def mirrored_inplace(self, horizontal: bool, vertical: bool) -> None: ...
    def offset(self) -> PySide2.QtCore.QPoint: ...
    def paintEngine(self) -> QPaintEngine: ...
    @overload
    def pixel(self, x: int, y: int) -> int: ...
    @overload
    def pixel(self, pt: PySide2.QtCore.QPoint) -> int: ...
    @overload
    def pixelColor(self, x: int, y: int) -> QColor: ...
    @overload
    def pixelColor(self, pt: PySide2.QtCore.QPoint) -> QColor: ...
    def pixelFormat(self) -> QPixelFormat: ...
    @overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    @overload
    def pixelIndex(self, pt: PySide2.QtCore.QPoint) -> int: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def reinterpretAsFormat(self, f: QImage.Format) -> bool: ...
    def rgbSwapped(self) -> QImage: ...
    def rgbSwapped_helper(self) -> QImage: ...
    def rgbSwapped_inplace(self) -> None: ...
    @overload
    def save(self, device: PySide2.QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def scaled(self, w: int, h: int, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    @overload
    def scaled(self, s: PySide2.QtCore.QSize, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    def scaledToHeight(self, h: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    def scaledToWidth(self, w: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    def scanLine(self, arg__1: int) -> bytes: ...
    def setAlphaChannel(self, alphaChannel: QImage) -> None: ...
    def setColor(self, i: int, c: int) -> None: ...
    def setColorCount(self, arg__1: int) -> None: ...
    def setColorSpace(self, arg__1: QColorSpace) -> None: ...
    def setColorTable(self, colors: typing.List[int]) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setDotsPerMeterX(self, arg__1: int) -> None: ...
    def setDotsPerMeterY(self, arg__1: int) -> None: ...
    def setOffset(self, arg__1: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None: ...
    @overload
    def setPixel(self, pt: PySide2.QtCore.QPoint, index_or_rgb: int) -> None: ...
    @overload
    def setPixelColor(self, x: int, y: int, c: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setPixelColor(self, pt: PySide2.QtCore.QPoint, c: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setText(self, key: str, value: str) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeInBytes(self) -> int: ...
    def smoothScaled(self, w: int, h: int) -> QImage: ...
    def swap(self, other: QImage) -> None: ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    @classmethod
    def toImageFormat(cls, format: QPixelFormat) -> QImage.Format: ...
    @classmethod
    def toPixelFormat(cls, format: QImage.Format) -> QPixelFormat: ...
    @overload
    def transformed(self, matrix: QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    @overload
    def transformed(self, matrix: QTransform, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QImage: ...
    @overload
    @classmethod
    def trueMatrix(cls, arg__1: QMatrix, w: int, h: int) -> QMatrix: ...
    @overload
    @classmethod
    def trueMatrix(cls, arg__1: QTransform, w: int, h: int) -> QTransform: ...
    @overload
    def valid(self, x: int, y: int) -> bool: ...
    @overload
    def valid(self, pt: PySide2.QtCore.QPoint) -> bool: ...
    def width(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QImageIOHandler(shiboken2.Object):
    class ImageOption:
        Animation: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        BackgroundColor: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ClipRect: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        CompressionRatio: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Description: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Endianness: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Gamma: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ImageFormat: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ImageTransformation: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        IncrementalReading: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Name: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        OptimizedWrite: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ProgressiveScanWrite: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Quality: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ScaledClipRect: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        ScaledSize: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        Size: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        SubType: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        SupportedSubTypes: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        TransformedByDefault: typing.ClassVar[QImageIOHandler.ImageOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __and__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __rand__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __rmul__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __ror__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __rsub__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __sub__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...
        def __xor__(self, other: typing.SupportsInt) -> QImageIOHandler.ImageOption: ...

    class Transformation:
        TransformationFlip: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationFlipAndRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationMirror: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationMirrorAndRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationNone: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationRotate180: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationRotate270: typing.ClassVar[QImageIOHandler.Transformation] = ...
        TransformationRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QImageIOHandler.Transformations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __rand__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __ror__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __xor__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...

    class Transformations:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QImageIOHandler.Transformations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __rand__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __ror__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
        def __xor__(self, other: typing.SupportsInt) -> QImageIOHandler.Transformations: ...
    Animation: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    BackgroundColor: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ClipRect: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    CompressionRatio: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Description: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Endianness: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Gamma: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ImageFormat: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ImageTransformation: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    IncrementalReading: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Name: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    OptimizedWrite: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ProgressiveScanWrite: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Quality: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ScaledClipRect: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    ScaledSize: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    Size: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    SubType: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    SupportedSubTypes: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    TransformationFlip: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationFlipAndRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationMirror: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationMirrorAndRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationNone: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationRotate180: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationRotate270: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformationRotate90: typing.ClassVar[QImageIOHandler.Transformation] = ...
    TransformedByDefault: typing.ClassVar[QImageIOHandler.ImageOption] = ...
    def __init__(self) -> None: ...
    def canRead(self) -> bool: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def nextImageDelay(self) -> int: ...
    def option(self, option: QImageIOHandler.ImageOption) -> typing.Any: ...
    def read(self, image: QImage) -> bool: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setFormat(self, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setOption(self, option: QImageIOHandler.ImageOption, value: typing.Any) -> None: ...
    def supportsOption(self, option: QImageIOHandler.ImageOption) -> bool: ...
    def write(self, image: QImage) -> bool: ...

class QImageReader(shiboken2.Object):
    class ImageReaderError:
        DeviceError: typing.ClassVar[QImageReader.ImageReaderError] = ...
        FileNotFoundError: typing.ClassVar[QImageReader.ImageReaderError] = ...
        InvalidDataError: typing.ClassVar[QImageReader.ImageReaderError] = ...
        UnknownError: typing.ClassVar[QImageReader.ImageReaderError] = ...
        UnsupportedFormatError: typing.ClassVar[QImageReader.ImageReaderError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __and__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __rand__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __ror__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __sub__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
        def __xor__(self, other: typing.SupportsInt) -> QImageReader.ImageReaderError: ...
    DeviceError: typing.ClassVar[QImageReader.ImageReaderError] = ...
    FileNotFoundError: typing.ClassVar[QImageReader.ImageReaderError] = ...
    InvalidDataError: typing.ClassVar[QImageReader.ImageReaderError] = ...
    UnknownError: typing.ClassVar[QImageReader.ImageReaderError] = ...
    UnsupportedFormatError: typing.ClassVar[QImageReader.ImageReaderError] = ...
    @overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def autoDetectImageFormat(self) -> bool: ...
    def autoTransform(self) -> bool: ...
    def backgroundColor(self) -> QColor: ...
    def canRead(self) -> bool: ...
    def clipRect(self) -> PySide2.QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def decideFormatFromContent(self) -> bool: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> QImageReader.ImageReaderError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    def imageCount(self) -> int: ...
    def imageFormat(self) -> QImage.Format: ...
    @classmethod
    def imageFormatsForMimeType(cls, mimeType: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def quality(self) -> int: ...
    def read(self) -> QImage: ...
    def scaledClipRect(self) -> PySide2.QtCore.QRect: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setAutoDetectImageFormat(self, enabled: bool) -> None: ...
    def setAutoTransform(self, enabled: bool) -> None: ...
    def setBackgroundColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setClipRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setDecideFormatFromContent(self, ignored: bool) -> None: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setGamma(self, gamma: float) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setScaledClipRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setScaledSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @classmethod
    def supportedImageFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @classmethod
    def supportedMimeTypes(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportsAnimation(self) -> bool: ...
    def supportsOption(self, option: QImageIOHandler.ImageOption) -> bool: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    def transformation(self) -> typing.Union[QImageIOHandler.Transformations,QImageIOHandler.Transformation]: ...

class QImageWriter(shiboken2.Object):
    class ImageWriterError:
        DeviceError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
        InvalidImageError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
        UnknownError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
        UnsupportedFormatError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __and__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __rand__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __ror__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __sub__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
        def __xor__(self, other: typing.SupportsInt) -> QImageWriter.ImageWriterError: ...
    DeviceError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
    InvalidImageError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
    UnknownError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
    UnsupportedFormatError: typing.ClassVar[QImageWriter.ImageWriterError] = ...
    @overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def canWrite(self) -> bool: ...
    def compression(self) -> int: ...
    def description(self) -> str: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> QImageWriter.ImageWriterError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    @classmethod
    def imageFormatsForMimeType(cls, mimeType: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def optimizedWrite(self) -> bool: ...
    def progressiveScanWrite(self) -> bool: ...
    def quality(self) -> int: ...
    def setCompression(self, compression: int) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setGamma(self, gamma: float) -> None: ...
    def setOptimizedWrite(self, optimize: bool) -> None: ...
    def setProgressiveScanWrite(self, progressive: bool) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setSubType(self, type: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setText(self, key: str, text: str) -> None: ...
    def setTransformation(self, orientation: typing.Union[QImageIOHandler.Transformations,QImageIOHandler.Transformation]) -> None: ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @classmethod
    def supportedImageFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @classmethod
    def supportedMimeTypes(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def supportsOption(self, option: QImageIOHandler.ImageOption) -> bool: ...
    def transformation(self) -> typing.Union[QImageIOHandler.Transformations,QImageIOHandler.Transformation]: ...
    def write(self, image: QImage) -> bool: ...

class QInputEvent(PySide2.QtCore.QEvent):
    ts: typing.Any
    def __init__(self, type: PySide2.QtCore.QEvent.Type, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def setModifiers(self, amodifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def setTimestamp(self, atimestamp: int) -> None: ...
    def timestamp(self) -> int: ...

class QInputMethod(PySide2.QtCore.QObject):
    class Action:
        Click: typing.ClassVar[QInputMethod.Action] = ...
        ContextMenu: typing.ClassVar[QInputMethod.Action] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __and__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __rand__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __rmul__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __ror__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __rsub__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __rxor__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __sub__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
        def __xor__(self, other: typing.SupportsInt) -> QInputMethod.Action: ...
    Click: typing.ClassVar[QInputMethod.Action] = ...
    ContextMenu: typing.ClassVar[QInputMethod.Action] = ...
    anchorRectangleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    animatingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    cursorRectangleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    inputDirectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    inputItemClipRectangleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    keyboardRectangleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    localeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def anchorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def commit(self) -> None: ...
    def cursorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def hide(self) -> None: ...
    def inputDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def inputItemClipRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemTransform(self) -> QTransform: ...
    def invokeAction(self, a: QInputMethod.Action, cursorPosition: int) -> None: ...
    def isAnimating(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> PySide2.QtCore.QRectF: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    @classmethod
    def queryFocusObject(cls, query: PySide2.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def reset(self) -> None: ...
    def setInputItemRectangle(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setInputItemTransform(self, transform: QTransform) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def show(self) -> None: ...
    def update(self, queries: typing.Union[PySide2.QtCore.Qt.InputMethodQueries,PySide2.QtCore.Qt.InputMethodQuery]) -> None: ...

class QInputMethodEvent(PySide2.QtCore.QEvent):
    class Attribute(shiboken2.Object):
        length: typing.Any
        start: typing.Any
        type: typing.Any
        value: typing.Any
        @overload
        def __init__(self, typ: QInputMethodEvent.AttributeType, s: int, l: int, val: typing.Any) -> None: ...
        @overload
        def __init__(self, typ: QInputMethodEvent.AttributeType, s: int, l: int) -> None: ...
        @overload
        def __init__(self, Attribute: QInputMethodEvent.Attribute) -> None: ...
        def __copy__(self) -> None: ...

    class AttributeType:
        Cursor: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
        Language: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
        Ruby: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
        Selection: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
        TextFormat: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __and__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QInputMethodEvent.AttributeType: ...
    Cursor: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
    Language: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
    Ruby: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
    Selection: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
    TextFormat: typing.ClassVar[QInputMethodEvent.AttributeType] = ...
    @overload
    def __init__(self, preeditText: str, attributes: typing.Iterable[QInputMethodEvent.Attribute]) -> None: ...
    @overload
    def __init__(self, other: QInputMethodEvent) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attributes(self) -> typing.List[QInputMethodEvent.Attribute]: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def setCommitString(self, commitString: str, replaceFrom: int = ..., replaceLength: int = ...) -> None: ...

class QInputMethodQueryEvent(PySide2.QtCore.QEvent):
    def __init__(self, queries: typing.Union[PySide2.QtCore.Qt.InputMethodQueries,PySide2.QtCore.Qt.InputMethodQuery]) -> None: ...
    def queries(self) -> typing.Union[PySide2.QtCore.Qt.InputMethodQueries,PySide2.QtCore.Qt.InputMethodQuery]: ...
    def setValue(self, query: PySide2.QtCore.Qt.InputMethodQuery, value: typing.Any) -> None: ...
    def value(self, query: PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...

class QIntValidator(QValidator):
    bottomChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    topChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, bottom: int, top: int, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., bottomChanged: typing.Callable = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., topChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., bottom: int = ..., bottomChanged: typing.Callable = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., top: int = ..., topChanged: typing.Callable = ...) -> None: ...
    def bottom(self) -> int: ...
    def fixup(self, input: str) -> None: ...
    def setBottom(self, arg__1: int) -> None: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, arg__1: int) -> None: ...
    def top(self) -> int: ...
    def validate(self, arg__1: str, arg__2: int) -> QValidator.State: ...

class QKeyEvent(QInputEvent):
    autor: typing.Any
    nModifiers: typing.Any
    nScanCode: typing.Any
    nVirtualKey: typing.Any
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def key(self) -> int: ...
    def matches(self, key: QKeySequence.StandardKey) -> bool: ...
    def modifiers(self) -> typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]: ...
    def nativeModifiers(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeVirtualKey(self) -> int: ...
    def text(self) -> str: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QKeySequence(shiboken2.Object):
    class SequenceFormat:
        NativeText: typing.ClassVar[QKeySequence.SequenceFormat] = ...
        PortableText: typing.ClassVar[QKeySequence.SequenceFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QKeySequence.SequenceFormat: ...

    class SequenceMatch:
        ExactMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
        NoMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
        PartialMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __and__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __rand__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __rmul__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __ror__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __rsub__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __rxor__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __sub__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...
        def __xor__(self, other: typing.SupportsInt) -> QKeySequence.SequenceMatch: ...

    class StandardKey:
        AddTab: typing.ClassVar[QKeySequence.StandardKey] = ...
        Back: typing.ClassVar[QKeySequence.StandardKey] = ...
        Backspace: typing.ClassVar[QKeySequence.StandardKey] = ...
        Bold: typing.ClassVar[QKeySequence.StandardKey] = ...
        Cancel: typing.ClassVar[QKeySequence.StandardKey] = ...
        Close: typing.ClassVar[QKeySequence.StandardKey] = ...
        Copy: typing.ClassVar[QKeySequence.StandardKey] = ...
        Cut: typing.ClassVar[QKeySequence.StandardKey] = ...
        Delete: typing.ClassVar[QKeySequence.StandardKey] = ...
        DeleteCompleteLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        DeleteEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        DeleteEndOfWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        DeleteStartOfWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        Deselect: typing.ClassVar[QKeySequence.StandardKey] = ...
        Find: typing.ClassVar[QKeySequence.StandardKey] = ...
        FindNext: typing.ClassVar[QKeySequence.StandardKey] = ...
        FindPrevious: typing.ClassVar[QKeySequence.StandardKey] = ...
        Forward: typing.ClassVar[QKeySequence.StandardKey] = ...
        FullScreen: typing.ClassVar[QKeySequence.StandardKey] = ...
        HelpContents: typing.ClassVar[QKeySequence.StandardKey] = ...
        InsertLineSeparator: typing.ClassVar[QKeySequence.StandardKey] = ...
        InsertParagraphSeparator: typing.ClassVar[QKeySequence.StandardKey] = ...
        Italic: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToEndOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToEndOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToNextChar: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToNextLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToNextPage: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToNextWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToPreviousChar: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToPreviousLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToPreviousPage: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToPreviousWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToStartOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToStartOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
        MoveToStartOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        New: typing.ClassVar[QKeySequence.StandardKey] = ...
        NextChild: typing.ClassVar[QKeySequence.StandardKey] = ...
        Open: typing.ClassVar[QKeySequence.StandardKey] = ...
        Paste: typing.ClassVar[QKeySequence.StandardKey] = ...
        Preferences: typing.ClassVar[QKeySequence.StandardKey] = ...
        PreviousChild: typing.ClassVar[QKeySequence.StandardKey] = ...
        Print: typing.ClassVar[QKeySequence.StandardKey] = ...
        Quit: typing.ClassVar[QKeySequence.StandardKey] = ...
        Redo: typing.ClassVar[QKeySequence.StandardKey] = ...
        Refresh: typing.ClassVar[QKeySequence.StandardKey] = ...
        Replace: typing.ClassVar[QKeySequence.StandardKey] = ...
        Save: typing.ClassVar[QKeySequence.StandardKey] = ...
        SaveAs: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectAll: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectEndOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectEndOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectNextChar: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectNextLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectNextPage: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectNextWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectPreviousChar: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectPreviousLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectPreviousPage: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectPreviousWord: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectStartOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectStartOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
        SelectStartOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
        Underline: typing.ClassVar[QKeySequence.StandardKey] = ...
        Undo: typing.ClassVar[QKeySequence.StandardKey] = ...
        UnknownKey: typing.ClassVar[QKeySequence.StandardKey] = ...
        WhatsThis: typing.ClassVar[QKeySequence.StandardKey] = ...
        ZoomIn: typing.ClassVar[QKeySequence.StandardKey] = ...
        ZoomOut: typing.ClassVar[QKeySequence.StandardKey] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __and__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __rand__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __rmul__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __ror__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __rsub__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __rxor__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __sub__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
        def __xor__(self, other: typing.SupportsInt) -> QKeySequence.StandardKey: ...
    AddTab: typing.ClassVar[QKeySequence.StandardKey] = ...
    Back: typing.ClassVar[QKeySequence.StandardKey] = ...
    Backspace: typing.ClassVar[QKeySequence.StandardKey] = ...
    Bold: typing.ClassVar[QKeySequence.StandardKey] = ...
    Cancel: typing.ClassVar[QKeySequence.StandardKey] = ...
    Close: typing.ClassVar[QKeySequence.StandardKey] = ...
    Copy: typing.ClassVar[QKeySequence.StandardKey] = ...
    Cut: typing.ClassVar[QKeySequence.StandardKey] = ...
    Delete: typing.ClassVar[QKeySequence.StandardKey] = ...
    DeleteCompleteLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    DeleteEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    DeleteEndOfWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    DeleteStartOfWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    Deselect: typing.ClassVar[QKeySequence.StandardKey] = ...
    ExactMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
    Find: typing.ClassVar[QKeySequence.StandardKey] = ...
    FindNext: typing.ClassVar[QKeySequence.StandardKey] = ...
    FindPrevious: typing.ClassVar[QKeySequence.StandardKey] = ...
    Forward: typing.ClassVar[QKeySequence.StandardKey] = ...
    FullScreen: typing.ClassVar[QKeySequence.StandardKey] = ...
    HelpContents: typing.ClassVar[QKeySequence.StandardKey] = ...
    InsertLineSeparator: typing.ClassVar[QKeySequence.StandardKey] = ...
    InsertParagraphSeparator: typing.ClassVar[QKeySequence.StandardKey] = ...
    Italic: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToEndOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToEndOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToNextChar: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToNextLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToNextPage: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToNextWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToPreviousChar: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToPreviousLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToPreviousPage: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToPreviousWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToStartOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToStartOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
    MoveToStartOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    NativeText: typing.ClassVar[QKeySequence.SequenceFormat] = ...
    New: typing.ClassVar[QKeySequence.StandardKey] = ...
    NextChild: typing.ClassVar[QKeySequence.StandardKey] = ...
    NoMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
    Open: typing.ClassVar[QKeySequence.StandardKey] = ...
    PartialMatch: typing.ClassVar[QKeySequence.SequenceMatch] = ...
    Paste: typing.ClassVar[QKeySequence.StandardKey] = ...
    PortableText: typing.ClassVar[QKeySequence.SequenceFormat] = ...
    Preferences: typing.ClassVar[QKeySequence.StandardKey] = ...
    PreviousChild: typing.ClassVar[QKeySequence.StandardKey] = ...
    Print: typing.ClassVar[QKeySequence.StandardKey] = ...
    Quit: typing.ClassVar[QKeySequence.StandardKey] = ...
    Redo: typing.ClassVar[QKeySequence.StandardKey] = ...
    Refresh: typing.ClassVar[QKeySequence.StandardKey] = ...
    Replace: typing.ClassVar[QKeySequence.StandardKey] = ...
    Save: typing.ClassVar[QKeySequence.StandardKey] = ...
    SaveAs: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectAll: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectEndOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectEndOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectEndOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectNextChar: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectNextLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectNextPage: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectNextWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectPreviousChar: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectPreviousLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectPreviousPage: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectPreviousWord: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectStartOfBlock: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectStartOfDocument: typing.ClassVar[QKeySequence.StandardKey] = ...
    SelectStartOfLine: typing.ClassVar[QKeySequence.StandardKey] = ...
    Underline: typing.ClassVar[QKeySequence.StandardKey] = ...
    Undo: typing.ClassVar[QKeySequence.StandardKey] = ...
    UnknownKey: typing.ClassVar[QKeySequence.StandardKey] = ...
    WhatsThis: typing.ClassVar[QKeySequence.StandardKey] = ...
    ZoomIn: typing.ClassVar[QKeySequence.StandardKey] = ...
    ZoomOut: typing.ClassVar[QKeySequence.StandardKey] = ...
    @overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...) -> None: ...
    @overload
    def __init__(self, key: str, format: QKeySequence.SequenceFormat = ...) -> None: ...
    @overload
    def __init__(self, key: QKeySequence.StandardKey) -> None: ...
    @overload
    def __init__(self, ks: typing.Union[QKeySequence,str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def count(self) -> int: ...
    @classmethod
    def fromString(cls, str: str, format: QKeySequence.SequenceFormat = ...) -> QKeySequence: ...
    def isEmpty(self) -> bool: ...
    @classmethod
    def keyBindings(cls, key: QKeySequence.StandardKey) -> typing.List[QKeySequence]: ...
    @classmethod
    def listFromString(cls, str: str, format: QKeySequence.SequenceFormat = ...) -> typing.List[QKeySequence]: ...
    @classmethod
    def listToString(cls, list: typing.Iterable[QKeySequence], format: QKeySequence.SequenceFormat = ...) -> str: ...
    def matches(self, seq: typing.Union[QKeySequence,str]) -> QKeySequence.SequenceMatch: ...
    @classmethod
    def mnemonic(cls, text: str) -> QKeySequence: ...
    def swap(self, other: typing.Union[QKeySequence,str]) -> None: ...
    def toString(self, format: QKeySequence.SequenceFormat = ...) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QLinearGradient(QGradient):
    @overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...
    @overload
    def __init__(self, start: PySide2.QtCore.QPointF, finalStop: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self, QLinearGradient: QLinearGradient) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def finalStop(self) -> PySide2.QtCore.QPointF: ...
    @overload
    def setFinalStop(self, x: float, y: float) -> None: ...
    @overload
    def setFinalStop(self, stop: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setStart(self, x: float, y: float) -> None: ...
    @overload
    def setStart(self, start: PySide2.QtCore.QPointF) -> None: ...
    def start(self) -> PySide2.QtCore.QPointF: ...
    def __copy__(self) -> None: ...

class QMatrix(shiboken2.Object):
    @overload
    def __init__(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float) -> None: ...
    @overload
    def __init__(self, other: QMatrix) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    def inverted(self) -> typing.Tuple[QMatrix,bool]: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    @overload
    def map(self, x: int, y: int) -> typing.Tuple[int,int]: ...
    @overload
    def map(self, x: float, y: float) -> typing.Tuple[float,float]: ...
    @overload
    def map(self, a: QPolygon) -> QPolygon: ...
    @overload
    def map(self, a: QPolygonF) -> QPolygonF: ...
    @overload
    def map(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @overload
    def map(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @overload
    def map(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def map(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def map(self, p: QPainterPath) -> QPainterPath: ...
    @overload
    def map(self, r: QRegion) -> QRegion: ...
    @overload
    def mapRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @overload
    def mapRect(self, arg__1: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide2.QtCore.QRect) -> QPolygon: ...
    def reset(self) -> None: ...
    def rotate(self, a: float) -> QMatrix: ...
    def scale(self, sx: float, sy: float) -> QMatrix: ...
    def setMatrix(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float) -> None: ...
    def shear(self, sh: float, sv: float) -> QMatrix: ...
    def translate(self, dx: float, dy: float) -> QMatrix: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __imul__(self, arg__1: QMatrix) -> QMatrix: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @overload
    def __mul__(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @overload
    def __mul__(self, o: QMatrix) -> QMatrix: ...
    @overload
    def __mul__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def __mul__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QMatrix2x2(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix2x2: QMatrix2x2) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix2x2: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix2x2) -> QMatrix2x2: ...
    def __imul__(self, factor: float) -> QMatrix2x2: ...
    def __isub__(self, other: QMatrix2x2) -> QMatrix2x2: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix2x3(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix2x3: QMatrix2x3) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix3x2: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix2x3) -> QMatrix2x3: ...
    def __imul__(self, factor: float) -> QMatrix2x3: ...
    def __isub__(self, other: QMatrix2x3) -> QMatrix2x3: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix2x4(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix2x4: QMatrix2x4) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix4x2: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix2x4) -> QMatrix2x4: ...
    def __imul__(self, factor: float) -> QMatrix2x4: ...
    def __isub__(self, other: QMatrix2x4) -> QMatrix2x4: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix3x2(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix3x2: QMatrix3x2) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix2x3: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix3x2) -> QMatrix3x2: ...
    def __imul__(self, factor: float) -> QMatrix3x2: ...
    def __isub__(self, other: QMatrix3x2) -> QMatrix3x2: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix3x3(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix3x3: QMatrix3x3) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix3x3: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix3x3) -> QMatrix3x3: ...
    def __imul__(self, factor: float) -> QMatrix3x3: ...
    def __isub__(self, other: QMatrix3x3) -> QMatrix3x3: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix3x4(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix3x4: QMatrix3x4) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix4x3: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix3x4) -> QMatrix3x4: ...
    def __imul__(self, factor: float) -> QMatrix3x4: ...
    def __isub__(self, other: QMatrix3x4) -> QMatrix3x4: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix4x2(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix4x2: QMatrix4x2) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix2x4: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix4x2) -> QMatrix4x2: ...
    def __imul__(self, factor: float) -> QMatrix4x2: ...
    def __isub__(self, other: QMatrix4x2) -> QMatrix4x2: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix4x3(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, QMatrix4x3: QMatrix4x3) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> QMatrix3x4: ...
    def __call__(self, row: int, column: int) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix4x3) -> QMatrix4x3: ...
    def __imul__(self, factor: float) -> QMatrix4x3: ...
    def __isub__(self, other: QMatrix4x3) -> QMatrix4x3: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMatrix4x4(shiboken2.Object):
    constData: typing.ClassVar[function] = ...
    @overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @overload
    def __init__(self, matrix: QMatrix) -> None: ...
    @overload
    def __init__(self, transform: QTransform) -> None: ...
    @overload
    def __init__(self, values: typing.Iterable[float]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __dummy(self, arg__1: typing.Iterable[float]) -> None: ...
    def column(self, index: int) -> QVector4D: ...
    def copyDataTo(self) -> float: ...
    def data(self) -> typing.List[float]: ...
    def determinant(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def flipCoordinates(self) -> None: ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    def inverted(self) -> typing.Tuple[QMatrix4x4,bool]: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def lookAt(self, eye: QVector3D, center: QVector3D, up: QVector3D) -> None: ...
    @overload
    def map(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def map(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def map(self, point: QVector3D) -> QVector3D: ...
    @overload
    def map(self, point: QVector4D) -> QVector4D: ...
    @overload
    def mapRect(self, rect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @overload
    def mapRect(self, rect: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapVector(self, vector: QVector3D) -> QVector3D: ...
    def normalMatrix(self) -> QMatrix3x3: ...
    def optimize(self) -> None: ...
    @overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @overload
    def ortho(self, rect: PySide2.QtCore.QRect) -> None: ...
    @overload
    def ortho(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def perspective(self, verticalAngle: float, aspectRatio: float, nearPlane: float, farPlane: float) -> None: ...
    @overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None: ...
    @overload
    def rotate(self, angle: float, vector: QVector3D) -> None: ...
    @overload
    def rotate(self, quaternion: QQuaternion) -> None: ...
    def row(self, index: int) -> QVector4D: ...
    @overload
    def scale(self, x: float, y: float, z: float) -> None: ...
    @overload
    def scale(self, x: float, y: float) -> None: ...
    @overload
    def scale(self, factor: float) -> None: ...
    @overload
    def scale(self, vector: QVector3D) -> None: ...
    def setColumn(self, index: int, value: QVector4D) -> None: ...
    def setRow(self, index: int, value: QVector4D) -> None: ...
    def setToIdentity(self) -> None: ...
    def toAffine(self) -> QMatrix: ...
    @overload
    def toTransform(self, distanceToPlane: float) -> QTransform: ...
    @overload
    def toTransform(self) -> QTransform: ...
    @overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    @overload
    def translate(self, x: float, y: float) -> None: ...
    @overload
    def translate(self, vector: QVector3D) -> None: ...
    def transposed(self) -> QMatrix4x4: ...
    @overload
    def viewport(self, left: float, bottom: float, width: float, height: float, nearPlane: float = ..., farPlane: float = ...) -> None: ...
    @overload
    def viewport(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def __add__(self, m2: QMatrix4x4) -> QMatrix4x4: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QMatrix4x4) -> QMatrix4x4: ...
    @overload
    def __imul__(self, factor: float) -> QMatrix4x4: ...
    @overload
    def __imul__(self, other: QMatrix4x4) -> QMatrix4x4: ...
    def __isub__(self, other: QMatrix4x4) -> QMatrix4x4: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QMatrix4x4: ...
    @overload
    def __mul__(self, m2: QMatrix4x4) -> QMatrix4x4: ...
    @overload
    def __mul__(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def __mul__(self, point: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QMatrix4x4: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, m2: QMatrix4x4) -> QMatrix4x4: ...
    def __truediv__(self, other) -> typing.Any: ...

class QMouseEvent(QInputEvent):
    caps: typing.Any
    l: typing.Any
    s: typing.Any
    velocity: typing.Any
    w: typing.Any
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    @overload
    def __init__(self, type: PySide2.QtCore.QEvent.Type, localPos: PySide2.QtCore.QPointF, button: PySide2.QtCore.Qt.MouseButton, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def flags(self) -> typing.Union[PySide2.QtCore.Qt.MouseEventFlags,PySide2.QtCore.Qt.MouseEventFlag]: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def setLocalPos(self, localPosition: PySide2.QtCore.QPointF) -> None: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QMoveEvent(PySide2.QtCore.QEvent):
    def __init__(self, pos: PySide2.QtCore.QPoint, oldPos: PySide2.QtCore.QPoint) -> None: ...
    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...

class QMovie(PySide2.QtCore.QObject):
    class CacheMode:
        CacheAll: typing.ClassVar[QMovie.CacheMode] = ...
        CacheNone: typing.ClassVar[QMovie.CacheMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMovie.CacheMode: ...

    class MovieState:
        NotRunning: typing.ClassVar[QMovie.MovieState] = ...
        Paused: typing.ClassVar[QMovie.MovieState] = ...
        Running: typing.ClassVar[QMovie.MovieState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __and__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __rand__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __ror__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __sub__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
        def __xor__(self, other: typing.SupportsInt) -> QMovie.MovieState: ...
    CacheAll: typing.ClassVar[QMovie.CacheMode] = ...
    CacheNone: typing.ClassVar[QMovie.CacheMode] = ...
    NotRunning: typing.ClassVar[QMovie.MovieState] = ...
    Paused: typing.ClassVar[QMovie.MovieState] = ...
    Running: typing.ClassVar[QMovie.MovieState] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    frameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    resized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    started: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    updated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., cacheMode: QMovie.CacheMode = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., frameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., resized: typing.Callable = ..., speed: int = ..., started: typing.Callable = ..., stateChanged: typing.Callable = ..., updated: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., cacheMode: QMovie.CacheMode = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., frameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., resized: typing.Callable = ..., speed: int = ..., started: typing.Callable = ..., stateChanged: typing.Callable = ..., updated: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., cacheMode: QMovie.CacheMode = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., frameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., resized: typing.Callable = ..., speed: int = ..., started: typing.Callable = ..., stateChanged: typing.Callable = ..., updated: typing.Callable = ...) -> None: ...
    def backgroundColor(self) -> QColor: ...
    def cacheMode(self) -> QMovie.CacheMode: ...
    def currentFrameNumber(self) -> int: ...
    def currentImage(self) -> QImage: ...
    def currentPixmap(self) -> QPixmap: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def frameCount(self) -> int: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def isValid(self) -> bool: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def jumpToNextFrame(self) -> bool: ...
    def lastError(self) -> QImageReader.ImageReaderError: ...
    def lastErrorString(self) -> str: ...
    def loopCount(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setBackgroundColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setCacheMode(self, mode: QMovie.CacheMode) -> None: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setScaledSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setSpeed(self, percentSpeed: int) -> None: ...
    def speed(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> QMovie.MovieState: ...
    def stop(self) -> None: ...
    @classmethod
    def supportedFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...

class QNativeGestureEvent(QInputEvent):
    @overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, dev: QTouchDevice, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int) -> None: ...
    @overload
    def __init__(self, type: PySide2.QtCore.Qt.NativeGestureType, localPos: PySide2.QtCore.QPointF, windowPos: PySide2.QtCore.QPointF, screenPos: PySide2.QtCore.QPointF, value: float, sequenceId: int, intArgument: int) -> None: ...
    def device(self) -> QTouchDevice: ...
    def gestureType(self) -> PySide2.QtCore.Qt.NativeGestureType: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def value(self) -> float: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...

class QOffscreenSurface(PySide2.QtCore.QObject, QSurface):
    screenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, screen: QScreen, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., screenChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, screen: typing.Union[QScreen,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., screenChanged: typing.Callable = ...) -> None: ...
    def create(self) -> None: ...
    def destroy(self) -> None: ...
    def format(self) -> QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def nativeHandle(self) -> int: ...
    def requestedFormat(self) -> QSurfaceFormat: ...
    def screen(self) -> QScreen: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...
    def setNativeHandle(self, handle: int) -> None: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> QSurface.SurfaceType: ...

class QOpenGLBuffer(shiboken2.Object):
    class Access:
        ReadOnly: typing.ClassVar[QOpenGLBuffer.Access] = ...
        ReadWrite: typing.ClassVar[QOpenGLBuffer.Access] = ...
        WriteOnly: typing.ClassVar[QOpenGLBuffer.Access] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Access: ...

    class RangeAccessFlag:
        RangeFlushExplicit: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        RangeInvalidate: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        RangeInvalidateBuffer: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        RangeRead: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        RangeUnsynchronized: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        RangeWrite: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...

    class RangeAccessFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.RangeAccessFlags: ...

    class Type:
        IndexBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
        PixelPackBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
        PixelUnpackBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
        VertexBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.Type: ...

    class UsagePattern:
        DynamicCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        DynamicDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        DynamicRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StaticCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StaticDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StaticRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StreamCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StreamDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        StreamRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLBuffer.UsagePattern: ...
    DynamicCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    DynamicDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    DynamicRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    IndexBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
    PixelPackBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
    PixelUnpackBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
    RangeFlushExplicit: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    RangeInvalidate: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    RangeInvalidateBuffer: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    RangeRead: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    RangeUnsynchronized: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    RangeWrite: typing.ClassVar[QOpenGLBuffer.RangeAccessFlag] = ...
    ReadOnly: typing.ClassVar[QOpenGLBuffer.Access] = ...
    ReadWrite: typing.ClassVar[QOpenGLBuffer.Access] = ...
    StaticCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    StaticDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    StaticRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    StreamCopy: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    StreamDraw: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    StreamRead: typing.ClassVar[QOpenGLBuffer.UsagePattern] = ...
    VertexBuffer: typing.ClassVar[QOpenGLBuffer.Type] = ...
    WriteOnly: typing.ClassVar[QOpenGLBuffer.Access] = ...
    @overload
    def __init__(self, other: QOpenGLBuffer) -> None: ...
    @overload
    def __init__(self, type: QOpenGLBuffer.Type) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def allocate(self, data: int, count: int) -> None: ...
    @overload
    def allocate(self, count: int) -> None: ...
    def bind(self) -> bool: ...
    def bufferId(self) -> int: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def map(self, access: QOpenGLBuffer.Access) -> int: ...
    def mapRange(self, offset: int, count: int, access: typing.Union[QOpenGLBuffer.RangeAccessFlags,QOpenGLBuffer.RangeAccessFlag]) -> int: ...
    def read(self, offset: int, data: int, count: int) -> bool: ...
    def release(self) -> None: ...
    def setUsagePattern(self, value: QOpenGLBuffer.UsagePattern) -> None: ...
    def size(self) -> int: ...
    def type(self) -> QOpenGLBuffer.Type: ...
    def unmap(self) -> bool: ...
    def usagePattern(self) -> QOpenGLBuffer.UsagePattern: ...
    def write(self, offset: int, data: int, count: int) -> None: ...

class QOpenGLContext(PySide2.QtCore.QObject):
    class OpenGLModuleType:
        LibGL: typing.ClassVar[QOpenGLContext.OpenGLModuleType] = ...
        LibGLES: typing.ClassVar[QOpenGLContext.OpenGLModuleType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLContext.OpenGLModuleType: ...
    LibGL: typing.ClassVar[QOpenGLContext.OpenGLModuleType] = ...
    LibGLES: typing.ClassVar[QOpenGLContext.OpenGLModuleType] = ...
    aboutToBeDestroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aboutToBeDestroyed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def areSharing(cls, first: QOpenGLContext, second: QOpenGLContext) -> bool: ...
    def create(self) -> bool: ...
    @classmethod
    def currentContext(cls) -> QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def extensions(self) -> typing.Set[PySide2.QtCore.QByteArray]: ...
    def extraFunctions(self) -> QOpenGLExtraFunctions: ...
    def format(self) -> QSurfaceFormat: ...
    def functions(self) -> QOpenGLFunctions: ...
    @classmethod
    def globalShareContext(cls) -> QOpenGLContext: ...
    def hasExtension(self, extension: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    def isOpenGLES(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self, surface: QSurface) -> bool: ...
    def nativeHandle(self) -> typing.Any: ...
    @classmethod
    def openGLModuleHandle(cls) -> int: ...
    @classmethod
    def openGLModuleType(cls) -> QOpenGLContext.OpenGLModuleType: ...
    def screen(self) -> QScreen: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...
    def setNativeHandle(self, handle: typing.Any) -> None: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def setShareContext(self, shareContext: QOpenGLContext) -> None: ...
    def shareContext(self) -> QOpenGLContext: ...
    def shareGroup(self) -> QOpenGLContextGroup: ...
    @classmethod
    def supportsThreadedOpenGL(cls) -> bool: ...
    def surface(self) -> QSurface: ...
    def swapBuffers(self, surface: QSurface) -> None: ...
    def versionFunctions(self, versionProfile: QOpenGLVersionProfile = ...) -> QAbstractOpenGLFunctions: ...

class QOpenGLContextGroup(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def currentContextGroup(cls) -> QOpenGLContextGroup: ...
    def shares(self) -> typing.List[QOpenGLContext]: ...

class QOpenGLDebugLogger(PySide2.QtCore.QObject):
    class LoggingMode:
        AsynchronousLogging: typing.ClassVar[QOpenGLDebugLogger.LoggingMode] = ...
        SynchronousLogging: typing.ClassVar[QOpenGLDebugLogger.LoggingMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugLogger.LoggingMode: ...
    AsynchronousLogging: typing.ClassVar[QOpenGLDebugLogger.LoggingMode] = ...
    SynchronousLogging: typing.ClassVar[QOpenGLDebugLogger.LoggingMode] = ...
    messageLogged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., loggingMode: QOpenGLDebugLogger.LoggingMode = ..., messageLogged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def disableMessages(self, ids: typing.List[int], sources: typing.Union[QOpenGLDebugMessage.Sources,QOpenGLDebugMessage.Source] = ..., types: typing.Union[QOpenGLDebugMessage.Types,QOpenGLDebugMessage.Type] = ...) -> None: ...
    @overload
    def disableMessages(self, sources: typing.Union[QOpenGLDebugMessage.Sources,QOpenGLDebugMessage.Source] = ..., types: typing.Union[QOpenGLDebugMessage.Types,QOpenGLDebugMessage.Type] = ..., severities: typing.Union[QOpenGLDebugMessage.Severities,QOpenGLDebugMessage.Severity] = ...) -> None: ...
    @overload
    def enableMessages(self, ids: typing.List[int], sources: typing.Union[QOpenGLDebugMessage.Sources,QOpenGLDebugMessage.Source] = ..., types: typing.Union[QOpenGLDebugMessage.Types,QOpenGLDebugMessage.Type] = ...) -> None: ...
    @overload
    def enableMessages(self, sources: typing.Union[QOpenGLDebugMessage.Sources,QOpenGLDebugMessage.Source] = ..., types: typing.Union[QOpenGLDebugMessage.Types,QOpenGLDebugMessage.Type] = ..., severities: typing.Union[QOpenGLDebugMessage.Severities,QOpenGLDebugMessage.Severity] = ...) -> None: ...
    def initialize(self) -> bool: ...
    def isLogging(self) -> bool: ...
    def logMessage(self, debugMessage: QOpenGLDebugMessage) -> None: ...
    def loggedMessages(self) -> typing.List[QOpenGLDebugMessage]: ...
    def loggingMode(self) -> QOpenGLDebugLogger.LoggingMode: ...
    def maximumMessageLength(self) -> int: ...
    def popGroup(self) -> None: ...
    def pushGroup(self, name: str, id: int = ..., source: QOpenGLDebugMessage.Source = ...) -> None: ...
    def startLogging(self, loggingMode: QOpenGLDebugLogger.LoggingMode = ...) -> None: ...
    def stopLogging(self) -> None: ...

class QOpenGLDebugMessage(shiboken2.Object):
    class Severities:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Severities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...

    class Severity:
        AnySeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        HighSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        InvalidSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        LastSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        LowSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        MediumSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        NotificationSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Severities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Severities: ...

    class Source:
        APISource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        AnySource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        ApplicationSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        InvalidSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        LastSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        OtherSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        ShaderCompilerSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        ThirdPartySource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        WindowSystemSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Sources: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...

    class Sources:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Sources: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Sources: ...

    class Type:
        AnyType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        DeprecatedBehaviorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        ErrorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        GroupPopType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        GroupPushType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        InvalidType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        LastType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        MarkerType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        OtherType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        PerformanceType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        PortabilityType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        UndefinedBehaviorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Types: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...

    class Types:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLDebugMessage.Types: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLDebugMessage.Types: ...
    APISource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    AnySeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    AnySource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    AnyType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    ApplicationSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    DeprecatedBehaviorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    ErrorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    GroupPopType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    GroupPushType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    HighSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    InvalidSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    InvalidSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    InvalidType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    LastSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    LastSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    LastType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    LowSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    MarkerType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    MediumSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    NotificationSeverity: typing.ClassVar[QOpenGLDebugMessage.Severity] = ...
    OtherSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    OtherType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    PerformanceType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    PortabilityType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    ShaderCompilerSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    ThirdPartySource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    UndefinedBehaviorType: typing.ClassVar[QOpenGLDebugMessage.Type] = ...
    WindowSystemSource: typing.ClassVar[QOpenGLDebugMessage.Source] = ...
    @overload
    def __init__(self, debugMessage: QOpenGLDebugMessage) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def createApplicationMessage(cls, text: str, id: int = ..., severity: QOpenGLDebugMessage.Severity = ..., type: QOpenGLDebugMessage.Type = ...) -> QOpenGLDebugMessage: ...
    @classmethod
    def createThirdPartyMessage(cls, text: str, id: int = ..., severity: QOpenGLDebugMessage.Severity = ..., type: QOpenGLDebugMessage.Type = ...) -> QOpenGLDebugMessage: ...
    def id(self) -> int: ...
    def message(self) -> str: ...
    def severity(self) -> QOpenGLDebugMessage.Severity: ...
    def source(self) -> QOpenGLDebugMessage.Source: ...
    def swap(self, other: QOpenGLDebugMessage) -> None: ...
    def type(self) -> QOpenGLDebugMessage.Type: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QOpenGLExtraFunctions(QOpenGLFunctions):
    @overload
    def __init__(self, context: QOpenGLContext) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def glActiveShaderProgram(self, pipeline: int, program: int) -> None: ...
    def glBeginQuery(self, target: int, id: int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode: int) -> None: ...
    def glBindBufferBase(self, target: int, index: int, buffer: int) -> None: ...
    def glBindImageTexture(self, unit: int, texture: int, level: int, layered: int, layer: int, access: int, format: int) -> None: ...
    def glBindProgramPipeline(self, pipeline: int) -> None: ...
    def glBindSampler(self, unit: int, sampler: int) -> None: ...
    def glBindTransformFeedback(self, target: int, id: int) -> None: ...
    def glBindVertexArray(self, array: int) -> None: ...
    def glBlendBarrier(self) -> None: ...
    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendEquationi(self, buf: int, mode: int) -> None: ...
    def glBlendFuncSeparatei(self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glBlendFunci(self, buf: int, src: int, dst: int) -> None: ...
    def glBlitFramebuffer(self, srcX0: int, srcY0: int, srcX1: int, srcY1: int, dstX0: int, dstY0: int, dstX1: int, dstY1: int, mask: int, filter: int) -> None: ...
    def glClearBufferfi(self, buffer: int, drawbuffer: int, depth: float, stencil: int) -> None: ...
    def glClearBufferfv(self, buffer: int, drawbuffer: int, value: typing.Iterable[float]) -> None: ...
    def glClearBufferiv(self, buffer: int, drawbuffer: int, value: typing.Iterable[int]) -> None: ...
    def glClearBufferuiv(self, buffer: int, drawbuffer: int, value: typing.Iterable[int]) -> None: ...
    def glColorMaski(self, index: int, r: int, g: int, b: int, a: int) -> None: ...
    def glCompressedTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyImageSubData(self, srcName: int, srcTarget: int, srcLevel: int, srcX: int, srcY: int, srcZ: int, dstName: int, dstTarget: int, dstLevel: int, dstX: int, dstY: int, dstZ: int, srcWidth: int, srcHeight: int, srcDepth: int) -> None: ...
    def glCopyTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glDebugMessageControl(self, source: int, type: int, severity: int, count: int, ids: typing.Iterable[int], enabled: int) -> None: ...
    def glDebugMessageInsert(self, source: int, type: int, id: int, severity: int, length: int, buf: bytes) -> None: ...
    def glDeleteProgramPipelines(self, n: int, pipelines: typing.Iterable[int]) -> None: ...
    def glDeleteQueries(self, n: int, ids: typing.Iterable[int]) -> None: ...
    def glDeleteSamplers(self, count: int, samplers: typing.Iterable[int]) -> None: ...
    def glDeleteTransformFeedbacks(self, n: int, ids: typing.Iterable[int]) -> None: ...
    def glDeleteVertexArrays(self, n: int, arrays: typing.Iterable[int]) -> None: ...
    def glDisablei(self, target: int, index: int) -> None: ...
    def glDispatchCompute(self, num_groups_x: int, num_groups_y: int, num_groups_z: int) -> None: ...
    def glDrawArraysIndirect(self, mode: int, indirect: int) -> None: ...
    def glDrawArraysInstanced(self, mode: int, first: int, count: int, instancecount: int) -> None: ...
    def glDrawBuffers(self, n: int, bufs: typing.Iterable[int]) -> None: ...
    def glDrawElementsBaseVertex(self, mode: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int) -> None: ...
    def glDrawElementsInstanced(self, mode: int, count: int, type: int, indices: int, instancecount: int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode: int, count: int, type: int, indices: int, instancecount: int, basevertex: int) -> None: ...
    def glDrawRangeElements(self, mode: int, start: int, end: int, count: int, type: int, indices: int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode: int, start: int, end: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glEnablei(self, target: int, index: int) -> None: ...
    def glEndQuery(self, target: int) -> None: ...
    def glFramebufferParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glFramebufferTexture(self, target: int, attachment: int, texture: int, level: int) -> None: ...
    def glFramebufferTextureLayer(self, target: int, attachment: int, texture: int, level: int, layer: int) -> None: ...
    def glGenProgramPipelines(self, n: int, pipelines: typing.Iterable[int]) -> None: ...
    def glGenQueries(self, n: int, ids: typing.Iterable[int]) -> None: ...
    def glGenSamplers(self, count: int, samplers: typing.Iterable[int]) -> None: ...
    def glGenTransformFeedbacks(self, n: int, ids: typing.Iterable[int]) -> None: ...
    def glGenVertexArrays(self, n: int, arrays: typing.Iterable[int]) -> None: ...
    def glGetActiveUniformBlockiv(self, program: int, uniformBlockIndex: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetActiveUniformsiv(self, program: int, uniformCount: int, uniformIndices: typing.Iterable[int], pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetBufferParameteri64v(self, target: int, pname: int) -> int: ...
    def glGetFragDataLocation(self, program: int, name: bytes) -> int: ...
    def glGetFramebufferParameteriv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetInteger64i_v(self, target: int, index: int) -> int: ...
    def glGetInteger64v(self, pname: int) -> int: ...
    def glGetIntegeri_v(self, target: int, index: int, data: typing.Iterable[int]) -> None: ...
    def glGetInternalformativ(self, target: int, internalformat: int, pname: int, bufSize: int, params: typing.Iterable[int]) -> None: ...
    def glGetMultisamplefv(self, pname: int, index: int, val: typing.Iterable[float]) -> None: ...
    def glGetProgramBinary(self, program: int, bufSize: int, binary: int) -> typing.Tuple[int,int]: ...
    def glGetProgramInterfaceiv(self, program: int, programInterface: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetProgramPipelineiv(self, pipeline: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetProgramResourceIndex(self, program: int, programInterface: int, name: bytes) -> int: ...
    def glGetProgramResourceLocation(self, program: int, programInterface: int, name: bytes) -> int: ...
    def glGetProgramResourceiv(self, program: int, programInterface: int, index: int, propCount: int, props: typing.Iterable[int], bufSize: int, length: typing.Iterable[int], params: typing.Iterable[int]) -> None: ...
    def glGetQueryObjectuiv(self, id: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetQueryiv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetSamplerParameterIiv(self, sampler: int, pname: int) -> int: ...
    def glGetSamplerParameterIuiv(self, sampler: int, pname: int) -> int: ...
    def glGetSamplerParameterfv(self, sampler: int, pname: int, params: typing.Iterable[float]) -> None: ...
    def glGetSamplerParameteriv(self, sampler: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetStringi(self, name: int, index: int) -> bytes: ...
    def glGetTexLevelParameterfv(self, target: int, level: int, pname: int, params: typing.Iterable[float]) -> None: ...
    def glGetTexLevelParameteriv(self, target: int, level: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetTexParameterIiv(self, target: int, pname: int) -> int: ...
    def glGetTexParameterIuiv(self, target: int, pname: int) -> int: ...
    def glGetUniformBlockIndex(self, program: int, uniformBlockName: bytes) -> int: ...
    def glGetUniformuiv(self, program: int, location: int, params: typing.Iterable[int]) -> None: ...
    def glGetVertexAttribIiv(self, index: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetVertexAttribIuiv(self, index: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetnUniformfv(self, program: int, location: int, bufSize: int) -> float: ...
    def glGetnUniformiv(self, program: int, location: int, bufSize: int) -> int: ...
    def glGetnUniformuiv(self, program: int, location: int, bufSize: int) -> int: ...
    def glInvalidateFramebuffer(self, target: int, numAttachments: int, attachments: typing.Iterable[int]) -> None: ...
    def glInvalidateSubFramebuffer(self, target: int, numAttachments: int, attachments: typing.Iterable[int], x: int, y: int, width: int, height: int) -> None: ...
    def glIsEnabledi(self, target: int, index: int) -> int: ...
    def glIsProgramPipeline(self, pipeline: int) -> int: ...
    def glIsQuery(self, id: int) -> int: ...
    def glIsSampler(self, sampler: int) -> int: ...
    def glIsTransformFeedback(self, id: int) -> int: ...
    def glIsVertexArray(self, array: int) -> int: ...
    def glMemoryBarrier(self, barriers: int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers: int) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glObjectLabel(self, identifier: int, name: int, length: int, label: bytes) -> None: ...
    def glObjectPtrLabel(self, ptr: int, length: int, label: bytes) -> None: ...
    def glPatchParameteri(self, pname: int, value: int) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveBoundingBox(self, minX: float, minY: float, minZ: float, minW: float, maxX: float, maxY: float, maxZ: float, maxW: float) -> None: ...
    def glProgramBinary(self, program: int, binaryFormat: int, binary: int, length: int) -> None: ...
    def glProgramParameteri(self, program: int, pname: int, value: int) -> None: ...
    def glProgramUniform1f(self, program: int, location: int, v0: float) -> None: ...
    def glProgramUniform1fv(self, program: int, location: int, count: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniform1i(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1iv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform1ui(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1uiv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform2f(self, program: int, location: int, v0: float, v1: float) -> None: ...
    def glProgramUniform2fv(self, program: int, location: int, count: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2iv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform2ui(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2uiv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform3f(self, program: int, location: int, v0: float, v1: float, v2: float) -> None: ...
    def glProgramUniform3fv(self, program: int, location: int, count: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniform3i(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3iv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform3ui(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3uiv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform4f(self, program: int, location: int, v0: float, v1: float, v2: float, v3: float) -> None: ...
    def glProgramUniform4fv(self, program: int, location: int, count: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniform4i(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4iv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniform4ui(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4uiv(self, program: int, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glProgramUniformMatrix2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glPushDebugGroup(self, source: int, id: int, length: int, message: bytes) -> None: ...
    def glReadBuffer(self, mode: int) -> None: ...
    def glReadnPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, bufSize: int, data: int) -> None: ...
    def glRenderbufferStorageMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleMaski(self, maskNumber: int, mask: int) -> None: ...
    def glSamplerParameterIiv(self, sampler: int, pname: int, param: typing.Iterable[int]) -> None: ...
    def glSamplerParameterIuiv(self, sampler: int, pname: int, param: typing.Iterable[int]) -> None: ...
    def glSamplerParameterf(self, sampler: int, pname: int, param: float) -> None: ...
    def glSamplerParameterfv(self, sampler: int, pname: int, param: typing.Iterable[float]) -> None: ...
    def glSamplerParameteri(self, sampler: int, pname: int, param: int) -> None: ...
    def glSamplerParameteriv(self, sampler: int, pname: int, param: typing.Iterable[int]) -> None: ...
    def glTexBuffer(self, target: int, internalformat: int, buffer: int) -> None: ...
    def glTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterIiv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glTexParameterIuiv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glTexStorage2D(self, target: int, levels: int, internalformat: int, width: int, height: int) -> None: ...
    def glTexStorage2DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, fixedsamplelocations: int) -> None: ...
    def glTexStorage3D(self, target: int, levels: int, internalformat: int, width: int, height: int, depth: int) -> None: ...
    def glTexStorage3DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, depth: int, fixedsamplelocations: int) -> None: ...
    def glTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1ui(self, location: int, v0: int) -> None: ...
    def glUniform1uiv(self, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glUniform2ui(self, location: int, v0: int, v1: int) -> None: ...
    def glUniform2uiv(self, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glUniform3uiv(self, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glUniform4uiv(self, location: int, count: int, value: typing.Iterable[int]) -> None: ...
    def glUniformBlockBinding(self, program: int, uniformBlockIndex: int, uniformBlockBinding: int) -> None: ...
    def glUniformMatrix2x3fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix2x4fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix3x2fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix3x4fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix4x2fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix4x3fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUnmapBuffer(self, target: int) -> int: ...
    def glUseProgramStages(self, pipeline: int, stages: int, program: int) -> None: ...
    def glValidateProgramPipeline(self, pipeline: int) -> None: ...
    def glVertexAttribBinding(self, attribindex: int, bindingindex: int) -> None: ...
    def glVertexAttribDivisor(self, index: int, divisor: int) -> None: ...
    def glVertexAttribFormat(self, attribindex: int, size: int, type: int, normalized: int, relativeoffset: int) -> None: ...
    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4iv(self, index: int, v: typing.Iterable[int]) -> None: ...
    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4uiv(self, index: int, v: typing.Iterable[int]) -> None: ...
    def glVertexAttribIFormat(self, attribindex: int, size: int, type: int, relativeoffset: int) -> None: ...
    def glVertexAttribIPointer(self, index: int, size: int, type: int, stride: int, pointer: int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex: int, divisor: int) -> None: ...

class QOpenGLFramebufferObject(shiboken2.Object):
    class Attachment:
        CombinedDepthStencil: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
        Depth: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
        NoAttachment: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.Attachment: ...

    class FramebufferRestorePolicy:
        DontRestoreFramebufferBinding: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
        RestoreFrameBufferBinding: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
        RestoreFramebufferBindingToDefault: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLFramebufferObject.FramebufferRestorePolicy: ...
    CombinedDepthStencil: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
    Depth: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
    DontRestoreFramebufferBinding: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
    NoAttachment: typing.ClassVar[QOpenGLFramebufferObject.Attachment] = ...
    RestoreFrameBufferBinding: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
    RestoreFramebufferBindingToDefault: typing.ClassVar[QOpenGLFramebufferObject.FramebufferRestorePolicy] = ...
    @overload
    def __init__(self, width: int, height: int, attachment: QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, attachment: QOpenGLFramebufferObject.Attachment, target: int = ..., internalFormat: int = ...) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: QOpenGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, format: QOpenGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, target: int = ...) -> None: ...
    @overload
    def addColorAttachment(self, width: int, height: int, internalFormat: int = ...) -> None: ...
    @overload
    def addColorAttachment(self, size: PySide2.QtCore.QSize, internalFormat: int = ...) -> None: ...
    def attachment(self) -> QOpenGLFramebufferObject.Attachment: ...
    def bind(self) -> bool: ...
    @classmethod
    def bindDefault(cls) -> bool: ...
    @overload
    @classmethod
    def blitFramebuffer(cls, target: QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int, restorePolicy: QOpenGLFramebufferObject.FramebufferRestorePolicy) -> None: ...
    @overload
    @classmethod
    def blitFramebuffer(cls, target: QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int) -> None: ...
    @overload
    @classmethod
    def blitFramebuffer(cls, target: QOpenGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int = ..., filter: int = ...) -> None: ...
    @overload
    @classmethod
    def blitFramebuffer(cls, target: QOpenGLFramebufferObject, source: QOpenGLFramebufferObject, buffers: int = ..., filter: int = ...) -> None: ...
    def format(self) -> QOpenGLFramebufferObjectFormat: ...
    def handle(self) -> int: ...
    @classmethod
    def hasOpenGLFramebufferBlit(cls) -> bool: ...
    @classmethod
    def hasOpenGLFramebufferObjects(cls) -> bool: ...
    def height(self) -> int: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def release(self) -> bool: ...
    def setAttachment(self, attachment: QOpenGLFramebufferObject.Attachment) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List[PySide2.QtCore.QSize]: ...
    @overload
    def takeTexture(self, colorAttachmentIndex: int) -> int: ...
    @overload
    def takeTexture(self) -> int: ...
    def texture(self) -> int: ...
    def textures(self) -> typing.List[int]: ...
    @overload
    def toImage(self, flipped: bool, colorAttachmentIndex: int) -> QImage: ...
    @overload
    def toImage(self, flipped: bool) -> QImage: ...
    @overload
    def toImage(self) -> QImage: ...
    def width(self) -> int: ...

class QOpenGLFramebufferObjectFormat(shiboken2.Object):
    @overload
    def __init__(self, other: QOpenGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attachment(self) -> QOpenGLFramebufferObject.Attachment: ...
    def internalTextureFormat(self) -> int: ...
    def mipmap(self) -> bool: ...
    def samples(self) -> int: ...
    def setAttachment(self, attachment: QOpenGLFramebufferObject.Attachment) -> None: ...
    def setInternalTextureFormat(self, internalTextureFormat: int) -> None: ...
    def setMipmap(self, enabled: bool) -> None: ...
    def setSamples(self, samples: int) -> None: ...
    def setTextureTarget(self, target: int) -> None: ...
    def textureTarget(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QOpenGLFunctions(shiboken2.Object):
    class OpenGLFeature:
        BlendColor: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        BlendEquation: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        BlendEquationAdvanced: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        BlendEquationSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        BlendFuncSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        BlendSubtract: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        Buffers: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        CompressedTextures: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        FixedFunctionPipeline: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        Framebuffers: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        MultipleRenderTargets: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        Multisample: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        Multitexture: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        NPOTTextureRepeat: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        NPOTTextures: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        Shaders: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        StencilSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        TextureRGFormats: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...

    class OpenGLFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLFunctions.OpenGLFeatures: ...
    BlendColor: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    BlendEquation: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    BlendEquationAdvanced: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    BlendEquationSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    BlendFuncSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    BlendSubtract: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    Buffers: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    CompressedTextures: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    FixedFunctionPipeline: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    Framebuffers: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    MultipleRenderTargets: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    Multisample: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    Multitexture: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    NPOTTextureRepeat: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    NPOTTextures: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    Shaders: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    StencilSeparate: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    TextureRGFormats: typing.ClassVar[QOpenGLFunctions.OpenGLFeature] = ...
    @overload
    def __init__(self, context: QOpenGLContext) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def glActiveTexture(self, texture: int) -> None: ...
    def glAttachShader(self, program: int, shader: int) -> None: ...
    def glBindAttribLocation(self, program: int, index: int, name: bytes) -> None: ...
    def glBindBuffer(self, target: int, buffer: int) -> None: ...
    def glBindFramebuffer(self, target: int, framebuffer: int) -> None: ...
    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None: ...
    def glBindTexture(self, target: int, texture: int) -> None: ...
    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glBlendEquation(self, mode: int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendFunc(self, sfactor: int, dfactor: int) -> None: ...
    def glBlendFuncSeparate(self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glCheckFramebufferStatus(self, target: int) -> int: ...
    def glClear(self, mask: int) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepthf(self, depth: float) -> None: ...
    def glClearStencil(self, s: int) -> None: ...
    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None: ...
    def glCompileShader(self, shader: int) -> None: ...
    def glCompressedTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyTexImage2D(self, target: int, level: int, internalformat: int, x: int, y: int, width: int, height: int, border: int) -> None: ...
    def glCopyTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type: int) -> int: ...
    def glCullFace(self, mode: int) -> None: ...
    def glDeleteBuffers(self, n: int, buffers: typing.Iterable[int]) -> None: ...
    def glDeleteFramebuffers(self, n: int, framebuffers: typing.Iterable[int]) -> None: ...
    def glDeleteProgram(self, program: int) -> None: ...
    def glDeleteRenderbuffers(self, n: int, renderbuffers: typing.Iterable[int]) -> None: ...
    def glDeleteShader(self, shader: int) -> None: ...
    def glDeleteTextures(self, n: int, textures: typing.Iterable[int]) -> None: ...
    def glDepthFunc(self, func: int) -> None: ...
    def glDepthMask(self, flag: int) -> None: ...
    def glDepthRangef(self, zNear: float, zFar: float) -> None: ...
    def glDetachShader(self, program: int, shader: int) -> None: ...
    def glDisable(self, cap: int) -> None: ...
    def glDisableVertexAttribArray(self, index: int) -> None: ...
    def glDrawArrays(self, mode: int, first: int, count: int) -> None: ...
    def glDrawElements(self, mode: int, count: int, type: int, indices: int) -> None: ...
    def glEnable(self, cap: int) -> None: ...
    def glEnableVertexAttribArray(self, index: int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int) -> None: ...
    def glFramebufferTexture2D(self, target: int, attachment: int, textarget: int, texture: int, level: int) -> None: ...
    def glFrontFace(self, mode: int) -> None: ...
    def glGenBuffers(self, n: int, buffers: typing.Iterable[int]) -> None: ...
    def glGenFramebuffers(self, n: int, framebuffers: typing.Iterable[int]) -> None: ...
    def glGenRenderbuffers(self, n: int, renderbuffers: typing.Iterable[int]) -> None: ...
    def glGenTextures(self, n: int, textures: typing.Iterable[int]) -> None: ...
    def glGenerateMipmap(self, target: int) -> None: ...
    def glGetAttachedShaders(self, program: int, maxcount: int, count: typing.Iterable[int], shaders: typing.Iterable[int]) -> None: ...
    def glGetAttribLocation(self, program: int, name: bytes) -> int: ...
    def glGetBufferParameteriv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFloatv(self, pname: int, params: typing.Iterable[float]) -> None: ...
    def glGetFramebufferAttachmentParameteriv(self, target: int, attachment: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetIntegerv(self, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetProgramiv(self, program: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetRenderbufferParameteriv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetShaderPrecisionFormat(self, shadertype: int, precisiontype: int, range: typing.Iterable[int], precision: typing.Iterable[int]) -> None: ...
    def glGetShaderiv(self, shader: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetString(self, name: int) -> bytes: ...
    def glGetTexParameterfv(self, target: int, pname: int, params: typing.Iterable[float]) -> None: ...
    def glGetTexParameteriv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glGetUniformLocation(self, program: int, name: bytes) -> int: ...
    def glGetUniformfv(self, program: int, location: int, params: typing.Iterable[float]) -> None: ...
    def glGetUniformiv(self, program: int, location: int, params: typing.Iterable[int]) -> None: ...
    def glGetVertexAttribfv(self, index: int, pname: int, params: typing.Iterable[float]) -> None: ...
    def glGetVertexAttribiv(self, index: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glHint(self, target: int, mode: int) -> None: ...
    def glIsBuffer(self, buffer: int) -> int: ...
    def glIsEnabled(self, cap: int) -> int: ...
    def glIsFramebuffer(self, framebuffer: int) -> int: ...
    def glIsProgram(self, program: int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer: int) -> int: ...
    def glIsShader(self, shader: int) -> int: ...
    def glIsTexture(self, texture: int) -> int: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLinkProgram(self, program: int) -> None: ...
    def glPixelStorei(self, pname: int, param: int) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReadPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleCoverage(self, value: float, invert: int) -> None: ...
    def glScissor(self, x: int, y: int, width: int, height: int) -> None: ...
    def glShaderBinary(self, n: int, shaders: typing.Iterable[int], binaryformat: int, binary: int, length: int) -> None: ...
    def glStencilFunc(self, func: int, ref: int, mask: int) -> None: ...
    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None: ...
    def glStencilMask(self, mask: int) -> None: ...
    def glStencilMaskSeparate(self, face: int, mask: int) -> None: ...
    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None: ...
    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int) -> None: ...
    def glTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterf(self, target: int, pname: int, param: float) -> None: ...
    def glTexParameterfv(self, target: int, pname: int, params: typing.Iterable[float]) -> None: ...
    def glTexParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glTexParameteriv(self, target: int, pname: int, params: typing.Iterable[int]) -> None: ...
    def glTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1f(self, location: int, x: float) -> None: ...
    def glUniform1fv(self, location: int, count: int, v: typing.Iterable[float]) -> None: ...
    def glUniform1i(self, location: int, x: int) -> None: ...
    def glUniform1iv(self, location: int, count: int, v: typing.Iterable[int]) -> None: ...
    def glUniform2f(self, location: int, x: float, y: float) -> None: ...
    def glUniform2fv(self, location: int, count: int, v: typing.Iterable[float]) -> None: ...
    def glUniform2i(self, location: int, x: int, y: int) -> None: ...
    def glUniform2iv(self, location: int, count: int, v: typing.Iterable[int]) -> None: ...
    def glUniform3f(self, location: int, x: float, y: float, z: float) -> None: ...
    def glUniform3fv(self, location: int, count: int, v: typing.Iterable[float]) -> None: ...
    def glUniform3i(self, location: int, x: int, y: int, z: int) -> None: ...
    def glUniform3iv(self, location: int, count: int, v: typing.Iterable[int]) -> None: ...
    def glUniform4f(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    def glUniform4fv(self, location: int, count: int, v: typing.Iterable[float]) -> None: ...
    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int) -> None: ...
    def glUniform4iv(self, location: int, count: int, v: typing.Iterable[int]) -> None: ...
    def glUniformMatrix2fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix3fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUniformMatrix4fv(self, location: int, count: int, transpose: int, value: typing.Iterable[float]) -> None: ...
    def glUseProgram(self, program: int) -> None: ...
    def glValidateProgram(self, program: int) -> None: ...
    def glVertexAttrib1f(self, indx: int, x: float) -> None: ...
    def glVertexAttrib1fv(self, indx: int, values: typing.Iterable[float]) -> None: ...
    def glVertexAttrib2f(self, indx: int, x: float, y: float) -> None: ...
    def glVertexAttrib2fv(self, indx: int, values: typing.Iterable[float]) -> None: ...
    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float) -> None: ...
    def glVertexAttrib3fv(self, indx: int, values: typing.Iterable[float]) -> None: ...
    def glVertexAttrib4f(self, indx: int, x: float, y: float, z: float, w: float) -> None: ...
    def glVertexAttrib4fv(self, indx: int, values: typing.Iterable[float]) -> None: ...
    def glVertexAttribPointer(self, indx: int, size: int, type: int, normalized: int, stride: int, ptr: int) -> None: ...
    def glViewport(self, x: int, y: int, width: int, height: int) -> None: ...
    def hasOpenGLFeature(self, feature: QOpenGLFunctions.OpenGLFeature) -> bool: ...
    def initializeOpenGLFunctions(self) -> None: ...
    def openGLFeatures(self) -> typing.Union[QOpenGLFunctions.OpenGLFeatures,QOpenGLFunctions.OpenGLFeature]: ...

class QOpenGLPixelTransferOptions(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QOpenGLPixelTransferOptions) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alignment(self) -> int: ...
    def imageHeight(self) -> int: ...
    def isLeastSignificantBitFirst(self) -> bool: ...
    def isSwapBytesEnabled(self) -> bool: ...
    def rowLength(self) -> int: ...
    def setAlignment(self, alignment: int) -> None: ...
    def setImageHeight(self, imageHeight: int) -> None: ...
    def setLeastSignificantByteFirst(self, lsbFirst: bool) -> None: ...
    def setRowLength(self, rowLength: int) -> None: ...
    def setSkipImages(self, skipImages: int) -> None: ...
    def setSkipPixels(self, skipPixels: int) -> None: ...
    def setSkipRows(self, skipRows: int) -> None: ...
    def setSwapBytesEnabled(self, swapBytes: bool) -> None: ...
    def skipImages(self) -> int: ...
    def skipPixels(self) -> int: ...
    def skipRows(self) -> int: ...
    def swap(self, other: QOpenGLPixelTransferOptions) -> None: ...
    def __copy__(self) -> None: ...

class QOpenGLShader(PySide2.QtCore.QObject):
    class ShaderType:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLShader.ShaderType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...

    class ShaderTypeBit:
        Compute: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        Fragment: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        Geometry: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        TessellationControl: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        TessellationEvaluation: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        Vertex: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLShader.ShaderType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLShader.ShaderType: ...
    Compute: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    Fragment: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    Geometry: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    TessellationControl: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    TessellationEvaluation: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    Vertex: typing.ClassVar[QOpenGLShader.ShaderTypeBit] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def compileSourceCode(self, source: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def compileSourceCode(self, source: str) -> bool: ...
    @overload
    def compileSourceCode(self, source: bytes) -> bool: ...
    def compileSourceFile(self, fileName: str) -> bool: ...
    @classmethod
    def hasOpenGLShaders(cls, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], context: typing.Union[QOpenGLContext,None] = ...) -> bool: ...
    def isCompiled(self) -> bool: ...
    def log(self) -> str: ...
    def shaderId(self) -> int: ...
    def shaderType(self) -> typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit]: ...
    def sourceCode(self) -> PySide2.QtCore.QByteArray: ...

class QOpenGLShaderProgram(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def addCacheableShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def addCacheableShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: str) -> bool: ...
    @overload
    def addCacheableShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: bytes) -> bool: ...
    def addCacheableShaderFromSourceFile(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], fileName: str) -> bool: ...
    def addShader(self, shader: QOpenGLShader) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: str) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], source: bytes) -> bool: ...
    def addShaderFromSourceFile(self, type: typing.Union[QOpenGLShader.ShaderType,QOpenGLShader.ShaderTypeBit], fileName: str) -> bool: ...
    @overload
    def attributeLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    @overload
    def attributeLocation(self, name: str) -> int: ...
    @overload
    def attributeLocation(self, name: bytes) -> int: ...
    def bind(self) -> bool: ...
    @overload
    def bindAttributeLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes], location: int) -> None: ...
    @overload
    def bindAttributeLocation(self, name: str, location: int) -> None: ...
    @overload
    def bindAttributeLocation(self, name: bytes, location: int) -> None: ...
    def create(self) -> bool: ...
    def defaultInnerTessellationLevels(self) -> typing.List[float]: ...
    def defaultOuterTessellationLevels(self) -> typing.List[float]: ...
    @overload
    def disableAttributeArray(self, location: int) -> None: ...
    @overload
    def disableAttributeArray(self, name: bytes) -> None: ...
    @overload
    def enableAttributeArray(self, location: int) -> None: ...
    @overload
    def enableAttributeArray(self, name: bytes) -> None: ...
    @classmethod
    def hasOpenGLShaderPrograms(cls, context: typing.Union[QOpenGLContext,None] = ...) -> bool: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def log(self) -> str: ...
    def maxGeometryOutputVertices(self) -> int: ...
    def patchVertexCount(self) -> int: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def removeAllShaders(self) -> None: ...
    def removeShader(self, shader: QOpenGLShader) -> None: ...
    @overload
    def setAttributeArray(self, location: int, type: int, values: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray(self, name: bytes, type: int, values: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray(self, location: int, values: typing.Iterable[float], tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray(self, name: bytes, values: typing.Iterable[float], tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeBuffer(self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeBuffer(self, name: bytes, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, values: typing.Iterable[float], columns: int, rows: int) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, values: typing.Iterable[float], columns: int, rows: int) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector4D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: QVector4D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: float) -> None: ...
    def setDefaultInnerTessellationLevels(self, levels: typing.List[float]) -> None: ...
    def setDefaultOuterTessellationLevels(self, levels: typing.List[float]) -> None: ...
    def setPatchVertexCount(self, count: int) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QTransform) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector2D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector3D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector4D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: typing.Tuple[typing.Tuple[float,float],typing.Tuple[float,float]]) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: typing.Tuple[typing.Tuple[float,float,float],typing.Tuple[float,float,float],typing.Tuple[float,float,float]]) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: typing.Tuple[typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float]]) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: int) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, size: PySide2.QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, size: PySide2.QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QTransform) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QVector2D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QVector3D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: QVector4D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: typing.Tuple[typing.Tuple[float,float],typing.Tuple[float,float]]) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: typing.Tuple[typing.Tuple[float,float,float],typing.Tuple[float,float,float],typing.Tuple[float,float,float]]) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: typing.Tuple[typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float],typing.Tuple[float,float,float,float]]) -> None: ...
    @overload
    def setUniformValue1f(self, arg__1: bytes, arg__2: float) -> None: ...
    @overload
    def setUniformValue1f(self, arg__1: int, arg__2: float) -> None: ...
    @overload
    def setUniformValue1i(self, arg__1: bytes, arg__2: int) -> None: ...
    @overload
    def setUniformValue1i(self, arg__1: int, arg__2: int) -> None: ...
    @overload
    def setUniformValueArray(self, location: int, values: typing.Iterable[float], count: int, tupleSize: int) -> None: ...
    @overload
    def setUniformValueArray(self, name: bytes, values: typing.Iterable[float], count: int, tupleSize: int) -> None: ...
    @overload
    def setUniformValueArray(self, location: int, values: typing.Iterable[int], count: int) -> None: ...
    @overload
    def setUniformValueArray(self, name: bytes, values: typing.Iterable[int], count: int) -> None: ...
    def shaders(self) -> typing.List[QOpenGLShader]: ...
    @overload
    def uniformLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    @overload
    def uniformLocation(self, name: str) -> int: ...
    @overload
    def uniformLocation(self, name: bytes) -> int: ...

class QOpenGLTexture(shiboken2.Object):
    class BindingTarget:
        BindingTarget1D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget1DArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget2D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget2DArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget2DMultisample: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget2DMultisampleArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTarget3D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTargetBuffer: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTargetCubeMap: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTargetCubeMapArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        BindingTargetRectangle: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.BindingTarget: ...

    class ComparisonFunction:
        CommpareNotEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareAlways: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareGreater: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareGreaterEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareLess: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareLessEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        CompareNever: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonFunction: ...

    class ComparisonMode:
        CompareNone: typing.ClassVar[QOpenGLTexture.ComparisonMode] = ...
        CompareRefToTexture: typing.ClassVar[QOpenGLTexture.ComparisonMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.ComparisonMode: ...

    class CoordinateDirection:
        DirectionR: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
        DirectionS: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
        DirectionT: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.CoordinateDirection: ...

    class CubeMapFace:
        CubeMapNegativeX: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        CubeMapNegativeY: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        CubeMapNegativeZ: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        CubeMapPositiveX: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        CubeMapPositiveY: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        CubeMapPositiveZ: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.CubeMapFace: ...

    class DepthStencilMode:
        DepthMode: typing.ClassVar[QOpenGLTexture.DepthStencilMode] = ...
        StencilMode: typing.ClassVar[QOpenGLTexture.DepthStencilMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.DepthStencilMode: ...

    class Feature:
        AnisotropicFiltering: typing.ClassVar[QOpenGLTexture.Feature] = ...
        ImmutableMultisampleStorage: typing.ClassVar[QOpenGLTexture.Feature] = ...
        ImmutableStorage: typing.ClassVar[QOpenGLTexture.Feature] = ...
        MaxFeatureFlag: typing.ClassVar[QOpenGLTexture.Feature] = ...
        NPOTTextureRepeat: typing.ClassVar[QOpenGLTexture.Feature] = ...
        NPOTTextures: typing.ClassVar[QOpenGLTexture.Feature] = ...
        StencilTexturing: typing.ClassVar[QOpenGLTexture.Feature] = ...
        Swizzle: typing.ClassVar[QOpenGLTexture.Feature] = ...
        Texture1D: typing.ClassVar[QOpenGLTexture.Feature] = ...
        Texture3D: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureArrays: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureBuffer: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureComparisonOperators: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureCubeMapArrays: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureMipMapLevel: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureMultisample: typing.ClassVar[QOpenGLTexture.Feature] = ...
        TextureRectangle: typing.ClassVar[QOpenGLTexture.Feature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLTexture.Features: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...

    class Features:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QOpenGLTexture.Features: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Features: ...

    class Filter:
        Linear: typing.ClassVar[QOpenGLTexture.Filter] = ...
        LinearMipMapLinear: typing.ClassVar[QOpenGLTexture.Filter] = ...
        LinearMipMapNearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
        Nearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
        NearestMipMapLinear: typing.ClassVar[QOpenGLTexture.Filter] = ...
        NearestMipMapNearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Filter: ...

    class MipMapGeneration:
        DontGenerateMipMaps: typing.ClassVar[QOpenGLTexture.MipMapGeneration] = ...
        GenerateMipMaps: typing.ClassVar[QOpenGLTexture.MipMapGeneration] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.MipMapGeneration: ...

    class PixelFormat:
        Alpha: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        BGR: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        BGRA: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        BGRA_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        BGR_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        Depth: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        DepthStencil: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        Luminance: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        LuminanceAlpha: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        NoSourceFormat: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RG: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RGB: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RGBA: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RGBA_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RGB_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        RG_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        Red: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        Red_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        Stencil: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelFormat: ...

    class PixelType:
        Float16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Float16OES: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Float32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Float32_D32_UInt32_S8_X24: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Int16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Int32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        Int8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        NoPixelType: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_R5G6B5: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_R5G6B5_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_RGB5A1: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_RGB5A1_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_RGBA4: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt16_RGBA4_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_D24S8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RG11B10F: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RGB10A2: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RGB10A2_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RGB9_E5: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RGBA8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt32_RGBA8_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt8_RG3B2: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        UInt8_RG3B2_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.PixelType: ...

    class SwizzleComponent:
        SwizzleAlpha: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
        SwizzleBlue: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
        SwizzleGreen: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
        SwizzleRed: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleComponent: ...

    class SwizzleValue:
        AlphaValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        BlueValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        GreenValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        OneValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        RedValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        ZeroValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.SwizzleValue: ...

    class Target:
        Target1D: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target1DArray: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target2D: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target2DArray: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target2DMultisample: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target2DMultisampleArray: typing.ClassVar[QOpenGLTexture.Target] = ...
        Target3D: typing.ClassVar[QOpenGLTexture.Target] = ...
        TargetBuffer: typing.ClassVar[QOpenGLTexture.Target] = ...
        TargetCubeMap: typing.ClassVar[QOpenGLTexture.Target] = ...
        TargetCubeMapArray: typing.ClassVar[QOpenGLTexture.Target] = ...
        TargetRectangle: typing.ClassVar[QOpenGLTexture.Target] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.Target: ...

    class TextureFormat:
        AlphaFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D16: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D24: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D24S8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D32: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        D32FS8X24: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        DepthFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        LuminanceAlphaFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        LuminanceFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        NoFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R11_EAC_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R11_EAC_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R5G6B5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG11B10F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG11_EAC_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG11_EAC_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG3B2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB10A2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB5A1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8_ETC1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB9E5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA8_ETC2_EAC: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBAFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_10x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_10x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_10x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_10x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_12x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_12x12: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_4x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_5x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_5x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_6x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_6x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_8x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_8x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_ASTC_8x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_DXT3: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBA_DXT5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGBFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB_BP_SIGNED_FLOAT: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB_BP_UNSIGNED_FLOAT: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB_BP_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RGB_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG_ATI2N_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        RG_ATI2N_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R_ATI1N_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        R_ATI1N_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        S8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_10x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_10x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_10x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_10x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_12x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_12x12: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_4x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_5x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_5x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_6x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_6x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_8x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_8x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ASTC_8x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_Alpha8_ETC2_EAC: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB_Alpha_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB_Alpha_DXT3: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB_Alpha_DXT5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB_BP_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        SRGB_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormat: ...

    class TextureFormatClass:
        FormatClass_128Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_16Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_24Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_32Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_48Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_64Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_8Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_96Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_BPTC_Float: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_BPTC_Unorm: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_RGTC1_R: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_RGTC2_RG: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_S3TC_DXT1_RGB: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_S3TC_DXT1_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_S3TC_DXT3_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_S3TC_DXT5_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        FormatClass_Unique: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        NoFormatClass: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureFormatClass: ...

    class TextureUnitReset:
        DontResetTextureUnit: typing.ClassVar[QOpenGLTexture.TextureUnitReset] = ...
        ResetTextureUnit: typing.ClassVar[QOpenGLTexture.TextureUnitReset] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.TextureUnitReset: ...

    class WrapMode:
        ClampToBorder: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
        ClampToEdge: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
        MirroredRepeat: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
        Repeat: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTexture.WrapMode: ...
    Alpha: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    AlphaFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    AlphaValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    AnisotropicFiltering: typing.ClassVar[QOpenGLTexture.Feature] = ...
    BGR: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    BGRA: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    BGRA_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    BGR_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    BindingTarget1D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget1DArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget2D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget2DArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget2DMultisample: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget2DMultisampleArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTarget3D: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTargetBuffer: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTargetCubeMap: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTargetCubeMapArray: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BindingTargetRectangle: typing.ClassVar[QOpenGLTexture.BindingTarget] = ...
    BlueValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    ClampToBorder: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
    ClampToEdge: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
    CommpareNotEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareAlways: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareGreater: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareGreaterEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareLess: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareLessEqual: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareNever: typing.ClassVar[QOpenGLTexture.ComparisonFunction] = ...
    CompareNone: typing.ClassVar[QOpenGLTexture.ComparisonMode] = ...
    CompareRefToTexture: typing.ClassVar[QOpenGLTexture.ComparisonMode] = ...
    CubeMapNegativeX: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    CubeMapNegativeY: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    CubeMapNegativeZ: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    CubeMapPositiveX: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    CubeMapPositiveY: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    CubeMapPositiveZ: typing.ClassVar[QOpenGLTexture.CubeMapFace] = ...
    D16: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    D24: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    D24S8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    D32: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    D32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    D32FS8X24: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    Depth: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    DepthFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    DepthMode: typing.ClassVar[QOpenGLTexture.DepthStencilMode] = ...
    DepthStencil: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    DirectionR: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
    DirectionS: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
    DirectionT: typing.ClassVar[QOpenGLTexture.CoordinateDirection] = ...
    DontGenerateMipMaps: typing.ClassVar[QOpenGLTexture.MipMapGeneration] = ...
    DontResetTextureUnit: typing.ClassVar[QOpenGLTexture.TextureUnitReset] = ...
    Float16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Float16OES: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Float32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Float32_D32_UInt32_S8_X24: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    FormatClass_128Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_16Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_24Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_32Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_48Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_64Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_8Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_96Bit: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_BPTC_Float: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_BPTC_Unorm: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_RGTC1_R: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_RGTC2_RG: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_S3TC_DXT1_RGB: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_S3TC_DXT1_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_S3TC_DXT3_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_S3TC_DXT5_RGBA: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    FormatClass_Unique: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    GenerateMipMaps: typing.ClassVar[QOpenGLTexture.MipMapGeneration] = ...
    GreenValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    ImmutableMultisampleStorage: typing.ClassVar[QOpenGLTexture.Feature] = ...
    ImmutableStorage: typing.ClassVar[QOpenGLTexture.Feature] = ...
    Int16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Int32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Int8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    Linear: typing.ClassVar[QOpenGLTexture.Filter] = ...
    LinearMipMapLinear: typing.ClassVar[QOpenGLTexture.Filter] = ...
    LinearMipMapNearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
    Luminance: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    LuminanceAlpha: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    LuminanceAlphaFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    LuminanceFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    MaxFeatureFlag: typing.ClassVar[QOpenGLTexture.Feature] = ...
    MirroredRepeat: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
    NPOTTextureRepeat: typing.ClassVar[QOpenGLTexture.Feature] = ...
    NPOTTextures: typing.ClassVar[QOpenGLTexture.Feature] = ...
    Nearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
    NearestMipMapLinear: typing.ClassVar[QOpenGLTexture.Filter] = ...
    NearestMipMapNearest: typing.ClassVar[QOpenGLTexture.Filter] = ...
    NoFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    NoFormatClass: typing.ClassVar[QOpenGLTexture.TextureFormatClass] = ...
    NoPixelType: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    NoSourceFormat: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    OneValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    R11_EAC_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R11_EAC_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R5G6B5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RG11B10F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG11_EAC_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG11_EAC_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG3B2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RGB10A2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB5A1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8_ETC1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB9E5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RGBA16F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA16I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA16U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA16_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA16_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA32F: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA32I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA32U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA8I: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA8U: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA8_ETC2_EAC: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA8_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA8_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBAFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_10x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_10x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_10x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_10x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_12x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_12x12: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_4x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_5x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_5x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_6x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_6x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_8x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_8x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_ASTC_8x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_DXT3: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_DXT5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGBA_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RGBFormat: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB_BP_SIGNED_FLOAT: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB_BP_UNSIGNED_FLOAT: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB_BP_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RGB_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RG_ATI2N_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG_ATI2N_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    RG_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    R_ATI1N_SNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    R_ATI1N_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    Red: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    RedValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    Red_Integer: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    Repeat: typing.ClassVar[QOpenGLTexture.WrapMode] = ...
    ResetTextureUnit: typing.ClassVar[QOpenGLTexture.TextureUnitReset] = ...
    S8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_10x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_10x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_10x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_10x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_12x10: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_12x12: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_4x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_5x4: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_5x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_6x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_6x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_8x5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_8x6: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ASTC_8x8: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_Alpha8_ETC2_EAC: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB8_PunchThrough_Alpha1_ETC2: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB_Alpha_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB_Alpha_DXT3: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB_Alpha_DXT5: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB_BP_UNorm: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    SRGB_DXT1: typing.ClassVar[QOpenGLTexture.TextureFormat] = ...
    Stencil: typing.ClassVar[QOpenGLTexture.PixelFormat] = ...
    StencilMode: typing.ClassVar[QOpenGLTexture.DepthStencilMode] = ...
    StencilTexturing: typing.ClassVar[QOpenGLTexture.Feature] = ...
    Swizzle: typing.ClassVar[QOpenGLTexture.Feature] = ...
    SwizzleAlpha: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
    SwizzleBlue: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
    SwizzleGreen: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
    SwizzleRed: typing.ClassVar[QOpenGLTexture.SwizzleComponent] = ...
    Target1D: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target1DArray: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target2D: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target2DArray: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target2DMultisample: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target2DMultisampleArray: typing.ClassVar[QOpenGLTexture.Target] = ...
    Target3D: typing.ClassVar[QOpenGLTexture.Target] = ...
    TargetBuffer: typing.ClassVar[QOpenGLTexture.Target] = ...
    TargetCubeMap: typing.ClassVar[QOpenGLTexture.Target] = ...
    TargetCubeMapArray: typing.ClassVar[QOpenGLTexture.Target] = ...
    TargetRectangle: typing.ClassVar[QOpenGLTexture.Target] = ...
    Texture1D: typing.ClassVar[QOpenGLTexture.Feature] = ...
    Texture3D: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureArrays: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureBuffer: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureComparisonOperators: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureCubeMapArrays: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureMipMapLevel: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureMultisample: typing.ClassVar[QOpenGLTexture.Feature] = ...
    TextureRectangle: typing.ClassVar[QOpenGLTexture.Feature] = ...
    UInt16: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_R5G6B5: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_R5G6B5_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_RGB5A1: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_RGB5A1_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_RGBA4: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt16_RGBA4_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_D24S8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RG11B10F: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RGB10A2: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RGB10A2_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RGB9_E5: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RGBA8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt32_RGBA8_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt8: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt8_RG3B2: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    UInt8_RG3B2_Rev: typing.ClassVar[QOpenGLTexture.PixelType] = ...
    ZeroValue: typing.ClassVar[QOpenGLTexture.SwizzleValue] = ...
    @overload
    def __init__(self, image: QImage, genMipMaps: QOpenGLTexture.MipMapGeneration = ...) -> None: ...
    @overload
    def __init__(self, target: QOpenGLTexture.Target) -> None: ...
    @overload
    def allocateStorage(self, pixelFormat: QOpenGLTexture.PixelFormat, pixelType: QOpenGLTexture.PixelType) -> None: ...
    @overload
    def allocateStorage(self) -> None: ...
    @overload
    def bind(self, unit: int, reset: QOpenGLTexture.TextureUnitReset = ...) -> None: ...
    @overload
    def bind(self) -> None: ...
    def borderColor(self) -> QColor: ...
    @overload
    @classmethod
    def boundTextureId(cls, unit: int, target: QOpenGLTexture.BindingTarget) -> int: ...
    @overload
    @classmethod
    def boundTextureId(cls, target: QOpenGLTexture.BindingTarget) -> int: ...
    def comparisonFunction(self) -> QOpenGLTexture.ComparisonFunction: ...
    def comparisonMode(self) -> QOpenGLTexture.ComparisonMode: ...
    def create(self) -> bool: ...
    def createTextureView(self, target: QOpenGLTexture.Target, viewFormat: QOpenGLTexture.TextureFormat, minimumMipmapLevel: int, maximumMipmapLevel: int, minimumLayer: int, maximumLayer: int) -> QOpenGLTexture: ...
    def depth(self) -> int: ...
    def depthStencilMode(self) -> QOpenGLTexture.DepthStencilMode: ...
    def destroy(self) -> None: ...
    def faces(self) -> int: ...
    def format(self) -> QOpenGLTexture.TextureFormat: ...
    @overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...) -> None: ...
    @overload
    def generateMipMaps(self) -> None: ...
    @classmethod
    def hasFeature(cls, feature: QOpenGLTexture.Feature) -> bool: ...
    def height(self) -> int: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    @overload
    def isBound(self, unit: int) -> bool: ...
    @overload
    def isBound(self) -> bool: ...
    def isCreated(self) -> bool: ...
    def isFixedSamplePositions(self) -> bool: ...
    def isStorageAllocated(self) -> bool: ...
    def isTextureView(self) -> bool: ...
    def layers(self) -> int: ...
    def levelOfDetailRange(self) -> typing.Tuple[float,float]: ...
    def levelofDetailBias(self) -> float: ...
    def magnificationFilter(self) -> QOpenGLTexture.Filter: ...
    def maximumAnisotropy(self) -> float: ...
    def maximumLevelOfDetail(self) -> float: ...
    def maximumMipLevels(self) -> int: ...
    def minMagFilters(self) -> typing.Tuple[QOpenGLTexture.Filter,QOpenGLTexture.Filter]: ...
    def minificationFilter(self) -> QOpenGLTexture.Filter: ...
    def minimumLevelOfDetail(self) -> float: ...
    def mipBaseLevel(self) -> int: ...
    def mipLevelRange(self) -> typing.Tuple[int,int]: ...
    def mipLevels(self) -> int: ...
    def mipMaxLevel(self) -> int: ...
    @overload
    def release(self, unit: int, reset: QOpenGLTexture.TextureUnitReset = ...) -> None: ...
    @overload
    def release(self) -> None: ...
    def samples(self) -> int: ...
    def setAutoMipMapGenerationEnabled(self, enabled: bool) -> None: ...
    @overload
    def setBorderColor(self, r: float, g: float, b: float, a: float) -> None: ...
    @overload
    def setBorderColor(self, r: int, g: int, b: int, a: int) -> None: ...
    @overload
    def setBorderColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setComparisonFunction(self, function: QOpenGLTexture.ComparisonFunction) -> None: ...
    def setComparisonMode(self, mode: QOpenGLTexture.ComparisonMode) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: QOpenGLTexture.CubeMapFace, dataSize: int, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, cubeFace: QOpenGLTexture.CubeMapFace, dataSize: int, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, dataSize: int, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, dataSize: int, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setCompressedData(self, dataSize: int, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, cubeFace: QOpenGLTexture.CubeMapFace, layerCount: int, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, cubeFace: QOpenGLTexture.CubeMapFace, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: QOpenGLTexture.CubeMapFace, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, cubeFace: QOpenGLTexture.CubeMapFace, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, sourceFormat: QOpenGLTexture.PixelFormat, sourceType: QOpenGLTexture.PixelType, data: int, options: typing.Union[QOpenGLPixelTransferOptions,None] = ...) -> None: ...
    @overload
    def setData(self, image: QImage, genMipMaps: QOpenGLTexture.MipMapGeneration = ...) -> None: ...
    def setDepthStencilMode(self, mode: QOpenGLTexture.DepthStencilMode) -> None: ...
    def setFixedSamplePositions(self, fixed: bool) -> None: ...
    def setFormat(self, format: QOpenGLTexture.TextureFormat) -> None: ...
    def setLayers(self, layers: int) -> None: ...
    def setLevelOfDetailRange(self, min: float, max: float) -> None: ...
    def setLevelofDetailBias(self, bias: float) -> None: ...
    def setMagnificationFilter(self, filter: QOpenGLTexture.Filter) -> None: ...
    def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
    def setMaximumLevelOfDetail(self, value: float) -> None: ...
    def setMinMagFilters(self, minificationFilter: QOpenGLTexture.Filter, magnificationFilter: QOpenGLTexture.Filter) -> None: ...
    def setMinificationFilter(self, filter: QOpenGLTexture.Filter) -> None: ...
    def setMinimumLevelOfDetail(self, value: float) -> None: ...
    def setMipBaseLevel(self, baseLevel: int) -> None: ...
    def setMipLevelRange(self, baseLevel: int, maxLevel: int) -> None: ...
    def setMipLevels(self, levels: int) -> None: ...
    def setMipMaxLevel(self, maxLevel: int) -> None: ...
    def setSamples(self, samples: int) -> None: ...
    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
    @overload
    def setSwizzleMask(self, r: QOpenGLTexture.SwizzleValue, g: QOpenGLTexture.SwizzleValue, b: QOpenGLTexture.SwizzleValue, a: QOpenGLTexture.SwizzleValue) -> None: ...
    @overload
    def setSwizzleMask(self, component: QOpenGLTexture.SwizzleComponent, value: QOpenGLTexture.SwizzleValue) -> None: ...
    @overload
    def setWrapMode(self, direction: QOpenGLTexture.CoordinateDirection, mode: QOpenGLTexture.WrapMode) -> None: ...
    @overload
    def setWrapMode(self, mode: QOpenGLTexture.WrapMode) -> None: ...
    def swizzleMask(self, component: QOpenGLTexture.SwizzleComponent) -> QOpenGLTexture.SwizzleValue: ...
    def target(self) -> QOpenGLTexture.Target: ...
    def textureId(self) -> int: ...
    def width(self) -> int: ...
    def wrapMode(self, direction: QOpenGLTexture.CoordinateDirection) -> QOpenGLTexture.WrapMode: ...

class QOpenGLTextureBlitter(shiboken2.Object):
    class Origin:
        OriginBottomLeft: typing.ClassVar[QOpenGLTextureBlitter.Origin] = ...
        OriginTopLeft: typing.ClassVar[QOpenGLTextureBlitter.Origin] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLTextureBlitter.Origin: ...
    OriginBottomLeft: typing.ClassVar[QOpenGLTextureBlitter.Origin] = ...
    OriginTopLeft: typing.ClassVar[QOpenGLTextureBlitter.Origin] = ...
    def __init__(self) -> None: ...
    def bind(self, target: int = ...) -> None: ...
    @overload
    def blit(self, texture: int, targetTransform: QMatrix4x4, sourceOrigin: QOpenGLTextureBlitter.Origin) -> None: ...
    @overload
    def blit(self, texture: int, targetTransform: QMatrix4x4, sourceTransform: QMatrix3x3) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def release(self) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setRedBlueSwizzle(self, swizzle: bool) -> None: ...
    @classmethod
    def sourceTransform(cls, subTexture: PySide2.QtCore.QRectF, textureSize: PySide2.QtCore.QSize, origin: QOpenGLTextureBlitter.Origin) -> QMatrix3x3: ...
    def supportsExternalOESTarget(self) -> bool: ...
    @classmethod
    def targetTransform(cls, target: PySide2.QtCore.QRectF, viewport: PySide2.QtCore.QRect) -> QMatrix4x4: ...

class QOpenGLTimeMonitor(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectIds(self) -> typing.List[int]: ...
    def recordSample(self) -> int: ...
    def reset(self) -> None: ...
    def sampleCount(self) -> int: ...
    def setSampleCount(self, sampleCount: int) -> None: ...
    def waitForIntervals(self) -> typing.List[int]: ...
    def waitForSamples(self) -> typing.List[int]: ...

class QOpenGLTimerQuery(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def begin(self) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def end(self) -> None: ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectId(self) -> int: ...
    def recordTimestamp(self) -> None: ...
    def waitForResult(self) -> int: ...
    def waitForTimestamp(self) -> int: ...

class QOpenGLVersionProfile(shiboken2.Object):
    @overload
    def __init__(self, format: QSurfaceFormat) -> None: ...
    @overload
    def __init__(self, other: QOpenGLVersionProfile) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def hasProfiles(self) -> bool: ...
    def isLegacyVersion(self) -> bool: ...
    def isValid(self) -> bool: ...
    def profile(self) -> QSurfaceFormat.OpenGLContextProfile: ...
    def setProfile(self, profile: QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setVersion(self, majorVersion: int, minorVersion: int) -> None: ...
    def version(self) -> typing.Tuple[int,int]: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QOpenGLVertexArrayObject(PySide2.QtCore.QObject):
    class Binder(shiboken2.Object):
        def __init__(self, v: QOpenGLVertexArrayObject) -> None: ...
        def rebind(self) -> None: ...
        def release(self) -> None: ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def bind(self) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def objectId(self) -> int: ...
    def release(self) -> None: ...

class QOpenGLWindow(QPaintDeviceWindow):
    class UpdateBehavior:
        NoPartialUpdate: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
        PartialUpdateBlend: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
        PartialUpdateBlit: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> QOpenGLWindow.UpdateBehavior: ...
    NoPartialUpdate: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
    PartialUpdateBlend: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
    PartialUpdateBlit: typing.ClassVar[QOpenGLWindow.UpdateBehavior] = ...
    frameSwapped: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, shareContext: QOpenGLContext, updateBehavior: QOpenGLWindow.UpdateBehavior = ..., parent: typing.Union[QWindow,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QOpenGLWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, updateBehavior: QOpenGLWindow.UpdateBehavior = ..., parent: typing.Union[QWindow,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., focusObjectChanged: typing.Callable = ..., frameSwapped: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QOpenGLWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    def context(self) -> QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def grabFramebuffer(self) -> QImage: ...
    def initializeGL(self) -> None: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def paintOverGL(self) -> None: ...
    def paintUnderGL(self) -> None: ...
    def redirected(self, arg__1: PySide2.QtCore.QPoint) -> QPaintDevice: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def shareContext(self) -> QOpenGLContext: ...
    def updateBehavior(self) -> QOpenGLWindow.UpdateBehavior: ...

class QPageLayout(shiboken2.Object):
    class Mode:
        FullPageMode: typing.ClassVar[QPageLayout.Mode] = ...
        StandardMode: typing.ClassVar[QPageLayout.Mode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __and__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageLayout.Mode: ...

    class Orientation:
        Landscape: typing.ClassVar[QPageLayout.Orientation] = ...
        Portrait: typing.ClassVar[QPageLayout.Orientation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __and__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageLayout.Orientation: ...

    class Unit:
        Cicero: typing.ClassVar[QPageLayout.Unit] = ...
        Didot: typing.ClassVar[QPageLayout.Unit] = ...
        Inch: typing.ClassVar[QPageLayout.Unit] = ...
        Millimeter: typing.ClassVar[QPageLayout.Unit] = ...
        Pica: typing.ClassVar[QPageLayout.Unit] = ...
        Point: typing.ClassVar[QPageLayout.Unit] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __and__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageLayout.Unit: ...
    Cicero: typing.ClassVar[QPageLayout.Unit] = ...
    Didot: typing.ClassVar[QPageLayout.Unit] = ...
    FullPageMode: typing.ClassVar[QPageLayout.Mode] = ...
    Inch: typing.ClassVar[QPageLayout.Unit] = ...
    Landscape: typing.ClassVar[QPageLayout.Orientation] = ...
    Millimeter: typing.ClassVar[QPageLayout.Unit] = ...
    Pica: typing.ClassVar[QPageLayout.Unit] = ...
    Point: typing.ClassVar[QPageLayout.Unit] = ...
    Portrait: typing.ClassVar[QPageLayout.Orientation] = ...
    StandardMode: typing.ClassVar[QPageLayout.Mode] = ...
    @overload
    def __init__(self, pageSize: QPageSize, orientation: QPageLayout.Orientation, margins: PySide2.QtCore.QMarginsF, units: QPageLayout.Unit = ..., minMargins: PySide2.QtCore.QMarginsF = ...) -> None: ...
    @overload
    def __init__(self, other: QPageLayout) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def fullRect(self, units: QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    @overload
    def fullRect(self) -> PySide2.QtCore.QRectF: ...
    def fullRectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def fullRectPoints(self) -> PySide2.QtCore.QRect: ...
    def isEquivalentTo(self, other: QPageLayout) -> bool: ...
    def isValid(self) -> bool: ...
    @overload
    def margins(self, units: QPageLayout.Unit) -> PySide2.QtCore.QMarginsF: ...
    @overload
    def margins(self) -> PySide2.QtCore.QMarginsF: ...
    def marginsPixels(self, resolution: int) -> PySide2.QtCore.QMargins: ...
    def marginsPoints(self) -> PySide2.QtCore.QMargins: ...
    def maximumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def minimumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def mode(self) -> QPageLayout.Mode: ...
    def orientation(self) -> QPageLayout.Orientation: ...
    def pageSize(self) -> QPageSize: ...
    @overload
    def paintRect(self, units: QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    @overload
    def paintRect(self) -> PySide2.QtCore.QRectF: ...
    def paintRectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def paintRectPoints(self) -> PySide2.QtCore.QRect: ...
    def setBottomMargin(self, bottomMargin: float) -> bool: ...
    def setLeftMargin(self, leftMargin: float) -> bool: ...
    def setMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    def setMinimumMargins(self, minMargins: PySide2.QtCore.QMarginsF) -> None: ...
    def setMode(self, mode: QPageLayout.Mode) -> None: ...
    def setOrientation(self, orientation: QPageLayout.Orientation) -> None: ...
    def setPageSize(self, pageSize: QPageSize, minMargins: PySide2.QtCore.QMarginsF = ...) -> None: ...
    def setRightMargin(self, rightMargin: float) -> bool: ...
    def setTopMargin(self, topMargin: float) -> bool: ...
    def setUnits(self, units: QPageLayout.Unit) -> None: ...
    def swap(self, other: QPageLayout) -> None: ...
    def units(self) -> QPageLayout.Unit: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPageSize(shiboken2.Object):
    class PageSizeId:
        A0: typing.ClassVar[QPageSize.PageSizeId] = ...
        A1: typing.ClassVar[QPageSize.PageSizeId] = ...
        A10: typing.ClassVar[QPageSize.PageSizeId] = ...
        A2: typing.ClassVar[QPageSize.PageSizeId] = ...
        A3: typing.ClassVar[QPageSize.PageSizeId] = ...
        A3Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
        A4: typing.ClassVar[QPageSize.PageSizeId] = ...
        A4Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
        A4Plus: typing.ClassVar[QPageSize.PageSizeId] = ...
        A4Small: typing.ClassVar[QPageSize.PageSizeId] = ...
        A5: typing.ClassVar[QPageSize.PageSizeId] = ...
        A5Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
        A6: typing.ClassVar[QPageSize.PageSizeId] = ...
        A7: typing.ClassVar[QPageSize.PageSizeId] = ...
        A8: typing.ClassVar[QPageSize.PageSizeId] = ...
        A9: typing.ClassVar[QPageSize.PageSizeId] = ...
        AnsiA: typing.ClassVar[QPageSize.PageSizeId] = ...
        AnsiB: typing.ClassVar[QPageSize.PageSizeId] = ...
        AnsiC: typing.ClassVar[QPageSize.PageSizeId] = ...
        AnsiD: typing.ClassVar[QPageSize.PageSizeId] = ...
        AnsiE: typing.ClassVar[QPageSize.PageSizeId] = ...
        ArchA: typing.ClassVar[QPageSize.PageSizeId] = ...
        ArchB: typing.ClassVar[QPageSize.PageSizeId] = ...
        ArchC: typing.ClassVar[QPageSize.PageSizeId] = ...
        ArchD: typing.ClassVar[QPageSize.PageSizeId] = ...
        ArchE: typing.ClassVar[QPageSize.PageSizeId] = ...
        B0: typing.ClassVar[QPageSize.PageSizeId] = ...
        B1: typing.ClassVar[QPageSize.PageSizeId] = ...
        B10: typing.ClassVar[QPageSize.PageSizeId] = ...
        B2: typing.ClassVar[QPageSize.PageSizeId] = ...
        B3: typing.ClassVar[QPageSize.PageSizeId] = ...
        B4: typing.ClassVar[QPageSize.PageSizeId] = ...
        B5: typing.ClassVar[QPageSize.PageSizeId] = ...
        B5Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
        B6: typing.ClassVar[QPageSize.PageSizeId] = ...
        B7: typing.ClassVar[QPageSize.PageSizeId] = ...
        B8: typing.ClassVar[QPageSize.PageSizeId] = ...
        B9: typing.ClassVar[QPageSize.PageSizeId] = ...
        C5E: typing.ClassVar[QPageSize.PageSizeId] = ...
        Comm10E: typing.ClassVar[QPageSize.PageSizeId] = ...
        Custom: typing.ClassVar[QPageSize.PageSizeId] = ...
        DLE: typing.ClassVar[QPageSize.PageSizeId] = ...
        DoublePostcard: typing.ClassVar[QPageSize.PageSizeId] = ...
        Envelope10: typing.ClassVar[QPageSize.PageSizeId] = ...
        Envelope11: typing.ClassVar[QPageSize.PageSizeId] = ...
        Envelope12: typing.ClassVar[QPageSize.PageSizeId] = ...
        Envelope14: typing.ClassVar[QPageSize.PageSizeId] = ...
        Envelope9: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeB4: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeB5: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeB6: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC0: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC1: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC2: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC3: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC4: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC5: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC6: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC65: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeC7: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeChou3: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeChou4: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeDL: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeInvite: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeItalian: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeKaku2: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeKaku3: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeMonarch: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePersonal: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc1: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc10: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc2: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc3: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc4: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc5: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc6: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc7: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc8: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopePrc9: typing.ClassVar[QPageSize.PageSizeId] = ...
        EnvelopeYou4: typing.ClassVar[QPageSize.PageSizeId] = ...
        Executive: typing.ClassVar[QPageSize.PageSizeId] = ...
        ExecutiveStandard: typing.ClassVar[QPageSize.PageSizeId] = ...
        FanFoldGerman: typing.ClassVar[QPageSize.PageSizeId] = ...
        FanFoldGermanLegal: typing.ClassVar[QPageSize.PageSizeId] = ...
        FanFoldUS: typing.ClassVar[QPageSize.PageSizeId] = ...
        Folio: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial10x11: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial10x13: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial10x14: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial12x11: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial15x11: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial7x9: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial8x10: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial9x11: typing.ClassVar[QPageSize.PageSizeId] = ...
        Imperial9x12: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB0: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB1: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB10: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB2: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB3: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB4: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB5: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB6: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB7: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB8: typing.ClassVar[QPageSize.PageSizeId] = ...
        JisB9: typing.ClassVar[QPageSize.PageSizeId] = ...
        LastPageSize: typing.ClassVar[QPageSize.PageSizeId] = ...
        Ledger: typing.ClassVar[QPageSize.PageSizeId] = ...
        Legal: typing.ClassVar[QPageSize.PageSizeId] = ...
        LegalExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
        Letter: typing.ClassVar[QPageSize.PageSizeId] = ...
        LetterExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
        LetterPlus: typing.ClassVar[QPageSize.PageSizeId] = ...
        LetterSmall: typing.ClassVar[QPageSize.PageSizeId] = ...
        NPageSize: typing.ClassVar[QPageSize.PageSizeId] = ...
        NPaperSize: typing.ClassVar[QPageSize.PageSizeId] = ...
        Note: typing.ClassVar[QPageSize.PageSizeId] = ...
        Postcard: typing.ClassVar[QPageSize.PageSizeId] = ...
        Prc16K: typing.ClassVar[QPageSize.PageSizeId] = ...
        Prc32K: typing.ClassVar[QPageSize.PageSizeId] = ...
        Prc32KBig: typing.ClassVar[QPageSize.PageSizeId] = ...
        Quarto: typing.ClassVar[QPageSize.PageSizeId] = ...
        Statement: typing.ClassVar[QPageSize.PageSizeId] = ...
        SuperA: typing.ClassVar[QPageSize.PageSizeId] = ...
        SuperB: typing.ClassVar[QPageSize.PageSizeId] = ...
        Tabloid: typing.ClassVar[QPageSize.PageSizeId] = ...
        TabloidExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __and__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageSize.PageSizeId: ...

    class SizeMatchPolicy:
        ExactMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
        FuzzyMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
        FuzzyOrientationMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageSize.SizeMatchPolicy: ...

    class Unit:
        Cicero: typing.ClassVar[QPageSize.Unit] = ...
        Didot: typing.ClassVar[QPageSize.Unit] = ...
        Inch: typing.ClassVar[QPageSize.Unit] = ...
        Millimeter: typing.ClassVar[QPageSize.Unit] = ...
        Pica: typing.ClassVar[QPageSize.Unit] = ...
        Point: typing.ClassVar[QPageSize.Unit] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __and__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __rand__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __ror__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __sub__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
        def __xor__(self, other: typing.SupportsInt) -> QPageSize.Unit: ...
    A0: typing.ClassVar[QPageSize.PageSizeId] = ...
    A1: typing.ClassVar[QPageSize.PageSizeId] = ...
    A10: typing.ClassVar[QPageSize.PageSizeId] = ...
    A2: typing.ClassVar[QPageSize.PageSizeId] = ...
    A3: typing.ClassVar[QPageSize.PageSizeId] = ...
    A3Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
    A4: typing.ClassVar[QPageSize.PageSizeId] = ...
    A4Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
    A4Plus: typing.ClassVar[QPageSize.PageSizeId] = ...
    A4Small: typing.ClassVar[QPageSize.PageSizeId] = ...
    A5: typing.ClassVar[QPageSize.PageSizeId] = ...
    A5Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
    A6: typing.ClassVar[QPageSize.PageSizeId] = ...
    A7: typing.ClassVar[QPageSize.PageSizeId] = ...
    A8: typing.ClassVar[QPageSize.PageSizeId] = ...
    A9: typing.ClassVar[QPageSize.PageSizeId] = ...
    AnsiA: typing.ClassVar[QPageSize.PageSizeId] = ...
    AnsiB: typing.ClassVar[QPageSize.PageSizeId] = ...
    AnsiC: typing.ClassVar[QPageSize.PageSizeId] = ...
    AnsiD: typing.ClassVar[QPageSize.PageSizeId] = ...
    AnsiE: typing.ClassVar[QPageSize.PageSizeId] = ...
    ArchA: typing.ClassVar[QPageSize.PageSizeId] = ...
    ArchB: typing.ClassVar[QPageSize.PageSizeId] = ...
    ArchC: typing.ClassVar[QPageSize.PageSizeId] = ...
    ArchD: typing.ClassVar[QPageSize.PageSizeId] = ...
    ArchE: typing.ClassVar[QPageSize.PageSizeId] = ...
    B0: typing.ClassVar[QPageSize.PageSizeId] = ...
    B1: typing.ClassVar[QPageSize.PageSizeId] = ...
    B10: typing.ClassVar[QPageSize.PageSizeId] = ...
    B2: typing.ClassVar[QPageSize.PageSizeId] = ...
    B3: typing.ClassVar[QPageSize.PageSizeId] = ...
    B4: typing.ClassVar[QPageSize.PageSizeId] = ...
    B5: typing.ClassVar[QPageSize.PageSizeId] = ...
    B5Extra: typing.ClassVar[QPageSize.PageSizeId] = ...
    B6: typing.ClassVar[QPageSize.PageSizeId] = ...
    B7: typing.ClassVar[QPageSize.PageSizeId] = ...
    B8: typing.ClassVar[QPageSize.PageSizeId] = ...
    B9: typing.ClassVar[QPageSize.PageSizeId] = ...
    C5E: typing.ClassVar[QPageSize.PageSizeId] = ...
    Cicero: typing.ClassVar[QPageSize.Unit] = ...
    Comm10E: typing.ClassVar[QPageSize.PageSizeId] = ...
    Custom: typing.ClassVar[QPageSize.PageSizeId] = ...
    DLE: typing.ClassVar[QPageSize.PageSizeId] = ...
    Didot: typing.ClassVar[QPageSize.Unit] = ...
    DoublePostcard: typing.ClassVar[QPageSize.PageSizeId] = ...
    Envelope10: typing.ClassVar[QPageSize.PageSizeId] = ...
    Envelope11: typing.ClassVar[QPageSize.PageSizeId] = ...
    Envelope12: typing.ClassVar[QPageSize.PageSizeId] = ...
    Envelope14: typing.ClassVar[QPageSize.PageSizeId] = ...
    Envelope9: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeB4: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeB5: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeB6: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC0: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC1: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC2: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC3: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC4: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC5: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC6: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC65: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeC7: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeChou3: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeChou4: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeDL: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeInvite: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeItalian: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeKaku2: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeKaku3: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeMonarch: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePersonal: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc1: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc10: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc2: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc3: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc4: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc5: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc6: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc7: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc8: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopePrc9: typing.ClassVar[QPageSize.PageSizeId] = ...
    EnvelopeYou4: typing.ClassVar[QPageSize.PageSizeId] = ...
    ExactMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
    Executive: typing.ClassVar[QPageSize.PageSizeId] = ...
    ExecutiveStandard: typing.ClassVar[QPageSize.PageSizeId] = ...
    FanFoldGerman: typing.ClassVar[QPageSize.PageSizeId] = ...
    FanFoldGermanLegal: typing.ClassVar[QPageSize.PageSizeId] = ...
    FanFoldUS: typing.ClassVar[QPageSize.PageSizeId] = ...
    Folio: typing.ClassVar[QPageSize.PageSizeId] = ...
    FuzzyMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
    FuzzyOrientationMatch: typing.ClassVar[QPageSize.SizeMatchPolicy] = ...
    Imperial10x11: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial10x13: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial10x14: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial12x11: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial15x11: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial7x9: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial8x10: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial9x11: typing.ClassVar[QPageSize.PageSizeId] = ...
    Imperial9x12: typing.ClassVar[QPageSize.PageSizeId] = ...
    Inch: typing.ClassVar[QPageSize.Unit] = ...
    JisB0: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB1: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB10: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB2: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB3: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB4: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB5: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB6: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB7: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB8: typing.ClassVar[QPageSize.PageSizeId] = ...
    JisB9: typing.ClassVar[QPageSize.PageSizeId] = ...
    LastPageSize: typing.ClassVar[QPageSize.PageSizeId] = ...
    Ledger: typing.ClassVar[QPageSize.PageSizeId] = ...
    Legal: typing.ClassVar[QPageSize.PageSizeId] = ...
    LegalExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
    Letter: typing.ClassVar[QPageSize.PageSizeId] = ...
    LetterExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
    LetterPlus: typing.ClassVar[QPageSize.PageSizeId] = ...
    LetterSmall: typing.ClassVar[QPageSize.PageSizeId] = ...
    Millimeter: typing.ClassVar[QPageSize.Unit] = ...
    NPageSize: typing.ClassVar[QPageSize.PageSizeId] = ...
    NPaperSize: typing.ClassVar[QPageSize.PageSizeId] = ...
    Note: typing.ClassVar[QPageSize.PageSizeId] = ...
    Pica: typing.ClassVar[QPageSize.Unit] = ...
    Point: typing.ClassVar[QPageSize.Unit] = ...
    Postcard: typing.ClassVar[QPageSize.PageSizeId] = ...
    Prc16K: typing.ClassVar[QPageSize.PageSizeId] = ...
    Prc32K: typing.ClassVar[QPageSize.PageSizeId] = ...
    Prc32KBig: typing.ClassVar[QPageSize.PageSizeId] = ...
    Quarto: typing.ClassVar[QPageSize.PageSizeId] = ...
    Statement: typing.ClassVar[QPageSize.PageSizeId] = ...
    SuperA: typing.ClassVar[QPageSize.PageSizeId] = ...
    SuperB: typing.ClassVar[QPageSize.PageSizeId] = ...
    Tabloid: typing.ClassVar[QPageSize.PageSizeId] = ...
    TabloidExtra: typing.ClassVar[QPageSize.PageSizeId] = ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSizeF, units: QPageSize.Unit, name: str = ..., matchPolicy: QPageSize.SizeMatchPolicy = ...) -> None: ...
    @overload
    def __init__(self, pointSize: PySide2.QtCore.QSize, name: str = ..., matchPolicy: QPageSize.SizeMatchPolicy = ...) -> None: ...
    @overload
    def __init__(self, other: QPageSize) -> None: ...
    @overload
    def __init__(self, pageSizeId: QPageSize.PageSizeId) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def definitionSize(self) -> PySide2.QtCore.QSizeF: ...
    def definitionUnits(self) -> QPageSize.Unit: ...
    def id(self) -> QPageSize.PageSizeId: ...
    def isEquivalentTo(self, other: QPageSize) -> bool: ...
    def isValid(self) -> bool: ...
    def key(self) -> str: ...
    def name(self) -> str: ...
    def rect(self, units: QPageSize.Unit) -> PySide2.QtCore.QRectF: ...
    def rectPixels(self, resolution: int) -> PySide2.QtCore.QRect: ...
    def rectPoints(self) -> PySide2.QtCore.QRect: ...
    def size(self, units: QPageSize.Unit) -> PySide2.QtCore.QSizeF: ...
    def sizePixels(self, resolution: int) -> PySide2.QtCore.QSize: ...
    def sizePoints(self) -> PySide2.QtCore.QSize: ...
    def swap(self, other: QPageSize) -> None: ...
    def windowsId(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPagedPaintDevice(QPaintDevice):
    class Margins(shiboken2.Object):
        bottom: typing.Any
        left: typing.Any
        right: typing.Any
        top: typing.Any
        @overload
        def __init__(self, Margins: QPagedPaintDevice.Margins) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...

    class PageSize:
        A0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A3Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A4Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A4Plus: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A4Small: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A5Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        A9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        AnsiA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        AnsiB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        AnsiC: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        AnsiD: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        AnsiE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ArchA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ArchB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ArchC: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ArchD: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ArchE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B5Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        B9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        C5E: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Comm10E: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Custom: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        DLE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        DoublePostcard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Envelope10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Envelope11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Envelope12: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Envelope14: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Envelope9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeB4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeB5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeB6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC65: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeC7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeChou3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeChou4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeDL: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeInvite: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeItalian: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeKaku2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeKaku3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeMonarch: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePersonal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopePrc9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        EnvelopeYou4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Executive: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        ExecutiveStandard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        FanFoldGerman: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        FanFoldGermanLegal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        FanFoldUS: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Folio: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial10x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial10x13: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial10x14: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial12x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial15x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial7x9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial8x10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial9x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Imperial9x12: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        JisB9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        LastPageSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Ledger: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Legal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        LegalExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Letter: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        LetterExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        LetterPlus: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        LetterSmall: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        NPageSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        NPaperSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Note: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Postcard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Prc16K: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Prc32K: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Prc32KBig: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Quarto: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Statement: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        SuperA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        SuperB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        Tabloid: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        TabloidExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __and__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __rand__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __ror__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __sub__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...
        def __xor__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PageSize: ...

    class PdfVersion:
        PdfVersion_1_4: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
        PdfVersion_1_6: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
        PdfVersion_A1b: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __and__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __rand__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __ror__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __sub__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
        def __xor__(self, other: typing.SupportsInt) -> QPagedPaintDevice.PdfVersion: ...
    A0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A3Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A4Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A4Plus: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A4Small: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A5Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    A9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    AnsiA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    AnsiB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    AnsiC: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    AnsiD: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    AnsiE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ArchA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ArchB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ArchC: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ArchD: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ArchE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B5Extra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    B9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    C5E: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Comm10E: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Custom: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    DLE: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    DoublePostcard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Envelope10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Envelope11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Envelope12: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Envelope14: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Envelope9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeB4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeB5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeB6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC65: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeC7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeChou3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeChou4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeDL: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeInvite: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeItalian: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeKaku2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeKaku3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeMonarch: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePersonal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopePrc9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    EnvelopeYou4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Executive: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    ExecutiveStandard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    FanFoldGerman: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    FanFoldGermanLegal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    FanFoldUS: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Folio: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial10x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial10x13: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial10x14: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial12x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial15x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial7x9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial8x10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial9x11: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Imperial9x12: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB0: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB1: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB10: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB2: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB3: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB4: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB5: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB6: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB7: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB8: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    JisB9: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    LastPageSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Ledger: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Legal: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    LegalExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Letter: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    LetterExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    LetterPlus: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    LetterSmall: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    NPageSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    NPaperSize: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Note: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    PdfVersion_1_4: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
    PdfVersion_1_6: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
    PdfVersion_A1b: typing.ClassVar[QPagedPaintDevice.PdfVersion] = ...
    Postcard: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Prc16K: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Prc32K: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Prc32KBig: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Quarto: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Statement: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    SuperA: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    SuperB: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    Tabloid: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    TabloidExtra: typing.ClassVar[QPagedPaintDevice.PageSize] = ...
    def __init__(self) -> None: ...
    def devicePageLayout(self) -> QPageLayout: ...
    def margins(self) -> QPagedPaintDevice.Margins: ...
    def newPage(self) -> bool: ...
    def pageLayout(self) -> QPageLayout: ...
    def pageSize(self) -> QPagedPaintDevice.PageSize: ...
    def pageSizeMM(self) -> PySide2.QtCore.QSizeF: ...
    def setMargins(self, margins: QPagedPaintDevice.Margins) -> None: ...
    def setPageLayout(self, pageLayout: QPageLayout) -> bool: ...
    @overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF, units: QPageLayout.Unit) -> bool: ...
    @overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    def setPageOrientation(self, orientation: QPageLayout.Orientation) -> bool: ...
    @overload
    def setPageSize(self, pageSize: QPageSize) -> bool: ...
    @overload
    def setPageSize(self, size: QPagedPaintDevice.PageSize) -> None: ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF) -> None: ...

class QPaintDevice(shiboken2.Object):
    class PaintDeviceMetric:
        PdmDepth: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmDevicePixelRatio: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmDevicePixelRatioScaled: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmDpiX: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmDpiY: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmHeight: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmHeightMM: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmNumColors: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmPhysicalDpiX: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmPhysicalDpiY: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmWidth: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        PdmWidthMM: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __sub__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintDevice.PaintDeviceMetric: ...
    PdmDepth: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmDevicePixelRatio: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmDevicePixelRatioScaled: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmDpiX: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmDpiY: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmHeight: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmHeightMM: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmNumColors: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmPhysicalDpiX: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmPhysicalDpiY: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmWidth: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    PdmWidthMM: typing.ClassVar[QPaintDevice.PaintDeviceMetric] = ...
    painters: typing.Any
    def __init__(self) -> None: ...
    def colorCount(self) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> int: ...
    def devicePixelRatioF(self) -> float: ...
    @classmethod
    def devicePixelRatioFScale(cls) -> float: ...
    def height(self) -> int: ...
    def heightMM(self) -> int: ...
    def initPainter(self, painter: QPainter) -> None: ...
    def logicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def paintingActive(self) -> bool: ...
    def physicalDpiX(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def redirected(self, offset: PySide2.QtCore.QPoint) -> QPaintDevice: ...
    def sharedPainter(self) -> QPainter: ...
    def width(self) -> int: ...
    def widthMM(self) -> int: ...

class QPaintDeviceWindow(QWindow, QPaintDevice):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: QExposeEvent) -> None: ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    @overload
    def update(self, rect: PySide2.QtCore.QRect) -> None: ...
    @overload
    def update(self, region: QRegion) -> None: ...
    @overload
    def update(self) -> None: ...

class QPaintEngine(shiboken2.Object):
    class DirtyFlag:
        AllDirty: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyBackground: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyBackgroundMode: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyBrush: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyBrushOrigin: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyClipEnabled: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyClipPath: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyClipRegion: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyCompositionMode: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyFont: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyHints: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyOpacity: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyPen: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        DirtyTransform: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPaintEngine.DirtyFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...

    class DirtyFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPaintEngine.DirtyFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.DirtyFlags: ...

    class PaintEngineFeature:
        AllFeatures: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        AlphaBlend: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        Antialiasing: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        BlendModes: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        BrushStroke: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        ConicalGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        ConstantOpacity: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        LinearGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        MaskedBrush: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        ObjectBoundingModeGradients: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PaintOutsidePaintEvent: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PainterPaths: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PatternBrush: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PatternTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PerspectiveTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PixmapTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PorterDuff: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        PrimitiveTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        RadialGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        RasterOpModes: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPaintEngine.PaintEngineFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...

    class PaintEngineFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPaintEngine.PaintEngineFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.PaintEngineFeatures: ...

    class PolygonDrawMode:
        ConvexMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
        OddEvenMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
        PolylineMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
        WindingMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.PolygonDrawMode: ...

    class Type:
        Blitter: typing.ClassVar[QPaintEngine.Type] = ...
        CoreGraphics: typing.ClassVar[QPaintEngine.Type] = ...
        Direct2D: typing.ClassVar[QPaintEngine.Type] = ...
        Direct3D: typing.ClassVar[QPaintEngine.Type] = ...
        MacPrinter: typing.ClassVar[QPaintEngine.Type] = ...
        MaxUser: typing.ClassVar[QPaintEngine.Type] = ...
        OpenGL: typing.ClassVar[QPaintEngine.Type] = ...
        OpenGL2: typing.ClassVar[QPaintEngine.Type] = ...
        OpenVG: typing.ClassVar[QPaintEngine.Type] = ...
        PaintBuffer: typing.ClassVar[QPaintEngine.Type] = ...
        Pdf: typing.ClassVar[QPaintEngine.Type] = ...
        Picture: typing.ClassVar[QPaintEngine.Type] = ...
        PostScript: typing.ClassVar[QPaintEngine.Type] = ...
        QWindowSystem: typing.ClassVar[QPaintEngine.Type] = ...
        QuickDraw: typing.ClassVar[QPaintEngine.Type] = ...
        Raster: typing.ClassVar[QPaintEngine.Type] = ...
        SVG: typing.ClassVar[QPaintEngine.Type] = ...
        User: typing.ClassVar[QPaintEngine.Type] = ...
        Windows: typing.ClassVar[QPaintEngine.Type] = ...
        X11: typing.ClassVar[QPaintEngine.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QPaintEngine.Type: ...
    AllDirty: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    AllFeatures: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    AlphaBlend: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    Antialiasing: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    BlendModes: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    Blitter: typing.ClassVar[QPaintEngine.Type] = ...
    BrushStroke: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    ConicalGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    ConstantOpacity: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    ConvexMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
    CoreGraphics: typing.ClassVar[QPaintEngine.Type] = ...
    Direct2D: typing.ClassVar[QPaintEngine.Type] = ...
    Direct3D: typing.ClassVar[QPaintEngine.Type] = ...
    DirtyBackground: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyBackgroundMode: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyBrush: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyBrushOrigin: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyClipEnabled: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyClipPath: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyClipRegion: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyCompositionMode: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyFont: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyHints: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyOpacity: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyPen: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    DirtyTransform: typing.ClassVar[QPaintEngine.DirtyFlag] = ...
    LinearGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    MacPrinter: typing.ClassVar[QPaintEngine.Type] = ...
    MaskedBrush: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    MaxUser: typing.ClassVar[QPaintEngine.Type] = ...
    ObjectBoundingModeGradients: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    OddEvenMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
    OpenGL: typing.ClassVar[QPaintEngine.Type] = ...
    OpenGL2: typing.ClassVar[QPaintEngine.Type] = ...
    OpenVG: typing.ClassVar[QPaintEngine.Type] = ...
    PaintBuffer: typing.ClassVar[QPaintEngine.Type] = ...
    PaintOutsidePaintEvent: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    PainterPaths: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    PatternBrush: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    PatternTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    Pdf: typing.ClassVar[QPaintEngine.Type] = ...
    PerspectiveTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    Picture: typing.ClassVar[QPaintEngine.Type] = ...
    PixmapTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    PolylineMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
    PorterDuff: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    PostScript: typing.ClassVar[QPaintEngine.Type] = ...
    PrimitiveTransform: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    QWindowSystem: typing.ClassVar[QPaintEngine.Type] = ...
    QuickDraw: typing.ClassVar[QPaintEngine.Type] = ...
    RadialGradientFill: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    Raster: typing.ClassVar[QPaintEngine.Type] = ...
    RasterOpModes: typing.ClassVar[QPaintEngine.PaintEngineFeature] = ...
    SVG: typing.ClassVar[QPaintEngine.Type] = ...
    User: typing.ClassVar[QPaintEngine.Type] = ...
    WindingMode: typing.ClassVar[QPaintEngine.PolygonDrawMode] = ...
    Windows: typing.ClassVar[QPaintEngine.Type] = ...
    X11: typing.ClassVar[QPaintEngine.Type] = ...
    active: typing.Any
    extended: typing.Any
    gccaps: typing.Any
    selfDestruct: typing.Any
    state: typing.Any
    def __init__(self, features: typing.Union[QPaintEngine.PaintEngineFeatures,QPaintEngine.PaintEngineFeature] = ...) -> None: ...
    def begin(self, pdev: QPaintDevice) -> bool: ...
    def clearDirty(self, df: typing.Union[QPaintEngine.DirtyFlags,QPaintEngine.DirtyFlag]) -> None: ...
    def coordinateOffset(self) -> PySide2.QtCore.QPoint: ...
    @overload
    def drawEllipse(self, r: PySide2.QtCore.QRect) -> None: ...
    @overload
    def drawEllipse(self, r: PySide2.QtCore.QRectF) -> None: ...
    def drawImage(self, r: PySide2.QtCore.QRectF, pm: QImage, sr: PySide2.QtCore.QRectF, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawLines(self, lines: PySide2.QtCore.QLine, lineCount: int) -> None: ...
    @overload
    def drawLines(self, lines: PySide2.QtCore.QLineF, lineCount: int) -> None: ...
    def drawPath(self, path: QPainterPath) -> None: ...
    def drawPixmap(self, r: PySide2.QtCore.QRectF, pm: QPixmap, sr: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def drawPoints(self, points: PySide2.QtCore.QPoint, pointCount: int) -> None: ...
    @overload
    def drawPoints(self, points: PySide2.QtCore.QPointF, pointCount: int) -> None: ...
    @overload
    def drawPolygon(self, points: PySide2.QtCore.QPoint, pointCount: int, mode: QPaintEngine.PolygonDrawMode) -> None: ...
    @overload
    def drawPolygon(self, points: PySide2.QtCore.QPointF, pointCount: int, mode: QPaintEngine.PolygonDrawMode) -> None: ...
    @overload
    def drawRects(self, rects: PySide2.QtCore.QRect, rectCount: int) -> None: ...
    @overload
    def drawRects(self, rects: PySide2.QtCore.QRectF, rectCount: int) -> None: ...
    def drawTextItem(self, p: PySide2.QtCore.QPointF, textItem: QTextItem) -> None: ...
    def drawTiledPixmap(self, r: PySide2.QtCore.QRectF, pixmap: QPixmap, s: PySide2.QtCore.QPointF) -> None: ...
    def end(self) -> bool: ...
    def hasFeature(self, feature: typing.Union[QPaintEngine.PaintEngineFeatures,QPaintEngine.PaintEngineFeature]) -> bool: ...
    def isActive(self) -> bool: ...
    def isExtended(self) -> bool: ...
    def paintDevice(self) -> QPaintDevice: ...
    def painter(self) -> QPainter: ...
    def setActive(self, newState: bool) -> None: ...
    def setDirty(self, df: typing.Union[QPaintEngine.DirtyFlags,QPaintEngine.DirtyFlag]) -> None: ...
    def setSystemClip(self, baseClip: QRegion) -> None: ...
    def setSystemRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def syncState(self) -> None: ...
    def systemClip(self) -> QRegion: ...
    def systemRect(self) -> PySide2.QtCore.QRect: ...
    def testDirty(self, df: typing.Union[QPaintEngine.DirtyFlags,QPaintEngine.DirtyFlag]) -> bool: ...
    def type(self) -> QPaintEngine.Type: ...
    def updateState(self, state: QPaintEngineState) -> None: ...

class QPaintEngineState(shiboken2.Object):
    dirtyFlags: typing.Any
    def __init__(self) -> None: ...
    def backgroundBrush(self) -> QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def brush(self) -> QBrush: ...
    def brushNeedsResolving(self) -> bool: ...
    def brushOrigin(self) -> PySide2.QtCore.QPointF: ...
    def clipOperation(self) -> PySide2.QtCore.Qt.ClipOperation: ...
    def clipPath(self) -> QPainterPath: ...
    def clipRegion(self) -> QRegion: ...
    def compositionMode(self) -> QPainter.CompositionMode: ...
    def font(self) -> QFont: ...
    def isClipEnabled(self) -> bool: ...
    def matrix(self) -> QMatrix: ...
    def opacity(self) -> float: ...
    def painter(self) -> QPainter: ...
    def pen(self) -> QPen: ...
    def penNeedsResolving(self) -> bool: ...
    def renderHints(self) -> typing.Union[QPainter.RenderHints,QPainter.RenderHint]: ...
    def state(self) -> typing.Union[QPaintEngine.DirtyFlags,QPaintEngine.DirtyFlag]: ...
    def transform(self) -> QTransform: ...

class QPaintEvent(PySide2.QtCore.QEvent):
    @overload
    def __init__(self, paintRect: PySide2.QtCore.QRect) -> None: ...
    @overload
    def __init__(self, paintRegion: QRegion) -> None: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def region(self) -> QRegion: ...

class QPainter(shiboken2.Object):
    class CompositionMode:
        CompositionMode_Clear: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_ColorBurn: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_ColorDodge: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Darken: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Destination: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_DestinationAtop: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_DestinationIn: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_DestinationOut: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_DestinationOver: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Difference: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Exclusion: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_HardLight: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Lighten: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Multiply: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Overlay: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Plus: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Screen: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_SoftLight: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Source: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_SourceAtop: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_SourceIn: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_SourceOut: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_SourceOver: typing.ClassVar[QPainter.CompositionMode] = ...
        CompositionMode_Xor: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_ClearDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSource: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSourceAndDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSourceAndNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSourceOrDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSourceOrNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_NotSourceXorDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SetDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SourceAndDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SourceAndNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SourceOrDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SourceOrNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        RasterOp_SourceXorDestination: typing.ClassVar[QPainter.CompositionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainter.CompositionMode: ...

    class PixmapFragment(shiboken2.Object):
        height: typing.Any
        opacity: typing.Any
        rotation: typing.Any
        scaleX: typing.Any
        scaleY: typing.Any
        sourceLeft: typing.Any
        sourceTop: typing.Any
        width: typing.Any
        x: typing.Any
        y: typing.Any
        @overload
        def __init__(self, PixmapFragment: QPainter.PixmapFragment) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @classmethod
        def create(cls, pos: PySide2.QtCore.QPointF, sourceRect: PySide2.QtCore.QRectF, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> QPainter.PixmapFragment: ...
        def __copy__(self) -> None: ...

    class PixmapFragmentHint:
        OpaqueHint: typing.ClassVar[QPainter.PixmapFragmentHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPainter.PixmapFragmentHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...

    class PixmapFragmentHints:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPainter.PixmapFragmentHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainter.PixmapFragmentHints: ...

    class RenderHint:
        Antialiasing: typing.ClassVar[QPainter.RenderHint] = ...
        HighQualityAntialiasing: typing.ClassVar[QPainter.RenderHint] = ...
        LosslessImageRendering: typing.ClassVar[QPainter.RenderHint] = ...
        NonCosmeticDefaultPen: typing.ClassVar[QPainter.RenderHint] = ...
        Qt4CompatiblePainting: typing.ClassVar[QPainter.RenderHint] = ...
        SmoothPixmapTransform: typing.ClassVar[QPainter.RenderHint] = ...
        TextAntialiasing: typing.ClassVar[QPainter.RenderHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPainter.RenderHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...

    class RenderHints:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QPainter.RenderHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainter.RenderHints: ...
    Antialiasing: typing.ClassVar[QPainter.RenderHint] = ...
    CompositionMode_Clear: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_ColorBurn: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_ColorDodge: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Darken: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Destination: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_DestinationAtop: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_DestinationIn: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_DestinationOut: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_DestinationOver: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Difference: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Exclusion: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_HardLight: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Lighten: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Multiply: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Overlay: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Plus: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Screen: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_SoftLight: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Source: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_SourceAtop: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_SourceIn: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_SourceOut: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_SourceOver: typing.ClassVar[QPainter.CompositionMode] = ...
    CompositionMode_Xor: typing.ClassVar[QPainter.CompositionMode] = ...
    HighQualityAntialiasing: typing.ClassVar[QPainter.RenderHint] = ...
    LosslessImageRendering: typing.ClassVar[QPainter.RenderHint] = ...
    NonCosmeticDefaultPen: typing.ClassVar[QPainter.RenderHint] = ...
    OpaqueHint: typing.ClassVar[QPainter.PixmapFragmentHint] = ...
    Qt4CompatiblePainting: typing.ClassVar[QPainter.RenderHint] = ...
    RasterOp_ClearDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSource: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSourceAndDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSourceAndNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSourceOrDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSourceOrNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_NotSourceXorDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SetDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SourceAndDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SourceAndNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SourceOrDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SourceOrNotDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    RasterOp_SourceXorDestination: typing.ClassVar[QPainter.CompositionMode] = ...
    SmoothPixmapTransform: typing.ClassVar[QPainter.RenderHint] = ...
    TextAntialiasing: typing.ClassVar[QPainter.RenderHint] = ...
    @overload
    def __init__(self, arg__1: QPaintDevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def background(self) -> QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def begin(self, arg__1: QPaintDevice) -> bool: ...
    def beginNativePainting(self) -> None: ...
    @overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: typing.SupportsInt, text: str) -> PySide2.QtCore.QRect: ...
    @overload
    def boundingRect(self, rect: PySide2.QtCore.QRect, flags: typing.SupportsInt, text: str) -> PySide2.QtCore.QRect: ...
    @overload
    def boundingRect(self, rect: PySide2.QtCore.QRectF, flags: typing.SupportsInt, text: str) -> PySide2.QtCore.QRectF: ...
    @overload
    def boundingRect(self, rect: PySide2.QtCore.QRectF, text: str, o: QTextOption = ...) -> PySide2.QtCore.QRectF: ...
    def brush(self) -> QBrush: ...
    def brushOrigin(self) -> PySide2.QtCore.QPoint: ...
    def clipBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clipPath(self) -> QPainterPath: ...
    def clipRegion(self) -> QRegion: ...
    def combinedMatrix(self) -> QMatrix: ...
    def combinedTransform(self) -> QTransform: ...
    def compositionMode(self) -> QPainter.CompositionMode: ...
    def device(self) -> QPaintDevice: ...
    def deviceMatrix(self) -> QMatrix: ...
    def deviceTransform(self) -> QTransform: ...
    @overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, rect: PySide2.QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, rect: PySide2.QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawConvexPolygon(self, arg__1: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def drawConvexPolygon(self, arg__1: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    @overload
    def drawConvexPolygon(self, polygon: QPolygon) -> None: ...
    @overload
    def drawConvexPolygon(self, polygon: QPolygonF) -> None: ...
    @overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def drawEllipse(self, center: PySide2.QtCore.QPoint, rx: int, ry: int) -> None: ...
    @overload
    def drawEllipse(self, center: PySide2.QtCore.QPointF, rx: float, ry: float) -> None: ...
    @overload
    def drawEllipse(self, r: PySide2.QtCore.QRect) -> None: ...
    @overload
    def drawEllipse(self, r: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def drawImage(self, x: int, y: int, image: QImage, sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawImage(self, p: PySide2.QtCore.QPoint, image: QImage, sr: PySide2.QtCore.QRect, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawImage(self, p: PySide2.QtCore.QPointF, image: QImage, sr: PySide2.QtCore.QRectF, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawImage(self, targetRect: PySide2.QtCore.QRect, image: QImage, sourceRect: PySide2.QtCore.QRect, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawImage(self, targetRect: PySide2.QtCore.QRectF, image: QImage, sourceRect: PySide2.QtCore.QRectF, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def drawImage(self, p: PySide2.QtCore.QPoint, image: QImage) -> None: ...
    @overload
    def drawImage(self, p: PySide2.QtCore.QPointF, image: QImage) -> None: ...
    @overload
    def drawImage(self, r: PySide2.QtCore.QRect, image: QImage) -> None: ...
    @overload
    def drawImage(self, r: PySide2.QtCore.QRectF, image: QImage) -> None: ...
    @overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @overload
    def drawLine(self, p1: PySide2.QtCore.QPoint, p2: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def drawLine(self, p1: PySide2.QtCore.QPointF, p2: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def drawLine(self, line: PySide2.QtCore.QLine) -> None: ...
    @overload
    def drawLine(self, line: PySide2.QtCore.QLineF) -> None: ...
    @overload
    def drawLines(self, lines: typing.List[PySide2.QtCore.QLineF]) -> None: ...
    @overload
    def drawLines(self, lines: typing.List[PySide2.QtCore.QLine]) -> None: ...
    @overload
    def drawLines(self, pointPairs: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def drawLines(self, pointPairs: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    def drawPath(self, path: QPainterPath) -> None: ...
    @overload
    def drawPicture(self, x: int, y: int, picture: QPicture) -> None: ...
    @overload
    def drawPicture(self, p: PySide2.QtCore.QPoint, picture: QPicture) -> None: ...
    @overload
    def drawPicture(self, p: PySide2.QtCore.QPointF, picture: QPicture) -> None: ...
    @overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, arg__1: PySide2.QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, rect: PySide2.QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, p: PySide2.QtCore.QPoint, pm: QPixmap, sr: PySide2.QtCore.QRect) -> None: ...
    @overload
    def drawPixmap(self, p: PySide2.QtCore.QPointF, pm: QPixmap, sr: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def drawPixmap(self, targetRect: PySide2.QtCore.QRect, pixmap: QPixmap, sourceRect: PySide2.QtCore.QRect) -> None: ...
    @overload
    def drawPixmap(self, targetRect: PySide2.QtCore.QRectF, pixmap: QPixmap, sourceRect: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, p: PySide2.QtCore.QPoint, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, p: PySide2.QtCore.QPointF, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, r: PySide2.QtCore.QRect, pm: QPixmap) -> None: ...
    def drawPixmapFragments(self, fragments: QPainter.PixmapFragment, fragmentCount: int, pixmap: QPixmap, hints: typing.Union[QPainter.PixmapFragmentHints,QPainter.PixmapFragmentHint] = ...) -> None: ...
    @overload
    def drawPoint(self, x: int, y: int) -> None: ...
    @overload
    def drawPoint(self, p: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def drawPoint(self, pt: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def drawPoints(self, arg__1: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def drawPoints(self, arg__1: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    @overload
    def drawPoints(self, points: QPolygon) -> None: ...
    @overload
    def drawPoints(self, points: QPolygonF) -> None: ...
    @overload
    def drawPolygon(self, arg__1: typing.List[PySide2.QtCore.QPointF], arg__2: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolygon(self, arg__1: typing.List[PySide2.QtCore.QPoint], arg__2: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolygon(self, polygon: QPolygon, fillRule: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolygon(self, polygon: QPolygonF, fillRule: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def drawPolyline(self, arg__1: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def drawPolyline(self, arg__1: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    @overload
    def drawPolyline(self, polygon: QPolygon) -> None: ...
    @overload
    def drawPolyline(self, polyline: QPolygonF) -> None: ...
    @overload
    def drawRect(self, x1: int, y1: int, w: int, h: int) -> None: ...
    @overload
    def drawRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    @overload
    def drawRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def drawRects(self, rectangles: typing.List[PySide2.QtCore.QRectF]) -> None: ...
    @overload
    def drawRects(self, rectangles: typing.List[PySide2.QtCore.QRect]) -> None: ...
    @overload
    def drawRoundRect(self, x: int, y: int, w: int, h: int, xRound: int = ..., yRound: int = ...) -> None: ...
    @overload
    def drawRoundRect(self, r: PySide2.QtCore.QRect, xround: int = ..., yround: int = ...) -> None: ...
    @overload
    def drawRoundRect(self, r: PySide2.QtCore.QRectF, xround: int = ..., yround: int = ...) -> None: ...
    @overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawRoundedRect(self, rect: PySide2.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawRoundedRect(self, rect: PySide2.QtCore.QRectF, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def drawStaticText(self, left: int, top: int, staticText: QStaticText) -> None: ...
    @overload
    def drawStaticText(self, topLeftPosition: PySide2.QtCore.QPoint, staticText: QStaticText) -> None: ...
    @overload
    def drawStaticText(self, topLeftPosition: PySide2.QtCore.QPointF, staticText: QStaticText) -> None: ...
    @overload
    def drawText(self, x: int, y: int, w: int, h: int, flags: typing.SupportsInt, text: str, br: PySide2.QtCore.QRect = ...) -> None: ...
    @overload
    def drawText(self, r: PySide2.QtCore.QRect, flags: typing.SupportsInt, text: str, br: PySide2.QtCore.QRect = ...) -> None: ...
    @overload
    def drawText(self, r: PySide2.QtCore.QRectF, flags: typing.SupportsInt, text: str, br: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def drawText(self, r: PySide2.QtCore.QRectF, text: str, o: QTextOption = ...) -> None: ...
    @overload
    def drawText(self, x: int, y: int, s: str) -> None: ...
    @overload
    def drawText(self, p: PySide2.QtCore.QPoint, s: str) -> None: ...
    @overload
    def drawText(self, p: PySide2.QtCore.QPointF, s: str) -> None: ...
    @overload
    def drawTextItem(self, x: int, y: int, ti: QTextItem) -> None: ...
    @overload
    def drawTextItem(self, p: PySide2.QtCore.QPoint, ti: QTextItem) -> None: ...
    @overload
    def drawTextItem(self, p: PySide2.QtCore.QPointF, ti: QTextItem) -> None: ...
    @overload
    def drawTiledPixmap(self, x: int, y: int, w: int, h: int, arg__5: QPixmap, sx: int = ..., sy: int = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, arg__1: PySide2.QtCore.QRect, arg__2: QPixmap, pos: PySide2.QtCore.QPoint = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, rect: PySide2.QtCore.QRectF, pm: QPixmap, offset: PySide2.QtCore.QPointF = ...) -> None: ...
    def end(self) -> bool: ...
    def endNativePainting(self) -> None: ...
    @overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def eraseRect(self, arg__1: PySide2.QtCore.QRect) -> None: ...
    @overload
    def eraseRect(self, arg__1: PySide2.QtCore.QRectF) -> None: ...
    def fillPath(self, path: QPainterPath, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, arg__5: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, preset: QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide2.QtCore.QRect, arg__2: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide2.QtCore.QRect, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide2.QtCore.QRectF, arg__2: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def fillRect(self, arg__1: PySide2.QtCore.QRectF, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRect, c: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRect, preset: QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRect, style: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRectF, c: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRectF, preset: QGradient.Preset) -> None: ...
    @overload
    def fillRect(self, r: PySide2.QtCore.QRectF, style: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    def font(self) -> QFont: ...
    def fontInfo(self) -> QFontInfo: ...
    def fontMetrics(self) -> QFontMetrics: ...
    def hasClipping(self) -> bool: ...
    def initFrom(self, device: QPaintDevice) -> None: ...
    def isActive(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def matrix(self) -> QMatrix: ...
    def matrixEnabled(self) -> bool: ...
    def opacity(self) -> float: ...
    def paintEngine(self) -> QPaintEngine: ...
    def pen(self) -> QPen: ...
    @classmethod
    def redirected(cls, device: QPaintDevice, offset: typing.Union[PySide2.QtCore.QPoint,None] = ...) -> QPaintDevice: ...
    def renderHints(self) -> typing.Union[QPainter.RenderHints,QPainter.RenderHint]: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def restore(self) -> None: ...
    @classmethod
    def restoreRedirected(cls, device: QPaintDevice) -> None: ...
    def rotate(self, a: float) -> None: ...
    def save(self) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def setBackground(self, bg: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setBackgroundMode(self, mode: PySide2.QtCore.Qt.BGMode) -> None: ...
    @overload
    def setBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def setBrush(self, style: PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @overload
    def setBrushOrigin(self, x: int, y: int) -> None: ...
    @overload
    def setBrushOrigin(self, arg__1: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setBrushOrigin(self, arg__1: PySide2.QtCore.QPointF) -> None: ...
    def setClipPath(self, path: QPainterPath, op: PySide2.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, x: int, y: int, w: int, h: int, op: PySide2.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, arg__1: PySide2.QtCore.QRect, op: PySide2.QtCore.Qt.ClipOperation = ...) -> None: ...
    @overload
    def setClipRect(self, arg__1: PySide2.QtCore.QRectF, op: PySide2.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipRegion(self, arg__1: QRegion, op: PySide2.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipping(self, enable: bool) -> None: ...
    def setCompositionMode(self, mode: QPainter.CompositionMode) -> None: ...
    def setFont(self, f: QFont) -> None: ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setMatrix(self, matrix: QMatrix, combine: bool = ...) -> None: ...
    def setMatrixEnabled(self, enabled: bool) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    @overload
    def setPen(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setPen(self, pen: QPen) -> None: ...
    @overload
    def setPen(self, style: PySide2.QtCore.Qt.PenStyle) -> None: ...
    @classmethod
    def setRedirected(cls, device: QPaintDevice, replacement: QPaintDevice, offset: PySide2.QtCore.QPoint = ...) -> None: ...
    def setRenderHint(self, hint: QPainter.RenderHint, on: bool = ...) -> None: ...
    def setRenderHints(self, hints: typing.Union[QPainter.RenderHints,QPainter.RenderHint], on: bool = ...) -> None: ...
    def setTransform(self, transform: QTransform, combine: bool = ...) -> None: ...
    def setViewTransformEnabled(self, enable: bool) -> None: ...
    @overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def setViewport(self, viewport: PySide2.QtCore.QRect) -> None: ...
    @overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def setWindow(self, window: PySide2.QtCore.QRect) -> None: ...
    def setWorldMatrix(self, matrix: QMatrix, combine: bool = ...) -> None: ...
    def setWorldMatrixEnabled(self, enabled: bool) -> None: ...
    def setWorldTransform(self, matrix: QTransform, combine: bool = ...) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def strokePath(self, path: QPainterPath, pen: QPen) -> None: ...
    def testRenderHint(self, hint: QPainter.RenderHint) -> bool: ...
    def transform(self) -> QTransform: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def translate(self, offset: PySide2.QtCore.QPointF) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def window(self) -> PySide2.QtCore.QRect: ...
    def worldMatrix(self) -> QMatrix: ...
    def worldMatrixEnabled(self) -> bool: ...
    def worldTransform(self) -> QTransform: ...

class QPainterPath(shiboken2.Object):
    class Element(shiboken2.Object):
        type: typing.Any
        x: typing.Any
        y: typing.Any
        @overload
        def __init__(self, Element: QPainterPath.Element) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class ElementType:
        CurveToDataElement: typing.ClassVar[QPainterPath.ElementType] = ...
        CurveToElement: typing.ClassVar[QPainterPath.ElementType] = ...
        LineToElement: typing.ClassVar[QPainterPath.ElementType] = ...
        MoveToElement: typing.ClassVar[QPainterPath.ElementType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __and__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __rand__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __ror__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __sub__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
        def __xor__(self, other: typing.SupportsInt) -> QPainterPath.ElementType: ...
    CurveToDataElement: typing.ClassVar[QPainterPath.ElementType] = ...
    CurveToElement: typing.ClassVar[QPainterPath.ElementType] = ...
    LineToElement: typing.ClassVar[QPainterPath.ElementType] = ...
    MoveToElement: typing.ClassVar[QPainterPath.ElementType] = ...
    @overload
    def __init__(self, other: QPainterPath) -> None: ...
    @overload
    def __init__(self, startPoint: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def addEllipse(self, center: PySide2.QtCore.QPointF, rx: float, ry: float) -> None: ...
    @overload
    def addEllipse(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def addPath(self, path: QPainterPath) -> None: ...
    def addPolygon(self, polygon: QPolygonF) -> None: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def addRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def addRegion(self, region: QRegion) -> None: ...
    @overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, xRnd: int, yRnd: int) -> None: ...
    @overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, roundness: int) -> None: ...
    @overload
    def addRoundRect(self, rect: PySide2.QtCore.QRectF, xRnd: int, yRnd: int) -> None: ...
    @overload
    def addRoundRect(self, rect: PySide2.QtCore.QRectF, roundness: int) -> None: ...
    @overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def addRoundedRect(self, rect: PySide2.QtCore.QRectF, xRadius: float, yRadius: float, mode: PySide2.QtCore.Qt.SizeMode = ...) -> None: ...
    @overload
    def addText(self, x: float, y: float, f: QFont, text: str) -> None: ...
    @overload
    def addText(self, point: PySide2.QtCore.QPointF, f: QFont, text: str) -> None: ...
    def angleAtPercent(self, t: float) -> float: ...
    @overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None: ...
    @overload
    def arcMoveTo(self, rect: PySide2.QtCore.QRectF, angle: float) -> None: ...
    @overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLength: float) -> None: ...
    @overload
    def arcTo(self, rect: PySide2.QtCore.QRectF, startAngle: float, arcLength: float) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def closeSubpath(self) -> None: ...
    def connectPath(self, path: QPainterPath) -> None: ...
    @overload
    def contains(self, p: QPainterPath) -> bool: ...
    @overload
    def contains(self, pt: PySide2.QtCore.QPointF) -> bool: ...
    @overload
    def contains(self, rect: PySide2.QtCore.QRectF) -> bool: ...
    def controlPointRect(self) -> PySide2.QtCore.QRectF: ...
    @overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float) -> None: ...
    @overload
    def cubicTo(self, ctrlPt1: PySide2.QtCore.QPointF, ctrlPt2: PySide2.QtCore.QPointF, endPt: PySide2.QtCore.QPointF) -> None: ...
    def currentPosition(self) -> PySide2.QtCore.QPointF: ...
    def elementAt(self, i: int) -> QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def intersected(self, r: QPainterPath) -> QPainterPath: ...
    @overload
    def intersects(self, p: QPainterPath) -> bool: ...
    @overload
    def intersects(self, rect: PySide2.QtCore.QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def length(self) -> float: ...
    @overload
    def lineTo(self, x: float, y: float) -> None: ...
    @overload
    def lineTo(self, p: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def moveTo(self, x: float, y: float) -> None: ...
    @overload
    def moveTo(self, p: PySide2.QtCore.QPointF) -> None: ...
    def percentAtLength(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> PySide2.QtCore.QPointF: ...
    @overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float) -> None: ...
    @overload
    def quadTo(self, ctrlPt: PySide2.QtCore.QPointF, endPt: PySide2.QtCore.QPointF) -> None: ...
    def reserve(self, size: int) -> None: ...
    def setElementPositionAt(self, i: int, x: float, y: float) -> None: ...
    def setFillRule(self, fillRule: PySide2.QtCore.Qt.FillRule) -> None: ...
    def simplified(self) -> QPainterPath: ...
    def slopeAtPercent(self, t: float) -> float: ...
    def subtracted(self, r: QPainterPath) -> QPainterPath: ...
    def subtractedInverted(self, r: QPainterPath) -> QPainterPath: ...
    def swap(self, other: QPainterPath) -> None: ...
    @overload
    def toFillPolygon(self, matrix: QMatrix) -> QPolygonF: ...
    @overload
    def toFillPolygon(self, matrix: QTransform = ...) -> QPolygonF: ...
    @overload
    def toFillPolygons(self, matrix: QMatrix) -> typing.List[QPolygonF]: ...
    @overload
    def toFillPolygons(self, matrix: QTransform = ...) -> typing.List[QPolygonF]: ...
    def toReversed(self) -> QPainterPath: ...
    @overload
    def toSubpathPolygons(self, matrix: QMatrix) -> typing.List[QPolygonF]: ...
    @overload
    def toSubpathPolygons(self, matrix: QTransform = ...) -> typing.List[QPolygonF]: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> QPainterPath: ...
    @overload
    def translated(self, offset: PySide2.QtCore.QPointF) -> QPainterPath: ...
    def united(self, r: QPainterPath) -> QPainterPath: ...
    def __add__(self, other: QPainterPath) -> QPainterPath: ...
    def __and__(self, other: QPainterPath) -> QPainterPath: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: QPainterPath) -> QPainterPath: ...
    def __iand__(self, other: QPainterPath) -> QPainterPath: ...
    def __ior__(self, other: QPainterPath) -> QPainterPath: ...
    def __isub__(self, other: QPainterPath) -> QPainterPath: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, m: QMatrix) -> QPainterPath: ...
    @overload
    def __mul__(self, m: QTransform) -> QPainterPath: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: QPainterPath) -> QPainterPath: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rand__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __ror__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __sub__(self, other: QPainterPath) -> QPainterPath: ...

class QPainterPathStroker(shiboken2.Object):
    @overload
    def __init__(self, pen: QPen) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def createStroke(self, path: QPainterPath) -> QPainterPath: ...
    def curveThreshold(self) -> float: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setCapStyle(self, style: PySide2.QtCore.Qt.PenCapStyle) -> None: ...
    def setCurveThreshold(self, threshold: float) -> None: ...
    def setDashOffset(self, offset: float) -> None: ...
    @overload
    def setDashPattern(self, arg__1: PySide2.QtCore.Qt.PenStyle) -> None: ...
    @overload
    def setDashPattern(self, dashPattern: typing.List[float]) -> None: ...
    def setJoinStyle(self, style: PySide2.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, length: float) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...

class QPalette(shiboken2.Object):
    class ColorGroup:
        Active: typing.ClassVar[QPalette.ColorGroup] = ...
        All: typing.ClassVar[QPalette.ColorGroup] = ...
        Current: typing.ClassVar[QPalette.ColorGroup] = ...
        Disabled: typing.ClassVar[QPalette.ColorGroup] = ...
        Inactive: typing.ClassVar[QPalette.ColorGroup] = ...
        NColorGroups: typing.ClassVar[QPalette.ColorGroup] = ...
        Normal: typing.ClassVar[QPalette.ColorGroup] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __and__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __rand__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __ror__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __sub__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...
        def __xor__(self, other: typing.SupportsInt) -> QPalette.ColorGroup: ...

    class ColorRole:
        AlternateBase: typing.ClassVar[QPalette.ColorRole] = ...
        Background: typing.ClassVar[QPalette.ColorRole] = ...
        Base: typing.ClassVar[QPalette.ColorRole] = ...
        BrightText: typing.ClassVar[QPalette.ColorRole] = ...
        Button: typing.ClassVar[QPalette.ColorRole] = ...
        ButtonText: typing.ClassVar[QPalette.ColorRole] = ...
        Dark: typing.ClassVar[QPalette.ColorRole] = ...
        Foreground: typing.ClassVar[QPalette.ColorRole] = ...
        Highlight: typing.ClassVar[QPalette.ColorRole] = ...
        HighlightedText: typing.ClassVar[QPalette.ColorRole] = ...
        Light: typing.ClassVar[QPalette.ColorRole] = ...
        Link: typing.ClassVar[QPalette.ColorRole] = ...
        LinkVisited: typing.ClassVar[QPalette.ColorRole] = ...
        Mid: typing.ClassVar[QPalette.ColorRole] = ...
        Midlight: typing.ClassVar[QPalette.ColorRole] = ...
        NColorRoles: typing.ClassVar[QPalette.ColorRole] = ...
        NoRole: typing.ClassVar[QPalette.ColorRole] = ...
        PlaceholderText: typing.ClassVar[QPalette.ColorRole] = ...
        Shadow: typing.ClassVar[QPalette.ColorRole] = ...
        Text: typing.ClassVar[QPalette.ColorRole] = ...
        ToolTipBase: typing.ClassVar[QPalette.ColorRole] = ...
        ToolTipText: typing.ClassVar[QPalette.ColorRole] = ...
        Window: typing.ClassVar[QPalette.ColorRole] = ...
        WindowText: typing.ClassVar[QPalette.ColorRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __and__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __rand__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __ror__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __sub__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
        def __xor__(self, other: typing.SupportsInt) -> QPalette.ColorRole: ...
    Active: typing.ClassVar[QPalette.ColorGroup] = ...
    All: typing.ClassVar[QPalette.ColorGroup] = ...
    AlternateBase: typing.ClassVar[QPalette.ColorRole] = ...
    Background: typing.ClassVar[QPalette.ColorRole] = ...
    Base: typing.ClassVar[QPalette.ColorRole] = ...
    BrightText: typing.ClassVar[QPalette.ColorRole] = ...
    Button: typing.ClassVar[QPalette.ColorRole] = ...
    ButtonText: typing.ClassVar[QPalette.ColorRole] = ...
    Current: typing.ClassVar[QPalette.ColorGroup] = ...
    Dark: typing.ClassVar[QPalette.ColorRole] = ...
    Disabled: typing.ClassVar[QPalette.ColorGroup] = ...
    Foreground: typing.ClassVar[QPalette.ColorRole] = ...
    Highlight: typing.ClassVar[QPalette.ColorRole] = ...
    HighlightedText: typing.ClassVar[QPalette.ColorRole] = ...
    Inactive: typing.ClassVar[QPalette.ColorGroup] = ...
    Light: typing.ClassVar[QPalette.ColorRole] = ...
    Link: typing.ClassVar[QPalette.ColorRole] = ...
    LinkVisited: typing.ClassVar[QPalette.ColorRole] = ...
    Mid: typing.ClassVar[QPalette.ColorRole] = ...
    Midlight: typing.ClassVar[QPalette.ColorRole] = ...
    NColorGroups: typing.ClassVar[QPalette.ColorGroup] = ...
    NColorRoles: typing.ClassVar[QPalette.ColorRole] = ...
    NoRole: typing.ClassVar[QPalette.ColorRole] = ...
    Normal: typing.ClassVar[QPalette.ColorGroup] = ...
    PlaceholderText: typing.ClassVar[QPalette.ColorRole] = ...
    Shadow: typing.ClassVar[QPalette.ColorRole] = ...
    Text: typing.ClassVar[QPalette.ColorRole] = ...
    ToolTipBase: typing.ClassVar[QPalette.ColorRole] = ...
    ToolTipText: typing.ClassVar[QPalette.ColorRole] = ...
    Window: typing.ClassVar[QPalette.ColorRole] = ...
    WindowText: typing.ClassVar[QPalette.ColorRole] = ...
    @overload
    def __init__(self, windowText: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], button: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], light: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], dark: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], mid: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], text: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], bright_text: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], base: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], window: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def __init__(self, windowText: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], window: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], light: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], dark: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], mid: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], text: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], base: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def __init__(self, button: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], window: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def __init__(self, button: PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @overload
    def __init__(self, button: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def __init__(self, palette: QPalette) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alternateBase(self) -> QBrush: ...
    def background(self) -> QBrush: ...
    def base(self) -> QBrush: ...
    def brightText(self) -> QBrush: ...
    @overload
    def brush(self, cg: QPalette.ColorGroup, cr: QPalette.ColorRole) -> QBrush: ...
    @overload
    def brush(self, cr: QPalette.ColorRole) -> QBrush: ...
    def button(self) -> QBrush: ...
    def buttonText(self) -> QBrush: ...
    def cacheKey(self) -> int: ...
    @overload
    def color(self, cg: QPalette.ColorGroup, cr: QPalette.ColorRole) -> QColor: ...
    @overload
    def color(self, cr: QPalette.ColorRole) -> QColor: ...
    def currentColorGroup(self) -> QPalette.ColorGroup: ...
    def dark(self) -> QBrush: ...
    def foreground(self) -> QBrush: ...
    def highlight(self) -> QBrush: ...
    def highlightedText(self) -> QBrush: ...
    def isBrushSet(self, cg: QPalette.ColorGroup, cr: QPalette.ColorRole) -> bool: ...
    def isCopyOf(self, p: QPalette) -> bool: ...
    def isEqual(self, cr1: QPalette.ColorGroup, cr2: QPalette.ColorGroup) -> bool: ...
    def light(self) -> QBrush: ...
    def link(self) -> QBrush: ...
    def linkVisited(self) -> QBrush: ...
    def mid(self) -> QBrush: ...
    def midlight(self) -> QBrush: ...
    def placeholderText(self) -> QBrush: ...
    @overload
    def resolve(self, arg__1: QPalette) -> QPalette: ...
    @overload
    def resolve(self, mask: int) -> None: ...
    @overload
    def resolve(self) -> int: ...
    @overload
    def setBrush(self, cg: QPalette.ColorGroup, cr: QPalette.ColorRole, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def setBrush(self, cr: QPalette.ColorRole, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    @overload
    def setColor(self, cg: QPalette.ColorGroup, cr: QPalette.ColorRole, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setColor(self, cr: QPalette.ColorRole, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setColorGroup(self, cr: QPalette.ColorGroup, windowText: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], button: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], light: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], dark: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], mid: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], text: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], bright_text: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], base: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], window: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setCurrentColorGroup(self, cg: QPalette.ColorGroup) -> None: ...
    def shadow(self) -> QBrush: ...
    def swap(self, other: QPalette) -> None: ...
    def text(self) -> QBrush: ...
    def toolTipBase(self) -> QBrush: ...
    def toolTipText(self) -> QBrush: ...
    def window(self) -> QBrush: ...
    def windowText(self) -> QBrush: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, ds: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, ds: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QPdfWriter(PySide2.QtCore.QObject, QPagedPaintDevice):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, device: PySide2.QtCore.QIODevice, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, filename: str, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addFileAttachment(self, fileName: str, data: typing.Union[PySide2.QtCore.QByteArray,bytes], mimeType: str = ...) -> None: ...
    def creator(self) -> str: ...
    def documentXmpMetadata(self) -> PySide2.QtCore.QByteArray: ...
    def metric(self, id: QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def paintEngine(self) -> QPaintEngine: ...
    def pdfVersion(self) -> QPagedPaintDevice.PdfVersion: ...
    def resolution(self) -> int: ...
    def setCreator(self, creator: str) -> None: ...
    def setDocumentXmpMetadata(self, xmpMetadata: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setMargins(self, m: QPagedPaintDevice.Margins) -> None: ...
    def setPageSize(self, size: QPagedPaintDevice.PageSize) -> None: ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setPdfVersion(self, version: QPagedPaintDevice.PdfVersion) -> None: ...
    def setResolution(self, resolution: int) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...

class QPen(shiboken2.Object):
    @overload
    def __init__(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient], width: float, s: PySide2.QtCore.Qt.PenStyle = ..., c: PySide2.QtCore.Qt.PenCapStyle = ..., j: PySide2.QtCore.Qt.PenJoinStyle = ...) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.Qt.PenStyle) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def __init__(self, pen: QPen) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def brush(self) -> QBrush: ...
    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def color(self) -> QColor: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def isCosmetic(self) -> bool: ...
    def isSolid(self) -> bool: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setCapStyle(self, pcs: PySide2.QtCore.Qt.PenCapStyle) -> None: ...
    def setColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setCosmetic(self, cosmetic: bool) -> None: ...
    def setDashOffset(self, doffset: float) -> None: ...
    def setDashPattern(self, pattern: typing.List[float]) -> None: ...
    def setJoinStyle(self, pcs: PySide2.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, limit: float) -> None: ...
    def setStyle(self, arg__1: PySide2.QtCore.Qt.PenStyle) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def setWidthF(self, width: float) -> None: ...
    def style(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def swap(self, other: QPen) -> None: ...
    def width(self) -> int: ...
    def widthF(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QPicture(QPaintDevice):
    @overload
    def __init__(self, arg__1: QPicture) -> None: ...
    @overload
    def __init__(self, formatVersion: int = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def data(self) -> bytes: ...
    def devType(self) -> int: ...
    @classmethod
    def inputFormatList(cls) -> typing.List[str]: ...
    @classmethod
    def inputFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def isNull(self) -> bool: ...
    @overload
    def load(self, dev: PySide2.QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def metric(self, m: QPaintDevice.PaintDeviceMetric) -> int: ...
    @classmethod
    def outputFormatList(cls) -> typing.List[str]: ...
    @classmethod
    def outputFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def paintEngine(self) -> QPaintEngine: ...
    @classmethod
    def pictureFormat(cls, fileName: str) -> bytes: ...
    def play(self, p: QPainter) -> bool: ...
    @overload
    def save(self, dev: PySide2.QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def setBoundingRect(self, r: PySide2.QtCore.QRect) -> None: ...
    def setData(self, data: bytes, size: int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: QPicture) -> None: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QPictureIO(shiboken2.Object):
    @overload
    def __init__(self, fileName: str, format: bytes) -> None: ...
    @overload
    def __init__(self, ioDevice: PySide2.QtCore.QIODevice, format: bytes) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> bytes: ...
    def gamma(self) -> float: ...
    @classmethod
    def inputFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def ioDevice(self) -> PySide2.QtCore.QIODevice: ...
    @classmethod
    def outputFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def parameters(self) -> bytes: ...
    def picture(self) -> QPicture: ...
    @overload
    @classmethod
    def pictureFormat(cls, arg__1: PySide2.QtCore.QIODevice) -> PySide2.QtCore.QByteArray: ...
    @overload
    @classmethod
    def pictureFormat(cls, fileName: str) -> PySide2.QtCore.QByteArray: ...
    def quality(self) -> int: ...
    def read(self) -> bool: ...
    def setDescription(self, arg__1: str) -> None: ...
    def setFileName(self, arg__1: str) -> None: ...
    def setFormat(self, arg__1: bytes) -> None: ...
    def setGamma(self, arg__1: float) -> None: ...
    def setIODevice(self, arg__1: PySide2.QtCore.QIODevice) -> None: ...
    def setParameters(self, arg__1: bytes) -> None: ...
    def setPicture(self, arg__1: QPicture) -> None: ...
    def setQuality(self, arg__1: int) -> None: ...
    def setStatus(self, arg__1: int) -> None: ...
    def status(self) -> int: ...
    def write(self) -> bool: ...

class QPixelFormat(shiboken2.Object):
    class AlphaPosition:
        AtBeginning: typing.ClassVar[QPixelFormat.AlphaPosition] = ...
        AtEnd: typing.ClassVar[QPixelFormat.AlphaPosition] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPosition: ...

    class AlphaPremultiplied:
        NotPremultiplied: typing.ClassVar[QPixelFormat.AlphaPremultiplied] = ...
        Premultiplied: typing.ClassVar[QPixelFormat.AlphaPremultiplied] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaPremultiplied: ...

    class AlphaUsage:
        IgnoresAlpha: typing.ClassVar[QPixelFormat.AlphaUsage] = ...
        UsesAlpha: typing.ClassVar[QPixelFormat.AlphaUsage] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.AlphaUsage: ...

    class ByteOrder:
        BigEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
        CurrentSystemEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
        LittleEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.ByteOrder: ...

    class ColorModel:
        Alpha: typing.ClassVar[QPixelFormat.ColorModel] = ...
        BGR: typing.ClassVar[QPixelFormat.ColorModel] = ...
        CMYK: typing.ClassVar[QPixelFormat.ColorModel] = ...
        Grayscale: typing.ClassVar[QPixelFormat.ColorModel] = ...
        HSL: typing.ClassVar[QPixelFormat.ColorModel] = ...
        HSV: typing.ClassVar[QPixelFormat.ColorModel] = ...
        Indexed: typing.ClassVar[QPixelFormat.ColorModel] = ...
        RGB: typing.ClassVar[QPixelFormat.ColorModel] = ...
        YUV: typing.ClassVar[QPixelFormat.ColorModel] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.ColorModel: ...

    class TypeInterpretation:
        FloatingPoint: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
        UnsignedByte: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
        UnsignedInteger: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
        UnsignedShort: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.TypeInterpretation: ...

    class YUVLayout:
        IMC1: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        IMC2: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        IMC3: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        IMC4: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        NV12: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        NV21: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        UYVY: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        Y16: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        Y8: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUV411: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUV420P: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUV420SP: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUV422: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUV444: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YUYV: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        YV12: typing.ClassVar[QPixelFormat.YUVLayout] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __and__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __rand__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __ror__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __sub__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
        def __xor__(self, other: typing.SupportsInt) -> QPixelFormat.YUVLayout: ...
    Alpha: typing.ClassVar[QPixelFormat.ColorModel] = ...
    AtBeginning: typing.ClassVar[QPixelFormat.AlphaPosition] = ...
    AtEnd: typing.ClassVar[QPixelFormat.AlphaPosition] = ...
    BGR: typing.ClassVar[QPixelFormat.ColorModel] = ...
    BigEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
    CMYK: typing.ClassVar[QPixelFormat.ColorModel] = ...
    CurrentSystemEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
    FloatingPoint: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
    Grayscale: typing.ClassVar[QPixelFormat.ColorModel] = ...
    HSL: typing.ClassVar[QPixelFormat.ColorModel] = ...
    HSV: typing.ClassVar[QPixelFormat.ColorModel] = ...
    IMC1: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    IMC2: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    IMC3: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    IMC4: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    IgnoresAlpha: typing.ClassVar[QPixelFormat.AlphaUsage] = ...
    Indexed: typing.ClassVar[QPixelFormat.ColorModel] = ...
    LittleEndian: typing.ClassVar[QPixelFormat.ByteOrder] = ...
    NV12: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    NV21: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    NotPremultiplied: typing.ClassVar[QPixelFormat.AlphaPremultiplied] = ...
    Premultiplied: typing.ClassVar[QPixelFormat.AlphaPremultiplied] = ...
    RGB: typing.ClassVar[QPixelFormat.ColorModel] = ...
    UYVY: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    UnsignedByte: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
    UnsignedInteger: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
    UnsignedShort: typing.ClassVar[QPixelFormat.TypeInterpretation] = ...
    UsesAlpha: typing.ClassVar[QPixelFormat.AlphaUsage] = ...
    Y16: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    Y8: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUV: typing.ClassVar[QPixelFormat.ColorModel] = ...
    YUV411: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUV420P: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUV420SP: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUV422: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUV444: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YUYV: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    YV12: typing.ClassVar[QPixelFormat.YUVLayout] = ...
    @overload
    def __init__(self, colorModel: QPixelFormat.ColorModel, firstSize: int, secondSize: int, thirdSize: int, fourthSize: int, fifthSize: int, alphaSize: int, alphaUsage: QPixelFormat.AlphaUsage, alphaPosition: QPixelFormat.AlphaPosition, premultiplied: QPixelFormat.AlphaPremultiplied, typeInterpretation: QPixelFormat.TypeInterpretation, byteOrder: QPixelFormat.ByteOrder = ..., subEnum: int = ...) -> None: ...
    @overload
    def __init__(self, QPixelFormat: QPixelFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alphaPosition(self) -> QPixelFormat.AlphaPosition: ...
    def alphaSize(self) -> int: ...
    def alphaUsage(self) -> QPixelFormat.AlphaUsage: ...
    def bitsPerPixel(self) -> int: ...
    def blackSize(self) -> int: ...
    def blueSize(self) -> int: ...
    def brightnessSize(self) -> int: ...
    def byteOrder(self) -> QPixelFormat.ByteOrder: ...
    def channelCount(self) -> int: ...
    def colorModel(self) -> QPixelFormat.ColorModel: ...
    def cyanSize(self) -> int: ...
    def greenSize(self) -> int: ...
    def hueSize(self) -> int: ...
    def lightnessSize(self) -> int: ...
    def magentaSize(self) -> int: ...
    def premultiplied(self) -> QPixelFormat.AlphaPremultiplied: ...
    def redSize(self) -> int: ...
    def saturationSize(self) -> int: ...
    def subEnum(self) -> int: ...
    def typeInterpretation(self) -> QPixelFormat.TypeInterpretation: ...
    def yellowSize(self) -> int: ...
    def yuvLayout(self) -> QPixelFormat.YUVLayout: ...
    def __copy__(self) -> None: ...

class QPixmap(QPaintDevice):
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @overload
    def __init__(self, arg__1: QPixmap) -> None: ...
    @overload
    def __init__(self, image: QImage) -> None: ...
    @overload
    def __init__(self, xpm: typing.Iterable[str]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def cacheKey(self) -> int: ...
    def convertFromImage(self, img: QImage, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    @overload
    def copy(self, x: int, y: int, width: int, height: int) -> QPixmap: ...
    @overload
    def copy(self, rect: PySide2.QtCore.QRect = ...) -> QPixmap: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> QBitmap: ...
    def createMaskFromColor(self, maskColor: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int], mode: PySide2.QtCore.Qt.MaskMode = ...) -> QBitmap: ...
    @classmethod
    def defaultDepth(cls) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    @overload
    def fill(self, device: QPaintDevice, xofs: int, yofs: int) -> None: ...
    @overload
    def fill(self, device: QPaintDevice, ofs: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def fill(self, fillColor: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int] = ...) -> None: ...
    @classmethod
    def fromImage(cls, image: QImage, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QPixmap: ...
    @classmethod
    def fromImageInPlace(cls, image: QImage, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QPixmap: ...
    @classmethod
    def fromImageReader(cls, imageReader: QImageReader, flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> QPixmap: ...
    @overload
    @classmethod
    def grabWidget(cls, widget: PySide2.QtCore.QObject, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QPixmap: ...
    @overload
    @classmethod
    def grabWidget(cls, widget: PySide2.QtCore.QObject, rect: PySide2.QtCore.QRect) -> QPixmap: ...
    @classmethod
    def grabWindow(cls, arg__1: int, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QPixmap: ...
    def hasAlpha(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def isNull(self) -> bool: ...
    def isQBitmap(self) -> bool: ...
    def load(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    @overload
    def loadFromData(self, buf: bytes, len: int, format: typing.Optional[str] = ..., flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    @overload
    def loadFromData(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes], format: typing.Optional[str] = ..., flags: typing.Union[PySide2.QtCore.Qt.ImageConversionFlags,PySide2.QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    def mask(self) -> QBitmap: ...
    def metric(self, arg__1: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    @overload
    def save(self, device: PySide2.QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def scaled(self, w: int, h: int, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    @overload
    def scaled(self, s: PySide2.QtCore.QSize, aspectMode: PySide2.QtCore.Qt.AspectRatioMode = ..., mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    def scaledToHeight(self, h: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    def scaledToWidth(self, w: int, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    @overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int, exposed: typing.Union[QRegion,None] = ...) -> None: ...
    @overload
    def scroll(self, dx: int, dy: int, rect: PySide2.QtCore.QRect, exposed: typing.Union[QRegion,None] = ...) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setMask(self, arg__1: QBitmap) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def swap(self, other: QPixmap) -> None: ...
    def toImage(self) -> QImage: ...
    @overload
    def transformed(self, arg__1: QMatrix, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    @overload
    def transformed(self, arg__1: QTransform, mode: PySide2.QtCore.Qt.TransformationMode = ...) -> QPixmap: ...
    @overload
    @classmethod
    def trueMatrix(cls, m: QMatrix, w: int, h: int) -> QMatrix: ...
    @overload
    @classmethod
    def trueMatrix(cls, m: QTransform, w: int, h: int) -> QTransform: ...
    def width(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QPixmapCache(shiboken2.Object):
    class Key(shiboken2.Object):
        @overload
        def __init__(self, other: QPixmapCache.Key) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def isValid(self) -> bool: ...
        def swap(self, other: QPixmapCache.Key) -> None: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
    def __init__(self) -> None: ...
    @classmethod
    def cacheLimit(cls) -> int: ...
    @classmethod
    def clear(cls) -> None: ...
    def find(self, arg__1: QPixmapCache.Key) -> None: ...
    @overload
    @classmethod
    def insert(cls, key: str, pixmap: QPixmap) -> bool: ...
    @overload
    @classmethod
    def insert(cls, pixmap: QPixmap) -> QPixmapCache.Key: ...
    @overload
    @classmethod
    def remove(cls, key: QPixmapCache.Key) -> None: ...
    @overload
    @classmethod
    def remove(cls, key: str) -> None: ...
    @classmethod
    def replace(cls, key: QPixmapCache.Key, pixmap: QPixmap) -> bool: ...
    @classmethod
    def setCacheLimit(cls, arg__1: int) -> None: ...

class QPointingDeviceUniqueId(shiboken2.Object):
    @overload
    def __init__(self, QPointingDeviceUniqueId: QPointingDeviceUniqueId) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def fromNumericId(cls, id: int) -> QPointingDeviceUniqueId: ...
    def isValid(self) -> bool: ...
    def numericId(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPolygon(shiboken2.Object):
    @overload
    def __init__(self, r: PySide2.QtCore.QRect, closed: bool = ...) -> None: ...
    @overload
    def __init__(self, other: QPolygon) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def append(self, l: typing.List[PySide2.QtCore.QPoint]) -> None: ...
    @overload
    def append(self, t: PySide2.QtCore.QPoint) -> None: ...
    def at(self, i: int) -> PySide2.QtCore.QPoint: ...
    def back(self) -> PySide2.QtCore.QPoint: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide2.QtCore.QPoint: ...
    def constFirst(self) -> PySide2.QtCore.QPoint: ...
    def constLast(self) -> PySide2.QtCore.QPoint: ...
    def contains(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def containsPoint(self, pt: PySide2.QtCore.QPoint, fillRule: PySide2.QtCore.Qt.FillRule) -> bool: ...
    @overload
    def count(self, t: PySide2.QtCore.QPoint) -> int: ...
    @overload
    def count(self) -> int: ...
    def data(self) -> PySide2.QtCore.QPoint: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def fill(self, t: PySide2.QtCore.QPoint, size: int = ...) -> typing.List[PySide2.QtCore.QPoint]: ...
    def first(self) -> PySide2.QtCore.QPoint: ...
    @classmethod
    def fromList(cls, list: typing.Iterable[PySide2.QtCore.QPoint]) -> typing.List[PySide2.QtCore.QPoint]: ...
    def front(self) -> PySide2.QtCore.QPoint: ...
    def indexOf(self, t: PySide2.QtCore.QPoint, from_: int = ...) -> int: ...
    @overload
    def insert(self, i: int, n: int, t: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def insert(self, i: int, t: PySide2.QtCore.QPoint) -> None: ...
    def intersected(self, r: QPolygon) -> QPolygon: ...
    def intersects(self, r: QPolygon) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QPoint]) -> bool: ...
    def last(self) -> PySide2.QtCore.QPoint: ...
    def lastIndexOf(self, t: PySide2.QtCore.QPoint, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide2.QtCore.QPoint]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, t: PySide2.QtCore.QPoint) -> None: ...
    def push_back(self, t: PySide2.QtCore.QPoint) -> None: ...
    def push_front(self, t: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def remove(self, i: int, n: int) -> None: ...
    @overload
    def remove(self, i: int) -> None: ...
    def removeAll(self, t: PySide2.QtCore.QPoint) -> int: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QPoint) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def setSharable(self, sharable: bool) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    def squeeze(self) -> None: ...
    def startsWith(self, t: PySide2.QtCore.QPoint) -> bool: ...
    def subtracted(self, r: QPolygon) -> QPolygon: ...
    def swap(self, other: QPolygon) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide2.QtCore.QPoint: ...
    def takeFirst(self) -> PySide2.QtCore.QPoint: ...
    def takeLast(self) -> PySide2.QtCore.QPoint: ...
    def toList(self) -> typing.List[PySide2.QtCore.QPoint]: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, offset: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> QPolygon: ...
    @overload
    def translated(self, offset: PySide2.QtCore.QPoint) -> QPolygon: ...
    def united(self, r: QPolygon) -> QPolygon: ...
    @overload
    def value(self, i: int, defaultValue: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def value(self, i: int) -> PySide2.QtCore.QPoint: ...
    def __add__(self, l: typing.List[PySide2.QtCore.QPoint]) -> typing.List[PySide2.QtCore.QPoint]: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, t: PySide2.QtCore.QPoint) -> QPolygon: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    @overload
    def __lshift__(self, l: typing.List[PySide2.QtCore.QPoint]) -> QPolygon: ...
    @overload
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @overload
    def __lshift__(self, t: PySide2.QtCore.QPoint) -> QPolygon: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, m: QMatrix) -> QPolygon: ...
    @overload
    def __mul__(self, m: QTransform) -> QPolygon: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __setitem__(self, index, object) -> None: ...

class QPolygonF(shiboken2.Object):
    @overload
    def __init__(self, a: QPolygon) -> None: ...
    @overload
    def __init__(self, a: QPolygonF) -> None: ...
    @overload
    def __init__(self, r: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, v: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def append(self, l: typing.List[PySide2.QtCore.QPointF]) -> None: ...
    @overload
    def append(self, t: PySide2.QtCore.QPointF) -> None: ...
    def at(self, i: int) -> PySide2.QtCore.QPointF: ...
    def back(self) -> PySide2.QtCore.QPointF: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide2.QtCore.QPointF: ...
    def constFirst(self) -> PySide2.QtCore.QPointF: ...
    def constLast(self) -> PySide2.QtCore.QPointF: ...
    def contains(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def containsPoint(self, pt: PySide2.QtCore.QPointF, fillRule: PySide2.QtCore.Qt.FillRule) -> bool: ...
    @overload
    def count(self, t: PySide2.QtCore.QPointF) -> int: ...
    @overload
    def count(self) -> int: ...
    def data(self) -> PySide2.QtCore.QPointF: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def fill(self, t: PySide2.QtCore.QPointF, size: int = ...) -> typing.List[PySide2.QtCore.QPointF]: ...
    def first(self) -> PySide2.QtCore.QPointF: ...
    @classmethod
    def fromList(cls, list: typing.Iterable[PySide2.QtCore.QPointF]) -> typing.List[PySide2.QtCore.QPointF]: ...
    def front(self) -> PySide2.QtCore.QPointF: ...
    def indexOf(self, t: PySide2.QtCore.QPointF, from_: int = ...) -> int: ...
    @overload
    def insert(self, i: int, n: int, t: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def insert(self, i: int, t: PySide2.QtCore.QPointF) -> None: ...
    def intersected(self, r: QPolygonF) -> QPolygonF: ...
    def intersects(self, r: QPolygonF) -> bool: ...
    def isClosed(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[PySide2.QtCore.QPointF]) -> bool: ...
    def last(self) -> PySide2.QtCore.QPointF: ...
    def lastIndexOf(self, t: PySide2.QtCore.QPointF, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide2.QtCore.QPointF]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, t: PySide2.QtCore.QPointF) -> None: ...
    def push_back(self, t: PySide2.QtCore.QPointF) -> None: ...
    def push_front(self, t: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def remove(self, i: int, n: int) -> None: ...
    @overload
    def remove(self, i: int) -> None: ...
    def removeAll(self, t: PySide2.QtCore.QPointF) -> int: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def replace(self, i: int, t: PySide2.QtCore.QPointF) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def setSharable(self, sharable: bool) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    def squeeze(self) -> None: ...
    def startsWith(self, t: PySide2.QtCore.QPointF) -> bool: ...
    def subtracted(self, r: QPolygonF) -> QPolygonF: ...
    def swap(self, other: QPolygonF) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide2.QtCore.QPointF: ...
    def takeFirst(self) -> PySide2.QtCore.QPointF: ...
    def takeLast(self) -> PySide2.QtCore.QPointF: ...
    def toList(self) -> typing.List[PySide2.QtCore.QPointF]: ...
    def toPolygon(self) -> QPolygon: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> QPolygonF: ...
    @overload
    def translated(self, offset: PySide2.QtCore.QPointF) -> QPolygonF: ...
    def united(self, r: QPolygonF) -> QPolygonF: ...
    @overload
    def value(self, i: int, defaultValue: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def value(self, i: int) -> PySide2.QtCore.QPointF: ...
    def __add__(self, l: typing.List[PySide2.QtCore.QPointF]) -> typing.List[PySide2.QtCore.QPointF]: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, t: PySide2.QtCore.QPointF) -> typing.List[PySide2.QtCore.QPointF]: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, m: QMatrix) -> QPolygonF: ...
    @overload
    def __mul__(self, m: QTransform) -> QPolygonF: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __setitem__(self, index, object) -> None: ...

class QPyTextObject(PySide2.QtCore.QObject, QTextObjectInterface):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def drawObject(self, painter: QPainter, rect: PySide2.QtCore.QRectF, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> None: ...
    def intrinsicSize(self, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> PySide2.QtCore.QSizeF: ...

class QQuaternion(shiboken2.Object):
    @overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @overload
    def __init__(self, scalar: float, vector: QVector3D) -> None: ...
    @overload
    def __init__(self, vector: QVector4D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def conjugate(self) -> QQuaternion: ...
    def conjugated(self) -> QQuaternion: ...
    @classmethod
    def dotProduct(cls, q1: QQuaternion, q2: QQuaternion) -> float: ...
    @classmethod
    def fromAxes(cls, xAxis: QVector3D, yAxis: QVector3D, zAxis: QVector3D) -> QQuaternion: ...
    @overload
    @classmethod
    def fromAxisAndAngle(cls, x: float, y: float, z: float, angle: float) -> QQuaternion: ...
    @overload
    @classmethod
    def fromAxisAndAngle(cls, axis: QVector3D, angle: float) -> QQuaternion: ...
    @classmethod
    def fromDirection(cls, direction: QVector3D, up: QVector3D) -> QQuaternion: ...
    @overload
    @classmethod
    def fromEulerAngles(cls, pitch: float, yaw: float, roll: float) -> QQuaternion: ...
    @overload
    @classmethod
    def fromEulerAngles(cls, eulerAngles: QVector3D) -> QQuaternion: ...
    @classmethod
    def fromRotationMatrix(cls, rot3x3: QMatrix3x3) -> QQuaternion: ...
    def getAxes(self, xAxis: QVector3D, yAxis: QVector3D, zAxis: QVector3D) -> None: ...
    def inverted(self) -> QQuaternion: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @classmethod
    def nlerp(cls, q1: QQuaternion, q2: QQuaternion, t: float) -> QQuaternion: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QQuaternion: ...
    def rotatedVector(self, vector: QVector3D) -> QVector3D: ...
    @classmethod
    def rotationTo(cls, from_: QVector3D, to: QVector3D) -> QQuaternion: ...
    def scalar(self) -> float: ...
    def setScalar(self, scalar: float) -> None: ...
    @overload
    def setVector(self, x: float, y: float, z: float) -> None: ...
    @overload
    def setVector(self, vector: QVector3D) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    @classmethod
    def slerp(cls, q1: QQuaternion, q2: QQuaternion, t: float) -> QQuaternion: ...
    def toEulerAngles(self) -> QVector3D: ...
    def toRotationMatrix(self) -> QMatrix3x3: ...
    def toVector4D(self) -> QVector4D: ...
    def vector(self) -> QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...
    def __add__(self, q2: QQuaternion) -> QQuaternion: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, quaternion: QQuaternion) -> QQuaternion: ...
    @overload
    def __imul__(self, factor: float) -> QQuaternion: ...
    @overload
    def __imul__(self, quaternion: QQuaternion) -> QQuaternion: ...
    def __isub__(self, quaternion: QQuaternion) -> QQuaternion: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QQuaternion: ...
    @overload
    def __mul__(self, q2: QQuaternion) -> QQuaternion: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QQuaternion: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, q2: QQuaternion) -> QQuaternion: ...
    def __truediv__(self, other) -> typing.Any: ...

class QRadialGradient(QGradient):
    @overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...
    @overload
    def __init__(self, center: PySide2.QtCore.QPointF, centerRadius: float, focalPoint: PySide2.QtCore.QPointF, focalRadius: float) -> None: ...
    @overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float, focalPoint: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @overload
    def __init__(self, center: PySide2.QtCore.QPointF, radius: float) -> None: ...
    @overload
    def __init__(self, QRadialGradient: QRadialGradient) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def centerRadius(self) -> float: ...
    def focalPoint(self) -> PySide2.QtCore.QPointF: ...
    def focalRadius(self) -> float: ...
    def radius(self) -> float: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...
    @overload
    def setCenter(self, center: PySide2.QtCore.QPointF) -> None: ...
    def setCenterRadius(self, radius: float) -> None: ...
    @overload
    def setFocalPoint(self, x: float, y: float) -> None: ...
    @overload
    def setFocalPoint(self, focalPoint: PySide2.QtCore.QPointF) -> None: ...
    def setFocalRadius(self, radius: float) -> None: ...
    def setRadius(self, radius: float) -> None: ...
    def __copy__(self) -> None: ...

class QRasterWindow(QPaintDeviceWindow):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[QWindow,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: typing.Any = ..., transientParentChanged: typing.Callable = ..., visibility: QRasterWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def redirected(self, arg__1: PySide2.QtCore.QPoint) -> QPaintDevice: ...

class QRawFont(shiboken2.Object):
    class AntialiasingType:
        PixelAntialiasing: typing.ClassVar[QRawFont.AntialiasingType] = ...
        SubPixelAntialiasing: typing.ClassVar[QRawFont.AntialiasingType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __and__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __rand__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __ror__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __sub__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...
        def __xor__(self, other: typing.SupportsInt) -> QRawFont.AntialiasingType: ...

    class LayoutFlag:
        KernedAdvances: typing.ClassVar[QRawFont.LayoutFlag] = ...
        SeparateAdvances: typing.ClassVar[QRawFont.LayoutFlag] = ...
        UseDesignMetrics: typing.ClassVar[QRawFont.LayoutFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRawFont.LayoutFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...

    class LayoutFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRawFont.LayoutFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QRawFont.LayoutFlags: ...
    KernedAdvances: typing.ClassVar[QRawFont.LayoutFlag] = ...
    PixelAntialiasing: typing.ClassVar[QRawFont.AntialiasingType] = ...
    SeparateAdvances: typing.ClassVar[QRawFont.LayoutFlag] = ...
    SubPixelAntialiasing: typing.ClassVar[QRawFont.AntialiasingType] = ...
    UseDesignMetrics: typing.ClassVar[QRawFont.LayoutFlag] = ...
    @overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: QFont.HintingPreference = ...) -> None: ...
    @overload
    def __init__(self, fontData: typing.Union[PySide2.QtCore.QByteArray,bytes], pixelSize: float, hintingPreference: QFont.HintingPreference = ...) -> None: ...
    @overload
    def __init__(self, other: QRawFont) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.List[int], layoutFlags: typing.Union[QRawFont.LayoutFlags,QRawFont.LayoutFlag]) -> typing.List[PySide2.QtCore.QPointF]: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.List[int]) -> typing.List[PySide2.QtCore.QPointF]: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: QRawFont.AntialiasingType = ..., transform: QTransform = ...) -> QImage: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def boundingRect(self, glyphIndex: int) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def familyName(self) -> str: ...
    def fontTable(self, tagName: bytes) -> PySide2.QtCore.QByteArray: ...
    @classmethod
    def fromFont(cls, font: QFont, writingSystem: QFontDatabase.WritingSystem = ...) -> QRawFont: ...
    def glyphIndexesForString(self, text: str) -> typing.List[int]: ...
    def hintingPreference(self) -> QFont.HintingPreference: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def lineThickness(self) -> float: ...
    def loadFromData(self, fontData: typing.Union[PySide2.QtCore.QByteArray,bytes], pixelSize: float, hintingPreference: QFont.HintingPreference) -> None: ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: QFont.HintingPreference) -> None: ...
    def maxCharWidth(self) -> float: ...
    def pathForGlyph(self, glyphIndex: int) -> QPainterPath: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float) -> None: ...
    def style(self) -> QFont.Style: ...
    def styleName(self) -> str: ...
    def supportedWritingSystems(self) -> typing.List[QFontDatabase.WritingSystem]: ...
    @overload
    def supportsCharacter(self, character: str) -> bool: ...
    @overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    def swap(self, other: QRawFont) -> None: ...
    def underlinePosition(self) -> float: ...
    def unitsPerEm(self) -> float: ...
    def weight(self) -> int: ...
    def xHeight(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QRegExpValidator(QValidator):
    regExpChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, rx: PySide2.QtCore.QRegExp, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., regExp: PySide2.QtCore.QRegExp = ..., regExpChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., regExp: PySide2.QtCore.QRegExp = ..., regExpChanged: typing.Callable = ...) -> None: ...
    def regExp(self) -> PySide2.QtCore.QRegExp: ...
    def setRegExp(self, rx: PySide2.QtCore.QRegExp) -> None: ...
    def validate(self, input: str, pos: int) -> QValidator.State: ...

class QRegion(shiboken2.Object):
    class RegionType:
        Ellipse: typing.ClassVar[QRegion.RegionType] = ...
        Rectangle: typing.ClassVar[QRegion.RegionType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __and__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __sub__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegion.RegionType: ...
    Ellipse: typing.ClassVar[QRegion.RegionType] = ...
    Rectangle: typing.ClassVar[QRegion.RegionType] = ...
    @overload
    def __init__(self, x: int, y: int, w: int, h: int, t: QRegion.RegionType = ...) -> None: ...
    @overload
    def __init__(self, pa: QPolygon, fillRule: PySide2.QtCore.Qt.FillRule = ...) -> None: ...
    @overload
    def __init__(self, r: PySide2.QtCore.QRect, t: QRegion.RegionType = ...) -> None: ...
    @overload
    def __init__(self, bitmap: QBitmap) -> None: ...
    @overload
    def __init__(self, region: QRegion) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def begin(self) -> PySide2.QtCore.QRect: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def cbegin(self) -> PySide2.QtCore.QRect: ...
    def cend(self) -> PySide2.QtCore.QRect: ...
    @overload
    def contains(self, p: PySide2.QtCore.QPoint) -> bool: ...
    @overload
    def contains(self, r: PySide2.QtCore.QRect) -> bool: ...
    def end(self) -> PySide2.QtCore.QRect: ...
    @overload
    def intersected(self, r: PySide2.QtCore.QRect) -> QRegion: ...
    @overload
    def intersected(self, r: QRegion) -> QRegion: ...
    @overload
    def intersects(self, r: PySide2.QtCore.QRect) -> bool: ...
    @overload
    def intersects(self, r: QRegion) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def rectCount(self) -> int: ...
    def rects(self) -> typing.List[PySide2.QtCore.QRect]: ...
    def setRects(self, rect: PySide2.QtCore.QRect, num: int) -> None: ...
    def subtracted(self, r: QRegion) -> QRegion: ...
    def swap(self, other: QRegion) -> None: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, p: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> QRegion: ...
    @overload
    def translated(self, p: PySide2.QtCore.QPoint) -> QRegion: ...
    @overload
    def united(self, r: PySide2.QtCore.QRect) -> QRegion: ...
    @overload
    def united(self, r: QRegion) -> QRegion: ...
    def xored(self, r: QRegion) -> QRegion: ...
    @overload
    def __add__(self, r: PySide2.QtCore.QRect) -> QRegion: ...
    @overload
    def __add__(self, r: QRegion) -> QRegion: ...
    @overload
    def __and__(self, r: PySide2.QtCore.QRect) -> QRegion: ...
    @overload
    def __and__(self, r: QRegion) -> QRegion: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    @overload
    def __iadd__(self, r: PySide2.QtCore.QRect) -> QRegion: ...
    @overload
    def __iadd__(self, r: QRegion) -> QRegion: ...
    def __ior__(self, r: QRegion) -> QRegion: ...
    def __isub__(self, r: QRegion) -> QRegion: ...
    def __ixor__(self, r: QRegion) -> QRegion: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, m: QMatrix) -> QRegion: ...
    @overload
    def __mul__(self, m: QTransform) -> QRegion: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, r: QRegion) -> QRegion: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rand__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __ror__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rxor__(self, other) -> typing.Any: ...
    def __sub__(self, r: QRegion) -> QRegion: ...
    def __xor__(self, r: QRegion) -> QRegion: ...

class QRegularExpressionValidator(QValidator):
    regularExpressionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, re: PySide2.QtCore.QRegularExpression, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., regularExpression: PySide2.QtCore.QRegularExpression = ..., regularExpressionChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., changed: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., regularExpression: PySide2.QtCore.QRegularExpression = ..., regularExpressionChanged: typing.Callable = ...) -> None: ...
    def regularExpression(self) -> PySide2.QtCore.QRegularExpression: ...
    def setRegularExpression(self, re: PySide2.QtCore.QRegularExpression) -> None: ...
    def validate(self, input: str, pos: int) -> QValidator.State: ...

class QResizeEvent(PySide2.QtCore.QEvent):
    def __init__(self, size: PySide2.QtCore.QSize, oldSize: PySide2.QtCore.QSize) -> None: ...
    def oldSize(self) -> PySide2.QtCore.QSize: ...
    def size(self) -> PySide2.QtCore.QSize: ...

class QScreen(PySide2.QtCore.QObject):
    availableGeometryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    geometryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    logicalDotsPerInchChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    orientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    physicalDotsPerInchChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    physicalSizeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    primaryOrientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    refreshRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    virtualGeometryChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def angleBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation) -> int: ...
    def availableGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableSize(self) -> PySide2.QtCore.QSize: ...
    def availableVirtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableVirtualSize(self) -> PySide2.QtCore.QSize: ...
    def depth(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def grabWindow(self, window: int, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QPixmap: ...
    def isLandscape(self, orientation: PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def isPortrait(self, orientation: PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def manufacturer(self) -> str: ...
    def mapBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation, rect: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def model(self) -> str: ...
    def name(self) -> str: ...
    def nativeOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientationUpdateMask(self) -> typing.Union[PySide2.QtCore.Qt.ScreenOrientations,PySide2.QtCore.Qt.ScreenOrientation]: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalSize(self) -> PySide2.QtCore.QSizeF: ...
    def primaryOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def refreshRate(self) -> float: ...
    def serialNumber(self) -> str: ...
    def setOrientationUpdateMask(self, mask: typing.Union[PySide2.QtCore.Qt.ScreenOrientations,PySide2.QtCore.Qt.ScreenOrientation]) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def transformBetween(self, a: PySide2.QtCore.Qt.ScreenOrientation, b: PySide2.QtCore.Qt.ScreenOrientation, target: PySide2.QtCore.QRect) -> QTransform: ...
    def virtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def virtualSiblingAt(self, point: PySide2.QtCore.QPoint) -> QScreen: ...
    def virtualSiblings(self) -> typing.List[QScreen]: ...
    def virtualSize(self) -> PySide2.QtCore.QSize: ...

class QScrollEvent(PySide2.QtCore.QEvent):
    class ScrollState:
        ScrollFinished: typing.ClassVar[QScrollEvent.ScrollState] = ...
        ScrollStarted: typing.ClassVar[QScrollEvent.ScrollState] = ...
        ScrollUpdated: typing.ClassVar[QScrollEvent.ScrollState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __and__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __rand__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __ror__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __sub__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
        def __xor__(self, other: typing.SupportsInt) -> QScrollEvent.ScrollState: ...
    ScrollFinished: typing.ClassVar[QScrollEvent.ScrollState] = ...
    ScrollStarted: typing.ClassVar[QScrollEvent.ScrollState] = ...
    ScrollUpdated: typing.ClassVar[QScrollEvent.ScrollState] = ...
    def __init__(self, contentPos: PySide2.QtCore.QPointF, overshoot: PySide2.QtCore.QPointF, scrollState: QScrollEvent.ScrollState) -> None: ...
    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def overshootDistance(self) -> PySide2.QtCore.QPointF: ...
    def scrollState(self) -> QScrollEvent.ScrollState: ...

class QScrollPrepareEvent(PySide2.QtCore.QEvent):
    def __init__(self, startPos: PySide2.QtCore.QPointF) -> None: ...
    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def contentPosRange(self) -> PySide2.QtCore.QRectF: ...
    def setContentPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def setContentPosRange(self, rect: PySide2.QtCore.QRectF) -> None: ...
    def setViewportSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def startPos(self) -> PySide2.QtCore.QPointF: ...
    def viewportSize(self) -> PySide2.QtCore.QSizeF: ...

class QSessionManager(PySide2.QtCore.QObject):
    class RestartHint:
        RestartAnyway: typing.ClassVar[QSessionManager.RestartHint] = ...
        RestartIfRunning: typing.ClassVar[QSessionManager.RestartHint] = ...
        RestartImmediately: typing.ClassVar[QSessionManager.RestartHint] = ...
        RestartNever: typing.ClassVar[QSessionManager.RestartHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __and__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QSessionManager.RestartHint: ...
    RestartAnyway: typing.ClassVar[QSessionManager.RestartHint] = ...
    RestartIfRunning: typing.ClassVar[QSessionManager.RestartHint] = ...
    RestartImmediately: typing.ClassVar[QSessionManager.RestartHint] = ...
    RestartNever: typing.ClassVar[QSessionManager.RestartHint] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def cancel(self) -> None: ...
    def discardCommand(self) -> typing.List[str]: ...
    def isPhase2(self) -> bool: ...
    def release(self) -> None: ...
    def requestPhase2(self) -> None: ...
    def restartCommand(self) -> typing.List[str]: ...
    def restartHint(self) -> QSessionManager.RestartHint: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    def setDiscardCommand(self, arg__1: typing.Iterable[str]) -> None: ...
    @overload
    def setManagerProperty(self, name: str, value: str) -> None: ...
    @overload
    def setManagerProperty(self, name: str, value: typing.Iterable[str]) -> None: ...
    def setRestartCommand(self, arg__1: typing.Iterable[str]) -> None: ...
    def setRestartHint(self, arg__1: QSessionManager.RestartHint) -> None: ...

class QShortcutEvent(PySide2.QtCore.QEvent):
    def __init__(self, key: typing.Union[QKeySequence,str], id: int, ambiguous: bool = ...) -> None: ...
    def isAmbiguous(self) -> bool: ...
    def key(self) -> QKeySequence: ...
    def shortcutId(self) -> int: ...

class QShowEvent(PySide2.QtCore.QEvent):
    def __init__(self) -> None: ...

class QStandardItem(shiboken2.Object):
    class ItemType:
        Type: typing.ClassVar[QStandardItem.ItemType] = ...
        UserType: typing.ClassVar[QStandardItem.ItemType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __and__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __rand__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __ror__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __sub__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
        def __xor__(self, other: typing.SupportsInt) -> QStandardItem.ItemType: ...
    Type: typing.ClassVar[QStandardItem.ItemType] = ...
    UserType: typing.ClassVar[QStandardItem.ItemType] = ...
    @overload
    def __init__(self, icon: QIcon, text: str) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @overload
    def __init__(self, other: QStandardItem) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def appendColumn(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, item: QStandardItem) -> None: ...
    @overload
    def appendRow(self, items: typing.Iterable[QStandardItem]) -> None: ...
    def appendRows(self, items: typing.Iterable[QStandardItem]) -> None: ...
    def background(self) -> QBrush: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, row: int, column: int = ...) -> QStandardItem: ...
    def clearData(self) -> None: ...
    def clone(self) -> QStandardItem: ...
    def column(self) -> int: ...
    def columnCount(self) -> int: ...
    def data(self, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def font(self) -> QFont: ...
    def foreground(self) -> QBrush: ...
    def hasChildren(self) -> bool: ...
    def icon(self) -> QIcon: ...
    def index(self) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, items: typing.Iterable[QStandardItem]) -> None: ...
    def insertColumns(self, column: int, count: int) -> None: ...
    @overload
    def insertRow(self, row: int, item: QStandardItem) -> None: ...
    @overload
    def insertRow(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRows(self, row: int, count: int) -> None: ...
    @overload
    def insertRows(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    def isAutoTristate(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isDropEnabled(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isSelectable(self) -> bool: ...
    def isTristate(self) -> bool: ...
    def isUserTristate(self) -> bool: ...
    def model(self) -> QStandardItemModel: ...
    def parent(self) -> QStandardItem: ...
    def read(self, in_: PySide2.QtCore.QDataStream) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeColumns(self, column: int, count: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def removeRows(self, row: int, count: int) -> None: ...
    def row(self) -> int: ...
    def rowCount(self) -> int: ...
    def setAccessibleDescription(self, accessibleDescription: str) -> None: ...
    def setAccessibleText(self, accessibleText: str) -> None: ...
    def setAutoTristate(self, tristate: bool) -> None: ...
    def setBackground(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setCheckState(self, checkState: PySide2.QtCore.Qt.CheckState) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    @overload
    def setChild(self, row: int, column: int, item: QStandardItem) -> None: ...
    @overload
    def setChild(self, row: int, item: QStandardItem) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> None: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def setDropEnabled(self, dropEnabled: bool) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFlags(self, flags: typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]) -> None: ...
    def setFont(self, font: QFont) -> None: ...
    def setForeground(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setIcon(self, icon: QIcon) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def setSizeHint(self, sizeHint: PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, textAlignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setTristate(self, tristate: bool) -> None: ...
    def setUserTristate(self, tristate: bool) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def statusTip(self) -> str: ...
    def takeChild(self, row: int, column: int = ...) -> QStandardItem: ...
    def takeColumn(self, column: int) -> typing.List[QStandardItem]: ...
    def takeRow(self, row: int) -> typing.List[QStandardItem]: ...
    def text(self) -> str: ...
    def textAlignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def toolTip(self) -> str: ...
    def type(self) -> QStandardItem.ItemType: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide2.QtCore.QDataStream) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, out: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, in_: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QStandardItemModel(PySide2.QtCore.QAbstractItemModel):
    itemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, rows: int, columns: int, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., itemChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., sortRole: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., itemChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., sortRole: int = ...) -> None: ...
    def appendColumn(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, item: QStandardItem) -> None: ...
    @overload
    def appendRow(self, items: typing.Iterable[QStandardItem]) -> None: ...
    def clear(self) -> None: ...
    def clearItemData(self, index: PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide2.QtCore.QMimeData, action: PySide2.QtCore.Qt.DropAction, row: int, column: int, parent: PySide2.QtCore.QModelIndex) -> bool: ...
    def findItems(self, text: str, flags: typing.Union[PySide2.QtCore.Qt.MatchFlags,PySide2.QtCore.Qt.MatchFlag] = ..., column: int = ...) -> typing.List[QStandardItem]: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def horizontalHeaderItem(self, column: int) -> QStandardItem: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def indexFromItem(self, item: QStandardItem) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def insertColumn(self, column: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertColumn(self, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    @overload
    def insertRow(self, row: int, item: QStandardItem) -> None: ...
    @overload
    def insertRow(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRow(self, row: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def invisibleRootItem(self) -> QStandardItem: ...
    def item(self, row: int, column: int = ...) -> QStandardItem: ...
    def itemData(self, index: PySide2.QtCore.QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def itemFromIndex(self, index: PySide2.QtCore.QModelIndex) -> QStandardItem: ...
    def itemPrototype(self) -> QStandardItem: ...
    def mimeData(self, indexes: typing.List[PySide2.QtCore.QModelIndex]) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @overload
    def parent(self, child: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def removeColumns(self, column: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...
    def setHorizontalHeaderItem(self, column: int, item: QStandardItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    @overload
    def setItem(self, row: int, column: int, item: QStandardItem) -> None: ...
    @overload
    def setItem(self, row: int, item: QStandardItem) -> None: ...
    def setItemData(self, index: PySide2.QtCore.QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def setItemPrototype(self, item: QStandardItem) -> None: ...
    def setItemRoleNames(self, roleNames: typing.Dict[int,PySide2.QtCore.QByteArray]) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSortRole(self, role: PySide2.QtCore.Qt.ItemDataRole) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: QStandardItem) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def sibling(self, row: int, column: int, idx: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column: int, order: PySide2.QtCore.Qt.SortOrder = ...) -> None: ...
    def sortRole(self) -> int: ...
    def supportedDropActions(self) -> typing.Union[PySide2.QtCore.Qt.DropActions,PySide2.QtCore.Qt.DropAction]: ...
    def takeColumn(self, column: int) -> typing.List[QStandardItem]: ...
    def takeHorizontalHeaderItem(self, column: int) -> QStandardItem: ...
    def takeItem(self, row: int, column: int = ...) -> QStandardItem: ...
    def takeRow(self, row: int) -> typing.List[QStandardItem]: ...
    def takeVerticalHeaderItem(self, row: int) -> QStandardItem: ...
    def verticalHeaderItem(self, row: int) -> QStandardItem: ...

class QStaticText(shiboken2.Object):
    class PerformanceHint:
        AggressiveCaching: typing.ClassVar[QStaticText.PerformanceHint] = ...
        ModerateCaching: typing.ClassVar[QStaticText.PerformanceHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __and__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QStaticText.PerformanceHint: ...
    AggressiveCaching: typing.ClassVar[QStaticText.PerformanceHint] = ...
    ModerateCaching: typing.ClassVar[QStaticText.PerformanceHint] = ...
    @overload
    def __init__(self, other: QStaticText) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def performanceHint(self) -> QStaticText.PerformanceHint: ...
    def prepare(self, matrix: QTransform = ..., font: QFont = ...) -> None: ...
    def setPerformanceHint(self, performanceHint: QStaticText.PerformanceHint) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, textFormat: PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextOption(self, textOption: QTextOption) -> None: ...
    def setTextWidth(self, textWidth: float) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def swap(self, other: QStaticText) -> None: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textOption(self) -> QTextOption: ...
    def textWidth(self) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QStatusTipEvent(PySide2.QtCore.QEvent):
    def __init__(self, tip: str) -> None: ...
    def tip(self) -> str: ...

class QStyleHints(PySide2.QtCore.QObject):
    cursorFlashTimeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    keyboardInputIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mouseDoubleClickIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mousePressAndHoldIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    mouseQuickSelectionThresholdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    showShortcutsInContextMenusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    startDragDistanceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    startDragTimeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    tabFocusBehaviorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    useHoverEffectsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    wheelScrollLinesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def cursorFlashTime(self) -> int: ...
    def fontSmoothingGamma(self) -> float: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardInputInterval(self) -> int: ...
    def mouseDoubleClickDistance(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def passwordMaskCharacter(self) -> str: ...
    def passwordMaskDelay(self) -> int: ...
    def setCursorFlashTime(self, cursorFlashTime: int) -> None: ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def setKeyboardInputInterval(self, keyboardInputInterval: int) -> None: ...
    def setMouseDoubleClickInterval(self, mouseDoubleClickInterval: int) -> None: ...
    def setMousePressAndHoldInterval(self, mousePressAndHoldInterval: int) -> None: ...
    def setMouseQuickSelectionThreshold(self, threshold: int) -> None: ...
    def setShowShortcutsInContextMenus(self, showShortcutsInContextMenus: bool) -> None: ...
    def setStartDragDistance(self, startDragDistance: int) -> None: ...
    def setStartDragTime(self, startDragTime: int) -> None: ...
    def setTabFocusBehavior(self, tabFocusBehavior: PySide2.QtCore.Qt.TabFocusBehavior) -> None: ...
    def setUseHoverEffects(self, useHoverEffects: bool) -> None: ...
    def setWheelScrollLines(self, scrollLines: int) -> None: ...
    def showIsFullScreen(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    def singleClickActivation(self) -> bool: ...
    def startDragDistance(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def tabFocusBehavior(self) -> PySide2.QtCore.Qt.TabFocusBehavior: ...
    def touchDoubleTapDistance(self) -> int: ...
    def useHoverEffects(self) -> bool: ...
    def useRtlExtensions(self) -> bool: ...
    def wheelScrollLines(self) -> int: ...

class QSurface(shiboken2.Object):
    class SurfaceClass:
        Offscreen: typing.ClassVar[QSurface.SurfaceClass] = ...
        Window: typing.ClassVar[QSurface.SurfaceClass] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __and__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurface.SurfaceClass: ...

    class SurfaceType:
        MetalSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        OpenGLSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        OpenVGSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        RasterGLSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        RasterSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        VulkanSurface: typing.ClassVar[QSurface.SurfaceType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __and__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurface.SurfaceType: ...
    MetalSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    Offscreen: typing.ClassVar[QSurface.SurfaceClass] = ...
    OpenGLSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    OpenVGSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    RasterGLSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    RasterSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    VulkanSurface: typing.ClassVar[QSurface.SurfaceType] = ...
    Window: typing.ClassVar[QSurface.SurfaceClass] = ...
    m_type: typing.Any
    def __init__(self, type: QSurface.SurfaceClass) -> None: ...
    def format(self) -> QSurfaceFormat: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def supportsOpenGL(self) -> bool: ...
    def surfaceClass(self) -> QSurface.SurfaceClass: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> QSurface.SurfaceType: ...

class QSurfaceFormat(shiboken2.Object):
    class ColorSpace:
        DefaultColorSpace: typing.ClassVar[QSurfaceFormat.ColorSpace] = ...
        sRGBColorSpace: typing.ClassVar[QSurfaceFormat.ColorSpace] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.ColorSpace: ...

    class FormatOption:
        DebugContext: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
        DeprecatedFunctions: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
        ResetNotification: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
        StereoBuffers: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSurfaceFormat.FormatOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...

    class FormatOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSurfaceFormat.FormatOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.FormatOptions: ...

    class OpenGLContextProfile:
        CompatibilityProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
        CoreProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
        NoProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.OpenGLContextProfile: ...

    class RenderableType:
        DefaultRenderableType: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
        OpenGL: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
        OpenGLES: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
        OpenVG: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.RenderableType: ...

    class SwapBehavior:
        DefaultSwapBehavior: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
        DoubleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
        SingleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
        TripleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> QSurfaceFormat.SwapBehavior: ...
    CompatibilityProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
    CoreProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
    DebugContext: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
    DefaultColorSpace: typing.ClassVar[QSurfaceFormat.ColorSpace] = ...
    DefaultRenderableType: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
    DefaultSwapBehavior: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
    DeprecatedFunctions: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
    DoubleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
    NoProfile: typing.ClassVar[QSurfaceFormat.OpenGLContextProfile] = ...
    OpenGL: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
    OpenGLES: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
    OpenVG: typing.ClassVar[QSurfaceFormat.RenderableType] = ...
    ResetNotification: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
    SingleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
    StereoBuffers: typing.ClassVar[QSurfaceFormat.FormatOption] = ...
    TripleBuffer: typing.ClassVar[QSurfaceFormat.SwapBehavior] = ...
    sRGBColorSpace: typing.ClassVar[QSurfaceFormat.ColorSpace] = ...
    @overload
    def __init__(self, options: typing.Union[QSurfaceFormat.FormatOptions,QSurfaceFormat.FormatOption]) -> None: ...
    @overload
    def __init__(self, other: QSurfaceFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    def colorSpace(self) -> QSurfaceFormat.ColorSpace: ...
    @classmethod
    def defaultFormat(cls) -> QSurfaceFormat: ...
    def depthBufferSize(self) -> int: ...
    def greenBufferSize(self) -> int: ...
    def hasAlpha(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def options(self) -> typing.Union[QSurfaceFormat.FormatOptions,QSurfaceFormat.FormatOption]: ...
    def profile(self) -> QSurfaceFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def renderableType(self) -> QSurfaceFormat.RenderableType: ...
    def samples(self) -> int: ...
    def setAlphaBufferSize(self, size: int) -> None: ...
    def setBlueBufferSize(self, size: int) -> None: ...
    def setColorSpace(self, colorSpace: QSurfaceFormat.ColorSpace) -> None: ...
    @classmethod
    def setDefaultFormat(cls, format: QSurfaceFormat) -> None: ...
    def setDepthBufferSize(self, size: int) -> None: ...
    def setGreenBufferSize(self, size: int) -> None: ...
    def setMajorVersion(self, majorVersion: int) -> None: ...
    def setMinorVersion(self, minorVersion: int) -> None: ...
    @overload
    def setOption(self, option: QSurfaceFormat.FormatOption, on: bool = ...) -> None: ...
    @overload
    def setOption(self, opt: typing.Union[QSurfaceFormat.FormatOptions,QSurfaceFormat.FormatOption]) -> None: ...
    def setOptions(self, options: typing.Union[QSurfaceFormat.FormatOptions,QSurfaceFormat.FormatOption]) -> None: ...
    def setProfile(self, profile: QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size: int) -> None: ...
    def setRenderableType(self, type: QSurfaceFormat.RenderableType) -> None: ...
    def setSamples(self, numSamples: int) -> None: ...
    def setStencilBufferSize(self, size: int) -> None: ...
    def setStereo(self, enable: bool) -> None: ...
    def setSwapBehavior(self, behavior: QSurfaceFormat.SwapBehavior) -> None: ...
    def setSwapInterval(self, interval: int) -> None: ...
    def setVersion(self, major: int, minor: int) -> None: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapBehavior(self) -> QSurfaceFormat.SwapBehavior: ...
    def swapInterval(self) -> int: ...
    @overload
    def testOption(self, opt: typing.Union[QSurfaceFormat.FormatOptions,QSurfaceFormat.FormatOption]) -> bool: ...
    @overload
    def testOption(self, option: QSurfaceFormat.FormatOption) -> bool: ...
    def version(self) -> typing.Tuple[int,int]: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QSyntaxHighlighter(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def currentBlock(self) -> QTextBlock: ...
    def currentBlockState(self) -> int: ...
    def currentBlockUserData(self) -> QTextBlockUserData: ...
    def document(self) -> QTextDocument: ...
    def format(self, pos: int) -> QTextCharFormat: ...
    def highlightBlock(self, text: str) -> None: ...
    def previousBlockState(self) -> int: ...
    def rehighlight(self) -> None: ...
    def rehighlightBlock(self, block: QTextBlock) -> None: ...
    def setCurrentBlockState(self, newState: int) -> None: ...
    def setCurrentBlockUserData(self, data: QTextBlockUserData) -> None: ...
    def setDocument(self, doc: QTextDocument) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, font: QFont) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, format: QTextCharFormat) -> None: ...

class QTabletEvent(QInputEvent):
    class PointerType:
        Cursor: typing.ClassVar[QTabletEvent.PointerType] = ...
        Eraser: typing.ClassVar[QTabletEvent.PointerType] = ...
        Pen: typing.ClassVar[QTabletEvent.PointerType] = ...
        UnknownPointer: typing.ClassVar[QTabletEvent.PointerType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __and__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTabletEvent.PointerType: ...

    class TabletDevice:
        Airbrush: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        FourDMouse: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        NoDevice: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        Puck: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        RotationStylus: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        Stylus: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        XFreeEraser: typing.ClassVar[QTabletEvent.TabletDevice] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __and__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __rand__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __ror__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __sub__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
        def __xor__(self, other: typing.SupportsInt) -> QTabletEvent.TabletDevice: ...
    Airbrush: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    Cursor: typing.ClassVar[QTabletEvent.PointerType] = ...
    Eraser: typing.ClassVar[QTabletEvent.PointerType] = ...
    FourDMouse: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    NoDevice: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    Pen: typing.ClassVar[QTabletEvent.PointerType] = ...
    Puck: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    RotationStylus: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    Stylus: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    UnknownPointer: typing.ClassVar[QTabletEvent.PointerType] = ...
    XFreeEraser: typing.ClassVar[QTabletEvent.TabletDevice] = ...
    @overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], uniqueID: int, button: PySide2.QtCore.Qt.MouseButton, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]) -> None: ...
    @overload
    def __init__(self, t: PySide2.QtCore.QEvent.Type, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], uniqueID: int) -> None: ...
    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def device(self) -> QTabletEvent.TabletDevice: ...
    def deviceType(self) -> QTabletEvent.TabletDevice: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def hiResGlobalX(self) -> float: ...
    def hiResGlobalY(self) -> float: ...
    def pointerType(self) -> QTabletEvent.PointerType: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def x(self) -> int: ...
    def xTilt(self) -> int: ...
    def y(self) -> int: ...
    def yTilt(self) -> int: ...
    def z(self) -> int: ...

class QTextBlock(shiboken2.Object):
    class iterator(shiboken2.Object):
        @overload
        def __init__(self, o: QTextBlock.iterator) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def atEnd(self) -> bool: ...
        def fragment(self) -> QTextFragment: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __iadd__(self, arg__1: int) -> QTextBlock.iterator: ...
        def __isub__(self, arg__1: int) -> QTextBlock.iterator: ...
        def __iter__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __next__(self) -> object: ...
    @overload
    def __init__(self, o: QTextBlock) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def begin(self) -> QTextBlock.iterator: ...
    def blockFormat(self) -> QTextBlockFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def clearLayout(self) -> None: ...
    def contains(self, position: int) -> bool: ...
    def document(self) -> QTextDocument: ...
    def end(self) -> QTextBlock.iterator: ...
    def firstLineNumber(self) -> int: ...
    def fragmentIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def layout(self) -> QTextLayout: ...
    def length(self) -> int: ...
    def lineCount(self) -> int: ...
    def next(self) -> QTextBlock: ...
    def position(self) -> int: ...
    def previous(self) -> QTextBlock: ...
    def revision(self) -> int: ...
    def setLineCount(self, count: int) -> None: ...
    def setRevision(self, rev: int) -> None: ...
    def setUserData(self, data: QTextBlockUserData) -> None: ...
    def setUserState(self, state: int) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textFormats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def textList(self) -> QTextList: ...
    def userData(self) -> QTextBlockUserData: ...
    def userState(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iter__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTextBlockFormat(QTextFormat):
    class LineHeightTypes:
        FixedHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
        LineDistanceHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
        MinimumHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
        ProportionalHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
        SingleHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __and__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextBlockFormat.LineHeightTypes: ...

    class MarkerType:
        Checked: typing.ClassVar[QTextBlockFormat.MarkerType] = ...
        NoMarker: typing.ClassVar[QTextBlockFormat.MarkerType] = ...
        Unchecked: typing.ClassVar[QTextBlockFormat.MarkerType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextBlockFormat.MarkerType: ...
    FixedHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
    LineDistanceHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
    MinimumHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
    ProportionalHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
    SingleHeight: typing.ClassVar[QTextBlockFormat.LineHeightTypes] = ...
    @overload
    def __init__(self, QTextBlockFormat: QTextBlockFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def bottomMargin(self) -> float: ...
    def headingLevel(self) -> int: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    @overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float: ...
    @overload
    def lineHeight(self) -> float: ...
    def lineHeightType(self) -> int: ...
    def marker(self) -> QTextBlockFormat.MarkerType: ...
    def nonBreakableLines(self) -> bool: ...
    def pageBreakPolicy(self) -> typing.Union[QTextFormat.PageBreakFlags,QTextFormat.PageBreakFlag]: ...
    def rightMargin(self) -> float: ...
    def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    def setHeadingLevel(self, alevel: int) -> None: ...
    def setIndent(self, indent: int) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setLineHeight(self, height: float, heightType: int) -> None: ...
    def setMarker(self, marker: QTextBlockFormat.MarkerType) -> None: ...
    def setNonBreakableLines(self, b: bool) -> None: ...
    def setPageBreakPolicy(self, flags: typing.Union[QTextFormat.PageBreakFlags,QTextFormat.PageBreakFlag]) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTabPositions(self, tabs: typing.Iterable[QTextOption.Tab]) -> None: ...
    def setTextIndent(self, aindent: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    def tabPositions(self) -> typing.List[QTextOption.Tab]: ...
    def textIndent(self) -> float: ...
    def topMargin(self) -> float: ...
    def __copy__(self) -> None: ...

class QTextBlockGroup(QTextObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def blockFormatChanged(self, block: QTextBlock) -> None: ...
    def blockInserted(self, block: QTextBlock) -> None: ...
    def blockList(self) -> typing.List[QTextBlock]: ...
    def blockRemoved(self, block: QTextBlock) -> None: ...

class QTextBlockUserData(shiboken2.Object):
    def __init__(self) -> None: ...

class QTextCharFormat(QTextFormat):
    class FontPropertiesInheritanceBehavior:
        FontPropertiesAll: typing.ClassVar[QTextCharFormat.FontPropertiesInheritanceBehavior] = ...
        FontPropertiesSpecifiedOnly: typing.ClassVar[QTextCharFormat.FontPropertiesInheritanceBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCharFormat.FontPropertiesInheritanceBehavior: ...

    class UnderlineStyle:
        DashDotDotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        DashDotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        DashUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        DotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        NoUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        SingleUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        SpellCheckUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        WaveUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCharFormat.UnderlineStyle: ...

    class VerticalAlignment:
        AlignBaseline: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignBottom: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignMiddle: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignNormal: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignSubScript: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignSuperScript: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        AlignTop: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCharFormat.VerticalAlignment: ...
    AlignBaseline: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignBottom: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignMiddle: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignNormal: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignSubScript: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignSuperScript: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    AlignTop: typing.ClassVar[QTextCharFormat.VerticalAlignment] = ...
    DashDotDotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    DashDotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    DashUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    DotLine: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    FontPropertiesAll: typing.ClassVar[QTextCharFormat.FontPropertiesInheritanceBehavior] = ...
    FontPropertiesSpecifiedOnly: typing.ClassVar[QTextCharFormat.FontPropertiesInheritanceBehavior] = ...
    NoUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    SingleUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    SpellCheckUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    WaveUnderline: typing.ClassVar[QTextCharFormat.UnderlineStyle] = ...
    @overload
    def __init__(self, QTextCharFormat: QTextCharFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def anchorHref(self) -> str: ...
    def anchorName(self) -> str: ...
    def anchorNames(self) -> typing.List[str]: ...
    def font(self) -> QFont: ...
    def fontCapitalization(self) -> QFont.Capitalization: ...
    def fontFamilies(self) -> typing.Any: ...
    def fontFamily(self) -> str: ...
    def fontFixedPitch(self) -> bool: ...
    def fontHintingPreference(self) -> QFont.HintingPreference: ...
    def fontItalic(self) -> bool: ...
    def fontKerning(self) -> bool: ...
    def fontLetterSpacing(self) -> float: ...
    def fontLetterSpacingType(self) -> QFont.SpacingType: ...
    def fontOverline(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontStretch(self) -> int: ...
    def fontStrikeOut(self) -> bool: ...
    def fontStyleHint(self) -> QFont.StyleHint: ...
    def fontStyleName(self) -> typing.Any: ...
    def fontStyleStrategy(self) -> QFont.StyleStrategy: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontWordSpacing(self) -> float: ...
    def isAnchor(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setAnchor(self, anchor: bool) -> None: ...
    def setAnchorHref(self, value: str) -> None: ...
    def setAnchorName(self, name: str) -> None: ...
    def setAnchorNames(self, names: typing.Iterable[str]) -> None: ...
    @overload
    def setFont(self, font: QFont, behavior: QTextCharFormat.FontPropertiesInheritanceBehavior) -> None: ...
    @overload
    def setFont(self, font: QFont) -> None: ...
    def setFontCapitalization(self, capitalization: QFont.Capitalization) -> None: ...
    def setFontFamilies(self, families: typing.Iterable[str]) -> None: ...
    def setFontFamily(self, family: str) -> None: ...
    def setFontFixedPitch(self, fixedPitch: bool) -> None: ...
    def setFontHintingPreference(self, hintingPreference: QFont.HintingPreference) -> None: ...
    def setFontItalic(self, italic: bool) -> None: ...
    def setFontKerning(self, enable: bool) -> None: ...
    def setFontLetterSpacing(self, spacing: float) -> None: ...
    def setFontLetterSpacingType(self, letterSpacingType: QFont.SpacingType) -> None: ...
    def setFontOverline(self, overline: bool) -> None: ...
    def setFontPointSize(self, size: float) -> None: ...
    def setFontStretch(self, factor: int) -> None: ...
    def setFontStrikeOut(self, strikeOut: bool) -> None: ...
    def setFontStyleHint(self, hint: QFont.StyleHint, strategy: QFont.StyleStrategy = ...) -> None: ...
    def setFontStyleName(self, styleName: str) -> None: ...
    def setFontStyleStrategy(self, strategy: QFont.StyleStrategy) -> None: ...
    def setFontUnderline(self, underline: bool) -> None: ...
    def setFontWeight(self, weight: typing.SupportsInt) -> None: ...
    def setFontWordSpacing(self, spacing: float) -> None: ...
    def setTableCellColumnSpan(self, tableCellColumnSpan: int) -> None: ...
    def setTableCellRowSpan(self, tableCellRowSpan: int) -> None: ...
    def setTextOutline(self, pen: QPen) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setUnderlineColor(self, color: typing.Union[QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def setUnderlineStyle(self, style: QTextCharFormat.UnderlineStyle) -> None: ...
    def setVerticalAlignment(self, alignment: QTextCharFormat.VerticalAlignment) -> None: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def textOutline(self) -> QPen: ...
    def toolTip(self) -> str: ...
    def underlineColor(self) -> QColor: ...
    def underlineStyle(self) -> QTextCharFormat.UnderlineStyle: ...
    def verticalAlignment(self) -> QTextCharFormat.VerticalAlignment: ...
    def __copy__(self) -> None: ...

class QTextCursor(shiboken2.Object):
    class MoveMode:
        KeepAnchor: typing.ClassVar[QTextCursor.MoveMode] = ...
        MoveAnchor: typing.ClassVar[QTextCursor.MoveMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCursor.MoveMode: ...

    class MoveOperation:
        Down: typing.ClassVar[QTextCursor.MoveOperation] = ...
        End: typing.ClassVar[QTextCursor.MoveOperation] = ...
        EndOfBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
        EndOfLine: typing.ClassVar[QTextCursor.MoveOperation] = ...
        EndOfWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
        Left: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NextBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NextCell: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NextCharacter: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NextRow: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NextWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
        NoMove: typing.ClassVar[QTextCursor.MoveOperation] = ...
        PreviousBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
        PreviousCell: typing.ClassVar[QTextCursor.MoveOperation] = ...
        PreviousCharacter: typing.ClassVar[QTextCursor.MoveOperation] = ...
        PreviousRow: typing.ClassVar[QTextCursor.MoveOperation] = ...
        PreviousWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
        Right: typing.ClassVar[QTextCursor.MoveOperation] = ...
        Start: typing.ClassVar[QTextCursor.MoveOperation] = ...
        StartOfBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
        StartOfLine: typing.ClassVar[QTextCursor.MoveOperation] = ...
        StartOfWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
        Up: typing.ClassVar[QTextCursor.MoveOperation] = ...
        WordLeft: typing.ClassVar[QTextCursor.MoveOperation] = ...
        WordRight: typing.ClassVar[QTextCursor.MoveOperation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCursor.MoveOperation: ...

    class SelectionType:
        BlockUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
        Document: typing.ClassVar[QTextCursor.SelectionType] = ...
        LineUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
        WordUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCursor.SelectionType: ...
    BlockUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
    Document: typing.ClassVar[QTextCursor.SelectionType] = ...
    Down: typing.ClassVar[QTextCursor.MoveOperation] = ...
    End: typing.ClassVar[QTextCursor.MoveOperation] = ...
    EndOfBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
    EndOfLine: typing.ClassVar[QTextCursor.MoveOperation] = ...
    EndOfWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
    KeepAnchor: typing.ClassVar[QTextCursor.MoveMode] = ...
    Left: typing.ClassVar[QTextCursor.MoveOperation] = ...
    LineUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
    MoveAnchor: typing.ClassVar[QTextCursor.MoveMode] = ...
    NextBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
    NextCell: typing.ClassVar[QTextCursor.MoveOperation] = ...
    NextCharacter: typing.ClassVar[QTextCursor.MoveOperation] = ...
    NextRow: typing.ClassVar[QTextCursor.MoveOperation] = ...
    NextWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
    NoMove: typing.ClassVar[QTextCursor.MoveOperation] = ...
    PreviousBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
    PreviousCell: typing.ClassVar[QTextCursor.MoveOperation] = ...
    PreviousCharacter: typing.ClassVar[QTextCursor.MoveOperation] = ...
    PreviousRow: typing.ClassVar[QTextCursor.MoveOperation] = ...
    PreviousWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
    Right: typing.ClassVar[QTextCursor.MoveOperation] = ...
    Start: typing.ClassVar[QTextCursor.MoveOperation] = ...
    StartOfBlock: typing.ClassVar[QTextCursor.MoveOperation] = ...
    StartOfLine: typing.ClassVar[QTextCursor.MoveOperation] = ...
    StartOfWord: typing.ClassVar[QTextCursor.MoveOperation] = ...
    Up: typing.ClassVar[QTextCursor.MoveOperation] = ...
    WordLeft: typing.ClassVar[QTextCursor.MoveOperation] = ...
    WordRight: typing.ClassVar[QTextCursor.MoveOperation] = ...
    WordUnderCursor: typing.ClassVar[QTextCursor.SelectionType] = ...
    @overload
    def __init__(self, block: QTextBlock) -> None: ...
    @overload
    def __init__(self, cursor: QTextCursor) -> None: ...
    @overload
    def __init__(self, document: QTextDocument) -> None: ...
    @overload
    def __init__(self, frame: QTextFrame) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def anchor(self) -> int: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def beginEditBlock(self) -> None: ...
    def block(self) -> QTextBlock: ...
    def blockCharFormat(self) -> QTextCharFormat: ...
    def blockFormat(self) -> QTextBlockFormat: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def clearSelection(self) -> None: ...
    def columnNumber(self) -> int: ...
    @overload
    def createList(self, format: QTextListFormat) -> QTextList: ...
    @overload
    def createList(self, style: QTextListFormat.Style) -> QTextList: ...
    def currentFrame(self) -> QTextFrame: ...
    def currentList(self) -> QTextList: ...
    def currentTable(self) -> QTextTable: ...
    def deleteChar(self) -> None: ...
    def deletePreviousChar(self) -> None: ...
    def document(self) -> QTextDocument: ...
    def endEditBlock(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    @overload
    def insertBlock(self, format: QTextBlockFormat, charFormat: QTextCharFormat) -> None: ...
    @overload
    def insertBlock(self, format: QTextBlockFormat) -> None: ...
    @overload
    def insertBlock(self) -> None: ...
    def insertFragment(self, fragment: QTextDocumentFragment) -> None: ...
    def insertFrame(self, format: QTextFrameFormat) -> QTextFrame: ...
    def insertHtml(self, html: str) -> None: ...
    @overload
    def insertImage(self, format: QTextImageFormat, alignment: QTextFrameFormat.Position) -> None: ...
    @overload
    def insertImage(self, image: QImage, name: str = ...) -> None: ...
    @overload
    def insertImage(self, format: QTextImageFormat) -> None: ...
    @overload
    def insertImage(self, name: str) -> None: ...
    @overload
    def insertList(self, format: QTextListFormat) -> QTextList: ...
    @overload
    def insertList(self, style: QTextListFormat.Style) -> QTextList: ...
    @overload
    def insertTable(self, rows: int, cols: int, format: QTextTableFormat) -> QTextTable: ...
    @overload
    def insertTable(self, rows: int, cols: int) -> QTextTable: ...
    @overload
    def insertText(self, text: str, format: QTextCharFormat) -> None: ...
    @overload
    def insertText(self, text: str) -> None: ...
    def isCopyOf(self, other: QTextCursor) -> bool: ...
    def isNull(self) -> bool: ...
    def joinPreviousEditBlock(self) -> None: ...
    def keepPositionOnInsert(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: QTextCharFormat) -> None: ...
    def mergeBlockFormat(self, modifier: QTextBlockFormat) -> None: ...
    def mergeCharFormat(self, modifier: QTextCharFormat) -> None: ...
    def movePosition(self, op: QTextCursor.MoveOperation, arg__2: QTextCursor.MoveMode = ..., n: int = ...) -> bool: ...
    def position(self) -> int: ...
    def positionInBlock(self) -> int: ...
    def removeSelectedText(self) -> None: ...
    def select(self, selection: QTextCursor.SelectionType) -> None: ...
    def selectedTableCells(self) -> typing.Tuple[int,int,int,int]: ...
    def selectedText(self) -> str: ...
    def selection(self) -> QTextDocumentFragment: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setBlockCharFormat(self, format: QTextCharFormat) -> None: ...
    def setBlockFormat(self, format: QTextBlockFormat) -> None: ...
    def setCharFormat(self, format: QTextCharFormat) -> None: ...
    def setKeepPositionOnInsert(self, b: bool) -> None: ...
    def setPosition(self, pos: int, mode: QTextCursor.MoveMode = ...) -> None: ...
    def setVerticalMovementX(self, x: int) -> None: ...
    def setVisualNavigation(self, b: bool) -> None: ...
    def swap(self, other: QTextCursor) -> None: ...
    def verticalMovementX(self) -> int: ...
    def visualNavigation(self) -> bool: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTextDocument(PySide2.QtCore.QObject):
    class FindFlag:
        FindBackward: typing.ClassVar[QTextDocument.FindFlag] = ...
        FindCaseSensitively: typing.ClassVar[QTextDocument.FindFlag] = ...
        FindWholeWords: typing.ClassVar[QTextDocument.FindFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextDocument.FindFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...

    class FindFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextDocument.FindFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.FindFlags: ...

    class MarkdownFeature:
        MarkdownDialectCommonMark: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
        MarkdownDialectGitHub: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
        MarkdownNoHTML: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextDocument.MarkdownFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...

    class MarkdownFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextDocument.MarkdownFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.MarkdownFeatures: ...

    class MetaInformation:
        DocumentTitle: typing.ClassVar[QTextDocument.MetaInformation] = ...
        DocumentUrl: typing.ClassVar[QTextDocument.MetaInformation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.MetaInformation: ...

    class ResourceType:
        HtmlResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        ImageResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        MarkdownResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        StyleSheetResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        UnknownResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        UserResource: typing.ClassVar[QTextDocument.ResourceType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.ResourceType: ...

    class Stacks:
        RedoStack: typing.ClassVar[QTextDocument.Stacks] = ...
        UndoAndRedoStacks: typing.ClassVar[QTextDocument.Stacks] = ...
        UndoStack: typing.ClassVar[QTextDocument.Stacks] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __and__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextDocument.Stacks: ...
    DocumentTitle: typing.ClassVar[QTextDocument.MetaInformation] = ...
    DocumentUrl: typing.ClassVar[QTextDocument.MetaInformation] = ...
    FindBackward: typing.ClassVar[QTextDocument.FindFlag] = ...
    FindCaseSensitively: typing.ClassVar[QTextDocument.FindFlag] = ...
    FindWholeWords: typing.ClassVar[QTextDocument.FindFlag] = ...
    HtmlResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    ImageResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    MarkdownDialectCommonMark: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
    MarkdownDialectGitHub: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
    MarkdownNoHTML: typing.ClassVar[QTextDocument.MarkdownFeature] = ...
    MarkdownResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    RedoStack: typing.ClassVar[QTextDocument.Stacks] = ...
    StyleSheetResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    UndoAndRedoStacks: typing.ClassVar[QTextDocument.Stacks] = ...
    UndoStack: typing.ClassVar[QTextDocument.Stacks] = ...
    UnknownResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    UserResource: typing.ClassVar[QTextDocument.ResourceType] = ...
    baseUrlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    blockCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsChange: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    cursorPositionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    documentLayoutChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    modificationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    redoAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    undoAvailable: typing.ClassVar[PySide2.QtCore.Signal] = ...
    undoCommandAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, text: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., baseUrl: PySide2.QtCore.QUrl = ..., baseUrlChanged: typing.Callable = ..., blockCount: int = ..., blockCountChanged: typing.Callable = ..., contentsChange: typing.Callable = ..., contentsChanged: typing.Callable = ..., cursorPositionChanged: typing.Callable = ..., defaultFont: QFont = ..., defaultStyleSheet: str = ..., destroyed: typing.Callable = ..., documentLayoutChanged: typing.Callable = ..., documentMargin: float = ..., indentWidth: float = ..., maximumBlockCount: int = ..., modificationChanged: typing.Callable = ..., modified: bool = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pageSize: PySide2.QtCore.QSizeF = ..., redoAvailable: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., textWidth: float = ..., undoAvailable: typing.Callable = ..., undoCommandAdded: typing.Callable = ..., undoRedoEnabled: bool = ..., useDesignMetrics: bool = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., baseUrl: PySide2.QtCore.QUrl = ..., baseUrlChanged: typing.Callable = ..., blockCount: int = ..., blockCountChanged: typing.Callable = ..., contentsChange: typing.Callable = ..., contentsChanged: typing.Callable = ..., cursorPositionChanged: typing.Callable = ..., defaultFont: QFont = ..., defaultStyleSheet: str = ..., destroyed: typing.Callable = ..., documentLayoutChanged: typing.Callable = ..., documentMargin: float = ..., indentWidth: float = ..., maximumBlockCount: int = ..., modificationChanged: typing.Callable = ..., modified: bool = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pageSize: PySide2.QtCore.QSizeF = ..., redoAvailable: typing.Callable = ..., size: PySide2.QtCore.QSizeF = ..., textWidth: float = ..., undoAvailable: typing.Callable = ..., undoCommandAdded: typing.Callable = ..., undoRedoEnabled: bool = ..., useDesignMetrics: bool = ...) -> None: ...
    def addResource(self, type: int, name: PySide2.QtCore.QUrl, resource: typing.Any) -> None: ...
    def adjustSize(self) -> None: ...
    def allFormats(self) -> typing.List[QTextFormat]: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def begin(self) -> QTextBlock: ...
    def blockCount(self) -> int: ...
    def characterAt(self, pos: int) -> str: ...
    def characterCount(self) -> int: ...
    def clear(self) -> None: ...
    def clearUndoRedoStacks(self, historyToClear: QTextDocument.Stacks = ...) -> None: ...
    def clone(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ...) -> QTextDocument: ...
    def createObject(self, f: QTextFormat) -> QTextObject: ...
    def defaultCursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def defaultFont(self) -> QFont: ...
    def defaultStyleSheet(self) -> str: ...
    def defaultTextOption(self) -> QTextOption: ...
    def documentLayout(self) -> QAbstractTextDocumentLayout: ...
    def documentMargin(self) -> float: ...
    def drawContents(self, painter: QPainter, rect: PySide2.QtCore.QRectF = ...) -> None: ...
    def end(self) -> QTextBlock: ...
    @overload
    def find(self, expr: PySide2.QtCore.QRegExp, cursor: QTextCursor, options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: PySide2.QtCore.QRegExp, from_: int = ..., options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: PySide2.QtCore.QRegularExpression, cursor: QTextCursor, options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: PySide2.QtCore.QRegularExpression, from_: int = ..., options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    @overload
    def find(self, subString: str, cursor: QTextCursor, options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    @overload
    def find(self, subString: str, from_: int = ..., options: typing.Union[QTextDocument.FindFlags,QTextDocument.FindFlag] = ...) -> QTextCursor: ...
    def findBlock(self, pos: int) -> QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber: int) -> QTextBlock: ...
    def findBlockByNumber(self, blockNumber: int) -> QTextBlock: ...
    def firstBlock(self) -> QTextBlock: ...
    def frameAt(self, pos: int) -> QTextFrame: ...
    def idealWidth(self) -> float: ...
    def indentWidth(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def lastBlock(self) -> QTextBlock: ...
    def lineCount(self) -> int: ...
    def loadResource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def markContentsDirty(self, from_: int, length: int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def metaInformation(self, info: QTextDocument.MetaInformation) -> str: ...
    def object(self, objectIndex: int) -> QTextObject: ...
    def objectForFormat(self, arg__1: QTextFormat) -> QTextObject: ...
    def pageCount(self) -> int: ...
    def pageSize(self) -> PySide2.QtCore.QSizeF: ...
    def print_(self, printer: QPagedPaintDevice) -> None: ...
    @overload
    def redo(self, cursor: QTextCursor) -> None: ...
    @overload
    def redo(self) -> None: ...
    def resource(self, type: int, name: PySide2.QtCore.QUrl) -> typing.Any: ...
    def revision(self) -> int: ...
    def rootFrame(self) -> QTextFrame: ...
    def setBaseUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def setDefaultCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setDefaultFont(self, font: QFont) -> None: ...
    def setDefaultStyleSheet(self, sheet: str) -> None: ...
    def setDefaultTextOption(self, option: QTextOption) -> None: ...
    def setDocumentLayout(self, layout: QAbstractTextDocumentLayout) -> None: ...
    def setDocumentMargin(self, margin: float) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setIndentWidth(self, width: float) -> None: ...
    def setMarkdown(self, markdown: str, features: typing.Union[QTextDocument.MarkdownFeatures,QTextDocument.MarkdownFeature] = ...) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setMetaInformation(self, info: QTextDocument.MetaInformation, arg__2: str) -> None: ...
    def setModified(self, m: bool = ...) -> None: ...
    def setPageSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def textWidth(self) -> float: ...
    def toHtml(self, encoding: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> str: ...
    def toMarkdown(self, features: typing.Union[QTextDocument.MarkdownFeatures,QTextDocument.MarkdownFeature] = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...
    @overload
    def undo(self, cursor: QTextCursor) -> None: ...
    @overload
    def undo(self) -> None: ...
    def useDesignMetrics(self) -> bool: ...

class QTextDocumentFragment(shiboken2.Object):
    @overload
    def __init__(self, document: QTextDocument) -> None: ...
    @overload
    def __init__(self, range: QTextCursor) -> None: ...
    @overload
    def __init__(self, rhs: QTextDocumentFragment) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    @classmethod
    def fromHtml(cls, html: str, resourceProvider: QTextDocument) -> QTextDocumentFragment: ...
    @overload
    @classmethod
    def fromHtml(cls, html: str) -> QTextDocumentFragment: ...
    @classmethod
    def fromPlainText(cls, plainText: str) -> QTextDocumentFragment: ...
    def isEmpty(self) -> bool: ...
    def toHtml(self, encoding: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def __copy__(self) -> None: ...

class QTextDocumentWriter(shiboken2.Object):
    @overload
    def __init__(self, device: PySide2.QtCore.QIODevice, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def codec(self) -> PySide2.QtCore.QTextCodec: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def setCodec(self, codec: PySide2.QtCore.QTextCodec) -> None: ...
    def setDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @classmethod
    def supportedDocumentFormats(cls) -> typing.List[PySide2.QtCore.QByteArray]: ...
    @overload
    def write(self, document: QTextDocument) -> bool: ...
    @overload
    def write(self, fragment: QTextDocumentFragment) -> bool: ...

class QTextFormat(shiboken2.Object):
    class FormatType:
        BlockFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        CharFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        FrameFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        InvalidFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        ListFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        TableFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        UserFormat: typing.ClassVar[QTextFormat.FormatType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFormat.FormatType: ...

    class ObjectTypes:
        ImageObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
        NoObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
        TableCellObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
        TableObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
        UserObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFormat.ObjectTypes: ...

    class PageBreakFlag:
        PageBreak_AlwaysAfter: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
        PageBreak_AlwaysBefore: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
        PageBreak_Auto: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextFormat.PageBreakFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...

    class PageBreakFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextFormat.PageBreakFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFormat.PageBreakFlags: ...

    class Property:
        AnchorHref: typing.ClassVar[QTextFormat.Property] = ...
        AnchorName: typing.ClassVar[QTextFormat.Property] = ...
        BackgroundBrush: typing.ClassVar[QTextFormat.Property] = ...
        BackgroundImageUrl: typing.ClassVar[QTextFormat.Property] = ...
        BlockAlignment: typing.ClassVar[QTextFormat.Property] = ...
        BlockBottomMargin: typing.ClassVar[QTextFormat.Property] = ...
        BlockCodeFence: typing.ClassVar[QTextFormat.Property] = ...
        BlockCodeLanguage: typing.ClassVar[QTextFormat.Property] = ...
        BlockIndent: typing.ClassVar[QTextFormat.Property] = ...
        BlockLeftMargin: typing.ClassVar[QTextFormat.Property] = ...
        BlockMarker: typing.ClassVar[QTextFormat.Property] = ...
        BlockNonBreakableLines: typing.ClassVar[QTextFormat.Property] = ...
        BlockQuoteLevel: typing.ClassVar[QTextFormat.Property] = ...
        BlockRightMargin: typing.ClassVar[QTextFormat.Property] = ...
        BlockTopMargin: typing.ClassVar[QTextFormat.Property] = ...
        BlockTrailingHorizontalRulerWidth: typing.ClassVar[QTextFormat.Property] = ...
        CssFloat: typing.ClassVar[QTextFormat.Property] = ...
        FirstFontProperty: typing.ClassVar[QTextFormat.Property] = ...
        FontCapitalization: typing.ClassVar[QTextFormat.Property] = ...
        FontFamilies: typing.ClassVar[QTextFormat.Property] = ...
        FontFamily: typing.ClassVar[QTextFormat.Property] = ...
        FontFixedPitch: typing.ClassVar[QTextFormat.Property] = ...
        FontHintingPreference: typing.ClassVar[QTextFormat.Property] = ...
        FontItalic: typing.ClassVar[QTextFormat.Property] = ...
        FontKerning: typing.ClassVar[QTextFormat.Property] = ...
        FontLetterSpacing: typing.ClassVar[QTextFormat.Property] = ...
        FontLetterSpacingType: typing.ClassVar[QTextFormat.Property] = ...
        FontOverline: typing.ClassVar[QTextFormat.Property] = ...
        FontPixelSize: typing.ClassVar[QTextFormat.Property] = ...
        FontPointSize: typing.ClassVar[QTextFormat.Property] = ...
        FontSizeAdjustment: typing.ClassVar[QTextFormat.Property] = ...
        FontSizeIncrement: typing.ClassVar[QTextFormat.Property] = ...
        FontStretch: typing.ClassVar[QTextFormat.Property] = ...
        FontStrikeOut: typing.ClassVar[QTextFormat.Property] = ...
        FontStyleHint: typing.ClassVar[QTextFormat.Property] = ...
        FontStyleName: typing.ClassVar[QTextFormat.Property] = ...
        FontStyleStrategy: typing.ClassVar[QTextFormat.Property] = ...
        FontUnderline: typing.ClassVar[QTextFormat.Property] = ...
        FontWeight: typing.ClassVar[QTextFormat.Property] = ...
        FontWordSpacing: typing.ClassVar[QTextFormat.Property] = ...
        ForegroundBrush: typing.ClassVar[QTextFormat.Property] = ...
        FrameBorder: typing.ClassVar[QTextFormat.Property] = ...
        FrameBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
        FrameBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
        FrameBottomMargin: typing.ClassVar[QTextFormat.Property] = ...
        FrameHeight: typing.ClassVar[QTextFormat.Property] = ...
        FrameLeftMargin: typing.ClassVar[QTextFormat.Property] = ...
        FrameMargin: typing.ClassVar[QTextFormat.Property] = ...
        FramePadding: typing.ClassVar[QTextFormat.Property] = ...
        FrameRightMargin: typing.ClassVar[QTextFormat.Property] = ...
        FrameTopMargin: typing.ClassVar[QTextFormat.Property] = ...
        FrameWidth: typing.ClassVar[QTextFormat.Property] = ...
        FullWidthSelection: typing.ClassVar[QTextFormat.Property] = ...
        HeadingLevel: typing.ClassVar[QTextFormat.Property] = ...
        ImageAltText: typing.ClassVar[QTextFormat.Property] = ...
        ImageHeight: typing.ClassVar[QTextFormat.Property] = ...
        ImageName: typing.ClassVar[QTextFormat.Property] = ...
        ImageQuality: typing.ClassVar[QTextFormat.Property] = ...
        ImageTitle: typing.ClassVar[QTextFormat.Property] = ...
        ImageWidth: typing.ClassVar[QTextFormat.Property] = ...
        IsAnchor: typing.ClassVar[QTextFormat.Property] = ...
        LastFontProperty: typing.ClassVar[QTextFormat.Property] = ...
        LayoutDirection: typing.ClassVar[QTextFormat.Property] = ...
        LineHeight: typing.ClassVar[QTextFormat.Property] = ...
        LineHeightType: typing.ClassVar[QTextFormat.Property] = ...
        ListIndent: typing.ClassVar[QTextFormat.Property] = ...
        ListNumberPrefix: typing.ClassVar[QTextFormat.Property] = ...
        ListNumberSuffix: typing.ClassVar[QTextFormat.Property] = ...
        ListStyle: typing.ClassVar[QTextFormat.Property] = ...
        ObjectIndex: typing.ClassVar[QTextFormat.Property] = ...
        ObjectType: typing.ClassVar[QTextFormat.Property] = ...
        OutlinePen: typing.ClassVar[QTextFormat.Property] = ...
        PageBreakPolicy: typing.ClassVar[QTextFormat.Property] = ...
        TabPositions: typing.ClassVar[QTextFormat.Property] = ...
        TableBorderCollapse: typing.ClassVar[QTextFormat.Property] = ...
        TableCellBottomBorder: typing.ClassVar[QTextFormat.Property] = ...
        TableCellBottomBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
        TableCellBottomBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
        TableCellBottomPadding: typing.ClassVar[QTextFormat.Property] = ...
        TableCellColumnSpan: typing.ClassVar[QTextFormat.Property] = ...
        TableCellLeftBorder: typing.ClassVar[QTextFormat.Property] = ...
        TableCellLeftBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
        TableCellLeftBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
        TableCellLeftPadding: typing.ClassVar[QTextFormat.Property] = ...
        TableCellPadding: typing.ClassVar[QTextFormat.Property] = ...
        TableCellRightBorder: typing.ClassVar[QTextFormat.Property] = ...
        TableCellRightBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
        TableCellRightBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
        TableCellRightPadding: typing.ClassVar[QTextFormat.Property] = ...
        TableCellRowSpan: typing.ClassVar[QTextFormat.Property] = ...
        TableCellSpacing: typing.ClassVar[QTextFormat.Property] = ...
        TableCellTopBorder: typing.ClassVar[QTextFormat.Property] = ...
        TableCellTopBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
        TableCellTopBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
        TableCellTopPadding: typing.ClassVar[QTextFormat.Property] = ...
        TableColumnWidthConstraints: typing.ClassVar[QTextFormat.Property] = ...
        TableColumns: typing.ClassVar[QTextFormat.Property] = ...
        TableHeaderRowCount: typing.ClassVar[QTextFormat.Property] = ...
        TextIndent: typing.ClassVar[QTextFormat.Property] = ...
        TextOutline: typing.ClassVar[QTextFormat.Property] = ...
        TextToolTip: typing.ClassVar[QTextFormat.Property] = ...
        TextUnderlineColor: typing.ClassVar[QTextFormat.Property] = ...
        TextUnderlineStyle: typing.ClassVar[QTextFormat.Property] = ...
        TextVerticalAlignment: typing.ClassVar[QTextFormat.Property] = ...
        UserProperty: typing.ClassVar[QTextFormat.Property] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFormat.Property: ...
    AnchorHref: typing.ClassVar[QTextFormat.Property] = ...
    AnchorName: typing.ClassVar[QTextFormat.Property] = ...
    BackgroundBrush: typing.ClassVar[QTextFormat.Property] = ...
    BackgroundImageUrl: typing.ClassVar[QTextFormat.Property] = ...
    BlockAlignment: typing.ClassVar[QTextFormat.Property] = ...
    BlockBottomMargin: typing.ClassVar[QTextFormat.Property] = ...
    BlockCodeFence: typing.ClassVar[QTextFormat.Property] = ...
    BlockCodeLanguage: typing.ClassVar[QTextFormat.Property] = ...
    BlockFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    BlockIndent: typing.ClassVar[QTextFormat.Property] = ...
    BlockLeftMargin: typing.ClassVar[QTextFormat.Property] = ...
    BlockMarker: typing.ClassVar[QTextFormat.Property] = ...
    BlockNonBreakableLines: typing.ClassVar[QTextFormat.Property] = ...
    BlockQuoteLevel: typing.ClassVar[QTextFormat.Property] = ...
    BlockRightMargin: typing.ClassVar[QTextFormat.Property] = ...
    BlockTopMargin: typing.ClassVar[QTextFormat.Property] = ...
    BlockTrailingHorizontalRulerWidth: typing.ClassVar[QTextFormat.Property] = ...
    CharFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    CssFloat: typing.ClassVar[QTextFormat.Property] = ...
    FirstFontProperty: typing.ClassVar[QTextFormat.Property] = ...
    FontCapitalization: typing.ClassVar[QTextFormat.Property] = ...
    FontFamilies: typing.ClassVar[QTextFormat.Property] = ...
    FontFamily: typing.ClassVar[QTextFormat.Property] = ...
    FontFixedPitch: typing.ClassVar[QTextFormat.Property] = ...
    FontHintingPreference: typing.ClassVar[QTextFormat.Property] = ...
    FontItalic: typing.ClassVar[QTextFormat.Property] = ...
    FontKerning: typing.ClassVar[QTextFormat.Property] = ...
    FontLetterSpacing: typing.ClassVar[QTextFormat.Property] = ...
    FontLetterSpacingType: typing.ClassVar[QTextFormat.Property] = ...
    FontOverline: typing.ClassVar[QTextFormat.Property] = ...
    FontPixelSize: typing.ClassVar[QTextFormat.Property] = ...
    FontPointSize: typing.ClassVar[QTextFormat.Property] = ...
    FontSizeAdjustment: typing.ClassVar[QTextFormat.Property] = ...
    FontSizeIncrement: typing.ClassVar[QTextFormat.Property] = ...
    FontStretch: typing.ClassVar[QTextFormat.Property] = ...
    FontStrikeOut: typing.ClassVar[QTextFormat.Property] = ...
    FontStyleHint: typing.ClassVar[QTextFormat.Property] = ...
    FontStyleName: typing.ClassVar[QTextFormat.Property] = ...
    FontStyleStrategy: typing.ClassVar[QTextFormat.Property] = ...
    FontUnderline: typing.ClassVar[QTextFormat.Property] = ...
    FontWeight: typing.ClassVar[QTextFormat.Property] = ...
    FontWordSpacing: typing.ClassVar[QTextFormat.Property] = ...
    ForegroundBrush: typing.ClassVar[QTextFormat.Property] = ...
    FrameBorder: typing.ClassVar[QTextFormat.Property] = ...
    FrameBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
    FrameBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
    FrameBottomMargin: typing.ClassVar[QTextFormat.Property] = ...
    FrameFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    FrameHeight: typing.ClassVar[QTextFormat.Property] = ...
    FrameLeftMargin: typing.ClassVar[QTextFormat.Property] = ...
    FrameMargin: typing.ClassVar[QTextFormat.Property] = ...
    FramePadding: typing.ClassVar[QTextFormat.Property] = ...
    FrameRightMargin: typing.ClassVar[QTextFormat.Property] = ...
    FrameTopMargin: typing.ClassVar[QTextFormat.Property] = ...
    FrameWidth: typing.ClassVar[QTextFormat.Property] = ...
    FullWidthSelection: typing.ClassVar[QTextFormat.Property] = ...
    HeadingLevel: typing.ClassVar[QTextFormat.Property] = ...
    ImageAltText: typing.ClassVar[QTextFormat.Property] = ...
    ImageHeight: typing.ClassVar[QTextFormat.Property] = ...
    ImageName: typing.ClassVar[QTextFormat.Property] = ...
    ImageObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
    ImageQuality: typing.ClassVar[QTextFormat.Property] = ...
    ImageTitle: typing.ClassVar[QTextFormat.Property] = ...
    ImageWidth: typing.ClassVar[QTextFormat.Property] = ...
    InvalidFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    IsAnchor: typing.ClassVar[QTextFormat.Property] = ...
    LastFontProperty: typing.ClassVar[QTextFormat.Property] = ...
    LayoutDirection: typing.ClassVar[QTextFormat.Property] = ...
    LineHeight: typing.ClassVar[QTextFormat.Property] = ...
    LineHeightType: typing.ClassVar[QTextFormat.Property] = ...
    ListFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    ListIndent: typing.ClassVar[QTextFormat.Property] = ...
    ListNumberPrefix: typing.ClassVar[QTextFormat.Property] = ...
    ListNumberSuffix: typing.ClassVar[QTextFormat.Property] = ...
    ListStyle: typing.ClassVar[QTextFormat.Property] = ...
    NoObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
    ObjectIndex: typing.ClassVar[QTextFormat.Property] = ...
    ObjectType: typing.ClassVar[QTextFormat.Property] = ...
    OutlinePen: typing.ClassVar[QTextFormat.Property] = ...
    PageBreakPolicy: typing.ClassVar[QTextFormat.Property] = ...
    PageBreak_AlwaysAfter: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
    PageBreak_AlwaysBefore: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
    PageBreak_Auto: typing.ClassVar[QTextFormat.PageBreakFlag] = ...
    TabPositions: typing.ClassVar[QTextFormat.Property] = ...
    TableBorderCollapse: typing.ClassVar[QTextFormat.Property] = ...
    TableCellBottomBorder: typing.ClassVar[QTextFormat.Property] = ...
    TableCellBottomBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
    TableCellBottomBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
    TableCellBottomPadding: typing.ClassVar[QTextFormat.Property] = ...
    TableCellColumnSpan: typing.ClassVar[QTextFormat.Property] = ...
    TableCellLeftBorder: typing.ClassVar[QTextFormat.Property] = ...
    TableCellLeftBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
    TableCellLeftBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
    TableCellLeftPadding: typing.ClassVar[QTextFormat.Property] = ...
    TableCellObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
    TableCellPadding: typing.ClassVar[QTextFormat.Property] = ...
    TableCellRightBorder: typing.ClassVar[QTextFormat.Property] = ...
    TableCellRightBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
    TableCellRightBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
    TableCellRightPadding: typing.ClassVar[QTextFormat.Property] = ...
    TableCellRowSpan: typing.ClassVar[QTextFormat.Property] = ...
    TableCellSpacing: typing.ClassVar[QTextFormat.Property] = ...
    TableCellTopBorder: typing.ClassVar[QTextFormat.Property] = ...
    TableCellTopBorderBrush: typing.ClassVar[QTextFormat.Property] = ...
    TableCellTopBorderStyle: typing.ClassVar[QTextFormat.Property] = ...
    TableCellTopPadding: typing.ClassVar[QTextFormat.Property] = ...
    TableColumnWidthConstraints: typing.ClassVar[QTextFormat.Property] = ...
    TableColumns: typing.ClassVar[QTextFormat.Property] = ...
    TableFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    TableHeaderRowCount: typing.ClassVar[QTextFormat.Property] = ...
    TableObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
    TextIndent: typing.ClassVar[QTextFormat.Property] = ...
    TextOutline: typing.ClassVar[QTextFormat.Property] = ...
    TextToolTip: typing.ClassVar[QTextFormat.Property] = ...
    TextUnderlineColor: typing.ClassVar[QTextFormat.Property] = ...
    TextUnderlineStyle: typing.ClassVar[QTextFormat.Property] = ...
    TextVerticalAlignment: typing.ClassVar[QTextFormat.Property] = ...
    UserFormat: typing.ClassVar[QTextFormat.FormatType] = ...
    UserObject: typing.ClassVar[QTextFormat.ObjectTypes] = ...
    UserProperty: typing.ClassVar[QTextFormat.Property] = ...
    @overload
    def __init__(self, rhs: QTextFormat) -> None: ...
    @overload
    def __init__(self, type: int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def background(self) -> QBrush: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def brushProperty(self, propertyId: int) -> QBrush: ...
    def clearBackground(self) -> None: ...
    def clearForeground(self) -> None: ...
    def clearProperty(self, propertyId: int) -> None: ...
    def colorProperty(self, propertyId: int) -> QColor: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def foreground(self) -> QBrush: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def intProperty(self, propertyId: int) -> int: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isTableCellFormat(self) -> bool: ...
    def isTableFormat(self) -> bool: ...
    def isValid(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def lengthProperty(self, propertyId: int) -> QTextLength: ...
    def lengthVectorProperty(self, propertyId: int) -> typing.List[QTextLength]: ...
    def merge(self, other: QTextFormat) -> None: ...
    def objectIndex(self) -> int: ...
    def objectType(self) -> int: ...
    def penProperty(self, propertyId: int) -> QPen: ...
    def properties(self) -> typing.Dict[int,typing.Any]: ...
    def property(self, propertyId: int) -> typing.Any: ...
    def propertyCount(self) -> int: ...
    def setBackground(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setForeground(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setLayoutDirection(self, direction: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setObjectIndex(self, object: int) -> None: ...
    def setObjectType(self, type: int) -> None: ...
    @overload
    def setProperty(self, propertyId: int, lengths: typing.List[QTextLength]) -> None: ...
    @overload
    def setProperty(self, propertyId: int, value: typing.Any) -> None: ...
    def stringProperty(self, propertyId: int) -> str: ...
    def swap(self, other: QTextFormat) -> None: ...
    def toBlockFormat(self) -> QTextBlockFormat: ...
    def toCharFormat(self) -> QTextCharFormat: ...
    def toFrameFormat(self) -> QTextFrameFormat: ...
    def toImageFormat(self) -> QTextImageFormat: ...
    def toListFormat(self) -> QTextListFormat: ...
    def toTableCellFormat(self) -> QTextTableCellFormat: ...
    def toTableFormat(self) -> QTextTableFormat: ...
    def type(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QTextFragment(shiboken2.Object):
    @overload
    def __init__(self, o: QTextFragment) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def charFormat(self) -> QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def contains(self, position: int) -> bool: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def text(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTextFrame(QTextObject):
    class iterator(shiboken2.Object):
        @overload
        def __init__(self, o: QTextFrame.iterator) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def atEnd(self) -> bool: ...
        def currentBlock(self) -> QTextBlock: ...
        def currentFrame(self) -> QTextFrame: ...
        def parentFrame(self) -> QTextFrame: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __iadd__(self, arg__1: int) -> QTextFrame.iterator: ...
        def __isub__(self, arg__1: int) -> QTextFrame.iterator: ...
        def __iter__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __next__(self) -> object: ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def begin(self) -> QTextFrame.iterator: ...
    def childFrames(self) -> typing.List[QTextFrame]: ...
    def end(self) -> QTextFrame.iterator: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def firstPosition(self) -> int: ...
    def frameFormat(self) -> QTextFrameFormat: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def lastPosition(self) -> int: ...
    def parentFrame(self) -> QTextFrame: ...
    def setFrameFormat(self, format: QTextFrameFormat) -> None: ...
    def __iter__(self) -> object: ...

class QTextFrameFormat(QTextFormat):
    class BorderStyle:
        BorderStyle_Dashed: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_DotDash: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_DotDotDash: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Dotted: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Double: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Groove: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Inset: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_None: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Outset: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Ridge: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        BorderStyle_Solid: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFrameFormat.BorderStyle: ...

    class Position:
        FloatLeft: typing.ClassVar[QTextFrameFormat.Position] = ...
        FloatRight: typing.ClassVar[QTextFrameFormat.Position] = ...
        InFlow: typing.ClassVar[QTextFrameFormat.Position] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __and__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextFrameFormat.Position: ...
    BorderStyle_Dashed: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_DotDash: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_DotDotDash: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Dotted: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Double: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Groove: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Inset: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_None: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Outset: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Ridge: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    BorderStyle_Solid: typing.ClassVar[QTextFrameFormat.BorderStyle] = ...
    FloatLeft: typing.ClassVar[QTextFrameFormat.Position] = ...
    FloatRight: typing.ClassVar[QTextFrameFormat.Position] = ...
    InFlow: typing.ClassVar[QTextFrameFormat.Position] = ...
    @overload
    def __init__(self, QTextFrameFormat: QTextFrameFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def border(self) -> float: ...
    def borderBrush(self) -> QBrush: ...
    def borderStyle(self) -> QTextFrameFormat.BorderStyle: ...
    def bottomMargin(self) -> float: ...
    def height(self) -> QTextLength: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    def margin(self) -> float: ...
    def padding(self) -> float: ...
    def pageBreakPolicy(self) -> typing.Union[QTextFormat.PageBreakFlags,QTextFormat.PageBreakFlag]: ...
    def position(self) -> QTextFrameFormat.Position: ...
    def rightMargin(self) -> float: ...
    def setBorder(self, border: float) -> None: ...
    def setBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    @overload
    def setHeight(self, height: QTextLength) -> None: ...
    @overload
    def setHeight(self, height: float) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setMargin(self, margin: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setPageBreakPolicy(self, flags: typing.Union[QTextFormat.PageBreakFlags,QTextFormat.PageBreakFlag]) -> None: ...
    def setPosition(self, f: QTextFrameFormat.Position) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    @overload
    def setWidth(self, length: QTextLength) -> None: ...
    @overload
    def setWidth(self, width: float) -> None: ...
    def topMargin(self) -> float: ...
    def width(self) -> QTextLength: ...
    def __copy__(self) -> None: ...

class QTextImageFormat(QTextCharFormat):
    @overload
    def __init__(self, QTextImageFormat: QTextImageFormat) -> None: ...
    @overload
    def __init__(self, format: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def quality(self) -> int: ...
    def setHeight(self, height: float) -> None: ...
    def setName(self, name: str) -> None: ...
    def setQuality(self, quality: int = ...) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...
    def __copy__(self) -> None: ...

class QTextInlineObject(shiboken2.Object):
    def __init__(self) -> None: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def format(self) -> QTextFormat: ...
    def formatIndex(self) -> int: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setAscent(self, a: float) -> None: ...
    def setDescent(self, d: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textPosition(self) -> int: ...
    def width(self) -> float: ...
    def __copy__(self) -> None: ...

class QTextItem(shiboken2.Object):
    class RenderFlag:
        Dummy: typing.ClassVar[QTextItem.RenderFlag] = ...
        Overline: typing.ClassVar[QTextItem.RenderFlag] = ...
        RightToLeft: typing.ClassVar[QTextItem.RenderFlag] = ...
        StrikeOut: typing.ClassVar[QTextItem.RenderFlag] = ...
        Underline: typing.ClassVar[QTextItem.RenderFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextItem.RenderFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...

    class RenderFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextItem.RenderFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextItem.RenderFlags: ...
    Dummy: typing.ClassVar[QTextItem.RenderFlag] = ...
    Overline: typing.ClassVar[QTextItem.RenderFlag] = ...
    RightToLeft: typing.ClassVar[QTextItem.RenderFlag] = ...
    StrikeOut: typing.ClassVar[QTextItem.RenderFlag] = ...
    Underline: typing.ClassVar[QTextItem.RenderFlag] = ...
    def __init__(self) -> None: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def font(self) -> QFont: ...
    def renderFlags(self) -> typing.Union[QTextItem.RenderFlags,QTextItem.RenderFlag]: ...
    def text(self) -> str: ...
    def width(self) -> float: ...

class QTextLayout(shiboken2.Object):
    class CursorMode:
        SkipCharacters: typing.ClassVar[QTextLayout.CursorMode] = ...
        SkipWords: typing.ClassVar[QTextLayout.CursorMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __and__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextLayout.CursorMode: ...

    class FormatRange(shiboken2.Object):
        format: typing.Any
        length: typing.Any
        start: typing.Any
        @overload
        def __init__(self, FormatRange: QTextLayout.FormatRange) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...
    SkipCharacters: typing.ClassVar[QTextLayout.CursorMode] = ...
    SkipWords: typing.ClassVar[QTextLayout.CursorMode] = ...
    @overload
    def __init__(self, text: str, font: QFont, paintdevice: typing.Union[QPaintDevice,None] = ...) -> None: ...
    @overload
    def __init__(self, b: QTextBlock) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def additionalFormats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def beginLayout(self) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def cacheEnabled(self) -> bool: ...
    def clearAdditionalFormats(self) -> None: ...
    def clearFormats(self) -> None: ...
    def clearLayout(self) -> None: ...
    def createLine(self) -> QTextLine: ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def draw(self, p: QPainter, pos: PySide2.QtCore.QPointF, selections: typing.List[QTextLayout.FormatRange] = ..., clip: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def drawCursor(self, p: QPainter, pos: PySide2.QtCore.QPointF, cursorPosition: int, width: int) -> None: ...
    @overload
    def drawCursor(self, p: QPainter, pos: PySide2.QtCore.QPointF, cursorPosition: int) -> None: ...
    def endLayout(self) -> None: ...
    def font(self) -> QFont: ...
    def formats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def lineAt(self, i: int) -> QTextLine: ...
    def lineCount(self) -> int: ...
    def lineForTextPosition(self, pos: int) -> QTextLine: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def nextCursorPosition(self, oldPos: int, mode: QTextLayout.CursorMode = ...) -> int: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def preeditAreaPosition(self) -> int: ...
    def preeditAreaText(self) -> str: ...
    def previousCursorPosition(self, oldPos: int, mode: QTextLayout.CursorMode = ...) -> int: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def setAdditionalFormats(self, overrides: typing.Iterable[QTextLayout.FormatRange]) -> None: ...
    def setCacheEnabled(self, enable: bool) -> None: ...
    def setCursorMoveStyle(self, style: PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setFlags(self, flags: typing.SupportsInt) -> None: ...
    def setFont(self, f: QFont) -> None: ...
    def setFormats(self, overrides: typing.List[QTextLayout.FormatRange]) -> None: ...
    def setPosition(self, p: PySide2.QtCore.QPointF) -> None: ...
    def setPreeditArea(self, position: int, text: str) -> None: ...
    def setRawFont(self, rawFont: QRawFont) -> None: ...
    def setText(self, string: str) -> None: ...
    def setTextOption(self, option: QTextOption) -> None: ...
    def text(self) -> str: ...
    def textOption(self) -> QTextOption: ...

class QTextLength(shiboken2.Object):
    class Type:
        FixedLength: typing.ClassVar[QTextLength.Type] = ...
        PercentageLength: typing.ClassVar[QTextLength.Type] = ...
        VariableLength: typing.ClassVar[QTextLength.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextLength.Type: ...
    FixedLength: typing.ClassVar[QTextLength.Type] = ...
    PercentageLength: typing.ClassVar[QTextLength.Type] = ...
    VariableLength: typing.ClassVar[QTextLength.Type] = ...
    @overload
    def __init__(self, type: QTextLength.Type, value: float) -> None: ...
    @overload
    def __init__(self, QTextLength: QTextLength) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def rawValue(self) -> float: ...
    def type(self) -> QTextLength.Type: ...
    def value(self, maximumLength: float) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...

class QTextLine(shiboken2.Object):
    class CursorPosition:
        CursorBetweenCharacters: typing.ClassVar[QTextLine.CursorPosition] = ...
        CursorOnCharacter: typing.ClassVar[QTextLine.CursorPosition] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __and__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextLine.CursorPosition: ...

    class Edge:
        Leading: typing.ClassVar[QTextLine.Edge] = ...
        Trailing: typing.ClassVar[QTextLine.Edge] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __and__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextLine.Edge: ...
    CursorBetweenCharacters: typing.ClassVar[QTextLine.CursorPosition] = ...
    CursorOnCharacter: typing.ClassVar[QTextLine.CursorPosition] = ...
    Leading: typing.ClassVar[QTextLine.Edge] = ...
    Trailing: typing.ClassVar[QTextLine.Edge] = ...
    def __init__(self) -> None: ...
    def ascent(self) -> float: ...
    def cursorToX(self, cursorPos: int, edge: QTextLine.Edge = ...) -> float: ...
    def descent(self) -> float: ...
    def draw(self, p: QPainter, point: PySide2.QtCore.QPointF, selection: typing.Union[QTextLayout.FormatRange,None] = ...) -> None: ...
    def height(self) -> float: ...
    def horizontalAdvance(self) -> float: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def naturalTextRect(self) -> PySide2.QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setLeadingIncluded(self, included: bool) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    @overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None: ...
    @overload
    def setNumColumns(self, columns: int) -> None: ...
    def setPosition(self, pos: PySide2.QtCore.QPointF) -> None: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def xToCursor(self, x: float, edge: QTextLine.CursorPosition = ...) -> int: ...
    def y(self) -> float: ...
    def __copy__(self) -> None: ...

class QTextList(QTextBlockGroup):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def add(self, block: QTextBlock) -> None: ...
    def count(self) -> int: ...
    def format(self) -> QTextListFormat: ...
    def item(self, i: int) -> QTextBlock: ...
    def itemNumber(self, arg__1: QTextBlock) -> int: ...
    def itemText(self, arg__1: QTextBlock) -> str: ...
    def remove(self, arg__1: QTextBlock) -> None: ...
    def removeItem(self, i: int) -> None: ...
    @overload
    def setFormat(self, format: QTextFormat) -> None: ...
    @overload
    def setFormat(self, format: QTextListFormat) -> None: ...

class QTextListFormat(QTextFormat):
    class Style:
        ListCircle: typing.ClassVar[QTextListFormat.Style] = ...
        ListDecimal: typing.ClassVar[QTextListFormat.Style] = ...
        ListDisc: typing.ClassVar[QTextListFormat.Style] = ...
        ListLowerAlpha: typing.ClassVar[QTextListFormat.Style] = ...
        ListLowerRoman: typing.ClassVar[QTextListFormat.Style] = ...
        ListSquare: typing.ClassVar[QTextListFormat.Style] = ...
        ListStyleUndefined: typing.ClassVar[QTextListFormat.Style] = ...
        ListUpperAlpha: typing.ClassVar[QTextListFormat.Style] = ...
        ListUpperRoman: typing.ClassVar[QTextListFormat.Style] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __and__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextListFormat.Style: ...
    ListCircle: typing.ClassVar[QTextListFormat.Style] = ...
    ListDecimal: typing.ClassVar[QTextListFormat.Style] = ...
    ListDisc: typing.ClassVar[QTextListFormat.Style] = ...
    ListLowerAlpha: typing.ClassVar[QTextListFormat.Style] = ...
    ListLowerRoman: typing.ClassVar[QTextListFormat.Style] = ...
    ListSquare: typing.ClassVar[QTextListFormat.Style] = ...
    ListStyleUndefined: typing.ClassVar[QTextListFormat.Style] = ...
    ListUpperAlpha: typing.ClassVar[QTextListFormat.Style] = ...
    ListUpperRoman: typing.ClassVar[QTextListFormat.Style] = ...
    @overload
    def __init__(self, QTextListFormat: QTextListFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def numberPrefix(self) -> str: ...
    def numberSuffix(self) -> str: ...
    def setIndent(self, indent: int) -> None: ...
    def setNumberPrefix(self, numberPrefix: str) -> None: ...
    def setNumberSuffix(self, numberSuffix: str) -> None: ...
    def setStyle(self, style: QTextListFormat.Style) -> None: ...
    def style(self) -> QTextListFormat.Style: ...
    def __copy__(self) -> None: ...

class QTextObject(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def document(self) -> QTextDocument: ...
    def format(self) -> QTextFormat: ...
    def formatIndex(self) -> int: ...
    def objectIndex(self) -> int: ...
    def setFormat(self, format: QTextFormat) -> None: ...

class QTextObjectInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def drawObject(self, painter: QPainter, rect: PySide2.QtCore.QRectF, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> None: ...
    def intrinsicSize(self, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> PySide2.QtCore.QSizeF: ...

class QTextOption(shiboken2.Object):
    class Flag:
        AddSpaceForLineAndParagraphSeparators: typing.ClassVar[QTextOption.Flag] = ...
        IncludeTrailingSpaces: typing.ClassVar[QTextOption.Flag] = ...
        ShowDocumentTerminator: typing.ClassVar[QTextOption.Flag] = ...
        ShowLineAndParagraphSeparators: typing.ClassVar[QTextOption.Flag] = ...
        ShowTabsAndSpaces: typing.ClassVar[QTextOption.Flag] = ...
        SuppressColors: typing.ClassVar[QTextOption.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextOption.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextOption.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextOption.Flags: ...

    class Tab(shiboken2.Object):
        delimiter: typing.Any
        position: typing.Any
        type: typing.Any
        @overload
        def __init__(self, pos: float, tabType: QTextOption.TabType, delim: str = ...) -> None: ...
        @overload
        def __init__(self, Tab: QTextOption.Tab) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class TabType:
        CenterTab: typing.ClassVar[QTextOption.TabType] = ...
        DelimiterTab: typing.ClassVar[QTextOption.TabType] = ...
        LeftTab: typing.ClassVar[QTextOption.TabType] = ...
        RightTab: typing.ClassVar[QTextOption.TabType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextOption.TabType: ...

    class WrapMode:
        ManualWrap: typing.ClassVar[QTextOption.WrapMode] = ...
        NoWrap: typing.ClassVar[QTextOption.WrapMode] = ...
        WordWrap: typing.ClassVar[QTextOption.WrapMode] = ...
        WrapAnywhere: typing.ClassVar[QTextOption.WrapMode] = ...
        WrapAtWordBoundaryOrAnywhere: typing.ClassVar[QTextOption.WrapMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __and__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextOption.WrapMode: ...
    AddSpaceForLineAndParagraphSeparators: typing.ClassVar[QTextOption.Flag] = ...
    CenterTab: typing.ClassVar[QTextOption.TabType] = ...
    DelimiterTab: typing.ClassVar[QTextOption.TabType] = ...
    IncludeTrailingSpaces: typing.ClassVar[QTextOption.Flag] = ...
    LeftTab: typing.ClassVar[QTextOption.TabType] = ...
    ManualWrap: typing.ClassVar[QTextOption.WrapMode] = ...
    NoWrap: typing.ClassVar[QTextOption.WrapMode] = ...
    RightTab: typing.ClassVar[QTextOption.TabType] = ...
    ShowDocumentTerminator: typing.ClassVar[QTextOption.Flag] = ...
    ShowLineAndParagraphSeparators: typing.ClassVar[QTextOption.Flag] = ...
    ShowTabsAndSpaces: typing.ClassVar[QTextOption.Flag] = ...
    SuppressColors: typing.ClassVar[QTextOption.Flag] = ...
    WordWrap: typing.ClassVar[QTextOption.WrapMode] = ...
    WrapAnywhere: typing.ClassVar[QTextOption.WrapMode] = ...
    WrapAtWordBoundaryOrAnywhere: typing.ClassVar[QTextOption.WrapMode] = ...
    @overload
    def __init__(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    @overload
    def __init__(self, o: QTextOption) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def flags(self) -> typing.Union[QTextOption.Flags,QTextOption.Flag]: ...
    def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setFlags(self, flags: typing.Union[QTextOption.Flags,QTextOption.Flag]) -> None: ...
    def setTabArray(self, tabStops: typing.Iterable[float]) -> None: ...
    def setTabStop(self, tabStop: float) -> None: ...
    def setTabStopDistance(self, tabStopDistance: float) -> None: ...
    def setTabs(self, tabStops: typing.Iterable[QTextOption.Tab]) -> None: ...
    def setTextDirection(self, aDirection: PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def setWrapMode(self, wrap: QTextOption.WrapMode) -> None: ...
    def tabArray(self) -> typing.List[float]: ...
    def tabStop(self) -> float: ...
    def tabStopDistance(self) -> float: ...
    def tabs(self) -> typing.List[QTextOption.Tab]: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def useDesignMetrics(self) -> bool: ...
    def wrapMode(self) -> QTextOption.WrapMode: ...
    def __copy__(self) -> None: ...

class QTextTable(QTextFrame):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, doc: QTextDocument, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def appendColumns(self, count: int) -> None: ...
    def appendRows(self, count: int) -> None: ...
    @overload
    def cellAt(self, row: int, col: int) -> QTextTableCell: ...
    @overload
    def cellAt(self, c: QTextCursor) -> QTextTableCell: ...
    @overload
    def cellAt(self, position: int) -> QTextTableCell: ...
    def columns(self) -> int: ...
    def format(self) -> QTextTableFormat: ...
    def insertColumns(self, pos: int, num: int) -> None: ...
    def insertRows(self, pos: int, num: int) -> None: ...
    @overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @overload
    def mergeCells(self, cursor: QTextCursor) -> None: ...
    def removeColumns(self, pos: int, num: int) -> None: ...
    def removeRows(self, pos: int, num: int) -> None: ...
    def resize(self, rows: int, cols: int) -> None: ...
    def rowEnd(self, c: QTextCursor) -> QTextCursor: ...
    def rowStart(self, c: QTextCursor) -> QTextCursor: ...
    def rows(self) -> int: ...
    @overload
    def setFormat(self, format: QTextFormat) -> None: ...
    @overload
    def setFormat(self, format: QTextTableFormat) -> None: ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None: ...

class QTextTableCell(shiboken2.Object):
    @overload
    def __init__(self, o: QTextTableCell) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def begin(self) -> QTextFrame.iterator: ...
    def column(self) -> int: ...
    def columnSpan(self) -> int: ...
    def end(self) -> QTextFrame.iterator: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def firstPosition(self) -> int: ...
    def format(self) -> QTextCharFormat: ...
    def isValid(self) -> bool: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def lastPosition(self) -> int: ...
    def row(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setFormat(self, format: QTextCharFormat) -> None: ...
    def tableCellFormatIndex(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTextTableCellFormat(QTextCharFormat):
    @overload
    def __init__(self, QTextTableCellFormat: QTextTableCellFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bottomBorder(self) -> float: ...
    def bottomBorderBrush(self) -> QBrush: ...
    def bottomBorderStyle(self) -> QTextFrameFormat.BorderStyle: ...
    def bottomPadding(self) -> float: ...
    def isValid(self) -> bool: ...
    def leftBorder(self) -> float: ...
    def leftBorderBrush(self) -> QBrush: ...
    def leftBorderStyle(self) -> QTextFrameFormat.BorderStyle: ...
    def leftPadding(self) -> float: ...
    def rightBorder(self) -> float: ...
    def rightBorderBrush(self) -> QBrush: ...
    def rightBorderStyle(self) -> QTextFrameFormat.BorderStyle: ...
    def rightPadding(self) -> float: ...
    def setBorder(self, width: float) -> None: ...
    def setBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomBorder(self, width: float) -> None: ...
    def setBottomBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setBottomBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomPadding(self, padding: float) -> None: ...
    def setLeftBorder(self, width: float) -> None: ...
    def setLeftBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setLeftBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setLeftPadding(self, padding: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setRightBorder(self, width: float) -> None: ...
    def setRightBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setRightBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setRightPadding(self, padding: float) -> None: ...
    def setTopBorder(self, width: float) -> None: ...
    def setTopBorderBrush(self, brush: typing.Union[QBrush,QColor,PySide2.QtCore.Qt.GlobalColor,QLinearGradient]) -> None: ...
    def setTopBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None: ...
    def setTopPadding(self, padding: float) -> None: ...
    def topBorder(self) -> float: ...
    def topBorderBrush(self) -> QBrush: ...
    def topBorderStyle(self) -> QTextFrameFormat.BorderStyle: ...
    def topPadding(self) -> float: ...
    def __copy__(self) -> None: ...

class QTextTableFormat(QTextFrameFormat):
    @overload
    def __init__(self, QTextTableFormat: QTextTableFormat) -> None: ...
    @overload
    def __init__(self, fmt: QTextFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def alignment(self) -> typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]: ...
    def borderCollapse(self) -> bool: ...
    def cellPadding(self) -> float: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> typing.List[QTextLength]: ...
    def columns(self) -> int: ...
    def headerRowCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def setAlignment(self, alignment: typing.Union[PySide2.QtCore.Qt.Alignment,PySide2.QtCore.Qt.AlignmentFlag]) -> None: ...
    def setBorderCollapse(self, borderCollapse: bool) -> None: ...
    def setCellPadding(self, padding: float) -> None: ...
    def setCellSpacing(self, spacing: float) -> None: ...
    def setColumnWidthConstraints(self, constraints: typing.List[QTextLength]) -> None: ...
    def setColumns(self, columns: int) -> None: ...
    def setHeaderRowCount(self, count: int) -> None: ...
    def __copy__(self) -> None: ...

class QToolBarChangeEvent(PySide2.QtCore.QEvent):
    def __init__(self, t: bool) -> None: ...
    def toggle(self) -> bool: ...

class QTouchDevice(shiboken2.Object):
    class Capabilities:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTouchDevice.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...

    class CapabilityFlag:
        Area: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        MouseEmulation: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        NormalizedPosition: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        Position: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        Pressure: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        RawPositions: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        Velocity: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTouchDevice.Capabilities: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __rand__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __ror__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...
        def __xor__(self, other: typing.SupportsInt) -> QTouchDevice.Capabilities: ...

    class DeviceType:
        TouchPad: typing.ClassVar[QTouchDevice.DeviceType] = ...
        TouchScreen: typing.ClassVar[QTouchDevice.DeviceType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __and__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTouchDevice.DeviceType: ...
    Area: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    MouseEmulation: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    NormalizedPosition: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    Position: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    Pressure: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    RawPositions: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    TouchPad: typing.ClassVar[QTouchDevice.DeviceType] = ...
    TouchScreen: typing.ClassVar[QTouchDevice.DeviceType] = ...
    Velocity: typing.ClassVar[QTouchDevice.CapabilityFlag] = ...
    def __init__(self) -> None: ...
    def capabilities(self) -> typing.Union[QTouchDevice.Capabilities,QTouchDevice.CapabilityFlag]: ...
    @classmethod
    def devices(cls) -> typing.List[QTouchDevice]: ...
    def maximumTouchPoints(self) -> int: ...
    def name(self) -> str: ...
    def setCapabilities(self, caps: typing.Union[QTouchDevice.Capabilities,QTouchDevice.CapabilityFlag]) -> None: ...
    def setMaximumTouchPoints(self, max: int) -> None: ...
    def setName(self, name: str) -> None: ...
    def setType(self, devType: QTouchDevice.DeviceType) -> None: ...
    def type(self) -> QTouchDevice.DeviceType: ...

class QTouchEvent(QInputEvent):
    class TouchPoint(shiboken2.Object):
        class InfoFlag:
            Pen: typing.ClassVar[QTouchEvent.TouchPoint.InfoFlag] = ...
            Token: typing.ClassVar[QTouchEvent.TouchPoint.InfoFlag] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
    
        class InfoFlags:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> QTouchEvent.TouchPoint.InfoFlags: ...
        Pen: typing.ClassVar[QTouchEvent.TouchPoint.InfoFlag] = ...
        Token: typing.ClassVar[QTouchEvent.TouchPoint.InfoFlag] = ...
        @overload
        def __init__(self, id: int = ...) -> None: ...
        @overload
        def __init__(self, other: QTouchEvent.TouchPoint) -> None: ...
        def ellipseDiameters(self) -> PySide2.QtCore.QSizeF: ...
        def flags(self) -> typing.Union[QTouchEvent.TouchPoint.InfoFlags,QTouchEvent.TouchPoint.InfoFlag]: ...
        def id(self) -> int: ...
        def lastNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def lastPos(self) -> PySide2.QtCore.QPointF: ...
        def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
        def lastScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def normalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def pos(self) -> PySide2.QtCore.QPointF: ...
        def pressure(self) -> float: ...
        def rawScreenPositions(self) -> typing.List[PySide2.QtCore.QPointF]: ...
        def rect(self) -> PySide2.QtCore.QRectF: ...
        def rotation(self) -> float: ...
        def scenePos(self) -> PySide2.QtCore.QPointF: ...
        def sceneRect(self) -> PySide2.QtCore.QRectF: ...
        def screenPos(self) -> PySide2.QtCore.QPointF: ...
        def screenRect(self) -> PySide2.QtCore.QRectF: ...
        def setEllipseDiameters(self, dia: PySide2.QtCore.QSizeF) -> None: ...
        def setFlags(self, flags: typing.Union[QTouchEvent.TouchPoint.InfoFlags,QTouchEvent.TouchPoint.InfoFlag]) -> None: ...
        def setId(self, id: int) -> None: ...
        def setLastNormalizedPos(self, lastNormalizedPos: PySide2.QtCore.QPointF) -> None: ...
        def setLastPos(self, lastPos: PySide2.QtCore.QPointF) -> None: ...
        def setLastScenePos(self, lastScenePos: PySide2.QtCore.QPointF) -> None: ...
        def setLastScreenPos(self, lastScreenPos: PySide2.QtCore.QPointF) -> None: ...
        def setNormalizedPos(self, normalizedPos: PySide2.QtCore.QPointF) -> None: ...
        def setPos(self, pos: PySide2.QtCore.QPointF) -> None: ...
        def setPressure(self, pressure: float) -> None: ...
        def setRawScreenPositions(self, positions: typing.List[PySide2.QtCore.QPointF]) -> None: ...
        def setRect(self, rect: PySide2.QtCore.QRectF) -> None: ...
        def setRotation(self, angle: float) -> None: ...
        def setScenePos(self, scenePos: PySide2.QtCore.QPointF) -> None: ...
        def setSceneRect(self, sceneRect: PySide2.QtCore.QRectF) -> None: ...
        def setScreenPos(self, screenPos: PySide2.QtCore.QPointF) -> None: ...
        def setScreenRect(self, screenRect: PySide2.QtCore.QRectF) -> None: ...
        def setStartNormalizedPos(self, startNormalizedPos: PySide2.QtCore.QPointF) -> None: ...
        def setStartPos(self, startPos: PySide2.QtCore.QPointF) -> None: ...
        def setStartScenePos(self, startScenePos: PySide2.QtCore.QPointF) -> None: ...
        def setStartScreenPos(self, startScreenPos: PySide2.QtCore.QPointF) -> None: ...
        def setState(self, state: typing.Union[PySide2.QtCore.Qt.TouchPointStates,PySide2.QtCore.Qt.TouchPointState]) -> None: ...
        def setUniqueId(self, uid: int) -> None: ...
        def setVelocity(self, v: QVector2D) -> None: ...
        def startNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def startPos(self) -> PySide2.QtCore.QPointF: ...
        def startScenePos(self) -> PySide2.QtCore.QPointF: ...
        def startScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def state(self) -> PySide2.QtCore.Qt.TouchPointState: ...
        def swap(self, other: QTouchEvent.TouchPoint) -> None: ...
        def uniqueId(self) -> QPointingDeviceUniqueId: ...
        def velocity(self) -> QVector2D: ...
        def __copy__(self) -> None: ...
    _target: typing.Any
    def __init__(self, eventType: PySide2.QtCore.QEvent.Type, device: typing.Union[QTouchDevice,None] = ..., modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier] = ..., touchPointStates: typing.Union[PySide2.QtCore.Qt.TouchPointStates,PySide2.QtCore.Qt.TouchPointState] = ..., touchPoints: typing.Iterable[QTouchEvent.TouchPoint] = ...) -> None: ...
    def device(self) -> QTouchDevice: ...
    def setDevice(self, adevice: QTouchDevice) -> None: ...
    def setTarget(self, atarget: PySide2.QtCore.QObject) -> None: ...
    def setTouchPointStates(self, aTouchPointStates: typing.Union[PySide2.QtCore.Qt.TouchPointStates,PySide2.QtCore.Qt.TouchPointState]) -> None: ...
    def setTouchPoints(self, atouchPoints: typing.Iterable[QTouchEvent.TouchPoint]) -> None: ...
    def setWindow(self, awindow: QWindow) -> None: ...
    def target(self) -> PySide2.QtCore.QObject: ...
    def touchPointStates(self) -> typing.Union[PySide2.QtCore.Qt.TouchPointStates,PySide2.QtCore.Qt.TouchPointState]: ...
    def touchPoints(self) -> typing.List[QTouchEvent.TouchPoint]: ...
    def window(self) -> QWindow: ...

class QTransform(shiboken2.Object):
    class TransformationType:
        TxNone: typing.ClassVar[QTransform.TransformationType] = ...
        TxProject: typing.ClassVar[QTransform.TransformationType] = ...
        TxRotate: typing.ClassVar[QTransform.TransformationType] = ...
        TxScale: typing.ClassVar[QTransform.TransformationType] = ...
        TxShear: typing.ClassVar[QTransform.TransformationType] = ...
        TxTranslate: typing.ClassVar[QTransform.TransformationType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __and__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTransform.TransformationType: ...
    TxNone: typing.ClassVar[QTransform.TransformationType] = ...
    TxProject: typing.ClassVar[QTransform.TransformationType] = ...
    TxRotate: typing.ClassVar[QTransform.TransformationType] = ...
    TxScale: typing.ClassVar[QTransform.TransformationType] = ...
    TxShear: typing.ClassVar[QTransform.TransformationType] = ...
    TxTranslate: typing.ClassVar[QTransform.TransformationType] = ...
    @overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float, h31: float, h32: float, h33: float = ...) -> None: ...
    @overload
    def __init__(self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float) -> None: ...
    @overload
    def __init__(self, mtx: QMatrix) -> None: ...
    @overload
    def __init__(self, other: QTransform) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def adjoint(self) -> QTransform: ...
    def det(self) -> float: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @classmethod
    def fromScale(cls, dx: float, dy: float) -> QTransform: ...
    @classmethod
    def fromTranslate(cls, dx: float, dy: float) -> QTransform: ...
    def inverted(self) -> typing.Tuple[QTransform,bool]: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isTranslating(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m13(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    def m23(self) -> float: ...
    def m31(self) -> float: ...
    def m32(self) -> float: ...
    def m33(self) -> float: ...
    @overload
    def map(self, x: float, y: float) -> typing.Tuple[float,float]: ...
    @overload
    def map(self, a: QPolygon) -> QPolygon: ...
    @overload
    def map(self, a: QPolygonF) -> QPolygonF: ...
    @overload
    def map(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @overload
    def map(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @overload
    def map(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def map(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @overload
    def map(self, p: QPainterPath) -> QPainterPath: ...
    @overload
    def map(self, r: QRegion) -> QRegion: ...
    @overload
    def mapRect(self, arg__1: PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @overload
    def mapRect(self, arg__1: PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide2.QtCore.QRect) -> QPolygon: ...
    @overload
    @classmethod
    def quadToQuad(cls, one: QPolygonF, two: QPolygonF, result: QTransform) -> bool: ...
    @overload
    @classmethod
    def quadToQuad(cls, arg__1: QPolygonF, arg__2: QPolygonF) -> object: ...
    @overload
    @classmethod
    def quadToSquare(cls, quad: QPolygonF, result: QTransform) -> bool: ...
    @overload
    @classmethod
    def quadToSquare(cls, arg__1: QPolygonF) -> object: ...
    def reset(self) -> None: ...
    def rotate(self, a: float, axis: PySide2.QtCore.Qt.Axis = ...) -> QTransform: ...
    def rotateRadians(self, a: float, axis: PySide2.QtCore.Qt.Axis = ...) -> QTransform: ...
    def scale(self, sx: float, sy: float) -> QTransform: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float) -> None: ...
    def shear(self, sh: float, sv: float) -> QTransform: ...
    @overload
    @classmethod
    def squareToQuad(cls, square: QPolygonF, result: QTransform) -> bool: ...
    @overload
    @classmethod
    def squareToQuad(cls, arg__1: QPolygonF) -> object: ...
    def toAffine(self) -> QMatrix: ...
    def translate(self, dx: float, dy: float) -> QTransform: ...
    def transposed(self) -> QTransform: ...
    def type(self) -> QTransform.TransformationType: ...
    def __add__(self, n: float) -> QTransform: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, div: float) -> QTransform: ...
    @overload
    def __imul__(self, arg__1: QTransform) -> QTransform: ...
    @overload
    def __imul__(self, div: float) -> QTransform: ...
    def __isub__(self, div: float) -> QTransform: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, l: PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @overload
    def __mul__(self, l: PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @overload
    def __mul__(self, n: float) -> QTransform: ...
    @overload
    def __mul__(self, o: QTransform) -> QTransform: ...
    @overload
    def __mul__(self, p: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @overload
    def __mul__(self, p: PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, n: float) -> QTransform: ...
    def __truediv__(self, other) -> typing.Any: ...

class QValidator(PySide2.QtCore.QObject):
    class State:
        Acceptable: typing.ClassVar[QValidator.State] = ...
        Intermediate: typing.ClassVar[QValidator.State] = ...
        Invalid: typing.ClassVar[QValidator.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __and__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QValidator.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QValidator.State: ...
    Acceptable: typing.ClassVar[QValidator.State] = ...
    Intermediate: typing.ClassVar[QValidator.State] = ...
    Invalid: typing.ClassVar[QValidator.State] = ...
    changed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def fixup(self, arg__1: str) -> None: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    def validate(self, arg__1: str, arg__2: int) -> QValidator.State: ...

class QVector2D(shiboken2.Object):
    @overload
    def __init__(self, xpos: float, ypos: float) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self, vector: QVector3D) -> None: ...
    @overload
    def __init__(self, vector: QVector4D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def distanceToLine(self, point: QVector2D, direction: QVector2D) -> float: ...
    def distanceToPoint(self, point: QVector2D) -> float: ...
    @classmethod
    def dotProduct(cls, v1: QVector2D, v2: QVector2D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector2D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector3D(self) -> QVector3D: ...
    def toVector4D(self) -> QVector4D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def __add__(self, v2: QVector2D) -> QVector2D: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, vector: QVector2D) -> QVector2D: ...
    @overload
    def __imul__(self, factor: float) -> QVector2D: ...
    @overload
    def __imul__(self, vector: QVector2D) -> QVector2D: ...
    def __isub__(self, vector: QVector2D) -> QVector2D: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QVector2D: ...
    @overload
    def __mul__(self, v2: QVector2D) -> QVector2D: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QVector2D: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, v2: QVector2D) -> QVector2D: ...
    def __truediv__(self, other) -> typing.Any: ...

class QVector3D(shiboken2.Object):
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...
    @overload
    def __init__(self, vector: QVector2D, zpos: float) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self, vector: QVector2D) -> None: ...
    @overload
    def __init__(self, vector: QVector4D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def crossProduct(cls, v1: QVector3D, v2: QVector3D) -> QVector3D: ...
    def distanceToLine(self, point: QVector3D, direction: QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane1: QVector3D, plane2: QVector3D, plane3: QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane: QVector3D, normal: QVector3D) -> float: ...
    def distanceToPoint(self, point: QVector3D) -> float: ...
    @classmethod
    def dotProduct(cls, v1: QVector3D, v2: QVector3D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @overload
    @classmethod
    def normal(cls, v1: QVector3D, v2: QVector3D, v3: QVector3D) -> QVector3D: ...
    @overload
    @classmethod
    def normal(cls, v1: QVector3D, v2: QVector3D) -> QVector3D: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector3D: ...
    def project(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: PySide2.QtCore.QRect) -> QVector3D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> QVector2D: ...
    def toVector4D(self) -> QVector4D: ...
    def unproject(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: PySide2.QtCore.QRect) -> QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...
    def __add__(self, v2: QVector3D) -> QVector3D: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, vector: QVector3D) -> QVector3D: ...
    @overload
    def __imul__(self, factor: float) -> QVector3D: ...
    @overload
    def __imul__(self, vector: QVector3D) -> QVector3D: ...
    def __isub__(self, vector: QVector3D) -> QVector3D: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QVector3D: ...
    @overload
    def __mul__(self, matrix: QMatrix4x4) -> QVector3D: ...
    @overload
    def __mul__(self, quaternion: QQuaternion) -> QVector3D: ...
    @overload
    def __mul__(self, v2: QVector3D) -> QVector3D: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QVector3D: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, v2: QVector3D) -> QVector3D: ...
    def __truediv__(self, other) -> typing.Any: ...

class QVector4D(shiboken2.Object):
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...
    @overload
    def __init__(self, vector: QVector2D, zpos: float, wpos: float) -> None: ...
    @overload
    def __init__(self, vector: QVector3D, wpos: float) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def __init__(self, vector: QVector2D) -> None: ...
    @overload
    def __init__(self, vector: QVector3D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def dotProduct(cls, v1: QVector4D, v2: QVector4D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector4D: ...
    def setW(self, w: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> QVector2D: ...
    def toVector2DAffine(self) -> QVector2D: ...
    def toVector3D(self) -> QVector3D: ...
    def toVector3DAffine(self) -> QVector3D: ...
    def w(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...
    def __add__(self, v2: QVector4D) -> QVector4D: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, vector: QVector4D) -> QVector4D: ...
    @overload
    def __imul__(self, factor: float) -> QVector4D: ...
    @overload
    def __imul__(self, vector: QVector4D) -> QVector4D: ...
    def __isub__(self, vector: QVector4D) -> QVector4D: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QVector4D: ...
    @overload
    def __mul__(self, matrix: QMatrix4x4) -> QVector4D: ...
    @overload
    def __mul__(self, v2: QVector4D) -> QVector4D: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QVector4D: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, arg__1: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, v2: QVector4D) -> QVector4D: ...
    def __truediv__(self, other) -> typing.Any: ...

class QWhatsThisClickedEvent(PySide2.QtCore.QEvent):
    def __init__(self, href: str) -> None: ...
    def href(self) -> str: ...

class QWheelEvent(QInputEvent):
    _unused_: typing.Any
    angleD: typing.Any
    invertedScrolling: typing.Any
    ph: typing.Any
    pixelD: typing.Any
    qt4D: typing.Any
    qt4O: typing.Any
    reserved: typing.Any
    src: typing.Any
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource, inverted: bool) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], phase: PySide2.QtCore.Qt.ScrollPhase, source: PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], phase: PySide2.QtCore.Qt.ScrollPhase, inverted: bool, source: PySide2.QtCore.Qt.MouseEventSource = ...) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], phase: PySide2.QtCore.Qt.ScrollPhase) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, pixelDelta: PySide2.QtCore.QPoint, angleDelta: PySide2.QtCore.QPoint, qt4Delta: int, qt4Orientation: PySide2.QtCore.Qt.Orientation, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier]) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, globalPos: PySide2.QtCore.QPointF, delta: int, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], orient: PySide2.QtCore.Qt.Orientation = ...) -> None: ...
    @overload
    def __init__(self, pos: PySide2.QtCore.QPointF, delta: int, buttons: typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton], modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], orient: PySide2.QtCore.Qt.Orientation = ...) -> None: ...
    def angleDelta(self) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> typing.Union[PySide2.QtCore.Qt.MouseButtons,PySide2.QtCore.Qt.MouseButton]: ...
    def delta(self) -> int: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalPosition(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def inverted(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def phase(self) -> PySide2.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QWindow(PySide2.QtCore.QObject, QSurface):
    class AncestorMode:
        ExcludeTransients: typing.ClassVar[QWindow.AncestorMode] = ...
        IncludeTransients: typing.ClassVar[QWindow.AncestorMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __and__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QWindow.AncestorMode: ...

    class Visibility:
        AutomaticVisibility: typing.ClassVar[QWindow.Visibility] = ...
        FullScreen: typing.ClassVar[QWindow.Visibility] = ...
        Hidden: typing.ClassVar[QWindow.Visibility] = ...
        Maximized: typing.ClassVar[QWindow.Visibility] = ...
        Minimized: typing.ClassVar[QWindow.Visibility] = ...
        Windowed: typing.ClassVar[QWindow.Visibility] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __and__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __rand__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __ror__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __sub__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
        def __xor__(self, other: typing.SupportsInt) -> QWindow.Visibility: ...
    AutomaticVisibility: typing.ClassVar[QWindow.Visibility] = ...
    ExcludeTransients: typing.ClassVar[QWindow.AncestorMode] = ...
    FullScreen: typing.ClassVar[QWindow.Visibility] = ...
    Hidden: typing.ClassVar[QWindow.Visibility] = ...
    IncludeTransients: typing.ClassVar[QWindow.AncestorMode] = ...
    Maximized: typing.ClassVar[QWindow.Visibility] = ...
    Minimized: typing.ClassVar[QWindow.Visibility] = ...
    Windowed: typing.ClassVar[QWindow.Visibility] = ...
    activeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentOrientationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    focusObjectChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    heightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumHeightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    maximumWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    minimumHeightChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    minimumWidthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    modalityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    opacityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    screenChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    transientParentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibilityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    visibleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    widthChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    windowStateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    windowTitleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    xChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    yChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, parent: QWindow, active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: QWindow = ..., transientParentChanged: typing.Callable = ..., visibility: QWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, screen: typing.Union[QScreen,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., contentOrientation: PySide2.QtCore.Qt.ScreenOrientation = ..., contentOrientationChanged: typing.Callable = ..., destroyed: typing.Callable = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., focusObjectChanged: typing.Callable = ..., height: int = ..., heightChanged: typing.Callable = ..., maximumHeight: int = ..., maximumHeightChanged: typing.Callable = ..., maximumWidth: int = ..., maximumWidthChanged: typing.Callable = ..., minimumHeight: int = ..., minimumHeightChanged: typing.Callable = ..., minimumWidth: int = ..., minimumWidthChanged: typing.Callable = ..., modality: PySide2.QtCore.Qt.WindowModality = ..., modalityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., screenChanged: typing.Callable = ..., title: str = ..., transientParent: QWindow = ..., transientParentChanged: typing.Callable = ..., visibility: QWindow.Visibility = ..., visibilityChanged: typing.Callable = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: int = ..., widthChanged: typing.Callable = ..., windowStateChanged: typing.Callable = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., xChanged: typing.Callable = ..., y: int = ..., yChanged: typing.Callable = ...) -> None: ...
    def accessibleRoot(self) -> QAccessibleInterface: ...
    def alert(self, msec: int) -> None: ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def close(self) -> bool: ...
    def contentOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def create(self) -> None: ...
    def cursor(self) -> QCursor: ...
    def destroy(self) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: QExposeEvent) -> None: ...
    def filePath(self) -> str: ...
    def flags(self) -> typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType]: ...
    def focusInEvent(self, arg__1: QFocusEvent) -> None: ...
    def focusObject(self) -> PySide2.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: QFocusEvent) -> None: ...
    def format(self) -> QSurfaceFormat: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameMargins(self) -> PySide2.QtCore.QMargins: ...
    def framePosition(self) -> PySide2.QtCore.QPoint: ...
    @classmethod
    def fromWinId(cls, id: int) -> QWindow: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def height(self) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, arg__1: QHideEvent) -> None: ...
    def icon(self) -> QIcon: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: QWindow, mode: QWindow.AncestorMode = ...) -> bool: ...
    def isExposed(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: QKeyEvent) -> None: ...
    def lower(self) -> None: ...
    def mapFromGlobal(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, pos: PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def modality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def mouseDoubleClickEvent(self, arg__1: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: QMouseEvent) -> None: ...
    def moveEvent(self, arg__1: QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: typing.Union[PySide2.QtCore.QByteArray,bytes], message: int) -> typing.Tuple[bool,int]: ...
    def opacity(self) -> float: ...
    @overload
    def parent(self, mode: QWindow.AncestorMode) -> QWindow: ...
    @overload
    def parent(self) -> QWindow: ...
    def position(self) -> PySide2.QtCore.QPoint: ...
    def raise_(self) -> None: ...
    def reportContentOrientationChange(self, orientation: PySide2.QtCore.Qt.ScreenOrientation) -> None: ...
    def requestActivate(self) -> None: ...
    def requestUpdate(self) -> None: ...
    def requestedFormat(self) -> QSurfaceFormat: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    @overload
    def resize(self, newSize: PySide2.QtCore.QSize) -> None: ...
    def resizeEvent(self, arg__1: QResizeEvent) -> None: ...
    def screen(self) -> QScreen: ...
    def setBaseSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setCursor(self, arg__1: typing.Union[QCursor,PySide2.QtCore.Qt.CursorShape]) -> None: ...
    def setFilePath(self, filePath: str) -> None: ...
    def setFlag(self, arg__1: PySide2.QtCore.Qt.WindowType, on: bool = ...) -> None: ...
    def setFlags(self, flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType]) -> None: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...
    def setFramePosition(self, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int) -> None: ...
    @overload
    def setGeometry(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setHeight(self, arg: int) -> None: ...
    def setIcon(self, icon: QIcon) -> None: ...
    def setKeyboardGrabEnabled(self, grab: bool) -> bool: ...
    def setMask(self, region: QRegion) -> None: ...
    def setMaximumHeight(self, h: int) -> None: ...
    def setMaximumSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setMaximumWidth(self, w: int) -> None: ...
    def setMinimumHeight(self, h: int) -> None: ...
    def setMinimumSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setMinimumWidth(self, w: int) -> None: ...
    def setModality(self, modality: PySide2.QtCore.Qt.WindowModality) -> None: ...
    def setMouseGrabEnabled(self, grab: bool) -> bool: ...
    def setOpacity(self, level: float) -> None: ...
    @overload
    def setParent(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> None: ...
    @overload
    def setParent(self, parent: QWindow) -> None: ...
    @overload
    def setPosition(self, posx: int, posy: int) -> None: ...
    @overload
    def setPosition(self, pt: PySide2.QtCore.QPoint) -> None: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def setSizeIncrement(self, size: PySide2.QtCore.QSize) -> None: ...
    def setSurfaceType(self, surfaceType: QSurface.SurfaceType) -> None: ...
    def setTitle(self, arg__1: str) -> None: ...
    def setTransientParent(self, parent: QWindow) -> None: ...
    def setVisibility(self, v: QWindow.Visibility) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWidth(self, arg: int) -> None: ...
    def setWindowState(self, state: PySide2.QtCore.Qt.WindowState) -> None: ...
    def setWindowStates(self, states: typing.Union[PySide2.QtCore.Qt.WindowStates,PySide2.QtCore.Qt.WindowState]) -> None: ...
    def setX(self, arg: int) -> None: ...
    def setY(self, arg: int) -> None: ...
    def show(self) -> None: ...
    def showEvent(self, arg__1: QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def startSystemMove(self) -> bool: ...
    def startSystemResize(self, edges: typing.Union[PySide2.QtCore.Qt.Edges,PySide2.QtCore.Qt.Edge]) -> bool: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> QSurface.SurfaceType: ...
    def tabletEvent(self, arg__1: QTabletEvent) -> None: ...
    def title(self) -> str: ...
    def touchEvent(self, arg__1: QTouchEvent) -> None: ...
    def transientParent(self) -> QWindow: ...
    def type(self) -> PySide2.QtCore.Qt.WindowType: ...
    def unsetCursor(self) -> None: ...
    def visibility(self) -> QWindow.Visibility: ...
    def wheelEvent(self, arg__1: QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowState: ...
    def windowStates(self) -> typing.Union[PySide2.QtCore.Qt.WindowStates,PySide2.QtCore.Qt.WindowState]: ...
    def x(self) -> int: ...
    def y(self) -> int: ...

class QWindowStateChangeEvent(PySide2.QtCore.QEvent):
    def __init__(self, aOldState: typing.Union[PySide2.QtCore.Qt.WindowStates,PySide2.QtCore.Qt.WindowState], isOverride: bool = ...) -> None: ...
    def isOverride(self) -> bool: ...
    def oldState(self) -> typing.Union[PySide2.QtCore.Qt.WindowStates,PySide2.QtCore.Qt.WindowState]: ...

class Qt(PySide2.QtCore.Qt):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def codecForHtml(cls, ba: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> PySide2.QtCore.QTextCodec: ...
    @classmethod
    def convertFromPlainText(cls, plain: str, mode: PySide2.QtCore.Qt.WhiteSpaceMode = ...) -> str: ...
    @classmethod
    def mightBeRichText(cls, arg__1: str) -> bool: ...

def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
@overload
def qGray(r: int, g: int, b: int) -> int: ...
@overload
def qGray(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qIsGray(rgb: int) -> bool: ...
def qRed(rgb: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...
