import PySide2.Qt3DCore
import PySide2.QtCore
import PySide2.QtGui
import shiboken2
import typing
T = typing.TypeVar('T')

class Qt3DInput(shiboken2.Object):
    class QAbstractActionInput(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...

    class QAbstractAxisInput(PySide2.Qt3DCore.Qt3DCore.QNode):
        sourceDeviceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def setSourceDevice(self, sourceDevice: Qt3DInput.QAbstractPhysicalDevice) -> None: ...
        def sourceDevice(self) -> Qt3DInput.QAbstractPhysicalDevice: ...

    class QAbstractPhysicalDevice(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DInput.QAbstractPhysicalDevice.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addAxisSetting(self, axisSetting: Qt3DInput.QAxisSetting) -> None: ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def axisSettings(self) -> typing.List[Qt3DInput.QAxisSetting]: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...
        def removeAxisSetting(self, axisSetting: Qt3DInput.QAxisSetting) -> None: ...

    class QAction(PySide2.Qt3DCore.Qt3DCore.QNode):
        activeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QAction.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addInput(self, input: Qt3DInput.QAbstractActionInput) -> None: ...
        def inputs(self) -> typing.List[Qt3DInput.QAbstractActionInput]: ...
        def isActive(self) -> bool: ...
        def removeInput(self, input: Qt3DInput.QAbstractActionInput) -> None: ...

    class QActionInput(Qt3DInput.QAbstractActionInput):
        buttonsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceDeviceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., buttons: typing.List[int] = ..., buttonsChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QActionInput.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sourceDevice: Qt3DInput.QAbstractPhysicalDevice = ..., sourceDeviceChanged: typing.Callable = ...) -> None: ...
        def buttons(self) -> typing.List[int]: ...
        def setButtons(self, buttons: typing.List[int]) -> None: ...
        def setSourceDevice(self, sourceDevice: Qt3DInput.QAbstractPhysicalDevice) -> None: ...
        def sourceDevice(self) -> Qt3DInput.QAbstractPhysicalDevice: ...

    class QAnalogAxisInput(Qt3DInput.QAbstractAxisInput):
        axisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., axis: int = ..., axisChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QAnalogAxisInput.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sourceDevice: typing.Any = ..., sourceDeviceChanged: typing.Callable = ...) -> None: ...
        def axis(self) -> int: ...
        def setAxis(self, axis: int) -> None: ...

    class QAxis(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DInput.QAxis.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., value: float = ..., valueChanged: typing.Callable = ...) -> None: ...
        def addInput(self, input: Qt3DInput.QAbstractAxisInput) -> None: ...
        def inputs(self) -> typing.List[Qt3DInput.QAbstractAxisInput]: ...
        def removeInput(self, input: Qt3DInput.QAbstractAxisInput) -> None: ...
        def value(self) -> float: ...

    class QAxisAccumulator(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class SourceAxisType:
            Acceleration: typing.ClassVar[Qt3DInput.QAxisAccumulator.SourceAxisType] = ...
            Velocity: typing.ClassVar[Qt3DInput.QAxisAccumulator.SourceAxisType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
        Acceleration: typing.ClassVar[Qt3DInput.QAxisAccumulator.SourceAxisType] = ...
        Velocity: typing.ClassVar[Qt3DInput.QAxisAccumulator.SourceAxisType] = ...
        scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceAxisChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceAxisTypeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        velocityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QAxisAccumulator.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., sourceAxis: Qt3DInput.QAxis = ..., sourceAxisChanged: typing.Callable = ..., sourceAxisType: Qt3DInput.QAxisAccumulator.SourceAxisType = ..., sourceAxisTypeChanged: typing.Callable = ..., value: float = ..., valueChanged: typing.Callable = ..., velocity: float = ..., velocityChanged: typing.Callable = ...) -> None: ...
        def scale(self) -> float: ...
        def setScale(self, scale: float) -> None: ...
        def setSourceAxis(self, sourceAxis: Qt3DInput.QAxis) -> None: ...
        def setSourceAxisType(self, sourceAxisType: Qt3DInput.QAxisAccumulator.SourceAxisType) -> None: ...
        def sourceAxis(self) -> Qt3DInput.QAxis: ...
        def sourceAxisType(self) -> Qt3DInput.QAxisAccumulator.SourceAxisType: ...
        def value(self) -> float: ...
        def velocity(self) -> float: ...

    class QAxisSetting(PySide2.Qt3DCore.Qt3DCore.QNode):
        axesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        deadZoneRadiusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        smoothChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., axes: typing.List[int] = ..., axesChanged: typing.Callable = ..., deadZoneRadius: float = ..., deadZoneRadiusChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QAxisSetting.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., smooth: bool = ..., smoothChanged: typing.Callable = ...) -> None: ...
        def axes(self) -> typing.List[int]: ...
        def deadZoneRadius(self) -> float: ...
        def isSmoothEnabled(self) -> bool: ...
        def setAxes(self, axes: typing.List[int]) -> None: ...
        def setDeadZoneRadius(self, deadZoneRadius: float) -> None: ...
        def setSmoothEnabled(self, enabled: bool) -> None: ...

    class QButtonAxisInput(Qt3DInput.QAbstractAxisInput):
        accelerationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        buttonsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        decelerationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., acceleration: float = ..., accelerationChanged: typing.Callable = ..., buttons: typing.List[int] = ..., buttonsChanged: typing.Callable = ..., deceleration: float = ..., decelerationChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QButtonAxisInput.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., sourceDevice: typing.Any = ..., sourceDeviceChanged: typing.Callable = ...) -> None: ...
        def acceleration(self) -> float: ...
        def buttons(self) -> typing.List[int]: ...
        def deceleration(self) -> float: ...
        def scale(self) -> float: ...
        def setAcceleration(self, acceleration: float) -> None: ...
        def setButtons(self, buttons: typing.List[int]) -> None: ...
        def setDeceleration(self, deceleration: float) -> None: ...
        def setScale(self, scale: float) -> None: ...

    class QInputAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def availablePhysicalDevices(self) -> typing.List[str]: ...
        def createPhysicalDevice(self, name: str) -> Qt3DInput.QAbstractPhysicalDevice: ...

    class QInputChord(Qt3DInput.QAbstractActionInput):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timeoutChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DInput.QInputChord.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., timeout: int = ..., timeoutChanged: typing.Callable = ...) -> None: ...
        def addChord(self, input: Qt3DInput.QAbstractActionInput) -> None: ...
        def chords(self) -> typing.List[Qt3DInput.QAbstractActionInput]: ...
        def removeChord(self, input: Qt3DInput.QAbstractActionInput) -> None: ...
        def setTimeout(self, timeout: int) -> None: ...
        def timeout(self) -> int: ...

    class QInputSequence(Qt3DInput.QAbstractActionInput):
        buttonIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        timeoutChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., buttonInterval: int = ..., buttonIntervalChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QInputSequence.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., timeout: int = ..., timeoutChanged: typing.Callable = ...) -> None: ...
        def addSequence(self, input: Qt3DInput.QAbstractActionInput) -> None: ...
        def buttonInterval(self) -> int: ...
        def removeSequence(self, input: Qt3DInput.QAbstractActionInput) -> None: ...
        def sequences(self) -> typing.List[Qt3DInput.QAbstractActionInput]: ...
        def setButtonInterval(self, buttonInterval: int) -> None: ...
        def setTimeout(self, timeout: int) -> None: ...
        def timeout(self) -> int: ...

    class QInputSettings(PySide2.Qt3DCore.Qt3DCore.QComponent):
        eventSourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QInputSettings.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., eventSource: PySide2.QtCore.QObject = ..., eventSourceChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def eventSource(self) -> PySide2.QtCore.QObject: ...
        def setEventSource(self, eventSource: PySide2.QtCore.QObject) -> None: ...

    class QKeyEvent(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: typing.Union[PySide2.QtCore.Qt.KeyboardModifiers,PySide2.QtCore.Qt.KeyboardModifier], text: str = ..., autorep: bool = ..., count: int = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def count(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def isAutoRepeat(self) -> bool: ...
        def key(self) -> int: ...
        def matches(self, key_: PySide2.QtGui.QKeySequence.StandardKey) -> bool: ...
        def modifiers(self) -> int: ...
        def nativeScanCode(self) -> int: ...
        def setAccepted(self, accepted: bool) -> None: ...
        def text(self) -> str: ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...

    class QKeyboardDevice(Qt3DInput.QAbstractPhysicalDevice):
        activeInputChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., activeInput: Qt3DInput.QKeyboardHandler = ..., activeInputChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QKeyboardDevice.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def activeInput(self) -> Qt3DInput.QKeyboardHandler: ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...

    class QKeyboardHandler(PySide2.Qt3DCore.Qt3DCore.QComponent):
        asteriskPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        backPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        backtabPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        callPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        cancelPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        context1Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        context2Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        context3Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        context4Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        deletePressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit0Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit1Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit2Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit3Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit4Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit5Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit6Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit7Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit8Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        digit9Pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        downPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        enterPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        escapePressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        flipPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        focusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        hangupPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        leftPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        menuPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        noPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        numberSignPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        returnPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rightPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        selectPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceDeviceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        spacePressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        tabPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        upPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        volumeDownPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        volumeUpPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        yesPressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., asteriskPressed: typing.Callable = ..., backPressed: typing.Callable = ..., backtabPressed: typing.Callable = ..., callPressed: typing.Callable = ..., cancelPressed: typing.Callable = ..., context1Pressed: typing.Callable = ..., context2Pressed: typing.Callable = ..., context3Pressed: typing.Callable = ..., context4Pressed: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QKeyboardHandler.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., deletePressed: typing.Callable = ..., destroyed: typing.Callable = ..., digit0Pressed: typing.Callable = ..., digit1Pressed: typing.Callable = ..., digit2Pressed: typing.Callable = ..., digit3Pressed: typing.Callable = ..., digit4Pressed: typing.Callable = ..., digit5Pressed: typing.Callable = ..., digit6Pressed: typing.Callable = ..., digit7Pressed: typing.Callable = ..., digit8Pressed: typing.Callable = ..., digit9Pressed: typing.Callable = ..., downPressed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., enterPressed: typing.Callable = ..., escapePressed: typing.Callable = ..., flipPressed: typing.Callable = ..., focus: bool = ..., focusChanged: typing.Callable = ..., hangupPressed: typing.Callable = ..., isShareable: bool = ..., leftPressed: typing.Callable = ..., menuPressed: typing.Callable = ..., noPressed: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., numberSignPressed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., removedFromEntity: typing.Callable = ..., returnPressed: typing.Callable = ..., rightPressed: typing.Callable = ..., selectPressed: typing.Callable = ..., shareableChanged: typing.Callable = ..., sourceDevice: Qt3DInput.QKeyboardDevice = ..., sourceDeviceChanged: typing.Callable = ..., spacePressed: typing.Callable = ..., tabPressed: typing.Callable = ..., upPressed: typing.Callable = ..., volumeDownPressed: typing.Callable = ..., volumeUpPressed: typing.Callable = ..., yesPressed: typing.Callable = ...) -> None: ...
        def focus(self) -> bool: ...
        def setFocus(self, focus: bool) -> None: ...
        def setSourceDevice(self, keyboardDevice: Qt3DInput.QKeyboardDevice) -> None: ...
        def sourceDevice(self) -> Qt3DInput.QKeyboardDevice: ...

    class QLogicalDevice(PySide2.Qt3DCore.Qt3DCore.QComponent):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QLogicalDevice.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def actions(self) -> typing.List[Qt3DInput.QAction]: ...
        def addAction(self, action: Qt3DInput.QAction) -> None: ...
        def addAxis(self, axis: Qt3DInput.QAxis) -> None: ...
        def axes(self) -> typing.List[Qt3DInput.QAxis]: ...
        def removeAction(self, action: Qt3DInput.QAction) -> None: ...
        def removeAxis(self, axis: Qt3DInput.QAxis) -> None: ...

    class QMouseDevice(Qt3DInput.QAbstractPhysicalDevice):
        class Axis:
            WheelX: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
            WheelY: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
            X: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
            Y: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseDevice.Axis: ...
        WheelX: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
        WheelY: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
        X: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
        Y: typing.ClassVar[Qt3DInput.QMouseDevice.Axis] = ...
        sensitivityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        updateAxesContinuouslyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DInput.QMouseDevice.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sensitivity: float = ..., sensitivityChanged: typing.Callable = ..., updateAxesContinuously: bool = ..., updateAxesContinuouslyChanged: typing.Callable = ...) -> None: ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...
        def sensitivity(self) -> float: ...
        def setSensitivity(self, value: float) -> None: ...
        def setUpdateAxesContinuously(self, updateAxesContinuously: bool) -> None: ...
        def updateAxesContinuously(self) -> bool: ...

    class QMouseEvent(PySide2.QtCore.QObject):
        class Buttons:
            BackButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
            LeftButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
            MiddleButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
            NoButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
            RightButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Buttons: ...
    
        class Modifiers:
            AltModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            ControlModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            KeypadModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            MetaModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            NoModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            ShiftModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QMouseEvent.Modifiers: ...
        AltModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        BackButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
        ControlModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        KeypadModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        LeftButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
        MetaModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        MiddleButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
        NoButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
        NoModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        RightButton: typing.ClassVar[Qt3DInput.QMouseEvent.Buttons] = ...
        ShiftModifier: typing.ClassVar[Qt3DInput.QMouseEvent.Modifiers] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def button(self) -> Qt3DInput.QMouseEvent.Buttons: ...
        def buttons(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def modifiers(self) -> Qt3DInput.QMouseEvent.Modifiers: ...
        def setAccepted(self, accepted: bool) -> None: ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...
        def wasHeld(self) -> bool: ...
        def x(self) -> int: ...
        def y(self) -> int: ...

    class QMouseHandler(PySide2.Qt3DCore.Qt3DCore.QComponent):
        clicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        containsMouseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        doubleClicked: typing.ClassVar[PySide2.QtCore.Signal] = ...
        entered: typing.ClassVar[PySide2.QtCore.Signal] = ...
        exited: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressAndHold: typing.ClassVar[PySide2.QtCore.Signal] = ...
        pressed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        released: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceDeviceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        wheel: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., clicked: typing.Callable = ..., containsMouse: bool = ..., containsMouseChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DInput.QMouseHandler.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., doubleClicked: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., entered: typing.Callable = ..., exited: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., positionChanged: typing.Callable = ..., pressAndHold: typing.Callable = ..., pressed: typing.Callable = ..., released: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., sourceDevice: Qt3DInput.QMouseDevice = ..., sourceDeviceChanged: typing.Callable = ..., wheel: typing.Callable = ...) -> None: ...
        def containsMouse(self) -> bool: ...
        def setContainsMouse(self, contains: bool) -> None: ...
        def setSourceDevice(self, mouseDevice: Qt3DInput.QMouseDevice) -> None: ...
        def sourceDevice(self) -> Qt3DInput.QMouseDevice: ...

    class QWheelEvent(PySide2.QtCore.QObject):
        class Buttons:
            BackButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
            LeftButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
            MiddleButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
            NoButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
            RightButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Buttons: ...
    
        class Modifiers:
            AltModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            ControlModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            KeypadModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            MetaModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            NoModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            ShiftModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DInput.QWheelEvent.Modifiers: ...
        AltModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        BackButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
        ControlModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        KeypadModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        LeftButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
        MetaModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        MiddleButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
        NoButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
        NoModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        RightButton: typing.ClassVar[Qt3DInput.QWheelEvent.Buttons] = ...
        ShiftModifier: typing.ClassVar[Qt3DInput.QWheelEvent.Modifiers] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def angleDelta(self) -> PySide2.QtCore.QPoint: ...
        def buttons(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def modifiers(self) -> Qt3DInput.QWheelEvent.Modifiers: ...
        def setAccepted(self, accepted: bool) -> None: ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...
        def x(self) -> int: ...
        def y(self) -> int: ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
