from typing import Optional

from axipy import Plugin, ActionButton, Position, view_manager

from .style_catalog import StyleCatalogsDialog


class StyleCatalogs(Plugin):

    def __init__(self) -> None:
        self._button = ActionButton(
            title=self.tr("Каталоги\nсо стилями"),
            on_click=self.on_click,
            icon=str(self.plugin_dir / "images" / "style_catalog.png"),
        )
        self.w: Optional[StyleCatalogsDialog] = None
        position = Position(self.tr("Основные"), self.tr("Настройки"))
        position.add(self._button)

    def unload(self) -> None:
        if self.w is not None:
            self.w.save_settings()
            self.w.deleteLater()
            self.w = None

        self._button.remove()

    def on_click(self) -> None:
        if self.w is None:
            self.w = StyleCatalogsDialog(self, parent=view_manager.global_parent)
        self.w.open()
