from typing import overload
import PySide2.Qt3DCore
import PySide2.Qt3DRender
import PySide2.QtCore
import PySide2.QtGui
import shiboken2
import typing
T = typing.TypeVar('T')

class Qt3DAnimation(shiboken2.Object):
    class QAbstractAnimation(PySide2.QtCore.QObject):
        class AnimationType:
            KeyframeAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
            MorphingAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
            VertexBlendAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
        KeyframeAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
        MorphingAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
        VertexBlendAnimation: typing.ClassVar[Qt3DAnimation.QAbstractAnimation.AnimationType] = ...
        animationNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def animationName(self) -> str: ...
        def animationType(self) -> Qt3DAnimation.QAbstractAnimation.AnimationType: ...
        def duration(self) -> float: ...
        def position(self) -> float: ...
        def setAnimationName(self, name: str) -> None: ...
        def setDuration(self, duration: float) -> None: ...
        def setPosition(self, position: float) -> None: ...

    class QAbstractAnimationClip(PySide2.Qt3DCore.Qt3DCore.QNode):
        durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def duration(self) -> float: ...

    class QAbstractChannelMapping(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...

    class QAbstractClipAnimator(PySide2.Qt3DCore.Qt3DCore.QComponent):
        class Loops:
            Infinite: typing.ClassVar[Qt3DAnimation.QAbstractClipAnimator.Loops] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAbstractClipAnimator.Loops: ...
        Infinite: typing.ClassVar[Qt3DAnimation.QAbstractClipAnimator.Loops] = ...
        channelMapperChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        clockChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        loopCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        normalizedTimeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        runningChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., channelMapper: typing.Any = ..., channelMapperChanged: typing.Callable = ..., clock: Qt3DAnimation.QClock = ..., clockChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAbstractClipAnimator.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., loopCountChanged: typing.Callable = ..., loops: int = ..., nodeDestroyed: typing.Callable = ..., normalizedTime: float = ..., normalizedTimeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., running: bool = ..., runningChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def clock(self) -> Qt3DAnimation.QClock: ...
        def isRunning(self) -> bool: ...
        def loopCount(self) -> int: ...
        def normalizedTime(self) -> float: ...
        def setClock(self, clock: Qt3DAnimation.QClock) -> None: ...
        def setLoopCount(self, loops: int) -> None: ...
        def setNormalizedTime(self, timeFraction: float) -> None: ...
        def setRunning(self, running: bool) -> None: ...
        def start(self) -> None: ...
        def stop(self) -> None: ...

    class QAbstractClipBlendNode(PySide2.Qt3DCore.Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAbstractClipBlendNode.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QAdditiveClipBlend(Qt3DAnimation.QAbstractClipBlendNode):
        additiveClipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        additiveFactorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        baseClipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., additiveClip: Qt3DAnimation.QAbstractClipBlendNode = ..., additiveClipChanged: typing.Callable = ..., additiveFactor: float = ..., additiveFactorChanged: typing.Callable = ..., baseClip: Qt3DAnimation.QAbstractClipBlendNode = ..., baseClipChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAdditiveClipBlend.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def additiveClip(self) -> Qt3DAnimation.QAbstractClipBlendNode: ...
        def additiveFactor(self) -> float: ...
        def baseClip(self) -> Qt3DAnimation.QAbstractClipBlendNode: ...
        def setAdditiveClip(self, additiveClip: Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def setAdditiveFactor(self, additiveFactor: float) -> None: ...
        def setBaseClip(self, baseClip: Qt3DAnimation.QAbstractClipBlendNode) -> None: ...

    class QAnimationAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...

    class QAnimationCallback(shiboken2.Object):
        class Flag:
            OnOwningThread: typing.ClassVar[Qt3DAnimation.QAnimationCallback.Flag] = ...
            OnThreadPool: typing.ClassVar[Qt3DAnimation.QAnimationCallback.Flag] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationCallback.Flag: ...
        OnOwningThread: typing.ClassVar[Qt3DAnimation.QAnimationCallback.Flag] = ...
        OnThreadPool: typing.ClassVar[Qt3DAnimation.QAnimationCallback.Flag] = ...
        def __init__(self) -> None: ...
        def valueChanged(self, value: typing.Any) -> None: ...

    class QAnimationClip(Qt3DAnimation.QAbstractAnimationClip):
        clipDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., clipData: typing.Any = ..., clipDataChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAnimationClip.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...

    class QAnimationClipLoader(Qt3DAnimation.QAbstractAnimationClip):
        class Status:
            Error: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
            NotReady: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
            Ready: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QAnimationClipLoader.Status: ...
        Error: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
        NotReady: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
        Ready: typing.ClassVar[Qt3DAnimation.QAnimationClipLoader.Status] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @overload
        def __init__(self, source: PySide2.QtCore.QUrl, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAnimationClipLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., sourceChanged: typing.Callable = ..., status: Qt3DAnimation.QAnimationClipLoader.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DAnimation.QAnimationClipLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DAnimation.QAnimationClipLoader.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        def setSource(self, source: PySide2.QtCore.QUrl) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> Qt3DAnimation.QAnimationClipLoader.Status: ...

    class QAnimationController(PySide2.QtCore.QObject):
        activeAnimationGroupChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        entityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionOffsetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionScaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        recursiveChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., activeAnimationGroup: int = ..., activeAnimationGroupChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entity: PySide2.Qt3DCore.Qt3DCore.QEntity = ..., entityChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: float = ..., positionChanged: typing.Callable = ..., positionOffset: float = ..., positionOffsetChanged: typing.Callable = ..., positionScale: float = ..., positionScaleChanged: typing.Callable = ..., recursive: bool = ..., recursiveChanged: typing.Callable = ...) -> None: ...
        def activeAnimationGroup(self) -> int: ...
        def addAnimationGroup(self, animationGroups: Qt3DAnimation.QAnimationGroup) -> None: ...
        def animationGroupList(self) -> typing.List[Qt3DAnimation.QAnimationGroup]: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def getAnimationIndex(self, name: str) -> int: ...
        def getGroup(self, index: int) -> Qt3DAnimation.QAnimationGroup: ...
        def position(self) -> float: ...
        def positionOffset(self) -> float: ...
        def positionScale(self) -> float: ...
        def recursive(self) -> bool: ...
        def removeAnimationGroup(self, animationGroups: Qt3DAnimation.QAnimationGroup) -> None: ...
        def setActiveAnimationGroup(self, index: int) -> None: ...
        def setAnimationGroups(self, animationGroups: typing.List[Qt3DAnimation.QAnimationGroup]) -> None: ...
        def setEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity) -> None: ...
        def setPosition(self, position: float) -> None: ...
        def setPositionOffset(self, offset: float) -> None: ...
        def setPositionScale(self, scale: float) -> None: ...
        def setRecursive(self, recursive: bool) -> None: ...

    class QAnimationGroup(PySide2.QtCore.QObject):
        durationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        positionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: float = ..., positionChanged: typing.Callable = ...) -> None: ...
        def addAnimation(self, animation: Qt3DAnimation.QAbstractAnimation) -> None: ...
        def animationList(self) -> typing.List[Qt3DAnimation.QAbstractAnimation]: ...
        def duration(self) -> float: ...
        def name(self) -> str: ...
        def position(self) -> float: ...
        def removeAnimation(self, animation: Qt3DAnimation.QAbstractAnimation) -> None: ...
        def setAnimations(self, animations: typing.List[Qt3DAnimation.QAbstractAnimation]) -> None: ...
        def setName(self, name: str) -> None: ...
        def setPosition(self, position: float) -> None: ...

    class QBlendedClipAnimator(Qt3DAnimation.QAbstractClipAnimator):
        blendTreeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., blendTree: Qt3DAnimation.QAbstractClipBlendNode = ..., blendTreeChanged: typing.Callable = ..., channelMapper: typing.Any = ..., channelMapperChanged: typing.Callable = ..., clock: typing.Any = ..., clockChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QBlendedClipAnimator.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., loopCountChanged: typing.Callable = ..., loops: int = ..., nodeDestroyed: typing.Callable = ..., normalizedTime: float = ..., normalizedTimeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., running: bool = ..., runningChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def blendTree(self) -> Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendTree(self, blendTree: Qt3DAnimation.QAbstractClipBlendNode) -> None: ...

    class QClipAnimator(Qt3DAnimation.QAbstractClipAnimator):
        clipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., channelMapper: typing.Any = ..., channelMapperChanged: typing.Callable = ..., clip: Qt3DAnimation.QAbstractAnimationClip = ..., clipChanged: typing.Callable = ..., clock: typing.Any = ..., clockChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QClipAnimator.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., loopCountChanged: typing.Callable = ..., loops: int = ..., nodeDestroyed: typing.Callable = ..., normalizedTime: float = ..., normalizedTimeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., running: bool = ..., runningChanged: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def clip(self) -> Qt3DAnimation.QAbstractAnimationClip: ...
        def setClip(self, clip: Qt3DAnimation.QAbstractAnimationClip) -> None: ...

    class QClock(PySide2.Qt3DCore.Qt3DCore.QNode):
        playbackRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DAnimation.QClock.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., playbackRate: float = ..., playbackRateChanged: typing.Callable = ...) -> None: ...
        def playbackRate(self) -> float: ...
        def setPlaybackRate(self, playbackRate: float) -> None: ...

    class QKeyFrame(shiboken2.Object):
        class InterpolationType:
            BezierInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
            ConstantInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
            LinearInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
        BezierInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
        ConstantInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
        LinearInterpolation: typing.ClassVar[Qt3DAnimation.QKeyFrame.InterpolationType] = ...
        @overload
        def __init__(self, coords: PySide2.QtGui.QVector2D, lh: PySide2.QtGui.QVector2D, rh: PySide2.QtGui.QVector2D) -> None: ...
        @overload
        def __init__(self, coords: PySide2.QtGui.QVector2D) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def coordinates(self) -> PySide2.QtGui.QVector2D: ...
        def interpolationType(self) -> Qt3DAnimation.QKeyFrame.InterpolationType: ...
        def leftControlPoint(self) -> PySide2.QtGui.QVector2D: ...
        def rightControlPoint(self) -> PySide2.QtGui.QVector2D: ...
        def setCoordinates(self, coords: PySide2.QtGui.QVector2D) -> None: ...
        def setInterpolationType(self, interp: Qt3DAnimation.QKeyFrame.InterpolationType) -> None: ...
        def setLeftControlPoint(self, lh: PySide2.QtGui.QVector2D) -> None: ...
        def setRightControlPoint(self, rh: PySide2.QtGui.QVector2D) -> None: ...

    class QKeyframeAnimation(Qt3DAnimation.QAbstractAnimation):
        class RepeatMode:
            Constant: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
            None_: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
            Repeat: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        Constant: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
        None_: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
        Repeat: typing.ClassVar[Qt3DAnimation.QKeyframeAnimation.RepeatMode] = ...
        easingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        endModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        framePositionsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        startModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        targetNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., animationName: str = ..., animationNameChanged: typing.Callable = ..., animationType: Qt3DAnimation.QKeyframeAnimation.AnimationType = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., easing: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type] = ..., easingChanged: typing.Callable = ..., endMode: Qt3DAnimation.QKeyframeAnimation.RepeatMode = ..., endModeChanged: typing.Callable = ..., framePositions: typing.List[float] = ..., framePositionsChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: float = ..., positionChanged: typing.Callable = ..., startMode: Qt3DAnimation.QKeyframeAnimation.RepeatMode = ..., startModeChanged: typing.Callable = ..., target: PySide2.Qt3DCore.Qt3DCore.QTransform = ..., targetChanged: typing.Callable = ..., targetName: str = ..., targetNameChanged: typing.Callable = ...) -> None: ...
        def addKeyframe(self, keyframe: PySide2.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def easing(self) -> PySide2.QtCore.QEasingCurve: ...
        def endMode(self) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def framePositions(self) -> typing.List[float]: ...
        def keyframeList(self) -> typing.List[PySide2.Qt3DCore.Qt3DCore.QTransform]: ...
        def removeKeyframe(self, keyframe: PySide2.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def setEasing(self, easing: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type]) -> None: ...
        def setEndMode(self, mode: Qt3DAnimation.QKeyframeAnimation.RepeatMode) -> None: ...
        def setFramePositions(self, positions: typing.List[float]) -> None: ...
        def setKeyframes(self, keyframes: typing.List[PySide2.Qt3DCore.Qt3DCore.QTransform]) -> None: ...
        def setStartMode(self, mode: Qt3DAnimation.QKeyframeAnimation.RepeatMode) -> None: ...
        def setTarget(self, target: PySide2.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def startMode(self) -> Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def target(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def targetName(self) -> str: ...

    class QLerpClipBlend(Qt3DAnimation.QAbstractClipBlendNode):
        blendFactorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        endClipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        startClipChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., blendFactor: float = ..., blendFactorChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DAnimation.QLerpClipBlend.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., endClip: Qt3DAnimation.QAbstractClipBlendNode = ..., endClipChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., startClip: Qt3DAnimation.QAbstractClipBlendNode = ..., startClipChanged: typing.Callable = ...) -> None: ...
        def blendFactor(self) -> float: ...
        def endClip(self) -> Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendFactor(self, blendFactor: float) -> None: ...
        def setEndClip(self, endClip: Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def setStartClip(self, startClip: Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def startClip(self) -> Qt3DAnimation.QAbstractClipBlendNode: ...

    class QMorphTarget(PySide2.QtCore.QObject):
        attributeNamesChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., attributeNames: None = ..., attributeNamesChanged: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def addAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute) -> None: ...
        def attributeList(self) -> typing.List[PySide2.Qt3DRender.Qt3DRender.QAttribute]: ...
        def attributeNames(self) -> typing.List[str]: ...
        @classmethod
        def fromGeometry(cls, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry, attributes: typing.Iterable[str]) -> Qt3DAnimation.QMorphTarget: ...
        def removeAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute) -> None: ...
        def setAttributes(self, attributes: typing.List[PySide2.Qt3DRender.Qt3DRender.QAttribute]) -> None: ...

    class QMorphingAnimation(Qt3DAnimation.QAbstractAnimation):
        class Method:
            Normalized: typing.ClassVar[Qt3DAnimation.QMorphingAnimation.Method] = ...
            Relative: typing.ClassVar[Qt3DAnimation.QMorphingAnimation.Method] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DAnimation.QMorphingAnimation.Method: ...
        Normalized: typing.ClassVar[Qt3DAnimation.QMorphingAnimation.Method] = ...
        Relative: typing.ClassVar[Qt3DAnimation.QMorphingAnimation.Method] = ...
        easingChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        interpolatorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        methodChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        targetNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        targetPositionsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., animationName: str = ..., animationNameChanged: typing.Callable = ..., animationType: Qt3DAnimation.QMorphingAnimation.AnimationType = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., easing: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type] = ..., easingChanged: typing.Callable = ..., interpolator: float = ..., interpolatorChanged: typing.Callable = ..., method: Qt3DAnimation.QMorphingAnimation.Method = ..., methodChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: float = ..., positionChanged: typing.Callable = ..., target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer = ..., targetChanged: typing.Callable = ..., targetName: str = ..., targetNameChanged: typing.Callable = ..., targetPositions: typing.List[float] = ..., targetPositionsChanged: typing.Callable = ...) -> None: ...
        def addMorphTarget(self, target: Qt3DAnimation.QMorphTarget) -> None: ...
        def easing(self) -> PySide2.QtCore.QEasingCurve: ...
        def getWeights(self, positionIndex: int) -> typing.List[float]: ...
        def interpolator(self) -> float: ...
        def method(self) -> Qt3DAnimation.QMorphingAnimation.Method: ...
        def morphTargetList(self) -> typing.List[Qt3DAnimation.QMorphTarget]: ...
        def removeMorphTarget(self, target: Qt3DAnimation.QMorphTarget) -> None: ...
        def setEasing(self, easing: typing.Union[PySide2.QtCore.QEasingCurve,PySide2.QtCore.QEasingCurve.Type]) -> None: ...
        def setMethod(self, method: Qt3DAnimation.QMorphingAnimation.Method) -> None: ...
        def setMorphTargets(self, targets: typing.List[Qt3DAnimation.QMorphTarget]) -> None: ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def setTargetPositions(self, targetPositions: typing.List[float]) -> None: ...
        def setWeights(self, positionIndex: int, weights: typing.List[float]) -> None: ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> typing.List[float]: ...

    class QSkeletonMapping(Qt3DAnimation.QAbstractChannelMapping):
        skeletonChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.Qt3DCore.Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DAnimation.QSkeletonMapping.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., skeleton: PySide2.Qt3DCore.Qt3DCore.QAbstractSkeleton = ..., skeletonChanged: typing.Callable = ...) -> None: ...
        def setSkeleton(self, skeleton: PySide2.Qt3DCore.Qt3DCore.QAbstractSkeleton) -> None: ...
        def skeleton(self) -> PySide2.Qt3DCore.Qt3DCore.QAbstractSkeleton: ...

    class QVertexBlendAnimation(Qt3DAnimation.QAbstractAnimation):
        interpolatorChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        targetNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        targetPositionsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., animationName: str = ..., animationNameChanged: typing.Callable = ..., animationType: Qt3DAnimation.QVertexBlendAnimation.AnimationType = ..., destroyed: typing.Callable = ..., duration: float = ..., durationChanged: typing.Callable = ..., interpolator: float = ..., interpolatorChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., position: float = ..., positionChanged: typing.Callable = ..., target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer = ..., targetChanged: typing.Callable = ..., targetName: str = ..., targetNameChanged: typing.Callable = ..., targetPositions: typing.List[float] = ..., targetPositionsChanged: typing.Callable = ...) -> None: ...
        def addMorphTarget(self, target: Qt3DAnimation.QMorphTarget) -> None: ...
        def interpolator(self) -> float: ...
        def morphTargetList(self) -> typing.List[Qt3DAnimation.QMorphTarget]: ...
        def removeMorphTarget(self, target: Qt3DAnimation.QMorphTarget) -> None: ...
        def setMorphTargets(self, targets: typing.List[Qt3DAnimation.QMorphTarget]) -> None: ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def setTargetPositions(self, targetPositions: typing.List[float]) -> None: ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> typing.List[float]: ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
