"""
Модуль источников данных.
В данном модуле содержатся классы и методы для работы с источниками данных.
"""

# depends on axipy.cs, axipy.utl

from .sqldialect import *  # no dependencies
from .state_manager_ import *  # no dependencies
from .observer_manager import *  # depends on state_manager_
from .schema import *  # depends on axipy.cs
from .attribute_factory import *  # depends on schema
from .raster import *  # depends on axipy.cs
from .geometry import *  # depends on axipy.cs, axipy.utl
from .style import *  # depends on geometry
from .feature import *  # depends on geometry, style
from .data_object import *  # depends on axipy.cs, axipy.utl, feature, geometry, raster, schema
from .tab_file import *  # depends on data_object
from .data_manager_ import *  # depends on data_object, sqldialect
from .providers import *

attribute_schema = schema
DataManagerWrapper = data_manager_
DataObjectWrapper = data_object
FeatureWrapper = feature


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "attribute_schema": schema,
        "DataManagerWrapper": data_manager_,
        "DataObjectWrapper": data_object,
        "FeatureWrapper": feature,
        "Geometry": geometry,
        "Style": style,
        "TabFile": tab_file,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")


"""
Attributes:
    provider_manager (axipy.ProviderManager): Готовый экземпляр открытия/создания объектов данных.
    data_manager (axipy.DataManager):
        Хранилище объектов приложения.

        Это то же хранилище, которое отображается в панели "Открытые данные".

        Note:
            При открытии объектов данных :meth:`axipy.ProviderManager.openfile`
            они автоматически попадают в каталог.
"""
