from axipy.da.data_object import Table
from .data_provider import DataProvider
from .source import Source
from typing import List


__all__ = [
    "PanoramaSource",
    "PanoramaDataProvider",
]


class PanoramaSource(Source):
    pass


class PanoramaDataProvider(DataProvider):
    """Провайдер для источников ГИС Панорама.
    
    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.provider_manager.panorama`.
    """
    _identifier = 'PanoramaDataProvider'

    def get_source(self, data: str, alias: str = None) -> Source:
        """Создает источник данных.

        Args:
          data: Имя файла или описание источника данных.
        """
        return PanoramaSource(
            Source._provider(self.id),
            Source._alias(alias),
            {
                'src': data,
            }
        )

    def open(self, data: str, alias: str = None) -> Table:
        """Открывает объект данных.

        Args:
          data: Имя файла или описание источника данных.
          alias: Псевдоним для открываемого объекта.
        """
        return self.get_source(data, alias).open()

    def get_destination(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

